/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableexists;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableexists.Messages;
import org.pentaho.di.trans.steps.tableexists.TableExistsData;
import org.pentaho.di.trans.steps.tableexists.TableExistsMeta;

public class TableExists
extends BaseStep
implements StepInterface {
    private TableExistsMeta meta;
    private TableExistsData data;

    public TableExists(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block9: {
            this.meta = (TableExistsMeta)smi;
            this.data = (TableExistsData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean tablexists = false;
            try {
                if (this.first) {
                    this.first = false;
                    this.data.outputRowMeta = this.getInputRowMeta().clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    if (Const.isEmpty((String)this.meta.getDynamicTablenameField())) {
                        this.logError(Messages.getString("TableExists.Error.TablenameFieldMissing"));
                        throw new KettleException(Messages.getString("TableExists.Error.TablenameFieldMissing"));
                    }
                    if (this.data.indexOfTablename < 0) {
                        this.data.indexOfTablename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicTablenameField());
                        if (this.data.indexOfTablename < 0) {
                            this.logError(Messages.getString("TableExists.Exception.CouldnotFindField") + "[" + this.meta.getDynamicTablenameField() + "]");
                            throw new KettleException(Messages.getString("TableExists.Exception.CouldnotFindField", this.meta.getDynamicTablenameField()));
                        }
                    }
                }
                String tablename = this.getInputRowMeta().getString(r, this.data.indexOfTablename);
                tablename = this.data.realSchemaname != null ? this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.realSchemaname, tablename) : this.data.db.getDatabaseMeta().quoteField(tablename);
                tablexists = this.data.db.checkTableExists(tablename);
                Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)tablexists);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), Messages.getString("TableExists.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("TableExists.ErrorInStepRunning : " + e.getMessage()));
                    throw new KettleStepException(Messages.getString("TableExists.Log.ErrorInStep"), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block9;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "TableExistsO01");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block11: {
            this.meta = (TableExistsMeta)smi;
            this.data = (TableExistsData)sdi;
            if (super.init(smi, sdi)) {
                if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                    this.log.logError(this.toString(), Messages.getString("TableExists.Error.ResultFieldMissing"), new Object[0]);
                    return false;
                }
                this.data.db = new Database(this.meta.getDatabase());
                this.data.db.shareVariablesWith((VariableSpace)this);
                if (!Const.isEmpty((String)this.meta.getSchemaname())) {
                    this.data.realSchemaname = this.environmentSubstitute(this.meta.getSchemaname());
                }
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("TableExists.Log.ConnectedToDB"));
                    }
                    return true;
                }
                catch (KettleException e) {
                    this.logError(Messages.getString("TableExists.Log.DBException") + e.getMessage());
                    if (this.data.db == null) break block11;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableExistsMeta)smi;
        this.data = (TableExistsData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

