# -*- coding: utf-8 -*-

"""Data literal storing emoji German names and Unicode codes."""

__all__ = ['EMOJI_UNICODE_GERMAN', 'UNICODE_EMOJI_GERMAN',]

EMOJI_UNICODE_GERMAN = {
	u':grinsendes_gesicht:': u'\U0001F600',
	u':grinsendes_gesicht_mit_großen_augen:': u'\U0001F603',
	u':grinsendes_gesicht_mit_lachenden_augen:': u'\U0001F604',
	u':strahlendes_gesicht_mit_lachenden_augen:': u'\U0001F601',
	u':grinsendes_gesicht_mit_zusammengekniffenen_augen:': u'\U0001F606',
	u':grinsendes_gesicht_mit_schweißtropfen:': u'\U0001F605',
	u':sich_vor_lachen_auf_dem_boden_wälzen:': u'\U0001F923',
	u':gesicht_mit_freudentränen:': u'\U0001F602',
	u':leicht_lächelndes_gesicht:': u'\U0001F642',
	u':umgekehrtes_gesicht:': u'\U0001F643',
	u':zwinkerndes_gesicht:': u'\U0001F609',
	u':lächelndes_gesicht_mit_lachenden_augen:': u'\U0001F60A',
	u':lächelndes_gesicht_mit_heiligenschein:': u'\U0001F607',
	u':lächelndes_gesicht_mit_herzen:': u'\U0001F970',
	u':lächelndes_gesicht_mit_herzförmigen_augen:': u'\U0001F60D',
	u':überwältigt:': u'\U0001F929',
	u':kuss_zuwerfendes_gesicht:': u'\U0001F618',
	u':küssendes_gesicht:': u'\U0001F617',
	u':lächelndes_gesicht:': u'\U0000263A\U0000FE0F',
	u':küssendes_gesicht_mit_geschlossenen_augen:': u'\U0001F61A',
	u':küssendes_gesicht_mit_lächelnden_augen:': u'\U0001F619',
	u':lachendes_gesicht_mit_träne:': u'\U0001F972',
	u':sich_die_lippen_leckendes_gesicht:': u'\U0001F60B',
	u':gesicht_mit_herausgestreckter_zunge:': u'\U0001F61B',
	u':zwinkerndes_gesicht_mit_herausgestreckter_zunge:': u'\U0001F61C',
	u':irres_gesicht:': u'\U0001F92A',
	u':gesicht_mit_herausgestreckter_zunge_und_zusammengekniffenen_augen:': u'\U0001F61D',
	u':gesicht_mit_dollarzeichen:': u'\U0001F911',
	u':gesicht_mit_umarmenden_händen:': u'\U0001F917',
	u':verlegen_kicherndes_gesicht:': u'\U0001F92D',
	u':ermahnendes_gesicht:': u'\U0001F92B',
	u':nachdenkendes_gesicht:': u'\U0001F914',
	u':gesicht_mit_reißverschlussmund:': u'\U0001F910',
	u':gesicht_mit_hochgezogenen_augenbrauen:': u'\U0001F928',
	u':neutrales_gesicht:': u'\U0001F610',
	u':ausdrucksloses_gesicht:': u'\U0001F611',
	u':gesicht_ohne_mund:': u'\U0001F636',
	u':selbstgefällig_grinsendes_gesicht:': u'\U0001F60F',
	u':verstimmtes_gesicht:': u'\U0001F612',
	u':augen_verdrehendes_gesicht:': u'\U0001F644',
	u':grimassen_schneidendes_gesicht:': u'\U0001F62C',
	u':lügendes_gesicht:': u'\U0001F925',
	u':erleichtertes_gesicht:': u'\U0001F60C',
	u':nachdenkliches_gesicht:': u'\U0001F614',
	u':schläfriges_gesicht:': u'\U0001F62A',
	u':sabberndes_gesicht:': u'\U0001F924',
	u':schlafendes_gesicht:': u'\U0001F634',
	u':gesicht_mit_atemschutzmaske:': u'\U0001F637',
	u':gesicht_mit_fieberthermometer:': u'\U0001F912',
	u':gesicht_mit_kopfverband:': u'\U0001F915',
	u':würgendes_gesicht:': u'\U0001F922',
	u':kotzendes_gesicht:': u'\U0001F92E',
	u':niesendes_gesicht:': u'\U0001F927',
	u':schwitzendes_gesicht:': u'\U0001F975',
	u':frierendes_gesicht:': u'\U0001F976',
	u':schwindeliges_gesicht:': u'\U0001F974',
	u':benommenes_gesicht:': u'\U0001F635',
	u':explodierender_kopf:': u'\U0001F92F',
	u':gesicht_mit_cowboyhut:': u'\U0001F920',
	u':partygesicht:': u'\U0001F973',
	u':verkleidet:': u'\U0001F978',
	u':lächelndes_gesicht_mit_sonnenbrille:': u'\U0001F60E',
	u':strebergesicht:': u'\U0001F913',
	u':gesicht_mit_monokel:': u'\U0001F9D0',
	u':verwundertes_gesicht:': u'\U0001F615',
	u':besorgtes_gesicht:': u'\U0001F61F',
	u':betrübtes_gesicht:': u'\U0001F641',
	u':düsteres_gesicht:': u'\U00002639\U0000FE0F',
	u':gesicht_mit_offenem_mund:': u'\U0001F62E',
	u':verdutztes_gesicht:': u'\U0001F62F',
	u':erstauntes_gesicht:': u'\U0001F632',
	u':errötetes_gesicht_mit_großen_augen:': u'\U0001F633',
	u':bettelndes_gesicht:': u'\U0001F97A',
	u':entsetztes_gesicht:': u'\U0001F626',
	u':qualvolles_gesicht:': u'\U0001F627',
	u':ängstliches_gesicht:': u'\U0001F628',
	u':besorgtes_gesicht_mit_schweißtropfen:': u'\U0001F630',
	u':trauriges_aber_erleichtertes_gesicht:': u'\U0001F625',
	u':weinendes_gesicht:': u'\U0001F622',
	u':heulendes_gesicht:': u'\U0001F62D',
	u':vor_angst_schreiendes_gesicht:': u'\U0001F631',
	u':verwirrtes_gesicht:': u'\U0001F616',
	u':entschlossenes_gesicht:': u'\U0001F623',
	u':enttäuschtes_gesicht:': u'\U0001F61E',
	u':bedrücktes_gesicht_mit_schweiß:': u'\U0001F613',
	u':erschöpftes_gesicht:': u'\U0001F629',
	u':müdes_gesicht:': u'\U0001F62B',
	u':gähnendes_gesicht:': u'\U0001F971',
	u':schnaubendes_gesicht:': u'\U0001F624',
	u':schmollendes_gesicht:': u'\U0001F621',
	u':verärgertes_gesicht:': u'\U0001F620',
	u':gesicht_mit_symbolen_über_dem_mund:': u'\U0001F92C',
	u':grinsendes_gesicht_mit_hörnern:': u'\U0001F608',
	u':wütendes_gesicht_mit_hörnern:': u'\U0001F47F',
	u':totenkopf:': u'\U0001F480',
	u':totenkopf_mit_gekreuzten_knochen:': u'\U00002620\U0000FE0F',
	u':kothaufen:': u'\U0001F4A9',
	u':clown-gesicht:': u'\U0001F921',
	u':ungeheuer:': u'\U0001F479',
	u':kobold:': u'\U0001F47A',
	u':gespenst:': u'\U0001F47B',
	u':außerirdischer:': u'\U0001F47D',
	u':computerspiel-monster:': u'\U0001F47E',
	u':roboter:': u'\U0001F916',
	u':grinsende_katze:': u'\U0001F63A',
	u':grinsende_katze_mit_lachenden_augen:': u'\U0001F638',
	u':katze_mit_freudentränen:': u'\U0001F639',
	u':lachende_katze_mit_herzen_als_augen:': u'\U0001F63B',
	u':verwegen_lächelnde_katze:': u'\U0001F63C',
	u':küssende_katze:': u'\U0001F63D',
	u':erschöpfte_katze:': u'\U0001F640',
	u':weinende_katze:': u'\U0001F63F',
	u':schmollende_katze:': u'\U0001F63E',
	u':sich_die_augen_zuhaltendes_affengesicht:': u'\U0001F648',
	u':sich_die_ohren_zuhaltendes_affengesicht:': u'\U0001F649',
	u':sich_den_mund_zuhaltendes_affengesicht:': u'\U0001F64A',
	u':kussabdruck:': u'\U0001F48B',
	u':liebesbrief:': u'\U0001F48C',
	u':herz_mit_pfeil:': u'\U0001F498',
	u':herz_mit_schleife:': u'\U0001F49D',
	u':funkelndes_herz:': u'\U0001F496',
	u':wachsendes_herz:': u'\U0001F497',
	u':schlagendes_herz:': u'\U0001F493',
	u':kreisende_herzen:': u'\U0001F49E',
	u':zwei_herzen:': u'\U0001F495',
	u':herzdekoration:': u'\U0001F49F',
	u':herz_als_ausrufezeichen:': u'\U00002763\U0000FE0F',
	u':gebrochenes_herz:': u'\U0001F494',
	u':rotes_herz:': u'\U00002764\U0000FE0F',
	u':oranges_herz:': u'\U0001F9E1',
	u':gelbes_herz:': u'\U0001F49B',
	u':grünes_herz:': u'\U0001F49A',
	u':blaues_herz:': u'\U0001F499',
	u':lila_herz:': u'\U0001F49C',
	u':braunes_herz:': u'\U0001F90E',
	u':schwarzes_herz:': u'\U0001F5A4',
	u':weißes_herz:': u'\U0001F90D',
	u':100_punkte:': u'\U0001F4AF',
	u':ärger:': u'\U0001F4A2',
	u':zusammenstoß:': u'\U0001F4A5',
	u':schwindlig:': u'\U0001F4AB',
	u':schweißtropfen:': u'\U0001F4A6',
	u':staubwolke:': u'\U0001F4A8',
	u':loch:': u'\U0001F573\U0000FE0F',
	u':bombe:': u'\U0001F4A3',
	u':sprechblase_mit_drei_punkten:': u'\U0001F4AC',
	u':auge_in_sprechblase:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
	u':sprechblase_links:': u'\U0001F5E8\U0000FE0F',
	u':sprechblase_für_wütende_aussage_rechts:': u'\U0001F5EF\U0000FE0F',
	u':gedankenblase:': u'\U0001F4AD',
	u':schlafen:': u'\U0001F4A4',
	u':winkende_hand:': u'\U0001F44B',
	u':winkende_hand_helle_hautfarbe:': u'\U0001F44B\U0001F3FB',
	u':winkende_hand_mittelhelle_hautfarbe:': u'\U0001F44B\U0001F3FC',
	u':winkende_hand_mittlere_hautfarbe:': u'\U0001F44B\U0001F3FD',
	u':winkende_hand_mitteldunkle_hautfarbe:': u'\U0001F44B\U0001F3FE',
	u':winkende_hand_dunkle_hautfarbe:': u'\U0001F44B\U0001F3FF',
	u':erhobene_hand_von_hinten:': u'\U0001F91A',
	u':erhobene_hand_von_hinten_helle_hautfarbe:': u'\U0001F91A\U0001F3FB',
	u':erhobene_hand_von_hinten_mittelhelle_hautfarbe:': u'\U0001F91A\U0001F3FC',
	u':erhobene_hand_von_hinten_mittlere_hautfarbe:': u'\U0001F91A\U0001F3FD',
	u':erhobene_hand_von_hinten_mitteldunkle_hautfarbe:': u'\U0001F91A\U0001F3FE',
	u':erhobene_hand_von_hinten_dunkle_hautfarbe:': u'\U0001F91A\U0001F3FF',
	u':hand_mit_gespreizten_fingern:': u'\U0001F590\U0000FE0F',
	u':hand_mit_gespreizten_fingern_helle_hautfarbe:': u'\U0001F590\U0001F3FB',
	u':hand_mit_gespreizten_fingern_mittelhelle_hautfarbe:': u'\U0001F590\U0001F3FC',
	u':hand_mit_gespreizten_fingern_mittlere_hautfarbe:': u'\U0001F590\U0001F3FD',
	u':hand_mit_gespreizten_fingern_mitteldunkle_hautfarbe:': u'\U0001F590\U0001F3FE',
	u':hand_mit_gespreizten_fingern_dunkle_hautfarbe:': u'\U0001F590\U0001F3FF',
	u':erhobene_hand:': u'\U0000270B',
	u':erhobene_hand_helle_hautfarbe:': u'\U0000270B\U0001F3FB',
	u':erhobene_hand_mittelhelle_hautfarbe:': u'\U0000270B\U0001F3FC',
	u':erhobene_hand_mittlere_hautfarbe:': u'\U0000270B\U0001F3FD',
	u':erhobene_hand_mitteldunkle_hautfarbe:': u'\U0000270B\U0001F3FE',
	u':erhobene_hand_dunkle_hautfarbe:': u'\U0000270B\U0001F3FF',
	u':vulkanischer_gruß:': u'\U0001F596',
	u':vulkanischer_gruß_helle_hautfarbe:': u'\U0001F596\U0001F3FB',
	u':vulkanischer_gruß_mittelhelle_hautfarbe:': u'\U0001F596\U0001F3FC',
	u':vulkanischer_gruß_mittlere_hautfarbe:': u'\U0001F596\U0001F3FD',
	u':vulkanischer_gruß_mitteldunkle_hautfarbe:': u'\U0001F596\U0001F3FE',
	u':vulkanischer_gruß_dunkle_hautfarbe:': u'\U0001F596\U0001F3FF',
	u':ok-zeichen:': u'\U0001F44C',
	u':ok-zeichen_helle_hautfarbe:': u'\U0001F44C\U0001F3FB',
	u':ok-zeichen_mittelhelle_hautfarbe:': u'\U0001F44C\U0001F3FC',
	u':ok-zeichen_mittlere_hautfarbe:': u'\U0001F44C\U0001F3FD',
	u':ok-zeichen_mitteldunkle_hautfarbe:': u'\U0001F44C\U0001F3FE',
	u':ok-zeichen_dunkle_hautfarbe:': u'\U0001F44C\U0001F3FF',
	u':zusammengedrückte_finger:': u'\U0001F90C',
	u':zusammengedrückte_finger_helle_hautfarbe:': u'\U0001F90C\U0001F3FB',
	u':zusammengedrückte_finger_mittelhelle_hautfarbe:': u'\U0001F90C\U0001F3FC',
	u':zusammengedrückte_finger_mittlere_hautfarbe:': u'\U0001F90C\U0001F3FD',
	u':zusammengedrückte_finger_mitteldunkle_hautfarbe:': u'\U0001F90C\U0001F3FE',
	u':zusammengedrückte_finger_dunkle_hautfarbe:': u'\U0001F90C\U0001F3FF',
	u':wenig-geste:': u'\U0001F90F',
	u':wenig-geste_helle_hautfarbe:': u'\U0001F90F\U0001F3FB',
	u':wenig-geste_mittelhelle_hautfarbe:': u'\U0001F90F\U0001F3FC',
	u':wenig-geste_mittlere_hautfarbe:': u'\U0001F90F\U0001F3FD',
	u':wenig-geste_mitteldunkle_hautfarbe:': u'\U0001F90F\U0001F3FE',
	u':wenig-geste_dunkle_hautfarbe:': u'\U0001F90F\U0001F3FF',
	u':victory-geste:': u'\U0000270C\U0000FE0F',
	u':victory-geste_helle_hautfarbe:': u'\U0000270C\U0001F3FB',
	u':victory-geste_mittelhelle_hautfarbe:': u'\U0000270C\U0001F3FC',
	u':victory-geste_mittlere_hautfarbe:': u'\U0000270C\U0001F3FD',
	u':victory-geste_mitteldunkle_hautfarbe:': u'\U0000270C\U0001F3FE',
	u':victory-geste_dunkle_hautfarbe:': u'\U0000270C\U0001F3FF',
	u':hand_mit_gekreuzten_fingern:': u'\U0001F91E',
	u':hand_mit_gekreuzten_fingern_helle_hautfarbe:': u'\U0001F91E\U0001F3FB',
	u':hand_mit_gekreuzten_fingern_mittelhelle_hautfarbe:': u'\U0001F91E\U0001F3FC',
	u':hand_mit_gekreuzten_fingern_mittlere_hautfarbe:': u'\U0001F91E\U0001F3FD',
	u':hand_mit_gekreuzten_fingern_mitteldunkle_hautfarbe:': u'\U0001F91E\U0001F3FE',
	u':hand_mit_gekreuzten_fingern_dunkle_hautfarbe:': u'\U0001F91E\U0001F3FF',
	u':ich-liebe-dich-geste:': u'\U0001F91F',
	u':ich-liebe-dich-geste_helle_hautfarbe:': u'\U0001F91F\U0001F3FB',
	u':ich-liebe-dich-geste_mittelhelle_hautfarbe:': u'\U0001F91F\U0001F3FC',
	u':ich-liebe-dich-geste_mittlere_hautfarbe:': u'\U0001F91F\U0001F3FD',
	u':ich-liebe-dich-geste_mitteldunkle_hautfarbe:': u'\U0001F91F\U0001F3FE',
	u':ich-liebe-dich-geste_dunkle_hautfarbe:': u'\U0001F91F\U0001F3FF',
	u':teufelsgruß:': u'\U0001F918',
	u':teufelsgruß_helle_hautfarbe:': u'\U0001F918\U0001F3FB',
	u':teufelsgruß_mittelhelle_hautfarbe:': u'\U0001F918\U0001F3FC',
	u':teufelsgruß_mittlere_hautfarbe:': u'\U0001F918\U0001F3FD',
	u':teufelsgruß_mitteldunkle_hautfarbe:': u'\U0001F918\U0001F3FE',
	u':teufelsgruß_dunkle_hautfarbe:': u'\U0001F918\U0001F3FF',
	u':ruf-mich-an-handzeichen:': u'\U0001F919',
	u':ruf-mich-an-handzeichen_helle_hautfarbe:': u'\U0001F919\U0001F3FB',
	u':ruf-mich-an-handzeichen_mittelhelle_hautfarbe:': u'\U0001F919\U0001F3FC',
	u':ruf-mich-an-handzeichen_mittlere_hautfarbe:': u'\U0001F919\U0001F3FD',
	u':ruf-mich-an-handzeichen_mitteldunkle_hautfarbe:': u'\U0001F919\U0001F3FE',
	u':ruf-mich-an-handzeichen_dunkle_hautfarbe:': u'\U0001F919\U0001F3FF',
	u':nach_links_weisender_zeigefinger:': u'\U0001F448',
	u':nach_links_weisender_zeigefinger_helle_hautfarbe:': u'\U0001F448\U0001F3FB',
	u':nach_links_weisender_zeigefinger_mittelhelle_hautfarbe:': u'\U0001F448\U0001F3FC',
	u':nach_links_weisender_zeigefinger_mittlere_hautfarbe:': u'\U0001F448\U0001F3FD',
	u':nach_links_weisender_zeigefinger_mitteldunkle_hautfarbe:': u'\U0001F448\U0001F3FE',
	u':nach_links_weisender_zeigefinger_dunkle_hautfarbe:': u'\U0001F448\U0001F3FF',
	u':nach_rechts_weisender_zeigefinger:': u'\U0001F449',
	u':nach_rechts_weisender_zeigefinger_helle_hautfarbe:': u'\U0001F449\U0001F3FB',
	u':nach_rechts_weisender_zeigefinger_mittelhelle_hautfarbe:': u'\U0001F449\U0001F3FC',
	u':nach_rechts_weisender_zeigefinger_mittlere_hautfarbe:': u'\U0001F449\U0001F3FD',
	u':nach_rechts_weisender_zeigefinger_mitteldunkle_hautfarbe:': u'\U0001F449\U0001F3FE',
	u':nach_rechts_weisender_zeigefinger_dunkle_hautfarbe:': u'\U0001F449\U0001F3FF',
	u':nach_oben_weisender_zeigefinger_von_hinten:': u'\U0001F446',
	u':nach_oben_weisender_zeigefinger_von_hinten_helle_hautfarbe:': u'\U0001F446\U0001F3FB',
	u':nach_oben_weisender_zeigefinger_von_hinten_mittelhelle_hautfarbe:': u'\U0001F446\U0001F3FC',
	u':nach_oben_weisender_zeigefinger_von_hinten_mittlere_hautfarbe:': u'\U0001F446\U0001F3FD',
	u':nach_oben_weisender_zeigefinger_von_hinten_mitteldunkle_hautfarbe:': u'\U0001F446\U0001F3FE',
	u':nach_oben_weisender_zeigefinger_von_hinten_dunkle_hautfarbe:': u'\U0001F446\U0001F3FF',
	u':mittelfinger:': u'\U0001F595',
	u':mittelfinger_helle_hautfarbe:': u'\U0001F595\U0001F3FB',
	u':mittelfinger_mittelhelle_hautfarbe:': u'\U0001F595\U0001F3FC',
	u':mittelfinger_mittlere_hautfarbe:': u'\U0001F595\U0001F3FD',
	u':mittelfinger_mitteldunkle_hautfarbe:': u'\U0001F595\U0001F3FE',
	u':mittelfinger_dunkle_hautfarbe:': u'\U0001F595\U0001F3FF',
	u':nach_unten_weisender_zeigefinger:': u'\U0001F447',
	u':nach_unten_weisender_zeigefinger_helle_hautfarbe:': u'\U0001F447\U0001F3FB',
	u':nach_unten_weisender_zeigefinger_mittelhelle_hautfarbe:': u'\U0001F447\U0001F3FC',
	u':nach_unten_weisender_zeigefinger_mittlere_hautfarbe:': u'\U0001F447\U0001F3FD',
	u':nach_unten_weisender_zeigefinger_mitteldunkle_hautfarbe:': u'\U0001F447\U0001F3FE',
	u':nach_unten_weisender_zeigefinger_dunkle_hautfarbe:': u'\U0001F447\U0001F3FF',
	u':nach_oben_weisender_zeigefinger_von_vorne:': u'\U0000261D\U0000FE0F',
	u':nach_oben_weisender_zeigefinger_von_vorne_helle_hautfarbe:': u'\U0000261D\U0001F3FB',
	u':nach_oben_weisender_zeigefinger_von_vorne_mittelhelle_hautfarbe:': u'\U0000261D\U0001F3FC',
	u':nach_oben_weisender_zeigefinger_von_vorne_mittlere_hautfarbe:': u'\U0000261D\U0001F3FD',
	u':nach_oben_weisender_zeigefinger_von_vorne_mitteldunkle_hautfarbe:': u'\U0000261D\U0001F3FE',
	u':nach_oben_weisender_zeigefinger_von_vorne_dunkle_hautfarbe:': u'\U0000261D\U0001F3FF',
	u':daumen_hoch:': u'\U0001F44D',
	u':daumen_hoch_helle_hautfarbe:': u'\U0001F44D\U0001F3FB',
	u':daumen_hoch_mittelhelle_hautfarbe:': u'\U0001F44D\U0001F3FC',
	u':daumen_hoch_mittlere_hautfarbe:': u'\U0001F44D\U0001F3FD',
	u':daumen_hoch_mitteldunkle_hautfarbe:': u'\U0001F44D\U0001F3FE',
	u':daumen_hoch_dunkle_hautfarbe:': u'\U0001F44D\U0001F3FF',
	u':daumen_runter:': u'\U0001F44E',
	u':daumen_runter_helle_hautfarbe:': u'\U0001F44E\U0001F3FB',
	u':daumen_runter_mittelhelle_hautfarbe:': u'\U0001F44E\U0001F3FC',
	u':daumen_runter_mittlere_hautfarbe:': u'\U0001F44E\U0001F3FD',
	u':daumen_runter_mitteldunkle_hautfarbe:': u'\U0001F44E\U0001F3FE',
	u':daumen_runter_dunkle_hautfarbe:': u'\U0001F44E\U0001F3FF',
	u':erhobene_faust:': u'\U0000270A',
	u':erhobene_faust_helle_hautfarbe:': u'\U0000270A\U0001F3FB',
	u':erhobene_faust_mittelhelle_hautfarbe:': u'\U0000270A\U0001F3FC',
	u':erhobene_faust_mittlere_hautfarbe:': u'\U0000270A\U0001F3FD',
	u':erhobene_faust_mitteldunkle_hautfarbe:': u'\U0000270A\U0001F3FE',
	u':erhobene_faust_dunkle_hautfarbe:': u'\U0000270A\U0001F3FF',
	u':geballte_faust:': u'\U0001F44A',
	u':geballte_faust_helle_hautfarbe:': u'\U0001F44A\U0001F3FB',
	u':geballte_faust_mittelhelle_hautfarbe:': u'\U0001F44A\U0001F3FC',
	u':geballte_faust_mittlere_hautfarbe:': u'\U0001F44A\U0001F3FD',
	u':geballte_faust_mitteldunkle_hautfarbe:': u'\U0001F44A\U0001F3FE',
	u':geballte_faust_dunkle_hautfarbe:': u'\U0001F44A\U0001F3FF',
	u':faust_nach_links:': u'\U0001F91B',
	u':faust_nach_links_helle_hautfarbe:': u'\U0001F91B\U0001F3FB',
	u':faust_nach_links_mittelhelle_hautfarbe:': u'\U0001F91B\U0001F3FC',
	u':faust_nach_links_mittlere_hautfarbe:': u'\U0001F91B\U0001F3FD',
	u':faust_nach_links_mitteldunkle_hautfarbe:': u'\U0001F91B\U0001F3FE',
	u':faust_nach_links_dunkle_hautfarbe:': u'\U0001F91B\U0001F3FF',
	u':faust_nach_rechts:': u'\U0001F91C',
	u':faust_nach_rechts_helle_hautfarbe:': u'\U0001F91C\U0001F3FB',
	u':faust_nach_rechts_mittelhelle_hautfarbe:': u'\U0001F91C\U0001F3FC',
	u':faust_nach_rechts_mittlere_hautfarbe:': u'\U0001F91C\U0001F3FD',
	u':faust_nach_rechts_mitteldunkle_hautfarbe:': u'\U0001F91C\U0001F3FE',
	u':faust_nach_rechts_dunkle_hautfarbe:': u'\U0001F91C\U0001F3FF',
	u':klatschende_hände:': u'\U0001F44F',
	u':klatschende_hände_helle_hautfarbe:': u'\U0001F44F\U0001F3FB',
	u':klatschende_hände_mittelhelle_hautfarbe:': u'\U0001F44F\U0001F3FC',
	u':klatschende_hände_mittlere_hautfarbe:': u'\U0001F44F\U0001F3FD',
	u':klatschende_hände_mitteldunkle_hautfarbe:': u'\U0001F44F\U0001F3FE',
	u':klatschende_hände_dunkle_hautfarbe:': u'\U0001F44F\U0001F3FF',
	u':zwei_erhobene_handflächen:': u'\U0001F64C',
	u':zwei_erhobene_handflächen_helle_hautfarbe:': u'\U0001F64C\U0001F3FB',
	u':zwei_erhobene_handflächen_mittelhelle_hautfarbe:': u'\U0001F64C\U0001F3FC',
	u':zwei_erhobene_handflächen_mittlere_hautfarbe:': u'\U0001F64C\U0001F3FD',
	u':zwei_erhobene_handflächen_mitteldunkle_hautfarbe:': u'\U0001F64C\U0001F3FE',
	u':zwei_erhobene_handflächen_dunkle_hautfarbe:': u'\U0001F64C\U0001F3FF',
	u':offene_hände:': u'\U0001F450',
	u':offene_hände_helle_hautfarbe:': u'\U0001F450\U0001F3FB',
	u':offene_hände_mittelhelle_hautfarbe:': u'\U0001F450\U0001F3FC',
	u':offene_hände_mittlere_hautfarbe:': u'\U0001F450\U0001F3FD',
	u':offene_hände_mitteldunkle_hautfarbe:': u'\U0001F450\U0001F3FE',
	u':offene_hände_dunkle_hautfarbe:': u'\U0001F450\U0001F3FF',
	u':handflächen_nach_oben:': u'\U0001F932',
	u':handflächen_nach_oben_helle_hautfarbe:': u'\U0001F932\U0001F3FB',
	u':handflächen_nach_oben_mittelhelle_hautfarbe:': u'\U0001F932\U0001F3FC',
	u':handflächen_nach_oben_mittlere_hautfarbe:': u'\U0001F932\U0001F3FD',
	u':handflächen_nach_oben_mitteldunkle_hautfarbe:': u'\U0001F932\U0001F3FE',
	u':handflächen_nach_oben_dunkle_hautfarbe:': u'\U0001F932\U0001F3FF',
	u':handschlag:': u'\U0001F91D',
	u':betende_hände:': u'\U0001F64F',
	u':betende_hände_helle_hautfarbe:': u'\U0001F64F\U0001F3FB',
	u':betende_hände_mittelhelle_hautfarbe:': u'\U0001F64F\U0001F3FC',
	u':betende_hände_mittlere_hautfarbe:': u'\U0001F64F\U0001F3FD',
	u':betende_hände_mitteldunkle_hautfarbe:': u'\U0001F64F\U0001F3FE',
	u':betende_hände_dunkle_hautfarbe:': u'\U0001F64F\U0001F3FF',
	u':schreibende_hand:': u'\U0000270D\U0000FE0F',
	u':schreibende_hand_helle_hautfarbe:': u'\U0000270D\U0001F3FB',
	u':schreibende_hand_mittelhelle_hautfarbe:': u'\U0000270D\U0001F3FC',
	u':schreibende_hand_mittlere_hautfarbe:': u'\U0000270D\U0001F3FD',
	u':schreibende_hand_mitteldunkle_hautfarbe:': u'\U0000270D\U0001F3FE',
	u':schreibende_hand_dunkle_hautfarbe:': u'\U0000270D\U0001F3FF',
	u':nagellack:': u'\U0001F485',
	u':nagellack_helle_hautfarbe:': u'\U0001F485\U0001F3FB',
	u':nagellack_mittelhelle_hautfarbe:': u'\U0001F485\U0001F3FC',
	u':nagellack_mittlere_hautfarbe:': u'\U0001F485\U0001F3FD',
	u':nagellack_mitteldunkle_hautfarbe:': u'\U0001F485\U0001F3FE',
	u':nagellack_dunkle_hautfarbe:': u'\U0001F485\U0001F3FF',
	u':selfie:': u'\U0001F933',
	u':selfie_helle_hautfarbe:': u'\U0001F933\U0001F3FB',
	u':selfie_mittelhelle_hautfarbe:': u'\U0001F933\U0001F3FC',
	u':selfie_mittlere_hautfarbe:': u'\U0001F933\U0001F3FD',
	u':selfie_mitteldunkle_hautfarbe:': u'\U0001F933\U0001F3FE',
	u':selfie_dunkle_hautfarbe:': u'\U0001F933\U0001F3FF',
	u':angespannter_bizeps:': u'\U0001F4AA',
	u':angespannter_bizeps_helle_hautfarbe:': u'\U0001F4AA\U0001F3FB',
	u':angespannter_bizeps_mittelhelle_hautfarbe:': u'\U0001F4AA\U0001F3FC',
	u':angespannter_bizeps_mittlere_hautfarbe:': u'\U0001F4AA\U0001F3FD',
	u':angespannter_bizeps_mitteldunkle_hautfarbe:': u'\U0001F4AA\U0001F3FE',
	u':angespannter_bizeps_dunkle_hautfarbe:': u'\U0001F4AA\U0001F3FF',
	u':armprothese:': u'\U0001F9BE',
	u':beinprothese:': u'\U0001F9BF',
	u':bein:': u'\U0001F9B5',
	u':bein_helle_hautfarbe:': u'\U0001F9B5\U0001F3FB',
	u':bein_mittelhelle_hautfarbe:': u'\U0001F9B5\U0001F3FC',
	u':bein_mittlere_hautfarbe:': u'\U0001F9B5\U0001F3FD',
	u':bein_mitteldunkle_hautfarbe:': u'\U0001F9B5\U0001F3FE',
	u':bein_dunkle_hautfarbe:': u'\U0001F9B5\U0001F3FF',
	u':fuß:': u'\U0001F9B6',
	u':fuß_helle_hautfarbe:': u'\U0001F9B6\U0001F3FB',
	u':fuß_mittelhelle_hautfarbe:': u'\U0001F9B6\U0001F3FC',
	u':fuß_mittlere_hautfarbe:': u'\U0001F9B6\U0001F3FD',
	u':fuß_mitteldunkle_hautfarbe:': u'\U0001F9B6\U0001F3FE',
	u':fuß_dunkle_hautfarbe:': u'\U0001F9B6\U0001F3FF',
	u':ohr:': u'\U0001F442',
	u':ohr_helle_hautfarbe:': u'\U0001F442\U0001F3FB',
	u':ohr_mittelhelle_hautfarbe:': u'\U0001F442\U0001F3FC',
	u':ohr_mittlere_hautfarbe:': u'\U0001F442\U0001F3FD',
	u':ohr_mitteldunkle_hautfarbe:': u'\U0001F442\U0001F3FE',
	u':ohr_dunkle_hautfarbe:': u'\U0001F442\U0001F3FF',
	u':ohr_mit_hörhilfe:': u'\U0001F9BB',
	u':ohr_mit_hörhilfe_helle_hautfarbe:': u'\U0001F9BB\U0001F3FB',
	u':ohr_mit_hörhilfe_mittelhelle_hautfarbe:': u'\U0001F9BB\U0001F3FC',
	u':ohr_mit_hörhilfe_mittlere_hautfarbe:': u'\U0001F9BB\U0001F3FD',
	u':ohr_mit_hörhilfe_mitteldunkle_hautfarbe:': u'\U0001F9BB\U0001F3FE',
	u':ohr_mit_hörhilfe_dunkle_hautfarbe:': u'\U0001F9BB\U0001F3FF',
	u':nase:': u'\U0001F443',
	u':nase_helle_hautfarbe:': u'\U0001F443\U0001F3FB',
	u':nase_mittelhelle_hautfarbe:': u'\U0001F443\U0001F3FC',
	u':nase_mittlere_hautfarbe:': u'\U0001F443\U0001F3FD',
	u':nase_mitteldunkle_hautfarbe:': u'\U0001F443\U0001F3FE',
	u':nase_dunkle_hautfarbe:': u'\U0001F443\U0001F3FF',
	u':gehirn:': u'\U0001F9E0',
	u':herz_(organ):': u'\U0001FAC0',
	u':lungen:': u'\U0001FAC1',
	u':zahn:': u'\U0001F9B7',
	u':knochen:': u'\U0001F9B4',
	u':augen:': u'\U0001F440',
	u':auge:': u'\U0001F441\U0000FE0F',
	u':zunge:': u'\U0001F445',
	u':mund:': u'\U0001F444',
	u':baby:': u'\U0001F476',
	u':baby_helle_hautfarbe:': u'\U0001F476\U0001F3FB',
	u':baby_mittelhelle_hautfarbe:': u'\U0001F476\U0001F3FC',
	u':baby_mittlere_hautfarbe:': u'\U0001F476\U0001F3FD',
	u':baby_mitteldunkle_hautfarbe:': u'\U0001F476\U0001F3FE',
	u':baby_dunkle_hautfarbe:': u'\U0001F476\U0001F3FF',
	u':kind:': u'\U0001F9D2',
	u':kind_helle_hautfarbe:': u'\U0001F9D2\U0001F3FB',
	u':kind_mittelhelle_hautfarbe:': u'\U0001F9D2\U0001F3FC',
	u':kind_mittlere_hautfarbe:': u'\U0001F9D2\U0001F3FD',
	u':kind_mitteldunkle_hautfarbe:': u'\U0001F9D2\U0001F3FE',
	u':kind_dunkle_hautfarbe:': u'\U0001F9D2\U0001F3FF',
	u':junge:': u'\U0001F466',
	u':junge_helle_hautfarbe:': u'\U0001F466\U0001F3FB',
	u':junge_mittelhelle_hautfarbe:': u'\U0001F466\U0001F3FC',
	u':junge_mittlere_hautfarbe:': u'\U0001F466\U0001F3FD',
	u':junge_mitteldunkle_hautfarbe:': u'\U0001F466\U0001F3FE',
	u':junge_dunkle_hautfarbe:': u'\U0001F466\U0001F3FF',
	u':mädchen:': u'\U0001F467',
	u':mädchen_helle_hautfarbe:': u'\U0001F467\U0001F3FB',
	u':mädchen_mittelhelle_hautfarbe:': u'\U0001F467\U0001F3FC',
	u':mädchen_mittlere_hautfarbe:': u'\U0001F467\U0001F3FD',
	u':mädchen_mitteldunkle_hautfarbe:': u'\U0001F467\U0001F3FE',
	u':mädchen_dunkle_hautfarbe:': u'\U0001F467\U0001F3FF',
	u':erwachsener:': u'\U0001F9D1',
	u':erwachsener_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB',
	u':erwachsener_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC',
	u':erwachsener_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD',
	u':erwachsener_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE',
	u':erwachsener_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF',
	u':person_blondes_haar:': u'\U0001F471',
	u':person_helle_hautfarbe,_blondes_haar:': u'\U0001F471\U0001F3FB',
	u':person_mittelhelle_hautfarbe,_blondes_haar:': u'\U0001F471\U0001F3FC',
	u':person_mittlere_hautfarbe,_blondes_haar:': u'\U0001F471\U0001F3FD',
	u':person_mitteldunkle_hautfarbe,_blondes_haar:': u'\U0001F471\U0001F3FE',
	u':person_dunkle_hautfarbe,_blondes_haar:': u'\U0001F471\U0001F3FF',
	u':mann:': u'\U0001F468',
	u':mann_helle_hautfarbe:': u'\U0001F468\U0001F3FB',
	u':mann_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC',
	u':mann_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD',
	u':mann_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE',
	u':mann_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF',
	u':mann_bart:': u'\U0001F9D4',
	u':mann_helle_hautfarbe,_bart:': u'\U0001F9D4\U0001F3FB',
	u':mann_mittelhelle_hautfarbe,_bart:': u'\U0001F9D4\U0001F3FC',
	u':mann_mittlere_hautfarbe,_bart:': u'\U0001F9D4\U0001F3FD',
	u':mann_mitteldunkle_hautfarbe,_bart:': u'\U0001F9D4\U0001F3FE',
	u':mann_dunkle_hautfarbe,_bart:': u'\U0001F9D4\U0001F3FF',
	u':mann_rotes_haar:': u'\U0001F468\U0000200D\U0001F9B0',
	u':mann_helle_hautfarbe,_rotes_haar:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B0',
	u':mann_mittelhelle_hautfarbe,_rotes_haar:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B0',
	u':mann_mittlere_hautfarbe,_rotes_haar:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B0',
	u':mann_mitteldunkle_hautfarbe,_rotes_haar:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B0',
	u':mann_dunkle_hautfarbe,_rotes_haar:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B0',
	u':mann_lockiges_haar:': u'\U0001F468\U0000200D\U0001F9B1',
	u':mann_helle_hautfarbe,_lockiges_haar:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B1',
	u':mann_mittelhelle_hautfarbe,_lockiges_haar:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B1',
	u':mann_mittlere_hautfarbe,_lockiges_haar:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B1',
	u':mann_mitteldunkle_hautfarbe,_lockiges_haar:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B1',
	u':mann_dunkle_hautfarbe,_lockiges_haar:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B1',
	u':mann_weißes_haar:': u'\U0001F468\U0000200D\U0001F9B3',
	u':mann_helle_hautfarbe,_weißes_haar:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B3',
	u':mann_mittelhelle_hautfarbe,_weißes_haar:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B3',
	u':mann_mittlere_hautfarbe,_weißes_haar:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B3',
	u':mann_mitteldunkle_hautfarbe,_weißes_haar:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B3',
	u':mann_dunkle_hautfarbe,_weißes_haar:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B3',
	u':mann_glatze:': u'\U0001F468\U0000200D\U0001F9B2',
	u':mann_helle_hautfarbe,_glatze:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B2',
	u':mann_mittelhelle_hautfarbe,_glatze:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B2',
	u':mann_mittlere_hautfarbe,_glatze:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B2',
	u':mann_mitteldunkle_hautfarbe,_glatze:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B2',
	u':mann_dunkle_hautfarbe,_glatze:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B2',
	u':frau:': u'\U0001F469',
	u':frau_helle_hautfarbe:': u'\U0001F469\U0001F3FB',
	u':frau_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC',
	u':frau_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD',
	u':frau_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE',
	u':frau_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF',
	u':frau_rotes_haar:': u'\U0001F469\U0000200D\U0001F9B0',
	u':frau_helle_hautfarbe,_rotes_haar:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B0',
	u':frau_mittelhelle_hautfarbe,_rotes_haar:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B0',
	u':frau_mittlere_hautfarbe,_rotes_haar:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B0',
	u':frau_mitteldunkle_hautfarbe,_rotes_haar:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B0',
	u':frau_dunkle_hautfarbe,_rotes_haar:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B0',
	u':erwachsener_rotes_haar:': u'\U0001F9D1\U0000200D\U0001F9B0',
	u':erwachsener_helle_hautfarbe,_rotes_haar:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B0',
	u':erwachsener_mittelhelle_hautfarbe,_rotes_haar:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B0',
	u':erwachsener_mittlere_hautfarbe,_rotes_haar:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B0',
	u':erwachsener_mitteldunkle_hautfarbe,_rotes_haar:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B0',
	u':erwachsener_dunkle_hautfarbe,_rotes_haar:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B0',
	u':frau_lockiges_haar:': u'\U0001F469\U0000200D\U0001F9B1',
	u':frau_helle_hautfarbe,_lockiges_haar:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B1',
	u':frau_mittelhelle_hautfarbe,_lockiges_haar:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B1',
	u':frau_mittlere_hautfarbe,_lockiges_haar:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B1',
	u':frau_mitteldunkle_hautfarbe,_lockiges_haar:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B1',
	u':frau_dunkle_hautfarbe,_lockiges_haar:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B1',
	u':erwachsener_lockiges_haar:': u'\U0001F9D1\U0000200D\U0001F9B1',
	u':erwachsener_helle_hautfarbe,_lockiges_haar:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B1',
	u':erwachsener_mittelhelle_hautfarbe,_lockiges_haar:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B1',
	u':erwachsener_mittlere_hautfarbe,_lockiges_haar:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B1',
	u':erwachsener_mitteldunkle_hautfarbe,_lockiges_haar:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B1',
	u':erwachsener_dunkle_hautfarbe,_lockiges_haar:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B1',
	u':frau_weißes_haar:': u'\U0001F469\U0000200D\U0001F9B3',
	u':frau_helle_hautfarbe,_weißes_haar:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B3',
	u':frau_mittelhelle_hautfarbe,_weißes_haar:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B3',
	u':frau_mittlere_hautfarbe,_weißes_haar:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B3',
	u':frau_mitteldunkle_hautfarbe,_weißes_haar:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B3',
	u':frau_dunkle_hautfarbe,_weißes_haar:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B3',
	u':erwachsener_weißes_haar:': u'\U0001F9D1\U0000200D\U0001F9B3',
	u':erwachsener_helle_hautfarbe,_weißes_haar:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B3',
	u':erwachsener_mittelhelle_hautfarbe,_weißes_haar:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B3',
	u':erwachsener_mittlere_hautfarbe,_weißes_haar:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B3',
	u':erwachsener_mitteldunkle_hautfarbe,_weißes_haar:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B3',
	u':erwachsener_dunkle_hautfarbe,_weißes_haar:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B3',
	u':frau_glatze:': u'\U0001F469\U0000200D\U0001F9B2',
	u':frau_helle_hautfarbe,_glatze:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B2',
	u':frau_mittelhelle_hautfarbe,_glatze:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B2',
	u':frau_mittlere_hautfarbe,_glatze:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B2',
	u':frau_mitteldunkle_hautfarbe,_glatze:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B2',
	u':frau_dunkle_hautfarbe,_glatze:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B2',
	u':erwachsener_glatze:': u'\U0001F9D1\U0000200D\U0001F9B2',
	u':erwachsener_helle_hautfarbe,_glatze:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B2',
	u':erwachsener_mittelhelle_hautfarbe,_glatze:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B2',
	u':erwachsener_mittlere_hautfarbe,_glatze:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B2',
	u':erwachsener_mitteldunkle_hautfarbe,_glatze:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B2',
	u':erwachsener_dunkle_hautfarbe,_glatze:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B2',
	u':frau_blond:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
	u':frau_helle_hautfarbe,_blond:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mittelhelle_hautfarbe,_blond:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mittlere_hautfarbe,_blond:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mitteldunkle_hautfarbe,_blond:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_dunkle_hautfarbe,_blond:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':mann_blond:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
	u':mann_helle_hautfarbe,_blond:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mittelhelle_hautfarbe,_blond:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mittlere_hautfarbe,_blond:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mitteldunkle_hautfarbe,_blond:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_dunkle_hautfarbe,_blond:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':älterer_erwachsener:': u'\U0001F9D3',
	u':älterer_erwachsener_helle_hautfarbe:': u'\U0001F9D3\U0001F3FB',
	u':älterer_erwachsener_mittelhelle_hautfarbe:': u'\U0001F9D3\U0001F3FC',
	u':älterer_erwachsener_mittlere_hautfarbe:': u'\U0001F9D3\U0001F3FD',
	u':älterer_erwachsener_mitteldunkle_hautfarbe:': u'\U0001F9D3\U0001F3FE',
	u':älterer_erwachsener_dunkle_hautfarbe:': u'\U0001F9D3\U0001F3FF',
	u':älterer_mann:': u'\U0001F474',
	u':älterer_mann_helle_hautfarbe:': u'\U0001F474\U0001F3FB',
	u':älterer_mann_mittelhelle_hautfarbe:': u'\U0001F474\U0001F3FC',
	u':älterer_mann_mittlere_hautfarbe:': u'\U0001F474\U0001F3FD',
	u':älterer_mann_mitteldunkle_hautfarbe:': u'\U0001F474\U0001F3FE',
	u':älterer_mann_dunkle_hautfarbe:': u'\U0001F474\U0001F3FF',
	u':ältere_frau:': u'\U0001F475',
	u':ältere_frau_helle_hautfarbe:': u'\U0001F475\U0001F3FB',
	u':ältere_frau_mittelhelle_hautfarbe:': u'\U0001F475\U0001F3FC',
	u':ältere_frau_mittlere_hautfarbe:': u'\U0001F475\U0001F3FD',
	u':ältere_frau_mitteldunkle_hautfarbe:': u'\U0001F475\U0001F3FE',
	u':ältere_frau_dunkle_hautfarbe:': u'\U0001F475\U0001F3FF',
	u':missmutige_person:': u'\U0001F64D',
	u':missmutige_person_helle_hautfarbe:': u'\U0001F64D\U0001F3FB',
	u':missmutige_person_mittelhelle_hautfarbe:': u'\U0001F64D\U0001F3FC',
	u':missmutige_person_mittlere_hautfarbe:': u'\U0001F64D\U0001F3FD',
	u':missmutige_person_mitteldunkle_hautfarbe:': u'\U0001F64D\U0001F3FE',
	u':missmutige_person_dunkle_hautfarbe:': u'\U0001F64D\U0001F3FF',
	u':missmutiger_mann:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
	u':missmutiger_mann_helle_hautfarbe:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':missmutiger_mann_mittelhelle_hautfarbe:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':missmutiger_mann_mittlere_hautfarbe:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':missmutiger_mann_mitteldunkle_hautfarbe:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':missmutiger_mann_dunkle_hautfarbe:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':missmutige_frau:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
	u':missmutige_frau_helle_hautfarbe:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':missmutige_frau_mittelhelle_hautfarbe:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':missmutige_frau_mittlere_hautfarbe:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':missmutige_frau_mitteldunkle_hautfarbe:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':missmutige_frau_dunkle_hautfarbe:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':schmollende_person:': u'\U0001F64E',
	u':schmollende_person_helle_hautfarbe:': u'\U0001F64E\U0001F3FB',
	u':schmollende_person_mittelhelle_hautfarbe:': u'\U0001F64E\U0001F3FC',
	u':schmollende_person_mittlere_hautfarbe:': u'\U0001F64E\U0001F3FD',
	u':schmollende_person_mitteldunkle_hautfarbe:': u'\U0001F64E\U0001F3FE',
	u':schmollende_person_dunkle_hautfarbe:': u'\U0001F64E\U0001F3FF',
	u':schmollender_mann:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
	u':schmollender_mann_helle_hautfarbe:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':schmollender_mann_mittelhelle_hautfarbe:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':schmollender_mann_mittlere_hautfarbe:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':schmollender_mann_mitteldunkle_hautfarbe:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':schmollender_mann_dunkle_hautfarbe:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':schmollende_frau:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
	u':schmollende_frau_helle_hautfarbe:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':schmollende_frau_mittelhelle_hautfarbe:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':schmollende_frau_mittlere_hautfarbe:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':schmollende_frau_mitteldunkle_hautfarbe:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':schmollende_frau_dunkle_hautfarbe:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_mit_überkreuzten_armen:': u'\U0001F645',
	u':person_mit_überkreuzten_armen_helle_hautfarbe:': u'\U0001F645\U0001F3FB',
	u':person_mit_überkreuzten_armen_mittelhelle_hautfarbe:': u'\U0001F645\U0001F3FC',
	u':person_mit_überkreuzten_armen_mittlere_hautfarbe:': u'\U0001F645\U0001F3FD',
	u':person_mit_überkreuzten_armen_mitteldunkle_hautfarbe:': u'\U0001F645\U0001F3FE',
	u':person_mit_überkreuzten_armen_dunkle_hautfarbe:': u'\U0001F645\U0001F3FF',
	u':mann_mit_überkreuzten_armen:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_überkreuzten_armen_helle_hautfarbe:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_überkreuzten_armen_mittelhelle_hautfarbe:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_überkreuzten_armen_mittlere_hautfarbe:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_überkreuzten_armen_mitteldunkle_hautfarbe:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_überkreuzten_armen_dunkle_hautfarbe:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_mit_überkreuzten_armen:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_überkreuzten_armen_helle_hautfarbe:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_überkreuzten_armen_mittelhelle_hautfarbe:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_überkreuzten_armen_mittlere_hautfarbe:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_überkreuzten_armen_mitteldunkle_hautfarbe:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_überkreuzten_armen_dunkle_hautfarbe:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_mit_händen_auf_dem_kopf:': u'\U0001F646',
	u':person_mit_händen_auf_dem_kopf_helle_hautfarbe:': u'\U0001F646\U0001F3FB',
	u':person_mit_händen_auf_dem_kopf_mittelhelle_hautfarbe:': u'\U0001F646\U0001F3FC',
	u':person_mit_händen_auf_dem_kopf_mittlere_hautfarbe:': u'\U0001F646\U0001F3FD',
	u':person_mit_händen_auf_dem_kopf_mitteldunkle_hautfarbe:': u'\U0001F646\U0001F3FE',
	u':person_mit_händen_auf_dem_kopf_dunkle_hautfarbe:': u'\U0001F646\U0001F3FF',
	u':mann_mit_händen_auf_dem_kopf:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_händen_auf_dem_kopf_helle_hautfarbe:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_händen_auf_dem_kopf_mittelhelle_hautfarbe:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_händen_auf_dem_kopf_mittlere_hautfarbe:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_händen_auf_dem_kopf_mitteldunkle_hautfarbe:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_händen_auf_dem_kopf_dunkle_hautfarbe:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_mit_händen_auf_dem_kopf:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_händen_auf_dem_kopf_helle_hautfarbe:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_händen_auf_dem_kopf_mittelhelle_hautfarbe:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_händen_auf_dem_kopf_mittlere_hautfarbe:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_händen_auf_dem_kopf_mitteldunkle_hautfarbe:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_händen_auf_dem_kopf_dunkle_hautfarbe:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':infoschalter-mitarbeiter(in):': u'\U0001F481',
	u':infoschalter-mitarbeiter(in)_helle_hautfarbe:': u'\U0001F481\U0001F3FB',
	u':infoschalter-mitarbeiter(in)_mittelhelle_hautfarbe:': u'\U0001F481\U0001F3FC',
	u':infoschalter-mitarbeiter(in)_mittlere_hautfarbe:': u'\U0001F481\U0001F3FD',
	u':infoschalter-mitarbeiter(in)_mitteldunkle_hautfarbe:': u'\U0001F481\U0001F3FE',
	u':infoschalter-mitarbeiter(in)_dunkle_hautfarbe:': u'\U0001F481\U0001F3FF',
	u':infoschalter-mitarbeiter:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
	u':infoschalter-mitarbeiter_helle_hautfarbe:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':infoschalter-mitarbeiter_mittelhelle_hautfarbe:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':infoschalter-mitarbeiter_mittlere_hautfarbe:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':infoschalter-mitarbeiter_mitteldunkle_hautfarbe:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':infoschalter-mitarbeiter_dunkle_hautfarbe:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':infoschalter-mitarbeiterin:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
	u':infoschalter-mitarbeiterin_helle_hautfarbe:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':infoschalter-mitarbeiterin_mittelhelle_hautfarbe:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':infoschalter-mitarbeiterin_mittlere_hautfarbe:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':infoschalter-mitarbeiterin_mitteldunkle_hautfarbe:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':infoschalter-mitarbeiterin_dunkle_hautfarbe:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_mit_erhobenem_arm:': u'\U0001F64B',
	u':person_mit_erhobenem_arm_helle_hautfarbe:': u'\U0001F64B\U0001F3FB',
	u':person_mit_erhobenem_arm_mittelhelle_hautfarbe:': u'\U0001F64B\U0001F3FC',
	u':person_mit_erhobenem_arm_mittlere_hautfarbe:': u'\U0001F64B\U0001F3FD',
	u':person_mit_erhobenem_arm_mitteldunkle_hautfarbe:': u'\U0001F64B\U0001F3FE',
	u':person_mit_erhobenem_arm_dunkle_hautfarbe:': u'\U0001F64B\U0001F3FF',
	u':mann_mit_erhobenem_arm:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_erhobenem_arm_helle_hautfarbe:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_erhobenem_arm_mittelhelle_hautfarbe:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_erhobenem_arm_mittlere_hautfarbe:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_erhobenem_arm_mitteldunkle_hautfarbe:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_erhobenem_arm_dunkle_hautfarbe:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_mit_erhobenem_arm:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_erhobenem_arm_helle_hautfarbe:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_erhobenem_arm_mittelhelle_hautfarbe:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_erhobenem_arm_mittlere_hautfarbe:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_erhobenem_arm_mitteldunkle_hautfarbe:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_erhobenem_arm_dunkle_hautfarbe:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':gehörlose_person:': u'\U0001F9CF',
	u':gehörlose_person_helle_hautfarbe:': u'\U0001F9CF\U0001F3FB',
	u':gehörlose_person_mittelhelle_hautfarbe:': u'\U0001F9CF\U0001F3FC',
	u':gehörlose_person_mittlere_hautfarbe:': u'\U0001F9CF\U0001F3FD',
	u':gehörlose_person_mitteldunkle_hautfarbe:': u'\U0001F9CF\U0001F3FE',
	u':gehörlose_person_dunkle_hautfarbe:': u'\U0001F9CF\U0001F3FF',
	u':gehörloser_mann:': u'\U0001F9CF\U0000200D\U00002642\U0000FE0F',
	u':gehörloser_mann_helle_hautfarbe:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':gehörloser_mann_mittelhelle_hautfarbe:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':gehörloser_mann_mittlere_hautfarbe:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':gehörloser_mann_mitteldunkle_hautfarbe:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':gehörloser_mann_dunkle_hautfarbe:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':gehörlose_frau:': u'\U0001F9CF\U0000200D\U00002640\U0000FE0F',
	u':gehörlose_frau_helle_hautfarbe:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':gehörlose_frau_mittelhelle_hautfarbe:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':gehörlose_frau_mittlere_hautfarbe:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':gehörlose_frau_mitteldunkle_hautfarbe:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':gehörlose_frau_dunkle_hautfarbe:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':sich_verbeugende_person:': u'\U0001F647',
	u':sich_verbeugende_person_helle_hautfarbe:': u'\U0001F647\U0001F3FB',
	u':sich_verbeugende_person_mittelhelle_hautfarbe:': u'\U0001F647\U0001F3FC',
	u':sich_verbeugende_person_mittlere_hautfarbe:': u'\U0001F647\U0001F3FD',
	u':sich_verbeugende_person_mitteldunkle_hautfarbe:': u'\U0001F647\U0001F3FE',
	u':sich_verbeugende_person_dunkle_hautfarbe:': u'\U0001F647\U0001F3FF',
	u':sich_verbeugender_mann:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
	u':sich_verbeugender_mann_helle_hautfarbe:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':sich_verbeugender_mann_mittelhelle_hautfarbe:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':sich_verbeugender_mann_mittlere_hautfarbe:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':sich_verbeugender_mann_mitteldunkle_hautfarbe:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':sich_verbeugender_mann_dunkle_hautfarbe:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':sich_verbeugende_frau:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
	u':sich_verbeugende_frau_helle_hautfarbe:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':sich_verbeugende_frau_mittelhelle_hautfarbe:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':sich_verbeugende_frau_mittlere_hautfarbe:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':sich_verbeugende_frau_mitteldunkle_hautfarbe:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':sich_verbeugende_frau_dunkle_hautfarbe:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':sich_an_den_kopf_fassende_person:': u'\U0001F926',
	u':sich_an_den_kopf_fassende_person_helle_hautfarbe:': u'\U0001F926\U0001F3FB',
	u':sich_an_den_kopf_fassende_person_mittelhelle_hautfarbe:': u'\U0001F926\U0001F3FC',
	u':sich_an_den_kopf_fassende_person_mittlere_hautfarbe:': u'\U0001F926\U0001F3FD',
	u':sich_an_den_kopf_fassende_person_mitteldunkle_hautfarbe:': u'\U0001F926\U0001F3FE',
	u':sich_an_den_kopf_fassende_person_dunkle_hautfarbe:': u'\U0001F926\U0001F3FF',
	u':sich_an_den_kopf_fassender_mann:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
	u':sich_an_den_kopf_fassender_mann_helle_hautfarbe:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':sich_an_den_kopf_fassender_mann_mittelhelle_hautfarbe:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':sich_an_den_kopf_fassender_mann_mittlere_hautfarbe:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':sich_an_den_kopf_fassender_mann_mitteldunkle_hautfarbe:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':sich_an_den_kopf_fassender_mann_dunkle_hautfarbe:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':sich_an_den_kopf_fassende_frau:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
	u':sich_an_den_kopf_fassende_frau_helle_hautfarbe:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':sich_an_den_kopf_fassende_frau_mittelhelle_hautfarbe:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':sich_an_den_kopf_fassende_frau_mittlere_hautfarbe:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':sich_an_den_kopf_fassende_frau_mitteldunkle_hautfarbe:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':sich_an_den_kopf_fassende_frau_dunkle_hautfarbe:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':schulterzuckende_person:': u'\U0001F937',
	u':schulterzuckende_person_helle_hautfarbe:': u'\U0001F937\U0001F3FB',
	u':schulterzuckende_person_mittelhelle_hautfarbe:': u'\U0001F937\U0001F3FC',
	u':schulterzuckende_person_mittlere_hautfarbe:': u'\U0001F937\U0001F3FD',
	u':schulterzuckende_person_mitteldunkle_hautfarbe:': u'\U0001F937\U0001F3FE',
	u':schulterzuckende_person_dunkle_hautfarbe:': u'\U0001F937\U0001F3FF',
	u':schulterzuckender_mann:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
	u':schulterzuckender_mann_helle_hautfarbe:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':schulterzuckender_mann_mittelhelle_hautfarbe:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':schulterzuckender_mann_mittlere_hautfarbe:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':schulterzuckender_mann_mitteldunkle_hautfarbe:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':schulterzuckender_mann_dunkle_hautfarbe:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':schulterzuckende_frau:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
	u':schulterzuckende_frau_helle_hautfarbe:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':schulterzuckende_frau_mittelhelle_hautfarbe:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':schulterzuckende_frau_mittlere_hautfarbe:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':schulterzuckende_frau_mitteldunkle_hautfarbe:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':schulterzuckende_frau_dunkle_hautfarbe:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':arzt/ärztin:': u'\U0001F9D1\U0000200D\U00002695\U0000FE0F',
	u':arzt/ärztin_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002695\U0000FE0F',
	u':arzt/ärztin_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002695\U0000FE0F',
	u':arzt/ärztin_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002695\U0000FE0F',
	u':arzt/ärztin_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002695\U0000FE0F',
	u':arzt/ärztin_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002695\U0000FE0F',
	u':arzt:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
	u':arzt_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
	u':arzt_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
	u':arzt_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
	u':arzt_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
	u':arzt_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
	u':ärztin:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
	u':ärztin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
	u':ärztin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
	u':ärztin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
	u':ärztin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
	u':ärztin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
	u':student(in):': u'\U0001F9D1\U0000200D\U0001F393',
	u':student(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F393',
	u':student(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F393',
	u':student(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F393',
	u':student(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F393',
	u':student(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F393',
	u':student:': u'\U0001F468\U0000200D\U0001F393',
	u':student_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
	u':student_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
	u':student_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
	u':student_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
	u':student_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
	u':studentin:': u'\U0001F469\U0000200D\U0001F393',
	u':studentin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
	u':studentin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
	u':studentin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
	u':studentin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
	u':studentin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
	u':lehrer(in):': u'\U0001F9D1\U0000200D\U0001F3EB',
	u':lehrer(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3EB',
	u':lehrer(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3EB',
	u':lehrer(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3EB',
	u':lehrer(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3EB',
	u':lehrer(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3EB',
	u':lehrer:': u'\U0001F468\U0000200D\U0001F3EB',
	u':lehrer_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
	u':lehrer_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
	u':lehrer_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
	u':lehrer_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
	u':lehrer_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
	u':lehrerin:': u'\U0001F469\U0000200D\U0001F3EB',
	u':lehrerin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
	u':lehrerin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
	u':lehrerin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
	u':lehrerin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
	u':lehrerin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
	u':richter(in):': u'\U0001F9D1\U0000200D\U00002696\U0000FE0F',
	u':richter(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002696\U0000FE0F',
	u':richter(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002696\U0000FE0F',
	u':richter(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002696\U0000FE0F',
	u':richter(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002696\U0000FE0F',
	u':richter(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002696\U0000FE0F',
	u':richter:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
	u':richter_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
	u':richter_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
	u':richter_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
	u':richter_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
	u':richter_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
	u':richterin:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
	u':richterin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
	u':richterin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
	u':richterin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
	u':richterin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
	u':richterin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
	u':bauer/bäuerin:': u'\U0001F9D1\U0000200D\U0001F33E',
	u':bauer/bäuerin_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F33E',
	u':bauer/bäuerin_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F33E',
	u':bauer/bäuerin_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F33E',
	u':bauer/bäuerin_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F33E',
	u':bauer/bäuerin_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F33E',
	u':bauer:': u'\U0001F468\U0000200D\U0001F33E',
	u':bauer_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
	u':bauer_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
	u':bauer_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
	u':bauer_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
	u':bauer_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
	u':bäuerin:': u'\U0001F469\U0000200D\U0001F33E',
	u':bäuerin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
	u':bäuerin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
	u':bäuerin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
	u':bäuerin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
	u':bäuerin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
	u':koch/köchin:': u'\U0001F9D1\U0000200D\U0001F373',
	u':koch/köchin_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F373',
	u':koch/köchin_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F373',
	u':koch/köchin_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F373',
	u':koch/köchin_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F373',
	u':koch/köchin_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F373',
	u':koch:': u'\U0001F468\U0000200D\U0001F373',
	u':koch_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
	u':koch_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
	u':koch_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
	u':koch_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
	u':koch_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
	u':köchin:': u'\U0001F469\U0000200D\U0001F373',
	u':köchin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
	u':köchin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
	u':köchin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
	u':köchin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
	u':köchin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
	u':mechaniker(in):': u'\U0001F9D1\U0000200D\U0001F527',
	u':mechaniker(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F527',
	u':mechaniker(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F527',
	u':mechaniker(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F527',
	u':mechaniker(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F527',
	u':mechaniker(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F527',
	u':mechaniker:': u'\U0001F468\U0000200D\U0001F527',
	u':mechaniker_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
	u':mechaniker_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
	u':mechaniker_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
	u':mechaniker_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
	u':mechaniker_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
	u':mechanikerin:': u'\U0001F469\U0000200D\U0001F527',
	u':mechanikerin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
	u':mechanikerin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
	u':mechanikerin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
	u':mechanikerin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
	u':mechanikerin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
	u':fabrikarbeiter(in):': u'\U0001F9D1\U0000200D\U0001F3ED',
	u':fabrikarbeiter(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3ED',
	u':fabrikarbeiter(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3ED',
	u':fabrikarbeiter(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3ED',
	u':fabrikarbeiter(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3ED',
	u':fabrikarbeiter(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3ED',
	u':fabrikarbeiter:': u'\U0001F468\U0000200D\U0001F3ED',
	u':fabrikarbeiter_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
	u':fabrikarbeiter_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
	u':fabrikarbeiter_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
	u':fabrikarbeiter_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
	u':fabrikarbeiter_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
	u':fabrikarbeiterin:': u'\U0001F469\U0000200D\U0001F3ED',
	u':fabrikarbeiterin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
	u':fabrikarbeiterin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
	u':fabrikarbeiterin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
	u':fabrikarbeiterin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
	u':fabrikarbeiterin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
	u':büroangestellte(r):': u'\U0001F9D1\U0000200D\U0001F4BC',
	u':büroangestellte(r)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BC',
	u':büroangestellte(r)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BC',
	u':büroangestellte(r)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BC',
	u':büroangestellte(r)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BC',
	u':büroangestellte(r)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BC',
	u':büroangestellter:': u'\U0001F468\U0000200D\U0001F4BC',
	u':büroangestellter_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
	u':büroangestellter_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
	u':büroangestellter_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
	u':büroangestellter_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
	u':büroangestellter_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
	u':büroangestellte:': u'\U0001F469\U0000200D\U0001F4BC',
	u':büroangestellte_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
	u':büroangestellte_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
	u':büroangestellte_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
	u':büroangestellte_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
	u':büroangestellte_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
	u':wissenschaftler(in):': u'\U0001F9D1\U0000200D\U0001F52C',
	u':wissenschaftler(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F52C',
	u':wissenschaftler(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F52C',
	u':wissenschaftler(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F52C',
	u':wissenschaftler(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F52C',
	u':wissenschaftler(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F52C',
	u':wissenschaftler:': u'\U0001F468\U0000200D\U0001F52C',
	u':wissenschaftler_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
	u':wissenschaftler_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
	u':wissenschaftler_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
	u':wissenschaftler_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
	u':wissenschaftler_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
	u':wissenschaftlerin:': u'\U0001F469\U0000200D\U0001F52C',
	u':wissenschaftlerin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
	u':wissenschaftlerin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
	u':wissenschaftlerin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
	u':wissenschaftlerin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
	u':wissenschaftlerin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
	u':it-experte/it-expertin:': u'\U0001F9D1\U0000200D\U0001F4BB',
	u':it-experte/it-expertin_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BB',
	u':it-experte/it-expertin_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BB',
	u':it-experte/it-expertin_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BB',
	u':it-experte/it-expertin_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BB',
	u':it-experte/it-expertin_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BB',
	u':it-experte:': u'\U0001F468\U0000200D\U0001F4BB',
	u':it-experte_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
	u':it-experte_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
	u':it-experte_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
	u':it-experte_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
	u':it-experte_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
	u':it-expertin:': u'\U0001F469\U0000200D\U0001F4BB',
	u':it-expertin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
	u':it-expertin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
	u':it-expertin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
	u':it-expertin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
	u':it-expertin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
	u':sänger(in):': u'\U0001F9D1\U0000200D\U0001F3A4',
	u':sänger(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A4',
	u':sänger(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A4',
	u':sänger(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A4',
	u':sänger(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A4',
	u':sänger(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A4',
	u':sänger:': u'\U0001F468\U0000200D\U0001F3A4',
	u':sänger_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
	u':sänger_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
	u':sänger_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
	u':sänger_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
	u':sänger_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
	u':sängerin:': u'\U0001F469\U0000200D\U0001F3A4',
	u':sängerin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
	u':sängerin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
	u':sängerin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
	u':sängerin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
	u':sängerin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
	u':künstler(in):': u'\U0001F9D1\U0000200D\U0001F3A8',
	u':künstler(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A8',
	u':künstler(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A8',
	u':künstler(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A8',
	u':künstler(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A8',
	u':künstler(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A8',
	u':künstler:': u'\U0001F468\U0000200D\U0001F3A8',
	u':künstler_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
	u':künstler_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
	u':künstler_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
	u':künstler_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
	u':künstler_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
	u':künstlerin:': u'\U0001F469\U0000200D\U0001F3A8',
	u':künstlerin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
	u':künstlerin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
	u':künstlerin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
	u':künstlerin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
	u':künstlerin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
	u':pilot(in):': u'\U0001F9D1\U0000200D\U00002708\U0000FE0F',
	u':pilot(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002708\U0000FE0F',
	u':pilot(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002708\U0000FE0F',
	u':pilot(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002708\U0000FE0F',
	u':pilot(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002708\U0000FE0F',
	u':pilot(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002708\U0000FE0F',
	u':pilot:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
	u':pilot_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
	u':pilot_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
	u':pilot_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
	u':pilot_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
	u':pilot_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
	u':pilotin:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
	u':pilotin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
	u':pilotin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
	u':pilotin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
	u':pilotin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
	u':pilotin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
	u':astronaut(in):': u'\U0001F9D1\U0000200D\U0001F680',
	u':astronaut(in)_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F680',
	u':astronaut(in)_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F680',
	u':astronaut(in)_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F680',
	u':astronaut(in)_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F680',
	u':astronaut(in)_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F680',
	u':astronaut:': u'\U0001F468\U0000200D\U0001F680',
	u':astronaut_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
	u':astronaut_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
	u':astronaut_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
	u':astronaut_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
	u':astronaut_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
	u':astronautin:': u'\U0001F469\U0000200D\U0001F680',
	u':astronautin_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
	u':astronautin_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
	u':astronautin_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
	u':astronautin_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
	u':astronautin_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
	u':feuerwehrmann/-frau:': u'\U0001F9D1\U0000200D\U0001F692',
	u':feuerwehrmann/-frau_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F692',
	u':feuerwehrmann/-frau_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F692',
	u':feuerwehrmann/-frau_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F692',
	u':feuerwehrmann/-frau_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F692',
	u':feuerwehrmann/-frau_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F692',
	u':feuerwehrmann:': u'\U0001F468\U0000200D\U0001F692',
	u':feuerwehrmann_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
	u':feuerwehrmann_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
	u':feuerwehrmann_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
	u':feuerwehrmann_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
	u':feuerwehrmann_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
	u':feuerwehrfrau:': u'\U0001F469\U0000200D\U0001F692',
	u':feuerwehrfrau_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
	u':feuerwehrfrau_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
	u':feuerwehrfrau_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
	u':feuerwehrfrau_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
	u':feuerwehrfrau_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
	u':polizist(in):': u'\U0001F46E',
	u':polizist(in)_helle_hautfarbe:': u'\U0001F46E\U0001F3FB',
	u':polizist(in)_mittelhelle_hautfarbe:': u'\U0001F46E\U0001F3FC',
	u':polizist(in)_mittlere_hautfarbe:': u'\U0001F46E\U0001F3FD',
	u':polizist(in)_mitteldunkle_hautfarbe:': u'\U0001F46E\U0001F3FE',
	u':polizist(in)_dunkle_hautfarbe:': u'\U0001F46E\U0001F3FF',
	u':polizist:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
	u':polizist_helle_hautfarbe:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':polizist_mittelhelle_hautfarbe:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':polizist_mittlere_hautfarbe:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':polizist_mitteldunkle_hautfarbe:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':polizist_dunkle_hautfarbe:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':polizistin:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
	u':polizistin_helle_hautfarbe:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':polizistin_mittelhelle_hautfarbe:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':polizistin_mittlere_hautfarbe:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':polizistin_mitteldunkle_hautfarbe:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':polizistin_dunkle_hautfarbe:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':detektiv(in):': u'\U0001F575\U0000FE0F',
	u':detektiv(in)_helle_hautfarbe:': u'\U0001F575\U0001F3FB',
	u':detektiv(in)_mittelhelle_hautfarbe:': u'\U0001F575\U0001F3FC',
	u':detektiv(in)_mittlere_hautfarbe:': u'\U0001F575\U0001F3FD',
	u':detektiv(in)_mitteldunkle_hautfarbe:': u'\U0001F575\U0001F3FE',
	u':detektiv(in)_dunkle_hautfarbe:': u'\U0001F575\U0001F3FF',
	u':detektiv:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':detektiv_helle_hautfarbe:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':detektiv_mittelhelle_hautfarbe:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':detektiv_mittlere_hautfarbe:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':detektiv_mitteldunkle_hautfarbe:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':detektiv_dunkle_hautfarbe:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':detektivin:': u'\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':detektivin_helle_hautfarbe:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':detektivin_mittelhelle_hautfarbe:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':detektivin_mittlere_hautfarbe:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':detektivin_mitteldunkle_hautfarbe:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':detektivin_dunkle_hautfarbe:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':wachmann/wachfrau:': u'\U0001F482',
	u':wachmann/wachfrau_helle_hautfarbe:': u'\U0001F482\U0001F3FB',
	u':wachmann/wachfrau_mittelhelle_hautfarbe:': u'\U0001F482\U0001F3FC',
	u':wachmann/wachfrau_mittlere_hautfarbe:': u'\U0001F482\U0001F3FD',
	u':wachmann/wachfrau_mitteldunkle_hautfarbe:': u'\U0001F482\U0001F3FE',
	u':wachmann/wachfrau_dunkle_hautfarbe:': u'\U0001F482\U0001F3FF',
	u':wachmann:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
	u':wachmann_helle_hautfarbe:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':wachmann_mittelhelle_hautfarbe:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':wachmann_mittlere_hautfarbe:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':wachmann_mitteldunkle_hautfarbe:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':wachmann_dunkle_hautfarbe:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':wachfrau:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
	u':wachfrau_helle_hautfarbe:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':wachfrau_mittelhelle_hautfarbe:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':wachfrau_mittlere_hautfarbe:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':wachfrau_mitteldunkle_hautfarbe:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':wachfrau_dunkle_hautfarbe:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':ninja:': u'\U0001F977',
	u':ninja_helle_hautfarbe:': u'\U0001F977\U0001F3FB',
	u':ninja_mittelhelle_hautfarbe:': u'\U0001F977\U0001F3FC',
	u':ninja_mittlere_hautfarbe:': u'\U0001F977\U0001F3FD',
	u':ninja_mitteldunkle_hautfarbe:': u'\U0001F977\U0001F3FE',
	u':ninja_dunkle_hautfarbe:': u'\U0001F977\U0001F3FF',
	u':bauarbeiter(in):': u'\U0001F477',
	u':bauarbeiter(in)_helle_hautfarbe:': u'\U0001F477\U0001F3FB',
	u':bauarbeiter(in)_mittelhelle_hautfarbe:': u'\U0001F477\U0001F3FC',
	u':bauarbeiter(in)_mittlere_hautfarbe:': u'\U0001F477\U0001F3FD',
	u':bauarbeiter(in)_mitteldunkle_hautfarbe:': u'\U0001F477\U0001F3FE',
	u':bauarbeiter(in)_dunkle_hautfarbe:': u'\U0001F477\U0001F3FF',
	u':bauarbeiter:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
	u':bauarbeiter_helle_hautfarbe:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':bauarbeiter_mittelhelle_hautfarbe:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':bauarbeiter_mittlere_hautfarbe:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':bauarbeiter_mitteldunkle_hautfarbe:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':bauarbeiter_dunkle_hautfarbe:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':bauarbeiterin:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
	u':bauarbeiterin_helle_hautfarbe:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':bauarbeiterin_mittelhelle_hautfarbe:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':bauarbeiterin_mittlere_hautfarbe:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':bauarbeiterin_mitteldunkle_hautfarbe:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':bauarbeiterin_dunkle_hautfarbe:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':prinz:': u'\U0001F934',
	u':prinz_helle_hautfarbe:': u'\U0001F934\U0001F3FB',
	u':prinz_mittelhelle_hautfarbe:': u'\U0001F934\U0001F3FC',
	u':prinz_mittlere_hautfarbe:': u'\U0001F934\U0001F3FD',
	u':prinz_mitteldunkle_hautfarbe:': u'\U0001F934\U0001F3FE',
	u':prinz_dunkle_hautfarbe:': u'\U0001F934\U0001F3FF',
	u':prinzessin:': u'\U0001F478',
	u':prinzessin_helle_hautfarbe:': u'\U0001F478\U0001F3FB',
	u':prinzessin_mittelhelle_hautfarbe:': u'\U0001F478\U0001F3FC',
	u':prinzessin_mittlere_hautfarbe:': u'\U0001F478\U0001F3FD',
	u':prinzessin_mitteldunkle_hautfarbe:': u'\U0001F478\U0001F3FE',
	u':prinzessin_dunkle_hautfarbe:': u'\U0001F478\U0001F3FF',
	u':person_mit_turban:': u'\U0001F473',
	u':person_mit_turban_helle_hautfarbe:': u'\U0001F473\U0001F3FB',
	u':person_mit_turban_mittelhelle_hautfarbe:': u'\U0001F473\U0001F3FC',
	u':person_mit_turban_mittlere_hautfarbe:': u'\U0001F473\U0001F3FD',
	u':person_mit_turban_mitteldunkle_hautfarbe:': u'\U0001F473\U0001F3FE',
	u':person_mit_turban_dunkle_hautfarbe:': u'\U0001F473\U0001F3FF',
	u':mann_mit_turban:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_turban_helle_hautfarbe:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_turban_mittelhelle_hautfarbe:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_turban_mittlere_hautfarbe:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_turban_mitteldunkle_hautfarbe:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_turban_dunkle_hautfarbe:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_mit_turban:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_turban_helle_hautfarbe:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_turban_mittelhelle_hautfarbe:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_turban_mittlere_hautfarbe:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_turban_mitteldunkle_hautfarbe:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_turban_dunkle_hautfarbe:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':mann_mit_chinesischem_hut:': u'\U0001F472',
	u':mann_mit_chinesischem_hut_helle_hautfarbe:': u'\U0001F472\U0001F3FB',
	u':mann_mit_chinesischem_hut_mittelhelle_hautfarbe:': u'\U0001F472\U0001F3FC',
	u':mann_mit_chinesischem_hut_mittlere_hautfarbe:': u'\U0001F472\U0001F3FD',
	u':mann_mit_chinesischem_hut_mitteldunkle_hautfarbe:': u'\U0001F472\U0001F3FE',
	u':mann_mit_chinesischem_hut_dunkle_hautfarbe:': u'\U0001F472\U0001F3FF',
	u':frau_mit_kopftuch:': u'\U0001F9D5',
	u':frau_mit_kopftuch_helle_hautfarbe:': u'\U0001F9D5\U0001F3FB',
	u':frau_mit_kopftuch_mittelhelle_hautfarbe:': u'\U0001F9D5\U0001F3FC',
	u':frau_mit_kopftuch_mittlere_hautfarbe:': u'\U0001F9D5\U0001F3FD',
	u':frau_mit_kopftuch_mitteldunkle_hautfarbe:': u'\U0001F9D5\U0001F3FE',
	u':frau_mit_kopftuch_dunkle_hautfarbe:': u'\U0001F9D5\U0001F3FF',
	u':person_im_smoking:': u'\U0001F935',
	u':person_im_smoking_helle_hautfarbe:': u'\U0001F935\U0001F3FB',
	u':person_im_smoking_mittelhelle_hautfarbe:': u'\U0001F935\U0001F3FC',
	u':person_im_smoking_mittlere_hautfarbe:': u'\U0001F935\U0001F3FD',
	u':person_im_smoking_mitteldunkle_hautfarbe:': u'\U0001F935\U0001F3FE',
	u':person_im_smoking_dunkle_hautfarbe:': u'\U0001F935\U0001F3FF',
	u':mann_im_smoking:': u'\U0001F935\U0000200D\U00002642\U0000FE0F',
	u':mann_im_smoking_helle_hautfarbe:': u'\U0001F935\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_im_smoking_mittelhelle_hautfarbe:': u'\U0001F935\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_im_smoking_mittlere_hautfarbe:': u'\U0001F935\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_im_smoking_mitteldunkle_hautfarbe:': u'\U0001F935\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_im_smoking_dunkle_hautfarbe:': u'\U0001F935\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_im_smoking:': u'\U0001F935\U0000200D\U00002640\U0000FE0F',
	u':frau_im_smoking_helle_hautfarbe:': u'\U0001F935\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_im_smoking_mittelhelle_hautfarbe:': u'\U0001F935\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_im_smoking_mittlere_hautfarbe:': u'\U0001F935\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_im_smoking_mitteldunkle_hautfarbe:': u'\U0001F935\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_im_smoking_dunkle_hautfarbe:': u'\U0001F935\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_mit_schleier:': u'\U0001F470',
	u':person_mit_schleier_helle_hautfarbe:': u'\U0001F470\U0001F3FB',
	u':person_mit_schleier_mittelhelle_hautfarbe:': u'\U0001F470\U0001F3FC',
	u':person_mit_schleier_mittlere_hautfarbe:': u'\U0001F470\U0001F3FD',
	u':person_mit_schleier_mitteldunkle_hautfarbe:': u'\U0001F470\U0001F3FE',
	u':person_mit_schleier_dunkle_hautfarbe:': u'\U0001F470\U0001F3FF',
	u':mann_mit_schleier:': u'\U0001F470\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_schleier_helle_hautfarbe:': u'\U0001F470\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_schleier_mittelhelle_hautfarbe:': u'\U0001F470\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_schleier_mittlere_hautfarbe:': u'\U0001F470\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_schleier_mitteldunkle_hautfarbe:': u'\U0001F470\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_schleier_dunkle_hautfarbe:': u'\U0001F470\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_mit_schleier:': u'\U0001F470\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_schleier_helle_hautfarbe:': u'\U0001F470\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_schleier_mittelhelle_hautfarbe:': u'\U0001F470\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_schleier_mittlere_hautfarbe:': u'\U0001F470\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_schleier_mitteldunkle_hautfarbe:': u'\U0001F470\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_schleier_dunkle_hautfarbe:': u'\U0001F470\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':schwangere_frau:': u'\U0001F930',
	u':schwangere_frau_helle_hautfarbe:': u'\U0001F930\U0001F3FB',
	u':schwangere_frau_mittelhelle_hautfarbe:': u'\U0001F930\U0001F3FC',
	u':schwangere_frau_mittlere_hautfarbe:': u'\U0001F930\U0001F3FD',
	u':schwangere_frau_mitteldunkle_hautfarbe:': u'\U0001F930\U0001F3FE',
	u':schwangere_frau_dunkle_hautfarbe:': u'\U0001F930\U0001F3FF',
	u':stillen:': u'\U0001F931',
	u':stillen_helle_hautfarbe:': u'\U0001F931\U0001F3FB',
	u':stillen_mittelhelle_hautfarbe:': u'\U0001F931\U0001F3FC',
	u':stillen_mittlere_hautfarbe:': u'\U0001F931\U0001F3FD',
	u':stillen_mitteldunkle_hautfarbe:': u'\U0001F931\U0001F3FE',
	u':stillen_dunkle_hautfarbe:': u'\U0001F931\U0001F3FF',
	u':stillende_frau:': u'\U0001F469\U0000200D\U0001F37C',
	u':stillende_frau_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F37C',
	u':stillende_frau_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F37C',
	u':stillende_frau_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F37C',
	u':stillende_frau_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F37C',
	u':stillende_frau_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F37C',
	u':stillender_mann:': u'\U0001F468\U0000200D\U0001F37C',
	u':stillender_mann_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F37C',
	u':stillender_mann_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F37C',
	u':stillender_mann_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F37C',
	u':stillender_mann_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F37C',
	u':stillender_mann_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F37C',
	u':stillende_person:': u'\U0001F9D1\U0000200D\U0001F37C',
	u':stillende_person_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F37C',
	u':stillende_person_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F37C',
	u':stillende_person_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F37C',
	u':stillende_person_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F37C',
	u':stillende_person_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F37C',
	u':putte:': u'\U0001F47C',
	u':putte_helle_hautfarbe:': u'\U0001F47C\U0001F3FB',
	u':putte_mittelhelle_hautfarbe:': u'\U0001F47C\U0001F3FC',
	u':putte_mittlere_hautfarbe:': u'\U0001F47C\U0001F3FD',
	u':putte_mitteldunkle_hautfarbe:': u'\U0001F47C\U0001F3FE',
	u':putte_dunkle_hautfarbe:': u'\U0001F47C\U0001F3FF',
	u':weihnachtsmann:': u'\U0001F385',
	u':weihnachtsmann_helle_hautfarbe:': u'\U0001F385\U0001F3FB',
	u':weihnachtsmann_mittelhelle_hautfarbe:': u'\U0001F385\U0001F3FC',
	u':weihnachtsmann_mittlere_hautfarbe:': u'\U0001F385\U0001F3FD',
	u':weihnachtsmann_mitteldunkle_hautfarbe:': u'\U0001F385\U0001F3FE',
	u':weihnachtsmann_dunkle_hautfarbe:': u'\U0001F385\U0001F3FF',
	u':weihnachtsfrau:': u'\U0001F936',
	u':weihnachtsfrau_helle_hautfarbe:': u'\U0001F936\U0001F3FB',
	u':weihnachtsfrau_mittelhelle_hautfarbe:': u'\U0001F936\U0001F3FC',
	u':weihnachtsfrau_mittlere_hautfarbe:': u'\U0001F936\U0001F3FD',
	u':weihnachtsfrau_mitteldunkle_hautfarbe:': u'\U0001F936\U0001F3FE',
	u':weihnachtsfrau_dunkle_hautfarbe:': u'\U0001F936\U0001F3FF',
	u':weihnachtsperson:': u'\U0001F9D1\U0000200D\U0001F384',
	u':weihnachtsperson_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F384',
	u':weihnachtsperson_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F384',
	u':weihnachtsperson_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F384',
	u':weihnachtsperson_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F384',
	u':weihnachtsperson_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F384',
	u':held:': u'\U0001F9B8',
	u':held_helle_hautfarbe:': u'\U0001F9B8\U0001F3FB',
	u':held_mittelhelle_hautfarbe:': u'\U0001F9B8\U0001F3FC',
	u':held_mittlere_hautfarbe:': u'\U0001F9B8\U0001F3FD',
	u':held_mitteldunkle_hautfarbe:': u'\U0001F9B8\U0001F3FE',
	u':held_dunkle_hautfarbe:': u'\U0001F9B8\U0001F3FF',
	u':superheld:': u'\U0001F9B8\U0000200D\U00002642\U0000FE0F',
	u':superheld_helle_hautfarbe:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':superheld_mittelhelle_hautfarbe:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':superheld_mittlere_hautfarbe:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':superheld_mitteldunkle_hautfarbe:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':superheld_dunkle_hautfarbe:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':heldin:': u'\U0001F9B8\U0000200D\U00002640\U0000FE0F',
	u':heldin_helle_hautfarbe:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':heldin_mittelhelle_hautfarbe:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':heldin_mittlere_hautfarbe:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':heldin_mitteldunkle_hautfarbe:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':heldin_dunkle_hautfarbe:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':bösewicht:': u'\U0001F9B9',
	u':bösewicht_helle_hautfarbe:': u'\U0001F9B9\U0001F3FB',
	u':bösewicht_mittelhelle_hautfarbe:': u'\U0001F9B9\U0001F3FC',
	u':bösewicht_mittlere_hautfarbe:': u'\U0001F9B9\U0001F3FD',
	u':bösewicht_mitteldunkle_hautfarbe:': u'\U0001F9B9\U0001F3FE',
	u':bösewicht_dunkle_hautfarbe:': u'\U0001F9B9\U0001F3FF',
	u':männlicher_bösewicht:': u'\U0001F9B9\U0000200D\U00002642\U0000FE0F',
	u':männlicher_bösewicht_helle_hautfarbe:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':männlicher_bösewicht_mittelhelle_hautfarbe:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':männlicher_bösewicht_mittlere_hautfarbe:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':männlicher_bösewicht_mitteldunkle_hautfarbe:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':männlicher_bösewicht_dunkle_hautfarbe:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':weiblicher_bösewicht:': u'\U0001F9B9\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_bösewicht_helle_hautfarbe:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_bösewicht_mittelhelle_hautfarbe:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_bösewicht_mittlere_hautfarbe:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_bösewicht_mitteldunkle_hautfarbe:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_bösewicht_dunkle_hautfarbe:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':magier(in):': u'\U0001F9D9',
	u':magier(in)_helle_hautfarbe:': u'\U0001F9D9\U0001F3FB',
	u':magier(in)_mittelhelle_hautfarbe:': u'\U0001F9D9\U0001F3FC',
	u':magier(in)_mittlere_hautfarbe:': u'\U0001F9D9\U0001F3FD',
	u':magier(in)_mitteldunkle_hautfarbe:': u'\U0001F9D9\U0001F3FE',
	u':magier(in)_dunkle_hautfarbe:': u'\U0001F9D9\U0001F3FF',
	u':magier:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
	u':magier_helle_hautfarbe:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':magier_mittelhelle_hautfarbe:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':magier_mittlere_hautfarbe:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':magier_mitteldunkle_hautfarbe:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':magier_dunkle_hautfarbe:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':magierin:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
	u':magierin_helle_hautfarbe:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':magierin_mittelhelle_hautfarbe:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':magierin_mittlere_hautfarbe:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':magierin_mitteldunkle_hautfarbe:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':magierin_dunkle_hautfarbe:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':märchenfee:': u'\U0001F9DA',
	u':märchenfee_helle_hautfarbe:': u'\U0001F9DA\U0001F3FB',
	u':märchenfee_mittelhelle_hautfarbe:': u'\U0001F9DA\U0001F3FC',
	u':märchenfee_mittlere_hautfarbe:': u'\U0001F9DA\U0001F3FD',
	u':märchenfee_mitteldunkle_hautfarbe:': u'\U0001F9DA\U0001F3FE',
	u':märchenfee_dunkle_hautfarbe:': u'\U0001F9DA\U0001F3FF',
	u':männliche_fee:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
	u':männliche_fee_helle_hautfarbe:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':männliche_fee_mittelhelle_hautfarbe:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':männliche_fee_mittlere_hautfarbe:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':männliche_fee_mitteldunkle_hautfarbe:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':männliche_fee_dunkle_hautfarbe:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':fee:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
	u':fee_helle_hautfarbe:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':fee_mittelhelle_hautfarbe:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':fee_mittlere_hautfarbe:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':fee_mitteldunkle_hautfarbe:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':fee_dunkle_hautfarbe:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':vampir:': u'\U0001F9DB',
	u':vampir_helle_hautfarbe:': u'\U0001F9DB\U0001F3FB',
	u':vampir_mittelhelle_hautfarbe:': u'\U0001F9DB\U0001F3FC',
	u':vampir_mittlere_hautfarbe:': u'\U0001F9DB\U0001F3FD',
	u':vampir_mitteldunkle_hautfarbe:': u'\U0001F9DB\U0001F3FE',
	u':vampir_dunkle_hautfarbe:': u'\U0001F9DB\U0001F3FF',
	u':männlicher_vampir:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
	u':männlicher_vampir_helle_hautfarbe:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':männlicher_vampir_mittelhelle_hautfarbe:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':männlicher_vampir_mittlere_hautfarbe:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':männlicher_vampir_mitteldunkle_hautfarbe:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':männlicher_vampir_dunkle_hautfarbe:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':weiblicher_vampir:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_vampir_helle_hautfarbe:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_vampir_mittelhelle_hautfarbe:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_vampir_mittlere_hautfarbe:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_vampir_mitteldunkle_hautfarbe:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':weiblicher_vampir_dunkle_hautfarbe:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':wassermensch:': u'\U0001F9DC',
	u':wassermensch_helle_hautfarbe:': u'\U0001F9DC\U0001F3FB',
	u':wassermensch_mittelhelle_hautfarbe:': u'\U0001F9DC\U0001F3FC',
	u':wassermensch_mittlere_hautfarbe:': u'\U0001F9DC\U0001F3FD',
	u':wassermensch_mitteldunkle_hautfarbe:': u'\U0001F9DC\U0001F3FE',
	u':wassermensch_dunkle_hautfarbe:': u'\U0001F9DC\U0001F3FF',
	u':wassermann:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
	u':wassermann_helle_hautfarbe:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':wassermann_mittelhelle_hautfarbe:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':wassermann_mittlere_hautfarbe:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':wassermann_mitteldunkle_hautfarbe:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':wassermann_dunkle_hautfarbe:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':meerjungfrau:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
	u':meerjungfrau_helle_hautfarbe:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':meerjungfrau_mittelhelle_hautfarbe:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':meerjungfrau_mittlere_hautfarbe:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':meerjungfrau_mitteldunkle_hautfarbe:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':meerjungfrau_dunkle_hautfarbe:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':elf(e):': u'\U0001F9DD',
	u':elf(e)_helle_hautfarbe:': u'\U0001F9DD\U0001F3FB',
	u':elf(e)_mittelhelle_hautfarbe:': u'\U0001F9DD\U0001F3FC',
	u':elf(e)_mittlere_hautfarbe:': u'\U0001F9DD\U0001F3FD',
	u':elf(e)_mitteldunkle_hautfarbe:': u'\U0001F9DD\U0001F3FE',
	u':elf(e)_dunkle_hautfarbe:': u'\U0001F9DD\U0001F3FF',
	u':elf:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
	u':elf_helle_hautfarbe:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':elf_mittelhelle_hautfarbe:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':elf_mittlere_hautfarbe:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':elf_mitteldunkle_hautfarbe:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':elf_dunkle_hautfarbe:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':elfe:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
	u':elfe_helle_hautfarbe:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':elfe_mittelhelle_hautfarbe:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':elfe_mittlere_hautfarbe:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':elfe_mitteldunkle_hautfarbe:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':elfe_dunkle_hautfarbe:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':flaschengeist:': u'\U0001F9DE',
	u':männlicher_flaschengeist:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
	u':weiblicher_flaschengeist:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
	u':zombie:': u'\U0001F9DF',
	u':männlicher_zombie:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
	u':weiblicher_zombie:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
	u':person,_die_eine_kopfmassage_bekommt:': u'\U0001F486',
	u':person,_die_eine_kopfmassage_bekommt_helle_hautfarbe:': u'\U0001F486\U0001F3FB',
	u':person,_die_eine_kopfmassage_bekommt_mittelhelle_hautfarbe:': u'\U0001F486\U0001F3FC',
	u':person,_die_eine_kopfmassage_bekommt_mittlere_hautfarbe:': u'\U0001F486\U0001F3FD',
	u':person,_die_eine_kopfmassage_bekommt_mitteldunkle_hautfarbe:': u'\U0001F486\U0001F3FE',
	u':person,_die_eine_kopfmassage_bekommt_dunkle_hautfarbe:': u'\U0001F486\U0001F3FF',
	u':mann,_der_eine_kopfmassage_bekommt:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
	u':mann,_der_eine_kopfmassage_bekommt_helle_hautfarbe:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann,_der_eine_kopfmassage_bekommt_mittelhelle_hautfarbe:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann,_der_eine_kopfmassage_bekommt_mittlere_hautfarbe:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann,_der_eine_kopfmassage_bekommt_mitteldunkle_hautfarbe:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann,_der_eine_kopfmassage_bekommt_dunkle_hautfarbe:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau,_die_eine_kopfmassage_bekommt:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
	u':frau,_die_eine_kopfmassage_bekommt_helle_hautfarbe:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau,_die_eine_kopfmassage_bekommt_mittelhelle_hautfarbe:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau,_die_eine_kopfmassage_bekommt_mittlere_hautfarbe:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau,_die_eine_kopfmassage_bekommt_mitteldunkle_hautfarbe:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau,_die_eine_kopfmassage_bekommt_dunkle_hautfarbe:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_beim_haareschneiden:': u'\U0001F487',
	u':person_beim_haareschneiden_helle_hautfarbe:': u'\U0001F487\U0001F3FB',
	u':person_beim_haareschneiden_mittelhelle_hautfarbe:': u'\U0001F487\U0001F3FC',
	u':person_beim_haareschneiden_mittlere_hautfarbe:': u'\U0001F487\U0001F3FD',
	u':person_beim_haareschneiden_mitteldunkle_hautfarbe:': u'\U0001F487\U0001F3FE',
	u':person_beim_haareschneiden_dunkle_hautfarbe:': u'\U0001F487\U0001F3FF',
	u':mann_beim_haareschneiden:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
	u':mann_beim_haareschneiden_helle_hautfarbe:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_beim_haareschneiden_mittelhelle_hautfarbe:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_beim_haareschneiden_mittlere_hautfarbe:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_beim_haareschneiden_mitteldunkle_hautfarbe:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_beim_haareschneiden_dunkle_hautfarbe:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_beim_haareschneiden:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
	u':frau_beim_haareschneiden_helle_hautfarbe:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_beim_haareschneiden_mittelhelle_hautfarbe:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_beim_haareschneiden_mittlere_hautfarbe:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_beim_haareschneiden_mitteldunkle_hautfarbe:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_beim_haareschneiden_dunkle_hautfarbe:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':fußgänger(in):': u'\U0001F6B6',
	u':fußgänger(in)_helle_hautfarbe:': u'\U0001F6B6\U0001F3FB',
	u':fußgänger(in)_mittelhelle_hautfarbe:': u'\U0001F6B6\U0001F3FC',
	u':fußgänger(in)_mittlere_hautfarbe:': u'\U0001F6B6\U0001F3FD',
	u':fußgänger(in)_mitteldunkle_hautfarbe:': u'\U0001F6B6\U0001F3FE',
	u':fußgänger(in)_dunkle_hautfarbe:': u'\U0001F6B6\U0001F3FF',
	u':fußgänger:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
	u':fußgänger_helle_hautfarbe:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':fußgänger_mittelhelle_hautfarbe:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':fußgänger_mittlere_hautfarbe:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':fußgänger_mitteldunkle_hautfarbe:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':fußgänger_dunkle_hautfarbe:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':fußgängerin:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
	u':fußgängerin_helle_hautfarbe:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':fußgängerin_mittelhelle_hautfarbe:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':fußgängerin_mittlere_hautfarbe:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':fußgängerin_mitteldunkle_hautfarbe:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':fußgängerin_dunkle_hautfarbe:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':stehende_person:': u'\U0001F9CD',
	u':stehende_person_helle_hautfarbe:': u'\U0001F9CD\U0001F3FB',
	u':stehende_person_mittelhelle_hautfarbe:': u'\U0001F9CD\U0001F3FC',
	u':stehende_person_mittlere_hautfarbe:': u'\U0001F9CD\U0001F3FD',
	u':stehende_person_mitteldunkle_hautfarbe:': u'\U0001F9CD\U0001F3FE',
	u':stehende_person_dunkle_hautfarbe:': u'\U0001F9CD\U0001F3FF',
	u':stehender_mann:': u'\U0001F9CD\U0000200D\U00002642\U0000FE0F',
	u':stehender_mann_helle_hautfarbe:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':stehender_mann_mittelhelle_hautfarbe:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':stehender_mann_mittlere_hautfarbe:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':stehender_mann_mitteldunkle_hautfarbe:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':stehender_mann_dunkle_hautfarbe:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':stehende_frau:': u'\U0001F9CD\U0000200D\U00002640\U0000FE0F',
	u':stehende_frau_helle_hautfarbe:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':stehende_frau_mittelhelle_hautfarbe:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':stehende_frau_mittlere_hautfarbe:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':stehende_frau_mitteldunkle_hautfarbe:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':stehende_frau_dunkle_hautfarbe:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':kniende_person:': u'\U0001F9CE',
	u':kniende_person_helle_hautfarbe:': u'\U0001F9CE\U0001F3FB',
	u':kniende_person_mittelhelle_hautfarbe:': u'\U0001F9CE\U0001F3FC',
	u':kniende_person_mittlere_hautfarbe:': u'\U0001F9CE\U0001F3FD',
	u':kniende_person_mitteldunkle_hautfarbe:': u'\U0001F9CE\U0001F3FE',
	u':kniende_person_dunkle_hautfarbe:': u'\U0001F9CE\U0001F3FF',
	u':kniender_mann:': u'\U0001F9CE\U0000200D\U00002642\U0000FE0F',
	u':kniender_mann_helle_hautfarbe:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':kniender_mann_mittelhelle_hautfarbe:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':kniender_mann_mittlere_hautfarbe:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':kniender_mann_mitteldunkle_hautfarbe:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':kniender_mann_dunkle_hautfarbe:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':kniende_frau:': u'\U0001F9CE\U0000200D\U00002640\U0000FE0F',
	u':kniende_frau_helle_hautfarbe:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':kniende_frau_mittelhelle_hautfarbe:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':kniende_frau_mittlere_hautfarbe:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':kniende_frau_mitteldunkle_hautfarbe:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':kniende_frau_dunkle_hautfarbe:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_mit_gehstock:': u'\U0001F9D1\U0000200D\U0001F9AF',
	u':person_mit_gehstock_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9AF',
	u':person_mit_gehstock_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9AF',
	u':person_mit_gehstock_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9AF',
	u':person_mit_gehstock_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9AF',
	u':person_mit_gehstock_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9AF',
	u':mann_mit_gehstock:': u'\U0001F468\U0000200D\U0001F9AF',
	u':mann_mit_gehstock_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9AF',
	u':mann_mit_gehstock_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9AF',
	u':mann_mit_gehstock_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9AF',
	u':mann_mit_gehstock_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9AF',
	u':mann_mit_gehstock_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9AF',
	u':frau_mit_gehstock:': u'\U0001F469\U0000200D\U0001F9AF',
	u':frau_mit_gehstock_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9AF',
	u':frau_mit_gehstock_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9AF',
	u':frau_mit_gehstock_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9AF',
	u':frau_mit_gehstock_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9AF',
	u':frau_mit_gehstock_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9AF',
	u':person_in_motorisiertem_rollstuhl:': u'\U0001F9D1\U0000200D\U0001F9BC',
	u':person_in_motorisiertem_rollstuhl_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BC',
	u':person_in_motorisiertem_rollstuhl_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BC',
	u':person_in_motorisiertem_rollstuhl_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BC',
	u':person_in_motorisiertem_rollstuhl_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BC',
	u':person_in_motorisiertem_rollstuhl_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BC',
	u':mann_in_elektrischem_rollstuhl:': u'\U0001F468\U0000200D\U0001F9BC',
	u':mann_in_elektrischem_rollstuhl_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BC',
	u':mann_in_elektrischem_rollstuhl_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BC',
	u':mann_in_elektrischem_rollstuhl_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BC',
	u':mann_in_elektrischem_rollstuhl_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BC',
	u':mann_in_elektrischem_rollstuhl_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BC',
	u':frau_in_elektrischem_rollstuhl:': u'\U0001F469\U0000200D\U0001F9BC',
	u':frau_in_elektrischem_rollstuhl_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BC',
	u':frau_in_elektrischem_rollstuhl_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BC',
	u':frau_in_elektrischem_rollstuhl_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BC',
	u':frau_in_elektrischem_rollstuhl_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BC',
	u':frau_in_elektrischem_rollstuhl_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BC',
	u':person_in_manuellem_rollstuhl:': u'\U0001F9D1\U0000200D\U0001F9BD',
	u':person_in_manuellem_rollstuhl_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BD',
	u':person_in_manuellem_rollstuhl_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BD',
	u':person_in_manuellem_rollstuhl_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BD',
	u':person_in_manuellem_rollstuhl_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BD',
	u':person_in_manuellem_rollstuhl_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BD',
	u':mann_in_manuellem_rollstuhl:': u'\U0001F468\U0000200D\U0001F9BD',
	u':mann_in_manuellem_rollstuhl_helle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BD',
	u':mann_in_manuellem_rollstuhl_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BD',
	u':mann_in_manuellem_rollstuhl_mittlere_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BD',
	u':mann_in_manuellem_rollstuhl_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BD',
	u':mann_in_manuellem_rollstuhl_dunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BD',
	u':frau_in_manuellem_rollstuhl:': u'\U0001F469\U0000200D\U0001F9BD',
	u':frau_in_manuellem_rollstuhl_helle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BD',
	u':frau_in_manuellem_rollstuhl_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BD',
	u':frau_in_manuellem_rollstuhl_mittlere_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BD',
	u':frau_in_manuellem_rollstuhl_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BD',
	u':frau_in_manuellem_rollstuhl_dunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BD',
	u':laufende_person:': u'\U0001F3C3',
	u':laufende_person_helle_hautfarbe:': u'\U0001F3C3\U0001F3FB',
	u':laufende_person_mittelhelle_hautfarbe:': u'\U0001F3C3\U0001F3FC',
	u':laufende_person_mittlere_hautfarbe:': u'\U0001F3C3\U0001F3FD',
	u':laufende_person_mitteldunkle_hautfarbe:': u'\U0001F3C3\U0001F3FE',
	u':laufende_person_dunkle_hautfarbe:': u'\U0001F3C3\U0001F3FF',
	u':laufender_mann:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
	u':laufender_mann_helle_hautfarbe:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':laufender_mann_mittelhelle_hautfarbe:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':laufender_mann_mittlere_hautfarbe:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':laufender_mann_mitteldunkle_hautfarbe:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':laufender_mann_dunkle_hautfarbe:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':laufende_frau:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
	u':laufende_frau_helle_hautfarbe:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':laufende_frau_mittelhelle_hautfarbe:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':laufende_frau_mittlere_hautfarbe:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':laufende_frau_mitteldunkle_hautfarbe:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':laufende_frau_dunkle_hautfarbe:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':tanzende_frau:': u'\U0001F483',
	u':tanzende_frau_helle_hautfarbe:': u'\U0001F483\U0001F3FB',
	u':tanzende_frau_mittelhelle_hautfarbe:': u'\U0001F483\U0001F3FC',
	u':tanzende_frau_mittlere_hautfarbe:': u'\U0001F483\U0001F3FD',
	u':tanzende_frau_mitteldunkle_hautfarbe:': u'\U0001F483\U0001F3FE',
	u':tanzende_frau_dunkle_hautfarbe:': u'\U0001F483\U0001F3FF',
	u':tanzender_mann:': u'\U0001F57A',
	u':tanzender_mann_helle_hautfarbe:': u'\U0001F57A\U0001F3FB',
	u':tanzender_mann_mittelhelle_hautfarbe:': u'\U0001F57A\U0001F3FC',
	u':tanzender_mann_mittlere_hautfarbe:': u'\U0001F57A\U0001F3FD',
	u':tanzender_mann_mitteldunkle_hautfarbe:': u'\U0001F57A\U0001F3FE',
	u':tanzender_mann_dunkle_hautfarbe:': u'\U0001F57A\U0001F3FF',
	u':schwebender_mann_im_anzug:': u'\U0001F574\U0000FE0F',
	u':schwebender_mann_im_anzug_helle_hautfarbe:': u'\U0001F574\U0001F3FB',
	u':schwebender_mann_im_anzug_mittelhelle_hautfarbe:': u'\U0001F574\U0001F3FC',
	u':schwebender_mann_im_anzug_mittlere_hautfarbe:': u'\U0001F574\U0001F3FD',
	u':schwebender_mann_im_anzug_mitteldunkle_hautfarbe:': u'\U0001F574\U0001F3FE',
	u':schwebender_mann_im_anzug_dunkle_hautfarbe:': u'\U0001F574\U0001F3FF',
	u':personen_mit_hasenohren:': u'\U0001F46F',
	u':männer_mit_hasenohren:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
	u':frauen_mit_hasenohren:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
	u':person_in_dampfsauna:': u'\U0001F9D6',
	u':person_in_dampfsauna_helle_hautfarbe:': u'\U0001F9D6\U0001F3FB',
	u':person_in_dampfsauna_mittelhelle_hautfarbe:': u'\U0001F9D6\U0001F3FC',
	u':person_in_dampfsauna_mittlere_hautfarbe:': u'\U0001F9D6\U0001F3FD',
	u':person_in_dampfsauna_mitteldunkle_hautfarbe:': u'\U0001F9D6\U0001F3FE',
	u':person_in_dampfsauna_dunkle_hautfarbe:': u'\U0001F9D6\U0001F3FF',
	u':mann_in_dampfsauna:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
	u':mann_in_dampfsauna_helle_hautfarbe:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_in_dampfsauna_mittelhelle_hautfarbe:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_in_dampfsauna_mittlere_hautfarbe:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_in_dampfsauna_mitteldunkle_hautfarbe:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_in_dampfsauna_dunkle_hautfarbe:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_in_dampfsauna:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
	u':frau_in_dampfsauna_helle_hautfarbe:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_in_dampfsauna_mittelhelle_hautfarbe:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_in_dampfsauna_mittlere_hautfarbe:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_in_dampfsauna_mitteldunkle_hautfarbe:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_in_dampfsauna_dunkle_hautfarbe:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':bergsteiger(in):': u'\U0001F9D7',
	u':bergsteiger(in)_helle_hautfarbe:': u'\U0001F9D7\U0001F3FB',
	u':bergsteiger(in)_mittelhelle_hautfarbe:': u'\U0001F9D7\U0001F3FC',
	u':bergsteiger(in)_mittlere_hautfarbe:': u'\U0001F9D7\U0001F3FD',
	u':bergsteiger(in)_mitteldunkle_hautfarbe:': u'\U0001F9D7\U0001F3FE',
	u':bergsteiger(in)_dunkle_hautfarbe:': u'\U0001F9D7\U0001F3FF',
	u':bergsteiger:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
	u':bergsteiger_helle_hautfarbe:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':bergsteiger_mittelhelle_hautfarbe:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':bergsteiger_mittlere_hautfarbe:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':bergsteiger_mitteldunkle_hautfarbe:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':bergsteiger_dunkle_hautfarbe:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':bergsteigerin:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
	u':bergsteigerin_helle_hautfarbe:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':bergsteigerin_mittelhelle_hautfarbe:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':bergsteigerin_mittlere_hautfarbe:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':bergsteigerin_mitteldunkle_hautfarbe:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':bergsteigerin_dunkle_hautfarbe:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':fechter(in):': u'\U0001F93A',
	u':pferderennen:': u'\U0001F3C7',
	u':pferderennen_helle_hautfarbe:': u'\U0001F3C7\U0001F3FB',
	u':pferderennen_mittelhelle_hautfarbe:': u'\U0001F3C7\U0001F3FC',
	u':pferderennen_mittlere_hautfarbe:': u'\U0001F3C7\U0001F3FD',
	u':pferderennen_mitteldunkle_hautfarbe:': u'\U0001F3C7\U0001F3FE',
	u':pferderennen_dunkle_hautfarbe:': u'\U0001F3C7\U0001F3FF',
	u':skifahrer(in):': u'\U000026F7\U0000FE0F',
	u':snowboarder(in):': u'\U0001F3C2',
	u':snowboarder(in)_helle_hautfarbe:': u'\U0001F3C2\U0001F3FB',
	u':snowboarder(in)_mittelhelle_hautfarbe:': u'\U0001F3C2\U0001F3FC',
	u':snowboarder(in)_mittlere_hautfarbe:': u'\U0001F3C2\U0001F3FD',
	u':snowboarder(in)_mitteldunkle_hautfarbe:': u'\U0001F3C2\U0001F3FE',
	u':snowboarder(in)_dunkle_hautfarbe:': u'\U0001F3C2\U0001F3FF',
	u':golfer(in):': u'\U0001F3CC\U0000FE0F',
	u':golfer(in)_helle_hautfarbe:': u'\U0001F3CC\U0001F3FB',
	u':golfer(in)_mittelhelle_hautfarbe:': u'\U0001F3CC\U0001F3FC',
	u':golfer(in)_mittlere_hautfarbe:': u'\U0001F3CC\U0001F3FD',
	u':golfer(in)_mitteldunkle_hautfarbe:': u'\U0001F3CC\U0001F3FE',
	u':golfer(in)_dunkle_hautfarbe:': u'\U0001F3CC\U0001F3FF',
	u':golfer:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':golfer_helle_hautfarbe:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':golfer_mittelhelle_hautfarbe:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':golfer_mittlere_hautfarbe:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':golfer_mitteldunkle_hautfarbe:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':golfer_dunkle_hautfarbe:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':golferin:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':golferin_helle_hautfarbe:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':golferin_mittelhelle_hautfarbe:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':golferin_mittlere_hautfarbe:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':golferin_mitteldunkle_hautfarbe:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':golferin_dunkle_hautfarbe:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':surfer(in):': u'\U0001F3C4',
	u':surfer(in)_helle_hautfarbe:': u'\U0001F3C4\U0001F3FB',
	u':surfer(in)_mittelhelle_hautfarbe:': u'\U0001F3C4\U0001F3FC',
	u':surfer(in)_mittlere_hautfarbe:': u'\U0001F3C4\U0001F3FD',
	u':surfer(in)_mitteldunkle_hautfarbe:': u'\U0001F3C4\U0001F3FE',
	u':surfer(in)_dunkle_hautfarbe:': u'\U0001F3C4\U0001F3FF',
	u':surfer:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
	u':surfer_helle_hautfarbe:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':surfer_mittelhelle_hautfarbe:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':surfer_mittlere_hautfarbe:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':surfer_mitteldunkle_hautfarbe:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':surfer_dunkle_hautfarbe:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':surferin:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
	u':surferin_helle_hautfarbe:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':surferin_mittelhelle_hautfarbe:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':surferin_mittlere_hautfarbe:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':surferin_mitteldunkle_hautfarbe:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':surferin_dunkle_hautfarbe:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_im_ruderboot:': u'\U0001F6A3',
	u':person_im_ruderboot_helle_hautfarbe:': u'\U0001F6A3\U0001F3FB',
	u':person_im_ruderboot_mittelhelle_hautfarbe:': u'\U0001F6A3\U0001F3FC',
	u':person_im_ruderboot_mittlere_hautfarbe:': u'\U0001F6A3\U0001F3FD',
	u':person_im_ruderboot_mitteldunkle_hautfarbe:': u'\U0001F6A3\U0001F3FE',
	u':person_im_ruderboot_dunkle_hautfarbe:': u'\U0001F6A3\U0001F3FF',
	u':mann_im_ruderboot:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
	u':mann_im_ruderboot_helle_hautfarbe:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_im_ruderboot_mittelhelle_hautfarbe:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_im_ruderboot_mittlere_hautfarbe:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_im_ruderboot_mitteldunkle_hautfarbe:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_im_ruderboot_dunkle_hautfarbe:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_im_ruderboot:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
	u':frau_im_ruderboot_helle_hautfarbe:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_im_ruderboot_mittelhelle_hautfarbe:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_im_ruderboot_mittlere_hautfarbe:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_im_ruderboot_mitteldunkle_hautfarbe:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_im_ruderboot_dunkle_hautfarbe:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':schwimmer(in):': u'\U0001F3CA',
	u':schwimmer(in)_helle_hautfarbe:': u'\U0001F3CA\U0001F3FB',
	u':schwimmer(in)_mittelhelle_hautfarbe:': u'\U0001F3CA\U0001F3FC',
	u':schwimmer(in)_mittlere_hautfarbe:': u'\U0001F3CA\U0001F3FD',
	u':schwimmer(in)_mitteldunkle_hautfarbe:': u'\U0001F3CA\U0001F3FE',
	u':schwimmer(in)_dunkle_hautfarbe:': u'\U0001F3CA\U0001F3FF',
	u':schwimmer:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
	u':schwimmer_helle_hautfarbe:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':schwimmer_mittelhelle_hautfarbe:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':schwimmer_mittlere_hautfarbe:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':schwimmer_mitteldunkle_hautfarbe:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':schwimmer_dunkle_hautfarbe:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':schwimmerin:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
	u':schwimmerin_helle_hautfarbe:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':schwimmerin_mittelhelle_hautfarbe:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':schwimmerin_mittlere_hautfarbe:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':schwimmerin_mitteldunkle_hautfarbe:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':schwimmerin_dunkle_hautfarbe:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_mit_ball:': u'\U000026F9\U0000FE0F',
	u':person_mit_ball_helle_hautfarbe:': u'\U000026F9\U0001F3FB',
	u':person_mit_ball_mittelhelle_hautfarbe:': u'\U000026F9\U0001F3FC',
	u':person_mit_ball_mittlere_hautfarbe:': u'\U000026F9\U0001F3FD',
	u':person_mit_ball_mitteldunkle_hautfarbe:': u'\U000026F9\U0001F3FE',
	u':person_mit_ball_dunkle_hautfarbe:': u'\U000026F9\U0001F3FF',
	u':mann_mit_ball:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_ball_helle_hautfarbe:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_ball_mittelhelle_hautfarbe:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_ball_mittlere_hautfarbe:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_ball_mitteldunkle_hautfarbe:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_mit_ball_dunkle_hautfarbe:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_mit_ball:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_ball_helle_hautfarbe:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_ball_mittelhelle_hautfarbe:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_ball_mittlere_hautfarbe:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_ball_mitteldunkle_hautfarbe:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_mit_ball_dunkle_hautfarbe:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':gewichtheber(in):': u'\U0001F3CB\U0000FE0F',
	u':gewichtheber(in)_helle_hautfarbe:': u'\U0001F3CB\U0001F3FB',
	u':gewichtheber(in)_mittelhelle_hautfarbe:': u'\U0001F3CB\U0001F3FC',
	u':gewichtheber(in)_mittlere_hautfarbe:': u'\U0001F3CB\U0001F3FD',
	u':gewichtheber(in)_mitteldunkle_hautfarbe:': u'\U0001F3CB\U0001F3FE',
	u':gewichtheber(in)_dunkle_hautfarbe:': u'\U0001F3CB\U0001F3FF',
	u':gewichtheber:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
	u':gewichtheber_helle_hautfarbe:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':gewichtheber_mittelhelle_hautfarbe:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':gewichtheber_mittlere_hautfarbe:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':gewichtheber_mitteldunkle_hautfarbe:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':gewichtheber_dunkle_hautfarbe:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':gewichtheberin:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
	u':gewichtheberin_helle_hautfarbe:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':gewichtheberin_mittelhelle_hautfarbe:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':gewichtheberin_mittlere_hautfarbe:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':gewichtheberin_mitteldunkle_hautfarbe:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':gewichtheberin_dunkle_hautfarbe:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':radfahrer(in):': u'\U0001F6B4',
	u':radfahrer(in)_helle_hautfarbe:': u'\U0001F6B4\U0001F3FB',
	u':radfahrer(in)_mittelhelle_hautfarbe:': u'\U0001F6B4\U0001F3FC',
	u':radfahrer(in)_mittlere_hautfarbe:': u'\U0001F6B4\U0001F3FD',
	u':radfahrer(in)_mitteldunkle_hautfarbe:': u'\U0001F6B4\U0001F3FE',
	u':radfahrer(in)_dunkle_hautfarbe:': u'\U0001F6B4\U0001F3FF',
	u':radfahrer:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
	u':radfahrer_helle_hautfarbe:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':radfahrer_mittelhelle_hautfarbe:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':radfahrer_mittlere_hautfarbe:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':radfahrer_mitteldunkle_hautfarbe:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':radfahrer_dunkle_hautfarbe:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':radfahrerin:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
	u':radfahrerin_helle_hautfarbe:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':radfahrerin_mittelhelle_hautfarbe:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':radfahrerin_mittlere_hautfarbe:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':radfahrerin_mitteldunkle_hautfarbe:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':radfahrerin_dunkle_hautfarbe:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':mountainbiker(in):': u'\U0001F6B5',
	u':mountainbiker(in)_helle_hautfarbe:': u'\U0001F6B5\U0001F3FB',
	u':mountainbiker(in)_mittelhelle_hautfarbe:': u'\U0001F6B5\U0001F3FC',
	u':mountainbiker(in)_mittlere_hautfarbe:': u'\U0001F6B5\U0001F3FD',
	u':mountainbiker(in)_mitteldunkle_hautfarbe:': u'\U0001F6B5\U0001F3FE',
	u':mountainbiker(in)_dunkle_hautfarbe:': u'\U0001F6B5\U0001F3FF',
	u':mountainbiker:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
	u':mountainbiker_helle_hautfarbe:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mountainbiker_mittelhelle_hautfarbe:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mountainbiker_mittlere_hautfarbe:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mountainbiker_mitteldunkle_hautfarbe:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mountainbiker_dunkle_hautfarbe:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':mountainbikerin:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
	u':mountainbikerin_helle_hautfarbe:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':mountainbikerin_mittelhelle_hautfarbe:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':mountainbikerin_mittlere_hautfarbe:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':mountainbikerin_mitteldunkle_hautfarbe:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':mountainbikerin_dunkle_hautfarbe:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':rad_schlagende_person:': u'\U0001F938',
	u':rad_schlagende_person_helle_hautfarbe:': u'\U0001F938\U0001F3FB',
	u':rad_schlagende_person_mittelhelle_hautfarbe:': u'\U0001F938\U0001F3FC',
	u':rad_schlagende_person_mittlere_hautfarbe:': u'\U0001F938\U0001F3FD',
	u':rad_schlagende_person_mitteldunkle_hautfarbe:': u'\U0001F938\U0001F3FE',
	u':rad_schlagende_person_dunkle_hautfarbe:': u'\U0001F938\U0001F3FF',
	u':rad_schlagender_mann:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
	u':rad_schlagender_mann_helle_hautfarbe:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':rad_schlagender_mann_mittelhelle_hautfarbe:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':rad_schlagender_mann_mittlere_hautfarbe:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':rad_schlagender_mann_mitteldunkle_hautfarbe:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':rad_schlagender_mann_dunkle_hautfarbe:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':rad_schlagende_frau:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
	u':rad_schlagende_frau_helle_hautfarbe:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':rad_schlagende_frau_mittelhelle_hautfarbe:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':rad_schlagende_frau_mittlere_hautfarbe:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':rad_schlagende_frau_mitteldunkle_hautfarbe:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':rad_schlagende_frau_dunkle_hautfarbe:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':ringer(in):': u'\U0001F93C',
	u':ringende_männer:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
	u':ringende_frauen:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
	u':wasserballspieler(in):': u'\U0001F93D',
	u':wasserballspieler(in)_helle_hautfarbe:': u'\U0001F93D\U0001F3FB',
	u':wasserballspieler(in)_mittelhelle_hautfarbe:': u'\U0001F93D\U0001F3FC',
	u':wasserballspieler(in)_mittlere_hautfarbe:': u'\U0001F93D\U0001F3FD',
	u':wasserballspieler(in)_mitteldunkle_hautfarbe:': u'\U0001F93D\U0001F3FE',
	u':wasserballspieler(in)_dunkle_hautfarbe:': u'\U0001F93D\U0001F3FF',
	u':wasserballspieler:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
	u':wasserballspieler_helle_hautfarbe:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':wasserballspieler_mittelhelle_hautfarbe:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':wasserballspieler_mittlere_hautfarbe:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':wasserballspieler_mitteldunkle_hautfarbe:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':wasserballspieler_dunkle_hautfarbe:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':wasserballspielerin:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
	u':wasserballspielerin_helle_hautfarbe:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':wasserballspielerin_mittelhelle_hautfarbe:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':wasserballspielerin_mittlere_hautfarbe:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':wasserballspielerin_mitteldunkle_hautfarbe:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':wasserballspielerin_dunkle_hautfarbe:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':handballspieler(in):': u'\U0001F93E',
	u':handballspieler(in)_helle_hautfarbe:': u'\U0001F93E\U0001F3FB',
	u':handballspieler(in)_mittelhelle_hautfarbe:': u'\U0001F93E\U0001F3FC',
	u':handballspieler(in)_mittlere_hautfarbe:': u'\U0001F93E\U0001F3FD',
	u':handballspieler(in)_mitteldunkle_hautfarbe:': u'\U0001F93E\U0001F3FE',
	u':handballspieler(in)_dunkle_hautfarbe:': u'\U0001F93E\U0001F3FF',
	u':handballspieler:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
	u':handballspieler_helle_hautfarbe:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':handballspieler_mittelhelle_hautfarbe:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':handballspieler_mittlere_hautfarbe:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':handballspieler_mitteldunkle_hautfarbe:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':handballspieler_dunkle_hautfarbe:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':handballspielerin:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
	u':handballspielerin_helle_hautfarbe:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':handballspielerin_mittelhelle_hautfarbe:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':handballspielerin_mittlere_hautfarbe:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':handballspielerin_mitteldunkle_hautfarbe:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':handballspielerin_dunkle_hautfarbe:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':jongleur(in):': u'\U0001F939',
	u':jongleur(in)_helle_hautfarbe:': u'\U0001F939\U0001F3FB',
	u':jongleur(in)_mittelhelle_hautfarbe:': u'\U0001F939\U0001F3FC',
	u':jongleur(in)_mittlere_hautfarbe:': u'\U0001F939\U0001F3FD',
	u':jongleur(in)_mitteldunkle_hautfarbe:': u'\U0001F939\U0001F3FE',
	u':jongleur(in)_dunkle_hautfarbe:': u'\U0001F939\U0001F3FF',
	u':jongleur:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
	u':jongleur_helle_hautfarbe:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':jongleur_mittelhelle_hautfarbe:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':jongleur_mittlere_hautfarbe:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':jongleur_mitteldunkle_hautfarbe:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':jongleur_dunkle_hautfarbe:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':jongleurin:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
	u':jongleurin_helle_hautfarbe:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':jongleurin_mittelhelle_hautfarbe:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':jongleurin_mittlere_hautfarbe:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':jongleurin_mitteldunkle_hautfarbe:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':jongleurin_dunkle_hautfarbe:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':person_im_lotossitz:': u'\U0001F9D8',
	u':person_im_lotossitz_helle_hautfarbe:': u'\U0001F9D8\U0001F3FB',
	u':person_im_lotossitz_mittelhelle_hautfarbe:': u'\U0001F9D8\U0001F3FC',
	u':person_im_lotossitz_mittlere_hautfarbe:': u'\U0001F9D8\U0001F3FD',
	u':person_im_lotossitz_mitteldunkle_hautfarbe:': u'\U0001F9D8\U0001F3FE',
	u':person_im_lotossitz_dunkle_hautfarbe:': u'\U0001F9D8\U0001F3FF',
	u':mann_im_lotossitz:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
	u':mann_im_lotossitz_helle_hautfarbe:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
	u':mann_im_lotossitz_mittelhelle_hautfarbe:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
	u':mann_im_lotossitz_mittlere_hautfarbe:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
	u':mann_im_lotossitz_mitteldunkle_hautfarbe:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
	u':mann_im_lotossitz_dunkle_hautfarbe:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
	u':frau_im_lotossitz:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
	u':frau_im_lotossitz_helle_hautfarbe:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
	u':frau_im_lotossitz_mittelhelle_hautfarbe:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
	u':frau_im_lotossitz_mittlere_hautfarbe:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
	u':frau_im_lotossitz_mitteldunkle_hautfarbe:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
	u':frau_im_lotossitz_dunkle_hautfarbe:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
	u':badende_person:': u'\U0001F6C0',
	u':badende_person_helle_hautfarbe:': u'\U0001F6C0\U0001F3FB',
	u':badende_person_mittelhelle_hautfarbe:': u'\U0001F6C0\U0001F3FC',
	u':badende_person_mittlere_hautfarbe:': u'\U0001F6C0\U0001F3FD',
	u':badende_person_mitteldunkle_hautfarbe:': u'\U0001F6C0\U0001F3FE',
	u':badende_person_dunkle_hautfarbe:': u'\U0001F6C0\U0001F3FF',
	u':im_bett_liegende_person:': u'\U0001F6CC',
	u':im_bett_liegende_person_helle_hautfarbe:': u'\U0001F6CC\U0001F3FB',
	u':im_bett_liegende_person_mittelhelle_hautfarbe:': u'\U0001F6CC\U0001F3FC',
	u':im_bett_liegende_person_mittlere_hautfarbe:': u'\U0001F6CC\U0001F3FD',
	u':im_bett_liegende_person_mitteldunkle_hautfarbe:': u'\U0001F6CC\U0001F3FE',
	u':im_bett_liegende_person_dunkle_hautfarbe:': u'\U0001F6CC\U0001F3FF',
	u':sich_an_den_händen_haltende_personen:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
	u':sich_an_den_händen_haltende_personen_helle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':sich_an_den_händen_haltende_personen_helle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':sich_an_den_händen_haltende_personen_helle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':sich_an_den_händen_haltende_personen_helle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':sich_an_den_händen_haltende_personen_helle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':sich_an_den_händen_haltende_personen_mittelhelle_hautfarbe,_helle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':sich_an_den_händen_haltende_personen_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':sich_an_den_händen_haltende_personen_mittelhelle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':sich_an_den_händen_haltende_personen_mittelhelle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':sich_an_den_händen_haltende_personen_mittelhelle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':sich_an_den_händen_haltende_personen_mittlere_hautfarbe,_helle_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':sich_an_den_händen_haltende_personen_mittlere_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':sich_an_den_händen_haltende_personen_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':sich_an_den_händen_haltende_personen_mittlere_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':sich_an_den_händen_haltende_personen_mittlere_hautfarbe,_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':sich_an_den_händen_haltende_personen_mitteldunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':sich_an_den_händen_haltende_personen_mitteldunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':sich_an_den_händen_haltende_personen_mitteldunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':sich_an_den_händen_haltende_personen_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':sich_an_den_händen_haltende_personen_mitteldunkle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':sich_an_den_händen_haltende_personen_dunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
	u':sich_an_den_händen_haltende_personen_dunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
	u':sich_an_den_händen_haltende_personen_dunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
	u':sich_an_den_händen_haltende_personen_dunkle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
	u':sich_an_den_händen_haltende_personen_dunkle_hautfarbe:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
	u':händchenhaltende_frauen:': u'\U0001F46D',
	u':händchenhaltende_frauen_helle_hautfarbe:': u'\U0001F46D\U0001F3FB',
	u':händchenhaltende_frauen_helle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':händchenhaltende_frauen_helle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':händchenhaltende_frauen_helle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':händchenhaltende_frauen_helle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':händchenhaltende_frauen_mittelhelle_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':händchenhaltende_frauen_mittelhelle_hautfarbe:': u'\U0001F46D\U0001F3FC',
	u':händchenhaltende_frauen_mittelhelle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':händchenhaltende_frauen_mittelhelle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':händchenhaltende_frauen_mittelhelle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':händchenhaltende_frauen_mittlere_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':händchenhaltende_frauen_mittlere_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':händchenhaltende_frauen_mittlere_hautfarbe:': u'\U0001F46D\U0001F3FD',
	u':händchenhaltende_frauen_mittlere_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':händchenhaltende_frauen_mittlere_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':händchenhaltende_frauen_mitteldunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':händchenhaltende_frauen_mitteldunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':händchenhaltende_frauen_mitteldunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':händchenhaltende_frauen_mitteldunkle_hautfarbe:': u'\U0001F46D\U0001F3FE',
	u':händchenhaltende_frauen_mitteldunkle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
	u':händchenhaltende_frauen_dunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
	u':händchenhaltende_frauen_dunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
	u':händchenhaltende_frauen_dunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
	u':händchenhaltende_frauen_dunkle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
	u':händchenhaltende_frauen_dunkle_hautfarbe:': u'\U0001F46D\U0001F3FF',
	u':mann_und_frau_halten_hände:': u'\U0001F46B',
	u':mann_und_frau_halten_hände_helle_hautfarbe:': u'\U0001F46B\U0001F3FB',
	u':mann_und_frau_halten_hände_helle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':mann_und_frau_halten_hände_helle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':mann_und_frau_halten_hände_helle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':mann_und_frau_halten_hände_helle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':mann_und_frau_halten_hände_mittelhelle_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':mann_und_frau_halten_hände_mittelhelle_hautfarbe:': u'\U0001F46B\U0001F3FC',
	u':mann_und_frau_halten_hände_mittelhelle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':mann_und_frau_halten_hände_mittelhelle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':mann_und_frau_halten_hände_mittelhelle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':mann_und_frau_halten_hände_mittlere_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':mann_und_frau_halten_hände_mittlere_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':mann_und_frau_halten_hände_mittlere_hautfarbe:': u'\U0001F46B\U0001F3FD',
	u':mann_und_frau_halten_hände_mittlere_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':mann_und_frau_halten_hände_mittlere_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':mann_und_frau_halten_hände_mitteldunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':mann_und_frau_halten_hände_mitteldunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':mann_und_frau_halten_hände_mitteldunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':mann_und_frau_halten_hände_mitteldunkle_hautfarbe:': u'\U0001F46B\U0001F3FE',
	u':mann_und_frau_halten_hände_mitteldunkle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':mann_und_frau_halten_hände_dunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':mann_und_frau_halten_hände_dunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':mann_und_frau_halten_hände_dunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':mann_und_frau_halten_hände_dunkle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':mann_und_frau_halten_hände_dunkle_hautfarbe:': u'\U0001F46B\U0001F3FF',
	u':händchenhaltende_männer:': u'\U0001F46C',
	u':händchenhaltende_männer_helle_hautfarbe:': u'\U0001F46C\U0001F3FB',
	u':händchenhaltende_männer_helle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':händchenhaltende_männer_helle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':händchenhaltende_männer_helle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':händchenhaltende_männer_helle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':händchenhaltende_männer_mittelhelle_hautfarbe,_helle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':händchenhaltende_männer_mittelhelle_hautfarbe:': u'\U0001F46C\U0001F3FC',
	u':händchenhaltende_männer_mittelhelle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':händchenhaltende_männer_mittelhelle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':händchenhaltende_männer_mittelhelle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':händchenhaltende_männer_mittlere_hautfarbe,_helle_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':händchenhaltende_männer_mittlere_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':händchenhaltende_männer_mittlere_hautfarbe:': u'\U0001F46C\U0001F3FD',
	u':händchenhaltende_männer_mittlere_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':händchenhaltende_männer_mittlere_hautfarbe,_dunkle_hautfarbe:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':händchenhaltende_männer_mitteldunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':händchenhaltende_männer_mitteldunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':händchenhaltende_männer_mitteldunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':händchenhaltende_männer_mitteldunkle_hautfarbe:': u'\U0001F46C\U0001F3FE',
	u':händchenhaltende_männer_mitteldunkle_hautfarbe,_dunkle_hautfarbe:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
	u':händchenhaltende_männer_dunkle_hautfarbe,_helle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
	u':händchenhaltende_männer_dunkle_hautfarbe,_mittelhelle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
	u':händchenhaltende_männer_dunkle_hautfarbe,_mittlere_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
	u':händchenhaltende_männer_dunkle_hautfarbe,_mitteldunkle_hautfarbe:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
	u':händchenhaltende_männer_dunkle_hautfarbe:': u'\U0001F46C\U0001F3FF',
	u':sich_küssendes_paar:': u'\U0001F48F',
	u':sich_küssendes_paar_frau,_mann:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
	u':sich_küssendes_paar_mann,_mann:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
	u':sich_küssendes_paar_frau,_frau:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
	u':liebespaar:': u'\U0001F491',
	u':liebespaar_frau,_mann:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
	u':liebespaar_mann,_mann:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
	u':liebespaar_frau,_frau:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
	u':familie:': u'\U0001F46A',
	u':familie_mann,_frau_und_junge:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
	u':familie_mann,_frau_und_mädchen:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
	u':familie_mann,_frau,_mädchen_und_junge:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
	u':familie_mann,_frau,_junge_und_junge:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
	u':familie_mann,_frau,_mädchen_und_mädchen:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
	u':familie_mann,_mann_und_junge:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
	u':familie_mann,_mann_und_mädchen:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
	u':familie_mann,_mann,_mädchen_und_junge:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
	u':familie_mann,_mann,_junge_und_junge:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
	u':familie_mann,_mann,_mädchen_und_mädchen:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
	u':familie_frau,_frau_und_junge:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
	u':familie_frau,_frau_und_mädchen:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
	u':familie_frau,_frau,_mädchen_und_junge:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
	u':familie_frau,_frau,_junge_und_junge:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
	u':familie_frau,_frau,_mädchen_und_mädchen:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
	u':familie_mann,_junge:': u'\U0001F468\U0000200D\U0001F466',
	u':familie_mann,_junge_und_junge:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
	u':familie_mann,_mädchen:': u'\U0001F468\U0000200D\U0001F467',
	u':familie_mann,_mädchen_und_junge:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
	u':familie_mann,_mädchen_und_mädchen:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
	u':familie_frau,_junge:': u'\U0001F469\U0000200D\U0001F466',
	u':familie_frau,_junge_und_junge:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
	u':familie_frau,_mädchen:': u'\U0001F469\U0000200D\U0001F467',
	u':familie_frau,_mädchen_und_junge:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
	u':familie_frau,_mädchen_und_mädchen:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
	u':sprechender_kopf:': u'\U0001F5E3\U0000FE0F',
	u':silhouette_einer_büste:': u'\U0001F464',
	u':silhouette_mehrerer_büsten:': u'\U0001F465',
	u':sich_umarmende_personen:': u'\U0001FAC2',
	u':fußabdrücke:': u'\U0001F463',
	u':helle_hautfarbe:': u'\U0001F3FB',
	u':mittelhelle_hautfarbe:': u'\U0001F3FC',
	u':mittlere_hautfarbe:': u'\U0001F3FD',
	u':mitteldunkle_hautfarbe:': u'\U0001F3FE',
	u':dunkle_hautfarbe:': u'\U0001F3FF',
	u':rotes_haar:': u'\U0001F9B0',
	u':lockiges_haar:': u'\U0001F9B1',
	u':weißes_haar:': u'\U0001F9B3',
	u':glatze:': u'\U0001F9B2',
	u':affengesicht:': u'\U0001F435',
	u':affe:': u'\U0001F412',
	u':gorilla:': u'\U0001F98D',
	u':orang-utan:': u'\U0001F9A7',
	u':hundegesicht:': u'\U0001F436',
	u':hund:': u'\U0001F415',
	u':blindenhund:': u'\U0001F9AE',
	u':assistenzhund:': u'\U0001F415\U0000200D\U0001F9BA',
	u':pudel:': u'\U0001F429',
	u':wolf:': u'\U0001F43A',
	u':fuchs:': u'\U0001F98A',
	u':waschbär:': u'\U0001F99D',
	u':katzengesicht:': u'\U0001F431',
	u':katze:': u'\U0001F408',
	u':schwarze_katze:': u'\U0001F408\U0000200D\U00002B1B',
	u':löwe:': u'\U0001F981',
	u':tigergesicht:': u'\U0001F42F',
	u':tiger:': u'\U0001F405',
	u':leopard:': u'\U0001F406',
	u':pferdegesicht:': u'\U0001F434',
	u':pferd:': u'\U0001F40E',
	u':einhorn:': u'\U0001F984',
	u':zebra:': u'\U0001F993',
	u':hirsch:': u'\U0001F98C',
	u':bison:': u'\U0001F9AC',
	u':kuhgesicht:': u'\U0001F42E',
	u':ochse:': u'\U0001F402',
	u':wasserbüffel:': u'\U0001F403',
	u':kuh:': u'\U0001F404',
	u':schweinegesicht:': u'\U0001F437',
	u':schwein:': u'\U0001F416',
	u':wildschwein:': u'\U0001F417',
	u':schweinerüssel:': u'\U0001F43D',
	u':widder:': u'\U0001F40F',
	u':schaf:': u'\U0001F411',
	u':ziege:': u'\U0001F410',
	u':dromedar:': u'\U0001F42A',
	u':kamel:': u'\U0001F42B',
	u':lama:': u'\U0001F999',
	u':giraffe:': u'\U0001F992',
	u':elefant:': u'\U0001F418',
	u':mammut:': u'\U0001F9A3',
	u':nashorn:': u'\U0001F98F',
	u':nilpferd:': u'\U0001F99B',
	u':mäusegesicht:': u'\U0001F42D',
	u':maus:': u'\U0001F401',
	u':ratte:': u'\U0001F400',
	u':hamster:': u'\U0001F439',
	u':hasengesicht:': u'\U0001F430',
	u':hase:': u'\U0001F407',
	u':streifenhörnchen:': u'\U0001F43F\U0000FE0F',
	u':biber:': u'\U0001F9AB',
	u':igel:': u'\U0001F994',
	u':fledermaus:': u'\U0001F987',
	u':bär:': u'\U0001F43B',
	u':eisbär:': u'\U0001F43B\U0000200D\U00002744\U0000FE0F',
	u':koala:': u'\U0001F428',
	u':panda:': u'\U0001F43C',
	u':faultier:': u'\U0001F9A5',
	u':otter:': u'\U0001F9A6',
	u':stinktier:': u'\U0001F9A8',
	u':känguru:': u'\U0001F998',
	u':dachs:': u'\U0001F9A1',
	u':tatzenabdrücke:': u'\U0001F43E',
	u':truthahn:': u'\U0001F983',
	u':huhn:': u'\U0001F414',
	u':hahn:': u'\U0001F413',
	u':schlüpfendes_küken:': u'\U0001F423',
	u':küken:': u'\U0001F424',
	u':küken_von_vorne:': u'\U0001F425',
	u':vogel:': u'\U0001F426',
	u':pinguin:': u'\U0001F427',
	u':taube:': u'\U0001F54A\U0000FE0F',
	u':adler:': u'\U0001F985',
	u':ente:': u'\U0001F986',
	u':schwan:': u'\U0001F9A2',
	u':eule:': u'\U0001F989',
	u':dodo:': u'\U0001F9A4',
	u':feder:': u'\U0001FAB6',
	u':flamingo:': u'\U0001F9A9',
	u':pfau:': u'\U0001F99A',
	u':papagei:': u'\U0001F99C',
	u':frosch:': u'\U0001F438',
	u':krokodil:': u'\U0001F40A',
	u':schildkröte:': u'\U0001F422',
	u':eidechse:': u'\U0001F98E',
	u':schlange:': u'\U0001F40D',
	u':drachengesicht:': u'\U0001F432',
	u':drache:': u'\U0001F409',
	u':sauropode:': u'\U0001F995',
	u':t-rex:': u'\U0001F996',
	u':blasender_wal:': u'\U0001F433',
	u':wal:': u'\U0001F40B',
	u':delfin:': u'\U0001F42C',
	u':seehund:': u'\U0001F9AD',
	u':fisch:': u'\U0001F41F',
	u':tropenfisch:': u'\U0001F420',
	u':kugelfisch:': u'\U0001F421',
	u':hai:': u'\U0001F988',
	u':oktopus:': u'\U0001F419',
	u':schneckenhaus:': u'\U0001F41A',
	u':schnecke:': u'\U0001F40C',
	u':schmetterling:': u'\U0001F98B',
	u':raupe:': u'\U0001F41B',
	u':ameise:': u'\U0001F41C',
	u':biene:': u'\U0001F41D',
	u':käfer:': u'\U0001FAB2',
	u':marienkäfer:': u'\U0001F41E',
	u':grille:': u'\U0001F997',
	u':kakerlake:': u'\U0001FAB3',
	u':spinne:': u'\U0001F577\U0000FE0F',
	u':spinnennetz:': u'\U0001F578\U0000FE0F',
	u':skorpion:': u'\U0001F982',
	u':moskito:': u'\U0001F99F',
	u':fliege:': u'\U0001FAB0',
	u':wurm:': u'\U0001FAB1',
	u':mikrobe:': u'\U0001F9A0',
	u':blumenstrauß:': u'\U0001F490',
	u':kirschblüte:': u'\U0001F338',
	u':blumenstempel:': u'\U0001F4AE',
	u':rosette:': u'\U0001F3F5\U0000FE0F',
	u':rose:': u'\U0001F339',
	u':welke_blume:': u'\U0001F940',
	u':hibiskus:': u'\U0001F33A',
	u':sonnenblume:': u'\U0001F33B',
	u':gelbe_blüte:': u'\U0001F33C',
	u':tulpe:': u'\U0001F337',
	u':spross:': u'\U0001F331',
	u':topfpflanze:': u'\U0001FAB4',
	u':nadelbaum:': u'\U0001F332',
	u':laubbaum:': u'\U0001F333',
	u':palme:': u'\U0001F334',
	u':kaktus:': u'\U0001F335',
	u':reisähre:': u'\U0001F33E',
	u':kräuter:': u'\U0001F33F',
	u':kleeblatt:': u'\U00002618\U0000FE0F',
	u':glücksklee:': u'\U0001F340',
	u':ahornblatt:': u'\U0001F341',
	u':laub:': u'\U0001F342',
	u':blätter_im_wind:': u'\U0001F343',
	u':trauben:': u'\U0001F347',
	u':honigmelone:': u'\U0001F348',
	u':wassermelone:': u'\U0001F349',
	u':mandarine:': u'\U0001F34A',
	u':zitrone:': u'\U0001F34B',
	u':banane:': u'\U0001F34C',
	u':ananas:': u'\U0001F34D',
	u':mango:': u'\U0001F96D',
	u':roter_apfel:': u'\U0001F34E',
	u':grüner_apfel:': u'\U0001F34F',
	u':birne:': u'\U0001F350',
	u':pfirsich:': u'\U0001F351',
	u':kirschen:': u'\U0001F352',
	u':erdbeere:': u'\U0001F353',
	u':blaubeeren:': u'\U0001FAD0',
	u':kiwi:': u'\U0001F95D',
	u':tomate:': u'\U0001F345',
	u':olive:': u'\U0001FAD2',
	u':kokosnuss:': u'\U0001F965',
	u':avocado:': u'\U0001F951',
	u':aubergine:': u'\U0001F346',
	u':kartoffel:': u'\U0001F954',
	u':karotte:': u'\U0001F955',
	u':maiskolben:': u'\U0001F33D',
	u':peperoni:': u'\U0001F336\U0000FE0F',
	u':paprika:': u'\U0001FAD1',
	u':gurke:': u'\U0001F952',
	u':grünzeug:': u'\U0001F96C',
	u':brokkoli:': u'\U0001F966',
	u':knoblauch:': u'\U0001F9C4',
	u':zwiebel:': u'\U0001F9C5',
	u':fliegenpilz:': u'\U0001F344',
	u':erdnuss:': u'\U0001F95C',
	u':kastanie:': u'\U0001F330',
	u':brot:': u'\U0001F35E',
	u':croissant:': u'\U0001F950',
	u':baguette:': u'\U0001F956',
	u':fladenbrot:': u'\U0001FAD3',
	u':brezel:': u'\U0001F968',
	u':bagel:': u'\U0001F96F',
	u':pfannkuchen:': u'\U0001F95E',
	u':waffel:': u'\U0001F9C7',
	u':käsestück:': u'\U0001F9C0',
	u':fleischhachse:': u'\U0001F356',
	u':hähnchenschenkel:': u'\U0001F357',
	u':fleischstück:': u'\U0001F969',
	u':bacon:': u'\U0001F953',
	u':hamburger:': u'\U0001F354',
	u':pommes_frites:': u'\U0001F35F',
	u':pizza:': u'\U0001F355',
	u':hotdog:': u'\U0001F32D',
	u':sandwich:': u'\U0001F96A',
	u':taco:': u'\U0001F32E',
	u':burrito:': u'\U0001F32F',
	u':tamale:': u'\U0001FAD4',
	u':döner:': u'\U0001F959',
	u':falafel:': u'\U0001F9C6',
	u':ei:': u'\U0001F95A',
	u':spiegelei_in_bratpfanne:': u'\U0001F373',
	u':pfannengericht:': u'\U0001F958',
	u':topf_mit_essen:': u'\U0001F372',
	u':fondue:': u'\U0001FAD5',
	u':schüssel_mit_löffel:': u'\U0001F963',
	u':salat:': u'\U0001F957',
	u':popcorn:': u'\U0001F37F',
	u':butter:': u'\U0001F9C8',
	u':salz:': u'\U0001F9C2',
	u':konserve:': u'\U0001F96B',
	u':bento-box:': u'\U0001F371',
	u':reiscracker:': u'\U0001F358',
	u':reisbällchen:': u'\U0001F359',
	u':reis_in_schüssel:': u'\U0001F35A',
	u':reis_mit_curry:': u'\U0001F35B',
	u':schüssel_und_essstäbchen:': u'\U0001F35C',
	u':spaghetti:': u'\U0001F35D',
	u':geröstete_süßkartoffel:': u'\U0001F360',
	u':oden:': u'\U0001F362',
	u':sushi:': u'\U0001F363',
	u':frittierte_garnele:': u'\U0001F364',
	u':fischfrikadelle:': u'\U0001F365',
	u':mondkuchen:': u'\U0001F96E',
	u':dango:': u'\U0001F361',
	u':teigtasche:': u'\U0001F95F',
	u':glückskeks:': u'\U0001F960',
	u':takeaway-schachtel:': u'\U0001F961',
	u':krebs:': u'\U0001F980',
	u':hummer:': u'\U0001F99E',
	u':garnele:': u'\U0001F990',
	u':tintenfisch:': u'\U0001F991',
	u':auster:': u'\U0001F9AA',
	u':softeis:': u'\U0001F366',
	u':wassereis:': u'\U0001F367',
	u':eiscreme:': u'\U0001F368',
	u':donut:': u'\U0001F369',
	u':keks:': u'\U0001F36A',
	u':geburtstagskuchen:': u'\U0001F382',
	u':torte:': u'\U0001F370',
	u':cupcake:': u'\U0001F9C1',
	u':kuchen:': u'\U0001F967',
	u':schokoladentafel:': u'\U0001F36B',
	u':bonbon:': u'\U0001F36C',
	u':lutscher:': u'\U0001F36D',
	u':pudding:': u'\U0001F36E',
	u':honigtopf:': u'\U0001F36F',
	u':babyflasche:': u'\U0001F37C',
	u':glas_milch:': u'\U0001F95B',
	u':heißgetränk:': u'\U00002615',
	u':teekanne:': u'\U0001FAD6',
	u':teetasse_ohne_henkel:': u'\U0001F375',
	u':sake-flasche_und_-tasse:': u'\U0001F376',
	u':flasche_mit_knallendem_korken:': u'\U0001F37E',
	u':weinglas:': u'\U0001F377',
	u':cocktailglas:': u'\U0001F378',
	u':cocktail:': u'\U0001F379',
	u':bierkrug:': u'\U0001F37A',
	u':bierkrüge:': u'\U0001F37B',
	u':sektgläser:': u'\U0001F942',
	u':trinkglas:': u'\U0001F943',
	u':becher_mit_strohhalm:': u'\U0001F964',
	u':bubble_tea:': u'\U0001F9CB',
	u':trinkpäckchen:': u'\U0001F9C3',
	u':mate-tee:': u'\U0001F9C9',
	u':eiswürfel:': u'\U0001F9CA',
	u':essstäbchen:': u'\U0001F962',
	u':teller_mit_messer_und_gabel:': u'\U0001F37D\U0000FE0F',
	u':gabel_und_messer:': u'\U0001F374',
	u':löffel:': u'\U0001F944',
	u':küchenmesser:': u'\U0001F52A',
	u':amphore:': u'\U0001F3FA',
	u':globus_mit_europa_und_afrika:': u'\U0001F30D',
	u':globus_mit_amerika:': u'\U0001F30E',
	u':globus_mit_asien_und_australien:': u'\U0001F30F',
	u':globus_mit_meridianen:': u'\U0001F310',
	u':weltkarte:': u'\U0001F5FA\U0000FE0F',
	u':umriss_von_japan:': u'\U0001F5FE',
	u':kompass:': u'\U0001F9ED',
	u':schneebedeckter_berg:': u'\U0001F3D4\U0000FE0F',
	u':berg:': u'\U000026F0\U0000FE0F',
	u':vulkan:': u'\U0001F30B',
	u':fuji:': u'\U0001F5FB',
	u':camping:': u'\U0001F3D5\U0000FE0F',
	u':strand_mit_sonnenschirm:': u'\U0001F3D6\U0000FE0F',
	u':wüste:': u'\U0001F3DC\U0000FE0F',
	u':einsame_insel:': u'\U0001F3DD\U0000FE0F',
	u':nationalpark:': u'\U0001F3DE\U0000FE0F',
	u':stadion:': u'\U0001F3DF\U0000FE0F',
	u':antikes_gebäude:': u'\U0001F3DB\U0000FE0F',
	u':kran:': u'\U0001F3D7\U0000FE0F',
	u':ziegelstein:': u'\U0001F9F1',
	u':felsen:': u'\U0001FAA8',
	u':holz:': u'\U0001FAB5',
	u':hütte:': u'\U0001F6D6',
	u':wohnhäuser:': u'\U0001F3D8\U0000FE0F',
	u':verfallenes_haus:': u'\U0001F3DA\U0000FE0F',
	u':haus:': u'\U0001F3E0',
	u':haus_mit_garten:': u'\U0001F3E1',
	u':bürogebäude:': u'\U0001F3E2',
	u':japanisches_postgebäude:': u'\U0001F3E3',
	u':postgebäude:': u'\U0001F3E4',
	u':krankenhaus:': u'\U0001F3E5',
	u':bank:': u'\U0001F3E6',
	u':hotel:': u'\U0001F3E8',
	u':stundenhotel:': u'\U0001F3E9',
	u':bedarfsartikelgeschäft:': u'\U0001F3EA',
	u':schule:': u'\U0001F3EB',
	u':kaufhaus:': u'\U0001F3EC',
	u':fabrik:': u'\U0001F3ED',
	u':japanisches_schloss:': u'\U0001F3EF',
	u':schloss:': u'\U0001F3F0',
	u':hochzeit:': u'\U0001F492',
	u':tokyo_tower:': u'\U0001F5FC',
	u':freiheitsstatue:': u'\U0001F5FD',
	u':kirche:': u'\U000026EA',
	u':moschee:': u'\U0001F54C',
	u':hindutempel:': u'\U0001F6D5',
	u':synagoge:': u'\U0001F54D',
	u':shinto-schrein:': u'\U000026E9\U0000FE0F',
	u':kaaba:': u'\U0001F54B',
	u':springbrunnen:': u'\U000026F2',
	u':zelt:': u'\U000026FA',
	u':neblig:': u'\U0001F301',
	u':sternenhimmel:': u'\U0001F303',
	u':skyline:': u'\U0001F3D9\U0000FE0F',
	u':sonnenaufgang_über_bergen:': u'\U0001F304',
	u':sonnenaufgang_über_dem_meer:': u'\U0001F305',
	u':abendstimmung_in_der_stadt:': u'\U0001F306',
	u':sonnenuntergang_in_der_stadt:': u'\U0001F307',
	u':brücke_vor_nachthimmel:': u'\U0001F309',
	u':heiße_quellen:': u'\U00002668\U0000FE0F',
	u':karussellpferd:': u'\U0001F3A0',
	u':riesenrad:': u'\U0001F3A1',
	u':achterbahn:': u'\U0001F3A2',
	u':barbershop-säule:': u'\U0001F488',
	u':zirkuszelt:': u'\U0001F3AA',
	u':dampflokomotive:': u'\U0001F682',
	u':straßenbahnwagen:': u'\U0001F683',
	u':hochgeschwindigkeitszug_mit_spitzer_nase:': u'\U0001F684',
	u':hochgeschwindigkeitszug:': u'\U0001F685',
	u':zug:': u'\U0001F686',
	u':u-bahn:': u'\U0001F687',
	u':s-bahn:': u'\U0001F688',
	u':bahnhof:': u'\U0001F689',
	u':straßenbahn:': u'\U0001F68A',
	u':einschienenbahn:': u'\U0001F69D',
	u':bergbahn:': u'\U0001F69E',
	u':tramwagen:': u'\U0001F68B',
	u':bus:': u'\U0001F68C',
	u':vorderansicht_bus:': u'\U0001F68D',
	u':oberleitungsbus:': u'\U0001F68E',
	u':kleinbus:': u'\U0001F690',
	u':krankenwagen:': u'\U0001F691',
	u':feuerwehrauto:': u'\U0001F692',
	u':polizeiwagen:': u'\U0001F693',
	u':vorderansicht_polizeiwagen:': u'\U0001F694',
	u':taxi:': u'\U0001F695',
	u':vorderansicht_taxi:': u'\U0001F696',
	u':auto:': u'\U0001F697',
	u':vorderansicht_auto:': u'\U0001F698',
	u':wohnmobil:': u'\U0001F699',
	u':pick-up:': u'\U0001F6FB',
	u':lieferwagen:': u'\U0001F69A',
	u':sattelzug:': u'\U0001F69B',
	u':traktor:': u'\U0001F69C',
	u':rennauto:': u'\U0001F3CE\U0000FE0F',
	u':motorrad:': u'\U0001F3CD\U0000FE0F',
	u':motorroller:': u'\U0001F6F5',
	u':manueller_rollstuhl:': u'\U0001F9BD',
	u':elektrischer_rollstuhl:': u'\U0001F9BC',
	u':autorikscha:': u'\U0001F6FA',
	u':fahrrad:': u'\U0001F6B2',
	u':tretroller:': u'\U0001F6F4',
	u':skateboard:': u'\U0001F6F9',
	u':rollschuh:': u'\U0001F6FC',
	u':bushaltestelle:': u'\U0001F68F',
	u':autobahn:': u'\U0001F6E3\U0000FE0F',
	u':bahngleis:': u'\U0001F6E4\U0000FE0F',
	u':ölfass:': u'\U0001F6E2\U0000FE0F',
	u':tanksäule:': u'\U000026FD',
	u':polizeilicht:': u'\U0001F6A8',
	u':horizontale_verkehrsampel:': u'\U0001F6A5',
	u':vertikale_verkehrsampel:': u'\U0001F6A6',
	u':stoppschild:': u'\U0001F6D1',
	u':baustellenschild:': u'\U0001F6A7',
	u':anker:': u'\U00002693',
	u':segelboot:': u'\U000026F5',
	u':kanu:': u'\U0001F6F6',
	u':schnellboot:': u'\U0001F6A4',
	u':passagierschiff:': u'\U0001F6F3\U0000FE0F',
	u':fähre:': u'\U000026F4\U0000FE0F',
	u':motorboot:': u'\U0001F6E5\U0000FE0F',
	u':schiff:': u'\U0001F6A2',
	u':flugzeug:': u'\U00002708\U0000FE0F',
	u':kleines_flugzeug:': u'\U0001F6E9\U0000FE0F',
	u':abflug:': u'\U0001F6EB',
	u':landung_eines_flugzeugs:': u'\U0001F6EC',
	u':fallschirm:': u'\U0001FA82',
	u':sitzplatz:': u'\U0001F4BA',
	u':hubschrauber:': u'\U0001F681',
	u':schwebebahn:': u'\U0001F69F',
	u':bergschwebebahn:': u'\U0001F6A0',
	u':bergseilbahn:': u'\U0001F6A1',
	u':satellit:': u'\U0001F6F0\U0000FE0F',
	u':rakete:': u'\U0001F680',
	u':fliegende_untertasse:': u'\U0001F6F8',
	u':rezeptionsklingel:': u'\U0001F6CE\U0000FE0F',
	u':gepäck:': u'\U0001F9F3',
	u':sanduhr:': u'\U0000231B',
	u':laufende_sanduhr:': u'\U000023F3',
	u':armbanduhr:': u'\U0000231A',
	u':wecker:': u'\U000023F0',
	u':stoppuhr:': u'\U000023F1\U0000FE0F',
	u':zeitschaltuhr:': u'\U000023F2\U0000FE0F',
	u':kaminuhr:': u'\U0001F570\U0000FE0F',
	u':ziffernblatt_12.00_uhr:': u'\U0001F55B',
	u':12.30_uhr:': u'\U0001F567',
	u':1.00_uhr:': u'\U0001F550',
	u':1.30_uhr:': u'\U0001F55C',
	u':2.00_uhr:': u'\U0001F551',
	u':2.30_uhr:': u'\U0001F55D',
	u':3.00_uhr:': u'\U0001F552',
	u':3.30_uhr:': u'\U0001F55E',
	u':4.00_uhr:': u'\U0001F553',
	u':4.30_uhr:': u'\U0001F55F',
	u':5.00_uhr:': u'\U0001F554',
	u':5.30_uhr:': u'\U0001F560',
	u':6.00_uhr:': u'\U0001F555',
	u':6.30_uhr:': u'\U0001F561',
	u':7.00_uhr:': u'\U0001F556',
	u':7.30_uhr:': u'\U0001F562',
	u':8.00_uhr:': u'\U0001F557',
	u':8.30_uhr:': u'\U0001F563',
	u':9.00_uhr:': u'\U0001F558',
	u':9.30_uhr:': u'\U0001F564',
	u':10.00_uhr:': u'\U0001F559',
	u':10.30_uhr:': u'\U0001F565',
	u':11.00_uhr:': u'\U0001F55A',
	u':11.30_uhr:': u'\U0001F566',
	u':neumond:': u'\U0001F311',
	u':erstes_mondviertel:': u'\U0001F312',
	u':zunehmender_halbmond:': u'\U0001F313',
	u':zweites_mondviertel:': u'\U0001F314',
	u':vollmond:': u'\U0001F315',
	u':drittes_mondviertel:': u'\U0001F316',
	u':abnehmender_halbmond:': u'\U0001F317',
	u':letztes_mondviertel:': u'\U0001F318',
	u':mondsichel:': u'\U0001F319',
	u':neumond_mit_gesicht:': u'\U0001F31A',
	u':mondsichel_mit_gesicht_links:': u'\U0001F31B',
	u':mondsichel_mit_gesicht_rechts:': u'\U0001F31C',
	u':thermometer:': u'\U0001F321\U0000FE0F',
	u':sonne:': u'\U00002600\U0000FE0F',
	u':vollmond_mit_gesicht:': u'\U0001F31D',
	u':sonne_mit_gesicht:': u'\U0001F31E',
	u':ringplanet:': u'\U0001FA90',
	u':weißer_mittelgroßer_stern:': u'\U00002B50',
	u':funkelnder_stern:': u'\U0001F31F',
	u':sternschnuppe:': u'\U0001F320',
	u':milchstraße:': u'\U0001F30C',
	u':wolke:': u'\U00002601\U0000FE0F',
	u':sonne_hinter_wolke:': u'\U000026C5',
	u':wolke_mit_blitz_und_regen:': u'\U000026C8\U0000FE0F',
	u':sonne_hinter_kleiner_wolke:': u'\U0001F324\U0000FE0F',
	u':sonne_hinter_großer_wolke:': u'\U0001F325\U0000FE0F',
	u':sonne_hinter_regenwolke:': u'\U0001F326\U0000FE0F',
	u':wolke_mit_regen:': u'\U0001F327\U0000FE0F',
	u':wolke_mit_schnee:': u'\U0001F328\U0000FE0F',
	u':wolke_mit_blitz:': u'\U0001F329\U0000FE0F',
	u':wirbelsturm:': u'\U0001F32A\U0000FE0F',
	u':nebel:': u'\U0001F32B\U0000FE0F',
	u':wind:': u'\U0001F32C\U0000FE0F',
	u':wirbel:': u'\U0001F300',
	u':regenbogen:': u'\U0001F308',
	u':geschlossener_regenschirm:': u'\U0001F302',
	u':regenschirm:': u'\U00002602\U0000FE0F',
	u':regenschirm_im_regen:': u'\U00002614',
	u':aufgestellter_sonnenschirm:': u'\U000026F1\U0000FE0F',
	u':hochspannung:': u'\U000026A1',
	u':schneeflocke:': u'\U00002744\U0000FE0F',
	u':schneemann_im_schnee:': u'\U00002603\U0000FE0F',
	u':schneemann_ohne_schneeflocken:': u'\U000026C4',
	u':komet:': u'\U00002604\U0000FE0F',
	u':feuer:': u'\U0001F525',
	u':tropfen:': u'\U0001F4A7',
	u':welle:': u'\U0001F30A',
	u':halloweenkürbis:': u'\U0001F383',
	u':weihnachtsbaum:': u'\U0001F384',
	u':feuerwerk:': u'\U0001F386',
	u':wunderkerze:': u'\U0001F387',
	u':feuerwerkskörper:': u'\U0001F9E8',
	u':funkelnde_sterne:': u'\U00002728',
	u':luftballon:': u'\U0001F388',
	u':konfettibombe:': u'\U0001F389',
	u':konfettiball:': u'\U0001F38A',
	u':tanabata-baum:': u'\U0001F38B',
	u':piniendekoration:': u'\U0001F38D',
	u':japanische_puppen:': u'\U0001F38E',
	u':traditionelle_japanische_windsäcke:': u'\U0001F38F',
	u':japanisches_windspiel:': u'\U0001F390',
	u':traditionelles_mondfest:': u'\U0001F391',
	u':roter_umschlag:': u'\U0001F9E7',
	u':pinke_schleife:': u'\U0001F380',
	u':geschenk:': u'\U0001F381',
	u':gedenkschleife:': u'\U0001F397\U0000FE0F',
	u':eintrittskarten:': u'\U0001F39F\U0000FE0F',
	u':ticket:': u'\U0001F3AB',
	u':militärorden:': u'\U0001F396\U0000FE0F',
	u':pokal:': u'\U0001F3C6',
	u':sportmedaille:': u'\U0001F3C5',
	u':goldmedaille:': u'\U0001F947',
	u':silbermedaille:': u'\U0001F948',
	u':bronzemedaille:': u'\U0001F949',
	u':fußball:': u'\U000026BD',
	u':baseball:': u'\U000026BE',
	u':softball:': u'\U0001F94E',
	u':basketball:': u'\U0001F3C0',
	u':volleyball:': u'\U0001F3D0',
	u':football:': u'\U0001F3C8',
	u':rugbyball:': u'\U0001F3C9',
	u':tennisball:': u'\U0001F3BE',
	u':frisbee:': u'\U0001F94F',
	u':bowling:': u'\U0001F3B3',
	u':kricket:': u'\U0001F3CF',
	u':feldhockey:': u'\U0001F3D1',
	u':eishockey:': u'\U0001F3D2',
	u':lacrosse:': u'\U0001F94D',
	u':tischtennis:': u'\U0001F3D3',
	u':badminton:': u'\U0001F3F8',
	u':boxhandschuh:': u'\U0001F94A',
	u':kampfsportanzug:': u'\U0001F94B',
	u':tor:': u'\U0001F945',
	u':golffahne:': u'\U000026F3',
	u':schlittschuh:': u'\U000026F8\U0000FE0F',
	u':angel_mit_fisch:': u'\U0001F3A3',
	u':tauchmaske:': u'\U0001F93F',
	u':laufshirt:': u'\U0001F3BD',
	u':ski:': u'\U0001F3BF',
	u':schlitten:': u'\U0001F6F7',
	u':curlingstein:': u'\U0001F94C',
	u':darts:': u'\U0001F3AF',
	u':jo-jo:': u'\U0001FA80',
	u':drachen:': u'\U0001FA81',
	u':billardkugel:': u'\U0001F3B1',
	u':kristallkugel:': u'\U0001F52E',
	u':zauberstab:': u'\U0001FA84',
	u':nazar-amulett:': u'\U0001F9FF',
	u':gamepad:': u'\U0001F3AE',
	u':joystick:': u'\U0001F579\U0000FE0F',
	u':spielautomat:': u'\U0001F3B0',
	u':spielwürfel:': u'\U0001F3B2',
	u':puzzleteil:': u'\U0001F9E9',
	u':teddybär:': u'\U0001F9F8',
	u':piñata:': u'\U0001FA85',
	u':matroschka:': u'\U0001FA86',
	u':pik:': u'\U00002660\U0000FE0F',
	u':herz:': u'\U00002665\U0000FE0F',
	u':karo:': u'\U00002666\U0000FE0F',
	u':kreuz:': u'\U00002663\U0000FE0F',
	u':bauer_schach:': u'\U0000265F\U0000FE0F',
	u':jokerkarte:': u'\U0001F0CF',
	u':mahjong-stein:': u'\U0001F004',
	u':japanische_blumenkarte:': u'\U0001F3B4',
	u':masken:': u'\U0001F3AD',
	u':gerahmtes_bild:': u'\U0001F5BC\U0000FE0F',
	u':mischpalette:': u'\U0001F3A8',
	u':faden:': u'\U0001F9F5',
	u':nähnadel:': u'\U0001FAA1',
	u':wollknäuel:': u'\U0001F9F6',
	u':knoten:': u'\U0001FAA2',
	u':brille:': u'\U0001F453',
	u':sonnenbrille:': u'\U0001F576\U0000FE0F',
	u':schutzbrille:': u'\U0001F97D',
	u':laborkittel:': u'\U0001F97C',
	u':sicherheitsweste:': u'\U0001F9BA',
	u':hemd_mit_krawatte:': u'\U0001F454',
	u':t-shirt:': u'\U0001F455',
	u':jeans:': u'\U0001F456',
	u':schal:': u'\U0001F9E3',
	u':handschuhe:': u'\U0001F9E4',
	u':mantel:': u'\U0001F9E5',
	u':socken:': u'\U0001F9E6',
	u':kleid:': u'\U0001F457',
	u':kimono:': u'\U0001F458',
	u':sari:': u'\U0001F97B',
	u':einteiliger_badeanzug:': u'\U0001FA71',
	u':slip:': u'\U0001FA72',
	u':shorts:': u'\U0001FA73',
	u':bikini:': u'\U0001F459',
	u':bluse:': u'\U0001F45A',
	u':geldbörse:': u'\U0001F45B',
	u':handtasche:': u'\U0001F45C',
	u':clutch:': u'\U0001F45D',
	u':einkaufstüten:': u'\U0001F6CD\U0000FE0F',
	u':schulranzen:': u'\U0001F392',
	u':zehensandale:': u'\U0001FA74',
	u':herrenschuh:': u'\U0001F45E',
	u':sportschuh:': u'\U0001F45F',
	u':wanderstiefel:': u'\U0001F97E',
	u':flacher_schuh:': u'\U0001F97F',
	u':stöckelschuh:': u'\U0001F460',
	u':damensandale:': u'\U0001F461',
	u':ballettschuhe:': u'\U0001FA70',
	u':damenstiefel:': u'\U0001F462',
	u':krone:': u'\U0001F451',
	u':damenhut:': u'\U0001F452',
	u':zylinder:': u'\U0001F3A9',
	u':doktorhut:': u'\U0001F393',
	u':baseballmütze:': u'\U0001F9E2',
	u':militärhelm:': u'\U0001FA96',
	u':rettungshelm:': u'\U000026D1\U0000FE0F',
	u':gebetskette:': u'\U0001F4FF',
	u':lippenstift:': u'\U0001F484',
	u':ring:': u'\U0001F48D',
	u':edelstein:': u'\U0001F48E',
	u':durchgestrichener_lautsprecher:': u'\U0001F507',
	u':lautsprecher_mit_geringer_lautstärke:': u'\U0001F508',
	u':lautsprecher_mit_mittlerer_lautstärke:': u'\U0001F509',
	u':lautsprecher_mit_hoher_lautstärke:': u'\U0001F50A',
	u':lautsprecher:': u'\U0001F4E2',
	u':megafon:': u'\U0001F4E3',
	u':posthorn:': u'\U0001F4EF',
	u':glocke:': u'\U0001F514',
	u':durchgestrichene_glocke:': u'\U0001F515',
	u':notenschlüssel:': u'\U0001F3BC',
	u':musiknote:': u'\U0001F3B5',
	u':musiknoten:': u'\U0001F3B6',
	u':studiomikrofon:': u'\U0001F399\U0000FE0F',
	u':schieberegler:': u'\U0001F39A\U0000FE0F',
	u':drehregler:': u'\U0001F39B\U0000FE0F',
	u':mikrofon:': u'\U0001F3A4',
	u':kopfhörer:': u'\U0001F3A7',
	u':radio:': u'\U0001F4FB',
	u':saxofon:': u'\U0001F3B7',
	u':akkordeon:': u'\U0001FA97',
	u':gitarre:': u'\U0001F3B8',
	u':klaviatur:': u'\U0001F3B9',
	u':trompete:': u'\U0001F3BA',
	u':geige:': u'\U0001F3BB',
	u':banjo:': u'\U0001FA95',
	u':trommel:': u'\U0001F941',
	u':afrikanische_trommel:': u'\U0001FA98',
	u':mobiltelefon:': u'\U0001F4F1',
	u':mobiltelefon_mit_pfeil:': u'\U0001F4F2',
	u':telefon:': u'\U0000260E\U0000FE0F',
	u':telefonhörer:': u'\U0001F4DE',
	u':pager:': u'\U0001F4DF',
	u':faxgerät:': u'\U0001F4E0',
	u':batterie:': u'\U0001F50B',
	u':stromstecker:': u'\U0001F50C',
	u':laptop:': u'\U0001F4BB',
	u':desktopcomputer:': u'\U0001F5A5\U0000FE0F',
	u':drucker:': u'\U0001F5A8\U0000FE0F',
	u':tastatur:': u'\U00002328\U0000FE0F',
	u':computermaus:': u'\U0001F5B1\U0000FE0F',
	u':trackball:': u'\U0001F5B2\U0000FE0F',
	u':minidisc:': u'\U0001F4BD',
	u':diskette:': u'\U0001F4BE',
	u':cd:': u'\U0001F4BF',
	u':dvd:': u'\U0001F4C0',
	u':abakus:': u'\U0001F9EE',
	u':filmkamera:': u'\U0001F3A5',
	u':filmstreifen:': u'\U0001F39E\U0000FE0F',
	u':filmprojektor:': u'\U0001F4FD\U0000FE0F',
	u':filmklappe:': u'\U0001F3AC',
	u':fernseher:': u'\U0001F4FA',
	u':fotoapparat:': u'\U0001F4F7',
	u':fotoapparat_mit_blitz:': u'\U0001F4F8',
	u':videokamera:': u'\U0001F4F9',
	u':videokassette:': u'\U0001F4FC',
	u':lupe_nach_links:': u'\U0001F50D',
	u':lupe_nach_rechts:': u'\U0001F50E',
	u':kerze:': u'\U0001F56F\U0000FE0F',
	u':glühbirne:': u'\U0001F4A1',
	u':taschenlampe:': u'\U0001F526',
	u':rote_papierlaterne:': u'\U0001F3EE',
	u':öllampe:': u'\U0001FA94',
	u':notizbuch_mit_dekorativem_einband:': u'\U0001F4D4',
	u':geschlossenes_buch:': u'\U0001F4D5',
	u':offenes_buch:': u'\U0001F4D6',
	u':grünes_buch:': u'\U0001F4D7',
	u':blaues_buch:': u'\U0001F4D8',
	u':orangefarbenes_buch:': u'\U0001F4D9',
	u':bücherstapel:': u'\U0001F4DA',
	u':notizbuch:': u'\U0001F4D3',
	u':spiralblock:': u'\U0001F4D2',
	u':teilweise_eingerolltes_blatt:': u'\U0001F4C3',
	u':schriftrolle:': u'\U0001F4DC',
	u':vorderseite_eines_blattes:': u'\U0001F4C4',
	u':zeitung:': u'\U0001F4F0',
	u':zusammengerollte_zeitung:': u'\U0001F5DE\U0000FE0F',
	u':pagemarker:': u'\U0001F4D1',
	u':lesezeichen:': u'\U0001F516',
	u':etikett:': u'\U0001F3F7\U0000FE0F',
	u':geldsack:': u'\U0001F4B0',
	u':münze:': u'\U0001FA99',
	u':yen-banknote:': u'\U0001F4B4',
	u':dollar-banknote:': u'\U0001F4B5',
	u':euro-banknote:': u'\U0001F4B6',
	u':pfund-banknote:': u'\U0001F4B7',
	u':geldschein_mit_flügeln:': u'\U0001F4B8',
	u':kreditkarte:': u'\U0001F4B3',
	u':beleg:': u'\U0001F9FE',
	u':steigender_trend_mit_yen-zeichen:': u'\U0001F4B9',
	u':briefumschlag:': u'\U00002709\U0000FE0F',
	u':e-mail:': u'\U0001F4E7',
	u':eingehender_briefumschlag:': u'\U0001F4E8',
	u':umschlag_mit_pfeil:': u'\U0001F4E9',
	u':postausgang:': u'\U0001F4E4',
	u':posteingang:': u'\U0001F4E5',
	u':paket:': u'\U0001F4E6',
	u':geschlossener_briefkasten_mit_post:': u'\U0001F4EB',
	u':geschlossener_briefkasten_ohne_post:': u'\U0001F4EA',
	u':offener_briefkasten_mit_post:': u'\U0001F4EC',
	u':offener_briefkasten_ohne_post:': u'\U0001F4ED',
	u':briefkasten:': u'\U0001F4EE',
	u':urne_mit_wahlzettel:': u'\U0001F5F3\U0000FE0F',
	u':bleistift:': u'\U0000270F\U0000FE0F',
	u':schwarzer_federhalter:': u'\U00002712\U0000FE0F',
	u':füllhalter:': u'\U0001F58B\U0000FE0F',
	u':kugelschreiber:': u'\U0001F58A\U0000FE0F',
	u':pinsel:': u'\U0001F58C\U0000FE0F',
	u':wachsmalstift:': u'\U0001F58D\U0000FE0F',
	u':papier_und_bleistift:': u'\U0001F4DD',
	u':aktentasche:': u'\U0001F4BC',
	u':ordner:': u'\U0001F4C1',
	u':geöffneter_ordner:': u'\U0001F4C2',
	u':karteibahnen:': u'\U0001F5C2\U0000FE0F',
	u':kalender:': u'\U0001F4C5',
	u':abreißkalender:': u'\U0001F4C6',
	u':notizblock:': u'\U0001F5D2\U0000FE0F',
	u':spiralkalender:': u'\U0001F5D3\U0000FE0F',
	u':rotationskartei:': u'\U0001F4C7',
	u':aufwärtstrend:': u'\U0001F4C8',
	u':abwärtstrend:': u'\U0001F4C9',
	u':balkendiagramm:': u'\U0001F4CA',
	u':zwischenablage:': u'\U0001F4CB',
	u':reißzwecke:': u'\U0001F4CC',
	u':stecknadel:': u'\U0001F4CD',
	u':büroklammer:': u'\U0001F4CE',
	u':verhakte_büroklammern:': u'\U0001F587\U0000FE0F',
	u':lineal:': u'\U0001F4CF',
	u':dreieckiges_lineal:': u'\U0001F4D0',
	u':schere:': u'\U00002702\U0000FE0F',
	u':karteikasten:': u'\U0001F5C3\U0000FE0F',
	u':aktenschrank:': u'\U0001F5C4\U0000FE0F',
	u':papierkorb:': u'\U0001F5D1\U0000FE0F',
	u':geschlossenes_schloss:': u'\U0001F512',
	u':offenes_schloss:': u'\U0001F513',
	u':schloss_mit_füller:': u'\U0001F50F',
	u':schloss_mit_schlüssel:': u'\U0001F510',
	u':schlüssel:': u'\U0001F511',
	u':alter_schlüssel:': u'\U0001F5DD\U0000FE0F',
	u':hammer:': u'\U0001F528',
	u':axt:': u'\U0001FA93',
	u':pickel:': u'\U000026CF\U0000FE0F',
	u':hammer_und_pickel:': u'\U00002692\U0000FE0F',
	u':hammer_und_schraubenschlüssel:': u'\U0001F6E0\U0000FE0F',
	u':dolch:': u'\U0001F5E1\U0000FE0F',
	u':gekreuzte_schwerter:': u'\U00002694\U0000FE0F',
	u':pistole:': u'\U0001F52B',
	u':bumerang:': u'\U0001FA83',
	u':pfeil_und_bogen:': u'\U0001F3F9',
	u':schutzschild:': u'\U0001F6E1\U0000FE0F',
	u':handsäge:': u'\U0001FA9A',
	u':schraubenschlüssel:': u'\U0001F527',
	u':schraubenzieher:': u'\U0001FA9B',
	u':mutter_und_schraube:': u'\U0001F529',
	u':zahnrad:': u'\U00002699\U0000FE0F',
	u':schraubzwinge:': u'\U0001F5DC\U0000FE0F',
	u':waage:': u'\U00002696\U0000FE0F',
	u':gehstock:': u'\U0001F9AF',
	u':verknüpfungssymbol:': u'\U0001F517',
	u':ketten:': u'\U000026D3\U0000FE0F',
	u':angelhaken:': u'\U0001FA9D',
	u':werkzeugkasten:': u'\U0001F9F0',
	u':magnet:': u'\U0001F9F2',
	u':leiter:': u'\U0001FA9C',
	u':destillierapparat:': u'\U00002697\U0000FE0F',
	u':reagenzglas:': u'\U0001F9EA',
	u':petrischale:': u'\U0001F9EB',
	u':dna:': u'\U0001F9EC',
	u':mikroskop:': u'\U0001F52C',
	u':teleskop:': u'\U0001F52D',
	u':satellitenschüssel:': u'\U0001F4E1',
	u':spritze:': u'\U0001F489',
	u':blutstropfen:': u'\U0001FA78',
	u':kapsel:': u'\U0001F48A',
	u':heftpflaster:': u'\U0001FA79',
	u':stethoskop:': u'\U0001FA7A',
	u':tür:': u'\U0001F6AA',
	u':fahrstuhl:': u'\U0001F6D7',
	u':spiegel:': u'\U0001FA9E',
	u':fenster:': u'\U0001FA9F',
	u':bett:': u'\U0001F6CF\U0000FE0F',
	u':sofa_und_lampe:': u'\U0001F6CB\U0000FE0F',
	u':stuhl:': u'\U0001FA91',
	u':toilette:': u'\U0001F6BD',
	u':pömpel:': u'\U0001FAA0',
	u':dusche:': u'\U0001F6BF',
	u':badewanne:': u'\U0001F6C1',
	u':mäusefalle:': u'\U0001FAA4',
	u':rasierer:': u'\U0001FA92',
	u':creme:': u'\U0001F9F4',
	u':sicherheitsnadel:': u'\U0001F9F7',
	u':besen:': u'\U0001F9F9',
	u':korb:': u'\U0001F9FA',
	u':küchenrolle:': u'\U0001F9FB',
	u':eimer:': u'\U0001FAA3',
	u':seife:': u'\U0001F9FC',
	u':zahnbürste:': u'\U0001FAA5',
	u':schwamm:': u'\U0001F9FD',
	u':feuerlöscher:': u'\U0001F9EF',
	u':einkaufswagen:': u'\U0001F6D2',
	u':zigarette:': u'\U0001F6AC',
	u':sarg:': u'\U000026B0\U0000FE0F',
	u':grabstein:': u'\U0001FAA6',
	u':urne:': u'\U000026B1\U0000FE0F',
	u':statue:': u'\U0001F5FF',
	u':plakat:': u'\U0001FAA7',
	u':symbol_geldautomat:': u'\U0001F3E7',
	u':symbol_papierkorb:': u'\U0001F6AE',
	u':trinkwasser:': u'\U0001F6B0',
	u':symbol_rollstuhl:': u'\U0000267F',
	u':herren:': u'\U0001F6B9',
	u':damen:': u'\U0001F6BA',
	u':toiletten:': u'\U0001F6BB',
	u':symbol_baby:': u'\U0001F6BC',
	u':wc:': u'\U0001F6BE',
	u':passkontrolle:': u'\U0001F6C2',
	u':zollkontrolle:': u'\U0001F6C3',
	u':gepäckausgabe:': u'\U0001F6C4',
	u':gepäckaufbewahrung:': u'\U0001F6C5',
	u':warnung:': u'\U000026A0\U0000FE0F',
	u':kinder_überqueren_die_straße:': u'\U0001F6B8',
	u':zutritt_verboten:': u'\U000026D4',
	u':verboten:': u'\U0001F6AB',
	u':fahrräder_verboten:': u'\U0001F6B3',
	u':rauchverbot:': u'\U0001F6AD',
	u':abfall_verboten:': u'\U0001F6AF',
	u':kein_trinkwasser:': u'\U0001F6B1',
	u':fußgänger_verboten:': u'\U0001F6B7',
	u':mobiltelefone_verboten:': u'\U0001F4F5',
	u':minderjährige_verboten:': u'\U0001F51E',
	u':radioaktiv:': u'\U00002622\U0000FE0F',
	u':biogefährdung:': u'\U00002623\U0000FE0F',
	u':pfeil_nach_oben:': u'\U00002B06\U0000FE0F',
	u':pfeil_nach_rechts_oben:': u'\U00002197\U0000FE0F',
	u':pfeil_nach_rechts:': u'\U000027A1\U0000FE0F',
	u':pfeil_nach_rechts_unten:': u'\U00002198\U0000FE0F',
	u':pfeil_nach_unten:': u'\U00002B07\U0000FE0F',
	u':pfeil_nach_links_unten:': u'\U00002199\U0000FE0F',
	u':pfeil_nach_links:': u'\U00002B05\U0000FE0F',
	u':pfeil_nach_links_oben:': u'\U00002196\U0000FE0F',
	u':pfeil_nach_oben_und_unten:': u'\U00002195\U0000FE0F',
	u':pfeil_nach_links_und_rechts:': u'\U00002194\U0000FE0F',
	u':geschwungener_pfeil_nach_links:': u'\U000021A9\U0000FE0F',
	u':geschwungener_pfeil_nach_rechts:': u'\U000021AA\U0000FE0F',
	u':geschwungener_pfeil_nach_oben:': u'\U00002934\U0000FE0F',
	u':geschwungener_pfeil_nach_unten:': u'\U00002935\U0000FE0F',
	u':kreisförmige_pfeile_im_uhrzeigersinn:': u'\U0001F503',
	u':kreisförmige_pfeile_gegen_den_uhrzeigersinn:': u'\U0001F504',
	u':back-pfeil:': u'\U0001F519',
	u':end-pfeil:': u'\U0001F51A',
	u':on!-pfeil:': u'\U0001F51B',
	u':soon-pfeil:': u'\U0001F51C',
	u':top-pfeil:': u'\U0001F51D',
	u':kultstätte:': u'\U0001F6D0',
	u':atomzeichen:': u'\U0000269B\U0000FE0F',
	u':om:': u'\U0001F549\U0000FE0F',
	u':davidstern:': u'\U00002721\U0000FE0F',
	u':dharma-rad:': u'\U00002638\U0000FE0F',
	u':yin_und_yang:': u'\U0000262F\U0000FE0F',
	u':römisches_kreuz:': u'\U0000271D\U0000FE0F',
	u':orthodoxes_kreuz:': u'\U00002626\U0000FE0F',
	u':hilal_und_stern:': u'\U0000262A\U0000FE0F',
	u':friedenszeichen:': u'\U0000262E\U0000FE0F',
	u':menora:': u'\U0001F54E',
	u':hexagramm_mit_punkt:': u'\U0001F52F',
	u':widder_(sternzeichen):': u'\U00002648',
	u':stier_(sternzeichen):': u'\U00002649',
	u':zwilling_(sternzeichen):': u'\U0000264A',
	u':krebs_(sternzeichen):': u'\U0000264B',
	u':löwe_(sternzeichen):': u'\U0000264C',
	u':jungfrau_(sternzeichen):': u'\U0000264D',
	u':waage_(sternzeichen):': u'\U0000264E',
	u':skorpion_(sternzeichen):': u'\U0000264F',
	u':schütze_(sternzeichen):': u'\U00002650',
	u':steinbock_(sternzeichen):': u'\U00002651',
	u':wassermann_(sternzeichen):': u'\U00002652',
	u':fische_(sternzeichen):': u'\U00002653',
	u':schlangenträger:': u'\U000026CE',
	u':zufallsmodus:': u'\U0001F500',
	u':wiederholen:': u'\U0001F501',
	u':titel_wiederholen:': u'\U0001F502',
	u':wiedergabe:': u'\U000025B6\U0000FE0F',
	u':doppelpfeile_nach_rechts:': u'\U000023E9',
	u':nächster_titel:': u'\U000023ED\U0000FE0F',
	u':wiedergabe_oder_pause:': u'\U000023EF\U0000FE0F',
	u':pfeil_zurück:': u'\U000025C0\U0000FE0F',
	u':zurückspulen:': u'\U000023EA',
	u':vorheriger_titel:': u'\U000023EE\U0000FE0F',
	u':aufwärts-schaltfläche:': u'\U0001F53C',
	u':doppelpfeile_nach_oben:': u'\U000023EB',
	u':abwärts-schaltfläche:': u'\U0001F53D',
	u':doppelpfeile_nach_unten:': u'\U000023EC',
	u':pause:': u'\U000023F8\U0000FE0F',
	u':stopp:': u'\U000023F9\U0000FE0F',
	u':aufnehmen:': u'\U000023FA\U0000FE0F',
	u':auswerfen:': u'\U000023CF\U0000FE0F',
	u':kinosymbol:': u'\U0001F3A6',
	u':taste_dimmen:': u'\U0001F505',
	u':taste_heller:': u'\U0001F506',
	u':balkenförmige_signalstärkenanzeige:': u'\U0001F4F6',
	u':vibrationsmodus:': u'\U0001F4F3',
	u':mobiltelefon_aus:': u'\U0001F4F4',
	u':frauensymbol:': u'\U00002640\U0000FE0F',
	u':männersymbol:': u'\U00002642\U0000FE0F',
	u':symbol_für_transgender:': u'\U000026A7\U0000FE0F',
	u':multiplikationszeichen:': u'\U00002716\U0000FE0F',
	u':pluszeichen:': u'\U00002795',
	u':minuszeichen:': u'\U00002796',
	u':divisionszeichen:': u'\U00002797',
	u':unendlichkeit:': u'\U0000267E\U0000FE0F',
	u':doppeltes_ausrufezeichen:': u'\U0000203C\U0000FE0F',
	u':ausrufe-_und_fragezeichen:': u'\U00002049\U0000FE0F',
	u':rotes_fragezeichen:': u'\U00002753',
	u':weißes_fragezeichen:': u'\U00002754',
	u':weißes_ausrufezeichen:': u'\U00002755',
	u':rotes_ausrufezeichen:': u'\U00002757',
	u':wellenlinie:': u'\U00003030\U0000FE0F',
	u':geldwechsel:': u'\U0001F4B1',
	u':dollarzeichen:': u'\U0001F4B2',
	u':äskulapstab:': u'\U00002695\U0000FE0F',
	u':recycling-symbol:': u'\U0000267B\U0000FE0F',
	u':lilie:': u'\U0000269C\U0000FE0F',
	u':dreizack:': u'\U0001F531',
	u':namensschild:': u'\U0001F4DB',
	u':japanisches_anfänger-zeichen:': u'\U0001F530',
	u':hohler_roter_kreis:': u'\U00002B55',
	u':weißes_häkchen:': u'\U00002705',
	u':abstimmungsfeld_mit_häkchen:': u'\U00002611\U0000FE0F',
	u':kräftiges_häkchen:': u'\U00002714\U0000FE0F',
	u':kreuzzeichen:': u'\U0000274C',
	u':kreuzsymbol_im_quadrat:': u'\U0000274E',
	u':schleife:': u'\U000027B0',
	u':doppelschleife:': u'\U000027BF',
	u':teilalternationszeichen:': u'\U0000303D\U0000FE0F',
	u':achtzackiger_stern:': u'\U00002733\U0000FE0F',
	u':stern_mit_acht_zacken:': u'\U00002734\U0000FE0F',
	u':funkeln:': u'\U00002747\U0000FE0F',
	u':copyright:': u'\U000000A9\U0000FE0F',
	u':registered-trademark:': u'\U000000AE\U0000FE0F',
	u':markenzeichen:': u'\U00002122\U0000FE0F',
	u':taste_#:': u'\U00000023\U0000FE0F\U000020E3',
	u':taste_*:': u'\U0000002A\U0000FE0F\U000020E3',
	u':taste_0:': u'\U00000030\U0000FE0F\U000020E3',
	u':taste_1:': u'\U00000031\U0000FE0F\U000020E3',
	u':taste_2:': u'\U00000032\U0000FE0F\U000020E3',
	u':taste_3:': u'\U00000033\U0000FE0F\U000020E3',
	u':taste_4:': u'\U00000034\U0000FE0F\U000020E3',
	u':taste_5:': u'\U00000035\U0000FE0F\U000020E3',
	u':taste_6:': u'\U00000036\U0000FE0F\U000020E3',
	u':taste_7:': u'\U00000037\U0000FE0F\U000020E3',
	u':taste_8:': u'\U00000038\U0000FE0F\U000020E3',
	u':taste_9:': u'\U00000039\U0000FE0F\U000020E3',
	u':taste_10:': u'\U0001F51F',
	u':eingabesymbol_lateinische_großbuchstaben:': u'\U0001F520',
	u':eingabesymbol_lateinische_kleinbuchstaben:': u'\U0001F521',
	u':eingabesymbol_zahlen:': u'\U0001F522',
	u':eingabesymbol_sonderzeichen:': u'\U0001F523',
	u':eingabesymbol_lateinische_buchstaben:': u'\U0001F524',
	u':großbuchstabe_a_in_rotem_quadrat:': u'\U0001F170\U0000FE0F',
	u':großbuchstaben_ab_in_rotem_quadrat:': u'\U0001F18E',
	u':großbuchstabe_b_in_rotem_quadrat:': u'\U0001F171\U0000FE0F',
	u':großbuchstaben_cl_in_rotem_quadrat:': u'\U0001F191',
	u':wort_cool_in_blauem_quadrat:': u'\U0001F192',
	u':wort_free_in_blauem_quadrat:': u'\U0001F193',
	u':buchstabe_i_in_blauem_quadrat:': u'\U00002139\U0000FE0F',
	u':großbuchstaben_id_in_lila_quadrat:': u'\U0001F194',
	u':buchstabe_m_in_kreis:': u'\U000024C2\U0000FE0F',
	u':wort_new_in_blauem_quadrat:': u'\U0001F195',
	u':großbuchstaben_ng_in_blauem_quadrat:': u'\U0001F196',
	u':großbuchstabe_o_in_rotem_quadrat:': u'\U0001F17E\U0000FE0F',
	u':großbuchstaben_ok_in_blauem_quadrat:': u'\U0001F197',
	u':großbuchstabe_p_in_blauem_quadrat:': u'\U0001F17F\U0000FE0F',
	u':sos-zeichen:': u'\U0001F198',
	u':schriftzug_up!_im_blauen_quadrat:': u'\U0001F199',
	u':großbuchstaben_vs_in_orangefarbenem_quadrat:': u'\U0001F19A',
	u':schriftzeichen_koko:': u'\U0001F201',
	u':schriftzeichen_sa:': u'\U0001F202\U0000FE0F',
	u':schriftzeichen_für_monatsbetrag:': u'\U0001F237\U0000FE0F',
	u':schriftzeichen_für_nicht_gratis:': u'\U0001F236',
	u':schriftzeichen_für_reserviert:': u'\U0001F22F',
	u':schriftzeichen_für_schnäppchen:': u'\U0001F250',
	u':schriftzeichen_für_rabatt:': u'\U0001F239',
	u':schriftzeichen_für_gratis:': u'\U0001F21A',
	u':schriftzeichen_für_verbieten:': u'\U0001F232',
	u':schriftzeichen_für_akzeptieren:': u'\U0001F251',
	u':schriftzeichen_für_anwenden:': u'\U0001F238',
	u':schriftzeichen_für_note_zum_bestehen:': u'\U0001F234',
	u':schriftzeichen_für_zimmer_frei:': u'\U0001F233',
	u':schriftzeichen_für_gratulation:': u'\U00003297\U0000FE0F',
	u':schriftzeichen_für_geheimnis:': u'\U00003299\U0000FE0F',
	u':schriftzeichen_für_geöffnet:': u'\U0001F23A',
	u':schriftzeichen_für_kein_zimmer_frei:': u'\U0001F235',
	u':roter_kreis:': u'\U0001F534',
	u':oranger_kreis:': u'\U0001F7E0',
	u':gelber_kreis:': u'\U0001F7E1',
	u':grüner_kreis:': u'\U0001F7E2',
	u':blauer_kreis:': u'\U0001F535',
	u':lila_kreis:': u'\U0001F7E3',
	u':brauner_kreis:': u'\U0001F7E4',
	u':schwarzer_kreis:': u'\U000026AB',
	u':weißer_kreis:': u'\U000026AA',
	u':rotes_viereck:': u'\U0001F7E5',
	u':oranges_viereck:': u'\U0001F7E7',
	u':gelbes_viereck:': u'\U0001F7E8',
	u':grünes_viereck:': u'\U0001F7E9',
	u':blaues_viereck:': u'\U0001F7E6',
	u':lila_viereck:': u'\U0001F7EA',
	u':braunes_viereck:': u'\U0001F7EB',
	u':großes_schwarzes_quadrat:': u'\U00002B1B',
	u':großes_weißes_quadrat:': u'\U00002B1C',
	u':mittelgroßes_schwarzes_quadrat:': u'\U000025FC\U0000FE0F',
	u':mittelgroßes_weißes_quadrat:': u'\U000025FB\U0000FE0F',
	u':mittelkleines_schwarzes_quadrat:': u'\U000025FE',
	u':mittelkleines_weißes_quadrat:': u'\U000025FD',
	u':kleines_schwarzes_quadrat:': u'\U000025AA\U0000FE0F',
	u':kleines_weißes_quadrat:': u'\U000025AB\U0000FE0F',
	u':große_orangefarbene_raute:': u'\U0001F536',
	u':große_blaue_raute:': u'\U0001F537',
	u':kleine_orangefarbene_raute:': u'\U0001F538',
	u':kleine_blaue_raute:': u'\U0001F539',
	u':rotes_dreieck_mit_der_spitze_nach_oben:': u'\U0001F53A',
	u':rotes_dreieck_mit_der_spitze_nach_unten:': u'\U0001F53B',
	u':rautenform_mit_punkt:': u'\U0001F4A0',
	u':optionsfeld:': u'\U0001F518',
	u':weiße_quadratische_schaltfläche:': u'\U0001F533',
	u':schwarze_quadratische_schaltfläche:': u'\U0001F532',
	u':zielflagge:': u'\U0001F3C1',
	u':dreiecksflagge:': u'\U0001F6A9',
	u':überkreuzte_flaggen:': u'\U0001F38C',
	u':schwarze_flagge:': u'\U0001F3F4',
	u':weiße_flagge:': u'\U0001F3F3\U0000FE0F',
	u':regenbogenflagge:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
	u':transgender-flagge:': u'\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F',
	u':piratenflagge:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
	u':flagge_ascension:': u'\U0001F1E6\U0001F1E8',
	u':flagge_andorra:': u'\U0001F1E6\U0001F1E9',
	u':flagge_vereinigte_arabische_emirate:': u'\U0001F1E6\U0001F1EA',
	u':flagge_afghanistan:': u'\U0001F1E6\U0001F1EB',
	u':flagge_antigua_und_barbuda:': u'\U0001F1E6\U0001F1EC',
	u':flagge_anguilla:': u'\U0001F1E6\U0001F1EE',
	u':flagge_albanien:': u'\U0001F1E6\U0001F1F1',
	u':flagge_armenien:': u'\U0001F1E6\U0001F1F2',
	u':flagge_angola:': u'\U0001F1E6\U0001F1F4',
	u':flagge_antarktis:': u'\U0001F1E6\U0001F1F6',
	u':flagge_argentinien:': u'\U0001F1E6\U0001F1F7',
	u':flagge_amerikanisch-samoa:': u'\U0001F1E6\U0001F1F8',
	u':flagge_österreich:': u'\U0001F1E6\U0001F1F9',
	u':flagge_australien:': u'\U0001F1E6\U0001F1FA',
	u':flagge_aruba:': u'\U0001F1E6\U0001F1FC',
	u':flagge_ålandinseln:': u'\U0001F1E6\U0001F1FD',
	u':flagge_aserbaidschan:': u'\U0001F1E6\U0001F1FF',
	u':flagge_bosnien_und_herzegowina:': u'\U0001F1E7\U0001F1E6',
	u':flagge_barbados:': u'\U0001F1E7\U0001F1E7',
	u':flagge_bangladesch:': u'\U0001F1E7\U0001F1E9',
	u':flagge_belgien:': u'\U0001F1E7\U0001F1EA',
	u':flagge_burkina_faso:': u'\U0001F1E7\U0001F1EB',
	u':flagge_bulgarien:': u'\U0001F1E7\U0001F1EC',
	u':flagge_bahrain:': u'\U0001F1E7\U0001F1ED',
	u':flagge_burundi:': u'\U0001F1E7\U0001F1EE',
	u':flagge_benin:': u'\U0001F1E7\U0001F1EF',
	u':flagge_st._barthélemy:': u'\U0001F1E7\U0001F1F1',
	u':flagge_bermuda:': u'\U0001F1E7\U0001F1F2',
	u':flagge_brunei_darussalam:': u'\U0001F1E7\U0001F1F3',
	u':flagge_bolivien:': u'\U0001F1E7\U0001F1F4',
	u':flagge_bonaire,_sint_eustatius_und_saba:': u'\U0001F1E7\U0001F1F6',
	u':flagge_brasilien:': u'\U0001F1E7\U0001F1F7',
	u':flagge_bahamas:': u'\U0001F1E7\U0001F1F8',
	u':flagge_bhutan:': u'\U0001F1E7\U0001F1F9',
	u':flagge_bouvetinsel:': u'\U0001F1E7\U0001F1FB',
	u':flagge_botsuana:': u'\U0001F1E7\U0001F1FC',
	u':flagge_belarus:': u'\U0001F1E7\U0001F1FE',
	u':flagge_belize:': u'\U0001F1E7\U0001F1FF',
	u':flagge_kanada:': u'\U0001F1E8\U0001F1E6',
	u':flagge_kokosinseln:': u'\U0001F1E8\U0001F1E8',
	u':flagge_kongo-kinshasa:': u'\U0001F1E8\U0001F1E9',
	u':flagge_zentralafrikanische_republik:': u'\U0001F1E8\U0001F1EB',
	u':flagge_kongo-brazzaville:': u'\U0001F1E8\U0001F1EC',
	u':flagge_schweiz:': u'\U0001F1E8\U0001F1ED',
	u':flagge_côte_d’ivoire:': u'\U0001F1E8\U0001F1EE',
	u':flagge_cookinseln:': u'\U0001F1E8\U0001F1F0',
	u':flagge_chile:': u'\U0001F1E8\U0001F1F1',
	u':flagge_kamerun:': u'\U0001F1E8\U0001F1F2',
	u':flagge_china:': u'\U0001F1E8\U0001F1F3',
	u':flagge_kolumbien:': u'\U0001F1E8\U0001F1F4',
	u':flagge_clipperton-insel:': u'\U0001F1E8\U0001F1F5',
	u':flagge_costa_rica:': u'\U0001F1E8\U0001F1F7',
	u':flagge_kuba:': u'\U0001F1E8\U0001F1FA',
	u':flagge_cabo_verde:': u'\U0001F1E8\U0001F1FB',
	u':flagge_curaçao:': u'\U0001F1E8\U0001F1FC',
	u':flagge_weihnachtsinsel:': u'\U0001F1E8\U0001F1FD',
	u':flagge_zypern:': u'\U0001F1E8\U0001F1FE',
	u':flagge_tschechien:': u'\U0001F1E8\U0001F1FF',
	u':flagge_deutschland:': u'\U0001F1E9\U0001F1EA',
	u':flagge_diego_garcia:': u'\U0001F1E9\U0001F1EC',
	u':flagge_dschibuti:': u'\U0001F1E9\U0001F1EF',
	u':flagge_dänemark:': u'\U0001F1E9\U0001F1F0',
	u':flagge_dominica:': u'\U0001F1E9\U0001F1F2',
	u':flagge_dominikanische_republik:': u'\U0001F1E9\U0001F1F4',
	u':flagge_algerien:': u'\U0001F1E9\U0001F1FF',
	u':flagge_ceuta_und_melilla:': u'\U0001F1EA\U0001F1E6',
	u':flagge_ecuador:': u'\U0001F1EA\U0001F1E8',
	u':flagge_estland:': u'\U0001F1EA\U0001F1EA',
	u':flagge_ägypten:': u'\U0001F1EA\U0001F1EC',
	u':flagge_westsahara:': u'\U0001F1EA\U0001F1ED',
	u':flagge_eritrea:': u'\U0001F1EA\U0001F1F7',
	u':flagge_spanien:': u'\U0001F1EA\U0001F1F8',
	u':flagge_äthiopien:': u'\U0001F1EA\U0001F1F9',
	u':flagge_europäische_union:': u'\U0001F1EA\U0001F1FA',
	u':flagge_finnland:': u'\U0001F1EB\U0001F1EE',
	u':flagge_fidschi:': u'\U0001F1EB\U0001F1EF',
	u':flagge_falklandinseln:': u'\U0001F1EB\U0001F1F0',
	u':flagge_mikronesien:': u'\U0001F1EB\U0001F1F2',
	u':flagge_färöer:': u'\U0001F1EB\U0001F1F4',
	u':flagge_frankreich:': u'\U0001F1EB\U0001F1F7',
	u':flagge_gabun:': u'\U0001F1EC\U0001F1E6',
	u':flagge_vereinigtes_königreich:': u'\U0001F1EC\U0001F1E7',
	u':flagge_grenada:': u'\U0001F1EC\U0001F1E9',
	u':flagge_georgien:': u'\U0001F1EC\U0001F1EA',
	u':flagge_französisch-guayana:': u'\U0001F1EC\U0001F1EB',
	u':flagge_guernsey:': u'\U0001F1EC\U0001F1EC',
	u':flagge_ghana:': u'\U0001F1EC\U0001F1ED',
	u':flagge_gibraltar:': u'\U0001F1EC\U0001F1EE',
	u':flagge_grönland:': u'\U0001F1EC\U0001F1F1',
	u':flagge_gambia:': u'\U0001F1EC\U0001F1F2',
	u':flagge_guinea:': u'\U0001F1EC\U0001F1F3',
	u':flagge_guadeloupe:': u'\U0001F1EC\U0001F1F5',
	u':flagge_äquatorialguinea:': u'\U0001F1EC\U0001F1F6',
	u':flagge_griechenland:': u'\U0001F1EC\U0001F1F7',
	u':flagge_südgeorgien_und_die_südlichen_sandwichinseln:': u'\U0001F1EC\U0001F1F8',
	u':flagge_guatemala:': u'\U0001F1EC\U0001F1F9',
	u':flagge_guam:': u'\U0001F1EC\U0001F1FA',
	u':flagge_guinea-bissau:': u'\U0001F1EC\U0001F1FC',
	u':flagge_guyana:': u'\U0001F1EC\U0001F1FE',
	u':flagge_sonderverwaltungsregion_hongkong:': u'\U0001F1ED\U0001F1F0',
	u':flagge_heard_und_mcdonaldinseln:': u'\U0001F1ED\U0001F1F2',
	u':flagge_honduras:': u'\U0001F1ED\U0001F1F3',
	u':flagge_kroatien:': u'\U0001F1ED\U0001F1F7',
	u':flagge_haiti:': u'\U0001F1ED\U0001F1F9',
	u':flagge_ungarn:': u'\U0001F1ED\U0001F1FA',
	u':flagge_kanarische_inseln:': u'\U0001F1EE\U0001F1E8',
	u':flagge_indonesien:': u'\U0001F1EE\U0001F1E9',
	u':flagge_irland:': u'\U0001F1EE\U0001F1EA',
	u':flagge_israel:': u'\U0001F1EE\U0001F1F1',
	u':flagge_isle_of_man:': u'\U0001F1EE\U0001F1F2',
	u':flagge_indien:': u'\U0001F1EE\U0001F1F3',
	u':flagge_britisches_territorium_im_indischen_ozean:': u'\U0001F1EE\U0001F1F4',
	u':flagge_irak:': u'\U0001F1EE\U0001F1F6',
	u':flagge_iran:': u'\U0001F1EE\U0001F1F7',
	u':flagge_island:': u'\U0001F1EE\U0001F1F8',
	u':flagge_italien:': u'\U0001F1EE\U0001F1F9',
	u':flagge_jersey:': u'\U0001F1EF\U0001F1EA',
	u':flagge_jamaika:': u'\U0001F1EF\U0001F1F2',
	u':flagge_jordanien:': u'\U0001F1EF\U0001F1F4',
	u':flagge_japan:': u'\U0001F1EF\U0001F1F5',
	u':flagge_kenia:': u'\U0001F1F0\U0001F1EA',
	u':flagge_kirgisistan:': u'\U0001F1F0\U0001F1EC',
	u':flagge_kambodscha:': u'\U0001F1F0\U0001F1ED',
	u':flagge_kiribati:': u'\U0001F1F0\U0001F1EE',
	u':flagge_komoren:': u'\U0001F1F0\U0001F1F2',
	u':flagge_st._kitts_und_nevis:': u'\U0001F1F0\U0001F1F3',
	u':flagge_nordkorea:': u'\U0001F1F0\U0001F1F5',
	u':flagge_südkorea:': u'\U0001F1F0\U0001F1F7',
	u':flagge_kuwait:': u'\U0001F1F0\U0001F1FC',
	u':flagge_kaimaninseln:': u'\U0001F1F0\U0001F1FE',
	u':flagge_kasachstan:': u'\U0001F1F0\U0001F1FF',
	u':flagge_laos:': u'\U0001F1F1\U0001F1E6',
	u':flagge_libanon:': u'\U0001F1F1\U0001F1E7',
	u':flagge_st._lucia:': u'\U0001F1F1\U0001F1E8',
	u':flagge_liechtenstein:': u'\U0001F1F1\U0001F1EE',
	u':flagge_sri_lanka:': u'\U0001F1F1\U0001F1F0',
	u':flagge_liberia:': u'\U0001F1F1\U0001F1F7',
	u':flagge_lesotho:': u'\U0001F1F1\U0001F1F8',
	u':flagge_litauen:': u'\U0001F1F1\U0001F1F9',
	u':flagge_luxemburg:': u'\U0001F1F1\U0001F1FA',
	u':flagge_lettland:': u'\U0001F1F1\U0001F1FB',
	u':flagge_libyen:': u'\U0001F1F1\U0001F1FE',
	u':flagge_marokko:': u'\U0001F1F2\U0001F1E6',
	u':flagge_monaco:': u'\U0001F1F2\U0001F1E8',
	u':flagge_republik_moldau:': u'\U0001F1F2\U0001F1E9',
	u':flagge_montenegro:': u'\U0001F1F2\U0001F1EA',
	u':flagge_st._martin:': u'\U0001F1F2\U0001F1EB',
	u':flagge_madagaskar:': u'\U0001F1F2\U0001F1EC',
	u':flagge_marshallinseln:': u'\U0001F1F2\U0001F1ED',
	u':flagge_nordmazedonien:': u'\U0001F1F2\U0001F1F0',
	u':flagge_mali:': u'\U0001F1F2\U0001F1F1',
	u':flagge_myanmar:': u'\U0001F1F2\U0001F1F2',
	u':flagge_mongolei:': u'\U0001F1F2\U0001F1F3',
	u':flagge_sonderverwaltungsregion_macau:': u'\U0001F1F2\U0001F1F4',
	u':flagge_nördliche_marianen:': u'\U0001F1F2\U0001F1F5',
	u':flagge_martinique:': u'\U0001F1F2\U0001F1F6',
	u':flagge_mauretanien:': u'\U0001F1F2\U0001F1F7',
	u':flagge_montserrat:': u'\U0001F1F2\U0001F1F8',
	u':flagge_malta:': u'\U0001F1F2\U0001F1F9',
	u':flagge_mauritius:': u'\U0001F1F2\U0001F1FA',
	u':flagge_malediven:': u'\U0001F1F2\U0001F1FB',
	u':flagge_malawi:': u'\U0001F1F2\U0001F1FC',
	u':flagge_mexiko:': u'\U0001F1F2\U0001F1FD',
	u':flagge_malaysia:': u'\U0001F1F2\U0001F1FE',
	u':flagge_mosambik:': u'\U0001F1F2\U0001F1FF',
	u':flagge_namibia:': u'\U0001F1F3\U0001F1E6',
	u':flagge_neukaledonien:': u'\U0001F1F3\U0001F1E8',
	u':flagge_niger:': u'\U0001F1F3\U0001F1EA',
	u':flagge_norfolkinsel:': u'\U0001F1F3\U0001F1EB',
	u':flagge_nigeria:': u'\U0001F1F3\U0001F1EC',
	u':flagge_nicaragua:': u'\U0001F1F3\U0001F1EE',
	u':flagge_niederlande:': u'\U0001F1F3\U0001F1F1',
	u':flagge_norwegen:': u'\U0001F1F3\U0001F1F4',
	u':flagge_nepal:': u'\U0001F1F3\U0001F1F5',
	u':flagge_nauru:': u'\U0001F1F3\U0001F1F7',
	u':flagge_niue:': u'\U0001F1F3\U0001F1FA',
	u':flagge_neuseeland:': u'\U0001F1F3\U0001F1FF',
	u':flagge_oman:': u'\U0001F1F4\U0001F1F2',
	u':flagge_panama:': u'\U0001F1F5\U0001F1E6',
	u':flagge_peru:': u'\U0001F1F5\U0001F1EA',
	u':flagge_französisch-polynesien:': u'\U0001F1F5\U0001F1EB',
	u':flagge_papua-neuguinea:': u'\U0001F1F5\U0001F1EC',
	u':flagge_philippinen:': u'\U0001F1F5\U0001F1ED',
	u':flagge_pakistan:': u'\U0001F1F5\U0001F1F0',
	u':flagge_polen:': u'\U0001F1F5\U0001F1F1',
	u':flagge_st._pierre_und_miquelon:': u'\U0001F1F5\U0001F1F2',
	u':flagge_pitcairninseln:': u'\U0001F1F5\U0001F1F3',
	u':flagge_puerto_rico:': u'\U0001F1F5\U0001F1F7',
	u':flagge_palästinensische_autonomiegebiete:': u'\U0001F1F5\U0001F1F8',
	u':flagge_portugal:': u'\U0001F1F5\U0001F1F9',
	u':flagge_palau:': u'\U0001F1F5\U0001F1FC',
	u':flagge_paraguay:': u'\U0001F1F5\U0001F1FE',
	u':flagge_katar:': u'\U0001F1F6\U0001F1E6',
	u':flagge_réunion:': u'\U0001F1F7\U0001F1EA',
	u':flagge_rumänien:': u'\U0001F1F7\U0001F1F4',
	u':flagge_serbien:': u'\U0001F1F7\U0001F1F8',
	u':flagge_russland:': u'\U0001F1F7\U0001F1FA',
	u':flagge_ruanda:': u'\U0001F1F7\U0001F1FC',
	u':flagge_saudi-arabien:': u'\U0001F1F8\U0001F1E6',
	u':flagge_salomonen:': u'\U0001F1F8\U0001F1E7',
	u':flagge_seychellen:': u'\U0001F1F8\U0001F1E8',
	u':flagge_sudan:': u'\U0001F1F8\U0001F1E9',
	u':flagge_schweden:': u'\U0001F1F8\U0001F1EA',
	u':flagge_singapur:': u'\U0001F1F8\U0001F1EC',
	u':flagge_st._helena:': u'\U0001F1F8\U0001F1ED',
	u':flagge_slowenien:': u'\U0001F1F8\U0001F1EE',
	u':flagge_spitzbergen_und_jan_mayen:': u'\U0001F1F8\U0001F1EF',
	u':flagge_slowakei:': u'\U0001F1F8\U0001F1F0',
	u':flagge_sierra_leone:': u'\U0001F1F8\U0001F1F1',
	u':flagge_san_marino:': u'\U0001F1F8\U0001F1F2',
	u':flagge_senegal:': u'\U0001F1F8\U0001F1F3',
	u':flagge_somalia:': u'\U0001F1F8\U0001F1F4',
	u':flagge_suriname:': u'\U0001F1F8\U0001F1F7',
	u':flagge_südsudan:': u'\U0001F1F8\U0001F1F8',
	u':flagge_são_tomé_und_príncipe:': u'\U0001F1F8\U0001F1F9',
	u':flagge_el_salvador:': u'\U0001F1F8\U0001F1FB',
	u':flagge_sint_maarten:': u'\U0001F1F8\U0001F1FD',
	u':flagge_syrien:': u'\U0001F1F8\U0001F1FE',
	u':flagge_eswatini:': u'\U0001F1F8\U0001F1FF',
	u':flagge_tristan_da_cunha:': u'\U0001F1F9\U0001F1E6',
	u':flagge_turks-_und_caicosinseln:': u'\U0001F1F9\U0001F1E8',
	u':flagge_tschad:': u'\U0001F1F9\U0001F1E9',
	u':flagge_französische_süd-_und_antarktisgebiete:': u'\U0001F1F9\U0001F1EB',
	u':flagge_togo:': u'\U0001F1F9\U0001F1EC',
	u':flagge_thailand:': u'\U0001F1F9\U0001F1ED',
	u':flagge_tadschikistan:': u'\U0001F1F9\U0001F1EF',
	u':flagge_tokelau:': u'\U0001F1F9\U0001F1F0',
	u':flagge_timor-leste:': u'\U0001F1F9\U0001F1F1',
	u':flagge_turkmenistan:': u'\U0001F1F9\U0001F1F2',
	u':flagge_tunesien:': u'\U0001F1F9\U0001F1F3',
	u':flagge_tonga:': u'\U0001F1F9\U0001F1F4',
	u':flagge_türkei:': u'\U0001F1F9\U0001F1F7',
	u':flagge_trinidad_und_tobago:': u'\U0001F1F9\U0001F1F9',
	u':flagge_tuvalu:': u'\U0001F1F9\U0001F1FB',
	u':flagge_taiwan:': u'\U0001F1F9\U0001F1FC',
	u':flagge_tansania:': u'\U0001F1F9\U0001F1FF',
	u':flagge_ukraine:': u'\U0001F1FA\U0001F1E6',
	u':flagge_uganda:': u'\U0001F1FA\U0001F1EC',
	u':flagge_amerikanische_überseeinseln:': u'\U0001F1FA\U0001F1F2',
	u':flagge_vereinte_nationen:': u'\U0001F1FA\U0001F1F3',
	u':flagge_vereinigte_staaten:': u'\U0001F1FA\U0001F1F8',
	u':flagge_uruguay:': u'\U0001F1FA\U0001F1FE',
	u':flagge_usbekistan:': u'\U0001F1FA\U0001F1FF',
	u':flagge_vatikanstadt:': u'\U0001F1FB\U0001F1E6',
	u':flagge_st._vincent_und_die_grenadinen:': u'\U0001F1FB\U0001F1E8',
	u':flagge_venezuela:': u'\U0001F1FB\U0001F1EA',
	u':flagge_britische_jungferninseln:': u'\U0001F1FB\U0001F1EC',
	u':flagge_amerikanische_jungferninseln:': u'\U0001F1FB\U0001F1EE',
	u':flagge_vietnam:': u'\U0001F1FB\U0001F1F3',
	u':flagge_vanuatu:': u'\U0001F1FB\U0001F1FA',
	u':flagge_wallis_und_futuna:': u'\U0001F1FC\U0001F1EB',
	u':flagge_samoa:': u'\U0001F1FC\U0001F1F8',
	u':flagge_kosovo:': u'\U0001F1FD\U0001F1F0',
	u':flagge_jemen:': u'\U0001F1FE\U0001F1EA',
	u':flagge_mayotte:': u'\U0001F1FE\U0001F1F9',
	u':flagge_südafrika:': u'\U0001F1FF\U0001F1E6',
	u':flagge_sambia:': u'\U0001F1FF\U0001F1F2',
	u':flagge_simbabwe:': u'\U0001F1FF\U0001F1FC',
	u':flagge_england:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
	u':flagge_schottland:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
	u':flagge_wales:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F'
}

UNICODE_EMOJI_GERMAN = {v: k for k, v in EMOJI_UNICODE_GERMAN.items()}
