/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingClusterStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingDistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.FreeDiskVariable;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.ConditionalMapWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyHelper {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String POLICY_MAPPING_KEY = "PolicyHelper.policyMapping";
    public static final int SESSION_EXPIRY = 180;
    static ThreadLocal<SessionWrapper> SESSION_WRAPPPER_REF = new ThreadLocal();

    private static ThreadLocal<Map<String, String>> getPolicyMapping(SolrCloudManager cloudManager) {
        return (ThreadLocal)cloudManager.getObjectCache().computeIfAbsent(POLICY_MAPPING_KEY, k -> new ThreadLocal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReplicaPosition> getReplicaLocations(String collName, final AutoScalingConfig autoScalingConfig, SolrCloudManager cloudManager, final Map<String, String> optionalPolicyMapping, List<String> shardNames, int nrtReplicas, int tlogReplicas, int pullReplicas, List<String> nodesList) {
        ArrayList<ReplicaPosition> positions = new ArrayList<ReplicaPosition>();
        final ThreadLocal<Map<String, String>> policyMapping = PolicyHelper.getPolicyMapping(cloudManager);
        final DelegatingClusterStateProvider stateProvider = new DelegatingClusterStateProvider(cloudManager.getClusterStateProvider()){

            @Override
            public String getPolicyNameByCollection(String coll) {
                return policyMapping.get() != null && ((Map)policyMapping.get()).containsKey(coll) ? (String)optionalPolicyMapping.get(coll) : this.delegate.getPolicyNameByCollection(coll);
            }
        };
        DelegatingCloudManager delegatingManager = new DelegatingCloudManager(cloudManager){

            @Override
            public ClusterStateProvider getClusterStateProvider() {
                return stateProvider;
            }

            @Override
            public DistribStateManager getDistribStateManager() {
                if (autoScalingConfig != null) {
                    return new DelegatingDistribStateManager(null){

                        @Override
                        public AutoScalingConfig getAutoScalingConfig() {
                            return autoScalingConfig;
                        }
                    };
                }
                return super.getDistribStateManager();
            }
        };
        policyMapping.set(optionalPolicyMapping);
        SessionWrapper sessionWrapper = null;
        try {
            try {
                sessionWrapper = PolicyHelper.getSession(delegatingManager);
                SESSION_WRAPPPER_REF.set(sessionWrapper);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "unable to get autoscaling policy session", (Throwable)e);
            }
            Policy.Session origSession = sessionWrapper.session;
            Policy.Session newSession = origSession.cloneToNewSession(delegatingManager);
            HashMap<String, Double> diskSpaceReqd = new HashMap<String, Double>();
            try {
                DocCollection coll = cloudManager.getClusterStateProvider().getCollection(collName);
                if (coll != null) {
                    for (String shardName : shardNames) {
                        Object idxSz;
                        Map<String, Map<String, List<ReplicaInfo>>> details;
                        ReplicaInfo replicaInfo;
                        Replica ldr = coll.getLeader(shardName);
                        if (ldr == null || !cloudManager.getClusterStateProvider().getLiveNodes().contains(ldr.getNodeName()) || (replicaInfo = (ReplicaInfo)(details = cloudManager.getNodeStateProvider().getReplicaInfo(ldr.getNodeName(), Collections.singleton(Variable.Type.FREEDISK.perReplicaValue))).getOrDefault(collName, Collections.emptyMap()).getOrDefault(shardName, Collections.singletonList(null)).get(0)) == null || (idxSz = replicaInfo.getVariables().get(Variable.Type.FREEDISK.perReplicaValue)) == null) continue;
                        diskSpaceReqd.put(shardName, 1.5 * (Double)Variable.Type.FREEDISK.validate(null, idxSz, false));
                    }
                }
            }
            catch (IOException e) {
                log.warn("Exception while reading disk free metric values for nodes to be used for collection: {}", (Object)collName, (Object)e);
            }
            EnumMap<Replica.Type, Integer> typeVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
            typeVsCount.put(Replica.Type.NRT, nrtReplicas);
            typeVsCount.put(Replica.Type.TLOG, tlogReplicas);
            typeVsCount.put(Replica.Type.PULL, pullReplicas);
            for (String shardName : shardNames) {
                int idx = 0;
                for (Map.Entry e : typeVsCount.entrySet()) {
                    for (int i = 0; i < (Integer)e.getValue(); ++i) {
                        SolrRequest op;
                        Suggester suggester = newSession.getSuggester(CollectionParams.CollectionAction.ADDREPLICA).hint(Suggester.Hint.REPLICATYPE, e.getKey()).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(collName, shardName));
                        if (nodesList != null) {
                            for (String nodeName : nodesList) {
                                suggester = suggester.hint(Suggester.Hint.TARGET_NODE, nodeName);
                            }
                        }
                        if (diskSpaceReqd.get(shardName) != null) {
                            suggester.hint(Suggester.Hint.MINFREEDISK, diskSpaceReqd.get(shardName));
                        }
                        if ((op = suggester.getSuggestion()) == null) {
                            String errorId = "AutoScaling.error.diagnostics." + System.nanoTime();
                            Policy.Session sessionCopy = suggester.session;
                            log.error("errorId : {} {}", (Object)errorId, (Object)Utils.handleExp(log, "", () -> Utils.writeJson((Object)PolicyHelper.getDiagnostics(sessionCopy), new StringWriter(), true).toString()));
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " No node can satisfy the rules " + Utils.toJSONString(Utils.getDeepCopy(newSession.expandedClauses, 4, true) + " More details from logs in node : " + Utils.getMDCNode() + ", errorId : " + errorId));
                        }
                        newSession = suggester.getSession();
                        positions.add(new ReplicaPosition(shardName, ++idx, (Replica.Type)((Object)e.getKey()), op.getParams().get("node")));
                    }
                }
            }
            sessionWrapper.update(newSession);
        }
        finally {
            policyMapping.remove();
            if (sessionWrapper != null) {
                sessionWrapper.returnSession();
            }
        }
        return positions;
    }

    public static MapWriter getDiagnostics(Policy policy, SolrCloudManager cloudManager) {
        Policy.Session session = policy.createSession(cloudManager);
        return PolicyHelper.getDiagnostics(session);
    }

    public static MapWriter getDiagnostics(Policy.Session session) {
        List<Row> sorted = session.getSortedNodes();
        return ew -> {
            PolicyHelper.writeNodes(ew, sorted);
            ew.put((CharSequence)"liveNodes", session.cloudManager.getClusterStateProvider().getLiveNodes()).put((CharSequence)"violations", session.getViolations()).put((CharSequence)"config", session.getPolicy());
        };
    }

    static void writeNodes(MapWriter.EntryWriter ew, List<Row> sorted) throws IOException {
        HashSet<CharSequence> alreadyWritten = new HashSet<CharSequence>();
        BiPredicate<CharSequence, Object> p = ConditionalMapWriter.dedupeKeyPredicate(alreadyWritten).and(ConditionalMapWriter.NON_NULL_VAL).and((s, o) -> !(o instanceof Map) || !((Map)o).isEmpty());
        ew.put((CharSequence)"sortedNodes", iw -> {
            for (Row row : sorted) {
                iw.add(ew1 -> {
                    alreadyWritten.clear();
                    ew1.put("node", row.node, p).put("isLive", row.isLive, p);
                    for (Cell cell : row.getCells()) {
                        ew1.put(cell.name, cell.val, p);
                    }
                    ew1.put((CharSequence)"replicas", row.collectionVsShardVsReplicas);
                });
            }
        });
    }

    public static List<Suggester.SuggestionInfo> getSuggestions(AutoScalingConfig autoScalingConf, SolrCloudManager cloudManager, SolrParams params) {
        return PolicyHelper.getSuggestions(autoScalingConf, cloudManager, 20, 10, params);
    }

    public static List<Suggester.SuggestionInfo> getSuggestions(AutoScalingConfig autoScalingConf, SolrCloudManager cloudManager) {
        return PolicyHelper.getSuggestions(autoScalingConf, cloudManager, 20, 10, null);
    }

    public static List<Suggester.SuggestionInfo> getSuggestions(AutoScalingConfig autoScalingConf, SolrCloudManager cloudManager, int max, int timeoutInSecs, SolrParams params) {
        List<Object> types;
        Policy policy = autoScalingConf.getPolicy();
        Suggestion.Ctx ctx = new Suggestion.Ctx();
        ctx.endTime = cloudManager.getTimeSource().getTimeNs() + TimeUnit.SECONDS.toNanos(timeoutInSecs);
        ctx.max = max;
        ctx.session = policy.createSession(cloudManager);
        String[] t = params == null ? null : params.getParams("type");
        List<Object> list = types = t == null ? Collections.emptyList() : Arrays.asList(t);
        if (types.isEmpty() || types.contains(Suggestion.Type.violation.name())) {
            List<Violation> violations = ctx.session.getViolations();
            for (Violation violation : violations) {
                violation.getClause().getThirdTag().varType.getSuggestions(ctx.setViolation(violation));
                ctx.violation = null;
            }
            block3: for (Violation current : ctx.session.getViolations()) {
                for (Violation old : violations) {
                    if (!ctx.needMore()) {
                        return ctx.getSuggestions();
                    }
                    if (!current.equals(old)) continue;
                    ctx.suggestions.add(new Suggester.SuggestionInfo(current, null, Suggestion.Type.unresolved_violation));
                    continue block3;
                }
            }
        }
        if ((types.isEmpty() || types.contains(Suggestion.Type.repair.name())) && ctx.needMore()) {
            try {
                PolicyHelper.addMissingReplicas(cloudManager, ctx);
            }
            catch (IOException e) {
                log.error("Unable to fetch cluster state", (Throwable)e);
            }
        }
        if ((types.isEmpty() || types.contains(Suggestion.Type.improvement.name())) && ctx.needMore()) {
            PolicyHelper.suggestOptimizations(ctx, Math.min(ctx.max - ctx.getSuggestions().size(), 10));
        }
        return ctx.getSuggestions();
    }

    private static void addMissingReplicas(SolrCloudManager cloudManager, Suggestion.Ctx ctx) throws IOException {
        cloudManager.getClusterStateProvider().getClusterState().forEachCollection(coll -> coll.forEach(slice -> {
            if (!ctx.needMore()) {
                return;
            }
            ReplicaCount replicaCount = new ReplicaCount();
            slice.forEach(replica -> {
                if (replica.getState() == Replica.State.ACTIVE || replica.getState() == Replica.State.RECOVERING) {
                    replicaCount.increment(replica.getType());
                }
            });
            PolicyHelper.addMissingReplicas(replicaCount, coll, slice.getName(), Replica.Type.NRT, ctx);
            PolicyHelper.addMissingReplicas(replicaCount, coll, slice.getName(), Replica.Type.PULL, ctx);
            PolicyHelper.addMissingReplicas(replicaCount, coll, slice.getName(), Replica.Type.TLOG, ctx);
        }));
    }

    private static void addMissingReplicas(ReplicaCount count, DocCollection coll, String shard, Replica.Type type, Suggestion.Ctx ctx) {
        int delta = count.delta(coll.getExpectedReplicaCount(type, 0), type);
        while (true) {
            if (!ctx.needMore()) {
                return;
            }
            if (delta >= 0) break;
            SolrRequest suggestion = ctx.addSuggestion(ctx.session.getSuggester(CollectionParams.CollectionAction.ADDREPLICA).hint(Suggester.Hint.REPLICATYPE, (Object)type).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(coll.getName(), shard)), Suggestion.Type.repair);
            if (suggestion == null) {
                return;
            }
            ++delta;
        }
    }

    private static void suggestOptimizations(Suggestion.Ctx ctx, int count) {
        int maxTotalSuggestions = ctx.getSuggestions().size() + count;
        List<Row> matrix = ctx.session.matrix;
        if (matrix.isEmpty()) {
            return;
        }
        block0: for (int i = 0; i < matrix.size() && ctx.getSuggestions().size() < maxTotalSuggestions && !ctx.hasTimedOut(); ++i) {
            Row row = matrix.get(i);
            HashMap collVsShards = new HashMap();
            row.forEachReplica(ri -> collVsShards.computeIfAbsent(ri.getCollection(), s -> new HashSet()).add(ri.getShard()));
            for (Map.Entry entry : collVsShards.entrySet()) {
                entry.setValue(FreeDiskVariable.getSortedShards(Collections.singletonList(row), (Collection)entry.getValue(), (String)entry.getKey()));
            }
            block2: for (Map.Entry entry : collVsShards.entrySet()) {
                if (!ctx.needMore()) {
                    return;
                }
                if (ctx.getSuggestions().size() >= maxTotalSuggestions || ctx.hasTimedOut()) continue block0;
                for (String shard : (Collection)entry.getValue()) {
                    Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.COLL_SHARD, new Pair(entry.getKey(), shard)).hint(Suggester.Hint.SRC_NODE, row.node);
                    ctx.addSuggestion(suggester, Suggestion.Type.improvement);
                    if (ctx.getSuggestions().size() < maxTotalSuggestions) continue;
                    continue block2;
                }
            }
        }
    }

    public static void logState(SolrCloudManager cloudManager, Suggester suggester) {
        if (log.isTraceEnabled()) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("LOGSTATE: {}", (Object)Utils.writeJson((Object)PolicyHelper.loggingInfo(cloudManager.getDistribStateManager().getAutoScalingConfig().getPolicy(), cloudManager, suggester), new StringWriter(), true));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static MapWriter loggingInfo(Policy policy, SolrCloudManager cloudManager, Suggester suggester) {
        return ew -> {
            ew.put((CharSequence)"diagnostics", PolicyHelper.getDiagnostics(policy, cloudManager));
            if (suggester != null) {
                ew.put((CharSequence)"suggester", suggester);
            }
        };
    }

    public static SessionWrapper getSession(SolrCloudManager cloudManager) throws IOException, InterruptedException {
        return PolicyHelper.getSession(cloudManager, true);
    }

    static SessionWrapper getSession(SolrCloudManager cloudManager, boolean allowWait) throws IOException, InterruptedException {
        SessionRef sessionRef = (SessionRef)cloudManager.getObjectCache().computeIfAbsent(SessionRef.class.getName(), s -> new SessionRef());
        return sessionRef.get(cloudManager, allowWait);
    }

    public static SessionWrapper getLastSessionWrapper(boolean clear) {
        SessionWrapper wrapper = SESSION_WRAPPPER_REF.get();
        if (clear) {
            SESSION_WRAPPPER_REF.remove();
        }
        return wrapper;
    }

    public static class SessionWrapper {
        private final long createTime;
        private long lastUpdateTime;
        private Policy.Session session;
        public Status status;
        private final SessionRef ref;
        private final AtomicInteger refCount = new AtomicInteger();
        public final long zkVersion;

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public SessionWrapper(Policy.Session session, SessionRef ref) {
            this.lastUpdateTime = this.createTime = session.cloudManager.getTimeSource().getTimeNs();
            this.session = session;
            this.status = Status.COMPUTING;
            this.ref = ref;
            this.zkVersion = session.getPolicy().getZkVersion();
        }

        public Policy.Session get() {
            return this.session;
        }

        public void update(Policy.Session session) {
            this.lastUpdateTime = session.cloudManager.getTimeSource().getTimeNs();
            this.session = session;
        }

        public int getRefCount() {
            return this.refCount.get();
        }

        public void returnSession(Policy.Session session) {
            if (this.status != Status.COMPUTING) {
                log.warn("returning session {} not in state COMPUTING", (Object)this.getCreateTime());
            }
            this.update(session);
            this.returnSession();
        }

        public void returnSession() {
            this.refCount.incrementAndGet();
            this.ref.returnSession(this);
        }

        public void release() {
            if (this.refCount.decrementAndGet() <= 0) {
                this.ref.release(this);
            }
        }
    }

    static class SessionRef {
        private final Object lockObj = new Object();
        private Set<SessionWrapper> sessionWrapperSet = Collections.newSetFromMap(new IdentityHashMap());
        private int creationsInProgress = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isEmpty() {
            Object object = this.lockObj;
            synchronized (object) {
                return this.sessionWrapperSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release(SessionWrapper sessionWrapper) {
            boolean present;
            Object object = this.lockObj;
            synchronized (object) {
                present = this.sessionWrapperSet.remove(sessionWrapper);
            }
            if (!present) {
                log.warn("released session {} not found in session set", (Object)sessionWrapper.getCreateTime());
            } else if (log.isDebugEnabled()) {
                TimeSource timeSource = ((SessionWrapper)sessionWrapper).session.cloudManager.getTimeSource();
                log.debug("final release, session {} lived a total of {}ms, ", (Object)sessionWrapper.getCreateTime(), (Object)Utils.timeElapsed(timeSource, TimeUnit.MILLISECONDS.convert(sessionWrapper.getCreateTime(), TimeUnit.NANOSECONDS), TimeUnit.MILLISECONDS));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void returnSession(SessionWrapper sessionWrapper) {
            boolean present;
            Object object = this.lockObj;
            synchronized (object) {
                sessionWrapper.status = Status.EXECUTING;
                present = this.sessionWrapperSet.contains(sessionWrapper);
                this.lockObj.notify();
            }
            if (present) {
                if (log.isDebugEnabled()) {
                    log.debug("returnSession {}", (Object)sessionWrapper.getCreateTime());
                }
            } else {
                log.warn("returning unknown session {} ", (Object)sessionWrapper.getCreateTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionWrapper get(SolrCloudManager cloudManager, boolean allowWait) throws IOException, InterruptedException {
            TimeSource timeSource = cloudManager.getTimeSource();
            long oldestUpdateTimeNs = TimeUnit.SECONDS.convert(timeSource.getTimeNs(), TimeUnit.NANOSECONDS) - 180L;
            int zkVersion = cloudManager.getDistribStateManager().getAutoScalingConfig().getZkVersion();
            Object object = this.lockObj;
            synchronized (object) {
                SessionWrapper sw = this.getAvailableSession(zkVersion, oldestUpdateTimeNs);
                if (sw != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("reusing session {}", (Object)sw.getCreateTime());
                    }
                    return sw;
                }
                if ((this.creationsInProgress != 0 || this.hasCandidateSession(zkVersion, oldestUpdateTimeNs)) && allowWait) {
                    long waitForMs = (long)(Math.random() * 9.0 * 1000.0) + 1000L;
                    if (log.isDebugEnabled()) {
                        log.debug("No sessions are available, all busy COMPUTING (or {} creations in progress). starting wait of {}ms", (Object)this.creationsInProgress, (Object)waitForMs);
                    }
                    long waitStart = Utils.time(timeSource, TimeUnit.MILLISECONDS);
                    try {
                        this.lockObj.wait(waitForMs);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("out of waiting. wait of {}ms, actual time elapsed {}ms", (Object)waitForMs, (Object)Utils.timeElapsed(timeSource, waitStart, TimeUnit.MILLISECONDS));
                    }
                    if ((sw = this.getAvailableSession(zkVersion, oldestUpdateTimeNs)) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("reusing session {} after wait", (Object)sw.getCreateTime());
                        }
                        return sw;
                    }
                }
                ++this.creationsInProgress;
            }
            SessionWrapper newSessionWrapper = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Creating a new session");
                }
                Policy.Session session = cloudManager.getDistribStateManager().getAutoScalingConfig().getPolicy().createSession(cloudManager);
                newSessionWrapper = new SessionWrapper(session, this);
                if (log.isDebugEnabled()) {
                    log.debug("New session created, {}", (Object)newSessionWrapper.getCreateTime());
                }
                SessionWrapper sessionWrapper = newSessionWrapper;
                return sessionWrapper;
            }
            finally {
                Object object2 = this.lockObj;
                synchronized (object2) {
                    --this.creationsInProgress;
                    if (newSessionWrapper != null) {
                        this.sessionWrapperSet.add(newSessionWrapper);
                    }
                }
            }
        }

        private SessionWrapper getAvailableSession(int zkVersion, long oldestUpdateTimeNs) {
            for (SessionWrapper sw : this.sessionWrapperSet) {
                if (sw.status != Status.EXECUTING || sw.getLastUpdateTime() < oldestUpdateTimeNs || sw.zkVersion != (long)zkVersion) continue;
                sw.status = Status.COMPUTING;
                return sw;
            }
            return null;
        }

        private boolean hasCandidateSession(int zkVersion, long oldestUpdateTimeNs) {
            for (SessionWrapper sw : this.sessionWrapperSet) {
                if (sw.getLastUpdateTime() < oldestUpdateTimeNs || sw.zkVersion != (long)zkVersion) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Status {
        COMPUTING,
        EXECUTING;

    }
}

