/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public final class JmxUtil {
    public static MBeanServer findFirstMBeanServer() {
        MBeanServer mBeanServer = JmxUtil.findMBeanServerForAgentId(null);
        if (mBeanServer == null) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        return mBeanServer;
    }

    public static MBeanServer findMBeanServerForServiceUrl(String serviceUrl) throws IOException {
        if (serviceUrl == null) {
            return null;
        }
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(serviceUrl), null, server);
        connector.start();
        return server;
    }

    public static MBeanServer findMBeanServerForAgentId(String agentId) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        return (MBeanServer)servers.get(0);
    }
}

