/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.speedlimit;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.InvocationCallback;
import org.traccar.Context;
import org.traccar.helper.UnitsConverter;
import org.traccar.speedlimit.SpeedLimitException;
import org.traccar.speedlimit.SpeedLimitProvider;

public class OverpassSpeedLimitProvider
implements SpeedLimitProvider {
    private final String url;

    public OverpassSpeedLimitProvider(String url) {
        this.url = url + "?data=[out:json];way[maxspeed](around:100.0,%f,%f);out%%20tags;";
    }

    private Double parseSpeed(String value) {
        if (value.endsWith(" mph")) {
            return UnitsConverter.knotsFromMph(Double.parseDouble(value.substring(0, value.length() - 4)));
        }
        if (value.endsWith(" knots")) {
            return Double.parseDouble(value.substring(0, value.length() - 6));
        }
        if (value.matches("\\d+")) {
            return UnitsConverter.knotsFromKph(Double.parseDouble(value));
        }
        return null;
    }

    @Override
    public void getSpeedLimit(double latitude, double longitude, final SpeedLimitProvider.SpeedLimitProviderCallback callback) {
        String formattedUrl = String.format(this.url, latitude, longitude);
        AsyncInvoker invoker = Context.getClient().target(formattedUrl).request().async();
        invoker.get((InvocationCallback)new InvocationCallback<JsonObject>(){

            public void completed(JsonObject json) {
                JsonArray elements = json.getJsonArray("elements");
                if (!elements.isEmpty()) {
                    Double maxSpeed = OverpassSpeedLimitProvider.this.parseSpeed(elements.getJsonObject(0).getJsonObject("tags").getString("maxspeed"));
                    if (maxSpeed != null) {
                        callback.onSuccess(maxSpeed);
                    } else {
                        callback.onFailure(new SpeedLimitException("Parsing failed"));
                    }
                } else {
                    callback.onFailure(new SpeedLimitException("Not found"));
                }
            }

            public void failed(Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }
}

