/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;

public class NavtelecomProtocolDecoder
extends BaseProtocolDecoder {
    public NavtelecomProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(4);
        int receiver = buf.readIntLE();
        int sender = buf.readIntLE();
        int length = buf.readUnsignedShortLE();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        String sentence = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString();
        if (sentence.startsWith("*>S")) {
            String data = "*<S";
            ByteBuf response = Unpooled.buffer();
            response.writeCharSequence((CharSequence)"@NTC", StandardCharsets.US_ASCII);
            response.writeIntLE(sender);
            response.writeIntLE(receiver);
            response.writeShortLE(data.length());
            response.writeByte(Checksum.xor(data));
            response.writeByte(Checksum.xor(response.nioBuffer()));
            response.writeCharSequence((CharSequence)data, StandardCharsets.US_ASCII);
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        }
        return null;
    }
}

