/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Context;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;
import org.traccar.protocol.HuabaoProtocolDecoder;

public class HuabaoProtocolEncoder
extends BaseProtocolEncoder {
    public HuabaoProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = Context.getIdentityManager().lookupAttributeBoolean(command.getDeviceId(), this.getProtocolName() + ".alternative", false, false, true);
        ByteBuf id = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(this.getUniqueId(command.getDeviceId())));
        try {
            ByteBuf data = Unpooled.buffer();
            byte[] time = DataConverter.parseHex(new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
            switch (command.getType()) {
                case "engineStop": {
                    if (alternative) {
                        data.writeByte(1);
                        data.writeBytes(time);
                        ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(40966, id, false, data);
                        return byteBuf;
                    }
                    data.writeByte(240);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(33029, id, false, data);
                    return byteBuf;
                }
                case "engineResume": {
                    if (alternative) {
                        data.writeByte(0);
                        data.writeBytes(time);
                        ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(40966, id, false, data);
                        return byteBuf;
                    }
                    data.writeByte(241);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(33029, id, false, data);
                    return byteBuf;
                }
            }
            Object var8_12 = null;
            return var8_12;
        }
        finally {
            id.release();
        }
    }
}

