/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.protocol.Jt600ProtocolDecoder;

public class HuabaoProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_GENERAL_RESPONSE = 32769;
    public static final int MSG_GENERAL_RESPONSE_2 = 17409;
    public static final int MSG_HEARTBEAT = 2;
    public static final int MSG_TERMINAL_REGISTER = 256;
    public static final int MSG_TERMINAL_REGISTER_RESPONSE = 33024;
    public static final int MSG_TERMINAL_CONTROL = 33029;
    public static final int MSG_TERMINAL_AUTH = 258;
    public static final int MSG_LOCATION_REPORT = 512;
    public static final int MSG_LOCATION_REPORT_2 = 21761;
    public static final int MSG_LOCATION_REPORT_BLIND = 21762;
    public static final int MSG_LOCATION_BATCH = 1796;
    public static final int MSG_OIL_CONTROL = 40966;
    public static final int MSG_TIME_SYNC_REQUEST = 265;
    public static final int MSG_TIME_SYNC_RESPONSE = 33033;
    public static final int RESULT_SUCCESS = 0;

    public HuabaoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static ByteBuf formatMessage(int type, ByteBuf id, boolean shortIndex, ByteBuf data) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(126);
        buf.writeShort(type);
        buf.writeShort(data.readableBytes());
        buf.writeBytes(id);
        if (shortIndex) {
            buf.writeByte(1);
        } else {
            buf.writeShort(1);
        }
        buf.writeBytes(data);
        data.release();
        buf.writeByte(Checksum.xor(buf.nioBuffer(1, buf.readableBytes() - 1)));
        buf.writeByte(126);
        return buf;
    }

    private void sendGeneralResponse(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(index);
            response.writeShort(type);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(32769, id, false, response), remoteAddress));
        }
    }

    private void sendGeneralResponse2(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(type);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(17409, id, true, response), remoteAddress));
        }
    }

    private String decodeAlarm(long value) {
        if (BitUtil.check(value, 0)) {
            return "sos";
        }
        if (BitUtil.check(value, 1)) {
            return "overspeed";
        }
        if (BitUtil.check(value, 5)) {
            return "gpsAntennaCut";
        }
        if (BitUtil.check(value, 4) || BitUtil.check(value, 9) || BitUtil.check(value, 10) || BitUtil.check(value, 11)) {
            return "fault";
        }
        if (BitUtil.check(value, 8)) {
            return "powerOff";
        }
        if (BitUtil.check(value, 17)) {
            return "tampering";
        }
        if (BitUtil.check(value, 20)) {
            return "geofence";
        }
        if (BitUtil.check(value, 28)) {
            return "movement";
        }
        if (BitUtil.check(value, 29)) {
            return "accident";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) == 40) {
            return this.decodeResult(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
        }
        buf.readUnsignedByte();
        int type = buf.readUnsignedShort();
        int attribute = buf.readUnsignedShort();
        ByteBuf id = buf.readSlice(6);
        int index = type == 21761 || type == 21762 ? buf.readUnsignedByte() : buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)id));
        if (deviceSession == null) {
            return null;
        }
        if (deviceSession.getTimeZone() == null) {
            deviceSession.setTimeZone(this.getTimeZone(deviceSession.getDeviceId(), "GMT+8"));
        }
        if (type == 256) {
            if (channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeShort(index);
                response.writeByte(0);
                response.writeBytes(ByteBufUtil.hexDump((ByteBuf)id).getBytes(StandardCharsets.US_ASCII));
                channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(33024, id, false, response), remoteAddress));
            }
        } else if (type == 258 || type == 2) {
            this.sendGeneralResponse(channel, remoteAddress, id, type, index);
        } else {
            if (type == 512) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                return this.decodeLocation(deviceSession, buf);
            }
            if (type == 21761 || type == 21762) {
                if (BitUtil.check(attribute, 15)) {
                    this.sendGeneralResponse2(channel, remoteAddress, id, type);
                }
                return this.decodeLocation2(deviceSession, buf, type);
            }
            if (type == 1796) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                return this.decodeLocationBatch(deviceSession, buf);
            }
            if (type == 265 && channel != null) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                ByteBuf response = Unpooled.buffer();
                response.writeShort(calendar.get(1));
                response.writeByte(calendar.get(2) + 1);
                response.writeByte(calendar.get(5));
                response.writeByte(calendar.get(11));
                response.writeByte(calendar.get(12));
                response.writeByte(calendar.get(13));
                channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(33024, id, false, response), remoteAddress));
            }
        }
        return null;
    }

    private Position decodeResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession != null) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            position.set("result", sentence);
            return position;
        }
        return null;
    }

    private Position decodeLocation(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("alarm", this.decodeAlarm(buf.readUnsignedInt()));
        int status = buf.readInt();
        position.set("ignition", BitUtil.check(status, 0));
        position.set("blocked", BitUtil.check(status, 10));
        position.setValid(BitUtil.check(status, 1));
        double lat = (double)buf.readUnsignedInt() * 1.0E-6;
        double lon = (double)buf.readUnsignedInt() * 1.0E-6;
        if (BitUtil.check(status, 2)) {
            position.setLatitude(-lat);
        } else {
            position.setLatitude(lat);
        }
        if (BitUtil.check(status, 3)) {
            position.setLongitude(-lon);
        } else {
            position.setLongitude(lon);
        }
        position.setAltitude(buf.readShort());
        position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
        position.setCourse(buf.readUnsignedShort());
        DateBuilder dateBuilder = new DateBuilder(deviceSession.getTimeZone()).setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
        position.setTime(dateBuilder.getDate());
        if (buf.readableBytes() == 20) {
            buf.skipBytes(4);
            position.set("odometer", buf.readUnsignedInt() * 1000L);
            position.set("battery", (double)buf.readUnsignedShort() * 0.1);
            buf.readUnsignedInt();
            position.set("rssi", buf.readUnsignedByte());
            buf.skipBytes(3);
            return position;
        }
        while (buf.readableBytes() > 2) {
            short subtype = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            int endIndex = buf.readerIndex() + length;
            switch (subtype) {
                case 1: {
                    position.set("odometer", buf.readUnsignedInt() * 100L);
                    break;
                }
                case 2: {
                    position.set("fuel", (double)buf.readUnsignedShort() * 0.1);
                    break;
                }
                case 48: {
                    position.set("rssi", buf.readUnsignedByte());
                    break;
                }
                case 49: {
                    position.set("sat", buf.readUnsignedByte());
                    break;
                }
                case 51: {
                    String sentence = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    if (!sentence.startsWith("*M00")) break;
                    String lockStatus = sentence.substring(8, 15);
                    position.set("battery", (double)Integer.parseInt(lockStatus.substring(2, 5)) * 0.01);
                    break;
                }
                case 145: {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.1);
                    position.set("rpm", buf.readUnsignedShort());
                    position.set("obdSpeed", buf.readUnsignedByte());
                    position.set("throttle", buf.readUnsignedByte() * 100 / 255);
                    position.set("engineLoad", buf.readUnsignedByte() * 100 / 255);
                    position.set("coolantTemp", buf.readUnsignedByte() - 40);
                    buf.readUnsignedShort();
                    position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.01);
                    buf.readUnsignedShort();
                    buf.readUnsignedInt();
                    buf.readUnsignedShort();
                    position.set("fuelUsed", (double)buf.readUnsignedShort() * 0.01);
                    break;
                }
                case 148: {
                    if (length <= 0) break;
                    position.set("vin", buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString());
                    break;
                }
                case 208: {
                    long userStatus = buf.readUnsignedInt();
                    if (!BitUtil.check(userStatus, 3)) break;
                    position.set("alarm", "vibration");
                    break;
                }
                case 211: {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                    break;
                }
                case 212: 
                case 254: {
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
                case 213: {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                    break;
                }
                case 218: {
                    buf.readUnsignedShort();
                    short deviceStatus = buf.readUnsignedByte();
                    position.set("string", BitUtil.check(deviceStatus, 0));
                    position.set("motion", BitUtil.check(deviceStatus, 2));
                    position.set("cover", BitUtil.check(deviceStatus, 3));
                    break;
                }
                case 235: {
                    if (buf.getUnsignedShort(buf.readerIndex()) > 200) {
                        Network network = new Network();
                        int mcc = buf.readUnsignedShort();
                        short mnc = buf.readUnsignedByte();
                        while (buf.readerIndex() < endIndex) {
                            network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
                        }
                        position.setNetwork(network);
                        break;
                    }
                    block22: while (buf.readerIndex() < endIndex) {
                        int extendedLength = buf.readUnsignedShort();
                        int extendedType = buf.readUnsignedShort();
                        switch (extendedType) {
                            case 1: {
                                position.set("fuel1", (double)buf.readUnsignedShort() * 0.1);
                                buf.readUnsignedByte();
                                continue block22;
                            }
                            case 35: {
                                position.set("fuel2", Double.parseDouble(buf.readCharSequence(6, StandardCharsets.US_ASCII).toString()));
                                continue block22;
                            }
                            case 206: {
                                position.set("power", (double)buf.readUnsignedShort() * 0.01);
                                continue block22;
                            }
                        }
                        buf.skipBytes(extendedLength - 2);
                    }
                    break;
                }
            }
            buf.readerIndex(endIndex);
        }
        return position;
    }

    private Position decodeLocation2(DeviceSession deviceSession, ByteBuf buf, int type) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        Jt600ProtocolDecoder.decodeBinaryLocation(buf, position);
        position.setValid(type != 21762);
        position.set("rssi", buf.readUnsignedByte());
        position.set("sat", buf.readUnsignedByte());
        position.set("odometer", buf.readUnsignedInt() * 1000L);
        short battery = buf.readUnsignedByte();
        if (battery <= 100) {
            position.set("batteryLevel", Integer.valueOf(battery));
        } else if (battery == 170) {
            position.set("charge", true);
        }
        position.setNetwork(new Network(CellTower.fromCidLac(buf.readUnsignedInt(), buf.readUnsignedShort())));
        short product = buf.readUnsignedByte();
        int status = buf.readUnsignedShort();
        int alarm = buf.readUnsignedShort();
        if (product == 1 || product == 2) {
            if (BitUtil.check(alarm, 0)) {
                position.set("alarm", "lowPower");
            }
        } else if (product == 3) {
            position.set("blocked", BitUtil.check(status, 5));
            if (BitUtil.check(alarm, 1)) {
                position.set("alarm", "lowPower");
            }
            if (BitUtil.check(alarm, 2)) {
                position.set("alarm", "vibration");
            }
            if (BitUtil.check(alarm, 3)) {
                position.set("alarm", "lowBattery");
            }
        }
        position.set("status", status);
        return position;
    }

    private List<Position> decodeLocationBatch(DeviceSession deviceSession, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        int count = buf.readUnsignedShort();
        buf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            int endIndex = buf.readUnsignedShort() + buf.readerIndex();
            positions.add(this.decodeLocation(deviceSession, buf));
            buf.readerIndex(endIndex);
        }
        return positions;
    }
}

