/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.Position;

public class BlackKiteProtocolDecoder
extends BaseProtocolDecoder {
    private static final int TAG_IMEI = 3;
    private static final int TAG_DATE = 32;
    private static final int TAG_COORDINATES = 48;
    private static final int TAG_SPEED_COURSE = 51;
    private static final int TAG_ALTITUDE = 52;
    private static final int TAG_STATUS = 64;
    private static final int TAG_DIGITAL_OUTPUTS = 69;
    private static final int TAG_DIGITAL_INPUTS = 70;
    private static final int TAG_INPUT_VOLTAGE1 = 80;
    private static final int TAG_INPUT_VOLTAGE2 = 81;
    private static final int TAG_INPUT_VOLTAGE3 = 82;
    private static final int TAG_INPUT_VOLTAGE4 = 83;
    private static final int TAG_XT1 = 96;
    private static final int TAG_XT2 = 97;
    private static final int TAG_XT3 = 98;

    public BlackKiteProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int checksum) {
        if (channel != null) {
            ByteBuf reply = Unpooled.buffer((int)3);
            reply.writeByte(2);
            reply.writeShortLE((int)((short)checksum));
            channel.writeAndFlush((Object)new NetworkMessage(reply, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        int length = (buf.readUnsignedShortLE() & Short.MAX_VALUE) + 3;
        LinkedList<Position> positions = new LinkedList<Position>();
        HashSet<Integer> tags = new HashSet<Integer>();
        boolean hasLocation = false;
        Position position = new Position(this.getProtocolName());
        block15: while (buf.readerIndex() < length) {
            short tag = buf.readUnsignedByte();
            if (tags.contains(tag)) {
                if (hasLocation && position.getFixTime() != null) {
                    positions.add(position);
                }
                tags.clear();
                hasLocation = false;
                position = new Position(this.getProtocolName());
            }
            tags.add(Integer.valueOf(tag));
            switch (tag) {
                case 3: {
                    this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 32: {
                    position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                    break;
                }
                case 48: {
                    hasLocation = true;
                    position.setValid((buf.readUnsignedByte() & 0xF0) == 0);
                    position.setLatitude((double)buf.readIntLE() / 1000000.0);
                    position.setLongitude((double)buf.readIntLE() / 1000000.0);
                    break;
                }
                case 51: {
                    position.setSpeed((double)buf.readUnsignedShortLE() * 0.0539957);
                    position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
                    break;
                }
                case 52: {
                    position.setAltitude(buf.readShortLE());
                    break;
                }
                case 64: {
                    int status = buf.readUnsignedShortLE();
                    position.set("ignition", BitUtil.check(status, 9));
                    if (BitUtil.check(status, 15)) {
                        position.set("alarm", "general");
                    }
                    position.set("charge", BitUtil.check(status, 2));
                    break;
                }
                case 70: {
                    int input = buf.readUnsignedShortLE();
                    for (int i = 0; i < 16; ++i) {
                        position.set("io" + (i + 1), BitUtil.check(input, i));
                    }
                    continue block15;
                }
                case 69: {
                    int output = buf.readUnsignedShortLE();
                    for (int i = 0; i < 16; ++i) {
                        position.set("io" + (i + 17), BitUtil.check(output, i));
                    }
                    continue block15;
                }
                case 80: {
                    position.set("adc1", (double)buf.readUnsignedShortLE() / 1000.0);
                    break;
                }
                case 81: {
                    position.set("adc2", (double)buf.readUnsignedShortLE() / 1000.0);
                    break;
                }
                case 82: {
                    position.set("adc3", (double)buf.readUnsignedShortLE() / 1000.0);
                    break;
                }
                case 83: {
                    position.set("adc4", (double)buf.readUnsignedShortLE() / 1000.0);
                    break;
                }
                case 96: 
                case 97: 
                case 98: {
                    buf.skipBytes(16);
                    break;
                }
            }
        }
        if (hasLocation && position.getFixTime() != null) {
            positions.add(position);
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0])) == null) {
            return null;
        }
        this.sendResponse(channel, buf.readUnsignedShortLE());
        for (Position p : positions) {
            p.setDeviceId(deviceSession.getDeviceId());
        }
        if (positions.isEmpty()) {
            return null;
        }
        return positions;
    }
}

