/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.beans;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IntrospectionContext {
    private final Class<?> targetClass;
    private final Map<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();

    public IntrospectionContext(Class<?> targetClass) {
        if (targetClass == null) {
            throw new NullPointerException();
        }
        this.targetClass = targetClass;
    }

    public void addDescriptor(PropertyDescriptor descriptor) {
        this.descriptors.put(descriptor.getName(), descriptor);
    }

    public void addDescriptors(PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            this.addDescriptor(descriptor);
        }
    }

    public PropertyDescriptor getDescriptor(String name) {
        return this.descriptors.get(name);
    }

    public PropertyDescriptor[] getDescriptors() {
        return this.descriptors.values().toArray(new PropertyDescriptor[this.descriptors.values().size()]);
    }

    public Set<String> getPropertyNames() {
        return this.descriptors.keySet();
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public boolean hasProperty(String name) {
        return this.descriptors.containsKey(name);
    }

    public void removeProperty(String name) {
        this.descriptors.remove(name);
    }
}

