/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class MapQuestGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String key) {
        if (url == null) {
            url = "http://www.mapquestapi.com/geocoding/v1/reverse";
        }
        url = (String)url + "?key=" + key + "&location=%f,%f";
        return url;
    }

    public MapQuestGeocoder(String url, String key, int cacheSize, AddressFormat addressFormat) {
        super(MapQuestGeocoder.formatUrl(url, key), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray locations;
        JsonArray result = json.getJsonArray("results");
        if (result != null && (locations = result.getJsonObject(0).getJsonArray("locations")) != null) {
            JsonObject location = locations.getJsonObject(0);
            Address address = new Address();
            if (location.containsKey((Object)"street")) {
                address.setStreet(location.getString("street"));
            }
            if (location.containsKey((Object)"adminArea5")) {
                address.setSettlement(location.getString("adminArea5"));
            }
            if (location.containsKey((Object)"adminArea4")) {
                address.setDistrict(location.getString("adminArea4"));
            }
            if (location.containsKey((Object)"adminArea3")) {
                address.setState(location.getString("adminArea3"));
            }
            if (location.containsKey((Object)"adminArea1")) {
                address.setCountry(location.getString("adminArea1").toUpperCase());
            }
            if (location.containsKey((Object)"postalCode")) {
                address.setPostcode(location.getString("postalCode"));
            }
            return address;
        }
        return null;
    }
}

