/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import java.net.SocketAddress;
import org.traccar.BasePipelineFactory;
import org.traccar.Protocol;
import org.traccar.model.Command;

public class ActiveDevice {
    private final long deviceId;
    private final Protocol protocol;
    private final Channel channel;
    private final SocketAddress remoteAddress;
    private final boolean supportsLiveCommands;

    public ActiveDevice(long deviceId, Protocol protocol, Channel channel, SocketAddress remoteAddress) {
        this.deviceId = deviceId;
        this.protocol = protocol;
        this.channel = channel;
        this.remoteAddress = remoteAddress;
        this.supportsLiveCommands = BasePipelineFactory.getHandler(channel.pipeline(), HttpRequestDecoder.class) == null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public boolean supportsLiveCommands() {
        return this.supportsLiveCommands;
    }

    public void sendCommand(Command command) {
        this.protocol.sendDataCommand(this.channel, this.remoteAddress, command);
    }
}

