/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.traccar.BasePipelineFactory;
import org.traccar.Context;
import org.traccar.EventLoopGroupFactory;
import org.traccar.PipelineBuilder;
import org.traccar.config.Keys;

public abstract class TrackerServer {
    private final boolean datagram;
    private final AbstractBootstrap bootstrap;
    private int port;
    private String address;
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public boolean isDatagram() {
        return this.datagram;
    }

    public TrackerServer(boolean datagram, String protocol) {
        this.datagram = datagram;
        this.address = Context.getConfig().getString(Keys.PROTOCOL_ADDRESS.withPrefix(protocol));
        this.port = Context.getConfig().getInteger(Keys.PROTOCOL_PORT.withPrefix(protocol));
        BasePipelineFactory pipelineFactory = new BasePipelineFactory(this, protocol){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline) {
                TrackerServer.this.addProtocolHandlers(pipeline);
            }
        };
        this.bootstrap = datagram ? ((Bootstrap)((Bootstrap)new Bootstrap().group(EventLoopGroupFactory.getWorkerGroup())).channel(NioDatagramChannel.class)).handler((ChannelHandler)pipelineFactory) : ((ServerBootstrap)new ServerBootstrap().group(EventLoopGroupFactory.getBossGroup(), EventLoopGroupFactory.getWorkerGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)pipelineFactory);
    }

    protected abstract void addProtocolHandlers(PipelineBuilder var1);

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public void start() throws Exception {
        InetSocketAddress endpoint = this.address == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.address, this.port);
        Channel channel = this.bootstrap.bind((SocketAddress)endpoint).sync().channel();
        if (channel != null) {
            this.getChannelGroup().add((Object)channel);
        }
    }

    public void stop() {
        this.channelGroup.close().awaitUninterruptibly();
    }
}

