#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for eos_route_maps
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type

DOCUMENTATION = """
module: eos_route_maps
short_description: Manages Route Maps resource module
description: This module configures and manages the attributes of Route Mapd on Arista
  EOS platforms.
version_added: 2.1.0
author: Gomathi Selvi Srinivasan (@GomathiselviS)
notes:
- Tested against Arista EOS 4.23.0F
- This module works with connection C(network_cli). See the L(EOS Platform Options,eos_platform_options).
options:
    config:
      description: A list of route-map options
      type: list
      elements: dict
      suboptions:
        route_map:
          description: Route map name.
          type: str
        entries:
          description: Route Map entries.
          type: list
          elements: dict
          suboptions:
            statement:
              description: statement name
              type: str
            source:
              description: Rename/Copy configuration
              type: dict
              suboptions:
                action:
                  description: rename or copy configuration
                  type: str
                  choices: ["rename", "copy"]
                source_map_name:
                  description: Source route map name.
                  type: str
                overwrite:
                  description: if True, overwrite existing config.
                  type: bool
            action:
              description: Action for matching routes
              type: str
              choices: ["deny", "permit"]
            sequence:
              description: Index in the sequence.
              type: int
            continue_sequence:
              description: Route map entry sequence number.
              type: int
            description:
              description: Description for the route map.
              type: str
            sub_route_map:
              description: Sub route map
              type: dict
              suboptions:
                name:
                  description: sub route map name
                  type: str
                invert_result:
                  description: Invert sub route map result
                  type: bool
            set:
              description: set route attributes.
              type: dict
              suboptions:
                as_path:
                  description: Set as-path.
                  type: dict
                  suboptions:
                    match:
                      description: Match the entire as-path.
                      type: dict
                      suboptions:
                        as_number:
                          description: as number to use (includes auto;in csv format)
                          type: str
                        none:
                          description: Remove matching AS numbers
                          type: bool
                    prepend:
                      description: Prepend to the as-path.
                      type: dict
                      suboptions:
                        as_number:
                          description: as number to prepend (includes auto;in csv format)
                          type: str
                        last_as:
                          description: The number of times to prepend the last AS number.
                          type: int
                bgp:
                  description: BGP AS path multipath weight.
                  type: int
                community_attributes:
                  description: BGP community attribute.
                  type: dict
                  suboptions:
                    graceful_shutdown:
                      description: Graceful shutdown
                      type: bool
                    community:
                      description: community attributes.
                      type: dict
                      suboptions:
                        number:
                          description: community number (in csv format).
                          type: str
                        list:
                          description: community list name.
                          type: str
                        graceful_shutdown:
                          description: Gracefully shutdown.
                          type: bool
                        additive:
                          description: Add to existing community.
                          type: bool
                        delete:
                          description: Delete matching communities.
                          type: bool
                        internet:
                          description: Internet community
                          type: bool
                        local_as:
                          description: Do not send outside local AS.
                          type: bool
                        no_advertise:
                          description: Do not advertise to any peer.
                          type: bool
                        no_export:
                          description: Do not export to next AS.
                          type: bool
                    none:
                      description: No community attribute.
                      type: bool
                distance:
                  description: Set protocol independent distance.
                  type: int
                evpn:
                  description: Keep the next hop when advertising to eBGP peers.
                  type: bool
                extcommunity:
                  description: BGP extended community attribute.
                  type: dict
                  suboptions:
                    lbw:
                      description: Link bandwith values.
                      type: dict
                      suboptions:
                        value:
                          description: Link Bandwidth extended community value.
                          type: str
                        aggregate:
                          description: Aggregate Link Bandwidth.
                          type: bool
                        divide:
                          description: Divide Link Bandwidth.
                          type: str
                          choices: ["equal", "ration"]
                    none:
                      description: No attribute.
                      type: bool
                    rt:
                      description: Route target extended community
                      type: dict
                      suboptions: &params01
                        vpn:
                          description: VPN extended community.
                          type: str
                        additive:
                          description: Add to the existing community.
                          type: bool
                        delete:
                          description: Delete matching communities.
                          type: bool
                    soo:
                      description: Site-of-Origin extended community.
                      type: dict
                      suboptions: *params01
                ip:
                  description: Set IP specific information.
                  type: dict
                  suboptions: &params02
                    address:
                      description: next hop address.
                      type: str
                    unchanged:
                      description: Keep the next hop when advertising to eBGP peer
                      type: bool
                    peer_address:
                      description: Use BGP peering addr as next-hop.
                      type: bool
                ipv6:
                  description: Set IPv6 specific information.
                  type: dict
                  suboptions: *params02
                isis_level:
                  description: IS-IS level.
                  type: str
                local_preference:
                  description: BGP local preference.
                  type: int
                metric:
                  description: Route metric.
                  type: dict
                  suboptions:
                    igp_param:
                      description: IGP parameter
                      type: str
                      choices: ['igp-metric', 'igp-nexthop-cost']
                    add:
                      description: Add igp-metric / igp-nexthop-cost
                      type: str
                      choices: ['igp-metric', 'igp-nexthop-cost']
                    value:
                      description: metric value to add or subtract(with +/- sign).
                      type: str
                metric_type:
                  description: Route metric type.
                  type: str
                  choices: ["type-1", "type-2"]
                nexthop:
                  description: Route next hop.
                  type: dict
                  suboptions:
                    value:
                      description: IGP metric value.
                      type: int
                    max_metric:
                      description: Set IGP max metric value.
                      type: bool
                origin:
                  description: Set bgp origin.
                  type: str
                  choices: ["egp", "igp", "incomplete"]
                segment_index:
                  description: MPLS Segment-routing Segment Index.
                  type: int
                tag:
                  description: Route tag
                  type: int
                weight:
                  description: BGP weight.
                  type: int
            match:
              description: Route map match rules.
              type: dict
              suboptions:
                aggregate_role: &params04
                  description: Role in BGP contributor-aggregate relation.
                  type: dict
                  suboptions:
                    contributor:
                      description: BGP aggregate's contributor.
                      type: bool
                    route_map:
                      description: Route map to apply against the aggregate route.
                      type: str
                as:
                  description: BGP AS number.
                  type: int
                as_path: &params05
                  description: Set as-path.
                  type: dict
                  suboptions:
                    path_list:
                      description: AS path list name.
                      type: str
                    length:
                      description: Specify as-path length ( with comparison operators like <= 60 and >= 40 ).
                      type: str
                community: &params06
                  description: BGP community attribute.
                  type: dict
                  suboptions:
                    community_list:
                      description: list of community names (in csv format).
                      type: str
                    exact_match:
                      description:  Do exact matching of communities.
                      type: bool
                    instances:
                      description: Match number of community instances ( with comparison operators like <= 60 and >= 40 ).
                      type: str
                extcommunity: &params07
                  description: extended community list name.
                  type: dict
                  suboptions:
                    community_list:
                      description: list of community names (in csv format).
                      type: str
                    exact_match:
                      description: Do exact matching of communities.
                      type: bool
                interface:
                  description: interface name.
                  type: str
                invert_result:
                  description: Invert match result.
                  type: dict
                  suboptions:
                    aggregate_role: *params04
                    as_path: *params05
                    community: *params06
                    extcommunity: *params07
                    large_community: *params07
                ip:
                  description: Set IP specific information.
                  type: dict
                  suboptions: &params08
                    address:
                      description: next hop destination.
                      type: dict
                      suboptions:
                        access_list:
                          description: ip access-list.
                          type: str
                        dynamic:
                          description: Configure dynamic prefix-list.
                          type: bool
                        prefix_list:
                          description: Prefix list.
                          type: str
                    next_hop:
                      description: next hop prefix list.
                      type: str
                    resolved_next_hop:
                      description: Route resolved prefix list.
                      type: str
                ipv6:
                  description: Set IPv6 specific information.
                  type: dict
                  suboptions: *params08
                large_community: *params07
                isis_level:
                  description: IS-IS level.
                  type: str
                local_preference:
                  description: BGP local preference.
                  type: int
                metric:
                  description: Route metric.
                  type: int
                metric_type:
                  description: Route metric type.
                  type: str
                  choices: ["type-1", "type-2"]
                route_type:
                  description: Route type
                  type: str
                router_id:
                  description: Router ID.
                  type: str
                source_protocol:
                  description: Source routing protocol,
                  type: str
                tag:
                  description: Route tag
                  type: int
    running_config:
      description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the EOS device by
        executing the command B(show running-config | section route-map).
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result.
      type: str
    state:
      description:
      - The state the configuration should be left in.
      type: str
      choices:
      - deleted
      - merged
      - overridden
      - replaced
      - gathered
      - rendered
      - parsed
      default: merged
"""
EXAMPLES = """
# Using merged
# Before state
# veos#show running-config | section route-map
# veos#

  - name: Merge provided configuration with device configuration
    arista.eos.eos_route_maps:
      config:
        - route_map: "mapmerge"
          entries:
            - description: "merged_map"
              action: "permit"
              sequence: 10
              match:
                router_id: 22
            - description: "newmap"
              action: "deny"
              sequence: 25
              continue_sequence: 45
              match:
                interface: "Ethernet1"
        - route_map: "mapmerge2"
          entries:
            - sub_route_map:
                name: "mapmerge"
              action: "deny"
              sequence: 45
              set:
                metric:
                  value: 25
                  add: "igp-metric"
                as_path:
                  prepend:
                    last_as: 2
              match:
                ipv6:
                  resolved_next_hop: "list1"
      state: merged

# After State:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    description merged_map
#    match router-id prefix-list 22
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# !
# route-map test permit 10
# veos#


# Module Execution:

#  "after": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "description": "merged_map",
#                     "match": {
#                         "router_id": "22"
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue_sequence": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ],
#     "before": {},
#     "changed": true,
#     "commands": [
#         "route-map mapmerge permit 10",
#         "match router-id prefix-list 22",
#         "description merged_map",
#         "route-map mapmerge deny 25",
#         "match interface Ethernet1",
#         "description newmap",
#         "continue 45",
#         "route-map mapmerge2 deny 45",
#         "match ipv6 resolved-next-hop prefix-list list1",
#         "set metric 25 +igp-metric",
#         "set as-path prepend last-as 2",
#         "sub-route-map mapmerge"
#     ],
#

# Using replaced:

# Before State:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    description merged_map
#    match router-id prefix-list 22
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# !
# veos#

  - name: Replace
    arista.eos.eos_route_maps:
      config:
        - route_map: "mapmerge"
          entries:
            - action: "permit"
              sequence: 10
              match:
                ipv6:
                  resolved_next_hop: "listr"
            - action: "deny"
              sequence: 90
              set:
                extcommunity:
                  rt:
                    vpn: "22:11"
                    delete: True
                ip:
                  unchanged: True
      state: replaced

# After State:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    match ipv6 resolved-next-hop prefix-list listr
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge deny 90
#    set ip next-hop unchanged
#    set extcommunity rt 22:11 delete
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# !
#
# Module Execution:
#
#     "after": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "listr"
#                         }
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue_sequence": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 },
#                 {
#                     "action": "deny",
#                     "sequence": 90,
#                     "set": {
#                         "extcommunity": {
#                             "rt": {
#                                 "delete": true,
#                                 "vpn": "22:11"
#                             }
#                         },
#                         "ip": {
#                             "unchanged": true
#                         }
#                     }
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "sequence": 10
#                 }
#             ],
#             "route_map": "test"
#         }
#     ],
#     "before": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "description": "merged_map",
#                     "match": {
#                         "router_id": "22"
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue_sequence": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ],
#     "changed": true,
#     "commands": [
#         "route-map mapmerge permit 10",
#         "match ipv6 resolved-next-hop prefix-list listr",
#         "no match router-id prefix-list 22",
#         "no description",
#         "route-map mapmerge deny 90",
#         "set extcommunity rt 22:11 delete",
#         "set ip next-hop unchanged"
#     ],
#
#
# Using Overridden:

# Before state:
# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    match ipv6 resolved-next-hop prefix-list listr
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge deny 90
#    set ip next-hop unchanged
#    set extcommunity rt 22:11 delete
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# !
# route-map test permit 10
# veos#

  - name: Override
    arista.eos.eos_route_maps:
      config:
        - route_map: "mapmerge"
          entries:
            - action: "permit"
              sequence: 10
              match:
                ipv6:
                  resolved_next_hop: "listr"
            - action: "deny"
              sequence: 90
              set:
                metric:
                  igp_param: "igp-nexthop-cost"
      state: overridden

# After State:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    match ipv6 resolved-next-hop prefix-list listr
# !
# route-map mapmerge deny 90
#    set metric igp-nexthop-cost
# veos#
#
#
#    "after": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "listr"
#                         }
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "sequence": 90,
#                     "set": {
#                         "metric": {
#                             "igp_param": "igp-nexthop-cost"
#                         }
#                     }
#                 }
#             ],
#             "route_map": "mapmerge"
#         }
#     ],
#     "before": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "listr"
#                         }
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue_sequence": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 },
#                 {
#                     "action": "deny",
#                     "sequence": 90,
#                     "set": {
#                         "extcommunity": {
#                             "rt": {
#                                 "delete": true,
#                                 "vpn": "22:11"
#                             }
#                         },
#                         "ip": {
#                             "unchanged": true
#                         }
#                     }
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "sequence": 10
#                 }
#             ],
#             "route_map": "test"
#         }
#     ],
#     "changed": true,
#     "commands": [
#         "no route-map mapmerge deny 25",
#         "no route-map mapmerge2 deny 45",
#         "no route-map test permit 10",
#         "route-map mapmerge deny 90",
#         "set metric igp-nexthop-cost",
#         "no set ip next-hop unchanged",
#         "no set extcommunity rt 22:11 delete"
#     ],
#
# Using deleted:
# Before State:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    description merged_map
#    match router-id prefix-list 22
#    match ipv6 resolved-next-hop prefix-list listr
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge deny 90
#    set metric igp-nexthop-cost
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# veos#

  - name: Delete route-map
    arista.eos.eos_route_maps:
      config:
        - route_map: "mapmerge"
      state: deleted
    become: yes
    tags:
      - deleted1

# After State:

# veos#show running-config | section route-map
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# veos#
#
# Module Execution:
#
# "after": [
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ],
#     "before": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "description": "merged_map",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "listr"
#                         },
#                         "router_id": "22"
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 },
#                 {
#                     "action": "deny",
#                     "sequence": 90,
#                     "set": {
#                         "metric": {
#                             "igp_param": "igp-nexthop-cost"
#                         }
#                     }
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ],
#     "changed": true,
#     "commands": [
#         "no route-map mapmerge"
#     ],

# Using deleted to delete all route-maps:

# Before State:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    description merged_map
#    match router-id prefix-list 22
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# veos#

  - name: Delete all route-maps
    arista.eos.eos_route_maps:
      state: deleted

# After State:
# veos#show running-config | section route-map
# veos#
#
# Module Execution:
#
# "after": {},
#     "before": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "description": "merged_map",
#                     "match": {
#                         "router_id": "22"
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ],
#     "changed": true,
#     "commands": [
#         "no route-map mapmerge",
#         "no route-map mapmerge2"
#     ],

# Using gathered:

# Device configs:

# veos#show running-config | section route-map
# route-map mapmerge permit 10
#    description merged_map
#    match router-id prefix-list 22
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2
# veos#

  - name: gather configs
    arista.eos.eos_route_maps:
      state: gathered

# Module Execution:
#   "gathered": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "description": "merged_map",
#                     "match": {
#                         "router_id": "22"
#                     },
#                     "sequence": 10
#                 },
#                 {
#                     "action": "deny",
#                     "continue_sequence": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ],

# Using rendered:

  - name: Render provided configuration
    arista.eos.eos_route_maps:
      config:
        - route_map: "mapmerge"
          entries:
            - description: "merged_map"
              action: "permit"
              sequence: 10
              match:
                router_id: 22
              set:
                bgp: 20
            - description: "newmap"
              action: "deny"
              sequence: 25
              continue_sequence: 45
              match:
                interface: "Ethernet1"
        - route_map: "mapmerge2"
          entries:
            - sub_route_map:
                name: "mapmerge"
              action: "deny"
              sequence: 45
              set:
                metric:
                  value: 25
                  add: "igp-metric"
                as_path:
                  prepend:
                    last_as: 2
              match:
                ipv6:
                  resolved_next_hop: "list1"
      state: rendered

# Module Execution:
# "rendered": [
#         "route-map mapmerge permit 10",
#         "match router-id prefix-list 22",
#         "set bgp bestpath as-path weight 20",
#         "description merged_map",
#         "route-map mapmerge deny 25",
#         "match interface Ethernet1",
#         "description newmap",
#         "continue 45",
#         "route-map mapmerge2 deny 45",
#         "match ipv6 resolved-next-hop prefix-list list1",
#         "set metric 25 +igp-metric",
#         "set as-path prepend last-as 2",
#         "sub-route-map mapmerge"
#     ]

# Using parsed:

# parsed.cfg
# route-map mapmerge permit 10
#    description merged_map
#    match router-id prefix-list 22
#    set bgp bestpath as-path weight 20
# !
# route-map mapmerge deny 25
#    description newmap
#    match interface Ethernet1
#    continue 45
# !
# route-map mapmerge2 deny 45
#    match ipv6 resolved-next-hop prefix-list list1
#    sub-route-map mapmerge
#    set metric 25 +igp-metric
#    set as-path prepend last-as 2

  - name: parse configs
    arista.eos.eos_route_maps:
      running_config: "{{ lookup('file', './parsed.cfg') }}"
      state: parsed

# Module Execution:
# "parsed": [
#         {
#             "entries": [
#                 {
#                     "action": "permit",
#                     "description": "merged_map",
#                     "match": {
#                         "router_id": "22"
#                     },
#                     "sequence": 10,
#                     "set": {
#                         "bgp": 20
#                     }
#                 },
#                 {
#                     "action": "deny",
#                     "continue_sequence": 45,
#                     "description": "newmap",
#                     "match": {
#                         "interface": "Ethernet1"
#                     },
#                     "sequence": 25
#                 }
#             ],
#             "route_map": "mapmerge"
#         },
#         {
#             "entries": [
#                 {
#                     "action": "deny",
#                     "match": {
#                         "ipv6": {
#                             "resolved_next_hop": "list1"
#                         }
#                     },
#                     "sequence": 45,
#                     "set": {
#                         "as_path": {
#                             "prepend": {
#                                 "last_as": 2
#                             }
#                         },
#                         "metric": {
#                             "add": "igp-metric",
#                             "value": "25"
#                         }
#                     },
#                     "sub_route_map": {
#                         "name": "mapmerge"
#                     }
#                 }
#             ],
#             "route_map": "mapmerge2"
#         }
#     ]



"""

from ansible.module_utils.basic import AnsibleModule
from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.route_maps.route_maps import (
    Route_mapsArgs,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.route_maps.route_maps import (
    Route_maps,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(
        argument_spec=Route_mapsArgs.argument_spec,
        mutually_exclusive=[],
        required_if=[],
        supports_check_mode=False,
    )

    result = Route_maps(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
