/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.junit.Assert;

public class VocabularyAssert {
    public static void assertVocabulary(Analyzer a, InputStream voc, InputStream out) throws IOException {
        BufferedReader vocReader = new BufferedReader(new InputStreamReader(voc, StandardCharsets.UTF_8));
        BufferedReader outputReader = new BufferedReader(new InputStreamReader(out, StandardCharsets.UTF_8));
        String inputWord = null;
        while ((inputWord = vocReader.readLine()) != null) {
            String expectedWord = outputReader.readLine();
            Assert.assertNotNull((Object)expectedWord);
            BaseTokenStreamTestCase.checkOneTerm(a, inputWord, expectedWord);
        }
    }

    public static void assertVocabulary(Analyzer a, InputStream vocOut) throws IOException {
        BufferedReader vocReader = new BufferedReader(new InputStreamReader(vocOut, StandardCharsets.UTF_8));
        String inputLine = null;
        while ((inputLine = vocReader.readLine()) != null) {
            if (inputLine.startsWith("#") || inputLine.trim().length() == 0) continue;
            String[] words = inputLine.split("\t");
            BaseTokenStreamTestCase.checkOneTerm(a, words[0], words[1]);
        }
    }

    public static void assertVocabulary(Analyzer a, Path zipFile, String voc, String out) throws IOException {
        Path tmp = LuceneTestCase.createTempDir();
        try (InputStream in = Files.newInputStream(zipFile, new OpenOption[0]);){
            TestUtil.unzip(in, tmp);
        }
        var6_6 = null;
        try (InputStream v = Files.newInputStream(tmp.resolve(voc), new OpenOption[0]);
             InputStream o = Files.newInputStream(tmp.resolve(out), new OpenOption[0]);){
            VocabularyAssert.assertVocabulary(a, v, o);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    public static void assertVocabulary(Analyzer a, Path zipFile, String vocOut) throws IOException {
        Path tmp = LuceneTestCase.createTempDir();
        try (InputStream in = Files.newInputStream(zipFile, new OpenOption[0]);){
            TestUtil.unzip(in, tmp);
        }
        in = Files.newInputStream(tmp.resolve(vocOut), new OpenOption[0]);
        var5_5 = null;
        try {
            VocabularyAssert.assertVocabulary(a, in);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
    }
}

