(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/146/hamt#hamt-hash-slice-size '5)
  (define std/srfi/146/hamt#hamt-hash-size
    (let ((_word-size1313_ std/srfi/143#fx-width))
      (- _word-size1313_
         (remainder _word-size1313_ std/srfi/146/hamt#hamt-hash-slice-size))))
  (define std/srfi/146/hamt#hamt-hash-modulus
    (expt '2 std/srfi/146/hamt#hamt-hash-size))
  (define std/srfi/146/hamt#hamt-bucket-size
    (expt '2 std/srfi/146/hamt#hamt-hash-slice-size))
  (define std/srfi/146/hamt#hamt-null (cons 'hamt 'null))
  (define std/srfi/146/hamt#hash-array-mapped-trie
    (make-struct-type
     'std/srfi/146/hamt#hash-array-mapped-trie
     '#f
     '6
     'hash-array-mapped-trie
     '((fields: = count hash mutable? payload? root))
     '#f))
  (define std/srfi/146/hamt#hash-array-mapped-trie?
    (make-struct-predicate std/srfi/146/hamt#hash-array-mapped-trie))
  (define std/srfi/146/hamt#hamt/=
    (make-struct-field-accessor std/srfi/146/hamt#hash-array-mapped-trie '0))
  (define std/srfi/146/hamt#hamt/count
    (make-struct-field-accessor std/srfi/146/hamt#hash-array-mapped-trie '1))
  (define std/srfi/146/hamt#hamt/hash
    (make-struct-field-accessor std/srfi/146/hamt#hash-array-mapped-trie '2))
  (define std/srfi/146/hamt#hamt/mutable?
    (make-struct-field-accessor std/srfi/146/hamt#hash-array-mapped-trie '3))
  (define std/srfi/146/hamt#hamt/payload?
    (make-struct-field-accessor std/srfi/146/hamt#hash-array-mapped-trie '4))
  (define std/srfi/146/hamt#hamt/root
    (make-struct-field-accessor std/srfi/146/hamt#hash-array-mapped-trie '5))
  (define std/srfi/146/hamt#set-hamt/count!
    (make-struct-field-mutator std/srfi/146/hamt#hash-array-mapped-trie '1))
  (define std/srfi/146/hamt#set-hamt/root!
    (make-struct-field-mutator std/srfi/146/hamt#hash-array-mapped-trie '5))
  (define std/srfi/146/hamt#%make-hamt
    (lambda (_=1306_
             _count1307_
             _hash1308_
             _mutable?1309_
             _payload?1310_
             _root1311_)
      (make-struct-instance
       std/srfi/146/hamt#hash-array-mapped-trie
       _=1306_
       _count1307_
       _hash1308_
       _mutable?1309_
       _payload?1310_
       _root1311_)))
  (define std/srfi/146/hamt#make-hamt
    (lambda (_=1302_ _hash1303_ _payload?1304_)
      (let ((__tmp4913 (std/srfi/146/hamt#make-empty-narrow)))
        (declare (not safe))
        (##structure
         std/srfi/146/hamt#hash-array-mapped-trie
         _=1302_
         '0
         _hash1303_
         '#f
         _payload?1304_
         __tmp4913))))
  (define std/srfi/146/hamt#collision
    (make-struct-type
     'std/srfi/146/hamt#collision
     '#f
     '2
     'collision
     '((fields: entries hash))
     '#f))
  (define std/srfi/146/hamt#collision?
    (make-struct-predicate std/srfi/146/hamt#collision))
  (define std/srfi/146/hamt#collision/entries
    (make-struct-field-accessor std/srfi/146/hamt#collision '0))
  (define std/srfi/146/hamt#collision/hash
    (make-struct-field-accessor std/srfi/146/hamt#collision '1))
  (define std/srfi/146/hamt#make-collision
    (lambda (_entries1299_ _hash1300_)
      (make-struct-instance
       std/srfi/146/hamt#collision
       _entries1299_
       _hash1300_)))
  (define std/srfi/146/hamt#narrow
    (make-struct-type
     'std/srfi/146/hamt#narrow
     '#f
     '3
     'narrow
     '((fields: array children leaves))
     '#f))
  (define std/srfi/146/hamt#narrow?
    (make-struct-predicate std/srfi/146/hamt#narrow))
  (define std/srfi/146/hamt#narrow/array
    (make-struct-field-accessor std/srfi/146/hamt#narrow '0))
  (define std/srfi/146/hamt#narrow/children
    (make-struct-field-accessor std/srfi/146/hamt#narrow '1))
  (define std/srfi/146/hamt#narrow/leaves
    (make-struct-field-accessor std/srfi/146/hamt#narrow '2))
  (define std/srfi/146/hamt#make-narrow
    (lambda (_array1295_ _children1296_ _leaves1297_)
      (make-struct-instance
       std/srfi/146/hamt#narrow
       _array1295_
       _children1296_
       _leaves1297_)))
  (define std/srfi/146/hamt#wide
    (make-struct-type
     'std/srfi/146/hamt#wide
     '#f
     '3
     'wide
     '((fields: array children leaves))
     '#f))
  (define std/srfi/146/hamt#wide?
    (make-struct-predicate std/srfi/146/hamt#wide))
  (define std/srfi/146/hamt#wide/array
    (make-struct-field-accessor std/srfi/146/hamt#wide '0))
  (define std/srfi/146/hamt#wide/children
    (make-struct-field-accessor std/srfi/146/hamt#wide '1))
  (define std/srfi/146/hamt#wide/leaves
    (make-struct-field-accessor std/srfi/146/hamt#wide '2))
  (define std/srfi/146/hamt#set-wide/children!
    (make-struct-field-mutator std/srfi/146/hamt#wide '1))
  (define std/srfi/146/hamt#set-wide/leaves!
    (make-struct-field-mutator std/srfi/146/hamt#wide '2))
  (define std/srfi/146/hamt#make-wide
    (lambda (_array1291_ _children1292_ _leaves1293_)
      (make-struct-instance
       std/srfi/146/hamt#wide
       _array1291_
       _children1292_
       _leaves1293_)))
  (define std/srfi/146/hamt#hamt/empty?
    (lambda (_hamt1289_)
      (zero? (##structure-ref
              _hamt1289_
              '2
              std/srfi/146/hamt#hash-array-mapped-trie
              '#f))))
  (define std/srfi/146/hamt#hamt/immutable-inner
    (lambda (_hamt1284_ _replace1285_)
      (if (##structure-ref
           _hamt1284_
           '4
           std/srfi/146/hamt#hash-array-mapped-trie
           '#f)
          (let ((_payload?1287_
                 (##structure-ref
                  _hamt1284_
                  '5
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)))
            (let ((__tmp4917
                   (##structure-ref
                    _hamt1284_
                    '1
                    std/srfi/146/hamt#hash-array-mapped-trie
                    '#f))
                  (__tmp4916
                   (##structure-ref
                    _hamt1284_
                    '2
                    std/srfi/146/hamt#hash-array-mapped-trie
                    '#f))
                  (__tmp4915
                   (##structure-ref
                    _hamt1284_
                    '3
                    std/srfi/146/hamt#hash-array-mapped-trie
                    '#f))
                  (__tmp4914
                   (std/srfi/146/hamt#->immutable
                    (##structure-ref
                     _hamt1284_
                     '6
                     std/srfi/146/hamt#hash-array-mapped-trie
                     '#f)
                    _payload?1287_
                    _replace1285_)))
              (declare (not safe))
              (##structure
               std/srfi/146/hamt#hash-array-mapped-trie
               __tmp4917
               __tmp4916
               __tmp4915
               '#f
               _payload?1287_
               __tmp4914)))
          _hamt1284_)))
  (define std/srfi/146/hamt#hamt/immutable__0
    (lambda (_hamt1276_)
      (std/srfi/146/hamt#hamt/immutable-inner
       _hamt1276_
       (lambda (_k1278_ _d1279_) _d1279_))))
  (define std/srfi/146/hamt#hamt/immutable
    (lambda _g4919_
      (let ((_g4918_ (let () (declare (not safe)) (##length _g4919_))))
        (cond ((let () (declare (not safe)) (##fx= _g4918_ 1))
               (apply std/srfi/146/hamt#hamt/immutable__0 _g4919_))
              ((let () (declare (not safe)) (##fx= _g4918_ 2))
               (apply std/srfi/146/hamt#hamt/immutable-inner _g4919_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/146/hamt#hamt/immutable
                _g4919_))))))
  (define std/srfi/146/hamt#hamt/mutable
    (lambda (_hamt1274_)
      (if (##structure-ref
           _hamt1274_
           '4
           std/srfi/146/hamt#hash-array-mapped-trie
           '#f)
          _hamt1274_
          (let ((__tmp4924
                 (##structure-ref
                  _hamt1274_
                  '1
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f))
                (__tmp4923
                 (##structure-ref
                  _hamt1274_
                  '2
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f))
                (__tmp4922
                 (##structure-ref
                  _hamt1274_
                  '3
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f))
                (__tmp4921
                 (##structure-ref
                  _hamt1274_
                  '5
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f))
                (__tmp4920
                 (##structure-ref
                  _hamt1274_
                  '6
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)))
            (declare (not safe))
            (##structure
             std/srfi/146/hamt#hash-array-mapped-trie
             __tmp4924
             __tmp4923
             __tmp4922
             '#t
             __tmp4921
             __tmp4920)))))
  (define std/srfi/146/hamt#hamt/replace
    (lambda (_hamt1254_ _key1255_ _dp1256_)
      (if (not (##structure-ref
                _hamt1254_
                '4
                std/srfi/146/hamt#hash-array-mapped-trie
                '#f))
          '#!void
          (error '"Assertion failed:"
                 '(not (hamt/mutable? hamt))
                 (list 'not
                       (##structure-ref
                        _hamt1254_
                        '4
                        std/srfi/146/hamt#hash-array-mapped-trie
                        '#f))))
      (let* ((_payload?1258_
              (##structure-ref
               _hamt1254_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_root1260_
              (##structure-ref
               _hamt1254_
               '6
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_==1262_
              (##structure-ref
               _hamt1254_
               '1
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_hp1264_
              (##structure-ref
               _hamt1254_
               '3
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_hash1266_ (std/srfi/146/hamt#hash-bits _hp1264_ _key1255_))
             (_g4925_ (std/srfi/146/hamt#modify-pure
                       _hamt1254_
                       _root1260_
                       '0
                       _dp1256_
                       _hash1266_
                       _key1255_)))
        (begin
          (let ((_g4926_ (let ()
                           (declare (not safe))
                           (if (##values? _g4925_)
                               (##vector-length _g4925_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4926_ 2)))
                (error "Context expects 2 values" _g4926_)))
          (let ((_change1268_
                 (let () (declare (not safe)) (##vector-ref _g4925_ 0)))
                (_node1269_
                 (let () (declare (not safe)) (##vector-ref _g4925_ 1))))
            (let ()
              (if (eq? _node1269_ _root1260_)
                  _hamt1254_
                  (let ((_count1272_
                         (+ (##structure-ref
                             _hamt1254_
                             '2
                             std/srfi/146/hamt#hash-array-mapped-trie
                             '#f)
                            _change1268_)))
                    (declare (not safe))
                    (##structure
                     std/srfi/146/hamt#hash-array-mapped-trie
                     _==1262_
                     _count1272_
                     _hp1264_
                     '#f
                     _payload?1258_
                     _node1269_)))))))))
  (define std/srfi/146/hamt#hamt/put
    (lambda (_hamt1248_ _key1249_ _datum1250_)
      (std/srfi/146/hamt#hamt/replace
       _hamt1248_
       _key1249_
       (lambda (_x1252_) _datum1250_))))
  (define std/srfi/146/hamt#hamt/replace!
    (lambda (_hamt1234_ _key1235_ _dp1236_)
      (if (##structure-ref
           _hamt1234_
           '4
           std/srfi/146/hamt#hash-array-mapped-trie
           '#f)
          '#!void
          (error '"Assertion failed:"
                 '(hamt/mutable? hamt)
                 (list 'hamt/mutable? _hamt1234_)))
      (let* ((_root1238_
              (##structure-ref
               _hamt1234_
               '6
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_hp1240_
              (##structure-ref
               _hamt1234_
               '3
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_hash1242_ (std/srfi/146/hamt#hash-bits _hp1240_ _key1235_))
             (_g4927_ (std/srfi/146/hamt#mutate
                       _hamt1234_
                       _root1238_
                       '0
                       _dp1236_
                       _hash1242_
                       _key1235_)))
        (begin
          (let ((_g4928_ (let ()
                           (declare (not safe))
                           (if (##values? _g4927_)
                               (##vector-length _g4927_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4928_ 2)))
                (error "Context expects 2 values" _g4928_)))
          (let ((_change1244_
                 (let () (declare (not safe)) (##vector-ref _g4927_ 0)))
                (_node1245_
                 (let () (declare (not safe)) (##vector-ref _g4927_ 1))))
            (let ()
              (if (zero? _change1244_)
                  '#!void
                  (##structure-set!
                   _hamt1234_
                   (+ (##structure-ref
                       _hamt1234_
                       '2
                       std/srfi/146/hamt#hash-array-mapped-trie
                       '#f)
                      _change1244_)
                   '2
                   std/srfi/146/hamt#hash-array-mapped-trie
                   '#f))
              (if (eq? _node1245_ _root1238_)
                  '#!void
                  (##structure-set!
                   _hamt1234_
                   _node1245_
                   '6
                   std/srfi/146/hamt#hash-array-mapped-trie
                   '#f))
              _hamt1234_))))))
  (define std/srfi/146/hamt#hamt/put!
    (lambda (_hamt1228_ _key1229_ _datum1230_)
      (std/srfi/146/hamt#hamt/replace!
       _hamt1228_
       _key1229_
       (lambda (_x1232_) _datum1230_))))
  (define std/srfi/146/hamt#make-empty-narrow
    (lambda ()
      (let ((__tmp4929 (vector)))
        (declare (not safe))
        (##structure std/srfi/146/hamt#narrow __tmp4929 '0 '0))))
  (define std/srfi/146/hamt#hamt-null?
    (lambda (_n1225_) (eq? _n1225_ std/srfi/146/hamt#hamt-null)))
  (define std/srfi/146/hamt#collision-single-leaf?
    (lambda (_n1221_)
      (let ((_elements1223_
             (##structure-ref _n1221_ '1 std/srfi/146/hamt#collision '#f)))
        (if (not (null? _elements1223_)) (null? (cdr _elements1223_)) '#f))))
  (define std/srfi/146/hamt#narrow-single-leaf?
    (lambda (_n1219_)
      (if (zero? (##structure-ref _n1219_ '2 std/srfi/146/hamt#narrow '#f))
          (= '1
             (bit-count
              (##structure-ref _n1219_ '3 std/srfi/146/hamt#narrow '#f)))
          '#f)))
  (define std/srfi/146/hamt#wide-single-leaf?
    (lambda (_n1217_)
      (if (zero? (##structure-ref _n1217_ '2 std/srfi/146/hamt#wide '#f))
          (= '1
             (bit-count
              (##structure-ref _n1217_ '3 std/srfi/146/hamt#wide '#f)))
          '#f)))
  (define std/srfi/146/hamt#hash-bits
    (lambda (_hp1214_ _key1215_)
      (remainder (_hp1214_ _key1215_) std/srfi/146/hamt#hamt-hash-modulus)))
  (define std/srfi/146/hamt#next-set-bit
    (lambda (_i1208_ _start1209_ _end1210_)
      (let ((_index1212_
             (std/srfi/151#first-set-bit
              (std/srfi/151#bit-field _i1208_ _start1209_ _end1210_))))
        (if (not (= _index1212_ '-1)) (+ _index1212_ _start1209_) '#f))))
  (define std/srfi/146/hamt#narrow->wide
    (lambda (_n1178_ _payload?1179_)
      (let* ((_c1181_ (##structure-ref
                       _n1178_
                       '2
                       std/srfi/146/hamt#narrow
                       '#f))
             (_l1183_ (##structure-ref
                       _n1178_
                       '3
                       std/srfi/146/hamt#narrow
                       '#f))
             (_stride1185_ (std/srfi/146/hamt#leaf-stride _payload?1179_))
             (_a-in1187_
              (##structure-ref _n1178_ '1 std/srfi/146/hamt#narrow '#f))
             (_a-out1189_
              (make-vector
               (* _stride1185_ std/srfi/146/hamt#hamt-bucket-size))))
        (let _next-leaf1192_ ((_start1194_ '0) (_count1195_ '0))
          (let ((_i1197_ (std/srfi/146/hamt#next-set-bit
                          _l1183_
                          _start1194_
                          std/srfi/146/hamt#hamt-bucket-size)))
            (if _i1197_
                (begin
                  (let ((_j1199_ (* _stride1185_ _i1197_)))
                    (vector-set!
                     _a-out1189_
                     _j1199_
                     (vector-ref _a-in1187_ _count1195_))
                    (if _payload?1179_
                        (vector-set!
                         _a-out1189_
                         (+ _j1199_ '1)
                         (vector-ref _a-in1187_ (+ _count1195_ '1)))
                        '#!void))
                  (_next-leaf1192_
                   (+ _i1197_ '1)
                   (+ _stride1185_ _count1195_)))
                '#!void)))
        (let _next-child1201_ ((_start1203_ '0)
                               (_offset1204_
                                (* _stride1185_ (bit-count _l1183_))))
          (let ((_i1206_ (std/srfi/146/hamt#next-set-bit
                          _c1181_
                          _start1203_
                          std/srfi/146/hamt#hamt-bucket-size)))
            (if _i1206_
                (begin
                  (vector-set!
                   _a-out1189_
                   (* _stride1185_ _i1206_)
                   (vector-ref _a-in1187_ _offset1204_))
                  (_next-child1201_ (+ _i1206_ '1) (+ _offset1204_ '1)))
                '#!void)))
        (let ()
          (declare (not safe))
          (##structure std/srfi/146/hamt#wide _a-out1189_ _c1181_ _l1183_)))))
  (define std/srfi/146/hamt#->immutable
    (lambda (_n1142_ _payload?1143_ _replace1144_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _n1142_ 'std/srfi/146/hamt#collision))
          _n1142_
          (if (let ()
                (declare (not safe))
                (##structure-instance-of? _n1142_ 'std/srfi/146/hamt#narrow))
              _n1142_
              (if (let ()
                    (declare (not safe))
                    (##structure-instance-of? _n1142_ 'std/srfi/146/hamt#wide))
                  (let* ((_c1146_ (##structure-ref
                                   _n1142_
                                   '2
                                   std/srfi/146/hamt#wide
                                   '#f))
                         (_l1148_ (##structure-ref
                                   _n1142_
                                   '3
                                   std/srfi/146/hamt#wide
                                   '#f))
                         (_stride1150_
                          (std/srfi/146/hamt#leaf-stride _payload?1143_))
                         (_l-count1152_ (bit-count _l1148_))
                         (_a-in1154_
                          (##structure-ref
                           _n1142_
                           '1
                           std/srfi/146/hamt#wide
                           '#f))
                         (_a-out1156_
                          (make-vector
                           (+ (* _stride1150_ _l-count1152_)
                              (bit-count _c1146_)))))
                    (let _next-leaf1159_ ((_start1161_ '0) (_count1162_ '0))
                      (let ((_i1164_ (std/srfi/146/hamt#next-set-bit
                                      _l1148_
                                      _start1161_
                                      std/srfi/146/hamt#hamt-bucket-size)))
                        (if _i1164_
                            (begin
                              (let* ((_j1166_ (* _stride1150_ _i1164_))
                                     (_key1168_
                                      (vector-ref _a-in1154_ _j1166_)))
                                (vector-set! _a-out1156_ _count1162_ _key1168_)
                                (if _payload?1143_
                                    (vector-set!
                                     _a-out1156_
                                     (+ _count1162_ '1)
                                     (_replace1144_
                                      _key1168_
                                      (vector-ref _a-in1154_ (+ _j1166_ '1))))
                                    '#!void))
                              (_next-leaf1159_
                               (+ _i1164_ '1)
                               (+ _stride1150_ _count1162_)))
                            '#!void)))
                    (let _next-child1171_ ((_start1173_ '0)
                                           (_offset1174_
                                            (* _stride1150_ _l-count1152_)))
                      (let ((_i1176_ (std/srfi/146/hamt#next-set-bit
                                      _c1146_
                                      _start1173_
                                      std/srfi/146/hamt#hamt-bucket-size)))
                        (if _i1176_
                            (begin
                              (vector-set!
                               _a-out1156_
                               _offset1174_
                               (std/srfi/146/hamt#->immutable
                                (vector-ref
                                 _a-in1154_
                                 (* _stride1150_ _i1176_))
                                _payload?1143_
                                _replace1144_))
                              (_next-child1171_
                               (+ _i1176_ '1)
                               (+ _offset1174_ '1)))
                            '#!void)))
                    (let ()
                      (declare (not safe))
                      (##structure
                       std/srfi/146/hamt#narrow
                       _a-out1156_
                       _c1146_
                       _l1148_)))
                  (error '"Unexpected type of node."))))))
  (define std/srfi/146/hamt#hash-fragment
    (lambda (_shift1139_ _hash1140_)
      (std/srfi/151#bit-field
       _hash1140_
       _shift1139_
       (+ _shift1139_ std/srfi/146/hamt#hamt-hash-slice-size))))
  (define std/srfi/146/hamt#fragment->mask
    (lambda (_fragment1137_) (- (expt '2 _fragment1137_) '1)))
  (define std/srfi/146/hamt#mutate
    (lambda (_hamt1130_ _n1131_ _shift1132_ _dp1133_ _h1134_ _k1135_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _n1131_ 'std/srfi/146/hamt#collision))
          (std/srfi/146/hamt#modify-collision
           _hamt1130_
           _n1131_
           _shift1132_
           _dp1133_
           _h1134_
           _k1135_)
          (if (let ()
                (declare (not safe))
                (##structure-instance-of? _n1131_ 'std/srfi/146/hamt#narrow))
              (std/srfi/146/hamt#modify-wide
               _hamt1130_
               (std/srfi/146/hamt#narrow->wide
                _n1131_
                (##structure-ref
                 _hamt1130_
                 '5
                 std/srfi/146/hamt#hash-array-mapped-trie
                 '#f))
               _shift1132_
               _dp1133_
               _h1134_
               _k1135_)
              (if (let ()
                    (declare (not safe))
                    (##structure-instance-of? _n1131_ 'std/srfi/146/hamt#wide))
                  (std/srfi/146/hamt#modify-wide
                   _hamt1130_
                   _n1131_
                   _shift1132_
                   _dp1133_
                   _h1134_
                   _k1135_)
                  (error '"Unknown HAMT node type." _n1131_))))))
  (define std/srfi/146/hamt#modify-wide
    (lambda (_hamt1119_ _n1120_ _shift1121_ _dp1122_ _h1123_ _k1124_)
      (let ((_fragment1126_
             (std/srfi/146/hamt#hash-fragment _shift1121_ _h1123_)))
        (if (bit-set?
             _fragment1126_
             (##structure-ref _n1120_ '2 std/srfi/146/hamt#wide '#f))
            (std/srfi/146/hamt#modify-wide-child
             _hamt1119_
             _n1120_
             _shift1121_
             _dp1122_
             _h1123_
             _k1124_)
            (if (bit-set?
                 _fragment1126_
                 (##structure-ref _n1120_ '3 std/srfi/146/hamt#wide '#f))
                (std/srfi/146/hamt#modify-wide-leaf
                 _hamt1119_
                 _n1120_
                 _shift1121_
                 _dp1122_
                 _h1123_
                 _k1124_)
                (let ((_d1128_ (_dp1122_ std/srfi/146/hamt#hamt-null)))
                  (if (std/srfi/146/hamt#hamt-null? _d1128_)
                      (values '0 _n1120_)
                      (std/srfi/146/hamt#modify-wide-new
                       _hamt1119_
                       _n1120_
                       _shift1121_
                       _d1128_
                       _h1123_
                       _k1124_))))))))
  (define std/srfi/146/hamt#modify-wide-child
    (lambda (_hamt1084_ _n1085_ _shift1086_ _dp1087_ _h1088_ _k1089_)
      (let* ((_fragment1091_
              (std/srfi/146/hamt#hash-fragment _shift1086_ _h1088_))
             (_array1093_
              (##structure-ref _n1085_ '1 std/srfi/146/hamt#wide '#f))
             (_payload?1095_
              (##structure-ref
               _hamt1084_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_stride1097_ (std/srfi/146/hamt#leaf-stride _payload?1095_))
             (_i1099_ (* _stride1097_ _fragment1091_))
             (_child1101_ (vector-ref _array1093_ _i1099_))
             (_g4930_ (std/srfi/146/hamt#mutate
                       _hamt1084_
                       _child1101_
                       (+ _shift1086_ std/srfi/146/hamt#hamt-hash-slice-size)
                       _dp1087_
                       _h1088_
                       _k1089_)))
        (begin
          (let ((_g4931_ (let ()
                           (declare (not safe))
                           (if (##values? _g4930_)
                               (##vector-length _g4930_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4931_ 2)))
                (error "Context expects 2 values" _g4931_)))
          (let ((_change1103_
                 (let () (declare (not safe)) (##vector-ref _g4930_ 0)))
                (_new-child1104_
                 (let () (declare (not safe)) (##vector-ref _g4930_ 1))))
            (let ()
              (letrec ((_coalesce1107_
                        (lambda (_key1116_ _datum1117_)
                          (vector-set! _array1093_ _i1099_ _key1116_)
                          (if _payload?1095_
                              (vector-set!
                               _array1093_
                               (+ _i1099_ '1)
                               _datum1117_)
                              '#!void)
                          (##structure-set!
                           _n1085_
                           (std/srfi/151#copy-bit
                            _fragment1091_
                            (##structure-ref
                             _n1085_
                             '2
                             std/srfi/146/hamt#wide
                             '#f)
                            '#f)
                           '2
                           std/srfi/146/hamt#wide
                           '#f)
                          (##structure-set!
                           _n1085_
                           (std/srfi/151#copy-bit
                            _fragment1091_
                            (##structure-ref
                             _n1085_
                             '3
                             std/srfi/146/hamt#wide
                             '#f)
                            '#t)
                           '3
                           std/srfi/146/hamt#wide
                           '#f)
                          (values _change1103_ _n1085_)))
                       (_replace1108_
                        (lambda ()
                          (vector-set! _array1093_ _i1099_ _new-child1104_)
                          (values _change1103_ _n1085_))))
                (if (eq? _new-child1104_ _child1101_)
                    (values _change1103_ _n1085_)
                    (if (std/srfi/146/hamt#hamt-null? _new-child1104_)
                        (error '"Child cannot become null." _n1085_)
                        (if (let ()
                              (declare (not safe))
                              (##structure-instance-of?
                               _new-child1104_
                               'std/srfi/146/hamt#collision))
                            (if (std/srfi/146/hamt#collision-single-leaf?
                                 _new-child1104_)
                                (let ((_a1110_ (car (##structure-ref
                                                     _new-child1104_
                                                     '1
                                                     std/srfi/146/hamt#collision
                                                     '#f))))
                                  (if _payload?1095_
                                      (_coalesce1107_
                                       (car _a1110_)
                                       (cdr _a1110_))
                                      (_coalesce1107_ _a1110_ '#f)))
                                (_replace1108_))
                            (if (let ()
                                  (declare (not safe))
                                  (##structure-instance-of?
                                   _new-child1104_
                                   'std/srfi/146/hamt#wide))
                                (if (std/srfi/146/hamt#wide-single-leaf?
                                     _new-child1104_)
                                    (let ((_a1112_ (##structure-ref
                                                    _new-child1104_
                                                    '1
                                                    std/srfi/146/hamt#wide
                                                    '#f))
                                          (_j1113_ (* _stride1097_
                                                      (std/srfi/146/hamt#next-set-bit
                                                       (##structure-ref
                                                        _new-child1104_
                                                        '3
                                                        std/srfi/146/hamt#wide
                                                        '#f)
                                                       '0
                                                       std/srfi/146/hamt#hamt-bucket-size))))
                                      (_coalesce1107_
                                       (vector-ref _a1112_ _j1113_)
                                       (if _payload?1095_
                                           (vector-ref _a1112_ (+ _j1113_ '1))
                                           '#f)))
                                    (_replace1108_))
                                (if (let ()
                                      (declare (not safe))
                                      (##structure-instance-of?
                                       _new-child1104_
                                       'std/srfi/146/hamt#narrow))
                                    (_replace1108_)
                                    (error '"Unexpected type of child node.")))))))))))))
  (define std/srfi/146/hamt#modify-wide-leaf
    (lambda (_hamt1057_ _n1058_ _shift1059_ _dp1060_ _h1061_ _k1062_)
      (let* ((_fragment1064_
              (std/srfi/146/hamt#hash-fragment _shift1059_ _h1061_))
             (_array1066_
              (##structure-ref _n1058_ '1 std/srfi/146/hamt#wide '#f))
             (_payload?1068_
              (##structure-ref
               _hamt1057_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_stride1070_ (std/srfi/146/hamt#leaf-stride _payload?1068_))
             (_i1072_ (* _stride1070_ _fragment1064_))
             (_key1074_ (vector-ref _array1066_ _i1072_)))
        (if ((##structure-ref
              _hamt1057_
              '1
              std/srfi/146/hamt#hash-array-mapped-trie
              '#f)
             _k1062_
             _key1074_)
            (let* ((_existing1077_
                    (if _payload?1068_
                        (vector-ref _array1066_ (+ _i1072_ '1))
                        std/srfi/146/hamt#hamt-null))
                   (_d1079_ (_dp1060_ _existing1077_)))
              (if (std/srfi/146/hamt#hamt-null? _d1079_)
                  (begin
                    (vector-set! _array1066_ _i1072_ '#f)
                    (if _payload?1068_
                        (vector-set! _array1066_ (+ _i1072_ '1) '#f)
                        '#!void)
                    (##structure-set!
                     _n1058_
                     (std/srfi/151#copy-bit
                      _fragment1064_
                      (##structure-ref _n1058_ '3 std/srfi/146/hamt#wide '#f)
                      '#f)
                     '3
                     std/srfi/146/hamt#wide
                     '#f)
                    (values '-1 _n1058_))
                  (begin
                    (if _payload?1068_
                        (vector-set! _array1066_ (+ _i1072_ '1) _d1079_)
                        '#!void)
                    (values '0 _n1058_))))
            (let ((_d1082_ (_dp1060_ std/srfi/146/hamt#hamt-null)))
              (if (std/srfi/146/hamt#hamt-null? _d1082_)
                  (values '0 _n1058_)
                  (std/srfi/146/hamt#add-wide-leaf-key
                   _hamt1057_
                   _n1058_
                   _shift1059_
                   _d1082_
                   _h1061_
                   _k1062_)))))))
  (define std/srfi/146/hamt#add-wide-leaf-key
    (lambda (_hamt1029_ _n1030_ _shift1031_ _d1032_ _h1033_ _k1034_)
      (letrec* ((_payload?1036_
                 (##structure-ref
                  _hamt1029_
                  '5
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f))
                (_make-entry1037_
                 (if _payload?1036_ cons (lambda (_k1054_ _d1055_) _k1054_))))
        (let* ((_fragment1039_
                (std/srfi/146/hamt#hash-fragment _shift1031_ _h1033_))
               (_array1041_
                (##structure-ref _n1030_ '1 std/srfi/146/hamt#wide '#f))
               (_stride1043_ (std/srfi/146/hamt#leaf-stride _payload?1036_))
               (_i1045_ (* _stride1043_ _fragment1039_))
               (_key1047_ (vector-ref _array1041_ _i1045_))
               (_hash1049_
                (std/srfi/146/hamt#hash-bits
                 (##structure-ref
                  _hamt1029_
                  '3
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)
                 _key1047_))
               (_datum1051_
                (if _payload?1036_
                    (vector-ref _array1041_ (+ _i1045_ '1))
                    '#f)))
          (vector-set!
           _array1041_
           _i1045_
           (if (= _h1033_ _hash1049_)
               (let ((__tmp4932
                      (list (_make-entry1037_ _k1034_ _d1032_)
                            (_make-entry1037_ _key1047_ _datum1051_))))
                 (declare (not safe))
                 (##structure std/srfi/146/hamt#collision __tmp4932 _h1033_))
               (std/srfi/146/hamt#make-narrow-with-two-keys
                _payload?1036_
                (+ _shift1031_ std/srfi/146/hamt#hamt-hash-slice-size)
                _h1033_
                _k1034_
                _d1032_
                _hash1049_
                _key1047_
                _datum1051_)))
          (if _payload?1036_
              (vector-set! _array1041_ (+ _i1045_ '1) '#f)
              '#!void)
          (##structure-set!
           _n1030_
           (std/srfi/151#copy-bit
            _fragment1039_
            (##structure-ref _n1030_ '2 std/srfi/146/hamt#wide '#f)
            '#t)
           '2
           std/srfi/146/hamt#wide
           '#f)
          (##structure-set!
           _n1030_
           (std/srfi/151#copy-bit
            _fragment1039_
            (##structure-ref _n1030_ '3 std/srfi/146/hamt#wide '#f)
            '#f)
           '3
           std/srfi/146/hamt#wide
           '#f)
          (values '1 _n1030_)))))
  (define std/srfi/146/hamt#modify-wide-new
    (lambda (_hamt1011_ _n1012_ _shift1013_ _d1014_ _h1015_ _k1016_)
      (let* ((_fragment1018_
              (std/srfi/146/hamt#hash-fragment _shift1013_ _h1015_))
             (_array1020_
              (##structure-ref _n1012_ '1 std/srfi/146/hamt#wide '#f))
             (_payload?1022_
              (##structure-ref
               _hamt1011_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_stride1024_ (std/srfi/146/hamt#leaf-stride _payload?1022_))
             (_i1026_ (* _stride1024_ _fragment1018_)))
        (vector-set! _array1020_ _i1026_ _k1016_)
        (if _payload?1022_
            (vector-set! _array1020_ (+ _i1026_ '1) _d1014_)
            '#!void)
        (##structure-set!
         _n1012_
         (std/srfi/151#copy-bit
          _fragment1018_
          (##structure-ref _n1012_ '3 std/srfi/146/hamt#wide '#f)
          '#t)
         '3
         std/srfi/146/hamt#wide
         '#f)
        (values '1 _n1012_))))
  (define std/srfi/146/hamt#make-narrow-with-two-keys
    (lambda (_payload?990_
             _shift991_
             _h1992_
             _k1993_
             _d1994_
             _h2995_
             _k2996_
             _d2997_)
      (letrec ((_two-leaves999_
                (lambda (_f11004_ _k11005_ _d11006_ _f21007_ _k21008_ _d21009_)
                  (let ((__tmp4934
                         (if _payload?990_
                             (vector _k11005_ _d11006_ _k21008_ _d21009_)
                             (vector _k11005_ _k21008_)))
                        (__tmp4933
                         (std/srfi/151#copy-bit
                          _f21007_
                          (std/srfi/151#copy-bit _f11004_ '0 '#t)
                          '#t)))
                    (declare (not safe))
                    (##structure
                     std/srfi/146/hamt#narrow
                     __tmp4934
                     '0
                     __tmp4933)))))
        (if (not (= _h1992_ _h2995_))
            '#!void
            (error '"Assertion failed:"
                   '(not (= h1 h2))
                   (list 'not (= _h1992_ _h2995_))))
        (let ((_f11001_ (std/srfi/146/hamt#hash-fragment _shift991_ _h1992_))
              (_f21002_ (std/srfi/146/hamt#hash-fragment _shift991_ _h2995_)))
          (if (= _f11001_ _f21002_)
              (let ((__tmp4936
                     (vector (std/srfi/146/hamt#make-narrow-with-two-keys
                              _payload?990_
                              (+ _shift991_
                                 std/srfi/146/hamt#hamt-hash-slice-size)
                              _h1992_
                              _k1993_
                              _d1994_
                              _h2995_
                              _k2996_
                              _d2997_)))
                    (__tmp4935 (std/srfi/151#copy-bit _f11001_ '0 '#t)))
                (declare (not safe))
                (##structure std/srfi/146/hamt#narrow __tmp4936 __tmp4935 '0))
              (if (< _f11001_ _f21002_)
                  (_two-leaves999_
                   _f11001_
                   _k1993_
                   _d1994_
                   _f21002_
                   _k2996_
                   _d2997_)
                  (_two-leaves999_
                   _f21002_
                   _k2996_
                   _d2997_
                   _f11001_
                   _k1993_
                   _d1994_)))))))
  (define std/srfi/146/hamt#modify-pure
    (lambda (_hamt983_ _n984_ _shift985_ _dp986_ _h987_ _k988_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _n984_ 'std/srfi/146/hamt#collision))
          (std/srfi/146/hamt#modify-collision
           _hamt983_
           _n984_
           _shift985_
           _dp986_
           _h987_
           _k988_)
          (if (let ()
                (declare (not safe))
                (##structure-instance-of? _n984_ 'std/srfi/146/hamt#narrow))
              (std/srfi/146/hamt#modify-narrow
               _hamt983_
               _n984_
               _shift985_
               _dp986_
               _h987_
               _k988_)
              (if (let ()
                    (declare (not safe))
                    (##structure-instance-of? _n984_ 'std/srfi/146/hamt#wide))
                  (error '"Should have been converted to narrow before here.")
                  (error '"Unknown HAMT node type." _n984_))))))
  (define std/srfi/146/hamt#lower-collision
    (lambda (_hamt964_ _n965_ _shift966_ _dp967_ _h968_ _k969_)
      (let ((_collision-hash971_
             (##structure-ref _n965_ '2 std/srfi/146/hamt#collision '#f))
            (_d972_ (_dp967_ std/srfi/146/hamt#hamt-null)))
        (if (std/srfi/146/hamt#hamt-null? _d972_)
            (values '0 _n965_)
            (values '1
                    (let _descend974_ ((_shift976_ _shift966_))
                      (let ((_collision-fragment978_
                             (std/srfi/146/hamt#hash-fragment
                              _shift976_
                              _collision-hash971_))
                            (_leaf-fragment979_
                             (std/srfi/146/hamt#hash-fragment
                              _shift976_
                              _h968_)))
                        (if (= _collision-fragment978_ _leaf-fragment979_)
                            (let ((_child981_
                                   (_descend974_
                                    (+ _shift976_
                                       std/srfi/146/hamt#hamt-hash-slice-size))))
                              (let ((__tmp4938 (vector _child981_))
                                    (__tmp4937
                                     (std/srfi/151#copy-bit
                                      _collision-fragment978_
                                      '0
                                      '#t)))
                                (declare (not safe))
                                (##structure
                                 std/srfi/146/hamt#narrow
                                 __tmp4938
                                 __tmp4937
                                 '0)))
                            (let ((__tmp4941
                                   (if (##structure-ref
                                        _hamt964_
                                        '5
                                        std/srfi/146/hamt#hash-array-mapped-trie
                                        '#f)
                                       (vector _k969_ _d972_ _n965_)
                                       (vector _k969_ _n965_)))
                                  (__tmp4940
                                   (std/srfi/151#copy-bit
                                    _collision-fragment978_
                                    '0
                                    '#t))
                                  (__tmp4939
                                   (std/srfi/151#copy-bit
                                    _leaf-fragment979_
                                    '0
                                    '#t)))
                              (declare (not safe))
                              (##structure
                               std/srfi/146/hamt#narrow
                               __tmp4941
                               __tmp4940
                               __tmp4939))))))))))
  (define std/srfi/146/hamt#modify-collision
    (lambda (_hamt934_ _n935_ _shift936_ _dp937_ _h938_ _k939_)
      (if (= _h938_
             (##structure-ref _n935_ '2 std/srfi/146/hamt#collision '#f))
          (let ((_payload?941_
                 (##structure-ref
                  _hamt934_
                  '5
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)))
            (let _next943_ ((_entries945_
                             (##structure-ref
                              _n935_
                              '1
                              std/srfi/146/hamt#collision
                              '#f))
                            (_checked946_ '()))
              (if (null? _entries945_)
                  (let ((_d948_ (_dp937_ std/srfi/146/hamt#hamt-null)))
                    (if (std/srfi/146/hamt#hamt-null? _d948_)
                        (values '0 _n935_)
                        (values '1
                                (let ((__tmp4942
                                       (if _payload?941_
                                           (cons (cons _k939_ _d948_)
                                                 _checked946_)
                                           (cons _k939_ _checked946_))))
                                  (declare (not safe))
                                  (##structure
                                   std/srfi/146/hamt#collision
                                   __tmp4942
                                   _h938_)))))
                  (let* ((_entry950_ (car _entries945_))
                         (_key952_
                          (if _payload?941_ (car _entry950_) _entry950_)))
                    (if ((##structure-ref
                          _hamt934_
                          '1
                          std/srfi/146/hamt#hash-array-mapped-trie
                          '#f)
                         _k939_
                         _key952_)
                        (let* ((_existing955_
                                (if _payload?941_
                                    (cdr _entry950_)
                                    std/srfi/146/hamt#hamt-null))
                               (_d957_ (_dp937_ _existing955_))
                               (_delete?959_
                                (std/srfi/146/hamt#hamt-null? _d957_))
                               (_others961_
                                (append _checked946_ (cdr _entries945_))))
                          (values (if _delete?959_ '-1 '0)
                                  (let ((__tmp4943
                                         (if _delete?959_
                                             _others961_
                                             (if _payload?941_
                                                 (cons (cons _k939_ _d957_)
                                                       _others961_)
                                                 (cons _k939_ _others961_)))))
                                    (declare (not safe))
                                    (##structure
                                     std/srfi/146/hamt#collision
                                     __tmp4943
                                     _h938_))))
                        (_next943_
                         (cdr _entries945_)
                         (cons (car _entries945_) _checked946_)))))))
          (std/srfi/146/hamt#lower-collision
           _hamt934_
           _n935_
           _shift936_
           _dp937_
           _h938_
           _k939_))))
  (define std/srfi/146/hamt#leaf-stride
    (lambda (_payload?932_) (if _payload?932_ '2 '1)))
  (define std/srfi/146/hamt#narrow-child-index
    (lambda (_l927_ _c928_ _mask929_ _payload?930_)
      (+ (* (std/srfi/146/hamt#leaf-stride _payload?930_) (bit-count _l927_))
         (bit-count (bitwise-and _c928_ _mask929_)))))
  (define std/srfi/146/hamt#narrow-leaf-index
    (lambda (_l923_ _mask924_ _payload?925_)
      (* (std/srfi/146/hamt#leaf-stride _payload?925_)
         (bit-count (bitwise-and _l923_ _mask924_)))))
  (define std/srfi/146/hamt#modify-narrow
    (lambda (_hamt912_ _n913_ _shift914_ _dp915_ _h916_ _k917_)
      (let ((_fragment919_
             (std/srfi/146/hamt#hash-fragment _shift914_ _h916_)))
        (if (bit-set?
             _fragment919_
             (##structure-ref _n913_ '2 std/srfi/146/hamt#narrow '#f))
            (std/srfi/146/hamt#modify-narrow-child
             _hamt912_
             _n913_
             _shift914_
             _dp915_
             _h916_
             _k917_)
            (if (bit-set?
                 _fragment919_
                 (##structure-ref _n913_ '3 std/srfi/146/hamt#narrow '#f))
                (std/srfi/146/hamt#modify-narrow-leaf
                 _hamt912_
                 _n913_
                 _shift914_
                 _dp915_
                 _h916_
                 _k917_)
                (let ((_d921_ (_dp915_ std/srfi/146/hamt#hamt-null)))
                  (if (std/srfi/146/hamt#hamt-null? _d921_)
                      (values '0 _n913_)
                      (std/srfi/146/hamt#modify-narrow-new
                       _hamt912_
                       _n913_
                       _shift914_
                       _d921_
                       _h916_
                       _k917_))))))))
  (define std/srfi/146/hamt#modify-narrow-child
    (lambda (_hamt816_ _n817_ _shift818_ _dp819_ _h820_ _k821_)
      (let* ((_fragment823_
              (std/srfi/146/hamt#hash-fragment _shift818_ _h820_))
             (_mask825_ (std/srfi/146/hamt#fragment->mask _fragment823_))
             (_c827_ (##structure-ref _n817_ '2 std/srfi/146/hamt#narrow '#f))
             (_l829_ (##structure-ref _n817_ '3 std/srfi/146/hamt#narrow '#f))
             (_array831_
              (##structure-ref _n817_ '1 std/srfi/146/hamt#narrow '#f))
             (_payload?833_
              (##structure-ref
               _hamt816_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_child-index835_
              (std/srfi/146/hamt#narrow-child-index
               _l829_
               _c827_
               _mask825_
               _payload?833_))
             (_child837_ (vector-ref _array831_ _child-index835_))
             (_g4944_ (std/srfi/146/hamt#modify-pure
                       _hamt816_
                       _child837_
                       (+ _shift818_ std/srfi/146/hamt#hamt-hash-slice-size)
                       _dp819_
                       _h820_
                       _k821_)))
        (begin
          (let ((_g4945_ (let ()
                           (declare (not safe))
                           (if (##values? _g4944_)
                               (##vector-length _g4944_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4945_ 2)))
                (error "Context expects 2 values" _g4945_)))
          (let ((_change839_
                 (let () (declare (not safe)) (##vector-ref _g4944_ 0)))
                (_new-child840_
                 (let () (declare (not safe)) (##vector-ref _g4944_ 1))))
            (let ()
              (letrec ((_coalesce843_
                        (lambda (_key851_ _datum852_)
                          (let ((_leaf-index854_
                                 (std/srfi/146/hamt#narrow-leaf-index
                                  _l829_
                                  _mask825_
                                  _payload?833_)))
                            (values _change839_
                                    (let ((__tmp4948
                                           (if _payload?833_
                                               (let* ((_result856_
                                                       (make-vector
                                                        (+ (vector-length
                                                            _array831_)
                                                           (- (+ (+ '0 '1) '1)
                                                              '1))))
                                                      (_index859_
                                                       _leaf-index854_))
                                                 (vector-copy!
                                                  _result856_
                                                  (+ '0 '0)
                                                  _array831_
                                                  '0
                                                  _index859_)
                                                 (vector-set!
                                                  _result856_
                                                  (+ '0 _index859_)
                                                  _key851_)
                                                 (let* ((_skew862_ (+ '0 '1))
                                                        (_index865_
                                                         _leaf-index854_))
                                                   (vector-copy!
                                                    _result856_
                                                    (+ _index859_ _skew862_)
                                                    _array831_
                                                    _index859_
                                                    _index865_)
                                                   (vector-set!
                                                    _result856_
                                                    (+ _skew862_ _index865_)
                                                    _datum852_)
                                                   (let* ((_skew868_
                                                           (+ _skew862_ '1))
                                                          (_index871_
                                                           _child-index835_))
                                                     (vector-copy!
                                                      _result856_
                                                      (+ _index865_ _skew868_)
                                                      _array831_
                                                      _index865_
                                                      _index871_)
                                                     (let* ((_dropped874_ '1)
                                                            (_offset877_
                                                             (+ _index871_
                                                                _dropped874_))
                                                            (_skew880_
                                                             (- _skew868_
                                                                _dropped874_)))
                                                       (let ((_index884_
                                                              (vector-length
                                                               _array831_)))
                                                         (vector-copy!
                                                          _result856_
                                                          (+ _offset877_
                                                             _skew880_)
                                                          _array831_
                                                          _offset877_
                                                          _index884_)
                                                         _result856_)))))
                                               (let* ((_result887_
                                                       (make-vector
                                                        (+ (vector-length
                                                            _array831_)
                                                           (- (+ '0 '1) '1))))
                                                      (_index890_
                                                       _leaf-index854_))
                                                 (vector-copy!
                                                  _result887_
                                                  (+ '0 '0)
                                                  _array831_
                                                  '0
                                                  _index890_)
                                                 (vector-set!
                                                  _result887_
                                                  (+ '0 _index890_)
                                                  _key851_)
                                                 (let* ((_skew893_ (+ '0 '1))
                                                        (_index896_
                                                         _child-index835_))
                                                   (vector-copy!
                                                    _result887_
                                                    (+ _index890_ _skew893_)
                                                    _array831_
                                                    _index890_
                                                    _index896_)
                                                   (let* ((_dropped899_ '1)
                                                          (_offset902_
                                                           (+ _index896_
                                                              _dropped899_))
                                                          (_skew905_
                                                           (- _skew893_
                                                              _dropped899_)))
                                                     (let ((_index909_
                                                            (vector-length
                                                             _array831_)))
                                                       (vector-copy!
                                                        _result887_
                                                        (+ _offset902_
                                                           _skew905_)
                                                        _array831_
                                                        _offset902_
                                                        _index909_)
                                                       _result887_))))))
                                          (__tmp4947
                                           (std/srfi/151#copy-bit
                                            _fragment823_
                                            _c827_
                                            '#f))
                                          (__tmp4946
                                           (std/srfi/151#copy-bit
                                            _fragment823_
                                            _l829_
                                            '#t)))
                                      (declare (not safe))
                                      (##structure
                                       std/srfi/146/hamt#narrow
                                       __tmp4948
                                       __tmp4947
                                       __tmp4946))))))
                       (_replace844_
                        (lambda ()
                          (values _change839_
                                  (let ((__tmp4949
                                         (std/srfi/146/vector-edit#vector-replace-one
                                          _array831_
                                          _child-index835_
                                          _new-child840_)))
                                    (declare (not safe))
                                    (##structure
                                     std/srfi/146/hamt#narrow
                                     __tmp4949
                                     _c827_
                                     _l829_))))))
                (if (eq? _new-child840_ _child837_)
                    (values '0 _n817_)
                    (if (std/srfi/146/hamt#hamt-null? _new-child840_)
                        (error '"Child cannot become null." _n817_)
                        (if (let ()
                              (declare (not safe))
                              (##structure-instance-of?
                               _new-child840_
                               'std/srfi/146/hamt#collision))
                            (if (std/srfi/146/hamt#collision-single-leaf?
                                 _new-child840_)
                                (let ((_a846_ (car (##structure-ref
                                                    _new-child840_
                                                    '1
                                                    std/srfi/146/hamt#collision
                                                    '#f))))
                                  (if _payload?833_
                                      (_coalesce843_ (car _a846_) (cdr _a846_))
                                      (_coalesce843_ _a846_ '#f)))
                                (_replace844_))
                            (if (let ()
                                  (declare (not safe))
                                  (##structure-instance-of?
                                   _new-child840_
                                   'std/srfi/146/hamt#narrow))
                                (if (std/srfi/146/hamt#narrow-single-leaf?
                                     _new-child840_)
                                    (let ((_a848_ (##structure-ref
                                                   _new-child840_
                                                   '1
                                                   std/srfi/146/hamt#narrow
                                                   '#f)))
                                      (_coalesce843_
                                       (vector-ref _a848_ '0)
                                       (if _payload?833_
                                           (vector-ref _a848_ '1)
                                           '#f)))
                                    (_replace844_))
                                (if (let ()
                                      (declare (not safe))
                                      (##structure-instance-of?
                                       _new-child840_
                                       'std/srfi/146/hamt#wide))
                                    (error '"New child should be collision or narrow.")
                                    (error '"Unexpected type of child node.")))))))))))))
  (define std/srfi/146/hamt#modify-narrow-leaf
    (lambda (_hamt783_ _n784_ _shift785_ _dp786_ _h787_ _k788_)
      (let* ((_fragment790_
              (std/srfi/146/hamt#hash-fragment _shift785_ _h787_))
             (_mask792_ (std/srfi/146/hamt#fragment->mask _fragment790_))
             (_c794_ (##structure-ref _n784_ '2 std/srfi/146/hamt#narrow '#f))
             (_l796_ (##structure-ref _n784_ '3 std/srfi/146/hamt#narrow '#f))
             (_array798_
              (##structure-ref _n784_ '1 std/srfi/146/hamt#narrow '#f))
             (_payload?800_
              (##structure-ref
               _hamt783_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_stride802_ (std/srfi/146/hamt#leaf-stride _payload?800_))
             (_leaf-index804_
              (std/srfi/146/hamt#narrow-leaf-index
               _l796_
               _mask792_
               _payload?800_))
             (_key806_ (vector-ref _array798_ _leaf-index804_)))
        (if ((##structure-ref
              _hamt783_
              '1
              std/srfi/146/hamt#hash-array-mapped-trie
              '#f)
             _k788_
             _key806_)
            (let* ((_existing809_
                    (if _payload?800_
                        (vector-ref _array798_ (+ _leaf-index804_ '1))
                        std/srfi/146/hamt#hamt-null))
                   (_d811_ (_dp786_ _existing809_)))
              (if (std/srfi/146/hamt#hamt-null? _d811_)
                  (values '-1
                          (let ((__tmp4951
                                 (std/srfi/146/vector-edit#vector-without
                                  _array798_
                                  _leaf-index804_
                                  (+ _leaf-index804_ _stride802_)))
                                (__tmp4950
                                 (std/srfi/151#copy-bit
                                  _fragment790_
                                  _l796_
                                  '#f)))
                            (declare (not safe))
                            (##structure
                             std/srfi/146/hamt#narrow
                             __tmp4951
                             _c794_
                             __tmp4950)))
                  (if _payload?800_
                      (values '0
                              (let ((__tmp4952
                                     (std/srfi/146/vector-edit#vector-replace-one
                                      _array798_
                                      (+ _leaf-index804_ '1)
                                      _d811_)))
                                (declare (not safe))
                                (##structure
                                 std/srfi/146/hamt#narrow
                                 __tmp4952
                                 _c794_
                                 _l796_)))
                      (values '0 _n784_))))
            (let ((_d814_ (_dp786_ std/srfi/146/hamt#hamt-null)))
              (if (std/srfi/146/hamt#hamt-null? _d814_)
                  (values '0 _n784_)
                  (std/srfi/146/hamt#add-narrow-leaf-key
                   _hamt783_
                   _n784_
                   _shift785_
                   _d814_
                   _h787_
                   _k788_)))))))
  (define std/srfi/146/hamt#add-narrow-leaf-key
    (lambda (_hamt695_ _n696_ _shift697_ _d698_ _h699_ _k700_)
      (letrec* ((_payload?702_
                 (##structure-ref
                  _hamt695_
                  '5
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f))
                (_make-entry703_
                 (if _payload?702_ cons (lambda (_k780_ _d781_) _k780_))))
        (let* ((_fragment705_
                (std/srfi/146/hamt#hash-fragment _shift697_ _h699_))
               (_mask707_ (std/srfi/146/hamt#fragment->mask _fragment705_))
               (_c709_ (##structure-ref
                        _n696_
                        '2
                        std/srfi/146/hamt#narrow
                        '#f))
               (_l711_ (##structure-ref
                        _n696_
                        '3
                        std/srfi/146/hamt#narrow
                        '#f))
               (_array713_
                (##structure-ref _n696_ '1 std/srfi/146/hamt#narrow '#f))
               (_payload?715_
                (##structure-ref
                 _hamt695_
                 '5
                 std/srfi/146/hamt#hash-array-mapped-trie
                 '#f))
               (_stride717_ (std/srfi/146/hamt#leaf-stride _payload?715_))
               (_leaf-index719_
                (std/srfi/146/hamt#narrow-leaf-index
                 _l711_
                 _mask707_
                 _payload?715_))
               (_key721_ (vector-ref _array713_ _leaf-index719_))
               (_child-index723_
                (std/srfi/146/hamt#narrow-child-index
                 _l711_
                 _c709_
                 _mask707_
                 _payload?715_))
               (_hash725_
                (std/srfi/146/hamt#hash-bits
                 (##structure-ref
                  _hamt695_
                  '3
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)
                 _key721_))
               (_datum727_
                (if _payload?715_
                    (vector-ref _array713_ (+ _leaf-index719_ '1))
                    '#f)))
          (values '1
                  (let ((__tmp4955
                         (if (= _h699_ _hash725_)
                             (let* ((_result730_
                                     (make-vector
                                      (+ (vector-length _array713_)
                                         (+ (- '0 _stride717_) '1))))
                                    (_index733_ _leaf-index719_))
                               (vector-copy!
                                _result730_
                                (+ '0 '0)
                                _array713_
                                '0
                                _index733_)
                               (let* ((_dropped736_ _stride717_)
                                      (_offset739_ (+ _index733_ _dropped736_))
                                      (_skew742_ (- '0 _dropped736_)))
                                 (let ((_index746_ _child-index723_))
                                   (vector-copy!
                                    _result730_
                                    (+ _offset739_ _skew742_)
                                    _array713_
                                    _offset739_
                                    _index746_)
                                   (vector-set!
                                    _result730_
                                    (+ _skew742_ _index746_)
                                    (let ((__tmp4956
                                           (list (_make-entry703_
                                                  _k700_
                                                  _d698_)
                                                 (_make-entry703_
                                                  _key721_
                                                  _datum727_))))
                                      (declare (not safe))
                                      (##structure
                                       std/srfi/146/hamt#collision
                                       __tmp4956
                                       _h699_)))
                                   (let* ((_skew749_ (+ _skew742_ '1))
                                          (_index752_
                                           (vector-length _array713_)))
                                     (vector-copy!
                                      _result730_
                                      (+ _index746_ _skew749_)
                                      _array713_
                                      _index746_
                                      _index752_)
                                     _result730_))))
                             (let* ((_result755_
                                     (make-vector
                                      (+ (vector-length _array713_)
                                         (+ (- '0 _stride717_) '1))))
                                    (_index758_ _leaf-index719_))
                               (vector-copy!
                                _result755_
                                (+ '0 '0)
                                _array713_
                                '0
                                _index758_)
                               (let* ((_dropped761_ _stride717_)
                                      (_offset764_ (+ _index758_ _dropped761_))
                                      (_skew767_ (- '0 _dropped761_)))
                                 (let ((_index771_ _child-index723_))
                                   (vector-copy!
                                    _result755_
                                    (+ _offset764_ _skew767_)
                                    _array713_
                                    _offset764_
                                    _index771_)
                                   (vector-set!
                                    _result755_
                                    (+ _skew767_ _index771_)
                                    (std/srfi/146/hamt#make-narrow-with-two-keys
                                     _payload?715_
                                     (+ _shift697_
                                        std/srfi/146/hamt#hamt-hash-slice-size)
                                     _h699_
                                     _k700_
                                     _d698_
                                     _hash725_
                                     _key721_
                                     _datum727_))
                                   (let* ((_skew774_ (+ _skew767_ '1))
                                          (_index777_
                                           (vector-length _array713_)))
                                     (vector-copy!
                                      _result755_
                                      (+ _index771_ _skew774_)
                                      _array713_
                                      _index771_
                                      _index777_)
                                     _result755_))))))
                        (__tmp4954
                         (std/srfi/151#copy-bit _fragment705_ _c709_ '#t))
                        (__tmp4953
                         (std/srfi/151#copy-bit _fragment705_ _l711_ '#f)))
                    (declare (not safe))
                    (##structure
                     std/srfi/146/hamt#narrow
                     __tmp4955
                     __tmp4954
                     __tmp4953)))))))
  (define std/srfi/146/hamt#modify-narrow-new
    (lambda (_hamt641_ _n642_ _shift643_ _d644_ _h645_ _k646_)
      (let* ((_fragment648_
              (std/srfi/146/hamt#hash-fragment _shift643_ _h645_))
             (_mask650_ (std/srfi/146/hamt#fragment->mask _fragment648_))
             (_c652_ (##structure-ref _n642_ '2 std/srfi/146/hamt#narrow '#f))
             (_l654_ (##structure-ref _n642_ '3 std/srfi/146/hamt#narrow '#f))
             (_array656_
              (##structure-ref _n642_ '1 std/srfi/146/hamt#narrow '#f))
             (_payload?658_
              (##structure-ref
               _hamt641_
               '5
               std/srfi/146/hamt#hash-array-mapped-trie
               '#f))
             (_leaf-index660_
              (std/srfi/146/hamt#narrow-leaf-index
               _l654_
               _mask650_
               _payload?658_))
             (_delete?662_ (std/srfi/146/hamt#hamt-null? _d644_)))
        (values '1
                (let ((__tmp4958
                       (if _payload?658_
                           (let* ((_result665_
                                   (make-vector
                                    (+ (vector-length _array656_)
                                       (+ (+ '0 '1) '1))))
                                  (_index668_ _leaf-index660_))
                             (vector-copy!
                              _result665_
                              (+ '0 '0)
                              _array656_
                              '0
                              _index668_)
                             (vector-set! _result665_ (+ '0 _index668_) _k646_)
                             (let* ((_skew671_ (+ '0 '1))
                                    (_index674_ _leaf-index660_))
                               (vector-copy!
                                _result665_
                                (+ _index668_ _skew671_)
                                _array656_
                                _index668_
                                _index674_)
                               (vector-set!
                                _result665_
                                (+ _skew671_ _index674_)
                                _d644_)
                               (let* ((_skew677_ (+ _skew671_ '1))
                                      (_index680_ (vector-length _array656_)))
                                 (vector-copy!
                                  _result665_
                                  (+ _index674_ _skew677_)
                                  _array656_
                                  _index674_
                                  _index680_)
                                 _result665_)))
                           (let* ((_result683_
                                   (make-vector
                                    (+ (vector-length _array656_) (+ '0 '1))))
                                  (_index686_ _leaf-index660_))
                             (vector-copy!
                              _result683_
                              (+ '0 '0)
                              _array656_
                              '0
                              _index686_)
                             (vector-set! _result683_ (+ '0 _index686_) _k646_)
                             (let* ((_skew689_ (+ '0 '1))
                                    (_index692_ (vector-length _array656_)))
                               (vector-copy!
                                _result683_
                                (+ _index686_ _skew689_)
                                _array656_
                                _index686_
                                _index692_)
                               _result683_))))
                      (__tmp4957
                       (std/srfi/151#copy-bit _fragment648_ _l654_ '#t)))
                  (declare (not safe))
                  (##structure
                   std/srfi/146/hamt#narrow
                   __tmp4958
                   _c652_
                   __tmp4957))))))
  (define std/srfi/146/hamt#hamt-fetch
    (lambda (_hamt594_ _key595_)
      (let ((_h597_ (std/srfi/146/hamt#hash-bits
                     (##structure-ref
                      _hamt594_
                      '3
                      std/srfi/146/hamt#hash-array-mapped-trie
                      '#f)
                     _key595_))
            (_payload?598_
             (##structure-ref
              _hamt594_
              '5
              std/srfi/146/hamt#hash-array-mapped-trie
              '#f)))
        (let _descend600_ ((_n602_ (##structure-ref
                                    _hamt594_
                                    '6
                                    std/srfi/146/hamt#hash-array-mapped-trie
                                    '#f))
                           (_shift603_ '0))
          (if (let ()
                (declare (not safe))
                (##structure-instance-of? _n602_ 'std/srfi/146/hamt#collision))
              (let ((_entries605_
                     (##structure-ref
                      _n602_
                      '1
                      std/srfi/146/hamt#collision
                      '#f))
                    (_key=606_
                     (##structure-ref
                      _hamt594_
                      '1
                      std/srfi/146/hamt#hash-array-mapped-trie
                      '#f)))
                (if _payload?598_
                    (let ((_$e608_ (assoc _key595_ _entries605_ _key=606_)))
                      (if _$e608_ (cdr _$e608_) std/srfi/146/hamt#hamt-null))
                    (if (std/srfi/1#find-tail
                         (lambda (_e611_) (_key=606_ _key595_ _e611_))
                         _entries605_)
                        'present
                        std/srfi/146/hamt#hamt-null)))
              (if (let ()
                    (declare (not safe))
                    (##structure-instance-of?
                     _n602_
                     'std/srfi/146/hamt#narrow))
                  (let ((_array613_
                         (##structure-ref
                          _n602_
                          '1
                          std/srfi/146/hamt#narrow
                          '#f))
                        (_c614_ (##structure-ref
                                 _n602_
                                 '2
                                 std/srfi/146/hamt#narrow
                                 '#f))
                        (_l615_ (##structure-ref
                                 _n602_
                                 '3
                                 std/srfi/146/hamt#narrow
                                 '#f))
                        (_fragment616_
                         (std/srfi/146/hamt#hash-fragment _shift603_ _h597_)))
                    (if (bit-set? _fragment616_ _c614_)
                        (let* ((_mask618_
                                (std/srfi/146/hamt#fragment->mask
                                 _fragment616_))
                               (_child-index620_
                                (std/srfi/146/hamt#narrow-child-index
                                 _l615_
                                 _c614_
                                 _mask618_
                                 (##structure-ref
                                  _hamt594_
                                  '5
                                  std/srfi/146/hamt#hash-array-mapped-trie
                                  '#f))))
                          (_descend600_
                           (vector-ref _array613_ _child-index620_)
                           (+ _shift603_
                              std/srfi/146/hamt#hamt-hash-slice-size)))
                        (if (bit-set? _fragment616_ _l615_)
                            (let* ((_mask623_
                                    (std/srfi/146/hamt#fragment->mask
                                     _fragment616_))
                                   (_leaf-index625_
                                    (std/srfi/146/hamt#narrow-leaf-index
                                     _l615_
                                     _mask623_
                                     (##structure-ref
                                      _hamt594_
                                      '5
                                      std/srfi/146/hamt#hash-array-mapped-trie
                                      '#f)))
                                   (_k627_ (vector-ref
                                            _array613_
                                            _leaf-index625_)))
                              (if ((##structure-ref
                                    _hamt594_
                                    '1
                                    std/srfi/146/hamt#hash-array-mapped-trie
                                    '#f)
                                   _k627_
                                   _key595_)
                                  (if _payload?598_
                                      (vector-ref
                                       _array613_
                                       (+ _leaf-index625_ '1))
                                      'present)
                                  std/srfi/146/hamt#hamt-null))
                            std/srfi/146/hamt#hamt-null)))
                  (if (let ()
                        (declare (not safe))
                        (##structure-instance-of?
                         _n602_
                         'std/srfi/146/hamt#wide))
                      (let ((_array630_
                             (##structure-ref
                              _n602_
                              '1
                              std/srfi/146/hamt#wide
                              '#f))
                            (_stride631_
                             (std/srfi/146/hamt#leaf-stride
                              (##structure-ref
                               _hamt594_
                               '5
                               std/srfi/146/hamt#hash-array-mapped-trie
                               '#f)))
                            (_c632_ (##structure-ref
                                     _n602_
                                     '2
                                     std/srfi/146/hamt#wide
                                     '#f))
                            (_l633_ (##structure-ref
                                     _n602_
                                     '3
                                     std/srfi/146/hamt#wide
                                     '#f))
                            (_i634_ (std/srfi/146/hamt#hash-fragment
                                     _shift603_
                                     _h597_)))
                        (if (bit-set? _i634_ _c632_)
                            (_descend600_
                             (vector-ref _array630_ (* _stride631_ _i634_))
                             (+ _shift603_
                                std/srfi/146/hamt#hamt-hash-slice-size))
                            (if (bit-set? _i634_ _l633_)
                                (let* ((_j636_ (* _stride631_ _i634_))
                                       (_k638_ (vector-ref _array630_ _j636_)))
                                  (if ((##structure-ref
                                        _hamt594_
                                        '1
                                        std/srfi/146/hamt#hash-array-mapped-trie
                                        '#f)
                                       _k638_
                                       _key595_)
                                      (if _payload?598_
                                          (vector-ref _array630_ (+ _j636_ '1))
                                          'present)
                                      std/srfi/146/hamt#hamt-null))
                                std/srfi/146/hamt#hamt-null)))
                      (error '"Unexpected type of child node."))))))))
  (define std/srfi/146/hamt#collision/for-each
    (lambda (_procedure574_ _node575_ _payload?576_)
      (if _payload?576_
          (let _$loop578_ ((_remaining581_
                            (##structure-ref
                             _node575_
                             '1
                             std/srfi/146/hamt#collision
                             '#f)))
            (if (null? _remaining581_)
                '#!void
                (begin
                  (let ((_e584_ (car _remaining581_)))
                    (_procedure574_ (car _e584_) (cdr _e584_)))
                  (_$loop578_ (cdr _remaining581_)))))
          (let _$loop586_ ((_remaining589_
                            (##structure-ref
                             _node575_
                             '1
                             std/srfi/146/hamt#collision
                             '#f)))
            (if (null? _remaining589_)
                '#!void
                (begin
                  (let ((_e592_ (car _remaining589_)))
                    (_procedure574_ _e592_ '#f))
                  (_$loop586_ (cdr _remaining589_))))))))
  (define std/srfi/146/hamt#narrow/for-each
    (lambda (_procedure542_ _node543_ _payload?544_)
      (let ((_array546_
             (##structure-ref _node543_ '1 std/srfi/146/hamt#narrow '#f))
            (_stride547_ (std/srfi/146/hamt#leaf-stride _payload?544_))
            (_c548_ (##structure-ref
                     _node543_
                     '2
                     std/srfi/146/hamt#narrow
                     '#f))
            (_l549_ (##structure-ref
                     _node543_
                     '3
                     std/srfi/146/hamt#narrow
                     '#f)))
        (let _next-leaf551_ ((_count553_ '0) (_start554_ '0))
          (let ((_i556_ (std/srfi/146/hamt#next-set-bit
                         _l549_
                         _start554_
                         std/srfi/146/hamt#hamt-bucket-size)))
            (if _i556_
                (let* ((_j558_ (* _stride547_ _count553_))
                       (_k560_ (vector-ref _array546_ _j558_))
                       (_d562_ (if _payload?544_
                                   (vector-ref _array546_ (+ _j558_ '1))
                                   '#f)))
                  (_procedure542_ _k560_ _d562_)
                  (_next-leaf551_ (+ _count553_ '1) (+ _i556_ '1)))
                (let _next-child565_ ((_start567_ '0)
                                      (_offset568_ (* _stride547_ _count553_)))
                  (let ((_i570_ (std/srfi/146/hamt#next-set-bit
                                 _c548_
                                 _start567_
                                 std/srfi/146/hamt#hamt-bucket-size)))
                    (if _i570_
                        (let ((_child572_ (vector-ref _array546_ _offset568_)))
                          (std/srfi/146/hamt#hamt-node/for-each
                           _child572_
                           _payload?544_
                           _procedure542_)
                          (_next-child565_ (+ _i570_ '1) (+ _offset568_ '1)))
                        '#!void)))))))))
  (define std/srfi/146/hamt#wide/for-each
    (lambda (_procedure521_ _node522_ _payload?523_)
      (let ((_array525_
             (##structure-ref _node522_ '1 std/srfi/146/hamt#wide '#f))
            (_stride526_ (std/srfi/146/hamt#leaf-stride _payload?523_))
            (_c527_ (##structure-ref _node522_ '2 std/srfi/146/hamt#wide '#f))
            (_l528_ (##structure-ref _node522_ '3 std/srfi/146/hamt#wide '#f)))
        (let _$loop530_ ((_i533_ '0))
          (if (= _i533_ std/srfi/146/hamt#hamt-bucket-size)
              '#!void
              (begin
                (let ((_j535_ (* _stride526_ _i533_)))
                  (if (bit-set? _i533_ _l528_)
                      (let ((_k537_ (vector-ref _array525_ _j535_))
                            (_d538_ (if _payload?523_
                                        (vector-ref _array525_ (+ _j535_ '1))
                                        '#f)))
                        (_procedure521_ _k537_ _d538_))
                      (if (bit-set? _i533_ _c527_)
                          (let ((_child540_ (vector-ref _array525_ _j535_)))
                            (std/srfi/146/hamt#hamt-node/for-each
                             _child540_
                             _payload?523_
                             _procedure521_))
                          '#!void)))
                (_$loop530_ (+ _i533_ '1))))))))
  (define std/srfi/146/hamt#hamt-node/for-each
    (lambda (_node517_ _payload?518_ _procedure519_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _node517_ 'std/srfi/146/hamt#collision))
          (std/srfi/146/hamt#collision/for-each
           _procedure519_
           _node517_
           _payload?518_)
          (if (let ()
                (declare (not safe))
                (##structure-instance-of? _node517_ 'std/srfi/146/hamt#narrow))
              (std/srfi/146/hamt#narrow/for-each
               _procedure519_
               _node517_
               _payload?518_)
              (if (let ()
                    (declare (not safe))
                    (##structure-instance-of?
                     _node517_
                     'std/srfi/146/hamt#wide))
                  (std/srfi/146/hamt#wide/for-each
                   _procedure519_
                   _node517_
                   _payload?518_)
                  (error '"Invalid type of node." _node517_))))))
  (define std/srfi/146/hamt#hamt/for-each
    (lambda (_procedure514_ _hamt515_)
      (std/srfi/146/hamt#hamt-node/for-each
       (##structure-ref
        _hamt515_
        '6
        std/srfi/146/hamt#hash-array-mapped-trie
        '#f)
       (##structure-ref
        _hamt515_
        '5
        std/srfi/146/hamt#hash-array-mapped-trie
        '#f)
       _procedure514_)))
  (define std/srfi/146/hamt#hamt->list
    (lambda (_hamt506_ _procedure507_)
      (let ((_accumulator509_ '()))
        (std/srfi/146/hamt#hamt/for-each
         (lambda (_k511_ _v512_)
           (set! _accumulator509_
                 (cons (_procedure507_ _k511_ _v512_) _accumulator509_)))
         _hamt506_)
        _accumulator509_)))
  (define std/srfi/146/hamt#assert-collision-valid
    (lambda (_node488_ _hp489_ _payload?490_)
      (let ((_entries494_
             (##structure-ref _node488_ '1 std/srfi/146/hamt#collision '#f))
            (_hash495_
             (##structure-ref _node488_ '2 std/srfi/146/hamt#collision '#f))
            (_extract496_ (if _payload?490_ car (lambda (_x492_) _x492_))))
        (let _$loop498_ ((_remaining501_ _entries494_))
          (if (null? _remaining501_)
              '#!void
              (begin
                (let ((_a504_ (car _remaining501_)))
                  (if (= _hash495_
                         (std/srfi/146/hamt#hash-bits
                          _hp489_
                          (_extract496_ _a504_)))
                      '#!void
                      (error '"Assertion failed:"
                             '(= hash (hash-bits hp (extract a)))
                             (list '=
                                   _hash495_
                                   (std/srfi/146/hamt#hash-bits
                                    _hp489_
                                    (_extract496_ _a504_))))))
                (_$loop498_ (cdr _remaining501_)))))
        (if _payload?490_ (map car _entries494_) _entries494_))))
  (define std/srfi/146/hamt#assert-narrow-valid
    (lambda (_node451_ _hp452_ _payload?453_ _shift454_)
      (let ((_array456_
             (##structure-ref _node451_ '1 std/srfi/146/hamt#narrow '#f))
            (_stride457_ (std/srfi/146/hamt#leaf-stride _payload?453_))
            (_c458_ (##structure-ref
                     _node451_
                     '2
                     std/srfi/146/hamt#narrow
                     '#f))
            (_l459_ (##structure-ref
                     _node451_
                     '3
                     std/srfi/146/hamt#narrow
                     '#f)))
        (if (zero? (bitwise-and _c458_ _l459_))
            '#!void
            (error '"Assertion failed:"
                   '(zero? (bitwise-and c l))
                   (list 'zero? (bitwise-and _c458_ _l459_))))
        (let _next-leaf461_ ((_count463_ '0) (_i464_ '0) (_keys465_ '()))
          (if (< _i464_ std/srfi/146/hamt#hamt-bucket-size)
              (if (bit-set? _i464_ _l459_)
                  (let ((_k467_ (vector-ref
                                 _array456_
                                 (* _stride457_ _count463_))))
                    (if (= _i464_
                           (std/srfi/146/hamt#hash-fragment
                            _shift454_
                            (std/srfi/146/hamt#hash-bits _hp452_ _k467_)))
                        '#!void
                        (error '"Assertion failed:"
                               '(= i (hash-fragment shift (hash-bits hp k)))
                               (list '=
                                     _i464_
                                     (std/srfi/146/hamt#hash-fragment
                                      _shift454_
                                      (std/srfi/146/hamt#hash-bits
                                       _hp452_
                                       _k467_)))))
                    (_next-leaf461_
                     (+ _count463_ '1)
                     (+ _i464_ '1)
                     (cons _k467_ _keys465_)))
                  (_next-leaf461_ _count463_ (+ _i464_ '1) _keys465_))
              (let _next-child469_ ((_i471_ '0)
                                    (_key-groups472_ (list _keys465_))
                                    (_offset473_ (* _stride457_ _count463_)))
                (if (= _i471_ std/srfi/146/hamt#hamt-bucket-size)
                    (apply append _key-groups472_)
                    (if (bit-set? _i471_ _c458_)
                        (let* ((_child475_ (vector-ref _array456_ _offset473_))
                               (_child-keys477_
                                (std/srfi/146/hamt#assert-hamt-node-valid
                                 _child475_
                                 _hp452_
                                 _payload?453_
                                 (+ _shift454_
                                    std/srfi/146/hamt#hamt-hash-slice-size))))
                          (let _$loop480_ ((_remaining483_ _child-keys477_))
                            (if (null? _remaining483_)
                                '#!void
                                (begin
                                  (let ((_k486_ (car _remaining483_)))
                                    (if (= _i471_
                                           (std/srfi/146/hamt#hash-fragment
                                            _shift454_
                                            (std/srfi/146/hamt#hash-bits
                                             _hp452_
                                             _k486_)))
                                        '#!void
                                        (error '"Assertion failed:"
                                               '(= i
                                                   (hash-fragment
                                                    shift
                                                    (hash-bits hp k)))
                                               (list '=
                                                     _i471_
                                                     (std/srfi/146/hamt#hash-fragment
                                                      _shift454_
                                                      (std/srfi/146/hamt#hash-bits
                                                       _hp452_
                                                       _k486_))))))
                                  (_$loop480_ (cdr _remaining483_)))))
                          (_next-child469_
                           (+ _i471_ '1)
                           (cons _child-keys477_ _key-groups472_)
                           (+ _offset473_ '1)))
                        (_next-child469_
                         (+ _i471_ '1)
                         _key-groups472_
                         _offset473_)))))))))
  (define std/srfi/146/hamt#assert-wide-valid
    (lambda (_node419_ _hp420_ _payload?421_ _shift422_)
      (let ((_array424_
             (##structure-ref _node419_ '1 std/srfi/146/hamt#wide '#f))
            (_stride425_ (std/srfi/146/hamt#leaf-stride _payload?421_))
            (_c426_ (##structure-ref _node419_ '2 std/srfi/146/hamt#wide '#f))
            (_l427_ (##structure-ref _node419_ '3 std/srfi/146/hamt#wide '#f)))
        (if (zero? (bitwise-and _c426_ _l427_))
            '#!void
            (error '"Assertion failed:"
                   '(zero? (bitwise-and c l))
                   (list 'zero? (bitwise-and _c426_ _l427_))))
        (let _next-fragment429_ ((_i431_ '0) (_key-groups432_ '()))
          (if (= _i431_ std/srfi/146/hamt#hamt-bucket-size)
              (apply append _key-groups432_)
              (let ((_j434_ (* _stride425_ _i431_)))
                (if (bit-set? _i431_ _l427_)
                    (let ((_k436_ (vector-ref _array424_ _j434_)))
                      (if (= _i431_
                             (std/srfi/146/hamt#hash-fragment
                              _shift422_
                              (std/srfi/146/hamt#hash-bits _hp420_ _k436_)))
                          '#!void
                          (error '"Assertion failed:"
                                 '(= i (hash-fragment shift (hash-bits hp k)))
                                 (list '=
                                       _i431_
                                       (std/srfi/146/hamt#hash-fragment
                                        _shift422_
                                        (std/srfi/146/hamt#hash-bits
                                         _hp420_
                                         _k436_)))))
                      (_next-fragment429_
                       (+ _i431_ '1)
                       (cons (list _k436_) _key-groups432_)))
                    (if (bit-set? _i431_ _c426_)
                        (let* ((_child438_ (vector-ref _array424_ _j434_))
                               (_child-keys440_
                                (std/srfi/146/hamt#assert-hamt-node-valid
                                 _child438_
                                 _hp420_
                                 _payload?421_
                                 (+ _shift422_
                                    std/srfi/146/hamt#hamt-hash-slice-size))))
                          (let _$loop443_ ((_remaining446_ _child-keys440_))
                            (if (null? _remaining446_)
                                '#!void
                                (begin
                                  (let ((_k449_ (car _remaining446_)))
                                    (if (= _i431_
                                           (std/srfi/146/hamt#hash-fragment
                                            _shift422_
                                            (std/srfi/146/hamt#hash-bits
                                             _hp420_
                                             _k449_)))
                                        '#!void
                                        (error '"Assertion failed:"
                                               '(= i
                                                   (hash-fragment
                                                    shift
                                                    (hash-bits hp k)))
                                               (list '=
                                                     _i431_
                                                     (std/srfi/146/hamt#hash-fragment
                                                      _shift422_
                                                      (std/srfi/146/hamt#hash-bits
                                                       _hp420_
                                                       _k449_))))))
                                  (_$loop443_ (cdr _remaining446_)))))
                          (_next-fragment429_
                           (+ _i431_ '1)
                           (cons _child-keys440_ _key-groups432_)))
                        (begin
                          (if (not (vector-ref _array424_ _j434_))
                              '#!void
                              (error '"Assertion failed:"
                                     '(not (vector-ref array j))
                                     (list 'not
                                           (vector-ref _array424_ _j434_))))
                          (if _payload?421_
                              (if (not (vector-ref _array424_ (+ _j434_ '1)))
                                  '#!void
                                  (error '"Assertion failed:"
                                         '(not (vector-ref array (+ j 1)))
                                         (list 'not
                                               (vector-ref
                                                _array424_
                                                (+ _j434_ '1)))))
                              '#!void)
                          (_next-fragment429_
                           (+ _i431_ '1)
                           _key-groups432_))))))))))
  (define std/srfi/146/hamt#assert-hamt-node-valid
    (lambda (_node414_ _hp415_ _payload?416_ _shift417_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _node414_ 'std/srfi/146/hamt#collision))
          (std/srfi/146/hamt#assert-collision-valid
           _node414_
           _hp415_
           _payload?416_)
          (if (let ()
                (declare (not safe))
                (##structure-instance-of? _node414_ 'std/srfi/146/hamt#narrow))
              (std/srfi/146/hamt#assert-narrow-valid
               _node414_
               _hp415_
               _payload?416_
               _shift417_)
              (if (let ()
                    (declare (not safe))
                    (##structure-instance-of?
                     _node414_
                     'std/srfi/146/hamt#wide))
                  (std/srfi/146/hamt#assert-wide-valid
                   _node414_
                   _hp415_
                   _payload?416_
                   _shift417_)
                  (error '"Invalid type of node." _node414_))))))
  (define std/srfi/146/hamt#assert-hamt-valid
    (lambda (_hamt405_)
      (let ((_hp407_ (##structure-ref
                      _hamt405_
                      '3
                      std/srfi/146/hamt#hash-array-mapped-trie
                      '#f)))
        (if (procedure?
             (##structure-ref
              _hamt405_
              '1
              std/srfi/146/hamt#hash-array-mapped-trie
              '#f))
            '#!void
            (error '"Assertion failed:"
                   '(procedure? (hamt/= hamt))
                   (list 'procedure?
                         (##structure-ref
                          _hamt405_
                          '1
                          std/srfi/146/hamt#hash-array-mapped-trie
                          '#f))))
        (if (procedure? _hp407_)
            '#!void
            (error '"Assertion failed:"
                   '(procedure? hp)
                   (list 'procedure? _hp407_)))
        (if (memq (##structure-ref
                   _hamt405_
                   '4
                   std/srfi/146/hamt#hash-array-mapped-trie
                   '#f)
                  '(#t #f))
            '#!void
            (error '"Assertion failed:"
                   '(memq (hamt/mutable? hamt) '(#t #f))
                   (list 'memq
                         (##structure-ref
                          _hamt405_
                          '4
                          std/srfi/146/hamt#hash-array-mapped-trie
                          '#f)
                         '(#t #f))))
        (let* ((_payload?409_
                (##structure-ref
                 _hamt405_
                 '5
                 std/srfi/146/hamt#hash-array-mapped-trie
                 '#f))
               (_keys411_
                (std/srfi/146/hamt#assert-hamt-node-valid
                 (##structure-ref
                  _hamt405_
                  '6
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)
                 _hp407_
                 _payload?409_
                 '0)))
          (if (= (##structure-ref
                  _hamt405_
                  '2
                  std/srfi/146/hamt#hash-array-mapped-trie
                  '#f)
                 (length _keys411_))
              '#!void
              (error '"Assertion failed:"
                     '(= (hamt/count hamt) (length keys))
                     (list '=
                           (##structure-ref
                            _hamt405_
                            '2
                            std/srfi/146/hamt#hash-array-mapped-trie
                            '#f)
                           (length _keys411_)))))))))
