var timapi;
(function (timapi) {
    let TimeDateFormat;
    (function (TimeDateFormat) {
        TimeDateFormat["time"] = "hh:mm:ss";
        TimeDateFormat["date"] = "dd.MM.yyyy";
        TimeDateFormat["regular"] = "dd-MM-yyyy hh:mm:ss";
    })(TimeDateFormat = timapi.TimeDateFormat || (timapi.TimeDateFormat = {}));
    class TimeDate {
        constructor(yearOrFormatOrDate, monthOrValue, day, hour, minute, second) {
            let date;
            switch (arguments.length) {
                case 6: {
                    this.$year = yearOrFormatOrDate;
                    this.$month = monthOrValue;
                    this.$day = day;
                    this.$hour = hour;
                    this.$minute = minute;
                    this.$second = second;
                    break;
                }
                case 2: {
                    const format = yearOrFormatOrDate;
                    const value = monthOrValue;
                    this.initWithFormatAndValue(format, value);
                    break;
                }
                case 1: {
                    date = yearOrFormatOrDate;
                    break;
                }
                case 0: {
                    date = new Date();
                    break;
                }
                default: {
                    throw new Error("Invalid argument");
                }
            }
            if (date !== undefined) {
                this.$year = date.getFullYear();
                this.$month = date.getMonth();
                this.$day = date.getDate();
                this.$hour = date.getHours();
                this.$minute = date.getMinutes();
                this.$second = date.getSeconds();
            }
        }
        get $year() {
            return this.year;
        }
        set $year(value) {
            this.year = value;
        }
        get $month() {
            return this.month;
        }
        set $month(value) {
            this.month = value;
        }
        get $day() {
            return this.day;
        }
        set $day(value) {
            this.day = value;
        }
        get $hour() {
            return this.hour;
        }
        set $hour(value) {
            this.hour = value;
        }
        get $minute() {
            return this.minute;
        }
        set $minute(value) {
            this.minute = value;
        }
        get $second() {
            return this.second;
        }
        set $second(value) {
            this.second = value;
        }
        format(format) {
            const year4 = this.$year.toString();
            const year2 = (this.$year % 100).toString();
            const month = (this.$month + 1).toString();
            const day = this.$day.toString();
            const hour = this.$hour.toString();
            const minute = this.$minute.toString();
            const second = this.$second.toString();
            const result = format
                .replace("yyyy", "0".repeat(4 - year4.length) + year4)
                .replace("yy", "0".repeat(2 - year2.length) + year2)
                .replace("MM", "0".repeat(2 - month.length) + month)
                .replace("dd", "0".repeat(2 - day.length) + day)
                .replace("HH", "0".repeat(2 - hour.length) + hour)
                .replace("mm", "0".repeat(2 - minute.length) + minute)
                .replace("ss", "0".repeat(2 - second.length) + second)
                .replace("Z", "+0000");
            return result;
        }
        initWithFormatAndValue(format, value) {
            format = format.replace(/[^a-zA-Z0-9]/g, "");
            const startIndexYear = format.indexOf("y");
            const endIndexYear = format.lastIndexOf("y");
            this.$year = parseInt(value.slice(startIndexYear, endIndexYear + 1), undefined);
            const startIndexMonth = format.indexOf("M");
            const endIndexMonth = format.lastIndexOf("M");
            this.$month = parseInt(value.slice(startIndexMonth, endIndexMonth + 1), undefined);
            const startIndexDay = format.indexOf("d");
            const endIndexDay = format.lastIndexOf("d");
            this.$day = parseInt(value.slice(startIndexDay, endIndexDay + 1), undefined);
            const startIndexHour = format.indexOf("H");
            const endIndexHour = format.lastIndexOf("H");
            this.$hour = parseInt(value.slice(startIndexHour, endIndexHour + 1), undefined);
            const startIndexMinute = format.indexOf("m");
            const endIndexMinute = format.lastIndexOf("m");
            this.$minute = parseInt(value.slice(startIndexMinute, endIndexMinute + 1), undefined);
            const startIndexSecond = format.indexOf("s");
            const endIndexSecond = format.lastIndexOf("s");
            this.$second = parseInt(value.slice(startIndexSecond, endIndexSecond + 1), undefined);
        }
        toStringRegular() {
            return this.format(TimeDateFormat.regular);
        }
        toStringReceiptDate() {
            return this.format(TimeDateFormat.date);
        }
        toStringReceiptTime() {
            return this.format(TimeDateFormat.time);
        }
    }
    timapi.TimeDate = TimeDate;
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var logging;
    (function (logging) {
        let ErrorCode;
        (function (ErrorCode) {
            ErrorCode[ErrorCode["CLOSE_FAILURE"] = 0] = "CLOSE_FAILURE";
            ErrorCode[ErrorCode["FLUSH_FAILURE"] = 1] = "FLUSH_FAILURE";
            ErrorCode[ErrorCode["GENERIC_FAILURE"] = 2] = "GENERIC_FAILURE";
            ErrorCode[ErrorCode["OPEN_FAILURE"] = 3] = "OPEN_FAILURE";
            ErrorCode[ErrorCode["WRITE_FAILURE"] = 4] = "WRITE_FAILURE";
        })(ErrorCode = logging.ErrorCode || (logging.ErrorCode = {}));
        class ErrorManager {
            error(msg, ex, code) {
                console.error("Error [$code]: $msg");
            }
        }
        logging.ErrorManager = ErrorManager;
    })(logging = timapi.logging || (timapi.logging = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var logging;
    (function (logging) {
        let Level;
        (function (Level) {
            Level[Level["SEVERE"] = 0] = "SEVERE";
            Level[Level["WARNING"] = 1] = "WARNING";
            Level[Level["INFO"] = 2] = "INFO";
            Level[Level["CONFIG"] = 3] = "CONFIG";
            Level[Level["FINE"] = 4] = "FINE";
            Level[Level["FINER"] = 5] = "FINER";
            Level[Level["FINEST"] = 6] = "FINEST";
            Level[Level["OFF"] = 7] = "OFF";
        })(Level = logging.Level || (logging.Level = {}));
    })(logging = timapi.logging || (timapi.logging = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var logging;
    (function (logging) {
        class Log {
            constructor($name) {
                this.name = $name;
            }
            entering(sourceClass, sourceMethod, params) {
                if (!this.isLoggable(logging.Level.FINEST)) {
                    return;
                }
                let logMessage = "Entering ->[" +
                    sourceClass +
                    "]: " +
                    sourceMethod;
                if (params !== undefined) {
                    logMessage += "\nparams:";
                    this.log(logging.Level.FINEST, logMessage, params);
                }
                else {
                    this.log(logging.Level.FINEST, logMessage);
                }
            }
            exiting(sourceClass, sourceMethod, params) {
                if (!this.isLoggable(logging.Level.FINEST)) {
                    return;
                }
                let logMessage = "Exiting ->[" +
                    sourceClass +
                    "]: " +
                    sourceMethod;
                if (params !== undefined) {
                    logMessage += "\nparams:";
                    this.log(logging.Level.FINEST, logMessage, params);
                }
                else {
                    this.log(logging.Level.FINEST, logMessage);
                }
            }
            log(level, description, event) {
                if (!this.isLoggable(level)) {
                    return;
                }
                let logMessage = "[" +
                    this.stringForLogLevel(level) +
                    "]: " +
                    description;
                let stack = "";
                if ((level == logging.Level.SEVERE) || (level == logging.Level.WARNING)) {
                    stack = new Error().stack;
                }
                if (event !== undefined) {
                    console.log(logMessage, event, " (" + this.name + ")", stack);
                }
                else {
                    console.log(logMessage, " (" + this.name + ")", stack);
                }
            }
            isLoggable(level) {
                if (Log.logLevel == logging.Level.OFF) {
                    return false;
                }
                return level <= Log.logLevel;
            }
            stringForLogLevel(level) {
                switch (level) {
                    case logging.Level.CONFIG:
                        return "CONFIG";
                    case logging.Level.FINE:
                        return "FINE";
                    case logging.Level.FINER:
                        return "FINER";
                    case logging.Level.FINEST:
                        return "FINEST";
                    case logging.Level.INFO:
                        return "INFO";
                    case logging.Level.OFF:
                        return "OFF";
                    case logging.Level.SEVERE:
                        return "SEVERE";
                    case logging.Level.WARNING:
                        return "WARNING";
                    default:
                        return "";
                }
            }
        }
        Log.logLevel = logging.Level.SEVERE;
        logging.Log = Log;
    })(logging = timapi.logging || (timapi.logging = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var logging;
    (function (logging) {
        class Logger {
            constructor() {
                this.loggers = new Array();
            }
            static getInstance() {
                if (Logger._instance == undefined) {
                    Logger._instance = new Logger();
                }
                return Logger._instance;
            }
            static getLogger(name) {
                let logger = Logger.getInstance().$loggers[name];
                if (logger == undefined) {
                    logger = new logging.Log(name);
                }
                return logger;
            }
            get $loggers() {
                return this.loggers;
            }
        }
        logging.Logger = Logger;
    })(logging = timapi.logging || (timapi.logging = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var logging;
    (function (logging) {
        class LogHandler {
            close() {
            }
            flush() {
            }
            isLoggable(record) {
                return true;
            }
            publish(record) {
                console.log(record.$message);
            }
            reportError(msg, exception, code) {
                console.error(msg);
            }
        }
        logging.LogHandler = LogHandler;
    })(logging = timapi.logging || (timapi.logging = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var logging;
    (function (logging) {
        class LogRecord {
            constructor($level, $message) {
                this.level = $level;
                this.message = $message;
            }
            get $message() {
                return this.message;
            }
            set $message(value) {
                this.message = value;
            }
            get $level() {
                return this.level;
            }
            set $level(value) {
                this.level = value;
            }
        }
        logging.LogRecord = LogRecord;
    })(logging = timapi.logging || (timapi.logging = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var utils;
    (function (utils) {
        class StringBuilder {
            constructor(value) {
                this.holder = new Array();
                this.append(value);
            }
            append(value) {
                if (value !== undefined && value !== undefined) {
                    this.holder.push(value);
                }
                return this;
            }
            toString() {
                return this.holder.join("");
            }
        }
        utils.StringBuilder = StringBuilder;
    })(utils = timapi.utils || (timapi.utils = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var utils;
    (function (utils) {
        var ArrayAdditions;
        (function (ArrayAdditions_1) {
            class ArrayAdditions {
                static remove(element, arr) {
                    let keys = Object.getOwnPropertyNames(element);
                    return arr.filter(arrElement => {
                        return arrElement !== element;
                    });
                }
            }
            ArrayAdditions_1.ArrayAdditions = ArrayAdditions;
        })(ArrayAdditions = utils.ArrayAdditions || (utils.ArrayAdditions = {}));
    })(utils = timapi.utils || (timapi.utils = {}));
})(timapi || (timapi = {}));
timapi.logging = timapi.logging || {};
timapi.constants = timapi.constants || {};
timapi.protocol = timapi.protocol || {};
timapi.protocol.constants = timapi.protocol.constants || {};
timapi.protocol.sixml = timapi.protocol.sixml || {};
timapi.statemachine = timapi.statemachine || {};
timapi.statemachine.states = timapi.statemachine.states || {};
timapi.protocol.Container = function () {
};
timapi.protocol.Container.prototype.toXmlNode = Object.abstractFunction;
timapi.protocol.Container.prototype.xmlHasAttribute = function (node, name) {
    return node.attributes.has(name);
};
timapi.protocol.Container.prototype.xmlHasChild = function (node, name) {
    for (child of node.children) {
        if (child.name == name) {
            return true;
        }
    }
    return false;
};
timapi.protocol.Container.prototype.xmlGetAttribute = function (node, name) {
    return node.attributes.get(name);
};
timapi.protocol.Container.prototype.xmlGetChild = function (node, name) {
    for (child of node.children) {
        if (child.name == name) {
            return child;
        }
    }
    throw "No such element";
};
timapi.protocol.Container.prototype.xmlGetChildren = function (node, name) {
    var list = [];
    for (child of node.children) {
        if (child.name == name) {
            list.push(child);
        }
    }
    return list;
};
timapi.protocol.Container.prototype.xmlSetAttribute = function (node, name, value) {
    node.attributes.set(name, value);
};
timapi.protocol.Container.prototype.xmlAddChild = function (node, name, value) {
    if (arguments.length == 3 && typeof value === "string") {
        var child = new timapi.protocol.XmlNode(name);
        child.textContent = value;
        node.children.push(child);
    }
    else if (arguments.length == 3 && value instanceof timapi.protocol.Container) {
        node.children.push(value.toXmlNode());
    }
    else {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.Message = function () {
};
timapi.protocol.Message.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.TimeDate = timapi.TimeDate;
timapi.protocol.XmlNode = function (name) {
    this.name = name;
    this.children = [];
    this.attributes = new Map();
};
timapi.protocol.XmlNode.prototype.name = "";
timapi.protocol.XmlNode.prototype.textContent = "";
timapi.protocol.XmlNode.prototype.children = undefined;
timapi.protocol.XmlNode.prototype.attributes = undefined;
var timapi;
(function (timapi) {
    var protocol;
    (function (protocol) {
        class XmlWriter {
            constructor($useDoubleQuotes, $useAsciiEncoding) {
                this.stringDelimiter = "\"";
                this.encoding = "UTF-8";
                if ($useDoubleQuotes) {
                    this.stringDelimiter = "\"";
                }
                else {
                    this.stringDelimiter = "\'";
                }
                if ($useAsciiEncoding) {
                    this.encoding = "US-ASCII";
                }
                else {
                    this.encoding = "UTF-8";
                }
            }
            writeXml(node, builder) {
                if (builder == undefined) {
                    builder = new timapi.utils.StringBuilder();
                }
                builder.append("<?xml version=");
                builder.append(this.stringDelimiter);
                builder.append("1.0");
                builder.append(this.stringDelimiter);
                builder.append(" encoding=");
                builder.append(this.stringDelimiter);
                builder.append(this.encoding);
                builder.append(this.stringDelimiter);
                builder.append("?>");
                this.writeXmlNode(node, builder);
                return timapi.utils.StringHelper.makeString(builder);
            }
            writeXmlNode(node, builder) {
                builder.append("<").append(node.name);
                Array.from(node.attributes).forEach(function (entry) {
                    builder.append(" ");
                    builder.append(entry[0]);
                    builder.append("=");
                    builder.append(this.stringDelimiter);
                    builder.append(entry[1]);
                    builder.append(this.stringDelimiter);
                }, this);
                if (node.children.length === 0) {
                    if (node.textContent.length === 0) {
                        builder.append("/>");
                    }
                    else {
                        builder.append(">");
                        this.escapeXmlString(builder, node.textContent);
                        builder.append("</").append(node.name).append(">");
                    }
                }
                else {
                    builder.append(">");
                    for (let child of node.children) {
                        this.writeXmlNode(child, builder);
                    }
                    builder.append("</").append(node.name).append(">");
                }
            }
            escapeXmlString(builder, text) {
                let stringValue = text.toString();
                let len = stringValue.length;
                for (let i = 0; i < len; i++) {
                    let character = stringValue[i];
                    switch (character) {
                        case "<":
                            builder.append("&lt;");
                            break;
                        case ">":
                            builder.append("&gt;");
                            break;
                        case "\"":
                            builder.append("&quot;");
                            break;
                        case "&":
                            builder.append("&amp;");
                            break;
                        case "\'":
                            builder.append("&apos;");
                            break;
                        default:
                            if (character > 0x7e) {
                                builder.append("&#").append(character).append(";");
                            }
                            else {
                                builder.append(character);
                            }
                    }
                }
            }
        }
        protocol.XmlWriter = XmlWriter;
    })(protocol = timapi.protocol || (timapi.protocol = {}));
})(timapi || (timapi = {}));
var timapi;
(function (timapi) {
    var constants;
    (function (constants) {
        let RequestType;
        (function (RequestType) {
            RequestType[RequestType["connect"] = 0] = "connect";
            RequestType[RequestType["activate"] = 1] = "activate";
            RequestType[RequestType["applicationInformation"] = 2] = "applicationInformation";
            RequestType[RequestType["balance"] = 3] = "balance";
            RequestType[RequestType["changeSettings"] = 4] = "changeSettings";
            RequestType[RequestType["commit"] = 5] = "commit";
            RequestType[RequestType["counterRequest"] = 6] = "counterRequest";
            RequestType[RequestType["deactivate"] = 7] = "deactivate";
            RequestType[RequestType["dccRates"] = 8] = "dccRates";
            RequestType[RequestType["hardwareInformation"] = 9] = "hardwareInformation";
            RequestType[RequestType["initTransaction"] = 10] = "initTransaction";
            RequestType[RequestType["login"] = 11] = "login";
            RequestType[RequestType["logout"] = 12] = "logout";
            RequestType[RequestType["reboot"] = 13] = "reboot";
            RequestType[RequestType["reconciliation"] = 14] = "reconciliation";
            RequestType[RequestType["receiptRequest"] = 15] = "receiptRequest";
            RequestType[RequestType["reconfig"] = 16] = "reconfig";
            RequestType[RequestType["rollback"] = 17] = "rollback";
            RequestType[RequestType["softwareInformation"] = 18] = "softwareInformation";
            RequestType[RequestType["systemInformation"] = 19] = "systemInformation";
            RequestType[RequestType["softwareUpdate"] = 20] = "softwareUpdate";
            RequestType[RequestType["transaction"] = 21] = "transaction";
            RequestType[RequestType["closeReader"] = 22] = "closeReader";
            RequestType[RequestType["openReader"] = 23] = "openReader";
            RequestType[RequestType["ejectCard"] = 24] = "ejectCard";
            RequestType[RequestType["openMaintenanceWindow"] = 25] = "openMaintenanceWindow";
            RequestType[RequestType["closeMaintenanceWindow"] = 26] = "closeMaintenanceWindow";
            RequestType[RequestType["activateServiceMenu"] = 27] = "activateServiceMenu";
            RequestType[RequestType["openDialogMode"] = 28] = "openDialogMode";
            RequestType[RequestType["closeDialogMode"] = 29] = "closeDialogMode";
            RequestType[RequestType["showSignatureCapture"] = 30] = "showSignatureCapture";
            RequestType[RequestType["showDialog"] = 31] = "showDialog";
            RequestType[RequestType["balanceInquiry"] = 32] = "balanceInquiry";
            RequestType[RequestType["queryLoyalty"] = 33] = "queryLoyalty";
        })(RequestType = constants.RequestType || (constants.RequestType = {}));
    })(constants = timapi.constants || (timapi.constants = {}));
})(timapi || (timapi = {}));
timapi.constants.AdminFunctions = {
    login: 0,
    logout: 1,
    reconfig: 2,
    reboot: 3,
    softwareUpdate: 4,
    activate: 5,
    deactivate: 6,
    counterRequest: 7,
    reconciliation: 8,
    balance: 9,
    openDialogMode: 10,
    closeDialogMode: 11,
    transmitLog: 12,
    startReaderCleaning: 13,
    dccRates: 14,
    changeSettings: 15,
    receiptRequest: 16,
    closeReader: 17,
    openReader: 18,
    ejectCard: 19,
    openMaintenanceWindow: 20,
    closeMaintenanceWindow: 21,
    activateServiceMenu: 22
};
timapi.constants.BrandBarBrand = {
    alipay: 0,
    amex: 1,
    bonuscard: 2,
    cash: 3,
    conforama: 4,
    coopMobile: 5,
    cup: 6,
    diners: 7,
    dinerClub: 8,
    jcb: 9,
    lebara: 10,
    lycaMobile: 11,
    maestro: 12,
    masterCard: 13,
    mbudgetMc: 14,
    mcard: 15,
    mediaMarkt: 16,
    myOne: 17,
    salt: 18,
    pharmacard: 19,
    phonecard: 20,
    postCard: 21,
    powerCard: 22,
    reka: 23,
    sunrise: 24,
    supercardPlus: 25,
    swisscom: 26,
    visa: 27,
    visaElectron: 28,
    vpay: 29,
    wirCard: 30,
    yallo: 31
};
timapi.constants.BrandMode = {
    all: 0,
    selected: 1,
    off: 2
};
timapi.constants.CardReaderStatus = {
    cardReaderClosed: 0,
    cardManuallyEntered: 1,
    cardSwiped: 2,
    cardNotRemoved: 3,
    cardPresented: 4,
    cardReaderEmpty: 5,
    cardInserted: 6,
    cardEjected: 7
};
timapi.constants.ConnectionStatus = {
    disconnected: 0,
    loggedOut: 1,
    loggedIn: 2
};
timapi.constants.CounterType = {
    shift: 0,
    balance: 1
};
timapi.constants.Currency = {
    AED: { code: "AED", name: "UAE Dirham", exponent: 2 },
    AFN: { code: "AFN", name: "Afghani", exponent: 2 },
    ALL: { code: "ALL", name: "Lek", exponent: 2 },
    AMD: { code: "AMD", name: "Armenian Dram", exponent: 2 },
    ANG: { code: "ANG", name: "Netherlands Antillean Guilder", exponent: 2 },
    AOA: { code: "AOA", name: "Kwanza", exponent: 2 },
    ARS: { code: "ARS", name: "Argentine Peso", exponent: 2 },
    AUD: { code: "AUD", name: "Australian Dollar", exponent: 2 },
    AWG: { code: "AWG", name: "Aruban Florin", exponent: 2 },
    AZN: { code: "AZN", name: "Azerbaijanian Manat", exponent: 2 },
    BAM: { code: "BAM", name: "Convertible Mark", exponent: 2 },
    BBD: { code: "BBD", name: "Barbados Dollar", exponent: 2 },
    BDT: { code: "BDT", name: "Taka", exponent: 2 },
    BGN: { code: "BGN", name: "Bulgarian Lev", exponent: 2 },
    BHD: { code: "BHD", name: "Bahraini Dinar", exponent: 3 },
    BIF: { code: "BIF", name: "Burundi Franc", exponent: 0 },
    BMD: { code: "BMD", name: "Bermudian Dollar", exponent: 2 },
    BND: { code: "BND", name: "Brunei Dollar", exponent: 2 },
    BOB: { code: "BOB", name: "Boliviano", exponent: 2 },
    BOV: { code: "BOV", name: "Mvdol", exponent: 2 },
    BRL: { code: "BRL", name: "Brazilian Real", exponent: 2 },
    BSD: { code: "BSD", name: "Bahamian Dollar", exponent: 2 },
    BTN: { code: "BTN", name: "Ngultrum", exponent: 2 },
    BWP: { code: "BWP", name: "Pula", exponent: 2 },
    BYN: { code: "BYN", name: "Belarusian Ruble", exponent: 2 },
    BYR: { code: "BYR", name: "Belarusian Ruble", exponent: 0 },
    BZD: { code: "BZD", name: "Belize Dollar", exponent: 2 },
    CAD: { code: "CAD", name: "Canadian Dollar", exponent: 2 },
    CDF: { code: "CDF", name: "Congolese Franc", exponent: 2 },
    CHE: { code: "CHE", name: "WIR Euro", exponent: 2 },
    CHF: { code: "CHF", name: "Swiss Franc", exponent: 2 },
    CHW: { code: "CHW", name: "WIR Franc", exponent: 2 },
    CLF: { code: "CLF", name: "Unidad de Fomento", exponent: 4 },
    CLP: { code: "CLP", name: "Chilean Peso", exponent: 0 },
    CNY: { code: "CNY", name: "Yuan Renminbi", exponent: 2 },
    COP: { code: "COP", name: "Colombian Peso", exponent: 2 },
    COU: { code: "COU", name: "Unidad de Valor Real", exponent: 2 },
    CRC: { code: "CRC", name: "Costa Rican Colon", exponent: 2 },
    CUC: { code: "CUC", name: "Peso Convertible", exponent: 2 },
    CUP: { code: "CUP", name: "Cuban Peso", exponent: 2 },
    CVE: { code: "CVE", name: "Cabo Verde Escudo", exponent: 2 },
    CZK: { code: "CZK", name: "Czech Koruna", exponent: 2 },
    DJF: { code: "DJF", name: "Djibouti Franc", exponent: 0 },
    DKK: { code: "DKK", name: "Danish Krone", exponent: 2 },
    DOP: { code: "DOP", name: "Dominican Peso", exponent: 2 },
    DZD: { code: "DZD", name: "Algerian Dinar", exponent: 2 },
    EGP: { code: "EGP", name: "Egyptian Pound", exponent: 2 },
    ERN: { code: "ERN", name: "Nakfa", exponent: 2 },
    ETB: { code: "ETB", name: "Ethiopian Birr", exponent: 2 },
    EUR: { code: "EUR", name: "Euro", exponent: 2 },
    FJD: { code: "FJD", name: "Fiji Dollar", exponent: 2 },
    FKP: { code: "FKP", name: "Falkland Islands Pound", exponent: 2 },
    GBP: { code: "GBP", name: "Pound Sterling", exponent: 2 },
    GEL: { code: "GEL", name: "Lari", exponent: 2 },
    GHS: { code: "GHS", name: "Ghana Cedi", exponent: 2 },
    GIP: { code: "GIP", name: "Gibraltar Pound", exponent: 2 },
    GMD: { code: "GMD", name: "Dalasi", exponent: 2 },
    GNF: { code: "GNF", name: "Guinea Franc", exponent: 0 },
    GTQ: { code: "GTQ", name: "Quetzal", exponent: 2 },
    GYD: { code: "GYD", name: "Guyana Dollar", exponent: 2 },
    HKD: { code: "HKD", name: "Hong Kong Dollar", exponent: 2 },
    HNL: { code: "HNL", name: "Lempira", exponent: 2 },
    HRK: { code: "HRK", name: "Kuna", exponent: 2 },
    HTG: { code: "HTG", name: "Gourde", exponent: 2 },
    HUF: { code: "HUF", name: "Forint", exponent: 2 },
    IDR: { code: "IDR", name: "Rupiah", exponent: 2 },
    ILS: { code: "ILS", name: "New Israeli Sheqel", exponent: 2 },
    INR: { code: "INR", name: "Indian Rupee", exponent: 2 },
    IQD: { code: "IQD", name: "Iraqi Dinar", exponent: 3 },
    IRR: { code: "IRR", name: "Iranian Rial", exponent: 2 },
    ISK: { code: "ISK", name: "Iceland Krona", exponent: 0 },
    JMD: { code: "JMD", name: "Jamaican Dollar", exponent: 2 },
    JOD: { code: "JOD", name: "Jordanian Dinar", exponent: 3 },
    JPY: { code: "JPY", name: "Yen", exponent: 0 },
    KES: { code: "KES", name: "Kenyan Shilling", exponent: 2 },
    KGS: { code: "KGS", name: "Som", exponent: 2 },
    KHR: { code: "KHR", name: "Riel", exponent: 2 },
    KMF: { code: "KMF", name: "Comoro Franc", exponent: 0 },
    KPW: { code: "KPW", name: "North Korean Won", exponent: 2 },
    KRW: { code: "KRW", name: "Won", exponent: 0 },
    KWD: { code: "KWD", name: "Kuwaiti Dinar", exponent: 3 },
    KYD: { code: "KYD", name: "Cayman Islands Dollar", exponent: 2 },
    KZT: { code: "KZT", name: "Tenge", exponent: 2 },
    LAK: { code: "LAK", name: "Kip", exponent: 2 },
    LBP: { code: "LBP", name: "Lebanese Pound", exponent: 2 },
    LKR: { code: "LKR", name: "Sri Lanka Rupee", exponent: 2 },
    LRD: { code: "LRD", name: "Liberian Dollar", exponent: 2 },
    LSL: { code: "LSL", name: "Loti", exponent: 2 },
    LYD: { code: "LYD", name: "Libyan Dinar", exponent: 3 },
    MAD: { code: "MAD", name: "Moroccan Dirham", exponent: 2 },
    MDL: { code: "MDL", name: "Moldovan Leu", exponent: 2 },
    MGA: { code: "MGA", name: "Malagasy Ariary", exponent: 2 },
    MKD: { code: "MKD", name: "Denar", exponent: 2 },
    MMK: { code: "MMK", name: "Kyat", exponent: 2 },
    MNT: { code: "MNT", name: "Tugrik", exponent: 2 },
    MOP: { code: "MOP", name: "Pataca", exponent: 2 },
    MRO: { code: "MRO", name: "Ouguiya", exponent: 2 },
    MUR: { code: "MUR", name: "Mauritius Rupee", exponent: 2 },
    MVR: { code: "MVR", name: "Rufiyaa", exponent: 2 },
    MWK: { code: "MWK", name: "Malawi Kwacha", exponent: 2 },
    MXN: { code: "MXN", name: "Mexican Peso", exponent: 2 },
    MXV: { code: "MXV", name: "Mexican Unidad de Inversion (UDI)", exponent: 2 },
    MYR: { code: "MYR", name: "Malaysian Ringgit", exponent: 2 },
    MZN: { code: "MZN", name: "Mozambique Metical", exponent: 2 },
    NAD: { code: "NAD", name: "Namibia Dollar", exponent: 2 },
    NGN: { code: "NGN", name: "Naira", exponent: 2 },
    NIO: { code: "NIO", name: "Cordoba Oro", exponent: 2 },
    NOK: { code: "NOK", name: "Norwegian Krone", exponent: 2 },
    NPR: { code: "NPR", name: "Nepalese Rupee", exponent: 2 },
    NZD: { code: "NZD", name: "New Zealand Dollar", exponent: 2 },
    OMR: { code: "OMR", name: "Rial Omani", exponent: 3 },
    PAB: { code: "PAB", name: "Balboa", exponent: 2 },
    PEN: { code: "PEN", name: "Sol", exponent: 2 },
    PGK: { code: "PGK", name: "Kina", exponent: 2 },
    PHP: { code: "PHP", name: "Philippine Peso", exponent: 2 },
    PKR: { code: "PKR", name: "Pakistan Rupee", exponent: 2 },
    PLN: { code: "PLN", name: "Zloty", exponent: 2 },
    PTS: { code: "PTS", name: "VM Loyalty", exponent: 0 },
    PYG: { code: "PYG", name: "Guarani", exponent: 0 },
    QAR: { code: "QAR", name: "Qatari Rial", exponent: 2 },
    RON: { code: "RON", name: "Romanian Leu", exponent: 2 },
    RSD: { code: "RSD", name: "Serbian Dinar", exponent: 2 },
    RUB: { code: "RUB", name: "Russian Ruble", exponent: 2 },
    RWF: { code: "RWF", name: "Rwanda Franc", exponent: 0 },
    SAR: { code: "SAR", name: "Saudi Riyal", exponent: 2 },
    SBD: { code: "SBD", name: "Solomon Islands Dollar", exponent: 2 },
    SCR: { code: "SCR", name: "Seychelles Rupee", exponent: 2 },
    SDG: { code: "SDG", name: "Sudanese Pound", exponent: 2 },
    SEK: { code: "SEK", name: "Swedish Krona", exponent: 2 },
    SGD: { code: "SGD", name: "Singapore Dollar", exponent: 2 },
    SHP: { code: "SHP", name: "Saint Helena Pound", exponent: 2 },
    SLL: { code: "SLL", name: "Leone", exponent: 2 },
    SOS: { code: "SOS", name: "Somali Shilling", exponent: 2 },
    SRD: { code: "SRD", name: "Surinam Dollar", exponent: 2 },
    SSP: { code: "SSP", name: "South Sudanese Pound", exponent: 2 },
    STD: { code: "STD", name: "Dobra", exponent: 2 },
    SVC: { code: "SVC", name: "El Salvador Colon", exponent: 2 },
    SYP: { code: "SYP", name: "Syrian Pound", exponent: 2 },
    SZL: { code: "SZL", name: "Lilangeni", exponent: 2 },
    THB: { code: "THB", name: "Baht", exponent: 2 },
    TJS: { code: "TJS", name: "Somoni", exponent: 2 },
    TMT: { code: "TMT", name: "Turkmenistan New Manat", exponent: 2 },
    TND: { code: "TND", name: "Tunisian Dinar", exponent: 3 },
    TOP: { code: "TOP", name: "Pa’anga", exponent: 2 },
    TRY: { code: "TRY", name: "Turkish Lira", exponent: 2 },
    TTD: { code: "TTD", name: "Trinidad and Tobago Dollar", exponent: 2 },
    TWD: { code: "TWD", name: "New Taiwan Dollar", exponent: 2 },
    TZS: { code: "TZS", name: "Tanzanian Shilling", exponent: 2 },
    UAH: { code: "UAH", name: "Hryvnia", exponent: 2 },
    UGX: { code: "UGX", name: "Uganda Shilling", exponent: 0 },
    USD: { code: "USD", name: "US Dollar", exponent: 2 },
    USN: { code: "USN", name: "US Dollar (Next day)", exponent: 2 },
    UYI: { code: "UYI", name: "Uruguay Peso en Unidades Indexadas (URUIURUI)", exponent: 0 },
    UYU: { code: "UYU", name: "Peso Uruguayo", exponent: 2 },
    UZS: { code: "UZS", name: "Uzbekistan Sum", exponent: 2 },
    VEF: { code: "VEF", name: "Bolívar", exponent: 2 },
    VND: { code: "VND", name: "Dong", exponent: 0 },
    VUV: { code: "VUV", name: "Vatu", exponent: 0 },
    WST: { code: "WST", name: "Tala", exponent: 2 },
    XAF: { code: "XAF", name: "CFA Franc BEAC", exponent: 0 },
    XCD: { code: "XCD", name: "East Caribbean Dollar", exponent: 2 },
    XOF: { code: "XOF", name: "CFA Franc BCEAO", exponent: 0 },
    XPF: { code: "XPF", name: "CFP Franc", exponent: 0 },
    YER: { code: "YER", name: "Yemeni Rial", exponent: 2 },
    ZAR: { code: "ZAR", name: "Rand", exponent: 2 },
    ZMW: { code: "ZMW", name: "Zambian Kwacha", exponent: 2 },
    ZWL: { code: "ZWL", name: "Zimbabwe Dollar", exponent: 2 }
};
timapi.constants.CurrencyType = {
    local: 0,
    foreign: 1,
    dcc: 2
};
timapi.constants.Cvm = {
    pin: 0,
    pinSignature: 1,
    signature: 2,
    onDevice: 3,
    noCvm: 4
};
timapi.constants.DialogFunctions = {
    showSignatureCapture: 0,
    showDialog: 1,
    sendCardCommand: 2
};
timapi.constants.EcrInfoType = {
    os: 0,
    ecrApplication: 1,
    eftApi: 2,
    eftModule: 3
};
timapi.constants.FinancialTransactions = {
    purchase: 0,
    credit: 1,
    reversal: 2,
    preAuthorization: 3,
    cashAdvance: 4,
    commit: 5,
    rollback: 6,
    giro: 7,
    combined: 8,
    authorizeCredit: 9,
    authorizeDeposit: 10,
    finalizePurchase: 11,
    proceed: 12,
    purchaseForcedAcceptance: 13,
    purchaseWithCashback: 14,
    purchasePhoneAuthorized: 15,
    loadVoucher: 16,
    collectPoints: 17,
    purchaseReservation: 18,
    purchaseReservationPhoneAuthorized: 19,
    amtAdjustment: 20,
    purchasePhoneOrdered: 21,
    purchaseMailOrdered: 22
};
timapi.constants.Guides = {
    retail: 0,
    unattended: 1,
    advancedRetail: 2,
    banking: 3,
    petrol: 4,
    dialog: 5,
    remote: 6,
    gastro: 7,
    hospitality: 8,
    valueAddedServices: 9,
    austrianUseCases: 10
};
timapi.constants.HardwareType = {
    terminal: 0,
    eftApplication: 1,
    pinPad: 2,
    contactReader: 3,
    contactlessReader: 4,
    magStripeReader: 5
};
timapi.constants.ImageFileFormat = {
    jpeg: 0,
    png: 1
};
timapi.constants.KernelType = {
    emvContact: 0,
    entryPoint: 1,
    kernel1: 2,
    kernel2: 3,
    kernel3: 4,
    kernel4: 5,
    kernel5: 6,
    kernel6: 7,
    kernel7: 8
};
timapi.constants.ManagementStatus = {
    closed: 0,
    open: 1,
    dialog: 2
};
timapi.constants.MerchantAction = {
    signature: 0,
    none: 1
};
timapi.constants.MerchantOptionType = {
    additionalMerchantData: 0,
    multiAccountIndex: 1,
    multiContractIndex: 2,
    merchantTid: 3,
    clerkIdentifier: 4,
    fuelDispenserNumber: 5,
    posdnumber: 6,
    receiptNumber: 7,
    shiftNumber: 8
};
timapi.constants.NonFinancialTransactions = {
    cancel: 0,
    balanceInquiry: 1,
    clientIdentification: 2,
    initTransaction: 3,
    holdCommit: 4,
    reservation: 5,
    adjustReservation: 6,
    cancelReservation: 7,
    loyaltyData: 8,
    startCheckout: 9,
    finishCheckout: 10,
    provideLoyaltyBasket: 11
};
timapi.constants.PaymentProtocol = {
    ep2: 0,
    ev: 1,
    valueMaster: 2,
    v3cxml: 3
};
timapi.constants.PosEntryMode = {
    unspecified: 0,
    manual: 1,
    magStripeIncomplete: 2,
    barCode: 3,
    ocr: 4,
    icc: 5,
    magStripe: 6,
    magStripeFallback: 7,
    magStripeFallbackAgain: 8,
    magStripeFallbackIccFail: 9,
    emergencyDataEntry: 10,
    ecommerce: 11,
    ctlessIcc: 12,
    ctlessMagStrige: 13
};
timapi.constants.PrintFlag = {
    suppressHeader: 0,
    suppressSignature: 1,
    suppressEcrInfo: 2,
    suppressEftInfo: 3
};
timapi.constants.PrintFormat = {
    noPrint: 0,
    normal: 1,
    onDevice: 2,
    fieldsOnly: 3
};
timapi.constants.ProcessingDisposition = {
    onEcr: 0,
    onEft: 1
};
timapi.constants.ProtocolLevel = {
    sixml2_2: 0
};
timapi.constants.ProtocolType = {
    sixml: 0
};
timapi.constants.Reason = {
    ok: 0,
    corr: 1,
    stop: 2,
    cardReader: 3,
    autoConfirm: 4,
    timeout: 5,
    codeOk: 6,
    codeNok: 7,
    pinOk: 8,
    pinNok: 9
};
timapi.constants.ReceiptItemType = {
    actId: 0,
    accPer: 1,
    acqId: 2,
    aid: 3,
    amount: 4,
    amountDcc: 5,
    amountOther: 6,
    authCode: 7,
    authReslt: 8,
    authRespC: 9,
    authRespTextC: 10,
    brandName: 11,
    currency: 12,
    currencyDcc: 13,
    dccDisclaimer: 14,
    disclaimer: 15,
    exponent: 16,
    exponentDcc: 17,
    markupDcc: 18,
    markupExponentDcc: 19,
    cardNumberPrintableMerchant: 20,
    cardNumberPrintableCardholder: 21,
    rateDcc: 22,
    rateExponentDcc: 23,
    timeStampDate: 24,
    timeStampTime: 25,
    trmId: 26,
    trxRefNum: 27,
    trxSeqCnt: 28,
    posEntryMode: 29,
    cardExpiryDate: 30,
    cardNumberEnc: 31,
    amountSaldo: 32,
    ecrSeqCounter: 33,
    panReceiptDol: 34,
    panReceiptDolIndex: 35
};
timapi.constants.ReceiptRequestType = {
    reprint: 0,
    list: 1
};
timapi.constants.ReceiptType = {
    purchase: 0,
    credit: 1,
    reversal: 2
};
timapi.constants.Recipient = {
    merchant: 0,
    cardholder: 1,
    both: 2
};
timapi.constants.ResourceId = {
    enterMileage: 0,
    enterCarNumber: 1,
    enterDriverCode: 2,
    enterFleetId: 3,
    selectPump: 4,
    selectWashingStation: 5,
    selectProgram: 6,
    selectProduct: 7,
    loadCard: 8,
    readCode: 9,
    checkCode: 10,
    enterAdditionalInformation: 11,
    enterCostCenter: 12,
    enterEmployeeNumber: 13,
    enterLicensePlate: 14,
    enterProjectNumber: 15,
    petrolPrintReceipt: 16,
    petrolRemoveCard: 17,
    petrolOutOfOrder: 18,
    petrolInvalidEntry: 19,
    petrolRefuelAtPump: 20,
    petrolSeeOtherScreen: 21,
    petrolPleaseRefuel: 22,
    noRechargeCard: 23,
    showPhoneNumberWithAmount: 24,
    enterPhoneOrPrepaidNumber: 25,
    phoneNumberTooLong: 26,
    phoneNumberTooShort: 27,
    enterPhoneNumber: 28,
    pleaseWait: 29,
    processingDeclined: 30,
    processingOk: 31,
    registerCard: 32,
    welcomeCard: 33,
    showPhoneNumber: 34,
    interAccountTransfer: 35,
    interAccountTransferConfirmation: 36,
    disbursementFromAccount: 37,
    depositOwnAccount: 38,
    emptyDialog: 39,
    packetAcknowledgement: 40,
    pinEntry: 41,
    bankingInsertCard: 42,
    bankingPinCheck: 43,
    bankingShowSaldo: 44,
    bankingConfirmAmount: 45,
    bankingRemoveCard: 46,
    bankingWelcome: 47,
    commonRegular: 48,
    commonPleaseWait: 49,
    commonDataSaved: 50,
    commonCardInitialized: 51,
    commonCardDeinitialized: 52,
    commonRemoveCard: 53
};
timapi.constants.ResultCode = {
    ok: 0,
    apiCancelEcr: 0,
    apiInvalidAnswer: 1,
    apiDisabledFeature: 2,
    apiFunctionDisallowed: 3,
    apiPersistencyProblem: 4,
    apiConnectFailServer: 0,
    apiConnectFailTerminal: 1,
    apiConnectionLostServer: 2,
    apiConnectionLostTerminal: 3,
    ethernetDisconnected: 4,
    rs232Disconnected: 5,
    apiTimeoutServer: 6,
    apiTimeoutTerminal: 7,
    serverInvalidAnswer: 0,
    serverInvalidRequest: 1,
    serverDisabledFeature: 2,
    serverPersistencyProblem: 3,
    serverConnectFailTerminal: 0,
    serverConnectionLostTerminal: 1,
    serverTimeoutTerminal: 2,
    ccrUnavailable: 0,
    mcrUnavailable: 1,
    nfcUnavailable: 2,
    displayUnavailable: 3,
    pinPadUnavailable: 4,
    rs232Unavailable: 5,
    rs232NotConfigured: 6,
    cardReaderErrorCcr: 0,
    cardReaderErrorMcr: 1,
    cardReaderErrorNfc: 2,
    cardErrorCcr: 3,
    cardErrorMcr: 4,
    cardErrorNfc: 5,
    cardReadError: 6,
    cardReadTimeout: 7,
    cardInsertionTimeout: 8,
    cardReaderKeysLost: 9,
    cardReaderSecurityError: 10,
    cardTimeout: 11,
    cardNotReadable: 12,
    cardInvalidData: 13,
    cardFunctionNotFound: 14,
    cardFunctionNotAllowed: 15,
    pinPadSecurityError: 0,
    pinPadTampered: 1,
    pinPadKeysLost: 2,
    cardholderStop: 0,
    cardholderTimeout: 1,
    cardRemoved: 2,
    timTimeoutEcr: 0,
    timConnectFailPaymentHost: 1,
    timConnectionLostPaymentHost: 2,
    timTimeoutAnswerRs232: 3,
    timCommunicationFailure: 4,
    timConfigFailure: 5,
    timInitFailure: 6,
    sixmlGeneralError: 0,
    sixmlInvalidRequest: 1,
    sixmlWrongCashier: 2,
    sixmlWrongEcrId: 3,
    sixmlUnknownReferenceNumber: 4,
    sixmlWrongState: 5,
    busyOtherController: 6,
    busyMaintenance: 7,
    requestPending: 8,
    sixmlUnsupportedRequest: 9,
    trxNoCommonApplications: 0,
    trxLimitExceeded: 1,
    trxNoCommonCvm: 2,
    declinedCvmFailed: 3,
    trxReferral: 4,
    trxInvalidAuthResponse: 5,
    declinedGeneric: 6,
    declinedSaldoTooLow: 7,
    declinedWrongPin: 8,
    declinedCardBlocked: 9,
    declinedSecurityIssue: 10,
    declinedUsageControl: 11,
    declinedDoubleTransaction: 12,
    declinedGenericFirstAc: 13,
    declinedGenericSecondAc: 14,
    trxCommitTimeout: 15,
    trxRollbackImpossible: 16,
    cashbackAmountTooLow: 17,
    cashbackAmountTooHigh: 18,
    basketDeclined: 19,
    noTrxInGroupExceeded: 20,
    unsupportedCharactersInMessage: 21,
    loyaltyCheckInPending: 22,
    declinedCardError: 23,
    declinedCardExpired: 24,
    declinedTrxInvalid: 25,
    declinedTryLater: 26,
    declinedTryAnotherInterface: 27,
    declinedInvalidMerchant: 28,
    declinedRestrictionDeclined: 29,
    declinedWrongCurrency: 30,
    declinedAutoreversalPending: 31,
    declinedWrongCardNumber: 32,
    declinedWrongCardExpiryDate: 33,
    declinedRetryTemporaryUnavailable: 34,
    declinedServiceNotAllowed: 35,
    declinedCardholderInformationIssue: 36,
    declinedReferralWrongAuthCode: 37,
    declinedReferralWrongAmount: 38,
    declinedReferralOtherReason: 39,
    declinedCaptureCardGeneric: 40,
    declinedCaptureCardInfoToClient: 41,
    declinedCaptureCardOrderToClient: 42,
    declinedCaptureCardTimeoutRemovingCard: 43,
    declinedNotSupported: 44
};
timapi.constants.SecurityStatus = {
    disabled: 0,
    active: 1,
    tampered: 2
};
timapi.constants.SettingType = {
    displayBrightness: 0,
    displayContrast: 1,
    keypadTones: 2,
    alertTones: 3,
    language: 4
};
timapi.constants.SleepModeStatus = {
    enteringSleep: 0,
    wakingUp: 1
};
timapi.constants.StatusFunctions = {
    featureRequest: 0,
    terminalStatus: 1,
    systemInformation: 2,
    applicationInformation: 3,
    hardwareInformation: 4,
    keepAlive: 5,
    licenseChanged: 6
};
timapi.constants.Theme = {
    six: 0,
    swissPost: 1
};
timapi.constants.TransactionStatus = {
    busy: 0,
    idle: 1,
    waitForCard: 2,
    readingCard: 3,
    applicationSelection: 4,
    waitForProceed: 5,
    dccSelection: 6,
    enterTip: 7,
    pinEntry: 8,
    signatureCapture: 9,
    processing: 10,
    waitForCommit: 11
};
timapi.constants.TransactionType = {
    purchase: 0,
    credit: 1,
    reversal: 2,
    preAuthorization: 3,
    finalizePurchase: 4,
    cashAdvance: 5,
    purchaseForcedAcceptance: 6,
    purchaseWithCashback: 7,
    purchasePhoneAuthorized: 8,
    purchasePhoneOrdered: 9,
    purchaseMailOrdered: 10,
    giro: 11,
    combined: 12,
    authorizeCredit: 13,
    authorizeDeposit: 14,
    reservation: 15,
    adjustReservation: 16,
    cancelReservation: 17,
    purchaseReservation: 18,
    purchaseReservationPhoneAuthorized: 19
};
timapi.constants.UpdateStatus = {
    upToDate: 0,
    runningNoReboot: 1,
    runningReboot: 2
};
timapi.protocol.constants.AdminFunctions = {};
timapi.protocol.constants.AdminFunctions.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (AdminFunctions)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.AdminFunctions.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.AdminFunctions._timApi2Protocol =
    new Map([[timapi.constants.AdminFunctions.login, 0x1],
        [timapi.constants.AdminFunctions.logout, 0x2],
        [timapi.constants.AdminFunctions.reconfig, 0x4],
        [timapi.constants.AdminFunctions.reboot, 0x8],
        [timapi.constants.AdminFunctions.softwareUpdate, 0x10],
        [timapi.constants.AdminFunctions.activate, 0x20],
        [timapi.constants.AdminFunctions.deactivate, 0x40],
        [timapi.constants.AdminFunctions.counterRequest, 0x80],
        [timapi.constants.AdminFunctions.reconciliation, 0x100],
        [timapi.constants.AdminFunctions.balance, 0x200],
        [timapi.constants.AdminFunctions.openDialogMode, 0x400],
        [timapi.constants.AdminFunctions.closeDialogMode, 0x800],
        [timapi.constants.AdminFunctions.transmitLog, 0x1000],
        [timapi.constants.AdminFunctions.startReaderCleaning, 0x2000],
        [timapi.constants.AdminFunctions.dccRates, 0x4000],
        [timapi.constants.AdminFunctions.changeSettings, 0x8000],
        [timapi.constants.AdminFunctions.receiptRequest, 0x10000],
        [timapi.constants.AdminFunctions.closeReader, 0x20000],
        [timapi.constants.AdminFunctions.openReader, 0x40000],
        [timapi.constants.AdminFunctions.ejectCard, 0x80000],
        [timapi.constants.AdminFunctions.openMaintenanceWindow, 0x100000],
        [timapi.constants.AdminFunctions.closeMaintenanceWindow, 0x200000],
        [timapi.constants.AdminFunctions.activateServiceMenu, 0x400000]]);
timapi.protocol.constants.AdminFunctions._protocol2TimApi =
    new Map([[0x1, timapi.constants.AdminFunctions.login],
        [0x2, timapi.constants.AdminFunctions.logout],
        [0x4, timapi.constants.AdminFunctions.reconfig],
        [0x8, timapi.constants.AdminFunctions.reboot],
        [0x10, timapi.constants.AdminFunctions.softwareUpdate],
        [0x20, timapi.constants.AdminFunctions.activate],
        [0x40, timapi.constants.AdminFunctions.deactivate],
        [0x80, timapi.constants.AdminFunctions.counterRequest],
        [0x100, timapi.constants.AdminFunctions.reconciliation],
        [0x200, timapi.constants.AdminFunctions.balance],
        [0x400, timapi.constants.AdminFunctions.openDialogMode],
        [0x800, timapi.constants.AdminFunctions.closeDialogMode],
        [0x1000, timapi.constants.AdminFunctions.transmitLog],
        [0x2000, timapi.constants.AdminFunctions.startReaderCleaning],
        [0x4000, timapi.constants.AdminFunctions.dccRates],
        [0x8000, timapi.constants.AdminFunctions.changeSettings],
        [0x10000, timapi.constants.AdminFunctions.receiptRequest],
        [0x20000, timapi.constants.AdminFunctions.closeReader],
        [0x40000, timapi.constants.AdminFunctions.openReader],
        [0x80000, timapi.constants.AdminFunctions.ejectCard],
        [0x100000, timapi.constants.AdminFunctions.openMaintenanceWindow],
        [0x200000, timapi.constants.AdminFunctions.closeMaintenanceWindow],
        [0x400000, timapi.constants.AdminFunctions.activateServiceMenu]]);
timapi.protocol.constants.BrandBarBrand = {};
timapi.protocol.constants.BrandBarBrand.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (BrandBarBrand)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.BrandBarBrand.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (BrandBarBrand)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.BrandBarBrand.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.BrandBarBrand._timApi2Protocol =
    new Map([[timapi.constants.BrandBarBrand.alipay, "Alipay"],
        [timapi.constants.BrandBarBrand.amex, "Amex"],
        [timapi.constants.BrandBarBrand.bonuscard, "Bonuscard"],
        [timapi.constants.BrandBarBrand.cash, "Cash"],
        [timapi.constants.BrandBarBrand.conforama, "Conforama"],
        [timapi.constants.BrandBarBrand.coopMobile, "CoopMobile"],
        [timapi.constants.BrandBarBrand.cup, "CUP"],
        [timapi.constants.BrandBarBrand.diners, "Diners"],
        [timapi.constants.BrandBarBrand.dinerClub, "DinerClub"],
        [timapi.constants.BrandBarBrand.jcb, "Jcb"],
        [timapi.constants.BrandBarBrand.lebara, "Lebara"],
        [timapi.constants.BrandBarBrand.lycaMobile, "LycaMobile"],
        [timapi.constants.BrandBarBrand.maestro, "Maestro"],
        [timapi.constants.BrandBarBrand.masterCard, "MasterCard"],
        [timapi.constants.BrandBarBrand.mbudgetMc, "MBudgetMc"],
        [timapi.constants.BrandBarBrand.mcard, "MCard"],
        [timapi.constants.BrandBarBrand.mediaMarkt, "MediaMarkt"],
        [timapi.constants.BrandBarBrand.myOne, "MyOne"],
        [timapi.constants.BrandBarBrand.salt, "Salt."],
        [timapi.constants.BrandBarBrand.pharmacard, "Pharmacard"],
        [timapi.constants.BrandBarBrand.phonecard, "Phonecard"],
        [timapi.constants.BrandBarBrand.postCard, "PostCard"],
        [timapi.constants.BrandBarBrand.powerCard, "PowerCard"],
        [timapi.constants.BrandBarBrand.reka, "Reka"],
        [timapi.constants.BrandBarBrand.sunrise, "Sunrise"],
        [timapi.constants.BrandBarBrand.supercardPlus, "SupercardPlus"],
        [timapi.constants.BrandBarBrand.swisscom, "Swisscom"],
        [timapi.constants.BrandBarBrand.visa, "Visa"],
        [timapi.constants.BrandBarBrand.visaElectron, "VisaElectron"],
        [timapi.constants.BrandBarBrand.vpay, "VPay"],
        [timapi.constants.BrandBarBrand.wirCard, "WirCard"],
        [timapi.constants.BrandBarBrand.yallo, "Yallo"]]);
timapi.protocol.constants.BrandBarBrand._protocol2TimApi =
    new Map([["Alipay", timapi.constants.BrandBarBrand.alipay],
        ["Amex", timapi.constants.BrandBarBrand.amex],
        ["Bonuscard", timapi.constants.BrandBarBrand.bonuscard],
        ["Cash", timapi.constants.BrandBarBrand.cash],
        ["Conforama", timapi.constants.BrandBarBrand.conforama],
        ["CoopMobile", timapi.constants.BrandBarBrand.coopMobile],
        ["CUP", timapi.constants.BrandBarBrand.cup],
        ["Diners", timapi.constants.BrandBarBrand.diners],
        ["DinerClub", timapi.constants.BrandBarBrand.dinerClub],
        ["Jcb", timapi.constants.BrandBarBrand.jcb],
        ["Lebara", timapi.constants.BrandBarBrand.lebara],
        ["LycaMobile", timapi.constants.BrandBarBrand.lycaMobile],
        ["Maestro", timapi.constants.BrandBarBrand.maestro],
        ["MasterCard", timapi.constants.BrandBarBrand.masterCard],
        ["MBudgetMc", timapi.constants.BrandBarBrand.mbudgetMc],
        ["MCard", timapi.constants.BrandBarBrand.mcard],
        ["MediaMarkt", timapi.constants.BrandBarBrand.mediaMarkt],
        ["MyOne", timapi.constants.BrandBarBrand.myOne],
        ["Salt.", timapi.constants.BrandBarBrand.salt],
        ["Pharmacard", timapi.constants.BrandBarBrand.pharmacard],
        ["Phonecard", timapi.constants.BrandBarBrand.phonecard],
        ["PostCard", timapi.constants.BrandBarBrand.postCard],
        ["PowerCard", timapi.constants.BrandBarBrand.powerCard],
        ["Reka", timapi.constants.BrandBarBrand.reka],
        ["Sunrise", timapi.constants.BrandBarBrand.sunrise],
        ["SupercardPlus", timapi.constants.BrandBarBrand.supercardPlus],
        ["Swisscom", timapi.constants.BrandBarBrand.swisscom],
        ["Visa", timapi.constants.BrandBarBrand.visa],
        ["VisaElectron", timapi.constants.BrandBarBrand.visaElectron],
        ["VPay", timapi.constants.BrandBarBrand.vpay],
        ["WirCard", timapi.constants.BrandBarBrand.wirCard],
        ["Yallo", timapi.constants.BrandBarBrand.yallo]]);
timapi.protocol.constants.BrandMode = {};
timapi.protocol.constants.BrandMode.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (BrandMode)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.BrandMode.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (BrandMode)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.BrandMode.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.BrandMode._timApi2Protocol =
    new Map([[timapi.constants.BrandMode.all, "All"],
        [timapi.constants.BrandMode.selected, "Selected"],
        [timapi.constants.BrandMode.off, "Off"]]);
timapi.protocol.constants.BrandMode._protocol2TimApi =
    new Map([["All", timapi.constants.BrandMode.all],
        ["Selected", timapi.constants.BrandMode.selected],
        ["Off", timapi.constants.BrandMode.off]]);
timapi.protocol.constants.CardReaderStatus = {};
timapi.protocol.constants.CardReaderStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (CardReaderStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.CardReaderStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (CardReaderStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.CardReaderStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.CardReaderStatus._timApi2Protocol =
    new Map([[timapi.constants.CardReaderStatus.cardReaderClosed, "CardReaderClosed"],
        [timapi.constants.CardReaderStatus.cardManuallyEntered, "CardManuallyEntered"],
        [timapi.constants.CardReaderStatus.cardSwiped, "CardSwiped"],
        [timapi.constants.CardReaderStatus.cardNotRemoved, "CardNotRemoved"],
        [timapi.constants.CardReaderStatus.cardPresented, "CardPresented"],
        [timapi.constants.CardReaderStatus.cardReaderEmpty, "CardReaderEmpty"],
        [timapi.constants.CardReaderStatus.cardInserted, "CardInserted"],
        [timapi.constants.CardReaderStatus.cardEjected, "CardEjected"]]);
timapi.protocol.constants.CardReaderStatus._protocol2TimApi =
    new Map([["CardReaderClosed", timapi.constants.CardReaderStatus.cardReaderClosed],
        ["CardManuallyEntered", timapi.constants.CardReaderStatus.cardManuallyEntered],
        ["CardSwiped", timapi.constants.CardReaderStatus.cardSwiped],
        ["CardNotRemoved", timapi.constants.CardReaderStatus.cardNotRemoved],
        ["CardPresented", timapi.constants.CardReaderStatus.cardPresented],
        ["CardReaderEmpty", timapi.constants.CardReaderStatus.cardReaderEmpty],
        ["CardInserted", timapi.constants.CardReaderStatus.cardInserted],
        ["CardEjected", timapi.constants.CardReaderStatus.cardEjected]]);
timapi.protocol.constants.ConnectionStatus = {};
timapi.protocol.constants.ConnectionStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ConnectionStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ConnectionStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ConnectionStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ConnectionStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ConnectionStatus._timApi2Protocol =
    new Map([[timapi.constants.ConnectionStatus.disconnected, "Disconnected"],
        [timapi.constants.ConnectionStatus.loggedOut, "LoggedOut"],
        [timapi.constants.ConnectionStatus.loggedIn, "LoggedIn"]]);
timapi.protocol.constants.ConnectionStatus._protocol2TimApi =
    new Map([["Disconnected", timapi.constants.ConnectionStatus.disconnected],
        ["LoggedOut", timapi.constants.ConnectionStatus.loggedOut],
        ["LoggedIn", timapi.constants.ConnectionStatus.loggedIn]]);
timapi.protocol.constants.CounterType = {};
timapi.protocol.constants.CounterType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (CounterType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.CounterType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (CounterType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.CounterType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.CounterType._timApi2Protocol =
    new Map([[timapi.constants.CounterType.shift, "Shift"],
        [timapi.constants.CounterType.balance, "Balance"]]);
timapi.protocol.constants.CounterType._protocol2TimApi =
    new Map([["Shift", timapi.constants.CounterType.shift],
        ["Balance", timapi.constants.CounterType.balance]]);
timapi.protocol.constants.CurrencyType = {};
timapi.protocol.constants.CurrencyType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (CurrencyType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.CurrencyType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (CurrencyType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.CurrencyType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.CurrencyType._timApi2Protocol =
    new Map([[timapi.constants.CurrencyType.local, "Local"],
        [timapi.constants.CurrencyType.foreign, "Foreign"],
        [timapi.constants.CurrencyType.dcc, "Dcc"]]);
timapi.protocol.constants.CurrencyType._protocol2TimApi =
    new Map([["Local", timapi.constants.CurrencyType.local],
        ["Foreign", timapi.constants.CurrencyType.foreign],
        ["Dcc", timapi.constants.CurrencyType.dcc]]);
timapi.protocol.constants.Cvm = {};
timapi.protocol.constants.Cvm.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Cvm)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.Cvm.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Cvm)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Cvm.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Cvm._timApi2Protocol =
    new Map([[timapi.constants.Cvm.pin, "Pin"],
        [timapi.constants.Cvm.pinSignature, "PinSignature"],
        [timapi.constants.Cvm.signature, "Signature"],
        [timapi.constants.Cvm.onDevice, "OnDevice"],
        [timapi.constants.Cvm.noCvm, "NoCvm"]]);
timapi.protocol.constants.Cvm._protocol2TimApi =
    new Map([["Pin", timapi.constants.Cvm.pin],
        ["PinSignature", timapi.constants.Cvm.pinSignature],
        ["Signature", timapi.constants.Cvm.signature],
        ["OnDevice", timapi.constants.Cvm.onDevice],
        ["NoCvm", timapi.constants.Cvm.noCvm]]);
timapi.protocol.constants.DialogFunctions = {};
timapi.protocol.constants.DialogFunctions.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (DialogFunctions)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.DialogFunctions.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.DialogFunctions._timApi2Protocol =
    new Map([[timapi.constants.DialogFunctions.showSignatureCapture, 0x1],
        [timapi.constants.DialogFunctions.showDialog, 0x2],
        [timapi.constants.DialogFunctions.sendCardCommand, 0x4]]);
timapi.protocol.constants.DialogFunctions._protocol2TimApi =
    new Map([[0x1, timapi.constants.DialogFunctions.showSignatureCapture],
        [0x2, timapi.constants.DialogFunctions.showDialog],
        [0x4, timapi.constants.DialogFunctions.sendCardCommand]]);
timapi.protocol.constants.EcrInfoType = {};
timapi.protocol.constants.EcrInfoType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (EcrInfoType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.EcrInfoType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (EcrInfoType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.EcrInfoType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.EcrInfoType._timApi2Protocol =
    new Map([[timapi.constants.EcrInfoType.os, "Os"],
        [timapi.constants.EcrInfoType.ecrApplication, "EcrApplication"],
        [timapi.constants.EcrInfoType.eftApi, "EftAPI"],
        [timapi.constants.EcrInfoType.eftModule, "EftModule"]]);
timapi.protocol.constants.EcrInfoType._protocol2TimApi =
    new Map([["Os", timapi.constants.EcrInfoType.os],
        ["EcrApplication", timapi.constants.EcrInfoType.ecrApplication],
        ["EftAPI", timapi.constants.EcrInfoType.eftApi],
        ["EftModule", timapi.constants.EcrInfoType.eftModule]]);
timapi.protocol.constants.FeatureType = {
    sixmlGuides: "sixml:Guides",
    sixmlProtocolLevel: "sixml:ProtocolLevel",
    sixmlStatusFunctions: "sixml:StatusFunctions",
    sixmlAdminFunctions: "sixml:AdminFunctions",
    sixmlFinancialTransactions: "sixml:FinancialTransactions",
    sixmlNonFinancialTransactions: "sixml:NonFinancialTransactions",
    sixmlRemoteFunctions: "sixml:RemoteFunctions",
    sixmlDialogFunctions: "sixml:DialogFunctions",
    sixmlAutoCommit: "sixml:AutoCommit",
    sixmlAutoShiftManagement: "sixml:AutoShiftManagement",
    sixmlAutoShutterManagement: "sixml:AutoShutterManagement",
    sixmlSleepTimer: "sixml:SleepTimer",
    sixmlSwUpdateInformation: "sixml:SwUpdateInformation",
    sixmlRequestRepetition: "sixml:RequestRepetition",
    sixmlAllowClosedCardInsertion: "sixml:AllowClosedCardInsert",
    paymentDcc: "pay:Dcc",
    paymentDeclinedReceipts: "pay:DeclinedReceipts",
    paymentPartialApproval: "pay:PartialApproval",
    paymentPartialCommit: "pay:PartialCommit",
    ep2Available: "pp:ep2:Available",
    ep2Dcc: "pp:ep2:Dcc",
    ep2DeclinedReceipts: "pp:ep2:DeclinedReceipts",
    ep2MultiAccountSelection: "pp:ep2:MultiAccountSelection",
    ep2MultiContractSelection: "pp:ep2:MultiContractSelection",
    hardwarePrinterInstalled: "hw:Printer:Installed",
    hardwareDisplayCardholderInstalled: "hw:Display:Cardholder:Installed",
    hardwareDisplayMerchantInstalled: "hw:Display:Merchant:Installed",
    hardwareSettingDisplayBrightness: "hw:Setting:Display:Brightness",
    hardwareSettingDisplayContrast: "hw:Setting:Display:Contrast",
    hardwareSettingTonesAlert: "hw:Setting:Tones:Alert",
    hardwareSettingTonesKeypad: "hw:Setting:Tones:Keypad"
};
timapi.protocol.constants.FinancialTransactions = {};
timapi.protocol.constants.FinancialTransactions.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (FinancialTransactions)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.FinancialTransactions.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.FinancialTransactions._timApi2Protocol =
    new Map([[timapi.constants.FinancialTransactions.purchase, 0x1],
        [timapi.constants.FinancialTransactions.credit, 0x2],
        [timapi.constants.FinancialTransactions.reversal, 0x4],
        [timapi.constants.FinancialTransactions.preAuthorization, 0x8],
        [timapi.constants.FinancialTransactions.cashAdvance, 0x10],
        [timapi.constants.FinancialTransactions.commit, 0x20],
        [timapi.constants.FinancialTransactions.rollback, 0x40],
        [timapi.constants.FinancialTransactions.giro, 0x80],
        [timapi.constants.FinancialTransactions.combined, 0x100],
        [timapi.constants.FinancialTransactions.authorizeCredit, 0x200],
        [timapi.constants.FinancialTransactions.authorizeDeposit, 0x400],
        [timapi.constants.FinancialTransactions.finalizePurchase, 0x800],
        [timapi.constants.FinancialTransactions.proceed, 0x1000],
        [timapi.constants.FinancialTransactions.purchaseForcedAcceptance, 0x2000],
        [timapi.constants.FinancialTransactions.purchaseWithCashback, 0x4000],
        [timapi.constants.FinancialTransactions.purchasePhoneAuthorized, 0x8000],
        [timapi.constants.FinancialTransactions.loadVoucher, 0x10000],
        [timapi.constants.FinancialTransactions.collectPoints, 0x20000],
        [timapi.constants.FinancialTransactions.purchaseReservation, 0x40000],
        [timapi.constants.FinancialTransactions.purchaseReservationPhoneAuthorized, 0x80000],
        [timapi.constants.FinancialTransactions.amtAdjustment, 0x100000],
        [timapi.constants.FinancialTransactions.purchasePhoneOrdered, 0x200000],
        [timapi.constants.FinancialTransactions.purchaseMailOrdered, 0x400000]]);
timapi.protocol.constants.FinancialTransactions._protocol2TimApi =
    new Map([[0x1, timapi.constants.FinancialTransactions.purchase],
        [0x2, timapi.constants.FinancialTransactions.credit],
        [0x4, timapi.constants.FinancialTransactions.reversal],
        [0x8, timapi.constants.FinancialTransactions.preAuthorization],
        [0x10, timapi.constants.FinancialTransactions.cashAdvance],
        [0x20, timapi.constants.FinancialTransactions.commit],
        [0x40, timapi.constants.FinancialTransactions.rollback],
        [0x80, timapi.constants.FinancialTransactions.giro],
        [0x100, timapi.constants.FinancialTransactions.combined],
        [0x200, timapi.constants.FinancialTransactions.authorizeCredit],
        [0x400, timapi.constants.FinancialTransactions.authorizeDeposit],
        [0x800, timapi.constants.FinancialTransactions.finalizePurchase],
        [0x1000, timapi.constants.FinancialTransactions.proceed],
        [0x2000, timapi.constants.FinancialTransactions.purchaseForcedAcceptance],
        [0x4000, timapi.constants.FinancialTransactions.purchaseWithCashback],
        [0x8000, timapi.constants.FinancialTransactions.purchasePhoneAuthorized],
        [0x10000, timapi.constants.FinancialTransactions.loadVoucher],
        [0x20000, timapi.constants.FinancialTransactions.collectPoints],
        [0x40000, timapi.constants.FinancialTransactions.purchaseReservation],
        [0x80000, timapi.constants.FinancialTransactions.purchaseReservationPhoneAuthorized],
        [0x100000, timapi.constants.FinancialTransactions.amtAdjustment],
        [0x200000, timapi.constants.FinancialTransactions.purchasePhoneOrdered],
        [0x400000, timapi.constants.FinancialTransactions.purchaseMailOrdered]]);
timapi.protocol.constants.Function = {
    terminalStatus: "TerminalStatus",
    featureRequest: "FeatureRequest",
    systemInformation: "SystemInformation",
    applicationInformation: "ApplicationInformation",
    hardwareInformation: "HardwareInformation",
    keepAlive: "KeepAlive",
    licenseChanged: "LicenseChanged",
    login: "Login",
    logout: "Logout",
    reconfig: "Reconfig",
    reboot: "Reboot",
    softwareUpdate: "SoftwareUpdate",
    changeSettings: "ChangeSettings",
    activate: "Activate",
    deactivate: "Deactivate",
    counterRequest: "CounterRequest",
    reconciliation: "Reconciliation",
    balance: "Balance",
    dccRates: "DccRates",
    cancel: "Cancel",
    purchase: "Purchase",
    credit: "Credit",
    reversal: "Reversal",
    commit: "Commit",
    rollback: "Rollback",
    receiptRequest: "ReceiptRequest",
    preAuthorization: "PreAuthorization",
    finalizePurchase: "FinalizePurchase",
    initTransaction: "InitTransaction",
    closeReader: "CloseReader",
    openReader: "OpenReader",
    ejectCard: "EjectCard",
    openMaintenanceWindow: "OpenMaintenanceWindow",
    holdCommit: "HoldCommit",
    closeMaintenanceWindow: "CloseMaintenanceWindow",
    activateServiceMenu: "ActivateServiceMenu",
    amtAdjustment: "AmtAdjustment",
    balanceInquiry: "BalanceInquiry",
    cashAdvance: "CashAdvance",
    purchaseForcedAcceptance: "PurchaseForcedAcceptance",
    purchaseWithCashback: "PurchaseWithCashback",
    purchasePhoneAuthorized: "PurchasePhoneAuthorized",
    purchasePhoneOrdered: "PurchasePhoneOrdered",
    purchaseMailOrdered: "PurchaseMailOrdered",
    giro: "Giro",
    combined: "Combined",
    authorizeCredit: "AuthorizeCredit",
    authorizeDeposit: "AuthorizeDeposit",
    openDialogMode: "OpenDialogMode",
    closeDialogMode: "CloseDialogMode",
    showSignatureCapture: "ShowSignatureCapture",
    showDialog: "ShowDialog",
    sendCardCommand: "SendCardCommand",
    transmitLog: "TransmitLog",
    screenshot: "Screenshot",
    reservation: "Reservation",
    adjustReservation: "AdjustReservation",
    cancelReservation: "CancelReservation",
    purchaseReservation: "PurchaseReservation",
    purchaseReservationPhoneAuthorized: "PurchaseReservationPhoneAuthorized",
    loadVoucher: "LoadVoucher",
    collectPoints: "CollectPoints",
    loyaltyData: "LoyaltyData",
    startCheckout: "StartCheckout",
    finishCheckout: "FinishCheckout",
    provideLoyaltyBasket: "ProvideLoyaltyBasket",
    loyaltyInfo: "LoyaltyInfo"
};
timapi.protocol.constants.FunctionGroup = {
    status: "Status",
    admin: "Admin",
    finTransaction: "FinTransaction",
    nonFinTransaction: "NonFinTransaction",
    dialog: "Dialog",
    remote: "Remote"
};
timapi.protocol.constants.Guides = {};
timapi.protocol.constants.Guides.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (Guides)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.Guides.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.Guides._timApi2Protocol =
    new Map([[timapi.constants.Guides.retail, 0x1],
        [timapi.constants.Guides.unattended, 0x2],
        [timapi.constants.Guides.advancedRetail, 0x4],
        [timapi.constants.Guides.banking, 0x8],
        [timapi.constants.Guides.petrol, 0x10],
        [timapi.constants.Guides.dialog, 0x20],
        [timapi.constants.Guides.remote, 0x40],
        [timapi.constants.Guides.gastro, 0x80],
        [timapi.constants.Guides.hospitality, 0x100],
        [timapi.constants.Guides.valueAddedServices, 0x200],
        [timapi.constants.Guides.austrianUseCases, 0x400]]);
timapi.protocol.constants.Guides._protocol2TimApi =
    new Map([[0x1, timapi.constants.Guides.retail],
        [0x2, timapi.constants.Guides.unattended],
        [0x4, timapi.constants.Guides.advancedRetail],
        [0x8, timapi.constants.Guides.banking],
        [0x10, timapi.constants.Guides.petrol],
        [0x20, timapi.constants.Guides.dialog],
        [0x40, timapi.constants.Guides.remote],
        [0x80, timapi.constants.Guides.gastro],
        [0x100, timapi.constants.Guides.hospitality],
        [0x200, timapi.constants.Guides.valueAddedServices],
        [0x400, timapi.constants.Guides.austrianUseCases]]);
timapi.protocol.constants.HardwareType = {};
timapi.protocol.constants.HardwareType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (HardwareType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.HardwareType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (HardwareType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.HardwareType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.HardwareType._timApi2Protocol =
    new Map([[timapi.constants.HardwareType.terminal, "Terminal"],
        [timapi.constants.HardwareType.eftApplication, "EftApplication"],
        [timapi.constants.HardwareType.pinPad, "PinPad"],
        [timapi.constants.HardwareType.contactReader, "ContactReader"],
        [timapi.constants.HardwareType.contactlessReader, "ContactlessReader"],
        [timapi.constants.HardwareType.magStripeReader, "MagStripeReader"]]);
timapi.protocol.constants.HardwareType._protocol2TimApi =
    new Map([["Terminal", timapi.constants.HardwareType.terminal],
        ["EftApplication", timapi.constants.HardwareType.eftApplication],
        ["PinPad", timapi.constants.HardwareType.pinPad],
        ["ContactReader", timapi.constants.HardwareType.contactReader],
        ["ContactlessReader", timapi.constants.HardwareType.contactlessReader],
        ["MagStripeReader", timapi.constants.HardwareType.magStripeReader]]);
timapi.protocol.constants.ImageFileFormat = {};
timapi.protocol.constants.ImageFileFormat.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ImageFileFormat)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ImageFileFormat.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ImageFileFormat)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ImageFileFormat.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ImageFileFormat._timApi2Protocol =
    new Map([[timapi.constants.ImageFileFormat.jpeg, "Jpeg"],
        [timapi.constants.ImageFileFormat.png, "Png"]]);
timapi.protocol.constants.ImageFileFormat._protocol2TimApi =
    new Map([["Jpeg", timapi.constants.ImageFileFormat.jpeg],
        ["Png", timapi.constants.ImageFileFormat.png]]);
timapi.protocol.constants.KernelType = {};
timapi.protocol.constants.KernelType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (KernelType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.KernelType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (KernelType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.KernelType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.KernelType._timApi2Protocol =
    new Map([[timapi.constants.KernelType.emvContact, -1],
        [timapi.constants.KernelType.entryPoint, 0],
        [timapi.constants.KernelType.kernel1, 1],
        [timapi.constants.KernelType.kernel2, 2],
        [timapi.constants.KernelType.kernel3, 3],
        [timapi.constants.KernelType.kernel4, 4],
        [timapi.constants.KernelType.kernel5, 5],
        [timapi.constants.KernelType.kernel6, 6],
        [timapi.constants.KernelType.kernel7, 7]]);
timapi.protocol.constants.KernelType._protocol2TimApi =
    new Map([[-1, timapi.constants.KernelType.emvContact],
        [0, timapi.constants.KernelType.entryPoint],
        [1, timapi.constants.KernelType.kernel1],
        [2, timapi.constants.KernelType.kernel2],
        [3, timapi.constants.KernelType.kernel3],
        [4, timapi.constants.KernelType.kernel4],
        [5, timapi.constants.KernelType.kernel5],
        [6, timapi.constants.KernelType.kernel6],
        [7, timapi.constants.KernelType.kernel7]]);
timapi.protocol.constants.ManagementStatus = {};
timapi.protocol.constants.ManagementStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ManagementStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ManagementStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ManagementStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ManagementStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ManagementStatus._timApi2Protocol =
    new Map([[timapi.constants.ManagementStatus.closed, "Closed"],
        [timapi.constants.ManagementStatus.open, "Open"],
        [timapi.constants.ManagementStatus.dialog, "Dialog"]]);
timapi.protocol.constants.ManagementStatus._protocol2TimApi =
    new Map([["Closed", timapi.constants.ManagementStatus.closed],
        ["Open", timapi.constants.ManagementStatus.open],
        ["Dialog", timapi.constants.ManagementStatus.dialog]]);
timapi.protocol.constants.MerchantAction = {};
timapi.protocol.constants.MerchantAction.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (MerchantAction)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.MerchantAction.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (MerchantAction)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.MerchantAction.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.MerchantAction._timApi2Protocol =
    new Map([[timapi.constants.MerchantAction.signature, "Signature"],
        [timapi.constants.MerchantAction.none, "None"]]);
timapi.protocol.constants.MerchantAction._protocol2TimApi =
    new Map([["Signature", timapi.constants.MerchantAction.signature],
        ["None", timapi.constants.MerchantAction.none]]);
timapi.protocol.constants.MerchantOptionType = {};
timapi.protocol.constants.MerchantOptionType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (MerchantOptionType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.MerchantOptionType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (MerchantOptionType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.MerchantOptionType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.MerchantOptionType._timApi2Protocol =
    new Map([[timapi.constants.MerchantOptionType.additionalMerchantData, "AdditionalMerchantData"],
        [timapi.constants.MerchantOptionType.multiAccountIndex, "MultiAccountIndex"],
        [timapi.constants.MerchantOptionType.multiContractIndex, "MultiContractIndex"],
        [timapi.constants.MerchantOptionType.merchantTid, "MerchantTid"],
        [timapi.constants.MerchantOptionType.clerkIdentifier, "ClerkIdentifier"],
        [timapi.constants.MerchantOptionType.fuelDispenserNumber, "FuelDispenserNumber"],
        [timapi.constants.MerchantOptionType.posdnumber, "POSDNumber"],
        [timapi.constants.MerchantOptionType.receiptNumber, "ReceiptNumber"],
        [timapi.constants.MerchantOptionType.shiftNumber, "ShiftNumber"]]);
timapi.protocol.constants.MerchantOptionType._protocol2TimApi =
    new Map([["AdditionalMerchantData", timapi.constants.MerchantOptionType.additionalMerchantData],
        ["MultiAccountIndex", timapi.constants.MerchantOptionType.multiAccountIndex],
        ["MultiContractIndex", timapi.constants.MerchantOptionType.multiContractIndex],
        ["MerchantTid", timapi.constants.MerchantOptionType.merchantTid],
        ["ClerkIdentifier", timapi.constants.MerchantOptionType.clerkIdentifier],
        ["FuelDispenserNumber", timapi.constants.MerchantOptionType.fuelDispenserNumber],
        ["POSDNumber", timapi.constants.MerchantOptionType.posdnumber],
        ["ReceiptNumber", timapi.constants.MerchantOptionType.receiptNumber],
        ["ShiftNumber", timapi.constants.MerchantOptionType.shiftNumber]]);
timapi.protocol.constants.NonFinancialTransactions = {};
timapi.protocol.constants.NonFinancialTransactions.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (NonFinancialTransactions)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.NonFinancialTransactions.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.NonFinancialTransactions._timApi2Protocol =
    new Map([[timapi.constants.NonFinancialTransactions.cancel, 0x1],
        [timapi.constants.NonFinancialTransactions.balanceInquiry, 0x2],
        [timapi.constants.NonFinancialTransactions.clientIdentification, 0x4],
        [timapi.constants.NonFinancialTransactions.initTransaction, 0x8],
        [timapi.constants.NonFinancialTransactions.holdCommit, 0x10],
        [timapi.constants.NonFinancialTransactions.reservation, 0x20],
        [timapi.constants.NonFinancialTransactions.adjustReservation, 0x40],
        [timapi.constants.NonFinancialTransactions.cancelReservation, 0x80],
        [timapi.constants.NonFinancialTransactions.loyaltyData, 0x200],
        [timapi.constants.NonFinancialTransactions.startCheckout, 0x400],
        [timapi.constants.NonFinancialTransactions.finishCheckout, 0x800],
        [timapi.constants.NonFinancialTransactions.provideLoyaltyBasket, 0x1000]]);
timapi.protocol.constants.NonFinancialTransactions._protocol2TimApi =
    new Map([[0x1, timapi.constants.NonFinancialTransactions.cancel],
        [0x2, timapi.constants.NonFinancialTransactions.balanceInquiry],
        [0x4, timapi.constants.NonFinancialTransactions.clientIdentification],
        [0x8, timapi.constants.NonFinancialTransactions.initTransaction],
        [0x10, timapi.constants.NonFinancialTransactions.holdCommit],
        [0x20, timapi.constants.NonFinancialTransactions.reservation],
        [0x40, timapi.constants.NonFinancialTransactions.adjustReservation],
        [0x80, timapi.constants.NonFinancialTransactions.cancelReservation],
        [0x200, timapi.constants.NonFinancialTransactions.loyaltyData],
        [0x400, timapi.constants.NonFinancialTransactions.startCheckout],
        [0x800, timapi.constants.NonFinancialTransactions.finishCheckout],
        [0x1000, timapi.constants.NonFinancialTransactions.provideLoyaltyBasket]]);
timapi.protocol.constants.OptionType = {
    sixmlAutoCommit: "sixml:AutoCommit",
    sixmlProtocolLevel: "sixml:ProtocolLevel",
    sixmlCommitTimeout: "sixml:CommitTimeout",
    sixmlProceedTimeout: "sixml:ProceedTimeout",
    sixmlGuides: "sixml:Guides",
    sixmlCardInsertionTimeout: "sixml:CardInsertionTimeout",
    sixmlCardRemovalTimeout: "sixml:CardRemovalTimeout",
    sixmlAutoShiftManagement: "sixml:AutoShiftManagement",
    sixmlAutoShutterManagement: "sixml:AutoShutterManagement",
    sixmlPartialApproval: "sixml:PartialApproval",
    sixmlDcc: "sixml:Dcc",
    sixmlTip: "sixml:Tip",
    sixmlPartialCommit: "sixml:PartialCommit",
    sixmlProceedRequired: "sixml:ProceedRequired",
    sixmlAllowClosedCardInsert: "sixml:AllowClosedCardInsert",
    sixmlQrctimeout: "sixml:QRCTimeout",
    sixmlLateCheckinTimeout: "sixml:LateCheckinTimeout"
};
timapi.protocol.constants.PaymentProtocol = {};
timapi.protocol.constants.PaymentProtocol.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (PaymentProtocol)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.PaymentProtocol.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (PaymentProtocol)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.PaymentProtocol.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.PaymentProtocol._timApi2Protocol =
    new Map([[timapi.constants.PaymentProtocol.ep2, "ep2"],
        [timapi.constants.PaymentProtocol.ev, "ev"],
        [timapi.constants.PaymentProtocol.valueMaster, "vm"],
        [timapi.constants.PaymentProtocol.v3cxml, "3CXml"]]);
timapi.protocol.constants.PaymentProtocol._protocol2TimApi =
    new Map([["ep2", timapi.constants.PaymentProtocol.ep2],
        ["ev", timapi.constants.PaymentProtocol.ev],
        ["vm", timapi.constants.PaymentProtocol.valueMaster],
        ["3CXml", timapi.constants.PaymentProtocol.v3cxml]]);
timapi.protocol.constants.PosEntryMode = {};
timapi.protocol.constants.PosEntryMode.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (PosEntryMode)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.PosEntryMode.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (PosEntryMode)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.PosEntryMode.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.PosEntryMode._timApi2Protocol =
    new Map([[timapi.constants.PosEntryMode.unspecified, 0],
        [timapi.constants.PosEntryMode.manual, 1],
        [timapi.constants.PosEntryMode.magStripeIncomplete, 2],
        [timapi.constants.PosEntryMode.barCode, 3],
        [timapi.constants.PosEntryMode.ocr, 4],
        [timapi.constants.PosEntryMode.icc, 5],
        [timapi.constants.PosEntryMode.magStripe, 90],
        [timapi.constants.PosEntryMode.magStripeFallback, 91],
        [timapi.constants.PosEntryMode.magStripeFallbackAgain, 92],
        [timapi.constants.PosEntryMode.magStripeFallbackIccFail, 93],
        [timapi.constants.PosEntryMode.emergencyDataEntry, 94],
        [timapi.constants.PosEntryMode.ecommerce, 95],
        [timapi.constants.PosEntryMode.ctlessIcc, 97],
        [timapi.constants.PosEntryMode.ctlessMagStrige, 98]]);
timapi.protocol.constants.PosEntryMode._protocol2TimApi =
    new Map([[0, timapi.constants.PosEntryMode.unspecified],
        [1, timapi.constants.PosEntryMode.manual],
        [2, timapi.constants.PosEntryMode.magStripeIncomplete],
        [3, timapi.constants.PosEntryMode.barCode],
        [4, timapi.constants.PosEntryMode.ocr],
        [5, timapi.constants.PosEntryMode.icc],
        [90, timapi.constants.PosEntryMode.magStripe],
        [91, timapi.constants.PosEntryMode.magStripeFallback],
        [92, timapi.constants.PosEntryMode.magStripeFallbackAgain],
        [93, timapi.constants.PosEntryMode.magStripeFallbackIccFail],
        [94, timapi.constants.PosEntryMode.emergencyDataEntry],
        [95, timapi.constants.PosEntryMode.ecommerce],
        [97, timapi.constants.PosEntryMode.ctlessIcc],
        [98, timapi.constants.PosEntryMode.ctlessMagStrige]]);
timapi.protocol.constants.PrintFlag = {};
timapi.protocol.constants.PrintFlag.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (PrintFlag)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.PrintFlag.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.PrintFlag._timApi2Protocol =
    new Map([[timapi.constants.PrintFlag.suppressHeader, 0x1],
        [timapi.constants.PrintFlag.suppressSignature, 0x2],
        [timapi.constants.PrintFlag.suppressEcrInfo, 0x4],
        [timapi.constants.PrintFlag.suppressEftInfo, 0x8]]);
timapi.protocol.constants.PrintFlag._protocol2TimApi =
    new Map([[0x1, timapi.constants.PrintFlag.suppressHeader],
        [0x2, timapi.constants.PrintFlag.suppressSignature],
        [0x4, timapi.constants.PrintFlag.suppressEcrInfo],
        [0x8, timapi.constants.PrintFlag.suppressEftInfo]]);
timapi.protocol.constants.PrintFormat = {};
timapi.protocol.constants.PrintFormat.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (PrintFormat)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.PrintFormat.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (PrintFormat)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.PrintFormat.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.PrintFormat._timApi2Protocol =
    new Map([[timapi.constants.PrintFormat.noPrint, "NoPrint"],
        [timapi.constants.PrintFormat.normal, "Normal"],
        [timapi.constants.PrintFormat.onDevice, "OnDevice"],
        [timapi.constants.PrintFormat.fieldsOnly, "FieldsOnly"]]);
timapi.protocol.constants.PrintFormat._protocol2TimApi =
    new Map([["NoPrint", timapi.constants.PrintFormat.noPrint],
        ["Normal", timapi.constants.PrintFormat.normal],
        ["OnDevice", timapi.constants.PrintFormat.onDevice],
        ["FieldsOnly", timapi.constants.PrintFormat.fieldsOnly]]);
timapi.protocol.constants.ProcessingDisposition = {};
timapi.protocol.constants.ProcessingDisposition.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ProcessingDisposition)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ProcessingDisposition.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ProcessingDisposition)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ProcessingDisposition.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ProcessingDisposition._timApi2Protocol =
    new Map([[timapi.constants.ProcessingDisposition.onEcr, "OnECR"],
        [timapi.constants.ProcessingDisposition.onEft, "OnEFT"]]);
timapi.protocol.constants.ProcessingDisposition._protocol2TimApi =
    new Map([["OnECR", timapi.constants.ProcessingDisposition.onEcr],
        ["OnEFT", timapi.constants.ProcessingDisposition.onEft]]);
timapi.protocol.constants.ProtocolLevel = {};
timapi.protocol.constants.ProtocolLevel.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ProtocolLevel)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ProtocolLevel.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ProtocolLevel)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ProtocolLevel.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ProtocolLevel._timApi2Protocol =
    new Map([[timapi.constants.ProtocolLevel.sixml2_2, 3]]);
timapi.protocol.constants.ProtocolLevel._protocol2TimApi =
    new Map([[3, timapi.constants.ProtocolLevel.sixml2_2]]);
timapi.protocol.constants.ProtocolType = {};
timapi.protocol.constants.ProtocolType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ProtocolType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ProtocolType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ProtocolType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ProtocolType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ProtocolType._timApi2Protocol =
    new Map([[timapi.constants.ProtocolType.sixml, 1]]);
timapi.protocol.constants.ProtocolType._protocol2TimApi =
    new Map([[1, timapi.constants.ProtocolType.sixml]]);
timapi.protocol.constants.Reason = {};
timapi.protocol.constants.Reason.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Reason)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.Reason.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Reason)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Reason.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Reason._timApi2Protocol =
    new Map([[timapi.constants.Reason.ok, "Ok"],
        [timapi.constants.Reason.corr, "Corr"],
        [timapi.constants.Reason.stop, "Stop"],
        [timapi.constants.Reason.cardReader, "CardReader"],
        [timapi.constants.Reason.autoConfirm, "AutoConfirm"],
        [timapi.constants.Reason.timeout, "Timeout"],
        [timapi.constants.Reason.codeOk, "CodeOk"],
        [timapi.constants.Reason.codeNok, "CodeNok"],
        [timapi.constants.Reason.pinOk, "PinOk"],
        [timapi.constants.Reason.pinNok, "PinNok"]]);
timapi.protocol.constants.Reason._protocol2TimApi =
    new Map([["Ok", timapi.constants.Reason.ok],
        ["Corr", timapi.constants.Reason.corr],
        ["Stop", timapi.constants.Reason.stop],
        ["CardReader", timapi.constants.Reason.cardReader],
        ["AutoConfirm", timapi.constants.Reason.autoConfirm],
        ["Timeout", timapi.constants.Reason.timeout],
        ["CodeOk", timapi.constants.Reason.codeOk],
        ["CodeNok", timapi.constants.Reason.codeNok],
        ["PinOk", timapi.constants.Reason.pinOk],
        ["PinNok", timapi.constants.Reason.pinNok]]);
timapi.protocol.constants.ReceiptItemType = {};
timapi.protocol.constants.ReceiptItemType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ReceiptItemType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ReceiptItemType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ReceiptItemType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ReceiptItemType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ReceiptItemType._timApi2Protocol =
    new Map([[timapi.constants.ReceiptItemType.actId, "ActId"],
        [timapi.constants.ReceiptItemType.accPer, "AccPer"],
        [timapi.constants.ReceiptItemType.acqId, "AcqId"],
        [timapi.constants.ReceiptItemType.aid, "Aid"],
        [timapi.constants.ReceiptItemType.amount, "Amount"],
        [timapi.constants.ReceiptItemType.amountDcc, "AmountDcc"],
        [timapi.constants.ReceiptItemType.amountOther, "AmountOther"],
        [timapi.constants.ReceiptItemType.authCode, "AuthCode"],
        [timapi.constants.ReceiptItemType.authReslt, "AuthReslt"],
        [timapi.constants.ReceiptItemType.authRespC, "AuthRespC"],
        [timapi.constants.ReceiptItemType.authRespTextC, "AuthRespTextC"],
        [timapi.constants.ReceiptItemType.brandName, "BrandName"],
        [timapi.constants.ReceiptItemType.currency, "Currency"],
        [timapi.constants.ReceiptItemType.currencyDcc, "CurrencyDcc"],
        [timapi.constants.ReceiptItemType.dccDisclaimer, "DccDisclaimer"],
        [timapi.constants.ReceiptItemType.disclaimer, "Disclaimer"],
        [timapi.constants.ReceiptItemType.exponent, "Exponent"],
        [timapi.constants.ReceiptItemType.exponentDcc, "ExponentDcc"],
        [timapi.constants.ReceiptItemType.markupDcc, "MarkupDcc"],
        [timapi.constants.ReceiptItemType.markupExponentDcc, "MarkupExponentDcc"],
        [timapi.constants.ReceiptItemType.cardNumberPrintableMerchant, "CardNumberPrintableMerchant"],
        [timapi.constants.ReceiptItemType.cardNumberPrintableCardholder, "CardNumberPrintableCardholder"],
        [timapi.constants.ReceiptItemType.rateDcc, "RateDcc"],
        [timapi.constants.ReceiptItemType.rateExponentDcc, "RateExponentDcc"],
        [timapi.constants.ReceiptItemType.timeStampDate, "TimeStampDate"],
        [timapi.constants.ReceiptItemType.timeStampTime, "TimeStampTime"],
        [timapi.constants.ReceiptItemType.trmId, "TrmId"],
        [timapi.constants.ReceiptItemType.trxRefNum, "TrxRefNum"],
        [timapi.constants.ReceiptItemType.trxSeqCnt, "TrxSeqCnt"],
        [timapi.constants.ReceiptItemType.posEntryMode, "PosEntryMode"],
        [timapi.constants.ReceiptItemType.cardExpiryDate, "CardExpiryDate"],
        [timapi.constants.ReceiptItemType.cardNumberEnc, "CardNumberEnc"],
        [timapi.constants.ReceiptItemType.amountSaldo, "AmountSaldo"],
        [timapi.constants.ReceiptItemType.ecrSeqCounter, "EcrSeqCounter"],
        [timapi.constants.ReceiptItemType.panReceiptDol, "PanReceiptDol"],
        [timapi.constants.ReceiptItemType.panReceiptDolIndex, "PanReceiptDolIndex"]]);
timapi.protocol.constants.ReceiptItemType._protocol2TimApi =
    new Map([["ActId", timapi.constants.ReceiptItemType.actId],
        ["AccPer", timapi.constants.ReceiptItemType.accPer],
        ["AcqId", timapi.constants.ReceiptItemType.acqId],
        ["Aid", timapi.constants.ReceiptItemType.aid],
        ["Amount", timapi.constants.ReceiptItemType.amount],
        ["AmountDcc", timapi.constants.ReceiptItemType.amountDcc],
        ["AmountOther", timapi.constants.ReceiptItemType.amountOther],
        ["AuthCode", timapi.constants.ReceiptItemType.authCode],
        ["AuthReslt", timapi.constants.ReceiptItemType.authReslt],
        ["AuthRespC", timapi.constants.ReceiptItemType.authRespC],
        ["AuthRespTextC", timapi.constants.ReceiptItemType.authRespTextC],
        ["BrandName", timapi.constants.ReceiptItemType.brandName],
        ["Currency", timapi.constants.ReceiptItemType.currency],
        ["CurrencyDcc", timapi.constants.ReceiptItemType.currencyDcc],
        ["DccDisclaimer", timapi.constants.ReceiptItemType.dccDisclaimer],
        ["Disclaimer", timapi.constants.ReceiptItemType.disclaimer],
        ["Exponent", timapi.constants.ReceiptItemType.exponent],
        ["ExponentDcc", timapi.constants.ReceiptItemType.exponentDcc],
        ["MarkupDcc", timapi.constants.ReceiptItemType.markupDcc],
        ["MarkupExponentDcc", timapi.constants.ReceiptItemType.markupExponentDcc],
        ["CardNumberPrintableMerchant", timapi.constants.ReceiptItemType.cardNumberPrintableMerchant],
        ["CardNumberPrintableCardholder", timapi.constants.ReceiptItemType.cardNumberPrintableCardholder],
        ["RateDcc", timapi.constants.ReceiptItemType.rateDcc],
        ["RateExponentDcc", timapi.constants.ReceiptItemType.rateExponentDcc],
        ["TimeStampDate", timapi.constants.ReceiptItemType.timeStampDate],
        ["TimeStampTime", timapi.constants.ReceiptItemType.timeStampTime],
        ["TrmId", timapi.constants.ReceiptItemType.trmId],
        ["TrxRefNum", timapi.constants.ReceiptItemType.trxRefNum],
        ["TrxSeqCnt", timapi.constants.ReceiptItemType.trxSeqCnt],
        ["PosEntryMode", timapi.constants.ReceiptItemType.posEntryMode],
        ["CardExpiryDate", timapi.constants.ReceiptItemType.cardExpiryDate],
        ["CardNumberEnc", timapi.constants.ReceiptItemType.cardNumberEnc],
        ["AmountSaldo", timapi.constants.ReceiptItemType.amountSaldo],
        ["EcrSeqCounter", timapi.constants.ReceiptItemType.ecrSeqCounter],
        ["PanReceiptDol", timapi.constants.ReceiptItemType.panReceiptDol],
        ["PanReceiptDolIndex", timapi.constants.ReceiptItemType.panReceiptDolIndex]]);
timapi.protocol.constants.ReceiptRequestType = {};
timapi.protocol.constants.ReceiptRequestType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ReceiptRequestType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ReceiptRequestType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ReceiptRequestType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ReceiptRequestType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ReceiptRequestType._timApi2Protocol =
    new Map([[timapi.constants.ReceiptRequestType.reprint, "Reprint"],
        [timapi.constants.ReceiptRequestType.list, "List"]]);
timapi.protocol.constants.ReceiptRequestType._protocol2TimApi =
    new Map([["Reprint", timapi.constants.ReceiptRequestType.reprint],
        ["List", timapi.constants.ReceiptRequestType.list]]);
timapi.protocol.constants.ReceiptType = {};
timapi.protocol.constants.ReceiptType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ReceiptType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ReceiptType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ReceiptType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ReceiptType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ReceiptType._timApi2Protocol =
    new Map([[timapi.constants.ReceiptType.purchase, "Purchase"],
        [timapi.constants.ReceiptType.credit, "Credit"],
        [timapi.constants.ReceiptType.reversal, "Reversal"]]);
timapi.protocol.constants.ReceiptType._protocol2TimApi =
    new Map([["Purchase", timapi.constants.ReceiptType.purchase],
        ["Credit", timapi.constants.ReceiptType.credit],
        ["Reversal", timapi.constants.ReceiptType.reversal]]);
timapi.protocol.constants.Recipient = {};
timapi.protocol.constants.Recipient.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Recipient)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.Recipient.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Recipient)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Recipient.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Recipient._timApi2Protocol =
    new Map([[timapi.constants.Recipient.merchant, "Merchant"],
        [timapi.constants.Recipient.cardholder, "Cardholder"],
        [timapi.constants.Recipient.both, "Both"]]);
timapi.protocol.constants.Recipient._protocol2TimApi =
    new Map([["Merchant", timapi.constants.Recipient.merchant],
        ["Cardholder", timapi.constants.Recipient.cardholder],
        ["Both", timapi.constants.Recipient.both]]);
timapi.protocol.constants.ResourceId = {};
timapi.protocol.constants.ResourceId.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ResourceId)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ResourceId.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ResourceId)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ResourceId.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ResourceId._timApi2Protocol =
    new Map([[timapi.constants.ResourceId.enterMileage, 100],
        [timapi.constants.ResourceId.enterCarNumber, 101],
        [timapi.constants.ResourceId.enterDriverCode, 102],
        [timapi.constants.ResourceId.enterFleetId, 103],
        [timapi.constants.ResourceId.selectPump, 104],
        [timapi.constants.ResourceId.selectWashingStation, 105],
        [timapi.constants.ResourceId.selectProgram, 106],
        [timapi.constants.ResourceId.selectProduct, 107],
        [timapi.constants.ResourceId.loadCard, 108],
        [timapi.constants.ResourceId.readCode, 109],
        [timapi.constants.ResourceId.checkCode, 110],
        [timapi.constants.ResourceId.enterAdditionalInformation, 111],
        [timapi.constants.ResourceId.enterCostCenter, 112],
        [timapi.constants.ResourceId.enterEmployeeNumber, 113],
        [timapi.constants.ResourceId.enterLicensePlate, 114],
        [timapi.constants.ResourceId.enterProjectNumber, 115],
        [timapi.constants.ResourceId.petrolPrintReceipt, 116],
        [timapi.constants.ResourceId.petrolRemoveCard, 117],
        [timapi.constants.ResourceId.petrolOutOfOrder, 118],
        [timapi.constants.ResourceId.petrolInvalidEntry, 119],
        [timapi.constants.ResourceId.petrolRefuelAtPump, 120],
        [timapi.constants.ResourceId.petrolSeeOtherScreen, 121],
        [timapi.constants.ResourceId.petrolPleaseRefuel, 122],
        [timapi.constants.ResourceId.noRechargeCard, 1000],
        [timapi.constants.ResourceId.showPhoneNumberWithAmount, 1001],
        [timapi.constants.ResourceId.enterPhoneOrPrepaidNumber, 1002],
        [timapi.constants.ResourceId.phoneNumberTooLong, 1003],
        [timapi.constants.ResourceId.phoneNumberTooShort, 1004],
        [timapi.constants.ResourceId.enterPhoneNumber, 1005],
        [timapi.constants.ResourceId.pleaseWait, 1006],
        [timapi.constants.ResourceId.processingDeclined, 1007],
        [timapi.constants.ResourceId.processingOk, 1008],
        [timapi.constants.ResourceId.registerCard, 1009],
        [timapi.constants.ResourceId.welcomeCard, 1010],
        [timapi.constants.ResourceId.showPhoneNumber, 1011],
        [timapi.constants.ResourceId.interAccountTransfer, 1012],
        [timapi.constants.ResourceId.interAccountTransferConfirmation, 1013],
        [timapi.constants.ResourceId.disbursementFromAccount, 1014],
        [timapi.constants.ResourceId.depositOwnAccount, 1015],
        [timapi.constants.ResourceId.emptyDialog, 1016],
        [timapi.constants.ResourceId.packetAcknowledgement, 1017],
        [timapi.constants.ResourceId.pinEntry, 1018],
        [timapi.constants.ResourceId.bankingInsertCard, 1100],
        [timapi.constants.ResourceId.bankingPinCheck, 1101],
        [timapi.constants.ResourceId.bankingShowSaldo, 1102],
        [timapi.constants.ResourceId.bankingConfirmAmount, 1103],
        [timapi.constants.ResourceId.bankingRemoveCard, 1104],
        [timapi.constants.ResourceId.bankingWelcome, 1105],
        [timapi.constants.ResourceId.commonRegular, 3000],
        [timapi.constants.ResourceId.commonPleaseWait, 3001],
        [timapi.constants.ResourceId.commonDataSaved, 3002],
        [timapi.constants.ResourceId.commonCardInitialized, 3003],
        [timapi.constants.ResourceId.commonCardDeinitialized, 3004],
        [timapi.constants.ResourceId.commonRemoveCard, 3005]]);
timapi.protocol.constants.ResourceId._protocol2TimApi =
    new Map([[100, timapi.constants.ResourceId.enterMileage],
        [101, timapi.constants.ResourceId.enterCarNumber],
        [102, timapi.constants.ResourceId.enterDriverCode],
        [103, timapi.constants.ResourceId.enterFleetId],
        [104, timapi.constants.ResourceId.selectPump],
        [105, timapi.constants.ResourceId.selectWashingStation],
        [106, timapi.constants.ResourceId.selectProgram],
        [107, timapi.constants.ResourceId.selectProduct],
        [108, timapi.constants.ResourceId.loadCard],
        [109, timapi.constants.ResourceId.readCode],
        [110, timapi.constants.ResourceId.checkCode],
        [111, timapi.constants.ResourceId.enterAdditionalInformation],
        [112, timapi.constants.ResourceId.enterCostCenter],
        [113, timapi.constants.ResourceId.enterEmployeeNumber],
        [114, timapi.constants.ResourceId.enterLicensePlate],
        [115, timapi.constants.ResourceId.enterProjectNumber],
        [116, timapi.constants.ResourceId.petrolPrintReceipt],
        [117, timapi.constants.ResourceId.petrolRemoveCard],
        [118, timapi.constants.ResourceId.petrolOutOfOrder],
        [119, timapi.constants.ResourceId.petrolInvalidEntry],
        [120, timapi.constants.ResourceId.petrolRefuelAtPump],
        [121, timapi.constants.ResourceId.petrolSeeOtherScreen],
        [122, timapi.constants.ResourceId.petrolPleaseRefuel],
        [1000, timapi.constants.ResourceId.noRechargeCard],
        [1001, timapi.constants.ResourceId.showPhoneNumberWithAmount],
        [1002, timapi.constants.ResourceId.enterPhoneOrPrepaidNumber],
        [1003, timapi.constants.ResourceId.phoneNumberTooLong],
        [1004, timapi.constants.ResourceId.phoneNumberTooShort],
        [1005, timapi.constants.ResourceId.enterPhoneNumber],
        [1006, timapi.constants.ResourceId.pleaseWait],
        [1007, timapi.constants.ResourceId.processingDeclined],
        [1008, timapi.constants.ResourceId.processingOk],
        [1009, timapi.constants.ResourceId.registerCard],
        [1010, timapi.constants.ResourceId.welcomeCard],
        [1011, timapi.constants.ResourceId.showPhoneNumber],
        [1012, timapi.constants.ResourceId.interAccountTransfer],
        [1013, timapi.constants.ResourceId.interAccountTransferConfirmation],
        [1014, timapi.constants.ResourceId.disbursementFromAccount],
        [1015, timapi.constants.ResourceId.depositOwnAccount],
        [1016, timapi.constants.ResourceId.emptyDialog],
        [1017, timapi.constants.ResourceId.packetAcknowledgement],
        [1018, timapi.constants.ResourceId.pinEntry],
        [1100, timapi.constants.ResourceId.bankingInsertCard],
        [1101, timapi.constants.ResourceId.bankingPinCheck],
        [1102, timapi.constants.ResourceId.bankingShowSaldo],
        [1103, timapi.constants.ResourceId.bankingConfirmAmount],
        [1104, timapi.constants.ResourceId.bankingRemoveCard],
        [1105, timapi.constants.ResourceId.bankingWelcome],
        [3000, timapi.constants.ResourceId.commonRegular],
        [3001, timapi.constants.ResourceId.commonPleaseWait],
        [3002, timapi.constants.ResourceId.commonDataSaved],
        [3003, timapi.constants.ResourceId.commonCardInitialized],
        [3004, timapi.constants.ResourceId.commonCardDeinitialized],
        [3005, timapi.constants.ResourceId.commonRemoveCard]]);
timapi.protocol.constants.ResultCode = {};
timapi.protocol.constants.ResultCode.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ResultCode)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.ResultCode.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (ResultCode)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ResultCode.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.ResultCode._timApi2Protocol =
    new Map([[timapi.constants.ResultCode.ok, 0],
        [timapi.constants.ResultCode.apiCancelEcr, 50],
        [timapi.constants.ResultCode.apiInvalidAnswer, 51],
        [timapi.constants.ResultCode.apiDisabledFeature, 52],
        [timapi.constants.ResultCode.apiFunctionDisallowed, 53],
        [timapi.constants.ResultCode.apiPersistencyProblem, 54],
        [timapi.constants.ResultCode.apiConnectFailServer, 100],
        [timapi.constants.ResultCode.apiConnectFailTerminal, 101],
        [timapi.constants.ResultCode.apiConnectionLostServer, 102],
        [timapi.constants.ResultCode.apiConnectionLostTerminal, 103],
        [timapi.constants.ResultCode.ethernetDisconnected, 104],
        [timapi.constants.ResultCode.rs232Disconnected, 105],
        [timapi.constants.ResultCode.apiTimeoutServer, 106],
        [timapi.constants.ResultCode.apiTimeoutTerminal, 107],
        [timapi.constants.ResultCode.serverInvalidAnswer, 200],
        [timapi.constants.ResultCode.serverInvalidRequest, 201],
        [timapi.constants.ResultCode.serverDisabledFeature, 202],
        [timapi.constants.ResultCode.serverPersistencyProblem, 203],
        [timapi.constants.ResultCode.serverConnectFailTerminal, 250],
        [timapi.constants.ResultCode.serverConnectionLostTerminal, 251],
        [timapi.constants.ResultCode.serverTimeoutTerminal, 252],
        [timapi.constants.ResultCode.ccrUnavailable, 300],
        [timapi.constants.ResultCode.mcrUnavailable, 301],
        [timapi.constants.ResultCode.nfcUnavailable, 302],
        [timapi.constants.ResultCode.displayUnavailable, 303],
        [timapi.constants.ResultCode.pinPadUnavailable, 304],
        [timapi.constants.ResultCode.rs232Unavailable, 305],
        [timapi.constants.ResultCode.rs232NotConfigured, 306],
        [timapi.constants.ResultCode.cardReaderErrorCcr, 400],
        [timapi.constants.ResultCode.cardReaderErrorMcr, 401],
        [timapi.constants.ResultCode.cardReaderErrorNfc, 402],
        [timapi.constants.ResultCode.cardErrorCcr, 403],
        [timapi.constants.ResultCode.cardErrorMcr, 404],
        [timapi.constants.ResultCode.cardErrorNfc, 405],
        [timapi.constants.ResultCode.cardReadError, 406],
        [timapi.constants.ResultCode.cardReadTimeout, 407],
        [timapi.constants.ResultCode.cardInsertionTimeout, 408],
        [timapi.constants.ResultCode.cardReaderKeysLost, 409],
        [timapi.constants.ResultCode.cardReaderSecurityError, 410],
        [timapi.constants.ResultCode.cardTimeout, 411],
        [timapi.constants.ResultCode.cardNotReadable, 412],
        [timapi.constants.ResultCode.cardInvalidData, 413],
        [timapi.constants.ResultCode.cardFunctionNotFound, 414],
        [timapi.constants.ResultCode.cardFunctionNotAllowed, 415],
        [timapi.constants.ResultCode.pinPadSecurityError, 500],
        [timapi.constants.ResultCode.pinPadTampered, 501],
        [timapi.constants.ResultCode.pinPadKeysLost, 502],
        [timapi.constants.ResultCode.cardholderStop, 550],
        [timapi.constants.ResultCode.cardholderTimeout, 551],
        [timapi.constants.ResultCode.cardRemoved, 552],
        [timapi.constants.ResultCode.timTimeoutEcr, 600],
        [timapi.constants.ResultCode.timConnectFailPaymentHost, 601],
        [timapi.constants.ResultCode.timConnectionLostPaymentHost, 602],
        [timapi.constants.ResultCode.timTimeoutAnswerRs232, 603],
        [timapi.constants.ResultCode.timCommunicationFailure, 604],
        [timapi.constants.ResultCode.timConfigFailure, 605],
        [timapi.constants.ResultCode.timInitFailure, 606],
        [timapi.constants.ResultCode.sixmlGeneralError, 700],
        [timapi.constants.ResultCode.sixmlInvalidRequest, 701],
        [timapi.constants.ResultCode.sixmlWrongCashier, 702],
        [timapi.constants.ResultCode.sixmlWrongEcrId, 703],
        [timapi.constants.ResultCode.sixmlUnknownReferenceNumber, 704],
        [timapi.constants.ResultCode.sixmlWrongState, 705],
        [timapi.constants.ResultCode.busyOtherController, 706],
        [timapi.constants.ResultCode.busyMaintenance, 707],
        [timapi.constants.ResultCode.requestPending, 708],
        [timapi.constants.ResultCode.sixmlUnsupportedRequest, 709],
        [timapi.constants.ResultCode.trxNoCommonApplications, 800],
        [timapi.constants.ResultCode.trxLimitExceeded, 801],
        [timapi.constants.ResultCode.trxNoCommonCvm, 802],
        [timapi.constants.ResultCode.declinedCvmFailed, 803],
        [timapi.constants.ResultCode.trxReferral, 804],
        [timapi.constants.ResultCode.trxInvalidAuthResponse, 805],
        [timapi.constants.ResultCode.declinedGeneric, 806],
        [timapi.constants.ResultCode.declinedSaldoTooLow, 807],
        [timapi.constants.ResultCode.declinedWrongPin, 808],
        [timapi.constants.ResultCode.declinedCardBlocked, 809],
        [timapi.constants.ResultCode.declinedSecurityIssue, 810],
        [timapi.constants.ResultCode.declinedUsageControl, 811],
        [timapi.constants.ResultCode.declinedDoubleTransaction, 812],
        [timapi.constants.ResultCode.declinedGenericFirstAc, 813],
        [timapi.constants.ResultCode.declinedGenericSecondAc, 814],
        [timapi.constants.ResultCode.trxCommitTimeout, 815],
        [timapi.constants.ResultCode.trxRollbackImpossible, 816],
        [timapi.constants.ResultCode.cashbackAmountTooLow, 817],
        [timapi.constants.ResultCode.cashbackAmountTooHigh, 818],
        [timapi.constants.ResultCode.basketDeclined, 819],
        [timapi.constants.ResultCode.noTrxInGroupExceeded, 820],
        [timapi.constants.ResultCode.unsupportedCharactersInMessage, 821],
        [timapi.constants.ResultCode.loyaltyCheckInPending, 822],
        [timapi.constants.ResultCode.declinedCardError, 823],
        [timapi.constants.ResultCode.declinedCardExpired, 824],
        [timapi.constants.ResultCode.declinedTrxInvalid, 825],
        [timapi.constants.ResultCode.declinedTryLater, 826],
        [timapi.constants.ResultCode.declinedTryAnotherInterface, 827],
        [timapi.constants.ResultCode.declinedInvalidMerchant, 828],
        [timapi.constants.ResultCode.declinedRestrictionDeclined, 829],
        [timapi.constants.ResultCode.declinedWrongCurrency, 830],
        [timapi.constants.ResultCode.declinedAutoreversalPending, 831],
        [timapi.constants.ResultCode.declinedWrongCardNumber, 832],
        [timapi.constants.ResultCode.declinedWrongCardExpiryDate, 833],
        [timapi.constants.ResultCode.declinedRetryTemporaryUnavailable, 834],
        [timapi.constants.ResultCode.declinedServiceNotAllowed, 835],
        [timapi.constants.ResultCode.declinedCardholderInformationIssue, 836],
        [timapi.constants.ResultCode.declinedReferralWrongAuthCode, 837],
        [timapi.constants.ResultCode.declinedReferralWrongAmount, 838],
        [timapi.constants.ResultCode.declinedReferralOtherReason, 839],
        [timapi.constants.ResultCode.declinedCaptureCardGeneric, 840],
        [timapi.constants.ResultCode.declinedCaptureCardInfoToClient, 841],
        [timapi.constants.ResultCode.declinedCaptureCardOrderToClient, 842],
        [timapi.constants.ResultCode.declinedCaptureCardTimeoutRemovingCard, 843],
        [timapi.constants.ResultCode.declinedNotSupported, 844]]);
timapi.protocol.constants.ResultCode._protocol2TimApi =
    new Map([[0, timapi.constants.ResultCode.ok],
        [50, timapi.constants.ResultCode.apiCancelEcr],
        [51, timapi.constants.ResultCode.apiInvalidAnswer],
        [52, timapi.constants.ResultCode.apiDisabledFeature],
        [53, timapi.constants.ResultCode.apiFunctionDisallowed],
        [54, timapi.constants.ResultCode.apiPersistencyProblem],
        [100, timapi.constants.ResultCode.apiConnectFailServer],
        [101, timapi.constants.ResultCode.apiConnectFailTerminal],
        [102, timapi.constants.ResultCode.apiConnectionLostServer],
        [103, timapi.constants.ResultCode.apiConnectionLostTerminal],
        [104, timapi.constants.ResultCode.ethernetDisconnected],
        [105, timapi.constants.ResultCode.rs232Disconnected],
        [106, timapi.constants.ResultCode.apiTimeoutServer],
        [107, timapi.constants.ResultCode.apiTimeoutTerminal],
        [200, timapi.constants.ResultCode.serverInvalidAnswer],
        [201, timapi.constants.ResultCode.serverInvalidRequest],
        [202, timapi.constants.ResultCode.serverDisabledFeature],
        [203, timapi.constants.ResultCode.serverPersistencyProblem],
        [250, timapi.constants.ResultCode.serverConnectFailTerminal],
        [251, timapi.constants.ResultCode.serverConnectionLostTerminal],
        [252, timapi.constants.ResultCode.serverTimeoutTerminal],
        [300, timapi.constants.ResultCode.ccrUnavailable],
        [301, timapi.constants.ResultCode.mcrUnavailable],
        [302, timapi.constants.ResultCode.nfcUnavailable],
        [303, timapi.constants.ResultCode.displayUnavailable],
        [304, timapi.constants.ResultCode.pinPadUnavailable],
        [305, timapi.constants.ResultCode.rs232Unavailable],
        [306, timapi.constants.ResultCode.rs232NotConfigured],
        [400, timapi.constants.ResultCode.cardReaderErrorCcr],
        [401, timapi.constants.ResultCode.cardReaderErrorMcr],
        [402, timapi.constants.ResultCode.cardReaderErrorNfc],
        [403, timapi.constants.ResultCode.cardErrorCcr],
        [404, timapi.constants.ResultCode.cardErrorMcr],
        [405, timapi.constants.ResultCode.cardErrorNfc],
        [406, timapi.constants.ResultCode.cardReadError],
        [407, timapi.constants.ResultCode.cardReadTimeout],
        [408, timapi.constants.ResultCode.cardInsertionTimeout],
        [409, timapi.constants.ResultCode.cardReaderKeysLost],
        [410, timapi.constants.ResultCode.cardReaderSecurityError],
        [411, timapi.constants.ResultCode.cardTimeout],
        [412, timapi.constants.ResultCode.cardNotReadable],
        [413, timapi.constants.ResultCode.cardInvalidData],
        [414, timapi.constants.ResultCode.cardFunctionNotFound],
        [415, timapi.constants.ResultCode.cardFunctionNotAllowed],
        [500, timapi.constants.ResultCode.pinPadSecurityError],
        [501, timapi.constants.ResultCode.pinPadTampered],
        [502, timapi.constants.ResultCode.pinPadKeysLost],
        [550, timapi.constants.ResultCode.cardholderStop],
        [551, timapi.constants.ResultCode.cardholderTimeout],
        [552, timapi.constants.ResultCode.cardRemoved],
        [600, timapi.constants.ResultCode.timTimeoutEcr],
        [601, timapi.constants.ResultCode.timConnectFailPaymentHost],
        [602, timapi.constants.ResultCode.timConnectionLostPaymentHost],
        [603, timapi.constants.ResultCode.timTimeoutAnswerRs232],
        [604, timapi.constants.ResultCode.timCommunicationFailure],
        [605, timapi.constants.ResultCode.timConfigFailure],
        [606, timapi.constants.ResultCode.timInitFailure],
        [700, timapi.constants.ResultCode.sixmlGeneralError],
        [701, timapi.constants.ResultCode.sixmlInvalidRequest],
        [702, timapi.constants.ResultCode.sixmlWrongCashier],
        [703, timapi.constants.ResultCode.sixmlWrongEcrId],
        [704, timapi.constants.ResultCode.sixmlUnknownReferenceNumber],
        [705, timapi.constants.ResultCode.sixmlWrongState],
        [706, timapi.constants.ResultCode.busyOtherController],
        [707, timapi.constants.ResultCode.busyMaintenance],
        [708, timapi.constants.ResultCode.requestPending],
        [709, timapi.constants.ResultCode.sixmlUnsupportedRequest],
        [800, timapi.constants.ResultCode.trxNoCommonApplications],
        [801, timapi.constants.ResultCode.trxLimitExceeded],
        [802, timapi.constants.ResultCode.trxNoCommonCvm],
        [803, timapi.constants.ResultCode.declinedCvmFailed],
        [804, timapi.constants.ResultCode.trxReferral],
        [805, timapi.constants.ResultCode.trxInvalidAuthResponse],
        [806, timapi.constants.ResultCode.declinedGeneric],
        [807, timapi.constants.ResultCode.declinedSaldoTooLow],
        [808, timapi.constants.ResultCode.declinedWrongPin],
        [809, timapi.constants.ResultCode.declinedCardBlocked],
        [810, timapi.constants.ResultCode.declinedSecurityIssue],
        [811, timapi.constants.ResultCode.declinedUsageControl],
        [812, timapi.constants.ResultCode.declinedDoubleTransaction],
        [813, timapi.constants.ResultCode.declinedGenericFirstAc],
        [814, timapi.constants.ResultCode.declinedGenericSecondAc],
        [815, timapi.constants.ResultCode.trxCommitTimeout],
        [816, timapi.constants.ResultCode.trxRollbackImpossible],
        [817, timapi.constants.ResultCode.cashbackAmountTooLow],
        [818, timapi.constants.ResultCode.cashbackAmountTooHigh],
        [819, timapi.constants.ResultCode.basketDeclined],
        [820, timapi.constants.ResultCode.noTrxInGroupExceeded],
        [821, timapi.constants.ResultCode.unsupportedCharactersInMessage],
        [822, timapi.constants.ResultCode.loyaltyCheckInPending],
        [823, timapi.constants.ResultCode.declinedCardError],
        [824, timapi.constants.ResultCode.declinedCardExpired],
        [825, timapi.constants.ResultCode.declinedTrxInvalid],
        [826, timapi.constants.ResultCode.declinedTryLater],
        [827, timapi.constants.ResultCode.declinedTryAnotherInterface],
        [828, timapi.constants.ResultCode.declinedInvalidMerchant],
        [829, timapi.constants.ResultCode.declinedRestrictionDeclined],
        [830, timapi.constants.ResultCode.declinedWrongCurrency],
        [831, timapi.constants.ResultCode.declinedAutoreversalPending],
        [832, timapi.constants.ResultCode.declinedWrongCardNumber],
        [833, timapi.constants.ResultCode.declinedWrongCardExpiryDate],
        [834, timapi.constants.ResultCode.declinedRetryTemporaryUnavailable],
        [835, timapi.constants.ResultCode.declinedServiceNotAllowed],
        [836, timapi.constants.ResultCode.declinedCardholderInformationIssue],
        [837, timapi.constants.ResultCode.declinedReferralWrongAuthCode],
        [838, timapi.constants.ResultCode.declinedReferralWrongAmount],
        [839, timapi.constants.ResultCode.declinedReferralOtherReason],
        [840, timapi.constants.ResultCode.declinedCaptureCardGeneric],
        [841, timapi.constants.ResultCode.declinedCaptureCardInfoToClient],
        [842, timapi.constants.ResultCode.declinedCaptureCardOrderToClient],
        [843, timapi.constants.ResultCode.declinedCaptureCardTimeoutRemovingCard],
        [844, timapi.constants.ResultCode.declinedNotSupported]]);
timapi.protocol.constants.SecurityStatus = {};
timapi.protocol.constants.SecurityStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (SecurityStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.SecurityStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (SecurityStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.SecurityStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.SecurityStatus._timApi2Protocol =
    new Map([[timapi.constants.SecurityStatus.disabled, "Disabled"],
        [timapi.constants.SecurityStatus.active, "Active"],
        [timapi.constants.SecurityStatus.tampered, "Tampered"]]);
timapi.protocol.constants.SecurityStatus._protocol2TimApi =
    new Map([["Disabled", timapi.constants.SecurityStatus.disabled],
        ["Active", timapi.constants.SecurityStatus.active],
        ["Tampered", timapi.constants.SecurityStatus.tampered]]);
timapi.protocol.constants.SettingType = {};
timapi.protocol.constants.SettingType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (SettingType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.SettingType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (SettingType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.SettingType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.SettingType._timApi2Protocol =
    new Map([[timapi.constants.SettingType.displayBrightness, "DisplayBrightness"],
        [timapi.constants.SettingType.displayContrast, "DisplayContrast"],
        [timapi.constants.SettingType.keypadTones, "KeypadTones"],
        [timapi.constants.SettingType.alertTones, "AlertTones"],
        [timapi.constants.SettingType.language, "Language"]]);
timapi.protocol.constants.SettingType._protocol2TimApi =
    new Map([["DisplayBrightness", timapi.constants.SettingType.displayBrightness],
        ["DisplayContrast", timapi.constants.SettingType.displayContrast],
        ["KeypadTones", timapi.constants.SettingType.keypadTones],
        ["AlertTones", timapi.constants.SettingType.alertTones],
        ["Language", timapi.constants.SettingType.language]]);
timapi.protocol.constants.SleepModeStatus = {};
timapi.protocol.constants.SleepModeStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (SleepModeStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.SleepModeStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (SleepModeStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.SleepModeStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.SleepModeStatus._timApi2Protocol =
    new Map([[timapi.constants.SleepModeStatus.enteringSleep, "EnteringSleep"],
        [timapi.constants.SleepModeStatus.wakingUp, "WakingUp"]]);
timapi.protocol.constants.SleepModeStatus._protocol2TimApi =
    new Map([["EnteringSleep", timapi.constants.SleepModeStatus.enteringSleep],
        ["WakingUp", timapi.constants.SleepModeStatus.wakingUp]]);
timapi.protocol.constants.StatusFunctions = {};
timapi.protocol.constants.StatusFunctions.timApi2Protocol = function (value) {
    var flags = 0;
    for (var each of value) {
        if (!this._timApi2Protocol.has(each)) {
            throw new Error("Invalid argument '" + value + "' (StatusFunctions)");
        }
        flags |= this._timApi2Protocol.get(each);
    }
    return flags;
};
timapi.protocol.constants.StatusFunctions.protocol2TimApi = function (value) {
    var set = new Set();
    for (var [k, v] of this._protocol2TimApi.entries()) {
        if ((value & k) != 0) {
            set.add(v);
        }
    }
    return set;
};
timapi.protocol.constants.StatusFunctions._timApi2Protocol =
    new Map([[timapi.constants.StatusFunctions.featureRequest, 0x1],
        [timapi.constants.StatusFunctions.terminalStatus, 0x2],
        [timapi.constants.StatusFunctions.systemInformation, 0x4],
        [timapi.constants.StatusFunctions.applicationInformation, 0x8],
        [timapi.constants.StatusFunctions.hardwareInformation, 0x10],
        [timapi.constants.StatusFunctions.keepAlive, 0x20],
        [timapi.constants.StatusFunctions.licenseChanged, 0x40]]);
timapi.protocol.constants.StatusFunctions._protocol2TimApi =
    new Map([[0x1, timapi.constants.StatusFunctions.featureRequest],
        [0x2, timapi.constants.StatusFunctions.terminalStatus],
        [0x4, timapi.constants.StatusFunctions.systemInformation],
        [0x8, timapi.constants.StatusFunctions.applicationInformation],
        [0x10, timapi.constants.StatusFunctions.hardwareInformation],
        [0x20, timapi.constants.StatusFunctions.keepAlive],
        [0x40, timapi.constants.StatusFunctions.licenseChanged]]);
timapi.protocol.constants.Theme = {};
timapi.protocol.constants.Theme.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Theme)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.Theme.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (Theme)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Theme.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.Theme._timApi2Protocol =
    new Map([[timapi.constants.Theme.six, "Six"],
        [timapi.constants.Theme.swissPost, "SwissPost"]]);
timapi.protocol.constants.Theme._protocol2TimApi =
    new Map([["Six", timapi.constants.Theme.six],
        ["SwissPost", timapi.constants.Theme.swissPost]]);
timapi.protocol.constants.TransactionStatus = {};
timapi.protocol.constants.TransactionStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (TransactionStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.TransactionStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (TransactionStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.TransactionStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.TransactionStatus._timApi2Protocol =
    new Map([[timapi.constants.TransactionStatus.busy, "Busy"],
        [timapi.constants.TransactionStatus.idle, "Idle"],
        [timapi.constants.TransactionStatus.waitForCard, "WaitForCard"],
        [timapi.constants.TransactionStatus.readingCard, "ReadingCard"],
        [timapi.constants.TransactionStatus.applicationSelection, "ApplicationSelection"],
        [timapi.constants.TransactionStatus.waitForProceed, "WaitForProceed"],
        [timapi.constants.TransactionStatus.dccSelection, "DccSelection"],
        [timapi.constants.TransactionStatus.enterTip, "EnterTip"],
        [timapi.constants.TransactionStatus.pinEntry, "PinEntry"],
        [timapi.constants.TransactionStatus.signatureCapture, "SignatureCapture"],
        [timapi.constants.TransactionStatus.processing, "Processing"],
        [timapi.constants.TransactionStatus.waitForCommit, "WaitForCommit"]]);
timapi.protocol.constants.TransactionStatus._protocol2TimApi =
    new Map([["Busy", timapi.constants.TransactionStatus.busy],
        ["Idle", timapi.constants.TransactionStatus.idle],
        ["WaitForCard", timapi.constants.TransactionStatus.waitForCard],
        ["ReadingCard", timapi.constants.TransactionStatus.readingCard],
        ["ApplicationSelection", timapi.constants.TransactionStatus.applicationSelection],
        ["WaitForProceed", timapi.constants.TransactionStatus.waitForProceed],
        ["DccSelection", timapi.constants.TransactionStatus.dccSelection],
        ["EnterTip", timapi.constants.TransactionStatus.enterTip],
        ["PinEntry", timapi.constants.TransactionStatus.pinEntry],
        ["SignatureCapture", timapi.constants.TransactionStatus.signatureCapture],
        ["Processing", timapi.constants.TransactionStatus.processing],
        ["WaitForCommit", timapi.constants.TransactionStatus.waitForCommit]]);
timapi.protocol.constants.TransactionType = {};
timapi.protocol.constants.TransactionType.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (TransactionType)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.TransactionType.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (TransactionType)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.TransactionType.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.TransactionType._timApi2Protocol =
    new Map([[timapi.constants.TransactionType.purchase, "Purchase"],
        [timapi.constants.TransactionType.credit, "Credit"],
        [timapi.constants.TransactionType.reversal, "Reversal"],
        [timapi.constants.TransactionType.preAuthorization, "PreAuthorization"],
        [timapi.constants.TransactionType.finalizePurchase, "FinalizePurchase"],
        [timapi.constants.TransactionType.cashAdvance, "CashAdvance"],
        [timapi.constants.TransactionType.purchaseForcedAcceptance, "PurchaseForcedAcceptance"],
        [timapi.constants.TransactionType.purchaseWithCashback, "PurchaseWithCashback"],
        [timapi.constants.TransactionType.purchasePhoneAuthorized, "PurchasePhoneAuthorized"],
        [timapi.constants.TransactionType.purchasePhoneOrdered, "PurchasePhoneOrdered"],
        [timapi.constants.TransactionType.purchaseMailOrdered, "PurchaseMailOrdered"],
        [timapi.constants.TransactionType.giro, "Giro"],
        [timapi.constants.TransactionType.combined, "Combined"],
        [timapi.constants.TransactionType.authorizeCredit, "AuthorizeCredit"],
        [timapi.constants.TransactionType.authorizeDeposit, "AuthorizeDeposit"],
        [timapi.constants.TransactionType.reservation, "Reservation"],
        [timapi.constants.TransactionType.adjustReservation, "AdjustReservation"],
        [timapi.constants.TransactionType.cancelReservation, "CancelReservation"],
        [timapi.constants.TransactionType.purchaseReservation, "PurchaseReservation"],
        [timapi.constants.TransactionType.purchaseReservationPhoneAuthorized, "PurchaseReservationPhoneAuthorized"]]);
timapi.protocol.constants.TransactionType._protocol2TimApi =
    new Map([["Purchase", timapi.constants.TransactionType.purchase],
        ["Credit", timapi.constants.TransactionType.credit],
        ["Reversal", timapi.constants.TransactionType.reversal],
        ["PreAuthorization", timapi.constants.TransactionType.preAuthorization],
        ["FinalizePurchase", timapi.constants.TransactionType.finalizePurchase],
        ["CashAdvance", timapi.constants.TransactionType.cashAdvance],
        ["PurchaseForcedAcceptance", timapi.constants.TransactionType.purchaseForcedAcceptance],
        ["PurchaseWithCashback", timapi.constants.TransactionType.purchaseWithCashback],
        ["PurchasePhoneAuthorized", timapi.constants.TransactionType.purchasePhoneAuthorized],
        ["PurchasePhoneOrdered", timapi.constants.TransactionType.purchasePhoneOrdered],
        ["PurchaseMailOrdered", timapi.constants.TransactionType.purchaseMailOrdered],
        ["Giro", timapi.constants.TransactionType.giro],
        ["Combined", timapi.constants.TransactionType.combined],
        ["AuthorizeCredit", timapi.constants.TransactionType.authorizeCredit],
        ["AuthorizeDeposit", timapi.constants.TransactionType.authorizeDeposit],
        ["Reservation", timapi.constants.TransactionType.reservation],
        ["AdjustReservation", timapi.constants.TransactionType.adjustReservation],
        ["CancelReservation", timapi.constants.TransactionType.cancelReservation],
        ["PurchaseReservation", timapi.constants.TransactionType.purchaseReservation],
        ["PurchaseReservationPhoneAuthorized", timapi.constants.TransactionType.purchaseReservationPhoneAuthorized]]);
timapi.protocol.constants.UpdateStatus = {};
timapi.protocol.constants.UpdateStatus.timApi2Protocol = function (value) {
    if (!this._timApi2Protocol.has(value)) {
        throw new Error("Invalid argument '" + value + "' (UpdateStatus)");
    }
    return this._timApi2Protocol.get(value);
};
timapi.protocol.constants.UpdateStatus.protocol2TimApi = function (value) {
    if (!this._protocol2TimApi.has(value)) {
        throw new Error("Invalid argument '" + value + "' (UpdateStatus)");
    }
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.UpdateStatus.protocol2TimApiIfValid = function (value) {
    return this._protocol2TimApi.get(value);
};
timapi.protocol.constants.UpdateStatus._timApi2Protocol =
    new Map([[timapi.constants.UpdateStatus.upToDate, "UpToDate"],
        [timapi.constants.UpdateStatus.runningNoReboot, "RunningNoReboot"],
        [timapi.constants.UpdateStatus.runningReboot, "RunningReboot"]]);
timapi.protocol.constants.UpdateStatus._protocol2TimApi =
    new Map([["UpToDate", timapi.constants.UpdateStatus.upToDate],
        ["RunningNoReboot", timapi.constants.UpdateStatus.runningNoReboot],
        ["RunningReboot", timapi.constants.UpdateStatus.runningReboot]]);
timapi.protocol.sixml.AdditionalErrorInfo = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AdditionalErrorInfo) {
        var value = a;
        this.value = value.value;
        this.additionalErrorInfoType = value.additionalErrorInfoType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "AdditionalErrorInfoType")) {
            this.additionalErrorInfoType = this.xmlGetAttribute(node, "AdditionalErrorInfoType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AdditionalErrorInfo.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AdditionalErrorInfo.prototype.value = "";
timapi.protocol.sixml.AdditionalErrorInfo.prototype.additionalErrorInfoType = undefined;
timapi.protocol.sixml.AdditionalErrorInfo.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AdditionalErrorInfo");
    node.textContent = this.value;
    if (this.additionalErrorInfoType != undefined) {
        this.xmlSetAttribute(node, "AdditionalErrorInfoType", this.additionalErrorInfoType);
    }
    return node;
};
timapi.protocol.sixml.AdditionalErrorInfoList = function (a) {
    this.additionalErrorInfo = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AdditionalErrorInfoList) {
        var value = a;
        for (var each of value.additionalErrorInfo) {
            this.additionalErrorInfo.push(each ? new timapi.protocol.sixml.AdditionalErrorInfo(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:AdditionalErrorInfo")) {
            this.additionalErrorInfo.push(new timapi.protocol.sixml.AdditionalErrorInfo(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AdditionalErrorInfoList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AdditionalErrorInfoList.prototype.additionalErrorInfo = undefined;
timapi.protocol.sixml.AdditionalErrorInfoList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AdditionalErrorInfoList");
    for (var each of this.additionalErrorInfo) {
        this.xmlAddChild(node, "sixml:AdditionalErrorInfo", each);
    }
    return node;
};
timapi.protocol.sixml.AdditionalInfoItem = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AdditionalInfoItem) {
        var value = a;
        this.value = value.value;
        this.itemTextcode = value.itemTextcode;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "ItemTextcode")) {
            this.itemTextcode = (this.xmlGetAttribute(node, "ItemTextcode") ? parseInt(this.xmlGetAttribute(node, "ItemTextcode")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AdditionalInfoItem.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AdditionalInfoItem.prototype.value = "";
timapi.protocol.sixml.AdditionalInfoItem.prototype.itemTextcode = undefined;
timapi.protocol.sixml.AdditionalInfoItem.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AdditionalInfoItem");
    node.textContent = this.value;
    if (this.itemTextcode != undefined) {
        this.xmlSetAttribute(node, "ItemTextcode", timapi.utils.StringHelper.makeString(this.itemTextcode));
    }
    return node;
};
timapi.protocol.sixml.AdditionalInfoList = function (a) {
    this.additionalInfoItem = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AdditionalInfoList) {
        var value = a;
        for (var each of value.additionalInfoItem) {
            this.additionalInfoItem.push(each ? new timapi.protocol.sixml.AdditionalInfoItem(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:AdditionalInfoItem")) {
            this.additionalInfoItem.push(new timapi.protocol.sixml.AdditionalInfoItem(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AdditionalInfoList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AdditionalInfoList.prototype.additionalInfoItem = undefined;
timapi.protocol.sixml.AdditionalInfoList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AdditionalInfoList");
    for (var each of this.additionalInfoItem) {
        this.xmlAddChild(node, "sixml:AdditionalInfoItem", each);
    }
    return node;
};
timapi.protocol.sixml.Amount = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Amount) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Amount.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Amount.prototype.value = 0;
timapi.protocol.sixml.Amount.prototype.currency = undefined;
timapi.protocol.sixml.Amount.prototype.exponent = undefined;
timapi.protocol.sixml.Amount.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Amount");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.AmountDcc = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountDcc) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        this.rate = value.rate;
        this.rateExponent = value.rateExponent;
        this.markup = value.markup;
        this.markupExponent = value.markupExponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        if (this.xmlHasAttribute(node, "Rate")) {
            this.rate = (this.xmlGetAttribute(node, "Rate") ? parseInt(this.xmlGetAttribute(node, "Rate")) : 0);
        }
        if (this.xmlHasAttribute(node, "RateExponent")) {
            this.rateExponent = (this.xmlGetAttribute(node, "RateExponent") ? parseInt(this.xmlGetAttribute(node, "RateExponent")) : 0);
        }
        if (this.xmlHasAttribute(node, "Markup")) {
            this.markup = (this.xmlGetAttribute(node, "Markup") ? parseInt(this.xmlGetAttribute(node, "Markup")) : 0);
        }
        if (this.xmlHasAttribute(node, "MarkupExponent")) {
            this.markupExponent = (this.xmlGetAttribute(node, "MarkupExponent") ? parseInt(this.xmlGetAttribute(node, "MarkupExponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountDcc.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountDcc.prototype.value = 0;
timapi.protocol.sixml.AmountDcc.prototype.currency = undefined;
timapi.protocol.sixml.AmountDcc.prototype.exponent = undefined;
timapi.protocol.sixml.AmountDcc.prototype.rate = undefined;
timapi.protocol.sixml.AmountDcc.prototype.rateExponent = undefined;
timapi.protocol.sixml.AmountDcc.prototype.markup = undefined;
timapi.protocol.sixml.AmountDcc.prototype.markupExponent = undefined;
timapi.protocol.sixml.AmountDcc.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountDcc");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    if (this.rate != undefined) {
        this.xmlSetAttribute(node, "Rate", timapi.utils.StringHelper.makeString(this.rate));
    }
    if (this.rateExponent != undefined) {
        this.xmlSetAttribute(node, "RateExponent", timapi.utils.StringHelper.makeString(this.rateExponent));
    }
    if (this.markup != undefined) {
        this.xmlSetAttribute(node, "Markup", timapi.utils.StringHelper.makeString(this.markup));
    }
    if (this.markupExponent != undefined) {
        this.xmlSetAttribute(node, "MarkupExponent", timapi.utils.StringHelper.makeString(this.markupExponent));
    }
    return node;
};
timapi.protocol.sixml.AmountDiscount = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountDiscount) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        this.discountId = value.discountId;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        if (this.xmlHasAttribute(node, "DiscountId")) {
            this.discountId = this.xmlGetAttribute(node, "DiscountId");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountDiscount.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountDiscount.prototype.value = 0;
timapi.protocol.sixml.AmountDiscount.prototype.currency = undefined;
timapi.protocol.sixml.AmountDiscount.prototype.exponent = undefined;
timapi.protocol.sixml.AmountDiscount.prototype.discountId = undefined;
timapi.protocol.sixml.AmountDiscount.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountDiscount");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    if (this.discountId != undefined) {
        this.xmlSetAttribute(node, "DiscountId", this.discountId);
    }
    return node;
};
timapi.protocol.sixml.AmountDue = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountDue) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountDue.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountDue.prototype.value = 0;
timapi.protocol.sixml.AmountDue.prototype.currency = undefined;
timapi.protocol.sixml.AmountDue.prototype.exponent = undefined;
timapi.protocol.sixml.AmountDue.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountDue");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.AmountOther = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountOther) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountOther.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountOther.prototype.value = 0;
timapi.protocol.sixml.AmountOther.prototype.currency = undefined;
timapi.protocol.sixml.AmountOther.prototype.exponent = undefined;
timapi.protocol.sixml.AmountOther.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountOther");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.AmountSaldo = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountSaldo) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountSaldo.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountSaldo.prototype.value = 0;
timapi.protocol.sixml.AmountSaldo.prototype.currency = undefined;
timapi.protocol.sixml.AmountSaldo.prototype.exponent = undefined;
timapi.protocol.sixml.AmountSaldo.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountSaldo");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.AmountTax = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountTax) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountTax.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountTax.prototype.value = 0;
timapi.protocol.sixml.AmountTax.prototype.currency = undefined;
timapi.protocol.sixml.AmountTax.prototype.exponent = undefined;
timapi.protocol.sixml.AmountTax.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountTax");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.AmountTip = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountTip) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountTip.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountTip.prototype.value = 0;
timapi.protocol.sixml.AmountTip.prototype.currency = undefined;
timapi.protocol.sixml.AmountTip.prototype.exponent = undefined;
timapi.protocol.sixml.AmountTip.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountTip");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.AmountTotal = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.AmountTotal) {
        var value = a;
        this.value = value.value;
        this.currency = value.currency;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.AmountTotal.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.AmountTotal.prototype.value = 0;
timapi.protocol.sixml.AmountTotal.prototype.currency = undefined;
timapi.protocol.sixml.AmountTotal.prototype.exponent = undefined;
timapi.protocol.sixml.AmountTotal.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:AmountTotal");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.Application = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Application) {
        var value = a;
        this.aid = value.aid;
        this.applicationLabel = value.applicationLabel;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "Aid")) {
            this.aid = this.xmlGetAttribute(node, "Aid");
        }
        if (this.xmlHasAttribute(node, "ApplicationLabel")) {
            this.applicationLabel = this.xmlGetAttribute(node, "ApplicationLabel");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Application.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Application.prototype.aid = undefined;
timapi.protocol.sixml.Application.prototype.applicationLabel = undefined;
timapi.protocol.sixml.Application.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Application");
    if (this.aid != undefined) {
        this.xmlSetAttribute(node, "Aid", this.aid);
    }
    if (this.applicationLabel != undefined) {
        this.xmlSetAttribute(node, "ApplicationLabel", this.applicationLabel);
    }
    return node;
};
timapi.protocol.sixml.Basket = function (a) {
    this.item = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Basket) {
        var value = a;
        for (var each of value.item) {
            this.item.push(each ? new timapi.protocol.sixml.Item(each) : undefined);
        }
        this.loyaltyAuthResult = value.loyaltyAuthResult;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Item")) {
            this.item.push(new timapi.protocol.sixml.Item(each));
        }
        if (this.xmlHasChild(node, "sixml:LoyaltyAuthResult")) {
            this.loyaltyAuthResult = (this.xmlGetChild(node, "sixml:LoyaltyAuthResult").textContent ? parseInt(this.xmlGetChild(node, "sixml:LoyaltyAuthResult").textContent) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Basket.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Basket.prototype.item = undefined;
timapi.protocol.sixml.Basket.prototype.loyaltyAuthResult = undefined;
timapi.protocol.sixml.Basket.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Basket");
    for (var each of this.item) {
        this.xmlAddChild(node, "sixml:Item", each);
    }
    if (this.loyaltyAuthResult != undefined) {
        this.xmlAddChild(node, "sixml:LoyaltyAuthResult", timapi.utils.StringHelper.makeString(this.loyaltyAuthResult));
    }
    return node;
};
timapi.protocol.sixml.Brand = function (a) {
    this.application = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Brand) {
        var value = a;
        this.brandName = value.brandName;
        this.dccAvailable = value.dccAvailable;
        this.paymentProtocol = value.paymentProtocol;
        this.acqId = value.acqId;
        this.lastInitDate = value.lastInitDate;
        for (var each of value.application) {
            this.application.push(each ? new timapi.protocol.sixml.Application(each) : undefined);
        }
        this.currencyList = value.currencyList ? new timapi.protocol.sixml.CurrencyList(value.currencyList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "BrandName")) {
            this.brandName = this.xmlGetAttribute(node, "BrandName");
        }
        if (this.xmlHasAttribute(node, "DccAvailable")) {
            this.dccAvailable = this.xmlGetAttribute(node, "DccAvailable") == "1";
        }
        if (this.xmlHasAttribute(node, "PaymentProtocol")) {
            this.paymentProtocol = this.xmlGetAttribute(node, "PaymentProtocol");
        }
        if (this.xmlHasAttribute(node, "AcqId")) {
            this.acqId = (this.xmlGetAttribute(node, "AcqId") ? parseInt(this.xmlGetAttribute(node, "AcqId")) : 0);
        }
        if (this.xmlHasAttribute(node, "LastInitDate")) {
            this.lastInitDate = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "LastInitDate"));
        }
        for (var each of this.xmlGetChildren(node, "sixml:Application")) {
            this.application.push(new timapi.protocol.sixml.Application(each));
        }
        if (this.xmlHasChild(node, "sixml:CurrencyList")) {
            this.currencyList = new timapi.protocol.sixml.CurrencyList(this.xmlGetChild(node, "sixml:CurrencyList"));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Brand.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Brand.prototype.brandName = undefined;
timapi.protocol.sixml.Brand.prototype.dccAvailable = undefined;
timapi.protocol.sixml.Brand.prototype.paymentProtocol = undefined;
timapi.protocol.sixml.Brand.prototype.acqId = undefined;
timapi.protocol.sixml.Brand.prototype.lastInitDate = undefined;
timapi.protocol.sixml.Brand.prototype.application = undefined;
timapi.protocol.sixml.Brand.prototype.currencyList = undefined;
timapi.protocol.sixml.Brand.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Brand");
    if (this.brandName != undefined) {
        this.xmlSetAttribute(node, "BrandName", this.brandName);
    }
    if (this.dccAvailable != undefined) {
        this.xmlSetAttribute(node, "DccAvailable", (this.dccAvailable ? "1" : "0"));
    }
    if (this.paymentProtocol != undefined) {
        this.xmlSetAttribute(node, "PaymentProtocol", this.paymentProtocol);
    }
    if (this.acqId != undefined) {
        this.xmlSetAttribute(node, "AcqId", timapi.utils.StringHelper.makeString(this.acqId));
    }
    if (this.lastInitDate != undefined) {
        this.xmlSetAttribute(node, "LastInitDate", this.lastInitDate.format("yyyyMMdd'T'HHmmssZ"));
    }
    for (var each of this.application) {
        this.xmlAddChild(node, "sixml:Application", each);
    }
    if (this.currencyList != undefined) {
        this.xmlAddChild(node, "sixml:CurrencyList", this.currencyList);
    }
    return node;
};
timapi.protocol.sixml.BrandBar = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.BrandBar) {
        var value = a;
        this.value = value.value;
        this.brandMode = value.brandMode;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "BrandMode")) {
            this.brandMode = this.xmlGetAttribute(node, "BrandMode");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.BrandBar.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.BrandBar.prototype.value = "";
timapi.protocol.sixml.BrandBar.prototype.brandMode = undefined;
timapi.protocol.sixml.BrandBar.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:BrandBar");
    node.textContent = this.value;
    if (this.brandMode != undefined) {
        this.xmlSetAttribute(node, "BrandMode", this.brandMode);
    }
    return node;
};
timapi.protocol.sixml.BrandList = function (a) {
    this.brand = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.BrandList) {
        var value = a;
        for (var each of value.brand) {
            this.brand.push(each ? new timapi.protocol.sixml.Brand(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Brand")) {
            this.brand.push(new timapi.protocol.sixml.Brand(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.BrandList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.BrandList.prototype.brand = undefined;
timapi.protocol.sixml.BrandList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:BrandList");
    for (var each of this.brand) {
        this.xmlAddChild(node, "sixml:Brand", each);
    }
    return node;
};
timapi.protocol.sixml.CardData = function (a) {
    this.cardTrackData = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.CardData) {
        var value = a;
        this.posEntryMode = value.posEntryMode;
        this.aid = value.aid;
        this.acc = value.acc;
        this.cardNumber = value.cardNumber;
        this.cardNumberPrintable = value.cardNumberPrintable;
        this.cardNumberPrintableCardholder = value.cardNumberPrintableCardholder;
        this.cardNumberEnc = value.cardNumberEnc;
        this.cardNumberEncKeyIndex = value.cardNumberEncKeyIndex;
        this.cardExpiryDate = value.cardExpiryDate;
        this.brandName = value.brandName;
        this.tenderName = value.tenderName;
        this.cardRef = value.cardRef;
        this.cardCountryCode = value.cardCountryCode;
        this.terminalCountryCode = value.terminalCountryCode;
        this.uid = value.uid;
        for (var each of value.cardTrackData) {
            this.cardTrackData.push(each ? new timapi.protocol.sixml.CardTrackData(each) : undefined);
        }
        this.loyaltyInformationList = value.loyaltyInformationList ? new timapi.protocol.sixml.LoyaltyInformationList(value.loyaltyInformationList) : undefined;
        this.processingDisposition = value.processingDisposition;
        this.cardType = value.cardType;
        this.cardholder = value.cardholder;
        this.language = value.language;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "PosEntryMode")) {
            this.posEntryMode = (this.xmlGetAttribute(node, "PosEntryMode") ? parseInt(this.xmlGetAttribute(node, "PosEntryMode")) : 0);
        }
        if (this.xmlHasAttribute(node, "Aid")) {
            this.aid = this.xmlGetAttribute(node, "Aid");
        }
        if (this.xmlHasAttribute(node, "Acc")) {
            this.acc = this.xmlGetAttribute(node, "Acc");
        }
        if (this.xmlHasAttribute(node, "CardNumber")) {
            this.cardNumber = this.xmlGetAttribute(node, "CardNumber");
        }
        if (this.xmlHasAttribute(node, "CardNumberPrintable")) {
            this.cardNumberPrintable = this.xmlGetAttribute(node, "CardNumberPrintable");
        }
        if (this.xmlHasAttribute(node, "CardNumberPrintableCardholder")) {
            this.cardNumberPrintableCardholder = this.xmlGetAttribute(node, "CardNumberPrintableCardholder");
        }
        if (this.xmlHasAttribute(node, "CardNumberEnc")) {
            this.cardNumberEnc = timapi.ConversionHelper.hexStringToByte(this.xmlGetAttribute(node, "CardNumberEnc"));
        }
        if (this.xmlHasAttribute(node, "CardNumberEncKeyIndex")) {
            this.cardNumberEncKeyIndex = (this.xmlGetAttribute(node, "CardNumberEncKeyIndex") ? parseInt(this.xmlGetAttribute(node, "CardNumberEncKeyIndex")) : 0);
        }
        if (this.xmlHasAttribute(node, "CardExpiryDate")) {
            this.cardExpiryDate = new timapi.protocol.TimeDate("MMyy", this.xmlGetAttribute(node, "CardExpiryDate"));
        }
        if (this.xmlHasAttribute(node, "BrandName")) {
            this.brandName = this.xmlGetAttribute(node, "BrandName");
        }
        if (this.xmlHasAttribute(node, "TenderName")) {
            this.tenderName = this.xmlGetAttribute(node, "TenderName");
        }
        if (this.xmlHasAttribute(node, "CardRef")) {
            this.cardRef = this.xmlGetAttribute(node, "CardRef");
        }
        if (this.xmlHasAttribute(node, "CardCountryCode")) {
            this.cardCountryCode = (this.xmlGetAttribute(node, "CardCountryCode") ? parseInt(this.xmlGetAttribute(node, "CardCountryCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TerminalCountryCode")) {
            this.terminalCountryCode = (this.xmlGetAttribute(node, "TerminalCountryCode") ? parseInt(this.xmlGetAttribute(node, "TerminalCountryCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "Uid")) {
            this.uid = this.xmlGetAttribute(node, "Uid");
        }
        for (var each of this.xmlGetChildren(node, "sixml:CardTrackData")) {
            this.cardTrackData.push(new timapi.protocol.sixml.CardTrackData(each));
        }
        if (this.xmlHasChild(node, "sixml:LoyaltyInformationList")) {
            this.loyaltyInformationList = new timapi.protocol.sixml.LoyaltyInformationList(this.xmlGetChild(node, "sixml:LoyaltyInformationList"));
        }
        if (this.xmlHasAttribute(node, "ProcessingDisposition")) {
            this.processingDisposition = this.xmlGetAttribute(node, "ProcessingDisposition");
        }
        if (this.xmlHasAttribute(node, "CardType")) {
            this.cardType = (this.xmlGetAttribute(node, "CardType") ? parseInt(this.xmlGetAttribute(node, "CardType")) : 0);
        }
        if (this.xmlHasAttribute(node, "Cardholder")) {
            this.cardholder = this.xmlGetAttribute(node, "Cardholder");
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.CardData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.CardData.prototype.posEntryMode = undefined;
timapi.protocol.sixml.CardData.prototype.aid = undefined;
timapi.protocol.sixml.CardData.prototype.acc = undefined;
timapi.protocol.sixml.CardData.prototype.cardNumber = undefined;
timapi.protocol.sixml.CardData.prototype.cardNumberPrintable = undefined;
timapi.protocol.sixml.CardData.prototype.cardNumberPrintableCardholder = undefined;
timapi.protocol.sixml.CardData.prototype.cardNumberEnc = undefined;
timapi.protocol.sixml.CardData.prototype.cardNumberEncKeyIndex = undefined;
timapi.protocol.sixml.CardData.prototype.cardExpiryDate = undefined;
timapi.protocol.sixml.CardData.prototype.brandName = undefined;
timapi.protocol.sixml.CardData.prototype.tenderName = undefined;
timapi.protocol.sixml.CardData.prototype.cardRef = undefined;
timapi.protocol.sixml.CardData.prototype.cardCountryCode = undefined;
timapi.protocol.sixml.CardData.prototype.terminalCountryCode = undefined;
timapi.protocol.sixml.CardData.prototype.uid = undefined;
timapi.protocol.sixml.CardData.prototype.cardTrackData = undefined;
timapi.protocol.sixml.CardData.prototype.loyaltyInformationList = undefined;
timapi.protocol.sixml.CardData.prototype.processingDisposition = undefined;
timapi.protocol.sixml.CardData.prototype.cardType = undefined;
timapi.protocol.sixml.CardData.prototype.cardholder = undefined;
timapi.protocol.sixml.CardData.prototype.language = undefined;
timapi.protocol.sixml.CardData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:CardData");
    if (this.posEntryMode != undefined) {
        this.xmlSetAttribute(node, "PosEntryMode", timapi.utils.StringHelper.makeString(this.posEntryMode));
    }
    if (this.aid != undefined) {
        this.xmlSetAttribute(node, "Aid", this.aid);
    }
    if (this.acc != undefined) {
        this.xmlSetAttribute(node, "Acc", this.acc);
    }
    if (this.cardNumber != undefined) {
        this.xmlSetAttribute(node, "CardNumber", this.cardNumber);
    }
    if (this.cardNumberPrintable != undefined) {
        this.xmlSetAttribute(node, "CardNumberPrintable", this.cardNumberPrintable);
    }
    if (this.cardNumberPrintableCardholder != undefined) {
        this.xmlSetAttribute(node, "CardNumberPrintableCardholder", this.cardNumberPrintableCardholder);
    }
    if (this.cardNumberEnc != undefined) {
        this.xmlSetAttribute(node, "CardNumberEnc", timapi.protocol.ConversionHelper.byteToHexString(this.cardNumberEnc));
    }
    if (this.cardNumberEncKeyIndex != undefined) {
        this.xmlSetAttribute(node, "CardNumberEncKeyIndex", timapi.utils.StringHelper.makeString(this.cardNumberEncKeyIndex));
    }
    if (this.cardExpiryDate != undefined) {
        this.xmlSetAttribute(node, "CardExpiryDate", this.cardExpiryDate.format("MMyy"));
    }
    if (this.brandName != undefined) {
        this.xmlSetAttribute(node, "BrandName", this.brandName);
    }
    if (this.tenderName != undefined) {
        this.xmlSetAttribute(node, "TenderName", this.tenderName);
    }
    if (this.cardRef != undefined) {
        this.xmlSetAttribute(node, "CardRef", this.cardRef);
    }
    if (this.cardCountryCode != undefined) {
        this.xmlSetAttribute(node, "CardCountryCode", timapi.utils.StringHelper.makeString(this.cardCountryCode));
    }
    if (this.terminalCountryCode != undefined) {
        this.xmlSetAttribute(node, "TerminalCountryCode", timapi.utils.StringHelper.makeString(this.terminalCountryCode));
    }
    if (this.uid != undefined) {
        this.xmlSetAttribute(node, "Uid", this.uid);
    }
    for (var each of this.cardTrackData) {
        this.xmlAddChild(node, "sixml:CardTrackData", each);
    }
    if (this.loyaltyInformationList != undefined) {
        this.xmlAddChild(node, "sixml:LoyaltyInformationList", this.loyaltyInformationList);
    }
    if (this.processingDisposition != undefined) {
        this.xmlSetAttribute(node, "ProcessingDisposition", this.processingDisposition);
    }
    if (this.cardType != undefined) {
        this.xmlSetAttribute(node, "CardType", timapi.utils.StringHelper.makeString(this.cardType));
    }
    if (this.cardholder != undefined) {
        this.xmlSetAttribute(node, "Cardholder", this.cardholder);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    return node;
};
timapi.protocol.sixml.CardTrackData = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.CardTrackData) {
        var value = a;
        this.value = value.value;
        this.trackNum = value.trackNum;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "TrackNum")) {
            this.trackNum = (this.xmlGetAttribute(node, "TrackNum") ? parseInt(this.xmlGetAttribute(node, "TrackNum")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.CardTrackData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.CardTrackData.prototype.value = "";
timapi.protocol.sixml.CardTrackData.prototype.trackNum = undefined;
timapi.protocol.sixml.CardTrackData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:CardTrackData");
    node.textContent = this.value;
    if (this.trackNum != undefined) {
        this.xmlSetAttribute(node, "TrackNum", timapi.utils.StringHelper.makeString(this.trackNum));
    }
    return node;
};
timapi.protocol.sixml.ConfigData = function (a) {
    this.receiptHeader = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ConfigData) {
        var value = a;
        for (var each of value.receiptHeader) {
            this.receiptHeader.push(each ? new timapi.protocol.sixml.ReceiptHeader(each) : undefined);
        }
        this.language = value.language;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:ReceiptHeader")) {
            this.receiptHeader.push(new timapi.protocol.sixml.ReceiptHeader(each));
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ConfigData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ConfigData.prototype.receiptHeader = undefined;
timapi.protocol.sixml.ConfigData.prototype.language = undefined;
timapi.protocol.sixml.ConfigData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ConfigData");
    for (var each of this.receiptHeader) {
        this.xmlAddChild(node, "sixml:ReceiptHeader", each);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    return node;
};
timapi.protocol.sixml.Counter = function (a) {
    this.total = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Counter) {
        var value = a;
        this.brandName = value.brandName;
        this.paymentProtocol = value.paymentProtocol;
        this.acqId = value.acqId;
        this.count = value.count;
        this.countDcc = value.countDcc;
        this.countForeign = value.countForeign;
        for (var each of value.total) {
            this.total.push(each ? new timapi.protocol.sixml.Total(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "BrandName")) {
            this.brandName = this.xmlGetAttribute(node, "BrandName");
        }
        if (this.xmlHasAttribute(node, "PaymentProtocol")) {
            this.paymentProtocol = this.xmlGetAttribute(node, "PaymentProtocol");
        }
        if (this.xmlHasAttribute(node, "AcqId")) {
            this.acqId = (this.xmlGetAttribute(node, "AcqId") ? parseInt(this.xmlGetAttribute(node, "AcqId")) : 0);
        }
        if (this.xmlHasAttribute(node, "Count")) {
            this.count = (this.xmlGetAttribute(node, "Count") ? parseInt(this.xmlGetAttribute(node, "Count")) : 0);
        }
        if (this.xmlHasAttribute(node, "CountDcc")) {
            this.countDcc = (this.xmlGetAttribute(node, "CountDcc") ? parseInt(this.xmlGetAttribute(node, "CountDcc")) : 0);
        }
        if (this.xmlHasAttribute(node, "CountForeign")) {
            this.countForeign = (this.xmlGetAttribute(node, "CountForeign") ? parseInt(this.xmlGetAttribute(node, "CountForeign")) : 0);
        }
        for (var each of this.xmlGetChildren(node, "sixml:Total")) {
            this.total.push(new timapi.protocol.sixml.Total(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Counter.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Counter.prototype.brandName = undefined;
timapi.protocol.sixml.Counter.prototype.paymentProtocol = undefined;
timapi.protocol.sixml.Counter.prototype.acqId = undefined;
timapi.protocol.sixml.Counter.prototype.count = undefined;
timapi.protocol.sixml.Counter.prototype.countDcc = undefined;
timapi.protocol.sixml.Counter.prototype.countForeign = undefined;
timapi.protocol.sixml.Counter.prototype.total = undefined;
timapi.protocol.sixml.Counter.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Counter");
    if (this.brandName != undefined) {
        this.xmlSetAttribute(node, "BrandName", this.brandName);
    }
    if (this.paymentProtocol != undefined) {
        this.xmlSetAttribute(node, "PaymentProtocol", this.paymentProtocol);
    }
    if (this.acqId != undefined) {
        this.xmlSetAttribute(node, "AcqId", timapi.utils.StringHelper.makeString(this.acqId));
    }
    if (this.count != undefined) {
        this.xmlSetAttribute(node, "Count", timapi.utils.StringHelper.makeString(this.count));
    }
    if (this.countDcc != undefined) {
        this.xmlSetAttribute(node, "CountDcc", timapi.utils.StringHelper.makeString(this.countDcc));
    }
    if (this.countForeign != undefined) {
        this.xmlSetAttribute(node, "CountForeign", timapi.utils.StringHelper.makeString(this.countForeign));
    }
    for (var each of this.total) {
        this.xmlAddChild(node, "sixml:Total", each);
    }
    return node;
};
timapi.protocol.sixml.Counters = function (a) {
    this.counter = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Counters) {
        var value = a;
        this.counterType = value.counterType;
        this.actSeqCounter = value.actSeqCounter;
        this.periodSeqCounter = value.periodSeqCounter;
        for (var each of value.counter) {
            this.counter.push(each ? new timapi.protocol.sixml.Counter(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "CounterType")) {
            this.counterType = this.xmlGetAttribute(node, "CounterType");
        }
        if (this.xmlHasAttribute(node, "ActSeqCounter")) {
            this.actSeqCounter = (this.xmlGetAttribute(node, "ActSeqCounter") ? parseInt(this.xmlGetAttribute(node, "ActSeqCounter")) : 0);
        }
        if (this.xmlHasAttribute(node, "PeriodSeqCounter")) {
            this.periodSeqCounter = (this.xmlGetAttribute(node, "PeriodSeqCounter") ? parseInt(this.xmlGetAttribute(node, "PeriodSeqCounter")) : 0);
        }
        for (var each of this.xmlGetChildren(node, "sixml:Counter")) {
            this.counter.push(new timapi.protocol.sixml.Counter(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Counters.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Counters.prototype.counterType = undefined;
timapi.protocol.sixml.Counters.prototype.actSeqCounter = undefined;
timapi.protocol.sixml.Counters.prototype.periodSeqCounter = undefined;
timapi.protocol.sixml.Counters.prototype.counter = undefined;
timapi.protocol.sixml.Counters.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Counters");
    if (this.counterType != undefined) {
        this.xmlSetAttribute(node, "CounterType", this.counterType);
    }
    if (this.actSeqCounter != undefined) {
        this.xmlSetAttribute(node, "ActSeqCounter", timapi.utils.StringHelper.makeString(this.actSeqCounter));
    }
    if (this.periodSeqCounter != undefined) {
        this.xmlSetAttribute(node, "PeriodSeqCounter", timapi.utils.StringHelper.makeString(this.periodSeqCounter));
    }
    for (var each of this.counter) {
        this.xmlAddChild(node, "sixml:Counter", each);
    }
    return node;
};
timapi.protocol.sixml.CurrencyItem = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.CurrencyItem) {
        var value = a;
        this.value = value.value;
        this.currencyType = value.currencyType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "CurrencyType")) {
            this.currencyType = this.xmlGetAttribute(node, "CurrencyType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.CurrencyItem.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.CurrencyItem.prototype.value = "";
timapi.protocol.sixml.CurrencyItem.prototype.currencyType = undefined;
timapi.protocol.sixml.CurrencyItem.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:CurrencyItem");
    node.textContent = this.value;
    if (this.currencyType != undefined) {
        this.xmlSetAttribute(node, "CurrencyType", this.currencyType);
    }
    return node;
};
timapi.protocol.sixml.CurrencyList = function (a) {
    this.currencyItem = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.CurrencyList) {
        var value = a;
        for (var each of value.currencyItem) {
            this.currencyItem.push(each ? new timapi.protocol.sixml.CurrencyItem(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:CurrencyItem")) {
            this.currencyItem.push(new timapi.protocol.sixml.CurrencyItem(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.CurrencyList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.CurrencyList.prototype.currencyItem = undefined;
timapi.protocol.sixml.CurrencyList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:CurrencyList");
    for (var each of this.currencyItem) {
        this.xmlAddChild(node, "sixml:CurrencyItem", each);
    }
    return node;
};
timapi.protocol.sixml.DisplayContent = function (a) {
    this.displayLine = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.DisplayContent) {
        var value = a;
        for (var each of value.displayLine) {
            this.displayLine.push(each ? new timapi.protocol.sixml.DisplayLine(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:DisplayLine")) {
            this.displayLine.push(new timapi.protocol.sixml.DisplayLine(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.DisplayContent.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.DisplayContent.prototype.displayLine = undefined;
timapi.protocol.sixml.DisplayContent.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:DisplayContent");
    for (var each of this.displayLine) {
        this.xmlAddChild(node, "sixml:DisplayLine", each);
    }
    return node;
};
timapi.protocol.sixml.DisplayLine = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.DisplayLine) {
        var value = a;
        this.value = value.value;
        this.lineNum = value.lineNum;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "LineNum")) {
            this.lineNum = (this.xmlGetAttribute(node, "LineNum") ? parseInt(this.xmlGetAttribute(node, "LineNum")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.DisplayLine.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.DisplayLine.prototype.value = "";
timapi.protocol.sixml.DisplayLine.prototype.lineNum = undefined;
timapi.protocol.sixml.DisplayLine.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:DisplayLine");
    node.textContent = this.value;
    if (this.lineNum != undefined) {
        this.xmlSetAttribute(node, "LineNum", timapi.utils.StringHelper.makeString(this.lineNum));
    }
    return node;
};
timapi.protocol.sixml.EcrData = function (a) {
    this.ecrInfo = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.EcrData) {
        var value = a;
        for (var each of value.ecrInfo) {
            this.ecrInfo.push(each ? new timapi.protocol.sixml.EcrInfo(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:EcrInfo")) {
            this.ecrInfo.push(new timapi.protocol.sixml.EcrInfo(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.EcrData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.EcrData.prototype.ecrInfo = undefined;
timapi.protocol.sixml.EcrData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:EcrData");
    for (var each of this.ecrInfo) {
        this.xmlAddChild(node, "sixml:EcrInfo", each);
    }
    return node;
};
timapi.protocol.sixml.EcrInfo = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.EcrInfo) {
        var value = a;
        this.ecrInfoType = value.ecrInfoType;
        this.ecrInfoName = value.ecrInfoName;
        this.ecrInfoManufacturerName = value.ecrInfoManufacturerName;
        this.ecrInfoVers = value.ecrInfoVers;
        this.ecrInfoSerialNumber = value.ecrInfoSerialNumber;
        this.ecrInfoArchitecture = value.ecrInfoArchitecture;
        this.remoteIp = value.remoteIp;
        this.integratorSolution = value.integratorSolution;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "EcrInfoType")) {
            this.ecrInfoType = this.xmlGetAttribute(node, "EcrInfoType");
        }
        if (this.xmlHasAttribute(node, "EcrInfoName")) {
            this.ecrInfoName = this.xmlGetAttribute(node, "EcrInfoName");
        }
        if (this.xmlHasAttribute(node, "EcrInfoManufacturerName")) {
            this.ecrInfoManufacturerName = this.xmlGetAttribute(node, "EcrInfoManufacturerName");
        }
        if (this.xmlHasAttribute(node, "EcrInfoVers")) {
            this.ecrInfoVers = this.xmlGetAttribute(node, "EcrInfoVers");
        }
        if (this.xmlHasAttribute(node, "EcrInfoSerialNumber")) {
            this.ecrInfoSerialNumber = this.xmlGetAttribute(node, "EcrInfoSerialNumber");
        }
        if (this.xmlHasAttribute(node, "EcrInfoArchitecture")) {
            this.ecrInfoArchitecture = this.xmlGetAttribute(node, "EcrInfoArchitecture");
        }
        if (this.xmlHasAttribute(node, "RemoteIp")) {
            this.remoteIp = this.xmlGetAttribute(node, "RemoteIp");
        }
        if (this.xmlHasAttribute(node, "IntegratorSolution")) {
            this.integratorSolution = this.xmlGetAttribute(node, "IntegratorSolution");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.EcrInfo.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.EcrInfo.prototype.ecrInfoType = undefined;
timapi.protocol.sixml.EcrInfo.prototype.ecrInfoName = undefined;
timapi.protocol.sixml.EcrInfo.prototype.ecrInfoManufacturerName = undefined;
timapi.protocol.sixml.EcrInfo.prototype.ecrInfoVers = undefined;
timapi.protocol.sixml.EcrInfo.prototype.ecrInfoSerialNumber = undefined;
timapi.protocol.sixml.EcrInfo.prototype.ecrInfoArchitecture = undefined;
timapi.protocol.sixml.EcrInfo.prototype.remoteIp = undefined;
timapi.protocol.sixml.EcrInfo.prototype.integratorSolution = undefined;
timapi.protocol.sixml.EcrInfo.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:EcrInfo");
    if (this.ecrInfoType != undefined) {
        this.xmlSetAttribute(node, "EcrInfoType", this.ecrInfoType);
    }
    if (this.ecrInfoName != undefined) {
        this.xmlSetAttribute(node, "EcrInfoName", this.ecrInfoName);
    }
    if (this.ecrInfoManufacturerName != undefined) {
        this.xmlSetAttribute(node, "EcrInfoManufacturerName", this.ecrInfoManufacturerName);
    }
    if (this.ecrInfoVers != undefined) {
        this.xmlSetAttribute(node, "EcrInfoVers", this.ecrInfoVers);
    }
    if (this.ecrInfoSerialNumber != undefined) {
        this.xmlSetAttribute(node, "EcrInfoSerialNumber", this.ecrInfoSerialNumber);
    }
    if (this.ecrInfoArchitecture != undefined) {
        this.xmlSetAttribute(node, "EcrInfoArchitecture", this.ecrInfoArchitecture);
    }
    if (this.remoteIp != undefined) {
        this.xmlSetAttribute(node, "RemoteIp", this.remoteIp);
    }
    if (this.integratorSolution != undefined) {
        this.xmlSetAttribute(node, "IntegratorSolution", this.integratorSolution);
    }
    return node;
};
timapi.protocol.sixml.Feature = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Feature) {
        var value = a;
        this.value = value.value;
        this.featureType = value.featureType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "FeatureType")) {
            this.featureType = this.xmlGetAttribute(node, "FeatureType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Feature.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Feature.prototype.value = "";
timapi.protocol.sixml.Feature.prototype.featureType = undefined;
timapi.protocol.sixml.Feature.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Feature");
    node.textContent = this.value;
    if (this.featureType != undefined) {
        this.xmlSetAttribute(node, "FeatureType", this.featureType);
    }
    return node;
};
timapi.protocol.sixml.Features = function (a) {
    this.feature = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Features) {
        var value = a;
        for (var each of value.feature) {
            this.feature.push(each ? new timapi.protocol.sixml.Feature(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Feature")) {
            this.feature.push(new timapi.protocol.sixml.Feature(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Features.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Features.prototype.feature = undefined;
timapi.protocol.sixml.Features.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Features");
    for (var each of this.feature) {
        this.xmlAddChild(node, "sixml:Feature", each);
    }
    return node;
};
timapi.protocol.sixml.Hardware = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Hardware) {
        var value = a;
        this.hardwareType = value.hardwareType;
        this.serialNumber = value.serialNumber;
        this.productionDate = value.productionDate;
        this.productVersion = value.productVersion;
        this.firmwareVersion = value.firmwareVersion;
        this.securityStatus = value.securityStatus;
        this.lastCleaningDate = value.lastCleaningDate;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "HardwareType")) {
            this.hardwareType = this.xmlGetAttribute(node, "HardwareType");
        }
        if (this.xmlHasAttribute(node, "SerialNumber")) {
            this.serialNumber = this.xmlGetAttribute(node, "SerialNumber");
        }
        if (this.xmlHasAttribute(node, "ProductionDate")) {
            this.productionDate = new timapi.protocol.TimeDate("yyyyMMdd", this.xmlGetAttribute(node, "ProductionDate"));
        }
        if (this.xmlHasAttribute(node, "ProductVersion")) {
            this.productVersion = this.xmlGetAttribute(node, "ProductVersion");
        }
        if (this.xmlHasAttribute(node, "FirmwareVersion")) {
            this.firmwareVersion = this.xmlGetAttribute(node, "FirmwareVersion");
        }
        if (this.xmlHasAttribute(node, "SecurityStatus")) {
            this.securityStatus = this.xmlGetAttribute(node, "SecurityStatus");
        }
        if (this.xmlHasAttribute(node, "LastCleaningDate")) {
            this.lastCleaningDate = new timapi.protocol.TimeDate("yyyyMMdd", this.xmlGetAttribute(node, "LastCleaningDate"));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Hardware.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Hardware.prototype.hardwareType = undefined;
timapi.protocol.sixml.Hardware.prototype.serialNumber = undefined;
timapi.protocol.sixml.Hardware.prototype.productionDate = undefined;
timapi.protocol.sixml.Hardware.prototype.productVersion = undefined;
timapi.protocol.sixml.Hardware.prototype.firmwareVersion = undefined;
timapi.protocol.sixml.Hardware.prototype.securityStatus = undefined;
timapi.protocol.sixml.Hardware.prototype.lastCleaningDate = undefined;
timapi.protocol.sixml.Hardware.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Hardware");
    if (this.hardwareType != undefined) {
        this.xmlSetAttribute(node, "HardwareType", this.hardwareType);
    }
    if (this.serialNumber != undefined) {
        this.xmlSetAttribute(node, "SerialNumber", this.serialNumber);
    }
    if (this.productionDate != undefined) {
        this.xmlSetAttribute(node, "ProductionDate", this.productionDate.format("yyyyMMdd"));
    }
    if (this.productVersion != undefined) {
        this.xmlSetAttribute(node, "ProductVersion", this.productVersion);
    }
    if (this.firmwareVersion != undefined) {
        this.xmlSetAttribute(node, "FirmwareVersion", this.firmwareVersion);
    }
    if (this.securityStatus != undefined) {
        this.xmlSetAttribute(node, "SecurityStatus", this.securityStatus);
    }
    if (this.lastCleaningDate != undefined) {
        this.xmlSetAttribute(node, "LastCleaningDate", this.lastCleaningDate.format("yyyyMMdd"));
    }
    return node;
};
timapi.protocol.sixml.HardwareList = function (a) {
    this.hardware = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.HardwareList) {
        var value = a;
        for (var each of value.hardware) {
            this.hardware.push(each ? new timapi.protocol.sixml.Hardware(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Hardware")) {
            this.hardware.push(new timapi.protocol.sixml.Hardware(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.HardwareList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.HardwareList.prototype.hardware = undefined;
timapi.protocol.sixml.HardwareList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:HardwareList");
    for (var each of this.hardware) {
        this.xmlAddChild(node, "sixml:Hardware", each);
    }
    return node;
};
timapi.protocol.sixml.Icon = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Icon) {
        var value = a;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Icon.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Icon.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Icon");
    return node;
};
timapi.protocol.sixml.Item = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Item) {
        var value = a;
        this.itemAuthResult = value.itemAuthResult;
        this.itemId = value.itemId;
        this.prodDescription = value.prodDescription;
        this.loyaltyId = value.loyaltyId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountTotal = value.amountTotal ? new timapi.protocol.sixml.AmountTotal(value.amountTotal) : undefined;
        this.amountDiscount = value.amountDiscount ? new timapi.protocol.sixml.AmountDiscount(value.amountDiscount) : undefined;
        this.amountGross = value.amountGross ? new timapi.protocol.sixml.AmountGross(value.amountGross) : undefined;
        this.unitAmountGross = value.unitAmountGross ? new timapi.protocol.sixml.UnitAmountGross(value.unitAmountGross) : undefined;
        this.unitAmountDiscount = value.unitAmountDiscount ? new timapi.protocol.sixml.UnitAmountDiscount(value.unitAmountDiscount) : undefined;
        this.amountTax = value.amountTax ? new timapi.protocol.sixml.AmountTax(value.amountTax) : undefined;
        this.itemQuantity = value.itemQuantity ? new timapi.protocol.sixml.ItemQuantity(value.itemQuantity) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "ItemAuthResult")) {
            this.itemAuthResult = (this.xmlGetAttribute(node, "ItemAuthResult") ? parseInt(this.xmlGetAttribute(node, "ItemAuthResult")) : 0);
        }
        if (this.xmlHasAttribute(node, "ItemId")) {
            this.itemId = this.xmlGetAttribute(node, "ItemId");
        }
        if (this.xmlHasAttribute(node, "ProdDescription")) {
            this.prodDescription = this.xmlGetAttribute(node, "ProdDescription");
        }
        if (this.xmlHasAttribute(node, "LoyaltyId")) {
            this.loyaltyId = this.xmlGetAttribute(node, "LoyaltyId");
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountTotal")) {
            this.amountTotal = new timapi.protocol.sixml.AmountTotal(this.xmlGetChild(node, "sixml:AmountTotal"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDiscount")) {
            this.amountDiscount = new timapi.protocol.sixml.AmountDiscount(this.xmlGetChild(node, "sixml:AmountDiscount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountGross")) {
            this.amountGross = new timapi.protocol.sixml.AmountGross(this.xmlGetChild(node, "sixml:AmountGross"));
        }
        if (this.xmlHasChild(node, "sixml:UnitAmountGross")) {
            this.unitAmountGross = new timapi.protocol.sixml.UnitAmountGross(this.xmlGetChild(node, "sixml:UnitAmountGross"));
        }
        if (this.xmlHasChild(node, "sixml:UnitAmountDiscount")) {
            this.unitAmountDiscount = new timapi.protocol.sixml.UnitAmountDiscount(this.xmlGetChild(node, "sixml:UnitAmountDiscount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountTax")) {
            this.amountTax = new timapi.protocol.sixml.AmountTax(this.xmlGetChild(node, "sixml:AmountTax"));
        }
        if (this.xmlHasChild(node, "sixml:ItemQuantity")) {
            this.itemQuantity = new timapi.protocol.sixml.ItemQuantity(this.xmlGetChild(node, "sixml:ItemQuantity"));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Item.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Item.prototype.itemAuthResult = undefined;
timapi.protocol.sixml.Item.prototype.itemId = undefined;
timapi.protocol.sixml.Item.prototype.prodDescription = undefined;
timapi.protocol.sixml.Item.prototype.loyaltyId = undefined;
timapi.protocol.sixml.Item.prototype.amount = undefined;
timapi.protocol.sixml.Item.prototype.amountTotal = undefined;
timapi.protocol.sixml.Item.prototype.amountDiscount = undefined;
timapi.protocol.sixml.Item.prototype.amountGross = undefined;
timapi.protocol.sixml.Item.prototype.unitAmountGross = undefined;
timapi.protocol.sixml.Item.prototype.unitAmountDiscount = undefined;
timapi.protocol.sixml.Item.prototype.amountTax = undefined;
timapi.protocol.sixml.Item.prototype.itemQuantity = undefined;
timapi.protocol.sixml.Item.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Item");
    if (this.itemAuthResult != undefined) {
        this.xmlSetAttribute(node, "ItemAuthResult", timapi.utils.StringHelper.makeString(this.itemAuthResult));
    }
    if (this.itemId != undefined) {
        this.xmlSetAttribute(node, "ItemId", this.itemId);
    }
    if (this.prodDescription != undefined) {
        this.xmlSetAttribute(node, "ProdDescription", this.prodDescription);
    }
    if (this.loyaltyId != undefined) {
        this.xmlSetAttribute(node, "LoyaltyId", this.loyaltyId);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountTotal != undefined) {
        this.xmlAddChild(node, "sixml:AmountTotal", this.amountTotal);
    }
    if (this.amountDiscount != undefined) {
        this.xmlAddChild(node, "sixml:AmountDiscount", this.amountDiscount);
    }
    if (this.amountGross != undefined) {
        this.xmlAddChild(node, "sixml:AmountGross", this.amountGross);
    }
    if (this.unitAmountGross != undefined) {
        this.xmlAddChild(node, "sixml:UnitAmountGross", this.unitAmountGross);
    }
    if (this.unitAmountDiscount != undefined) {
        this.xmlAddChild(node, "sixml:UnitAmountDiscount", this.unitAmountDiscount);
    }
    if (this.amountTax != undefined) {
        this.xmlAddChild(node, "sixml:AmountTax", this.amountTax);
    }
    if (this.itemQuantity != undefined) {
        this.xmlAddChild(node, "sixml:ItemQuantity", this.itemQuantity);
    }
    return node;
};
timapi.protocol.sixml.ItemQuantity = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ItemQuantity) {
        var value = a;
        this.value = value.value;
        this.itemQuantityType = value.itemQuantityType;
        this.exponent = value.exponent;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = (node.textContent ? parseInt(node.textContent) : 0);
        if (this.xmlHasAttribute(node, "ItemQuantityType")) {
            this.itemQuantityType = this.xmlGetAttribute(node, "ItemQuantityType");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ItemQuantity.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ItemQuantity.prototype.value = 0;
timapi.protocol.sixml.ItemQuantity.prototype.itemQuantityType = undefined;
timapi.protocol.sixml.ItemQuantity.prototype.exponent = undefined;
timapi.protocol.sixml.ItemQuantity.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ItemQuantity");
    node.textContent = timapi.utils.StringHelper.makeString(this.value);
    if (this.itemQuantityType != undefined) {
        this.xmlSetAttribute(node, "ItemQuantityType", this.itemQuantityType);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    return node;
};
timapi.protocol.sixml.KernelVersion = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.KernelVersion) {
        var value = a;
        this.value = value.value;
        this.kernelType = value.kernelType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "KernelType")) {
            this.kernelType = (this.xmlGetAttribute(node, "KernelType") ? parseInt(this.xmlGetAttribute(node, "KernelType")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.KernelVersion.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.KernelVersion.prototype.value = "";
timapi.protocol.sixml.KernelVersion.prototype.kernelType = undefined;
timapi.protocol.sixml.KernelVersion.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:KernelVersion");
    node.textContent = this.value;
    if (this.kernelType != undefined) {
        this.xmlSetAttribute(node, "KernelType", timapi.utils.StringHelper.makeString(this.kernelType));
    }
    return node;
};
timapi.protocol.sixml.KernelVersionList = function (a) {
    this.kernelVersion = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.KernelVersionList) {
        var value = a;
        for (var each of value.kernelVersion) {
            this.kernelVersion.push(each ? new timapi.protocol.sixml.KernelVersion(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:KernelVersion")) {
            this.kernelVersion.push(new timapi.protocol.sixml.KernelVersion(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.KernelVersionList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.KernelVersionList.prototype.kernelVersion = undefined;
timapi.protocol.sixml.KernelVersionList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:KernelVersionList");
    for (var each of this.kernelVersion) {
        this.xmlAddChild(node, "sixml:KernelVersion", each);
    }
    return node;
};
timapi.protocol.sixml.LogOptions = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.LogOptions) {
        var value = a;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.LogOptions.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.LogOptions.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:LogOptions");
    return node;
};
timapi.protocol.sixml.LoyaltyInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.LoyaltyInformation) {
        var value = a;
        this.value = value.value;
        this.loyaltyInfoType = value.loyaltyInfoType;
        this.loyaltyFunctionType = value.loyaltyFunctionType;
        this.loyaltyNumber = value.loyaltyNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = timapi.ConversionHelper.hexStringToByte(node.textContent);
        if (this.xmlHasAttribute(node, "LoyaltyInfoType")) {
            this.loyaltyInfoType = this.xmlGetAttribute(node, "LoyaltyInfoType");
        }
        if (this.xmlHasAttribute(node, "LoyaltyFunctionType")) {
            this.loyaltyFunctionType = this.xmlGetAttribute(node, "LoyaltyFunctionType");
        }
        if (this.xmlHasAttribute(node, "LoyaltyNumber")) {
            this.loyaltyNumber = timapi.ConversionHelper.hexStringToByte(this.xmlGetAttribute(node, "LoyaltyNumber"));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.LoyaltyInformation.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.LoyaltyInformation.prototype.value = new Uint8Array(0);
timapi.protocol.sixml.LoyaltyInformation.prototype.loyaltyInfoType = undefined;
timapi.protocol.sixml.LoyaltyInformation.prototype.loyaltyFunctionType = undefined;
timapi.protocol.sixml.LoyaltyInformation.prototype.loyaltyNumber = undefined;
timapi.protocol.sixml.LoyaltyInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:LoyaltyInformation");
    node.textContent = timapi.protocol.ConversionHelper.byteToHexString(this.value);
    if (this.loyaltyInfoType != undefined) {
        this.xmlSetAttribute(node, "LoyaltyInfoType", this.loyaltyInfoType);
    }
    if (this.loyaltyFunctionType != undefined) {
        this.xmlSetAttribute(node, "LoyaltyFunctionType", this.loyaltyFunctionType);
    }
    if (this.loyaltyNumber != undefined) {
        this.xmlSetAttribute(node, "LoyaltyNumber", timapi.protocol.ConversionHelper.byteToHexString(this.loyaltyNumber));
    }
    return node;
};
timapi.protocol.sixml.LoyaltyInformationList = function (a) {
    this.loyaltyInformation = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.LoyaltyInformationList) {
        var value = a;
        for (var each of value.loyaltyInformation) {
            this.loyaltyInformation.push(each ? new timapi.protocol.sixml.LoyaltyInformation(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:LoyaltyInformation")) {
            this.loyaltyInformation.push(new timapi.protocol.sixml.LoyaltyInformation(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.LoyaltyInformationList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.LoyaltyInformationList.prototype.loyaltyInformation = undefined;
timapi.protocol.sixml.LoyaltyInformationList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:LoyaltyInformationList");
    for (var each of this.loyaltyInformation) {
        this.xmlAddChild(node, "sixml:LoyaltyInformation", each);
    }
    return node;
};
timapi.protocol.sixml.MerchantOption = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.MerchantOption) {
        var value = a;
        this.value = value.value;
        this.merchantOptionType = value.merchantOptionType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "MerchantOptionType")) {
            this.merchantOptionType = this.xmlGetAttribute(node, "MerchantOptionType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.MerchantOption.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.MerchantOption.prototype.value = "";
timapi.protocol.sixml.MerchantOption.prototype.merchantOptionType = undefined;
timapi.protocol.sixml.MerchantOption.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:MerchantOption");
    node.textContent = this.value;
    if (this.merchantOptionType != undefined) {
        this.xmlSetAttribute(node, "MerchantOptionType", this.merchantOptionType);
    }
    return node;
};
timapi.protocol.sixml.MerchantOptionList = function (a) {
    this.merchantOption = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.MerchantOptionList) {
        var value = a;
        for (var each of value.merchantOption) {
            this.merchantOption.push(each ? new timapi.protocol.sixml.MerchantOption(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:MerchantOption")) {
            this.merchantOption.push(new timapi.protocol.sixml.MerchantOption(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.MerchantOptionList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.MerchantOptionList.prototype.merchantOption = undefined;
timapi.protocol.sixml.MerchantOptionList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:MerchantOptionList");
    for (var each of this.merchantOption) {
        this.xmlAddChild(node, "sixml:MerchantOption", each);
    }
    return node;
};
timapi.protocol.sixml.NativeError = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.NativeError) {
        var value = a;
        this.errorCode = value.errorCode;
        this.errorMessage = value.errorMessage;
        this.errorSource = value.errorSource;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "ErrorCode")) {
            this.errorCode = (this.xmlGetAttribute(node, "ErrorCode") ? parseInt(this.xmlGetAttribute(node, "ErrorCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "ErrorMessage")) {
            this.errorMessage = this.xmlGetAttribute(node, "ErrorMessage");
        }
        if (this.xmlHasAttribute(node, "ErrorSource")) {
            this.errorSource = this.xmlGetAttribute(node, "ErrorSource");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.NativeError.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.NativeError.prototype.errorCode = undefined;
timapi.protocol.sixml.NativeError.prototype.errorMessage = undefined;
timapi.protocol.sixml.NativeError.prototype.errorSource = undefined;
timapi.protocol.sixml.NativeError.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:NativeError");
    if (this.errorCode != undefined) {
        this.xmlSetAttribute(node, "ErrorCode", timapi.utils.StringHelper.makeString(this.errorCode));
    }
    if (this.errorMessage != undefined) {
        this.xmlSetAttribute(node, "ErrorMessage", this.errorMessage);
    }
    if (this.errorSource != undefined) {
        this.xmlSetAttribute(node, "ErrorSource", this.errorSource);
    }
    return node;
};
timapi.protocol.sixml.NetworkInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.NetworkInformation) {
        var value = a;
        this.terminalIp = value.terminalIp;
        this.terminalIpMask = value.terminalIpMask;
        this.terminalIpGw = value.terminalIpGw;
        this.terminalIpDns = value.terminalIpDns;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "TerminalIp")) {
            this.terminalIp = this.xmlGetAttribute(node, "TerminalIp");
        }
        if (this.xmlHasAttribute(node, "TerminalIpMask")) {
            this.terminalIpMask = this.xmlGetAttribute(node, "TerminalIpMask");
        }
        if (this.xmlHasAttribute(node, "TerminalIpGw")) {
            this.terminalIpGw = this.xmlGetAttribute(node, "TerminalIpGw");
        }
        if (this.xmlHasAttribute(node, "TerminalIpDns")) {
            this.terminalIpDns = this.xmlGetAttribute(node, "TerminalIpDns");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.NetworkInformation.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.NetworkInformation.prototype.terminalIp = undefined;
timapi.protocol.sixml.NetworkInformation.prototype.terminalIpMask = undefined;
timapi.protocol.sixml.NetworkInformation.prototype.terminalIpGw = undefined;
timapi.protocol.sixml.NetworkInformation.prototype.terminalIpDns = undefined;
timapi.protocol.sixml.NetworkInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:NetworkInformation");
    if (this.terminalIp != undefined) {
        this.xmlSetAttribute(node, "TerminalIp", this.terminalIp);
    }
    if (this.terminalIpMask != undefined) {
        this.xmlSetAttribute(node, "TerminalIpMask", this.terminalIpMask);
    }
    if (this.terminalIpGw != undefined) {
        this.xmlSetAttribute(node, "TerminalIpGw", this.terminalIpGw);
    }
    if (this.terminalIpDns != undefined) {
        this.xmlSetAttribute(node, "TerminalIpDns", this.terminalIpDns);
    }
    return node;
};
timapi.protocol.sixml.Notification = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Notification) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        return;
    }
    if (arguments.length == 0) {
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Notification.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Notification.prototype.functionGroup = undefined;
timapi.protocol.sixml.Notification.prototype.function = undefined;
timapi.protocol.sixml.Notification.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Notification");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    return node;
};
timapi.protocol.sixml.Notification_Cancel = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Notification_Cancel) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.retainCardFlag = value.retainCardFlag;
        this.silentFlag = value.silentFlag;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasChild(node, "sixml:RetainCardFlag")) {
            this.retainCardFlag = this.xmlGetChild(node, "sixml:RetainCardFlag").textContent == "1";
        }
        if (this.xmlHasChild(node, "sixml:SilentFlag")) {
            this.silentFlag = this.xmlGetChild(node, "sixml:SilentFlag").textContent == "1";
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "Cancel";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Notification_Cancel.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Notification_Cancel.prototype.functionGroup = undefined;
timapi.protocol.sixml.Notification_Cancel.prototype.function = undefined;
timapi.protocol.sixml.Notification_Cancel.prototype.retainCardFlag = undefined;
timapi.protocol.sixml.Notification_Cancel.prototype.silentFlag = undefined;
timapi.protocol.sixml.Notification_Cancel.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Notification");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.retainCardFlag != undefined) {
        this.xmlAddChild(node, "sixml:RetainCardFlag", (this.retainCardFlag ? "1" : "0"));
    }
    if (this.silentFlag != undefined) {
        this.xmlAddChild(node, "sixml:SilentFlag", (this.silentFlag ? "1" : "0"));
    }
    return node;
};
timapi.protocol.sixml.Notification_HoldCommit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Notification_HoldCommit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "HoldCommit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Notification_HoldCommit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Notification_HoldCommit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Notification_HoldCommit.prototype.function = undefined;
timapi.protocol.sixml.Notification_HoldCommit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Notification");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    return node;
};
timapi.protocol.sixml.Notification_KeepAlive = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Notification_KeepAlive) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "KeepAlive";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Notification_KeepAlive.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Notification_KeepAlive.prototype.functionGroup = undefined;
timapi.protocol.sixml.Notification_KeepAlive.prototype.function = undefined;
timapi.protocol.sixml.Notification_KeepAlive.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Notification");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    return node;
};
timapi.protocol.sixml.Notification_LicenseChanged = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Notification_LicenseChanged) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.license = value.license;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasChild(node, "sixml:License")) {
            this.license = (this.xmlGetChild(node, "sixml:License").textContent ? parseInt(this.xmlGetChild(node, "sixml:License").textContent) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "LicenseChanged";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Notification_LicenseChanged.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Notification_LicenseChanged.prototype.functionGroup = undefined;
timapi.protocol.sixml.Notification_LicenseChanged.prototype.function = undefined;
timapi.protocol.sixml.Notification_LicenseChanged.prototype.license = undefined;
timapi.protocol.sixml.Notification_LicenseChanged.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Notification");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.license != undefined) {
        this.xmlAddChild(node, "sixml:License", timapi.utils.StringHelper.makeString(this.license));
    }
    return node;
};
timapi.protocol.sixml.Notification_TerminalStatus = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Notification_TerminalStatus) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.displayContent = value.displayContent ? new timapi.protocol.sixml.DisplayContent(value.displayContent) : undefined;
        this.cardReaderStatus = value.cardReaderStatus;
        this.transactionStatus = value.transactionStatus;
        this.connectionStatus = value.connectionStatus;
        this.managementStatus = value.managementStatus;
        this.sleepModeStatus = value.sleepModeStatus;
        this.receiptInformation = value.receiptInformation;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.swUpdateAvailable = value.swUpdateAvailable;
        this.terminalId = value.terminalId;
        this.finalAmount = value.finalAmount ? new timapi.protocol.sixml.FinalAmount(value.finalAmount) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasChild(node, "sixml:DisplayContent")) {
            this.displayContent = new timapi.protocol.sixml.DisplayContent(this.xmlGetChild(node, "sixml:DisplayContent"));
        }
        if (this.xmlHasChild(node, "sixml:CardReaderStatus")) {
            this.cardReaderStatus = this.xmlGetChild(node, "sixml:CardReaderStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:TransactionStatus")) {
            this.transactionStatus = this.xmlGetChild(node, "sixml:TransactionStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ConnectionStatus")) {
            this.connectionStatus = this.xmlGetChild(node, "sixml:ConnectionStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ManagementStatus")) {
            this.managementStatus = this.xmlGetChild(node, "sixml:ManagementStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:SleepModeStatus")) {
            this.sleepModeStatus = this.xmlGetChild(node, "sixml:SleepModeStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ReceiptInformation")) {
            this.receiptInformation = this.xmlGetChild(node, "sixml:ReceiptInformation").textContent == "1";
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:SwUpdateAvailable")) {
            this.swUpdateAvailable = this.xmlGetChild(node, "sixml:SwUpdateAvailable").textContent == "1";
        }
        if (this.xmlHasChild(node, "sixml:TerminalId")) {
            this.terminalId = this.xmlGetChild(node, "sixml:TerminalId").textContent;
        }
        if (this.xmlHasChild(node, "sixml:FinalAmount")) {
            this.finalAmount = new timapi.protocol.sixml.FinalAmount(this.xmlGetChild(node, "sixml:FinalAmount"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "TerminalStatus";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Notification_TerminalStatus.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Notification_TerminalStatus.prototype.functionGroup = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.function = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.displayContent = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.cardReaderStatus = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.transactionStatus = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.connectionStatus = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.managementStatus = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.sleepModeStatus = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.receiptInformation = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.cardData = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.swUpdateAvailable = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.terminalId = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.finalAmount = undefined;
timapi.protocol.sixml.Notification_TerminalStatus.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Notification");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.displayContent != undefined) {
        this.xmlAddChild(node, "sixml:DisplayContent", this.displayContent);
    }
    if (this.cardReaderStatus != undefined) {
        this.xmlAddChild(node, "sixml:CardReaderStatus", this.cardReaderStatus);
    }
    if (this.transactionStatus != undefined) {
        this.xmlAddChild(node, "sixml:TransactionStatus", this.transactionStatus);
    }
    if (this.connectionStatus != undefined) {
        this.xmlAddChild(node, "sixml:ConnectionStatus", this.connectionStatus);
    }
    if (this.managementStatus != undefined) {
        this.xmlAddChild(node, "sixml:ManagementStatus", this.managementStatus);
    }
    if (this.sleepModeStatus != undefined) {
        this.xmlAddChild(node, "sixml:SleepModeStatus", this.sleepModeStatus);
    }
    if (this.receiptInformation != undefined) {
        this.xmlAddChild(node, "sixml:ReceiptInformation", (this.receiptInformation ? "1" : "0"));
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.swUpdateAvailable != undefined) {
        this.xmlAddChild(node, "sixml:SwUpdateAvailable", (this.swUpdateAvailable ? "1" : "0"));
    }
    if (this.terminalId != undefined) {
        this.xmlAddChild(node, "sixml:TerminalId", this.terminalId);
    }
    if (this.finalAmount != undefined) {
        this.xmlAddChild(node, "sixml:FinalAmount", this.finalAmount);
    }
    return node;
};
timapi.protocol.sixml.PlaceholderItem = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.PlaceholderItem) {
        var value = a;
        this.value = value.value;
        this.placeholderNumber = value.placeholderNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "PlaceholderNumber")) {
            this.placeholderNumber = (this.xmlGetAttribute(node, "PlaceholderNumber") ? parseInt(this.xmlGetAttribute(node, "PlaceholderNumber")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.PlaceholderItem.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.PlaceholderItem.prototype.value = "";
timapi.protocol.sixml.PlaceholderItem.prototype.placeholderNumber = undefined;
timapi.protocol.sixml.PlaceholderItem.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:PlaceholderItem");
    node.textContent = this.value;
    if (this.placeholderNumber != undefined) {
        this.xmlSetAttribute(node, "PlaceholderNumber", timapi.utils.StringHelper.makeString(this.placeholderNumber));
    }
    return node;
};
timapi.protocol.sixml.PlaceholderItemList = function (a) {
    this.placeholderItem = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.PlaceholderItemList) {
        var value = a;
        for (var each of value.placeholderItem) {
            this.placeholderItem.push(each ? new timapi.protocol.sixml.PlaceholderItem(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:PlaceholderItem")) {
            this.placeholderItem.push(new timapi.protocol.sixml.PlaceholderItem(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.PlaceholderItemList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.PlaceholderItemList.prototype.placeholderItem = undefined;
timapi.protocol.sixml.PlaceholderItemList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:PlaceholderItemList");
    for (var each of this.placeholderItem) {
        this.xmlAddChild(node, "sixml:PlaceholderItem", each);
    }
    return node;
};
timapi.protocol.sixml.PpInfo = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.PpInfo) {
        var value = a;
        this.paymentProtocol = value.paymentProtocol;
        this.ppEp2transSeqCntOrig = value.ppEp2transSeqCntOrig;
        this.ppEp2transSeqCnt = value.ppEp2transSeqCnt;
        this.ppEp2authReslt = value.ppEp2authReslt;
        this.ppEp2authRespC = value.ppEp2authRespC;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "PaymentProtocol")) {
            this.paymentProtocol = this.xmlGetAttribute(node, "PaymentProtocol");
        }
        if (this.xmlHasAttribute(node, "PpEp2TransSeqCntOrig")) {
            this.ppEp2transSeqCntOrig = (this.xmlGetAttribute(node, "PpEp2TransSeqCntOrig") ? parseInt(this.xmlGetAttribute(node, "PpEp2TransSeqCntOrig")) : 0);
        }
        if (this.xmlHasAttribute(node, "PpEp2TransSeqCnt")) {
            this.ppEp2transSeqCnt = (this.xmlGetAttribute(node, "PpEp2TransSeqCnt") ? parseInt(this.xmlGetAttribute(node, "PpEp2TransSeqCnt")) : 0);
        }
        if (this.xmlHasAttribute(node, "PpEp2AuthReslt")) {
            this.ppEp2authReslt = (this.xmlGetAttribute(node, "PpEp2AuthReslt") ? parseInt(this.xmlGetAttribute(node, "PpEp2AuthReslt")) : 0);
        }
        if (this.xmlHasAttribute(node, "PpEp2AuthRespC")) {
            this.ppEp2authRespC = this.xmlGetAttribute(node, "PpEp2AuthRespC");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.PpInfo.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.PpInfo.prototype.paymentProtocol = undefined;
timapi.protocol.sixml.PpInfo.prototype.ppEp2transSeqCntOrig = undefined;
timapi.protocol.sixml.PpInfo.prototype.ppEp2transSeqCnt = undefined;
timapi.protocol.sixml.PpInfo.prototype.ppEp2authReslt = undefined;
timapi.protocol.sixml.PpInfo.prototype.ppEp2authRespC = undefined;
timapi.protocol.sixml.PpInfo.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:PpInfo");
    if (this.paymentProtocol != undefined) {
        this.xmlSetAttribute(node, "PaymentProtocol", this.paymentProtocol);
    }
    if (this.ppEp2transSeqCntOrig != undefined) {
        this.xmlSetAttribute(node, "PpEp2TransSeqCntOrig", timapi.utils.StringHelper.makeString(this.ppEp2transSeqCntOrig));
    }
    if (this.ppEp2transSeqCnt != undefined) {
        this.xmlSetAttribute(node, "PpEp2TransSeqCnt", timapi.utils.StringHelper.makeString(this.ppEp2transSeqCnt));
    }
    if (this.ppEp2authReslt != undefined) {
        this.xmlSetAttribute(node, "PpEp2AuthReslt", timapi.utils.StringHelper.makeString(this.ppEp2authReslt));
    }
    if (this.ppEp2authRespC != undefined) {
        this.xmlSetAttribute(node, "PpEp2AuthRespC", this.ppEp2authRespC);
    }
    return node;
};
timapi.protocol.sixml.PrintData = function (a) {
    this.receipt = [];
    this.receiptItems = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.PrintData) {
        var value = a;
        for (var each of value.receipt) {
            this.receipt.push(each ? new timapi.protocol.sixml.Receipt(each) : undefined);
        }
        for (var each of value.receiptItems) {
            this.receiptItems.push(each ? new timapi.protocol.sixml.ReceiptItems(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Receipt")) {
            this.receipt.push(new timapi.protocol.sixml.Receipt(each));
        }
        for (var each of this.xmlGetChildren(node, "sixml:ReceiptItems")) {
            this.receiptItems.push(new timapi.protocol.sixml.ReceiptItems(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.PrintData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.PrintData.prototype.receipt = undefined;
timapi.protocol.sixml.PrintData.prototype.receiptItems = undefined;
timapi.protocol.sixml.PrintData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:PrintData");
    for (var each of this.receipt) {
        this.xmlAddChild(node, "sixml:Receipt", each);
    }
    for (var each of this.receiptItems) {
        this.xmlAddChild(node, "sixml:ReceiptItems", each);
    }
    return node;
};
timapi.protocol.sixml.PrintOptionList = function (a) {
    this.printOptions = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.PrintOptionList) {
        var value = a;
        for (var each of value.printOptions) {
            this.printOptions.push(each ? new timapi.protocol.sixml.PrintOptions(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:PrintOptions")) {
            this.printOptions.push(new timapi.protocol.sixml.PrintOptions(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.PrintOptionList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.PrintOptionList.prototype.printOptions = undefined;
timapi.protocol.sixml.PrintOptionList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:PrintOptionList");
    for (var each of this.printOptions) {
        this.xmlAddChild(node, "sixml:PrintOptions", each);
    }
    return node;
};
timapi.protocol.sixml.PrintOptions = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.PrintOptions) {
        var value = a;
        this.recipient = value.recipient;
        this.printFormat = value.printFormat;
        this.printWidth = value.printWidth;
        this.printFlags = value.printFlags;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "Recipient")) {
            this.recipient = this.xmlGetAttribute(node, "Recipient");
        }
        if (this.xmlHasAttribute(node, "PrintFormat")) {
            this.printFormat = this.xmlGetAttribute(node, "PrintFormat");
        }
        if (this.xmlHasAttribute(node, "PrintWidth")) {
            this.printWidth = (this.xmlGetAttribute(node, "PrintWidth") ? parseInt(this.xmlGetAttribute(node, "PrintWidth")) : 0);
        }
        if (this.xmlHasAttribute(node, "PrintFlags")) {
            this.printFlags = (this.xmlGetAttribute(node, "PrintFlags") ? parseInt(this.xmlGetAttribute(node, "PrintFlags")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.PrintOptions.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.PrintOptions.prototype.recipient = undefined;
timapi.protocol.sixml.PrintOptions.prototype.printFormat = undefined;
timapi.protocol.sixml.PrintOptions.prototype.printWidth = undefined;
timapi.protocol.sixml.PrintOptions.prototype.printFlags = undefined;
timapi.protocol.sixml.PrintOptions.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:PrintOptions");
    if (this.recipient != undefined) {
        this.xmlSetAttribute(node, "Recipient", this.recipient);
    }
    if (this.printFormat != undefined) {
        this.xmlSetAttribute(node, "PrintFormat", this.printFormat);
    }
    if (this.printWidth != undefined) {
        this.xmlSetAttribute(node, "PrintWidth", timapi.utils.StringHelper.makeString(this.printWidth));
    }
    if (this.printFlags != undefined) {
        this.xmlSetAttribute(node, "PrintFlags", timapi.utils.StringHelper.makeString(this.printFlags));
    }
    return node;
};
timapi.protocol.sixml.ProtocolOption = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ProtocolOption) {
        var value = a;
        this.value = value.value;
        this.optionType = value.optionType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "OptionType")) {
            this.optionType = this.xmlGetAttribute(node, "OptionType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ProtocolOption.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ProtocolOption.prototype.value = "";
timapi.protocol.sixml.ProtocolOption.prototype.optionType = undefined;
timapi.protocol.sixml.ProtocolOption.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ProtocolOption");
    node.textContent = this.value;
    if (this.optionType != undefined) {
        this.xmlSetAttribute(node, "OptionType", this.optionType);
    }
    return node;
};
timapi.protocol.sixml.ProtocolOptionList = function (a) {
    this.protocolOption = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ProtocolOptionList) {
        var value = a;
        for (var each of value.protocolOption) {
            this.protocolOption.push(each ? new timapi.protocol.sixml.ProtocolOption(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:ProtocolOption")) {
            this.protocolOption.push(new timapi.protocol.sixml.ProtocolOption(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ProtocolOptionList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ProtocolOptionList.prototype.protocolOption = undefined;
timapi.protocol.sixml.ProtocolOptionList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ProtocolOptionList");
    for (var each of this.protocolOption) {
        this.xmlAddChild(node, "sixml:ProtocolOption", each);
    }
    return node;
};
timapi.protocol.sixml.Receipt = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Receipt) {
        var value = a;
        this.value = value.value;
        this.recipient = value.recipient;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "Recipient")) {
            this.recipient = this.xmlGetAttribute(node, "Recipient");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Receipt.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Receipt.prototype.value = "";
timapi.protocol.sixml.Receipt.prototype.recipient = undefined;
timapi.protocol.sixml.Receipt.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Receipt");
    node.textContent = this.value;
    if (this.recipient != undefined) {
        this.xmlSetAttribute(node, "Recipient", this.recipient);
    }
    return node;
};
timapi.protocol.sixml.ReceiptHeader = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ReceiptHeader) {
        var value = a;
        this.value = value.value;
        this.lineNum = value.lineNum;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "LineNum")) {
            this.lineNum = (this.xmlGetAttribute(node, "LineNum") ? parseInt(this.xmlGetAttribute(node, "LineNum")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ReceiptHeader.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ReceiptHeader.prototype.value = "";
timapi.protocol.sixml.ReceiptHeader.prototype.lineNum = undefined;
timapi.protocol.sixml.ReceiptHeader.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ReceiptHeader");
    node.textContent = this.value;
    if (this.lineNum != undefined) {
        this.xmlSetAttribute(node, "LineNum", timapi.utils.StringHelper.makeString(this.lineNum));
    }
    return node;
};
timapi.protocol.sixml.ReceiptItem = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ReceiptItem) {
        var value = a;
        this.value = value.value;
        this.receiptItemType = value.receiptItemType;
        this.recipient = value.recipient;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "ReceiptItemType")) {
            this.receiptItemType = this.xmlGetAttribute(node, "ReceiptItemType");
        }
        if (this.xmlHasAttribute(node, "Recipient")) {
            this.recipient = this.xmlGetAttribute(node, "Recipient");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ReceiptItem.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ReceiptItem.prototype.value = "";
timapi.protocol.sixml.ReceiptItem.prototype.receiptItemType = undefined;
timapi.protocol.sixml.ReceiptItem.prototype.recipient = undefined;
timapi.protocol.sixml.ReceiptItem.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ReceiptItem");
    node.textContent = this.value;
    if (this.receiptItemType != undefined) {
        this.xmlSetAttribute(node, "ReceiptItemType", this.receiptItemType);
    }
    if (this.recipient != undefined) {
        this.xmlSetAttribute(node, "Recipient", this.recipient);
    }
    return node;
};
timapi.protocol.sixml.ReceiptItems = function (a) {
    this.receiptItem = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ReceiptItems) {
        var value = a;
        this.receiptType = value.receiptType;
        for (var each of value.receiptItem) {
            this.receiptItem.push(each ? new timapi.protocol.sixml.ReceiptItem(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "ReceiptType")) {
            this.receiptType = this.xmlGetAttribute(node, "ReceiptType");
        }
        for (var each of this.xmlGetChildren(node, "sixml:ReceiptItem")) {
            this.receiptItem.push(new timapi.protocol.sixml.ReceiptItem(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ReceiptItems.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ReceiptItems.prototype.receiptType = undefined;
timapi.protocol.sixml.ReceiptItems.prototype.receiptItem = undefined;
timapi.protocol.sixml.ReceiptItems.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ReceiptItems");
    if (this.receiptType != undefined) {
        this.xmlSetAttribute(node, "ReceiptType", this.receiptType);
    }
    for (var each of this.receiptItem) {
        this.xmlAddChild(node, "sixml:ReceiptItem", each);
    }
    return node;
};
timapi.protocol.sixml.Request = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.repeat = value.repeat;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "Repeat")) {
            this.repeat = (this.xmlGetAttribute(node, "Repeat") ? parseInt(this.xmlGetAttribute(node, "Repeat")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request.prototype.function = undefined;
timapi.protocol.sixml.Request.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request.prototype.repeat = undefined;
timapi.protocol.sixml.Request.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.repeat != undefined) {
        this.xmlSetAttribute(node, "Repeat", timapi.utils.StringHelper.makeString(this.repeat));
    }
    return node;
};
timapi.protocol.sixml.Request_Activate = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Activate) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Activate";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Activate.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Activate.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Activate.prototype.function = undefined;
timapi.protocol.sixml.Request_Activate.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Activate.prototype.usrId = undefined;
timapi.protocol.sixml.Request_Activate.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    return node;
};
timapi.protocol.sixml.Request_ActivateServiceMenu = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_ActivateServiceMenu) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "ActivateServiceMenu";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_ActivateServiceMenu.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_ActivateServiceMenu.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_ActivateServiceMenu.prototype.function = undefined;
timapi.protocol.sixml.Request_ActivateServiceMenu.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_ActivateServiceMenu.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_AdjustReservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_AdjustReservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "AdjustReservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_AdjustReservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_AdjustReservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_AdjustReservation.prototype.function = undefined;
timapi.protocol.sixml.Request_AdjustReservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_AdjustReservation.prototype.amount = undefined;
timapi.protocol.sixml.Request_AdjustReservation.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_AdjustReservation.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_AdjustReservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_ApplicationInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_ApplicationInformation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "ApplicationInformation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_ApplicationInformation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_ApplicationInformation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_ApplicationInformation.prototype.function = undefined;
timapi.protocol.sixml.Request_ApplicationInformation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_ApplicationInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_AuthorizeCredit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_AuthorizeCredit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "AuthorizeCredit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_AuthorizeCredit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.function = undefined;
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.amount = undefined;
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_AuthorizeCredit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_AuthorizeDeposit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_AuthorizeDeposit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "AuthorizeDeposit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.function = undefined;
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.amount = undefined;
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_AuthorizeDeposit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Balance = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Balance) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Balance";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Balance.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Balance.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Balance.prototype.function = undefined;
timapi.protocol.sixml.Request_Balance.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Balance.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_BalanceInquiry = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_BalanceInquiry) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.language = value.language;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "BalanceInquiry";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_BalanceInquiry.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_BalanceInquiry.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_BalanceInquiry.prototype.function = undefined;
timapi.protocol.sixml.Request_BalanceInquiry.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_BalanceInquiry.prototype.language = undefined;
timapi.protocol.sixml.Request_BalanceInquiry.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    return node;
};
timapi.protocol.sixml.Request_CancelReservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CancelReservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "CancelReservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CancelReservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CancelReservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CancelReservation.prototype.function = undefined;
timapi.protocol.sixml.Request_CancelReservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CancelReservation.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_CancelReservation.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_CancelReservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_CashAdvance = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CashAdvance) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "CashAdvance";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CashAdvance.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CashAdvance.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.function = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.usrId = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.amount = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_CashAdvance.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_ChangeSettings = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_ChangeSettings) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.settingsList = value.settingsList ? new timapi.protocol.sixml.SettingsList(value.settingsList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:SettingsList")) {
            this.settingsList = new timapi.protocol.sixml.SettingsList(this.xmlGetChild(node, "sixml:SettingsList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "ChangeSettings";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_ChangeSettings.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_ChangeSettings.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_ChangeSettings.prototype.function = undefined;
timapi.protocol.sixml.Request_ChangeSettings.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_ChangeSettings.prototype.settingsList = undefined;
timapi.protocol.sixml.Request_ChangeSettings.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.settingsList != undefined) {
        this.xmlAddChild(node, "sixml:SettingsList", this.settingsList);
    }
    return node;
};
timapi.protocol.sixml.Request_CloseDialogMode = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CloseDialogMode) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CloseDialogMode";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CloseDialogMode.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CloseDialogMode.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CloseDialogMode.prototype.function = undefined;
timapi.protocol.sixml.Request_CloseDialogMode.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CloseDialogMode.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_CloseMaintenanceWindow = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CloseMaintenanceWindow) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CloseMaintenanceWindow";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CloseMaintenanceWindow.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CloseMaintenanceWindow.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CloseMaintenanceWindow.prototype.function = undefined;
timapi.protocol.sixml.Request_CloseMaintenanceWindow.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CloseMaintenanceWindow.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_CloseReader = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CloseReader) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CloseReader";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CloseReader.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CloseReader.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CloseReader.prototype.function = undefined;
timapi.protocol.sixml.Request_CloseReader.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CloseReader.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_CollectPoints = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CollectPoints) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "CollectPoints";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CollectPoints.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CollectPoints.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CollectPoints.prototype.function = undefined;
timapi.protocol.sixml.Request_CollectPoints.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CollectPoints.prototype.amount = undefined;
timapi.protocol.sixml.Request_CollectPoints.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_CollectPoints.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_CollectPoints.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Combined = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Combined) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountOther = value.amountOther ? new timapi.protocol.sixml.AmountOther(value.amountOther) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountOther")) {
            this.amountOther = new timapi.protocol.sixml.AmountOther(this.xmlGetChild(node, "sixml:AmountOther"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Combined";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Combined.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Combined.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Combined.prototype.function = undefined;
timapi.protocol.sixml.Request_Combined.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Combined.prototype.amount = undefined;
timapi.protocol.sixml.Request_Combined.prototype.amountOther = undefined;
timapi.protocol.sixml.Request_Combined.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_Combined.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_Combined.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountOther != undefined) {
        this.xmlAddChild(node, "sixml:AmountOther", this.amountOther);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Commit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Commit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.repeat = value.repeat;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "Repeat")) {
            this.repeat = (this.xmlGetAttribute(node, "Repeat") ? parseInt(this.xmlGetAttribute(node, "Repeat")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Commit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Commit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Commit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Commit.prototype.function = undefined;
timapi.protocol.sixml.Request_Commit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Commit.prototype.repeat = undefined;
timapi.protocol.sixml.Request_Commit.prototype.amount = undefined;
timapi.protocol.sixml.Request_Commit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.repeat != undefined) {
        this.xmlSetAttribute(node, "Repeat", timapi.utils.StringHelper.makeString(this.repeat));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    return node;
};
timapi.protocol.sixml.Request_CounterRequest = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_CounterRequest) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.counterType = value.counterType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:CounterType")) {
            this.counterType = this.xmlGetChild(node, "sixml:CounterType").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CounterRequest";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_CounterRequest.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_CounterRequest.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_CounterRequest.prototype.function = undefined;
timapi.protocol.sixml.Request_CounterRequest.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_CounterRequest.prototype.counterType = undefined;
timapi.protocol.sixml.Request_CounterRequest.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.counterType != undefined) {
        this.xmlAddChild(node, "sixml:CounterType", this.counterType);
    }
    return node;
};
timapi.protocol.sixml.Request_Credit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Credit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Credit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Credit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Credit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Credit.prototype.function = undefined;
timapi.protocol.sixml.Request_Credit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Credit.prototype.usrId = undefined;
timapi.protocol.sixml.Request_Credit.prototype.amount = undefined;
timapi.protocol.sixml.Request_Credit.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_Credit.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_Credit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_DccRates = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_DccRates) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "DccRates";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_DccRates.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_DccRates.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_DccRates.prototype.function = undefined;
timapi.protocol.sixml.Request_DccRates.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_DccRates.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_Deactivate = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Deactivate) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Deactivate";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Deactivate.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Deactivate.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Deactivate.prototype.function = undefined;
timapi.protocol.sixml.Request_Deactivate.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Deactivate.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_EjectCard = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_EjectCard) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "EjectCard";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_EjectCard.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_EjectCard.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_EjectCard.prototype.function = undefined;
timapi.protocol.sixml.Request_EjectCard.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_EjectCard.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_FeatureRequest = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_FeatureRequest) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "FeatureRequest";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_FeatureRequest.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_FeatureRequest.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_FeatureRequest.prototype.function = undefined;
timapi.protocol.sixml.Request_FeatureRequest.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_FeatureRequest.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_FinalizePurchase = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_FinalizePurchase) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.basket = value.basket ? new timapi.protocol.sixml.Basket(value.basket) : undefined;
        this.additionalInfoList = value.additionalInfoList ? new timapi.protocol.sixml.AdditionalInfoList(value.additionalInfoList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:Basket")) {
            this.basket = new timapi.protocol.sixml.Basket(this.xmlGetChild(node, "sixml:Basket"));
        }
        if (this.xmlHasChild(node, "sixml:AdditionalInfoList")) {
            this.additionalInfoList = new timapi.protocol.sixml.AdditionalInfoList(this.xmlGetChild(node, "sixml:AdditionalInfoList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "FinalizePurchase";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_FinalizePurchase.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_FinalizePurchase.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.function = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.amount = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.basket = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.additionalInfoList = undefined;
timapi.protocol.sixml.Request_FinalizePurchase.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.basket != undefined) {
        this.xmlAddChild(node, "sixml:Basket", this.basket);
    }
    if (this.additionalInfoList != undefined) {
        this.xmlAddChild(node, "sixml:AdditionalInfoList", this.additionalInfoList);
    }
    return node;
};
timapi.protocol.sixml.Request_Giro = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Giro) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.language = value.language;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Giro";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Giro.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Giro.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Giro.prototype.function = undefined;
timapi.protocol.sixml.Request_Giro.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Giro.prototype.amount = undefined;
timapi.protocol.sixml.Request_Giro.prototype.language = undefined;
timapi.protocol.sixml.Request_Giro.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_Giro.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_Giro.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_HardwareInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_HardwareInformation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "HardwareInformation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_HardwareInformation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_HardwareInformation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_HardwareInformation.prototype.function = undefined;
timapi.protocol.sixml.Request_HardwareInformation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_HardwareInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_InitTransaction = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_InitTransaction) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.displayAmountFlag = value.displayAmountFlag;
        this.language = value.language;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:DisplayAmountFlag")) {
            this.displayAmountFlag = this.xmlGetChild(node, "sixml:DisplayAmountFlag").textContent == "1";
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "InitTransaction";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_InitTransaction.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_InitTransaction.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_InitTransaction.prototype.function = undefined;
timapi.protocol.sixml.Request_InitTransaction.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_InitTransaction.prototype.amount = undefined;
timapi.protocol.sixml.Request_InitTransaction.prototype.displayAmountFlag = undefined;
timapi.protocol.sixml.Request_InitTransaction.prototype.language = undefined;
timapi.protocol.sixml.Request_InitTransaction.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.displayAmountFlag != undefined) {
        this.xmlAddChild(node, "sixml:DisplayAmountFlag", (this.displayAmountFlag ? "1" : "0"));
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    return node;
};
timapi.protocol.sixml.Request_LoadVoucher = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_LoadVoucher) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "LoadVoucher";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_LoadVoucher.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_LoadVoucher.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_LoadVoucher.prototype.function = undefined;
timapi.protocol.sixml.Request_LoadVoucher.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_LoadVoucher.prototype.amount = undefined;
timapi.protocol.sixml.Request_LoadVoucher.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_LoadVoucher.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_LoadVoucher.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Login = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Login) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.posId = value.posId;
        this.integratorId = value.integratorId;
        this.protocolOptionList = value.protocolOptionList ? new timapi.protocol.sixml.ProtocolOptionList(value.protocolOptionList) : undefined;
        this.printOptionList = value.printOptionList ? new timapi.protocol.sixml.PrintOptionList(value.printOptionList) : undefined;
        this.manufacturerFlags = value.manufacturerFlags;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:PosId")) {
            this.posId = this.xmlGetChild(node, "sixml:PosId").textContent;
        }
        if (this.xmlHasChild(node, "sixml:IntegratorId")) {
            this.integratorId = this.xmlGetChild(node, "sixml:IntegratorId").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ProtocolOptionList")) {
            this.protocolOptionList = new timapi.protocol.sixml.ProtocolOptionList(this.xmlGetChild(node, "sixml:ProtocolOptionList"));
        }
        if (this.xmlHasChild(node, "sixml:PrintOptionList")) {
            this.printOptionList = new timapi.protocol.sixml.PrintOptionList(this.xmlGetChild(node, "sixml:PrintOptionList"));
        }
        if (this.xmlHasChild(node, "sixml:ManufacturerFlags")) {
            this.manufacturerFlags = (this.xmlGetChild(node, "sixml:ManufacturerFlags").textContent ? parseInt(this.xmlGetChild(node, "sixml:ManufacturerFlags").textContent) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Login";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Login.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Login.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Login.prototype.function = undefined;
timapi.protocol.sixml.Request_Login.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Login.prototype.posId = undefined;
timapi.protocol.sixml.Request_Login.prototype.integratorId = undefined;
timapi.protocol.sixml.Request_Login.prototype.protocolOptionList = undefined;
timapi.protocol.sixml.Request_Login.prototype.printOptionList = undefined;
timapi.protocol.sixml.Request_Login.prototype.manufacturerFlags = undefined;
timapi.protocol.sixml.Request_Login.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.posId != undefined) {
        this.xmlAddChild(node, "sixml:PosId", this.posId);
    }
    if (this.integratorId != undefined) {
        this.xmlAddChild(node, "sixml:IntegratorId", this.integratorId);
    }
    if (this.protocolOptionList != undefined) {
        this.xmlAddChild(node, "sixml:ProtocolOptionList", this.protocolOptionList);
    }
    if (this.printOptionList != undefined) {
        this.xmlAddChild(node, "sixml:PrintOptionList", this.printOptionList);
    }
    if (this.manufacturerFlags != undefined) {
        this.xmlAddChild(node, "sixml:ManufacturerFlags", timapi.utils.StringHelper.makeString(this.manufacturerFlags));
    }
    return node;
};
timapi.protocol.sixml.Request_Logout = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Logout) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Logout";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Logout.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Logout.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Logout.prototype.function = undefined;
timapi.protocol.sixml.Request_Logout.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Logout.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_OpenDialogMode = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_OpenDialogMode) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "OpenDialogMode";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_OpenDialogMode.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_OpenDialogMode.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_OpenDialogMode.prototype.function = undefined;
timapi.protocol.sixml.Request_OpenDialogMode.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_OpenDialogMode.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_OpenMaintenanceWindow = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_OpenMaintenanceWindow) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "OpenMaintenanceWindow";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_OpenMaintenanceWindow.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_OpenMaintenanceWindow.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_OpenMaintenanceWindow.prototype.function = undefined;
timapi.protocol.sixml.Request_OpenMaintenanceWindow.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_OpenMaintenanceWindow.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_OpenReader = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_OpenReader) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "OpenReader";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_OpenReader.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_OpenReader.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_OpenReader.prototype.function = undefined;
timapi.protocol.sixml.Request_OpenReader.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_OpenReader.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_PreAuthorization = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_PreAuthorization) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.language = value.language;
        this.retainCardFlag = value.retainCardFlag;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        if (this.xmlHasChild(node, "sixml:RetainCardFlag")) {
            this.retainCardFlag = this.xmlGetChild(node, "sixml:RetainCardFlag").textContent == "1";
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PreAuthorization";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_PreAuthorization.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_PreAuthorization.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.function = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.usrId = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.amount = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.language = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.retainCardFlag = undefined;
timapi.protocol.sixml.Request_PreAuthorization.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    if (this.retainCardFlag != undefined) {
        this.xmlAddChild(node, "sixml:RetainCardFlag", (this.retainCardFlag ? "1" : "0"));
    }
    return node;
};
timapi.protocol.sixml.Request_Purchase = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Purchase) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        this.basket = value.basket ? new timapi.protocol.sixml.Basket(value.basket) : undefined;
        this.language = value.language;
        this.amountTip = value.amountTip ? new timapi.protocol.sixml.AmountTip(value.amountTip) : undefined;
        this.loyaltyCouponList = value.loyaltyCouponList ? new timapi.protocol.sixml.LoyaltyCouponList(value.loyaltyCouponList) : undefined;
        this.amountDiscount = value.amountDiscount ? new timapi.protocol.sixml.AmountDiscount(value.amountDiscount) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        if (this.xmlHasChild(node, "sixml:Basket")) {
            this.basket = new timapi.protocol.sixml.Basket(this.xmlGetChild(node, "sixml:Basket"));
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        if (this.xmlHasChild(node, "sixml:AmountTip")) {
            this.amountTip = new timapi.protocol.sixml.AmountTip(this.xmlGetChild(node, "sixml:AmountTip"));
        }
        if (this.xmlHasChild(node, "sixml:LoyaltyCouponList")) {
            this.loyaltyCouponList = new timapi.protocol.sixml.LoyaltyCouponList(this.xmlGetChild(node, "sixml:LoyaltyCouponList"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDiscount")) {
            this.amountDiscount = new timapi.protocol.sixml.AmountDiscount(this.xmlGetChild(node, "sixml:AmountDiscount"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Purchase";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Purchase.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Purchase.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.function = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.usrId = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.amount = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.basket = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.language = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.amountTip = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.loyaltyCouponList = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.amountDiscount = undefined;
timapi.protocol.sixml.Request_Purchase.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    if (this.basket != undefined) {
        this.xmlAddChild(node, "sixml:Basket", this.basket);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    if (this.amountTip != undefined) {
        this.xmlAddChild(node, "sixml:AmountTip", this.amountTip);
    }
    if (this.loyaltyCouponList != undefined) {
        this.xmlAddChild(node, "sixml:LoyaltyCouponList", this.loyaltyCouponList);
    }
    if (this.amountDiscount != undefined) {
        this.xmlAddChild(node, "sixml:AmountDiscount", this.amountDiscount);
    }
    return node;
};
timapi.protocol.sixml.Request_PurchaseForcedAcceptance = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_PurchaseForcedAcceptance) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchaseForcedAcceptance";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.function = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.usrId = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.amount = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_PurchaseForcedAcceptance.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_PurchasePhoneAuthorized = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_PurchasePhoneAuthorized) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchasePhoneAuthorized";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.function = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.usrId = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.amount = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_PurchasePhoneAuthorized.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_PurchaseReservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_PurchaseReservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchaseReservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_PurchaseReservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_PurchaseReservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_PurchaseReservation.prototype.function = undefined;
timapi.protocol.sixml.Request_PurchaseReservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_PurchaseReservation.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_PurchaseReservation.prototype.amount = undefined;
timapi.protocol.sixml.Request_PurchaseReservation.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_PurchaseReservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_PurchaseWithCashback = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_PurchaseWithCashback) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountOther = value.amountOther ? new timapi.protocol.sixml.AmountOther(value.amountOther) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountOther")) {
            this.amountOther = new timapi.protocol.sixml.AmountOther(this.xmlGetChild(node, "sixml:AmountOther"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchaseWithCashback";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.function = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.usrId = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.amount = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.amountOther = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_PurchaseWithCashback.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountOther != undefined) {
        this.xmlAddChild(node, "sixml:AmountOther", this.amountOther);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Reboot = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Reboot) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Reboot";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Reboot.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Reboot.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Reboot.prototype.function = undefined;
timapi.protocol.sixml.Request_Reboot.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Reboot.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_ReceiptRequest = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_ReceiptRequest) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.receiptRequestType = value.receiptRequestType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:ReceiptRequestType")) {
            this.receiptRequestType = this.xmlGetChild(node, "sixml:ReceiptRequestType").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "ReceiptRequest";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_ReceiptRequest.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_ReceiptRequest.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_ReceiptRequest.prototype.function = undefined;
timapi.protocol.sixml.Request_ReceiptRequest.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_ReceiptRequest.prototype.receiptRequestType = undefined;
timapi.protocol.sixml.Request_ReceiptRequest.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.receiptRequestType != undefined) {
        this.xmlAddChild(node, "sixml:ReceiptRequestType", this.receiptRequestType);
    }
    return node;
};
timapi.protocol.sixml.Request_Reconciliation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Reconciliation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Reconciliation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Reconciliation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Reconciliation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Reconciliation.prototype.function = undefined;
timapi.protocol.sixml.Request_Reconciliation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Reconciliation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_Reconfig = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Reconfig) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Reconfig";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Reconfig.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Reconfig.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Reconfig.prototype.function = undefined;
timapi.protocol.sixml.Request_Reconfig.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Reconfig.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_Reservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Reservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "Reservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Reservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Reservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Reservation.prototype.function = undefined;
timapi.protocol.sixml.Request_Reservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Reservation.prototype.amount = undefined;
timapi.protocol.sixml.Request_Reservation.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_Reservation.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_Reservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Reversal = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Reversal) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.usrId = value.usrId;
        this.transactionData = value.transactionData ? new timapi.protocol.sixml.TransactionData(value.transactionData) : undefined;
        this.merchantOptionList = value.merchantOptionList ? new timapi.protocol.sixml.MerchantOptionList(value.merchantOptionList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:UsrId")) {
            this.usrId = (this.xmlGetChild(node, "sixml:UsrId").textContent ? parseInt(this.xmlGetChild(node, "sixml:UsrId").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:TransactionData")) {
            this.transactionData = new timapi.protocol.sixml.TransactionData(this.xmlGetChild(node, "sixml:TransactionData"));
        }
        if (this.xmlHasChild(node, "sixml:MerchantOptionList")) {
            this.merchantOptionList = new timapi.protocol.sixml.MerchantOptionList(this.xmlGetChild(node, "sixml:MerchantOptionList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Reversal";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Reversal.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Reversal.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Reversal.prototype.function = undefined;
timapi.protocol.sixml.Request_Reversal.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Reversal.prototype.usrId = undefined;
timapi.protocol.sixml.Request_Reversal.prototype.transactionData = undefined;
timapi.protocol.sixml.Request_Reversal.prototype.merchantOptionList = undefined;
timapi.protocol.sixml.Request_Reversal.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.usrId != undefined) {
        this.xmlAddChild(node, "sixml:UsrId", timapi.utils.StringHelper.makeString(this.usrId));
    }
    if (this.transactionData != undefined) {
        this.xmlAddChild(node, "sixml:TransactionData", this.transactionData);
    }
    if (this.merchantOptionList != undefined) {
        this.xmlAddChild(node, "sixml:MerchantOptionList", this.merchantOptionList);
    }
    return node;
};
timapi.protocol.sixml.Request_Rollback = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_Rollback) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.repeat = value.repeat;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "Repeat")) {
            this.repeat = (this.xmlGetAttribute(node, "Repeat") ? parseInt(this.xmlGetAttribute(node, "Repeat")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Rollback";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_Rollback.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_Rollback.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_Rollback.prototype.function = undefined;
timapi.protocol.sixml.Request_Rollback.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_Rollback.prototype.repeat = undefined;
timapi.protocol.sixml.Request_Rollback.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.repeat != undefined) {
        this.xmlSetAttribute(node, "Repeat", timapi.utils.StringHelper.makeString(this.repeat));
    }
    return node;
};
timapi.protocol.sixml.Request_ShowDialog = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_ShowDialog) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resourceParameterList = value.resourceParameterList ? new timapi.protocol.sixml.ResourceParameterList(value.resourceParameterList) : undefined;
        this.resourceData = value.resourceData ? new timapi.protocol.sixml.ResourceData(value.resourceData) : undefined;
        this.brandBar = value.brandBar ? new timapi.protocol.sixml.BrandBar(value.brandBar) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:ResourceParameterList")) {
            this.resourceParameterList = new timapi.protocol.sixml.ResourceParameterList(this.xmlGetChild(node, "sixml:ResourceParameterList"));
        }
        if (this.xmlHasChild(node, "sixml:ResourceData")) {
            this.resourceData = new timapi.protocol.sixml.ResourceData(this.xmlGetChild(node, "sixml:ResourceData"));
        }
        if (this.xmlHasChild(node, "sixml:BrandBar")) {
            this.brandBar = new timapi.protocol.sixml.BrandBar(this.xmlGetChild(node, "sixml:BrandBar"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Dialog";
        this.function = "ShowDialog";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_ShowDialog.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_ShowDialog.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_ShowDialog.prototype.function = undefined;
timapi.protocol.sixml.Request_ShowDialog.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_ShowDialog.prototype.resourceParameterList = undefined;
timapi.protocol.sixml.Request_ShowDialog.prototype.resourceData = undefined;
timapi.protocol.sixml.Request_ShowDialog.prototype.brandBar = undefined;
timapi.protocol.sixml.Request_ShowDialog.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resourceParameterList != undefined) {
        this.xmlAddChild(node, "sixml:ResourceParameterList", this.resourceParameterList);
    }
    if (this.resourceData != undefined) {
        this.xmlAddChild(node, "sixml:ResourceData", this.resourceData);
    }
    if (this.brandBar != undefined) {
        this.xmlAddChild(node, "sixml:BrandBar", this.brandBar);
    }
    return node;
};
timapi.protocol.sixml.Request_ShowSignatureCapture = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_ShowSignatureCapture) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.signatureData = value.signatureData ? new timapi.protocol.sixml.SignatureData(value.signatureData) : undefined;
        this.brandBar = value.brandBar ? new timapi.protocol.sixml.BrandBar(value.brandBar) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:SignatureData")) {
            this.signatureData = new timapi.protocol.sixml.SignatureData(this.xmlGetChild(node, "sixml:SignatureData"));
        }
        if (this.xmlHasChild(node, "sixml:BrandBar")) {
            this.brandBar = new timapi.protocol.sixml.BrandBar(this.xmlGetChild(node, "sixml:BrandBar"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Dialog";
        this.function = "ShowSignatureCapture";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype.function = undefined;
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype.signatureData = undefined;
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype.brandBar = undefined;
timapi.protocol.sixml.Request_ShowSignatureCapture.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.signatureData != undefined) {
        this.xmlAddChild(node, "sixml:SignatureData", this.signatureData);
    }
    if (this.brandBar != undefined) {
        this.xmlAddChild(node, "sixml:BrandBar", this.brandBar);
    }
    return node;
};
timapi.protocol.sixml.Request_SoftwareUpdate = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_SoftwareUpdate) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "SoftwareUpdate";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_SoftwareUpdate.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_SoftwareUpdate.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_SoftwareUpdate.prototype.function = undefined;
timapi.protocol.sixml.Request_SoftwareUpdate.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_SoftwareUpdate.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.Request_SystemInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_SystemInformation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.ecrData = value.ecrData ? new timapi.protocol.sixml.EcrData(value.ecrData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:EcrData")) {
            this.ecrData = new timapi.protocol.sixml.EcrData(this.xmlGetChild(node, "sixml:EcrData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "SystemInformation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_SystemInformation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_SystemInformation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_SystemInformation.prototype.function = undefined;
timapi.protocol.sixml.Request_SystemInformation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_SystemInformation.prototype.ecrData = undefined;
timapi.protocol.sixml.Request_SystemInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.ecrData != undefined) {
        this.xmlAddChild(node, "sixml:EcrData", this.ecrData);
    }
    return node;
};
timapi.protocol.sixml.Request_TerminalStatus = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Request_TerminalStatus) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "TerminalStatus";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Request_TerminalStatus.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Request_TerminalStatus.prototype.functionGroup = undefined;
timapi.protocol.sixml.Request_TerminalStatus.prototype.function = undefined;
timapi.protocol.sixml.Request_TerminalStatus.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Request_TerminalStatus.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Request");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    return node;
};
timapi.protocol.sixml.ResourceData = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ResourceData) {
        var value = a;
        this.resourceId = value.resourceId;
        this.timeout = value.timeout;
        this.theme = value.theme;
        this.language = value.language;
        this.placeholderItemList = value.placeholderItemList ? new timapi.protocol.sixml.PlaceholderItemList(value.placeholderItemList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "ResourceId")) {
            this.resourceId = (this.xmlGetAttribute(node, "ResourceId") ? parseInt(this.xmlGetAttribute(node, "ResourceId")) : 0);
        }
        if (this.xmlHasAttribute(node, "Timeout")) {
            this.timeout = (this.xmlGetAttribute(node, "Timeout") ? parseInt(this.xmlGetAttribute(node, "Timeout")) : 0);
        }
        if (this.xmlHasAttribute(node, "Theme")) {
            this.theme = this.xmlGetAttribute(node, "Theme");
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PlaceholderItemList")) {
            this.placeholderItemList = new timapi.protocol.sixml.PlaceholderItemList(this.xmlGetChild(node, "sixml:PlaceholderItemList"));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ResourceData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ResourceData.prototype.resourceId = undefined;
timapi.protocol.sixml.ResourceData.prototype.timeout = undefined;
timapi.protocol.sixml.ResourceData.prototype.theme = undefined;
timapi.protocol.sixml.ResourceData.prototype.language = undefined;
timapi.protocol.sixml.ResourceData.prototype.placeholderItemList = undefined;
timapi.protocol.sixml.ResourceData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ResourceData");
    if (this.resourceId != undefined) {
        this.xmlSetAttribute(node, "ResourceId", timapi.utils.StringHelper.makeString(this.resourceId));
    }
    if (this.timeout != undefined) {
        this.xmlSetAttribute(node, "Timeout", timapi.utils.StringHelper.makeString(this.timeout));
    }
    if (this.theme != undefined) {
        this.xmlSetAttribute(node, "Theme", this.theme);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    if (this.placeholderItemList != undefined) {
        this.xmlAddChild(node, "sixml:PlaceholderItemList", this.placeholderItemList);
    }
    return node;
};
timapi.protocol.sixml.ResourceInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ResourceInformation) {
        var value = a;
        this.reason = value.reason;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.inputValue = value.inputValue;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "Reason")) {
            this.reason = this.xmlGetAttribute(node, "Reason");
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:InputValue")) {
            this.inputValue = this.xmlGetChild(node, "sixml:InputValue").textContent;
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ResourceInformation.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ResourceInformation.prototype.reason = undefined;
timapi.protocol.sixml.ResourceInformation.prototype.cardData = undefined;
timapi.protocol.sixml.ResourceInformation.prototype.inputValue = undefined;
timapi.protocol.sixml.ResourceInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ResourceInformation");
    if (this.reason != undefined) {
        this.xmlSetAttribute(node, "Reason", this.reason);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.inputValue != undefined) {
        this.xmlAddChild(node, "sixml:InputValue", this.inputValue);
    }
    return node;
};
timapi.protocol.sixml.Response = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.repeat = value.repeat;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasAttribute(node, "Repeat")) {
            this.repeat = (this.xmlGetAttribute(node, "Repeat") ? parseInt(this.xmlGetAttribute(node, "Repeat")) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response.prototype.function = undefined;
timapi.protocol.sixml.Response.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response.prototype.resultCode = undefined;
timapi.protocol.sixml.Response.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response.prototype.repeat = undefined;
timapi.protocol.sixml.Response.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.repeat != undefined) {
        this.xmlSetAttribute(node, "Repeat", timapi.utils.StringHelper.makeString(this.repeat));
    }
    return node;
};
timapi.protocol.sixml.Response_Activate = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Activate) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.actSeqCounter = value.actSeqCounter;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:ActSeqCounter")) {
            this.actSeqCounter = (this.xmlGetChild(node, "sixml:ActSeqCounter").textContent ? parseInt(this.xmlGetChild(node, "sixml:ActSeqCounter").textContent) : 0);
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Activate";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Activate.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Activate.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Activate.prototype.function = undefined;
timapi.protocol.sixml.Response_Activate.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Activate.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Activate.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Activate.prototype.printData = undefined;
timapi.protocol.sixml.Response_Activate.prototype.actSeqCounter = undefined;
timapi.protocol.sixml.Response_Activate.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.actSeqCounter != undefined) {
        this.xmlAddChild(node, "sixml:ActSeqCounter", timapi.utils.StringHelper.makeString(this.actSeqCounter));
    }
    return node;
};
timapi.protocol.sixml.Response_ActivateServiceMenu = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_ActivateServiceMenu) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "ActivateServiceMenu";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype.function = undefined;
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_ActivateServiceMenu.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_AdjustReservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_AdjustReservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "AdjustReservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_AdjustReservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_AdjustReservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.function = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.amount = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.cardData = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.printData = undefined;
timapi.protocol.sixml.Response_AdjustReservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_ApplicationInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_ApplicationInformation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.brandList = value.brandList ? new timapi.protocol.sixml.BrandList(value.brandList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:BrandList")) {
            this.brandList = new timapi.protocol.sixml.BrandList(this.xmlGetChild(node, "sixml:BrandList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "ApplicationInformation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_ApplicationInformation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_ApplicationInformation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_ApplicationInformation.prototype.function = undefined;
timapi.protocol.sixml.Response_ApplicationInformation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_ApplicationInformation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_ApplicationInformation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_ApplicationInformation.prototype.brandList = undefined;
timapi.protocol.sixml.Response_ApplicationInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.brandList != undefined) {
        this.xmlAddChild(node, "sixml:BrandList", this.brandList);
    }
    return node;
};
timapi.protocol.sixml.Response_AuthorizeCredit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_AuthorizeCredit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "AuthorizeCredit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_AuthorizeCredit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.function = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.amount = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.printData = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.cardData = undefined;
timapi.protocol.sixml.Response_AuthorizeCredit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    return node;
};
timapi.protocol.sixml.Response_AuthorizeDeposit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_AuthorizeDeposit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "AuthorizeDeposit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.function = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.amount = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.printData = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.cardData = undefined;
timapi.protocol.sixml.Response_AuthorizeDeposit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    return node;
};
timapi.protocol.sixml.Response_Balance = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Balance) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.counters = value.counters ? new timapi.protocol.sixml.Counters(value.counters) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:Counters")) {
            this.counters = new timapi.protocol.sixml.Counters(this.xmlGetChild(node, "sixml:Counters"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Balance";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Balance.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Balance.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Balance.prototype.function = undefined;
timapi.protocol.sixml.Response_Balance.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Balance.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Balance.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Balance.prototype.printData = undefined;
timapi.protocol.sixml.Response_Balance.prototype.counters = undefined;
timapi.protocol.sixml.Response_Balance.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.counters != undefined) {
        this.xmlAddChild(node, "sixml:Counters", this.counters);
    }
    return node;
};
timapi.protocol.sixml.Response_BalanceInquiry = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_BalanceInquiry) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "BalanceInquiry";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_BalanceInquiry.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_BalanceInquiry.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.function = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.printData = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.cardData = undefined;
timapi.protocol.sixml.Response_BalanceInquiry.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    return node;
};
timapi.protocol.sixml.Response_CancelReservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CancelReservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "CancelReservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CancelReservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CancelReservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.function = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.amount = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.printData = undefined;
timapi.protocol.sixml.Response_CancelReservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_CashAdvance = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CashAdvance) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "CashAdvance";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CashAdvance.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CashAdvance.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.function = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.amount = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.cardData = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.printData = undefined;
timapi.protocol.sixml.Response_CashAdvance.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_ChangeSettings = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_ChangeSettings) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "ChangeSettings";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_ChangeSettings.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_ChangeSettings.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_ChangeSettings.prototype.function = undefined;
timapi.protocol.sixml.Response_ChangeSettings.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_ChangeSettings.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_ChangeSettings.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_ChangeSettings.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_CloseDialogMode = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CloseDialogMode) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CloseDialogMode";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CloseDialogMode.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CloseDialogMode.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CloseDialogMode.prototype.function = undefined;
timapi.protocol.sixml.Response_CloseDialogMode.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CloseDialogMode.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CloseDialogMode.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CloseDialogMode.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_CloseMaintenanceWindow = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CloseMaintenanceWindow) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CloseMaintenanceWindow";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype.function = undefined;
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CloseMaintenanceWindow.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_CloseReader = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CloseReader) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CloseReader";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CloseReader.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CloseReader.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CloseReader.prototype.function = undefined;
timapi.protocol.sixml.Response_CloseReader.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CloseReader.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CloseReader.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CloseReader.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_CollectPoints = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CollectPoints) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "CollectPoints";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CollectPoints.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CollectPoints.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.function = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.amount = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.cardData = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.printData = undefined;
timapi.protocol.sixml.Response_CollectPoints.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Combined = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Combined) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Combined";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Combined.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Combined.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Combined.prototype.function = undefined;
timapi.protocol.sixml.Response_Combined.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Combined.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Combined.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Combined.prototype.amount = undefined;
timapi.protocol.sixml.Response_Combined.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_Combined.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_Combined.prototype.printData = undefined;
timapi.protocol.sixml.Response_Combined.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_Combined.prototype.cardData = undefined;
timapi.protocol.sixml.Response_Combined.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    return node;
};
timapi.protocol.sixml.Response_Commit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Commit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.repeat = value.repeat;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasAttribute(node, "Repeat")) {
            this.repeat = (this.xmlGetAttribute(node, "Repeat") ? parseInt(this.xmlGetAttribute(node, "Repeat")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Commit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Commit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Commit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Commit.prototype.function = undefined;
timapi.protocol.sixml.Response_Commit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Commit.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Commit.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Commit.prototype.repeat = undefined;
timapi.protocol.sixml.Response_Commit.prototype.printData = undefined;
timapi.protocol.sixml.Response_Commit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.repeat != undefined) {
        this.xmlSetAttribute(node, "Repeat", timapi.utils.StringHelper.makeString(this.repeat));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_CounterRequest = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_CounterRequest) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.counters = value.counters ? new timapi.protocol.sixml.Counters(value.counters) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Counters")) {
            this.counters = new timapi.protocol.sixml.Counters(this.xmlGetChild(node, "sixml:Counters"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "CounterRequest";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_CounterRequest.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_CounterRequest.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_CounterRequest.prototype.function = undefined;
timapi.protocol.sixml.Response_CounterRequest.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_CounterRequest.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_CounterRequest.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_CounterRequest.prototype.counters = undefined;
timapi.protocol.sixml.Response_CounterRequest.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.counters != undefined) {
        this.xmlAddChild(node, "sixml:Counters", this.counters);
    }
    return node;
};
timapi.protocol.sixml.Response_Credit = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Credit) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Credit";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Credit.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Credit.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Credit.prototype.function = undefined;
timapi.protocol.sixml.Response_Credit.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Credit.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Credit.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Credit.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_Credit.prototype.amount = undefined;
timapi.protocol.sixml.Response_Credit.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_Credit.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_Credit.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_Credit.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_Credit.prototype.cardData = undefined;
timapi.protocol.sixml.Response_Credit.prototype.printData = undefined;
timapi.protocol.sixml.Response_Credit.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_DccRates = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_DccRates) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "DccRates";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_DccRates.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_DccRates.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_DccRates.prototype.function = undefined;
timapi.protocol.sixml.Response_DccRates.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_DccRates.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_DccRates.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_DccRates.prototype.printData = undefined;
timapi.protocol.sixml.Response_DccRates.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Deactivate = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Deactivate) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.counters = value.counters ? new timapi.protocol.sixml.Counters(value.counters) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:Counters")) {
            this.counters = new timapi.protocol.sixml.Counters(this.xmlGetChild(node, "sixml:Counters"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Deactivate";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Deactivate.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Deactivate.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.function = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.printData = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.counters = undefined;
timapi.protocol.sixml.Response_Deactivate.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.counters != undefined) {
        this.xmlAddChild(node, "sixml:Counters", this.counters);
    }
    return node;
};
timapi.protocol.sixml.Response_EjectCard = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_EjectCard) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "EjectCard";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_EjectCard.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_EjectCard.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_EjectCard.prototype.function = undefined;
timapi.protocol.sixml.Response_EjectCard.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_EjectCard.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_EjectCard.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_EjectCard.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_Error = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Error) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.errorMessage = value.errorMessage;
        this.nativeError = value.nativeError ? new timapi.protocol.sixml.NativeError(value.nativeError) : undefined;
        this.ppInfo = value.ppInfo ? new timapi.protocol.sixml.PpInfo(value.ppInfo) : undefined;
        this.additionalErrorInfoList = value.additionalErrorInfoList ? new timapi.protocol.sixml.AdditionalErrorInfoList(value.additionalErrorInfoList) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.basket = value.basket ? new timapi.protocol.sixml.Basket(value.basket) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:ErrorMessage")) {
            this.errorMessage = this.xmlGetChild(node, "sixml:ErrorMessage").textContent;
        }
        if (this.xmlHasChild(node, "sixml:NativeError")) {
            this.nativeError = new timapi.protocol.sixml.NativeError(this.xmlGetChild(node, "sixml:NativeError"));
        }
        if (this.xmlHasChild(node, "sixml:PpInfo")) {
            this.ppInfo = new timapi.protocol.sixml.PpInfo(this.xmlGetChild(node, "sixml:PpInfo"));
        }
        if (this.xmlHasChild(node, "sixml:AdditionalErrorInfoList")) {
            this.additionalErrorInfoList = new timapi.protocol.sixml.AdditionalErrorInfoList(this.xmlGetChild(node, "sixml:AdditionalErrorInfoList"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:Basket")) {
            this.basket = new timapi.protocol.sixml.Basket(this.xmlGetChild(node, "sixml:Basket"));
        }
        return;
    }
    if (arguments.length == 0) {
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Error.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Error.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Error.prototype.function = undefined;
timapi.protocol.sixml.Response_Error.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Error.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Error.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Error.prototype.errorMessage = undefined;
timapi.protocol.sixml.Response_Error.prototype.nativeError = undefined;
timapi.protocol.sixml.Response_Error.prototype.ppInfo = undefined;
timapi.protocol.sixml.Response_Error.prototype.additionalErrorInfoList = undefined;
timapi.protocol.sixml.Response_Error.prototype.printData = undefined;
timapi.protocol.sixml.Response_Error.prototype.basket = undefined;
timapi.protocol.sixml.Response_Error.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.errorMessage != undefined) {
        this.xmlAddChild(node, "sixml:ErrorMessage", this.errorMessage);
    }
    if (this.nativeError != undefined) {
        this.xmlAddChild(node, "sixml:NativeError", this.nativeError);
    }
    if (this.ppInfo != undefined) {
        this.xmlAddChild(node, "sixml:PpInfo", this.ppInfo);
    }
    if (this.additionalErrorInfoList != undefined) {
        this.xmlAddChild(node, "sixml:AdditionalErrorInfoList", this.additionalErrorInfoList);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.basket != undefined) {
        this.xmlAddChild(node, "sixml:Basket", this.basket);
    }
    return node;
};
timapi.protocol.sixml.Response_FeatureRequest = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_FeatureRequest) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.features = value.features ? new timapi.protocol.sixml.Features(value.features) : undefined;
        this.terminalId = value.terminalId;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Features")) {
            this.features = new timapi.protocol.sixml.Features(this.xmlGetChild(node, "sixml:Features"));
        }
        if (this.xmlHasChild(node, "sixml:TerminalId")) {
            this.terminalId = this.xmlGetChild(node, "sixml:TerminalId").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "FeatureRequest";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_FeatureRequest.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_FeatureRequest.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.function = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.features = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.terminalId = undefined;
timapi.protocol.sixml.Response_FeatureRequest.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.features != undefined) {
        this.xmlAddChild(node, "sixml:Features", this.features);
    }
    if (this.terminalId != undefined) {
        this.xmlAddChild(node, "sixml:TerminalId", this.terminalId);
    }
    return node;
};
timapi.protocol.sixml.Response_FinalizePurchase = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_FinalizePurchase) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.basket = value.basket ? new timapi.protocol.sixml.Basket(value.basket) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:Basket")) {
            this.basket = new timapi.protocol.sixml.Basket(this.xmlGetChild(node, "sixml:Basket"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "FinalizePurchase";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_FinalizePurchase.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_FinalizePurchase.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.function = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.printData = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.basket = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.amount = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_FinalizePurchase.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.basket != undefined) {
        this.xmlAddChild(node, "sixml:Basket", this.basket);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    return node;
};
timapi.protocol.sixml.Response_Giro = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Giro) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Giro";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Giro.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Giro.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Giro.prototype.function = undefined;
timapi.protocol.sixml.Response_Giro.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Giro.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Giro.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Giro.prototype.amount = undefined;
timapi.protocol.sixml.Response_Giro.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_Giro.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_Giro.prototype.printData = undefined;
timapi.protocol.sixml.Response_Giro.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_Giro.prototype.cardData = undefined;
timapi.protocol.sixml.Response_Giro.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    return node;
};
timapi.protocol.sixml.Response_HardwareInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_HardwareInformation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.errorCode = value.errorCode;
        this.hardwareList = value.hardwareList ? new timapi.protocol.sixml.HardwareList(value.hardwareList) : undefined;
        this.kernelVersionList = value.kernelVersionList ? new timapi.protocol.sixml.KernelVersionList(value.kernelVersionList) : undefined;
        this.settingsList = value.settingsList ? new timapi.protocol.sixml.SettingsList(value.settingsList) : undefined;
        this.statisticsList = value.statisticsList ? new timapi.protocol.sixml.StatisticsList(value.statisticsList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:ErrorCode")) {
            this.errorCode = (this.xmlGetChild(node, "sixml:ErrorCode").textContent ? parseInt(this.xmlGetChild(node, "sixml:ErrorCode").textContent) : 0);
        }
        if (this.xmlHasChild(node, "sixml:HardwareList")) {
            this.hardwareList = new timapi.protocol.sixml.HardwareList(this.xmlGetChild(node, "sixml:HardwareList"));
        }
        if (this.xmlHasChild(node, "sixml:KernelVersionList")) {
            this.kernelVersionList = new timapi.protocol.sixml.KernelVersionList(this.xmlGetChild(node, "sixml:KernelVersionList"));
        }
        if (this.xmlHasChild(node, "sixml:SettingsList")) {
            this.settingsList = new timapi.protocol.sixml.SettingsList(this.xmlGetChild(node, "sixml:SettingsList"));
        }
        if (this.xmlHasChild(node, "sixml:StatisticsList")) {
            this.statisticsList = new timapi.protocol.sixml.StatisticsList(this.xmlGetChild(node, "sixml:StatisticsList"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "HardwareInformation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_HardwareInformation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_HardwareInformation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.function = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.errorCode = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.hardwareList = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.kernelVersionList = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.settingsList = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.statisticsList = undefined;
timapi.protocol.sixml.Response_HardwareInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.errorCode != undefined) {
        this.xmlAddChild(node, "sixml:ErrorCode", timapi.utils.StringHelper.makeString(this.errorCode));
    }
    if (this.hardwareList != undefined) {
        this.xmlAddChild(node, "sixml:HardwareList", this.hardwareList);
    }
    if (this.kernelVersionList != undefined) {
        this.xmlAddChild(node, "sixml:KernelVersionList", this.kernelVersionList);
    }
    if (this.settingsList != undefined) {
        this.xmlAddChild(node, "sixml:SettingsList", this.settingsList);
    }
    if (this.statisticsList != undefined) {
        this.xmlAddChild(node, "sixml:StatisticsList", this.statisticsList);
    }
    return node;
};
timapi.protocol.sixml.Response_InitTransaction = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_InitTransaction) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "InitTransaction";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_InitTransaction.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_InitTransaction.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_InitTransaction.prototype.function = undefined;
timapi.protocol.sixml.Response_InitTransaction.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_InitTransaction.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_InitTransaction.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_InitTransaction.prototype.cardData = undefined;
timapi.protocol.sixml.Response_InitTransaction.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    return node;
};
timapi.protocol.sixml.Response_LoadVoucher = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_LoadVoucher) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "LoadVoucher";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_LoadVoucher.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_LoadVoucher.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.function = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.amount = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.cardData = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.printData = undefined;
timapi.protocol.sixml.Response_LoadVoucher.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Login = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Login) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Login";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Login.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Login.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Login.prototype.function = undefined;
timapi.protocol.sixml.Response_Login.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Login.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Login.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Login.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_Logout = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Logout) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Logout";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Logout.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Logout.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Logout.prototype.function = undefined;
timapi.protocol.sixml.Response_Logout.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Logout.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Logout.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Logout.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_OpenDialogMode = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_OpenDialogMode) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "OpenDialogMode";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_OpenDialogMode.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_OpenDialogMode.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_OpenDialogMode.prototype.function = undefined;
timapi.protocol.sixml.Response_OpenDialogMode.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_OpenDialogMode.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_OpenDialogMode.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_OpenDialogMode.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_OpenMaintenanceWindow = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_OpenMaintenanceWindow) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "OpenMaintenanceWindow";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype.function = undefined;
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_OpenMaintenanceWindow.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_OpenReader = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_OpenReader) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "OpenReader";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_OpenReader.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_OpenReader.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_OpenReader.prototype.function = undefined;
timapi.protocol.sixml.Response_OpenReader.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_OpenReader.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_OpenReader.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_OpenReader.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_PreAuthorization = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_PreAuthorization) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.basket = value.basket ? new timapi.protocol.sixml.Basket(value.basket) : undefined;
        this.additionalInfoList = value.additionalInfoList ? new timapi.protocol.sixml.AdditionalInfoList(value.additionalInfoList) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:Basket")) {
            this.basket = new timapi.protocol.sixml.Basket(this.xmlGetChild(node, "sixml:Basket"));
        }
        if (this.xmlHasChild(node, "sixml:AdditionalInfoList")) {
            this.additionalInfoList = new timapi.protocol.sixml.AdditionalInfoList(this.xmlGetChild(node, "sixml:AdditionalInfoList"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PreAuthorization";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_PreAuthorization.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_PreAuthorization.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.function = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.amount = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.basket = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.additionalInfoList = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.printData = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.cardData = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_PreAuthorization.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.basket != undefined) {
        this.xmlAddChild(node, "sixml:Basket", this.basket);
    }
    if (this.additionalInfoList != undefined) {
        this.xmlAddChild(node, "sixml:AdditionalInfoList", this.additionalInfoList);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    return node;
};
timapi.protocol.sixml.Response_Purchase = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Purchase) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.basket = value.basket ? new timapi.protocol.sixml.Basket(value.basket) : undefined;
        this.additionalInfoList = value.additionalInfoList ? new timapi.protocol.sixml.AdditionalInfoList(value.additionalInfoList) : undefined;
        this.amountTip = value.amountTip ? new timapi.protocol.sixml.AmountTip(value.amountTip) : undefined;
        this.loyaltyCashbackAmount = value.loyaltyCashbackAmount ? new timapi.protocol.sixml.LoyaltyCashbackAmount(value.loyaltyCashbackAmount) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:Basket")) {
            this.basket = new timapi.protocol.sixml.Basket(this.xmlGetChild(node, "sixml:Basket"));
        }
        if (this.xmlHasChild(node, "sixml:AdditionalInfoList")) {
            this.additionalInfoList = new timapi.protocol.sixml.AdditionalInfoList(this.xmlGetChild(node, "sixml:AdditionalInfoList"));
        }
        if (this.xmlHasChild(node, "sixml:AmountTip")) {
            this.amountTip = new timapi.protocol.sixml.AmountTip(this.xmlGetChild(node, "sixml:AmountTip"));
        }
        if (this.xmlHasChild(node, "sixml:LoyaltyCashbackAmount")) {
            this.loyaltyCashbackAmount = new timapi.protocol.sixml.LoyaltyCashbackAmount(this.xmlGetChild(node, "sixml:LoyaltyCashbackAmount"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Purchase";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Purchase.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Purchase.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.function = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.amount = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.cardData = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.printData = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.basket = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.additionalInfoList = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.amountTip = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.loyaltyCashbackAmount = undefined;
timapi.protocol.sixml.Response_Purchase.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.basket != undefined) {
        this.xmlAddChild(node, "sixml:Basket", this.basket);
    }
    if (this.additionalInfoList != undefined) {
        this.xmlAddChild(node, "sixml:AdditionalInfoList", this.additionalInfoList);
    }
    if (this.amountTip != undefined) {
        this.xmlAddChild(node, "sixml:AmountTip", this.amountTip);
    }
    if (this.loyaltyCashbackAmount != undefined) {
        this.xmlAddChild(node, "sixml:LoyaltyCashbackAmount", this.loyaltyCashbackAmount);
    }
    return node;
};
timapi.protocol.sixml.Response_PurchaseForcedAcceptance = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_PurchaseForcedAcceptance) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchaseForcedAcceptance";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.function = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.amount = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.cardData = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.printData = undefined;
timapi.protocol.sixml.Response_PurchaseForcedAcceptance.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_PurchasePhoneAuthorized = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_PurchasePhoneAuthorized) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchasePhoneAuthorized";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.function = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.amount = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.cardData = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.printData = undefined;
timapi.protocol.sixml.Response_PurchasePhoneAuthorized.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_PurchaseReservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_PurchaseReservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountTip = value.amountTip ? new timapi.protocol.sixml.AmountTip(value.amountTip) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountTip")) {
            this.amountTip = new timapi.protocol.sixml.AmountTip(this.xmlGetChild(node, "sixml:AmountTip"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchaseReservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_PurchaseReservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_PurchaseReservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.function = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.amount = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.amountTip = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.cardData = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.printData = undefined;
timapi.protocol.sixml.Response_PurchaseReservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountTip != undefined) {
        this.xmlAddChild(node, "sixml:AmountTip", this.amountTip);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_PurchaseWithCashback = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_PurchaseWithCashback) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountOther = value.amountOther ? new timapi.protocol.sixml.AmountOther(value.amountOther) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountOther")) {
            this.amountOther = new timapi.protocol.sixml.AmountOther(this.xmlGetChild(node, "sixml:AmountOther"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "PurchaseWithCashback";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.function = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.amount = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.amountOther = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.cardData = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.printData = undefined;
timapi.protocol.sixml.Response_PurchaseWithCashback.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountOther != undefined) {
        this.xmlAddChild(node, "sixml:AmountOther", this.amountOther);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Reboot = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Reboot) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Reboot";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Reboot.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Reboot.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Reboot.prototype.function = undefined;
timapi.protocol.sixml.Response_Reboot.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Reboot.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Reboot.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Reboot.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    return node;
};
timapi.protocol.sixml.Response_ReceiptRequest = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_ReceiptRequest) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        this.hasMoreReceipts = value.hasMoreReceipts;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        if (this.xmlHasChild(node, "sixml:HasMoreReceipts")) {
            this.hasMoreReceipts = this.xmlGetChild(node, "sixml:HasMoreReceipts").textContent == "1";
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "ReceiptRequest";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_ReceiptRequest.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_ReceiptRequest.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.function = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.printData = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.hasMoreReceipts = undefined;
timapi.protocol.sixml.Response_ReceiptRequest.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    if (this.hasMoreReceipts != undefined) {
        this.xmlAddChild(node, "sixml:HasMoreReceipts", (this.hasMoreReceipts ? "1" : "0"));
    }
    return node;
};
timapi.protocol.sixml.Response_Reconciliation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Reconciliation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.counters = value.counters ? new timapi.protocol.sixml.Counters(value.counters) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Counters")) {
            this.counters = new timapi.protocol.sixml.Counters(this.xmlGetChild(node, "sixml:Counters"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Reconciliation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Reconciliation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Reconciliation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.function = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.counters = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.printData = undefined;
timapi.protocol.sixml.Response_Reconciliation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.counters != undefined) {
        this.xmlAddChild(node, "sixml:Counters", this.counters);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Reconfig = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Reconfig) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "Reconfig";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Reconfig.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Reconfig.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Reconfig.prototype.function = undefined;
timapi.protocol.sixml.Response_Reconfig.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Reconfig.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Reconfig.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Reconfig.prototype.printData = undefined;
timapi.protocol.sixml.Response_Reconfig.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Reservation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Reservation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountDue = value.amountDue ? new timapi.protocol.sixml.AmountDue(value.amountDue) : undefined;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDue")) {
            this.amountDue = new timapi.protocol.sixml.AmountDue(this.xmlGetChild(node, "sixml:AmountDue"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "NonFinTransaction";
        this.function = "Reservation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Reservation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Reservation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.function = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.amount = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.amountDue = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.cardData = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.printData = undefined;
timapi.protocol.sixml.Response_Reservation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountDue != undefined) {
        this.xmlAddChild(node, "sixml:AmountDue", this.amountDue);
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Reversal = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Reversal) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.transactionInformation = value.transactionInformation ? new timapi.protocol.sixml.TransactionInformation(value.transactionInformation) : undefined;
        this.amount = value.amount ? new timapi.protocol.sixml.Amount(value.amount) : undefined;
        this.amountDcc = value.amountDcc ? new timapi.protocol.sixml.AmountDcc(value.amountDcc) : undefined;
        this.amountSaldo = value.amountSaldo ? new timapi.protocol.sixml.AmountSaldo(value.amountSaldo) : undefined;
        this.dccDisclaimer = value.dccDisclaimer;
        this.disclaimer = value.disclaimer;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:TransactionInformation")) {
            this.transactionInformation = new timapi.protocol.sixml.TransactionInformation(this.xmlGetChild(node, "sixml:TransactionInformation"));
        }
        if (this.xmlHasChild(node, "sixml:Amount")) {
            this.amount = new timapi.protocol.sixml.Amount(this.xmlGetChild(node, "sixml:Amount"));
        }
        if (this.xmlHasChild(node, "sixml:AmountDcc")) {
            this.amountDcc = new timapi.protocol.sixml.AmountDcc(this.xmlGetChild(node, "sixml:AmountDcc"));
        }
        if (this.xmlHasChild(node, "sixml:AmountSaldo")) {
            this.amountSaldo = new timapi.protocol.sixml.AmountSaldo(this.xmlGetChild(node, "sixml:AmountSaldo"));
        }
        if (this.xmlHasChild(node, "sixml:DccDisclaimer")) {
            this.dccDisclaimer = this.xmlGetChild(node, "sixml:DccDisclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:Disclaimer")) {
            this.disclaimer = this.xmlGetChild(node, "sixml:Disclaimer").textContent;
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Reversal";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Reversal.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Reversal.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.function = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.transactionInformation = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.amount = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.amountDcc = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.amountSaldo = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.dccDisclaimer = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.disclaimer = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.printData = undefined;
timapi.protocol.sixml.Response_Reversal.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transactionInformation != undefined) {
        this.xmlAddChild(node, "sixml:TransactionInformation", this.transactionInformation);
    }
    if (this.amount != undefined) {
        this.xmlAddChild(node, "sixml:Amount", this.amount);
    }
    if (this.amountDcc != undefined) {
        this.xmlAddChild(node, "sixml:AmountDcc", this.amountDcc);
    }
    if (this.amountSaldo != undefined) {
        this.xmlAddChild(node, "sixml:AmountSaldo", this.amountSaldo);
    }
    if (this.dccDisclaimer != undefined) {
        this.xmlAddChild(node, "sixml:DccDisclaimer", this.dccDisclaimer);
    }
    if (this.disclaimer != undefined) {
        this.xmlAddChild(node, "sixml:Disclaimer", this.disclaimer);
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_Rollback = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_Rollback) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.repeat = value.repeat;
        this.printData = value.printData ? new timapi.protocol.sixml.PrintData(value.printData) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasAttribute(node, "Repeat")) {
            this.repeat = (this.xmlGetAttribute(node, "Repeat") ? parseInt(this.xmlGetAttribute(node, "Repeat")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:PrintData")) {
            this.printData = new timapi.protocol.sixml.PrintData(this.xmlGetChild(node, "sixml:PrintData"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "FinTransaction";
        this.function = "Rollback";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_Rollback.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_Rollback.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.function = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.repeat = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.printData = undefined;
timapi.protocol.sixml.Response_Rollback.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.repeat != undefined) {
        this.xmlSetAttribute(node, "Repeat", timapi.utils.StringHelper.makeString(this.repeat));
    }
    if (this.printData != undefined) {
        this.xmlAddChild(node, "sixml:PrintData", this.printData);
    }
    return node;
};
timapi.protocol.sixml.Response_ShowDialog = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_ShowDialog) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.resourceInformation = value.resourceInformation ? new timapi.protocol.sixml.ResourceInformation(value.resourceInformation) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:ResourceInformation")) {
            this.resourceInformation = new timapi.protocol.sixml.ResourceInformation(this.xmlGetChild(node, "sixml:ResourceInformation"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Dialog";
        this.function = "ShowDialog";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_ShowDialog.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_ShowDialog.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_ShowDialog.prototype.function = undefined;
timapi.protocol.sixml.Response_ShowDialog.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_ShowDialog.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_ShowDialog.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_ShowDialog.prototype.resourceInformation = undefined;
timapi.protocol.sixml.Response_ShowDialog.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.resourceInformation != undefined) {
        this.xmlAddChild(node, "sixml:ResourceInformation", this.resourceInformation);
    }
    return node;
};
timapi.protocol.sixml.Response_ShowSignatureCapture = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_ShowSignatureCapture) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.signatureInformation = value.signatureInformation ? new timapi.protocol.sixml.SignatureInformation(value.signatureInformation) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:SignatureInformation")) {
            this.signatureInformation = new timapi.protocol.sixml.SignatureInformation(this.xmlGetChild(node, "sixml:SignatureInformation"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Dialog";
        this.function = "ShowSignatureCapture";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.function = undefined;
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.signatureInformation = undefined;
timapi.protocol.sixml.Response_ShowSignatureCapture.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.signatureInformation != undefined) {
        this.xmlAddChild(node, "sixml:SignatureInformation", this.signatureInformation);
    }
    return node;
};
timapi.protocol.sixml.Response_SoftwareUpdate = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_SoftwareUpdate) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.updateStatus = value.updateStatus;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:UpdateStatus")) {
            this.updateStatus = this.xmlGetChild(node, "sixml:UpdateStatus").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Admin";
        this.function = "SoftwareUpdate";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_SoftwareUpdate.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.function = undefined;
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.updateStatus = undefined;
timapi.protocol.sixml.Response_SoftwareUpdate.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.updateStatus != undefined) {
        this.xmlAddChild(node, "sixml:UpdateStatus", this.updateStatus);
    }
    return node;
};
timapi.protocol.sixml.Response_SystemInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_SystemInformation) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.configData = value.configData ? new timapi.protocol.sixml.ConfigData(value.configData) : undefined;
        this.networkInformation = value.networkInformation ? new timapi.protocol.sixml.NetworkInformation(value.networkInformation) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:ConfigData")) {
            this.configData = new timapi.protocol.sixml.ConfigData(this.xmlGetChild(node, "sixml:ConfigData"));
        }
        if (this.xmlHasChild(node, "sixml:NetworkInformation")) {
            this.networkInformation = new timapi.protocol.sixml.NetworkInformation(this.xmlGetChild(node, "sixml:NetworkInformation"));
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "SystemInformation";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_SystemInformation.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_SystemInformation.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.function = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.configData = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.networkInformation = undefined;
timapi.protocol.sixml.Response_SystemInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.configData != undefined) {
        this.xmlAddChild(node, "sixml:ConfigData", this.configData);
    }
    if (this.networkInformation != undefined) {
        this.xmlAddChild(node, "sixml:NetworkInformation", this.networkInformation);
    }
    return node;
};
timapi.protocol.sixml.Response_TerminalStatus = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Response_TerminalStatus) {
        var value = a;
        this.functionGroup = value.functionGroup;
        this.function = value.function;
        this.sequenceNumber = value.sequenceNumber;
        this.resultCode = value.resultCode;
        this.timeStamp = value.timeStamp;
        this.displayContent = value.displayContent ? new timapi.protocol.sixml.DisplayContent(value.displayContent) : undefined;
        this.cardReaderStatus = value.cardReaderStatus;
        this.transactionStatus = value.transactionStatus;
        this.connectionStatus = value.connectionStatus;
        this.managementStatus = value.managementStatus;
        this.sleepModeStatus = value.sleepModeStatus;
        this.receiptInformation = value.receiptInformation;
        this.cardData = value.cardData ? new timapi.protocol.sixml.CardData(value.cardData) : undefined;
        this.swUpdateAvailable = value.swUpdateAvailable;
        this.terminalId = value.terminalId;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "FunctionGroup")) {
            this.functionGroup = this.xmlGetAttribute(node, "FunctionGroup");
        }
        if (this.xmlHasAttribute(node, "Function")) {
            this.function = this.xmlGetAttribute(node, "Function");
        }
        if (this.xmlHasAttribute(node, "SequenceNumber")) {
            this.sequenceNumber = (this.xmlGetAttribute(node, "SequenceNumber") ? parseInt(this.xmlGetAttribute(node, "SequenceNumber")) : 0);
        }
        if (this.xmlHasAttribute(node, "ResultCode")) {
            this.resultCode = (this.xmlGetAttribute(node, "ResultCode") ? parseInt(this.xmlGetAttribute(node, "ResultCode")) : 0);
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasChild(node, "sixml:DisplayContent")) {
            this.displayContent = new timapi.protocol.sixml.DisplayContent(this.xmlGetChild(node, "sixml:DisplayContent"));
        }
        if (this.xmlHasChild(node, "sixml:CardReaderStatus")) {
            this.cardReaderStatus = this.xmlGetChild(node, "sixml:CardReaderStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:TransactionStatus")) {
            this.transactionStatus = this.xmlGetChild(node, "sixml:TransactionStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ConnectionStatus")) {
            this.connectionStatus = this.xmlGetChild(node, "sixml:ConnectionStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ManagementStatus")) {
            this.managementStatus = this.xmlGetChild(node, "sixml:ManagementStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:SleepModeStatus")) {
            this.sleepModeStatus = this.xmlGetChild(node, "sixml:SleepModeStatus").textContent;
        }
        if (this.xmlHasChild(node, "sixml:ReceiptInformation")) {
            this.receiptInformation = this.xmlGetChild(node, "sixml:ReceiptInformation").textContent == "1";
        }
        if (this.xmlHasChild(node, "sixml:CardData")) {
            this.cardData = new timapi.protocol.sixml.CardData(this.xmlGetChild(node, "sixml:CardData"));
        }
        if (this.xmlHasChild(node, "sixml:SwUpdateAvailable")) {
            this.swUpdateAvailable = this.xmlGetChild(node, "sixml:SwUpdateAvailable").textContent == "1";
        }
        if (this.xmlHasChild(node, "sixml:TerminalId")) {
            this.terminalId = this.xmlGetChild(node, "sixml:TerminalId").textContent;
        }
        return;
    }
    if (arguments.length == 0) {
        this.functionGroup = "Status";
        this.function = "TerminalStatus";
        return;
    }
    throw new Error("Invalid argument");
};
timapi.protocol.sixml.Response_TerminalStatus.prototype = Object.create(timapi.protocol.Message.prototype);
timapi.protocol.sixml.Response_TerminalStatus.prototype.functionGroup = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.function = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.sequenceNumber = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.resultCode = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.timeStamp = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.displayContent = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.cardReaderStatus = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.transactionStatus = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.connectionStatus = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.managementStatus = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.sleepModeStatus = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.receiptInformation = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.cardData = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.swUpdateAvailable = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.terminalId = undefined;
timapi.protocol.sixml.Response_TerminalStatus.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Response");
    this.xmlSetAttribute(node, "xmlns:sixml", "http://www.six-payment-services.com/");
    if (this.functionGroup != undefined) {
        this.xmlSetAttribute(node, "FunctionGroup", this.functionGroup);
    }
    if (this.function != undefined) {
        this.xmlSetAttribute(node, "Function", this.function);
    }
    if (this.sequenceNumber != undefined) {
        this.xmlSetAttribute(node, "SequenceNumber", timapi.utils.StringHelper.makeString(this.sequenceNumber));
    }
    if (this.resultCode != undefined) {
        this.xmlSetAttribute(node, "ResultCode", timapi.utils.StringHelper.makeString(this.resultCode));
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.displayContent != undefined) {
        this.xmlAddChild(node, "sixml:DisplayContent", this.displayContent);
    }
    if (this.cardReaderStatus != undefined) {
        this.xmlAddChild(node, "sixml:CardReaderStatus", this.cardReaderStatus);
    }
    if (this.transactionStatus != undefined) {
        this.xmlAddChild(node, "sixml:TransactionStatus", this.transactionStatus);
    }
    if (this.connectionStatus != undefined) {
        this.xmlAddChild(node, "sixml:ConnectionStatus", this.connectionStatus);
    }
    if (this.managementStatus != undefined) {
        this.xmlAddChild(node, "sixml:ManagementStatus", this.managementStatus);
    }
    if (this.sleepModeStatus != undefined) {
        this.xmlAddChild(node, "sixml:SleepModeStatus", this.sleepModeStatus);
    }
    if (this.receiptInformation != undefined) {
        this.xmlAddChild(node, "sixml:ReceiptInformation", (this.receiptInformation ? "1" : "0"));
    }
    if (this.cardData != undefined) {
        this.xmlAddChild(node, "sixml:CardData", this.cardData);
    }
    if (this.swUpdateAvailable != undefined) {
        this.xmlAddChild(node, "sixml:SwUpdateAvailable", (this.swUpdateAvailable ? "1" : "0"));
    }
    if (this.terminalId != undefined) {
        this.xmlAddChild(node, "sixml:TerminalId", this.terminalId);
    }
    return node;
};
timapi.protocol.sixml.ScreenshotOptions = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.ScreenshotOptions) {
        var value = a;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.ScreenshotOptions.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.ScreenshotOptions.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:ScreenshotOptions");
    return node;
};
timapi.protocol.sixml.Setting = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Setting) {
        var value = a;
        this.value = value.value;
        this.settingType = value.settingType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "SettingType")) {
            this.settingType = this.xmlGetAttribute(node, "SettingType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Setting.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Setting.prototype.value = "";
timapi.protocol.sixml.Setting.prototype.settingType = undefined;
timapi.protocol.sixml.Setting.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Setting");
    node.textContent = this.value;
    if (this.settingType != undefined) {
        this.xmlSetAttribute(node, "SettingType", this.settingType);
    }
    return node;
};
timapi.protocol.sixml.SettingsList = function (a) {
    this.setting = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.SettingsList) {
        var value = a;
        for (var each of value.setting) {
            this.setting.push(each ? new timapi.protocol.sixml.Setting(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Setting")) {
            this.setting.push(new timapi.protocol.sixml.Setting(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.SettingsList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.SettingsList.prototype.setting = undefined;
timapi.protocol.sixml.SettingsList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:SettingsList");
    for (var each of this.setting) {
        this.xmlAddChild(node, "sixml:Setting", each);
    }
    return node;
};
timapi.protocol.sixml.SignatureCapture = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.SignatureCapture) {
        var value = a;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.SignatureCapture.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.SignatureCapture.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:SignatureCapture");
    return node;
};
timapi.protocol.sixml.SignatureData = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.SignatureData) {
        var value = a;
        this.resourceId = value.resourceId;
        this.timeout = value.timeout;
        this.theme = value.theme;
        this.imageFileFormat = value.imageFileFormat;
        this.imageHeight = value.imageHeight;
        this.imageWidth = value.imageWidth;
        this.backgroundColor = value.backgroundColor;
        this.watermarkColor = value.watermarkColor;
        this.signatureColor = value.signatureColor;
        this.language = value.language;
        this.watermarkItemList = value.watermarkItemList ? new timapi.protocol.sixml.WatermarkItemList(value.watermarkItemList) : undefined;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "ResourceId")) {
            this.resourceId = (this.xmlGetAttribute(node, "ResourceId") ? parseInt(this.xmlGetAttribute(node, "ResourceId")) : 0);
        }
        if (this.xmlHasAttribute(node, "Timeout")) {
            this.timeout = (this.xmlGetAttribute(node, "Timeout") ? parseInt(this.xmlGetAttribute(node, "Timeout")) : 0);
        }
        if (this.xmlHasAttribute(node, "Theme")) {
            this.theme = this.xmlGetAttribute(node, "Theme");
        }
        if (this.xmlHasAttribute(node, "ImageFileFormat")) {
            this.imageFileFormat = this.xmlGetAttribute(node, "ImageFileFormat");
        }
        if (this.xmlHasAttribute(node, "ImageHeight")) {
            this.imageHeight = (this.xmlGetAttribute(node, "ImageHeight") ? parseInt(this.xmlGetAttribute(node, "ImageHeight")) : 0);
        }
        if (this.xmlHasAttribute(node, "ImageWidth")) {
            this.imageWidth = (this.xmlGetAttribute(node, "ImageWidth") ? parseInt(this.xmlGetAttribute(node, "ImageWidth")) : 0);
        }
        if (this.xmlHasAttribute(node, "BackgroundColor")) {
            this.backgroundColor = this.xmlGetAttribute(node, "BackgroundColor");
        }
        if (this.xmlHasAttribute(node, "WatermarkColor")) {
            this.watermarkColor = this.xmlGetAttribute(node, "WatermarkColor");
        }
        if (this.xmlHasAttribute(node, "SignatureColor")) {
            this.signatureColor = this.xmlGetAttribute(node, "SignatureColor");
        }
        if (this.xmlHasChild(node, "sixml:Language")) {
            this.language = this.xmlGetChild(node, "sixml:Language").textContent;
        }
        if (this.xmlHasChild(node, "sixml:WatermarkItemList")) {
            this.watermarkItemList = new timapi.protocol.sixml.WatermarkItemList(this.xmlGetChild(node, "sixml:WatermarkItemList"));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.SignatureData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.SignatureData.prototype.resourceId = undefined;
timapi.protocol.sixml.SignatureData.prototype.timeout = undefined;
timapi.protocol.sixml.SignatureData.prototype.theme = undefined;
timapi.protocol.sixml.SignatureData.prototype.imageFileFormat = undefined;
timapi.protocol.sixml.SignatureData.prototype.imageHeight = undefined;
timapi.protocol.sixml.SignatureData.prototype.imageWidth = undefined;
timapi.protocol.sixml.SignatureData.prototype.backgroundColor = undefined;
timapi.protocol.sixml.SignatureData.prototype.watermarkColor = undefined;
timapi.protocol.sixml.SignatureData.prototype.signatureColor = undefined;
timapi.protocol.sixml.SignatureData.prototype.language = undefined;
timapi.protocol.sixml.SignatureData.prototype.watermarkItemList = undefined;
timapi.protocol.sixml.SignatureData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:SignatureData");
    if (this.resourceId != undefined) {
        this.xmlSetAttribute(node, "ResourceId", timapi.utils.StringHelper.makeString(this.resourceId));
    }
    if (this.timeout != undefined) {
        this.xmlSetAttribute(node, "Timeout", timapi.utils.StringHelper.makeString(this.timeout));
    }
    if (this.theme != undefined) {
        this.xmlSetAttribute(node, "Theme", this.theme);
    }
    if (this.imageFileFormat != undefined) {
        this.xmlSetAttribute(node, "ImageFileFormat", this.imageFileFormat);
    }
    if (this.imageHeight != undefined) {
        this.xmlSetAttribute(node, "ImageHeight", timapi.utils.StringHelper.makeString(this.imageHeight));
    }
    if (this.imageWidth != undefined) {
        this.xmlSetAttribute(node, "ImageWidth", timapi.utils.StringHelper.makeString(this.imageWidth));
    }
    if (this.backgroundColor != undefined) {
        this.xmlSetAttribute(node, "BackgroundColor", this.backgroundColor);
    }
    if (this.watermarkColor != undefined) {
        this.xmlSetAttribute(node, "WatermarkColor", this.watermarkColor);
    }
    if (this.signatureColor != undefined) {
        this.xmlSetAttribute(node, "SignatureColor", this.signatureColor);
    }
    if (this.language != undefined) {
        this.xmlAddChild(node, "sixml:Language", this.language);
    }
    if (this.watermarkItemList != undefined) {
        this.xmlAddChild(node, "sixml:WatermarkItemList", this.watermarkItemList);
    }
    return node;
};
timapi.protocol.sixml.SignatureInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.SignatureInformation) {
        var value = a;
        this.value = value.value;
        this.imageFileFormat = value.imageFileFormat;
        this.imageWidth = value.imageWidth;
        this.imageHeight = value.imageHeight;
        this.reason = value.reason;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = timapi.ConversionHelper.hexStringToByte(node.textContent);
        if (this.xmlHasAttribute(node, "ImageFileFormat")) {
            this.imageFileFormat = this.xmlGetAttribute(node, "ImageFileFormat");
        }
        if (this.xmlHasAttribute(node, "ImageWidth")) {
            this.imageWidth = (this.xmlGetAttribute(node, "ImageWidth") ? parseInt(this.xmlGetAttribute(node, "ImageWidth")) : 0);
        }
        if (this.xmlHasAttribute(node, "ImageHeight")) {
            this.imageHeight = (this.xmlGetAttribute(node, "ImageHeight") ? parseInt(this.xmlGetAttribute(node, "ImageHeight")) : 0);
        }
        if (this.xmlHasAttribute(node, "Reason")) {
            this.reason = this.xmlGetAttribute(node, "Reason");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.SignatureInformation.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.SignatureInformation.prototype.value = new Uint8Array(0);
timapi.protocol.sixml.SignatureInformation.prototype.imageFileFormat = undefined;
timapi.protocol.sixml.SignatureInformation.prototype.imageWidth = undefined;
timapi.protocol.sixml.SignatureInformation.prototype.imageHeight = undefined;
timapi.protocol.sixml.SignatureInformation.prototype.reason = undefined;
timapi.protocol.sixml.SignatureInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:SignatureInformation");
    node.textContent = timapi.protocol.ConversionHelper.byteToHexString(this.value);
    if (this.imageFileFormat != undefined) {
        this.xmlSetAttribute(node, "ImageFileFormat", this.imageFileFormat);
    }
    if (this.imageWidth != undefined) {
        this.xmlSetAttribute(node, "ImageWidth", timapi.utils.StringHelper.makeString(this.imageWidth));
    }
    if (this.imageHeight != undefined) {
        this.xmlSetAttribute(node, "ImageHeight", timapi.utils.StringHelper.makeString(this.imageHeight));
    }
    if (this.reason != undefined) {
        this.xmlSetAttribute(node, "Reason", this.reason);
    }
    return node;
};
timapi.protocol.sixml.Statistic = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Statistic) {
        var value = a;
        this.value = value.value;
        this.statisticType = value.statisticType;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        this.value = node.textContent;
        if (this.xmlHasAttribute(node, "StatisticType")) {
            this.statisticType = this.xmlGetAttribute(node, "StatisticType");
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Statistic.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Statistic.prototype.value = "";
timapi.protocol.sixml.Statistic.prototype.statisticType = undefined;
timapi.protocol.sixml.Statistic.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Statistic");
    node.textContent = this.value;
    if (this.statisticType != undefined) {
        this.xmlSetAttribute(node, "StatisticType", this.statisticType);
    }
    return node;
};
timapi.protocol.sixml.StatisticsList = function (a) {
    this.statistic = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.StatisticsList) {
        var value = a;
        for (var each of value.statistic) {
            this.statistic.push(each ? new timapi.protocol.sixml.Statistic(each) : undefined);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:Statistic")) {
            this.statistic.push(new timapi.protocol.sixml.Statistic(each));
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.StatisticsList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.StatisticsList.prototype.statistic = undefined;
timapi.protocol.sixml.StatisticsList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:StatisticsList");
    for (var each of this.statistic) {
        this.xmlAddChild(node, "sixml:Statistic", each);
    }
    return node;
};
timapi.protocol.sixml.TimeoutData = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.TimeoutData) {
        var value = a;
        this.timeoutType = value.timeoutType;
        this.extraTime = value.extraTime;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "TimeoutType")) {
            this.timeoutType = this.xmlGetAttribute(node, "TimeoutType");
        }
        if (this.xmlHasAttribute(node, "ExtraTime")) {
            this.extraTime = (this.xmlGetAttribute(node, "ExtraTime") ? parseInt(this.xmlGetAttribute(node, "ExtraTime")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.TimeoutData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.TimeoutData.prototype.timeoutType = undefined;
timapi.protocol.sixml.TimeoutData.prototype.extraTime = undefined;
timapi.protocol.sixml.TimeoutData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:TimeoutData");
    if (this.timeoutType != undefined) {
        this.xmlSetAttribute(node, "TimeoutType", this.timeoutType);
    }
    if (this.extraTime != undefined) {
        this.xmlSetAttribute(node, "ExtraTime", timapi.utils.StringHelper.makeString(this.extraTime));
    }
    return node;
};
timapi.protocol.sixml.Total = function (a) {
    this.trxDetail = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.Total) {
        var value = a;
        this.currency = value.currency;
        this.exponent = value.exponent;
        this.count = value.count;
        this.amountSum = value.amountSum;
        for (var each of value.trxDetail) {
            this.trxDetail.push(each ? new timapi.protocol.sixml.TrxDetail(each) : undefined);
        }
        this.amountSumOther = value.amountSumOther;
        this.amountSumTip = value.amountSumTip;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "Currency")) {
            this.currency = this.xmlGetAttribute(node, "Currency");
        }
        if (this.xmlHasAttribute(node, "Exponent")) {
            this.exponent = (this.xmlGetAttribute(node, "Exponent") ? parseInt(this.xmlGetAttribute(node, "Exponent")) : 0);
        }
        if (this.xmlHasAttribute(node, "Count")) {
            this.count = (this.xmlGetAttribute(node, "Count") ? parseInt(this.xmlGetAttribute(node, "Count")) : 0);
        }
        if (this.xmlHasAttribute(node, "AmountSum")) {
            this.amountSum = (this.xmlGetAttribute(node, "AmountSum") ? parseInt(this.xmlGetAttribute(node, "AmountSum")) : 0);
        }
        for (var each of this.xmlGetChildren(node, "sixml:TrxDetail")) {
            this.trxDetail.push(new timapi.protocol.sixml.TrxDetail(each));
        }
        if (this.xmlHasAttribute(node, "AmountSumOther")) {
            this.amountSumOther = (this.xmlGetAttribute(node, "AmountSumOther") ? parseInt(this.xmlGetAttribute(node, "AmountSumOther")) : 0);
        }
        if (this.xmlHasAttribute(node, "AmountSumTip")) {
            this.amountSumTip = (this.xmlGetAttribute(node, "AmountSumTip") ? parseInt(this.xmlGetAttribute(node, "AmountSumTip")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.Total.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.Total.prototype.currency = undefined;
timapi.protocol.sixml.Total.prototype.exponent = undefined;
timapi.protocol.sixml.Total.prototype.count = undefined;
timapi.protocol.sixml.Total.prototype.amountSum = undefined;
timapi.protocol.sixml.Total.prototype.trxDetail = undefined;
timapi.protocol.sixml.Total.prototype.amountSumOther = undefined;
timapi.protocol.sixml.Total.prototype.amountSumTip = undefined;
timapi.protocol.sixml.Total.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:Total");
    if (this.currency != undefined) {
        this.xmlSetAttribute(node, "Currency", this.currency);
    }
    if (this.exponent != undefined) {
        this.xmlSetAttribute(node, "Exponent", timapi.utils.StringHelper.makeString(this.exponent));
    }
    if (this.count != undefined) {
        this.xmlSetAttribute(node, "Count", timapi.utils.StringHelper.makeString(this.count));
    }
    if (this.amountSum != undefined) {
        this.xmlSetAttribute(node, "AmountSum", timapi.utils.StringHelper.makeString(this.amountSum));
    }
    for (var each of this.trxDetail) {
        this.xmlAddChild(node, "sixml:TrxDetail", each);
    }
    if (this.amountSumOther != undefined) {
        this.xmlSetAttribute(node, "AmountSumOther", timapi.utils.StringHelper.makeString(this.amountSumOther));
    }
    if (this.amountSumTip != undefined) {
        this.xmlSetAttribute(node, "AmountSumTip", timapi.utils.StringHelper.makeString(this.amountSumTip));
    }
    return node;
};
timapi.protocol.sixml.TransactionData = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.TransactionData) {
        var value = a;
        this.dccAllowed = value.dccAllowed;
        this.partialApprovalAllowed = value.partialApprovalAllowed;
        this.trxOriginalDate = value.trxOriginalDate;
        this.ecrSeqCounter = value.ecrSeqCounter;
        this.transRef = value.transRef;
        this.transSeq = value.transSeq;
        this.cardRef = value.cardRef;
        this.trmTransRef = value.trmTransRef;
        this.acqTransRef = value.acqTransRef;
        this.acqId = value.acqId;
        this.phoneAuthCode = value.phoneAuthCode;
        this.multiCurrencyFlag = value.multiCurrencyFlag;
        this.tipAllowed = value.tipAllowed;
        this.ngvmode = value.ngvmode;
        this.ngvclearingDelay = value.ngvclearingDelay;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "DccAllowed")) {
            this.dccAllowed = this.xmlGetAttribute(node, "DccAllowed") == "1";
        }
        if (this.xmlHasAttribute(node, "PartialApprovalAllowed")) {
            this.partialApprovalAllowed = this.xmlGetAttribute(node, "PartialApprovalAllowed") == "1";
        }
        if (this.xmlHasAttribute(node, "TrxOriginalDate")) {
            this.trxOriginalDate = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TrxOriginalDate"));
        }
        if (this.xmlHasAttribute(node, "EcrSeqCounter")) {
            this.ecrSeqCounter = (this.xmlGetAttribute(node, "EcrSeqCounter") ? parseInt(this.xmlGetAttribute(node, "EcrSeqCounter")) : 0);
        }
        if (this.xmlHasAttribute(node, "TransRef")) {
            this.transRef = (this.xmlGetAttribute(node, "TransRef") ? parseInt(this.xmlGetAttribute(node, "TransRef")) : 0);
        }
        if (this.xmlHasAttribute(node, "TransSeq")) {
            this.transSeq = (this.xmlGetAttribute(node, "TransSeq") ? parseInt(this.xmlGetAttribute(node, "TransSeq")) : 0);
        }
        if (this.xmlHasAttribute(node, "CardRef")) {
            this.cardRef = this.xmlGetAttribute(node, "CardRef");
        }
        if (this.xmlHasAttribute(node, "TrmTransRef")) {
            this.trmTransRef = this.xmlGetAttribute(node, "TrmTransRef");
        }
        if (this.xmlHasAttribute(node, "AcqTransRef")) {
            this.acqTransRef = this.xmlGetAttribute(node, "AcqTransRef");
        }
        if (this.xmlHasAttribute(node, "AcqId")) {
            this.acqId = (this.xmlGetAttribute(node, "AcqId") ? parseInt(this.xmlGetAttribute(node, "AcqId")) : 0);
        }
        if (this.xmlHasAttribute(node, "PhoneAuthCode")) {
            this.phoneAuthCode = this.xmlGetAttribute(node, "PhoneAuthCode");
        }
        if (this.xmlHasAttribute(node, "MultiCurrencyFlag")) {
            this.multiCurrencyFlag = this.xmlGetAttribute(node, "MultiCurrencyFlag") == "1";
        }
        if (this.xmlHasAttribute(node, "TipAllowed")) {
            this.tipAllowed = this.xmlGetAttribute(node, "TipAllowed") == "1";
        }
        if (this.xmlHasAttribute(node, "NGVMode")) {
            this.ngvmode = this.xmlGetAttribute(node, "NGVMode");
        }
        if (this.xmlHasAttribute(node, "NGVClearingDelay")) {
            this.ngvclearingDelay = (this.xmlGetAttribute(node, "NGVClearingDelay") ? parseInt(this.xmlGetAttribute(node, "NGVClearingDelay")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.TransactionData.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.TransactionData.prototype.dccAllowed = undefined;
timapi.protocol.sixml.TransactionData.prototype.partialApprovalAllowed = undefined;
timapi.protocol.sixml.TransactionData.prototype.trxOriginalDate = undefined;
timapi.protocol.sixml.TransactionData.prototype.ecrSeqCounter = undefined;
timapi.protocol.sixml.TransactionData.prototype.transRef = undefined;
timapi.protocol.sixml.TransactionData.prototype.transSeq = undefined;
timapi.protocol.sixml.TransactionData.prototype.cardRef = undefined;
timapi.protocol.sixml.TransactionData.prototype.trmTransRef = undefined;
timapi.protocol.sixml.TransactionData.prototype.acqTransRef = undefined;
timapi.protocol.sixml.TransactionData.prototype.acqId = undefined;
timapi.protocol.sixml.TransactionData.prototype.phoneAuthCode = undefined;
timapi.protocol.sixml.TransactionData.prototype.multiCurrencyFlag = undefined;
timapi.protocol.sixml.TransactionData.prototype.tipAllowed = undefined;
timapi.protocol.sixml.TransactionData.prototype.ngvmode = undefined;
timapi.protocol.sixml.TransactionData.prototype.ngvclearingDelay = undefined;
timapi.protocol.sixml.TransactionData.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:TransactionData");
    if (this.dccAllowed != undefined) {
        this.xmlSetAttribute(node, "DccAllowed", (this.dccAllowed ? "1" : "0"));
    }
    if (this.partialApprovalAllowed != undefined) {
        this.xmlSetAttribute(node, "PartialApprovalAllowed", (this.partialApprovalAllowed ? "1" : "0"));
    }
    if (this.trxOriginalDate != undefined) {
        this.xmlSetAttribute(node, "TrxOriginalDate", this.trxOriginalDate.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.ecrSeqCounter != undefined) {
        this.xmlSetAttribute(node, "EcrSeqCounter", timapi.utils.StringHelper.makeString(this.ecrSeqCounter));
    }
    if (this.transRef != undefined) {
        this.xmlSetAttribute(node, "TransRef", timapi.utils.StringHelper.makeString(this.transRef));
    }
    if (this.transSeq != undefined) {
        this.xmlSetAttribute(node, "TransSeq", timapi.utils.StringHelper.makeString(this.transSeq));
    }
    if (this.cardRef != undefined) {
        this.xmlSetAttribute(node, "CardRef", this.cardRef);
    }
    if (this.trmTransRef != undefined) {
        this.xmlSetAttribute(node, "TrmTransRef", this.trmTransRef);
    }
    if (this.acqTransRef != undefined) {
        this.xmlSetAttribute(node, "AcqTransRef", this.acqTransRef);
    }
    if (this.acqId != undefined) {
        this.xmlSetAttribute(node, "AcqId", timapi.utils.StringHelper.makeString(this.acqId));
    }
    if (this.phoneAuthCode != undefined) {
        this.xmlSetAttribute(node, "PhoneAuthCode", this.phoneAuthCode);
    }
    if (this.multiCurrencyFlag != undefined) {
        this.xmlSetAttribute(node, "MultiCurrencyFlag", (this.multiCurrencyFlag ? "1" : "0"));
    }
    if (this.tipAllowed != undefined) {
        this.xmlSetAttribute(node, "TipAllowed", (this.tipAllowed ? "1" : "0"));
    }
    if (this.ngvmode != undefined) {
        this.xmlSetAttribute(node, "NGVMode", this.ngvmode);
    }
    if (this.ngvclearingDelay != undefined) {
        this.xmlSetAttribute(node, "NGVClearingDelay", timapi.utils.StringHelper.makeString(this.ngvclearingDelay));
    }
    return node;
};
timapi.protocol.sixml.TransactionInformation = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.TransactionInformation) {
        var value = a;
        this.posEntryMode = value.posEntryMode;
        this.cvm = value.cvm;
        this.merchantAction = value.merchantAction;
        this.authCode = value.authCode;
        this.timeStamp = value.timeStamp;
        this.transRef = value.transRef;
        this.transSeq = value.transSeq;
        this.acqId = value.acqId;
        this.trmTransRef = value.trmTransRef;
        this.acqTransRef = value.acqTransRef;
        this.ecrSeqCounter = value.ecrSeqCounter;
        this.signatureInformation = value.signatureInformation ? new timapi.protocol.sixml.SignatureInformation(value.signatureInformation) : undefined;
        this.cardholderName = value.cardholderName;
        this.clientIdentifier = value.clientIdentifier;
        this.accountNumber = value.accountNumber;
        this.personOid = value.personOid;
        this.cardId = value.cardId;
        this.ngvusedFlag = value.ngvusedFlag;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "PosEntryMode")) {
            this.posEntryMode = (this.xmlGetAttribute(node, "PosEntryMode") ? parseInt(this.xmlGetAttribute(node, "PosEntryMode")) : 0);
        }
        if (this.xmlHasAttribute(node, "Cvm")) {
            this.cvm = this.xmlGetAttribute(node, "Cvm");
        }
        if (this.xmlHasAttribute(node, "MerchantAction")) {
            this.merchantAction = this.xmlGetAttribute(node, "MerchantAction");
        }
        if (this.xmlHasAttribute(node, "AuthCode")) {
            this.authCode = this.xmlGetAttribute(node, "AuthCode");
        }
        if (this.xmlHasAttribute(node, "TimeStamp")) {
            this.timeStamp = new timapi.protocol.TimeDate("yyyyMMdd'T'HHmmssZ", this.xmlGetAttribute(node, "TimeStamp"));
        }
        if (this.xmlHasAttribute(node, "TransRef")) {
            this.transRef = (this.xmlGetAttribute(node, "TransRef") ? parseInt(this.xmlGetAttribute(node, "TransRef")) : 0);
        }
        if (this.xmlHasAttribute(node, "TransSeq")) {
            this.transSeq = (this.xmlGetAttribute(node, "TransSeq") ? parseInt(this.xmlGetAttribute(node, "TransSeq")) : 0);
        }
        if (this.xmlHasAttribute(node, "AcqId")) {
            this.acqId = (this.xmlGetAttribute(node, "AcqId") ? parseInt(this.xmlGetAttribute(node, "AcqId")) : 0);
        }
        if (this.xmlHasAttribute(node, "TrmTransRef")) {
            this.trmTransRef = this.xmlGetAttribute(node, "TrmTransRef");
        }
        if (this.xmlHasAttribute(node, "AcqTransRef")) {
            this.acqTransRef = this.xmlGetAttribute(node, "AcqTransRef");
        }
        if (this.xmlHasAttribute(node, "EcrSeqCounter")) {
            this.ecrSeqCounter = (this.xmlGetAttribute(node, "EcrSeqCounter") ? parseInt(this.xmlGetAttribute(node, "EcrSeqCounter")) : 0);
        }
        if (this.xmlHasChild(node, "sixml:SignatureInformation")) {
            this.signatureInformation = new timapi.protocol.sixml.SignatureInformation(this.xmlGetChild(node, "sixml:SignatureInformation"));
        }
        if (this.xmlHasAttribute(node, "CardholderName")) {
            this.cardholderName = this.xmlGetAttribute(node, "CardholderName");
        }
        if (this.xmlHasAttribute(node, "ClientIdentifier")) {
            this.clientIdentifier = this.xmlGetAttribute(node, "ClientIdentifier");
        }
        if (this.xmlHasAttribute(node, "AccountNumber")) {
            this.accountNumber = this.xmlGetAttribute(node, "AccountNumber");
        }
        if (this.xmlHasAttribute(node, "PersonOid")) {
            this.personOid = (this.xmlGetAttribute(node, "PersonOid") ? parseInt(this.xmlGetAttribute(node, "PersonOid")) : 0);
        }
        if (this.xmlHasAttribute(node, "CardId")) {
            this.cardId = this.xmlGetAttribute(node, "CardId");
        }
        if (this.xmlHasAttribute(node, "NGVUsedFlag")) {
            this.ngvusedFlag = this.xmlGetAttribute(node, "NGVUsedFlag") == "1";
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.TransactionInformation.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.TransactionInformation.prototype.posEntryMode = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.cvm = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.merchantAction = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.authCode = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.timeStamp = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.transRef = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.transSeq = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.acqId = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.trmTransRef = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.acqTransRef = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.ecrSeqCounter = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.signatureInformation = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.cardholderName = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.clientIdentifier = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.accountNumber = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.personOid = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.cardId = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.ngvusedFlag = undefined;
timapi.protocol.sixml.TransactionInformation.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:TransactionInformation");
    if (this.posEntryMode != undefined) {
        this.xmlSetAttribute(node, "PosEntryMode", timapi.utils.StringHelper.makeString(this.posEntryMode));
    }
    if (this.cvm != undefined) {
        this.xmlSetAttribute(node, "Cvm", this.cvm);
    }
    if (this.merchantAction != undefined) {
        this.xmlSetAttribute(node, "MerchantAction", this.merchantAction);
    }
    if (this.authCode != undefined) {
        this.xmlSetAttribute(node, "AuthCode", this.authCode);
    }
    if (this.timeStamp != undefined) {
        this.xmlSetAttribute(node, "TimeStamp", this.timeStamp.format("yyyyMMdd'T'HHmmssZ"));
    }
    if (this.transRef != undefined) {
        this.xmlSetAttribute(node, "TransRef", timapi.utils.StringHelper.makeString(this.transRef));
    }
    if (this.transSeq != undefined) {
        this.xmlSetAttribute(node, "TransSeq", timapi.utils.StringHelper.makeString(this.transSeq));
    }
    if (this.acqId != undefined) {
        this.xmlSetAttribute(node, "AcqId", timapi.utils.StringHelper.makeString(this.acqId));
    }
    if (this.trmTransRef != undefined) {
        this.xmlSetAttribute(node, "TrmTransRef", this.trmTransRef);
    }
    if (this.acqTransRef != undefined) {
        this.xmlSetAttribute(node, "AcqTransRef", this.acqTransRef);
    }
    if (this.ecrSeqCounter != undefined) {
        this.xmlSetAttribute(node, "EcrSeqCounter", timapi.utils.StringHelper.makeString(this.ecrSeqCounter));
    }
    if (this.signatureInformation != undefined) {
        this.xmlAddChild(node, "sixml:SignatureInformation", this.signatureInformation);
    }
    if (this.cardholderName != undefined) {
        this.xmlSetAttribute(node, "CardholderName", this.cardholderName);
    }
    if (this.clientIdentifier != undefined) {
        this.xmlSetAttribute(node, "ClientIdentifier", this.clientIdentifier);
    }
    if (this.accountNumber != undefined) {
        this.xmlSetAttribute(node, "AccountNumber", this.accountNumber);
    }
    if (this.personOid != undefined) {
        this.xmlSetAttribute(node, "PersonOid", timapi.utils.StringHelper.makeString(this.personOid));
    }
    if (this.cardId != undefined) {
        this.xmlSetAttribute(node, "CardId", this.cardId);
    }
    if (this.ngvusedFlag != undefined) {
        this.xmlSetAttribute(node, "NGVUsedFlag", (this.ngvusedFlag ? "1" : "0"));
    }
    return node;
};
timapi.protocol.sixml.TrxDetail = function (a) {
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.TrxDetail) {
        var value = a;
        this.aid = value.aid;
        this.dccFlag = value.dccFlag;
        this.transactionType = value.transactionType;
        this.count = value.count;
        this.markup = value.markup;
        this.markupExponent = value.markupExponent;
        this.amountSum = value.amountSum;
        this.amountSumOther = value.amountSumOther;
        this.amountSumTip = value.amountSumTip;
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        if (this.xmlHasAttribute(node, "Aid")) {
            this.aid = this.xmlGetAttribute(node, "Aid");
        }
        if (this.xmlHasAttribute(node, "DccFlag")) {
            this.dccFlag = this.xmlGetAttribute(node, "DccFlag") == "1";
        }
        if (this.xmlHasAttribute(node, "TransactionType")) {
            this.transactionType = this.xmlGetAttribute(node, "TransactionType");
        }
        if (this.xmlHasAttribute(node, "Count")) {
            this.count = (this.xmlGetAttribute(node, "Count") ? parseInt(this.xmlGetAttribute(node, "Count")) : 0);
        }
        if (this.xmlHasAttribute(node, "Markup")) {
            this.markup = (this.xmlGetAttribute(node, "Markup") ? parseInt(this.xmlGetAttribute(node, "Markup")) : 0);
        }
        if (this.xmlHasAttribute(node, "MarkupExponent")) {
            this.markupExponent = (this.xmlGetAttribute(node, "MarkupExponent") ? parseInt(this.xmlGetAttribute(node, "MarkupExponent")) : 0);
        }
        if (this.xmlHasAttribute(node, "AmountSum")) {
            this.amountSum = (this.xmlGetAttribute(node, "AmountSum") ? parseInt(this.xmlGetAttribute(node, "AmountSum")) : 0);
        }
        if (this.xmlHasAttribute(node, "AmountSumOther")) {
            this.amountSumOther = (this.xmlGetAttribute(node, "AmountSumOther") ? parseInt(this.xmlGetAttribute(node, "AmountSumOther")) : 0);
        }
        if (this.xmlHasAttribute(node, "AmountSumTip")) {
            this.amountSumTip = (this.xmlGetAttribute(node, "AmountSumTip") ? parseInt(this.xmlGetAttribute(node, "AmountSumTip")) : 0);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.TrxDetail.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.TrxDetail.prototype.aid = undefined;
timapi.protocol.sixml.TrxDetail.prototype.dccFlag = undefined;
timapi.protocol.sixml.TrxDetail.prototype.transactionType = undefined;
timapi.protocol.sixml.TrxDetail.prototype.count = undefined;
timapi.protocol.sixml.TrxDetail.prototype.markup = undefined;
timapi.protocol.sixml.TrxDetail.prototype.markupExponent = undefined;
timapi.protocol.sixml.TrxDetail.prototype.amountSum = undefined;
timapi.protocol.sixml.TrxDetail.prototype.amountSumOther = undefined;
timapi.protocol.sixml.TrxDetail.prototype.amountSumTip = undefined;
timapi.protocol.sixml.TrxDetail.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:TrxDetail");
    if (this.aid != undefined) {
        this.xmlSetAttribute(node, "Aid", this.aid);
    }
    if (this.dccFlag != undefined) {
        this.xmlSetAttribute(node, "DccFlag", (this.dccFlag ? "1" : "0"));
    }
    if (this.transactionType != undefined) {
        this.xmlSetAttribute(node, "TransactionType", this.transactionType);
    }
    if (this.count != undefined) {
        this.xmlSetAttribute(node, "Count", timapi.utils.StringHelper.makeString(this.count));
    }
    if (this.markup != undefined) {
        this.xmlSetAttribute(node, "Markup", timapi.utils.StringHelper.makeString(this.markup));
    }
    if (this.markupExponent != undefined) {
        this.xmlSetAttribute(node, "MarkupExponent", timapi.utils.StringHelper.makeString(this.markupExponent));
    }
    if (this.amountSum != undefined) {
        this.xmlSetAttribute(node, "AmountSum", timapi.utils.StringHelper.makeString(this.amountSum));
    }
    if (this.amountSumOther != undefined) {
        this.xmlSetAttribute(node, "AmountSumOther", timapi.utils.StringHelper.makeString(this.amountSumOther));
    }
    if (this.amountSumTip != undefined) {
        this.xmlSetAttribute(node, "AmountSumTip", timapi.utils.StringHelper.makeString(this.amountSumTip));
    }
    return node;
};
timapi.protocol.sixml.WatermarkItemList = function (a) {
    this.watermarkItem = [];
    if (arguments.length == 1 && a instanceof timapi.protocol.sixml.WatermarkItemList) {
        var value = a;
        for (var each of value.watermarkItem) {
            this.watermarkItem.push(each);
        }
        return;
    }
    if (arguments.length == 1 && a instanceof timapi.protocol.XmlNode) {
        var node = a;
        for (var each of this.xmlGetChildren(node, "sixml:WatermarkItem")) {
            this.watermarkItem.push(each.textContent);
        }
        return;
    }
    if (arguments.length != 0) {
        throw new Error("Invalid argument");
    }
};
timapi.protocol.sixml.WatermarkItemList.prototype = Object.create(timapi.protocol.Container.prototype);
timapi.protocol.sixml.WatermarkItemList.prototype.watermarkItem = undefined;
timapi.protocol.sixml.WatermarkItemList.prototype.toXmlNode = function () {
    var node = new timapi.protocol.XmlNode("sixml:WatermarkItemList");
    for (var each of this.watermarkItem) {
        this.xmlAddChild(node, "sixml:WatermarkItem", each);
    }
    return node;
};
timapi.statemachine.states.ErrorState = function (context) {
    if (context == undefined) {
        throw new Error("Invalid argument. context is undefined");
    }
    this.context = context;
};
timapi.statemachine.states.ErrorState.loggerName = "timapi.statemachine.states.ErrorState";
timapi.statemachine.states.ErrorState.classname = "ErrorState";
timapi.statemachine.states.ErrorState.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.ErrorState.loggerName);
timapi.statemachine.states.ErrorState.prototype.enterState = function () {
    this.context.actionErrorConnectionLost();
    this.context.actionDisconnect();
    this.context.actionClearPendingEvent();
    if (this.context.conditionIsEnabledAutoConnect()
        && !this.context.conditionRunAwayProtection()) {
        this.context.actionRunAwayProtection();
        this.context.actionConnect();
        this.context.setState(new timapi.statemachine.states.Connecting(this.context));
        return;
    }
    this.context.actionRunAwayProtection();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.ErrorState.prototype.exitState = function () {
};
timapi.statemachine.states.ErrorState.prototype.activate = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.applicationInformation = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.balance = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.cancel = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.changeSettings = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.commit = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.connect = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.counterRequest = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.deactivate = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.disconnect = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.dccRates = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.hardwareInformation = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.initTransaction = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.login = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.logout = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.reboot = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.reconciliation = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.receiptRequest = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.reconfig = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.rollback = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.softwareUpdate = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.systemInformation = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.transaction = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.connected = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.connectFailed = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.disconnected = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.responseRequest = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.responseError = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.responseInvalid = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.responseBusy = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.notificationStatusChanged = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.notificationLicenseChanged = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.notificationKeepAlive = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.timeout = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.keepAliveTimeout = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.keepAliveTimer = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.trxStateBecameIdle = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.closeReader = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.openReader = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.ejectCard = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.openMaintenanceWindow = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.closeMaintenanceWindow = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.holdCommit = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.activateServiceMenu = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.amtAdjustment = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.balanceInquiry = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.openDialogMode = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.closeDialogMode = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.showSignatureCapture = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.showDialog = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.sendCardCommand = Object.illegalState;
timapi.statemachine.states.ErrorState.prototype.toString = function () {
    return this.classname;
};
timapi.statemachine.states.ErrorState.prototype.context = undefined;
timapi.statemachine.AbstractContext = function () {
};
timapi.statemachine.AbstractContext.loggerName = "timapi.statemachine.AbstractContext";
timapi.statemachine.AbstractContext.classname = "AbstractContext";
timapi.statemachine.AbstractContext.logger = timapi.logging.Logger.getLogger(timapi.statemachine.AbstractContext.loggerName);
timapi.statemachine.AbstractContext.prototype.start = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "start");
    this.state = undefined;
    this.setState(new timapi.statemachine.states.Initial(this));
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "start");
};
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoConnect = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoLogin = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledFetchBrands = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoActivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoDeactivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoLogout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsEnabledAutoDisconnect = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingEvent = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingActivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingApplicationInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingBalance = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingChangeSettings = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingCounterRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingDccRates = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingDeactivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingHardwareInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingInitTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingLogin = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingLogout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingReboot = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingReceiptRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingReconciliation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingReconfig = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingSoftwareUpdate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingSystemInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingCancel = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionTransactionNoCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasTerminalFeatures = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionSupportedFeatureAutoCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionMandatoryFeatureAutoCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionIsApplicationInformationNotSupported = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionCanRepeatRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionRunAwayProtection = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasGuideBanking = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasGuideUnattended = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingCloseReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingOpenReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingEjectCard = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingOpenMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingCloseMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingActivateServiceMenu = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasGuideAdvancedRetail = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingBalanceInquiry = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasGuideDialog = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingOpenDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingCloseDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingShowSignatureCapture = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingShowDialog = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.conditionHasPendingSendCardCommand = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionActivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionApplicationInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionBalance = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCancel = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionChangeSettings = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCounterRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionDccRates = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionDeactivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionHardwareInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionInitTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionLogin = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionLogout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionReboot = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionReconciliation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionReconfig = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionReceiptRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionRequestFeatures = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionRollback = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSoftwareUpdate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSystemInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetDefaultLoginRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionConnect = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionDisconnect = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSendErrorResponseDisconnect = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSendKeepAliveNotification = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseActivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseApplicationInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseBalance = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseChangeSettings = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseCounterRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseDeactivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseDccRates = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseError = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseFeatureRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseHardwareInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseInitTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseLogin = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseLogout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseReboot = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseRollback = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseReceiptRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseReconciliation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseReconfig = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseSoftwareUpdate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseSystemInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessNotificationStatusChanged = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessNotificationLicenseChanged = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionNotifyLoginCompleted = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSimulateLogoutCompleted = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSimulateCommitCompleted = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionClearPendingEvent = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingActivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingApplicationInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingBalance = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingChangeSettings = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingCounterRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingDccRates = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingDeactivate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingHardwareInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingInitTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingLogin = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingLogout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingReboot = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingReceiptRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingReconciliation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingReconfig = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingSoftwareUpdate = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingSystemInformation = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingCancel = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionClearPendingCancel = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionErrorConnectionLost = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionErrorInvalidResponse = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionErrorRequestInProgress = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionErrorWrongState = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionErrorTimeout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionErrorDisabledFeature = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionArmTimeoutTransaction = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionArmTimeoutRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionArmTimeoutLongRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCancelTimeout = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionRepeatRequest = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionRunAwayProtection = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCloseReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionOpenReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionEjectCard = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionOpenMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCloseMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionHoldCommit = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionAmtAdjustment = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionActivateServiceMenu = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseCloseReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseOpenReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseEjectCard = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseOpenMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseCloseMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseActivateServiceMenu = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingCloseReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingOpenReader = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingEjectCard = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingOpenMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingCloseMaintenanceWindow = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingActivateServiceMenu = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionBalanceInquiry = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseBalanceInquiry = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingBalanceInquiry = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionOpenDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionCloseDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionShowSignatureCapture = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionShowDialog = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSendCardCommand = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseOpenDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseCloseDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseShowSignatureCapture = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseShowDialog = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionProcessResponseSendCardCommand = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingOpenDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingCloseDialogMode = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingShowSignatureCapture = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingShowDialog = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.actionSetPendingSendCardCommand = Object.abstractFunction;
timapi.statemachine.AbstractContext.prototype.eventActivate = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventActivate");
    try {
        this.state.activate();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventActivate failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventActivate");
};
timapi.statemachine.AbstractContext.prototype.eventApplicationInformation = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventApplicationInformation");
    try {
        this.state.applicationInformation();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventApplicationInformation failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventApplicationInformation");
};
timapi.statemachine.AbstractContext.prototype.eventBalance = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventBalance");
    try {
        this.state.balance();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventBalance failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventBalance");
};
timapi.statemachine.AbstractContext.prototype.eventCancel = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventCancel");
    try {
        this.state.cancel();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventCancel failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventCancel");
};
timapi.statemachine.AbstractContext.prototype.eventChangeSettings = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventChangeSettings");
    try {
        this.state.changeSettings();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventChangeSettings failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventChangeSettings");
};
timapi.statemachine.AbstractContext.prototype.eventCommit = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventCommit");
    try {
        this.state.commit();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventCommit failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventCommit");
};
timapi.statemachine.AbstractContext.prototype.eventConnect = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventConnect");
    try {
        this.state.connect();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventConnect failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventConnect");
};
timapi.statemachine.AbstractContext.prototype.eventCounterRequest = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventCounterRequest");
    try {
        this.state.counterRequest();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventCounterRequest failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventCounterRequest");
};
timapi.statemachine.AbstractContext.prototype.eventDeactivate = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventDeactivate");
    try {
        this.state.deactivate();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventDeactivate failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventDeactivate");
};
timapi.statemachine.AbstractContext.prototype.eventDisconnect = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventDisconnect");
    try {
        this.state.disconnect();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventDisconnect failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventDisconnect");
};
timapi.statemachine.AbstractContext.prototype.eventDccRates = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventDccRates");
    try {
        this.state.dccRates();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventDccRates failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventDccRates");
};
timapi.statemachine.AbstractContext.prototype.eventHardwareInformation = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventHardwareInformation");
    try {
        this.state.hardwareInformation();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventHardwareInformation failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventHardwareInformation");
};
timapi.statemachine.AbstractContext.prototype.eventInitTransaction = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventInitTransaction");
    try {
        this.state.initTransaction();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventInitTransaction failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventInitTransaction");
};
timapi.statemachine.AbstractContext.prototype.eventLogin = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventLogin");
    try {
        this.state.login();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventLogin failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventLogin");
};
timapi.statemachine.AbstractContext.prototype.eventLogout = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventLogout");
    try {
        this.state.logout();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventLogout failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventLogout");
};
timapi.statemachine.AbstractContext.prototype.eventReboot = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventReboot");
    try {
        this.state.reboot();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventReboot failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventReboot");
};
timapi.statemachine.AbstractContext.prototype.eventReconciliation = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventReconciliation");
    try {
        this.state.reconciliation();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventReconciliation failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventReconciliation");
};
timapi.statemachine.AbstractContext.prototype.eventReceiptRequest = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventReceiptRequest");
    try {
        this.state.receiptRequest();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventReceiptRequest failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventReceiptRequest");
};
timapi.statemachine.AbstractContext.prototype.eventReconfig = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventReconfig");
    try {
        this.state.reconfig();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventReconfig failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventReconfig");
};
timapi.statemachine.AbstractContext.prototype.eventRollback = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventRollback");
    try {
        this.state.rollback();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventRollback failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventRollback");
};
timapi.statemachine.AbstractContext.prototype.eventSoftwareUpdate = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventSoftwareUpdate");
    try {
        this.state.softwareUpdate();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventSoftwareUpdate failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventSoftwareUpdate");
};
timapi.statemachine.AbstractContext.prototype.eventSystemInformation = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventSystemInformation");
    try {
        this.state.systemInformation();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventSystemInformation failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventSystemInformation");
};
timapi.statemachine.AbstractContext.prototype.eventTransaction = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventTransaction");
    try {
        this.state.transaction();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventTransaction failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventTransaction");
};
timapi.statemachine.AbstractContext.prototype.eventConnected = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventConnected");
    try {
        this.state.connected();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventConnected failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventConnected");
};
timapi.statemachine.AbstractContext.prototype.eventConnectFailed = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventConnectFailed");
    try {
        this.state.connectFailed();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventConnectFailed failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventConnectFailed");
};
timapi.statemachine.AbstractContext.prototype.eventDisconnected = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventDisconnected");
    try {
        this.state.disconnected();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventDisconnected failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventDisconnected");
};
timapi.statemachine.AbstractContext.prototype.eventResponseRequest = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventResponseRequest");
    try {
        this.state.responseRequest();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventResponseRequest failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventResponseRequest");
};
timapi.statemachine.AbstractContext.prototype.eventResponseError = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventResponseError");
    try {
        this.state.responseError();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventResponseError failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventResponseError");
};
timapi.statemachine.AbstractContext.prototype.eventResponseInvalid = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventResponseInvalid");
    try {
        this.state.responseInvalid();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventResponseInvalid failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventResponseInvalid");
};
timapi.statemachine.AbstractContext.prototype.eventResponseBusy = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventResponseBusy");
    try {
        this.state.responseBusy();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventResponseBusy failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventResponseBusy");
};
timapi.statemachine.AbstractContext.prototype.eventNotificationStatusChanged = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventNotificationStatusChanged");
    try {
        this.state.notificationStatusChanged();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventNotificationStatusChanged failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventNotificationStatusChanged");
};
timapi.statemachine.AbstractContext.prototype.eventNotificationLicenseChanged = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventNotificationLicenseChanged");
    try {
        this.state.notificationLicenseChanged();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventNotificationLicenseChanged failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventNotificationLicenseChanged");
};
timapi.statemachine.AbstractContext.prototype.eventNotificationKeepAlive = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventNotificationKeepAlive");
    try {
        this.state.notificationKeepAlive();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventNotificationKeepAlive failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventNotificationKeepAlive");
};
timapi.statemachine.AbstractContext.prototype.eventTimeout = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventTimeout");
    try {
        this.state.timeout();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventTimeout failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventTimeout");
};
timapi.statemachine.AbstractContext.prototype.eventKeepAliveTimeout = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventKeepAliveTimeout");
    try {
        this.state.keepAliveTimeout();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventKeepAliveTimeout failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventKeepAliveTimeout");
};
timapi.statemachine.AbstractContext.prototype.eventKeepAliveTimer = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventKeepAliveTimer");
    try {
        this.state.keepAliveTimer();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventKeepAliveTimer failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventKeepAliveTimer");
};
timapi.statemachine.AbstractContext.prototype.eventTrxStateBecameIdle = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventTrxStateBecameIdle");
    try {
        this.state.trxStateBecameIdle();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventTrxStateBecameIdle failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventTrxStateBecameIdle");
};
timapi.statemachine.AbstractContext.prototype.eventCloseReader = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventCloseReader");
    try {
        this.state.closeReader();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventCloseReader failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventCloseReader");
};
timapi.statemachine.AbstractContext.prototype.eventOpenReader = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventOpenReader");
    try {
        this.state.openReader();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventOpenReader failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventOpenReader");
};
timapi.statemachine.AbstractContext.prototype.eventEjectCard = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventEjectCard");
    try {
        this.state.ejectCard();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventEjectCard failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventEjectCard");
};
timapi.statemachine.AbstractContext.prototype.eventOpenMaintenanceWindow = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventOpenMaintenanceWindow");
    try {
        this.state.openMaintenanceWindow();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventOpenMaintenanceWindow failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventOpenMaintenanceWindow");
};
timapi.statemachine.AbstractContext.prototype.eventCloseMaintenanceWindow = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventCloseMaintenanceWindow");
    try {
        this.state.closeMaintenanceWindow();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventCloseMaintenanceWindow failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventCloseMaintenanceWindow");
};
timapi.statemachine.AbstractContext.prototype.eventHoldCommit = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventHoldCommit");
    try {
        this.state.holdCommit();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventHoldCommit failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventHoldCommit");
};
timapi.statemachine.AbstractContext.prototype.eventActivateServiceMenu = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventActivateServiceMenu");
    try {
        this.state.activateServiceMenu();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventActivateServiceMenu failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventActivateServiceMenu");
};
timapi.statemachine.AbstractContext.prototype.eventAmtAdjustment = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventAmtAdjustment");
    try {
        this.state.amtAdjustment();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventAmtAdjustment failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventAmtAdjustment");
};
timapi.statemachine.AbstractContext.prototype.eventBalanceInquiry = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventBalanceInquiry");
    try {
        this.state.balanceInquiry();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventBalanceInquiry failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventBalanceInquiry");
};
timapi.statemachine.AbstractContext.prototype.eventOpenDialogMode = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventOpenDialogMode");
    try {
        this.state.openDialogMode();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventOpenDialogMode failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventOpenDialogMode");
};
timapi.statemachine.AbstractContext.prototype.eventCloseDialogMode = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventCloseDialogMode");
    try {
        this.state.closeDialogMode();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventCloseDialogMode failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventCloseDialogMode");
};
timapi.statemachine.AbstractContext.prototype.eventShowSignatureCapture = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventShowSignatureCapture");
    try {
        this.state.showSignatureCapture();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventShowSignatureCapture failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventShowSignatureCapture");
};
timapi.statemachine.AbstractContext.prototype.eventShowDialog = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventShowDialog");
    try {
        this.state.showDialog();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventShowDialog failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventShowDialog");
};
timapi.statemachine.AbstractContext.prototype.eventSendCardCommand = function () {
    timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "eventSendCardCommand");
    try {
        this.state.sendCardCommand();
    }
    catch (e) {
        if (e.name == "TimError" &&
            (e.resultCode == timapi.constants.ResultCode.requestPending
                || e.resultCode == timapi.constants.ResultCode.sixmlWrongState)) {
            throw e;
        }
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Sending event eventSendCardCommand failed on state " +
            this.state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
        return;
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "eventSendCardCommand");
};
timapi.statemachine.AbstractContext.prototype.setState = function (state) {
    if (timapi.statemachine.AbstractContext.logger.isLoggable(timapi.logging.Level.FINEST)) {
        timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "setState", this.state);
    }
    else {
        timapi.statemachine.AbstractContext.logger.entering(timapi.statemachine.AbstractContext.classname, "setState");
    }
    if (state == undefined) {
        throw new Error("state is undefined");
    }
    if (this.state != undefined) {
        try {
            this.state.exitState();
        }
        catch (e) {
            timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Exit state failed on state " +
                this.state.classname + " with no Fail-State set", e);
            this.setState(new timapi.statemachine.states.ErrorState(this));
            return;
        }
    }
    this.state = state;
    try {
        this.state.enterState();
    }
    catch (e) {
        timapi.statemachine.AbstractContext.logger.log(timapi.logging.Level.severe, "Enter state failed on state " +
            state.classname + " with no Fail-State set", e);
        this.setState(new timapi.statemachine.states.ErrorState(this));
    }
    timapi.statemachine.AbstractContext.logger.exiting(timapi.statemachine.AbstractContext.classname, "setState");
};
timapi.statemachine.AbstractContext.prototype.state = undefined;
var timapi;
(function (timapi) {
    var statemachine;
    (function (statemachine) {
        var sixml;
        (function (sixml) {
            class StateMachine extends timapi.statemachine.AbstractContext {
                constructor(backend) {
                    super(backend);
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "<constructor>");
                    if (backend == undefined) {
                        throw new Error();
                    }
                    this.backend = backend;
                    for (var func in this.__proto__) {
                        if (this.__proto__[func] == undefined) {
                            StateMachine.logger.log(timapi.logging.Level.INFO, func + " not implemented!");
                            this.__proto__[func] = function () {
                                StateMachine.logger.log(timapi.logging.Level.WARNING, "Called function not implemented!");
                            };
                        }
                    }
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "<constructor>");
                }
                start() {
                    super.start();
                }
                dispose() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "dispose");
                    this.cancelTaskTimeout();
                    this.cancelTaskKeepAliveCheck();
                    this.cancelTaskKeepAliveDisconnect();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "dispose");
                }
                get $backend() {
                    return this.backend;
                }
                get $lastReceivedMessage() {
                    return this.lastReceivedMessage;
                }
                set $lastReceivedMessage(value) {
                    this.lastReceivedMessage = value;
                }
                set $requestChangeSettings(value) {
                    this.requestChangeSettings = value;
                }
                set $requestCounterRequest(value) {
                    this.requestCounterRequest = value;
                }
                set $requestLogin(value) {
                    this.requestLogin = value;
                }
                set $requestReceiptRequest(value) {
                    this.requestReceiptRequest = value;
                }
                set $requestShowSignatureCapture(value) {
                    this.requestShowSignatureCapture = value;
                }
                set $requestShowDialog(value) {
                    this.requestShowDialog = value;
                }
                set $notificationCancel(value) {
                    this.notificationCancel = value;
                }
                set $requestInitTransaction(value) {
                    this.requestInitTransaction = value;
                }
                set $requestTransaction(value) {
                    this.requestTransaction = value;
                }
                set $requestQueryLoyalty(value) {
                    this.requestQueryLoyalty = value;
                }
                conditionIsEnabledAutoConnect() {
                    return this.backend.$terminal.$settings.$autoConnect;
                }
                conditionIsEnabledAutoLogin() {
                    return this.backend.$terminal.$settings.$autoLogin;
                }
                conditionIsEnabledFetchBrands() {
                    return this.backend.$terminal.$settings.$fetchBrands;
                }
                conditionIsEnabledAutoActivate() {
                    return this.backend.$terminal.$settings.$autoActivate;
                }
                conditionIsEnabledAutoCommit() {
                    return this.backend.$terminal.$settings.$autoCommit;
                }
                conditionIsEnabledAutoDeactivate() {
                    return this.backend.$terminal.$settings.$autoDeactivate;
                }
                conditionIsEnabledAutoLogout() {
                    return this.backend.$terminal.$settings.$autoLogout;
                }
                conditionIsEnabledAutoDisconnect() {
                    return this.backend.$terminal.$settings.$autoDisconnect;
                }
                conditionHasTerminalFeatures() {
                    return this.backend.$features !== undefined;
                }
                conditionSupportedFeatureAutoCommit() {
                    return (this.backend.$features !== undefined &&
                        this.backend.$features.$sixml.$autoCommit ===
                            timapi.Support.supported);
                }
                conditionMandatoryFeatureAutoCommit() {
                    return (this.backend.$features !== undefined &&
                        this.backend.$features.$sixml.$autoCommit ===
                            timapi.Support.mandatory);
                }
                conditionIsApplicationInformationNotSupported() {
                    return (this.backend.$features !== undefined &&
                        !this.backend.$features.$sixml.$statusFunctions.has(timapi.constants.StatusFunctions.applicationInformation));
                }
                conditionHasPendingEvent() {
                    return this.pendingRequest !== undefined;
                }
                conditionHasPendingActivate() {
                    return this.pendingRequest === timapi.constants.RequestType.activate;
                }
                conditionHasPendingApplicationInformation() {
                    return (this.pendingRequest ===
                        timapi.constants.RequestType.applicationInformation);
                }
                conditionHasPendingBalance() {
                    return this.pendingRequest === timapi.constants.RequestType.balance;
                }
                conditionHasPendingChangeSettings() {
                    return (this.pendingRequest === timapi.constants.RequestType.changeSettings);
                }
                conditionHasPendingCommit() {
                    return this.pendingRequest === timapi.constants.RequestType.commit;
                }
                conditionHasPendingCounterRequest() {
                    return (this.pendingRequest === timapi.constants.RequestType.counterRequest);
                }
                conditionHasPendingDccRates() {
                    return this.pendingRequest === timapi.constants.RequestType.dccRates;
                }
                conditionHasPendingDeactivate() {
                    return this.pendingRequest === timapi.constants.RequestType.deactivate;
                }
                conditionHasPendingHardwareInformation() {
                    return (this.pendingRequest === timapi.constants.RequestType.hardwareInformation);
                }
                conditionHasPendingInitTransaction() {
                    return (this.pendingRequest === timapi.constants.RequestType.initTransaction);
                }
                conditionHasPendingLogin() {
                    return this.pendingRequest === timapi.constants.RequestType.login;
                }
                conditionHasPendingLogout() {
                    return this.pendingRequest === timapi.constants.RequestType.logout;
                }
                conditionHasPendingReboot() {
                    return this.pendingRequest === timapi.constants.RequestType.reboot;
                }
                conditionHasPendingReceiptRequest() {
                    return (this.pendingRequest === timapi.constants.RequestType.receiptRequest);
                }
                conditionHasPendingReconfig() {
                    return this.pendingRequest === timapi.constants.RequestType.reconfig;
                }
                conditionHasPendingReconciliation() {
                    return (this.pendingRequest === timapi.constants.RequestType.reconciliation);
                }
                conditionHasPendingSoftwareUpdate() {
                    return (this.pendingRequest === timapi.constants.RequestType.softwareUpdate);
                }
                conditionHasPendingSystemInformation() {
                    return (this.pendingRequest === timapi.constants.RequestType.systemInformation);
                }
                conditionHasPendingTransaction() {
                    return this.pendingRequest === timapi.constants.RequestType.transaction;
                }
                conditionHasPendingCancel() {
                    return this.hasPendingCancel;
                }
                conditionTransactionNoCommit() {
                    if (this.lastReceivedMessage == undefined) {
                        return true;
                    }
                    switch (this.lastReceivedMessage.attributes.get("Function")) {
                        case timapi.protocol.constants.Function.credit:
                        case timapi.protocol.constants.Function.combined:
                        case timapi.protocol.constants.Function.giro:
                        case timapi.protocol.constants.Function.finalizePurchase:
                        case timapi.protocol.constants.Function.purchase:
                        case timapi.protocol.constants.Function.purchaseForcedAcceptance:
                        case timapi.protocol.constants.Function.purchasePhoneAuthorized:
                        case timapi.protocol.constants.Function.purchaseReservation:
                        case timapi.protocol.constants.Function.purchaseWithCashback:
                            return false;
                        case timapi.protocol.constants.Function.adjustReservation:
                        case timapi.protocol.constants.Function.authorizeCredit:
                        case timapi.protocol.constants.Function.authorizeDeposit:
                        case timapi.protocol.constants.Function.balanceInquiry:
                        case timapi.protocol.constants.Function.bankingBalanceInquiry:
                        case timapi.protocol.constants.Function.cancelReservation:
                        case timapi.protocol.constants.Function.cashAdvance:
                        case timapi.protocol.constants.Function.collectPoints:
                        case timapi.protocol.constants.Function.loadVoucher:
                        case timapi.protocol.constants.Function.preAuthorization:
                        case timapi.protocol.constants.Function.queryLoyalty:
                        case timapi.protocol.constants.Function.reservation:
                        case timapi.protocol.constants.Function.reversal:
                        default:
                            return true;
                    }
                }
                conditionRunAwayProtection() {
                    return (this.runAwayTime !== undefined &&
                        new Date().getTime() - this.runAwayTime < 1000);
                }
                actionActivate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionActivate");
                    let message = new timapi.protocol.sixml.Request_Activate();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    message.usrId = this.backend.$terminal.$userId;
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionActivate");
                }
                actionApplicationInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionApplicationInformation");
                    let message = new timapi.protocol.sixml.Request_ApplicationInformation();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionApplicationInformation");
                }
                actionBalance() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionBalance");
                    let message = new timapi.protocol.sixml.Request_Balance();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionBalance");
                }
                actionCancel() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCancel");
                    let message = this.notificationCancel;
                    this.notificationCancel = undefined;
                    this.backend.sendNotification(message);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCancel");
                }
                actionChangeSettings() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionChangeSettings");
                    let message = this.requestChangeSettings;
                    this.requestChangeSettings = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionChangeSettings");
                }
                actionCommit() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCommit");
                    let message = new timapi.protocol.sixml.Request_Commit();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCommit");
                }
                actionCounterRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCounterRequest");
                    let message = this.requestCounterRequest;
                    this.requestCounterRequest = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCounterRequest");
                }
                actionDccRates() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionDccRates");
                    let message = new timapi.protocol.sixml.Request_DccRates();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionDccRates");
                }
                actionDeactivate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionDeactivate");
                    let message = new timapi.protocol.sixml.Request_Deactivate();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionDeactivate");
                }
                actionHardwareInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionHardwareInformation");
                    let message = new timapi.protocol.sixml.Request_HardwareInformation();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionHardwareInformation");
                }
                actionInitTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionInitTransaction");
                    let message = this.requestInitTransaction;
                    this.requestLogin = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionInitTransaction");
                }
                actionLogin() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionLogin");
                    let message = this.requestLogin;
                    this.requestLogin = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionLogin");
                }
                actionLogout() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionLogout");
                    let message = new timapi.protocol.sixml.Request_Logout();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionLogout");
                }
                actionReboot() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionReboot");
                    let message = new timapi.protocol.sixml.Request_Reboot();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionReboot");
                }
                actionReconciliation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionReconciliation");
                    let message = new timapi.protocol.sixml.Request_Reconciliation();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionReconciliation");
                }
                actionReconfig() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionReconfig");
                    let message = new timapi.protocol.sixml.Request_Reconfig();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionReconfig");
                }
                actionReceiptRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionReceiptRequest");
                    let message = this.requestReceiptRequest;
                    this.requestReceiptRequest = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionReceiptRequest");
                }
                actionRequestFeatures() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionRequestFeatures");
                    let message = new timapi.protocol.sixml.Request_FeatureRequest();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionRequestFeatures");
                }
                actionRollback() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionRollback");
                    let message = new timapi.protocol.sixml.Request_Rollback();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionRollback");
                }
                actionSoftwareUpdate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSoftwareUpdate");
                    let message = new timapi.protocol.sixml.Request_SoftwareUpdate();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSoftwareUpdate");
                }
                actionSystemInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSystemInformation");
                    let message = new timapi.protocol.sixml.Request_SystemInformation();
                    if (this.backend.$terminal.$ecrData.length > 0) {
                        let ecrData = new timapi.protocol.sixml.EcrData();
                        for (let entry of this.backend.$terminal.$ecrData) {
                            let ecrInfo = new timapi.protocol.sixml.EcrInfo();
                            ecrInfo.ecrInfoArchitecture = entry.$architecture;
                            ecrInfo.ecrInfoManufacturerName = entry.$manufacturerName;
                            ecrInfo.ecrInfoName = entry.$name;
                            ecrInfo.ecrInfoSerialNumber = entry.$serialNumber;
                            ecrInfo.ecrInfoType = timapi.protocol.constants.EcrInfoType.timApi2Protocol(entry.$type);
                            ecrInfo.ecrInfoVers = entry.$version;
                            ecrInfo.integratorSolution = entry.$integratorSolution;
                            ecrInfo.remoteIp = entry.$remoteIp;
                            ecrData.ecrInfo.push(ecrInfo);
                        }
                        message.ecrData = ecrData;
                    }
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSystemInformation");
                }
                actionTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionTransaction");
                    if (this.requestTransaction instanceof timapi.protocol.sixml.Request_Purchase) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_Credit) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_Reversal) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_PreAuthorization) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_FinalizePurchase) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_PurchaseForcedAcceptance) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_CashAdvance) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_PurchaseWithCashback) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.equenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_PurchasePhoneAuthorized) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_Reservation) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_AdjustReservation) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_CancelReservation) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else if (this.requestTransaction instanceof timapi.protocol.sixml.Request_PurchaseReservation) {
                        let message = this.requestTransaction;
                        this.requestTransaction = undefined;
                        message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                        this.backend.sendMessage(message);
                        this.armKeepAliveTimer();
                    }
                    else {
                        throw new Error();
                    }
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionTransaction");
                }
                actionSetDefaultLoginRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetDefaultLoginRequest");
                    this.$requestLogin = timapi.statemachine.sixml.ConvertTimApi2SIXml.createLoginRequest(this.backend.$terminal);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetDefaultLoginRequest");
                }
                actionConnect() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionConnect");
                    this.backend.commConnect();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionConnect");
                }
                actionDisconnect() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionDisconnect");
                    this.backend.commDisconnect();
                    this.backend.setDisconnectedTerminalStatus();
                    this.backend.notifyTerminalStatusChanged();
                    this.backend.notifyDisconnected();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionDisconnect");
                }
                actionSendKeepAliveNotification() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSendKeepAliveNotification");
                    this.backend.sendNotification(new timapi.protocol.sixml.Notification_KeepAlive());
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSendKeepAliveNotification");
                }
                actionSendErrorResponseDisconnect() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSendErrorResponseDisconnect");
                    this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiConnectionLostTerminal));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSendErrorResponseDisconnect");
                }
                actionProcessResponseActivate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseActivate");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_Activate(this.lastReceivedMessage);
                        timResponse = new timapi.ActivateResponse(timapi.statemachine.sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), response.actSeqCounter);
                        this.backend.notifyActivateCompleted(undefined, timResponse);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseActivate: exception", error);
                        throw error;
                    }
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseActivate");
                }
                actionProcessResponseApplicationInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseApplicationInformation");
                    let timBrands = new Array();
                    try {
                        let response = new timapi.protocol.sixml
                            .Response_ApplicationInformation(this.lastReceivedMessage);
                        for (let brand of response.brandList.brand) {
                            let timApplications = new Array();
                            for (let application of brand.application) {
                                timApplications.push(new timapi.Application(application.$aid, application.$applicationLabel));
                            }
                            let timCurrencies = new Array();
                            for (let item of brand.currencyList.currencyItem) {
                                timCurrencies.push(new timapi.CurrencyItem(timapi.constants.Currency["item.value"], timapi.protocol.constants.CurrencyType.protocol2TimApi(item.currencyType)));
                            }
                            timBrands.push(new timapi.Brands(brand.brandName, brand.dccAvailable, timapi.protocol.constants.PaymentProtocol.protocol2TimApi(brand.paymentProtocol), brand.$acqId, timapi.statemachine.sixml.ConvertSIXml2TimApi.convertTimeDateOrNull(brand.$lastInitDate), timApplications, timCurrencies));
                        }
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseApplicationInformation: exception", error);
                        throw error;
                    }
                    this.backend.$brands(timBrands);
                    this.backend.notifyApplicationInformationCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseApplicationInformation");
                }
                actionProcessResponseBalance() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseBalance");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_Balance(this.lastReceivedMessage);
                        timResponse = new timapi.BalanceResponse(timapi.statemachine.sixml.ConvertSIXml2TimApi.convertCounters(response.counters), timapi.statemachine.sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData));
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseBalance: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyBalanceCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseBalance");
                }
                actionProcessResponseChangeSettings() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseChangeSettings");
                    this.backend.notifyChangeSettingsCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseChangeSettings");
                }
                actionProcessResponseCommit() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseCommit");
                    this.backend.notifyCommitCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseCommit");
                }
                actionProcessResponseCounterRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseCounterRequest");
                    let timCounters;
                    try {
                        let response = new timapi.protocol.sixml.Response_CounterRequest(this.lastReceivedMessage);
                        timCounters = timapi.statemachine.sixml.ConvertSIXml2TimApi.convertCounters(response.counters);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseCounterRequest: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyCounterRequestCompleted(undefined, timCounters);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseCounterRequest");
                }
                actionProcessResponseDeactivate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseDeactivate");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_Deactivate(this.lastReceivedMessage);
                        timResponse = new timapi.DeactivateResponse(timapi.statemachine.sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), timapi.statemachine.sixml.ConvertSIXml2TimApi.convertCountersOrNull(response.counters));
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseDeactivate: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyDeactivateCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseDeactivate");
                }
                actionProcessResponseDccRates() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseDccRates");
                    let timPrintData;
                    try {
                        let response = new timapi.protocol.sixml.Response_DccRates(this.lastReceivedMessage);
                        timPrintData = timapi.statemachine.sixml.ConvertSIXml2TimApi.convertPrintData(response.printData);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseDccRates: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyDccRatesCompleted(undefined, timPrintData);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseDccRates");
                }
                actionProcessResponseError() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseError");
                    let response = new timapi.protocol.sixml.Response_Error(this.lastReceivedMessage);
                    let resultCode = timapi.protocol.constants.ResultCode.protocol2TimApi(response.resultCode);
                    if (resultCode == undefined) {
                        resultCode = timapi.constants.ResultCode.sixmlGeneralError;
                    }
                    let additionalErrorInfo = new Map();
                    if (response.additionalErrorInfoList !== undefined) {
                        for (let each of response.additionalErrorInfoList.additionalErrorInfo) {
                            additionalErrorInfo.set(each.additionalErrorInfoType, each.value);
                        }
                    }
                    this.backend.failRunningRequest(new timapi.TimException(resultCode, timapi.ErrorMessages.getErrorMessage(resultCode, this.backend.$terminal), timapi.statemachine.sixml.ConvertSIXml2TimApi.convertNativeErrorOrNull(response.nativeError), timapi.statemachine.sixml.ConvertSIXml2TimApi.convertPpInfoOrNull(response.ppInfo), additionalErrorInfo, timapi.statemachine.sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData)));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseError");
                }
                actionProcessResponseFeatureRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseFeatureRequest");
                    let timFeatures;
                    let terminalId = "";
                    try {
                        let response = new timapi.protocol.sixml.Response_FeatureRequest(this.lastReceivedMessage);
                        terminalId = response.terminalId;
                        let mapSupport = new Map([
                            ["0", timapi.Support.disabled],
                            ["1", timapi.Support.supported],
                            ["2", timapi.Support.mandatory]
                        ]);
                        let hwCardholderDisplay = false;
                        let hwMerchantDisplay = false;
                        let hwPrinter = false;
                        let hwDisplayBrightness = false;
                        let hwDisplayContrast = false;
                        let hwAlertTones = false;
                        let hwKeypadTones = false;
                        let payDcc = false;
                        let payDeclinedReceipts = false;
                        let payPartialApproval = false;
                        let payEp2Available = false;
                        let payEp2Dcc = false;
                        let payEp2DeclinedReceipts = false;
                        let payEp2MultiAccountSelection = false;
                        let payEp2MultiContractSelection = false;
                        let sixmlAdminFunctions = new Set();
                        let sixmlAutoCommit = timapi.Support.disabled;
                        let sixmlAutoShiftManagement = timapi.Support.disabled;
                        let sixmlAutoShutterManagement = timapi.Support.disabled;
                        let sixmlFinancialFunctions = new Set();
                        let sixmlGuides = new Set();
                        let sixmlNonFinancialFunctions = new Set();
                        let sixmlProtocolLevels = new Set();
                        let sixmlSleepTimer = false;
                        let sixmlStatusFunctions = new Set();
                        let sixmlDialogFunctions = new Set();
                        for (let feature of response.features.feature) {
                            switch (feature.featureType) {
                                case timapi.protocol.constants.FeatureType
                                    .hardwareDisplayCardHolderInstalled:
                                    hwCardholderDisplay = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .hardwareDisplayMerchantInstalled:
                                    hwMerchantDisplay = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.hardwarePrinterInstalled:
                                    hwPrinter = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .hardwareSettingDisplayBrightness:
                                    hwDisplayBrightness = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .hardwareSettingDisplayContrast:
                                    hwDisplayContrast = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .hardwareSettingTonesAlert:
                                    hwAlertTones = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .hardwareSettingTonesKeypad:
                                    hwKeypadTones = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.paymentDcc:
                                    payDcc = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.paymentDeclinedReceipts:
                                    payDeclinedReceipts = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.paymentPartialApproval:
                                    payPartialApproval = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.paymentPartialCommit:
                                    break;
                                case timapi.protocol.constants.FeatureType.ep2Available:
                                    payEp2Available = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.ep2Dcc:
                                    payEp2Dcc = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.ep2DeclinedReceipts:
                                    payEp2DeclinedReceipts = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.ep2MultiAccountSelection:
                                    payEp2MultiAccountSelection = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .ep2MultiContractSelection:
                                    payEp2MultiContractSelection = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlAdminFunctions:
                                    sixmlAdminFunctions = timapi.protocol.constants.AdminFunctions.protocol2TimApi(parseInt(feature.value, 16));
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlAutoCommit:
                                    sixmlAutoCommit = mapSupport.get(feature.value);
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlAutoShiftManagement:
                                    sixmlAutoShiftManagement = mapSupport.get(feature.value);
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .sixmlAutoShutterManagement:
                                    sixmlAutoShutterManagement = mapSupport.get(feature.value);
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlDialogFunctions:
                                    sixmlDialogFunctions = timapi.protocol.constants.DialogFunctions.protocol2TimApi(parseInt(feature.value, 16));
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .sixmlFinancialTransactions:
                                    sixmlFinancialFunctions = timapi.protocol.constants.FinancialTransactions.protocol2TimApi(parseInt(feature.value, 16));
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlGuides:
                                    sixmlGuides = timapi.protocol.constants.Guides.protocol2TimApi(parseInt(feature.value, 16));
                                    break;
                                case timapi.protocol.constants.FeatureType
                                    .sixmlNonFinancialTransactions:
                                    sixmlNonFinancialFunctions = timapi.protocol.constants.NonFinancialTransactions.protocol2TimApi(parseInt(feature.value, 16));
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlProtocolLevel:
                                    {
                                        let protocolValue = parseInt(feature.value, undefined);
                                        let pl = timapi.protocol.constants.ProtocolLevel.protocol2TimApiIfValid(protocolValue);
                                        if (pl !== undefined) {
                                            sixmlProtocolLevels.add(pl);
                                        }
                                    }
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlRemoteFunctions:
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlSleepTimer:
                                    sixmlSleepTimer = feature.value === "1";
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlStatusFunctions:
                                    sixmlStatusFunctions = timapi.protocol.constants.StatusFunctions.protocol2TimApi(parseInt(feature.value, 16));
                                    break;
                                case timapi.protocol.constants.FeatureType.sixmlSwUpdateInformation:
                                    break;
                                default:
                                    break;
                            }
                        }
                        timFeatures = new timapi.Features(new timapi.FeaturesHardware(hwCardholderDisplay, hwMerchantDisplay, hwPrinter, hwDisplayBrightness, hwDisplayContrast, hwAlertTones, hwKeypadTones), new timapi.FeaturesPayment(payDcc, payDeclinedReceipts, payPartialApproval, payEp2Available, payEp2Dcc, payEp2DeclinedReceipts, payEp2MultiAccountSelection, payEp2MultiContractSelection), new timapi.FeaturesSixml(sixmlAdminFunctions, sixmlAutoCommit, sixmlAutoShiftManagement, sixmlAutoShutterManagement, sixmlFinancialFunctions, sixmlGuides, sixmlNonFinancialFunctions, sixmlProtocolLevels, sixmlSleepTimer, sixmlStatusFunctions, sixmlDialogFunctions));
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseFeatureRequest: exception", [error]);
                        throw error;
                    }
                    this.backend.$terminalId = terminalId;
                    this.backend.$features = timFeatures;
                    if (this.requestLogin !== undefined) {
                        if (this.backend.$terminal.$settings.$autoCommit &&
                            timFeatures.$sixml.$autoCommit === timapi.Support.disabled) {
                            for (let each of this.requestLogin.protocolOptionList.protocolOption) {
                                if (each.optionType === timapi.protocol.constants.OptionType.sixmlAutoCommit) {
                                    each.value = 0;
                                }
                            }
                        }
                        let protocolLevel = timapi.statemachine.sixml.ConvertTimApi2SIXml.findMatchingProtocolLevel(this.backend.$terminal);
                        if (protocolLevel != 0) {
                            for (let each of this.requestLogin.protocolOptionList.protocolOption) {
                                if (each.optionType === timapi.protocol.constants.OptionType.sixmlProtocolLevel) {
                                    each.value = String(protocolLevel);
                                }
                            }
                        }
                        else {
                            this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiFunctionDisallowed));
                            throw new timapi.TimException(timapi.constants.ResultCode.apiFunctionDisallowed);
                        }
                    }
                    if (this.pendingRequest !== undefined &&
                        !this.backend.isPendingRequestAllowed()) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiFunctionDisallowed));
                        throw new timapi.TimException(timapi.constants.ResultCode.apiFunctionDisallowed);
                    }
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseFeatureRequest");
                }
                actionProcessResponseHardwareInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseHardwareInformation");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_HardwareInformation(this.lastReceivedMessage);
                        let timHardwares = new Array();
                        for (let hardware of response.hardwareList.hardware) {
                            timHardwares.push(new timapi.Hardware(timapi.protocol.constants.HardwareType.protocol2TimApi(hardware.hardwareType), hardware.serialNumber, timapi.statemachine.sixml.ConvertSIXml2TimApi.convertTimeDateOrNull(hardware.productionDate), hardware.productVersion, hardware.firmwareVersion, timapi.protocol.constants.SecurityStatus.protocol2TimApi(hardware.securityStatus), timapi.statemachine.sixml.ConvertSIXml2TimApi.convertTimeDateOrNull(hardware.lastCleaningDate)));
                        }
                        let timKernelVersions = new Map();
                        for (let kernelVersion of response.kernelVersionList.kernelVersion) {
                            timKernelVersions.set(timapi.protocol.constants.KernelType.protocol2TimApi(kernelVersion.kernelType), kernelVersion.value);
                        }
                        let timSettings = new Map();
                        for (let setting of response.settingsList.setting) {
                            timSettings.set(timapi.protocol.constants.SettingType.protocol2TimApi(setting.settingType), setting.value);
                        }
                        let timStatistics = new Map();
                        if (this.backend.$terminal.$settings.$guides.has(timapi.constants.Guides.unattended)) {
                            for (let statistic of response.statisticsList.statistic) {
                                timStatistics.set(statistic.statisticType, statistic.value);
                            }
                        }
                        timResponse = new timapi.HardwareInformationResponse(timHardwares, timKernelVersions, timSettings, timStatistics);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseHardwareInformation: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyHardwareInformationCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseHardwareInformation");
                }
                actionProcessResponseInitTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseInitTransaction");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_InitTransaction(this.lastReceivedMessage);
                        timResponse = sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseInitTransaction: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyInitTransactionCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseInitTransaction", [timResponse]);
                }
                actionProcessResponseLogin() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseLogin");
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseLogin");
                }
                actionProcessResponseLogout() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseLogout");
                    this.backend.notifyLogoutCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseLogout");
                }
                actionProcessResponseReboot() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseReboot");
                    this.backend.notifyRebootCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseReboot");
                }
                actionProcessResponseRollback() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseRollback");
                    let timPrintData;
                    try {
                        let response = new timapi.protocol.sixml.Response_Rollback(this.lastReceivedMessage);
                        timPrintData = sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseRollback: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyRollbackCompleted(undefined, timPrintData);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseRollback");
                }
                actionProcessResponseReceiptRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseReceiptRequest");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_ReceiptRequest(this.lastReceivedMessage);
                        timResponse = new timapi.ReceiptRequestResponse(sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), response.getHasMoreReceipts());
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseReceiptRequest: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyReceiptRequestCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseReceiptRequest");
                }
                actionProcessResponseReconciliation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseReconciliation");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_Reconciliation(this.lastReceivedMessage);
                        timResponse = new timapi.ReconciliationResponse(sixml.ConvertSIXml2TimApi.convertCounters(response.counters), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData));
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseReconciliation: exception", error);
                        throw error;
                    }
                    this.backend.notifyReconciliationCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseReconciliation");
                }
                actionProcessResponseReconfig() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseReconfig");
                    let timPrintData;
                    try {
                        let response = new timapi.protocol.sixml.Response_Reconfig(this.lastReceivedMessage);
                        timPrintData = sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData);
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseReconfig: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyReconfigCompleted(undefined, timPrintData);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseReconfig");
                }
                actionProcessResponseSoftwareUpdate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseSoftwareUpdate");
                    let timStatus;
                    try {
                        let response = new timapi.protocol.sixml.Response_SoftwareUpdate(this.lastReceivedMessage);
                        timStatus = timapi.protocol.constants.UpdateStatus.protocol2TimApi(response.getUpdateStatus());
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseSoftwareUpdate: exception", [error]);
                        throw error;
                    }
                    this.backend.notifySoftwareUpdateCompleted(undefined, timStatus);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseSoftwareUpdate");
                }
                actionProcessResponseSystemInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseSystemInformation");
                    let timResponse;
                    try {
                        let response = new timapi.protocol.sixml.Response_SystemInformation(this.lastReceivedMessage);
                        let timReceiptHeader = new Array();
                        for (let header of response.configData.receiptHeader) {
                            while (timReceiptHeader.length < header.lineNum) {
                                timReceiptHeader.push("");
                            }
                            timReceiptHeader[header.lineNum - 1] = header.value;
                        }
                        this.backend.$configData(new timapi.ConfigData(timReceiptHeader, response.configData.language));
                        timResponse = new timapi.SystemInformationResponse(new timapi.NetworkInformation(response.networkInformation.terminalIp, response.networkInformation.terminalIpMask, response.networkInformation.terminalIpGw, response.networkInformation.terminalIpDns));
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseSystemInformation: exception", [error]);
                        throw error;
                    }
                    this.backend.notifySystemInformationCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseSystemInformation");
                }
                actionProcessResponseTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseTransaction");
                    let timResponse;
                    try {
                        let guides = this.backend.$terminal.$settings.$guides;
                        switch (this.lastReceivedMessage.attributes.get("Function")) {
                            case timapi.protocol.constants.Function.purchase:
                                {
                                    let response = new timapi.protocol.sixml.Response_Purchase(this.lastReceivedMessage);
                                    let tipAmount;
                                    if (guides.has(timapi.constants.Guides.gastro)) {
                                        tipAmount = sixml.ConvertSIXml2TimApi.convertAmountTipOrNull(response.amountTip);
                                    }
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.purchase, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), tipAmount, sixml.ConvertSIXml2TimApi.convertAdditionalInfoOrEmpty(response.additionalInfoList), sixml.ConvertSIXml2TimApi.convertBasketOrEmpty(response.basket));
                                }
                                break;
                            case timapi.protocol.constants.Function.credit:
                                {
                                    let response = new timapi.protocol.sixml.Response_Credit(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.credit, sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amount), undefined, sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), new Array());
                                }
                                break;
                            case timapi.protocol.constants.Function.reversal:
                                {
                                    let response = new timapi.protocol.sixml.Response_Reversal(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.reversal, sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amount), undefined, sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, undefined, sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), new Array());
                                }
                                break;
                            case timapi.protocol.constants.Function.preAuhtorization:
                                {
                                    let response = new timapi.protocol.sixml
                                        .Response_PreAuthorization(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.PRE_AUTHORIZATION, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), undefined, sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformation(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, sixml.ConvertSIXml2TimApi.convertAdditionalInfoOrEmpty(response.additionalInfoList), sixml.ConvertSIXml2TimApi.convertBasketOrEmpty(response.basket));
                                }
                                break;
                            case timapi.protocol.constants.Function.finalizePurchase:
                                {
                                    let response = new timapi.protocol.sixml
                                        .Response_FinalizePurchase(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.finalizePurchase, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), undefined, undefined, undefined, undefined, undefined, undefined, sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), sixml.ConvertSIXml2TimApi.convertBasketOrEmpty(response.basket));
                                }
                                break;
                            case timapi.protocol.constants.Function.purchaseForcedAcceptance:
                                {
                                    let response = new timapi.protocol.sixml
                                        .Response_PurchaseForcedAcceptance(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.purchaseForcedAcceptance, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), new Array());
                                }
                                break;
                            case timapi.protocol.constants.Function.cashAdvance:
                                {
                                    let response = new timapi.protocol.sixml.Response_CashAdvance(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.cashAdvance, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), new Array());
                                }
                                break;
                            case timapi.protocol.constants.Function.purchaseWithCashback:
                                {
                                    let response = new timapi.protocol.sixml
                                        .Response_PurchaseWithCashback(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.purchaseWithCashback, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), new Array());
                                }
                                break;
                            case timapi.protocol.constants.Function.purchasePhoneAuthorized:
                                {
                                    let response = new timapi.protocol.sixml.Response_PurchasePhoneAuthorized(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.purchasePhoneAuthorized, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), new Array());
                                }
                                break;
                            case timapi.protocol.constants.Function.reservation:
                                {
                                    let response = new timapi.protocol.sixml.Response_Reservation(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.reservation, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), undefined, sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), undefined);
                                }
                                break;
                            case timapi.protocol.constants.Function.adjustReservation:
                                {
                                    let response = new timapi.protocol.sixml.Response_AdjustReservation(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.adjustReservation, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), undefined, sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation, this.$backend.$terminalId), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), undefined);
                                }
                                break;
                            case timapi.protocol.constants.Function.cancelReservation:
                                {
                                    let response = new timapi.protocol.sixml.Response_CancelReservation(this.lastReceivedMessage);
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.cancelReservation, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), undefined, undefined, undefined, sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation, this.$backend.$terminalId), undefined, undefined, sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), undefined, new Map(), undefined);
                                }
                                break;
                            case timapi.protocol.constants.Function.purchaseReservation:
                                {
                                    let response = new timapi.protocol.sixml.Response_PurchaseReservation(this.lastReceivedMessage);
                                    let tipAmount = undefined;
                                    if (guides.has(timapi.constants.Guides.gastro)) {
                                        tipAmount = sixml.ConvertSIXml2TimApi.convertAmountTipOrNull(response.amountTip);
                                    }
                                    timResponse = new timapi.TransactionResponse(timapi.constants.TransactionType.purchaseReservation, sixml.ConvertSIXml2TimApi.convertAmount(response.amount), sixml.ConvertSIXml2TimApi.convertAmountOrNull(response.amountDue), sixml.ConvertSIXml2TimApi.convertAmountDccOrNull(response.amountDcc), undefined, sixml.ConvertSIXml2TimApi.convertTransactionInformationOrNull(response.transactionInformation, this.$backend.$terminalId), response.dccDisclaimer, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(response.cardData), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData), tipAmount, new Map(), undefined);
                                }
                                break;
                            default:
                                throw new Error();
                        }
                    }
                    catch (error) {
                        this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                        StateMachine.logger.log(timapi.logging.Level.SEVERE, "actionProcessResponseTransaction: exception", [error]);
                        throw error;
                    }
                    this.backend.notifyTransactionCompleted(undefined, timResponse);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseTransaction");
                }
                actionProcessNotificationStatusChanged() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessNotificationStatusChanged");
                    let notification = new timapi.protocol.sixml.Notification_TerminalStatus(this.lastReceivedMessage);
                    let timDisplay = new Array();
                    for (let line of notification.displayContent.displayLine) {
                        let lineNum = line.lineNum;
                        while (timDisplay.length < lineNum) {
                            timDisplay.push("");
                        }
                        timDisplay[lineNum - 1] = line.value;
                    }
                    this.backend.$terminalStatus =
                        new timapi.TerminalStatus(timDisplay, timapi.protocol.constants.ConnectionStatus.protocol2TimApi(notification.connectionStatus), timapi.protocol.constants.ManagementStatus.protocol2TimApi(notification.managementStatus), timapi.protocol.constants.CardReaderStatus.protocol2TimApi(notification.cardReaderStatus), timapi.protocol.constants.TransactionStatus.protocol2TimApi(notification.transactionStatus), timapi.protocol.constants.SleepModeStatus.protocol2TimApiIfValid(notification.sleepModeStatus), notification.receiptInformation !== undefined
                            ? notification.receiptInformation
                            : false, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(notification.cardData), notification.swUpdateAvailable !== undefined
                            ? notification.swUpdateAvailable
                            : false);
                    this.backend.notifyTerminalStatusChanged();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessNotificationStatusChanged");
                }
                actionProcessNotificationLicenseChanged() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessNotificationLicenseChanged");
                    this.backend.$license(new timapi.protocol.sixml.Notification_LicenseChanged(this.lastReceivedMessage).license);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessNotificationLicenseChanged");
                }
                actionNotifyLoginCompleted() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionNotifyLoginCompleted");
                    this.backend.notifyLoginCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionNotifyLoginCompleted");
                }
                actionSimulateActivateCompleted() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSimulateActivateCompleted");
                    this.backend.notifyActivateCompleted(undefined, undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSimulateActivateCompleted");
                }
                actionSimulateDeactivateCompleted() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSimulateDeactivateCompleted");
                    this.backend.notifyDeactivateCompleted(undefined, undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSimulateDeactivateCompleted");
                }
                actionSimulateLogoutCompleted() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSimulateLogoutCompleted");
                    this.backend.notifyLogoutCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSimulateLogoutCompleted");
                }
                actionSimulateCommitCompleted() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSimulateCommitCompleted");
                    this.backend.notifyCommitCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSimulateCommitCompleted");
                }
                actionClearPendingEvent() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionClearPendingEvent");
                    this.pendingRequest = undefined;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionClearPendingEvent");
                }
                actionClearPendingCancel() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionClearPendingCancel");
                    this.hasPendingCancel = false;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionClearPendingCancel");
                }
                actionSetPendingActivate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingActivate");
                    this.pendingRequest = timapi.constants.RequestType.activate;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingActivate");
                }
                actionSetPendingApplicationInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingApplicationInformation");
                    this.pendingRequest = timapi.constants.RequestType.applicationInformation;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingApplicationInformation");
                }
                actionSetPendingBalance() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingBalance");
                    this.pendingRequest = timapi.constants.RequestType.balance;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingBalance");
                }
                actionSetPendingChangeSettings() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingChangeSettings");
                    this.pendingRequest = timapi.constants.RequestType.changeSettings;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingChangeSettings");
                }
                actionSetPendingCounterRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingCounterRequest");
                    this.pendingRequest = timapi.constants.RequestType.counterRequest;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingCounterRequest");
                }
                actionSetPendingCommit() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingCommit");
                    this.pendingRequest = timapi.constants.RequestType.commit;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingCommit");
                }
                actionSetPendingDccRates() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingDccRates");
                    this.pendingRequest = timapi.constants.RequestType.dccRates;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingDccRates");
                }
                actionSetPendingDeactivate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingDeactivate");
                    this.pendingRequest = timapi.constants.RequestType.deactivate;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingDeactivate");
                }
                actionSetPendingHardwareInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingHardwareInformation");
                    this.pendingRequest = timapi.constants.RequestType.hardwareInformation;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingHardwareInformation");
                }
                actionSetPendingInitTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingInitTransaction");
                    this.pendingRequest = timapi.constants.RequestType.initTransaction;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingInitTransaction");
                }
                actionSetPendingLogin() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingLogin");
                    this.pendingRequest = timapi.constants.RequestType.login;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingLogin");
                }
                actionSetPendingLogout() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingLogout");
                    this.pendingRequest = timapi.constants.RequestType.logout;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingLogout");
                }
                actionSetPendingReboot() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingReboot");
                    this.pendingRequest = timapi.constants.RequestType.reboot;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingReboot");
                }
                actionSetPendingReconfig() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingReconfig");
                    this.pendingRequest = timapi.constants.RequestType.reconfig;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingReconfig");
                }
                actionSetPendingReceiptRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingReceiptRequest");
                    this.pendingRequest = timapi.constants.RequestType.receiptRequest;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingReceiptRequest");
                }
                actionSetPendingReconciliation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingReconciliation");
                    this.pendingRequest = timapi.constants.RequestType.reconciliation;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingReconciliation");
                }
                actionSetPendingSoftwareUpdate() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingSoftwareUpdate");
                    this.pendingRequest = timapi.constants.RequestType.softwareUpdate;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingSoftwareUpdate");
                }
                actionSetPendingSystemInformation() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingSystemInformation");
                    this.pendingRequest = timapi.constants.RequestType.systemInformation;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingSystemInformation");
                }
                actionSetPendingTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingTransaction");
                    this.pendingRequest = timapi.constants.RequestType.transaction;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingTransaction");
                }
                actionSetPendingCancel() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingCancel");
                    this.hasPendingCancel = true;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingCancel");
                }
                actionErrorConnectionLost() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionErrorConnectionLost");
                    this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiConnectionLostTerminal));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionErrorConnectionLost");
                }
                actionErrorInvalidResponse() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionErrorInvalidResponse");
                    this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.apiInvalidAnswer));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionErrorInvalidResponse");
                }
                actionErrorRequestInProgress() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionErrorRequestInProgress");
                    throw new timapi.TimException(timapi.constants.ResultCode.requestPending);
                }
                actionErrorWrongState() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionErrorWrongState");
                    throw new timapi.TimException(timapi.constants.ResultCode.sixmlWrongState);
                }
                actionErrorTimeout() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionErrorTimeout");
                    this.backend.failRunningRequest(new timapi.TimException(timapi.constants.ResultCode.timCommunicationFailure));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionErrorTimeout");
                }
                actionErrorDisabledFeature() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionErrorDisabledFeature");
                    throw new timapi.TimException(timapi.constants.ResultCode.apiDisabledFeature);
                }
                actionArmTimeoutTransaction() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionArmTimeoutTransaction");
                    this.actionCancelTimeout();
                    this.taskTimeout = new sixml.TaskTimeout(this, 30 * 1000);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionArmTimeoutTransaction");
                }
                actionArmTimeoutRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionArmTimeoutRequest");
                    this.actionCancelTimeout();
                    this.taskTimeout = new sixml.TaskTimeout(this, 300 * 1000);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionArmTimeoutRequest");
                }
                actionArmTimeoutLongRequest() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionArmTimeoutLongRequest");
                    this.actionCancelTimeout();
                    this.taskTimeout = new sixml.TaskTimeout(this, 180 * 1000);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionArmTimeoutLongRequest");
                }
                actionCancelTimeout() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCancelTimeout");
                    this.cancelTaskTimeout();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCancelTimeout");
                }
                actionRunAwayProtection() {
                    this.runAwayTime = new Date().getTime();
                }
                conditionHasGuideUnattended() {
                    return this.backend.$terminal.$settings.$guides.has(timapi.constants.Guides.unattended);
                }
                conditionHasPendingCloseReader() {
                    return this.pendingRequest === timapi.constants.RequestType.closeReader;
                }
                conditionHasPendingOpenReader() {
                    return this.pendingRequest === timapi.constants.RequestType.openReader;
                }
                conditionHasPendingEjectCard() {
                    return this.pendingRequest === timapi.constants.RequestType.ejectCard;
                }
                conditionHasPendingOpenMaintenanceWindow() {
                    return (this.pendingRequest ===
                        timapi.constants.RequestType.openMaintenanceWindow);
                }
                conditionHasPendingCloseMaintenanceWindow() {
                    return (this.pendingRequest ===
                        timapi.constants.RequestType.closeMaintenanceWindow);
                }
                conditionHasPendingActivateServiceMenu() {
                    return (this.pendingRequest === timapi.constants.RequestType.activateServiceMenu);
                }
                conditionHasGuideAdvancedRetail() {
                    return this.backend.$terminal.$settings.$guides.has(timapi.constants.Guides.advancedRetail);
                }
                conditionHasPendingBalanceInquiry() {
                    return (this.pendingRequest === timapi.constants.RequestType.balanceInquiry);
                }
                conditionHasPendingQueryLoyalty() {
                    return this.pendingRequest === timapi.constants.RequestType.queryLoyalty;
                }
                actionCloseReader() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCloseReader");
                    let message = new timapi.protocol.sixml.Request_CloseReader();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCloseReader");
                }
                actionOpenReader() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionOpenReader");
                    let message = new timapi.protocol.sixml.Request_OpenReader();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionOpenReader");
                }
                actionEjectCard() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionEjectCard");
                    let message = new timapi.protocol.sixml.Request_EjectCard();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionEjectCard");
                }
                actionOpenMaintenanceWindow() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionOpenMaintenanceWindow");
                    let message = new timapi.protocol.sixml.Request_OpenMaintenanceWindow();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionOpenMaintenanceWindow");
                }
                actionCloseMaintenanceWindow() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCloseMaintenanceWindow");
                    let message = new timapi.protocol.sixml.Request_CloseMaintenanceWindow();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCloseMaintenanceWindow");
                }
                actionHoldCommit() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionHoldCommit");
                    this.backend.sendMessage(new timapi.protocol.sixml.Notification_HoldCommit());
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionHoldCommit");
                }
                actionActivateServiceMenu() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionActivateServiceMenu");
                    let message = new timapi.protocol.sixml.Request_ActivateServiceMenu();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionActivateServiceMenu");
                }
                actionProcessResponseCloseReader() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseCloseReader");
                    this.backend.notifyCloseReaderCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseCloseReader");
                }
                actionProcessResponseOpenReader() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseOpenReader");
                    this.backend.notifyOpenReaderCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseOpenReader");
                }
                actionProcessResponseEjectCard() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseEjectCard");
                    this.backend.notifyEjectCardCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseEjectCard");
                }
                actionProcessResponseOpenMaintenanceWindow() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseOpenMaintenanceWindow");
                    this.backend.notifyOpenMaintenanceWindowCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseOpenMaintenanceWindow");
                }
                actionProcessResponseCloseMaintenanceWindow() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseCloseMaintenanceWindow");
                    this.backend.notifyCloseMaintenanceWindowCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseCloseMaintenanceWindow");
                }
                actionProcessResponseActivateServiceMenu() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseActivateServiceMenu");
                    this.backend.notifyActivateServiceMenuCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseActivateServiceMenu");
                }
                actionSetPendingCloseReader() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingCloseReader");
                    this.pendingRequest = timapi.constants.RequestType.closeReader;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingCloseReader");
                }
                actionSetPendingOpenReader() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingOpenReader");
                    this.pendingRequest = timapi.constants.RequestType.openReader;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingOpenReader");
                }
                actionSetPendingEjectCard() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingEjectCard");
                    this.pendingRequest = timapi.constants.RequestType.ejectCard;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingEjectCard");
                }
                actionSetPendingOpenMaintenanceWindow() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingOpenMaintenanceWindow");
                    this.pendingRequest = timapi.constants.RequestType.openMaintenanceWindow;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingOpenMaintenanceWindow");
                }
                actionSetPendingCloseMaintenanceWindow() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingCloseMaintenanceWindow");
                    this.pendingRequest = timapi.constants.RequestType.closeMaintenanceWindow;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingCloseMaintenanceWindow");
                }
                actionSetPendingActivateServiceMenu() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingActivateServiceMenu");
                    this.pendingRequest = timapi.constants.RequestType.activateServiceMenu;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingActivateServiceMenu");
                }
                actionBalanceInquiry() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionBalanceInquiry");
                    let message = new timapi.protocol.sixml.Request_BalanceInquiry();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionBalanceInquiry");
                }
                actionQueryLoyalty() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionQueryLoyalty");
                    let message = this.requestQueryLoyalty;
                    this.requestQueryLoyalty = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionQueryLoyalty");
                }
                actionProcessResponseBalanceInquiry() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseBalanceInquiry");
                    let response = new timapi.protocol.sixml.Response_BalanceInquiry(this.lastReceivedMessage);
                    this.backend.notifyBalanceInquiryCompleted(undefined, new timapi.BalanceInquiryResponse(sixml.ConvertSIXml2TimApi.convertAmount(response.amountSaldo), sixml.ConvertSIXml2TimApi.convertPrintDataOrNull(response.printData)));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseBalanceInquiry");
                }
                actionProcessResponseQueryLoyalty() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseQueryLoyalty");
                    let response = new timapi.protocol.sixml.Response_QueryLoyalty(this.lastReceivedMessage);
                    this.backend.notifyQueryLoyaltyCompleted(undefined, sixml.ConvertSIXml2TimApi.convertCardData(response.cardData));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseQueryLoyalty");
                }
                actionSetPendingBalanceInquiry() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingBalanceInquiry");
                    this.pendingRequest = timapi.constants.RequestType.balanceInquiry;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingBalanceInquiry");
                }
                actionSetPendingQueryLoyalty() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingQueryLoyalty");
                    this.pendingRequest = timapi.constants.RequestType.queryLoyalty;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingQueryLoyalty");
                }
                conditionHasGuideDialog() {
                    return this.backend.$terminal.$settings.$guides.has(timapi.constants.Guides.DIALOG);
                }
                conditionHasPendingOpenDialogMode() {
                    return (this.pendingRequest === timapi.constants.RequestType.openDialogMode);
                }
                conditionHasPendingCloseDialogMode() {
                    return (this.pendingRequest === timapi.constants.RequestType.closeDialogMode);
                }
                conditionHasPendingShowSignatureCapture() {
                    return (this.pendingRequest ===
                        timapi.constants.RequestType.showSignatureCapture);
                }
                conditionHasPendingShowDialog() {
                    return this.pendingRequest === timapi.constants.RequestType.showDialog;
                }
                conditionHasPendingSendCardCommand() {
                    return false;
                }
                actionOpenDialogMode() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionOpenDialogMode");
                    let message = new timapi.protocol.sixml.Request_OpenDialogMode();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionOpenDialogMode");
                }
                actionCloseDialogMode() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionCloseDialogMode");
                    let message = new timapi.protocol.sixml.Request_CloseDialogMode();
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionCloseDialogMode");
                }
                actionShowSignatureCapture() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionShowSignatureCapture");
                    let message = this.requestShowSignatureCapture;
                    this.requestShowSignatureCapture = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionShowSignatureCapture");
                }
                actionShowDialog() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionShowDialog");
                    let message = this.requestShowDialog;
                    this.requestShowDialog = undefined;
                    message.sequenceNumber = this.backend.consumeNextSequenceNumber();
                    this.backend.sendMessage(message);
                    this.armKeepAliveTimer();
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionShowDialog");
                }
                actionProcessResponseOpenDialogMode() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseOpenDialogMode");
                    this.backend.notifyOpenDialogModeCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseOpenDialogMode");
                }
                actionProcessResponseCloseDialogMode() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseCloseDialogMode");
                    this.backend.notifyCloseDialogModeCompleted(undefined);
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseCloseDialogMode");
                }
                actionProcessResponseShowSignatureCapture() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseShowSignatureCapture");
                    let response = new timapi.protocol.sixml.Response_ShowSignatureCapture(this.lastReceivedMessage);
                    let siginfo = response.signatureInformation;
                    this.backend.notifyShowSignatureCaptureCompleted(undefined, new timapi.ShowSignatureCaptureResponse(timapi.protocol.constants.Reason.protocol2TimApi(siginfo.reason), timapi.protocol.constants.ImageFileFormat.protocol2TimApi(siginfo.imageFileFormat), siginfo.imageWidth, siginfo.imageHeight, siginfo.value));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseShowSignatureCapture");
                }
                actionProcessResponseShowDialog() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionProcessResponseShowDialog");
                    let response = new timapi.protocol.sixml.Response_ShowDialog(this.lastReceivedMessage);
                    let resinfo = response.resourceInformation;
                    this.backend.notifyShowDialogCompleted(undefined, new timapi.ShowDialogResponse(timapi.protocol.constants.Reason.protocol2TimApi(resinfo.reason), resinfo.inputValue, sixml.ConvertSIXml2TimApi.convertCardDataOrNull(resinfo.cardData)));
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionProcessResponseShowDialog");
                }
                actionSetPendingOpenDialogMode() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingOpenDialogMode");
                    this.pendingRequest = timapi.constants.RequestType.openDialogMode;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingOpenDialogMode");
                }
                actionSetPendingCloseDialogMode() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingCloseDialogMode");
                    this.pendingRequest = timapi.constants.RequestType.closeDialogMode;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingCloseDialogMode");
                }
                actionSetPendingShowSignatureCapture() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingShowSignatureCapture");
                    this.pendingRequest = timapi.constants.RequestType.showSignatureCapture;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingShowSignatureCapture");
                }
                actionSetPendingShowDialog() {
                    StateMachine.logger.entering(StateMachine.CLASS_NAME, "actionSetPendingShowDialog");
                    this.pendingRequest = timapi.constants.RequestType.showDialog;
                    StateMachine.logger.exiting(StateMachine.CLASS_NAME, "actionSetPendingShowDialog");
                }
                cancelTaskTimeout() {
                    if (this.taskTimeout !== undefined) {
                        this.taskTimeout.cancel();
                        this.taskTimeout = undefined;
                    }
                }
                cancelTaskKeepAliveDisconnect() {
                    if (this.taskKeepAliveDisconnect !== undefined) {
                        this.taskKeepAliveDisconnect.cancel();
                        this.taskKeepAliveDisconnect = undefined;
                    }
                }
                cancelTaskKeepAliveCheck() {
                    if (this.taskKeepAliveCheck !== undefined) {
                        this.taskKeepAliveCheck.cancel();
                        this.taskKeepAliveCheck = undefined;
                    }
                }
                armKeepAliveTimeout() {
                    if (this.backend.$terminal.$settings.$enableKeepAlive == true) {
                        this.cancelTaskKeepAliveDisconnect();
                        this.taskKeepAliveDisconnect = new sixml.TaskKeepAliveDisconnect(this, 22 * 1000);
                    }
                }
                armKeepAliveTimer() {
                    if (this.backend.$terminal.$settings.$enableKeepAlive == true) {
                        this.cancelTaskKeepAliveCheck();
                        this.taskKeepAliveCheck = new sixml.TaskKeepAliveCheck(this, 10 * 1000);
                    }
                }
                get $pendingRequest() {
                    return this.pendingRequest;
                }
            }
            StateMachine.LOGGER_NAME = "StateMachineLogger";
            StateMachine.CLASS_NAME = "StateMachine";
            StateMachine.logger = timapi.logging.Logger.getLogger(StateMachine.LOGGER_NAME);
            sixml.StateMachine = StateMachine;
        })(sixml = statemachine.sixml || (statemachine.sixml = {}));
    })(statemachine = timapi.statemachine || (timapi.statemachine = {}));
})(timapi || (timapi = {}));
timapi.statemachine.states.DefaultState = function (context) {
    if (context == undefined) {
        throw new Error("Invalid argument. context is undefined");
    }
    this.context = context;
};
timapi.statemachine.states.DefaultState.loggerName = "timapi.statemachine.states.DefaultState";
timapi.statemachine.states.DefaultState.classname = "DefaultState";
timapi.statemachine.states.DefaultState.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.DefaultState.loggerName);
timapi.statemachine.states.DefaultState.prototype.enterState = function () {
};
timapi.statemachine.states.DefaultState.prototype.exitState = function () {
};
timapi.statemachine.states.DefaultState.prototype.activate = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.applicationInformation = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.balance = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.cancel = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.changeSettings = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.commit = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.connect = Object.illegalState;
timapi.statemachine.states.DefaultState.prototype.counterRequest = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.deactivate = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.disconnect = function () {
    this.context.actionDisconnect();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.DefaultState.prototype.dccRates = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.hardwareInformation = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.initTransaction = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.login = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.logout = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.reboot = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.reconciliation = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.receiptRequest = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.reconfig = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.rollback = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.softwareUpdate = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.systemInformation = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.transaction = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.connected = Object.illegalState;
timapi.statemachine.states.DefaultState.prototype.connectFailed = function () {
    this.context.actionClearPendingEvent();
    this.context.setState(new timapi.statemachine.states.ErrorState(this.context));
};
timapi.statemachine.states.DefaultState.prototype.disconnected = function () {
    if (this.context.conditionIsEnabledAutoConnect()
        && !this.context.conditionRunAwayProtection()) {
        this.context.actionErrorConnectionLost();
        this.context.actionConnect();
        this.context.setState(new timapi.statemachine.states.Connecting(this.context));
        return;
    }
    this.context.actionErrorConnectionLost();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.DefaultState.prototype.responseRequest = function () {
    this.context.actionDisconnect();
    this.context.actionErrorInvalidResponse();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.DefaultState.prototype.responseError = function () {
    this.context.actionDisconnect();
    this.context.actionErrorInvalidResponse();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.DefaultState.prototype.responseInvalid = function () {
    this.context.actionDisconnect();
    this.context.actionErrorInvalidResponse();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.DefaultState.prototype.responseBusy = function () {
    this.context.actionDisconnect();
    this.context.actionErrorInvalidResponse();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.DefaultState.prototype.notificationStatusChanged = function () {
    this.context.actionProcessNotificationStatusChanged();
};
timapi.statemachine.states.DefaultState.prototype.notificationLicenseChanged = function () {
    this.context.actionProcessNotificationLicenseChanged();
};
timapi.statemachine.states.DefaultState.prototype.notificationKeepAlive = function () {
};
timapi.statemachine.states.DefaultState.prototype.timeout = Object.illegalState;
timapi.statemachine.states.DefaultState.prototype.keepAliveTimeout = function () {
    try {
        this.context.actionErrorConnectionLost();
        this.context.actionDisconnect();
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
    }
    catch (e) {
        timapi.statemachine.states.DefaultState.logger.log(timapi.logging.Level.severe, "Exception", e);
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
    }
};
timapi.statemachine.states.DefaultState.prototype.keepAliveTimer = function () {
    this.context.actionSendKeepAliveNotification();
};
timapi.statemachine.states.DefaultState.prototype.trxStateBecameIdle = function () {
};
timapi.statemachine.states.DefaultState.prototype.closeReader = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.openReader = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.ejectCard = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.openMaintenanceWindow = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.closeMaintenanceWindow = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.holdCommit = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.activateServiceMenu = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.amtAdjustment = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.balanceInquiry = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.openDialogMode = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.closeDialogMode = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.showSignatureCapture = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.showDialog = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.sendCardCommand = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.DefaultState.prototype.toString = function () {
    return this.classname;
};
timapi.statemachine.states.DefaultState.prototype.context = undefined;
timapi.statemachine.states.Activating = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.Activating.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.Activating.loggerName = "timapi.statemachine.states.Activating";
timapi.statemachine.states.Activating.classname = "Activating";
timapi.statemachine.states.Activating.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.Activating.loggerName);
timapi.statemachine.states.Activating.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
};
timapi.statemachine.states.Activating.prototype.activate = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.applicationInformation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.balance = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.cancel = function () {
    this.context.actionClearPendingCancel();
    this.context.actionCancel();
};
timapi.statemachine.states.Activating.prototype.changeSettings = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.commit = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.connect = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.counterRequest = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.deactivate = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.disconnect = function () {
    this.context.actionSendErrorResponseDisconnect();
    this.context.actionClearPendingEvent();
    this.context.actionDisconnect();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.Activating.prototype.dccRates = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.hardwareInformation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.initTransaction = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.login = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.logout = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.reboot = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.reconciliation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.receiptRequest = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.reconfig = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.rollback = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.softwareUpdate = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.systemInformation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.transaction = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.connected = function () {
};
timapi.statemachine.states.Activating.prototype.connectFailed = function () {
    this.context.actionClearPendingEvent();
    this.context.setState(new timapi.statemachine.states.ErrorState(this.context));
};
timapi.statemachine.states.Activating.prototype.responseRequest = function () {
    this.context.actionProcessResponseActivate();
    this.context.setState(new timapi.statemachine.states.Open(this.context));
};
timapi.statemachine.states.Activating.prototype.responseError = function () {
    this.context.actionClearPendingEvent();
    this.context.actionProcessResponseError();
    this.context.setState(new timapi.statemachine.states.LoggedIn(this.context));
};
timapi.statemachine.states.Activating.prototype.responseBusy = function () {
    if (!this.context.conditionHasPendingEvent()) {
        this.context.actionClearPendingEvent();
        this.context.actionProcessResponseError();
        this.context.setState(new timapi.statemachine.states.LoggedIn(this.context));
        return;
    }
};
timapi.statemachine.states.Activating.prototype.timeout = function () {
    this.context.actionErrorTimeout();
    this.context.setState(new timapi.statemachine.states.LoggedIn(this.context));
};
timapi.statemachine.states.Activating.prototype.keepAliveTimeout = function () {
    try {
        this.context.actionErrorConnectionLost();
        this.context.actionDisconnect();
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
    }
    catch (e) {
        timapi.statemachine.states.Activating.logger.log(timapi.logging.Level.severe, "Exception", e);
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
    }
};
timapi.statemachine.states.Activating.prototype.trxStateBecameIdle = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionActivate();
        return;
    }
};
timapi.statemachine.states.Activating.prototype.closeReader = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.openReader = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.ejectCard = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.openMaintenanceWindow = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.closeMaintenanceWindow = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.activateServiceMenu = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.balanceInquiry = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.openDialogMode = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.closeDialogMode = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.showSignatureCapture = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.showDialog = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Activating.prototype.sendCardCommand = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Connecting = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.Connecting.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.Connecting.loggerName = "timapi.statemachine.states.Connecting";
timapi.statemachine.states.Connecting.classname = "Connecting";
timapi.statemachine.states.Connecting.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.Connecting.loggerName);
timapi.statemachine.states.Connecting.prototype.activate = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingActivate();
};
timapi.statemachine.states.Connecting.prototype.applicationInformation = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingApplicationInformation();
};
timapi.statemachine.states.Connecting.prototype.cancel = function () {
    this.context.actionSetPendingCancel();
};
timapi.statemachine.states.Connecting.prototype.changeSettings = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingChangeSettings();
};
timapi.statemachine.states.Connecting.prototype.commit = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingCommit();
};
timapi.statemachine.states.Connecting.prototype.connect = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Connecting.prototype.counterRequest = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingCounterRequest();
};
timapi.statemachine.states.Connecting.prototype.deactivate = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingDeactivate();
};
timapi.statemachine.states.Connecting.prototype.dccRates = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingDccRates();
};
timapi.statemachine.states.Connecting.prototype.hardwareInformation = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingHardwareInformation();
};
timapi.statemachine.states.Connecting.prototype.initTransaction = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingInitTransaction();
};
timapi.statemachine.states.Connecting.prototype.login = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingLogin();
};
timapi.statemachine.states.Connecting.prototype.logout = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingLogout();
};
timapi.statemachine.states.Connecting.prototype.reboot = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingReboot();
};
timapi.statemachine.states.Connecting.prototype.reconciliation = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingReconciliation();
};
timapi.statemachine.states.Connecting.prototype.receiptRequest = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingReceiptRequest();
};
timapi.statemachine.states.Connecting.prototype.reconfig = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingReconfig();
};
timapi.statemachine.states.Connecting.prototype.softwareUpdate = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingSoftwareUpdate();
};
timapi.statemachine.states.Connecting.prototype.systemInformation = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingSystemInformation();
};
timapi.statemachine.states.Connecting.prototype.transaction = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingTransaction();
};
timapi.statemachine.states.Connecting.prototype.connected = function () {
    if (this.context.conditionIsEnabledAutoLogin()) {
        this.context.actionSetDefaultLoginRequest();
        this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
        return;
    }
    this.context.setState(new timapi.statemachine.states.LoggedOut(this.context));
};
timapi.statemachine.states.Connecting.prototype.connectFailed = function () {
    if (this.context.conditionIsEnabledAutoConnect()
        && !this.context.conditionRunAwayProtection()) {
        this.context.actionRunAwayProtection();
        this.context.actionClearPendingEvent();
        this.context.actionConnect();
        this.context.setState(new timapi.statemachine.states.Connecting(this.context));
        return;
    }
    this.context.actionClearPendingEvent();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.Connecting.prototype.notificationKeepAlive = function () {
};
timapi.statemachine.states.Connecting.prototype.keepAliveTimeout = function () {
};
timapi.statemachine.states.Connecting.prototype.keepAliveTimer = function () {
};
timapi.statemachine.states.Connecting.prototype.closeReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingCloseReader();
};
timapi.statemachine.states.Connecting.prototype.openReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingOpenReader();
};
timapi.statemachine.states.Connecting.prototype.ejectCard = function () {
    if (!this.context.conditionHasGuideUnattended()
        && !this.context.conditionHasGuideAdvancedRetail()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingEjectCard();
};
timapi.statemachine.states.Connecting.prototype.openMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingOpenMaintenanceWindow();
};
timapi.statemachine.states.Connecting.prototype.closeMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingCloseMaintenanceWindow();
};
timapi.statemachine.states.Connecting.prototype.activateServiceMenu = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingActivateServiceMenu();
};
timapi.statemachine.states.Connecting.prototype.balanceInquiry = function () {
    if (!this.context.conditionHasGuideAdvancedRetail()
        && !this.context.conditionHasGuideBanking()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingBalanceInquiry();
};
timapi.statemachine.states.Connecting.prototype.openDialogMode = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingOpenDialogMode();
};
timapi.statemachine.states.Connecting.prototype.closeDialogMode = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingCloseDialogMode();
};
timapi.statemachine.states.Connecting.prototype.showSignatureCapture = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingShowSignatureCapture();
};
timapi.statemachine.states.Connecting.prototype.showDialog = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingShowDialog();
};
timapi.statemachine.states.Connecting.prototype.sendCardCommand = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionErrorRequestInProgress();
        return;
    }
    this.context.actionSetPendingSendCardCommand();
};
timapi.statemachine.states.Deactivating = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.Deactivating.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.Deactivating.loggerName = "timapi.statemachine.states.Deactivating";
timapi.statemachine.states.Deactivating.classname = "Deactivating";
timapi.statemachine.states.Deactivating.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.Deactivating.loggerName);
timapi.statemachine.states.Deactivating.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
};
timapi.statemachine.states.Deactivating.prototype.activate = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.applicationInformation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.balance = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.cancel = function () {
    this.context.actionClearPendingCancel();
    this.context.actionCancel();
};
timapi.statemachine.states.Deactivating.prototype.changeSettings = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.commit = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.connect = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.counterRequest = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.deactivate = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.disconnect = function () {
    this.context.actionSendErrorResponseDisconnect();
    this.context.actionClearPendingEvent();
    this.context.actionDisconnect();
    this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
};
timapi.statemachine.states.Deactivating.prototype.dccRates = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.hardwareInformation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.initTransaction = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.login = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.logout = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.reboot = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.reconciliation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.receiptRequest = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.reconfig = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.rollback = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.softwareUpdate = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.systemInformation = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.transaction = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.connected = function () {
};
timapi.statemachine.states.Deactivating.prototype.connectFailed = function () {
    this.context.actionClearPendingEvent();
    this.context.setState(new timapi.statemachine.states.ErrorState(this.context));
};
timapi.statemachine.states.Deactivating.prototype.responseRequest = function () {
    if (this.context.conditionIsEnabledAutoLogout()
        && !this.context.conditionHasPendingEvent()) {
        this.context.actionProcessResponseDeactivate();
        this.context.actionLogout();
        this.context.setState(new timapi.statemachine.states.LoggingOut(this.context));
        return;
    }
    this.context.actionProcessResponseDeactivate();
    this.context.setState(new timapi.statemachine.states.LoggedIn(this.context));
};
timapi.statemachine.states.Deactivating.prototype.responseError = function () {
    this.context.actionClearPendingEvent();
    this.context.actionProcessResponseError();
    this.context.setState(new timapi.statemachine.states.Open(this.context));
};
timapi.statemachine.states.Deactivating.prototype.responseBusy = function () {
    if (!this.context.conditionHasPendingEvent()) {
        this.context.actionClearPendingEvent();
        this.context.actionProcessResponseError();
        this.context.setState(new timapi.statemachine.states.Open(this.context));
        return;
    }
};
timapi.statemachine.states.Deactivating.prototype.timeout = function () {
    this.context.actionErrorTimeout();
    this.context.setState(new timapi.statemachine.states.Open(this.context));
};
timapi.statemachine.states.Deactivating.prototype.keepAliveTimeout = function () {
    try {
        this.context.actionErrorConnectionLost();
        this.context.actionDisconnect();
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
    }
    catch (e) {
        timapi.statemachine.states.Deactivating.logger.log(timapi.logging.Level.severe, "Exception", e);
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
    }
};
timapi.statemachine.states.Deactivating.prototype.trxStateBecameIdle = function () {
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionDeactivate();
        return;
    }
};
timapi.statemachine.states.Deactivating.prototype.closeReader = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.openReader = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.ejectCard = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.openMaintenanceWindow = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.closeMaintenanceWindow = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.activateServiceMenu = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.balanceInquiry = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.openDialogMode = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.closeDialogMode = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.showSignatureCapture = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.showDialog = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.Deactivating.prototype.sendCardCommand = function () {
    this.context.actionErrorRequestInProgress();
};
timapi.statemachine.states.DialogMode = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.DialogMode.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.DialogMode.loggerName = "timapi.statemachine.states.DialogMode";
timapi.statemachine.states.DialogMode.classname = "DialogMode";
timapi.statemachine.states.DialogMode.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.DialogMode.loggerName);
timapi.statemachine.states.DialogMode.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
    this.context.actionCancelTimeout();
    if (this.context.conditionHasPendingOpenDialogMode()) {
        this.context.actionClearPendingEvent();
    }
    if (this.context.conditionHasPendingCloseDialogMode()) {
        this.context.actionClearPendingEvent();
        this.context.actionCloseDialogMode();
        this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
        return;
    }
    if (this.context.conditionHasPendingShowSignatureCapture()) {
        this.context.actionShowSignatureCapture();
        this.context.setState(new timapi.statemachine.states.WaitShowSignatureCapture(this.context));
        return;
    }
    if (this.context.conditionHasPendingShowDialog()) {
        this.context.actionShowDialog();
        this.context.setState(new timapi.statemachine.states.WaitShowDialog(this.context));
        return;
    }
    if (this.context.conditionHasPendingSendCardCommand()) {
        this.context.actionSendCardCommand();
        this.context.setState(new timapi.statemachine.states.WaitSendCardCommand(this.context));
        return;
    }
};
timapi.statemachine.states.DialogMode.prototype.applicationInformation = function () {
    this.context.actionSetPendingApplicationInformation();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.balance = function () {
    this.context.actionSetPendingBalance();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.cancel = function () {
    this.context.actionClearPendingCancel();
    this.context.actionCancel();
};
timapi.statemachine.states.DialogMode.prototype.changeSettings = function () {
    this.context.actionSetPendingChangeSettings();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.counterRequest = function () {
    this.context.actionSetPendingCounterRequest();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.deactivate = function () {
    this.context.actionSetPendingDeactivate();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.dccRates = function () {
    this.context.actionSetPendingDccRates();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.hardwareInformation = function () {
    this.context.actionSetPendingHardwareInformation();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.initTransaction = function () {
    this.context.actionSetPendingInitTransaction();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.login = function () {
    this.context.actionSetPendingLogin();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.logout = function () {
    this.context.actionSetPendingLogout();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.reboot = function () {
    this.context.actionSetPendingReboot();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.receiptRequest = function () {
    this.context.actionSetPendingReceiptRequest();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.reconfig = function () {
    this.context.actionSetPendingReconfig();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.softwareUpdate = function () {
    this.context.actionSetPendingSoftwareUpdate();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.systemInformation = function () {
    this.context.actionSetPendingSystemInformation();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.transaction = function () {
    this.context.actionSetPendingTransaction();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.closeReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseReader();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.openReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenReader();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.ejectCard = function () {
    if (!this.context.conditionHasGuideUnattended()
        && !this.context.conditionHasGuideAdvancedRetail()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingEjectCard();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.openMaintenanceWindow = function () {
    this.context.actionSetPendingOpenMaintenanceWindow();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.closeMaintenanceWindow = function () {
    this.context.actionSetPendingCloseMaintenanceWindow();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.activateServiceMenu = function () {
    this.context.actionSetPendingActivateServiceMenu();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.balanceInquiry = function () {
    if (!this.context.conditionHasGuideAdvancedRetail()
        && !this.context.conditionHasGuideBanking()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingBalanceInquiry();
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.closeDialogMode = function () {
    this.context.actionCloseDialogMode();
    this.context.setState(new timapi.statemachine.states.WaitCloseDialogMode(this.context));
};
timapi.statemachine.states.DialogMode.prototype.showSignatureCapture = function () {
    this.context.actionShowSignatureCapture();
    this.context.setState(new timapi.statemachine.states.WaitShowSignatureCapture(this.context));
};
timapi.statemachine.states.DialogMode.prototype.showDialog = function () {
    this.context.actionShowDialog();
    this.context.setState(new timapi.statemachine.states.WaitShowDialog(this.context));
};
timapi.statemachine.states.DialogMode.prototype.sendCardCommand = function () {
    this.context.actionSendCardCommand();
    this.context.setState(new timapi.statemachine.states.WaitSendCardCommand(this.context));
};
timapi.statemachine.states.Disconnected = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.Disconnected.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.Disconnected.loggerName = "timapi.statemachine.states.Disconnected";
timapi.statemachine.states.Disconnected.classname = "Disconnected";
timapi.statemachine.states.Disconnected.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.Disconnected.loggerName);
timapi.statemachine.states.Disconnected.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
    this.context.actionCancelTimeout();
    if (this.context.conditionHasPendingEvent()) {
        this.context.actionConnect();
        this.context.setState(new timapi.statemachine.states.Connecting(this.context));
        return;
    }
};
timapi.statemachine.states.Disconnected.prototype.activate = function () {
    this.context.actionSetPendingActivate();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.applicationInformation = function () {
    this.context.actionSetPendingApplicationInformation();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.balance = function () {
    this.context.actionSetPendingBalance();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.cancel = function () {
    this.context.actionSetPendingCancel();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.changeSettings = function () {
    this.context.actionSetPendingChangeSettings();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.commit = function () {
    this.context.actionSetPendingCommit();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.connect = function () {
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.counterRequest = function () {
    this.context.actionSetPendingCounterRequest();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.deactivate = function () {
    this.context.actionSetPendingDeactivate();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.disconnect = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.Disconnected.prototype.dccRates = function () {
    this.context.actionSetPendingDccRates();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.hardwareInformation = function () {
    this.context.actionSetPendingHardwareInformation();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.initTransaction = function () {
    this.context.actionSetPendingInitTransaction();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.login = function () {
    this.context.actionSetPendingLogin();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.logout = function () {
    this.context.actionSetPendingLogout();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.reboot = function () {
    this.context.actionSetPendingReboot();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.reconciliation = function () {
    this.context.actionSetPendingReconciliation();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.receiptRequest = function () {
    this.context.actionSetPendingReceiptRequest();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.reconfig = function () {
    this.context.actionSetPendingReconfig();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.softwareUpdate = function () {
    this.context.actionSetPendingSoftwareUpdate();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.systemInformation = function () {
    this.context.actionSetPendingSystemInformation();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.transaction = function () {
    this.context.actionSetPendingTransaction();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.connected = function () {
    this.context.setState(new timapi.statemachine.states.LoggedOut(this.context));
};
timapi.statemachine.states.Disconnected.prototype.connectFailed = function () {
    if (this.context.conditionIsEnabledAutoConnect()
        && !this.context.conditionRunAwayProtection()) {
        this.context.actionRunAwayProtection();
        this.context.actionConnect();
        this.context.setState(new timapi.statemachine.states.Connecting(this.context));
        return;
    }
};
timapi.statemachine.states.Disconnected.prototype.disconnected = function () {
};
timapi.statemachine.states.Disconnected.prototype.notificationKeepAlive = function () {
};
timapi.statemachine.states.Disconnected.prototype.keepAliveTimeout = function () {
};
timapi.statemachine.states.Disconnected.prototype.keepAliveTimer = function () {
};
timapi.statemachine.states.Disconnected.prototype.closeReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseReader();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.openReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenReader();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.ejectCard = function () {
    if (!this.context.conditionHasGuideUnattended()
        && !this.context.conditionHasGuideAdvancedRetail()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingEjectCard();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.openMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenMaintenanceWindow();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.closeMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseMaintenanceWindow();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.activateServiceMenu = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingActivateServiceMenu();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.balanceInquiry = function () {
    if (!this.context.conditionHasGuideAdvancedRetail()
        && !this.context.conditionHasGuideBanking()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingBalanceInquiry();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.openDialogMode = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenDialogMode();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.closeDialogMode = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseDialogMode();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.showSignatureCapture = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingShowSignatureCapture();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.showDialog = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingShowDialog();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Disconnected.prototype.sendCardCommand = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingSendCardCommand();
    this.context.actionConnect();
    this.context.setState(new timapi.statemachine.states.Connecting(this.context));
};
timapi.statemachine.states.Initial = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.Initial.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.Initial.loggerName = "timapi.statemachine.states.Initial";
timapi.statemachine.states.Initial.classname = "Initial";
timapi.statemachine.states.Initial.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.Initial.loggerName);
timapi.statemachine.states.Initial.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
    if (this.context.conditionIsEnabledAutoConnect()) {
        this.context.actionConnect();
        this.context.setState(new timapi.statemachine.states.Connecting(this.context));
        return;
    }
    if (!this.context.conditionIsEnabledAutoConnect()) {
        this.context.setState(new timapi.statemachine.states.Disconnected(this.context));
        return;
    }
};
timapi.statemachine.states.LoggedIn = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.LoggedIn.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.LoggedIn.loggerName = "timapi.statemachine.states.LoggedIn";
timapi.statemachine.states.LoggedIn.classname = "LoggedIn";
timapi.statemachine.states.LoggedIn.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.LoggedIn.loggerName);
timapi.statemachine.states.LoggedIn.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
    this.context.actionCancelTimeout();
    if (this.context.conditionHasPendingLogin()) {
        this.context.actionClearPendingEvent();
        this.context.actionLogin();
        this.context.setState(new timapi.statemachine.states.LoggingIn(this.context));
        return;
    }
    if (this.context.conditionHasPendingDeactivate()) {
        this.context.actionClearPendingEvent();
        this.context.actionDeactivate();
        this.context.setState(new timapi.statemachine.states.Deactivating(this.context));
        return;
    }
    if (this.context.conditionHasPendingApplicationInformation()) {
        this.context.actionApplicationInformation();
        this.context.setState(new timapi.statemachine.states.WaitApplicationInformation(this.context));
        return;
    }
    if (this.context.conditionHasPendingBalance()) {
        this.context.actionBalance();
        this.context.setState(new timapi.statemachine.states.WaitBalance(this.context));
        return;
    }
    if (this.context.conditionHasPendingCancel()) {
        this.context.actionClearPendingCancel();
        this.context.actionCancel();
    }
    if (this.context.conditionHasPendingChangeSettings()) {
        this.context.actionChangeSettings();
        this.context.setState(new timapi.statemachine.states.WaitChangeSettings(this.context));
        return;
    }
    if (this.context.conditionHasPendingDccRates()) {
        this.context.actionDccRates();
        this.context.setState(new timapi.statemachine.states.WaitDccRates(this.context));
        return;
    }
    if (this.context.conditionHasPendingHardwareInformation()) {
        this.context.actionHardwareInformation();
        this.context.setState(new timapi.statemachine.states.WaitHardwareInformation(this.context));
        return;
    }
    if (this.context.conditionHasPendingLogout()) {
        this.context.actionLogout();
        this.context.setState(new timapi.statemachine.states.LoggingOut(this.context));
        return;
    }
    if (this.context.conditionHasPendingReboot()) {
        this.context.actionReboot();
        this.context.setState(new timapi.statemachine.states.WaitReboot(this.context));
        return;
    }
    if (this.context.conditionHasPendingReconfig()) {
        this.context.actionReconfig();
        this.context.setState(new timapi.statemachine.states.WaitReconfig(this.context));
        return;
    }
    if (this.context.conditionHasPendingReconciliation()) {
        this.context.actionReconciliation();
        this.context.setState(new timapi.statemachine.states.WaitReconciliation(this.context));
        return;
    }
    if (this.context.conditionHasPendingReceiptRequest()) {
        this.context.actionReceiptRequest();
        this.context.setState(new timapi.statemachine.states.WaitReceiptRequestClosed(this.context));
        return;
    }
    if (this.context.conditionHasPendingSoftwareUpdate()) {
        this.context.actionSoftwareUpdate();
        this.context.setState(new timapi.statemachine.states.WaitSoftwareUpdate(this.context));
        return;
    }
    if (this.context.conditionHasPendingSystemInformation()) {
        this.context.actionSystemInformation();
        this.context.setState(new timapi.statemachine.states.WaitSystemInformation(this.context));
        return;
    }
    if (this.context.conditionHasPendingOpenMaintenanceWindow()) {
        this.context.actionOpenMaintenanceWindow();
        this.context.setState(new timapi.statemachine.states.WaitOpenMaintenanceWindow(this.context));
        return;
    }
    if (this.context.conditionHasPendingCloseMaintenanceWindow()) {
        this.context.actionCloseMaintenanceWindow();
        this.context.setState(new timapi.statemachine.states.WaitCloseMaintenanceWindow(this.context));
        return;
    }
    if (this.context.conditionHasPendingActivateServiceMenu()) {
        this.context.actionActivateServiceMenu();
        this.context.setState(new timapi.statemachine.states.WaitActivateServiceMenu(this.context));
        return;
    }
    if (this.context.conditionHasPendingActivate()
        || this.context.conditionHasPendingCommit()
        || this.context.conditionHasPendingCounterRequest()
        || this.context.conditionHasPendingInitTransaction()
        || this.context.conditionHasPendingTransaction()
        || this.context.conditionHasPendingCloseReader()
        || this.context.conditionHasPendingOpenReader()
        || this.context.conditionHasPendingEjectCard()
        || this.context.conditionHasPendingBalanceInquiry()
        || this.context.conditionHasPendingOpenDialogMode()
        || this.context.conditionHasPendingCloseDialogMode()
        || this.context.conditionHasPendingShowSignatureCapture()
        || this.context.conditionHasPendingShowDialog()
        || this.context.conditionHasPendingSendCardCommand()) {
        this.context.actionActivate();
        this.context.setState(new timapi.statemachine.states.Activating(this.context));
        return;
    }
};
timapi.statemachine.states.LoggedIn.prototype.activate = function () {
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.applicationInformation = function () {
    this.context.actionApplicationInformation();
    this.context.setState(new timapi.statemachine.states.WaitApplicationInformation(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.balance = function () {
    this.context.actionBalance();
    this.context.setState(new timapi.statemachine.states.WaitBalance(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.cancel = function () {
    this.context.actionClearPendingCancel();
    this.context.actionCancel();
};
timapi.statemachine.states.LoggedIn.prototype.changeSettings = function () {
    this.context.actionChangeSettings();
    this.context.setState(new timapi.statemachine.states.WaitChangeSettings(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.commit = function () {
    this.context.actionSetPendingCommit();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.counterRequest = function () {
    this.context.actionSetPendingCounterRequest();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.deactivate = function () {
    this.context.actionDeactivate();
    this.context.setState(new timapi.statemachine.states.Deactivating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.dccRates = function () {
    this.context.actionDccRates();
    this.context.setState(new timapi.statemachine.states.WaitDccRates(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.hardwareInformation = function () {
    this.context.actionHardwareInformation();
    this.context.setState(new timapi.statemachine.states.WaitHardwareInformation(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.initTransaction = function () {
    this.context.actionSetPendingInitTransaction();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.login = function () {
    this.context.actionLogin();
    this.context.setState(new timapi.statemachine.states.LoggingIn(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.logout = function () {
    this.context.actionLogout();
    this.context.setState(new timapi.statemachine.states.LoggingOut(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.reboot = function () {
    this.context.actionReboot();
    this.context.setState(new timapi.statemachine.states.WaitReboot(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.reconciliation = function () {
    this.context.actionReconciliation();
    this.context.setState(new timapi.statemachine.states.WaitReconciliation(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.receiptRequest = function () {
    this.context.actionReceiptRequest();
    this.context.setState(new timapi.statemachine.states.WaitReceiptRequestClosed(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.reconfig = function () {
    this.context.actionReconfig();
    this.context.setState(new timapi.statemachine.states.WaitReconfig(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.softwareUpdate = function () {
    this.context.actionSoftwareUpdate();
    this.context.setState(new timapi.statemachine.states.WaitSoftwareUpdate(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.systemInformation = function () {
    this.context.actionSystemInformation();
    this.context.setState(new timapi.statemachine.states.WaitSystemInformation(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.transaction = function () {
    this.context.actionSetPendingTransaction();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.closeReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseReader();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.openReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenReader();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.ejectCard = function () {
    if (!this.context.conditionHasGuideUnattended()
        && !this.context.conditionHasGuideAdvancedRetail()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingEjectCard();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.openMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionOpenMaintenanceWindow();
    this.context.setState(new timapi.statemachine.states.WaitOpenMaintenanceWindow(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.closeMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionCloseMaintenanceWindow();
    this.context.setState(new timapi.statemachine.states.WaitCloseMaintenanceWindow(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.activateServiceMenu = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionActivateServiceMenu();
    this.context.setState(new timapi.statemachine.states.WaitActivateServiceMenu(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.balanceInquiry = function () {
    if (!this.context.conditionHasGuideAdvancedRetail()
        && !this.context.conditionHasGuideBanking()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingBalanceInquiry();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.openDialogMode = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenDialogMode();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.closeDialogMode = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseDialogMode();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.showSignatureCapture = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingShowSignatureCapture();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.showDialog = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingShowDialog();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedIn.prototype.sendCardCommand = function () {
    if (!this.context.conditionHasGuideDialog()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingSendCardCommand();
    this.context.actionActivate();
    this.context.setState(new timapi.statemachine.states.Activating(this.context));
};
timapi.statemachine.states.LoggedOut = function (context) {
    timapi.statemachine.states.DefaultState.call(this, context);
};
timapi.statemachine.states.LoggedOut.prototype = Object.create(timapi.statemachine.states.DefaultState.prototype);
timapi.statemachine.states.LoggedOut.loggerName = "timapi.statemachine.states.LoggedOut";
timapi.statemachine.states.LoggedOut.classname = "LoggedOut";
timapi.statemachine.states.LoggedOut.logger = timapi.logging.Logger.getLogger(timapi.statemachine.states.LoggedOut.loggerName);
timapi.statemachine.states.LoggedOut.prototype.enterState = function () {
    timapi.statemachine.states.DefaultState.prototype.enterState.call(this);
    this.context.actionCancelTimeout();
    if (this.context.conditionHasPendingLogout()) {
        this.context.actionClearPendingEvent();
        this.context.actionSimulateLogoutCompleted();
    }
    if (this.context.conditionHasPendingCancel()) {
        this.context.actionClearPendingCancel();
        this.context.actionCancel();
    }
    if (this.context.conditionHasPendingActivate()
        || this.context.conditionHasPendingApplicationInformation()
        || this.context.conditionHasPendingBalance()
        || this.context.conditionHasPendingChangeSettings()
        || this.context.conditionHasPendingCommit()
        || this.context.conditionHasPendingCounterRequest()
        || this.context.conditionHasPendingDccRates()
        || this.context.conditionHasPendingDeactivate()
        || this.context.conditionHasPendingHardwareInformation()
        || this.context.conditionHasPendingInitTransaction()
        || this.context.conditionHasPendingLogin()
        || this.context.conditionHasPendingReboot()
        || this.context.conditionHasPendingReconfig()
        || this.context.conditionHasPendingReceiptRequest()
        || this.context.conditionHasPendingReconciliation()
        || this.context.conditionHasPendingSoftwareUpdate()
        || this.context.conditionHasPendingSystemInformation()
        || this.context.conditionHasPendingTransaction()
        || this.context.conditionHasPendingCloseReader()
        || this.context.conditionHasPendingOpenReader()
        || this.context.conditionHasPendingEjectCard()
        || this.context.conditionHasPendingOpenMaintenanceWindow()
        || this.context.conditionHasPendingCloseMaintenanceWindow()
        || this.context.conditionHasPendingActivateServiceMenu()
        || this.context.conditionHasPendingBalanceInquiry()
        || this.context.conditionHasPendingOpenDialogMode()
        || this.context.conditionHasPendingCloseDialogMode()
        || this.context.conditionHasPendingShowSignatureCapture()
        || this.context.conditionHasPendingShowDialog()
        || this.context.conditionHasPendingSendCardCommand()) {
        this.context.actionSetDefaultLoginRequest();
        this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
        return;
    }
};
timapi.statemachine.states.LoggedOut.prototype.activate = function () {
    this.context.actionSetPendingActivate();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.applicationInformation = function () {
    this.context.actionSetPendingApplicationInformation();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.balance = function () {
    this.context.actionSetPendingBalance();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.cancel = function () {
    this.context.actionClearPendingCancel();
    this.context.actionCancel();
};
timapi.statemachine.states.LoggedOut.prototype.changeSettings = function () {
    this.context.actionSetPendingChangeSettings();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.commit = function () {
    this.context.actionSetPendingCommit();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.connect = function () {
    this.context.actionErrorWrongState();
};
timapi.statemachine.states.LoggedOut.prototype.counterRequest = function () {
    this.context.actionSetPendingCounterRequest();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.deactivate = function () {
    this.context.actionSetPendingDeactivate();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.dccRates = function () {
    this.context.actionSetPendingDccRates();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.hardwareInformation = function () {
    this.context.actionSetPendingHardwareInformation();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.initTransaction = function () {
    this.context.actionSetPendingInitTransaction();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.login = function () {
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.logout = function () {
    this.context.actionSimulateLogoutCompleted();
};
timapi.statemachine.states.LoggedOut.prototype.reboot = function () {
    this.context.actionSetPendingReboot();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.reconciliation = function () {
    this.context.actionSetPendingReconciliation();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.receiptRequest = function () {
    this.context.actionSetPendingReceiptRequest();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.reconfig = function () {
    this.context.actionSetPendingReconfig();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.softwareUpdate = function () {
    this.context.actionSetPendingSoftwareUpdate();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.systemInformation = function () {
    this.context.actionSetPendingSystemInformation();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.transaction = function () {
    this.context.actionSetPendingTransaction();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.notificationKeepAlive = function () {
};
timapi.statemachine.states.LoggedOut.prototype.keepAliveTimeout = function () {
};
timapi.statemachine.states.LoggedOut.prototype.keepAliveTimer = function () {
};
timapi.statemachine.states.LoggedOut.prototype.closeReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseReader();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.openReader = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenReader();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.ejectCard = function () {
    if (!this.context.conditionHasGuideUnattended()
        && !this.context.conditionHasGuideAdvancedRetail()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingEjectCard();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.openMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingOpenMaintenanceWindow();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.closeMaintenanceWindow = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingCloseMaintenanceWindow();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.activateServiceMenu = function () {
    if (!this.context.conditionHasGuideUnattended()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingActivateServiceMenu();
    this.context.actionSetDefaultLoginRequest();
    this.context.setState(new timapi.statemachine.states.LoginRequest(this.context));
};
timapi.statemachine.states.LoggedOut.prototype.balanceInquiry = function () {
    if (!this.context.conditionHasGuideAdvancedRetail()
        && !this.context.conditionHasGuideBanking()) {
        this.context.actionErrorDisabledFeature();
        return;
    }
    this.context.actionSetPendingBalanceInq