/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.ArrayList;
import java.util.List;
import org.traccar.Context;
import org.traccar.database.DataManager;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.model.Device;
import org.traccar.model.Geofence;
import org.traccar.model.Position;

public class GeofenceManager
extends ExtendedObjectManager<Geofence> {
    public GeofenceManager(DataManager dataManager) {
        super(dataManager, Geofence.class);
    }

    @Override
    public final void refreshExtendedPermissions() {
        super.refreshExtendedPermissions();
        this.recalculateDevicesGeofences();
    }

    public List<Long> getCurrentDeviceGeofences(Position position) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long geofenceId : this.getAllDeviceItems(position.getDeviceId())) {
            Geofence geofence = (Geofence)this.getById(geofenceId);
            if (geofence == null || !geofence.getGeometry().containsPoint(position.getLatitude(), position.getLongitude())) continue;
            result.add(geofenceId);
        }
        return result;
    }

    public void recalculateDevicesGeofences() {
        for (Device device : Context.getDeviceManager().getAllDevices()) {
            List<Long> deviceGeofenceIds = device.getGeofenceIds();
            if (deviceGeofenceIds == null) {
                deviceGeofenceIds = new ArrayList<Long>();
            } else {
                deviceGeofenceIds.clear();
            }
            Position lastPosition = Context.getIdentityManager().getLastPosition(device.getId());
            if (lastPosition != null && this.getAllDeviceItems(device.getId()) != null) {
                deviceGeofenceIds.addAll(this.getCurrentDeviceGeofences(lastPosition));
            }
            device.setGeofenceIds(deviceGeofenceIds);
        }
    }
}

