/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

public class LineStringSnapper {
    private double snapTolerance = 0.0;
    private Coordinate[] srcPts;
    private LineSegment seg = new LineSegment();
    private boolean allowSnappingToSourceVertices = false;
    private boolean isClosed = false;

    public LineStringSnapper(LineString srcLine, double snapTolerance) {
        this(srcLine.getCoordinates(), snapTolerance);
    }

    public LineStringSnapper(Coordinate[] srcPts, double snapTolerance) {
        this.srcPts = srcPts;
        this.isClosed = LineStringSnapper.isClosed(srcPts);
        this.snapTolerance = snapTolerance;
    }

    public void setAllowSnappingToSourceVertices(boolean allowSnappingToSourceVertices) {
        this.allowSnappingToSourceVertices = allowSnappingToSourceVertices;
    }

    private static boolean isClosed(Coordinate[] pts) {
        if (pts.length <= 1) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    public Coordinate[] snapTo(Coordinate[] snapPts) {
        CoordinateList coordList = new CoordinateList(this.srcPts);
        this.snapVertices(coordList, snapPts);
        this.snapSegments(coordList, snapPts);
        Coordinate[] newPts = coordList.toCoordinateArray();
        return newPts;
    }

    private void snapVertices(CoordinateList srcCoords, Coordinate[] snapPts) {
        int end = this.isClosed ? srcCoords.size() - 1 : srcCoords.size();
        for (int i = 0; i < end; ++i) {
            Coordinate srcPt = (Coordinate)srcCoords.get(i);
            Coordinate snapVert = this.findSnapForVertex(srcPt, snapPts);
            if (snapVert == null) continue;
            srcCoords.set(i, new Coordinate(snapVert));
            if (i != 0 || !this.isClosed) continue;
            srcCoords.set(srcCoords.size() - 1, new Coordinate(snapVert));
        }
    }

    private Coordinate findSnapForVertex(Coordinate pt, Coordinate[] snapPts) {
        for (int i = 0; i < snapPts.length; ++i) {
            if (pt.equals2D(snapPts[i])) {
                return null;
            }
            if (!(pt.distance(snapPts[i]) < this.snapTolerance)) continue;
            return snapPts[i];
        }
        return null;
    }

    private void snapSegments(CoordinateList srcCoords, Coordinate[] snapPts) {
        if (snapPts.length == 0) {
            return;
        }
        int distinctPtCount = snapPts.length;
        if (snapPts[0].equals2D(snapPts[snapPts.length - 1])) {
            distinctPtCount = snapPts.length - 1;
        }
        for (int i = 0; i < distinctPtCount; ++i) {
            Coordinate snapPt = snapPts[i];
            int index = this.findSegmentIndexToSnap(snapPt, srcCoords);
            if (index < 0) continue;
            srcCoords.add(index + 1, new Coordinate(snapPt), false);
        }
    }

    private int findSegmentIndexToSnap(Coordinate snapPt, CoordinateList srcCoords) {
        double minDist = Double.MAX_VALUE;
        int snapIndex = -1;
        for (int i = 0; i < srcCoords.size() - 1; ++i) {
            this.seg.p0 = (Coordinate)srcCoords.get(i);
            this.seg.p1 = (Coordinate)srcCoords.get(i + 1);
            if (this.seg.p0.equals2D(snapPt) || this.seg.p1.equals2D(snapPt)) {
                if (this.allowSnappingToSourceVertices) continue;
                return -1;
            }
            double dist = this.seg.distance(snapPt);
            if (!(dist < this.snapTolerance) || !(dist < minDist)) continue;
            minDist = dist;
            snapIndex = i;
        }
        return snapIndex;
    }
}

