function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render as _render, unmountComponentAtNode } from 'react-dom'; // @ts-ignore

import { ExprVis } from './vis';
import { Visualization } from '../components';
export var visualization = function visualization() {
  return {
    name: 'visualization',
    displayName: 'visualization',
    reuseDomNode: true,
    render: function () {
      var _render2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(domNode, config, handlers) {
        var visData, visConfig, params, visType, vis, uiState, listenOnChange;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                visData = config.visData, visConfig = config.visConfig, params = config.params;
                visType = config.visType || visConfig.type;
                vis = new ExprVis({
                  title: config.title,
                  type: visType,
                  params: visConfig
                });
                vis.eventsSubject = {
                  next: handlers.event
                };
                uiState = handlers.uiState || vis.getUiState();
                handlers.onDestroy(function () {
                  unmountComponentAtNode(domNode);
                });
                listenOnChange = params ? params.listenOnChange : false;

                _render( /*#__PURE__*/React.createElement(Visualization, {
                  vis: vis,
                  visData: visData,
                  visParams: vis.params,
                  uiState: uiState,
                  listenOnChange: listenOnChange,
                  onInit: handlers.done
                }), domNode);

              case 8:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function render(_x, _x2, _x3) {
        return _render2.apply(this, arguments);
      }

      return render;
    }()
  };
};