function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import d3 from 'd3';
import $ from 'jquery';
export var Binder = /*#__PURE__*/function () {
  function Binder($scope) {
    var _this = this;

    _classCallCheck(this, Binder);

    _defineProperty(this, "disposal", []);

    // support auto-binding to $scope objects
    if ($scope) {
      $scope.$on('$destroy', function () {
        return _this.destroy();
      });
    }
  }

  _createClass(Binder, [{
    key: "on",
    value: function on(emitter) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var on = emitter.on || emitter.addListener;
      var off = emitter.off || emitter.removeListener;
      on.apply(emitter, args);
      this.disposal.push(function () {
        return off.apply(emitter, args);
      });
    }
  }, {
    key: "destroy",
    value: function destroy() {
      var destroyers = this.disposal;
      this.disposal = [];
      destroyers.forEach(function (fn) {
        return fn();
      });
    }
  }, {
    key: "jqOn",
    value: function jqOn(el) {
      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      var $el = $(el);
      $el.on.apply($el, args);
      this.disposal.push(function () {
        return $el.off.apply($el, args);
      });
    }
  }, {
    key: "fakeD3Bind",
    value: function fakeD3Bind(el, event, handler) {
      var _this2 = this;

      this.jqOn(el, event, function (e) {
        // mimic https://github.com/mbostock/d3/blob/3abb00113662463e5c19eb87cd33f6d0ddc23bc0/src/selection/on.js#L87-L94
        var o = d3.event; // Events can be reentrant (e.g., focus).

        d3.event = e;

        try {
          // @ts-ignore
          handler.apply(_this2, [_this2.__data__]);
        } finally {
          d3.event = o;
        }
      });
    }
  }]);

  return Binder;
}();