function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { esQuery } from '../../data/public';
import { SearchAPI } from './data_model/search_api'; // @ts-ignore

import { TimeCache } from './data_model/time_cache';
import { getData, getInjectedMetadata } from './services';
export function createVegaRequestHandler(_ref, abortSignal) {
  var data = _ref.plugins.data,
      uiSettings = _ref.core.uiSettings,
      serviceSettings = _ref.serviceSettings;
  var searchAPI;
  var timefilter = data.query.timefilter.timefilter;
  var timeCache = new TimeCache(timefilter, 3 * 1000);
  return /*#__PURE__*/function () {
    var _vegaRequestHandler = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref2) {
      var timeRange, filters, query, visParams, esQueryConfigs, filtersDsl, _yield$import, VegaParser, vp;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              timeRange = _ref2.timeRange, filters = _ref2.filters, query = _ref2.query, visParams = _ref2.visParams;

              if (!searchAPI) {
                searchAPI = new SearchAPI({
                  uiSettings: uiSettings,
                  search: getData().search,
                  injectedMetadata: getInjectedMetadata()
                }, abortSignal);
              }

              timeCache.setTimeRange(timeRange);
              esQueryConfigs = esQuery.getEsQueryConfig(uiSettings);
              filtersDsl = esQuery.buildEsQuery(undefined, query, filters, esQueryConfigs); // @ts-ignore

              _context.next = 7;
              return import('./data_model/vega_parser');

            case 7:
              _yield$import = _context.sent;
              VegaParser = _yield$import.VegaParser;
              vp = new VegaParser(visParams.spec, searchAPI, timeCache, filtersDsl, serviceSettings);
              _context.next = 12;
              return vp.parseAsync();

            case 12:
              return _context.abrupt("return", _context.sent);

            case 13:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function vegaRequestHandler(_x) {
      return _vegaRequestHandler.apply(this, arguments);
    }

    return vegaRequestHandler;
  }();
}