function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { Markdown } from '../../kibana_react/public';

/**
 * The MarkdownVisComponent renders markdown to HTML and presents it.
 */
var MarkdownVisComponent = /*#__PURE__*/function (_React$Component) {
  _inherits(MarkdownVisComponent, _React$Component);

  var _super = _createSuper(MarkdownVisComponent);

  function MarkdownVisComponent() {
    _classCallCheck(this, MarkdownVisComponent);

    return _super.apply(this, arguments);
  }

  _createClass(MarkdownVisComponent, [{
    key: "componentDidMount",

    /**
     * Will be called after the first render when the component is present in the DOM.
     *
     * We call renderComplete here, to signal, that we are done with rendering.
     */
    value: function componentDidMount() {
      this.props.renderComplete();
    }
    /**
     * Will be called after the component has been updated and the changes has been
     * flushed into the DOM.
     *
     * We will use this to signal that we are done rendering by calling the
     * renderComplete property.
     */

  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.props.renderComplete();
    }
    /**
     * Render the actual HTML.
     * Note: if only fontSize parameter has changed, this method will be called
     * and return the appropriate JSX, but React will detect, that only the
     * style argument has been updated, and thus only set this attribute to the DOM.
     */

  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement("div", {
        className: "mkdVis",
        style: {
          fontSize: "".concat(this.props.fontSize, "pt")
        }
      }, /*#__PURE__*/React.createElement(Markdown, {
        "data-test-subj": "markdownBody",
        markdown: this.props.markdown,
        openLinksInNewTab: this.props.openLinksInNewTab
      }));
    }
  }]);

  return MarkdownVisComponent;
}(React.Component);
/**
 * This is a wrapper component, that is actually used as the visualization.
 * The sole purpose of this component is to extract all required parameters from
 * the properties and pass them down as separate properties to the actual component.
 * That way the actual (MarkdownVisComponent) will properly trigger it's prop update
 * callback (componentWillReceiveProps) if one of these params change. It wouldn't
 * trigger otherwise (e.g. it doesn't for this wrapper), since it only triggers
 * if the reference to the prop changes (in this case the reference to vis).
 *
 * The way React works, this wrapper nearly brings no overhead, but allows us
 * to use proper lifecycle methods in the actual component.
 */


export function MarkdownVisWrapper(props) {
  return /*#__PURE__*/React.createElement(MarkdownVisComponent, {
    fontSize: props.visParams.fontSize,
    markdown: props.visParams.markdown,
    openLinksInNewTab: props.visParams.openLinksInNewTab,
    renderComplete: props.renderComplete
  });
}