function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';

function isSuccess(result) {
  return 'id' in result;
}

export function showSaveModal(saveModal, I18nContext) {
  var container = document.createElement('div');

  var closeModal = function closeModal() {
    ReactDOM.unmountComponentAtNode(container);
    document.body.removeChild(container);
  };

  var onSave = saveModal.props.onSave;

  var onSaveConfirmed = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var response,
          _args = arguments;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return onSave.apply(void 0, _args);

            case 2:
              response = _context.sent;

              // close modal if we either hit an error or the saved object got an id
              if (Boolean(isSuccess(response) ? response.id : response.error)) {
                closeModal();
              }

              return _context.abrupt("return", response);

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function onSaveConfirmed() {
      return _ref.apply(this, arguments);
    };
  }();

  document.body.appendChild(container);
  var element = /*#__PURE__*/React.cloneElement(saveModal, {
    onSave: onSaveConfirmed,
    onClose: closeModal
  });
  ReactDOM.render( /*#__PURE__*/React.createElement(I18nContext, null, element), container);
}