function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
// @ts-ignore
import { setToasts, setUiSettings, setKibanaVersion, setMapsLegacyConfig } from './kibana_services'; // @ts-ignore

import { ServiceSettings } from './map/service_settings'; // @ts-ignore

import { getPrecision, getZoomPrecision } from './map/precision'; // @ts-ignore

import { KibanaMap } from './map/kibana_map';
// @ts-ignore
import { BaseMapsVisualizationProvider } from './map/base_maps_visualization';
/**
 * These are the interfaces with your public contracts. You should export these
 * for other plugins to use in _their_ `SetupDeps`/`StartDeps` interfaces.
 * @public
 */

export var bindSetupCoreAndPlugins = function bindSetupCoreAndPlugins(core, config, kibanaVersion) {
  setToasts(core.notifications.toasts);
  setUiSettings(core.uiSettings);
  setKibanaVersion(kibanaVersion);
  setMapsLegacyConfig(config);
}; // eslint-disable-next-line @typescript-eslint/no-empty-interface

export var MapsLegacyPlugin = /*#__PURE__*/function () {
  function MapsLegacyPlugin(initializerContext) {
    _classCallCheck(this, MapsLegacyPlugin);

    _defineProperty(this, "_initializerContext", void 0);

    this._initializerContext = initializerContext;
  }

  _createClass(MapsLegacyPlugin, [{
    key: "setup",
    value: function setup(core, plugins) {
      var config = this._initializerContext.config.get();

      var kibanaVersion = this._initializerContext.env.packageInfo.version;
      bindSetupCoreAndPlugins(core, config, kibanaVersion);
      var serviceSettings = new ServiceSettings(config, config.tilemap);

      var getKibanaMapFactoryProvider = function getKibanaMapFactoryProvider() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return _construct(KibanaMap, args);
      };

      var getBaseMapsVis = function getBaseMapsVis() {
        return new BaseMapsVisualizationProvider(getKibanaMapFactoryProvider, serviceSettings);
      };

      return {
        serviceSettings: serviceSettings,
        getZoomPrecision: getZoomPrecision,
        getPrecision: getPrecision,
        config: config,
        getKibanaMapFactoryProvider: getKibanaMapFactoryProvider,
        getBaseMapsVis: getBaseMapsVis
      };
    }
  }, {
    key: "start",
    value: function start(core, plugins) {}
  }]);

  return MapsLegacyPlugin;
}();