/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { getSearchSourceMock } from './get_search_service_mock';
var fields = [];
fields.push({
  name: 'myField'
});

fields.getByName = function (name) {
  return fields.find(function (_ref) {
    var n = _ref.name;
    return n === name;
  });
};

export var getDepsMock = function getDepsMock() {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref2$searchSource = _ref2.searchSource,
      searchSource = _ref2$searchSource === void 0 ? {
    create: getSearchSourceMock()
  } : _ref2$searchSource;

  return {
    core: {
      getStartServices: jest.fn().mockReturnValue([null, {
        data: {
          search: {
            searchSource: searchSource
          },
          ui: {
            IndexPatternSelect: function IndexPatternSelect() {
              return /*#__PURE__*/React.createElement("div", null);
            }
          },
          indexPatterns: {
            get: function get() {
              return {
                fields: fields
              };
            }
          }
        }
      }])
    },
    getSettings: jest.fn().mockImplementation(function () {
      return Promise.resolve({
        autocompleteTimeout: 1000,
        autocompleteTerminateAfter: 100000
      });
    }),
    data: {
      search: {
        searchSource: {
          create: getSearchSourceMock()
        }
      },
      query: {
        filterManager: {
          fieldName: 'myField',
          getIndexPattern: function getIndexPattern() {
            return {
              fields: fields
            };
          },
          getAppFilters: jest.fn().mockImplementation(function () {
            return [];
          }),
          getGlobalFilters: jest.fn().mockImplementation(function () {
            return [];
          })
        },
        timefilter: {
          timefilter: {}
        }
      }
    }
  };
};