function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import { i18n } from '@kbn/i18n';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react';
import { EuiButtonEmpty, EuiFieldNumber, EuiFlexGroup, EuiFlexItem, EuiFormRow, EuiSpacer } from '@elastic/eui';
import { ActionBarWarning } from './action_bar_warning';
import { MAX_CONTEXT_SIZE, MIN_CONTEXT_SIZE } from '../../query_parameters/constants';
export function ActionBar(_ref) {
  var defaultStepSize = _ref.defaultStepSize,
      docCount = _ref.docCount,
      docCountAvailable = _ref.docCountAvailable,
      isDisabled = _ref.isDisabled,
      isLoading = _ref.isLoading,
      onChangeCount = _ref.onChangeCount,
      type = _ref.type;
  var showWarning = !isDisabled && !isLoading && docCountAvailable < docCount;
  var isSuccessor = type === 'successors';

  var _useState = useState(docCount),
      _useState2 = _slicedToArray(_useState, 2),
      newDocCount = _useState2[0],
      setNewDocCount = _useState2[1];

  var isValid = function isValid(value) {
    return value >= MIN_CONTEXT_SIZE && value <= MAX_CONTEXT_SIZE;
  };

  var onSubmit = function onSubmit(ev) {
    ev.preventDefault();

    if (newDocCount !== docCount && isValid(newDocCount)) {
      onChangeCount(newDocCount);
    }
  };

  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement("form", {
    onSubmit: onSubmit
  }, isSuccessor && /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), isSuccessor && showWarning && /*#__PURE__*/React.createElement(ActionBarWarning, {
    docCount: docCountAvailable,
    type: type
  }), isSuccessor && showWarning && /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    "data-test-subj": "".concat(type, "LoadMoreButton"),
    iconType: isSuccessor ? 'arrowDown' : 'arrowUp',
    isDisabled: isDisabled,
    isLoading: isLoading,
    onClick: function onClick() {
      var value = newDocCount + defaultStepSize;

      if (isValid(value)) {
        setNewDocCount(value);
        onChangeCount(value);
      }
    },
    flush: "right"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.context.loadButtonLabel",
    defaultMessage: "Load"
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    "aria-label": isSuccessor ? i18n.translate('discover.context.olderDocumentsAriaLabel', {
      defaultMessage: 'Number of older documents'
    }) : i18n.translate('discover.context.newerDocumentsAriaLabel', {
      defaultMessage: 'Number of newer documents'
    }),
    className: "cxtSizePicker",
    "data-test-subj": "".concat(type, "CountPicker"),
    disabled: isDisabled,
    min: MIN_CONTEXT_SIZE,
    max: MAX_CONTEXT_SIZE,
    onChange: function onChange(ev) {
      setNewDocCount(ev.target.valueAsNumber);
    },
    onBlur: function onBlur() {
      if (newDocCount !== docCount && isValid(newDocCount)) {
        onChangeCount(newDocCount);
      }
    },
    type: "number",
    value: newDocCount >= 0 ? newDocCount : ''
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    displayOnly: true
  }, isSuccessor ? /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.context.olderDocumentsDescription",
    defaultMessage: "older documents"
  }) : /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.context.newerDocumentsDescription",
    defaultMessage: "newer documents"
  })))), !isSuccessor && showWarning && /*#__PURE__*/React.createElement(ActionBarWarning, {
    docCount: docCountAvailable,
    type: type
  }), !isSuccessor && /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  })));
}