"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatternFieldListCreator = void 0;

var _lodash = require("lodash");

var _field = require("./field");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const getIndexPatternFieldListCreator = ({
  fieldFormats,
  onNotification
}) => (...fieldListParams) => {
  class FieldList extends Array {
    constructor(indexPattern, specs = [], shortDotsEnable = false) {
      super();

      _defineProperty(this, "byName", new Map());

      _defineProperty(this, "groups", new Map());

      _defineProperty(this, "indexPattern", void 0);

      _defineProperty(this, "shortDotsEnable", void 0);

      _defineProperty(this, "setByName", field => this.byName.set(field.name, field));

      _defineProperty(this, "setByGroup", field => {
        if (typeof this.groups.get(field.type) === 'undefined') {
          this.groups.set(field.type, new Map());
        }

        this.groups.get(field.type).set(field.name, field);
      });

      _defineProperty(this, "removeByGroup", field => this.groups.get(field.type).delete(field.name));

      _defineProperty(this, "getByName", name => this.byName.get(name));

      _defineProperty(this, "getByType", type => [...(this.groups.get(type) || new Map()).values()]);

      _defineProperty(this, "add", field => {
        const newField = new _field.Field(this.indexPattern, field, this.shortDotsEnable, {
          fieldFormats,
          onNotification
        });
        this.push(newField);
        this.setByName(newField);
        this.setByGroup(newField);
      });

      _defineProperty(this, "remove", field => {
        this.removeByGroup(field);
        this.byName.delete(field.name);
        const fieldIndex = (0, _lodash.findIndex)(this, {
          name: field.name
        });
        this.splice(fieldIndex, 1);
      });

      _defineProperty(this, "update", field => {
        const newField = new _field.Field(this.indexPattern, field, this.shortDotsEnable, {
          fieldFormats,
          onNotification
        });
        const index = this.findIndex(f => f.name === newField.name);
        this.splice(index, 1, newField);
        this.setByName(newField);
        this.removeByGroup(newField);
        this.setByGroup(newField);
      });

      _defineProperty(this, "toSpec", () => {
        return [...this.map(field => field.toSpec())];
      });

      this.indexPattern = indexPattern;
      this.shortDotsEnable = shortDotsEnable;
      specs.map(field => this.add(field));
    }

  }

  return new FieldList(...fieldListParams);
};

exports.getIndexPatternFieldListCreator = getIndexPatternFieldListCreator;