function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiHeader, EuiHeaderSection, EuiHeaderSectionItem, EuiHeaderSectionItemButton, EuiIcon, EuiShowFor, htmlIdGenerator } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import classnames from 'classnames';
import React, { createRef, useState } from 'react';
import { useObservable } from 'react-use';
import { LoadingIndicator } from '../';
import { CollapsibleNav } from './collapsible_nav';
import { HeaderBadge } from './header_badge';
import { HeaderBreadcrumbs } from './header_breadcrumbs';
import { HeaderHelpMenu } from './header_help_menu';
import { HeaderLogo } from './header_logo';
import { HeaderNavControls } from './header_nav_controls';
import { NavDrawer } from './nav_drawer';

function renderMenuTrigger(toggleOpen) {
  return /*#__PURE__*/React.createElement(EuiHeaderSectionItemButton, {
    "aria-label": i18n.translate('core.ui.chrome.headerGlobalNav.toggleSideNavAriaLabel', {
      defaultMessage: 'Toggle side navigation'
    }),
    onClick: toggleOpen
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "apps",
    size: "m"
  }));
}

export function Header(_ref) {
  var kibanaVersion = _ref.kibanaVersion,
      kibanaDocLink = _ref.kibanaDocLink,
      legacyMode = _ref.legacyMode,
      application = _ref.application,
      basePath = _ref.basePath,
      onIsLockedUpdate = _ref.onIsLockedUpdate,
      homeHref = _ref.homeHref,
      observables = _objectWithoutProperties(_ref, ["kibanaVersion", "kibanaDocLink", "legacyMode", "application", "basePath", "onIsLockedUpdate", "homeHref"]);

  var isVisible = useObservable(observables.isVisible$, true);
  var navType = useObservable(observables.navType$, 'modern');
  var isLocked = useObservable(observables.isLocked$, false);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  if (!isVisible) {
    return /*#__PURE__*/React.createElement(LoadingIndicator, {
      loadingCount$: observables.loadingCount$
    });
  }

  var navDrawerRef = /*#__PURE__*/createRef();
  var toggleCollapsibleNavRef = /*#__PURE__*/createRef();
  var navId = htmlIdGenerator()();
  var className = classnames('chrHeaderWrapper', // TODO #64541 - delete this
  'hide-for-sharing', {
    'chrHeaderWrapper--navIsLocked': isLocked,
    headerWrapper: navType === 'modern'
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(LoadingIndicator, {
    loadingCount$: observables.loadingCount$
  }), /*#__PURE__*/React.createElement("header", {
    className: className,
    "data-test-subj": "headerGlobalNav"
  }, /*#__PURE__*/React.createElement(EuiHeader, {
    position: "fixed"
  }, /*#__PURE__*/React.createElement(EuiHeaderSection, {
    grow: false
  }, navType === 'modern' ? /*#__PURE__*/React.createElement(EuiHeaderSectionItem, {
    border: "right",
    className: "header__toggleNavButtonSection"
  }, /*#__PURE__*/React.createElement(EuiHeaderSectionItemButton, {
    "data-test-subj": "toggleNavButton",
    "aria-label": i18n.translate('core.ui.primaryNav.toggleNavAriaLabel', {
      defaultMessage: 'Toggle primary navigation'
    }),
    onClick: function onClick() {
      return setIsOpen(!isOpen);
    },
    "aria-expanded": isOpen,
    "aria-pressed": isOpen,
    "aria-controls": navId,
    ref: toggleCollapsibleNavRef
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "menu",
    size: "m"
  }))) :
  /*#__PURE__*/
  // TODO #64541
  // Delete this block
  React.createElement(EuiShowFor, {
    sizes: ['xs', 's']
  }, /*#__PURE__*/React.createElement(EuiHeaderSectionItem, {
    border: "right"
  }, renderMenuTrigger(function () {
    var _navDrawerRef$current;

    return (_navDrawerRef$current = navDrawerRef.current) === null || _navDrawerRef$current === void 0 ? void 0 : _navDrawerRef$current.toggleOpen();
  }))), /*#__PURE__*/React.createElement(EuiHeaderSectionItem, {
    border: "right"
  }, /*#__PURE__*/React.createElement(HeaderLogo, {
    href: homeHref,
    forceNavigation$: observables.forceAppSwitcherNavigation$,
    navLinks$: observables.navLinks$,
    navigateToApp: application.navigateToApp
  })), /*#__PURE__*/React.createElement(HeaderNavControls, {
    side: "left",
    navControls$: observables.navControlsLeft$
  })), /*#__PURE__*/React.createElement(HeaderBreadcrumbs, {
    appTitle$: observables.appTitle$,
    breadcrumbs$: observables.breadcrumbs$
  }), /*#__PURE__*/React.createElement(HeaderBadge, {
    badge$: observables.badge$
  }), /*#__PURE__*/React.createElement(EuiHeaderSection, {
    side: "right"
  }, /*#__PURE__*/React.createElement(EuiHeaderSectionItem, null, /*#__PURE__*/React.createElement(HeaderHelpMenu, {
    helpExtension$: observables.helpExtension$,
    helpSupportUrl$: observables.helpSupportUrl$,
    kibanaDocLink: kibanaDocLink,
    kibanaVersion: kibanaVersion
  })), /*#__PURE__*/React.createElement(HeaderNavControls, {
    side: "right",
    navControls$: observables.navControlsRight$
  }))), navType === 'modern' ? /*#__PURE__*/React.createElement(CollapsibleNav, {
    appId$: application.currentAppId$,
    id: navId,
    isLocked: isLocked,
    navLinks$: observables.navLinks$,
    recentlyAccessed$: observables.recentlyAccessed$,
    isOpen: isOpen,
    homeHref: homeHref,
    basePath: basePath,
    legacyMode: legacyMode,
    navigateToApp: application.navigateToApp,
    onIsLockedUpdate: onIsLockedUpdate,
    closeNav: function closeNav() {
      setIsOpen(false);

      if (toggleCollapsibleNavRef.current) {
        toggleCollapsibleNavRef.current.focus();
      }
    },
    customNavLink$: observables.customNavLink$
  }) :
  /*#__PURE__*/
  // TODO #64541
  // Delete this block
  React.createElement(NavDrawer, {
    isLocked: isLocked,
    onIsLockedUpdate: onIsLockedUpdate,
    navLinks$: observables.navLinks$,
    recentlyAccessed$: observables.recentlyAccessed$,
    basePath: basePath,
    appId$: application.currentAppId$,
    navigateToApp: application.navigateToApp,
    ref: navDrawerRef,
    legacyMode: legacyMode
  })));
}