function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { cloneDeep, isEqual, take } from 'lodash';
import * as Rx from 'rxjs';
import { map } from 'rxjs/operators';
export var PersistedLog = /*#__PURE__*/function () {
  function PersistedLog(name, options) {
    var storage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : localStorage;

    _classCallCheck(this, PersistedLog);

    _defineProperty(this, "name", void 0);

    _defineProperty(this, "maxLength", void 0);

    _defineProperty(this, "isEqual", void 0);

    _defineProperty(this, "storage", void 0);

    _defineProperty(this, "items$", void 0);

    this.name = name;
    this.maxLength = typeof options.maxLength === 'string' ? this.maxLength = parseInt(options.maxLength, 10) : options.maxLength;
    this.isEqual = options.isEqual || isEqual;
    this.storage = storage;
    this.items$ = new Rx.BehaviorSubject(this.loadItems());

    if (this.maxLength !== undefined && !isNaN(this.maxLength)) {
      this.items$.next(take(this.items$.value, this.maxLength));
    }
  }

  _createClass(PersistedLog, [{
    key: "add",
    value: function add(val) {
      var _this = this;

      if (val == null) {
        return this.items$.value;
      }

      var nextItems = [val].concat(_toConsumableArray(_toConsumableArray(this.items$.value).filter(function (item) {
        return !_this.isEqual(item, val);
      }))).slice(0, this.maxLength); // truncate
      // Persist the stack to storage

      this.storage.setItem(this.name, JSON.stringify(nextItems)); // Notify subscribers

      this.items$.next(nextItems);
      return nextItems;
    }
  }, {
    key: "get",
    value: function get() {
      return cloneDeep(this.items$.value);
    }
  }, {
    key: "get$",
    value: function get$() {
      return this.items$.pipe(map(function (items) {
        return cloneDeep(items);
      }));
    }
  }, {
    key: "loadItems",
    value: function loadItems() {
      try {
        return JSON.parse(this.storage.getItem(this.name) || '[]');
      } catch (_unused) {
        return [];
      }
    }
  }]);

  return PersistedLog;
}();