function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { AppNavLinkStatus, AppStatus } from '../../application';
import { NavLinkWrapper } from './nav_link';
import { appendAppPath } from '../../application/utils';
export function toNavLink(app, basePath) {
  var useAppStatus = app.navLinkStatus === AppNavLinkStatus.default;
  var relativeBaseUrl = isLegacyApp(app) ? basePath.prepend(app.appUrl) : basePath.prepend(app.appRoute);
  var url = relativeToAbsolute(appendAppPath(relativeBaseUrl, app.defaultPath));
  var baseUrl = relativeToAbsolute(relativeBaseUrl);
  return new NavLinkWrapper(_objectSpread(_objectSpread({}, app), {}, {
    hidden: useAppStatus ? app.status === AppStatus.inaccessible : app.navLinkStatus === AppNavLinkStatus.hidden,
    disabled: useAppStatus ? false : app.navLinkStatus === AppNavLinkStatus.disabled,
    legacy: isLegacyApp(app),
    baseUrl: baseUrl
  }, isLegacyApp(app) ? {
    href: url && !url.startsWith(app.subUrlBase) ? url : baseUrl
  } : {
    href: url,
    url: url
  }));
}
/**
 * @param {string} url - a relative or root relative url.  If a relative path is given then the
 * absolute url returned will depend on the current page where this function is called from. For example
 * if you are on page "http://www.mysite.com/shopping/kids" and you pass this function "adults", you would get
 * back "http://www.mysite.com/shopping/adults".  If you passed this function a root relative path, or one that
 * starts with a "/", for example "/account/cart", you would get back "http://www.mysite.com/account/cart".
 * @return {string} the relative url transformed into an absolute url
 */

export function relativeToAbsolute(url) {
  var a = document.createElement('a');
  a.setAttribute('href', url);
  return a.href;
}

function isLegacyApp(app) {
  return app.legacy === true;
}