"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlock = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _code_block = require("./_code_block");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiCodeBlock = function EuiCodeBlock(_ref) {
  var inline = _ref.inline,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["inline"]);
  return _react.default.createElement(_code_block.EuiCodeBlockImpl, (0, _extends2.default)({
    inline: false
  }, rest));
};

exports.EuiCodeBlock = EuiCodeBlock;
EuiCodeBlock.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  inline: _propTypes.default.oneOf([false]),
  paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),
  fontSize: _propTypes.default.oneOf(["s", "m", "l"]),
  overflowHeight: _propTypes.default.number,
  isCopyable: _propTypes.default.bool,

  /**
     * Sets the syntax highlighting for a specific language
     * @see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases
     * for options
     */
  language: _propTypes.default.string,
  transparentBackground: _propTypes.default.bool
};
EuiCodeBlock.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCodeBlock",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "inline": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "false",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "paddingSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "fontSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "overflowHeight": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "isCopyable": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "language": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Sets the syntax highlighting for a specific language\n@see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases\nfor options"
    },
    "transparentBackground": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    }
  }
};