"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var axis_utils_1 = require("../../../utils/axis_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderTickLabel(ctx, tick, props) {
    var labelStyle = __assign(__assign({}, props.axisConfig.tickLabelStyle), { padding: 0 });
    var _a = props.axisSpec, tickSize = _a.tickSize, tickPadding = _a.tickPadding, position = _a.position, axisTicksDimensions = props.axisTicksDimensions, axisPosition = props.axisPosition, debug = props.debug;
    var tickLabelRotation = props.axisSpec.tickLabelRotation || 0;
    var tickLabelProps = axis_utils_1.getTickLabelProps(tickLabelRotation, tickSize, tickPadding, tick.position, position, axisPosition, axisTicksDimensions);
    var maxLabelTextWidth = axisTicksDimensions.maxLabelTextWidth, maxLabelTextHeight = axisTicksDimensions.maxLabelTextHeight;
    var x = tickLabelProps.x, y = tickLabelProps.y, offsetX = tickLabelProps.offsetX, offsetY = tickLabelProps.offsetY, align = tickLabelProps.align, verticalAlign = tickLabelProps.verticalAlign;
    if (debug) {
        debug_1.renderDebugRectCenterRotated(ctx, {
            x: x + offsetX,
            y: y + offsetY,
        }, {
            x: x + offsetX,
            y: y + offsetY,
            height: maxLabelTextHeight,
            width: maxLabelTextWidth,
        }, undefined, undefined, tickLabelRotation);
    }
    var font = {
        fontFamily: labelStyle.fontFamily,
        fontStyle: labelStyle.fontStyle ? labelStyle.fontStyle : 'normal',
        fontVariant: 'normal',
        fontWeight: 'normal',
        textColor: labelStyle.fill,
        textOpacity: 1,
    };
    canvas_1.withContext(ctx, function (ctx) {
        var textOffsetX = tickLabelRotation === 0 ? 0 : offsetX;
        var textOffsetY = tickLabelRotation === 0 ? 0 : offsetY;
        text_1.renderText(ctx, {
            x: x + textOffsetX,
            y: y + textOffsetY,
        }, tick.label, __assign(__assign({}, font), { fontSize: labelStyle.fontSize, fill: labelStyle.fill, align: align, baseline: verticalAlign }), tickLabelRotation);
    });
}
exports.renderTickLabel = renderTickLabel;
//# sourceMappingURL=tick_label.js.map