module GObjectIntrospection
  # Wraps a GIFunctionInfo struct.
  # Represents a function or method.
  class IFunctionInfo < ICallableInfo
    def symbol
      Lib.g_function_info_get_symbol @gobj
    end

    def flags
      Lib.g_function_info_get_flags @gobj
    end

    # TODO: Use some sort of bitfield
    def method?
      flags & 1 != 0
    end

    def constructor?
      flags & 2 != 0
    end

    def getter?
      flags & 4 != 0
    end

    def setter?
      flags & 8 != 0
    end

    def wraps_vfunc?
      flags & 16 != 0
    end

    def throws?
      flags & 32 != 0
    end
  end
end
