/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.traccar.database.DataManager;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.model.Driver;

public class DriversManager
extends ExtendedObjectManager<Driver> {
    private Map<String, Driver> driversByUniqueId;

    public DriversManager(DataManager dataManager) {
        super(dataManager, Driver.class);
        try {
            this.writeLock();
            if (this.driversByUniqueId == null) {
                this.driversByUniqueId = new ConcurrentHashMap<String, Driver>();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void addByUniqueId(Driver driver) {
        try {
            this.writeLock();
            if (this.driversByUniqueId == null) {
                this.driversByUniqueId = new ConcurrentHashMap<String, Driver>();
            }
            this.driversByUniqueId.put(driver.getUniqueId(), driver);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeByUniqueId(String driverUniqueId) {
        try {
            this.writeLock();
            if (this.driversByUniqueId == null) {
                this.driversByUniqueId = new ConcurrentHashMap<String, Driver>();
            }
            this.driversByUniqueId.remove(driverUniqueId);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    protected void addNewItem(Driver driver) {
        super.addNewItem(driver);
        this.addByUniqueId(driver);
    }

    @Override
    protected void updateCachedItem(Driver driver) {
        Driver cachedDriver = (Driver)this.getById(driver.getId());
        cachedDriver.setName(driver.getName());
        if (!driver.getUniqueId().equals(cachedDriver.getUniqueId())) {
            this.removeByUniqueId(cachedDriver.getUniqueId());
            cachedDriver.setUniqueId(driver.getUniqueId());
            this.addByUniqueId(cachedDriver);
        }
        cachedDriver.setAttributes(driver.getAttributes());
    }

    @Override
    protected void removeCachedItem(long driverId) {
        Driver cachedDriver = (Driver)this.getById(driverId);
        if (cachedDriver != null) {
            String driverUniqueId = cachedDriver.getUniqueId();
            super.removeCachedItem(driverId);
            this.removeByUniqueId(driverUniqueId);
        }
    }

    public Driver getDriverByUniqueId(String uniqueId) {
        try {
            this.readLock();
            Driver driver = this.driversByUniqueId.get(uniqueId);
            return driver;
        }
        finally {
            this.readUnlock();
        }
    }
}

