/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import com.cloudhopper.smpp.type.LoggingOptions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SmppSessionLogger
extends ChannelDuplexHandler {
    private final Logger logger;
    private final LoggingOptions options;

    public SmppSessionLogger(String name) {
        this(name, new LoggingOptions());
    }

    public SmppSessionLogger(String name, LoggingOptions options) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.options = options;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggingOptions getOptions() {
        return this.options;
    }

    protected void log(Direction direction, Object obj) {
        if (obj instanceof ByteBuf && this.options.isLogBytesEnabled()) {
            ByteBuf buffer = (ByteBuf)obj;
            if (direction == Direction.UP) {
                this.logger.info("read bytes: [{}]", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
            } else if (direction == Direction.DOWN) {
                this.logger.info("write bytes: [{}]", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.log(Direction.UP, msg);
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.log(Direction.DOWN, msg);
        ctx.write(msg, promise);
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

