/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class RefCounted<Type> {
    protected final Type resource;
    protected final AtomicInteger refcount = new AtomicInteger();

    public RefCounted(Type resource) {
        this.resource = resource;
    }

    public int getRefcount() {
        return this.refcount.get();
    }

    public final RefCounted<Type> incref() {
        this.refcount.incrementAndGet();
        return this;
    }

    public final Type get() {
        return this.resource;
    }

    public void decref() {
        if (this.refcount.decrementAndGet() == 0) {
            this.close();
        }
    }

    protected abstract void close();
}

