/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), -2.0lf) => dvec3(-1.9lf, -0.6333333333333333lf, -1.3666666666666667lf)
 * mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), -2.0lf) => dvec3(-0.10000000000000009lf, -1.9lf, -0.6333333333333333lf)
 * mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), -0.6666666666666667lf) => dvec3(-0.5666666666666664lf, -0.6333333333333333lf, -0.03333333333333344lf)
 * mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), -0.6666666666666667lf) => dvec3(-0.10000000000000009lf, -0.5666666666666664lf, -0.6333333333333333lf)
 * mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), 0.6666666666666665lf) => dvec3(0.09999999999999964lf, 0.033333333333333215lf, 0.6333333333333333lf)
 * mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), 0.6666666666666665lf) => dvec3(0.5666666666666669lf, 0.09999999999999964lf, 0.033333333333333215lf)
 * mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), 2.0lf) => dvec3(0.10000000000000009lf, 1.3666666666666667lf, 0.6333333333333333lf)
 * mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), 2.0lf) => dvec3(1.9lf, 0.10000000000000009lf, 1.3666666666666667lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), -2.0lf), dvec3(-1.9lf, -0.6333333333333333lf, -1.3666666666666667lf)) <= 2.4246420125224443e-05lf ? 1 : -1] array0;
  double[distance(mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), -2.0lf), dvec3(-0.10000000000000009lf, -1.9lf, -0.6333333333333333lf)) <= 2.0052708323593376e-05lf ? 1 : -1] array1;
  double[distance(mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), -0.6666666666666667lf), dvec3(-0.5666666666666664lf, -0.6333333333333333lf, -0.03333333333333344lf)) <= 8.504900548115382e-06lf ? 1 : -1] array2;
  double[distance(mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), -0.6666666666666667lf), dvec3(-0.10000000000000009lf, -0.5666666666666664lf, -0.6333333333333333lf)) <= 8.556998435328955e-06lf ? 1 : -1] array3;
  double[distance(mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), 0.6666666666666665lf), dvec3(0.09999999999999964lf, 0.033333333333333215lf, 0.6333333333333333lf)) <= 6.420453428086074e-06lf ? 1 : -1] array4;
  double[distance(mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), 0.6666666666666665lf), dvec3(0.5666666666666669lf, 0.09999999999999964lf, 0.033333333333333215lf)) <= 5.76387215526353e-06lf ? 1 : -1] array5;
  double[distance(mod(dvec3(-1.9lf, -0.6333333333333333lf, 0.6333333333333333lf), 2.0lf), dvec3(0.10000000000000009lf, 1.3666666666666667lf, 0.6333333333333333lf)) <= 1.5095989165632337e-05lf ? 1 : -1] array6;
  double[distance(mod(dvec3(1.9lf, -1.9lf, -0.6333333333333333lf), 2.0lf), dvec3(1.9lf, 0.10000000000000009lf, 1.3666666666666667lf)) <= 2.3426006441085467e-05lf ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
