/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.concurrent;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.concurrent.Sync;
import org.omg.CORBA.INTERNAL;

public class ReentrantMutex
implements Sync {
    protected Thread holder_ = null;
    protected int counter_ = 0;
    protected boolean debug = false;

    public ReentrantMutex() {
        this(false);
    }

    public ReentrantMutex(boolean bl) {
        this.debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ReentrantMutex reentrantMutex = this;
        synchronized (reentrantMutex) {
            try {
                Thread thread;
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquire enter: holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
                if (this.holder_ != (thread = Thread.currentThread())) {
                    try {
                        while (this.counter_ > 0) {
                            this.wait();
                        }
                        if (this.counter_ != 0) {
                            throw new INTERNAL("counter not 0 when first acquiring mutex");
                        }
                        this.holder_ = thread;
                    }
                    catch (InterruptedException interruptedException) {
                        this.notify();
                        throw interruptedException;
                    }
                }
                ++this.counter_;
            }
            finally {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquire exit: holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireAll(int n) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ReentrantMutex reentrantMutex = this;
        synchronized (reentrantMutex) {
            try {
                Thread thread;
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquireAll enter: count=" + n + " holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
                if (this.holder_ == (thread = Thread.currentThread())) {
                    throw new INTERNAL("Cannot acquireAll while holding the mutex");
                }
                try {
                    while (this.counter_ > 0) {
                        this.wait();
                    }
                    if (this.counter_ != 0) {
                        throw new INTERNAL("counter not 0 when first acquiring mutex");
                    }
                    this.holder_ = thread;
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
                this.counter_ = n;
            }
            finally {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquireAll exit: count=" + n + " holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
            }
        }
    }

    @Override
    public synchronized void release() {
        try {
            Thread thread;
            if (this.debug) {
                ORBUtility.dprintTrace(this, "release enter:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
            if ((thread = Thread.currentThread()) != this.holder_) {
                throw new INTERNAL("Attempt to release Mutex by thread not holding the Mutex");
            }
            --this.counter_;
            if (this.counter_ == 0) {
                this.holder_ = null;
                this.notify();
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprintTrace(this, "release exit:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int releaseAll() {
        try {
            Thread thread;
            if (this.debug) {
                ORBUtility.dprintTrace(this, "releaseAll enter:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
            if ((thread = Thread.currentThread()) != this.holder_) {
                throw new INTERNAL("Attempt to releaseAll Mutex by thread not holding the Mutex");
            }
            int n = this.counter_;
            this.counter_ = 0;
            this.holder_ = null;
            this.notify();
            int n2 = n;
            return n2;
        }
        finally {
            if (this.debug) {
                ORBUtility.dprintTrace(this, "releaseAll exit:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean attempt(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ReentrantMutex reentrantMutex = this;
        synchronized (reentrantMutex) {
            try {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "attempt enter: msecs=" + l + " holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
                Thread thread = Thread.currentThread();
                if (this.counter_ == 0) {
                    this.holder_ = thread;
                    this.counter_ = 1;
                    boolean bl = true;
                    return bl;
                }
                if (l <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                long l2 = l;
                long l3 = System.currentTimeMillis();
                do {
                    boolean bl;
                    try {
                        this.wait(l2);
                        if (this.counter_ != 0) continue;
                        this.holder_ = thread;
                        this.counter_ = 1;
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        this.notify();
                        throw interruptedException;
                    }
                    return bl;
                } while ((l2 = l - (System.currentTimeMillis() - l3)) > 0L);
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "attempt exit:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
            }
        }
    }
}

