/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SDeclaration;

public final class SDeclBlock
extends AStatement {
    private final List<SDeclaration> declarations;

    public SDeclBlock(Location location, List<SDeclaration> declarations) {
        super(location);
        this.declarations = Collections.unmodifiableList(declarations);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (SDeclaration declaration : this.declarations) {
            declaration.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        for (SDeclaration declaration : this.declarations) {
            declaration.analyze(scriptRoot, locals);
        }
        this.statementCount = this.declarations.size();
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        for (AStatement aStatement : this.declarations) {
            aStatement.write(classWriter, methodWriter, globals);
        }
    }

    @Override
    public String toString() {
        return this.multilineToString(Collections.emptyList(), this.declarations);
    }
}

