/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class TextSearchInfo {
    private static final FieldType SIMPLE_MATCH_ONLY_FIELD_TYPE = new FieldType();
    public static final TextSearchInfo SIMPLE_MATCH_ONLY;
    public static final TextSearchInfo WHITESPACE_MATCH_ONLY;
    public static final TextSearchInfo NONE;
    private final FieldType luceneFieldType;
    private final SimilarityProvider similarity;
    private final NamedAnalyzer searchAnalyzer;
    private final NamedAnalyzer searchQuoteAnalyzer;

    public TextSearchInfo(FieldType luceneFieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer) {
        this.luceneFieldType = luceneFieldType;
        this.similarity = similarity;
        this.searchAnalyzer = searchAnalyzer;
        this.searchQuoteAnalyzer = searchQuoteAnalyzer;
    }

    public SimilarityProvider getSimilarity() {
        return this.similarity;
    }

    public NamedAnalyzer getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public NamedAnalyzer getSearchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public boolean hasPositions() {
        return this.luceneFieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    public boolean hasOffsets() {
        return this.luceneFieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    public boolean hasNorms() {
        return !this.luceneFieldType.omitNorms();
    }

    public boolean isTokenized() {
        return this.luceneFieldType.tokenized();
    }

    public boolean isStored() {
        return this.luceneFieldType.stored();
    }

    public TermVector termVectors() {
        if (!this.luceneFieldType.storeTermVectors()) {
            return TermVector.NONE;
        }
        if (this.luceneFieldType.storeTermVectorOffsets()) {
            return TermVector.OFFSETS;
        }
        if (this.luceneFieldType.storeTermVectorPositions()) {
            return TermVector.POSITIONS;
        }
        return TermVector.DOCS;
    }

    static {
        SIMPLE_MATCH_ONLY_FIELD_TYPE.setTokenized(false);
        SIMPLE_MATCH_ONLY_FIELD_TYPE.setOmitNorms(true);
        SIMPLE_MATCH_ONLY_FIELD_TYPE.freeze();
        SIMPLE_MATCH_ONLY = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        WHITESPACE_MATCH_ONLY = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, Lucene.WHITESPACE_ANALYZER, Lucene.WHITESPACE_ANALYZER);
        NONE = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, null, null);
    }

    public static enum TermVector {
        NONE,
        DOCS,
        POSITIONS,
        OFFSETS;

    }
}

