/*!
 * Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"]);
})(this, function(Bokeh) {
  var define;
  return (function(modules, entry, aliases, externals) {
    if (Bokeh != null) {
      return Bokeh.register_plugin(modules, entry, aliases, externals);
    } else {
      throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
    }
  })
({
370: function _(e,s,t){const i=e(371);t.Widgets=i,e(6).register_models(i)},
371: function _(r,t,a){var e=r(372);a.AbstractButton=e.AbstractButton;var o=r(375);a.AbstractIcon=o.AbstractIcon;var u=r(376);a.AutocompleteInput=u.AutocompleteInput;var n=r(380);a.Button=n.Button;var v=r(381);a.CheckboxButtonGroup=v.CheckboxButtonGroup;var p=r(383);a.CheckboxGroup=p.CheckboxGroup;var i=r(385);a.ColorPicker=i.ColorPicker;var l=r(386);a.DatePicker=l.DatePicker;var c=r(389);a.DateRangeSlider=c.DateRangeSlider;var d=r(394);a.DateSlider=d.DateSlider;var g=r(395);a.Div=g.Div;var I=r(398);a.Dropdown=I.Dropdown;var S=r(399);a.FileInput=S.FileInput;var k=r(378);a.InputWidget=k.InputWidget;var x=r(396);a.Markup=x.Markup;var D=r(400);a.MultiSelect=D.MultiSelect;var P=r(401);a.Paragraph=P.Paragraph;var b=r(402);a.PasswordInput=b.PasswordInput;var s=r(403);a.PreText=s.PreText;var A=r(404);a.RadioButtonGroup=A.RadioButtonGroup;var B=r(405);a.RadioGroup=B.RadioGroup;var G=r(406);a.RangeSlider=G.RangeSlider;var R=r(407);a.Select=R.Select;var T=r(408);a.Slider=T.Slider;var h=r(409);a.Spinner=h.Spinner;var C=r(377);a.TextInput=C.TextInput;var w=r(410);a.TextAreaInput=w.TextAreaInput;var M=r(411);a.Toggle=M.Toggle;var W=r(432);a.Widget=W.Widget},
372: function _(t,e,n){const i=t(18),s=t(61),o=t(92),l=t(373),c=t(245);class r extends l.ControlView{initialize(){super.initialize(),this.icon_views={}}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}remove(){o.remove_views(this.icon_views),super.remove()}_render_button(...t){return s.button({type:"button",disabled:this.model.disabled,class:[c.bk_btn,c.bk_btn_type(this.model.button_type)]},...t)}render(){super.render(),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",()=>this.click());const t=this.model.icon;if(null!=t){o.build_views(this.icon_views,[t],{parent:this});const e=this.icon_views[t.id];e.render(),s.prepend(this.button_el,e.el,s.nbsp())}this.group_el=s.div({class:c.bk_btn_group},this.button_el),this.el.appendChild(this.group_el)}click(){null!=this.model.callback&&this.model.callback.execute(this.model)}}n.AbstractButtonView=r,r.__name__="AbstractButtonView";class _ extends l.Control{constructor(t){super(t)}static init_AbstractButton(){this.define({label:[i.String,"Button"],icon:[i.Instance],button_type:[i.ButtonType,"default"],callback:[i.Any]})}}n.AbstractButton=_,_.__name__="AbstractButton",_.init_AbstractButton()},
373: function _(e,n,s){const t=e(432);class o extends t.WidgetView{connect_signals(){super.connect_signals();const e=this.model.properties;this.on_change(e.disabled,()=>this.render())}}s.ControlView=o,o.__name__="ControlView";class i extends t.Widget{constructor(e){super(e)}}s.Control=i,i.__name__="Control"},
432: function _(i,t,e){const o=i(240),n=i(18);class s extends o.HTMLBoxView{_width_policy(){return"horizontal"==this.model.orientation?super._width_policy():"fixed"}_height_policy(){return"horizontal"==this.model.orientation?"fixed":super._height_policy()}box_sizing(){const i=super.box_sizing();return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i}}e.WidgetView=s,s.__name__="WidgetView";class r extends o.HTMLBox{constructor(i){super(i)}static init_Widget(){this.define({orientation:[n.Orientation,"horizontal"],default_size:[n.Number,300]}),this.override({margin:[5,5,5,5]})}}e.Widget=r,r.__name__="Widget",r.init_Widget()},
375: function _(c,t,s){const n=c(64),e=c(59);class o extends e.DOMView{}s.AbstractIconView=o,o.__name__="AbstractIconView";class _ extends n.Model{constructor(c){super(c)}}s.AbstractIcon=_,_.__name__="AbstractIcon"},
376: function _(e,t,n){const i=e(377),s=e(61),h=e(18),_=e(9),o=e(138),u=e(246);class c extends i.TextInputView{constructor(){super(...arguments),this._open=!1,this._last_value="",this._hover_index=0}render(){super.render(),this.input_el.addEventListener("keydown",e=>this._keydown(e)),this.input_el.addEventListener("keyup",e=>this._keyup(e)),this.menu=s.div({class:[u.bk_menu,o.bk_below]}),this.menu.addEventListener("click",e=>this._menu_click(e)),this.menu.addEventListener("mouseover",e=>this._menu_hover(e)),this.el.appendChild(this.menu),s.undisplay(this.menu)}change_input(){this._open&&this.menu.children.length>0&&(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu())}_update_completions(e){s.empty(this.menu);for(const t of e){const e=s.div({},t);this.menu.appendChild(e)}e.length>0&&this.menu.children[0].classList.add(o.bk_active)}_show_menu(){if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,s.display(this.menu);const e=t=>{const{target:n}=t;n instanceof HTMLElement&&!this.el.contains(n)&&(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,s.undisplay(this.menu))}_menu_click(e){e.target!=e.currentTarget&&e.target instanceof Element&&(this.model.value=e.target.textContent,this.input_el.focus(),this._hide_menu())}_menu_hover(e){if(e.target!=e.currentTarget&&e.target instanceof Element){let t=0;for(t=0;t<this.menu.children.length&&this.menu.children[t].textContent!=e.target.textContent;t++);this._bump_hover(t)}}_bump_hover(e){const t=this.menu.children.length;this._open&&t>0&&(this.menu.children[this._hover_index].classList.remove(o.bk_active),this._hover_index=_.clamp(e,0,t-1),this.menu.children[this._hover_index].classList.add(o.bk_active))}_keydown(e){}_keyup(e){switch(e.keyCode){case s.Keys.Enter:this.change_input();break;case s.Keys.Esc:this._hide_menu();break;case s.Keys.Up:this._bump_hover(this._hover_index-1);break;case s.Keys.Down:this._bump_hover(this._hover_index+1);break;default:{const e=this.input_el.value;if(e.length<this.model.min_characters)return void this._hide_menu();const t=[];for(const n of this.model.completions)n.startsWith(e)&&t.push(n);this._update_completions(t),0==t.length?this._hide_menu():this._show_menu()}}}}n.AutocompleteInputView=c,c.__name__="AutocompleteInputView";class r extends i.TextInput{constructor(e){super(e)}static init_AutocompleteInput(){this.prototype.default_view=c,this.define({completions:[h.Array,[]],min_characters:[h.Int,2]})}}n.AutocompleteInput=r,r.__name__="AutocompleteInput",r.init_AutocompleteInput()},
377: function _(e,t,i){const n=e(378),s=e(61),l=e(18),p=e(379);class u extends n.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.value.change,()=>this.input_el.value=this.model.value),this.connect(this.model.properties.value_input.change,()=>this.input_el.value=this.model.value_input),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder)}render(){super.render(),this.input_el=s.input({type:"text",class:p.bk_input,name:this.model.name,value:this.model.value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.input_el.addEventListener("change",()=>this.change_input()),this.input_el.addEventListener("input",()=>this.change_input_oninput()),this.group_el.appendChild(this.input_el)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_oninput(){this.model.value_input=this.input_el.value,super.change_input()}}i.TextInputView=u,u.__name__="TextInputView";class h extends n.InputWidget{constructor(e){super(e)}static init_TextInput(){this.prototype.default_view=u,this.define({value:[l.String,""],value_input:[l.String,""],placeholder:[l.String,""]})}}i.TextInput=h,h.__name__="TextInput",h.init_TextInput()},
378: function _(t,e,i){const l=t(373),n=t(61),s=t(18),c=t(379);class o extends l.ControlView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.title.change,()=>{this.label_el.textContent=this.model.title})}render(){super.render();const{title:t}=this.model;this.label_el=n.label({style:{display:0==t.length?"none":""}},t),this.group_el=n.div({class:c.bk_input_group},this.label_el),this.el.appendChild(this.group_el)}change_input(){null!=this.model.callback&&this.model.callback.execute(this.model)}}i.InputWidgetView=o,o.__name__="InputWidgetView";class a extends l.Control{constructor(t){super(t)}static init_InputWidget(){this.define({title:[s.String,""],callback:[s.Any]})}}i.InputWidget=a,a.__name__="InputWidget",a.init_InputWidget()},
379: function _(n,o,t){n(62),n(61).styles.append('.bk-root .bk-input {\n  display: inline-block;\n  width: 100%;\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  min-height: 31px;\n  padding: 0 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n.bk-root .bk-input:focus {\n  border-color: #66afe9;\n  outline: 0;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.bk-root .bk-input::placeholder,\n.bk-root .bk-input:-ms-input-placeholder,\n.bk-root .bk-input::-moz-placeholder,\n.bk-root .bk-input::-webkit-input-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.bk-root .bk-input[disabled],\n.bk-root .bk-input[readonly] {\n  cursor: not-allowed;\n  background-color: #eee;\n  opacity: 1;\n}\n.bk-root select[multiple].bk-input,\n.bk-root select[size].bk-input,\n.bk-root textarea.bk-input {\n  height: auto;\n}\n.bk-root .bk-input-group {\n  width: 100%;\n  height: 100%;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: start;\n  -webkit-align-items: start;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  white-space: nowrap;\n}\n.bk-root .bk-input-group.bk-inline {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-input-group.bk-inline > *:not(:first-child) {\n  margin-left: 5px;\n}\n.bk-root .bk-input-group input[type="checkbox"] + span,\n.bk-root .bk-input-group input[type="radio"] + span {\n  position: relative;\n  top: -2px;\n  margin-left: 3px;\n}\n'),t.bk_input="bk-input",t.bk_input_group="bk-input-group"},
380: function _(t,e,i){const n=t(372),s=t(274),c=t(18);class o extends n.AbstractButtonView{click(){this.model.clicks=this.model.clicks+1,this.model.trigger_event(new s.ButtonClick),super.click()}}i.ButtonView=o,o.__name__="ButtonView";class u extends n.AbstractButton{constructor(t){super(t)}static init_Button(){this.prototype.default_view=o,this.define({clicks:[c.Number,0]}),this.override({label:"Button"})}}i.Button=u,u.__name__="Button",u.init_Button()},
381: function _(t,e,o){const c=t(382),i=t(61),s=t(14),a=t(18),n=t(138);class u extends c.ButtonGroupView{get active(){return new s.Set(this.model.active)}change_active(t){const{active:e}=this;e.toggle(t),this.model.active=e.values,null!=this.model.callback&&this.model.callback.execute(this.model)}_update_active(){const{active:t}=this;this._buttons.forEach((e,o)=>{i.classes(e).toggle(n.bk_active,t.has(o))})}}o.CheckboxButtonGroupView=u,u.__name__="CheckboxButtonGroupView";class h extends c.ButtonGroup{constructor(t){super(t)}static init_CheckboxButtonGroup(){this.prototype.default_view=u,this.define({active:[a.Array,[]]})}}o.CheckboxButtonGroup=h,h.__name__="CheckboxButtonGroup",h.init_CheckboxButtonGroup()},
382: function _(t,e,n){const s=t(373),i=t(61),o=t(18),a=t(245);class _ extends s.ControlView{connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.button_type,()=>this.render()),this.on_change(t.labels,()=>this.render()),this.on_change(t.active,()=>this._update_active())}render(){super.render(),this._buttons=this.model.labels.map((t,e)=>{const n=i.div({class:[a.bk_btn,a.bk_btn_type(this.model.button_type)],disabled:this.model.disabled},t);return n.addEventListener("click",()=>this.change_active(e)),n}),this._update_active();const t=i.div({class:a.bk_btn_group},this._buttons);this.el.appendChild(t)}}n.ButtonGroupView=_,_.__name__="ButtonGroupView";class r extends s.Control{constructor(t){super(t)}static init_ButtonGroup(){this.define({labels:[o.Array,[]],button_type:[o.ButtonType,"default"],callback:[o.Any]})}}n.ButtonGroup=r,r.__name__="ButtonGroup",r.init_ButtonGroup()},
383: function _(e,t,i){const l=e(384),n=e(61),c=e(8),o=e(14),s=e(18),a=e(138),d=e(379);class h extends l.InputGroupView{render(){super.render();const e=n.div({class:[d.bk_input_group,this.model.inline?a.bk_inline:null]});this.el.appendChild(e);const{active:t,labels:i}=this.model;for(let l=0;l<i.length;l++){const o=n.input({type:"checkbox",value:`${l}`});o.addEventListener("change",()=>this.change_active(l)),this.model.disabled&&(o.disabled=!0),c.includes(t,l)&&(o.checked=!0);const s=n.label({},o,n.span({},i[l]));e.appendChild(s)}}change_active(e){const t=new o.Set(this.model.active);t.toggle(e),this.model.active=t.values,null!=this.model.callback&&this.model.callback.execute(this.model)}}i.CheckboxGroupView=h,h.__name__="CheckboxGroupView";class r extends l.InputGroup{constructor(e){super(e)}static init_CheckboxGroup(){this.prototype.default_view=h,this.define({active:[s.Array,[]],labels:[s.Array,[]],inline:[s.Boolean,!1],callback:[s.Any]})}}i.CheckboxGroup=r,r.__name__="CheckboxGroup",r.init_CheckboxGroup()},
384: function _(n,e,t){const s=n(373);class o extends s.ControlView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}}t.InputGroupView=o,o.__name__="InputGroupView";class c extends s.Control{constructor(n){super(n)}}t.InputGroup=c,c.__name__="InputGroup"},
385: function _(e,i,t){const n=e(378),s=e(61),o=e(18),l=e(379);class r extends n.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.color.change,()=>this.input_el.value=this.model.color),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled)}render(){super.render(),this.input_el=s.input({type:"color",class:l.bk_input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el)}change_input(){this.model.color=this.input_el.value,super.change_input()}}t.ColorPickerView=r,r.__name__="ColorPickerView";class c extends n.InputWidget{constructor(e){super(e)}static init_ColorPicker(){this.prototype.default_view=r,this.define({color:[o.Color,"#000000"]})}}t.ColorPicker=c,c.__name__="ColorPicker",c.init_ColorPicker()},
386: function _(e,t,i){const n=e(378),s=e(61),o=e(18),l=e(387),a=e(379);e(388),l.prototype.adjustPosition=function(){if(this._o.container)return;this.el.style.position="absolute";const e=this._o.trigger,t=this.el.offsetWidth,i=this.el.offsetHeight,n=window.innerWidth||document.documentElement.clientWidth,s=window.innerHeight||document.documentElement.clientHeight,o=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,l=e.getBoundingClientRect();let a=l.left+window.pageXOffset,d=l.bottom+window.pageYOffset;a-=this.el.parentElement.offsetLeft,d-=this.el.parentElement.offsetTop,(this._o.reposition&&a+t>n||this._o.position.indexOf("right")>-1&&a-t+e.offsetWidth>0)&&(a=a-t+e.offsetWidth),(this._o.reposition&&d+i>s+o||this._o.position.indexOf("top")>-1&&d-i-e.offsetHeight>0)&&(d=d-i-e.offsetHeight),this.el.style.left=a+"px",this.el.style.top=d+"px"};class d extends n.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}render(){null!=this._picker&&this._picker.destroy(),super.render(),this.input_el=s.input({type:"text",class:a.bk_input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=new l({field:this.input_el,defaultDate:this._unlocal_date(new Date(this.model.value)),setDefaultDate:!0,minDate:null!=this.model.min_date?this._unlocal_date(new Date(this.model.min_date)):void 0,maxDate:null!=this.model.max_date?this._unlocal_date(new Date(this.model.max_date)):void 0,onSelect:e=>this._on_select(e)}),this._root_element.appendChild(this._picker.el)}_unlocal_date(e){const t=6e4*e.getTimezoneOffset();e.setTime(e.getTime()-t);const i=e.toISOString().substr(0,10).split("-");return new Date(Number(i[0]),Number(i[1])-1,Number(i[2]))}_on_select(e){this.model.value=e.toDateString(),this.change_input()}}i.DatePickerView=d,d.__name__="DatePickerView";class h extends n.InputWidget{constructor(e){super(e)}static init_DatePicker(){this.prototype.default_view=d,this.define({value:[o.Any,(new Date).toDateString()],min_date:[o.Any],max_date:[o.Any]})}}i.DatePicker=h,h.__name__="DatePicker",h.init_DatePicker()},
387: function _(e,t,n){var a=function(e,t,n,a){e.addEventListener(t,n,!!a)},i=function(e,t,n,a){e.removeEventListener(t,n,!!a)},s=function(e,t){return-1!==(" "+e.className+" ").indexOf(" "+t+" ")},o=function(e,t){s(e,t)||(e.className=""===e.className?t:e.className+" "+t)},r=function(e,t){var n;e.className=(n=(" "+e.className+" ").replace(" "+t+" "," ")).trim?n.trim():n.replace(/^\s+|\s+$/g,"")},l=function(e){return/Array/.test(Object.prototype.toString.call(e))},h=function(e){return/Date/.test(Object.prototype.toString.call(e))&&!isNaN(e.getTime())},d=function(e){var t=e.getDay();return 0===t||6===t},u=function(e){
// solution lifted from date.js (MIT license): https://github.com/datejs/Datejs
return e%4==0&&e%100!=0||e%400==0},c=function(e,t){return[31,u(e)?29:28,31,30,31,30,31,31,30,31,30,31][t]},f=function(e){h(e)&&e.setHours(0,0,0,0)},g=function(e,t){return e.getTime()===t.getTime()},m=function(e,t,n){var a,i;for(a in t)(i=void 0!==e[a])&&"object"==typeof t[a]&&null!==t[a]&&void 0===t[a].nodeName?h(t[a])?n&&(e[a]=new Date(t[a].getTime())):l(t[a])?n&&(e[a]=t[a].slice(0)):e[a]=m({},t[a],n):!n&&i||(e[a]=t[a]);return e},p=function(e,t,n){var a;document.createEvent?((a=document.createEvent("HTMLEvents")).initEvent(t,!0,!1),a=m(a,n),e.dispatchEvent(a)):document.createEventObject&&(a=document.createEventObject(),a=m(a,n),e.fireEvent("on"+t,a))},y=function(e){return e.month<0&&(e.year-=Math.ceil(Math.abs(e.month)/12),e.month+=12),e.month>11&&(e.year+=Math.floor(Math.abs(e.month)/12),e.month-=12),e},D={field:null,bound:void 0,ariaLabel:"Use the arrow keys to pick a date",position:"bottom left",reposition:!0,format:"YYYY-MM-DD",toString:null,parse:null,defaultDate:null,setDefaultDate:!1,firstDay:0,formatStrict:!1,minDate:null,maxDate:null,yearRange:10,showWeekNumber:!1,pickWholeWeek:!1,minYear:0,maxYear:9999,minMonth:void 0,maxMonth:void 0,startRange:null,endRange:null,isRTL:!1,yearSuffix:"",showMonthAfterYear:!1,showDaysInNextAndPreviousMonths:!1,enableSelectionDaysInNextAndPreviousMonths:!1,numberOfMonths:1,mainCalendar:"left",container:void 0,blurFieldOnSelect:!0,i18n:{previousMonth:"Previous Month",nextMonth:"Next Month",months:["January","February","March","April","May","June","July","August","September","October","November","December"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdaysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]},theme:null,events:[],onSelect:null,onOpen:null,onClose:null,onDraw:null,keyboardInput:!0},b=function(e,t,n){for(t+=e.firstDay;t>=7;)t-=7;return n?e.i18n.weekdaysShort[t]:e.i18n.weekdays[t]},_=function(e){var t=[],n="false";if(e.isEmpty){if(!e.showDaysInNextAndPreviousMonths)return'<td class="is-empty"></td>';t.push("is-outside-current-month"),e.enableSelectionDaysInNextAndPreviousMonths||t.push("is-selection-disabled")}return e.isDisabled&&t.push("is-disabled"),e.isToday&&t.push("is-today"),e.isSelected&&(t.push("is-selected"),n="true"),e.hasEvent&&t.push("has-event"),e.isInRange&&t.push("is-inrange"),e.isStartRange&&t.push("is-startrange"),e.isEndRange&&t.push("is-endrange"),'<td data-day="'+e.day+'" class="'+t.join(" ")+'" aria-selected="'+n+'"><button class="pika-button pika-day" type="button" data-pika-year="'+e.year+'" data-pika-month="'+e.month+'" data-pika-day="'+e.day+'">'+e.day+"</button></td>"},v=function(e,t,n){return'<td class="pika-week">'+function(e){e.setHours(0,0,0,0);var t=e.getDate(),n=e.getDay(),a=function(e){return(e+7-1)%7};e.setDate(t+3-a(n));var i=new Date(e.getFullYear(),0,4),s=(e.getTime()-i.getTime())/864e5;return 1+Math.round((s-3+a(i.getDay()))/7)}(new Date(n,t,e))+"</td>"},w=function(e,t,n,a){return'<tr class="pika-row'+(n?" pick-whole-week":"")+(a?" is-selected":"")+'">'+(t?e.reverse():e).join("")+"</tr>"},k=function(e,t,n,a,i,s){var o,r,h,d,u,c=e._o,f=n===c.minYear,g=n===c.maxYear,m='<div id="'+s+'" class="pika-title" role="heading" aria-live="assertive">',p=!0,y=!0;for(h=[],o=0;o<12;o++)h.push('<option value="'+(n===i?o-t:12+o-t)+'"'+(o===a?' selected="selected"':"")+(f&&o<c.minMonth||g&&o>c.maxMonth?' disabled="disabled"':"")+">"+c.i18n.months[o]+"</option>");for(d='<div class="pika-label">'+c.i18n.months[a]+'<select class="pika-select pika-select-month" tabindex="-1">'+h.join("")+"</select></div>",l(c.yearRange)?(o=c.yearRange[0],r=c.yearRange[1]+1):(o=n-c.yearRange,r=1+n+c.yearRange),h=[];o<r&&o<=c.maxYear;o++)o>=c.minYear&&h.push('<option value="'+o+'"'+(o===n?' selected="selected"':"")+">"+o+"</option>");return u='<div class="pika-label">'+n+c.yearSuffix+'<select class="pika-select pika-select-year" tabindex="-1">'+h.join("")+"</select></div>",c.showMonthAfterYear?m+=u+d:m+=d+u,f&&(0===a||c.minMonth>=a)&&(p=!1),g&&(11===a||c.maxMonth<=a)&&(y=!1),0===t&&(m+='<button class="pika-prev'+(p?"":" is-disabled")+'" type="button">'+c.i18n.previousMonth+"</button>"),t===e._o.numberOfMonths-1&&(m+='<button class="pika-next'+(y?"":" is-disabled")+'" type="button">'+c.i18n.nextMonth+"</button>"),m+"</div>"},M=function(e,t,n){return'<table cellpadding="0" cellspacing="0" class="pika-table" role="grid" aria-labelledby="'+n+'">'+function(e){var t,n=[];for(e.showWeekNumber&&n.push("<th></th>"),t=0;t<7;t++)n.push('<th scope="col"><abbr title="'+b(e,t)+'">'+b(e,t,!0)+"</abbr></th>");return"<thead><tr>"+(e.isRTL?n.reverse():n).join("")+"</tr></thead>"}(e)+("<tbody>"+t.join("")+"</tbody>")+"</table>"},x=function(e){var t=this,n=t.config(e);t._onMouseDown=function(e){if(t._v){var a=(e=e||window.event).target||e.srcElement;if(a)if(s(a,"is-disabled")||(!s(a,"pika-button")||s(a,"is-empty")||s(a.parentNode,"is-disabled")?s(a,"pika-prev")?t.prevMonth():s(a,"pika-next")&&t.nextMonth():(t.setDate(new Date(a.getAttribute("data-pika-year"),a.getAttribute("data-pika-month"),a.getAttribute("data-pika-day"))),n.bound&&setTimeout(function(){t.hide(),n.blurFieldOnSelect&&n.field&&n.field.blur()},100))),s(a,"pika-select"))t._c=!0;else{if(!e.preventDefault)return e.returnValue=!1,!1;e.preventDefault()}}},t._onChange=function(e){var n=(e=e||window.event).target||e.srcElement;n&&(s(n,"pika-select-month")?t.gotoMonth(n.value):s(n,"pika-select-year")&&t.gotoYear(n.value))},t._onKeyChange=function(e){if(e=e||window.event,t.isVisible())switch(e.keyCode){case 13:case 27:n.field&&n.field.blur();break;case 37:t.adjustDate("subtract",1);break;case 38:t.adjustDate("subtract",7);break;case 39:t.adjustDate("add",1);break;case 40:t.adjustDate("add",7);break;case 8:case 46:t.setDate(null)}},t._parseFieldValue=function(){return n.parse?n.parse(n.field.value,n.format):new Date(Date.parse(n.field.value))},t._onInputChange=function(e){var n;e.firedBy!==t&&(n=t._parseFieldValue(),h(n)&&t.setDate(n),t._v||t.show())},t._onInputFocus=function(){t.show()},t._onInputClick=function(){t.show()},t._onInputBlur=function(){var e=document.activeElement;do{if(s(e,"pika-single"))return}while(e=e.parentNode);t._c||(t._b=setTimeout(function(){t.hide()},50)),t._c=!1},t._onClick=function(e){var a=(e=e||window.event).target||e.srcElement,i=a;if(a){do{if(s(i,"pika-single")||i===n.trigger)return}while(i=i.parentNode);t._v&&a!==n.trigger&&i!==n.trigger&&t.hide()}},t.el=document.createElement("div"),t.el.className="pika-single"+(n.isRTL?" is-rtl":"")+(n.theme?" "+n.theme:""),a(t.el,"mousedown",t._onMouseDown,!0),a(t.el,"touchend",t._onMouseDown,!0),a(t.el,"change",t._onChange),n.keyboardInput&&a(document,"keydown",t._onKeyChange),n.field&&(n.container?n.container.appendChild(t.el):n.bound?document.body.appendChild(t.el):n.field.parentNode.insertBefore(t.el,n.field.nextSibling),a(n.field,"change",t._onInputChange),n.defaultDate||(n.defaultDate=t._parseFieldValue(),n.setDefaultDate=!0));var i=n.defaultDate;h(i)?n.setDefaultDate?t.setDate(i,!0):t.gotoDate(i):t.gotoDate(new Date),n.bound?(this.hide(),t.el.className+=" is-bound",a(n.trigger,"click",t._onInputClick),a(n.trigger,"focus",t._onInputFocus),a(n.trigger,"blur",t._onInputBlur)):this.show()};x.prototype={config:function(e){this._o||(this._o=m({},D,!0));var t=m(this._o,e,!0);t.isRTL=!!t.isRTL,t.field=t.field&&t.field.nodeName?t.field:null,t.theme="string"==typeof t.theme&&t.theme?t.theme:null,t.bound=!!(void 0!==t.bound?t.field&&t.bound:t.field),t.trigger=t.trigger&&t.trigger.nodeName?t.trigger:t.field,t.disableWeekends=!!t.disableWeekends,t.disableDayFn="function"==typeof t.disableDayFn?t.disableDayFn:null;var n=parseInt(t.numberOfMonths,10)||1;if(t.numberOfMonths=n>4?4:n,h(t.minDate)||(t.minDate=!1),h(t.maxDate)||(t.maxDate=!1),t.minDate&&t.maxDate&&t.maxDate<t.minDate&&(t.maxDate=t.minDate=!1),t.minDate&&this.setMinDate(t.minDate),t.maxDate&&this.setMaxDate(t.maxDate),l(t.yearRange)){var a=(new Date).getFullYear()-10;t.yearRange[0]=parseInt(t.yearRange[0],10)||a,t.yearRange[1]=parseInt(t.yearRange[1],10)||a}else t.yearRange=Math.abs(parseInt(t.yearRange,10))||D.yearRange,t.yearRange>100&&(t.yearRange=100);return t},toString:function(e){return e=e||this._o.format,h(this._d)?this._o.toString?this._o.toString(this._d,e):this._d.toDateString():""},getDate:function(){return h(this._d)?new Date(this._d.getTime()):null},setDate:function(e,t){if(!e)return this._d=null,this._o.field&&(this._o.field.value="",p(this._o.field,"change",{firedBy:this})),this.draw();if("string"==typeof e&&(e=new Date(Date.parse(e))),h(e)){var n=this._o.minDate,a=this._o.maxDate;h(n)&&e<n?e=n:h(a)&&e>a&&(e=a),this._d=new Date(e.getTime()),f(this._d),this.gotoDate(this._d),this._o.field&&(this._o.field.value=this.toString(),p(this._o.field,"change",{firedBy:this})),t||"function"!=typeof this._o.onSelect||this._o.onSelect.call(this,this.getDate())}},clear:function(){this.setDate(null)},gotoDate:function(e){var t=!0;if(h(e)){if(this.calendars){var n=new Date(this.calendars[0].year,this.calendars[0].month,1),a=new Date(this.calendars[this.calendars.length-1].year,this.calendars[this.calendars.length-1].month,1),i=e.getTime();a.setMonth(a.getMonth()+1),a.setDate(a.getDate()-1),t=i<n.getTime()||a.getTime()<i}t&&(this.calendars=[{month:e.getMonth(),year:e.getFullYear()}],"right"===this._o.mainCalendar&&(this.calendars[0].month+=1-this._o.numberOfMonths)),this.adjustCalendars()}},adjustDate:function(e,t){var n,a=this.getDate()||new Date,i=24*parseInt(t)*60*60*1e3;"add"===e?n=new Date(a.valueOf()+i):"subtract"===e&&(n=new Date(a.valueOf()-i)),this.setDate(n)},adjustCalendars:function(){this.calendars[0]=y(this.calendars[0]);for(var e=1;e<this._o.numberOfMonths;e++)this.calendars[e]=y({month:this.calendars[0].month+e,year:this.calendars[0].year});this.draw()},gotoToday:function(){this.gotoDate(new Date)},gotoMonth:function(e){isNaN(e)||(this.calendars[0].month=parseInt(e,10),this.adjustCalendars())},nextMonth:function(){this.calendars[0].month++,this.adjustCalendars()},prevMonth:function(){this.calendars[0].month--,this.adjustCalendars()},gotoYear:function(e){isNaN(e)||(this.calendars[0].year=parseInt(e,10),this.adjustCalendars())},setMinDate:function(e){e instanceof Date?(f(e),this._o.minDate=e,this._o.minYear=e.getFullYear(),this._o.minMonth=e.getMonth()):(this._o.minDate=D.minDate,this._o.minYear=D.minYear,this._o.minMonth=D.minMonth,this._o.startRange=D.startRange),this.draw()},setMaxDate:function(e){e instanceof Date?(f(e),this._o.maxDate=e,this._o.maxYear=e.getFullYear(),this._o.maxMonth=e.getMonth()):(this._o.maxDate=D.maxDate,this._o.maxYear=D.maxYear,this._o.maxMonth=D.maxMonth,this._o.endRange=D.endRange),this.draw()},setStartRange:function(e){this._o.startRange=e},setEndRange:function(e){this._o.endRange=e},draw:function(e){if(this._v||e){var t,n=this._o,a=n.minYear,i=n.maxYear,s=n.minMonth,o=n.maxMonth,r="";this._y<=a&&(this._y=a,!isNaN(s)&&this._m<s&&(this._m=s)),this._y>=i&&(this._y=i,!isNaN(o)&&this._m>o&&(this._m=o));for(var l=0;l<n.numberOfMonths;l++)t="pika-title-"+Math.random().toString(36).replace(/[^a-z]+/g,"").substr(0,2),r+='<div class="pika-lendar">'+k(this,l,this.calendars[l].year,this.calendars[l].month,this.calendars[0].year,t)+this.render(this.calendars[l].year,this.calendars[l].month,t)+"</div>";this.el.innerHTML=r,n.bound&&"hidden"!==n.field.type&&setTimeout(function(){n.trigger.focus()},1),"function"==typeof this._o.onDraw&&this._o.onDraw(this),n.bound&&n.field.setAttribute("aria-label",n.ariaLabel)}},adjustPosition:function(){var e,t,n,a,i,s,l,h,d,u,c,f;if(!this._o.container){if(this.el.style.position="absolute",t=e=this._o.trigger,n=this.el.offsetWidth,a=this.el.offsetHeight,i=window.innerWidth||document.documentElement.clientWidth,s=window.innerHeight||document.documentElement.clientHeight,l=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,c=!0,f=!0,"function"==typeof e.getBoundingClientRect)h=(u=e.getBoundingClientRect()).left+window.pageXOffset,d=u.bottom+window.pageYOffset;else for(h=t.offsetLeft,d=t.offsetTop+t.offsetHeight;t=t.offsetParent;)h+=t.offsetLeft,d+=t.offsetTop;(this._o.reposition&&h+n>i||this._o.position.indexOf("right")>-1&&h-n+e.offsetWidth>0)&&(h=h-n+e.offsetWidth,c=!1),(this._o.reposition&&d+a>s+l||this._o.position.indexOf("top")>-1&&d-a-e.offsetHeight>0)&&(d=d-a-e.offsetHeight,f=!1),this.el.style.left=h+"px",this.el.style.top=d+"px",o(this.el,c?"left-aligned":"right-aligned"),o(this.el,f?"bottom-aligned":"top-aligned"),r(this.el,c?"right-aligned":"left-aligned"),r(this.el,f?"top-aligned":"bottom-aligned")}},render:function(e,t,n){var a=this._o,i=new Date,s=c(e,t),o=new Date(e,t,1).getDay(),r=[],l=[];f(i),a.firstDay>0&&(o-=a.firstDay)<0&&(o+=7);for(var u=0===t?11:t-1,m=11===t?0:t+1,p=0===t?e-1:e,y=11===t?e+1:e,D=c(p,u),b=s+o,k=b;k>7;)k-=7;b+=7-k;for(var x=!1,R=0,N=0;R<b;R++){var S=new Date(e,t,R-o+1),T=!!h(this._d)&&g(S,this._d),C=g(S,i),I=-1!==a.events.indexOf(S.toDateString()),Y=R<o||R>=s+o,O=R-o+1,E=t,j=e,F=a.startRange&&g(a.startRange,S),W=a.endRange&&g(a.endRange,S),A=a.startRange&&a.endRange&&a.startRange<S&&S<a.endRange;Y&&(R<o?(O=D+O,E=u,j=p):(O-=s,E=m,j=y));var L={day:O,month:E,year:j,hasEvent:I,isSelected:T,isToday:C,isDisabled:a.minDate&&S<a.minDate||a.maxDate&&S>a.maxDate||a.disableWeekends&&d(S)||a.disableDayFn&&a.disableDayFn(S),isEmpty:Y,isStartRange:F,isEndRange:W,isInRange:A,showDaysInNextAndPreviousMonths:a.showDaysInNextAndPreviousMonths,enableSelectionDaysInNextAndPreviousMonths:a.enableSelectionDaysInNextAndPreviousMonths};a.pickWholeWeek&&T&&(x=!0),l.push(_(L)),7==++N&&(a.showWeekNumber&&l.unshift(v(R-o,t,e)),r.push(w(l,a.isRTL,a.pickWholeWeek,x)),l=[],N=0,x=!1)}return M(a,r,n)},isVisible:function(){return this._v},show:function(){this.isVisible()||(this._v=!0,this.draw(),r(this.el,"is-hidden"),this._o.bound&&(a(document,"click",this._onClick),this.adjustPosition()),"function"==typeof this._o.onOpen&&this._o.onOpen.call(this))},hide:function(){var e=this._v;!1!==e&&(this._o.bound&&i(document,"click",this._onClick),this.el.style.position="static",this.el.style.left="auto",this.el.style.top="auto",o(this.el,"is-hidden"),this._v=!1,void 0!==e&&"function"==typeof this._o.onClose&&this._o.onClose.call(this))},destroy:function(){var e=this._o;this.hide(),i(this.el,"mousedown",this._onMouseDown,!0),i(this.el,"touchend",this._onMouseDown,!0),i(this.el,"change",this._onChange),e.keyboardInput&&i(document,"keydown",this._onKeyChange),e.field&&(i(e.field,"change",this._onInputChange),e.bound&&(i(e.trigger,"click",this._onInputClick),i(e.trigger,"focus",this._onInputFocus),i(e.trigger,"blur",this._onInputBlur))),this.el.parentNode&&this.el.parentNode.removeChild(this.el)}},t.exports=x},
388: function _(n,o,t){n(62),n(61).styles.append('.bk-root {\n  @charset "UTF-8";\n  /*!\n * Pikaday\n * Copyright © 2014 David Bushell | BSD & MIT license | https://dbushell.com/\n */\n  /*\nclear child float (pika-lendar), using the famous micro clearfix hack\nhttp://nicolasgallagher.com/micro-clearfix-hack/\n*/\n  /* styling for abbr */\n}\n.bk-root .pika-single {\n  z-index: 9999;\n  display: block;\n  position: relative;\n  color: #333;\n  background: #fff;\n  border: 1px solid #ccc;\n  border-bottom-color: #bbb;\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n}\n.bk-root .pika-single:before,\n.bk-root .pika-single:after {\n  content: " ";\n  display: table;\n}\n.bk-root .pika-single:after {\n  clear: both;\n}\n.bk-root .pika-single.is-hidden {\n  display: none;\n}\n.bk-root .pika-single.is-bound {\n  position: absolute;\n  box-shadow: 0 5px 15px -5px rgba(0, 0, 0, 0.5);\n}\n.bk-root .pika-lendar {\n  float: left;\n  width: 240px;\n  margin: 8px;\n}\n.bk-root .pika-title {\n  position: relative;\n  text-align: center;\n}\n.bk-root .pika-label {\n  display: inline-block;\n  position: relative;\n  z-index: 9999;\n  overflow: hidden;\n  margin: 0;\n  padding: 5px 3px;\n  font-size: 14px;\n  line-height: 20px;\n  font-weight: bold;\n  background-color: #fff;\n}\n.bk-root .pika-title select {\n  cursor: pointer;\n  position: absolute;\n  z-index: 9998;\n  margin: 0;\n  left: 0;\n  top: 5px;\n  opacity: 0;\n}\n.bk-root .pika-prev,\n.bk-root .pika-next {\n  display: block;\n  cursor: pointer;\n  position: relative;\n  outline: none;\n  border: 0;\n  padding: 0;\n  width: 20px;\n  height: 30px;\n  /* hide text using text-indent trick, using width value (it\'s enough) */\n  text-indent: 20px;\n  white-space: nowrap;\n  overflow: hidden;\n  background-color: transparent;\n  background-position: center center;\n  background-repeat: no-repeat;\n  background-size: 75% 75%;\n  opacity: 0.5;\n}\n.bk-root .pika-prev:hover,\n.bk-root .pika-next:hover {\n  opacity: 1;\n}\n.bk-root .pika-prev,\n.bk-root .is-rtl .pika-next {\n  float: left;\n  background-image: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAeCAYAAAAsEj5rAAAAUklEQVR42u3VMQoAIBADQf8Pgj+OD9hG2CtONJB2ymQkKe0HbwAP0xucDiQWARITIDEBEnMgMQ8S8+AqBIl6kKgHiXqQqAeJepBo/z38J/U0uAHlaBkBl9I4GwAAAABJRU5ErkJggg==\');\n}\n.bk-root .pika-next,\n.bk-root .is-rtl .pika-prev {\n  float: right;\n  background-image: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAeCAYAAAAsEj5rAAAAU0lEQVR42u3VOwoAMAgE0dwfAnNjU26bYkBCFGwfiL9VVWoO+BJ4Gf3gtsEKKoFBNTCoCAYVwaAiGNQGMUHMkjGbgjk2mIONuXo0nC8XnCf1JXgArVIZAQh5TKYAAAAASUVORK5CYII=\');\n}\n.bk-root .pika-prev.is-disabled,\n.bk-root .pika-next.is-disabled {\n  cursor: default;\n  opacity: 0.2;\n}\n.bk-root .pika-select {\n  display: inline-block;\n}\n.bk-root .pika-table {\n  width: 100%;\n  border-collapse: collapse;\n  border-spacing: 0;\n  border: 0;\n}\n.bk-root .pika-table th,\n.bk-root .pika-table td {\n  width: 14.28571429%;\n  padding: 0;\n}\n.bk-root .pika-table th {\n  color: #999;\n  font-size: 12px;\n  line-height: 25px;\n  font-weight: bold;\n  text-align: center;\n}\n.bk-root .pika-button {\n  cursor: pointer;\n  display: block;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  outline: none;\n  border: 0;\n  margin: 0;\n  width: 100%;\n  padding: 5px;\n  color: #666;\n  font-size: 12px;\n  line-height: 15px;\n  text-align: right;\n  background: #f5f5f5;\n}\n.bk-root .pika-week {\n  font-size: 11px;\n  color: #999;\n}\n.bk-root .is-today .pika-button {\n  color: #33aaff;\n  font-weight: bold;\n}\n.bk-root .is-selected .pika-button,\n.bk-root .has-event .pika-button {\n  color: #fff;\n  font-weight: bold;\n  background: #33aaff;\n  box-shadow: inset 0 1px 3px #178fe5;\n  border-radius: 3px;\n}\n.bk-root .has-event .pika-button {\n  background: #005da9;\n  box-shadow: inset 0 1px 3px #0076c9;\n}\n.bk-root .is-disabled .pika-button,\n.bk-root .is-inrange .pika-button {\n  background: #D5E9F7;\n}\n.bk-root .is-startrange .pika-button {\n  color: #fff;\n  background: #6CB31D;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .is-endrange .pika-button {\n  color: #fff;\n  background: #33aaff;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .is-disabled .pika-button {\n  pointer-events: none;\n  cursor: default;\n  color: #999;\n  opacity: 0.3;\n}\n.bk-root .is-outside-current-month .pika-button {\n  color: #999;\n  opacity: 0.3;\n}\n.bk-root .is-selection-disabled {\n  pointer-events: none;\n  cursor: default;\n}\n.bk-root .pika-button:hover,\n.bk-root .pika-row.pick-whole-week:hover .pika-button {\n  color: #fff;\n  background: #ff8000;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .pika-table abbr {\n  border-bottom: none;\n  cursor: help;\n}\n')},
389: function _(e,t,a){const i=e(150),r=e(390);class n extends r.AbstractRangeSliderView{}a.DateRangeSliderView=n,n.__name__="DateRangeSliderView";class s extends r.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}static init_DateRangeSlider(){this.prototype.default_view=n,this.override({format:"%d %b %Y"})}_formatter(e,t){return i(e,t)}}a.DateRangeSlider=s,s.__name__="DateRangeSlider",s.init_DateRangeSlider()},
390: function _(e,t,l){const s=e(391),i=e(18),a=e(61),r=e(8),o=e(16),n=e(373),d=e(392),c="bk-noUi-";class h extends n.ControlView{get noUiSlider(){return this.slider_el.noUiSlider}initialize(){super.initialize(),this._init_callback()}connect_signals(){super.connect_signals();const{callback:e,callback_policy:t,callback_throttle:l}=this.model.properties;this.on_change([e,t,l],()=>this._init_callback());const{start:s,end:i,value:a,step:r,title:o}=this.model.properties;this.on_change([s,i,a,r],()=>{const{start:e,end:t,value:l,step:s}=this._calc_to();this.noUiSlider.updateOptions({range:{min:e,max:t},start:l,step:s})});const{bar_color:n}=this.model.properties;this.on_change(n,()=>{this._set_bar_color()}),this.on_change([a,o],()=>this._update_title())}_init_callback(){const{callback:e}=this.model,t=()=>{null!=e&&e.execute(this.model),this.model.value_throttled=this.model.value};switch(this.model.callback_policy){case"continuous":this.callback_wrapper=t;break;case"throttle":this.callback_wrapper=o.throttle(t,this.model.callback_throttle);break;default:this.callback_wrapper=void 0}}_update_title(){a.empty(this.title_el);const e=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=e?"none":"",!e&&(0!=this.model.title.length&&(this.title_el.textContent=`${this.model.title}: `),this.model.show_value)){const{value:e}=this._calc_to(),t=e.map(e=>this.model.pretty(e)).join(" .. ");this.title_el.appendChild(a.span({class:d.bk_slider_value},t))}}_set_bar_color(){if(!this.model.disabled){this.slider_el.querySelector(`.${c}connect`).style.backgroundColor=this.model.bar_color}}_keypress_handle(e,t=0){const{start:l,value:s,end:i,step:a}=this._calc_to(),r=2==s.length;let o=l,n=i;switch(r&&0==t?n=s[1]:r&&1==t&&(o=s[0]),e.which){case 37:s[t]=Math.max(s[t]-a,o);break;case 39:s[t]=Math.min(s[t]+a,n);break;default:return}r?(this.model.value=s,this.model.properties.value.change.emit()):this.model.value=s[0],this.noUiSlider.set(s),null!=this.callback_wrapper&&this.callback_wrapper()}render(){super.render();const{start:e,end:t,value:l,step:i}=this._calc_to();let o;if(this.model.tooltips){const e={to:e=>this.model.pretty(e)};o=r.repeat(e,l.length)}else o=!1;if(null==this.slider_el){this.slider_el=a.div(),s.create(this.slider_el,{cssPrefix:c,range:{min:e,max:t},start:l,step:i,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:o,orientation:this.model.orientation,direction:this.model.direction}),this.noUiSlider.on("slide",(e,t,l)=>this._slide(l)),this.noUiSlider.on("change",(e,t,l)=>this._change(l)),this._set_keypress_handles();const r=(e,t)=>{if(!o)return;this.slider_el.querySelectorAll(`.${c}handle`)[e].querySelector(`.${c}tooltip`).style.display=t?"block":""};this.noUiSlider.on("start",(e,t)=>r(t,!0)),this.noUiSlider.on("end",(e,t)=>r(t,!1))}else this.noUiSlider.updateOptions({range:{min:e,max:t},start:l,step:i});this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=a.div({class:d.bk_slider_title}),this._update_title(),this.group_el=a.div({class:d.bk_input_group},this.title_el,this.slider_el),this.el.appendChild(this.group_el)}_slide(e){this.model.value=this._calc_from(e),null!=this.callback_wrapper&&this.callback_wrapper()}_change(e){switch(this.model.value=this._calc_from(e),this.model.value_throttled=this.model.value,this.model.callback_policy){case"mouseup":case"throttle":null!=this.model.callback&&this.model.callback.execute(this.model)}}}h.__name__="AbstractBaseSliderView";class _ extends h{_calc_to(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}}_calc_from([e]){return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(e):e}_set_keypress_handles(){const e=this.slider_el.querySelector(`.${c}handle`);e.setAttribute("tabindex","0"),e.addEventListener("keydown",e=>this._keypress_handle(e))}}l.AbstractSliderView=_,_.__name__="AbstractSliderView";class u extends h{_calc_to(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}}_calc_from(e){return e}_set_keypress_handles(){const e=this.slider_el.querySelector(`.${c}handle-lower`),t=this.slider_el.querySelector(`.${c}handle-upper`);e.setAttribute("tabindex","0"),e.addEventListener("keydown",e=>this._keypress_handle(e,0)),t.setAttribute("tabindex","1"),t.addEventListener("keydown",e=>this._keypress_handle(e,1))}}l.AbstractRangeSliderView=u,u.__name__="AbstractRangeSliderView";class p extends n.Control{constructor(e){super(e),this.connected=!1}static init_AbstractSlider(){this.define({title:[i.String,""],show_value:[i.Boolean,!0],start:[i.Any],end:[i.Any],value:[i.Any],value_throttled:[i.Any],step:[i.Number,1],format:[i.String],direction:[i.Any,"ltr"],tooltips:[i.Boolean,!0],callback:[i.Any],callback_throttle:[i.Number,200],callback_policy:[i.SliderCallbackPolicy,"throttle"],bar_color:[i.Color,"#e6e6e6"]})}_formatter(e,t){return`${e}`}pretty(e){return this._formatter(e,this.format)}}l.AbstractSlider=p,p.__name__="AbstractSlider",p.init_AbstractSlider()},
391: function _(t,e,r){
/*! nouislider - 10.1.0 - 2017-07-28 17:11:18 */var n;n=function(){"use strict";var t="10.1.0";function e(t){t.preventDefault()}function r(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function n(t,e,r){r>0&&(s(t,e),setTimeout(function(){a(t,e)},r))}function i(t){return Array.isArray(t)?t:[t]}function o(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function s(t,e){t.classList?t.classList.add(e):t.className+=" "+e}function a(t,e){t.classList?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function l(t){var e=void 0!==window.pageXOffset,r="CSS1Compat"===(t.compatMode||"");return{x:e?window.pageXOffset:r?t.documentElement.scrollLeft:t.body.scrollLeft,y:e?window.pageYOffset:r?t.documentElement.scrollTop:t.body.scrollTop}}function u(t,e){return 100/(e-t)}function c(t,e){return 100*e/(t[1]-t[0])}function p(t,e){for(var r=1;t>=e[r];)r+=1;return r}function f(t,e,r){if(r>=t.slice(-1)[0])return 100;var n,i,o,s,a=p(r,t);return n=t[a-1],i=t[a],o=e[a-1],s=e[a],o+function(t,e){return c(t,t[0]<0?e+Math.abs(t[0]):e-t[0])}([n,i],r)/u(o,s)}function d(t,e,r,n){if(100===n)return n;var i,o,s=p(n,t);return r?n-(i=t[s-1])>((o=t[s])-i)/2?o:i:e[s-1]?t[s-1]+function(t,e){return Math.round(t/e)*e}(n-t[s-1],e[s-1]):n}function h(e,n,i){var o;if("number"==typeof n&&(n=[n]),"[object Array]"!==Object.prototype.toString.call(n))throw new Error("noUiSlider ("+t+"): 'range' contains invalid value.");if(!r(o="min"===e?0:"max"===e?100:parseFloat(e))||!r(n[0]))throw new Error("noUiSlider ("+t+"): 'range' value isn't numeric.");i.xPct.push(o),i.xVal.push(n[0]),o?i.xSteps.push(!isNaN(n[1])&&n[1]):isNaN(n[1])||(i.xSteps[0]=n[1]),i.xHighestCompleteStep.push(0)}function m(t,e,r){if(!e)return!0;r.xSteps[t]=c([r.xVal[t],r.xVal[t+1]],e)/u(r.xPct[t],r.xPct[t+1]);var n=(r.xVal[t+1]-r.xVal[t])/r.xNumSteps[t],i=Math.ceil(Number(n.toFixed(3))-1),o=r.xVal[t]+r.xNumSteps[t]*i;r.xHighestCompleteStep[t]=o}function g(t,e,r){this.xPct=[],this.xVal=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var n,i=[];for(n in t)t.hasOwnProperty(n)&&i.push([t[n],n]);for(i.length&&"object"==typeof i[0][0]?i.sort(function(t,e){return t[0][0]-e[0][0]}):i.sort(function(t,e){return t[0]-e[0]}),n=0;n<i.length;n++)h(i[n][1],i[n][0],this);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)m(n,this.xNumSteps[n],this)}g.prototype.getMargin=function(e){var r=this.xNumSteps[0];if(r&&e/r%1!=0)throw new Error("noUiSlider ("+t+"): 'limit', 'margin' and 'padding' must be divisible by step.");return 2===this.xPct.length&&c(this.xVal,e)},g.prototype.toStepping=function(t){return t=f(this.xVal,this.xPct,t)},g.prototype.fromStepping=function(t){return function(t,e,r){if(r>=100)return t.slice(-1)[0];var n,i=p(r,e);return function(t,e){return e*(t[1]-t[0])/100+t[0]}([t[i-1],t[i]],(r-(n=e[i-1]))*u(n,e[i]))}(this.xVal,this.xPct,t)},g.prototype.getStep=function(t){return t=d(this.xPct,this.xSteps,this.snap,t)},g.prototype.getNearbySteps=function(t){var e=p(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e-0],step:this.xNumSteps[e-0],highestStep:this.xHighestCompleteStep[e-0]}}},g.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(o);return Math.max.apply(null,t)},g.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var v={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number};function b(e){if(function(t){return"object"==typeof t&&"function"==typeof t.to&&"function"==typeof t.from}(e))return!0;throw new Error("noUiSlider ("+t+"): 'format' requires 'to' and 'from' methods.")}function S(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'step' is not numeric.");e.singleStep=n}function w(e,r){if("object"!=typeof r||Array.isArray(r))throw new Error("noUiSlider ("+t+"): 'range' is not an object.");if(void 0===r.min||void 0===r.max)throw new Error("noUiSlider ("+t+"): Missing 'min' or 'max' in 'range'.");if(r.min===r.max)throw new Error("noUiSlider ("+t+"): 'range' 'min' and 'max' cannot be equal.");e.spectrum=new g(r,e.snap,e.singleStep)}function x(e,r){if(r=i(r),!Array.isArray(r)||!r.length)throw new Error("noUiSlider ("+t+"): 'start' option is incorrect.");e.handles=r.length,e.start=r}function y(e,r){if(e.snap=r,"boolean"!=typeof r)throw new Error("noUiSlider ("+t+"): 'snap' option must be a boolean.")}function E(e,r){if(e.animate=r,"boolean"!=typeof r)throw new Error("noUiSlider ("+t+"): 'animate' option must be a boolean.")}function C(e,r){if(e.animationDuration=r,"number"!=typeof r)throw new Error("noUiSlider ("+t+"): 'animationDuration' option must be a number.")}function N(e,r){var n,i=[!1];if("lower"===r?r=[!0,!1]:"upper"===r&&(r=[!1,!0]),!0===r||!1===r){for(n=1;n<e.handles;n++)i.push(r);i.push(!1)}else{if(!Array.isArray(r)||!r.length||r.length!==e.handles+1)throw new Error("noUiSlider ("+t+"): 'connect' option doesn't match handle count.");i=r}e.connect=i}function U(e,r){switch(r){case"horizontal":e.ort=0;break;case"vertical":e.ort=1;break;default:throw new Error("noUiSlider ("+t+"): 'orientation' option is invalid.")}}function P(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'margin' option must be numeric.");if(0!==n&&(e.margin=e.spectrum.getMargin(n),!e.margin))throw new Error("noUiSlider ("+t+"): 'margin' option is only supported on linear sliders.")}function A(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'limit' option must be numeric.");if(e.limit=e.spectrum.getMargin(n),!e.limit||e.handles<2)throw new Error("noUiSlider ("+t+"): 'limit' option is only supported on linear sliders with 2 or more handles.")}function M(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'padding' option must be numeric.");if(0!==n){if(e.padding=e.spectrum.getMargin(n),!e.padding)throw new Error("noUiSlider ("+t+"): 'padding' option is only supported on linear sliders.");if(e.padding<0)throw new Error("noUiSlider ("+t+"): 'padding' option must be a positive number.");if(e.padding>=50)throw new Error("noUiSlider ("+t+"): 'padding' option must be less than half the range.")}}function O(e,r){switch(r){case"ltr":e.dir=0;break;case"rtl":e.dir=1;break;default:throw new Error("noUiSlider ("+t+"): 'direction' option was not recognized.")}}function k(e,r){if("string"!=typeof r)throw new Error("noUiSlider ("+t+"): 'behaviour' must be a string containing options.");var n=r.indexOf("tap")>=0,i=r.indexOf("drag")>=0,o=r.indexOf("fixed")>=0,s=r.indexOf("snap")>=0,a=r.indexOf("hover")>=0;if(o){if(2!==e.handles)throw new Error("noUiSlider ("+t+"): 'fixed' behaviour must be used with 2 handles");P(e,e.start[1]-e.start[0])}e.events={tap:n||s,drag:i,fixed:o,snap:s,hover:a}}function V(e,r){if(e.multitouch=r,"boolean"!=typeof r)throw new Error("noUiSlider ("+t+"): 'multitouch' option must be a boolean.")}function F(e,r){if(!1!==r)if(!0===r){e.tooltips=[];for(var n=0;n<e.handles;n++)e.tooltips.push(!0)}else{if(e.tooltips=i(r),e.tooltips.length!==e.handles)throw new Error("noUiSlider ("+t+"): must pass a formatter for all handles.");e.tooltips.forEach(function(e){if("boolean"!=typeof e&&("object"!=typeof e||"function"!=typeof e.to))throw new Error("noUiSlider ("+t+"): 'tooltips' must be passed a formatter or 'false'.")})}}function L(t,e){t.ariaFormat=e,b(e)}function z(t,e){t.format=e,b(e)}function j(e,r){if(void 0!==r&&"string"!=typeof r&&!1!==r)throw new Error("noUiSlider ("+t+"): 'cssPrefix' must be a string or `false`.");e.cssPrefix=r}function H(e,r){if(void 0!==r&&"object"!=typeof r)throw new Error("noUiSlider ("+t+"): 'cssClasses' must be an object.");if("string"==typeof e.cssPrefix)for(var n in e.cssClasses={},r)r.hasOwnProperty(n)&&(e.cssClasses[n]=e.cssPrefix+r[n]);else e.cssClasses=r}function D(e,r){if(!0!==r&&!1!==r)throw new Error("noUiSlider ("+t+"): 'useRequestAnimationFrame' option should be true (default) or false.");e.useRequestAnimationFrame=r}function q(e){var r={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:v,format:v},n={step:{r:!1,t:S},start:{r:!0,t:x},connect:{r:!0,t:N},direction:{r:!0,t:O},snap:{r:!1,t:y},animate:{r:!1,t:E},animationDuration:{r:!1,t:C},range:{r:!0,t:w},orientation:{r:!1,t:U},margin:{r:!1,t:P},limit:{r:!1,t:A},padding:{r:!1,t:M},behaviour:{r:!0,t:k},multitouch:{r:!0,t:V},ariaFormat:{r:!1,t:L},format:{r:!1,t:z},tooltips:{r:!1,t:F},cssPrefix:{r:!1,t:j},cssClasses:{r:!1,t:H},useRequestAnimationFrame:{r:!1,t:D}},i={connect:!1,direction:"ltr",behaviour:"tap",multitouch:!1,orientation:"horizontal",cssPrefix:"noUi-",cssClasses:{target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",ltr:"ltr",rtl:"rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},useRequestAnimationFrame:!0};e.format&&!e.ariaFormat&&(e.ariaFormat=e.format),Object.keys(n).forEach(function(o){if(void 0===e[o]&&void 0===i[o]){if(n[o].r)throw new Error("noUiSlider ("+t+"): '"+o+"' is required.");return!0}n[o].t(r,void 0===e[o]?i[o]:e[o])}),r.pips=e.pips;var o=[["left","top"],["right","bottom"]];return r.style=o[r.dir][r.ort],r.styleOposite=o[r.dir?0:1][r.ort],r}function T(r,o,u){var c,p,f,d,h,m,g,v=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},b=window.CSS&&CSS.supports&&CSS.supports("touch-action","none")&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),S=r,w=[],x=[],y=0,E=o.spectrum,C=[],N={},U=r.ownerDocument,P=U.documentElement,A=U.body;function M(t,e){var r=U.createElement("div");return e&&s(r,e),t.appendChild(r),r}function O(t,e){var r=M(t,o.cssClasses.origin),n=M(r,o.cssClasses.handle);return n.setAttribute("data-handle",e),n.setAttribute("tabindex","0"),n.setAttribute("role","slider"),n.setAttribute("aria-orientation",o.ort?"vertical":"horizontal"),0===e?s(n,o.cssClasses.handleLower):e===o.handles-1&&s(n,o.cssClasses.handleUpper),r}function k(t,e){return!!e&&M(t,o.cssClasses.connect)}function V(t,e){return!!o.tooltips[e]&&M(t.firstChild,o.cssClasses.tooltip)}function F(t,e,r){var n=U.createElement("div"),i=[o.cssClasses.valueNormal,o.cssClasses.valueLarge,o.cssClasses.valueSub],a=[o.cssClasses.markerNormal,o.cssClasses.markerLarge,o.cssClasses.markerSub],l=[o.cssClasses.valueHorizontal,o.cssClasses.valueVertical],u=[o.cssClasses.markerHorizontal,o.cssClasses.markerVertical];function c(t,e){var r=e===o.cssClasses.value,n=r?i:a;return e+" "+(r?l:u)[o.ort]+" "+n[t]}return s(n,o.cssClasses.pips),s(n,0===o.ort?o.cssClasses.pipsHorizontal:o.cssClasses.pipsVertical),Object.keys(t).forEach(function(i){!function(t,i){i[1]=i[1]&&e?e(i[0],i[1]):i[1];var s=M(n,!1);s.className=c(i[1],o.cssClasses.marker),s.style[o.style]=t+"%",i[1]&&((s=M(n,!1)).className=c(i[1],o.cssClasses.value),s.style[o.style]=t+"%",s.innerText=r.to(i[0]))}(i,t[i])}),n}function L(){var t;h&&((t=h).parentElement.removeChild(t),h=null)}function z(e){L();var r=e.mode,n=e.density||1,i=e.filter||!1,o=function(e,r,n){if("range"===e||"steps"===e)return E.xVal;if("count"===e){if(!r)throw new Error("noUiSlider ("+t+"): 'values' required for mode 'count'.");var i,o=100/(r-1),s=0;for(r=[];(i=s++*o)<=100;)r.push(i);e="positions"}return"positions"===e?r.map(function(t){return E.fromStepping(n?E.getStep(t):t)}):"values"===e?n?r.map(function(t){return E.fromStepping(E.getStep(E.toStepping(t)))}):r:void 0}(r,e.values||!1,e.stepped||!1),s=function(t,e,r){var n,i={},o=E.xVal[0],s=E.xVal[E.xVal.length-1],a=!1,l=!1,u=0;return n=r.slice().sort(function(t,e){return t-e}),(r=n.filter(function(t){return!this[t]&&(this[t]=!0)},{}))[0]!==o&&(r.unshift(o),a=!0),r[r.length-1]!==s&&(r.push(s),l=!0),r.forEach(function(n,o){var s,c,p,f,d,h,m,g,v,b=n,S=r[o+1];if("steps"===e&&(s=E.xNumSteps[o]),s||(s=S-b),!1!==b&&void 0!==S)for(s=Math.max(s,1e-7),c=b;c<=S;c=(c+s).toFixed(7)/1){for(m=(d=(f=E.toStepping(c))-u)/t,v=d/(g=Math.round(m)),p=1;p<=g;p+=1)i[(u+p*v).toFixed(5)]=["x",0];h=r.indexOf(c)>-1?1:"steps"===e?2:0,!o&&a&&(h=0),c===S&&l||(i[f.toFixed(5)]=[c,h]),u=f}}),i}(n,r,o),a=e.format||{to:Math.round};return h=S.appendChild(F(s,i,a))}function j(){var t=c.getBoundingClientRect(),e="offset"+["Width","Height"][o.ort];return 0===o.ort?t.width||c[e]:t.height||c[e]}function H(t,e,r,n){var i=function(i){return!S.hasAttribute("disabled")&&(s=S,a=o.cssClasses.tap,(s.classList?!s.classList.contains(a):!new RegExp("\\b"+a+"\\b").test(s.className))&&(!!(i=function(t,e,r){var n,i,s=0===t.type.indexOf("touch"),a=0===t.type.indexOf("mouse"),u=0===t.type.indexOf("pointer");0===t.type.indexOf("MSPointer")&&(u=!0);if(s&&o.multitouch){var c=function(t){return t.target===r||r.contains(t.target)};if("touchstart"===t.type){var p=Array.prototype.filter.call(t.touches,c);if(p.length>1)return!1;n=p[0].pageX,i=p[0].pageY}else{var f=Array.prototype.find.call(t.changedTouches,c);if(!f)return!1;n=f.pageX,i=f.pageY}}else if(s){if(t.touches.length>1)return!1;n=t.changedTouches[0].pageX,i=t.changedTouches[0].pageY}e=e||l(U),(a||u)&&(n=t.clientX+e.x,i=t.clientY+e.y);return t.pageOffset=e,t.points=[n,i],t.cursor=a||u,t}(i,n.pageOffset,n.target||e))&&(!(t===v.start&&void 0!==i.buttons&&i.buttons>1)&&((!n.hover||!i.buttons)&&(b||i.preventDefault(),i.calcPoint=i.points[o.ort],void r(i,n))))));var s,a},s=[];return t.split(" ").forEach(function(t){e.addEventListener(t,i,!!b&&{passive:!0}),s.push([t,i])}),s}function D(t){var e,r,n,i,s,a,u=100*(t-(e=c,r=o.ort,n=e.getBoundingClientRect(),i=e.ownerDocument,s=i.documentElement,a=l(i),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(a.x=0),r?n.top+a.y-s.clientTop:n.left+a.x-s.clientLeft))/j();return o.dir?100-u:u}function T(t,e,r,n){var i=r.slice(),o=[!t,t],s=[t,!t];n=n.slice(),t&&n.reverse(),n.length>1?n.forEach(function(t,r){var n=$(i,t,i[t]+e,o[r],s[r],!1);!1===n?e=0:(e=n-i[t],i[t]=n)}):o=s=[!0];var a=!1;n.forEach(function(t,n){a=K(t,r[t]+e,o[n],s[n])||a}),a&&n.forEach(function(t){R("update",t),R("slide",t)})}function R(t,e,r){Object.keys(N).forEach(function(n){var i=n.split(".")[0];t===i&&N[n].forEach(function(t){t.call(d,C.map(o.format.to),e,C.slice(),r||!1,w.slice())})})}function X(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&Y(t,e)}function B(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return Y(t,e);var r=(o.dir?-1:1)*(t.calcPoint-e.startCalcPoint);T(r>0,100*r/e.baseSize,e.locations,e.handleNumbers)}function Y(t,r){r.handle&&(a(r.handle,o.cssClasses.active),y-=1),r.listeners.forEach(function(t){P.removeEventListener(t[0],t[1])}),0===y&&(a(S,o.cssClasses.drag),J(),t.cursor&&(A.style.cursor="",A.removeEventListener("selectstart",e))),r.handleNumbers.forEach(function(t){R("change",t),R("set",t),R("end",t)})}function _(t,r){var n;if(1===r.handleNumbers.length){var i=p[r.handleNumbers[0]];if(i.hasAttribute("disabled"))return!1;n=i.children[0],y+=1,s(n,o.cssClasses.active)}t.stopPropagation();var a=[],l=H(v.move,P,B,{target:t.target,handle:n,listeners:a,startCalcPoint:t.calcPoint,baseSize:j(),pageOffset:t.pageOffset,handleNumbers:r.handleNumbers,buttonsProperty:t.buttons,locations:w.slice()}),u=H(v.end,P,Y,{target:t.target,handle:n,listeners:a,handleNumbers:r.handleNumbers}),c=H("mouseout",P,X,{target:t.target,handle:n,listeners:a,handleNumbers:r.handleNumbers});a.push.apply(a,l.concat(u,c)),t.cursor&&(A.style.cursor=getComputedStyle(t.target).cursor,p.length>1&&s(S,o.cssClasses.drag),A.addEventListener("selectstart",e,!1)),r.handleNumbers.forEach(function(t){R("start",t)})}function I(t){t.stopPropagation();var e=D(t.calcPoint),r=function(t){var e=100,r=!1;return p.forEach(function(n,i){if(!n.hasAttribute("disabled")){var o=Math.abs(w[i]-t);o<e&&(r=i,e=o)}}),r}(e);if(!1===r)return!1;o.events.snap||n(S,o.cssClasses.tap,o.animationDuration),K(r,e,!0,!0),J(),R("slide",r,!0),R("update",r,!0),R("change",r,!0),R("set",r,!0),o.events.snap&&_(t,{handleNumbers:[r]})}function W(t){var e=D(t.calcPoint),r=E.getStep(e),n=E.fromStepping(r);Object.keys(N).forEach(function(t){"hover"===t.split(".")[0]&&N[t].forEach(function(t){t.call(d,n)})})}function $(t,e,r,n,i,s){var a;return p.length>1&&(n&&e>0&&(r=Math.max(r,t[e-1]+o.margin)),i&&e<p.length-1&&(r=Math.min(r,t[e+1]-o.margin))),p.length>1&&o.limit&&(n&&e>0&&(r=Math.min(r,t[e-1]+o.limit)),i&&e<p.length-1&&(r=Math.max(r,t[e+1]-o.limit))),o.padding&&(0===e&&(r=Math.max(r,o.padding)),e===p.length-1&&(r=Math.min(r,100-o.padding))),r=E.getStep(r),a=r,!((r=Math.max(Math.min(a,100),0))===t[e]&&!s)&&r}function G(t){return t+"%"}function J(){x.forEach(function(t){var e=w[t]>50?-1:1,r=3+(p.length+e*t);p[t].childNodes[0].style.zIndex=r})}function K(t,e,r,n){return!1!==(e=$(w,t,e,r,n,!1))&&(function(t,e){w[t]=e,C[t]=E.fromStepping(e);var r=function(){p[t].style[o.style]=G(e),Q(t),Q(t+1)};window.requestAnimationFrame&&o.useRequestAnimationFrame?window.requestAnimationFrame(r):r()}(t,e),!0)}function Q(t){if(f[t]){var e=0,r=100;0!==t&&(e=w[t-1]),t!==f.length-1&&(r=w[t]),f[t].style[o.style]=G(e),f[t].style[o.styleOposite]=G(100-r)}}function Z(t,e){null!==t&&!1!==t&&("number"==typeof t&&(t=String(t)),!1===(t=o.format.from(t))||isNaN(t)||K(e,E.toStepping(t),!1,!1))}function tt(t,e){var r=i(t),s=void 0===w[0];e=void 0===e||!!e,r.forEach(Z),o.animate&&!s&&n(S,o.cssClasses.tap,o.animationDuration),x.forEach(function(t){K(t,w[t],!0,!1)}),J(),x.forEach(function(t){R("update",t),null!==r[t]&&e&&R("set",t)})}function et(){var t=C.map(o.format.to);return 1===t.length?t[0]:t}function rt(t,e){N[t]=N[t]||[],N[t].push(e),"update"===t.split(".")[0]&&p.forEach(function(t,e){R("update",e)})}if(S.noUiSlider)throw new Error("noUiSlider ("+t+"): Slider was already initialized.");return function(t){s(t,o.cssClasses.target),0===o.dir?s(t,o.cssClasses.ltr):s(t,o.cssClasses.rtl),0===o.ort?s(t,o.cssClasses.horizontal):s(t,o.cssClasses.vertical),c=M(t,o.cssClasses.base)}(S),function(t,e){p=[],(f=[]).push(k(e,t[0]));for(var r=0;r<o.handles;r++)p.push(O(e,r)),x[r]=r,f.push(k(e,t[r+1]))}(o.connect,c),d={destroy:function(){for(var t in o.cssClasses)o.cssClasses.hasOwnProperty(t)&&a(S,o.cssClasses[t]);for(;S.firstChild;)S.removeChild(S.firstChild);delete S.noUiSlider},steps:function(){return w.map(function(t,e){var r=E.getNearbySteps(t),n=C[e],i=r.thisStep.step,o=null;!1!==i&&n+i>r.stepAfter.startValue&&(i=r.stepAfter.startValue-n),o=n>r.thisStep.startValue?r.thisStep.step:!1!==r.stepBefore.step&&n-r.stepBefore.highestStep,100===t?i=null:0===t&&(o=null);var s=E.countStepDecimals();return null!==i&&!1!==i&&(i=Number(i.toFixed(s))),null!==o&&!1!==o&&(o=Number(o.toFixed(s))),[o,i]})},on:rt,off:function(t){var e=t&&t.split(".")[0],r=e&&t.substring(e.length);Object.keys(N).forEach(function(t){var n=t.split(".")[0],i=t.substring(n.length);e&&e!==n||r&&r!==i||delete N[t]})},get:et,set:tt,reset:function(t){tt(o.start,t)},__moveHandles:function(t,e,r){T(t,e,w,r)},options:u,updateOptions:function(t,e){var r=et(),n=["margin","limit","padding","range","animate","snap","step","format"];n.forEach(function(e){void 0!==t[e]&&(u[e]=t[e])});var i=q(u);n.forEach(function(e){void 0!==t[e]&&(o[e]=i[e])}),E=i.spectrum,o.margin=i.margin,o.limit=i.limit,o.padding=i.padding,o.pips&&z(o.pips),w=[],tt(t.start||r,e)},target:S,removePips:L,pips:z},(m=o.events).fixed||p.forEach(function(t,e){H(v.start,t.children[0],_,{handleNumbers:[e]})}),m.tap&&H(v.start,c,I,{}),m.hover&&H(v.move,c,W,{hover:!0}),m.drag&&f.forEach(function(t,e){if(!1!==t&&0!==e&&e!==f.length-1){var r=p[e-1],n=p[e],i=[t];s(t,o.cssClasses.draggable),m.fixed&&(i.push(r.children[0]),i.push(n.children[0])),i.forEach(function(t){H(v.start,t,_,{handles:[r,n],handleNumbers:[e-1,e]})})}}),tt(o.start),o.pips&&z(o.pips),o.tooltips&&(g=p.map(V),rt("update",function(t,e,r){if(g[e]){var n=t[e];!0!==o.tooltips[e]&&(n=o.tooltips[e].to(r[e])),g[e].innerHTML=n}})),rt("update",function(t,e,r,n,i){x.forEach(function(t){var e=p[t],n=$(w,t,0,!0,!0,!0),s=$(w,t,100,!0,!0,!0),a=i[t],l=o.ariaFormat.to(r[t]);e.children[0].setAttribute("aria-valuemin",n.toFixed(1)),e.children[0].setAttribute("aria-valuemax",s.toFixed(1)),e.children[0].setAttribute("aria-valuenow",a.toFixed(1)),e.children[0].setAttribute("aria-valuetext",l)})}),d}return{version:t,create:function(e,r){if(!e||!e.nodeName)throw new Error("noUiSlider ("+t+"): create requires a single element, got: "+e);var n=T(e,q(r),r);return e.noUiSlider=n,n}}},"function"==typeof define&&define.amd?define([],n):"object"==typeof r?e.exports=n():window.noUiSlider=n()},
392: function _(e,t,i){e(62),e(393),e(61).styles.append(".bk-root .bk-slider-title {\n  white-space: nowrap;\n}\n.bk-root .bk-slider-value {\n  font-weight: 600;\n}\n"),i.bk_slider_value="bk-slider-value",i.bk_slider_title="bk-slider-title",i.bk_input_group="bk-input-group"},
393: function _(n,o,t){n(62),n(61).styles.append('.bk-root {\n  /* Functional styling;\n * These styles are required for noUiSlider to function.\n * You don\'t need to change these rules to apply your design.\n */\n  /* Painting and performance;\n * Browsers can paint handles in their own layer.\n */\n  /* Slider size and handle placement;\n */\n  /* Styling;\n */\n  /* Handles and cursors;\n */\n  /* Handle stripes;\n */\n  /* Disabled state;\n */\n  /* Base;\n *\n */\n  /* Values;\n *\n */\n  /* Markings;\n *\n */\n  /* Horizontal layout;\n *\n */\n  /* Vertical layout;\n *\n */\n}\n.bk-root .bk-noUi-target,\n.bk-root .bk-noUi-target * {\n  -webkit-touch-callout: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-user-select: none;\n  -ms-touch-action: none;\n  touch-action: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  user-select: none;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .bk-noUi-target {\n  position: relative;\n  direction: ltr;\n}\n.bk-root .bk-noUi-base {\n  width: 100%;\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  /* Fix 401 */\n}\n.bk-root .bk-noUi-connect {\n  position: absolute;\n  right: 0;\n  top: 0;\n  left: 0;\n  bottom: 0;\n}\n.bk-root .bk-noUi-origin {\n  position: absolute;\n  height: 0;\n  width: 0;\n}\n.bk-root .bk-noUi-handle {\n  position: relative;\n  z-index: 1;\n}\n.bk-root .bk-noUi-state-tap .bk-noUi-connect,\n.bk-root .bk-noUi-state-tap .bk-noUi-origin {\n  -webkit-transition: top 0.3s, right 0.3s, bottom 0.3s, left 0.3s;\n  transition: top 0.3s, right 0.3s, bottom 0.3s, left 0.3s;\n}\n.bk-root .bk-noUi-state-drag * {\n  cursor: inherit !important;\n}\n.bk-root .bk-noUi-base,\n.bk-root .bk-noUi-handle {\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0);\n}\n.bk-root .bk-noUi-horizontal {\n  height: 18px;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-handle {\n  width: 34px;\n  height: 28px;\n  left: -17px;\n  top: -6px;\n}\n.bk-root .bk-noUi-vertical {\n  width: 18px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle {\n  width: 28px;\n  height: 34px;\n  left: -6px;\n  top: -17px;\n}\n.bk-root .bk-noUi-target {\n  background: #FAFAFA;\n  border-radius: 4px;\n  border: 1px solid #D3D3D3;\n  box-shadow: inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;\n}\n.bk-root .bk-noUi-connect {\n  background: #3FB8AF;\n  border-radius: 4px;\n  box-shadow: inset 0 0 3px rgba(51, 51, 51, 0.45);\n  -webkit-transition: background 450ms;\n  transition: background 450ms;\n}\n.bk-root .bk-noUi-draggable {\n  cursor: ew-resize;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-draggable {\n  cursor: ns-resize;\n}\n.bk-root .bk-noUi-handle {\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #FFF;\n  cursor: default;\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;\n}\n.bk-root .bk-noUi-active {\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;\n}\n.bk-root .bk-noUi-handle:before,\n.bk-root .bk-noUi-handle:after {\n  content: "";\n  display: block;\n  position: absolute;\n  height: 14px;\n  width: 1px;\n  background: #E8E7E6;\n  left: 14px;\n  top: 6px;\n}\n.bk-root .bk-noUi-handle:after {\n  left: 17px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle:before,\n.bk-root .bk-noUi-vertical .bk-noUi-handle:after {\n  width: 14px;\n  height: 1px;\n  left: 6px;\n  top: 14px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle:after {\n  top: 17px;\n}\n.bk-root [disabled] .bk-noUi-connect {\n  background: #B8B8B8;\n}\n.bk-root [disabled].bk-noUi-target,\n.bk-root [disabled].bk-noUi-handle,\n.bk-root [disabled] .bk-noUi-handle {\n  cursor: not-allowed;\n}\n.bk-root .bk-noUi-pips,\n.bk-root .bk-noUi-pips * {\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .bk-noUi-pips {\n  position: absolute;\n  color: #999;\n}\n.bk-root .bk-noUi-value {\n  position: absolute;\n  white-space: nowrap;\n  text-align: center;\n}\n.bk-root .bk-noUi-value-sub {\n  color: #ccc;\n  font-size: 10px;\n}\n.bk-root .bk-noUi-marker {\n  position: absolute;\n  background: #CCC;\n}\n.bk-root .bk-noUi-marker-sub {\n  background: #AAA;\n}\n.bk-root .bk-noUi-marker-large {\n  background: #AAA;\n}\n.bk-root .bk-noUi-pips-horizontal {\n  padding: 10px 0;\n  height: 80px;\n  top: 100%;\n  left: 0;\n  width: 100%;\n}\n.bk-root .bk-noUi-value-horizontal {\n  -webkit-transform: translate3d(-50%, 50%, 0);\n  transform: translate3d(-50%, 50%, 0);\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker {\n  margin-left: -1px;\n  width: 2px;\n  height: 5px;\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker-sub {\n  height: 10px;\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker-large {\n  height: 15px;\n}\n.bk-root .bk-noUi-pips-vertical {\n  padding: 0 10px;\n  height: 100%;\n  top: 0;\n  left: 100%;\n}\n.bk-root .bk-noUi-value-vertical {\n  -webkit-transform: translate3d(0, 50%, 0);\n  transform: translate3d(0, 50%, 0);\n  padding-left: 25px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker {\n  width: 5px;\n  height: 2px;\n  margin-top: -1px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker-sub {\n  width: 10px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker-large {\n  width: 15px;\n}\n.bk-root .bk-noUi-tooltip {\n  display: block;\n  position: absolute;\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #fff;\n  color: #000;\n  padding: 5px;\n  text-align: center;\n  white-space: nowrap;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-tooltip {\n  -webkit-transform: translate(-50%, 0);\n  transform: translate(-50%, 0);\n  left: 50%;\n  bottom: 120%;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-tooltip {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  top: 50%;\n  right: 120%;\n}\n.bk-root .bk-noUi-handle {\n  cursor: grab;\n  cursor: -webkit-grab;\n}\n.bk-root .bk-noUi-handle.bk-noUi-active {\n  cursor: grabbing;\n  cursor: -webkit-grabbing;\n}\n.bk-root .bk-noUi-tooltip {\n  display: none;\n  white-space: nowrap;\n}\n.bk-root .bk-noUi-handle:hover .bk-noUi-tooltip {\n  display: block;\n}\n.bk-root .bk-noUi-horizontal {\n  width: 100%;\n  height: 10px;\n}\n.bk-root .bk-noUi-horizontal.bk-noUi-target {\n  margin: 5px 0px;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-handle {\n  width: 14px;\n  height: 18px;\n  left: -7px;\n  top: -5px;\n}\n.bk-root .bk-noUi-vertical {\n  width: 10px;\n  height: 100%;\n}\n.bk-root .bk-noUi-vertical.bk-noUi-target {\n  margin: 0px 5px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle {\n  width: 18px;\n  height: 14px;\n  left: -5px;\n  top: -7px;\n}\n.bk-root .bk-noUi-handle:after,\n.bk-root .bk-noUi-handle:before {\n  display: none;\n}\n.bk-root .bk-noUi-connect {\n  box-shadow: none;\n}\n')},
394: function _(e,t,i){const r=e(150),a=e(390);class s extends a.AbstractSliderView{}i.DateSliderView=s,s.__name__="DateSliderView";class d extends a.AbstractSlider{constructor(e){super(e),this.behaviour="tap",this.connected=[!0,!1]}static init_DateSlider(){this.prototype.default_view=s,this.override({format:"%d %b %Y"})}_formatter(e,t){return r(e,t)}}i.DateSlider=d,d.__name__="DateSlider",d.init_DateSlider()},
395: function _(e,t,i){const n=e(396),s=e(18);class r extends n.MarkupView{render(){super.render(),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.model.text}}i.DivView=r,r.__name__="DivView";class _ extends n.Markup{constructor(e){super(e)}static init_Div(){this.prototype.default_view=r,this.define({render_as_text:[s.Boolean,!1]})}}i.Div=_,_.__name__="Div",_.init_Div()},
396: function _(e,t,s){const i=e(180),n=e(61),a=e(18),l=e(432),r=e(397);class c extends l.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>{this.render(),this.root.compute_layout()})}_update_layout(){this.layout=new i.VariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){super.render();const e=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.markup_el=n.div({class:r.bk_clearfix,style:e}),this.el.appendChild(this.markup_el)}}s.MarkupView=c,c.__name__="MarkupView";class _ extends l.Widget{constructor(e){super(e)}static init_Markup(){this.define({text:[a.String,""],style:[a.Any,{}]})}}s.Markup=_,_.__name__="Markup",_.init_Markup()},
397: function _(e,n,r){e(62),e(61).styles.append('.bk-root .bk-clearfix:before,\n.bk-root .bk-clearfix:after {\n  content: "";\n  display: table;\n}\n.bk-root .bk-clearfix:after {\n  clear: both;\n}\n'),r.bk_clearfix="bk-clearfix"},
398: function _(e,t,i){const s=e(372),n=e(274),l=e(61),o=e(18),d=e(7),c=e(138),_=e(245),u=e(246);class h extends s.AbstractButtonView{constructor(){super(...arguments),this._open=!1}render(){super.render();const e=l.div({class:[u.bk_caret,c.bk_down]});if(this.model.is_split){const t=this._render_button(e);t.classList.add(_.bk_dropdown_toggle),t.addEventListener("click",()=>this._toggle_menu()),this.group_el.appendChild(t)}else this.button_el.appendChild(e);const t=this.model.menu.map((e,t)=>{if(null==e)return l.div({class:u.bk_divider});{const i=d.isString(e)?e:e[0],s=l.div({},i);return s.addEventListener("click",()=>this._item_click(t)),s}});this.menu=l.div({class:[u.bk_menu,c.bk_below]},t),this.el.appendChild(this.menu),l.undisplay(this.menu)}_show_menu(){if(!this._open){this._open=!0,l.display(this.menu);const e=t=>{const{target:i}=t;i instanceof HTMLElement&&!this.el.contains(i)&&(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,l.undisplay(this.menu))}_toggle_menu(){this._open?this._hide_menu():this._show_menu()}click(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new n.ButtonClick),this.model.value=this.model.default_value,null!=this.model.callback&&this.model.callback.execute(this.model),super.click()):this._toggle_menu()}_item_click(e){this._hide_menu();const t=this.model.menu[e];if(null!=t){const i=d.isString(t)?t:t[1];d.isString(i)?(this.model.trigger_event(new n.MenuItemClick(i)),this.model.value=i,null!=this.model.callback&&this.model.callback.execute(this.model)):(i.execute(this.model,{index:e}),null!=this.model.callback&&this.model.callback.execute(this.model))}}}i.DropdownView=h,h.__name__="DropdownView";class r extends s.AbstractButton{constructor(e){super(e)}static init_Dropdown(){this.prototype.default_view=h,this.define({split:[o.Boolean,!1],menu:[o.Array,[]],value:[o.String],default_value:[o.String]}),this.override({label:"Dropdown"})}get is_split(){return this.split||null!=this.default_value}}i.Dropdown=r,r.__name__="Dropdown",r.init_Dropdown()},
399: function _(e,t,i){const l=e(18),s=e(432);class n extends s.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render()),this.connect(this.model.properties.width.change,()=>this.render())}render(){this.dialogEl||(this.dialogEl=document.createElement("input"),this.dialogEl.type="file",this.dialogEl.multiple=!1,null!=this.model.accept&&""!=this.model.accept&&(this.dialogEl.accept=this.model.accept),this.dialogEl.style.width="{this.model.width}px",this.dialogEl.onchange=(e=>this.load_file(e)),this.el.appendChild(this.dialogEl))}load_file(e){const t=new FileReader;this.model.filename=e.target.files[0].name,t.onload=(e=>this.file(e)),t.readAsDataURL(e.target.files[0])}file(e){const t=e.target.result.split(","),i=t[1],l=t[0].split(":")[1].split(";")[0];this.model.value=i,this.model.mime_type=l}}i.FileInputView=n,n.__name__="FileInputView";class a extends s.Widget{constructor(e){super(e)}static init_FileInput(){this.prototype.default_view=n,this.define({value:[l.String,""],mime_type:[l.String,""],filename:[l.String,""],accept:[l.String,""]})}}i.FileInput=a,a.__name__="FileInput",a.init_FileInput()},
400: function _(e,t,s){const i=e(61),n=e(7),l=e(14),o=e(18),r=e(378),c=e(379);class h extends r.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,()=>this.render_selection()),this.connect(this.model.properties.options.change,()=>this.render()),this.connect(this.model.properties.name.change,()=>this.render()),this.connect(this.model.properties.title.change,()=>this.render()),this.connect(this.model.properties.size.change,()=>this.render()),this.connect(this.model.properties.disabled.change,()=>this.render())}render(){super.render();const e=this.model.options.map(e=>{let t,s;return n.isString(e)?t=s=e:[t,s]=e,i.option({value:t},s)});this.select_el=i.select({multiple:!0,class:c.bk_input,name:this.model.name,disabled:this.model.disabled},e),this.select_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.select_el),this.render_selection()}render_selection(){const e=new l.Set(this.model.value);for(const t of Array.from(this.el.querySelectorAll("option")))t.selected=e.has(t.value);this.select_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus"),t=[];for(const e of Array.from(this.el.querySelectorAll("option")))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.select_el.focus()}}s.MultiSelectView=h,h.__name__="MultiSelectView";class a extends r.InputWidget{constructor(e){super(e)}static init_MultiSelect(){this.prototype.default_view=h,this.define({value:[o.Array,[]],options:[o.Array,[]],size:[o.Number,4]})}}s.MultiSelect=a,a.__name__="MultiSelect",a.init_MultiSelect()},
401: function _(a,r,e){const t=a(396),p=a(61);class s extends t.MarkupView{render(){super.render();const a=p.p({style:{margin:0}},this.model.text);this.markup_el.appendChild(a)}}e.ParagraphView=s,s.__name__="ParagraphView";class i extends t.Markup{constructor(a){super(a)}static init_Paragraph(){this.prototype.default_view=s}}e.Paragraph=i,i.__name__="Paragraph",i.init_Paragraph()},
402: function _(s,t,e){const n=s(377);class r extends n.TextInputView{render(){super.render(),this.input_el.type="password"}}e.PasswordInputView=r,r.__name__="PasswordInputView";class p extends n.TextInput{constructor(s){super(s)}static init_PasswordInput(){this.prototype.default_view=r}}e.PasswordInput=p,p.__name__="PasswordInput",p.init_PasswordInput()},
403: function _(e,t,r){const s=e(396),i=e(61);class n extends s.MarkupView{render(){super.render();const e=i.pre({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(e)}}r.PreTextView=n,n.__name__="PreTextView";class _ extends s.Markup{constructor(e){super(e)}static init_PreText(){this.prototype.default_view=n}}r.PreText=_,_.__name__="PreText",_.init_PreText()},
404: function _(t,o,e){const i=t(382),a=t(61),n=t(18),u=t(138);class s extends i.ButtonGroupView{change_active(t){this.model.active!==t&&(this.model.active=t,null!=this.model.callback&&this.model.callback.execute(this.model))}_update_active(){const{active:t}=this.model;this._buttons.forEach((o,e)=>{a.classes(o).toggle(u.bk_active,t===e)})}}e.RadioButtonGroupView=s,s.__name__="RadioButtonGroupView";class c extends i.ButtonGroup{constructor(t){super(t)}static init_RadioButtonGroup(){this.prototype.default_view=s,this.define({active:[n.Any,null]})}}e.RadioButtonGroup=c,c.__name__="RadioButtonGroup",c.init_RadioButtonGroup()},
405: function _(e,i,t){const n=e(61),a=e(25),l=e(18),o=e(384),s=e(138),d=e(379);class c extends o.InputGroupView{render(){super.render();const e=n.div({class:[d.bk_input_group,this.model.inline?s.bk_inline:null]});this.el.appendChild(e);const i=a.uniqueId(),{active:t,labels:l}=this.model;for(let a=0;a<l.length;a++){const o=n.input({type:"radio",name:i,value:`${a}`});o.addEventListener("change",()=>this.change_active(a)),this.model.disabled&&(o.disabled=!0),a==t&&(o.checked=!0);const s=n.label({},o,n.span({},l[a]));e.appendChild(s)}}change_active(e){this.model.active=e,null!=this.model.callback&&this.model.callback.execute(this.model)}}t.RadioGroupView=c,c.__name__="RadioGroupView";class u extends o.InputGroup{constructor(e){super(e)}static init_RadioGroup(){this.prototype.default_view=c,this.define({active:[l.Number],labels:[l.Array,[]],inline:[l.Boolean,!1],callback:[l.Any]})}}t.RadioGroup=u,u.__name__="RadioGroup",u.init_RadioGroup()},
406: function _(e,t,i){const r=e(153),a=e(390);class n extends a.AbstractRangeSliderView{}i.RangeSliderView=n,n.__name__="RangeSliderView";class s extends a.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}static init_RangeSlider(){this.prototype.default_view=n,this.override({format:"0[.]00"})}_formatter(e,t){return r.format(e,t)}}i.RangeSlider=s,s.__name__="RangeSlider",s.init_RangeSlider()},
407: function _(e,t,s){const i=e(61),n=e(7),l=e(65),o=e(18),c=e(378),d=e(379);class a extends c.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}build_options(e){return e.map(e=>{let t,s;n.isString(e)?t=s=e:[t,s]=e;const l=this.model.value==t;return i.option({selected:l,value:t},s)})}render(){let e;if(super.render(),n.isArray(this.model.options))e=this.build_options(this.model.options);else{e=[];const t=this.model.options;for(const s in t){const n=t[s];e.push(i.optgroup({label:s},this.build_options(n)))}}this.select_el=i.select({class:d.bk_input,id:this.model.id,name:this.model.name,disabled:this.model.disabled},e),this.select_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.select_el)}change_input(){const e=this.select_el.value;l.logger.debug(`selectbox: value = ${e}`),this.model.value=e,super.change_input()}}s.SelectView=a,a.__name__="SelectView";class h extends c.InputWidget{constructor(e){super(e)}static init_Select(){this.prototype.default_view=a,this.define({value:[o.String,""],options:[o.Any,[]]})}}s.Select=h,h.__name__="Select",h.init_Select()},
408: function _(e,t,i){const r=e(153),s=e(390);class a extends s.AbstractSliderView{}i.SliderView=a,a.__name__="SliderView";class d extends s.AbstractSlider{constructor(e){super(e),this.behaviour="tap",this.connected=[!0,!1]}static init_Slider(){this.prototype.default_view=a,this.override({format:"0[.]00"})}_formatter(e,t){return r.format(e,t)}}i.Slider=d,d.__name__="Slider",d.init_Slider()},
409: function _(e,t,i){const n=e(378),s=e(61),l=e(18),h=e(379),{floor:o,max:p,min:d}=Math;function u(e){return o(e)!==e?e.toString().replace("/0+$/","").split(".")[1].length:0}class a extends n.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.low.change,()=>{const{low:e}=this.model;null!=e&&(this.input_el.min=e.toFixed(16))}),this.connect(this.model.properties.high.change,()=>{const{high:e}=this.model;null!=e&&(this.input_el.max=e.toFixed(16))}),this.connect(this.model.properties.step.change,()=>{const{step:e}=this.model;this.input_el.step=e.toFixed(16)}),this.connect(this.model.properties.value.change,()=>{const{value:e,step:t}=this.model;this.input_el.value=e.toFixed(u(t)).replace(/(\.[0-9]*[1-9])0+$|\.0*$/,"$1")}),this.connect(this.model.properties.disabled.change,()=>{this.input_el.disabled=this.model.disabled})}render(){super.render(),this.input_el=s.input({type:"number",class:h.bk_input,name:this.model.name,min:this.model.low,max:this.model.high,value:this.model.value,step:this.model.step,disabled:this.model.disabled}),this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el)}change_input(){if(this.input_el.value){const{step:e}=this.model;let t=Number(this.input_el.value);null!=this.model.low&&(t=p(t,this.model.low)),null!=this.model.high&&(t=d(t,this.model.high)),this.model.value=Number(t.toFixed(u(e))),super.change_input()}}}i.SpinnerView=a,a.__name__="SpinnerView";class r extends n.InputWidget{constructor(e){super(e)}static init_Spinner(){this.prototype.default_view=a,this.define({value:[l.Number,0],low:[l.Number,null],high:[l.Number,null],step:[l.Number,1]})}}i.Spinner=r,r.__name__="Spinner",r.init_Spinner()},
410: function _(e,t,i){const s=e(377),n=e(378),l=e(61),h=e(18),o=e(379);class a extends n.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.input_el.name=this.model.name||""),this.connect(this.model.properties.value.change,()=>this.input_el.value=this.model.value),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder),this.connect(this.model.properties.rows.change,()=>this.input_el.rows=this.model.rows),this.connect(this.model.properties.cols.change,()=>this.input_el.cols=this.model.cols),this.connect(this.model.properties.max_length.change,()=>this.input_el.maxLength=this.model.max_length)}render(){super.render(),this.input_el=l.textarea({class:o.bk_input,name:this.model.name,disabled:this.model.disabled,placeholder:this.model.placeholder,cols:this.model.cols,rows:this.model.rows,maxLength:this.model.max_length}),this.input_el.textContent=this.model.value,this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el)}change_input(){this.model.value=this.input_el.value,super.change_input()}}i.TextAreaInputView=a,a.__name__="TextAreaInputView";class p extends s.TextInput{constructor(e){super(e)}static init_TextAreaInput(){this.prototype.default_view=a,this.define({cols:[h.Number,20],rows:[h.Number,2],max_length:[h.Number,500]})}}i.TextAreaInput=p,p.__name__="TextAreaInput",p.init_TextAreaInput()},
411: function _(e,t,i){const s=e(372),c=e(61),o=e(18),a=e(138);class n extends s.AbstractButtonView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._update_active())}render(){super.render(),this._update_active()}click(){this.model.active=!this.model.active,super.click()}_update_active(){c.classes(this.button_el).toggle(a.bk_active,this.model.active)}}i.ToggleView=n,n.__name__="ToggleView";class l extends s.AbstractButton{constructor(e){super(e)}static init_Toggle(){this.prototype.default_view=n,this.define({active:[o.Boolean,!1]}),this.override({label:"Toggle"})}}i.Toggle=l,l.__name__="Toggle",l.init_Toggle()},
}, 370, {"models/widgets/main":370,"models/widgets/index":371,"models/widgets/abstract_button":372,"models/widgets/control":373,"models/widgets/widget":432,"models/widgets/abstract_icon":375,"models/widgets/autocomplete_input":376,"models/widgets/text_input":377,"models/widgets/input_widget":378,"styles/widgets/inputs":379,"models/widgets/button":380,"models/widgets/checkbox_button_group":381,"models/widgets/button_group":382,"models/widgets/checkbox_group":383,"models/widgets/input_group":384,"models/widgets/color_picker":385,"models/widgets/date_picker":386,"styles/widgets/pikaday":388,"models/widgets/date_range_slider":389,"models/widgets/abstract_slider":390,"styles/widgets/sliders":392,"styles/widgets/nouislider":393,"models/widgets/date_slider":394,"models/widgets/div":395,"models/widgets/markup":396,"styles/clearfix":397,"models/widgets/dropdown":398,"models/widgets/file_input":399,"models/widgets/multiselect":400,"models/widgets/paragraph":401,"models/widgets/password_input":402,"models/widgets/pretext":403,"models/widgets/radio_button_group":404,"models/widgets/radio_group":405,"models/widgets/range_slider":406,"models/widgets/selectbox":407,"models/widgets/slider":408,"models/widgets/spinner":409,"models/widgets/textarea_input":410,"models/widgets/toggle":411}, {});
})

//# sourceMappingURL=bokeh-widgets-es6.min.js.map
