"""Generated message classes for cloudtrace version v2beta1.

Sends application trace data to Cloud Trace for viewing. Trace data is
collected for all App Engine applications by default. Trace data from other
applications can be provided using this API. This library is used to interact
with the Cloud Trace API directly. If you are looking to instrument your
application for Cloud Trace, we recommend using OpenCensus.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'cloudtrace'


class CloudtraceProjectsTraceSinksCreateRequest(_messages.Message):
  r"""A CloudtraceProjectsTraceSinksCreateRequest object.

  Fields:
    parent: Required. The resource in which to create the sink (currently only
      project sinks are supported):      "projects/[PROJECT_ID]"  Examples:
      `"projects/my-trace-project"`, `"projects/123456789"`.
    traceSink: A TraceSink resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  traceSink = _messages.MessageField('TraceSink', 2)


class CloudtraceProjectsTraceSinksDeleteRequest(_messages.Message):
  r"""A CloudtraceProjectsTraceSinksDeleteRequest object.

  Fields:
    name: Required. The full resource name of the sink to delete, including
      the parent resource and the sink identifier:
      "projects/[PROJECT_NUMBER]/traceSinks/[SINK_ID]"  Example:
      `"projects/12345/traceSinks/my-sink-id"`.
  """

  name = _messages.StringField(1, required=True)


class CloudtraceProjectsTraceSinksGetRequest(_messages.Message):
  r"""A CloudtraceProjectsTraceSinksGetRequest object.

  Fields:
    name: Required. The resource name of the sink:
      "projects/[PROJECT_NUMBER]/traceSinks/[SINK_ID]"  Example:
      `"projects/12345/traceSinks/my-sink-id"`.
  """

  name = _messages.StringField(1, required=True)


class CloudtraceProjectsTraceSinksListRequest(_messages.Message):
  r"""A CloudtraceProjectsTraceSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored.  The presence of
      `nextPageToken` in the response indicates that more results might be
      available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method.  `pageToken` must be the value
      of `nextPageToken` from the previous response.  The values of other
      method parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose sinks are to be listed
      (currently only project parent resources are supported):
      "projects/[PROJECT_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudtraceProjectsTraceSinksPatchRequest(_messages.Message):
  r"""A CloudtraceProjectsTraceSinksPatchRequest object.

  Fields:
    name: Required. The full resource name of the sink to update, including
      the parent resource and the sink identifier:
      "projects/[PROJECT_NUMBER]/traceSinks/[SINK_ID]"  Example:
      `"projects/12345/traceSinks/my-sink-id"`.
    traceSink: A TraceSink resource to be passed as the request body.
    updateMask: Required. Field mask that specifies the fields in `trace_sink`
      that are to be updated. A sink field is overwritten if, and only if, it
      is in the update mask.  `name` and `writer_identity` fields cannot be
      updated.  An empty updateMask is considered an error.  For a detailed
      `FieldMask` definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask  Example:
      `updateMask=output_config`.
  """

  name = _messages.StringField(1, required=True)
  traceSink = _messages.MessageField('TraceSink', 2)
  updateMask = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ListTraceSinksResponse(_messages.Message):
  r"""Result returned from `ListTraceSinks`.

  Fields:
    nextPageToken: If there might be more results than appear in this
      response, then `nextPageToken` is included.  To get the next set of
      results, call the same method again using the value of `nextPageToken`
      as `pageToken`.
    sinks: A list of sinks.
  """

  nextPageToken = _messages.StringField(1)
  sinks = _messages.MessageField('TraceSink', 2, repeated=True)


class OutputConfig(_messages.Message):
  r"""OutputConfig contains a destination for writing trace data.

  Fields:
    destination: The destination for writing trace data. Currently only
      BigQuery is supported. E.g.:
      "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
  """

  destination = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TraceSink(_messages.Message):
  r"""Describes a sink used to export traces to a BigQuery dataset. The sink
  must be created within a project.

  Fields:
    name: Required. The canonical sink resource name, unique within the
      project. Must be of the form:
      project/[PROJECT_NUMBER]/traceSinks/[SINK_ID].  E.g.:
      `"projects/12345/traceSinks/my-project-trace-sink"`.  Sink identifiers
      are limited to 256 characters and can include only the following
      characters: upper and lower-case alphanumeric characters, underscores,
      hyphens, and periods.
    outputConfig: Required. The export destination.
    writerIdentity: Output only. A service account name for exporting the
      data. This field is set by sinks.create and sinks.update. The service
      account will need to be granted write access to the destination
      specified in the output configuration, see [Granting access for a
      resource](/iam/docs/granting-roles-to-service-
      accounts#granting_access_to_a_service_account_for_a_resource). To create
      tables and write data this account will need the dataEditor role. Read
      more about roles in the [BigQuery
      documentation](https://cloud.google.com/bigquery/docs/access-control).
      E.g.:     "service-00000001@00000002.iam.gserviceaccount.com"
  """

  name = _messages.StringField(1)
  outputConfig = _messages.MessageField('OutputConfig', 2)
  writerIdentity = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
