/*!
 * Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  root["Bokeh"] = factory();
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (parent_require && externals[id]) {
              try {
                mod = {exports: parent_require(id)};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }

    var main = require(entry);
    main.require = require;

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
/* legacy.js */ function _(require, module, exports) {
    function __export(m) {
        for (var p in m)
            if (!exports.hasOwnProperty(p))
                exports[p] = m[p];
    }
    require(1) /* ./polyfill */;
    __export(require(102) /* ./main */);
},
/* polyfill.js */ function _(require, module, exports) {
    require(2) /* es5-ext/object/assign/implement */;
    require(11) /* es5-ext/number/is-integer/implement */;
    require(14) /* es5-ext/string/#/repeat/implement */;
    require(21) /* es5-ext/array/from/implement */;
    require(49) /* es5-ext/math/log10/implement */;
    require(52) /* es6-set/implement */;
    require(87) /* es6-map/implement */;
    require(94) /* es6-weak-map/implement */;
    require(100) /* es6-promise/auto */;
},
/* es5-ext/object/assign/implement.js */ function _(require, module, exports) {
    if (!require(3) /* ./is-implemented */()) {
        Object.defineProperty(Object, "assign", {
            value: require(4) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/object/assign/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var assign = Object.assign, obj;
        if (typeof assign !== "function")
            return false;
        obj = { foo: "raz" };
        assign(obj, { bar: "dwa" }, { trzy: "trzy" });
        return obj.foo + obj.bar + obj.trzy === "razdwatrzy";
    };
},
/* es5-ext/object/assign/shim.js */ function _(require, module, exports) {
    var keys = require(5) /* ../keys */, value = require(10) /* ../valid-value */, max = Math.max;
    module.exports = function (dest, src /*, …srcn*/) {
        var error, i, length = max(arguments.length, 2), assign;
        dest = Object(value(dest));
        assign = function (key) {
            try {
                dest[key] = src[key];
            }
            catch (e) {
                if (!error)
                    error = e;
            }
        };
        for (i = 1; i < length; ++i) {
            src = arguments[i];
            keys(src).forEach(assign);
        }
        if (error !== undefined)
            throw error;
        return dest;
    };
},
/* es5-ext/object/keys/index.js */ function _(require, module, exports) {
    module.exports = require(6) /* ./is-implemented */() ? Object.keys : require(7) /* ./shim */;
},
/* es5-ext/object/keys/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        try {
            Object.keys("primitive");
            return true;
        }
        catch (e) {
            return false;
        }
    };
},
/* es5-ext/object/keys/shim.js */ function _(require, module, exports) {
    var isValue = require(8) /* ../is-value */;
    var keys = Object.keys;
    module.exports = function (object) { return keys(isValue(object) ? Object(object) : object); };
},
/* es5-ext/object/is-value.js */ function _(require, module, exports) {
    var _undefined = require(9) /* ../function/noop */(); // Support ES3 engines
    module.exports = function (val) { return val !== _undefined && val !== null; };
},
/* es5-ext/function/noop.js */ function _(require, module, exports) {
    // eslint-disable-next-line no-empty-function
    module.exports = function () { };
},
/* es5-ext/object/valid-value.js */ function _(require, module, exports) {
    var isValue = require(8) /* ./is-value */;
    module.exports = function (value) {
        if (!isValue(value))
            throw new TypeError("Cannot use null or undefined");
        return value;
    };
},
/* es5-ext/number/is-integer/implement.js */ function _(require, module, exports) {
    if (!require(12) /* ./is-implemented */()) {
        Object.defineProperty(Number, "isInteger", {
            value: require(13) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/number/is-integer/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var isInteger = Number.isInteger;
        if (typeof isInteger !== "function")
            return false;
        return !isInteger("23") && isInteger(34) && !isInteger(32.34);
    };
},
/* es5-ext/number/is-integer/shim.js */ function _(require, module, exports) {
    module.exports = function (value) {
        if (typeof value !== "number")
            return false;
        return value % 1 === 0;
    };
},
/* es5-ext/string/#/repeat/implement.js */ function _(require, module, exports) {
    if (!require(15) /* ./is-implemented */()) {
        Object.defineProperty(String.prototype, "repeat", {
            value: require(16) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/string/#/repeat/is-implemented.js */ function _(require, module, exports) {
    var str = "foo";
    module.exports = function () {
        if (typeof str.repeat !== "function")
            return false;
        return str.repeat(2) === "foofoo";
    };
},
/* es5-ext/string/#/repeat/shim.js */ function _(require, module, exports) {
    var value = require(10) /* ../../../object/valid-value */, toInteger = require(17) /* ../../../number/to-integer */;
    module.exports = function (count) {
        var str = String(value(this)), result;
        count = toInteger(count);
        if (count < 0)
            throw new RangeError("Count must be >= 0");
        if (!isFinite(count))
            throw new RangeError("Count must be < ∞");
        result = "";
        while (count) {
            if (count % 2)
                result += str;
            if (count > 1)
                str += str;
            // eslint-disable-next-line no-bitwise
            count >>= 1;
        }
        return result;
    };
},
/* es5-ext/number/to-integer.js */ function _(require, module, exports) {
    var sign = require(18) /* ../math/sign */, abs = Math.abs, floor = Math.floor;
    module.exports = function (value) {
        if (isNaN(value))
            return 0;
        value = Number(value);
        if (value === 0 || !isFinite(value))
            return value;
        return sign(value) * floor(abs(value));
    };
},
/* es5-ext/math/sign/index.js */ function _(require, module, exports) {
    module.exports = require(19) /* ./is-implemented */() ? Math.sign : require(20) /* ./shim */;
},
/* es5-ext/math/sign/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var sign = Math.sign;
        if (typeof sign !== "function")
            return false;
        return sign(10) === 1 && sign(-20) === -1;
    };
},
/* es5-ext/math/sign/shim.js */ function _(require, module, exports) {
    module.exports = function (value) {
        value = Number(value);
        if (isNaN(value) || value === 0)
            return value;
        return value > 0 ? 1 : -1;
    };
},
/* es5-ext/array/from/implement.js */ function _(require, module, exports) {
    if (!require(22) /* ./is-implemented */()) {
        Object.defineProperty(Array, "from", {
            value: require(23) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/array/from/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var from = Array.from, arr, result;
        if (typeof from !== "function")
            return false;
        arr = ["raz", "dwa"];
        result = from(arr);
        return Boolean(result && result !== arr && result[1] === "dwa");
    };
},
/* es5-ext/array/from/shim.js */ function _(require, module, exports) {
    var iteratorSymbol = require(24) /* es6-symbol */.iterator, isArguments = require(44) /* ../../function/is-arguments */, isFunction = require(45) /* ../../function/is-function */, toPosInt = require(46) /* ../../number/to-pos-integer */, callable = require(47) /* ../../object/valid-callable */, validValue = require(10) /* ../../object/valid-value */, isValue = require(8) /* ../../object/is-value */, isString = require(48) /* ../../string/is-string */, isArray = Array.isArray, call = Function.prototype.call, desc = { configurable: true, enumerable: true, writable: true, value: null }, defineProperty = Object.defineProperty;
    // eslint-disable-next-line complexity, max-lines-per-function
    module.exports = function (arrayLike /*, mapFn, thisArg*/) {
        var mapFn = arguments[1], thisArg = arguments[2], Context, i, j, arr, length, code, iterator, result, getIterator, value;
        arrayLike = Object(validValue(arrayLike));
        if (isValue(mapFn))
            callable(mapFn);
        if (!this || this === Array || !isFunction(this)) {
            // Result: Plain array
            if (!mapFn) {
                if (isArguments(arrayLike)) {
                    // Source: Arguments
                    length = arrayLike.length;
                    if (length !== 1)
                        return Array.apply(null, arrayLike);
                    arr = new Array(1);
                    arr[0] = arrayLike[0];
                    return arr;
                }
                if (isArray(arrayLike)) {
                    // Source: Array
                    arr = new Array((length = arrayLike.length));
                    for (i = 0; i < length; ++i)
                        arr[i] = arrayLike[i];
                    return arr;
                }
            }
            arr = [];
        }
        else {
            // Result: Non plain array
            Context = this;
        }
        if (!isArray(arrayLike)) {
            if ((getIterator = arrayLike[iteratorSymbol]) !== undefined) {
                // Source: Iterator
                iterator = callable(getIterator).call(arrayLike);
                if (Context)
                    arr = new Context();
                result = iterator.next();
                i = 0;
                while (!result.done) {
                    value = mapFn ? call.call(mapFn, thisArg, result.value, i) : result.value;
                    if (Context) {
                        desc.value = value;
                        defineProperty(arr, i, desc);
                    }
                    else {
                        arr[i] = value;
                    }
                    result = iterator.next();
                    ++i;
                }
                length = i;
            }
            else if (isString(arrayLike)) {
                // Source: String
                length = arrayLike.length;
                if (Context)
                    arr = new Context();
                for (i = 0, j = 0; i < length; ++i) {
                    value = arrayLike[i];
                    if (i + 1 < length) {
                        code = value.charCodeAt(0);
                        // eslint-disable-next-line max-depth
                        if (code >= 0xd800 && code <= 0xdbff)
                            value += arrayLike[++i];
                    }
                    value = mapFn ? call.call(mapFn, thisArg, value, j) : value;
                    if (Context) {
                        desc.value = value;
                        defineProperty(arr, j, desc);
                    }
                    else {
                        arr[j] = value;
                    }
                    ++j;
                }
                length = j;
            }
        }
        if (length === undefined) {
            // Source: array or array-like
            length = toPosInt(arrayLike.length);
            if (Context)
                arr = new Context(length);
            for (i = 0; i < length; ++i) {
                value = mapFn ? call.call(mapFn, thisArg, arrayLike[i], i) : arrayLike[i];
                if (Context) {
                    desc.value = value;
                    defineProperty(arr, i, desc);
                }
                else {
                    arr[i] = value;
                }
            }
        }
        if (Context) {
            desc.value = null;
            arr.length = length;
        }
        return arr;
    };
},
/* es6-symbol/index.js */ function _(require, module, exports) {
    module.exports = require(25) /* ./is-implemented */()
        ? require(26) /* es5-ext/global */.Symbol
        : require(27) /* ./polyfill */;
},
/* es6-symbol/is-implemented.js */ function _(require, module, exports) {
    var global = require(26) /* es5-ext/global */, validTypes = { object: true, symbol: true };
    module.exports = function () {
        var Symbol = global.Symbol;
        var symbol;
        if (typeof Symbol !== "function")
            return false;
        symbol = Symbol("test symbol");
        try {
            String(symbol);
        }
        catch (e) {
            return false;
        }
        // Return 'true' also for polyfills
        if (!validTypes[typeof Symbol.iterator])
            return false;
        if (!validTypes[typeof Symbol.toPrimitive])
            return false;
        if (!validTypes[typeof Symbol.toStringTag])
            return false;
        return true;
    };
},
/* es5-ext/global.js */ function _(require, module, exports) {
    module.exports = (function () {
        if (this)
            return this;
        // Unexpected strict mode (may happen if e.g. bundled into ESM module), be nice
        // Thanks @mathiasbynens -> https://mathiasbynens.be/notes/globalthis
        // In all ES5+ engines global object inherits from Object.prototype
        // (if you approached one that doesn't please report)
        Object.defineProperty(Object.prototype, "__global__", {
            get: function () { return this; },
            configurable: true
        });
        try {
            return __global__;
        }
        finally {
            delete Object.prototype.__global__;
        }
    })();
},
/* es6-symbol/polyfill.js */ function _(require, module, exports) {
    var d = require(28) /* d */, validateSymbol = require(39) /* ./validate-symbol */, NativeSymbol = require(26) /* es5-ext/global */.Symbol, generateName = require(41) /* ./lib/private/generate-name */, setupStandardSymbols = require(42) /* ./lib/private/setup/standard-symbols */, setupSymbolRegistry = require(43) /* ./lib/private/setup/symbol-registry */;
    var create = Object.create, defineProperties = Object.defineProperties, defineProperty = Object.defineProperty;
    var SymbolPolyfill, HiddenSymbol, isNativeSafe;
    if (typeof NativeSymbol === "function") {
        try {
            String(NativeSymbol());
            isNativeSafe = true;
        }
        catch (ignore) { }
    }
    else {
        NativeSymbol = null;
    }
    // Internal constructor (not one exposed) for creating Symbol instances.
    // This one is used to ensure that `someSymbol instanceof Symbol` always return false
    HiddenSymbol = function Symbol(description) {
        if (this instanceof HiddenSymbol)
            throw new TypeError("Symbol is not a constructor");
        return SymbolPolyfill(description);
    };
    // Exposed `Symbol` constructor
    // (returns instances of HiddenSymbol)
    module.exports = SymbolPolyfill = function Symbol(description) {
        var symbol;
        if (this instanceof Symbol)
            throw new TypeError("Symbol is not a constructor");
        if (isNativeSafe)
            return NativeSymbol(description);
        symbol = create(HiddenSymbol.prototype);
        description = description === undefined ? "" : String(description);
        return defineProperties(symbol, {
            __description__: d("", description),
            __name__: d("", generateName(description))
        });
    };
    setupStandardSymbols(SymbolPolyfill);
    setupSymbolRegistry(SymbolPolyfill);
    // Internal tweaks for real symbol producer
    defineProperties(HiddenSymbol.prototype, {
        constructor: d(SymbolPolyfill),
        toString: d("", function () { return this.__name__; })
    });
    // Proper implementation of methods exposed on Symbol.prototype
    // They won't be accessible on produced symbol instances as they derive from HiddenSymbol.prototype
    defineProperties(SymbolPolyfill.prototype, {
        toString: d(function () { return "Symbol (" + validateSymbol(this).__description__ + ")"; }),
        valueOf: d(function () { return validateSymbol(this); })
    });
    defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toPrimitive, d("", function () {
        var symbol = validateSymbol(this);
        if (typeof symbol === "symbol")
            return symbol;
        return symbol.toString();
    }));
    defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toStringTag, d("c", "Symbol"));
    // Proper implementaton of toPrimitive and toStringTag for returned symbol instances
    defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toStringTag, d("c", SymbolPolyfill.prototype[SymbolPolyfill.toStringTag]));
    // Note: It's important to define `toPrimitive` as last one, as some implementations
    // implement `toPrimitive` natively without implementing `toStringTag` (or other specified symbols)
    // And that may invoke error in definition flow:
    // See: https://github.com/medikoo/es6-symbol/issues/13#issuecomment-164146149
    defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toPrimitive, d("c", SymbolPolyfill.prototype[SymbolPolyfill.toPrimitive]));
},
/* d/index.js */ function _(require, module, exports) {
    var isValue = require(29) /* type/value/is */, isPlainFunction = require(30) /* type/plain-function/is */, assign = require(34) /* es5-ext/object/assign */, normalizeOpts = require(35) /* es5-ext/object/normalize-options */, contains = require(36) /* es5-ext/string/#/contains */;
    var d = (module.exports = function (dscr, value /*, options*/) {
        var c, e, w, options, desc;
        if (arguments.length < 2 || typeof dscr !== "string") {
            options = value;
            value = dscr;
            dscr = null;
        }
        else {
            options = arguments[2];
        }
        if (isValue(dscr)) {
            c = contains.call(dscr, "c");
            e = contains.call(dscr, "e");
            w = contains.call(dscr, "w");
        }
        else {
            c = w = true;
            e = false;
        }
        desc = { value: value, configurable: c, enumerable: e, writable: w };
        return !options ? desc : assign(normalizeOpts(options), desc);
    });
    d.gs = function (dscr, get, set /*, options*/) {
        var c, e, options, desc;
        if (typeof dscr !== "string") {
            options = set;
            set = get;
            get = dscr;
            dscr = null;
        }
        else {
            options = arguments[3];
        }
        if (!isValue(get)) {
            get = undefined;
        }
        else if (!isPlainFunction(get)) {
            options = get;
            get = set = undefined;
        }
        else if (!isValue(set)) {
            set = undefined;
        }
        else if (!isPlainFunction(set)) {
            options = set;
            set = undefined;
        }
        if (isValue(dscr)) {
            c = contains.call(dscr, "c");
            e = contains.call(dscr, "e");
        }
        else {
            c = true;
            e = false;
        }
        desc = { get: get, set: set, configurable: c, enumerable: e };
        return !options ? desc : assign(normalizeOpts(options), desc);
    };
},
/* type/value/is.js */ function _(require, module, exports) {
    // ES3 safe
    var _undefined = void 0;
    module.exports = function (value) { return value !== _undefined && value !== null; };
},
/* type/plain-function/is.js */ function _(require, module, exports) {
    var isFunction = require(31) /* ../function/is */;
    var classRe = /^\s*class[\s{/}]/, functionToString = Function.prototype.toString;
    module.exports = function (value) {
        if (!isFunction(value))
            return false;
        if (classRe.test(functionToString.call(value)))
            return false;
        return true;
    };
},
/* type/function/is.js */ function _(require, module, exports) {
    var isPrototype = require(32) /* ../prototype/is */;
    module.exports = function (value) {
        if (typeof value !== "function")
            return false;
        if (!hasOwnProperty.call(value, "length"))
            return false;
        try {
            if (typeof value.length !== "number")
                return false;
            if (typeof value.call !== "function")
                return false;
            if (typeof value.apply !== "function")
                return false;
        }
        catch (error) {
            return false;
        }
        return !isPrototype(value);
    };
},
/* type/prototype/is.js */ function _(require, module, exports) {
    var isObject = require(33) /* ../object/is */;
    module.exports = function (value) {
        if (!isObject(value))
            return false;
        try {
            if (!value.constructor)
                return false;
            return value.constructor.prototype === value;
        }
        catch (error) {
            return false;
        }
    };
},
/* type/object/is.js */ function _(require, module, exports) {
    var isValue = require(29) /* ../value/is */;
    // prettier-ignore
    var possibleTypes = { "object": true, "function": true, "undefined": true /* document.all */ };
    module.exports = function (value) {
        if (!isValue(value))
            return false;
        return hasOwnProperty.call(possibleTypes, typeof value);
    };
},
/* es5-ext/object/assign/index.js */ function _(require, module, exports) {
    module.exports = require(3) /* ./is-implemented */() ? Object.assign : require(4) /* ./shim */;
},
/* es5-ext/object/normalize-options.js */ function _(require, module, exports) {
    var isValue = require(8) /* ./is-value */;
    var forEach = Array.prototype.forEach, create = Object.create;
    var process = function (src, obj) {
        var key;
        for (key in src)
            obj[key] = src[key];
    };
    // eslint-disable-next-line no-unused-vars
    module.exports = function (opts1 /*, …options*/) {
        var result = create(null);
        forEach.call(arguments, function (options) {
            if (!isValue(options))
                return;
            process(Object(options), result);
        });
        return result;
    };
},
/* es5-ext/string/#/contains/index.js */ function _(require, module, exports) {
    module.exports = require(37) /* ./is-implemented */() ? String.prototype.contains : require(38) /* ./shim */;
},
/* es5-ext/string/#/contains/is-implemented.js */ function _(require, module, exports) {
    var str = "razdwatrzy";
    module.exports = function () {
        if (typeof str.contains !== "function")
            return false;
        return str.contains("dwa") === true && str.contains("foo") === false;
    };
},
/* es5-ext/string/#/contains/shim.js */ function _(require, module, exports) {
    var indexOf = String.prototype.indexOf;
    module.exports = function (searchString /*, position*/) {
        return indexOf.call(this, searchString, arguments[1]) > -1;
    };
},
/* es6-symbol/validate-symbol.js */ function _(require, module, exports) {
    var isSymbol = require(40) /* ./is-symbol */;
    module.exports = function (value) {
        if (!isSymbol(value))
            throw new TypeError(value + " is not a symbol");
        return value;
    };
},
/* es6-symbol/is-symbol.js */ function _(require, module, exports) {
    module.exports = function (value) {
        if (!value)
            return false;
        if (typeof value === "symbol")
            return true;
        if (!value.constructor)
            return false;
        if (value.constructor.name !== "Symbol")
            return false;
        return value[value.constructor.toStringTag] === "Symbol";
    };
},
/* es6-symbol/lib/private/generate-name.js */ function _(require, module, exports) {
    var d = require(28) /* d */;
    var create = Object.create, defineProperty = Object.defineProperty, objPrototype = Object.prototype;
    var created = create(null);
    module.exports = function (desc) {
        var postfix = 0, name, ie11BugWorkaround;
        while (created[desc + (postfix || "")])
            ++postfix;
        desc += postfix || "";
        created[desc] = true;
        name = "@@" + desc;
        defineProperty(objPrototype, name, d.gs(null, function (value) {
            // For IE11 issue see:
            // https://connect.microsoft.com/IE/feedbackdetail/view/1928508/
            //    ie11-broken-getters-on-dom-objects
            // https://github.com/medikoo/es6-symbol/issues/12
            if (ie11BugWorkaround)
                return;
            ie11BugWorkaround = true;
            defineProperty(this, name, d(value));
            ie11BugWorkaround = false;
        }));
        return name;
    };
},
/* es6-symbol/lib/private/setup/standard-symbols.js */ function _(require, module, exports) {
    var d = require(28) /* d */, NativeSymbol = require(26) /* es5-ext/global */.Symbol;
    module.exports = function (SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
            // To ensure proper interoperability with other native functions (e.g. Array.from)
            // fallback to eventual native implementation of given symbol
            hasInstance: d("", (NativeSymbol && NativeSymbol.hasInstance) || SymbolPolyfill("hasInstance")),
            isConcatSpreadable: d("", (NativeSymbol && NativeSymbol.isConcatSpreadable) ||
                SymbolPolyfill("isConcatSpreadable")),
            iterator: d("", (NativeSymbol && NativeSymbol.iterator) || SymbolPolyfill("iterator")),
            match: d("", (NativeSymbol && NativeSymbol.match) || SymbolPolyfill("match")),
            replace: d("", (NativeSymbol && NativeSymbol.replace) || SymbolPolyfill("replace")),
            search: d("", (NativeSymbol && NativeSymbol.search) || SymbolPolyfill("search")),
            species: d("", (NativeSymbol && NativeSymbol.species) || SymbolPolyfill("species")),
            split: d("", (NativeSymbol && NativeSymbol.split) || SymbolPolyfill("split")),
            toPrimitive: d("", (NativeSymbol && NativeSymbol.toPrimitive) || SymbolPolyfill("toPrimitive")),
            toStringTag: d("", (NativeSymbol && NativeSymbol.toStringTag) || SymbolPolyfill("toStringTag")),
            unscopables: d("", (NativeSymbol && NativeSymbol.unscopables) || SymbolPolyfill("unscopables"))
        });
    };
},
/* es6-symbol/lib/private/setup/symbol-registry.js */ function _(require, module, exports) {
    var d = require(28) /* d */, validateSymbol = require(39) /* ../../../validate-symbol */;
    var registry = Object.create(null);
    module.exports = function (SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
            for: d(function (key) {
                if (registry[key])
                    return registry[key];
                return (registry[key] = SymbolPolyfill(String(key)));
            }),
            keyFor: d(function (symbol) {
                var key;
                validateSymbol(symbol);
                for (key in registry) {
                    if (registry[key] === symbol)
                        return key;
                }
                return undefined;
            })
        });
    };
},
/* es5-ext/function/is-arguments.js */ function _(require, module, exports) {
    var objToString = Object.prototype.toString, id = objToString.call((function () { return arguments; })());
    module.exports = function (value) { return objToString.call(value) === id; };
},
/* es5-ext/function/is-function.js */ function _(require, module, exports) {
    var objToString = Object.prototype.toString, isFunctionStringTag = RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);
    module.exports = function (value) {
        return typeof value === "function" && isFunctionStringTag(objToString.call(value));
    };
},
/* es5-ext/number/to-pos-integer.js */ function _(require, module, exports) {
    var toInteger = require(17) /* ./to-integer */, max = Math.max;
    module.exports = function (value) { return max(0, toInteger(value)); };
},
/* es5-ext/object/valid-callable.js */ function _(require, module, exports) {
    module.exports = function (fn) {
        if (typeof fn !== "function")
            throw new TypeError(fn + " is not a function");
        return fn;
    };
},
/* es5-ext/string/is-string.js */ function _(require, module, exports) {
    var objToString = Object.prototype.toString, id = objToString.call("");
    module.exports = function (value) {
        return (typeof value === "string" ||
            (value &&
                typeof value === "object" &&
                (value instanceof String || objToString.call(value) === id)) ||
            false);
    };
},
/* es5-ext/math/log10/implement.js */ function _(require, module, exports) {
    if (!require(50) /* ./is-implemented */()) {
        Object.defineProperty(Math, "log10", {
            value: require(51) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/math/log10/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var log10 = Math.log10;
        if (typeof log10 !== "function")
            return false;
        return log10(2) === 0.3010299956639812;
    };
},
/* es5-ext/math/log10/shim.js */ function _(require, module, exports) {
    var log = Math.log, LOG10E = Math.LOG10E;
    module.exports = function (value) {
        if (isNaN(value))
            return NaN;
        value = Number(value);
        if (value < 0)
            return NaN;
        if (value === 0)
            return -Infinity;
        if (value === 1)
            return 0;
        if (value === Infinity)
            return Infinity;
        return log(value) * LOG10E;
    };
},
/* es6-set/implement.js */ function _(require, module, exports) {
    if (!require(53) /* ./is-implemented */()) {
        Object.defineProperty(require(26) /* es5-ext/global */, 'Set', { value: require(54) /* ./polyfill */, configurable: true, enumerable: false,
            writable: true });
    }
},
/* es6-set/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var set, iterator, result;
        if (typeof Set !== 'function')
            return false;
        set = new Set(['raz', 'dwa', 'trzy']);
        if (String(set) !== '[object Set]')
            return false;
        if (set.size !== 3)
            return false;
        if (typeof set.add !== 'function')
            return false;
        if (typeof set.clear !== 'function')
            return false;
        if (typeof set.delete !== 'function')
            return false;
        if (typeof set.entries !== 'function')
            return false;
        if (typeof set.forEach !== 'function')
            return false;
        if (typeof set.has !== 'function')
            return false;
        if (typeof set.keys !== 'function')
            return false;
        if (typeof set.values !== 'function')
            return false;
        iterator = set.values();
        result = iterator.next();
        if (result.done !== false)
            return false;
        if (result.value !== 'raz')
            return false;
        return true;
    };
},
/* es6-set/polyfill.js */ function _(require, module, exports) {
    var clear = require(55) /* es5-ext/array/#/clear */, eIndexOf = require(56) /* es5-ext/array/#/e-index-of */, setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, callable = require(47) /* es5-ext/object/valid-callable */, d = require(28) /* d */, ee = require(65) /* event-emitter */, Symbol = require(24) /* es6-symbol */, iterator = require(66) /* es6-iterator/valid-iterable */, forOf = require(68) /* es6-iterator/for-of */, Iterator = require(85) /* ./lib/iterator */, isNative = require(86) /* ./is-native-implemented */, call = Function.prototype.call, defineProperty = Object.defineProperty, getPrototypeOf = Object.getPrototypeOf, SetPoly, getValues, NativeSet;
    if (isNative)
        NativeSet = Set;
    module.exports = SetPoly = function Set( /*iterable*/) {
        var iterable = arguments[0], self;
        if (!(this instanceof SetPoly))
            throw new TypeError('Constructor requires \'new\'');
        if (isNative && setPrototypeOf)
            self = setPrototypeOf(new NativeSet(), getPrototypeOf(this));
        else
            self = this;
        if (iterable != null)
            iterator(iterable);
        defineProperty(self, '__setData__', d('c', []));
        if (!iterable)
            return self;
        forOf(iterable, function (value) {
            if (eIndexOf.call(this, value) !== -1)
                return;
            this.push(value);
        }, self.__setData__);
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(SetPoly, NativeSet);
        SetPoly.prototype = Object.create(NativeSet.prototype, { constructor: d(SetPoly) });
    }
    ee(Object.defineProperties(SetPoly.prototype, {
        add: d(function (value) {
            if (this.has(value))
                return this;
            this.emit('_add', this.__setData__.push(value) - 1, value);
            return this;
        }),
        clear: d(function () {
            if (!this.__setData__.length)
                return;
            clear.call(this.__setData__);
            this.emit('_clear');
        }),
        delete: d(function (value) {
            var index = eIndexOf.call(this.__setData__, value);
            if (index === -1)
                return false;
            this.__setData__.splice(index, 1);
            this.emit('_delete', index, value);
            return true;
        }),
        entries: d(function () { return new Iterator(this, 'key+value'); }),
        forEach: d(function (cb /*, thisArg*/) {
            var thisArg = arguments[1], iterator, result, value;
            callable(cb);
            iterator = this.values();
            result = iterator._next();
            while (result !== undefined) {
                value = iterator._resolve(result);
                call.call(cb, thisArg, value, value, this);
                result = iterator._next();
            }
        }),
        has: d(function (value) {
            return (eIndexOf.call(this.__setData__, value) !== -1);
        }),
        keys: d(getValues = function () { return this.values(); }),
        size: d.gs(function () { return this.__setData__.length; }),
        values: d(function () { return new Iterator(this); }),
        toString: d(function () { return '[object Set]'; })
    }));
    defineProperty(SetPoly.prototype, Symbol.iterator, d(getValues));
    defineProperty(SetPoly.prototype, Symbol.toStringTag, d('c', 'Set'));
},
/* es5-ext/array/#/clear.js */ function _(require, module, exports) {
    var value = require(10) /* ../../object/valid-value */;
    module.exports = function () {
        value(this).length = 0;
        return this;
    };
},
/* es5-ext/array/#/e-index-of.js */ function _(require, module, exports) {
    var numberIsNaN = require(57) /* ../../number/is-nan */, toPosInt = require(46) /* ../../number/to-pos-integer */, value = require(10) /* ../../object/valid-value */, indexOf = Array.prototype.indexOf, objHasOwnProperty = Object.prototype.hasOwnProperty, abs = Math.abs, floor = Math.floor;
    module.exports = function (searchElement /*, fromIndex*/) {
        var i, length, fromIndex, val;
        if (!numberIsNaN(searchElement))
            return indexOf.apply(this, arguments);
        length = toPosInt(value(this).length);
        fromIndex = arguments[1];
        if (isNaN(fromIndex))
            fromIndex = 0;
        else if (fromIndex >= 0)
            fromIndex = floor(fromIndex);
        else
            fromIndex = toPosInt(this.length) - floor(abs(fromIndex));
        for (i = fromIndex; i < length; ++i) {
            if (objHasOwnProperty.call(this, i)) {
                val = this[i];
                if (numberIsNaN(val))
                    return i; // Jslint: ignore
            }
        }
        return -1;
    };
},
/* es5-ext/number/is-nan/index.js */ function _(require, module, exports) {
    module.exports = require(58) /* ./is-implemented */() ? Number.isNaN : require(59) /* ./shim */;
},
/* es5-ext/number/is-nan/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var numberIsNaN = Number.isNaN;
        if (typeof numberIsNaN !== "function")
            return false;
        return !numberIsNaN({}) && numberIsNaN(NaN) && !numberIsNaN(34);
    };
},
/* es5-ext/number/is-nan/shim.js */ function _(require, module, exports) {
    module.exports = function (value) {
        // eslint-disable-next-line no-self-compare
        return value !== value;
    };
},
/* es5-ext/object/set-prototype-of/index.js */ function _(require, module, exports) {
    module.exports = require(61) /* ./is-implemented */() ? Object.setPrototypeOf : require(62) /* ./shim */;
},
/* es5-ext/object/set-prototype-of/is-implemented.js */ function _(require, module, exports) {
    var create = Object.create, getPrototypeOf = Object.getPrototypeOf, plainObject = {};
    module.exports = function ( /* CustomCreate*/) {
        var setPrototypeOf = Object.setPrototypeOf, customCreate = arguments[0] || create;
        if (typeof setPrototypeOf !== "function")
            return false;
        return getPrototypeOf(setPrototypeOf(customCreate(null), plainObject)) === plainObject;
    };
},
/* es5-ext/object/set-prototype-of/shim.js */ function _(require, module, exports) {
    var isObject = require(63) /* ../is-object */, value = require(10) /* ../valid-value */, objIsPrototypeOf = Object.prototype.isPrototypeOf, defineProperty = Object.defineProperty, nullDesc = { configurable: true, enumerable: false, writable: true, value: undefined }, validate;
    validate = function (obj, prototype) {
        value(obj);
        if (prototype === null || isObject(prototype))
            return obj;
        throw new TypeError("Prototype must be null or an object");
    };
    module.exports = (function (status) {
        var fn, set;
        if (!status)
            return null;
        if (status.level === 2) {
            if (status.set) {
                set = status.set;
                fn = function (obj, prototype) {
                    set.call(validate(obj, prototype), prototype);
                    return obj;
                };
            }
            else {
                fn = function (obj, prototype) {
                    validate(obj, prototype).__proto__ = prototype;
                    return obj;
                };
            }
        }
        else {
            fn = function self(obj, prototype) {
                var isNullBase;
                validate(obj, prototype);
                isNullBase = objIsPrototypeOf.call(self.nullPolyfill, obj);
                if (isNullBase)
                    delete self.nullPolyfill.__proto__;
                if (prototype === null)
                    prototype = self.nullPolyfill;
                obj.__proto__ = prototype;
                if (isNullBase)
                    defineProperty(self.nullPolyfill, "__proto__", nullDesc);
                return obj;
            };
        }
        return Object.defineProperty(fn, "level", {
            configurable: false,
            enumerable: false,
            writable: false,
            value: status.level
        });
    })((function () {
        var tmpObj1 = Object.create(null), tmpObj2 = {}, set, desc = Object.getOwnPropertyDescriptor(Object.prototype, "__proto__");
        if (desc) {
            try {
                set = desc.set; // Opera crashes at this point
                set.call(tmpObj1, tmpObj2);
            }
            catch (ignore) { }
            if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
                return { set: set, level: 2 };
        }
        tmpObj1.__proto__ = tmpObj2;
        if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
            return { level: 2 };
        tmpObj1 = {};
        tmpObj1.__proto__ = tmpObj2;
        if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
            return { level: 1 };
        return false;
    })());
    require(64) /* ../create */;
},
/* es5-ext/object/is-object.js */ function _(require, module, exports) {
    var isValue = require(8) /* ./is-value */;
    var map = { function: true, object: true };
    module.exports = function (value) { return (isValue(value) && map[typeof value]) || false; };
},
/* es5-ext/object/create.js */ function _(require, module, exports) {
    var create = Object.create, shim;
    if (!require(61) /* ./set-prototype-of/is-implemented */()) {
        shim = require(62) /* ./set-prototype-of/shim */;
    }
    module.exports = (function () {
        var nullObject, polyProps, desc;
        if (!shim)
            return create;
        if (shim.level !== 1)
            return create;
        nullObject = {};
        polyProps = {};
        desc = { configurable: false, enumerable: false, writable: true, value: undefined };
        Object.getOwnPropertyNames(Object.prototype).forEach(function (name) {
            if (name === "__proto__") {
                polyProps[name] = {
                    configurable: true,
                    enumerable: false,
                    writable: true,
                    value: undefined
                };
                return;
            }
            polyProps[name] = desc;
        });
        Object.defineProperties(nullObject, polyProps);
        Object.defineProperty(shim, "nullPolyfill", {
            configurable: false,
            enumerable: false,
            writable: false,
            value: nullObject
        });
        return function (prototype, props) {
            return create(prototype === null ? nullObject : prototype, props);
        };
    })();
},
/* event-emitter/index.js */ function _(require, module, exports) {
    var d = require(28) /* d */, callable = require(47) /* es5-ext/object/valid-callable */, apply = Function.prototype.apply, call = Function.prototype.call, create = Object.create, defineProperty = Object.defineProperty, defineProperties = Object.defineProperties, hasOwnProperty = Object.prototype.hasOwnProperty, descriptor = { configurable: true, enumerable: false, writable: true }, on, once, off, emit, methods, descriptors, base;
    on = function (type, listener) {
        var data;
        callable(listener);
        if (!hasOwnProperty.call(this, '__ee__')) {
            data = descriptor.value = create(null);
            defineProperty(this, '__ee__', descriptor);
            descriptor.value = null;
        }
        else {
            data = this.__ee__;
        }
        if (!data[type])
            data[type] = listener;
        else if (typeof data[type] === 'object')
            data[type].push(listener);
        else
            data[type] = [data[type], listener];
        return this;
    };
    once = function (type, listener) {
        var once, self;
        callable(listener);
        self = this;
        on.call(this, type, once = function () {
            off.call(self, type, once);
            apply.call(listener, this, arguments);
        });
        once.__eeOnceListener__ = listener;
        return this;
    };
    off = function (type, listener) {
        var data, listeners, candidate, i;
        callable(listener);
        if (!hasOwnProperty.call(this, '__ee__'))
            return this;
        data = this.__ee__;
        if (!data[type])
            return this;
        listeners = data[type];
        if (typeof listeners === 'object') {
            for (i = 0; (candidate = listeners[i]); ++i) {
                if ((candidate === listener) ||
                    (candidate.__eeOnceListener__ === listener)) {
                    if (listeners.length === 2)
                        data[type] = listeners[i ? 0 : 1];
                    else
                        listeners.splice(i, 1);
                }
            }
        }
        else {
            if ((listeners === listener) ||
                (listeners.__eeOnceListener__ === listener)) {
                delete data[type];
            }
        }
        return this;
    };
    emit = function (type) {
        var i, l, listener, listeners, args;
        if (!hasOwnProperty.call(this, '__ee__'))
            return;
        listeners = this.__ee__[type];
        if (!listeners)
            return;
        if (typeof listeners === 'object') {
            l = arguments.length;
            args = new Array(l - 1);
            for (i = 1; i < l; ++i)
                args[i - 1] = arguments[i];
            listeners = listeners.slice();
            for (i = 0; (listener = listeners[i]); ++i) {
                apply.call(listener, this, args);
            }
        }
        else {
            switch (arguments.length) {
                case 1:
                    call.call(listeners, this);
                    break;
                case 2:
                    call.call(listeners, this, arguments[1]);
                    break;
                case 3:
                    call.call(listeners, this, arguments[1], arguments[2]);
                    break;
                default:
                    l = arguments.length;
                    args = new Array(l - 1);
                    for (i = 1; i < l; ++i) {
                        args[i - 1] = arguments[i];
                    }
                    apply.call(listeners, this, args);
            }
        }
    };
    methods = {
        on: on,
        once: once,
        off: off,
        emit: emit
    };
    descriptors = {
        on: d(on),
        once: d(once),
        off: d(off),
        emit: d(emit)
    };
    base = defineProperties({}, descriptors);
    module.exports = exports = function (o) {
        return (o == null) ? create(base) : defineProperties(Object(o), descriptors);
    };
    exports.methods = methods;
},
/* es6-iterator/valid-iterable.js */ function _(require, module, exports) {
    var isIterable = require(67) /* ./is-iterable */;
    module.exports = function (value) {
        if (!isIterable(value))
            throw new TypeError(value + " is not iterable");
        return value;
    };
},
/* es6-iterator/is-iterable.js */ function _(require, module, exports) {
    var isArguments = require(44) /* es5-ext/function/is-arguments */, isValue = require(8) /* es5-ext/object/is-value */, isString = require(48) /* es5-ext/string/is-string */;
    var iteratorSymbol = require(24) /* es6-symbol */.iterator, isArray = Array.isArray;
    module.exports = function (value) {
        if (!isValue(value))
            return false;
        if (isArray(value))
            return true;
        if (isString(value))
            return true;
        if (isArguments(value))
            return true;
        return typeof value[iteratorSymbol] === "function";
    };
},
/* es6-iterator/for-of.js */ function _(require, module, exports) {
    var isArguments = require(44) /* es5-ext/function/is-arguments */, callable = require(47) /* es5-ext/object/valid-callable */, isString = require(48) /* es5-ext/string/is-string */, get = require(69) /* ./get */;
    var isArray = Array.isArray, call = Function.prototype.call, some = Array.prototype.some;
    module.exports = function (iterable, cb /*, thisArg*/) {
        var mode, thisArg = arguments[2], result, doBreak, broken, i, length, char, code;
        if (isArray(iterable) || isArguments(iterable))
            mode = "array";
        else if (isString(iterable))
            mode = "string";
        else
            iterable = get(iterable);
        callable(cb);
        doBreak = function () {
            broken = true;
        };
        if (mode === "array") {
            some.call(iterable, function (value) {
                call.call(cb, thisArg, value, doBreak);
                return broken;
            });
            return;
        }
        if (mode === "string") {
            length = iterable.length;
            for (i = 0; i < length; ++i) {
                char = iterable[i];
                if (i + 1 < length) {
                    code = char.charCodeAt(0);
                    if (code >= 0xd800 && code <= 0xdbff)
                        char += iterable[++i];
                }
                call.call(cb, thisArg, char, doBreak);
                if (broken)
                    break;
            }
            return;
        }
        result = iterable.next();
        while (!result.done) {
            call.call(cb, thisArg, result.value, doBreak);
            if (broken)
                return;
            result = iterable.next();
        }
    };
},
/* es6-iterator/get.js */ function _(require, module, exports) {
    var isArguments = require(44) /* es5-ext/function/is-arguments */, isString = require(48) /* es5-ext/string/is-string */, ArrayIterator = require(70) /* ./array */, StringIterator = require(84) /* ./string */, iterable = require(66) /* ./valid-iterable */, iteratorSymbol = require(24) /* es6-symbol */.iterator;
    module.exports = function (obj) {
        if (typeof iterable(obj)[iteratorSymbol] === "function")
            return obj[iteratorSymbol]();
        if (isArguments(obj))
            return new ArrayIterator(obj);
        if (isString(obj))
            return new StringIterator(obj);
        return new ArrayIterator(obj);
    };
},
/* es6-iterator/array.js */ function _(require, module, exports) {
    var setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, contains = require(36) /* es5-ext/string/#/contains */, d = require(28) /* d */, Symbol = require(24) /* es6-symbol */, Iterator = require(71) /* ./ */;
    var defineProperty = Object.defineProperty, ArrayIterator;
    ArrayIterator = module.exports = function (arr, kind) {
        if (!(this instanceof ArrayIterator))
            throw new TypeError("Constructor requires 'new'");
        Iterator.call(this, arr);
        if (!kind)
            kind = "value";
        else if (contains.call(kind, "key+value"))
            kind = "key+value";
        else if (contains.call(kind, "key"))
            kind = "key";
        else
            kind = "value";
        defineProperty(this, "__kind__", d("", kind));
    };
    if (setPrototypeOf)
        setPrototypeOf(ArrayIterator, Iterator);
    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete ArrayIterator.prototype.constructor;
    ArrayIterator.prototype = Object.create(Iterator.prototype, {
        _resolve: d(function (i) {
            if (this.__kind__ === "value")
                return this.__list__[i];
            if (this.__kind__ === "key+value")
                return [i, this.__list__[i]];
            return i;
        })
    });
    defineProperty(ArrayIterator.prototype, Symbol.toStringTag, d("c", "Array Iterator"));
},
/* es6-iterator/index.js */ function _(require, module, exports) {
    var clear = require(55) /* es5-ext/array/#/clear */, assign = require(34) /* es5-ext/object/assign */, callable = require(47) /* es5-ext/object/valid-callable */, value = require(10) /* es5-ext/object/valid-value */, d = require(28) /* d */, autoBind = require(72) /* d/auto-bind */, Symbol = require(24) /* es6-symbol */;
    var defineProperty = Object.defineProperty, defineProperties = Object.defineProperties, Iterator;
    module.exports = Iterator = function (list, context) {
        if (!(this instanceof Iterator))
            throw new TypeError("Constructor requires 'new'");
        defineProperties(this, {
            __list__: d("w", value(list)),
            __context__: d("w", context),
            __nextIndex__: d("w", 0)
        });
        if (!context)
            return;
        callable(context.on);
        context.on("_add", this._onAdd);
        context.on("_delete", this._onDelete);
        context.on("_clear", this._onClear);
    };
    // Internal %IteratorPrototype% doesn't expose its constructor
    delete Iterator.prototype.constructor;
    defineProperties(Iterator.prototype, assign({
        _next: d(function () {
            var i;
            if (!this.__list__)
                return undefined;
            if (this.__redo__) {
                i = this.__redo__.shift();
                if (i !== undefined)
                    return i;
            }
            if (this.__nextIndex__ < this.__list__.length)
                return this.__nextIndex__++;
            this._unBind();
            return undefined;
        }),
        next: d(function () {
            return this._createResult(this._next());
        }),
        _createResult: d(function (i) {
            if (i === undefined)
                return { done: true, value: undefined };
            return { done: false, value: this._resolve(i) };
        }),
        _resolve: d(function (i) {
            return this.__list__[i];
        }),
        _unBind: d(function () {
            this.__list__ = null;
            delete this.__redo__;
            if (!this.__context__)
                return;
            this.__context__.off("_add", this._onAdd);
            this.__context__.off("_delete", this._onDelete);
            this.__context__.off("_clear", this._onClear);
            this.__context__ = null;
        }),
        toString: d(function () {
            return "[object " + (this[Symbol.toStringTag] || "Object") + "]";
        })
    }, autoBind({
        _onAdd: d(function (index) {
            if (index >= this.__nextIndex__)
                return;
            ++this.__nextIndex__;
            if (!this.__redo__) {
                defineProperty(this, "__redo__", d("c", [index]));
                return;
            }
            this.__redo__.forEach(function (redo, i) {
                if (redo >= index)
                    this.__redo__[i] = ++redo;
            }, this);
            this.__redo__.push(index);
        }),
        _onDelete: d(function (index) {
            var i;
            if (index >= this.__nextIndex__)
                return;
            --this.__nextIndex__;
            if (!this.__redo__)
                return;
            i = this.__redo__.indexOf(index);
            if (i !== -1)
                this.__redo__.splice(i, 1);
            this.__redo__.forEach(function (redo, j) {
                if (redo > index)
                    this.__redo__[j] = --redo;
            }, this);
        }),
        _onClear: d(function () {
            if (this.__redo__)
                clear.call(this.__redo__);
            this.__nextIndex__ = 0;
        })
    })));
    defineProperty(Iterator.prototype, Symbol.iterator, d(function () {
        return this;
    }));
},
/* d/auto-bind.js */ function _(require, module, exports) {
    var isValue = require(29) /* type/value/is */, ensureValue = require(73) /* type/value/ensure */, ensurePlainFunction = require(78) /* type/plain-function/ensure */, copy = require(79) /* es5-ext/object/copy */, normalizeOptions = require(35) /* es5-ext/object/normalize-options */, map = require(81) /* es5-ext/object/map */;
    var bind = Function.prototype.bind, defineProperty = Object.defineProperty, hasOwnProperty = Object.prototype.hasOwnProperty, define;
    define = function (name, desc, options) {
        var value = ensureValue(desc) && ensurePlainFunction(desc.value), dgs;
        dgs = copy(desc);
        delete dgs.writable;
        delete dgs.value;
        dgs.get = function () {
            if (!options.overwriteDefinition && hasOwnProperty.call(this, name))
                return value;
            desc.value = bind.call(value, options.resolveContext ? options.resolveContext(this) : this);
            defineProperty(this, name, desc);
            return this[name];
        };
        return dgs;
    };
    module.exports = function (props /*, options*/) {
        var options = normalizeOptions(arguments[1]);
        if (isValue(options.resolveContext))
            ensurePlainFunction(options.resolveContext);
        return map(props, function (desc, name) { return define(name, desc, options); });
    };
},
/* type/value/ensure.js */ function _(require, module, exports) {
    var resolveException = require(74) /* ../lib/resolve-exception */, is = require(29) /* ./is */;
    module.exports = function (value /*, options*/) {
        if (is(value))
            return value;
        return resolveException(value, "Cannot use %v", arguments[1]);
    };
},
/* type/lib/resolve-exception.js */ function _(require, module, exports) {
    var isValue = require(29) /* ../value/is */, isObject = require(33) /* ../object/is */, stringCoerce = require(75) /* ../string/coerce */, toShortString = require(76) /* ./to-short-string */;
    var resolveMessage = function (message, value) {
        return message.replace("%v", toShortString(value));
    };
    module.exports = function (value, defaultMessage, inputOptions) {
        if (!isObject(inputOptions))
            throw new TypeError(resolveMessage(defaultMessage, value));
        if (!isValue(value)) {
            if ("default" in inputOptions)
                return inputOptions["default"];
            if (inputOptions.isOptional)
                return null;
        }
        var errorMessage = stringCoerce(inputOptions.errorMessage);
        if (!isValue(errorMessage))
            errorMessage = defaultMessage;
        throw new TypeError(resolveMessage(errorMessage, value));
    };
},
/* type/string/coerce.js */ function _(require, module, exports) {
    var isValue = require(29) /* ../value/is */, isObject = require(33) /* ../object/is */;
    var objectToString = Object.prototype.toString;
    module.exports = function (value) {
        if (!isValue(value))
            return null;
        if (isObject(value)) {
            // Reject Object.prototype.toString coercion
            var valueToString = value.toString;
            if (typeof valueToString !== "function")
                return null;
            if (valueToString === objectToString)
                return null;
            // Note: It can be object coming from other realm, still as there's no ES3 and CSP compliant
            // way to resolve its realm's Object.prototype.toString it's left as not addressed edge case
        }
        try {
            return "" + value; // Ensure implicit coercion
        }
        catch (error) {
            return null;
        }
    };
},
/* type/lib/to-short-string.js */ function _(require, module, exports) {
    var safeToString = require(77) /* ./safe-to-string */;
    var reNewLine = /[\n\r\u2028\u2029]/g;
    module.exports = function (value) {
        var string = safeToString(value);
        if (string === null)
            return "<Non-coercible to string value>";
        // Trim if too long
        if (string.length > 100)
            string = string.slice(0, 99) + "…";
        // Replace eventual new lines
        string = string.replace(reNewLine, function (char) {
            switch (char) {
                case "\n":
                    return "\\n";
                case "\r":
                    return "\\r";
                case "\u2028":
                    return "\\u2028";
                case "\u2029":
                    return "\\u2029";
                /* istanbul ignore next */
                default:
                    throw new Error("Unexpected character");
            }
        });
        return string;
    };
},
/* type/lib/safe-to-string.js */ function _(require, module, exports) {
    module.exports = function (value) {
        try {
            return value.toString();
        }
        catch (error) {
            try {
                return String(value);
            }
            catch (error2) {
                return null;
            }
        }
    };
},
/* type/plain-function/ensure.js */ function _(require, module, exports) {
    var resolveException = require(74) /* ../lib/resolve-exception */, is = require(30) /* ./is */;
    module.exports = function (value /*, options*/) {
        if (is(value))
            return value;
        return resolveException(value, "%v is not a plain function", arguments[1]);
    };
},
/* es5-ext/object/copy.js */ function _(require, module, exports) {
    var aFrom = require(80) /* ../array/from */, assign = require(34) /* ./assign */, value = require(10) /* ./valid-value */;
    module.exports = function (obj /*, propertyNames, options*/) {
        var copy = Object(value(obj)), propertyNames = arguments[1], options = Object(arguments[2]);
        if (copy !== obj && !propertyNames)
            return copy;
        var result = {};
        if (propertyNames) {
            aFrom(propertyNames, function (propertyName) {
                if (options.ensure || propertyName in obj)
                    result[propertyName] = obj[propertyName];
            });
        }
        else {
            assign(result, obj);
        }
        return result;
    };
},
/* es5-ext/array/from/index.js */ function _(require, module, exports) {
    module.exports = require(22) /* ./is-implemented */() ? Array.from : require(23) /* ./shim */;
},
/* es5-ext/object/map.js */ function _(require, module, exports) {
    var callable = require(47) /* ./valid-callable */, forEach = require(82) /* ./for-each */, call = Function.prototype.call;
    module.exports = function (obj, cb /*, thisArg*/) {
        var result = {}, thisArg = arguments[2];
        callable(cb);
        forEach(obj, function (value, key, targetObj, index) {
            result[key] = call.call(cb, thisArg, value, key, targetObj, index);
        });
        return result;
    };
},
/* es5-ext/object/for-each.js */ function _(require, module, exports) {
    module.exports = require(83) /* ./_iterate */("forEach");
},
/* es5-ext/object/_iterate.js */ function _(require, module, exports) {
    var callable = require(47) /* ./valid-callable */, value = require(10) /* ./valid-value */, bind = Function.prototype.bind, call = Function.prototype.call, keys = Object.keys, objPropertyIsEnumerable = Object.prototype.propertyIsEnumerable;
    module.exports = function (method, defVal) {
        return function (obj, cb /*, thisArg, compareFn*/) {
            var list, thisArg = arguments[2], compareFn = arguments[3];
            obj = Object(value(obj));
            callable(cb);
            list = keys(obj);
            if (compareFn) {
                list.sort(typeof compareFn === "function" ? bind.call(compareFn, obj) : undefined);
            }
            if (typeof method !== "function")
                method = list[method];
            return call.call(method, list, function (key, index) {
                if (!objPropertyIsEnumerable.call(obj, key))
                    return defVal;
                return call.call(cb, thisArg, obj[key], key, obj, index);
            });
        };
    };
},
/* es6-iterator/string.js */ function _(require, module, exports) {
    var setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, d = require(28) /* d */, Symbol = require(24) /* es6-symbol */, Iterator = require(71) /* ./ */;
    var defineProperty = Object.defineProperty, StringIterator;
    StringIterator = module.exports = function (str) {
        if (!(this instanceof StringIterator))
            throw new TypeError("Constructor requires 'new'");
        str = String(str);
        Iterator.call(this, str);
        defineProperty(this, "__length__", d("", str.length));
    };
    if (setPrototypeOf)
        setPrototypeOf(StringIterator, Iterator);
    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete StringIterator.prototype.constructor;
    StringIterator.prototype = Object.create(Iterator.prototype, {
        _next: d(function () {
            if (!this.__list__)
                return undefined;
            if (this.__nextIndex__ < this.__length__)
                return this.__nextIndex__++;
            this._unBind();
            return undefined;
        }),
        _resolve: d(function (i) {
            var char = this.__list__[i], code;
            if (this.__nextIndex__ === this.__length__)
                return char;
            code = char.charCodeAt(0);
            if (code >= 0xd800 && code <= 0xdbff)
                return char + this.__list__[this.__nextIndex__++];
            return char;
        })
    });
    defineProperty(StringIterator.prototype, Symbol.toStringTag, d("c", "String Iterator"));
},
/* es6-set/lib/iterator.js */ function _(require, module, exports) {
    var setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, contains = require(36) /* es5-ext/string/#/contains */, d = require(28) /* d */, Iterator = require(71) /* es6-iterator */, toStringTagSymbol = require(24) /* es6-symbol */.toStringTag, defineProperty = Object.defineProperty, SetIterator;
    SetIterator = module.exports = function (set, kind) {
        if (!(this instanceof SetIterator))
            return new SetIterator(set, kind);
        Iterator.call(this, set.__setData__, set);
        if (!kind)
            kind = 'value';
        else if (contains.call(kind, 'key+value'))
            kind = 'key+value';
        else
            kind = 'value';
        defineProperty(this, '__kind__', d('', kind));
    };
    if (setPrototypeOf)
        setPrototypeOf(SetIterator, Iterator);
    SetIterator.prototype = Object.create(Iterator.prototype, {
        constructor: d(SetIterator),
        _resolve: d(function (i) {
            if (this.__kind__ === 'value')
                return this.__list__[i];
            return [this.__list__[i], this.__list__[i]];
        }),
        toString: d(function () { return '[object Set Iterator]'; })
    });
    defineProperty(SetIterator.prototype, toStringTagSymbol, d('c', 'Set Iterator'));
},
/* es6-set/is-native-implemented.js */ function _(require, module, exports) {
    module.exports = (function () {
        if (typeof Set === 'undefined')
            return false;
        return (Object.prototype.toString.call(Set.prototype) === '[object Set]');
    }());
},
/* es6-map/implement.js */ function _(require, module, exports) {
    if (!require(88) /* ./is-implemented */()) {
        Object.defineProperty(require(26) /* es5-ext/global */, 'Map', { value: require(89) /* ./polyfill */, configurable: true, enumerable: false,
            writable: true });
    }
},
/* es6-map/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var map, iterator, result;
        if (typeof Map !== 'function')
            return false;
        try {
            // WebKit doesn't support arguments and crashes
            map = new Map([['raz', 'one'], ['dwa', 'two'], ['trzy', 'three']]);
        }
        catch (e) {
            return false;
        }
        if (String(map) !== '[object Map]')
            return false;
        if (map.size !== 3)
            return false;
        if (typeof map.clear !== 'function')
            return false;
        if (typeof map.delete !== 'function')
            return false;
        if (typeof map.entries !== 'function')
            return false;
        if (typeof map.forEach !== 'function')
            return false;
        if (typeof map.get !== 'function')
            return false;
        if (typeof map.has !== 'function')
            return false;
        if (typeof map.keys !== 'function')
            return false;
        if (typeof map.set !== 'function')
            return false;
        if (typeof map.values !== 'function')
            return false;
        iterator = map.entries();
        result = iterator.next();
        if (result.done !== false)
            return false;
        if (!result.value)
            return false;
        if (result.value[0] !== 'raz')
            return false;
        if (result.value[1] !== 'one')
            return false;
        return true;
    };
},
/* es6-map/polyfill.js */ function _(require, module, exports) {
    var clear = require(55) /* es5-ext/array/#/clear */, eIndexOf = require(56) /* es5-ext/array/#/e-index-of */, setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, callable = require(47) /* es5-ext/object/valid-callable */, validValue = require(10) /* es5-ext/object/valid-value */, d = require(28) /* d */, ee = require(65) /* event-emitter */, Symbol = require(24) /* es6-symbol */, iterator = require(66) /* es6-iterator/valid-iterable */, forOf = require(68) /* es6-iterator/for-of */, Iterator = require(90) /* ./lib/iterator */, isNative = require(93) /* ./is-native-implemented */, call = Function.prototype.call, defineProperties = Object.defineProperties, getPrototypeOf = Object.getPrototypeOf, MapPoly;
    module.exports = MapPoly = function ( /*iterable*/) {
        var iterable = arguments[0], keys, values, self;
        if (!(this instanceof MapPoly))
            throw new TypeError('Constructor requires \'new\'');
        if (isNative && setPrototypeOf && (Map !== MapPoly)) {
            self = setPrototypeOf(new Map(), getPrototypeOf(this));
        }
        else {
            self = this;
        }
        if (iterable != null)
            iterator(iterable);
        defineProperties(self, {
            __mapKeysData__: d('c', keys = []),
            __mapValuesData__: d('c', values = [])
        });
        if (!iterable)
            return self;
        forOf(iterable, function (value) {
            var key = validValue(value)[0];
            value = value[1];
            if (eIndexOf.call(keys, key) !== -1)
                return;
            keys.push(key);
            values.push(value);
        }, self);
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(MapPoly, Map);
        MapPoly.prototype = Object.create(Map.prototype, {
            constructor: d(MapPoly)
        });
    }
    ee(defineProperties(MapPoly.prototype, {
        clear: d(function () {
            if (!this.__mapKeysData__.length)
                return;
            clear.call(this.__mapKeysData__);
            clear.call(this.__mapValuesData__);
            this.emit('_clear');
        }),
        delete: d(function (key) {
            var index = eIndexOf.call(this.__mapKeysData__, key);
            if (index === -1)
                return false;
            this.__mapKeysData__.splice(index, 1);
            this.__mapValuesData__.splice(index, 1);
            this.emit('_delete', index, key);
            return true;
        }),
        entries: d(function () { return new Iterator(this, 'key+value'); }),
        forEach: d(function (cb /*, thisArg*/) {
            var thisArg = arguments[1], iterator, result;
            callable(cb);
            iterator = this.entries();
            result = iterator._next();
            while (result !== undefined) {
                call.call(cb, thisArg, this.__mapValuesData__[result], this.__mapKeysData__[result], this);
                result = iterator._next();
            }
        }),
        get: d(function (key) {
            var index = eIndexOf.call(this.__mapKeysData__, key);
            if (index === -1)
                return;
            return this.__mapValuesData__[index];
        }),
        has: d(function (key) {
            return (eIndexOf.call(this.__mapKeysData__, key) !== -1);
        }),
        keys: d(function () { return new Iterator(this, 'key'); }),
        set: d(function (key, value) {
            var index = eIndexOf.call(this.__mapKeysData__, key), emit;
            if (index === -1) {
                index = this.__mapKeysData__.push(key) - 1;
                emit = true;
            }
            this.__mapValuesData__[index] = value;
            if (emit)
                this.emit('_add', index, key);
            return this;
        }),
        size: d.gs(function () { return this.__mapKeysData__.length; }),
        values: d(function () { return new Iterator(this, 'value'); }),
        toString: d(function () { return '[object Map]'; })
    }));
    Object.defineProperty(MapPoly.prototype, Symbol.iterator, d(function () {
        return this.entries();
    }));
    Object.defineProperty(MapPoly.prototype, Symbol.toStringTag, d('c', 'Map'));
},
/* es6-map/lib/iterator.js */ function _(require, module, exports) {
    var setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, d = require(28) /* d */, Iterator = require(71) /* es6-iterator */, toStringTagSymbol = require(24) /* es6-symbol */.toStringTag, kinds = require(91) /* ./iterator-kinds */, defineProperties = Object.defineProperties, unBind = Iterator.prototype._unBind, MapIterator;
    MapIterator = module.exports = function (map, kind) {
        if (!(this instanceof MapIterator))
            return new MapIterator(map, kind);
        Iterator.call(this, map.__mapKeysData__, map);
        if (!kind || !kinds[kind])
            kind = 'key+value';
        defineProperties(this, {
            __kind__: d('', kind),
            __values__: d('w', map.__mapValuesData__)
        });
    };
    if (setPrototypeOf)
        setPrototypeOf(MapIterator, Iterator);
    MapIterator.prototype = Object.create(Iterator.prototype, {
        constructor: d(MapIterator),
        _resolve: d(function (i) {
            if (this.__kind__ === 'value')
                return this.__values__[i];
            if (this.__kind__ === 'key')
                return this.__list__[i];
            return [this.__list__[i], this.__values__[i]];
        }),
        _unBind: d(function () {
            this.__values__ = null;
            unBind.call(this);
        }),
        toString: d(function () { return '[object Map Iterator]'; })
    });
    Object.defineProperty(MapIterator.prototype, toStringTagSymbol, d('c', 'Map Iterator'));
},
/* es6-map/lib/iterator-kinds.js */ function _(require, module, exports) {
    module.exports = require(92) /* es5-ext/object/primitive-set */('key', 'value', 'key+value');
},
/* es5-ext/object/primitive-set.js */ function _(require, module, exports) {
    var forEach = Array.prototype.forEach, create = Object.create;
    // eslint-disable-next-line no-unused-vars
    module.exports = function (arg /*, …args*/) {
        var set = create(null);
        forEach.call(arguments, function (name) { set[name] = true; });
        return set;
    };
},
/* es6-map/is-native-implemented.js */ function _(require, module, exports) {
    module.exports = (function () {
        if (typeof Map === 'undefined')
            return false;
        return (Object.prototype.toString.call(new Map()) === '[object Map]');
    }());
},
/* es6-weak-map/implement.js */ function _(require, module, exports) {
    if (!require(95) /* ./is-implemented */()) {
        Object.defineProperty(require(26) /* es5-ext/global */, "WeakMap", {
            value: require(96) /* ./polyfill */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es6-weak-map/is-implemented.js */ function _(require, module, exports) {
    module.exports = function () {
        var weakMap, obj;
        if (typeof WeakMap !== "function")
            return false;
        try {
            // WebKit doesn't support arguments and crashes
            weakMap = new WeakMap([[obj = {}, "one"], [{}, "two"], [{}, "three"]]);
        }
        catch (e) {
            return false;
        }
        if (String(weakMap) !== "[object WeakMap]")
            return false;
        if (typeof weakMap.set !== "function")
            return false;
        if (weakMap.set({}, 1) !== weakMap)
            return false;
        if (typeof weakMap.delete !== "function")
            return false;
        if (typeof weakMap.has !== "function")
            return false;
        if (weakMap.get(obj) !== "one")
            return false;
        return true;
    };
},
/* es6-weak-map/polyfill.js */ function _(require, module, exports) {
    var isValue = require(8) /* es5-ext/object/is-value */, setPrototypeOf = require(60) /* es5-ext/object/set-prototype-of */, object = require(97) /* es5-ext/object/valid-object */, ensureValue = require(10) /* es5-ext/object/valid-value */, randomUniq = require(98) /* es5-ext/string/random-uniq */, d = require(28) /* d */, getIterator = require(69) /* es6-iterator/get */, forOf = require(68) /* es6-iterator/for-of */, toStringTagSymbol = require(24) /* es6-symbol */.toStringTag, isNative = require(99) /* ./is-native-implemented */, isArray = Array.isArray, defineProperty = Object.defineProperty, objHasOwnProperty = Object.prototype.hasOwnProperty, getPrototypeOf = Object.getPrototypeOf, WeakMapPoly;
    module.exports = WeakMapPoly = function ( /* Iterable*/) {
        var iterable = arguments[0], self;
        if (!(this instanceof WeakMapPoly))
            throw new TypeError("Constructor requires 'new'");
        self = isNative && setPrototypeOf && (WeakMap !== WeakMapPoly)
            ? setPrototypeOf(new WeakMap(), getPrototypeOf(this)) : this;
        if (isValue(iterable)) {
            if (!isArray(iterable))
                iterable = getIterator(iterable);
        }
        defineProperty(self, "__weakMapData__", d("c", "$weakMap$" + randomUniq()));
        if (!iterable)
            return self;
        forOf(iterable, function (val) {
            ensureValue(val);
            self.set(val[0], val[1]);
        });
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(WeakMapPoly, WeakMap);
        WeakMapPoly.prototype = Object.create(WeakMap.prototype, { constructor: d(WeakMapPoly) });
    }
    Object.defineProperties(WeakMapPoly.prototype, {
        delete: d(function (key) {
            if (objHasOwnProperty.call(object(key), this.__weakMapData__)) {
                delete key[this.__weakMapData__];
                return true;
            }
            return false;
        }),
        get: d(function (key) {
            if (!objHasOwnProperty.call(object(key), this.__weakMapData__))
                return undefined;
            return key[this.__weakMapData__];
        }),
        has: d(function (key) {
            return objHasOwnProperty.call(object(key), this.__weakMapData__);
        }),
        set: d(function (key, value) {
            defineProperty(object(key), this.__weakMapData__, d("c", value));
            return this;
        }),
        toString: d(function () {
            return "[object WeakMap]";
        })
    });
    defineProperty(WeakMapPoly.prototype, toStringTagSymbol, d("c", "WeakMap"));
},
/* es5-ext/object/valid-object.js */ function _(require, module, exports) {
    var isObject = require(63) /* ./is-object */;
    module.exports = function (value) {
        if (!isObject(value))
            throw new TypeError(value + " is not an Object");
        return value;
    };
},
/* es5-ext/string/random-uniq.js */ function _(require, module, exports) {
    var generated = Object.create(null), random = Math.random;
    module.exports = function () {
        var str;
        do {
            str = random().toString(36).slice(2);
        } while (generated[str]);
        return str;
    };
},
/* es6-weak-map/is-native-implemented.js */ function _(require, module, exports) {
    module.exports = (function () {
        if (typeof WeakMap !== "function")
            return false;
        return Object.prototype.toString.call(new WeakMap()) === "[object WeakMap]";
    }());
},
/* es6-promise/auto.js */ function _(require, module, exports) {
    module.exports = require(101) /* ./ */.polyfill();
},
/* es6-promise/dist/es6-promise.js */ function _(require, module, exports) {
    /*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.6+9869a4bc
     */
    (function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
            typeof define === 'function' && define.amd ? define(factory) :
                (global.ES6Promise = factory());
    }(this, (function () {
        'use strict';
        function objectOrFunction(x) {
            var type = typeof x;
            return x !== null && (type === 'object' || type === 'function');
        }
        function isFunction(x) {
            return typeof x === 'function';
        }
        var _isArray = void 0;
        if (Array.isArray) {
            _isArray = Array.isArray;
        }
        else {
            _isArray = function (x) {
                return Object.prototype.toString.call(x) === '[object Array]';
            };
        }
        var isArray = _isArray;
        var len = 0;
        var vertxNext = void 0;
        var customSchedulerFn = void 0;
        var asap = function asap(callback, arg) {
            queue[len] = callback;
            queue[len + 1] = arg;
            len += 2;
            if (len === 2) {
                // If len is 2, that means that we need to schedule an async flush.
                // If additional callbacks are queued before the queue is flushed, they
                // will be processed by this flush that we are scheduling.
                if (customSchedulerFn) {
                    customSchedulerFn(flush);
                }
                else {
                    scheduleFlush();
                }
            }
        };
        function setScheduler(scheduleFn) {
            customSchedulerFn = scheduleFn;
        }
        function setAsap(asapFn) {
            asap = asapFn;
        }
        var browserWindow = typeof window !== 'undefined' ? window : undefined;
        var browserGlobal = browserWindow || {};
        var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
        var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
        // test for web worker but not in IE10
        var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
        // node
        function useNextTick() {
            // node version 0.10.x displays a deprecation warning when nextTick is used recursively
            // see https://github.com/cujojs/when/issues/410 for details
            return function () {
                return process.nextTick(flush);
            };
        }
        // vertx
        function useVertxTimer() {
            if (typeof vertxNext !== 'undefined') {
                return function () {
                    vertxNext(flush);
                };
            }
            return useSetTimeout();
        }
        function useMutationObserver() {
            var iterations = 0;
            var observer = new BrowserMutationObserver(flush);
            var node = document.createTextNode('');
            observer.observe(node, { characterData: true });
            return function () {
                node.data = iterations = ++iterations % 2;
            };
        }
        // web worker
        function useMessageChannel() {
            var channel = new MessageChannel();
            channel.port1.onmessage = flush;
            return function () {
                return channel.port2.postMessage(0);
            };
        }
        function useSetTimeout() {
            // Store setTimeout reference so es6-promise will be unaffected by
            // other code modifying setTimeout (like sinon.useFakeTimers())
            var globalSetTimeout = setTimeout;
            return function () {
                return globalSetTimeout(flush, 1);
            };
        }
        var queue = new Array(1000);
        function flush() {
            for (var i = 0; i < len; i += 2) {
                var callback = queue[i];
                var arg = queue[i + 1];
                callback(arg);
                queue[i] = undefined;
                queue[i + 1] = undefined;
            }
            len = 0;
        }
        function attemptVertx() {
            try {
                var vertx = Function('return this')().require('vertx');
                vertxNext = vertx.runOnLoop || vertx.runOnContext;
                return useVertxTimer();
            }
            catch (e) {
                return useSetTimeout();
            }
        }
        var scheduleFlush = void 0;
        // Decide what async method to use to triggering processing of queued callbacks:
        if (isNode) {
            scheduleFlush = useNextTick();
        }
        else if (BrowserMutationObserver) {
            scheduleFlush = useMutationObserver();
        }
        else if (isWorker) {
            scheduleFlush = useMessageChannel();
        }
        else if (browserWindow === undefined && typeof require === 'function') {
            scheduleFlush = attemptVertx();
        }
        else {
            scheduleFlush = useSetTimeout();
        }
        function then(onFulfillment, onRejection) {
            var parent = this;
            var child = new this.constructor(noop);
            if (child[PROMISE_ID] === undefined) {
                makePromise(child);
            }
            var _state = parent._state;
            if (_state) {
                var callback = arguments[_state - 1];
                asap(function () {
                    return invokeCallback(_state, child, callback, parent._result);
                });
            }
            else {
                subscribe(parent, child, onFulfillment, onRejection);
            }
            return child;
        }
        /**
          `Promise.resolve` returns a promise that will become resolved with the
          passed `value`. It is shorthand for the following:
        
          ```javascript
          let promise = new Promise(function(resolve, reject){
            resolve(1);
          });
        
          promise.then(function(value){
            // value === 1
          });
          ```
        
          Instead of writing the above, your code now simply becomes the following:
        
          ```javascript
          let promise = Promise.resolve(1);
        
          promise.then(function(value){
            // value === 1
          });
          ```
        
          @method resolve
          @static
          @param {Any} value value that the returned promise will be resolved with
          Useful for tooling.
          @return {Promise} a promise that will become fulfilled with the given
          `value`
        */
        function resolve$1(object) {
            /*jshint validthis:true */
            var Constructor = this;
            if (object && typeof object === 'object' && object.constructor === Constructor) {
                return object;
            }
            var promise = new Constructor(noop);
            resolve(promise, object);
            return promise;
        }
        var PROMISE_ID = Math.random().toString(36).substring(2);
        function noop() { }
        var PENDING = void 0;
        var FULFILLED = 1;
        var REJECTED = 2;
        var TRY_CATCH_ERROR = { error: null };
        function selfFulfillment() {
            return new TypeError("You cannot resolve a promise with itself");
        }
        function cannotReturnOwn() {
            return new TypeError('A promises callback cannot return that same promise.');
        }
        function getThen(promise) {
            try {
                return promise.then;
            }
            catch (error) {
                TRY_CATCH_ERROR.error = error;
                return TRY_CATCH_ERROR;
            }
        }
        function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
            try {
                then$$1.call(value, fulfillmentHandler, rejectionHandler);
            }
            catch (e) {
                return e;
            }
        }
        function handleForeignThenable(promise, thenable, then$$1) {
            asap(function (promise) {
                var sealed = false;
                var error = tryThen(then$$1, thenable, function (value) {
                    if (sealed) {
                        return;
                    }
                    sealed = true;
                    if (thenable !== value) {
                        resolve(promise, value);
                    }
                    else {
                        fulfill(promise, value);
                    }
                }, function (reason) {
                    if (sealed) {
                        return;
                    }
                    sealed = true;
                    reject(promise, reason);
                }, 'Settle: ' + (promise._label || ' unknown promise'));
                if (!sealed && error) {
                    sealed = true;
                    reject(promise, error);
                }
            }, promise);
        }
        function handleOwnThenable(promise, thenable) {
            if (thenable._state === FULFILLED) {
                fulfill(promise, thenable._result);
            }
            else if (thenable._state === REJECTED) {
                reject(promise, thenable._result);
            }
            else {
                subscribe(thenable, undefined, function (value) {
                    return resolve(promise, value);
                }, function (reason) {
                    return reject(promise, reason);
                });
            }
        }
        function handleMaybeThenable(promise, maybeThenable, then$$1) {
            if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
                handleOwnThenable(promise, maybeThenable);
            }
            else {
                if (then$$1 === TRY_CATCH_ERROR) {
                    reject(promise, TRY_CATCH_ERROR.error);
                    TRY_CATCH_ERROR.error = null;
                }
                else if (then$$1 === undefined) {
                    fulfill(promise, maybeThenable);
                }
                else if (isFunction(then$$1)) {
                    handleForeignThenable(promise, maybeThenable, then$$1);
                }
                else {
                    fulfill(promise, maybeThenable);
                }
            }
        }
        function resolve(promise, value) {
            if (promise === value) {
                reject(promise, selfFulfillment());
            }
            else if (objectOrFunction(value)) {
                handleMaybeThenable(promise, value, getThen(value));
            }
            else {
                fulfill(promise, value);
            }
        }
        function publishRejection(promise) {
            if (promise._onerror) {
                promise._onerror(promise._result);
            }
            publish(promise);
        }
        function fulfill(promise, value) {
            if (promise._state !== PENDING) {
                return;
            }
            promise._result = value;
            promise._state = FULFILLED;
            if (promise._subscribers.length !== 0) {
                asap(publish, promise);
            }
        }
        function reject(promise, reason) {
            if (promise._state !== PENDING) {
                return;
            }
            promise._state = REJECTED;
            promise._result = reason;
            asap(publishRejection, promise);
        }
        function subscribe(parent, child, onFulfillment, onRejection) {
            var _subscribers = parent._subscribers;
            var length = _subscribers.length;
            parent._onerror = null;
            _subscribers[length] = child;
            _subscribers[length + FULFILLED] = onFulfillment;
            _subscribers[length + REJECTED] = onRejection;
            if (length === 0 && parent._state) {
                asap(publish, parent);
            }
        }
        function publish(promise) {
            var subscribers = promise._subscribers;
            var settled = promise._state;
            if (subscribers.length === 0) {
                return;
            }
            var child = void 0, callback = void 0, detail = promise._result;
            for (var i = 0; i < subscribers.length; i += 3) {
                child = subscribers[i];
                callback = subscribers[i + settled];
                if (child) {
                    invokeCallback(settled, child, callback, detail);
                }
                else {
                    callback(detail);
                }
            }
            promise._subscribers.length = 0;
        }
        function tryCatch(callback, detail) {
            try {
                return callback(detail);
            }
            catch (e) {
                TRY_CATCH_ERROR.error = e;
                return TRY_CATCH_ERROR;
            }
        }
        function invokeCallback(settled, promise, callback, detail) {
            var hasCallback = isFunction(callback), value = void 0, error = void 0, succeeded = void 0, failed = void 0;
            if (hasCallback) {
                value = tryCatch(callback, detail);
                if (value === TRY_CATCH_ERROR) {
                    failed = true;
                    error = value.error;
                    value.error = null;
                }
                else {
                    succeeded = true;
                }
                if (promise === value) {
                    reject(promise, cannotReturnOwn());
                    return;
                }
            }
            else {
                value = detail;
                succeeded = true;
            }
            if (promise._state !== PENDING) {
                // noop
            }
            else if (hasCallback && succeeded) {
                resolve(promise, value);
            }
            else if (failed) {
                reject(promise, error);
            }
            else if (settled === FULFILLED) {
                fulfill(promise, value);
            }
            else if (settled === REJECTED) {
                reject(promise, value);
            }
        }
        function initializePromise(promise, resolver) {
            try {
                resolver(function resolvePromise(value) {
                    resolve(promise, value);
                }, function rejectPromise(reason) {
                    reject(promise, reason);
                });
            }
            catch (e) {
                reject(promise, e);
            }
        }
        var id = 0;
        function nextId() {
            return id++;
        }
        function makePromise(promise) {
            promise[PROMISE_ID] = id++;
            promise._state = undefined;
            promise._result = undefined;
            promise._subscribers = [];
        }
        function validationError() {
            return new Error('Array Methods must be provided an Array');
        }
        var Enumerator = function () {
            function Enumerator(Constructor, input) {
                this._instanceConstructor = Constructor;
                this.promise = new Constructor(noop);
                if (!this.promise[PROMISE_ID]) {
                    makePromise(this.promise);
                }
                if (isArray(input)) {
                    this.length = input.length;
                    this._remaining = input.length;
                    this._result = new Array(this.length);
                    if (this.length === 0) {
                        fulfill(this.promise, this._result);
                    }
                    else {
                        this.length = this.length || 0;
                        this._enumerate(input);
                        if (this._remaining === 0) {
                            fulfill(this.promise, this._result);
                        }
                    }
                }
                else {
                    reject(this.promise, validationError());
                }
            }
            Enumerator.prototype._enumerate = function _enumerate(input) {
                for (var i = 0; this._state === PENDING && i < input.length; i++) {
                    this._eachEntry(input[i], i);
                }
            };
            Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
                var c = this._instanceConstructor;
                var resolve$$1 = c.resolve;
                if (resolve$$1 === resolve$1) {
                    var _then = getThen(entry);
                    if (_then === then && entry._state !== PENDING) {
                        this._settledAt(entry._state, i, entry._result);
                    }
                    else if (typeof _then !== 'function') {
                        this._remaining--;
                        this._result[i] = entry;
                    }
                    else if (c === Promise$1) {
                        var promise = new c(noop);
                        handleMaybeThenable(promise, entry, _then);
                        this._willSettleAt(promise, i);
                    }
                    else {
                        this._willSettleAt(new c(function (resolve$$1) {
                            return resolve$$1(entry);
                        }), i);
                    }
                }
                else {
                    this._willSettleAt(resolve$$1(entry), i);
                }
            };
            Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
                var promise = this.promise;
                if (promise._state === PENDING) {
                    this._remaining--;
                    if (state === REJECTED) {
                        reject(promise, value);
                    }
                    else {
                        this._result[i] = value;
                    }
                }
                if (this._remaining === 0) {
                    fulfill(promise, this._result);
                }
            };
            Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
                var enumerator = this;
                subscribe(promise, undefined, function (value) {
                    return enumerator._settledAt(FULFILLED, i, value);
                }, function (reason) {
                    return enumerator._settledAt(REJECTED, i, reason);
                });
            };
            return Enumerator;
        }();
        /**
          `Promise.all` accepts an array of promises, and returns a new promise which
          is fulfilled with an array of fulfillment values for the passed promises, or
          rejected with the reason of the first passed promise to be rejected. It casts all
          elements of the passed iterable to promises as it runs this algorithm.
        
          Example:
        
          ```javascript
          let promise1 = resolve(1);
          let promise2 = resolve(2);
          let promise3 = resolve(3);
          let promises = [ promise1, promise2, promise3 ];
        
          Promise.all(promises).then(function(array){
            // The array here would be [ 1, 2, 3 ];
          });
          ```
        
          If any of the `promises` given to `all` are rejected, the first promise
          that is rejected will be given as an argument to the returned promises's
          rejection handler. For example:
        
          Example:
        
          ```javascript
          let promise1 = resolve(1);
          let promise2 = reject(new Error("2"));
          let promise3 = reject(new Error("3"));
          let promises = [ promise1, promise2, promise3 ];
        
          Promise.all(promises).then(function(array){
            // Code here never runs because there are rejected promises!
          }, function(error) {
            // error.message === "2"
          });
          ```
        
          @method all
          @static
          @param {Array} entries array of promises
          @param {String} label optional string for labeling the promise.
          Useful for tooling.
          @return {Promise} promise that is fulfilled when all `promises` have been
          fulfilled, or rejected if any of them become rejected.
          @static
        */
        function all(entries) {
            return new Enumerator(this, entries).promise;
        }
        /**
          `Promise.race` returns a new promise which is settled in the same way as the
          first passed promise to settle.
        
          Example:
        
          ```javascript
          let promise1 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 1');
            }, 200);
          });
        
          let promise2 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 2');
            }, 100);
          });
        
          Promise.race([promise1, promise2]).then(function(result){
            // result === 'promise 2' because it was resolved before promise1
            // was resolved.
          });
          ```
        
          `Promise.race` is deterministic in that only the state of the first
          settled promise matters. For example, even if other promises given to the
          `promises` array argument are resolved, but the first settled promise has
          become rejected before the other promises became fulfilled, the returned
          promise will become rejected:
        
          ```javascript
          let promise1 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 1');
            }, 200);
          });
        
          let promise2 = new Promise(function(resolve, reject){
            setTimeout(function(){
              reject(new Error('promise 2'));
            }, 100);
          });
        
          Promise.race([promise1, promise2]).then(function(result){
            // Code here never runs
          }, function(reason){
            // reason.message === 'promise 2' because promise 2 became rejected before
            // promise 1 became fulfilled
          });
          ```
        
          An example real-world use case is implementing timeouts:
        
          ```javascript
          Promise.race([ajax('foo.json'), timeout(5000)])
          ```
        
          @method race
          @static
          @param {Array} promises array of promises to observe
          Useful for tooling.
          @return {Promise} a promise which settles in the same way as the first passed
          promise to settle.
        */
        function race(entries) {
            /*jshint validthis:true */
            var Constructor = this;
            if (!isArray(entries)) {
                return new Constructor(function (_, reject) {
                    return reject(new TypeError('You must pass an array to race.'));
                });
            }
            else {
                return new Constructor(function (resolve, reject) {
                    var length = entries.length;
                    for (var i = 0; i < length; i++) {
                        Constructor.resolve(entries[i]).then(resolve, reject);
                    }
                });
            }
        }
        /**
          `Promise.reject` returns a promise rejected with the passed `reason`.
          It is shorthand for the following:
        
          ```javascript
          let promise = new Promise(function(resolve, reject){
            reject(new Error('WHOOPS'));
          });
        
          promise.then(function(value){
            // Code here doesn't run because the promise is rejected!
          }, function(reason){
            // reason.message === 'WHOOPS'
          });
          ```
        
          Instead of writing the above, your code now simply becomes the following:
        
          ```javascript
          let promise = Promise.reject(new Error('WHOOPS'));
        
          promise.then(function(value){
            // Code here doesn't run because the promise is rejected!
          }, function(reason){
            // reason.message === 'WHOOPS'
          });
          ```
        
          @method reject
          @static
          @param {Any} reason value that the returned promise will be rejected with.
          Useful for tooling.
          @return {Promise} a promise rejected with the given `reason`.
        */
        function reject$1(reason) {
            /*jshint validthis:true */
            var Constructor = this;
            var promise = new Constructor(noop);
            reject(promise, reason);
            return promise;
        }
        function needsResolver() {
            throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
        }
        function needsNew() {
            throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
        }
        /**
          Promise objects represent the eventual result of an asynchronous operation. The
          primary way of interacting with a promise is through its `then` method, which
          registers callbacks to receive either a promise's eventual value or the reason
          why the promise cannot be fulfilled.
        
          Terminology
          -----------
        
          - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
          - `thenable` is an object or function that defines a `then` method.
          - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
          - `exception` is a value that is thrown using the throw statement.
          - `reason` is a value that indicates why a promise was rejected.
          - `settled` the final resting state of a promise, fulfilled or rejected.
        
          A promise can be in one of three states: pending, fulfilled, or rejected.
        
          Promises that are fulfilled have a fulfillment value and are in the fulfilled
          state.  Promises that are rejected have a rejection reason and are in the
          rejected state.  A fulfillment value is never a thenable.
        
          Promises can also be said to *resolve* a value.  If this value is also a
          promise, then the original promise's settled state will match the value's
          settled state.  So a promise that *resolves* a promise that rejects will
          itself reject, and a promise that *resolves* a promise that fulfills will
          itself fulfill.
        
        
          Basic Usage:
          ------------
        
          ```js
          let promise = new Promise(function(resolve, reject) {
            // on success
            resolve(value);
        
            // on failure
            reject(reason);
          });
        
          promise.then(function(value) {
            // on fulfillment
          }, function(reason) {
            // on rejection
          });
          ```
        
          Advanced Usage:
          ---------------
        
          Promises shine when abstracting away asynchronous interactions such as
          `XMLHttpRequest`s.
        
          ```js
          function getJSON(url) {
            return new Promise(function(resolve, reject){
              let xhr = new XMLHttpRequest();
        
              xhr.open('GET', url);
              xhr.onreadystatechange = handler;
              xhr.responseType = 'json';
              xhr.setRequestHeader('Accept', 'application/json');
              xhr.send();
        
              function handler() {
                if (this.readyState === this.DONE) {
                  if (this.status === 200) {
                    resolve(this.response);
                  } else {
                    reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
                  }
                }
              };
            });
          }
        
          getJSON('/posts.json').then(function(json) {
            // on fulfillment
          }, function(reason) {
            // on rejection
          });
          ```
        
          Unlike callbacks, promises are great composable primitives.
        
          ```js
          Promise.all([
            getJSON('/posts'),
            getJSON('/comments')
          ]).then(function(values){
            values[0] // => postsJSON
            values[1] // => commentsJSON
        
            return values;
          });
          ```
        
          @class Promise
          @param {Function} resolver
          Useful for tooling.
          @constructor
        */
        var Promise$1 = function () {
            function Promise(resolver) {
                this[PROMISE_ID] = nextId();
                this._result = this._state = undefined;
                this._subscribers = [];
                if (noop !== resolver) {
                    typeof resolver !== 'function' && needsResolver();
                    this instanceof Promise ? initializePromise(this, resolver) : needsNew();
                }
            }
            /**
            The primary way of interacting with a promise is through its `then` method,
            which registers callbacks to receive either a promise's eventual value or the
            reason why the promise cannot be fulfilled.
             ```js
            findUser().then(function(user){
              // user is available
            }, function(reason){
              // user is unavailable, and you are given the reason why
            });
            ```
             Chaining
            --------
             The return value of `then` is itself a promise.  This second, 'downstream'
            promise is resolved with the return value of the first promise's fulfillment
            or rejection handler, or rejected if the handler throws an exception.
             ```js
            findUser().then(function (user) {
              return user.name;
            }, function (reason) {
              return 'default name';
            }).then(function (userName) {
              // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
              // will be `'default name'`
            });
             findUser().then(function (user) {
              throw new Error('Found user, but still unhappy');
            }, function (reason) {
              throw new Error('`findUser` rejected and we're unhappy');
            }).then(function (value) {
              // never reached
            }, function (reason) {
              // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
              // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
            });
            ```
            If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
             ```js
            findUser().then(function (user) {
              throw new PedagogicalException('Upstream error');
            }).then(function (value) {
              // never reached
            }).then(function (value) {
              // never reached
            }, function (reason) {
              // The `PedgagocialException` is propagated all the way down to here
            });
            ```
             Assimilation
            ------------
             Sometimes the value you want to propagate to a downstream promise can only be
            retrieved asynchronously. This can be achieved by returning a promise in the
            fulfillment or rejection handler. The downstream promise will then be pending
            until the returned promise is settled. This is called *assimilation*.
             ```js
            findUser().then(function (user) {
              return findCommentsByAuthor(user);
            }).then(function (comments) {
              // The user's comments are now available
            });
            ```
             If the assimliated promise rejects, then the downstream promise will also reject.
             ```js
            findUser().then(function (user) {
              return findCommentsByAuthor(user);
            }).then(function (comments) {
              // If `findCommentsByAuthor` fulfills, we'll have the value here
            }, function (reason) {
              // If `findCommentsByAuthor` rejects, we'll have the reason here
            });
            ```
             Simple Example
            --------------
             Synchronous Example
             ```javascript
            let result;
             try {
              result = findResult();
              // success
            } catch(reason) {
              // failure
            }
            ```
             Errback Example
             ```js
            findResult(function(result, err){
              if (err) {
                // failure
              } else {
                // success
              }
            });
            ```
             Promise Example;
             ```javascript
            findResult().then(function(result){
              // success
            }, function(reason){
              // failure
            });
            ```
             Advanced Example
            --------------
             Synchronous Example
             ```javascript
            let author, books;
             try {
              author = findAuthor();
              books  = findBooksByAuthor(author);
              // success
            } catch(reason) {
              // failure
            }
            ```
             Errback Example
             ```js
             function foundBooks(books) {
             }
             function failure(reason) {
             }
             findAuthor(function(author, err){
              if (err) {
                failure(err);
                // failure
              } else {
                try {
                  findBoooksByAuthor(author, function(books, err) {
                    if (err) {
                      failure(err);
                    } else {
                      try {
                        foundBooks(books);
                      } catch(reason) {
                        failure(reason);
                      }
                    }
                  });
                } catch(error) {
                  failure(err);
                }
                // success
              }
            });
            ```
             Promise Example;
             ```javascript
            findAuthor().
              then(findBooksByAuthor).
              then(function(books){
                // found books
            }).catch(function(reason){
              // something went wrong
            });
            ```
             @method then
            @param {Function} onFulfilled
            @param {Function} onRejected
            Useful for tooling.
            @return {Promise}
            */
            /**
            `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
            as the catch block of a try/catch statement.
            ```js
            function findAuthor(){
            throw new Error('couldn't find that author');
            }
            // synchronous
            try {
            findAuthor();
            } catch(reason) {
            // something went wrong
            }
            // async with promises
            findAuthor().catch(function(reason){
            // something went wrong
            });
            ```
            @method catch
            @param {Function} onRejection
            Useful for tooling.
            @return {Promise}
            */
            Promise.prototype.catch = function _catch(onRejection) {
                return this.then(null, onRejection);
            };
            /**
              `finally` will be invoked regardless of the promise's fate just as native
              try/catch/finally behaves
            
              Synchronous example:
            
              ```js
              findAuthor() {
                if (Math.random() > 0.5) {
                  throw new Error();
                }
                return new Author();
              }
            
              try {
                return findAuthor(); // succeed or fail
              } catch(error) {
                return findOtherAuther();
              } finally {
                // always runs
                // doesn't affect the return value
              }
              ```
            
              Asynchronous example:
            
              ```js
              findAuthor().catch(function(reason){
                return findOtherAuther();
              }).finally(function(){
                // author was either found, or not
              });
              ```
            
              @method finally
              @param {Function} callback
              @return {Promise}
            */
            Promise.prototype.finally = function _finally(callback) {
                var promise = this;
                var constructor = promise.constructor;
                if (isFunction(callback)) {
                    return promise.then(function (value) {
                        return constructor.resolve(callback()).then(function () {
                            return value;
                        });
                    }, function (reason) {
                        return constructor.resolve(callback()).then(function () {
                            throw reason;
                        });
                    });
                }
                return promise.then(callback, callback);
            };
            return Promise;
        }();
        Promise$1.prototype.then = then;
        Promise$1.all = all;
        Promise$1.race = race;
        Promise$1.resolve = resolve$1;
        Promise$1.reject = reject$1;
        Promise$1._setScheduler = setScheduler;
        Promise$1._setAsap = setAsap;
        Promise$1._asap = asap;
        /*global self*/
        function polyfill() {
            var local = void 0;
            if (typeof global !== 'undefined') {
                local = global;
            }
            else if (typeof self !== 'undefined') {
                local = self;
            }
            else {
                try {
                    local = Function('return this')();
                }
                catch (e) {
                    throw new Error('polyfill failed because global object is unavailable in this environment');
                }
            }
            var P = local.Promise;
            if (P) {
                var promiseToString = null;
                try {
                    promiseToString = Object.prototype.toString.call(P.resolve());
                }
                catch (e) {
                    // silently ignored
                }
                if (promiseToString === '[object Promise]' && !P.cast) {
                    return;
                }
            }
            local.Promise = Promise$1;
        }
        // Strange compat..
        Promise$1.polyfill = polyfill;
        Promise$1.Promise = Promise$1;
        return Promise$1;
    })));
},
/* main.js */ function _(require, module, exports) {
    function __export(m) {
        for (var p in m)
            if (!exports.hasOwnProperty(p))
                exports[p] = m[p];
    }
    __export(require(103) /* ./index */);
},
/* index.js */ function _(require, module, exports) {
    var version_1 = require(104) /* ./version */;
    exports.version = version_1.version;
    var embed = require(105) /* ./embed */;
    exports.embed = embed;
    var embed_1 = require(105) /* ./embed */;
    exports.index = embed_1.index;
    var protocol = require(450) /* ./protocol */;
    exports.protocol = protocol;
    var _testing = require(451) /* ./testing */;
    exports._testing = _testing;
    var logging_1 = require(167) /* ./core/logging */;
    exports.logger = logging_1.logger;
    exports.set_log_level = logging_1.set_log_level;
    var settings_1 = require(128) /* ./core/settings */;
    exports.settings = settings_1.settings;
    var base_1 = require(108) /* ./base */;
    exports.Models = base_1.Models;
    var document_1 = require(106) /* ./document */;
    exports.documents = document_1.documents;
    var safely_1 = require(452) /* ./safely */;
    exports.safely = safely_1.safely;
},
/* version.js */ function _(require, module, exports) {
    exports.version = '1.4.0';
},
/* embed/index.js */ function _(require, module, exports) {
    var document_1 = require(106) /* ../document */;
    var logging_1 = require(167) /* ../core/logging */;
    var callback_1 = require(119) /* ../core/util/callback */;
    var string_1 = require(127) /* ../core/util/string */;
    var types_1 = require(109) /* ../core/util/types */;
    var standalone_1 = require(441) /* ./standalone */;
    var server_1 = require(443) /* ./server */;
    var dom_1 = require(442) /* ./dom */;
    var standalone_2 = require(441) /* ./standalone */;
    exports.add_document_standalone = standalone_2.add_document_standalone;
    exports.index = standalone_2.index;
    var server_2 = require(443) /* ./server */;
    exports.add_document_from_session = server_2.add_document_from_session;
    var notebook_1 = require(448) /* ./notebook */;
    exports.embed_items_notebook = notebook_1.embed_items_notebook;
    exports.kernels = notebook_1.kernels;
    var dom_2 = require(442) /* ./dom */;
    exports.BOKEH_ROOT = dom_2.BOKEH_ROOT;
    function embed_item(item, target_id) {
        var _a;
        var docs_json = {};
        var doc_id = string_1.uuid4();
        docs_json[doc_id] = item.doc;
        if (target_id == null)
            target_id = item.target_id;
        var element = document.getElementById(target_id);
        if (element != null)
            element.classList.add(dom_1.BOKEH_ROOT);
        var roots = (_a = {}, _a[item.root_id] = target_id, _a);
        var render_item = { roots: roots, docid: doc_id };
        callback_1.defer(function () { return _embed_items(docs_json, [render_item]); });
    }
    exports.embed_item = embed_item;
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    function embed_items(docs_json, render_items, app_path, absolute_url) {
        callback_1.defer(function () { return _embed_items(docs_json, render_items, app_path, absolute_url); });
    }
    exports.embed_items = embed_items;
    function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if (types_1.isString(docs_json))
            docs_json = JSON.parse(string_1.unescape(docs_json));
        var docs = {};
        for (var docid in docs_json) {
            var doc_json = docs_json[docid];
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        for (var _i = 0, render_items_1 = render_items; _i < render_items_1.length; _i++) {
            var item = render_items_1[_i];
            var element = dom_1._resolve_element(item);
            var roots = dom_1._resolve_root_elements(item);
            if (item.docid != null) {
                standalone_1.add_document_standalone(docs[item.docid], element, roots, item.use_for_title);
            }
            else if (item.sessionid != null) {
                var websocket_url = server_1._get_ws_url(app_path, absolute_url);
                logging_1.logger.debug("embed: computed ws url: " + websocket_url);
                var promise = server_1.add_document_from_session(websocket_url, item.sessionid, element, roots, item.use_for_title);
                promise.then(function () {
                    console.log("Bokeh items were rendered successfully");
                }, function (error) {
                    console.log("Error rendering Bokeh items:", error);
                });
            }
            else
                throw new Error("Error rendering Bokeh items: either 'docid' or 'sessionid' was expected.");
        }
    }
},
/* document/index.js */ function _(require, module, exports) {
    function __export(m) {
        for (var p in m)
            if (!exports.hasOwnProperty(p))
                exports[p] = m[p];
    }
    __export(require(107) /* ./document */);
    __export(require(199) /* ./events */);
},
/* document/document.js */ function _(require, module, exports) {
    var base_1 = require(108) /* ../base */;
    var version_1 = require(104) /* ../version */;
    var logging_1 = require(167) /* ../core/logging */;
    var bokeh_events_1 = require(376) /* ../core/bokeh_events */;
    var has_props_1 = require(115) /* ../core/has_props */;
    var signaling_1 = require(116) /* ../core/signaling */;
    var refs_1 = require(126) /* ../core/util/refs */;
    var serialization_1 = require(196) /* ../core/util/serialization */;
    var data_structures_1 = require(117) /* ../core/util/data_structures */;
    var array_1 = require(110) /* ../core/util/array */;
    var object_1 = require(125) /* ../core/util/object */;
    var eq_1 = require(118) /* ../core/util/eq */;
    var types_1 = require(109) /* ../core/util/types */;
    var layout_dom_1 = require(339) /* ../models/layouts/layout_dom */;
    var column_data_source_1 = require(170) /* ../models/sources/column_data_source */;
    var model_1 = require(166) /* ../model */;
    var events_1 = require(199) /* ./events */;
    var EventManager = /** @class */ (function () {
        function EventManager(document) {
            this.document = document;
            // Dispatches events to the subscribed models
            this.session = null;
            this.subscribed_models = new data_structures_1.Set();
        }
        EventManager.prototype.send_event = function (event) {
            if (this.session != null)
                this.session.send_event(event);
        };
        EventManager.prototype.trigger = function (event) {
            for (var _i = 0, _a = this.subscribed_models.values; _i < _a.length; _i++) {
                var id = _a[_i];
                if (event.origin != null && event.origin.id !== id)
                    continue;
                var model = this.document._all_models[id];
                if (model != null && model instanceof model_1.Model)
                    model._process_event(event);
            }
        };
        return EventManager;
    }());
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    var Document = /** @class */ (function () {
        function Document() {
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = {};
            this._all_models_by_name = new data_structures_1.MultiDict();
            this._all_models_freeze_count = 0;
            this._callbacks = [];
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakMap(); // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        Object.defineProperty(Document.prototype, "layoutables", {
            get: function () {
                return this._roots.filter(function (root) { return root instanceof layout_dom_1.LayoutDOM; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Document.prototype, "is_idle", {
            get: function () {
                for (var _i = 0, _a = this.layoutables; _i < _a.length; _i++) {
                    var root = _a[_i];
                    if (!this._idle_roots.has(root))
                        return false;
                }
                return true;
            },
            enumerable: true,
            configurable: true
        });
        Document.prototype.notify_idle = function (model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info("document idle at " + (Date.now() - this._init_timestamp) + " ms");
                this.idle.emit();
            }
        };
        Document.prototype.clear = function () {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        };
        Document.prototype.interactive_start = function (plot) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart());
            }
            this._interactive_timestamp = Date.now();
        };
        Document.prototype.interactive_stop = function (plot) {
            if (this._interactive_plot != null && this._interactive_plot.id === plot.id) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd());
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
        };
        Document.prototype.interactive_duration = function () {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        };
        Document.prototype.destructively_move = function (dest_doc) {
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            var roots = array_1.copy(this._roots);
            this.clear();
            for (var _i = 0, roots_1 = roots; _i < roots_1.length; _i++) {
                var root = roots_1[_i];
                if (root.document != null)
                    throw new Error("Somehow we didn't detach " + root);
            }
            if (Object.keys(this._all_models).length !== 0) {
                throw new Error("this._all_models still had stuff in it: " + this._all_models);
            }
            for (var _a = 0, roots_2 = roots; _a < roots_2.length; _a++) {
                var root = roots_2[_a];
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        };
        // TODO other fields of doc
        Document.prototype._push_all_models_freeze = function () {
            this._all_models_freeze_count += 1;
        };
        Document.prototype._pop_all_models_freeze = function () {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        /*protected*/ Document.prototype._invalidate_all_models = function () {
            logging_1.logger.debug("invalidating document models");
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        Document.prototype._recompute_all_models = function () {
            var new_all_models_set = new data_structures_1.Set();
            for (var _i = 0, _a = this._roots; _i < _a.length; _i++) {
                var r = _a[_i];
                new_all_models_set = new_all_models_set.union(r.references());
            }
            var old_all_models_set = new data_structures_1.Set(object_1.values(this._all_models));
            var to_detach = old_all_models_set.diff(new_all_models_set);
            var to_attach = new_all_models_set.diff(old_all_models_set);
            var recomputed = {};
            for (var _b = 0, _c = new_all_models_set.values; _b < _c.length; _b++) {
                var m = _c[_b];
                recomputed[m.id] = m;
            }
            for (var _d = 0, _e = to_detach.values; _d < _e.length; _d++) {
                var d = _e[_d];
                d.detach_document();
                if (d instanceof model_1.Model && d.name != null)
                    this._all_models_by_name.remove_value(d.name, d);
            }
            for (var _f = 0, _g = to_attach.values; _f < _g.length; _f++) {
                var a = _g[_f];
                a.attach_document(this);
                if (a instanceof model_1.Model && a.name != null)
                    this._all_models_by_name.add_value(a.name, a);
            }
            this._all_models = recomputed;
        };
        Document.prototype.roots = function () {
            return this._roots;
        };
        Document.prototype.add_root = function (model, setter_id) {
            logging_1.logger.debug("Adding root: " + model);
            if (array_1.includes(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootAddedEvent(this, model, setter_id));
        };
        Document.prototype.remove_root = function (model, setter_id) {
            var i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootRemovedEvent(this, model, setter_id));
        };
        Document.prototype.title = function () {
            return this._title;
        };
        Document.prototype.set_title = function (title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new events_1.TitleChangedEvent(this, title, setter_id));
            }
        };
        Document.prototype.get_model_by_id = function (model_id) {
            if (model_id in this._all_models) {
                return this._all_models[model_id];
            }
            else {
                return null;
            }
        };
        Document.prototype.get_model_by_name = function (name) {
            return this._all_models_by_name.get_one(name, "Multiple models are named '" + name + "'");
        };
        Document.prototype.on_change = function (callback) {
            if (!array_1.includes(this._callbacks, callback))
                this._callbacks.push(callback);
        };
        Document.prototype.remove_on_change = function (callback) {
            var i = this._callbacks.indexOf(callback);
            if (i >= 0)
                this._callbacks.splice(i, 1);
        };
        Document.prototype._trigger_on_change = function (event) {
            for (var _i = 0, _a = this._callbacks; _i < _a.length; _i++) {
                var cb = _a[_i];
                cb(event);
            }
        };
        // called by the model
        Document.prototype._notify_change = function (model, attr, old, new_, options) {
            if (attr === 'name') {
                this._all_models_by_name.remove_value(old, model);
                if (new_ != null)
                    this._all_models_by_name.add_value(new_, model);
            }
            var setter_id = options != null ? options.setter_id : void 0;
            var hint = options != null ? options.hint : void 0;
            this._trigger_on_change(new events_1.ModelChangedEvent(this, model, attr, old, new_, setter_id, hint));
        };
        Document._references_json = function (references, include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var references_json = [];
            for (var _i = 0, references_1 = references; _i < references_1.length; _i++) {
                var r = references_1[_i];
                var ref = r.ref();
                ref.attributes = r.attributes_as_json(include_defaults);
                // server doesn't want id in here since it's already in ref above
                delete ref.attributes.id;
                references_json.push(ref);
            }
            return references_json;
        };
        Document._instantiate_object = function (obj_id, obj_type, obj_attrs) {
            var full_attrs = Object.assign(Object.assign({}, obj_attrs), { id: obj_id, __deferred__: true });
            var model = base_1.Models(obj_type);
            return new model(full_attrs);
        };
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        Document._instantiate_references_json = function (references_json, existing_models) {
            // Create all instances, but without setting their props
            var references = {};
            for (var _i = 0, references_json_1 = references_json; _i < references_json_1.length; _i++) {
                var obj = references_json_1[_i];
                var obj_id = obj.id;
                var obj_type = obj.type;
                var obj_attrs = obj.attributes || {};
                var instance = void 0;
                if (obj_id in existing_models)
                    instance = existing_models[obj_id];
                else {
                    instance = Document._instantiate_object(obj_id, obj_type, obj_attrs);
                    if (obj.subtype != null)
                        instance.set_subtype(obj.subtype);
                }
                references[instance.id] = instance;
            }
            return references;
        };
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        Document._resolve_refs = function (value, old_references, new_references) {
            function resolve_ref(v) {
                if (refs_1.is_ref(v)) {
                    if (v.id in old_references)
                        return old_references[v.id];
                    else if (v.id in new_references)
                        return new_references[v.id];
                    else
                        throw new Error("reference " + JSON.stringify(v) + " isn't known (not in Document?)");
                }
                else if (types_1.isArray(v))
                    return resolve_array(v);
                else if (types_1.isPlainObject(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                var results = [];
                for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                    var v = array_2[_i];
                    results.push(resolve_ref(v));
                }
                return results;
            }
            function resolve_dict(dict) {
                var resolved = {};
                for (var k in dict) {
                    var v = dict[k];
                    resolved[k] = resolve_ref(v);
                }
                return resolved;
            }
            return resolve_ref(value);
        };
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        Document._initialize_references_json = function (references_json, old_references, new_references) {
            var to_update = {};
            for (var _i = 0, references_json_2 = references_json; _i < references_json_2.length; _i++) {
                var obj = references_json_2[_i];
                var obj_id = obj.id;
                var obj_attrs = obj.attributes;
                var was_new = !(obj_id in old_references);
                var instance = !was_new ? old_references[obj_id] : new_references[obj_id];
                // replace references with actual instances in obj_attrs
                var resolved_attrs = Document._resolve_refs(obj_attrs, old_references, new_references);
                to_update[instance.id] = [instance, resolved_attrs, was_new];
            }
            function foreach_depth_first(items, f) {
                var already_started = {};
                function foreach_value(v) {
                    if (v instanceof has_props_1.HasProps) {
                        // note that we ignore instances that aren't updated (not in to_update)
                        if (!(v.id in already_started) && v.id in items) {
                            already_started[v.id] = true;
                            var _a = items[v.id], attrs = _a[1], was_new = _a[2];
                            for (var a in attrs) {
                                var e = attrs[a];
                                foreach_value(e);
                            }
                            f(v, attrs, was_new);
                        }
                    }
                    else if (types_1.isArray(v)) {
                        for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                            var e = v_1[_i];
                            foreach_value(e);
                        }
                    }
                    else if (types_1.isPlainObject(v)) {
                        for (var k in v) {
                            var e = v[k];
                            foreach_value(e);
                        }
                    }
                }
                for (var k in items) {
                    var _a = items[k], instance = _a[0];
                    foreach_value(instance);
                }
            }
            // this first pass removes all 'refs' replacing them with real instances
            foreach_depth_first(to_update, function (instance, attrs, was_new) {
                if (was_new)
                    instance.setv(attrs, { silent: true });
            });
            // after removing all the refs, we can run the initialize code safely
            foreach_depth_first(to_update, function (instance, _attrs, was_new) {
                if (was_new)
                    instance.finalize();
            });
        };
        Document._event_for_attribute_change = function (changed_obj, key, new_value, doc, value_refs) {
            var changed_model = doc.get_model_by_id(changed_obj.id); // XXX!
            if (!changed_model.attribute_is_serializable(key))
                return null;
            else {
                var event = {
                    kind: "ModelChanged",
                    model: {
                        id: changed_obj.id,
                        type: changed_obj.type,
                    },
                    attr: key,
                    new: new_value,
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, true); // true = recurse
                return event;
            }
        };
        Document._events_to_sync_objects = function (from_obj, to_obj, to_doc, value_refs) {
            var from_keys = Object.keys(from_obj.attributes); //XXX!
            var to_keys = Object.keys(to_obj.attributes); //XXX!
            var removed = array_1.difference(from_keys, to_keys);
            var added = array_1.difference(to_keys, from_keys);
            var shared = array_1.intersection(from_keys, to_keys);
            var events = [];
            for (var _i = 0, removed_1 = removed; _i < removed_1.length; _i++) {
                var key = removed_1[_i];
                // we don't really have a "remove" event - not sure this ever
                // happens even. One way this could happen is if the server
                // does include_defaults=True and we do
                // include_defaults=false ... in that case it'd be best to
                // just ignore this probably. Warn about it, could mean
                // there's a bug if we don't have a key that the server sent.
                logging_1.logger.warn("Server sent key " + key + " but we don't seem to have it in our JSON");
            }
            for (var _a = 0, added_1 = added; _a < added_1.length; _a++) {
                var key = added_1[_a];
                var new_value = to_obj.attributes[key]; // XXX!
                events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
            }
            for (var _b = 0, shared_1 = shared; _b < shared_1.length; _b++) {
                var key = shared_1[_b];
                var old_value = from_obj.attributes[key]; // XXX!
                var new_value = to_obj.attributes[key]; // XXX!
                if (old_value == null && new_value == null) {
                }
                else if (old_value == null || new_value == null) {
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
                else {
                    if (!eq_1.isEqual(old_value, new_value))
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            return events.filter(function (e) { return e != null; });
        };
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        Document._compute_patch_since_json = function (from_json, to_doc) {
            var to_json = to_doc.to_json(false); // include_defaults=false
            function refs(json) {
                var result = {};
                for (var _i = 0, _a = json.roots.references; _i < _a.length; _i++) {
                    var obj = _a[_i];
                    result[obj.id] = obj;
                }
                return result;
            }
            var from_references = refs(from_json);
            var from_roots = {};
            var from_root_ids = [];
            for (var _i = 0, _a = from_json.roots.root_ids; _i < _a.length; _i++) {
                var r = _a[_i];
                from_roots[r] = from_references[r];
                from_root_ids.push(r);
            }
            var to_references = refs(to_json);
            var to_roots = {};
            var to_root_ids = [];
            for (var _b = 0, _c = to_json.roots.root_ids; _b < _c.length; _b++) {
                var r = _c[_b];
                to_roots[r] = to_references[r];
                to_root_ids.push(r);
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if (array_1.difference(from_root_ids, to_root_ids).length > 0 ||
                array_1.difference(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error("Not implemented: computing add/remove of document roots");
            }
            var value_refs = {};
            var events = [];
            for (var id in to_doc._all_models) {
                if (id in from_references) {
                    var update_model_events = Document._events_to_sync_objects(from_references[id], to_references[id], to_doc, value_refs);
                    events = events.concat(update_model_events);
                }
            }
            return {
                references: Document._references_json(object_1.values(value_refs), false),
                events: events,
            };
        };
        Document.prototype.to_json_string = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            return JSON.stringify(this.to_json(include_defaults));
        };
        Document.prototype.to_json = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var root_ids = this._roots.map(function (r) { return r.id; });
            var root_references = object_1.values(this._all_models);
            return {
                version: version_1.version,
                title: this._title,
                roots: {
                    root_ids: root_ids,
                    references: Document._references_json(root_references, include_defaults),
                },
            };
        };
        Document.from_json_string = function (s) {
            var json = JSON.parse(s);
            return Document.from_json(json);
        };
        Document.from_json = function (json) {
            logging_1.logger.debug("Creating Document from JSON");
            var py_version = json.version; // XXX!
            var is_dev = py_version.indexOf('+') !== -1 || py_version.indexOf('-') !== -1;
            var versions_string = "Library versions: JS (" + version_1.version + ") / Python (" + py_version + ")";
            if (!is_dev && version_1.version !== py_version) {
                logging_1.logger.warn("JS/Python version mismatch");
                logging_1.logger.warn(versions_string);
            }
            else
                logging_1.logger.debug(versions_string);
            var roots_json = json.roots;
            var root_ids = roots_json.root_ids;
            var references_json = roots_json.references;
            var references = Document._instantiate_references_json(references_json, {});
            Document._initialize_references_json(references_json, {}, references);
            var doc = new Document();
            for (var _i = 0, root_ids_1 = root_ids; _i < root_ids_1.length; _i++) {
                var r = root_ids_1[_i];
                doc.add_root(references[r]);
            } // XXX: HasProps
            doc.set_title(json.title); // XXX!
            return doc;
        };
        Document.prototype.replace_with_json = function (json) {
            var replacement = Document.from_json(json);
            replacement.destructively_move(this);
        };
        Document.prototype.create_json_patch_string = function (events) {
            return JSON.stringify(this.create_json_patch(events));
        };
        Document.prototype.create_json_patch = function (events) {
            var references = {};
            var json_events = [];
            for (var _i = 0, events_2 = events; _i < events_2.length; _i++) {
                var event = events_2[_i];
                if (event.document !== this) {
                    logging_1.logger.warn("Cannot create a patch using events from a different document, event had ", event.document, " we are ", this);
                    throw new Error("Cannot create a patch using events from a different document");
                }
                json_events.push(event.json(references));
            }
            return {
                events: json_events,
                references: Document._references_json(object_1.values(references)),
            };
        };
        Document.prototype.apply_json_patch = function (patch, buffers, setter_id) {
            var _a;
            if (buffers === void 0) {
                buffers = [];
            }
            var references_json = patch.references;
            var events_json = patch.events;
            var references = Document._instantiate_references_json(references_json, this._all_models);
            // The model being changed isn't always in references so add it in
            for (var _i = 0, events_json_1 = events_json; _i < events_json_1.length; _i++) {
                var event_json = events_json_1[_i];
                switch (event_json.kind) {
                    case "RootAdded":
                    case "RootRemoved":
                    case "ModelChanged": {
                        var model_id = event_json.model.id;
                        if (model_id in this._all_models) {
                            references[model_id] = this._all_models[model_id];
                        }
                        else {
                            if (!(model_id in references)) {
                                logging_1.logger.warn("Got an event for unknown model ", event_json.model);
                                throw new Error("event model wasn't known");
                            }
                        }
                        break;
                    }
                }
            }
            // split references into old and new so we know whether to initialize or update
            var old_references = {};
            var new_references = {};
            for (var id in references) {
                var value = references[id];
                if (id in this._all_models)
                    old_references[id] = value;
                else
                    new_references[id] = value;
            }
            Document._initialize_references_json(references_json, old_references, new_references);
            for (var _b = 0, events_json_2 = events_json; _b < events_json_2.length; _b++) {
                var event_json = events_json_2[_b];
                switch (event_json.kind) {
                    case 'ModelChanged': {
                        var patched_id = event_json.model.id;
                        if (!(patched_id in this._all_models)) {
                            throw new Error("Cannot apply patch to " + patched_id + " which is not in the document");
                        }
                        var patched_obj = this._all_models[patched_id];
                        var attr = event_json.attr;
                        var model_type = event_json.model.type;
                        // XXXX currently still need this first branch, some updates (initial?) go through here
                        if (attr === 'data' && model_type === 'ColumnDataSource') {
                            var _c = serialization_1.decode_column_data(event_json.new, buffers), data = _c[0], shapes = _c[1];
                            patched_obj.setv({ _shapes: shapes, data: data }, { setter_id: setter_id });
                        }
                        else {
                            var value = Document._resolve_refs(event_json.new, old_references, new_references);
                            patched_obj.setv((_a = {}, _a[attr] = value, _a), { setter_id: setter_id });
                        }
                        break;
                    }
                    case 'ColumnDataChanged': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                        }
                        var column_source = this._all_models[column_source_id];
                        var _d = serialization_1.decode_column_data(event_json.new, buffers), data = _d[0], shapes = _d[1];
                        if (event_json.cols != null) {
                            for (var k in column_source.data) {
                                if (!(k in data)) {
                                    data[k] = column_source.data[k];
                                }
                            }
                            for (var k in column_source._shapes) {
                                if (!(k in shapes)) {
                                    shapes[k] = column_source._shapes[k];
                                }
                            }
                        }
                        column_source.setv({
                            _shapes: shapes,
                            data: data,
                        }, {
                            setter_id: setter_id,
                            check_eq: false,
                        });
                        break;
                    }
                    case 'ColumnsStreamed': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                        }
                        var column_source = this._all_models[column_source_id];
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error("Cannot stream to non-ColumnDataSource");
                        }
                        var data = event_json.data;
                        var rollover = event_json.rollover;
                        column_source.stream(data, rollover, setter_id);
                        break;
                    }
                    case 'ColumnsPatched': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error("Cannot patch " + column_source_id + " which is not in the document");
                        }
                        var column_source = this._all_models[column_source_id];
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error("Cannot patch non-ColumnDataSource");
                        }
                        var patches = event_json.patches;
                        column_source.patch(patches, setter_id);
                        break;
                    }
                    case 'RootAdded': {
                        var root_id = event_json.model.id;
                        var root_obj = references[root_id];
                        this.add_root(root_obj, setter_id); // XXX: HasProps
                        break;
                    }
                    case 'RootRemoved': {
                        var root_id = event_json.model.id;
                        var root_obj = references[root_id];
                        this.remove_root(root_obj, setter_id); // XXX: HasProps
                        break;
                    }
                    case 'TitleChanged': {
                        this.set_title(event_json.title, setter_id);
                        break;
                    }
                    default:
                        throw new Error("Unknown patch event " + JSON.stringify(event_json));
                }
            }
        };
        return Document;
    }());
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports) {
    var types_1 = require(109) /* ./core/util/types */;
    var has_props_1 = require(115) /* ./core/has_props */;
    exports.overrides = {};
    var _all_models = new Map();
    exports.Models = (function (name) {
        var model = exports.overrides[name] || _all_models.get(name);
        if (model == null) {
            throw new Error("Model '" + name + "' does not exist. This could be due to a widget or a custom model not being registered before first usage.");
        }
        return model;
    });
    exports.Models.register = function (name, model) {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = function (name) {
        delete exports.overrides[name];
    };
    function is_HasProps(obj) {
        return types_1.isObject(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    exports.Models.register_models = function (models, force, errorFn) {
        if (force === void 0) {
            force = false;
        }
        if (models == null)
            return;
        for (var name in models) {
            var model = models[name];
            if (is_HasProps(model)) {
                var qualified = model.__qualified__;
                if (force || !_all_models.has(qualified))
                    _all_models.set(qualified, model);
                else if (errorFn != null)
                    errorFn(qualified);
                else
                    console.warn("Model '" + qualified + "' was already registered");
            }
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = function () { return Array.from(_all_models.keys()); };
    // TODO: this doesn't belong here, but it's easier this way for backwards compatibility
    var AllModels = require(129) /* ./models */;
    exports.register_models(AllModels);
},
/* core/util/types.js */ function _(require, module, exports) {
    var array_1 = require(110) /* ./array */;
    var toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && isFinite(obj) && Math.floor(obj) === obj;
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    exports.isString = isString;
    function isStrictNaN(obj) {
        return isNumber(obj) && obj !== +obj;
    }
    exports.isStrictNaN = isStrictNaN;
    function isFunction(obj) {
        return toString.call(obj) === "[object Function]";
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(arr, predicate) {
        return array_1.every(arr, predicate);
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(arr, predicate) {
        for (var i = 0, end = arr.length; i < end; i++) {
            if (!predicate(arr[i]))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return obj != null && obj.buffer instanceof ArrayBuffer;
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        var tp = typeof obj;
        return tp === 'function' || tp === 'object' && !!obj;
    }
    exports.isObject = isObject;
    function isPlainObject(obj) {
        return isObject(obj) && (obj.constructor == null || obj.constructor === Object);
    }
    exports.isPlainObject = isPlainObject;
},
/* core/util/array.js */ function _(require, module, exports) {
    var math_1 = require(111) /* ./math */;
    var assert_1 = require(112) /* ./assert */;
    var arrayable_1 = require(114) /* ./arrayable */;
    exports.map = arrayable_1.map;
    exports.reduce = arrayable_1.reduce;
    exports.min = arrayable_1.min;
    exports.min_by = arrayable_1.min_by;
    exports.max = arrayable_1.max;
    exports.max_by = arrayable_1.max_by;
    exports.sum = arrayable_1.sum;
    exports.cumsum = arrayable_1.cumsum;
    exports.every = arrayable_1.every;
    exports.some = arrayable_1.some;
    exports.find = arrayable_1.find;
    exports.find_last = arrayable_1.find_last;
    exports.find_index = arrayable_1.find_index;
    exports.find_last_index = arrayable_1.find_last_index;
    exports.sorted_index = arrayable_1.sorted_index;
    var slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return [].concat.apply([], arrays);
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip() {
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        if (arrays.length == 0)
            return [];
        var n = arrayable_1.min(arrays.map(function (a) { return a.length; }));
        var k = arrays.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (var j = 0; j < k; j++)
                result[i][j] = arrays[j][i];
        }
        return result;
    }
    exports.zip = zip;
    function unzip(array) {
        var n = array.length;
        var k = arrayable_1.min(array.map(function (a) { return a.length; }));
        var results = Array(k);
        for (var j = 0; j < k; j++)
            results[j] = new Array(n);
        for (var i = 0; i < n; i++) {
            for (var j = 0; j < k; j++)
                results[j][i] = array[i][j];
        }
        return results;
    }
    exports.unzip = unzip;
    function range(start, stop, step) {
        if (step === void 0) {
            step = 1;
        }
        assert_1.assert(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        var max = Math.max, ceil = Math.ceil, abs = Math.abs;
        var delta = start <= stop ? step : -step;
        var length = max(ceil(abs(stop - start) / step), 0);
        var range = Array(length);
        for (var i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num) {
        if (num === void 0) {
            num = 100;
        }
        var step = (stop - start) / (num - 1);
        var array = new Array(num);
        for (var i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        var rows = array.length;
        var cols = array[0].length;
        var transposed = [];
        for (var j = 0; j < cols; j++) {
            transposed[j] = [];
            for (var i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function argmin(array) {
        return arrayable_1.min_by(range(array.length), function (i) { return array[i]; });
    }
    exports.argmin = argmin;
    function argmax(array) {
        return arrayable_1.max_by(range(array.length), function (i) { return array[i]; });
    }
    exports.argmax = argmax;
    function sort_by(array, key) {
        var tmp = array.map(function (value, index) {
            return { value: value, index: index, key: key(value) };
        });
        tmp.sort(function (left, right) {
            var a = left.key;
            var b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map(function (item) { return item.value; });
    }
    exports.sort_by = sort_by;
    function uniq(array) {
        var result = [];
        for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
            var value = array_1[_i];
            if (!includes(result, value)) {
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq = uniq;
    function uniq_by(array, key) {
        var result = [];
        var seen = [];
        for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
            var value = array_2[_i];
            var computed = key(value);
            if (!includes(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq_by = uniq_by;
    function union() {
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        return uniq(concat(arrays));
    }
    exports.union = union;
    function intersection(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var result = [];
        top: for (var _a = 0, array_3 = array; _a < array_3.length; _a++) {
            var item = array_3[_a];
            if (includes(result, item))
                continue;
            for (var _b = 0, arrays_1 = arrays; _b < arrays_1.length; _b++) {
                var other = arrays_1[_b];
                if (!includes(other, item))
                    continue top;
            }
            result.push(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var rest = concat(arrays);
        return array.filter(function (value) { return !includes(rest, value); });
    }
    exports.difference = difference;
    function remove_at(array, i) {
        var result = copy(array);
        result.splice(i, 1);
        return result;
    }
    exports.remove_at = remove_at;
    function remove_by(array, key) {
        for (var i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.remove_by = remove_by;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        var length = array.length;
        var shuffled = new Array(length);
        for (var i = 0; i < length; i++) {
            var rand = math_1.randomIn(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        var n = array.length;
        var result = new Array(n - 1);
        for (var i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        var n = array.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
},
/* core/util/math.js */ function _(require, module, exports) {
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * Math.PI;
        }
        while (angle > 2 * Math.PI) {
            angle -= 2 * Math.PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, direction) {
        var d = angle_dist(lhs, rhs);
        if (d == 0)
            return false;
        if (d == 2 * Math.PI)
            return true;
        var norm_mid = angle_norm(mid);
        var cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return (direction == 0 /* clock */) ? cond : !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        var r1;
        var r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        var rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        if (val > max)
            return max;
        if (val < min)
            return min;
        return val;
    }
    exports.clamp = clamp;
},
/* core/util/assert.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var AssertionError = /** @class */ (function (_super) {
        tslib_1.__extends(AssertionError, _super);
        function AssertionError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AssertionError;
    }(Error));
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition()))
            return;
        throw new AssertionError(message || "Assertion failed");
    }
    exports.assert = assert;
},
/* tslib/tslib.js */ function _(require, module, exports) {
    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global global, define, System, Reflect, Promise */
    var __extends;
    var __assign;
    var __rest;
    var __decorate;
    var __param;
    var __metadata;
    var __awaiter;
    var __generator;
    var __exportStar;
    var __values;
    var __read;
    var __spread;
    var __spreadArrays;
    var __await;
    var __asyncGenerator;
    var __asyncDelegator;
    var __asyncValues;
    var __makeTemplateObject;
    var __importStar;
    var __importDefault;
    (function (factory) {
        var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
        if (typeof define === "function" && define.amd) {
            define("tslib", ["exports"], function (exports) { factory(createExporter(root, createExporter(exports))); });
        }
        else if (typeof module === "object" && typeof module.exports === "object") {
            factory(createExporter(root, createExporter(module.exports)));
        }
        else {
            factory(createExporter(root));
        }
        function createExporter(exports, previous) {
            if (exports !== root) {
                if (typeof Object.create === "function") {
                    Object.defineProperty(exports, "__esModule", { value: true });
                }
                else {
                    exports.__esModule = true;
                }
            }
            return function (id, v) { return exports[id] = previous ? previous(id, v) : v; };
        }
    })(function (exporter) {
        var extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (b.hasOwnProperty(p))
                        d[p] = b[p];
            };
        __extends = function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        __rest = function (s, e) {
            var t = {};
            for (var p in s)
                if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                    t[p] = s[p];
            if (s != null && typeof Object.getOwnPropertySymbols === "function")
                for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                        t[p[i]] = s[p[i]];
                }
            return t;
        };
        __decorate = function (decorators, target, key, desc) {
            var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
            if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
                r = Reflect.decorate(decorators, target, key, desc);
            else
                for (var i = decorators.length - 1; i >= 0; i--)
                    if (d = decorators[i])
                        r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
            return c > 3 && r && Object.defineProperty(target, key, r), r;
        };
        __param = function (paramIndex, decorator) {
            return function (target, key) { decorator(target, key, paramIndex); };
        };
        __metadata = function (metadataKey, metadataValue) {
            if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
                return Reflect.metadata(metadataKey, metadataValue);
        };
        __awaiter = function (thisArg, _arguments, P, generator) {
            return new (P || (P = Promise))(function (resolve, reject) {
                function fulfilled(value) {
                    try {
                        step(generator.next(value));
                    }
                    catch (e) {
                        reject(e);
                    }
                }
                function rejected(value) {
                    try {
                        step(generator["throw"](value));
                    }
                    catch (e) {
                        reject(e);
                    }
                }
                function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
                step((generator = generator.apply(thisArg, _arguments || [])).next());
            });
        };
        __generator = function (thisArg, body) {
            var _ = { label: 0, sent: function () {
                    if (t[0] & 1)
                        throw t[1];
                    return t[1];
                }, trys: [], ops: [] }, f, y, t, g;
            return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
            function verb(n) { return function (v) { return step([n, v]); }; }
            function step(op) {
                if (f)
                    throw new TypeError("Generator is already executing.");
                while (_)
                    try {
                        if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                            return t;
                        if (y = 0, t)
                            op = [op[0] & 2, t.value];
                        switch (op[0]) {
                            case 0:
                            case 1:
                                t = op;
                                break;
                            case 4:
                                _.label++;
                                return { value: op[1], done: false };
                            case 5:
                                _.label++;
                                y = op[1];
                                op = [0];
                                continue;
                            case 7:
                                op = _.ops.pop();
                                _.trys.pop();
                                continue;
                            default:
                                if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                    _ = 0;
                                    continue;
                                }
                                if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                    _.label = op[1];
                                    break;
                                }
                                if (op[0] === 6 && _.label < t[1]) {
                                    _.label = t[1];
                                    t = op;
                                    break;
                                }
                                if (t && _.label < t[2]) {
                                    _.label = t[2];
                                    _.ops.push(op);
                                    break;
                                }
                                if (t[2])
                                    _.ops.pop();
                                _.trys.pop();
                                continue;
                        }
                        op = body.call(thisArg, _);
                    }
                    catch (e) {
                        op = [6, e];
                        y = 0;
                    }
                    finally {
                        f = t = 0;
                    }
                if (op[0] & 5)
                    throw op[1];
                return { value: op[0] ? op[1] : void 0, done: true };
            }
        };
        __exportStar = function (m, exports) {
            for (var p in m)
                if (!exports.hasOwnProperty(p))
                    exports[p] = m[p];
        };
        __values = function (o) {
            var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
            if (m)
                return m.call(o);
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        };
        __read = function (o, n) {
            var m = typeof Symbol === "function" && o[Symbol.iterator];
            if (!m)
                return o;
            var i = m.call(o), r, ar = [], e;
            try {
                while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                    ar.push(r.value);
            }
            catch (error) {
                e = { error: error };
            }
            finally {
                try {
                    if (r && !r.done && (m = i["return"]))
                        m.call(i);
                }
                finally {
                    if (e)
                        throw e.error;
                }
            }
            return ar;
        };
        __spread = function () {
            for (var ar = [], i = 0; i < arguments.length; i++)
                ar = ar.concat(__read(arguments[i]));
            return ar;
        };
        __spreadArrays = function () {
            for (var s = 0, i = 0, il = arguments.length; i < il; i++)
                s += arguments[i].length;
            for (var r = Array(s), k = 0, i = 0; i < il; i++)
                for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                    r[k] = a[j];
            return r;
        };
        __await = function (v) {
            return this instanceof __await ? (this.v = v, this) : new __await(v);
        };
        __asyncGenerator = function (thisArg, _arguments, generator) {
            if (!Symbol.asyncIterator)
                throw new TypeError("Symbol.asyncIterator is not defined.");
            var g = generator.apply(thisArg, _arguments || []), i, q = [];
            return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
            function verb(n) {
                if (g[n])
                    i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
            }
            function resume(n, v) {
                try {
                    step(g[n](v));
                }
                catch (e) {
                    settle(q[0][3], e);
                }
            }
            function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
            function fulfill(value) { resume("next", value); }
            function reject(value) { resume("throw", value); }
            function settle(f, v) {
                if (f(v), q.shift(), q.length)
                    resume(q[0][0], q[0][1]);
            }
        };
        __asyncDelegator = function (o) {
            var i, p;
            return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
            function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
        };
        __asyncValues = function (o) {
            if (!Symbol.asyncIterator)
                throw new TypeError("Symbol.asyncIterator is not defined.");
            var m = o[Symbol.asyncIterator], i;
            return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
            function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
            function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
        };
        __makeTemplateObject = function (cooked, raw) {
            if (Object.defineProperty) {
                Object.defineProperty(cooked, "raw", { value: raw });
            }
            else {
                cooked.raw = raw;
            }
            return cooked;
        };
        __importStar = function (mod) {
            if (mod && mod.__esModule)
                return mod;
            var result = {};
            if (mod != null)
                for (var k in mod)
                    if (Object.hasOwnProperty.call(mod, k))
                        result[k] = mod[k];
            result["default"] = mod;
            return result;
        };
        __importDefault = function (mod) {
            return (mod && mod.__esModule) ? mod : { "default": mod };
        };
        exporter("__extends", __extends);
        exporter("__assign", __assign);
        exporter("__rest", __rest);
        exporter("__decorate", __decorate);
        exporter("__param", __param);
        exporter("__metadata", __metadata);
        exporter("__awaiter", __awaiter);
        exporter("__generator", __generator);
        exporter("__exportStar", __exportStar);
        exporter("__values", __values);
        exporter("__read", __read);
        exporter("__spread", __spread);
        exporter("__spreadArrays", __spreadArrays);
        exporter("__await", __await);
        exporter("__asyncGenerator", __asyncGenerator);
        exporter("__asyncDelegator", __asyncDelegator);
        exporter("__asyncValues", __asyncValues);
        exporter("__makeTemplateObject", __makeTemplateObject);
        exporter("__importStar", __importStar);
        exporter("__importDefault", __importDefault);
    });
},
/* core/util/arrayable.js */ function _(require, module, exports) {
    function splice(array, start, k) {
        var items = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            items[_i - 3] = arguments[_i];
        }
        var len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        var n = len - k + items.length;
        var result = new array.constructor(n);
        var i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (var _a = 0, items_1 = items; _a < items_1.length; _a++) {
            var item = items_1[_a];
            result[i++] = item;
        }
        for (var j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    exports.head = head;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (var i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function map(array, fn) {
        var n = array.length;
        var result = new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function filter(array, pred) {
        var n = array.length;
        var result = new array.constructor(n);
        var k = 0;
        for (var i = 0; i < n; i++) {
            var value = array[i];
            if (pred(value, i, array))
                result[k++] = value;
        }
        return head(result, k);
    }
    exports.filter = filter;
    function reduce(array, fn, initial) {
        var n = array.length;
        if (initial === undefined && n == 0)
            throw new Error("can't reduce an empty array without an initial value");
        var value;
        var i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    exports.reduce = reduce;
    function min(array) {
        var value;
        var result = Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function min_by(array, key) {
        if (array.length == 0)
            throw new Error("min_by() called with an empty array");
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length = array.length; i < length; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.min_by = min_by;
    function max(array) {
        var value;
        var result = -Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function max_by(array, key) {
        if (array.length == 0)
            throw new Error("max_by() called with an empty array");
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length = array.length; i < length; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.max_by = max_by;
    function sum(array) {
        var result = 0;
        for (var i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;
    function cumsum(array) {
        var result = new array.constructor(array.length);
        reduce(array, function (a, b, i) { return result[i] = a + b; }, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function every(array, predicate) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (!predicate(array[i]))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(array, predicate) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (predicate(array[i]))
                return true;
        }
        return false;
    }
    exports.some = some;
    function index_of(array, value) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (array[i] === value)
                return i;
        }
        return -1;
    }
    exports.index_of = index_of;
    function _find_index(dir) {
        return function (array, predicate) {
            var length = array.length;
            var index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        var index = exports.find_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function find_last(array, predicate) {
        var index = exports.find_last_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find_last = find_last;
    function sorted_index(array, value) {
        var low = 0;
        var high = array.length;
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sorted_index = sorted_index;
},
/* core/has_props.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var signaling_1 = require(116) /* ./signaling */;
    var property_mixins = require(120) /* ./property_mixins */;
    var refs_1 = require(126) /* ./util/refs */;
    var p = require(121) /* ./properties */;
    var string_1 = require(127) /* ./util/string */;
    var array_1 = require(110) /* ./util/array */;
    var object_1 = require(125) /* ./util/object */;
    var types_1 = require(109) /* ./util/types */;
    var eq_1 = require(118) /* ./util/eq */;
    var HasProps = /** @class */ (function (_super) {
        tslib_1.__extends(HasProps, _super);
        function HasProps(attrs) {
            if (attrs === void 0) {
                attrs = {};
            }
            var _this = _super.call(this) || this;
            _this._subtype = undefined;
            _this.document = null;
            _this.destroyed = new signaling_1.Signal0(_this, "destroyed");
            _this.change = new signaling_1.Signal0(_this, "change");
            _this.transformchange = new signaling_1.Signal0(_this, "transformchange");
            _this.attributes = {};
            _this.properties = {};
            _this._set_after_defaults = {};
            _this._pending = false;
            _this._changing = false;
            for (var name in _this.props) {
                var _a = _this.props[name], type = _a.type, default_value = _a.default_value;
                if (type != null)
                    _this.properties[name] = new type(_this, name, default_value);
                else
                    throw new Error("undefined property type for " + _this.type + "." + name);
            }
            // auto generating ID
            if (attrs.id == null)
                _this.setv({ id: string_1.uniqueId() }, { silent: true });
            var deferred = attrs.__deferred__ || false;
            if (deferred) {
                attrs = object_1.clone(attrs);
                delete attrs.__deferred__;
            }
            _this.setv(attrs, { silent: true });
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!deferred)
                _this.finalize();
            return _this;
        }
        Object.defineProperty(HasProps.prototype, "type", {
            get: function () {
                return this.constructor.__qualified__;
            },
            // XXX: setter is only required for backwards compatibility
            set: function (name) {
                console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead");
                this.constructor.__name__ = name;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HasProps, "__qualified__", {
            get: function () {
                var _a = this, __module__ = _a.__module__, __name__ = _a.__name__;
                return __module__ != null ? __module__ + "." + __name__ : __name__;
            },
            enumerable: true,
            configurable: true
        });
        HasProps.init_HasProps = function () {
            this.prototype.props = {};
            this.prototype.mixins = [];
            this.define({
                id: [p.Any],
            });
        };
        // }}}
        HasProps._fix_default = function (default_value, _attr) {
            if (default_value === undefined)
                return undefined;
            else if (types_1.isFunction(default_value))
                return default_value;
            else if (!types_1.isObject(default_value))
                return function () { return default_value; };
            else {
                //logger.warn(`${this.prototype.type}.${attr} uses unwrapped non-primitive default value`)
                if (types_1.isArray(default_value))
                    return function () { return array_1.copy(default_value); };
                else
                    return function () { return object_1.clone(default_value); };
            }
        };
        // TODO: don't use Partial<>, but exclude inherited properties
        HasProps.define = function (obj) {
            var _loop_1 = function (name) {
                var prop = obj[name];
                if (this_1.prototype.props[name] != null)
                    throw new Error("attempted to redefine property '" + this_1.prototype.type + "." + name + "'");
                if (this_1.prototype[name] != null)
                    throw new Error("attempted to redefine attribute '" + this_1.prototype.type + "." + name + "'");
                Object.defineProperty(this_1.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get: function () {
                        var value = this.getv(name);
                        return value;
                    },
                    set: function (value) {
                        var _a;
                        this.setv((_a = {}, _a[name] = value, _a));
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                var type = prop[0], default_value = prop[1], internal = prop[2];
                var refined_prop = {
                    type: type,
                    default_value: this_1._fix_default(default_value, name),
                    internal: internal || false,
                };
                var props = object_1.clone(this_1.prototype.props);
                props[name] = refined_prop;
                this_1.prototype.props = props;
            };
            var this_1 = this;
            for (var name in obj) {
                _loop_1(name);
            }
        };
        HasProps.internal = function (obj) {
            var _object = {};
            for (var name in obj) {
                var prop = obj[name];
                var type = prop[0], default_value = prop[1];
                _object[name] = [type, default_value, true];
            }
            this.define(_object);
        };
        HasProps.mixin = function () {
            var names = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                names[_i] = arguments[_i];
            }
            this.define(property_mixins.create(names));
            var mixins = this.prototype.mixins.concat(names);
            this.prototype.mixins = mixins;
        };
        HasProps.mixins = function (names) {
            this.mixin.apply(this, names);
        };
        HasProps.override = function (obj) {
            for (var name in obj) {
                var default_value = this._fix_default(obj[name], name);
                var value = this.prototype.props[name];
                if (value == null)
                    throw new Error("attempted to override nonexistent '" + this.prototype.type + "." + name + "'");
                var props = object_1.clone(this.prototype.props);
                props[name] = Object.assign(Object.assign({}, value), { default_value: default_value });
                this.prototype.props = props;
            }
        };
        HasProps.prototype.toString = function () {
            return this.type + "(" + this.id + ")";
        };
        HasProps.prototype.finalize = function () {
            var _this = this;
            // This is necessary because the initial creation of properties relies on
            // model.get which is not usable at that point yet in the constructor. This
            // initializer is called when deferred initialization happens for all models
            // and insures that the Bokeh properties are initialized from Backbone
            // attributes in a consistent way.
            //
            // TODO (bev) split property creation up into two parts so that only the
            // portion of init that can be done happens in HasProps constructor and so
            // that subsequent updates do not duplicate that setup work.
            for (var name in this.properties) {
                var prop = this.properties[name];
                prop.update();
                if (prop.spec.transform != null)
                    this.connect(prop.spec.transform.change, function () { return _this.transformchange.emit(); });
            }
            this.initialize();
            this.connect_signals();
        };
        HasProps.prototype.initialize = function () { };
        HasProps.prototype.connect_signals = function () { };
        HasProps.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        HasProps.prototype.destroy = function () {
            this.disconnect_signals();
            this.destroyed.emit();
        };
        // Create a new model with identical attributes to this one.
        HasProps.prototype.clone = function () {
            return new this.constructor(this.attributes);
        };
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        HasProps.prototype._setv = function (attrs, options) {
            // Extract attributes and options.
            var check_eq = options.check_eq;
            var silent = options.silent;
            var changes = [];
            var changing = this._changing;
            this._changing = true;
            var current = this.attributes;
            // For each `set` attribute, update or delete the current value.
            for (var attr in attrs) {
                var val = attrs[attr];
                if (check_eq !== false) {
                    if (!eq_1.isEqual(current[attr], val))
                        changes.push(attr);
                }
                else
                    changes.push(attr);
                current[attr] = val;
            }
            // Trigger all relevant attribute changes.
            if (!silent) {
                if (changes.length > 0)
                    this._pending = true;
                for (var i = 0; i < changes.length; i++)
                    this.properties[changes[i]].change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!silent && !options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit();
                }
            }
            this._pending = false;
            this._changing = false;
        };
        HasProps.prototype.setv = function (attrs, options) {
            if (options === void 0) {
                options = {};
            }
            for (var key in attrs) {
                if (!attrs.hasOwnProperty(key))
                    continue;
                var prop_name = key;
                if (this.props[prop_name] == null)
                    throw new Error("property " + this.type + "." + prop_name + " wasn't declared");
                if (!(options != null && options.defaults))
                    this._set_after_defaults[key] = true;
            }
            if (!object_1.isEmpty(attrs)) {
                var old = {};
                for (var key in attrs)
                    old[key] = this.getv(key);
                this._setv(attrs, options);
                var silent = options.silent;
                if (silent == null || !silent) {
                    for (var key in attrs)
                        this._tell_document_about_change(key, old[key], this.getv(key), options);
                }
            }
        };
        HasProps.prototype.getv = function (prop_name) {
            if (this.props[prop_name] == null)
                throw new Error("property " + this.type + "." + prop_name + " wasn't declared");
            else
                return this.attributes[prop_name];
        };
        HasProps.prototype.ref = function () {
            return refs_1.create_ref(this);
        };
        // we only keep the subtype so we match Python;
        // only Python cares about this
        HasProps.prototype.set_subtype = function (subtype) {
            this._subtype = subtype;
        };
        HasProps.prototype.attribute_is_serializable = function (attr) {
            var prop = this.props[attr];
            if (prop == null)
                throw new Error(this.type + ".attribute_is_serializable('" + attr + "'): " + attr + " wasn't declared");
            else
                return !prop.internal;
        };
        // dict of attributes that should be serialized to the server. We
        // sometimes stick things in attributes that aren't part of the
        // Document's models, subtypes that do that have to remove their
        // extra attributes here.
        HasProps.prototype.serializable_attributes = function () {
            var attrs = {};
            for (var name in this.attributes) {
                var value = this.attributes[name];
                if (this.attribute_is_serializable(name))
                    attrs[name] = value;
            }
            return attrs;
        };
        HasProps._value_to_json = function (_key, value, _optional_parent_object) {
            if (value instanceof HasProps)
                return value.ref();
            else if (types_1.isArray(value)) {
                var ref_array = [];
                for (var i = 0; i < value.length; i++) {
                    var v = value[i];
                    ref_array.push(HasProps._value_to_json(i.toString(), v, value));
                }
                return ref_array;
            }
            else if (types_1.isPlainObject(value)) {
                var ref_obj = {};
                for (var subkey in value) {
                    if (value.hasOwnProperty(subkey))
                        ref_obj[subkey] = HasProps._value_to_json(subkey, value[subkey], value);
                }
                return ref_obj;
            }
            else
                return value;
        };
        // Convert attributes to "shallow" JSON (values which are themselves models
        // are included as just references)
        HasProps.prototype.attributes_as_json = function (include_defaults, value_to_json) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            if (value_to_json === void 0) {
                value_to_json = HasProps._value_to_json;
            }
            var serializable = this.serializable_attributes();
            var attrs = {};
            for (var key in serializable) {
                if (serializable.hasOwnProperty(key)) {
                    var value = serializable[key];
                    if (include_defaults)
                        attrs[key] = value;
                    else if (key in this._set_after_defaults)
                        attrs[key] = value;
                }
            }
            return value_to_json("attributes", attrs, this);
        };
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        HasProps._json_record_references = function (doc, v, result, recurse) {
            if (v == null) {
            }
            else if (refs_1.is_ref(v)) {
                if (!(v.id in result)) {
                    var model = doc.get_model_by_id(v.id);
                    HasProps._value_record_references(model, result, recurse);
                }
            }
            else if (types_1.isArray(v)) {
                for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                    var elem = v_1[_i];
                    HasProps._json_record_references(doc, elem, result, recurse);
                }
            }
            else if (types_1.isPlainObject(v)) {
                for (var k in v) {
                    if (v.hasOwnProperty(k)) {
                        var elem = v[k];
                        HasProps._json_record_references(doc, elem, result, recurse);
                    }
                }
            }
        };
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        HasProps._value_record_references = function (v, result, recurse) {
            if (v == null) {
            }
            else if (v instanceof HasProps) {
                if (!(v.id in result)) {
                    result[v.id] = v;
                    if (recurse) {
                        var immediate = v._immediate_references();
                        for (var _i = 0, immediate_1 = immediate; _i < immediate_1.length; _i++) {
                            var obj = immediate_1[_i];
                            HasProps._value_record_references(obj, result, true);
                        } // true=recurse
                    }
                }
            }
            else if (v.buffer instanceof ArrayBuffer) {
            }
            else if (types_1.isArray(v)) {
                for (var _a = 0, v_2 = v; _a < v_2.length; _a++) {
                    var elem = v_2[_a];
                    HasProps._value_record_references(elem, result, recurse);
                }
            }
            else if (types_1.isPlainObject(v)) {
                for (var k in v) {
                    if (v.hasOwnProperty(k)) {
                        var elem = v[k];
                        HasProps._value_record_references(elem, result, recurse);
                    }
                }
            }
        };
        // Get models that are immediately referenced by our properties
        // (do not recurse, do not include ourselves)
        HasProps.prototype._immediate_references = function () {
            var result = {};
            var attrs = this.serializable_attributes();
            for (var key in attrs) {
                var value = attrs[key];
                HasProps._value_record_references(value, result, false); // false = no recurse
            }
            return object_1.values(result);
        };
        HasProps.prototype.references = function () {
            var references = {};
            HasProps._value_record_references(this, references, true);
            return object_1.values(references);
        };
        HasProps.prototype._doc_attached = function () { };
        HasProps.prototype.attach_document = function (doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error("models must be owned by only a single document");
            this.document = doc;
            this._doc_attached();
        };
        HasProps.prototype.detach_document = function () {
            // This should only be called by the Document implementation to unset the document field
            this.document = null;
        };
        HasProps.prototype._tell_document_about_change = function (attr, old, new_, options) {
            if (!this.attribute_is_serializable(attr))
                return;
            if (this.document != null) {
                var new_refs = {};
                HasProps._value_record_references(new_, new_refs, false);
                var old_refs = {};
                HasProps._value_record_references(old, old_refs, false);
                var need_invalidate = false;
                for (var new_id in new_refs) {
                    if (!(new_id in old_refs)) {
                        need_invalidate = true;
                        break;
                    }
                }
                if (!need_invalidate) {
                    for (var old_id in old_refs) {
                        if (!(old_id in new_refs)) {
                            need_invalidate = true;
                            break;
                        }
                    }
                }
                if (need_invalidate)
                    this.document._invalidate_all_models();
                this.document._notify_change(this, attr, old, new_, options);
            }
        };
        HasProps.prototype.materialize_dataspecs = function (source) {
            // Note: this should be moved to a function separate from HasProps
            var data = {};
            for (var name in this.properties) {
                var prop = this.properties[name];
                if (!(prop instanceof p.VectorSpec))
                    continue;
                // this skips optional properties like radius for circles
                if (prop.optional && prop.spec.value == null && !(name in this._set_after_defaults))
                    continue;
                var array = prop.array(source);
                data["_" + name] = array;
                // the shapes are indexed by the column name, but when we materialize the dataspec, we should
                // store under the canonical field name, e.g. _image_shape, even if the column name is "foo"
                if (prop.spec.field != null && prop.spec.field in source._shapes)
                    data["_" + name + "_shape"] = source._shapes[prop.spec.field];
                if (prop instanceof p.DistanceSpec)
                    data["max_" + name] = array_1.max(array);
            }
            return data;
        };
        return HasProps;
    }(signaling_1.Signalable()));
    exports.HasProps = HasProps;
    HasProps.init_HasProps();
},
/* core/signaling.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var data_structures_1 = require(117) /* ./util/data_structures */;
    var callback_1 = require(119) /* ./util/callback */;
    var array_1 = require(110) /* ./util/array */;
    var Signal = /** @class */ (function () {
        function Signal(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        Signal.prototype.connect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            var receivers = receiversForSender.get(this.sender);
            if (findConnection(receivers, this, slot, context) != null) {
                return false;
            }
            var receiver = context || slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            var senders = sendersForReceiver.get(receiver);
            var connection = { signal: this, slot: slot, context: context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        };
        Signal.prototype.disconnect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            var receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            var connection = findConnection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            var receiver = context || slot;
            var senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            scheduleCleanup(receivers);
            scheduleCleanup(senders);
            return true;
        };
        Signal.prototype.emit = function (args) {
            var receivers = receiversForSender.get(this.sender) || [];
            for (var _i = 0, receivers_1 = receivers; _i < receivers_1.length; _i++) {
                var _a = receivers_1[_i], signal = _a.signal, slot = _a.slot, context = _a.context;
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        };
        return Signal;
    }());
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    var Signal0 = /** @class */ (function (_super) {
        tslib_1.__extends(Signal0, _super);
        function Signal0() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Signal0.prototype.emit = function () {
            _super.prototype.emit.call(this, undefined);
        };
        return Signal0;
    }(Signal));
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnectBetween(sender, receiver) {
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (var _i = 0, senders_1 = senders; _i < senders_1.length; _i++) {
                var connection = senders_1[_i];
                if (connection.signal == null)
                    return;
                if (connection.signal.sender === sender)
                    connection.signal = null;
            }
            scheduleCleanup(receivers);
            scheduleCleanup(senders);
        }
        Signal.disconnectBetween = disconnectBetween;
        function disconnectSender(sender) {
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            for (var _i = 0, receivers_2 = receivers; _i < receivers_2.length; _i++) {
                var connection = receivers_2[_i];
                if (connection.signal == null)
                    return;
                var receiver = connection.context || connection.slot;
                connection.signal = null;
                scheduleCleanup(sendersForReceiver.get(receiver));
            }
            scheduleCleanup(receivers);
        }
        Signal.disconnectSender = disconnectSender;
        function disconnectReceiver(receiver) {
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (var _i = 0, senders_2 = senders; _i < senders_2.length; _i++) {
                var connection = senders_2[_i];
                if (connection.signal == null)
                    return;
                var sender = connection.signal.sender;
                connection.signal = null;
                scheduleCleanup(receiversForSender.get(sender));
            }
            scheduleCleanup(senders);
        }
        Signal.disconnectReceiver = disconnectReceiver;
        function disconnectAll(obj) {
            var receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (var _i = 0, receivers_3 = receivers; _i < receivers_3.length; _i++) {
                    var connection = receivers_3[_i];
                    connection.signal = null;
                }
                scheduleCleanup(receivers);
            }
            var senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (var _a = 0, senders_3 = senders; _a < senders_3.length; _a++) {
                    var connection = senders_3[_a];
                    connection.signal = null;
                }
                scheduleCleanup(senders);
            }
        }
        Signal.disconnectAll = disconnectAll;
    })(Signal = exports.Signal || (exports.Signal = {}));
    function Signalable(Base) {
        // XXX: `class Foo extends Signalable(Object)` doesn't work (compiles, but fails at runtime), so
        // we have to do this to allow signalable classes without an explict base class.
        if (Base != null) {
            return /** @class */ (function (_super) {
                tslib_1.__extends(class_1, _super);
                function class_1() {
                    return _super !== null && _super.apply(this, arguments) || this;
                }
                class_1.prototype.connect = function (signal, slot) {
                    return signal.connect(slot, this);
                };
                class_1.prototype.disconnect = function (signal, slot) {
                    return signal.disconnect(slot, this);
                };
                return class_1;
            }(Base));
        }
        else {
            return /** @class */ (function () {
                function class_2() {
                }
                class_2.prototype.connect = function (signal, slot) {
                    return signal.connect(slot, this);
                };
                class_2.prototype.disconnect = function (signal, slot) {
                    return signal.disconnect(slot, this);
                };
                return class_2;
            }());
        }
    }
    exports.Signalable = Signalable;
    var _Signalable;
    (function (_Signalable) {
        function connect(signal, slot) {
            return signal.connect(slot, this);
        }
        _Signalable.connect = connect;
        function disconnect(signal, slot) {
            return signal.disconnect(slot, this);
        }
        _Signalable.disconnect = disconnect;
    })(_Signalable = exports._Signalable || (exports._Signalable = {}));
    var receiversForSender = new WeakMap();
    var sendersForReceiver = new WeakMap();
    function findConnection(conns, signal, slot, context) {
        return array_1.find(conns, function (conn) { return conn.signal === signal && conn.slot === slot && conn.context === context; });
    }
    var dirtySet = new data_structures_1.Set();
    function scheduleCleanup(connections) {
        if (dirtySet.size === 0) {
            callback_1.defer(cleanupDirtySet);
        }
        dirtySet.add(connections);
    }
    function cleanupDirtySet() {
        dirtySet.forEach(function (connections) {
            array_1.remove_by(connections, function (connection) { return connection.signal == null; });
        });
        dirtySet.clear();
    }
},
/* core/util/data_structures.js */ function _(require, module, exports) {
    var array_1 = require(110) /* ./array */;
    var eq_1 = require(118) /* ./eq */;
    var types_1 = require(109) /* ./types */;
    var MultiDict = /** @class */ (function () {
        function MultiDict() {
            this._dict = {};
        }
        MultiDict.prototype._existing = function (key) {
            if (key in this._dict)
                return this._dict[key];
            else
                return null;
        };
        MultiDict.prototype.add_value = function (key, value) {
            /*
            if value == null
              throw new Error("Can't put null in this dict")
            if isArray(value)
              throw new Error("Can't put arrays in this dict")
            */
            var existing = this._existing(key);
            if (existing == null) {
                this._dict[key] = value;
            }
            else if (types_1.isArray(existing)) {
                existing.push(value);
            }
            else {
                this._dict[key] = [existing, value];
            }
        };
        MultiDict.prototype.remove_value = function (key, value) {
            var existing = this._existing(key);
            if (types_1.isArray(existing)) {
                var new_array = array_1.difference(existing, [value]);
                if (new_array.length > 0)
                    this._dict[key] = new_array;
                else
                    delete this._dict[key];
            }
            else if (eq_1.isEqual(existing, value)) {
                delete this._dict[key];
            }
        };
        MultiDict.prototype.get_one = function (key, duplicate_error) {
            var existing = this._existing(key);
            if (types_1.isArray(existing)) {
                if (existing.length === 1)
                    return existing[0];
                else
                    throw new Error(duplicate_error);
            }
            else
                return existing;
        };
        return MultiDict;
    }());
    exports.MultiDict = MultiDict;
    MultiDict.__name__ = "MultiDict";
    var Set = /** @class */ (function () {
        function Set(obj) {
            if (obj == null)
                this._values = [];
            else if (obj instanceof Set)
                this._values = array_1.copy(obj._values);
            else {
                this._values = [];
                for (var _i = 0, obj_1 = obj; _i < obj_1.length; _i++) {
                    var item = obj_1[_i];
                    this.add(item);
                }
            }
        }
        Object.defineProperty(Set.prototype, "values", {
            get: function () {
                return array_1.copy(this._values).sort();
            },
            enumerable: true,
            configurable: true
        });
        Set.prototype.toString = function () {
            return "Set([" + this.values.join(",") + "])";
        };
        Object.defineProperty(Set.prototype, "size", {
            get: function () {
                return this._values.length;
            },
            enumerable: true,
            configurable: true
        });
        Set.prototype.has = function (item) {
            return this._values.indexOf(item) !== -1;
        };
        Set.prototype.add = function (item) {
            if (!this.has(item))
                this._values.push(item);
        };
        Set.prototype.remove = function (item) {
            var i = this._values.indexOf(item);
            if (i !== -1)
                this._values.splice(i, 1);
        };
        Set.prototype.toggle = function (item) {
            var i = this._values.indexOf(item);
            if (i === -1)
                this._values.push(item);
            else
                this._values.splice(i, 1);
        };
        Set.prototype.clear = function () {
            this._values = [];
        };
        Set.prototype.union = function (input) {
            input = new Set(input);
            return new Set(this._values.concat(input._values));
        };
        Set.prototype.intersect = function (input) {
            input = new Set(input);
            var output = new Set();
            for (var _i = 0, _a = input._values; _i < _a.length; _i++) {
                var item = _a[_i];
                if (this.has(item) && input.has(item))
                    output.add(item);
            }
            return output;
        };
        Set.prototype.diff = function (input) {
            input = new Set(input);
            var output = new Set();
            for (var _i = 0, _a = this._values; _i < _a.length; _i++) {
                var item = _a[_i];
                if (!input.has(item))
                    output.add(item);
            }
            return output;
        };
        Set.prototype.forEach = function (fn, thisArg) {
            for (var _i = 0, _a = this._values; _i < _a.length; _i++) {
                var value = _a[_i];
                fn.call(thisArg || this, value, value, this);
            }
        };
        return Set;
    }());
    exports.Set = Set;
    Set.__name__ = "Set";
    var Matrix = /** @class */ (function () {
        function Matrix(nrows, ncols, init) {
            this.nrows = nrows;
            this.ncols = ncols;
            this._matrix = new Array(nrows);
            for (var y = 0; y < nrows; y++) {
                this._matrix[y] = new Array(ncols);
                for (var x = 0; x < ncols; x++) {
                    this._matrix[y][x] = init(y, x);
                }
            }
        }
        Matrix.prototype.at = function (row, col) {
            return this._matrix[row][col];
        };
        Matrix.prototype.map = function (fn) {
            var _this = this;
            return new Matrix(this.nrows, this.ncols, function (row, col) { return fn(_this.at(row, col), row, col); });
        };
        Matrix.prototype.apply = function (obj) {
            var _this = this;
            var fn = Matrix.from(obj);
            var _a = this, nrows = _a.nrows, ncols = _a.ncols;
            if (nrows == fn.nrows && ncols == fn.ncols)
                return new Matrix(nrows, ncols, function (row, col) { return fn.at(row, col)(_this.at(row, col), row, col); });
            else
                throw new Error("dimensions don't match");
        };
        Matrix.prototype.to_sparse = function () {
            var items = [];
            for (var y = 0; y < this.nrows; y++) {
                for (var x = 0; x < this.ncols; x++) {
                    var value = this._matrix[y][x];
                    items.push([value, y, x]);
                }
            }
            return items;
        };
        Matrix.from = function (obj) {
            if (obj instanceof Matrix)
                return obj;
            else {
                var nrows = obj.length;
                var ncols = array_1.min(obj.map(function (row) { return row.length; }));
                return new Matrix(nrows, ncols, function (row, col) { return obj[row][col]; });
            }
        };
        return Matrix;
    }());
    exports.Matrix = Matrix;
    Matrix.__name__ = "Matrix";
},
/* core/util/eq.js */ function _(require, module, exports) {
    var types_1 = require(109) /* ./types */;
    var toString = Object.prototype.toString;
    // Internal recursive comparison function for `isEqual`.
    function eq(a, b, aStack, bStack) {
        // Identical objects are equal. `0 === -0`, but they aren't identical.
        // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
        if (a === b)
            return a !== 0 || 1 / a === 1 / b;
        // A strict comparison is necessary because `null == undefined`.
        if (a == null || b == null)
            return a === b;
        // Compare `[[Class]]` names.
        var className = toString.call(a);
        if (className !== toString.call(b))
            return false;
        switch (className) {
            // Strings, numbers, regular expressions, dates, and booleans are compared by value.
            case '[object RegExp]':
            // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
            case '[object String]':
                // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
                // equivalent to `new String("5")`.
                return '' + a === '' + b;
            case '[object Number]':
                // `NaN`s are equivalent, but non-reflexive.
                // Object(NaN) is equivalent to NaN
                if (+a !== +a)
                    return +b !== +b;
                // An `egal` comparison is performed for other numeric values.
                return +a === 0 ? 1 / +a === 1 / b : +a === +b;
            case '[object Date]':
            case '[object Boolean]':
                // Coerce dates and booleans to numeric primitive values. Dates are compared by their
                // millisecond representations. Note that invalid dates with millisecond representations
                // of `NaN` are not equivalent.
                return +a === +b;
        }
        var areArrays = className === '[object Array]';
        if (!areArrays) {
            if (typeof a != 'object' || typeof b != 'object')
                return false;
            // Objects with different constructors are not equivalent, but `Object`s or `Array`s
            // from different frames are.
            var aCtor = a.constructor, bCtor = b.constructor;
            if (aCtor !== bCtor && !(types_1.isFunction(aCtor) && aCtor instanceof aCtor &&
                types_1.isFunction(bCtor) && bCtor instanceof bCtor)
                && ('constructor' in a && 'constructor' in b)) {
                return false;
            }
        }
        // Assume equality for cyclic structures. The algorithm for detecting cyclic
        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
        // Initializing stack of traversed objects.
        // It's done here since we only need them for objects and arrays comparison.
        aStack = aStack || [];
        bStack = bStack || [];
        var length = aStack.length;
        while (length--) {
            // Linear search. Performance is inversely proportional to the number of
            // unique nested structures.
            if (aStack[length] === a)
                return bStack[length] === b;
        }
        // Add the first object to the stack of traversed objects.
        aStack.push(a);
        bStack.push(b);
        // Recursively compare objects and arrays.
        if (areArrays) {
            // Compare array lengths to determine if a deep comparison is necessary.
            length = a.length;
            if (length !== b.length)
                return false;
            // Deep compare the contents, ignoring non-numeric properties.
            while (length--) {
                if (!eq(a[length], b[length], aStack, bStack))
                    return false;
            }
        }
        else {
            // Deep compare objects.
            var keys = Object.keys(a);
            var key = void 0;
            length = keys.length;
            // Ensure that both objects contain the same number of properties before comparing deep equality.
            if (Object.keys(b).length !== length)
                return false;
            while (length--) {
                // Deep compare each member
                key = keys[length];
                if (!(b.hasOwnProperty(key) && eq(a[key], b[key], aStack, bStack)))
                    return false;
            }
        }
        // Remove the first object from the stack of traversed objects.
        aStack.pop();
        bStack.pop();
        return true;
    }
    // Perform a deep comparison to check if two objects are equal.
    function isEqual(a, b) {
        return eq(a, b);
    }
    exports.isEqual = isEqual;
},
/* core/util/callback.js */ function _(require, module, exports) {
    function delay(func, wait) {
        return setTimeout(func, wait);
    }
    exports.delay = delay;
    var _defer = typeof requestAnimationFrame === "function" ? requestAnimationFrame : setImmediate;
    function defer(func) {
        return _defer(func);
    }
    exports.defer = defer;
    function throttle(func, wait, options) {
        if (options === void 0) {
            options = {};
        }
        var context, args, result;
        var timeout = null;
        var previous = 0;
        var later = function () {
            previous = options.leading === false ? 0 : Date.now();
            timeout = null;
            result = func.apply(context, args);
            if (!timeout)
                context = args = null;
        };
        return function () {
            var now = Date.now();
            if (!previous && options.leading === false)
                previous = now;
            var remaining = wait - (now - previous);
            context = this;
            args = arguments;
            if (remaining <= 0 || remaining > wait) {
                if (timeout) {
                    clearTimeout(timeout);
                    timeout = null;
                }
                previous = now;
                result = func.apply(context, args);
                if (!timeout)
                    context = args = null;
            }
            else if (!timeout && options.trailing !== false) {
                timeout = setTimeout(later, remaining);
            }
            return result;
        };
    }
    exports.throttle = throttle;
    function once(func) {
        var done = false;
        var memo;
        return function () {
            if (!done) {
                done = true;
                memo = func();
            }
            return memo;
        };
    }
    exports.once = once;
},
/* core/property_mixins.js */ function _(require, module, exports) {
    var p = require(121) /* ./properties */;
    var object_1 = require(125) /* ./util/object */;
    function _gen_mixin(mixin, prefix) {
        var result = {};
        for (var name in mixin) {
            var prop = mixin[name];
            result[prefix + name] = prop;
        }
        return result;
    }
    var _line_mixin = {
        line_color: [p.ColorSpec, 'black'],
        line_width: [p.NumberSpec, 1],
        line_alpha: [p.NumberSpec, 1.0],
        line_join: [p.LineJoin, 'bevel'],
        line_cap: [p.LineCap, 'butt'],
        line_dash: [p.Array, []],
        line_dash_offset: [p.Number, 0],
    };
    exports.line = function (prefix) {
        if (prefix === void 0) {
            prefix = "";
        }
        return _gen_mixin(_line_mixin, prefix);
    };
    var _fill_mixin = {
        fill_color: [p.ColorSpec, 'gray'],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.fill = function (prefix) {
        if (prefix === void 0) {
            prefix = "";
        }
        return _gen_mixin(_fill_mixin, prefix);
    };
    var _hatch_mixin = {
        hatch_color: [p.ColorSpec, 'black'],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.StringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.Any, {}],
    };
    exports.hatch = function (prefix) {
        if (prefix === void 0) {
            prefix = "";
        }
        return _gen_mixin(_hatch_mixin, prefix);
    };
    var _text_mixin = {
        text_font: [p.Font, 'helvetica'],
        text_font_size: [p.FontSizeSpec, '12pt'],
        text_font_style: [p.FontStyle, 'normal'],
        text_color: [p.ColorSpec, '#444444'],
        text_alpha: [p.NumberSpec, 1.0],
        text_align: [p.TextAlign, 'left'],
        text_baseline: [p.TextBaseline, 'bottom'],
        text_line_height: [p.Number, 1.2],
    };
    exports.text = function (prefix) {
        if (prefix === void 0) {
            prefix = "";
        }
        return _gen_mixin(_text_mixin, prefix);
    };
    function create(configs) {
        var result = {};
        for (var _i = 0, configs_1 = configs; _i < configs_1.length; _i++) {
            var config = configs_1[_i];
            var _a = config.split(":"), kind = _a[0], prefix = _a[1];
            var mixin = void 0;
            switch (kind) {
                case "line":
                    mixin = exports.line;
                    break;
                case "fill":
                    mixin = exports.fill;
                    break;
                case "hatch":
                    mixin = exports.hatch;
                    break;
                case "text":
                    mixin = exports.text;
                    break;
                default:
                    throw new Error("Unknown property mixin kind '" + kind + "'");
            }
            object_1.extend(result, mixin(prefix));
        }
        return result;
    }
    exports.create = create;
},
/* core/properties.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var signaling_1 = require(116) /* ./signaling */;
    var enums = require(122) /* ./enums */;
    var array_1 = require(110) /* ./util/array */;
    var arrayable_1 = require(114) /* ./util/arrayable */;
    var color_1 = require(123) /* ./util/color */;
    var types_1 = require(109) /* ./util/types */;
    signaling_1.Signal; // XXX: silence TS, because `Signal` appears in declarations due to Signalable
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return types_1.isPlainObject(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    exports.isSpec = isSpec;
    var Property = /** @class */ (function (_super) {
        tslib_1.__extends(Property, _super);
        function Property(obj, attr, default_value) {
            var _this = _super.call(this) || this;
            _this.obj = obj;
            _this.attr = attr;
            _this.default_value = default_value;
            _this.optional = false;
            _this.change = new signaling_1.Signal0(_this.obj, "change");
            _this._init();
            _this.connect(_this.change, function () { return _this._init(); });
            return _this;
        }
        Property.prototype.update = function () {
            this._init();
        };
        // ----- customizable policies
        Property.prototype.init = function () { };
        Property.prototype.transform = function (values) {
            return values;
        };
        Property.prototype.validate = function (value) {
            if (!this.valid(value))
                throw new Error(this.obj.type + "." + this.attr + " given invalid value: " + valueToString(value));
        };
        Property.prototype.valid = function (_value) {
            return true;
        };
        // ----- property accessors
        Property.prototype.value = function (do_spec_transform) {
            if (do_spec_transform === void 0) {
                do_spec_transform = true;
            }
            if (this.spec.value === undefined)
                throw new Error("attempted to retrieve property value for property without value specification");
            var ret = this.transform([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        };
        // ----- private methods
        /*protected*/ Property.prototype._init = function () {
            var _b;
            var obj = this.obj;
            var attr = this.attr;
            var attr_value = obj.getv(attr);
            if (attr_value === undefined) {
                var default_value = this.default_value;
                if (default_value !== undefined)
                    attr_value = default_value(obj);
                else
                    attr_value = null;
                obj.setv((_b = {}, _b[attr] = attr_value, _b), { silent: true, defaults: true });
            }
            if (types_1.isArray(attr_value))
                this.spec = { value: attr_value };
            else if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            //if (this.dataspec && this.spec.field != null && !isString(this.spec.field))
            //  throw new Error(`field value for property '${attr}' is not a string`)
            if (this.spec.value != null)
                this.validate(this.spec.value);
            this.init();
        };
        Property.prototype.toString = function () {
            /*${this.name}*/
            return "Prop(" + this.obj + "." + this.attr + ", spec: " + valueToString(this.spec) + ")";
        };
        return Property;
    }(signaling_1.Signalable()));
    exports.Property = Property;
    Property.__name__ = "Property";
    //
    // Primitive Properties
    //
    var Any = /** @class */ (function (_super) {
        tslib_1.__extends(Any, _super);
        function Any() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Any;
    }(Property));
    exports.Any = Any;
    Any.__name__ = "Any";
    var Array = /** @class */ (function (_super) {
        tslib_1.__extends(Array, _super);
        function Array() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Array.prototype.valid = function (value) {
            return types_1.isArray(value) || value instanceof Float64Array;
        };
        return Array;
    }(Property));
    exports.Array = Array;
    Array.__name__ = "Array";
    var Boolean = /** @class */ (function (_super) {
        tslib_1.__extends(Boolean, _super);
        function Boolean() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Boolean.prototype.valid = function (value) {
            return types_1.isBoolean(value);
        };
        return Boolean;
    }(Property));
    exports.Boolean = Boolean;
    Boolean.__name__ = "Boolean";
    var Color = /** @class */ (function (_super) {
        tslib_1.__extends(Color, _super);
        function Color() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Color.prototype.valid = function (value) {
            return types_1.isString(value) && color_1.is_color(value);
        };
        return Color;
    }(Property));
    exports.Color = Color;
    Color.__name__ = "Color";
    var Instance = /** @class */ (function (_super) {
        tslib_1.__extends(Instance, _super);
        function Instance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Instance;
    }(Property));
    exports.Instance = Instance;
    Instance.__name__ = "Instance";
    var Number = /** @class */ (function (_super) {
        tslib_1.__extends(Number, _super);
        function Number() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Number.prototype.valid = function (value) {
            return types_1.isNumber(value);
        };
        return Number;
    }(Property));
    exports.Number = Number;
    Number.__name__ = "Number";
    var Int = /** @class */ (function (_super) {
        tslib_1.__extends(Int, _super);
        function Int() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Int.prototype.valid = function (value) {
            return types_1.isNumber(value) && (value | 0) == value;
        };
        return Int;
    }(Number));
    exports.Int = Int;
    Int.__name__ = "Int";
    var Angle = /** @class */ (function (_super) {
        tslib_1.__extends(Angle, _super);
        function Angle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Angle;
    }(Number));
    exports.Angle = Angle;
    Angle.__name__ = "Angle";
    var Percent = /** @class */ (function (_super) {
        tslib_1.__extends(Percent, _super);
        function Percent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Percent.prototype.valid = function (value) {
            return types_1.isNumber(value) && 0 <= value && value <= 1.0;
        };
        return Percent;
    }(Number));
    exports.Percent = Percent;
    Percent.__name__ = "Percent";
    var String = /** @class */ (function (_super) {
        tslib_1.__extends(String, _super);
        function String() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        String.prototype.valid = function (value) {
            return types_1.isString(value);
        };
        return String;
    }(Property));
    exports.String = String;
    String.__name__ = "String";
    var FontSize = /** @class */ (function (_super) {
        tslib_1.__extends(FontSize, _super);
        function FontSize() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSize;
    }(String));
    exports.FontSize = FontSize;
    FontSize.__name__ = "FontSize";
    var Font = /** @class */ (function (_super) {
        tslib_1.__extends(Font, _super);
        function Font() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Font;
    }(String)); // TODO (bev) don't think this exists python side
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // Enum properties
    //
    var EnumProperty = /** @class */ (function (_super) {
        tslib_1.__extends(EnumProperty, _super);
        function EnumProperty() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        EnumProperty.prototype.valid = function (value) {
            return types_1.isString(value) && array_1.includes(this.enum_values, value);
        };
        return EnumProperty;
    }(Property));
    exports.EnumProperty = EnumProperty;
    EnumProperty.__name__ = "EnumProperty";
    function Enum(values) {
        return /** @class */ (function (_super) {
            tslib_1.__extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "enum_values", {
                get: function () {
                    return values;
                },
                enumerable: true,
                configurable: true
            });
            return class_1;
        }(EnumProperty));
    }
    exports.Enum = Enum;
    var Direction = /** @class */ (function (_super) {
        tslib_1.__extends(Direction, _super);
        function Direction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Direction.prototype, "enum_values", {
            get: function () {
                return enums.Direction;
            },
            enumerable: true,
            configurable: true
        });
        Direction.prototype.transform = function (values) {
            var result = new Uint8Array(values.length);
            for (var i = 0; i < values.length; i++) {
                switch (values[i]) {
                    case "clock":
                        result[i] = 0;
                        break;
                    case "anticlock":
                        result[i] = 1;
                        break;
                }
            }
            return result;
        };
        return Direction;
    }(EnumProperty));
    exports.Direction = Direction;
    Direction.__name__ = "Direction";
    exports.Anchor = Enum(enums.Anchor);
    exports.AngleUnits = Enum(enums.AngleUnits);
    exports.BoxOrigin = Enum(enums.BoxOrigin);
    exports.ButtonType = Enum(enums.ButtonType);
    exports.Dimension = Enum(enums.Dimension);
    exports.Dimensions = Enum(enums.Dimensions);
    exports.Distribution = Enum(enums.Distribution);
    exports.FontStyle = Enum(enums.FontStyle);
    exports.HatchPatternType = Enum(enums.HatchPatternType);
    exports.HTTPMethod = Enum(enums.HTTPMethod);
    exports.HexTileOrientation = Enum(enums.HexTileOrientation);
    exports.HoverMode = Enum(enums.HoverMode);
    exports.LatLon = Enum(enums.LatLon);
    exports.LegendClickPolicy = Enum(enums.LegendClickPolicy);
    exports.LegendLocation = Enum(enums.LegendLocation);
    exports.LineCap = Enum(enums.LineCap);
    exports.LineJoin = Enum(enums.LineJoin);
    exports.LinePolicy = Enum(enums.LinePolicy);
    exports.Location = Enum(enums.Location);
    exports.Logo = Enum(enums.Logo);
    exports.MarkerType = Enum(enums.MarkerType);
    exports.Orientation = Enum(enums.Orientation);
    exports.OutputBackend = Enum(enums.OutputBackend);
    exports.PaddingUnits = Enum(enums.PaddingUnits);
    exports.Place = Enum(enums.Place);
    exports.PointPolicy = Enum(enums.PointPolicy);
    exports.RadiusDimension = Enum(enums.RadiusDimension);
    exports.RenderLevel = Enum(enums.RenderLevel);
    exports.RenderMode = Enum(enums.RenderMode);
    exports.ResetPolicy = Enum(enums.ResetPolicy);
    exports.RoundingFunction = Enum(enums.RoundingFunction);
    exports.Side = Enum(enums.Side);
    exports.SizingMode = Enum(enums.SizingMode);
    exports.SliderCallbackPolicy = Enum(enums.SliderCallbackPolicy);
    exports.Sort = Enum(enums.Sort);
    exports.SpatialUnits = Enum(enums.SpatialUnits);
    exports.StartEnd = Enum(enums.StartEnd);
    exports.StepMode = Enum(enums.StepMode);
    exports.TapBehavior = Enum(enums.TapBehavior);
    exports.TextAlign = Enum(enums.TextAlign);
    exports.TextBaseline = Enum(enums.TextBaseline);
    exports.TextureRepetition = Enum(enums.TextureRepetition);
    exports.TickLabelOrientation = Enum(enums.TickLabelOrientation);
    exports.TooltipAttachment = Enum(enums.TooltipAttachment);
    exports.UpdateMode = Enum(enums.UpdateMode);
    exports.VerticalAlign = Enum(enums.VerticalAlign);
    //
    // DataSpec properties
    //
    var ScalarSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ScalarSpec, _super);
        function ScalarSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ScalarSpec;
    }(Property));
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    var VectorSpec = /** @class */ (function (_super) {
        tslib_1.__extends(VectorSpec, _super);
        function VectorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VectorSpec.prototype.array = function (source) {
            var ret;
            if (this.spec.field != null) {
                ret = this.transform(source.get_column(this.spec.field));
                if (ret == null)
                    throw new Error("attempted to retrieve property array for nonexistent field '" + this.spec.field + "'");
            }
            else if (this.spec.expr != null) {
                ret = this.transform(this.spec.expr.v_compute(source));
            }
            else {
                var length = source.get_length();
                if (length == null)
                    length = 1;
                var value = this.value(false); // don't apply any spec transform
                ret = array_1.repeat(value, length);
            }
            if (this.spec.transform != null)
                ret = this.spec.transform.v_compute(ret);
            return ret;
        };
        return VectorSpec;
    }(Property));
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    var DataSpec = /** @class */ (function (_super) {
        tslib_1.__extends(DataSpec, _super);
        function DataSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DataSpec;
    }(VectorSpec));
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    var UnitsSpec = /** @class */ (function (_super) {
        tslib_1.__extends(UnitsSpec, _super);
        function UnitsSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnitsSpec.prototype.init = function () {
            if (this.spec.units == null)
                this.spec.units = this.default_units;
            var units = this.spec.units;
            if (!array_1.includes(this.valid_units, units))
                throw new Error("units must be one of " + this.valid_units.join(", ") + "; got: " + units);
        };
        Object.defineProperty(UnitsSpec.prototype, "units", {
            get: function () {
                return this.spec.units;
            },
            set: function (units) {
                this.spec.units = units;
            },
            enumerable: true,
            configurable: true
        });
        return UnitsSpec;
    }(VectorSpec));
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    var AngleSpec = /** @class */ (function (_super) {
        tslib_1.__extends(AngleSpec, _super);
        function AngleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AngleSpec.prototype, "default_units", {
            get: function () { return "rad"; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AngleSpec.prototype, "valid_units", {
            get: function () { return enums.AngleUnits; },
            enumerable: true,
            configurable: true
        });
        AngleSpec.prototype.transform = function (values) {
            if (this.spec.units == "deg")
                values = arrayable_1.map(values, function (x) { return x * Math.PI / 180.0; });
            values = arrayable_1.map(values, function (x) { return -x; });
            return _super.prototype.transform.call(this, values);
        };
        return AngleSpec;
    }(UnitsSpec));
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    var BooleanSpec = /** @class */ (function (_super) {
        tslib_1.__extends(BooleanSpec, _super);
        function BooleanSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return BooleanSpec;
    }(DataSpec));
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    var ColorSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ColorSpec, _super);
        function ColorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ColorSpec;
    }(DataSpec));
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    var CoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSpec, _super);
        function CoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSpec;
    }(DataSpec));
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    var CoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSeqSpec, _super);
        function CoordinateSeqSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSeqSpec;
    }(DataSpec));
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    var DistanceSpec = /** @class */ (function (_super) {
        tslib_1.__extends(DistanceSpec, _super);
        function DistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DistanceSpec.prototype, "default_units", {
            get: function () { return "data"; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DistanceSpec.prototype, "valid_units", {
            get: function () { return enums.SpatialUnits; },
            enumerable: true,
            configurable: true
        });
        return DistanceSpec;
    }(UnitsSpec));
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    var FontSizeSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontSizeSpec, _super);
        function FontSizeSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeSpec;
    }(DataSpec));
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    var MarkerSpec = /** @class */ (function (_super) {
        tslib_1.__extends(MarkerSpec, _super);
        function MarkerSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return MarkerSpec;
    }(DataSpec));
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    var NumberSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NumberSpec, _super);
        function NumberSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NumberSpec;
    }(DataSpec));
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    var StringSpec = /** @class */ (function (_super) {
        tslib_1.__extends(StringSpec, _super);
        function StringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringSpec;
    }(DataSpec));
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    var NullStringSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NullStringSpec, _super);
        function NullStringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NullStringSpec;
    }(DataSpec));
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
},
/* core/enums.js */ function _(require, module, exports) {
    exports.Align = ["start", "center", "end"];
    exports.Anchor = [
        "top_left", "top_center", "top_right",
        "center_left", "center", "center_right",
        "bottom_left", "bottom_center", "bottom_right",
    ];
    exports.AngleUnits = ["deg", "rad"];
    exports.BoxOrigin = ["corner", "center"];
    exports.ButtonType = ["default", "primary", "success", "warning", "danger"];
    exports.Dimension = ["width", "height"];
    exports.Dimensions = ["width", "height", "both"];
    exports.Direction = ["clock", "anticlock"];
    exports.Distribution = ["uniform", "normal"];
    exports.FontStyle = ["normal", "italic", "bold", "bold italic"];
    exports.HatchPatternType = [
        'blank', 'dot', 'ring', 'horizontal_line', 'vertical_line', 'cross', 'horizontal_dash',
        'vertical_dash', 'spiral', 'right_diagonal_line', 'left_diagonal_line', 'diagonal_cross',
        'right_diagonal_dash', 'left_diagonal_dash', 'horizontal_wave', 'vertical_wave', 'criss_cross',
        ' ', '.', 'o', '-', '|', '+', '"', ':', '@', '/', '\\', 'x', ',', '`', 'v', '>', '*',
    ];
    exports.HTTPMethod = ["POST", "GET"];
    exports.HexTileOrientation = ["pointytop", "flattop"];
    exports.HoverMode = ["mouse", "hline", "vline"];
    exports.LatLon = ["lat", "lon"];
    exports.LegendClickPolicy = ["none", "hide", "mute"];
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = ["butt", "round", "square"];
    exports.LineJoin = ["miter", "round", "bevel"];
    exports.LinePolicy = ["prev", "next", "nearest", "interp", "none"];
    exports.Location = ["above", "below", "left", "right"];
    exports.Logo = ["normal", "grey"];
    exports.MarkerType = [
        "asterisk", "circle", "circle_cross", "circle_x", "cross",
        "dash", "diamond", "diamond_cross", "hex", "inverted_triangle",
        "square", "square_cross", "square_x", "triangle", "x",
    ];
    exports.Orientation = ["vertical", "horizontal"];
    exports.OutputBackend = ["canvas", "svg", "webgl"];
    exports.PaddingUnits = ["percent", "absolute"];
    exports.Place = ["above", "below", "left", "right", "center"];
    exports.PointPolicy = ["snap_to_data", "follow_mouse", "none"];
    exports.RadiusDimension = ["x", "y", "max", "min"];
    exports.RenderLevel = ["image", "underlay", "glyph", "annotation", "overlay"];
    exports.RenderMode = ["canvas", "css"];
    exports.ResetPolicy = ["standard", "event_only"];
    exports.RoundingFunction = ["round", "nearest", "floor", "rounddown", "ceil", "roundup"];
    exports.Side = ["above", "below", "left", "right"];
    exports.SizingMode = ["stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed"];
    exports.SliderCallbackPolicy = ["continuous", "throttle", "mouseup"];
    exports.Sort = ["ascending", "descending"];
    exports.SpatialUnits = ["screen", "data"];
    exports.StartEnd = ["start", "end"];
    exports.StepMode = ["after", "before", "center"];
    exports.TapBehavior = ["select", "inspect"];
    exports.TextAlign = ["left", "right", "center"];
    exports.TextBaseline = ["top", "middle", "bottom", "alphabetic", "hanging", "ideographic"];
    exports.TextureRepetition = ["repeat", "repeat_x", "repeat_y", "no_repeat"];
    exports.TickLabelOrientation = ["vertical", "horizontal", "parallel", "normal"];
    exports.TooltipAttachment = ["horizontal", "vertical", "left", "right", "above", "below"];
    exports.UpdateMode = ["replace", "append"];
    exports.VerticalAlign = ["top", "middle", "bottom"];
},
/* core/util/color.js */ function _(require, module, exports) {
    var svg_colors_1 = require(124) /* ./svg_colors */;
    var array_1 = require(110) /* ./array */;
    function is_color(value) {
        return svg_colors_1.is_svg_color(value.toLowerCase()) || value.substring(0, 1) == "#" || valid_rgb(value);
    }
    exports.is_color = is_color;
    function _component2hex(v) {
        var h = Number(v).toString(16);
        return h.length == 1 ? "0" + h : h;
    }
    function rgb2hex(r, g, b) {
        var R = _component2hex(r & 0xFF);
        var G = _component2hex(g & 0xFF);
        var B = _component2hex(b & 0xFF);
        return "#" + R + G + B;
    }
    exports.rgb2hex = rgb2hex;
    function color2hex(color) {
        color = color + '';
        if (color.indexOf('#') == 0)
            return color;
        else if (svg_colors_1.is_svg_color(color))
            return svg_colors_1.svg_colors[color];
        else if (color.indexOf('rgb') == 0) {
            var rgb = color.replace(/^rgba?\(|\s+|\)$/g, '').split(',');
            var hex = rgb.slice(0, 3).map(_component2hex).join('');
            if (rgb.length == 4)
                hex += _component2hex(Math.floor(parseFloat(rgb[3]) * 255));
            return "#" + hex.slice(0, 8); // can also be rgba
        }
        else
            return color;
    }
    exports.color2hex = color2hex;
    function color2rgba(color, alpha) {
        if (alpha === void 0) {
            alpha = 1.0;
        }
        if (!color) // NaN, null, '', etc.
            return [0, 0, 0, 0]; // transparent
        // Convert to hex and then to clean version of 6 or 8 chars
        var hex = color2hex(color);
        hex = hex.replace(/ |#/g, '');
        if (hex.length <= 4) {
            hex = hex.replace(/(.)/g, '$1$1');
        }
        // Convert pairs to numbers
        var rgba = hex.match(/../g).map(function (i) { return parseInt(i, 16) / 255; });
        // Ensure correct length, add alpha if necessary
        while (rgba.length < 3)
            rgba.push(0);
        if (rgba.length < 4)
            rgba.push(alpha);
        return rgba.slice(0, 4);
    }
    exports.color2rgba = color2rgba;
    function valid_rgb(value) {
        var params;
        switch (value.substring(0, 4)) {
            case "rgba": {
                params = { start: "rgba(", len: 4, alpha: true };
                break;
            }
            case "rgb(": {
                params = { start: "rgb(", len: 3, alpha: false };
                break;
            }
            default:
                return false;
        }
        // if '.' and then ',' found, we know decimals are used on rgb
        if (new RegExp(".*?(\\.).*(,)").test(value))
            throw new Error("color expects integers for rgb in rgb/rgba tuple, received " + value);
        // extract the numerical values from inside parens
        var contents = value.replace(params.start, "").replace(")", "").split(',').map(parseFloat);
        // check length of array based on rgb/rgba
        if (contents.length != params.len)
            throw new Error("color expects rgba " + params.len + "-tuple, received " + value);
        // check for valid numerical values for rgba
        if (params.alpha && !(0 <= contents[3] && contents[3] <= 1))
            throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");
        if (array_1.includes(contents.slice(0, 3).map(function (rgb) { return 0 <= rgb && rgb <= 255; }), false))
            throw new Error("color expects rgb to have value between 0 and 255");
        return true;
    }
    exports.valid_rgb = valid_rgb;
},
/* core/util/svg_colors.js */ function _(require, module, exports) {
    exports.svg_colors = {
        indianred: "#CD5C5C",
        lightcoral: "#F08080",
        salmon: "#FA8072",
        darksalmon: "#E9967A",
        lightsalmon: "#FFA07A",
        crimson: "#DC143C",
        red: "#FF0000",
        firebrick: "#B22222",
        darkred: "#8B0000",
        pink: "#FFC0CB",
        lightpink: "#FFB6C1",
        hotpink: "#FF69B4",
        deeppink: "#FF1493",
        mediumvioletred: "#C71585",
        palevioletred: "#DB7093",
        coral: "#FF7F50",
        tomato: "#FF6347",
        orangered: "#FF4500",
        darkorange: "#FF8C00",
        orange: "#FFA500",
        gold: "#FFD700",
        yellow: "#FFFF00",
        lightyellow: "#FFFFE0",
        lemonchiffon: "#FFFACD",
        lightgoldenrodyellow: "#FAFAD2",
        papayawhip: "#FFEFD5",
        moccasin: "#FFE4B5",
        peachpuff: "#FFDAB9",
        palegoldenrod: "#EEE8AA",
        khaki: "#F0E68C",
        darkkhaki: "#BDB76B",
        lavender: "#E6E6FA",
        thistle: "#D8BFD8",
        plum: "#DDA0DD",
        violet: "#EE82EE",
        orchid: "#DA70D6",
        fuchsia: "#FF00FF",
        magenta: "#FF00FF",
        mediumorchid: "#BA55D3",
        mediumpurple: "#9370DB",
        blueviolet: "#8A2BE2",
        darkviolet: "#9400D3",
        darkorchid: "#9932CC",
        darkmagenta: "#8B008B",
        purple: "#800080",
        indigo: "#4B0082",
        slateblue: "#6A5ACD",
        darkslateblue: "#483D8B",
        mediumslateblue: "#7B68EE",
        greenyellow: "#ADFF2F",
        chartreuse: "#7FFF00",
        lawngreen: "#7CFC00",
        lime: "#00FF00",
        limegreen: "#32CD32",
        palegreen: "#98FB98",
        lightgreen: "#90EE90",
        mediumspringgreen: "#00FA9A",
        springgreen: "#00FF7F",
        mediumseagreen: "#3CB371",
        seagreen: "#2E8B57",
        forestgreen: "#228B22",
        green: "#008000",
        darkgreen: "#006400",
        yellowgreen: "#9ACD32",
        olivedrab: "#6B8E23",
        olive: "#808000",
        darkolivegreen: "#556B2F",
        mediumaquamarine: "#66CDAA",
        darkseagreen: "#8FBC8F",
        lightseagreen: "#20B2AA",
        darkcyan: "#008B8B",
        teal: "#008080",
        aqua: "#00FFFF",
        cyan: "#00FFFF",
        lightcyan: "#E0FFFF",
        paleturquoise: "#AFEEEE",
        aquamarine: "#7FFFD4",
        turquoise: "#40E0D0",
        mediumturquoise: "#48D1CC",
        darkturquoise: "#00CED1",
        cadetblue: "#5F9EA0",
        steelblue: "#4682B4",
        lightsteelblue: "#B0C4DE",
        powderblue: "#B0E0E6",
        lightblue: "#ADD8E6",
        skyblue: "#87CEEB",
        lightskyblue: "#87CEFA",
        deepskyblue: "#00BFFF",
        dodgerblue: "#1E90FF",
        cornflowerblue: "#6495ED",
        royalblue: "#4169E1",
        blue: "#0000FF",
        mediumblue: "#0000CD",
        darkblue: "#00008B",
        navy: "#000080",
        midnightblue: "#191970",
        cornsilk: "#FFF8DC",
        blanchedalmond: "#FFEBCD",
        bisque: "#FFE4C4",
        navajowhite: "#FFDEAD",
        wheat: "#F5DEB3",
        burlywood: "#DEB887",
        tan: "#D2B48C",
        rosybrown: "#BC8F8F",
        sandybrown: "#F4A460",
        goldenrod: "#DAA520",
        darkgoldenrod: "#B8860B",
        peru: "#CD853F",
        chocolate: "#D2691E",
        saddlebrown: "#8B4513",
        sienna: "#A0522D",
        brown: "#A52A2A",
        maroon: "#800000",
        white: "#FFFFFF",
        snow: "#FFFAFA",
        honeydew: "#F0FFF0",
        mintcream: "#F5FFFA",
        azure: "#F0FFFF",
        aliceblue: "#F0F8FF",
        ghostwhite: "#F8F8FF",
        whitesmoke: "#F5F5F5",
        seashell: "#FFF5EE",
        beige: "#F5F5DC",
        oldlace: "#FDF5E6",
        floralwhite: "#FFFAF0",
        ivory: "#FFFFF0",
        antiquewhite: "#FAEBD7",
        linen: "#FAF0E6",
        lavenderblush: "#FFF0F5",
        mistyrose: "#FFE4E1",
        gainsboro: "#DCDCDC",
        lightgray: "#D3D3D3",
        lightgrey: "#D3D3D3",
        silver: "#C0C0C0",
        darkgray: "#A9A9A9",
        darkgrey: "#A9A9A9",
        gray: "#808080",
        grey: "#808080",
        dimgray: "#696969",
        dimgrey: "#696969",
        lightslategray: "#778899",
        lightslategrey: "#778899",
        slategray: "#708090",
        slategrey: "#708090",
        darkslategray: "#2F4F4F",
        darkslategrey: "#2F4F4F",
        black: "#000000",
    };
    function is_svg_color(color) {
        return color in exports.svg_colors;
    }
    exports.is_svg_color = is_svg_color;
},
/* core/util/object.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var array_1 = require(110) /* ./array */;
    exports.keys = Object.keys;
    function values(object) {
        var keys = Object.keys(object);
        var length = keys.length;
        var values = new Array(length);
        for (var i = 0; i < length; i++) {
            values[i] = object[keys[i]];
        }
        return values;
    }
    exports.values = values;
    function extend(dest, src) {
        return tslib_1.__assign(dest, src);
    }
    exports.extend = extend;
    function clone(obj) {
        return extend({}, obj); // XXX: can't use {...obj} due to https://github.com/Microsoft/TypeScript/issues/14409
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        /*
         * Returns an object with the array values for obj1 and obj2 unioned by key.
         */
        var result = Object.create(Object.prototype);
        var keys = array_1.concat([Object.keys(obj1), Object.keys(obj2)]);
        for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
            var key = keys_1[_i];
            var arr1 = obj1.hasOwnProperty(key) ? obj1[key] : [];
            var arr2 = obj2.hasOwnProperty(key) ? obj2[key] : [];
            result[key] = array_1.union(arr1, arr2);
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function isEmpty(obj) {
        return size(obj) === 0;
    }
    exports.isEmpty = isEmpty;
},
/* core/util/refs.js */ function _(require, module, exports) {
    var types_1 = require(109) /* ./types */;
    // Create a Bokeh reference from a HasProps subclass
    //
    // @param obj [HasProps] the object to create a reference for
    // @return [Object] a Bokeh reference for `obj`
    // @throw Error if `obj` is not a HasProps
    //
    function create_ref(obj) {
        var ref = {
            type: obj.type,
            id: obj.id,
        };
        if (obj._subtype != null) {
            ref.subtype = obj._subtype;
        }
        return ref;
    }
    exports.create_ref = create_ref;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a reference
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if (types_1.isObject(arg)) {
            var keys = Object.keys(arg).sort();
            if (keys.length == 2)
                return keys[0] == 'id' && keys[1] == 'type';
            if (keys.length == 3)
                return keys[0] == 'id' && keys[1] == 'subtype' && keys[2] == 'type';
        }
        return false;
    }
    exports.is_ref = is_ref;
},
/* core/util/string.js */ function _(require, module, exports) {
    var settings_1 = require(128) /* ../settings */;
    function startsWith(str, searchString, position) {
        if (position === void 0) {
            position = 0;
        }
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        var s = new Array(32);
        var hexDigits = "0123456789ABCDEF";
        for (var i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr((s[16].charCodeAt(0) & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    exports.uuid4 = uuid4;
    var counter = 1000;
    function uniqueId(prefix) {
        var id = settings_1.settings.dev ? "j" + counter++ : uuid4();
        if (prefix != null)
            return prefix + "-" + id;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, function (ch) {
            switch (ch) {
                case '&': return '&amp;';
                case '<': return '&lt;';
                case '>': return '&gt;';
                case '"': return '&quot;';
                case "'": return '&#x27;';
                case '`': return '&#x60;';
                default: return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, function (_, entity) {
            switch (entity) {
                case 'amp': return '&';
                case 'lt': return '<';
                case 'gt': return '>';
                case 'quot': return '"';
                case '#x27': return "'";
                case '#x60': return '`';
                default: return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return "'use strict';\n" + code;
    }
    exports.use_strict = use_strict;
},
/* core/settings.js */ function _(require, module, exports) {
    var Settings = /** @class */ (function () {
        function Settings() {
            this._dev = false;
        }
        Object.defineProperty(Settings.prototype, "dev", {
            get: function () {
                return this._dev;
            },
            set: function (dev) {
                this._dev = dev;
            },
            enumerable: true,
            configurable: true
        });
        return Settings;
    }());
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* models/index.js */ function _(require, module, exports) {
    function __export(m) {
        for (var p in m)
            if (!exports.hasOwnProperty(p))
                exports[p] = m[p];
    }
    __export(require(130) /* ./annotations */);
    __export(require(242) /* ./axes */);
    __export(require(269) /* ./callbacks */);
    __export(require(273) /* ./canvas */);
    __export(require(288) /* ./expressions */);
    __export(require(292) /* ./filters */);
    __export(require(298) /* ./formatters */);
    __export(require(302) /* ./glyphs */);
    __export(require(332) /* ./graphs */);
    __export(require(335) /* ./grids */);
    __export(require(337) /* ./layouts */);
    __export(require(350) /* ./mappers */);
    __export(require(217) /* ./transforms */);
    __export(require(356) /* ./markers */);
    __export(require(360) /* ./plots */);
    __export(require(383) /* ./ranges */);
    __export(require(384) /* ./renderers */);
    __export(require(385) /* ./scales */);
    __export(require(386) /* ./selections */);
    __export(require(387) /* ./sources */);
    __export(require(393) /* ./tickers */);
    __export(require(395) /* ./tiles */);
    __export(require(405) /* ./textures */);
    __export(require(409) /* ./tools */);
},
/* models/annotations/index.js */ function _(require, module, exports) {
    var annotation_1 = require(131) /* ./annotation */;
    exports.Annotation = annotation_1.Annotation;
    var arrow_1 = require(168) /* ./arrow */;
    exports.Arrow = arrow_1.Arrow;
    var arrow_head_1 = require(169) /* ./arrow_head */;
    exports.ArrowHead = arrow_head_1.ArrowHead;
    var arrow_head_2 = require(169) /* ./arrow_head */;
    exports.OpenHead = arrow_head_2.OpenHead;
    var arrow_head_3 = require(169) /* ./arrow_head */;
    exports.NormalHead = arrow_head_3.NormalHead;
    var arrow_head_4 = require(169) /* ./arrow_head */;
    exports.TeeHead = arrow_head_4.TeeHead;
    var arrow_head_5 = require(169) /* ./arrow_head */;
    exports.VeeHead = arrow_head_5.VeeHead;
    var band_1 = require(200) /* ./band */;
    exports.Band = band_1.Band;
    var box_annotation_1 = require(201) /* ./box_annotation */;
    exports.BoxAnnotation = box_annotation_1.BoxAnnotation;
    var color_bar_1 = require(203) /* ./color_bar */;
    exports.ColorBar = color_bar_1.ColorBar;
    var label_1 = require(227) /* ./label */;
    exports.Label = label_1.Label;
    var label_set_1 = require(229) /* ./label_set */;
    exports.LabelSet = label_set_1.LabelSet;
    var legend_1 = require(230) /* ./legend */;
    exports.Legend = legend_1.Legend;
    var legend_item_1 = require(231) /* ./legend_item */;
    exports.LegendItem = legend_item_1.LegendItem;
    var poly_annotation_1 = require(233) /* ./poly_annotation */;
    exports.PolyAnnotation = poly_annotation_1.PolyAnnotation;
    var slope_1 = require(234) /* ./slope */;
    exports.Slope = slope_1.Slope;
    var span_1 = require(235) /* ./span */;
    exports.Span = span_1.Span;
    var text_annotation_1 = require(228) /* ./text_annotation */;
    exports.TextAnnotation = text_annotation_1.TextAnnotation;
    var title_1 = require(236) /* ./title */;
    exports.Title = title_1.Title;
    var toolbar_panel_1 = require(237) /* ./toolbar_panel */;
    exports.ToolbarPanel = toolbar_panel_1.ToolbarPanel;
    var tooltip_1 = require(238) /* ./tooltip */;
    exports.Tooltip = tooltip_1.Tooltip;
    var whisker_1 = require(241) /* ./whisker */;
    exports.Whisker = whisker_1.Whisker;
},
/* models/annotations/annotation.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var proj = require(132) /* ../../core/util/projections */;
    var object_1 = require(125) /* ../../core/util/object */;
    var renderer_1 = require(160) /* ../renderers/renderer */;
    var AnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(AnnotationView, _super);
        function AnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AnnotationView.prototype, "panel", {
            get: function () {
                return this.layout;
            },
            enumerable: true,
            configurable: true
        });
        AnnotationView.prototype.get_size = function () {
            if (this.model.visible) {
                var _a = this._get_size(), width = _a.width, height = _a.height;
                return { width: Math.round(width), height: Math.round(height) };
            }
            else
                return { width: 0, height: 0 };
        };
        AnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var p = this.model.properties;
            this.on_change(p.visible, function () { return _this.plot_view.request_layout(); });
        };
        AnnotationView.prototype._get_size = function () {
            throw new Error("not implemented");
        };
        Object.defineProperty(AnnotationView.prototype, "ctx", {
            get: function () {
                return this.plot_view.canvas_view.ctx;
            },
            enumerable: true,
            configurable: true
        });
        AnnotationView.prototype.set_data = function (source) {
            var _a, _b;
            var data = this.model.materialize_dataspecs(source);
            object_1.extend(this, data);
            if (this.plot_model.use_map) {
                var self = this;
                if (self._x != null)
                    _a = proj.project_xy(self._x, self._y), self._x = _a[0], self._y = _a[1];
                if (self._xs != null)
                    _b = proj.project_xsys(self._xs, self._ys), self._xs = _b[0], self._ys = _b[1];
            }
        };
        Object.defineProperty(AnnotationView.prototype, "needs_clip", {
            get: function () {
                return this.layout == null; // TODO: change this, when center layout is fully implemented
            },
            enumerable: true,
            configurable: true
        });
        AnnotationView.prototype.serializable_state = function () {
            var state = _super.prototype.serializable_state.call(this);
            return this.layout == null ? state : Object.assign(Object.assign({}, state), { bbox: this.layout.bbox.box });
        };
        return AnnotationView;
    }(renderer_1.RendererView));
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    var Annotation = /** @class */ (function (_super) {
        tslib_1.__extends(Annotation, _super);
        function Annotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        Annotation.init_Annotation = function () {
            this.override({
                level: 'annotation',
            });
        };
        return Annotation;
    }(renderer_1.Renderer));
    exports.Annotation = Annotation;
    Annotation.__name__ = "Annotation";
    Annotation.init_Annotation();
},
/* core/util/projections.js */ function _(require, module, exports) {
    var proj4 = require(133) /* proj4/lib/core */;
    var Projection = require(134) /* proj4/lib/Proj */;
    var mercator = new Projection('GOOGLE');
    var wgs84 = new Projection('WGS84');
    exports.wgs84_mercator = proj4(wgs84, mercator);
    var mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    var latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    function clip_mercator(low, high, dimension) {
        var _a = mercator_bounds[dimension], min = _a[0], max = _a[1];
        return [Math.max(low, min), Math.min(high, max)];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        return value > latlon_bounds[dimension][0] && value < latlon_bounds[dimension][1];
    }
    exports.in_bounds = in_bounds;
    function project_xy(x, y) {
        var n = Math.min(x.length, y.length);
        var merc_x_s = new Array(n);
        var merc_y_s = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = exports.wgs84_mercator.forward([x[i], y[i]]), merc_x = _a[0], merc_y = _a[1];
            merc_x_s[i] = merc_x;
            merc_y_s[i] = merc_y;
        }
        return [merc_x_s, merc_y_s];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        var n = Math.min(xs.length, ys.length);
        var merc_xs_s = new Array(n);
        var merc_ys_s = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = project_xy(xs[i], ys[i]), merc_x_s = _a[0], merc_y_s = _a[1];
            merc_xs_s[i] = merc_x_s;
            merc_ys_s[i] = merc_y_s;
        }
        return [merc_xs_s, merc_ys_s];
    }
    exports.project_xsys = project_xsys;
},
/* proj4/lib/core.js */ function _(require, module, exports) {
    var proj = require(134) /* ./Proj */;
    var transform = require(155) /* ./transform */;
    var wgs84 = proj('WGS84');
    function transformer(from, to, coords) {
        var transformedArray;
        if (Array.isArray(coords)) {
            transformedArray = transform(from, to, coords);
            if (coords.length === 3) {
                return [transformedArray.x, transformedArray.y, transformedArray.z];
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            return transform(from, to, coords);
        }
    }
    function checkProj(item) {
        if (item instanceof proj) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return proj(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords) {
                    return transformer(fromProj, toProj, coords);
                },
                inverse: function (coords) {
                    return transformer(toProj, fromProj, coords);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    module.exports = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports) {
    var parseCode = require(135) /* ./parseCode */;
    var extend = require(142) /* ./extend */;
    var projections = require(143) /* ./projections */;
    var deriveConstants = require(151) /* ./deriveConstants */;
    var Datum = require(153) /* ./constants/Datum */;
    var datum = require(154) /* ./datum */;
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = parseCode(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = Datum[json.datumCode];
            if (datumDef) {
                json.datum_params = datumDef.towgs84 ? datumDef.towgs84.split(',') : null;
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        var sphere = deriveConstants.sphere(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = deriveConstants.eccentricity(sphere.a, sphere.b, sphere.rf, json.R_A);
        var datumObj = json.datum || datum(json.datumCode, json.datum_params, sphere.a, sphere.b, ecc.es, ecc.ep2);
        extend(this, json); // transfer everything over from the projection because we don't know what we'll need
        extend(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calulated in deriveConstants.sphere
        this.a = sphere.a;
        this.b = sphere.b;
        this.rf = sphere.rf;
        this.sphere = sphere.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections;
    Projection.projections.start();
    module.exports = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports) {
    var defs = require(136) /* ./defs */;
    var wkt = require(141) /* ./wkt */;
    var projStr = require(138) /* ./projString */;
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs;
    }
    var codeWords = ['GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs[code];
            }
            if (testWKT(code)) {
                return wkt(code);
            }
            if (testProj(code)) {
                return projStr(code);
            }
        }
        else {
            return code;
        }
    }
    module.exports = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports) {
    var globals = require(137) /* ./global */;
    var parseProj = require(138) /* ./projString */;
    var wkt = require(141) /* ./wkt */;
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = parseProj(arguments[1]);
                }
                else {
                    defs[name] = wkt(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    globals(defs);
    module.exports = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports) {
    module.exports = function (defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    };
},
/* proj4/lib/projString.js */ function _(require, module, exports) {
    var D2R = 0.01745329251994329577;
    var PrimeMeridian = require(139) /* ./constants/PrimeMeridian */;
    var units = require(140) /* ./constants/units */;
    module.exports = function (defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * D2R;
            },
            lon_0: function (v) {
                self.long0 = v * D2R;
            },
            lon_1: function (v) {
                self.long1 = v * D2R;
            },
            lon_2: function (v) {
                self.long2 = v * D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * D2R;
            },
            lonc: function (v) {
                self.longc = v * D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                if (units[v]) {
                    self.to_meter = units[v].to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * D2R;
            },
            pm: function (v) {
                self.from_greenwich = (PrimeMeridian[v] ? PrimeMeridian[v] : parseFloat(v)) * D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    };
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports) {
    exports.greenwich = 0.0; //"0dE",
    exports.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports.paris = 2.337229166667; //"2d20'14.025\"E",
    exports.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports.rome = 12.452333333333; //"12d27'8.4\"E",
    exports.bern = 7.439583333333; //"7d26'22.5\"E",
    exports.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports.ferro = -17.666666666667; //"17d40'W",
    exports.brussels = 4.367975; //"4d22'4.71\"E",
    exports.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports.athens = 23.7163375; //"23d42'58.815\"E",
    exports.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports) {
    exports.ft = { to_meter: 0.3048 };
    exports['us-ft'] = { to_meter: 1200 / 3937 };
},
/* proj4/lib/wkt.js */ function _(require, module, exports) {
    var D2R = 0.01745329251994329577;
    var extend = require(142) /* ./extend */;
    function mapit(obj, key, v) {
        obj[key] = v.map(function (aa) {
            var o = {};
            sExpr(aa, o);
            return o;
        }).reduce(function (a, b) {
            return extend(a, b);
        }, {});
    }
    function sExpr(v, obj) {
        var key;
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        else {
            key = v.shift();
            if (key === 'PARAMETER') {
                key = v.shift();
            }
            if (v.length === 1) {
                if (Array.isArray(v[0])) {
                    obj[key] = {};
                    sExpr(v[0], obj[key]);
                }
                else {
                    obj[key] = v[0];
                }
            }
            else if (!v.length) {
                obj[key] = true;
            }
            else if (key === 'TOWGS84') {
                obj[key] = v;
            }
            else {
                obj[key] = {};
                if (['UNIT', 'PRIMEM', 'VERT_DATUM'].indexOf(key) > -1) {
                    obj[key] = {
                        name: v[0].toLowerCase(),
                        convert: v[1]
                    };
                    if (v.length === 3) {
                        obj[key].auth = v[2];
                    }
                }
                else if (key === 'SPHEROID') {
                    obj[key] = {
                        name: v[0],
                        a: v[1],
                        rf: v[2]
                    };
                    if (v.length === 4) {
                        obj[key].auth = v[3];
                    }
                }
                else if (['GEOGCS', 'GEOCCS', 'DATUM', 'VERT_CS', 'COMPD_CS', 'LOCAL_CS', 'FITTED_CS', 'LOCAL_DATUM'].indexOf(key) > -1) {
                    v[0] = ['name', v[0]];
                    mapit(obj, key, v);
                }
                else if (v.every(function (aa) {
                    return Array.isArray(aa);
                })) {
                    mapit(obj, key, v);
                }
                else {
                    sExpr(v, obj[key]);
                }
            }
        }
    }
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === "object") {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = parseFloat(wkt.UNIT.convert, 10) * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = parseFloat(wkt.UNIT.convert, 10);
                }
            }
        }
        if (wkt.GEOGCS) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (wkt.GEOGCS.DATUM) {
                wkt.datumCode = wkt.GEOGCS.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = wkt.GEOGCS.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === "wgs_1984") {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = "rnb72";
            }
            if (wkt.GEOGCS.DATUM && wkt.GEOGCS.DATUM.SPHEROID) {
                wkt.ellps = wkt.GEOGCS.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === "international") {
                    wkt.ellps = 'intl';
                }
                wkt.a = wkt.GEOGCS.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(wkt.GEOGCS.DATUM.SPHEROID.rf, 10);
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = "osgb36";
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return parseFloat(input, 10) * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['false_easting', 'False_Easting'],
            ['false_northing', 'False_Northing'],
            ['central_meridian', 'Central_Meridian'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === "Lambert_Azimuthal_Equal_Area")) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
    }
    module.exports = function (wkt, self) {
        var lisp = JSON.parse(("," + wkt).replace(/\s*\,\s*([A-Z_0-9]+?)(\[)/g, ',["$1",').slice(1).replace(/\s*\,\s*([A-Z_0-9]+?)\]/g, ',"$1"]').replace(/,\["VERTCS".+/, ''));
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        lisp.unshift('output');
        var obj = {};
        sExpr(lisp, obj);
        cleanWKT(obj.output);
        return extend(self, obj.output);
    };
},
/* proj4/lib/extend.js */ function _(require, module, exports) {
    module.exports = function (destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    };
},
/* proj4/lib/projections.js */ function _(require, module, exports) {
    var projs = [
        require(144) /* ./projections/merc */,
        require(150) /* ./projections/longlat */
    ];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    exports.add = add;
    exports.get = function (name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    };
    exports.start = function () {
        projs.forEach(add);
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports) {
    var msfnz = require(145) /* ../common/msfnz */;
    var HALF_PI = Math.PI / 2;
    var EPSLN = 1.0e-10;
    var R2D = 57.29577951308232088;
    var adjust_lon = require(146) /* ../common/adjust_lon */;
    var FORTPI = Math.PI / 4;
    var tsfnz = require(148) /* ../common/tsfnz */;
    var phi2z = require(149) /* ../common/phi2z */;
    exports.init = function () {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = msfnz(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    };
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    exports.forward = function (p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * R2D > 90 && lat * R2D < -90 && lon * R2D > 180 && lon * R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - HALF_PI) <= EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * adjust_lon(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = tsfnz(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * adjust_lon(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    };
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    exports.inverse = function (p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = phi2z(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = adjust_lon(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    };
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports) {
    module.exports = function (eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    };
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports) {
    var TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    var SPI = 3.14159265359;
    var sign = require(147) /* ./sign */;
    module.exports = function (x) {
        return (Math.abs(x) <= SPI) ? x : (x - (sign(x) * TWO_PI));
    };
},
/* proj4/lib/common/sign.js */ function _(require, module, exports) {
    module.exports = function (x) {
        return x < 0 ? -1 : 1;
    };
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports) {
    var HALF_PI = Math.PI / 2;
    module.exports = function (eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (HALF_PI - phi)) / con);
    };
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports) {
    var HALF_PI = Math.PI / 2;
    module.exports = function (eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    };
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports) {
    exports.init = function () {
        //no-op for longlat
    };
    function identity(pt) {
        return pt;
    }
    exports.forward = identity;
    exports.inverse = identity;
    exports.names = ["longlat", "identity"];
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports) {
    // ellipoid pj_set_ell.c
    var SIXTH = 0.1666666666666666667;
    /* 1/6 */
    var RA4 = 0.04722222222222222222;
    /* 17/360 */
    var RA6 = 0.02215608465608465608;
    var EPSLN = 1.0e-10;
    var Ellipsoid = require(152) /* ./constants/Ellipsoid */;
    exports.eccentricity = function (a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (SIXTH + es * (RA4 + es * RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    };
    exports.sphere = function (a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = Ellipsoid[ellps];
            if (!ellipse) {
                ellipse = Ellipsoid.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    };
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports) {
    exports.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports) {
    exports.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports.potsdam = {
        towgs84: "606.0,23.0,413.0",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports.hermannskogel = {
        towgs84: "653.0,-212.0,449.0",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports) {
    var PJD_3PARAM = 1;
    var PJD_7PARAM = 2;
    var PJD_WGS84 = 4; // WGS84 or equivalent
    var PJD_NODATUM = 5; // WGS84 or equivalent
    var SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    function datum(datumCode, datum_params, a, b, es, ep2) {
        var out = {};
        out.datum_type = PJD_WGS84; //default setting
        if (datumCode && datumCode === 'none') {
            out.datum_type = PJD_NODATUM;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = PJD_7PARAM;
                    out.datum_params[3] *= SEC_TO_RAD;
                    out.datum_params[4] *= SEC_TO_RAD;
                    out.datum_params[5] *= SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    module.exports = datum;
},
/* proj4/lib/transform.js */ function _(require, module, exports) {
    var D2R = 0.01745329251994329577;
    var R2D = 57.29577951308232088;
    var PJD_3PARAM = 1;
    var PJD_7PARAM = 2;
    var datum_transform = require(156) /* ./datum_transform */;
    var adjust_axis = require(158) /* ./adjust_axis */;
    var proj = require(134) /* ./Proj */;
    var toPoint = require(159) /* ./common/toPoint */;
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === PJD_3PARAM || source.datum.datum_type === PJD_7PARAM) && dest.datumCode !== 'WGS84') || ((dest.datum.datum_type === PJD_3PARAM || dest.datum.datum_type === PJD_7PARAM) && source.datumCode !== 'WGS84');
    }
    module.exports = function transform(source, dest, point) {
        var wgs84;
        if (Array.isArray(point)) {
            point = toPoint(point);
        }
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new proj('WGS84');
            point = transform(source, wgs84, point);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (source.axis !== 'enu') {
            point = adjust_axis(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * D2R,
                y: point.y * D2R
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = datum_transform(source.datum, dest.datum, point);
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.grom_greenwich,
                y: point.y
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * R2D,
                y: point.y * R2D
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter
                };
            }
        }
        // DGR, 2010/11/12
        if (dest.axis !== 'enu') {
            return adjust_axis(dest, true, point);
        }
        return point;
    };
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports) {
    var PJD_3PARAM = 1;
    var PJD_7PARAM = 2;
    var PJD_NODATUM = 5; // WGS84 or equivalent
    var datum = require(157) /* ./datumUtils */;
    function checkParams(type) {
        return (type === PJD_3PARAM || type === PJD_7PARAM);
    }
    module.exports = function (source, dest, point) {
        // Short cut if the datums are identical.
        if (datum.compareDatums(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === PJD_NODATUM || dest.datum_type === PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        // Do we need to go through geocentric coordinates?
        if (source.es === dest.es && source.a === dest.a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = datum.geodeticToGeocentric(point, source.es, source.a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = datum.geocentricToWgs84(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = datum.geocentricFromWgs84(point, dest.datum_type, dest.datum_params);
        }
        return datum.geocentricToGeodetic(point, dest.es, dest.a, dest.b);
    };
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports) {
    var PJD_3PARAM = 1;
    var PJD_7PARAM = 2;
    var HALF_PI = Math.PI / 2;
    exports.compareDatums = function (source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(this.es - dest.es) > 0.000000000050) {
            // the tolerence for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === PJD_3PARAM) {
            return (this.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    }; // cs_compare_datums()
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    exports.geodeticToGeocentric = function (p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -HALF_PI && Latitude > -1.001 * HALF_PI) {
            Latitude = -HALF_PI;
        }
        else if (Latitude > HALF_PI && Latitude < 1.001 * HALF_PI) {
            Latitude = HALF_PI;
        }
        else if ((Latitude < -HALF_PI) || (Latitude > HALF_PI)) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return null;
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    }; // cs_geodetic_to_geocentric()
    exports.geocentricToGeodetic = function (p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    }; // cs_geocentric_to_geodetic()
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    exports.geocentricToWgs84 = function (p, datum_type, datum_params) {
        if (datum_type === PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    }; // cs_geocentric_to_wgs84
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    exports.geocentricFromWgs84 = function (p, datum_type, datum_params) {
        if (datum_type === PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    };
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports) {
    module.exports = function (crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                t = 'x';
            }
            else if (i === 1) {
                v = yin;
                t = 'y';
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                    out[t] = v;
                    break;
                case 'w':
                    out[t] = -v;
                    break;
                case 'n':
                    out[t] = v;
                    break;
                case 's':
                    out[t] = -v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    };
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports) {
    module.exports = function (array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    };
},
/* models/renderers/renderer.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var dom_view_1 = require(161) /* ../../core/dom_view */;
    var visuals = require(165) /* ../../core/visuals */;
    var p = require(121) /* ../../core/properties */;
    var model_1 = require(166) /* ../../model */;
    // This shouldn't be a DOMView, but annotations create a mess.
    var RendererView = /** @class */ (function (_super) {
        tslib_1.__extends(RendererView, _super);
        function RendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RendererView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals.Visuals(this.model);
            this._has_finished = true; // XXX: should be in render() but subclasses don't respect super()
        };
        Object.defineProperty(RendererView.prototype, "plot_view", {
            get: function () {
                return this.parent;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "plot_model", {
            get: function () {
                return this.parent.model;
            },
            enumerable: true,
            configurable: true
        });
        RendererView.prototype.request_render = function () {
            this.plot_view.request_render();
        };
        RendererView.prototype.map_to_screen = function (x, y) {
            return this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
        };
        Object.defineProperty(RendererView.prototype, "needs_clip", {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        RendererView.prototype.notify_finished = function () {
            this.plot_view.notify_finished();
        };
        Object.defineProperty(RendererView.prototype, "has_webgl", {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        return RendererView;
    }(dom_view_1.DOMView));
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    var Renderer = /** @class */ (function (_super) {
        tslib_1.__extends(Renderer, _super);
        function Renderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        Renderer.init_Renderer = function () {
            this.define({
                level: [p.RenderLevel],
                visible: [p.Boolean, true],
            });
        };
        return Renderer;
    }(model_1.Model));
    exports.Renderer = Renderer;
    Renderer.__name__ = "Renderer";
    Renderer.init_Renderer();
},
/* core/dom_view.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var view_1 = require(162) /* ./view */;
    var DOM = require(163) /* ./dom */;
    var root_1 = require(164) /* ../styles/root */;
    var DOMView = /** @class */ (function (_super) {
        tslib_1.__extends(DOMView, _super);
        function DOMView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DOMView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._has_finished = false;
            this.el = this._createElement();
        };
        DOMView.prototype.remove = function () {
            DOM.removeElement(this.el);
            _super.prototype.remove.call(this);
        };
        DOMView.prototype.css_classes = function () {
            return [];
        };
        DOMView.prototype.cursor = function (_sx, _sy) {
            return null;
        };
        DOMView.prototype.render = function () { };
        DOMView.prototype.renderTo = function (element) {
            element.appendChild(this.el);
            this.render();
        };
        DOMView.prototype.has_finished = function () {
            return this._has_finished;
        };
        Object.defineProperty(DOMView.prototype, "_root_element", {
            get: function () {
                return DOM.parent(this.el, "." + root_1.bk_root) || document.body;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DOMView.prototype, "is_idle", {
            get: function () {
                return this.has_finished();
            },
            enumerable: true,
            configurable: true
        });
        DOMView.prototype._createElement = function () {
            return DOM.createElement(this.tagName, { class: this.css_classes() });
        };
        return DOMView;
    }(view_1.View));
    exports.DOMView = DOMView;
    DOMView.__name__ = "DOMView";
    DOMView.prototype.tagName = "div";
},
/* core/view.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var signaling_1 = require(116) /* ./signaling */;
    var types_1 = require(109) /* ./util/types */;
    var string_1 = require(127) /* ./util/string */;
    var View = /** @class */ (function (_super) {
        tslib_1.__extends(View, _super);
        function View(options) {
            var _this = _super.call(this) || this;
            _this.removed = new signaling_1.Signal0(_this, "removed");
            if (options.model != null)
                _this.model = options.model;
            else
                throw new Error("model of a view wasn't configured");
            _this._parent = options.parent;
            _this.id = options.id || string_1.uniqueId();
            _this.initialize();
            if (options.connect_signals !== false)
                _this.connect_signals();
            return _this;
        }
        View.prototype.initialize = function () { };
        View.prototype.remove = function () {
            this._parent = undefined;
            this.disconnect_signals();
            this.removed.emit();
        };
        View.prototype.toString = function () {
            return this.model.type + "View(" + this.id + ")";
        };
        View.prototype.serializable_state = function () {
            return { type: this.model.type };
        };
        Object.defineProperty(View.prototype, "parent", {
            get: function () {
                if (this._parent !== undefined)
                    return this._parent;
                else
                    throw new Error("parent of a view wasn't configured");
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(View.prototype, "is_root", {
            get: function () {
                return this.parent === null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(View.prototype, "root", {
            get: function () {
                return this.is_root ? this : this.parent.root;
            },
            enumerable: true,
            configurable: true
        });
        View.prototype.assert_root = function () {
            if (!this.is_root)
                throw new Error(this.toString() + " is not a root layout");
        };
        View.prototype.connect_signals = function () { };
        View.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        View.prototype.on_change = function (properties, fn) {
            for (var _i = 0, _a = types_1.isArray(properties) ? properties : [properties]; _i < _a.length; _i++) {
                var property = _a[_i];
                this.connect(property.change, fn);
            }
        };
        return View;
    }(signaling_1.Signalable()));
    exports.View = View;
    View.__name__ = "View";
},
/* core/dom.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var types_1 = require(109) /* ./util/types */;
    var _createElement = function (tag) {
        return function (attrs) {
            if (attrs === void 0) {
                attrs = {};
            }
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var element = document.createElement(tag);
            element.classList.add("bk");
            for (var attr in attrs) {
                var value = attrs[attr];
                if (value == null || types_1.isBoolean(value) && !value)
                    continue;
                if (attr === "class") {
                    if (types_1.isString(value))
                        value = value.split(/\s+/);
                    if (types_1.isArray(value)) {
                        for (var _a = 0, value_1 = value; _a < value_1.length; _a++) {
                            var cls = value_1[_a];
                            if (cls != null)
                                element.classList.add(cls);
                        }
                        continue;
                    }
                }
                if (attr === "style" && types_1.isPlainObject(value)) {
                    for (var prop in value) {
                        element.style[prop] = value[prop];
                    }
                    continue;
                }
                if (attr === "data" && types_1.isPlainObject(value)) {
                    for (var key in value) {
                        element.dataset[key] = value[key]; // XXX: attrs needs a better type
                    }
                    continue;
                }
                element.setAttribute(attr, value);
            }
            function append(child) {
                if (child instanceof HTMLElement)
                    element.appendChild(child);
                else if (types_1.isString(child))
                    element.appendChild(document.createTextNode(child));
                else if (child != null && child !== false)
                    throw new Error("expected an HTMLElement, string, false or null, got " + JSON.stringify(child));
            }
            for (var _b = 0, children_1 = children; _b < children_1.length; _b++) {
                var child = children_1[_b];
                if (types_1.isArray(child)) {
                    for (var _c = 0, child_1 = child; _c < child_1.length; _c++) {
                        var _child = child_1[_c];
                        append(_child);
                    }
                }
                else
                    append(child);
            }
            return element;
        };
    };
    function createElement(tag, attrs) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        return _createElement(tag).apply(void 0, tslib_1.__spreadArrays([attrs], children));
    }
    exports.createElement = createElement;
    exports.div = _createElement("div"), exports.span = _createElement("span"), exports.canvas = _createElement("canvas"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.i = _createElement("i"), exports.pre = _createElement("pre"), exports.button = _createElement("button"), exports.label = _createElement("label"), exports.input = _createElement("input"), exports.select = _createElement("select"), exports.option = _createElement("option"), exports.optgroup = _createElement("optgroup"), exports.textarea = _createElement("textarea");
    function nbsp() {
        return document.createTextNode("\u00a0");
    }
    exports.nbsp = nbsp;
    function removeElement(element) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.removeElement = removeElement;
    function replaceWith(element, replacement) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element) {
        var nodes = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            nodes[_i - 1] = arguments[_i];
        }
        var first = element.firstChild;
        for (var _a = 0, nodes_1 = nodes; _a < nodes_1.length; _a++) {
            var node = nodes_1[_a];
            element.insertBefore(node, first);
        }
    }
    exports.prepend = prepend;
    function empty(element) {
        var child;
        while (child = element.firstChild) {
            element.removeChild(child);
        }
    }
    exports.empty = empty;
    function display(element) {
        element.style.display = "";
    }
    exports.display = display;
    function undisplay(element) {
        element.style.display = "none";
    }
    exports.undisplay = undisplay;
    function show(element) {
        element.style.visibility = "";
    }
    exports.show = show;
    function hide(element) {
        element.style.visibility = "hidden";
    }
    exports.hide = hide;
    function offset(element) {
        var rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft,
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var p = Element.prototype;
        var f = p.matches || p.webkitMatchesSelector || p.mozMatchesSelector || p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        var node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function num(value) {
        return parseFloat(value) || 0;
    }
    function extents(el) {
        var style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    exports.extents = extents;
    function size(el) {
        var rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    exports.size = size;
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    exports.scroll_size = scroll_size;
    function outer_size(el) {
        var _a = extents(el).margin, left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
        var _b = size(el), width = _b.width, height = _b.height;
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    exports.outer_size = outer_size;
    function content_size(el) {
        var _a = el.getBoundingClientRect(), left = _a.left, top = _a.top;
        var padding = extents(el).padding;
        var width = 0;
        var height = 0;
        for (var _i = 0, _b = children(el); _i < _b.length; _i++) {
            var child = _b[_i];
            var rect = child.getBoundingClientRect();
            width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
            height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
        }
        return { width: width, height: height };
    }
    exports.content_size = content_size;
    function position(el, box, margin) {
        var style = el.style;
        style.left = box.x + "px";
        style.top = box.y + "px";
        style.width = box.width + "px";
        style.height = box.height + "px";
        if (margin == null)
            style.margin = "";
        else {
            var top = margin.top, right = margin.right, bottom = margin.bottom, left = margin.left;
            style.margin = top + "px " + right + "px " + bottom + "px " + left + "px";
        }
    }
    exports.position = position;
    function children(el) {
        return Array.from(el.children);
    }
    exports.children = children;
    var ClassList = /** @class */ (function () {
        function ClassList(el) {
            this.el = el;
            this.classList = el.classList;
        }
        Object.defineProperty(ClassList.prototype, "values", {
            get: function () {
                var values = [];
                for (var i = 0; i < this.classList.length; i++) {
                    var item = this.classList.item(i);
                    if (item != null)
                        values.push(item);
                }
                return values;
            },
            enumerable: true,
            configurable: true
        });
        ClassList.prototype.has = function (cls) {
            return this.classList.contains(cls);
        };
        ClassList.prototype.add = function () {
            var classes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                classes[_i] = arguments[_i];
            }
            for (var _a = 0, classes_1 = classes; _a < classes_1.length; _a++) {
                var cls = classes_1[_a];
                this.classList.add(cls);
            }
            return this;
        };
        ClassList.prototype.remove = function () {
            var classes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                classes[_i] = arguments[_i];
            }
            for (var _a = 0, classes_2 = classes; _a < classes_2.length; _a++) {
                var cls = classes_2[_a];
                this.classList.remove(cls);
            }
            return this;
        };
        ClassList.prototype.clear = function () {
            for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
                var cls = _a[_i];
                if (cls != "bk")
                    this.classList.remove(cls);
            }
            return this;
        };
        ClassList.prototype.toggle = function (cls, activate) {
            var add = activate != null ? activate : !this.has(cls);
            if (add)
                this.add(cls);
            else
                this.remove(cls);
            return this;
        };
        return ClassList;
    }());
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el);
    }
    exports.classes = classes;
    var Keys;
    (function (Keys) {
        Keys[Keys["Backspace"] = 8] = "Backspace";
        Keys[Keys["Tab"] = 9] = "Tab";
        Keys[Keys["Enter"] = 13] = "Enter";
        Keys[Keys["Esc"] = 27] = "Esc";
        Keys[Keys["PageUp"] = 33] = "PageUp";
        Keys[Keys["PageDown"] = 34] = "PageDown";
        Keys[Keys["Left"] = 37] = "Left";
        Keys[Keys["Up"] = 38] = "Up";
        Keys[Keys["Right"] = 39] = "Right";
        Keys[Keys["Down"] = 40] = "Down";
        Keys[Keys["Delete"] = 46] = "Delete";
    })(Keys = exports.Keys || (exports.Keys = {}));
    function undisplayed(el, fn) {
        var display = el.style.display;
        el.style.display = "none";
        try {
            return fn();
        }
        finally {
            el.style.display = display;
        }
    }
    exports.undisplayed = undisplayed;
    function unsized(el, fn) {
        return sized(el, {}, fn);
    }
    exports.unsized = unsized;
    function sized(el, size, fn) {
        var _a = el.style, width = _a.width, height = _a.height, position = _a.position, display = _a.display;
        el.style.position = "absolute";
        el.style.display = "";
        el.style.width = size.width != null && size.width != Infinity ? size.width + "px" : "auto";
        el.style.height = size.height != null && size.height != Infinity ? size.height + "px" : "auto";
        try {
            return fn();
        }
        finally {
            el.style.position = position;
            el.style.display = display;
            el.style.width = width;
            el.style.height = height;
        }
    }
    exports.sized = sized;
    var StyleSheet = /** @class */ (function () {
        function StyleSheet() {
            this.style = exports.style({ type: "text/css" });
            prepend(document.head, this.style);
        }
        StyleSheet.prototype.append = function (css) {
            this.style.appendChild(document.createTextNode(css));
        };
        return StyleSheet;
    }());
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    exports.styles = new StyleSheet();
},
/* styles/root.js */ function _(require, module, exports) {
    var _a = require(163) /* ../core/dom */;
    _a.styles.append(".bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 10pt;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n");
    exports.bk_root = "bk-root";
},
/* core/visuals.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var mixins = require(120) /* ./property_mixins */;
    var color_1 = require(123) /* ./util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    function _get_canvas(size) {
        var canvas = document.createElement('canvas');
        canvas.width = size;
        canvas.height = size;
        return canvas;
    }
    function create_hatch_canvas(hatch_pattern, hatch_color, hatch_scale, hatch_weight) {
        var h = hatch_scale;
        var h2 = h / 2;
        var h4 = h2 / 2;
        var canvas = _get_canvas(hatch_scale);
        var ctx = canvas.getContext("2d");
        ctx.strokeStyle = hatch_color;
        ctx.lineCap = "square";
        ctx.fillStyle = hatch_color;
        ctx.lineWidth = hatch_weight;
        switch (hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case " ":
            case "blank":
                break;
            case ".":
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "o":
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "-":
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "|":
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "+":
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "\"":
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case ":":
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "@":
            case "spiral":
                var h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (var i = 0; i < 360; i++) {
                    var angle = 0.1 * i;
                    var x = h2 + (h30 * angle) * Math.cos(angle);
                    var y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            case "/":
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "\\":
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "x":
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case ",":
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "`":
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "v":
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case ">":
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "*":
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
        }
        return canvas;
    }
    var ContextProperties = /** @class */ (function () {
        function ContextProperties(obj, prefix) {
            if (prefix === void 0) {
                prefix = "";
            }
            this.obj = obj;
            this.prefix = prefix;
            // }
            this.cache = {};
            for (var _i = 0, _a = this.attrs; _i < _a.length; _i++) {
                var attr = _a[_i];
                this[attr] = obj.properties[prefix + attr];
            }
        }
        ContextProperties.prototype.warm_cache = function (source) {
            for (var _i = 0, _a = this.attrs; _i < _a.length; _i++) {
                var attr = _a[_i];
                var prop = this.obj.properties[this.prefix + attr];
                if (prop.spec.value !== undefined) // TODO (bev) better test?
                    this.cache[attr] = prop.spec.value;
                else if (source != null)
                    this.cache[attr + "_array"] = prop.array(source);
                else
                    throw new Error("source is required with a vectorized visual property");
            }
        };
        ContextProperties.prototype.cache_select = function (attr, i) {
            var prop = this.obj.properties[this.prefix + attr];
            var value;
            if (prop.spec.value !== undefined) // TODO (bev) better test?
                this.cache[attr] = value = prop.spec.value;
            else
                this.cache[attr] = value = this.cache[attr + "_array"][i];
            return value;
        };
        ContextProperties.prototype.set_vectorize = function (ctx, i) {
            if (this.all_indices != null) // all_indices is set by a Visuals instance associated with a CDSView
                this._set_vectorize(ctx, this.all_indices[i]);
            else // all_indices is not set for annotations which may have vectorized visual props
                this._set_vectorize(ctx, i);
        };
        return ContextProperties;
    }());
    exports.ContextProperties = ContextProperties;
    ContextProperties.__name__ = "ContextProperties";
    var Line = /** @class */ (function (_super) {
        tslib_1.__extends(Line, _super);
        function Line() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Line.prototype.set_value = function (ctx) {
            ctx.strokeStyle = this.line_color.value();
            ctx.globalAlpha = this.line_alpha.value();
            ctx.lineWidth = this.line_width.value();
            ctx.lineJoin = this.line_join.value();
            ctx.lineCap = this.line_cap.value();
            ctx.setLineDash(this.line_dash.value());
            ctx.setLineDashOffset(this.line_dash_offset.value());
        };
        Object.defineProperty(Line.prototype, "doit", {
            get: function () {
                return !(this.line_color.spec.value === null ||
                    this.line_alpha.spec.value == 0 ||
                    this.line_width.spec.value == 0);
            },
            enumerable: true,
            configurable: true
        });
        Line.prototype._set_vectorize = function (ctx, i) {
            this.cache_select("line_color", i);
            if (ctx.strokeStyle !== this.cache.line_color)
                ctx.strokeStyle = this.cache.line_color;
            this.cache_select("line_alpha", i);
            if (ctx.globalAlpha !== this.cache.line_alpha)
                ctx.globalAlpha = this.cache.line_alpha;
            this.cache_select("line_width", i);
            if (ctx.lineWidth !== this.cache.line_width)
                ctx.lineWidth = this.cache.line_width;
            this.cache_select("line_join", i);
            if (ctx.lineJoin !== this.cache.line_join)
                ctx.lineJoin = this.cache.line_join;
            this.cache_select("line_cap", i);
            if (ctx.lineCap !== this.cache.line_cap)
                ctx.lineCap = this.cache.line_cap;
            this.cache_select("line_dash", i);
            if (ctx.getLineDash() !== this.cache.line_dash)
                ctx.setLineDash(this.cache.line_dash);
            this.cache_select("line_dash_offset", i);
            if (ctx.getLineDashOffset() !== this.cache.line_dash_offset)
                ctx.setLineDashOffset(this.cache.line_dash_offset);
        };
        Line.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.line_color.value(), this.line_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return "rgba(" + r * 255 + "," + g * 255 + "," + b * 255 + "," + a + ")";
        };
        return Line;
    }(ContextProperties));
    exports.Line = Line;
    Line.__name__ = "Line";
    Line.prototype.attrs = Object.keys(mixins.line());
    var Fill = /** @class */ (function (_super) {
        tslib_1.__extends(Fill, _super);
        function Fill() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Fill.prototype.set_value = function (ctx) {
            ctx.fillStyle = this.fill_color.value();
            ctx.globalAlpha = this.fill_alpha.value();
        };
        Object.defineProperty(Fill.prototype, "doit", {
            get: function () {
                return !(this.fill_color.spec.value === null ||
                    this.fill_alpha.spec.value == 0);
            },
            enumerable: true,
            configurable: true
        });
        Fill.prototype._set_vectorize = function (ctx, i) {
            this.cache_select("fill_color", i);
            if (ctx.fillStyle !== this.cache.fill_color)
                ctx.fillStyle = this.cache.fill_color;
            this.cache_select("fill_alpha", i);
            if (ctx.globalAlpha !== this.cache.fill_alpha)
                ctx.globalAlpha = this.cache.fill_alpha;
        };
        Fill.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.fill_color.value(), this.fill_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return "rgba(" + r * 255 + "," + g * 255 + "," + b * 255 + "," + a + ")";
        };
        return Fill;
    }(ContextProperties));
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    Fill.prototype.attrs = Object.keys(mixins.fill());
    var Hatch = /** @class */ (function (_super) {
        tslib_1.__extends(Hatch, _super);
        function Hatch() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Hatch.prototype.cache_select = function (name, i) {
            var value;
            if (name == "pattern") {
                this.cache_select("hatch_color", i);
                this.cache_select("hatch_scale", i);
                this.cache_select("hatch_pattern", i);
                this.cache_select("hatch_weight", i);
                var _a = this.cache, hatch_color_1 = _a.hatch_color, hatch_scale_1 = _a.hatch_scale, hatch_pattern_1 = _a.hatch_pattern, hatch_weight_1 = _a.hatch_weight, hatch_extra = _a.hatch_extra;
                if (hatch_extra != null && hatch_extra.hasOwnProperty(hatch_pattern_1)) {
                    var custom = hatch_extra[hatch_pattern_1];
                    this.cache.pattern = custom.get_pattern(hatch_color_1, hatch_scale_1, hatch_weight_1);
                }
                else {
                    this.cache.pattern = function (ctx) {
                        var canvas = create_hatch_canvas(hatch_pattern_1, hatch_color_1, hatch_scale_1, hatch_weight_1);
                        return ctx.createPattern(canvas, 'repeat');
                    };
                }
            }
            else
                value = _super.prototype.cache_select.call(this, name, i);
            return value;
        };
        Hatch.prototype._try_defer = function (defer_func) {
            var _a = this.cache, hatch_pattern = _a.hatch_pattern, hatch_extra = _a.hatch_extra;
            if (hatch_extra != null && hatch_extra.hasOwnProperty(hatch_pattern)) {
                var custom = hatch_extra[hatch_pattern];
                custom.onload(defer_func);
            }
        };
        Object.defineProperty(Hatch.prototype, "doit", {
            get: function () {
                return !(this.hatch_color.spec.value === null ||
                    this.hatch_alpha.spec.value == 0 ||
                    this.hatch_pattern.spec.value == " " ||
                    this.hatch_pattern.spec.value == "blank" ||
                    this.hatch_pattern.spec.value === null);
            },
            enumerable: true,
            configurable: true
        });
        Hatch.prototype.doit2 = function (ctx, i, ready_func, defer_func) {
            if (!this.doit) {
                return;
            }
            this.cache_select("pattern", i);
            var pattern = this.cache.pattern(ctx);
            if (pattern == null) {
                this._try_defer(defer_func);
            }
            else {
                this.set_vectorize(ctx, i);
                ready_func();
            }
        };
        Hatch.prototype._set_vectorize = function (ctx, i) {
            this.cache_select("pattern", i);
            ctx.fillStyle = this.cache.pattern(ctx);
            this.cache_select("hatch_alpha", i);
            if (ctx.globalAlpha !== this.cache.hatch_alpha)
                ctx.globalAlpha = this.cache.hatch_alpha;
        };
        Hatch.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.hatch_color.value(), this.hatch_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return "rgba(" + r * 255 + "," + g * 255 + "," + b * 255 + "," + a + ")";
        };
        return Hatch;
    }(ContextProperties));
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    Hatch.prototype.attrs = Object.keys(mixins.hatch());
    var Text = /** @class */ (function (_super) {
        tslib_1.__extends(Text, _super);
        function Text() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Text.prototype.cache_select = function (name, i) {
            var value;
            if (name == "font") {
                _super.prototype.cache_select.call(this, "text_font_style", i);
                _super.prototype.cache_select.call(this, "text_font_size", i);
                _super.prototype.cache_select.call(this, "text_font", i);
                var _a = this.cache, text_font_style = _a.text_font_style, text_font_size = _a.text_font_size, text_font = _a.text_font;
                this.cache.font = value = text_font_style + " " + text_font_size + " " + text_font;
            }
            else
                value = _super.prototype.cache_select.call(this, name, i);
            return value;
        };
        Text.prototype.font_value = function () {
            var font = this.text_font.value();
            var font_size = this.text_font_size.value();
            var font_style = this.text_font_style.value();
            return font_style + " " + font_size + " " + font;
        };
        Text.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.text_color.value(), this.text_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return "rgba(" + r * 255 + "," + g * 255 + "," + b * 255 + "," + a + ")";
        };
        Text.prototype.set_value = function (ctx) {
            ctx.font = this.font_value();
            ctx.fillStyle = this.text_color.value();
            ctx.globalAlpha = this.text_alpha.value();
            ctx.textAlign = this.text_align.value();
            ctx.textBaseline = this.text_baseline.value();
        };
        Object.defineProperty(Text.prototype, "doit", {
            get: function () {
                return !(this.text_color.spec.value === null ||
                    this.text_alpha.spec.value == 0);
            },
            enumerable: true,
            configurable: true
        });
        Text.prototype._set_vectorize = function (ctx, i) {
            this.cache_select("font", i);
            if (ctx.font !== this.cache.font)
                ctx.font = this.cache.font;
            this.cache_select("text_color", i);
            if (ctx.fillStyle !== this.cache.text_color)
                ctx.fillStyle = this.cache.text_color;
            this.cache_select("text_alpha", i);
            if (ctx.globalAlpha !== this.cache.text_alpha)
                ctx.globalAlpha = this.cache.text_alpha;
            this.cache_select("text_align", i);
            if (ctx.textAlign !== this.cache.text_align)
                ctx.textAlign = this.cache.text_align;
            this.cache_select("text_baseline", i);
            if (ctx.textBaseline !== this.cache.text_baseline)
                ctx.textBaseline = this.cache.text_baseline;
        };
        return Text;
    }(ContextProperties));
    exports.Text = Text;
    Text.__name__ = "Text";
    Text.prototype.attrs = Object.keys(mixins.text());
    var Visuals = /** @class */ (function () {
        function Visuals(model) {
            for (var _i = 0, _a = model.mixins; _i < _a.length; _i++) {
                var mixin = _a[_i];
                var _b = mixin.split(":"), name = _b[0], _c = _b[1], prefix = _c === void 0 ? "" : _c;
                var cls = void 0;
                switch (name) {
                    case "line":
                        cls = Line;
                        break;
                    case "fill":
                        cls = Fill;
                        break;
                    case "hatch":
                        cls = Hatch;
                        break;
                    case "text":
                        cls = Text;
                        break;
                    default:
                        throw new Error("unknown visual: " + name);
                }
                this[prefix + name] = new cls(model, prefix);
            }
        }
        Visuals.prototype.warm_cache = function (source) {
            for (var name in this) {
                if (this.hasOwnProperty(name)) {
                    var prop = this[name];
                    if (prop instanceof ContextProperties)
                        prop.warm_cache(source);
                }
            }
        };
        Visuals.prototype.set_all_indices = function (all_indices) {
            for (var name in this) {
                if (this.hasOwnProperty(name)) {
                    var prop = this[name];
                    if (prop instanceof ContextProperties)
                        prop.all_indices = all_indices;
                }
            }
        };
        return Visuals;
    }());
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* model.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var has_props_1 = require(115) /* ./core/has_props */;
    var p = require(121) /* ./core/properties */;
    var types_1 = require(109) /* ./core/util/types */;
    var object_1 = require(125) /* ./core/util/object */;
    var logging_1 = require(167) /* ./core/logging */;
    var Model = /** @class */ (function (_super) {
        tslib_1.__extends(Model, _super);
        function Model(attrs) {
            return _super.call(this, attrs) || this;
        }
        Model.init_Model = function () {
            this.define({
                tags: [p.Array, []],
                name: [p.String],
                js_property_callbacks: [p.Any, {}],
                js_event_callbacks: [p.Any, {}],
                subscribed_events: [p.Array, []],
            });
        };
        Model.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, function () { return _this._update_property_callbacks(); });
            this.connect(this.properties.js_event_callbacks.change, function () { return _this._update_event_callbacks(); });
            this.connect(this.properties.subscribed_events.change, function () { return _this._update_event_callbacks(); });
        };
        /*protected*/ Model.prototype._process_event = function (event) {
            for (var _i = 0, _a = this.js_event_callbacks[event.event_name] || []; _i < _a.length; _i++) {
                var callback = _a[_i];
                callback.execute(event);
            }
            if (this.document != null && this.subscribed_events.some(function (m) { return m == event.event_name; }))
                this.document.event_manager.send_event(event);
        };
        Model.prototype.trigger_event = function (event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        };
        Model.prototype._update_event_callbacks = function () {
            if (this.document == null) {
                // File an issue: SidePanel in particular seems to have this issue
                logging_1.logger.warn('WARNING: Document not defined for updating event callbacks');
                return;
            }
            this.document.event_manager.subscribed_models.add(this.id);
        };
        Model.prototype._update_property_callbacks = function () {
            var _this = this;
            var signal_for = function (event) {
                var _a = event.split(":"), evt = _a[0], _b = _a[1], attr = _b === void 0 ? null : _b;
                return attr != null ? _this.properties[attr][evt] : _this[evt];
            };
            for (var event in this._js_callbacks) {
                var callbacks = this._js_callbacks[event];
                var signal = signal_for(event);
                for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                    var cb = callbacks_1[_i];
                    this.disconnect(signal, cb);
                }
            }
            this._js_callbacks = {};
            for (var event in this.js_property_callbacks) {
                var callbacks = this.js_property_callbacks[event];
                var wrappers = callbacks.map(function (cb) { return function () { return cb.execute(_this); }; });
                this._js_callbacks[event] = wrappers;
                var signal = signal_for(event);
                for (var _a = 0, wrappers_1 = wrappers; _a < wrappers_1.length; _a++) {
                    var cb = wrappers_1[_a];
                    this.connect(signal, cb);
                }
            }
        };
        Model.prototype._doc_attached = function () {
            if (!object_1.isEmpty(this.js_event_callbacks) || !object_1.isEmpty(this.subscribed_events))
                this._update_event_callbacks();
        };
        Model.prototype.select = function (selector) {
            if (types_1.isString(selector))
                return this.references().filter(function (ref) { return ref instanceof Model && ref.name === selector; });
            else if (selector.prototype instanceof has_props_1.HasProps)
                return this.references().filter(function (ref) { return ref instanceof selector; });
            else
                throw new Error("invalid selector");
        };
        Model.prototype.select_one = function (selector) {
            var result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error("found more than one object matching given selector");
            }
        };
        return Model;
    }(has_props_1.HasProps));
    exports.Model = Model;
    Model.__name__ = "Model";
    Model.init_Model();
},
/* core/logging.js */ function _(require, module, exports) {
    var types_1 = require(109) /* ./util/types */;
    var _loggers = {};
    var LogLevel = /** @class */ (function () {
        function LogLevel(name, level) {
            this.name = name;
            this.level = level;
        }
        return LogLevel;
    }());
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    var Logger = /** @class */ (function () {
        function Logger(name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            this._name = name;
            this.set_level(level);
        }
        Object.defineProperty(Logger, "levels", {
            get: function () {
                return Object.keys(Logger.log_levels);
            },
            enumerable: true,
            configurable: true
        });
        Logger.get = function (name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            if (name.length > 0) {
                var logger = _loggers[name];
                if (logger == null)
                    _loggers[name] = logger = new Logger(name, level);
                return logger;
            }
            else
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
        };
        Object.defineProperty(Logger.prototype, "level", {
            get: function () {
                return this.get_level();
            },
            enumerable: true,
            configurable: true
        });
        Logger.prototype.get_level = function () {
            return this._log_level;
        };
        Logger.prototype.set_level = function (log_level) {
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if (types_1.isString(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            var logger_name = "[" + this._name + "]";
            for (var name in Logger.log_levels) {
                var log_level_1 = Logger.log_levels[name];
                if (log_level_1.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                    this[name] = function () { };
                else
                    this[name] = _method_factory(name, logger_name);
            }
        };
        Logger.prototype.trace = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.debug = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.info = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.warn = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.error = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        return Logger;
    }());
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () { };
    }
    exports.logger = Logger.get("bokeh");
    function set_log_level(level) {
        if (Logger.log_levels[level] == null) {
            console.log("[bokeh] unrecognized logging level '" + level + "' passed to Bokeh.set_log_level(), ignoring");
            console.log("[bokeh] valid log levels are: " + Logger.levels.join(', '));
        }
        else {
            console.log("[bokeh] setting log level to: '" + level + "'");
            exports.logger.set_level(level);
        }
    }
    exports.set_log_level = set_log_level;
},
/* models/annotations/arrow.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var arrow_head_1 = require(169) /* ./arrow_head */;
    var column_data_source_1 = require(170) /* ../sources/column_data_source */;
    var p = require(121) /* ../../core/properties */;
    var math_1 = require(111) /* ../../core/util/math */;
    var ArrowView = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowView, _super);
        function ArrowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.model.source == null)
                this.model.source = new column_data_source_1.ColumnDataSource();
            this.set_data(this.model.source);
        };
        ArrowView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.set_data(_this.model.source); });
            this.connect(this.model.source.streaming, function () { return _this.set_data(_this.model.source); });
            this.connect(this.model.source.patching, function () { return _this.set_data(_this.model.source); });
        };
        ArrowView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        };
        ArrowView.prototype._map_data = function () {
            var frame = this.plot_view.frame;
            var sx_start, sy_start;
            if (this.model.start_units == 'data') {
                sx_start = frame.xscales[this.model.x_range_name].v_compute(this._x_start);
                sy_start = frame.yscales[this.model.y_range_name].v_compute(this._y_start);
            }
            else {
                sx_start = frame.xview.v_compute(this._x_start);
                sy_start = frame.yview.v_compute(this._y_start);
            }
            var sx_end, sy_end;
            if (this.model.end_units == 'data') {
                sx_end = frame.xscales[this.model.x_range_name].v_compute(this._x_end);
                sy_end = frame.yscales[this.model.y_range_name].v_compute(this._y_end);
            }
            else {
                sx_end = frame.xview.v_compute(this._x_end);
                sy_end = frame.yview.v_compute(this._y_end);
            }
            return [[sx_start, sy_start], [sx_end, sy_end]];
        };
        ArrowView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            // Order in this function is important. First we draw all the arrow heads.
            var _a = this._map_data(), start = _a[0], end = _a[1];
            if (this.model.end != null)
                this._arrow_head(ctx, "render", this.model.end, start, end);
            if (this.model.start != null)
                this._arrow_head(ctx, "render", this.model.start, end, start);
            // Next we call .clip on all the arrow heads, inside an initial canvas sized
            // rect, to create an "inverted" clip region for the arrow heads
            ctx.beginPath();
            var _b = this.plot_view.layout.bbox, x = _b.x, y = _b.y, width = _b.width, height = _b.height;
            ctx.rect(x, y, width, height);
            if (this.model.end != null)
                this._arrow_head(ctx, "clip", this.model.end, start, end);
            if (this.model.start != null)
                this._arrow_head(ctx, "clip", this.model.start, end, start);
            ctx.closePath();
            ctx.clip();
            // Finally we draw the arrow body, with the clipping regions set up. This prevents
            // "fat" arrows from overlapping the arrow head in a bad way.
            this._arrow_body(ctx, start, end);
            ctx.restore();
        };
        ArrowView.prototype._arrow_head = function (ctx, action, head, start, end) {
            for (var i = 0, _end = this._x_start.length; i < _end; i++) {
                // arrow head runs orthogonal to arrow body
                var angle = Math.PI / 2 + math_1.atan2([start[0][i], start[1][i]], [end[0][i], end[1][i]]);
                ctx.save();
                ctx.translate(end[0][i], end[1][i]);
                ctx.rotate(angle);
                if (action == "render")
                    head.render(ctx, i);
                else if (action == "clip")
                    head.clip(ctx, i);
                ctx.restore();
            }
        };
        ArrowView.prototype._arrow_body = function (ctx, start, end) {
            if (!this.visuals.line.doit)
                return;
            for (var i = 0, n = this._x_start.length; i < n; i++) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(start[0][i], start[1][i]);
                ctx.lineTo(end[0][i], end[1][i]);
                ctx.stroke();
            }
        };
        return ArrowView;
    }(annotation_1.AnnotationView));
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    var Arrow = /** @class */ (function (_super) {
        tslib_1.__extends(Arrow, _super);
        function Arrow(attrs) {
            return _super.call(this, attrs) || this;
        }
        Arrow.init_Arrow = function () {
            this.prototype.default_view = ArrowView;
            this.mixins(['line']);
            this.define({
                x_start: [p.NumberSpec],
                y_start: [p.NumberSpec],
                start_units: [p.SpatialUnits, 'data'],
                start: [p.Instance, null],
                x_end: [p.NumberSpec],
                y_end: [p.NumberSpec],
                end_units: [p.SpatialUnits, 'data'],
                end: [p.Instance, function () { return new arrow_head_1.OpenHead({}); }],
                source: [p.Instance],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
        };
        return Arrow;
    }(annotation_1.Annotation));
    exports.Arrow = Arrow;
    Arrow.__name__ = "Arrow";
    Arrow.init_Arrow();
},
/* models/annotations/arrow_head.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var visuals_1 = require(165) /* ../../core/visuals */;
    var p = require(121) /* ../../core/properties */;
    var ArrowHead = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowHead, _super);
        function ArrowHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        ArrowHead.init_ArrowHead = function () {
            this.define({
                size: [p.Number, 25],
            });
        };
        ArrowHead.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals_1.Visuals(this);
        };
        return ArrowHead;
    }(annotation_1.Annotation));
    exports.ArrowHead = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    ArrowHead.init_ArrowHead();
    var OpenHead = /** @class */ (function (_super) {
        tslib_1.__extends(OpenHead, _super);
        function OpenHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        OpenHead.init_OpenHead = function () {
            this.mixins(['line']);
        };
        OpenHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        OpenHead.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(0.5 * this.size, this.size);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * this.size, this.size);
                ctx.stroke();
            }
        };
        return OpenHead;
    }(ArrowHead));
    exports.OpenHead = OpenHead;
    OpenHead.__name__ = "OpenHead";
    OpenHead.init_OpenHead();
    var NormalHead = /** @class */ (function (_super) {
        tslib_1.__extends(NormalHead, _super);
        function NormalHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        NormalHead.init_NormalHead = function () {
            this.mixins(['line', 'fill']);
            this.override({
                fill_color: 'black',
            });
        };
        NormalHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        NormalHead.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        };
        NormalHead.prototype._normal = function (ctx, _i) {
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.closePath();
        };
        return NormalHead;
    }(ArrowHead));
    exports.NormalHead = NormalHead;
    NormalHead.__name__ = "NormalHead";
    NormalHead.init_NormalHead();
    var VeeHead = /** @class */ (function (_super) {
        tslib_1.__extends(VeeHead, _super);
        function VeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        VeeHead.init_VeeHead = function () {
            this.mixins(['line', 'fill']);
            this.override({
                fill_color: 'black',
            });
        };
        VeeHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0.5 * this.size);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        VeeHead.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        };
        VeeHead.prototype._vee = function (ctx, _i) {
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0.5 * this.size);
            ctx.closePath();
        };
        return VeeHead;
    }(ArrowHead));
    exports.VeeHead = VeeHead;
    VeeHead.__name__ = "VeeHead";
    VeeHead.init_VeeHead();
    var TeeHead = /** @class */ (function (_super) {
        tslib_1.__extends(TeeHead, _super);
        function TeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        TeeHead.init_TeeHead = function () {
            this.mixins(['line']);
        };
        TeeHead.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(0.5 * this.size, 0);
                ctx.lineTo(-0.5 * this.size, 0);
                ctx.stroke();
            }
        };
        TeeHead.prototype.clip = function (_ctx, _i) { };
        return TeeHead;
    }(ArrowHead));
    exports.TeeHead = TeeHead;
    TeeHead.__name__ = "TeeHead";
    TeeHead.init_TeeHead();
},
/* models/sources/column_data_source.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var columnar_data_source_1 = require(171) /* ./columnar_data_source */;
    var has_props_1 = require(115) /* ../../core/has_props */;
    var p = require(121) /* ../../core/properties */;
    var data_structures_1 = require(117) /* ../../core/util/data_structures */;
    var serialization_1 = require(196) /* ../../core/util/serialization */;
    var types_1 = require(109) /* ../../core/util/types */;
    var typed_array = require(198) /* ../../core/util/typed_array */;
    var object_1 = require(125) /* ../../core/util/object */;
    var events_1 = require(199) /* ../../document/events */;
    //exported for testing
    function stream_to_column(col, new_col, rollover) {
        if (types_1.isArray(col)) {
            var result = col.concat(new_col);
            if (rollover != null && result.length > rollover)
                return result.slice(-rollover);
            else
                return result;
        }
        else if (types_1.isTypedArray(col)) {
            var total_len = col.length + new_col.length;
            // handle rollover case for typed arrays
            if (rollover != null && total_len > rollover) {
                var start = total_len - rollover;
                var end = col.length;
                // resize col if it is shorter than the rollover length
                var result = void 0;
                if (col.length < rollover) {
                    result = new col.constructor(rollover);
                    result.set(col, 0);
                }
                else
                    result = col;
                // shift values in original col to accommodate new_col
                for (var i = start, endi = end; i < endi; i++) {
                    result[i - start] = result[i];
                }
                // update end values in col with new_col
                for (var i = 0, endi = new_col.length; i < endi; i++) {
                    result[i + (end - start)] = new_col[i];
                }
                return result;
            }
            else {
                var tmp = new col.constructor(new_col);
                return typed_array.concat(col, tmp);
            }
        }
        else
            throw new Error("unsupported array types");
    }
    exports.stream_to_column = stream_to_column;
    // exported for testing
    function slice(ind, length) {
        var start, step, stop;
        if (types_1.isNumber(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    exports.slice = slice;
    // exported for testing
    function patch_to_column(col, patch, shapes) {
        var patched = new data_structures_1.Set();
        var patched_range = false;
        for (var _i = 0, patch_1 = patch; _i < patch_1.length; _i++) {
            var _a = patch_1[_i], ind = _a[0], val = _a[1];
            // make the single index case look like the length-3 multi-index case
            var item = void 0, shape = void 0;
            var index = void 0;
            var value = void 0;
            if (types_1.isArray(ind)) {
                var i = ind[0];
                patched.add(i);
                shape = shapes[i];
                item = col[i];
                value = val;
                // this is basically like NumPy's "newaxis", inserting an empty dimension
                // makes length 2 and 3 multi-index cases uniform, so that the same code
                // can handle both
                if (ind.length === 2) {
                    shape = [1, shape[0]];
                    index = [ind[0], 0, ind[1]];
                }
                else
                    index = ind;
            }
            else {
                if (types_1.isNumber(ind)) {
                    value = [val];
                    patched.add(ind);
                }
                else {
                    value = val;
                    patched_range = true;
                }
                index = [0, 0, ind];
                shape = [1, col.length];
                item = col;
            }
            // now this one nested loop handles all cases
            var flat_index = 0;
            var _b = slice(index[1], shape[0]), istart = _b[0], istop = _b[1], istep = _b[2];
            var _c = slice(index[2], shape[1]), jstart = _c[0], jstop = _c[1], jstep = _c[2];
            for (var i = istart; i < istop; i += istep) {
                for (var j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.add(j);
                    }
                    item[(i * shape[1]) + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    }
    exports.patch_to_column = patch_to_column;
    var ColumnDataSource = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnDataSource, _super);
        function ColumnDataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColumnDataSource.init_ColumnDataSource = function () {
            this.define({
                data: [p.Any, {}],
            });
        };
        ColumnDataSource.prototype.initialize = function () {
            var _a;
            _super.prototype.initialize.call(this);
            _a = serialization_1.decode_column_data(this.data), this.data = _a[0], this._shapes = _a[1];
        };
        ColumnDataSource.prototype.attributes_as_json = function (include_defaults, value_to_json) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            if (value_to_json === void 0) {
                value_to_json = ColumnDataSource._value_to_json;
            }
            var attrs = {};
            var obj = this.serializable_attributes();
            for (var _i = 0, _a = object_1.keys(obj); _i < _a.length; _i++) {
                var key = _a[_i];
                var value = obj[key];
                if (key === 'data')
                    value = serialization_1.encode_column_data(value, this._shapes);
                if (include_defaults)
                    attrs[key] = value;
                else if (key in this._set_after_defaults)
                    attrs[key] = value;
            }
            return value_to_json("attributes", attrs, this);
        };
        ColumnDataSource._value_to_json = function (key, value, optional_parent_object) {
            if (types_1.isPlainObject(value) && key === 'data')
                return serialization_1.encode_column_data(value, optional_parent_object._shapes); // XXX: unknown vs. any
            else
                return has_props_1.HasProps._value_to_json(key, value, optional_parent_object);
        };
        ColumnDataSource.prototype.stream = function (new_data, rollover, setter_id) {
            var data = this.data;
            for (var k in new_data) {
                data[k] = stream_to_column(data[k], new_data[k], rollover);
            }
            this.setv({ data: data }, { silent: true });
            this.streaming.emit();
            if (this.document != null) {
                var hint = new events_1.ColumnsStreamedEvent(this.document, this.ref(), new_data, rollover);
                this.document._notify_change(this, 'data', null, null, { setter_id: setter_id, hint: hint });
            }
        };
        ColumnDataSource.prototype.patch = function (patches, setter_id) {
            var data = this.data;
            var patched = new data_structures_1.Set();
            for (var k in patches) {
                var patch = patches[k];
                patched = patched.union(patch_to_column(data[k], patch, this._shapes[k]));
            }
            this.setv({ data: data }, { silent: true });
            this.patching.emit(patched.values);
            if (this.document != null) {
                var hint = new events_1.ColumnsPatchedEvent(this.document, this.ref(), patches);
                this.document._notify_change(this, 'data', null, null, { setter_id: setter_id, hint: hint });
            }
        };
        return ColumnDataSource;
    }(columnar_data_source_1.ColumnarDataSource));
    exports.ColumnDataSource = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    ColumnDataSource.init_ColumnDataSource();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var data_source_1 = require(172) /* ./data_source */;
    var signaling_1 = require(116) /* ../../core/signaling */;
    var logging_1 = require(167) /* ../../core/logging */;
    var selection_manager_1 = require(174) /* ../../core/selection_manager */;
    var p = require(121) /* ../../core/properties */;
    var types_1 = require(109) /* ../../core/util/types */;
    var array_1 = require(110) /* ../../core/util/array */;
    var object_1 = require(125) /* ../../core/util/object */;
    var selection_1 = require(173) /* ../selections/selection */;
    var interaction_policy_1 = require(195) /* ../selections/interaction_policy */;
    var ColumnarDataSource = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnarDataSource, _super);
        function ColumnarDataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColumnarDataSource.prototype.get_array = function (key) {
            var column = this.data[key];
            if (column == null)
                this.data[key] = column = [];
            else if (!types_1.isArray(column))
                this.data[key] = column = Array.from(column);
            return column;
        };
        ColumnarDataSource.init_ColumnarDataSource = function () {
            this.define({
                selection_policy: [p.Instance, function () { return new interaction_policy_1.UnionRenderers(); }],
            });
            this.internal({
                selection_manager: [p.Instance, function (self) { return new selection_manager_1.SelectionManager({ source: self }); }],
                inspected: [p.Instance, function () { return new selection_1.Selection(); }],
                _shapes: [p.Any, {}],
            });
        };
        ColumnarDataSource.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect"); // XXX: <[indices, tool, renderer-view, source, data], this>
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
        };
        ColumnarDataSource.prototype.get_column = function (colname) {
            var column = this.data[colname];
            return column != null ? column : null;
        };
        ColumnarDataSource.prototype.columns = function () {
            // return the column names in this data source
            return object_1.keys(this.data);
        };
        ColumnarDataSource.prototype.get_length = function (soft) {
            if (soft === void 0) {
                soft = true;
            }
            var lengths = array_1.uniq(object_1.values(this.data).map(function (v) { return v.length; }));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    var msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else
                        throw new Error(msg);
                }
            }
        };
        ColumnarDataSource.prototype.get_indices = function () {
            var length = this.get_length();
            return array_1.range(0, length != null ? length : 1);
            //TODO: returns [0] when no data, should it?
        };
        ColumnarDataSource.prototype.clear = function () {
            var empty = {};
            for (var _i = 0, _a = this.columns(); _i < _a.length; _i++) {
                var col = _a[_i];
                empty[col] = new this.data[col].constructor(0);
            }
            this.data = empty;
        };
        return ColumnarDataSource;
    }(data_source_1.DataSource));
    exports.ColumnarDataSource = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    ColumnarDataSource.init_ColumnarDataSource();
},
/* models/sources/data_source.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var selection_1 = require(173) /* ../selections/selection */;
    var p = require(121) /* ../../core/properties */;
    var DataSource = /** @class */ (function (_super) {
        tslib_1.__extends(DataSource, _super);
        function DataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataSource.init_DataSource = function () {
            this.define({
                selected: [p.Instance, function () { return new selection_1.Selection(); }],
                callback: [p.Any],
            });
        };
        DataSource.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.selected.change, function () {
                if (_this.callback != null)
                    _this.callback.execute(_this);
            });
        };
        return DataSource;
    }(model_1.Model));
    exports.DataSource = DataSource;
    DataSource.__name__ = "DataSource";
    DataSource.init_DataSource();
},
/* models/selections/selection.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    var object_1 = require(125) /* ../../core/util/object */;
    var Selection = /** @class */ (function (_super) {
        tslib_1.__extends(Selection, _super);
        function Selection(attrs) {
            return _super.call(this, attrs) || this;
        }
        Selection.init_Selection = function () {
            this.define({
                indices: [p.Array, []],
                line_indices: [p.Array, []],
                multiline_indices: [p.Any, {}],
            });
            this.internal({
                final: [p.Boolean],
                selected_glyphs: [p.Array, []],
                get_view: [p.Any],
                image_indices: [p.Array, []],
            });
        };
        Selection.prototype.initialize = function () {
            var _this = this;
            _super.prototype.initialize.call(this);
            this['0d'] = { glyph: null, indices: [], flag: false, get_view: function () { return null; } };
            this['1d'] = { indices: this.indices };
            this['2d'] = { indices: {} };
            this.get_view = function () { return null; };
            this.connect(this.properties.indices.change, function () { return _this['1d'].indices = _this.indices; });
            this.connect(this.properties.line_indices.change, function () {
                _this['0d'].indices = _this.line_indices;
                _this['0d'].flag = _this.line_indices.length != 0;
            });
            this.connect(this.properties.selected_glyphs.change, function () { return _this['0d'].glyph = _this.selected_glyph; });
            this.connect(this.properties.get_view.change, function () { return _this['0d'].get_view = _this.get_view; });
            this.connect(this.properties.multiline_indices.change, function () { return _this['2d'].indices = _this.multiline_indices; });
        };
        Object.defineProperty(Selection.prototype, "selected_glyph", {
            get: function () {
                return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
            },
            enumerable: true,
            configurable: true
        });
        Selection.prototype.add_to_selected_glyphs = function (glyph) {
            this.selected_glyphs.push(glyph);
        };
        Selection.prototype.update = function (selection, final, append) {
            this.final = final;
            if (append)
                this.update_through_union(selection);
            else {
                this.indices = selection.indices;
                this.line_indices = selection.line_indices;
                this.selected_glyphs = selection.selected_glyphs;
                this.get_view = selection.get_view;
                this.multiline_indices = selection.multiline_indices;
                this.image_indices = selection.image_indices;
            }
        };
        Selection.prototype.clear = function () {
            this.final = true;
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.get_view = function () { return null; };
            this.selected_glyphs = [];
        };
        Selection.prototype.is_empty = function () {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        };
        Selection.prototype.update_through_union = function (other) {
            this.indices = array_1.union(other.indices, this.indices);
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            if (!this.get_view())
                this.get_view = other.get_view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        Selection.prototype.update_through_intersection = function (other) {
            this.indices = array_1.intersection(other.indices, this.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            if (!this.get_view())
                this.get_view = other.get_view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        return Selection;
    }(model_1.Model));
    exports.Selection = Selection;
    Selection.__name__ = "Selection";
    Selection.init_Selection();
},
/* core/selection_manager.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var has_props_1 = require(115) /* ./has_props */;
    var selection_1 = require(173) /* ../models/selections/selection */;
    var glyph_renderer_1 = require(175) /* ../models/renderers/glyph_renderer */;
    var graph_renderer_1 = require(192) /* ../models/renderers/graph_renderer */;
    var p = require(121) /* ./properties */;
    var SelectionManager = /** @class */ (function (_super) {
        tslib_1.__extends(SelectionManager, _super);
        function SelectionManager(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.inspectors = {};
            return _this;
        }
        SelectionManager.init_SelectionManager = function () {
            this.internal({
                source: [p.Any],
            });
        };
        SelectionManager.prototype.select = function (renderer_views, geometry, final, append) {
            if (append === void 0) {
                append = false;
            }
            // divide renderers into glyph_renderers or graph_renderers
            var glyph_renderer_views = [];
            var graph_renderer_views = [];
            for (var _i = 0, renderer_views_1 = renderer_views; _i < renderer_views_1.length; _i++) {
                var r = renderer_views_1[_i];
                if (r instanceof glyph_renderer_1.GlyphRendererView)
                    glyph_renderer_views.push(r);
                else if (r instanceof graph_renderer_1.GraphRendererView)
                    graph_renderer_views.push(r);
            }
            var did_hit = false;
            // graph renderer case
            for (var _a = 0, graph_renderer_views_1 = graph_renderer_views; _a < graph_renderer_views_1.length; _a++) {
                var r = graph_renderer_views_1[_a];
                var hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, append);
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                var hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, append);
            }
            return did_hit;
        };
        SelectionManager.prototype.inspect = function (renderer_view, geometry) {
            var did_hit = false;
            if (renderer_view instanceof glyph_renderer_1.GlyphRendererView) {
                var hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    var inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, false);
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view, { geometry: geometry }]);
                }
            }
            else if (renderer_view instanceof graph_renderer_1.GraphRendererView) {
                var hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, false);
            }
            return did_hit;
        };
        SelectionManager.prototype.clear = function (rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        };
        SelectionManager.prototype.get_or_create_inspector = function (rmodel) {
            if (this.inspectors[rmodel.id] == null)
                this.inspectors[rmodel.id] = new selection_1.Selection();
            return this.inspectors[rmodel.id];
        };
        return SelectionManager;
    }(has_props_1.HasProps));
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
    SelectionManager.init_SelectionManager();
},
/* models/renderers/glyph_renderer.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var data_renderer_1 = require(176) /* ./data_renderer */;
    var line_1 = require(177) /* ../glyphs/line */;
    var patch_1 = require(187) /* ../glyphs/patch */;
    var harea_1 = require(188) /* ../glyphs/harea */;
    var varea_1 = require(190) /* ../glyphs/varea */;
    var cds_view_1 = require(191) /* ../sources/cds_view */;
    var logging_1 = require(167) /* ../../core/logging */;
    var p = require(121) /* ../../core/properties */;
    var arrayable_1 = require(114) /* ../../core/util/arrayable */;
    var array_1 = require(110) /* ../../core/util/array */;
    var object_1 = require(125) /* ../../core/util/object */;
    var factor_range_1 = require(184) /* ../ranges/factor_range */;
    var selection_defaults = {
        fill: {},
        line: {},
    };
    var decimated_defaults = {
        fill: { fill_alpha: 0.3, fill_color: "grey" },
        line: { line_alpha: 0.3, line_color: "grey" },
    };
    var nonselection_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    var GlyphRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(GlyphRendererView, _super);
        function GlyphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GlyphRendererView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            var base_glyph = this.model.glyph;
            var has_fill = array_1.includes(base_glyph.mixins, "fill");
            var has_line = array_1.includes(base_glyph.mixins, "line");
            var glyph_attrs = object_1.clone(base_glyph.attributes);
            delete glyph_attrs.id;
            function mk_glyph(defaults) {
                var attrs = object_1.clone(glyph_attrs);
                if (has_fill)
                    object_1.extend(attrs, defaults.fill);
                if (has_line)
                    object_1.extend(attrs, defaults.line);
                return new base_glyph.constructor(attrs);
            }
            this.glyph = this.build_glyph_view(base_glyph);
            var selection_glyph = this.model.selection_glyph;
            if (selection_glyph == null)
                selection_glyph = mk_glyph({ fill: {}, line: {} });
            else if (selection_glyph === "auto")
                selection_glyph = mk_glyph(selection_defaults);
            this.selection_glyph = this.build_glyph_view(selection_glyph);
            var nonselection_glyph = this.model.nonselection_glyph;
            if ((nonselection_glyph == null))
                nonselection_glyph = mk_glyph({ fill: {}, line: {} });
            else if (nonselection_glyph === "auto")
                nonselection_glyph = mk_glyph(nonselection_defaults);
            this.nonselection_glyph = this.build_glyph_view(nonselection_glyph);
            var hover_glyph = this.model.hover_glyph;
            if (hover_glyph != null)
                this.hover_glyph = this.build_glyph_view(hover_glyph);
            var muted_glyph = this.model.muted_glyph;
            if (muted_glyph != null)
                this.muted_glyph = this.build_glyph_view(muted_glyph);
            var decimated_glyph = mk_glyph(decimated_defaults);
            this.decimated_glyph = this.build_glyph_view(decimated_glyph);
            this.xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            this.yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            this.set_data(false);
        };
        GlyphRendererView.prototype.build_glyph_view = function (model) {
            return new model.default_view({ model: model, parent: this }); // XXX
        };
        GlyphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.request_render(); });
            this.connect(this.model.glyph.change, function () { return _this.set_data(); });
            this.connect(this.model.data_source.change, function () { return _this.set_data(); });
            this.connect(this.model.data_source.streaming, function () { return _this.set_data(); });
            this.connect(this.model.data_source.patching, function (indices /* XXX: WHY? */) { return _this.set_data(true, indices); });
            this.connect(this.model.data_source.selected.change, function () { return _this.request_render(); });
            this.connect(this.model.data_source._select, function () { return _this.request_render(); });
            if (this.hover_glyph != null)
                this.connect(this.model.data_source.inspect, function () { return _this.request_render(); });
            this.connect(this.model.properties.view.change, function () { return _this.set_data(); });
            this.connect(this.model.view.change, function () { return _this.set_data(); });
            this.connect(this.model.properties.visible.change, function () { return _this.plot_view.update_dataranges(); });
            var _a = this.plot_view.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name in x_ranges) {
                var rng = x_ranges[name];
                if (rng instanceof factor_range_1.FactorRange)
                    this.connect(rng.change, function () { return _this.set_data(); });
            }
            for (var name in y_ranges) {
                var rng = y_ranges[name];
                if (rng instanceof factor_range_1.FactorRange)
                    this.connect(rng.change, function () { return _this.set_data(); });
            }
            this.connect(this.model.glyph.transformchange, function () { return _this.set_data(); });
        };
        GlyphRendererView.prototype.have_selection_glyphs = function () {
            return this.selection_glyph != null && this.nonselection_glyph != null;
        };
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        GlyphRendererView.prototype.set_data = function (request_render, indices) {
            if (request_render === void 0) {
                request_render = true;
            }
            if (indices === void 0) {
                indices = null;
            }
            var t0 = Date.now();
            var source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            // TODO (bev) this is a bit clunky, need to make sure glyphs use the correct ranges when they call
            // mapping functions on the base Renderer class
            this.glyph.model.setv({ x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name }, { silent: true });
            this.glyph.set_data(source, this.all_indices, indices);
            this.glyph.set_visuals(source);
            this.decimated_glyph.set_visuals(source);
            if (this.have_selection_glyphs()) {
                this.selection_glyph.set_visuals(source);
                this.nonselection_glyph.set_visuals(source);
            }
            if (this.hover_glyph != null)
                this.hover_glyph.set_visuals(source);
            if (this.muted_glyph != null)
                this.muted_glyph.set_visuals(source);
            var lod_factor = this.plot_model.lod_factor;
            this.decimated = [];
            for (var i = 0, end = Math.floor(this.all_indices.length / lod_factor); i < end; i++) {
                this.decimated.push(i * lod_factor);
            }
            var dt = Date.now() - t0;
            logging_1.logger.debug(this.glyph.model.type + " GlyphRenderer (" + this.model.id + "): set_data finished in " + dt + "ms");
            this.set_data_timestamp = Date.now();
            if (request_render)
                this.request_render();
        };
        Object.defineProperty(GlyphRendererView.prototype, "has_webgl", {
            get: function () {
                return this.glyph.glglyph != null;
            },
            enumerable: true,
            configurable: true
        });
        GlyphRendererView.prototype.render = function () {
            var _this = this;
            if (!this.model.visible)
                return;
            var t0 = Date.now();
            var glsupport = this.has_webgl;
            this.glyph.map_data();
            var dtmap = Date.now() - t0;
            var tmask = Date.now();
            // all_indices is in full data space, indices is converted to subset space
            // either by mask_data (that uses the spatial index) or manually
            var indices = this.glyph.mask_data(this.all_indices);
            if (indices.length === this.all_indices.length) {
                indices = array_1.range(0, this.all_indices.length);
            }
            var dtmask = Date.now() - tmask;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            // selected is in full set space
            var selected = this.model.data_source.selected;
            var selected_full_indices;
            if (!selected || selected.is_empty())
                selected_full_indices = [];
            else {
                if (this.glyph instanceof line_1.LineView && selected.selected_glyph === this.glyph.model)
                    selected_full_indices = this.model.view.convert_indices_from_subset(indices);
                else
                    selected_full_indices = selected.indices;
            }
            // inspected is in full set space
            var inspected = this.model.data_source.inspected;
            var inspected_full_indices = new Set((function () {
                if (!inspected || inspected.is_empty())
                    return [];
                else {
                    if (inspected['0d'].glyph)
                        return _this.model.view.convert_indices_from_subset(indices);
                    else if (inspected['1d'].indices.length > 0)
                        return inspected['1d'].indices;
                    else
                        return arrayable_1.map(Object.keys(inspected["2d"].indices), function (i) { return parseInt(i); });
                }
            })());
            // inspected is transformed to subset space
            var inspected_subset_indices = arrayable_1.filter(indices, function (i) { return inspected_full_indices.has(_this.all_indices[i]); });
            var lod_threshold = this.plot_model.lod_threshold;
            var glyph;
            var nonselection_glyph;
            var selection_glyph;
            if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false)
                && !glsupport && lod_threshold != null && this.all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = this.decimated;
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            }
            else {
                glyph = this.model.muted && this.muted_glyph != null ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected_subset_indices.length)
                indices = array_1.difference(indices, inspected_subset_indices);
            // Render with no selection
            var dtselect = null;
            var trender;
            if (!(selected_full_indices.length && this.have_selection_glyphs())) {
                trender = Date.now();
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices), this.glyph);
                    else
                        glyph.render(ctx, this.all_indices, this.glyph);
                }
                else if (this.glyph instanceof patch_1.PatchView || this.glyph instanceof harea_1.HAreaView || this.glyph instanceof varea_1.VAreaView) {
                    if (inspected.selected_glyphs.length == 0 || this.hover_glyph == null) {
                        glyph.render(ctx, this.all_indices, this.glyph);
                    }
                    else {
                        for (var _i = 0, _a = inspected.selected_glyphs; _i < _a.length; _i++) {
                            var sglyph = _a[_i];
                            if (sglyph.id == this.glyph.model.id)
                                this.hover_glyph.render(ctx, this.all_indices, this.glyph);
                        }
                    }
                }
                else {
                    glyph.render(ctx, indices, this.glyph);
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, inspected_subset_indices, this.glyph);
                }
                // Render with selection
            }
            else {
                // reset the selection mask
                var tselect = Date.now();
                var selected_mask = {};
                for (var _b = 0, selected_full_indices_1 = selected_full_indices; _b < selected_full_indices_1.length; _b++) {
                    var i = selected_full_indices_1[_b];
                    selected_mask[i] = true;
                }
                // intersect/different selection with render mask
                var selected_subset_indices = new Array();
                var nonselected_subset_indices = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    for (var _c = 0, _d = this.all_indices; _c < _d.length; _c++) {
                        var i = _d[_c];
                        if (selected_mask[i] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                else {
                    for (var _e = 0, indices_1 = indices; _e < indices_1.length; _e++) {
                        var i = indices_1[_e];
                        if (selected_mask[this.all_indices[i]] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                dtselect = Date.now() - tselect;
                trender = Date.now();
                nonselection_glyph.render(ctx, nonselected_subset_indices, this.glyph);
                selection_glyph.render(ctx, selected_subset_indices, this.glyph);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices), this.glyph);
                    else
                        this.hover_glyph.render(ctx, inspected_subset_indices, this.glyph);
                }
            }
            var dtrender = Date.now() - trender;
            this.last_dtrender = dtrender;
            var dttot = Date.now() - t0;
            logging_1.logger.debug(this.glyph.model.type + " GlyphRenderer (" + this.model.id + "): render finished in " + dttot + "ms");
            logging_1.logger.trace(" - map_data finished in       : " + dtmap + "ms");
            logging_1.logger.trace(" - mask_data finished in      : " + dtmask + "ms");
            if (dtselect != null) {
                logging_1.logger.trace(" - selection mask finished in : " + dtselect + "ms");
            }
            logging_1.logger.trace(" - glyph renders finished in  : " + dtrender + "ms");
            ctx.restore();
        };
        GlyphRendererView.prototype.draw_legend = function (ctx, x0, x1, y0, y1, field, label, index) {
            if (index == null)
                index = this.model.get_reference_point(field, label);
            this.glyph.draw_legend_for_index(ctx, { x0: x0, x1: x1, y0: y0, y1: y1 }, index);
        };
        GlyphRendererView.prototype.hit_test = function (geometry) {
            if (!this.model.visible)
                return null;
            var hit_test_result = this.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result == null)
                return null;
            return this.model.view.convert_selection_from_subset(hit_test_result);
        };
        return GlyphRendererView;
    }(data_renderer_1.DataRendererView));
    exports.GlyphRendererView = GlyphRendererView;
    GlyphRendererView.__name__ = "GlyphRendererView";
    var GlyphRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(GlyphRenderer, _super);
        function GlyphRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GlyphRenderer.init_GlyphRenderer = function () {
            this.prototype.default_view = GlyphRendererView;
            this.define({
                data_source: [p.Instance],
                view: [p.Instance, function () { return new cds_view_1.CDSView(); }],
                glyph: [p.Instance],
                hover_glyph: [p.Instance],
                nonselection_glyph: [p.Any, 'auto'],
                selection_glyph: [p.Any, 'auto'],
                muted_glyph: [p.Instance],
                muted: [p.Boolean, false],
            });
        };
        GlyphRenderer.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.view.source == null) {
                this.view.source = this.data_source;
                this.view.compute_indices();
            }
        };
        GlyphRenderer.prototype.get_reference_point = function (field, value) {
            var index = 0;
            if (field != null) {
                var data = this.data_source.get_column(field);
                if (data != null) {
                    var i = arrayable_1.indexOf(data, value);
                    if (i != -1)
                        index = i;
                }
            }
            return index;
        };
        GlyphRenderer.prototype.get_selection_manager = function () {
            return this.data_source.selection_manager;
        };
        return GlyphRenderer;
    }(data_renderer_1.DataRenderer));
    exports.GlyphRenderer = GlyphRenderer;
    GlyphRenderer.__name__ = "GlyphRenderer";
    GlyphRenderer.init_GlyphRenderer();
},
/* models/renderers/data_renderer.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var renderer_1 = require(160) /* ./renderer */;
    var p = require(121) /* ../../core/properties */;
    var DataRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(DataRendererView, _super);
        function DataRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DataRendererView;
    }(renderer_1.RendererView));
    exports.DataRendererView = DataRendererView;
    DataRendererView.__name__ = "DataRendererView";
    var DataRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(DataRenderer, _super);
        function DataRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataRenderer.init_DataRenderer = function () {
            this.define({
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.override({
                level: 'glyph',
            });
        };
        return DataRenderer;
    }(renderer_1.Renderer));
    exports.DataRenderer = DataRenderer;
    DataRenderer.__name__ = "DataRenderer";
    DataRenderer.init_DataRenderer();
},
/* models/glyphs/line.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var xy_glyph_1 = require(178) /* ./xy_glyph */;
    var utils_1 = require(186) /* ./utils */;
    var hittest = require(183) /* ../../core/hittest */;
    var LineView = /** @class */ (function (_super) {
        tslib_1.__extends(LineView, _super);
        function LineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LineView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            var drawing = false;
            var last_index = null;
            this.visuals.line.set_value(ctx);
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (drawing) {
                    if (!isFinite(sx[i] + sy[i])) {
                        ctx.stroke();
                        ctx.beginPath();
                        drawing = false;
                        last_index = i;
                        continue;
                    }
                    if (last_index != null && i - last_index > 1) {
                        ctx.stroke();
                        drawing = false;
                    }
                }
                if (drawing)
                    ctx.lineTo(sx[i], sy[i]);
                else {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    drawing = true;
                }
                last_index = i;
            }
            if (drawing)
                ctx.stroke();
        };
        LineView.prototype._hit_point = function (geometry) {
            var _this = this;
            /* Check if the point geometry hits this line glyph and return an object
            that describes the hit result:
              Args:
                * geometry (object): object with the following keys
                  * sx (float): screen x coordinate of the point
                  * sy (float): screen y coordinate of the point
                  * type (str): type of geometry (in this case it's a point)
              Output:
                Object with the following keys:
                  * 0d (bool): whether the point hits the glyph or not
                  * 1d (array(int)): array with the indices hit by the point
            */
            var result = hittest.create_empty_hit_test_result();
            var point = { x: geometry.sx, y: geometry.sy };
            var shortest = 9999;
            var threshold = Math.max(2, this.visuals.line.line_width.value() / 2);
            for (var i = 0, end = this.sx.length - 1; i < end; i++) {
                var p0 = { x: this.sx[i], y: this.sy[i] };
                var p1 = { x: this.sx[i + 1], y: this.sy[i + 1] };
                var dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result.add_to_selected_glyphs(this.model);
                    result.get_view = function () { return _this; };
                    result.line_indices = [i];
                }
            }
            return result;
        };
        LineView.prototype._hit_span = function (geometry) {
            var _this = this;
            var sx = geometry.sx, sy = geometry.sy;
            var result = hittest.create_empty_hit_test_result();
            var val;
            var values;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (var i = 0, end = values.length - 1; i < end; i++) {
                if ((values[i] <= val && val <= values[i + 1]) || (values[i + 1] <= val && val <= values[i])) {
                    result.add_to_selected_glyphs(this.model);
                    result.get_view = function () { return _this; };
                    result.line_indices.push(i);
                }
            }
            return result;
        };
        LineView.prototype.get_interpolation_hit = function (i, geometry) {
            var _a = [this._x[i], this._y[i], this._x[i + 1], this._y[i + 1]], x2 = _a[0], y2 = _a[1], x3 = _a[2], y3 = _a[3];
            return utils_1.line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
        };
        LineView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        };
        return LineView;
    }(xy_glyph_1.XYGlyphView));
    exports.LineView = LineView;
    LineView.__name__ = "LineView";
    var Line = /** @class */ (function (_super) {
        tslib_1.__extends(Line, _super);
        function Line(attrs) {
            return _super.call(this, attrs) || this;
        }
        Line.init_Line = function () {
            this.prototype.default_view = LineView;
            this.mixins(['line']);
        };
        return Line;
    }(xy_glyph_1.XYGlyph));
    exports.Line = Line;
    Line.__name__ = "Line";
    Line.init_Line();
},
/* models/glyphs/xy_glyph.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var spatial_1 = require(179) /* ../../core/util/spatial */;
    var glyph_1 = require(182) /* ./glyph */;
    var XYGlyphView = /** @class */ (function (_super) {
        tslib_1.__extends(XYGlyphView, _super);
        function XYGlyphView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        XYGlyphView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x.length; i < end; i++) {
                var x = this._x[i];
                var y = this._y[i];
                if (isNaN(x + y) || !isFinite(x + y))
                    continue;
                points.push({ x0: x, y0: y, x1: x, y1: y, i: i });
            }
            return new spatial_1.SpatialIndex(points);
        };
        XYGlyphView.prototype.scenterx = function (i) {
            return this.sx[i];
        };
        XYGlyphView.prototype.scentery = function (i) {
            return this.sy[i];
        };
        return XYGlyphView;
    }(glyph_1.GlyphView));
    exports.XYGlyphView = XYGlyphView;
    XYGlyphView.__name__ = "XYGlyphView";
    var XYGlyph = /** @class */ (function (_super) {
        tslib_1.__extends(XYGlyph, _super);
        function XYGlyph(attrs) {
            return _super.call(this, attrs) || this;
        }
        XYGlyph.init_XYGlyph = function () {
            this.coords([['x', 'y']]);
        };
        return XYGlyph;
    }(glyph_1.Glyph));
    exports.XYGlyph = XYGlyph;
    XYGlyph.__name__ = "XYGlyph";
    XYGlyph.init_XYGlyph();
},
/* core/util/spatial.js */ function _(require, module, exports) {
    var FlatBush = require(180) /* flatbush */;
    var bbox_1 = require(181) /* ./bbox */;
    var SpatialIndex = /** @class */ (function () {
        function SpatialIndex(points) {
            this.points = points;
            this.index = null;
            if (points.length > 0) {
                this.index = new FlatBush(points.length);
                for (var _i = 0, points_1 = points; _i < points_1.length; _i++) {
                    var p = points_1[_i];
                    var x0 = p.x0, y0 = p.y0, x1 = p.x1, y1 = p.y1;
                    this.index.add(x0, y0, x1, y1);
                }
                this.index.finish();
            }
        }
        SpatialIndex.prototype._normalize = function (rect) {
            var _a, _b;
            var x0 = rect.x0, y0 = rect.y0, x1 = rect.x1, y1 = rect.y1;
            if (x0 > x1)
                _a = [x1, x0], x0 = _a[0], x1 = _a[1];
            if (y0 > y1)
                _b = [y1, y0], y0 = _b[0], y1 = _b[1];
            return { x0: x0, y0: y0, x1: x1, y1: y1 };
        };
        Object.defineProperty(SpatialIndex.prototype, "bbox", {
            get: function () {
                if (this.index == null)
                    return bbox_1.empty();
                else {
                    var _a = this.index, minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
                    return { x0: minX, y0: minY, x1: maxX, y1: maxY };
                }
            },
            enumerable: true,
            configurable: true
        });
        SpatialIndex.prototype.search = function (rect) {
            var _this = this;
            if (this.index == null)
                return [];
            else {
                var _a = this._normalize(rect), x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
                var indices = this.index.search(x0, y0, x1, y1);
                return indices.map(function (j) { return _this.points[j]; });
            }
        };
        SpatialIndex.prototype.indices = function (rect) {
            return this.search(rect).map(function (_a) {
                var i = _a.i;
                return i;
            });
        };
        return SpatialIndex;
    }());
    exports.SpatialIndex = SpatialIndex;
    SpatialIndex.__name__ = "SpatialIndex";
},
/* flatbush/flatbush.js */ function _(require, module, exports) {
    (function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
            typeof define === 'function' && define.amd ? define(factory) :
                (global = global || self, global.Flatbush = factory());
    }(this, function () {
        'use strict';
        var FlatQueue = function FlatQueue() {
            this.ids = [];
            this.values = [];
            this.length = 0;
        };
        FlatQueue.prototype.clear = function clear() {
            this.length = this.ids.length = this.values.length = 0;
        };
        FlatQueue.prototype.push = function push(id, value) {
            this.ids.push(id);
            this.values.push(value);
            var pos = this.length++;
            while (pos > 0) {
                var parent = (pos - 1) >> 1;
                var parentValue = this.values[parent];
                if (value >= parentValue) {
                    break;
                }
                this.ids[pos] = this.ids[parent];
                this.values[pos] = parentValue;
                pos = parent;
            }
            this.ids[pos] = id;
            this.values[pos] = value;
        };
        FlatQueue.prototype.pop = function pop() {
            if (this.length === 0) {
                return undefined;
            }
            var top = this.ids[0];
            this.length--;
            if (this.length > 0) {
                var id = this.ids[0] = this.ids[this.length];
                var value = this.values[0] = this.values[this.length];
                var halfLength = this.length >> 1;
                var pos = 0;
                while (pos < halfLength) {
                    var left = (pos << 1) + 1;
                    var right = left + 1;
                    var bestIndex = this.ids[left];
                    var bestValue = this.values[left];
                    var rightValue = this.values[right];
                    if (right < this.length && rightValue < bestValue) {
                        left = right;
                        bestIndex = this.ids[right];
                        bestValue = rightValue;
                    }
                    if (bestValue >= value) {
                        break;
                    }
                    this.ids[pos] = bestIndex;
                    this.values[pos] = bestValue;
                    pos = left;
                }
                this.ids[pos] = id;
                this.values[pos] = value;
            }
            this.ids.pop();
            this.values.pop();
            return top;
        };
        FlatQueue.prototype.peek = function peek() {
            return this.ids[0];
        };
        FlatQueue.prototype.peekValue = function peekValue() {
            return this.values[0];
        };
        var ARRAY_TYPES = [
            Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
            Int32Array, Uint32Array, Float32Array, Float64Array
        ];
        var VERSION = 3; // serialized format version
        var Flatbush = function Flatbush(numItems, nodeSize, ArrayType, data) {
            if (nodeSize === void 0)
                nodeSize = 16;
            if (ArrayType === void 0)
                ArrayType = Float64Array;
            if (numItems === undefined) {
                throw new Error('Missing required argument: numItems.');
            }
            if (isNaN(numItems) || numItems <= 0) {
                throw new Error(("Unpexpected numItems value: " + numItems + "."));
            }
            this.numItems = +numItems;
            this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
            // calculate the total number of nodes in the R-tree to allocate space for
            // and the index of each tree level (used in search later)
            var n = numItems;
            var numNodes = n;
            this._levelBounds = [n * 4];
            do {
                n = Math.ceil(n / this.nodeSize);
                numNodes += n;
                this._levelBounds.push(numNodes * 4);
            } while (n !== 1);
            this.ArrayType = ArrayType || Float64Array;
            this.IndexArrayType = numNodes < 16384 ? Uint16Array : Uint32Array;
            var arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
            var nodesByteSize = numNodes * 4 * this.ArrayType.BYTES_PER_ELEMENT;
            if (arrayTypeIndex < 0) {
                throw new Error(("Unexpected typed array class: " + ArrayType + "."));
            }
            if (data && (data instanceof ArrayBuffer)) {
                this.data = data;
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = numNodes * 4;
                this.minX = this._boxes[this._pos - 4];
                this.minY = this._boxes[this._pos - 3];
                this.maxX = this._boxes[this._pos - 2];
                this.maxY = this._boxes[this._pos - 1];
            }
            else {
                this.data = new ArrayBuffer(8 + nodesByteSize + numNodes * this.IndexArrayType.BYTES_PER_ELEMENT);
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = 0;
                this.minX = Infinity;
                this.minY = Infinity;
                this.maxX = -Infinity;
                this.maxY = -Infinity;
                new Uint8Array(this.data, 0, 2).set([0xfb, (VERSION << 4) + arrayTypeIndex]);
                new Uint16Array(this.data, 2, 1)[0] = nodeSize;
                new Uint32Array(this.data, 4, 1)[0] = numItems;
            }
            // a priority queue for k-nearest-neighbors queries
            this._queue = new FlatQueue();
        };
        Flatbush.from = function from(data) {
            if (!(data instanceof ArrayBuffer)) {
                throw new Error('Data must be an instance of ArrayBuffer.');
            }
            var ref = new Uint8Array(data, 0, 2);
            var magic = ref[0];
            var versionAndType = ref[1];
            if (magic !== 0xfb) {
                throw new Error('Data does not appear to be in a Flatbush format.');
            }
            if (versionAndType >> 4 !== VERSION) {
                throw new Error(("Got v" + (versionAndType >> 4) + " data when expected v" + VERSION + "."));
            }
            var ref$1 = new Uint16Array(data, 2, 1);
            var nodeSize = ref$1[0];
            var ref$2 = new Uint32Array(data, 4, 1);
            var numItems = ref$2[0];
            return new Flatbush(numItems, nodeSize, ARRAY_TYPES[versionAndType & 0x0f], data);
        };
        Flatbush.prototype.add = function add(minX, minY, maxX, maxY) {
            var index = this._pos >> 2;
            this._indices[index] = index;
            this._boxes[this._pos++] = minX;
            this._boxes[this._pos++] = minY;
            this._boxes[this._pos++] = maxX;
            this._boxes[this._pos++] = maxY;
            if (minX < this.minX) {
                this.minX = minX;
            }
            if (minY < this.minY) {
                this.minY = minY;
            }
            if (maxX > this.maxX) {
                this.maxX = maxX;
            }
            if (maxY > this.maxY) {
                this.maxY = maxY;
            }
        };
        Flatbush.prototype.finish = function finish() {
            if (this._pos >> 2 !== this.numItems) {
                throw new Error(("Added " + (this._pos >> 2) + " items when expected " + (this.numItems) + "."));
            }
            var width = this.maxX - this.minX;
            var height = this.maxY - this.minY;
            var hilbertValues = new Uint32Array(this.numItems);
            var hilbertMax = (1 << 16) - 1;
            // map item centers into Hilbert coordinate space and calculate Hilbert values
            for (var i = 0; i < this.numItems; i++) {
                var pos = 4 * i;
                var minX = this._boxes[pos++];
                var minY = this._boxes[pos++];
                var maxX = this._boxes[pos++];
                var maxY = this._boxes[pos++];
                var x = Math.floor(hilbertMax * ((minX + maxX) / 2 - this.minX) / width);
                var y = Math.floor(hilbertMax * ((minY + maxY) / 2 - this.minY) / height);
                hilbertValues[i] = hilbert(x, y);
            }
            // sort items by their Hilbert value (for packing later)
            sort(hilbertValues, this._boxes, this._indices, 0, this.numItems - 1);
            // generate nodes at each tree level, bottom-up
            for (var i$1 = 0, pos$1 = 0; i$1 < this._levelBounds.length - 1; i$1++) {
                var end = this._levelBounds[i$1];
                // generate a parent node for each block of consecutive <nodeSize> nodes
                while (pos$1 < end) {
                    var nodeMinX = Infinity;
                    var nodeMinY = Infinity;
                    var nodeMaxX = -Infinity;
                    var nodeMaxY = -Infinity;
                    var nodeIndex = pos$1;
                    // calculate bbox for the new node
                    for (var i$2 = 0; i$2 < this.nodeSize && pos$1 < end; i$2++) {
                        var minX$1 = this._boxes[pos$1++];
                        var minY$1 = this._boxes[pos$1++];
                        var maxX$1 = this._boxes[pos$1++];
                        var maxY$1 = this._boxes[pos$1++];
                        if (minX$1 < nodeMinX) {
                            nodeMinX = minX$1;
                        }
                        if (minY$1 < nodeMinY) {
                            nodeMinY = minY$1;
                        }
                        if (maxX$1 > nodeMaxX) {
                            nodeMaxX = maxX$1;
                        }
                        if (maxY$1 > nodeMaxY) {
                            nodeMaxY = maxY$1;
                        }
                    }
                    // add the new node to the tree data
                    this._indices[this._pos >> 2] = nodeIndex;
                    this._boxes[this._pos++] = nodeMinX;
                    this._boxes[this._pos++] = nodeMinY;
                    this._boxes[this._pos++] = nodeMaxX;
                    this._boxes[this._pos++] = nodeMaxY;
                }
            }
        };
        Flatbush.prototype.search = function search(minX, minY, maxX, maxY, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            var nodeIndex = this._boxes.length - 4;
            var level = this._levelBounds.length - 1;
            var queue = [];
            var results = [];
            while (nodeIndex !== undefined) {
                // find the end index of the node
                var end = Math.min(nodeIndex + this.nodeSize * 4, this._levelBounds[level]);
                // search through child nodes
                for (var pos = nodeIndex; pos < end; pos += 4) {
                    var index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos]) {
                        continue;
                    } // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1]) {
                        continue;
                    } // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2]) {
                        continue;
                    } // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3]) {
                        continue;
                    } // minY > nodeMaxY
                    if (nodeIndex < this.numItems * 4) {
                        if (filterFn === undefined || filterFn(index)) {
                            results.push(index); // leaf item
                        }
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                        queue.push(level - 1);
                    }
                }
                level = queue.pop();
                nodeIndex = queue.pop();
            }
            return results;
        };
        Flatbush.prototype.neighbors = function neighbors(x, y, maxResults, maxDistance, filterFn) {
            if (maxResults === void 0)
                maxResults = Infinity;
            if (maxDistance === void 0)
                maxDistance = Infinity;
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            var nodeIndex = this._boxes.length - 4;
            var q = this._queue;
            var results = [];
            var maxDistSquared = maxDistance * maxDistance;
            while (nodeIndex !== undefined) {
                // find the end index of the node
                var end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // add child nodes to the queue
                for (var pos = nodeIndex; pos < end; pos += 4) {
                    var index = this._indices[pos >> 2] | 0;
                    var dx = axisDist(x, this._boxes[pos], this._boxes[pos + 2]);
                    var dy = axisDist(y, this._boxes[pos + 1], this._boxes[pos + 3]);
                    var dist = dx * dx + dy * dy;
                    if (nodeIndex < this.numItems * 4) { // leaf node
                        if (filterFn === undefined || filterFn(index)) {
                            // put a negative index if it's an item rather than a node, to recognize later
                            q.push(-index - 1, dist);
                        }
                    }
                    else {
                        q.push(index, dist);
                    }
                }
                // pop items from the queue
                while (q.length && q.peek() < 0) {
                    var dist$1 = q.peekValue();
                    if (dist$1 > maxDistSquared) {
                        q.clear();
                        return results;
                    }
                    results.push(-q.pop() - 1);
                    if (results.length === maxResults) {
                        q.clear();
                        return results;
                    }
                }
                nodeIndex = q.pop();
            }
            q.clear();
            return results;
        };
        function axisDist(k, min, max) {
            return k < min ? min - k : k <= max ? 0 : k - max;
        }
        // binary search for the first value in the array bigger than the given
        function upperBound(value, arr) {
            var i = 0;
            var j = arr.length - 1;
            while (i < j) {
                var m = (i + j) >> 1;
                if (arr[m] > value) {
                    j = m;
                }
                else {
                    i = m + 1;
                }
            }
            return arr[i];
        }
        // custom quicksort that sorts bbox data alongside the hilbert values
        function sort(values, boxes, indices, left, right) {
            if (left >= right) {
                return;
            }
            var pivot = values[(left + right) >> 1];
            var i = left - 1;
            var j = right + 1;
            while (true) {
                do {
                    i++;
                } while (values[i] < pivot);
                do {
                    j--;
                } while (values[j] > pivot);
                if (i >= j) {
                    break;
                }
                swap(values, boxes, indices, i, j);
            }
            sort(values, boxes, indices, left, j);
            sort(values, boxes, indices, j + 1, right);
        }
        // swap two values and two corresponding boxes
        function swap(values, boxes, indices, i, j) {
            var temp = values[i];
            values[i] = values[j];
            values[j] = temp;
            var k = 4 * i;
            var m = 4 * j;
            var a = boxes[k];
            var b = boxes[k + 1];
            var c = boxes[k + 2];
            var d = boxes[k + 3];
            boxes[k] = boxes[m];
            boxes[k + 1] = boxes[m + 1];
            boxes[k + 2] = boxes[m + 2];
            boxes[k + 3] = boxes[m + 3];
            boxes[m] = a;
            boxes[m + 1] = b;
            boxes[m + 2] = c;
            boxes[m + 3] = d;
            var e = indices[i];
            indices[i] = indices[j];
            indices[j] = e;
        }
        // Fast Hilbert curve algorithm by http://threadlocalmutex.com/
        // Ported from C++ https://github.com/rawrunprotected/hilbert_curves (public domain)
        function hilbert(x, y) {
            var a = x ^ y;
            var b = 0xFFFF ^ a;
            var c = 0xFFFF ^ (x | y);
            var d = x & (y ^ 0xFFFF);
            var A = a | (b >> 1);
            var B = (a >> 1) ^ a;
            var C = ((c >> 1) ^ (b & (d >> 1))) ^ c;
            var D = ((a & (c >> 1)) ^ (d >> 1)) ^ d;
            a = A;
            b = B;
            c = C;
            d = D;
            A = ((a & (a >> 2)) ^ (b & (b >> 2)));
            B = ((a & (b >> 2)) ^ (b & ((a ^ b) >> 2)));
            C ^= ((a & (c >> 2)) ^ (b & (d >> 2)));
            D ^= ((b & (c >> 2)) ^ ((a ^ b) & (d >> 2)));
            a = A;
            b = B;
            c = C;
            d = D;
            A = ((a & (a >> 4)) ^ (b & (b >> 4)));
            B = ((a & (b >> 4)) ^ (b & ((a ^ b) >> 4)));
            C ^= ((a & (c >> 4)) ^ (b & (d >> 4)));
            D ^= ((b & (c >> 4)) ^ ((a ^ b) & (d >> 4)));
            a = A;
            b = B;
            c = C;
            d = D;
            C ^= ((a & (c >> 8)) ^ (b & (d >> 8)));
            D ^= ((b & (c >> 8)) ^ ((a ^ b) & (d >> 8)));
            a = C ^ (C >> 1);
            b = D ^ (D >> 1);
            var i0 = x ^ y;
            var i1 = b | (0xFFFF ^ (i0 | a));
            i0 = (i0 | (i0 << 8)) & 0x00FF00FF;
            i0 = (i0 | (i0 << 4)) & 0x0F0F0F0F;
            i0 = (i0 | (i0 << 2)) & 0x33333333;
            i0 = (i0 | (i0 << 1)) & 0x55555555;
            i1 = (i1 | (i1 << 8)) & 0x00FF00FF;
            i1 = (i1 | (i1 << 4)) & 0x0F0F0F0F;
            i1 = (i1 | (i1 << 2)) & 0x33333333;
            i1 = (i1 | (i1 << 1)) & 0x55555555;
            return ((i1 << 1) | i0) >>> 0;
        }
        return Flatbush;
    }));
},
/* core/util/bbox.js */ function _(require, module, exports) {
    var min = Math.min, max = Math.max;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            x0: Number.MIN_VALUE,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            x0: -Infinity,
            y0: Number.MIN_VALUE,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            x0: min(a.x0, b.x0),
            x1: max(a.x1, b.x1),
            y0: min(a.y0, b.y0),
            y1: max(a.y1, b.y1),
        };
    }
    exports.union = union;
    var BBox = /** @class */ (function () {
        function BBox(box) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ('x0' in box) {
                var x0 = box.x0, y0 = box.y0, x1 = box.x1, y1 = box.y1;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error("invalid bbox {x0: " + x0 + ", y0: " + y0 + ", x1: " + x1 + ", y1: " + y1 + "}");
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else if ("x" in box) {
                var x = box.x, y = box.y, width = box.width, height = box.height;
                if (!(width >= 0 && height >= 0))
                    throw new Error("invalid bbox {x: " + x + ", y: " + y + ", width: " + width + ", height: " + height + "}");
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
            else {
                var left = void 0, right = void 0;
                var top = void 0, bottom = void 0;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        var w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        var h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (!(left <= right && top <= bottom))
                    throw new Error("invalid bbox {left: " + left + ", top: " + top + ", right: " + right + ", bottom: " + bottom + "}");
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        BBox.prototype.toString = function () {
            return "BBox({left: " + this.left + ", top: " + this.top + ", width: " + this.width + ", height: " + this.height + "})";
        };
        Object.defineProperty(BBox.prototype, "left", {
            get: function () { return this.x0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "top", {
            get: function () { return this.y0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "right", {
            get: function () { return this.x1; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "bottom", {
            get: function () { return this.y1; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "p0", {
            get: function () { return [this.x0, this.y0]; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "p1", {
            get: function () { return [this.x1, this.y1]; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "x", {
            get: function () { return this.x0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "y", {
            get: function () { return this.y0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "width", {
            get: function () { return this.x1 - this.x0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "height", {
            get: function () { return this.y1 - this.y0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "rect", {
            get: function () { return { x0: this.x0, y0: this.y0, x1: this.x1, y1: this.y1 }; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "box", {
            get: function () { return { x: this.x, y: this.y, width: this.width, height: this.height }; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "h_range", {
            get: function () { return { start: this.x0, end: this.x1 }; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "v_range", {
            get: function () { return { start: this.y0, end: this.y1 }; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "ranges", {
            get: function () { return [this.h_range, this.v_range]; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "aspect", {
            get: function () { return this.width / this.height; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "hcenter", {
            get: function () { return (this.left + this.right) / 2; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "vcenter", {
            get: function () { return (this.top + this.bottom) / 2; },
            enumerable: true,
            configurable: true
        });
        BBox.prototype.contains = function (x, y) {
            return x >= this.x0 && x <= this.x1 && y >= this.y0 && y <= this.y1;
        };
        BBox.prototype.clip = function (x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [x, y];
        };
        BBox.prototype.union = function (that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        };
        BBox.prototype.equals = function (that) {
            return this.x0 == that.x0 && this.y0 == that.y0 && this.x1 == that.x1 && this.y1 == that.y1;
        };
        Object.defineProperty(BBox.prototype, "xview", {
            get: function () {
                var _this = this;
                return {
                    compute: function (x) {
                        return _this.left + x;
                    },
                    v_compute: function (xx) {
                        var _xx = new Float64Array(xx.length);
                        var left = _this.left;
                        for (var i = 0; i < xx.length; i++) {
                            _xx[i] = left + xx[i];
                        }
                        return _xx;
                    },
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "yview", {
            get: function () {
                var _this = this;
                return {
                    compute: function (y) {
                        return _this.bottom - y;
                    },
                    v_compute: function (yy) {
                        var _yy = new Float64Array(yy.length);
                        var bottom = _this.bottom;
                        for (var i = 0; i < yy.length; i++) {
                            _yy[i] = bottom - yy[i];
                        }
                        return _yy;
                    },
                };
            },
            enumerable: true,
            configurable: true
        });
        return BBox;
    }());
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* models/glyphs/glyph.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var hittest = require(183) /* ../../core/hittest */;
    var p = require(121) /* ../../core/properties */;
    var bbox = require(181) /* ../../core/util/bbox */;
    var proj = require(132) /* ../../core/util/projections */;
    var visuals = require(165) /* ../../core/visuals */;
    var view_1 = require(162) /* ../../core/view */;
    var model_1 = require(166) /* ../../model */;
    var logging_1 = require(167) /* ../../core/logging */;
    var arrayable_1 = require(114) /* ../../core/util/arrayable */;
    var object_1 = require(125) /* ../../core/util/object */;
    var types_1 = require(109) /* ../../core/util/types */;
    var line_1 = require(177) /* ./line */;
    var factor_range_1 = require(184) /* ../ranges/factor_range */;
    var GlyphView = /** @class */ (function (_super) {
        tslib_1.__extends(GlyphView, _super);
        function GlyphView() {
            var _this = _super.apply(this, arguments) || this;
            _this._nohit_warned = {};
            return _this;
        }
        Object.defineProperty(GlyphView.prototype, "renderer", {
            get: function () {
                return this.parent;
            },
            enumerable: true,
            configurable: true
        });
        GlyphView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._nohit_warned = {};
            this.visuals = new visuals.Visuals(this.model);
            // Init gl (this should really be done anytime renderer is set,
            // and not done if it isn't ever set, but for now it only
            // matters in the unit tests because we build a view without a
            // renderer there)
            var gl = this.renderer.plot_view.gl;
            if (gl != null) {
                var webgl_module = null;
                try {
                    webgl_module = require(454) /* ./webgl/index */;
                }
                catch (e) {
                    if (e.code === 'MODULE_NOT_FOUND') {
                        logging_1.logger.warn('WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.');
                    }
                    else
                        throw e;
                }
                if (webgl_module != null) {
                    var Cls = webgl_module[this.model.type + 'GLGlyph'];
                    if (Cls != null)
                        this.glglyph = new Cls(gl.ctx, this);
                }
            }
        };
        GlyphView.prototype.set_visuals = function (source) {
            this.visuals.warm_cache(source);
            if (this.glglyph != null)
                this.glglyph.set_visuals_changed();
        };
        GlyphView.prototype.render = function (ctx, indices, data) {
            ctx.beginPath();
            if (this.glglyph != null) {
                if (this.glglyph.render(ctx, indices, data))
                    return;
            }
            this._render(ctx, indices, data);
        };
        GlyphView.prototype.has_finished = function () {
            return true;
        };
        GlyphView.prototype.notify_finished = function () {
            this.renderer.notify_finished();
        };
        GlyphView.prototype._bounds = function (bounds) {
            return bounds;
        };
        GlyphView.prototype.bounds = function () {
            return this._bounds(this.index.bbox);
        };
        GlyphView.prototype.log_bounds = function () {
            var bb = bbox.empty();
            var positive_x_bbs = this.index.search(bbox.positive_x());
            for (var _i = 0, positive_x_bbs_1 = positive_x_bbs; _i < positive_x_bbs_1.length; _i++) {
                var x = positive_x_bbs_1[_i];
                if (x.x0 < bb.x0)
                    bb.x0 = x.x0;
                if (x.x1 > bb.x1)
                    bb.x1 = x.x1;
            }
            var positive_y_bbs = this.index.search(bbox.positive_y());
            for (var _a = 0, positive_y_bbs_1 = positive_y_bbs; _a < positive_y_bbs_1.length; _a++) {
                var y = positive_y_bbs_1[_a];
                if (y.y0 < bb.y0)
                    bb.y0 = y.y0;
                if (y.y1 > bb.y1)
                    bb.y1 = y.y1;
            }
            return this._bounds(bb);
        };
        GlyphView.prototype.get_anchor_point = function (anchor, i, _a) {
            var sx = _a[0], sy = _a[1];
            switch (anchor) {
                case "center": return { x: this.scenterx(i, sx, sy), y: this.scentery(i, sx, sy) };
                default: return null;
            }
        };
        GlyphView.prototype.sdist = function (scale, pts, spans, pts_location, dilate) {
            if (pts_location === void 0) {
                pts_location = "edge";
            }
            if (dilate === void 0) {
                dilate = false;
            }
            var pt0;
            var pt1;
            var n = pts.length;
            if (pts_location == 'center') {
                var halfspan = arrayable_1.map(spans, function (d) { return d / 2; });
                pt0 = new Float64Array(n);
                for (var i = 0; i < n; i++) {
                    pt0[i] = pts[i] - halfspan[i];
                }
                pt1 = new Float64Array(n);
                for (var i = 0; i < n; i++) {
                    pt1[i] = pts[i] + halfspan[i];
                }
            }
            else {
                pt0 = pts;
                pt1 = new Float64Array(n);
                for (var i = 0; i < n; i++) {
                    pt1[i] = pt0[i] + spans[i];
                }
            }
            var spt0 = scale.v_compute(pt0);
            var spt1 = scale.v_compute(pt1);
            if (dilate)
                return arrayable_1.map(spt0, function (_, i) { return Math.ceil(Math.abs(spt1[i] - spt0[i])); });
            else
                return arrayable_1.map(spt0, function (_, i) { return Math.abs(spt1[i] - spt0[i]); });
        };
        GlyphView.prototype.draw_legend_for_index = function (_ctx, _bbox, _index) { };
        GlyphView.prototype.hit_test = function (geometry) {
            var result = null;
            var func = "_hit_" + geometry.type;
            if (this[func] != null) {
                result = this[func](geometry);
            }
            else if (this._nohit_warned[geometry.type] == null) {
                logging_1.logger.debug("'" + geometry.type + "' selection not available for " + this.model.type);
                this._nohit_warned[geometry.type] = true;
            }
            return result;
        };
        GlyphView.prototype._hit_rect_against_index = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var result = hittest.create_empty_hit_test_result();
            result.indices = this.index.indices({ x0: x0, x1: x1, y0: y0, y1: y1 });
            return result;
        };
        GlyphView.prototype.set_data = function (source, indices, indices_to_update) {
            var _a, _b, _c, _d;
            var data = this.model.materialize_dataspecs(source);
            this.visuals.set_all_indices(indices);
            if (indices && !(this instanceof line_1.LineView)) {
                var data_subset = {};
                var _loop_1 = function (k) {
                    var v = data[k];
                    if (k.charAt(0) === '_')
                        data_subset[k] = indices.map(function (i) { return v[i]; });
                    else
                        data_subset[k] = v;
                };
                for (var k in data) {
                    _loop_1(k);
                }
                data = data_subset;
            }
            var self = this;
            object_1.extend(self, data);
            // TODO (bev) Should really probably delegate computing projected
            // coordinates to glyphs, instead of centralizing here in one place.
            if (this.renderer.plot_view.model.use_map) {
                if (self._x != null)
                    _a = proj.project_xy(self._x, self._y), self._x = _a[0], self._y = _a[1];
                if (self._xs != null)
                    _b = proj.project_xsys(self._xs, self._ys), self._xs = _b[0], self._ys = _b[1];
                if (self._x0 != null)
                    _c = proj.project_xy(self._x0, self._y0), self._x0 = _c[0], self._y0 = _c[1];
                if (self._x1 != null)
                    _d = proj.project_xy(self._x1, self._y1), self._x1 = _d[0], self._y1 = _d[1];
            }
            // if we have any coordinates that are categorical, convert them to
            // synthetic coords here
            if (this.renderer.plot_view.frame.x_ranges != null) { // XXXX JUST TEMP FOR TESTS TO PASS
                var xr_1 = this.renderer.plot_view.frame.x_ranges[this.model.x_range_name];
                var yr_1 = this.renderer.plot_view.frame.y_ranges[this.model.y_range_name];
                for (var _i = 0, _e = this.model._coords; _i < _e.length; _i++) {
                    var _f = _e[_i], xname = _f[0], yname = _f[1];
                    xname = "_" + xname;
                    yname = "_" + yname;
                    // TODO (bev) more robust detection of multi-glyph case
                    // hand multi glyph case
                    if (self._xs != null) {
                        if (xr_1 instanceof factor_range_1.FactorRange) {
                            self[xname] = arrayable_1.map(self[xname], function (arr) { return xr_1.v_synthetic(arr); });
                        }
                        if (yr_1 instanceof factor_range_1.FactorRange) {
                            self[yname] = arrayable_1.map(self[yname], function (arr) { return yr_1.v_synthetic(arr); });
                        }
                    }
                    else {
                        // hand standard glyph case
                        if (xr_1 instanceof factor_range_1.FactorRange) {
                            self[xname] = xr_1.v_synthetic(self[xname]);
                        }
                        if (yr_1 instanceof factor_range_1.FactorRange) {
                            self[yname] = yr_1.v_synthetic(self[yname]);
                        }
                    }
                }
            }
            if (this.glglyph != null)
                this.glglyph.set_data_changed(self._x.length);
            this._set_data(indices_to_update); //TODO doesn't take subset indices into account
            this.index_data();
        };
        GlyphView.prototype._set_data = function (_indices) { };
        GlyphView.prototype.index_data = function () {
            this.index = this._index_data();
        };
        GlyphView.prototype.mask_data = function (indices) {
            // WebGL can do the clipping much more efficiently
            if (this.glglyph != null || this._mask_data == null)
                return indices;
            else
                return this._mask_data();
        };
        GlyphView.prototype.map_data = function () {
            var _a;
            // TODO: if using gl, skip this (when is this called?)
            // map all the coordinate fields
            var self = this;
            for (var _i = 0, _b = this.model._coords; _i < _b.length; _i++) {
                var _c = _b[_i], xname = _c[0], yname = _c[1];
                var sxname = "s" + xname;
                var syname = "s" + yname;
                xname = "_" + xname;
                yname = "_" + yname;
                if (self[xname] != null && (types_1.isArray(self[xname][0]) || types_1.isTypedArray(self[xname][0]))) {
                    var n = self[xname].length;
                    self[sxname] = new Array(n);
                    self[syname] = new Array(n);
                    for (var i = 0; i < n; i++) {
                        var _d = this.map_to_screen(self[xname][i], self[yname][i]), sx = _d[0], sy = _d[1];
                        self[sxname][i] = sx;
                        self[syname][i] = sy;
                    }
                }
                else
                    _a = this.map_to_screen(self[xname], self[yname]), self[sxname] = _a[0], self[syname] = _a[1];
            }
            this._map_data();
        };
        // This is where specs not included in coords are computed, e.g. radius.
        GlyphView.prototype._map_data = function () { };
        GlyphView.prototype.map_to_screen = function (x, y) {
            return this.renderer.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
        };
        return GlyphView;
    }(view_1.View));
    exports.GlyphView = GlyphView;
    GlyphView.__name__ = "GlyphView";
    var Glyph = /** @class */ (function (_super) {
        tslib_1.__extends(Glyph, _super);
        function Glyph(attrs) {
            return _super.call(this, attrs) || this;
        }
        Glyph.init_Glyph = function () {
            this.prototype._coords = [];
            this.internal({
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
        };
        Glyph.coords = function (coords) {
            var _coords = this.prototype._coords.concat(coords);
            this.prototype._coords = _coords;
            var result = {};
            for (var _i = 0, coords_1 = coords; _i < coords_1.length; _i++) {
                var _a = coords_1[_i], x = _a[0], y = _a[1];
                result[x] = [p.CoordinateSpec];
                result[y] = [p.CoordinateSpec];
            }
            this.define(result);
        };
        return Glyph;
    }(model_1.Model));
    exports.Glyph = Glyph;
    Glyph.__name__ = "Glyph";
    Glyph.init_Glyph();
},
/* core/hittest.js */ function _(require, module, exports) {
    var array_1 = require(110) /* ./util/array */;
    var selection_1 = require(173) /* ../models/selections/selection */;
    function point_in_poly(x, y, px, py) {
        var inside = false;
        var x1 = px[px.length - 1];
        var y1 = py[py.length - 1];
        for (var i = 0; i < px.length; i++) {
            var x2 = px[i];
            var y2 = py[i];
            if ((y1 < y) != (y2 < y)) {
                if (x1 + (y - y1) / (y2 - y1) * (x2 - x1) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    function point_in_ellipse(x, y, angle, b, a, x0, y0) {
        var A = (Math.pow((Math.cos(angle) / a), 2) + Math.pow((Math.sin(angle) / b), 2));
        var B = 2 * Math.cos(angle) * Math.sin(angle) * (Math.pow((1 / a), 2) - Math.pow((1 / b), 2));
        var C = (Math.pow((Math.cos(angle) / b), 2) + Math.pow((Math.sin(angle) / a), 2));
        var eqn = A * Math.pow((x - x0), 2) + B * (x - x0) * (y - y0) + C * Math.pow((y - y0), 2);
        var inside = eqn <= 1;
        return inside;
    }
    exports.point_in_ellipse = point_in_ellipse;
    function create_empty_hit_test_result() {
        return new selection_1.Selection();
    }
    exports.create_empty_hit_test_result = create_empty_hit_test_result;
    function create_hit_test_result_from_hits(hits) {
        var result = new selection_1.Selection();
        result.indices = array_1.sort_by(hits, function (_a) {
            var _i = _a[0], dist = _a[1];
            return dist;
        }).map(function (_a) {
            var i = _a[0], _dist = _a[1];
            return i;
        });
        return result;
    }
    exports.create_hit_test_result_from_hits = create_hit_test_result_from_hits;
    function sqr(x) {
        return x * x;
    }
    function dist_2_pts(p0, p1) {
        return sqr(p0.x - p1.x) + sqr(p0.y - p1.y);
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        var l2 = dist_2_pts(v, w);
        if (l2 == 0)
            return dist_2_pts(p, v);
        var t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p, v);
        if (t > 1)
            return dist_2_pts(p, w);
        var q = { x: v.x + t * (w.x - v.x), y: v.y + t * (w.y - v.y) };
        return dist_2_pts(p, q);
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
         *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
         *  the following attributes:
         *   * hit (boolean): whether the 2 segments intersect
         *   * x (float): x coordinate of the intersection point
         *   * y (float): y coordinate of the intersection point
         */
        var den = ((l1_y1 - l1_y0) * (l0_x1 - l0_x0)) - ((l1_x1 - l1_x0) * (l0_y1 - l0_y0));
        if (den == 0) {
            return { hit: false, x: null, y: null };
        }
        else {
            var a = l0_y0 - l1_y0;
            var b = l0_x0 - l1_x0;
            var num1 = ((l1_x1 - l1_x0) * a) - ((l1_y1 - l1_y0) * b);
            var num2 = ((l0_x1 - l0_x0) * a) - ((l0_y1 - l0_y0) * b);
            a = num1 / den;
            b = num2 / den;
            var x = l0_x0 + (a * (l0_x1 - l0_x0));
            var y = l0_y0 + (a * (l0_y1 - l0_y0));
            return { hit: (a > 0 && a < 1) && (b > 0 && b < 1), x: x, y: y };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;
},
/* models/ranges/factor_range.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var range_1 = require(185) /* ./range */;
    var p = require(121) /* ../../core/properties */;
    var arrayable_1 = require(114) /* ../../core/util/arrayable */;
    var array_1 = require(110) /* ../../core/util/array */;
    var types_1 = require(109) /* ../../core/util/types */;
    function map_one_level(factors, padding, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        for (var i = 0; i < factors.length; i++) {
            var factor = factors[i];
            if (factor in mapping)
                throw new Error("duplicate factor or subfactor: " + factor);
            else
                mapping[factor] = { value: 0.5 + i * (1 + padding) + offset };
        }
        return [mapping, (factors.length - 1) * padding];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        var tops = {};
        var tops_order = [];
        for (var _i = 0, factors_1 = factors; _i < factors_1.length; _i++) {
            var _a = factors_1[_i], f0 = _a[0], f1 = _a[1];
            if (!(f0 in tops)) {
                tops[f0] = [];
                tops_order.push(f0);
            }
            tops[f0].push(f1);
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_1 = function (f0) {
            var n = tops[f0].length;
            var _a = map_one_level(tops[f0], factor_pad, suboffset), submap = _a[0], subpad = _a[1];
            total_subpad += subpad;
            var subtot = array_1.sum(tops[f0].map(function (f1) { return submap[f1].value; }));
            mapping[f0] = { value: subtot / n, mapping: submap };
            suboffset += n + outer_pad + subpad;
        };
        for (var _b = 0, tops_order_1 = tops_order; _b < tops_order_1.length; _b++) {
            var f0 = tops_order_1[_b];
            _loop_1(f0);
        }
        return [mapping, tops_order, (tops_order.length - 1) * outer_pad + total_subpad];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        var tops = {};
        var tops_order = [];
        for (var _i = 0, factors_2 = factors; _i < factors_2.length; _i++) {
            var _a = factors_2[_i], f0 = _a[0], f1 = _a[1], f2 = _a[2];
            if (!(f0 in tops)) {
                tops[f0] = [];
                tops_order.push(f0);
            }
            tops[f0].push([f1, f2]);
        }
        var mids_order = [];
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_2 = function (f0) {
            var n = tops[f0].length;
            var _a = map_two_levels(tops[f0], inner_pad, factor_pad, suboffset), submap = _a[0], submids_order = _a[1], subpad = _a[2];
            for (var _i = 0, submids_order_1 = submids_order; _i < submids_order_1.length; _i++) {
                var f1 = submids_order_1[_i];
                mids_order.push([f0, f1]);
            }
            total_subpad += subpad;
            var subtot = array_1.sum(tops[f0].map(function (_a) {
                var f1 = _a[0];
                return submap[f1].value;
            }));
            mapping[f0] = { value: subtot / n, mapping: submap };
            suboffset += n + outer_pad + subpad;
        };
        for (var _b = 0, tops_order_2 = tops_order; _b < tops_order_2.length; _b++) {
            var f0 = tops_order_2[_b];
            _loop_2(f0);
        }
        return [mapping, tops_order, mids_order, (tops_order.length - 1) * outer_pad + total_subpad];
    }
    exports.map_three_levels = map_three_levels;
    var FactorRange = /** @class */ (function (_super) {
        tslib_1.__extends(FactorRange, _super);
        function FactorRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        FactorRange.init_FactorRange = function () {
            this.define({
                factors: [p.Array, []],
                factor_padding: [p.Number, 0],
                subgroup_padding: [p.Number, 0.8],
                group_padding: [p.Number, 1.4],
                range_padding: [p.Number, 0],
                range_padding_units: [p.PaddingUnits, "percent"],
                start: [p.Number],
                end: [p.Number],
            });
            this.internal({
                levels: [p.Number],
                mids: [p.Array],
                tops: [p.Array],
                tops_groups: [p.Array],
            });
        };
        Object.defineProperty(FactorRange.prototype, "min", {
            get: function () {
                return this.start;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FactorRange.prototype, "max", {
            get: function () {
                return this.end;
            },
            enumerable: true,
            configurable: true
        });
        FactorRange.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._init(true);
        };
        FactorRange.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.factors.change, function () { return _this.reset(); });
            this.connect(this.properties.factor_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.group_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.subgroup_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.range_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.range_padding_units.change, function () { return _this.reset(); });
        };
        FactorRange.prototype.reset = function () {
            this._init(false);
            this.change.emit();
        };
        FactorRange.prototype._lookup = function (x) {
            if (x.length == 1) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0])) {
                    return NaN;
                }
                return m[x[0]].value;
            }
            else if (x.length == 2) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0]) || !m[x[0]].mapping.hasOwnProperty(x[1])) {
                    return NaN;
                }
                return m[x[0]].mapping[x[1]].value;
            }
            else if (x.length == 3) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0]) || !m[x[0]].mapping.hasOwnProperty(x[1]) || !m[x[0]].mapping[x[1]].mapping.hasOwnProperty(x[2])) {
                    return NaN;
                }
                return m[x[0]].mapping[x[1]].mapping[x[2]].value;
            }
            else
                throw new Error("unreachable code");
        };
        // convert a string factor into a synthetic coordinate
        FactorRange.prototype.synthetic = function (x) {
            if (types_1.isNumber(x))
                return x;
            if (types_1.isString(x))
                return this._lookup([x]);
            var offset = 0;
            var off = x[x.length - 1];
            if (types_1.isNumber(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        };
        // convert an array of string factors into synthetic coordinates
        FactorRange.prototype.v_synthetic = function (xs) {
            var _this = this;
            return arrayable_1.map(xs, function (x) { return _this.synthetic(x); });
        };
        FactorRange.prototype._init = function (silent) {
            var _a, _b, _c;
            var levels;
            var inside_padding;
            if (array_1.every(this.factors, types_1.isString)) {
                levels = 1;
                _a = map_one_level(this.factors, this.factor_padding), this._mapping = _a[0], inside_padding = _a[1];
            }
            else if (array_1.every(this.factors, function (x) { return types_1.isArray(x) && x.length == 2 && types_1.isString(x[0]) && types_1.isString(x[1]); })) {
                levels = 2;
                _b = map_two_levels(this.factors, this.group_padding, this.factor_padding), this._mapping = _b[0], this.tops = _b[1], inside_padding = _b[2];
            }
            else if (array_1.every(this.factors, function (x) { return types_1.isArray(x) && x.length == 3 && types_1.isString(x[0]) && types_1.isString(x[1]) && types_1.isString(x[2]); })) {
                levels = 3;
                _c = map_three_levels(this.factors, this.group_padding, this.subgroup_padding, this.factor_padding), this._mapping = _c[0], this.tops = _c[1], this.mids = _c[2], inside_padding = _c[3];
            }
            else
                throw new Error("???");
            var start = 0;
            var end = this.factors.length + inside_padding;
            if (this.range_padding_units == "percent") {
                var half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            }
            else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({ start: start, end: end, levels: levels }, { silent: silent });
            if (this.bounds == "auto")
                this.setv({ bounds: [start, end] }, { silent: true });
        };
        return FactorRange;
    }(range_1.Range));
    exports.FactorRange = FactorRange;
    FactorRange.__name__ = "FactorRange";
    FactorRange.init_FactorRange();
},
/* models/ranges/range.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var p = require(121) /* ../../core/properties */;
    var types_1 = require(109) /* ../../core/util/types */;
    var Range = /** @class */ (function (_super) {
        tslib_1.__extends(Range, _super);
        function Range(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.have_updated_interactively = false;
            return _this;
        }
        Range.init_Range = function () {
            this.define({
                callback: [p.Any],
                bounds: [p.Any],
                min_interval: [p.Any],
                max_interval: [p.Any],
            });
            this.internal({
                plots: [p.Array, []],
            });
        };
        Range.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () { return _this._emit_callback(); });
        };
        Range.prototype._emit_callback = function () {
            if (this.callback != null) {
                if (types_1.isFunction(this.callback))
                    this.callback(this);
                else
                    this.callback.execute(this, {});
            }
        };
        Object.defineProperty(Range.prototype, "is_reversed", {
            get: function () {
                return this.start > this.end;
            },
            enumerable: true,
            configurable: true
        });
        return Range;
    }(model_1.Model));
    exports.Range = Range;
    Range.__name__ = "Range";
    Range.init_Range();
},
/* models/glyphs/utils.js */ function _(require, module, exports) {
    var hittest = require(183) /* ../../core/hittest */;
    function generic_line_legend(visuals, ctx, _a, index) {
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        if (visuals.line.doit) {
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
        ctx.restore();
    }
    exports.generic_line_legend = generic_line_legend;
    function generic_area_legend(visuals, ctx, _a, index) {
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        var w = Math.abs(x1 - x0);
        var dw = w * 0.1;
        var h = Math.abs(y1 - y0);
        var dh = h * 0.1;
        var sx0 = x0 + dw;
        var sx1 = x1 - dw;
        var sy0 = y0 + dh;
        var sy1 = y1 - dh;
        if (visuals.fill.doit) {
            visuals.fill.set_vectorize(ctx, index);
            ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        }
        if (visuals.hatch != null && visuals.hatch.doit) {
            visuals.hatch.set_vectorize(ctx, index);
            ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        }
        if (visuals.line && visuals.line.doit) {
            ctx.beginPath();
            ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
    }
    exports.generic_area_legend = generic_area_legend;
    function line_interpolation(renderer, geometry, x2, y2, x3, y3) {
        var _a, _b, _c, _d, _e, _f;
        var sx = geometry.sx, sy = geometry.sy;
        var x0, x1;
        var y0, y1;
        if (geometry.type == 'point') {
            // The +/- adjustments here are to dilate the hit point into a virtual "segment" to use below
            _a = renderer.yscale.r_invert(sy - 1, sy + 1), y0 = _a[0], y1 = _a[1];
            _b = renderer.xscale.r_invert(sx - 1, sx + 1), x0 = _b[0], x1 = _b[1];
        }
        else {
            // The +/- adjustments here are to handle cases such as purely horizontal or vertical lines
            if (geometry.direction == 'v') {
                _c = renderer.yscale.r_invert(sy, sy), y0 = _c[0], y1 = _c[1];
                _d = [Math.min(x2 - 1, x3 - 1), Math.max(x2 + 1, x3 + 1)], x0 = _d[0], x1 = _d[1];
            }
            else {
                _e = renderer.xscale.r_invert(sx, sx), x0 = _e[0], x1 = _e[1];
                _f = [Math.min(y2 - 1, y3 - 1), Math.max(y2 + 1, y3 + 1)], y0 = _f[0], y1 = _f[1];
            }
        }
        var _g = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3), x = _g.x, y = _g.y;
        return [x, y]; // XXX: null is not handled at use sites
    }
    exports.line_interpolation = line_interpolation;
},
/* models/glyphs/patch.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var xy_glyph_1 = require(178) /* ./xy_glyph */;
    var utils_1 = require(186) /* ./utils */;
    var hittest = require(183) /* ../../core/hittest */;
    var PatchView = /** @class */ (function (_super) {
        tslib_1.__extends(PatchView, _super);
        function PatchView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchView.prototype._inner_loop = function (ctx, indices, sx, sy, func) {
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (i == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    continue;
                }
                else if (isNaN(sx[i] + sy[i])) {
                    ctx.closePath();
                    func.apply(ctx);
                    ctx.beginPath();
                    continue;
                }
                else
                    ctx.lineTo(sx[i], sy[i]);
            }
            ctx.closePath();
            func.call(ctx);
        };
        PatchView.prototype._render = function (ctx, indices, _a) {
            var _this = this;
            var sx = _a.sx, sy = _a.sy;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.fill);
            }
            this.visuals.hatch.doit2(ctx, 0, function () { return _this._inner_loop(ctx, indices, sx, sy, ctx.fill); }, function () { return _this.renderer.request_render(); });
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.stroke);
            }
        };
        PatchView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        PatchView.prototype._hit_point = function (geometry) {
            var _this = this;
            var result = hittest.create_empty_hit_test_result();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, this.sx, this.sy)) {
                result.add_to_selected_glyphs(this.model);
                result.get_view = function () { return _this; };
            }
            return result;
        };
        return PatchView;
    }(xy_glyph_1.XYGlyphView));
    exports.PatchView = PatchView;
    PatchView.__name__ = "PatchView";
    var Patch = /** @class */ (function (_super) {
        tslib_1.__extends(Patch, _super);
        function Patch(attrs) {
            return _super.call(this, attrs) || this;
        }
        Patch.init_Patch = function () {
            this.prototype.default_view = PatchView;
            this.mixins(['line', 'fill', 'hatch']);
        };
        return Patch;
    }(xy_glyph_1.XYGlyph));
    exports.Patch = Patch;
    Patch.__name__ = "Patch";
    Patch.init_Patch();
},
/* models/glyphs/harea.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var area_1 = require(189) /* ./area */;
    var spatial_1 = require(179) /* ../../core/util/spatial */;
    var hittest = require(183) /* ../../core/hittest */;
    var p = require(121) /* ../../core/properties */;
    var HAreaView = /** @class */ (function (_super) {
        tslib_1.__extends(HAreaView, _super);
        function HAreaView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HAreaView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x1.length; i < end; i++) {
                var x1 = this._x1[i];
                var x2 = this._x2[i];
                var y = this._y[i];
                if (isNaN(x1 + x2 + y) || !isFinite(x1 + x2 + y))
                    continue;
                points.push({ x0: Math.min(x1, x2), y0: y, x1: Math.max(x1, x2), y1: y, i: i });
            }
            return new spatial_1.SpatialIndex(points);
        };
        HAreaView.prototype._inner = function (ctx, sx1, sx2, sy, func) {
            ctx.beginPath();
            for (var i = 0, end = sx1.length; i < end; i++) {
                ctx.lineTo(sx1[i], sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var start = sx2.length - 1, i = start; i >= 0; i--) {
                ctx.lineTo(sx2[i], sy[i]);
            }
            ctx.closePath();
            func.call(ctx);
        };
        HAreaView.prototype._render = function (ctx, _indices, _a) {
            var _this = this;
            var sx1 = _a.sx1, sx2 = _a.sx2, sy = _a.sy;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner(ctx, sx1, sx2, sy, ctx.fill);
            }
            this.visuals.hatch.doit2(ctx, 0, function () { return _this._inner(ctx, sx1, sx2, sy, ctx.fill); }, function () { return _this.renderer.request_render(); });
        };
        HAreaView.prototype._hit_point = function (geometry) {
            var _this = this;
            var result = hittest.create_empty_hit_test_result();
            var L = this.sy.length;
            var sx = new Float64Array(2 * L);
            var sy = new Float64Array(2 * L);
            for (var i = 0, end = L; i < end; i++) {
                sx[i] = this.sx1[i];
                sy[i] = this.sy[i];
                sx[L + i] = this.sx2[L - i - 1];
                sy[L + i] = this.sy[L - i - 1];
            }
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.get_view = function () { return _this; };
            }
            return result;
        };
        HAreaView.prototype.scenterx = function (i) {
            return (this.sx1[i] + this.sx2[i]) / 2;
        };
        HAreaView.prototype.scentery = function (i) {
            return this.sy[i];
        };
        HAreaView.prototype._map_data = function () {
            this.sx1 = this.renderer.xscale.v_compute(this._x1);
            this.sx2 = this.renderer.xscale.v_compute(this._x2);
            this.sy = this.renderer.yscale.v_compute(this._y);
        };
        return HAreaView;
    }(area_1.AreaView));
    exports.HAreaView = HAreaView;
    HAreaView.__name__ = "HAreaView";
    var HArea = /** @class */ (function (_super) {
        tslib_1.__extends(HArea, _super);
        function HArea(attrs) {
            return _super.call(this, attrs) || this;
        }
        HArea.init_HArea = function () {
            this.prototype.default_view = HAreaView;
            this.define({
                x1: [p.CoordinateSpec],
                x2: [p.CoordinateSpec],
                y: [p.CoordinateSpec],
            });
        };
        return HArea;
    }(area_1.Area));
    exports.HArea = HArea;
    HArea.__name__ = "HArea";
    HArea.init_HArea();
},
/* models/glyphs/area.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var glyph_1 = require(182) /* ./glyph */;
    var utils_1 = require(186) /* ./utils */;
    var AreaView = /** @class */ (function (_super) {
        tslib_1.__extends(AreaView, _super);
        function AreaView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AreaView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        };
        return AreaView;
    }(glyph_1.GlyphView));
    exports.AreaView = AreaView;
    AreaView.__name__ = "AreaView";
    var Area = /** @class */ (function (_super) {
        tslib_1.__extends(Area, _super);
        function Area(attrs) {
            return _super.call(this, attrs) || this;
        }
        Area.init_Area = function () {
            this.mixins(['fill', 'hatch']);
        };
        return Area;
    }(glyph_1.Glyph));
    exports.Area = Area;
    Area.__name__ = "Area";
    Area.init_Area();
},
/* models/glyphs/varea.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var area_1 = require(189) /* ./area */;
    var spatial_1 = require(179) /* ../../core/util/spatial */;
    var hittest = require(183) /* ../../core/hittest */;
    var p = require(121) /* ../../core/properties */;
    var VAreaView = /** @class */ (function (_super) {
        tslib_1.__extends(VAreaView, _super);
        function VAreaView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VAreaView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x.length; i < end; i++) {
                var x = this._x[i];
                var y1 = this._y1[i];
                var y2 = this._y2[i];
                if (isNaN(x + y1 + y2) || !isFinite(x + y1 + y2))
                    continue;
                points.push({ x0: x, y0: Math.min(y1, y2), x1: x, y1: Math.max(y1, y2), i: i });
            }
            return new spatial_1.SpatialIndex(points);
        };
        VAreaView.prototype._inner = function (ctx, sx, sy1, sy2, func) {
            ctx.beginPath();
            for (var i = 0, end = sy1.length; i < end; i++) {
                ctx.lineTo(sx[i], sy1[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var start = sy2.length - 1, i = start; i >= 0; i--) {
                ctx.lineTo(sx[i], sy2[i]);
            }
            ctx.closePath();
            func.call(ctx);
        };
        VAreaView.prototype._render = function (ctx, _indices, _a) {
            var _this = this;
            var sx = _a.sx, sy1 = _a.sy1, sy2 = _a.sy2;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner(ctx, sx, sy1, sy2, ctx.fill);
            }
            this.visuals.hatch.doit2(ctx, 0, function () { return _this._inner(ctx, sx, sy1, sy2, ctx.fill); }, function () { return _this.renderer.request_render(); });
        };
        VAreaView.prototype.scenterx = function (i) {
            return this.sx[i];
        };
        VAreaView.prototype.scentery = function (i) {
            return (this.sy1[i] + this.sy2[i]) / 2;
        };
        VAreaView.prototype._hit_point = function (geometry) {
            var _this = this;
            var result = hittest.create_empty_hit_test_result();
            var L = this.sx.length;
            var sx = new Float64Array(2 * L);
            var sy = new Float64Array(2 * L);
            for (var i = 0, end = L; i < end; i++) {
                sx[i] = this.sx[i];
                sy[i] = this.sy1[i];
                sx[L + i] = this.sx[L - i - 1];
                sy[L + i] = this.sy2[L - i - 1];
            }
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.get_view = function () { return _this; };
            }
            return result;
        };
        VAreaView.prototype._map_data = function () {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.sy1 = this.renderer.yscale.v_compute(this._y1);
            this.sy2 = this.renderer.yscale.v_compute(this._y2);
        };
        return VAreaView;
    }(area_1.AreaView));
    exports.VAreaView = VAreaView;
    VAreaView.__name__ = "VAreaView";
    var VArea = /** @class */ (function (_super) {
        tslib_1.__extends(VArea, _super);
        function VArea(attrs) {
            return _super.call(this, attrs) || this;
        }
        VArea.init_VArea = function () {
            this.prototype.default_view = VAreaView;
            this.define({
                x: [p.CoordinateSpec],
                y1: [p.CoordinateSpec],
                y2: [p.CoordinateSpec],
            });
        };
        return VArea;
    }(area_1.Area));
    exports.VArea = VArea;
    VArea.__name__ = "VArea";
    VArea.init_VArea();
},
/* models/sources/cds_view.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var p = require(121) /* ../../core/properties */;
    var selection_1 = require(173) /* ../selections/selection */;
    var array_1 = require(110) /* ../../core/util/array */;
    var columnar_data_source_1 = require(171) /* ./columnar_data_source */;
    var CDSView = /** @class */ (function (_super) {
        tslib_1.__extends(CDSView, _super);
        function CDSView(attrs) {
            return _super.call(this, attrs) || this;
        }
        CDSView.init_CDSView = function () {
            this.define({
                filters: [p.Array, []],
                source: [p.Instance],
            });
            this.internal({
                indices: [p.Array, []],
                indices_map: [p.Any, {}],
            });
        };
        CDSView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.compute_indices();
        };
        CDSView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.filters.change, function () {
                _this.compute_indices();
                _this.change.emit();
            });
            var connect_listeners = function () {
                var fn = function () { return _this.compute_indices(); };
                if (_this.source != null) {
                    _this.connect(_this.source.change, fn);
                    if (_this.source instanceof columnar_data_source_1.ColumnarDataSource) {
                        _this.connect(_this.source.streaming, fn);
                        _this.connect(_this.source.patching, fn);
                    }
                }
            };
            var initialized = this.source != null;
            if (initialized)
                connect_listeners();
            else {
                this.connect(this.properties.source.change, function () {
                    if (!initialized) {
                        connect_listeners();
                        initialized = true;
                    }
                });
            }
        };
        CDSView.prototype.compute_indices = function () {
            var _this = this;
            var indices = this.filters
                .map(function (filter) { return filter.compute_indices(_this.source); })
                .filter(function (indices) { return indices != null; });
            if (indices.length > 0)
                this.indices = array_1.intersection.apply(this, indices);
            else if (this.source instanceof columnar_data_source_1.ColumnarDataSource)
                this.indices = this.source.get_indices();
            this.indices_map_to_subset();
        };
        CDSView.prototype.indices_map_to_subset = function () {
            this.indices_map = {};
            for (var i = 0; i < this.indices.length; i++) {
                this.indices_map[this.indices[i]] = i;
            }
        };
        CDSView.prototype.convert_selection_from_subset = function (selection_subset) {
            var _this = this;
            var selection_full = new selection_1.Selection();
            selection_full.update_through_union(selection_subset);
            var indices_1d = selection_subset.indices.map(function (i) { return _this.indices[i]; });
            selection_full.indices = indices_1d;
            selection_full.image_indices = selection_subset.image_indices;
            return selection_full;
        };
        CDSView.prototype.convert_selection_to_subset = function (selection_full) {
            var _this = this;
            var selection_subset = new selection_1.Selection();
            selection_subset.update_through_union(selection_full);
            var indices_1d = selection_full.indices.map(function (i) { return _this.indices_map[i]; });
            selection_subset.indices = indices_1d;
            selection_subset.image_indices = selection_full.image_indices;
            return selection_subset;
        };
        CDSView.prototype.convert_indices_from_subset = function (indices) {
            var _this = this;
            return indices.map(function (i) { return _this.indices[i]; });
        };
        return CDSView;
    }(model_1.Model));
    exports.CDSView = CDSView;
    CDSView.__name__ = "CDSView";
    CDSView.init_CDSView();
},
/* models/renderers/graph_renderer.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var data_renderer_1 = require(176) /* ./data_renderer */;
    var graph_hit_test_policy_1 = require(193) /* ../graphs/graph_hit_test_policy */;
    var p = require(121) /* ../../core/properties */;
    var build_views_1 = require(194) /* ../../core/build_views */;
    var GraphRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(GraphRendererView, _super);
        function GraphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GraphRendererView.prototype.initialize = function () {
            var _a;
            _super.prototype.initialize.call(this);
            this.xscale = this.plot_view.frame.xscales.default;
            this.yscale = this.plot_view.frame.yscales.default;
            this._renderer_views = {};
            _a = build_views_1.build_views(this._renderer_views, [
                this.model.node_renderer,
                this.model.edge_renderer,
            ], { parent: this.parent }), this.node_view = _a[0], this.edge_view = _a[1];
            this.set_data();
        };
        GraphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.layout_provider.change, function () { return _this.set_data(); });
            this.connect(this.model.node_renderer.data_source._select, function () { return _this.set_data(); });
            this.connect(this.model.node_renderer.data_source.inspect, function () { return _this.set_data(); });
            this.connect(this.model.node_renderer.data_source.change, function () { return _this.set_data(); });
            this.connect(this.model.edge_renderer.data_source._select, function () { return _this.set_data(); });
            this.connect(this.model.edge_renderer.data_source.inspect, function () { return _this.set_data(); });
            this.connect(this.model.edge_renderer.data_source.change, function () { return _this.set_data(); });
            var _a = this.plot_view.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name in x_ranges) {
                var rng = x_ranges[name];
                this.connect(rng.change, function () { return _this.set_data(); });
            }
            for (var name in y_ranges) {
                var rng = y_ranges[name];
                this.connect(rng.change, function () { return _this.set_data(); });
            }
        };
        GraphRendererView.prototype.set_data = function (request_render) {
            var _a, _b;
            if (request_render === void 0) {
                request_render = true;
            }
            // TODO (bev) this is a bit clunky, need to make sure glyphs use the correct ranges when they call
            // mapping functions on the base Renderer class
            this.node_view.glyph.model.setv({ x_range_name: this.model.x_range_name, y_range_name: this.model.y_range_name }, { silent: true });
            this.edge_view.glyph.model.setv({ x_range_name: this.model.x_range_name, y_range_name: this.model.y_range_name }, { silent: true });
            // XXX
            var node_glyph = this.node_view.glyph;
            _a = this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source), node_glyph._x = _a[0], node_glyph._y = _a[1];
            var edge_glyph = this.edge_view.glyph;
            _b = this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source), edge_glyph._xs = _b[0], edge_glyph._ys = _b[1];
            node_glyph.index_data();
            edge_glyph.index_data();
            if (request_render)
                this.request_render();
        };
        GraphRendererView.prototype.render = function () {
            this.edge_view.render();
            this.node_view.render();
        };
        return GraphRendererView;
    }(data_renderer_1.DataRendererView));
    exports.GraphRendererView = GraphRendererView;
    GraphRendererView.__name__ = "GraphRendererView";
    var GraphRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(GraphRenderer, _super);
        function GraphRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GraphRenderer.init_GraphRenderer = function () {
            this.prototype.default_view = GraphRendererView;
            this.define({
                layout_provider: [p.Instance],
                node_renderer: [p.Instance],
                edge_renderer: [p.Instance],
                selection_policy: [p.Instance, function () { return new graph_hit_test_policy_1.NodesOnly(); }],
                inspection_policy: [p.Instance, function () { return new graph_hit_test_policy_1.NodesOnly(); }],
            });
        };
        GraphRenderer.prototype.get_selection_manager = function () {
            return this.node_renderer.data_source.selection_manager;
        };
        return GraphRenderer;
    }(data_renderer_1.DataRenderer));
    exports.GraphRenderer = GraphRenderer;
    GraphRenderer.__name__ = "GraphRenderer";
    GraphRenderer.init_GraphRenderer();
},
/* models/graphs/graph_hit_test_policy.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var arrayable_1 = require(114) /* ../../core/util/arrayable */;
    var array_1 = require(110) /* ../../core/util/array */;
    var hittest_1 = require(183) /* ../../core/hittest */;
    var GraphHitTestPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(GraphHitTestPolicy, _super);
        function GraphHitTestPolicy(attrs) {
            return _super.call(this, attrs) || this;
        }
        GraphHitTestPolicy.prototype._hit_test_nodes = function (geometry, graph_view) {
            if (!graph_view.model.visible)
                return null;
            var hit_test_result = graph_view.node_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return graph_view.node_view.model.view.convert_selection_from_subset(hit_test_result);
        };
        GraphHitTestPolicy.prototype._hit_test_edges = function (geometry, graph_view) {
            if (!graph_view.model.visible)
                return null;
            var hit_test_result = graph_view.edge_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return graph_view.edge_view.model.view.convert_selection_from_subset(hit_test_result);
        };
        return GraphHitTestPolicy;
    }(model_1.Model));
    exports.GraphHitTestPolicy = GraphHitTestPolicy;
    GraphHitTestPolicy.__name__ = "GraphHitTestPolicy";
    var NodesOnly = /** @class */ (function (_super) {
        tslib_1.__extends(NodesOnly, _super);
        function NodesOnly(attrs) {
            return _super.call(this, attrs) || this;
        }
        NodesOnly.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test_nodes(geometry, graph_view);
        };
        NodesOnly.prototype.do_selection = function (hit_test_result, graph, final, append) {
            if (hit_test_result == null)
                return false;
            var node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, append);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        };
        NodesOnly.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, append) {
            if (hit_test_result == null)
                return false;
            var node_inspection = graph_view.model.get_selection_manager().get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view, { geometry: geometry }]);
            return !node_inspection.is_empty();
        };
        return NodesOnly;
    }(GraphHitTestPolicy));
    exports.NodesOnly = NodesOnly;
    NodesOnly.__name__ = "NodesOnly";
    var NodesAndLinkedEdges = /** @class */ (function (_super) {
        tslib_1.__extends(NodesAndLinkedEdges, _super);
        function NodesAndLinkedEdges(attrs) {
            return _super.call(this, attrs) || this;
        }
        NodesAndLinkedEdges.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test_nodes(geometry, graph_view);
        };
        NodesAndLinkedEdges.prototype.get_linked_edges = function (node_source, edge_source, mode) {
            var node_indices = [];
            if (mode == 'selection') {
                node_indices = node_source.selected.indices.map(function (i) { return node_source.data.index[i]; });
            }
            else if (mode == 'inspection') {
                node_indices = node_source.inspected.indices.map(function (i) { return node_source.data.index[i]; });
            }
            var edge_indices = [];
            for (var i = 0; i < edge_source.data.start.length; i++) {
                if (array_1.contains(node_indices, edge_source.data.start[i]) || array_1.contains(node_indices, edge_source.data.end[i]))
                    edge_indices.push(i);
            }
            var linked_edges = hittest_1.create_empty_hit_test_result();
            for (var _i = 0, edge_indices_1 = edge_indices; _i < edge_indices_1.length; _i++) {
                var i = edge_indices_1[_i];
                linked_edges.multiline_indices[i] = [0]; //currently only supports 2-element multilines, so this is all of it
            }
            linked_edges.indices = edge_indices;
            return linked_edges;
        };
        NodesAndLinkedEdges.prototype.do_selection = function (hit_test_result, graph, final, append) {
            if (hit_test_result == null)
                return false;
            var node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, append);
            var edge_selection = graph.edge_renderer.data_source.selected;
            var linked_edges_selection = this.get_linked_edges(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            edge_selection.update(linked_edges_selection, final, append);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        };
        NodesAndLinkedEdges.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, append) {
            if (hit_test_result == null)
                return false;
            var node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, append);
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            var edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            var linked_edges = this.get_linked_edges(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            edge_inspection.update(linked_edges, final, append);
            //silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view, { geometry: geometry }]);
            return !node_inspection.is_empty();
        };
        return NodesAndLinkedEdges;
    }(GraphHitTestPolicy));
    exports.NodesAndLinkedEdges = NodesAndLinkedEdges;
    NodesAndLinkedEdges.__name__ = "NodesAndLinkedEdges";
    var EdgesAndLinkedNodes = /** @class */ (function (_super) {
        tslib_1.__extends(EdgesAndLinkedNodes, _super);
        function EdgesAndLinkedNodes(attrs) {
            return _super.call(this, attrs) || this;
        }
        EdgesAndLinkedNodes.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test_edges(geometry, graph_view);
        };
        EdgesAndLinkedNodes.prototype.get_linked_nodes = function (node_source, edge_source, mode) {
            var edge_indices = [];
            if (mode == 'selection')
                edge_indices = edge_source.selected.indices;
            else if (mode == 'inspection')
                edge_indices = edge_source.inspected.indices;
            var nodes = [];
            for (var _i = 0, edge_indices_2 = edge_indices; _i < edge_indices_2.length; _i++) {
                var i = edge_indices_2[_i];
                nodes.push(edge_source.data.start[i]);
                nodes.push(edge_source.data.end[i]);
            }
            var node_indices = array_1.uniq(nodes).map(function (i) { return arrayable_1.indexOf(node_source.data.index, i); });
            var linked_nodes = hittest_1.create_empty_hit_test_result();
            linked_nodes.indices = node_indices;
            return linked_nodes;
        };
        EdgesAndLinkedNodes.prototype.do_selection = function (hit_test_result, graph, final, append) {
            if (hit_test_result == null)
                return false;
            var edge_selection = graph.edge_renderer.data_source.selected;
            edge_selection.update(hit_test_result, final, append);
            var node_selection = graph.node_renderer.data_source.selected;
            var linked_nodes = this.get_linked_nodes(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            node_selection.update(linked_nodes, final, append);
            graph.edge_renderer.data_source._select.emit();
            return !edge_selection.is_empty();
        };
        EdgesAndLinkedNodes.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, append) {
            if (hit_test_result == null)
                return false;
            var edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            edge_inspection.update(hit_test_result, final, append);
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            var node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            var linked_nodes = this.get_linked_nodes(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            node_inspection.update(linked_nodes, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.edge_view.model.data_source.inspect.emit([graph_view.edge_view, { geometry: geometry }]);
            return !edge_inspection.is_empty();
        };
        return EdgesAndLinkedNodes;
    }(GraphHitTestPolicy));
    exports.EdgesAndLinkedNodes = EdgesAndLinkedNodes;
    EdgesAndLinkedNodes.__name__ = "EdgesAndLinkedNodes";
},
/* core/build_views.js */ function _(require, module, exports) {
    var array_1 = require(110) /* ./util/array */;
    function build_views(view_storage, models, options, cls) {
        if (cls === void 0) {
            cls = function (model) { return model.default_view; };
        }
        var to_remove = array_1.difference(Object.keys(view_storage), models.map(function (model) { return model.id; }));
        for (var _i = 0, to_remove_1 = to_remove; _i < to_remove_1.length; _i++) {
            var model_id = to_remove_1[_i];
            view_storage[model_id].remove();
            delete view_storage[model_id];
        }
        var created_views = [];
        var new_models = models.filter(function (model) { return view_storage[model.id] == null; });
        for (var _a = 0, new_models_1 = new_models; _a < new_models_1.length; _a++) {
            var model = new_models_1[_a];
            var view_cls = cls(model);
            var view_options = Object.assign(Object.assign({}, options), { model: model, connect_signals: false });
            var view = new view_cls(view_options);
            view_storage[model.id] = view;
            created_views.push(view);
        }
        for (var _b = 0, created_views_1 = created_views; _b < created_views_1.length; _b++) {
            var view = created_views_1[_b];
            view.connect_signals();
        }
        return created_views;
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        for (var id in view_storage) {
            view_storage[id].remove();
            delete view_storage[id];
        }
    }
    exports.remove_views = remove_views;
},
/* models/selections/interaction_policy.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var SelectionPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(SelectionPolicy, _super);
        function SelectionPolicy() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SelectionPolicy.prototype.do_selection = function (hit_test_result, source, final, append) {
            if (hit_test_result === null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, append);
                source._select.emit();
                return !source.selected.is_empty();
            }
        };
        return SelectionPolicy;
    }(model_1.Model));
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    var IntersectRenderers = /** @class */ (function (_super) {
        tslib_1.__extends(IntersectRenderers, _super);
        function IntersectRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        IntersectRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var hit_test_result_renderers = [];
            for (var _i = 0, renderer_views_1 = renderer_views; _i < renderer_views_1.length; _i++) {
                var r = renderer_views_1[_i];
                var result = r.hit_test(geometry);
                if (result !== null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                for (var _a = 0, hit_test_result_renderers_1 = hit_test_result_renderers; _a < hit_test_result_renderers_1.length; _a++) {
                    var hit_test_result_other = hit_test_result_renderers_1[_a];
                    hit_test_result.update_through_intersection(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        };
        return IntersectRenderers;
    }(SelectionPolicy));
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    var UnionRenderers = /** @class */ (function (_super) {
        tslib_1.__extends(UnionRenderers, _super);
        function UnionRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnionRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var hit_test_result_renderers = [];
            for (var _i = 0, renderer_views_2 = renderer_views; _i < renderer_views_2.length; _i++) {
                var r = renderer_views_2[_i];
                var result = r.hit_test(geometry);
                if (result !== null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                for (var _a = 0, hit_test_result_renderers_2 = hit_test_result_renderers; _a < hit_test_result_renderers_2.length; _a++) {
                    var hit_test_result_other = hit_test_result_renderers_2[_a];
                    hit_test_result.update_through_union(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        };
        return UnionRenderers;
    }(SelectionPolicy));
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* core/util/serialization.js */ function _(require, module, exports) {
    var types_1 = require(109) /* ./types */;
    var compat_1 = require(197) /* ./compat */;
    exports.ARRAY_TYPES = {
        uint8: Uint8Array,
        int8: Int8Array,
        uint16: Uint16Array,
        int16: Int16Array,
        uint32: Uint32Array,
        int32: Int32Array,
        float32: Float32Array,
        float64: Float64Array,
    };
    exports.DTYPES = {
        Uint8Array: "uint8",
        Int8Array: "int8",
        Uint16Array: "uint16",
        Int16Array: "int16",
        Uint32Array: "uint32",
        Int32Array: "int32",
        Float32Array: "float32",
        Float64Array: "float64",
    };
    function arrayName(array) {
        if ("name" in array.constructor)
            return array.constructor.name;
        else {
            switch (true) {
                case array instanceof Uint8Array: return "Uint8Array";
                case array instanceof Int8Array: return "Int8Array";
                case array instanceof Uint16Array: return "Uint16Array";
                case array instanceof Int16Array: return "Int16Array";
                case array instanceof Uint32Array: return "Uint32Array";
                case array instanceof Int32Array: return "Int32Array";
                case array instanceof Float32Array: return "Float32Array";
                case array instanceof Float64Array: return "Float64Array";
                default:
                    throw new Error("unsupported typed array");
            }
        }
    }
    exports.BYTE_ORDER = compat_1.is_little_endian ? "little" : "big";
    function swap16(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 2);
        for (var i = 0, end = x.length; i < end; i += 2) {
            var t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    exports.swap16 = swap16;
    function swap32(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 4);
        for (var i = 0, end = x.length; i < end; i += 4) {
            var t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    exports.swap32 = swap32;
    function swap64(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 8);
        for (var i = 0, end = x.length; i < end; i += 8) {
            var t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    exports.swap64 = swap64;
    function process_buffer(specification, buffers) {
        var need_swap = specification.order !== exports.BYTE_ORDER;
        var shape = specification.shape;
        var bytes = null;
        for (var _i = 0, buffers_1 = buffers; _i < buffers_1.length; _i++) {
            var buf = buffers_1[_i];
            var header = JSON.parse(buf[0]);
            if (header.id === specification.__buffer__) {
                bytes = buf[1];
                break;
            }
        }
        var arr = new (exports.ARRAY_TYPES[specification.dtype])(bytes);
        if (need_swap) {
            if (arr.BYTES_PER_ELEMENT === 2) {
                swap16(arr);
            }
            else if (arr.BYTES_PER_ELEMENT === 4) {
                swap32(arr);
            }
            else if (arr.BYTES_PER_ELEMENT === 8) {
                swap64(arr);
            }
        }
        return [arr, shape];
    }
    exports.process_buffer = process_buffer;
    function process_array(obj, buffers) {
        if (types_1.isObject(obj) && '__ndarray__' in obj)
            return decode_base64(obj);
        else if (types_1.isObject(obj) && '__buffer__' in obj)
            return process_buffer(obj, buffers);
        else if (types_1.isArray(obj) || types_1.isTypedArray(obj))
            return [obj, []];
        else
            return undefined;
    }
    exports.process_array = process_array;
    function arrayBufferToBase64(buffer) {
        var bytes = new Uint8Array(buffer);
        var chars = Array.from(bytes).map(function (b) { return String.fromCharCode(b); });
        return btoa(chars.join(""));
    }
    exports.arrayBufferToBase64 = arrayBufferToBase64;
    function base64ToArrayBuffer(base64) {
        var binary_string = atob(base64);
        var len = binary_string.length;
        var bytes = new Uint8Array(len);
        for (var i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    exports.base64ToArrayBuffer = base64ToArrayBuffer;
    function decode_base64(input) {
        var bytes = base64ToArrayBuffer(input.__ndarray__);
        var dtype = input.dtype;
        var shape = input.shape;
        var array;
        if (dtype in exports.ARRAY_TYPES)
            array = new (exports.ARRAY_TYPES[dtype])(bytes);
        else
            throw new Error("unknown dtype: " + dtype);
        return [array, shape];
    }
    exports.decode_base64 = decode_base64;
    function encode_base64(array, shape) {
        var b64 = arrayBufferToBase64(array.buffer);
        var name = arrayName(array);
        var dtype;
        if (name in exports.DTYPES)
            dtype = exports.DTYPES[name];
        else
            throw new Error("unknown array type: " + name);
        var data = {
            __ndarray__: b64,
            shape: shape,
            dtype: dtype,
        };
        return data;
    }
    exports.encode_base64 = encode_base64;
    function decode_traverse_data(v, buffers) {
        // v is just a regular array of scalars
        if (v.length == 0 || !(types_1.isObject(v[0]) || types_1.isArray(v[0]))) {
            return [v, []];
        }
        var arrays = [];
        var shapes = [];
        for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
            var obj = v_1[_i];
            var _a = types_1.isArray(obj) ? decode_traverse_data(obj, buffers)
                : process_array(obj, buffers), arr = _a[0], shape = _a[1];
            arrays.push(arr);
            shapes.push(shape);
        }
        // If there is a list of empty lists, reduce that to just a list
        var filtered_shapes = shapes.map(function (shape) { return shape.filter(function (v) { return v.length != 0; }); });
        return [arrays, filtered_shapes];
    }
    function decode_column_data(data, buffers) {
        if (buffers === void 0) {
            buffers = [];
        }
        var new_data = {};
        var new_shapes = {};
        for (var k in data) {
            // might be array of scalars, or might be ragged array or arrays
            var v = data[k];
            if (types_1.isArray(v)) {
                // v is just a regular array of scalars
                if (v.length == 0 || !(types_1.isObject(v[0]) || types_1.isArray(v[0]))) {
                    new_data[k] = v;
                    continue;
                }
                // v is a ragged array of arrays
                var _a = decode_traverse_data(v, buffers), arrays = _a[0], shapes = _a[1];
                new_data[k] = arrays;
                new_shapes[k] = shapes;
                // must be object or array (single array case)
            }
            else {
                var _b = process_array(v, buffers), arr = _b[0], shape = _b[1];
                new_data[k] = arr;
                new_shapes[k] = shape;
            }
        }
        return [new_data, new_shapes];
    }
    exports.decode_column_data = decode_column_data;
    function encode_traverse_data(v, shapes) {
        var new_array = [];
        for (var i = 0, end = v.length; i < end; i++) {
            var item = v[i];
            if (types_1.isTypedArray(item)) {
                var shape = shapes[i] ? shapes[i] : undefined;
                new_array.push(encode_base64(item, shape));
            }
            else if (types_1.isArray(item)) {
                new_array.push(encode_traverse_data(item, shapes ? shapes[i] : []));
            }
            else
                new_array.push(item);
        }
        return new_array;
    }
    function encode_column_data(data, shapes) {
        var new_data = {};
        for (var k in data) {
            var v = data[k];
            var shapes_k = shapes != null ? shapes[k] : undefined;
            var new_v = void 0;
            if (types_1.isTypedArray(v)) {
                new_v = encode_base64(v, shapes_k);
            }
            else if (types_1.isArray(v)) {
                new_v = encode_traverse_data(v, shapes_k || []);
            }
            else
                new_v = v;
            new_data[k] = new_v;
        }
        return new_data;
    }
    exports.encode_column_data = encode_column_data;
},
/* core/util/compat.js */ function _(require, module, exports) {
    exports.is_ie = (function () {
        var ua = typeof navigator !== "undefined" ? navigator.userAgent : "";
        return ua.indexOf('MSIE') >= 0 || ua.indexOf('Trident') > 0 || ua.indexOf('Edge') > 0;
    })();
    exports.is_mobile = (function () {
        return typeof window !== "undefined" && ("ontouchstart" in window || navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (function () {
        var buf = new ArrayBuffer(4);
        var buf8 = new Uint8Array(buf);
        var buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        var little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
},
/* core/util/typed_array.js */ function _(require, module, exports) {
    function concat(array0) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var n = array0.length;
        for (var _a = 0, arrays_1 = arrays; _a < arrays_1.length; _a++) {
            var array = arrays_1[_a];
            n += array.length;
        }
        var result = new array0.constructor(n);
        result.set(array0, 0);
        var i = array0.length;
        for (var _b = 0, arrays_2 = arrays; _b < arrays_2.length; _b++) {
            var array = arrays_2[_b];
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
    exports.concat = concat;
},
/* document/events.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var has_props_1 = require(115) /* ../core/has_props */;
    var DocumentChangedEvent = /** @class */ (function () {
        function DocumentChangedEvent(document) {
            this.document = document;
        }
        return DocumentChangedEvent;
    }());
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    var ModelChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ModelChangedEvent, _super);
        function ModelChangedEvent(document, model, attr, old, new_, setter_id, hint) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.attr = attr;
            _this.old = old;
            _this.new_ = new_;
            _this.setter_id = setter_id;
            _this.hint = hint;
            return _this;
        }
        ModelChangedEvent.prototype.json = function (references) {
            if (this.attr === "id") {
                throw new Error("'id' field should never change, whatever code just set it is wrong");
            }
            if (this.hint != null)
                return this.hint.json(references);
            var value = this.new_;
            var value_json = has_props_1.HasProps._value_to_json(this.attr, value, this.model);
            var value_refs = {};
            has_props_1.HasProps._value_record_references(value, value_refs, true); // true = recurse
            if (this.model.id in value_refs && this.model !== value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                delete value_refs[this.model.id];
            }
            for (var id in value_refs) {
                references[id] = value_refs[id];
            }
            return {
                kind: "ModelChanged",
                model: this.model.ref(),
                attr: this.attr,
                new: value_json,
            };
        };
        return ModelChangedEvent;
    }(DocumentChangedEvent));
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    var ColumnsPatchedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnsPatchedEvent, _super);
        function ColumnsPatchedEvent(document, column_source, patches) {
            var _this = _super.call(this, document) || this;
            _this.column_source = column_source;
            _this.patches = patches;
            return _this;
        }
        ColumnsPatchedEvent.prototype.json = function (_references) {
            return {
                kind: "ColumnsPatched",
                column_source: this.column_source,
                patches: this.patches,
            };
        };
        return ColumnsPatchedEvent;
    }(DocumentChangedEvent));
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    var ColumnsStreamedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnsStreamedEvent, _super);
        function ColumnsStreamedEvent(document, column_source, data, rollover) {
            var _this = _super.call(this, document) || this;
            _this.column_source = column_source;
            _this.data = data;
            _this.rollover = rollover;
            return _this;
        }
        ColumnsStreamedEvent.prototype.json = function (_references) {
            return {
                kind: "ColumnsStreamed",
                column_source: this.column_source,
                data: this.data,
                rollover: this.rollover,
            };
        };
        return ColumnsStreamedEvent;
    }(DocumentChangedEvent));
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    var TitleChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(TitleChangedEvent, _super);
        function TitleChangedEvent(document, title, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.title = title;
            _this.setter_id = setter_id;
            return _this;
        }
        TitleChangedEvent.prototype.json = function (_references) {
            return {
                kind: "TitleChanged",
                title: this.title,
            };
        };
        return TitleChangedEvent;
    }(DocumentChangedEvent));
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    var RootAddedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(RootAddedEvent, _super);
        function RootAddedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootAddedEvent.prototype.json = function (references) {
            has_props_1.HasProps._value_record_references(this.model, references, true);
            return {
                kind: "RootAdded",
                model: this.model.ref(),
            };
        };
        return RootAddedEvent;
    }(DocumentChangedEvent));
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    var RootRemovedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(RootRemovedEvent, _super);
        function RootRemovedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootRemovedEvent.prototype.json = function (_references) {
            return {
                kind: "RootRemoved",
                model: this.model.ref(),
            };
        };
        return RootRemovedEvent;
    }(DocumentChangedEvent));
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* models/annotations/band.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var column_data_source_1 = require(170) /* ../sources/column_data_source */;
    var p = require(121) /* ../../core/properties */;
    var BandView = /** @class */ (function (_super) {
        tslib_1.__extends(BandView, _super);
        function BandView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BandView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.set_data(this.model.source);
        };
        BandView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.source.streaming, function () { return _this.set_data(_this.model.source); });
            this.connect(this.model.source.patching, function () { return _this.set_data(_this.model.source); });
            this.connect(this.model.source.change, function () { return _this.set_data(_this.model.source); });
        };
        BandView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        };
        BandView.prototype._map_data = function () {
            var frame = this.plot_view.frame;
            var dim = this.model.dimension;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var limit_scale = dim == "height" ? yscale : xscale;
            var base_scale = dim == "height" ? xscale : yscale;
            var limit_view = dim == "height" ? frame.yview : frame.xview;
            var base_view = dim == "height" ? frame.xview : frame.yview;
            var _lower_sx;
            if (this.model.properties.lower.units == "data")
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            var _upper_sx;
            if (this.model.properties.upper.units == "data")
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            var _base_sx;
            if (this.model.properties.base.units == "data")
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            var _a = dim == 'height' ? [1, 0] : [0, 1], i = _a[0], j = _a[1];
            var _lower = [_lower_sx, _base_sx];
            var _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        };
        BandView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._map_data();
            var ctx = this.plot_view.canvas_view.ctx;
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var start = this._upper_sx.length - 1, i = start; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
        };
        return BandView;
    }(annotation_1.AnnotationView));
    exports.BandView = BandView;
    BandView.__name__ = "BandView";
    var Band = /** @class */ (function (_super) {
        tslib_1.__extends(Band, _super);
        function Band(attrs) {
            return _super.call(this, attrs) || this;
        }
        Band.init_Band = function () {
            this.prototype.default_view = BandView;
            this.mixins(['line', 'fill']);
            this.define({
                lower: [p.DistanceSpec],
                upper: [p.DistanceSpec],
                base: [p.DistanceSpec],
                dimension: [p.Dimension, 'height'],
                source: [p.Instance, function () { return new column_data_source_1.ColumnDataSource(); }],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        };
        return Band;
    }(annotation_1.Annotation));
    exports.Band = Band;
    Band.__name__ = "Band";
    Band.init_Band();
},
/* models/annotations/box_annotation.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var signaling_1 = require(116) /* ../../core/signaling */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var bbox_1 = require(181) /* ../../core/util/bbox */;
    var annotations_1 = require(202) /* ../../styles/annotations */;
    exports.EDGE_TOLERANCE = 2.5;
    var BoxAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(BoxAnnotationView, _super);
        function BoxAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxAnnotationView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.classList.add(annotations_1.bk_shading);
            dom_1.undisplay(this.el);
        };
        BoxAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () { return _this.render(); });
                this.connect(this.model.data_update, function () { return _this.render(); });
            }
            else {
                this.connect(this.model.change, function () { return _this.plot_view.request_render(); });
                this.connect(this.model.data_update, function () { return _this.plot_view.request_render(); });
            }
        };
        BoxAnnotationView.prototype.render = function () {
            var _this = this;
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.undisplay(this.el);
            if (!this.model.visible)
                return;
            // don't render if *all* position are null
            if (this.model.left == null && this.model.right == null && this.model.top == null && this.model.bottom == null) {
                dom_1.undisplay(this.el);
                return;
            }
            var frame = this.plot_view.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var _calc_dim = function (dim, dim_units, scale, view, frame_extrema) {
                var sdim;
                if (dim != null) {
                    if (_this.model.screen)
                        sdim = dim;
                    else {
                        if (dim_units == 'data')
                            sdim = scale.compute(dim);
                        else
                            sdim = view.compute(dim);
                    }
                }
                else
                    sdim = frame_extrema;
                return sdim;
            };
            this.sleft = _calc_dim(this.model.left, this.model.left_units, xscale, frame.xview, frame._left.value);
            this.sright = _calc_dim(this.model.right, this.model.right_units, xscale, frame.xview, frame._right.value);
            this.stop = _calc_dim(this.model.top, this.model.top_units, yscale, frame.yview, frame._top.value);
            this.sbottom = _calc_dim(this.model.bottom, this.model.bottom_units, yscale, frame.yview, frame._bottom.value);
            var draw = this.model.render_mode == 'css' ? this._css_box.bind(this) : this._canvas_box.bind(this);
            draw(this.sleft, this.sright, this.sbottom, this.stop);
        };
        BoxAnnotationView.prototype._css_box = function (sleft, sright, sbottom, stop) {
            var line_width = this.model.properties.line_width.value();
            var sw = Math.floor(sright - sleft) - line_width;
            var sh = Math.floor(sbottom - stop) - line_width;
            this.el.style.left = sleft + "px";
            this.el.style.width = sw + "px";
            this.el.style.top = stop + "px";
            this.el.style.height = sh + "px";
            this.el.style.borderWidth = line_width + "px";
            this.el.style.borderColor = this.model.properties.line_color.value();
            this.el.style.backgroundColor = this.model.properties.fill_color.value();
            this.el.style.opacity = this.model.properties.fill_alpha.value();
            // try our best to honor line dashing in some way, if we can
            var ld = this.model.properties.line_dash.value().length < 2 ? "solid" : "dashed";
            this.el.style.borderStyle = ld;
            dom_1.display(this.el);
        };
        BoxAnnotationView.prototype._canvas_box = function (sleft, sright, sbottom, stop) {
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            ctx.beginPath();
            ctx.rect(sleft, stop, sright - sleft, sbottom - stop);
            this.visuals.fill.set_value(ctx);
            ctx.fill();
            this.visuals.line.set_value(ctx);
            ctx.stroke();
            ctx.restore();
        };
        BoxAnnotationView.prototype.interactive_bbox = function () {
            var tol = this.model.properties.line_width.value() + exports.EDGE_TOLERANCE;
            return new bbox_1.BBox({
                x0: this.sleft - tol,
                y0: this.stop - tol,
                x1: this.sright + tol,
                y1: this.sbottom + tol,
            });
        };
        BoxAnnotationView.prototype.interactive_hit = function (sx, sy) {
            if (this.model.in_cursor == null)
                return false;
            var bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        };
        BoxAnnotationView.prototype.cursor = function (sx, sy) {
            var tol = 3;
            if (Math.abs(sx - this.sleft) < tol || Math.abs(sx - this.sright) < tol)
                return this.model.ew_cursor;
            else if (Math.abs(sy - this.sbottom) < tol || Math.abs(sy - this.stop) < tol)
                return this.model.ns_cursor;
            else if (sx > this.sleft && sx < this.sright && sy > this.stop && sy < this.sbottom)
                return this.model.in_cursor;
            else
                return null;
        };
        return BoxAnnotationView;
    }(annotation_1.AnnotationView));
    exports.BoxAnnotationView = BoxAnnotationView;
    BoxAnnotationView.__name__ = "BoxAnnotationView";
    var BoxAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(BoxAnnotation, _super);
        function BoxAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        BoxAnnotation.init_BoxAnnotation = function () {
            this.prototype.default_view = BoxAnnotationView;
            this.mixins(['line', 'fill']);
            this.define({
                render_mode: [p.RenderMode, 'canvas'],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
                top: [p.Number, null],
                top_units: [p.SpatialUnits, 'data'],
                bottom: [p.Number, null],
                bottom_units: [p.SpatialUnits, 'data'],
                left: [p.Number, null],
                left_units: [p.SpatialUnits, 'data'],
                right: [p.Number, null],
                right_units: [p.SpatialUnits, 'data'],
            });
            this.internal({
                screen: [p.Boolean, false],
                ew_cursor: [p.String, null],
                ns_cursor: [p.String, null],
                in_cursor: [p.String, null],
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3,
            });
        };
        BoxAnnotation.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.data_update = new signaling_1.Signal0(this, "data_update");
        };
        BoxAnnotation.prototype.update = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            this.setv({ left: left, right: right, top: top, bottom: bottom, screen: true }, { silent: true });
            this.data_update.emit();
        };
        return BoxAnnotation;
    }(annotation_1.Annotation));
    exports.BoxAnnotation = BoxAnnotation;
    BoxAnnotation.__name__ = "BoxAnnotation";
    BoxAnnotation.init_BoxAnnotation();
},
/* styles/annotations.js */ function _(require, module, exports) {
    require(164) /* ./root */;
    var _a = require(163) /* ../core/dom */;
    _a.styles.append(".bk-root .bk-shading {\n  position: absolute;\n  display: block;\n  border: 1px dashed green;\n}\n");
    exports.bk_annotation = "bk-annotation";
    exports.bk_shading = "bk-shading";
    exports.bk_annotation_child = "bk-annotation-child";
},
/* models/annotations/color_bar.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var basic_ticker_1 = require(204) /* ../tickers/basic_ticker */;
    var basic_tick_formatter_1 = require(208) /* ../formatters/basic_tick_formatter */;
    var linear_color_mapper_1 = require(210) /* ../mappers/linear_color_mapper */;
    var linear_scale_1 = require(215) /* ../scales/linear_scale */;
    var log_scale_1 = require(224) /* ../scales/log_scale */;
    var range1d_1 = require(225) /* ../ranges/range1d */;
    var p = require(121) /* ../../core/properties */;
    var text_util = require(226) /* ../../core/util/text */;
    var array_1 = require(110) /* ../../core/util/array */;
    var arrayable_1 = require(114) /* ../../core/util/arrayable */;
    var object_1 = require(125) /* ../../core/util/object */;
    var types_1 = require(109) /* ../../core/util/types */;
    var SHORT_DIM = 25;
    var LONG_DIM_MIN_SCALAR = 0.3;
    var LONG_DIM_MAX_SCALAR = 0.8;
    var ColorBarView = /** @class */ (function (_super) {
        tslib_1.__extends(ColorBarView, _super);
        function ColorBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColorBarView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._set_canvas_image();
        };
        ColorBarView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.visible.change, function () { return _this.plot_view.request_render(); });
            this.connect(this.model.ticker.change, function () { return _this.plot_view.request_render(); });
            this.connect(this.model.formatter.change, function () { return _this.plot_view.request_render(); });
            if (this.model.color_mapper != null) {
                this.connect(this.model.color_mapper.change, function () {
                    _this._set_canvas_image();
                    _this.plot_view.request_render();
                });
            }
        };
        ColorBarView.prototype._get_size = function () {
            if (this.model.color_mapper == null)
                return { width: 0, height: 0 };
            else {
                var _a = this.compute_legend_dimensions(), width = _a.width, height = _a.height;
                return { width: width, height: height };
            }
        };
        ColorBarView.prototype._set_canvas_image = function () {
            var _a, _b;
            if (this.model.color_mapper == null)
                return;
            var palette = this.model.color_mapper.palette;
            if (this.model.orientation == 'vertical')
                palette = array_1.reversed(palette);
            var w, h;
            switch (this.model.orientation) {
                case "vertical": {
                    _a = [1, palette.length], w = _a[0], h = _a[1];
                    break;
                }
                case "horizontal": {
                    _b = [palette.length, 1], w = _b[0], h = _b[1];
                    break;
                }
                default:
                    throw new Error("unreachable code");
            }
            var canvas = document.createElement('canvas');
            canvas.width = w;
            canvas.height = h;
            var image_ctx = canvas.getContext('2d');
            var image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            var cmap = new linear_color_mapper_1.LinearColorMapper({ palette: palette }).rgba_mapper;
            var buf8 = cmap.v_compute(array_1.range(0, palette.length));
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
            this.image = canvas;
        };
        ColorBarView.prototype.compute_legend_dimensions = function () {
            var image_dimensions = this._computed_image_dimensions();
            var _a = [image_dimensions.height, image_dimensions.width], image_height = _a[0], image_width = _a[1];
            var label_extent = this._get_label_extent();
            var title_extent = this._title_extent();
            var tick_extent = this._tick_extent();
            var padding = this.model.padding;
            var legend_height, legend_width;
            switch (this.model.orientation) {
                case "vertical":
                    legend_height = image_height + title_extent + 2 * padding;
                    legend_width = image_width + tick_extent + label_extent + 2 * padding;
                    break;
                case "horizontal":
                    legend_height = image_height + title_extent + tick_extent + label_extent + 2 * padding;
                    legend_width = image_width + 2 * padding;
                    break;
                default:
                    throw new Error("unreachable code");
            }
            return { width: legend_width, height: legend_height };
        };
        ColorBarView.prototype.compute_legend_location = function () {
            var legend_dimensions = this.compute_legend_dimensions();
            var _a = [legend_dimensions.height, legend_dimensions.width], legend_height = _a[0], legend_width = _a[1];
            var legend_margin = this.model.margin;
            var panel = this.panel != null ? this.panel : this.plot_view.frame;
            var _b = panel.bbox.ranges, hr = _b[0], vr = _b[1];
            var location = this.model.location;
            var sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                    case 'top_left':
                        sx = hr.start + legend_margin;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.start + legend_margin;
                        break;
                    case 'bottom_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_left':
                        sx = hr.start + legend_margin;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'center_left':
                        sx = hr.start + legend_margin;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    default:
                        throw new Error("unreachable code");
                }
            }
            else if (types_1.isArray(location) && location.length == 2) {
                var vx = location[0], vy = location[1];
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            }
            else
                throw new Error("unreachable code");
            return { sx: sx, sy: sy };
        };
        ColorBarView.prototype.render = function () {
            if (!this.model.visible || this.model.color_mapper == null)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            var _a = this.compute_legend_location(), sx = _a.sx, sy = _a.sy;
            ctx.translate(sx, sy);
            this._draw_bbox(ctx);
            var image_offset = this._get_image_offset();
            ctx.translate(image_offset.x, image_offset.y);
            this._draw_image(ctx);
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null) {
                var tick_info = this.tick_info();
                this._draw_major_ticks(ctx, tick_info);
                this._draw_minor_ticks(ctx, tick_info);
                this._draw_major_labels(ctx, tick_info);
            }
            if (this.model.title)
                this._draw_title(ctx);
            ctx.restore();
        };
        ColorBarView.prototype._draw_bbox = function (ctx) {
            var bbox = this.compute_legend_dimensions();
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(0, 0, bbox.width, bbox.height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(0, 0, bbox.width, bbox.height);
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_image = function (ctx) {
            var image = this._computed_image_dimensions();
            ctx.save();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.scale_alpha;
            ctx.drawImage(this.image, 0, 0, image.width, image.height);
            if (this.visuals.bar_line.doit) {
                this.visuals.bar_line.set_value(ctx);
                ctx.strokeRect(0, 0, image.width, image.height);
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_major_ticks = function (ctx, tick_info) {
            if (!this.visuals.major_tick_line.doit)
                return;
            var _a = this._normals(), nx = _a[0], ny = _a[1];
            var image = this._computed_image_dimensions();
            var _b = [image.width * nx, image.height * ny], x_offset = _b[0], y_offset = _b[1];
            var _c = tick_info.coords.major, sx = _c[0], sy = _c[1];
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.major_tick_line.set_value(ctx);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_minor_ticks = function (ctx, tick_info) {
            if (!this.visuals.minor_tick_line.doit)
                return;
            var _a = this._normals(), nx = _a[0], ny = _a[1];
            var image = this._computed_image_dimensions();
            var _b = [image.width * nx, image.height * ny], x_offset = _b[0], y_offset = _b[1];
            var _c = tick_info.coords.minor, sx = _c[0], sy = _c[1];
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.minor_tick_line.set_value(ctx);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_major_labels = function (ctx, tick_info) {
            if (!this.visuals.major_label_text.doit)
                return;
            var _a = this._normals(), nx = _a[0], ny = _a[1];
            var image = this._computed_image_dimensions();
            var _b = [image.width * nx, image.height * ny], x_offset = _b[0], y_offset = _b[1];
            var standoff = (this.model.label_standoff + this._tick_extent());
            var _c = [standoff * nx, standoff * ny], x_standoff = _c[0], y_standoff = _c[1];
            var _d = tick_info.coords.major, sx = _d[0], sy = _d[1];
            var formatted_labels = tick_info.labels.major;
            this.visuals.major_label_text.set_value(ctx);
            ctx.save();
            ctx.translate(x_offset + x_standoff, y_offset + y_standoff);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.fillText(formatted_labels[i], Math.round(sx[i] + nx * this.model.label_standoff), Math.round(sy[i] + ny * this.model.label_standoff));
            }
            ctx.restore();
        };
        ColorBarView.prototype._draw_title = function (ctx) {
            if (!this.visuals.title_text.doit)
                return;
            ctx.save();
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(this.model.title, 0, -this.model.title_standoff);
            ctx.restore();
        };
        /*protected*/ ColorBarView.prototype._get_label_extent = function () {
            var major_labels = this.tick_info().labels.major;
            var label_extent;
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null && !object_1.isEmpty(major_labels)) {
                var ctx_1 = this.plot_view.canvas_view.ctx;
                ctx_1.save();
                this.visuals.major_label_text.set_value(ctx_1);
                switch (this.model.orientation) {
                    case "vertical":
                        label_extent = array_1.max((major_labels.map(function (label) { return ctx_1.measureText(label.toString()).width; })));
                        break;
                    case "horizontal":
                        label_extent = text_util.measure_font(this.visuals.major_label_text.font_value()).height;
                        break;
                    default:
                        throw new Error("unreachable code");
                }
                label_extent += this.model.label_standoff;
                ctx_1.restore();
            }
            else
                label_extent = 0;
            return label_extent;
        };
        /*protected*/ ColorBarView.prototype._get_image_offset = function () {
            // Returns image offset relative to legend bounding box
            var x = this.model.padding;
            var y = this.model.padding + this._title_extent();
            return { x: x, y: y };
        };
        // {{{ TODO: state
        ColorBarView.prototype._normals = function () {
            return this.model.orientation == 'vertical' ? [1, 0] : [0, 1];
        };
        ColorBarView.prototype._title_extent = function () {
            var font_value = this.model.title_text_font + " " + this.model.title_text_font_size + " " + this.model.title_text_font_style;
            var title_extent = this.model.title ? text_util.measure_font(font_value).height + this.model.title_standoff : 0;
            return title_extent;
        };
        ColorBarView.prototype._tick_extent = function () {
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null)
                return array_1.max([this.model.major_tick_out, this.model.minor_tick_out]);
            else
                return 0;
        };
        ColorBarView.prototype._computed_image_dimensions = function () {
            /*
            Heuristics to determine ColorBar image dimensions if set to "auto"
        
            Note: Returns the height/width values for the ColorBar's scale image, not
            the dimensions of the entire ColorBar.
        
            If the short dimension (the width of a vertical bar or height of a
            horizontal bar) is set to "auto", the resulting dimension will be set to
            25 px.
        
            For a ColorBar in a side panel with the long dimension (the height of a
            vertical bar or width of a horizontal bar) set to "auto", the
            resulting dimension will be as long as the adjacent frame edge, so that the
            bar "fits" to the plot.
        
            For a ColorBar in the plot frame with the long dimension set to "auto", the
            resulting dimension will be the greater of:
              * The length of the color palette * 25px
              * The parallel frame dimension * 0.30
                (i.e the frame height for a vertical ColorBar)
            But not greater than:
              * The parallel frame dimension * 0.80
            */
            var frame_height = this.plot_view.frame._height.value;
            var frame_width = this.plot_view.frame._width.value;
            var title_extent = this._title_extent();
            var height, width;
            switch (this.model.orientation) {
                case "vertical": {
                    if (this.model.height == 'auto') {
                        if (this.panel != null)
                            height = frame_height - 2 * this.model.padding - title_extent;
                        else {
                            height = array_1.max([this.model.color_mapper.palette.length * SHORT_DIM, frame_height * LONG_DIM_MIN_SCALAR]);
                            height = array_1.min([height, frame_height * LONG_DIM_MAX_SCALAR - 2 * this.model.padding - title_extent]);
                        }
                    }
                    else
                        height = this.model.height;
                    width = this.model.width == 'auto' ? SHORT_DIM : this.model.width;
                    break;
                }
                case "horizontal": {
                    height = this.model.height == 'auto' ? SHORT_DIM : this.model.height;
                    if (this.model.width == 'auto') {
                        if (this.panel != null)
                            width = frame_width - 2 * this.model.padding;
                        else {
                            width = array_1.max([this.model.color_mapper.palette.length * SHORT_DIM, frame_width * LONG_DIM_MIN_SCALAR]);
                            width = array_1.min([width, frame_width * LONG_DIM_MAX_SCALAR - 2 * this.model.padding]);
                        }
                    }
                    else
                        width = this.model.width;
                    break;
                }
                default:
                    throw new Error("unreachable code");
            }
            return { width: width, height: height };
        };
        /*protected*/ ColorBarView.prototype._tick_coordinate_scale = function (scale_length) {
            /*
            Creates and returns a scale instance that maps the `color_mapper` range
            (low to high) to a screen space range equal to the length of the ColorBar's
            scale image. The scale is used to calculate the tick coordinates in screen
            coordinates for plotting purposes.
        
            Note: the type of color_mapper has to match the type of scale (i.e.
            a LinearColorMapper will require a corresponding LinearScale instance).
            */
            var ranges = {
                source_range: new range1d_1.Range1d({
                    start: this.model.color_mapper.low,
                    end: this.model.color_mapper.high,
                }),
                target_range: new range1d_1.Range1d({
                    start: 0,
                    end: scale_length,
                }),
            };
            switch (this.model.color_mapper.type) {
                case "LinearColorMapper": return new linear_scale_1.LinearScale(ranges);
                case "LogColorMapper": return new log_scale_1.LogScale(ranges);
                default:
                    throw new Error("unreachable code");
            }
        };
        ColorBarView.prototype._format_major_labels = function (initial_labels, major_ticks) {
            // XXX: passing null as cross_loc probably means MercatorTickFormatters, etc
            // will not function properly in conjunction with colorbars
            var formatted_labels = this.model.formatter.doFormat(initial_labels, null);
            for (var i = 0, end = major_ticks.length; i < end; i++) {
                if (major_ticks[i] in this.model.major_label_overrides)
                    formatted_labels[i] = this.model.major_label_overrides[major_ticks[i]];
            }
            return formatted_labels;
        };
        ColorBarView.prototype.tick_info = function () {
            var image_dimensions = this._computed_image_dimensions();
            var scale_length;
            switch (this.model.orientation) {
                case "vertical": {
                    scale_length = image_dimensions.height;
                    break;
                }
                case "horizontal": {
                    scale_length = image_dimensions.width;
                    break;
                }
                default:
                    throw new Error("unreachable code");
            }
            var scale = this._tick_coordinate_scale(scale_length);
            var _a = this._normals(), i = _a[0], j = _a[1];
            var _b = [this.model.color_mapper.low, this.model.color_mapper.high], start = _b[0], end = _b[1];
            // XXX: passing null as cross_loc probably means MercatorTickers, etc
            // will not function properly in conjunction with colorbars
            var ticks = this.model.ticker.get_ticks(start, end, null, null, this.model.ticker.desired_num_ticks);
            var majors = ticks.major;
            var minors = ticks.minor;
            var major_coords = [[], []];
            var minor_coords = [[], []];
            for (var ii = 0, _end = majors.length; ii < _end; ii++) {
                if (majors[ii] < start || majors[ii] > end)
                    continue;
                major_coords[i].push(majors[ii]);
                major_coords[j].push(0);
            }
            for (var ii = 0, _end = minors.length; ii < _end; ii++) {
                if (minors[ii] < start || minors[ii] > end)
                    continue;
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(0);
            }
            var labels = { major: this._format_major_labels(major_coords[i], majors) };
            var coords = {
                major: [[], []],
                minor: [[], []],
            };
            coords.major[i] = scale.v_compute(major_coords[i]);
            coords.minor[i] = scale.v_compute(minor_coords[i]);
            coords.major[j] = major_coords[j];
            coords.minor[j] = minor_coords[j];
            // Because we want the scale to be reversed
            if (this.model.orientation == 'vertical') {
                coords.major[i] = arrayable_1.map(coords.major[i], function (coord) { return scale_length - coord; });
                coords.minor[i] = arrayable_1.map(coords.minor[i], function (coord) { return scale_length - coord; });
            }
            return { coords: coords, labels: labels };
        };
        return ColorBarView;
    }(annotation_1.AnnotationView));
    exports.ColorBarView = ColorBarView;
    ColorBarView.__name__ = "ColorBarView";
    var ColorBar = /** @class */ (function (_super) {
        tslib_1.__extends(ColorBar, _super);
        function ColorBar(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColorBar.init_ColorBar = function () {
            this.prototype.default_view = ColorBarView;
            this.mixins([
                'text:major_label_',
                'text:title_',
                'line:major_tick_',
                'line:minor_tick_',
                'line:border_',
                'line:bar_',
                'fill:background_',
            ]);
            this.define({
                location: [p.Any, 'top_right'],
                orientation: [p.Orientation, 'vertical'],
                title: [p.String],
                title_standoff: [p.Number, 2],
                width: [p.Any, 'auto'],
                height: [p.Any, 'auto'],
                scale_alpha: [p.Number, 1.0],
                ticker: [p.Instance, function () { return new basic_ticker_1.BasicTicker(); }],
                formatter: [p.Instance, function () { return new basic_tick_formatter_1.BasicTickFormatter(); }],
                major_label_overrides: [p.Any, {}],
                color_mapper: [p.Instance],
                label_standoff: [p.Number, 5],
                margin: [p.Number, 30],
                padding: [p.Number, 10],
                major_tick_in: [p.Number, 5],
                major_tick_out: [p.Number, 0],
                minor_tick_in: [p.Number, 0],
                minor_tick_out: [p.Number, 0],
            });
            this.override({
                background_fill_color: "#ffffff",
                background_fill_alpha: 0.95,
                bar_line_color: null,
                border_line_color: null,
                major_label_text_align: "center",
                major_label_text_baseline: "middle",
                major_label_text_font_size: "8pt",
                major_tick_line_color: "#ffffff",
                minor_tick_line_color: null,
                title_text_font_size: "10pt",
                title_text_font_style: "italic",
            });
        };
        return ColorBar;
    }(annotation_1.Annotation));
    exports.ColorBar = ColorBar;
    ColorBar.__name__ = "ColorBar";
    ColorBar.init_ColorBar();
},
/* models/tickers/basic_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var adaptive_ticker_1 = require(205) /* ./adaptive_ticker */;
    var BasicTicker = /** @class */ (function (_super) {
        tslib_1.__extends(BasicTicker, _super);
        function BasicTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        return BasicTicker;
    }(adaptive_ticker_1.AdaptiveTicker));
    exports.BasicTicker = BasicTicker;
    BasicTicker.__name__ = "BasicTicker";
},
/* models/tickers/adaptive_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var continuous_ticker_1 = require(206) /* ./continuous_ticker */;
    var array_1 = require(110) /* ../../core/util/array */;
    var p = require(121) /* ../../core/properties */;
    // Forces a number x into a specified range [min_val, max_val].
    function clamp(x, min_val, max_val) {
        return Math.max(min_val, Math.min(max_val, x));
    }
    // A log function with an optional base.
    function log(x, base) {
        if (base === void 0) {
            base = Math.E;
        }
        return Math.log(x) / Math.log(base);
    }
    var AdaptiveTicker = /** @class */ (function (_super) {
        tslib_1.__extends(AdaptiveTicker, _super);
        function AdaptiveTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        AdaptiveTicker.init_AdaptiveTicker = function () {
            this.define({
                base: [p.Number, 10.0],
                mantissas: [p.Array, [1, 2, 5]],
                min_interval: [p.Number, 0.0],
                max_interval: [p.Number],
            });
        };
        // These arguments control the range of possible intervals.  The interval I
        // returned by get_interval() will be the one that most closely matches the
        // desired number of ticks, subject to the following constraints:
        // I = (M * B^N), where
        // M is a member of mantissas,
        // B is base,
        // and N is an integer;
        // and min_interval <= I <= max_interval.
        AdaptiveTicker.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            var prefix_mantissa = array_1.nth(this.mantissas, -1) / this.base;
            var suffix_mantissa = array_1.nth(this.mantissas, 0) * this.base;
            this.extended_mantissas = tslib_1.__spreadArrays([prefix_mantissa], this.mantissas, [suffix_mantissa]);
            this.base_factor = this.get_min_interval() === 0.0 ? 1.0 : this.get_min_interval();
        };
        AdaptiveTicker.prototype.get_interval = function (data_low, data_high, desired_n_ticks) {
            var data_range = data_high - data_low;
            var ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            var interval_exponent = Math.floor(log(ideal_interval / this.base_factor, this.base));
            var ideal_magnitude = Math.pow(this.base, interval_exponent) * this.base_factor;
            // An untested optimization.
            //   const ideal_mantissa = ideal_interval / ideal_magnitude
            //   index = sorted_index(this.extended_mantissas, ideal_mantissa)
            //   candidate_mantissas = this.extended_mantissas[index..index + 1]
            var candidate_mantissas = this.extended_mantissas;
            var errors = candidate_mantissas.map(function (mantissa) {
                return Math.abs(desired_n_ticks - (data_range / (mantissa * ideal_magnitude)));
            });
            var best_mantissa = candidate_mantissas[array_1.argmin(errors)];
            var interval = best_mantissa * ideal_magnitude;
            return clamp(interval, this.get_min_interval(), this.get_max_interval());
        };
        return AdaptiveTicker;
    }(continuous_ticker_1.ContinuousTicker));
    exports.AdaptiveTicker = AdaptiveTicker;
    AdaptiveTicker.__name__ = "AdaptiveTicker";
    AdaptiveTicker.init_AdaptiveTicker();
},
/* models/tickers/continuous_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var ticker_1 = require(207) /* ./ticker */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    var types_1 = require(109) /* ../../core/util/types */;
    var ContinuousTicker = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousTicker, _super);
        function ContinuousTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        ContinuousTicker.init_ContinuousTicker = function () {
            this.define({
                num_minor_ticks: [p.Number, 5],
                desired_num_ticks: [p.Number, 6],
            });
        };
        ContinuousTicker.prototype.get_ticks = function (data_low, data_high, _range, cross_loc, _) {
            return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
        };
        // The version of get_ticks() that does the work (and the version that
        // should be overridden in subclasses).
        ContinuousTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, _cross_loc, desired_n_ticks) {
            var interval = this.get_interval(data_low, data_high, desired_n_ticks);
            var start_factor = Math.floor(data_low / interval);
            var end_factor = Math.ceil(data_high / interval);
            var factors;
            if (types_1.isStrictNaN(start_factor) || types_1.isStrictNaN(end_factor))
                factors = [];
            else
                factors = array_1.range(start_factor, end_factor + 1);
            var ticks = factors
                .map(function (factor) { return factor * interval; })
                .filter(function (tick) { return data_low <= tick && tick <= data_high; });
            var num_minor_ticks = this.num_minor_ticks;
            var minor_ticks = [];
            if (num_minor_ticks > 0 && ticks.length > 0) {
                var minor_interval_1 = interval / num_minor_ticks;
                var minor_offsets = array_1.range(0, num_minor_ticks).map(function (i) { return i * minor_interval_1; });
                for (var _i = 0, _a = minor_offsets.slice(1); _i < _a.length; _i++) {
                    var x = _a[_i];
                    var mt = ticks[0] - x;
                    if (data_low <= mt && mt <= data_high) {
                        minor_ticks.push(mt);
                    }
                }
                for (var _b = 0, ticks_1 = ticks; _b < ticks_1.length; _b++) {
                    var tick = ticks_1[_b];
                    for (var _c = 0, minor_offsets_1 = minor_offsets; _c < minor_offsets_1.length; _c++) {
                        var x = minor_offsets_1[_c];
                        var mt = tick + x;
                        if (data_low <= mt && mt <= data_high) {
                            minor_ticks.push(mt);
                        }
                    }
                }
            }
            return {
                major: ticks,
                minor: minor_ticks,
            };
        };
        // Returns the smallest interval that can be returned by get_interval().
        ContinuousTicker.prototype.get_min_interval = function () {
            return this.min_interval;
        };
        // Returns the largest interval that can be returned by get_interval().
        ContinuousTicker.prototype.get_max_interval = function () {
            return this.max_interval != null ? this.max_interval : Infinity;
        };
        // Returns the interval size that would produce exactly the number of
        // desired ticks.  (In general we won't use exactly this interval, because
        // we want the ticks to be round numbers.)
        ContinuousTicker.prototype.get_ideal_interval = function (data_low, data_high, desired_n_ticks) {
            var data_range = data_high - data_low;
            return data_range / desired_n_ticks;
        };
        return ContinuousTicker;
    }(ticker_1.Ticker));
    exports.ContinuousTicker = ContinuousTicker;
    ContinuousTicker.__name__ = "ContinuousTicker";
    ContinuousTicker.init_ContinuousTicker();
},
/* models/tickers/ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var Ticker = /** @class */ (function (_super) {
        tslib_1.__extends(Ticker, _super);
        function Ticker(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Ticker;
    }(model_1.Model));
    exports.Ticker = Ticker;
    Ticker.__name__ = "Ticker";
},
/* models/formatters/basic_tick_formatter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var tick_formatter_1 = require(209) /* ./tick_formatter */;
    var p = require(121) /* ../../core/properties */;
    var types_1 = require(109) /* ../../core/util/types */;
    var BasicTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(BasicTickFormatter, _super);
        function BasicTickFormatter(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.last_precision = 3;
            return _this;
        }
        BasicTickFormatter.init_BasicTickFormatter = function () {
            this.define({
                precision: [p.Any, 'auto'],
                use_scientific: [p.Boolean, true],
                power_limit_high: [p.Number, 5],
                power_limit_low: [p.Number, -3],
            });
        };
        Object.defineProperty(BasicTickFormatter.prototype, "scientific_limit_low", {
            get: function () {
                return Math.pow(10.0, this.power_limit_low);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BasicTickFormatter.prototype, "scientific_limit_high", {
            get: function () {
                return Math.pow(10.0, this.power_limit_high);
            },
            enumerable: true,
            configurable: true
        });
        BasicTickFormatter.prototype.doFormat = function (ticks, _opts) {
            if (ticks.length == 0)
                return [];
            var zero_eps = 0;
            if (ticks.length >= 2)
                zero_eps = Math.abs(ticks[1] - ticks[0]) / 10000;
            var need_sci = false;
            if (this.use_scientific) {
                for (var _i = 0, ticks_1 = ticks; _i < ticks_1.length; _i++) {
                    var tick = ticks_1[_i];
                    var tick_abs = Math.abs(tick);
                    if (tick_abs > zero_eps && (tick_abs >= this.scientific_limit_high || tick_abs <= this.scientific_limit_low)) {
                        need_sci = true;
                        break;
                    }
                }
            }
            var labels = new Array(ticks.length);
            var precision = this.precision;
            if (precision == null || types_1.isNumber(precision)) {
                if (need_sci) {
                    for (var i = 0, end = ticks.length; i < end; i++) {
                        labels[i] = ticks[i].toExponential(precision || undefined);
                    }
                }
                else {
                    for (var i = 0, end = ticks.length; i < end; i++) {
                        labels[i] = ticks[i].toFixed(precision || undefined).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
                    }
                }
            }
            else {
                for (var x = this.last_precision, asc = this.last_precision <= 15; asc ? x <= 15 : x >= 15; asc ? x++ : x--) {
                    var is_ok = true;
                    if (need_sci) {
                        for (var i = 0, end = ticks.length; i < end; i++) {
                            labels[i] = ticks[i].toExponential(x);
                            if (i > 0) {
                                if (labels[i] === labels[i - 1]) {
                                    is_ok = false;
                                    break;
                                }
                            }
                        }
                        if (is_ok) {
                            break;
                        }
                    }
                    else {
                        for (var i = 0, end = ticks.length; i < end; i++) {
                            labels[i] = ticks[i].toFixed(x).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
                            if (i > 0) {
                                if (labels[i] == labels[i - 1]) {
                                    is_ok = false;
                                    break;
                                }
                            }
                        }
                        if (is_ok) {
                            break;
                        }
                    }
                    if (is_ok) {
                        this.last_precision = x;
                        break;
                    }
                }
            }
            return labels;
        };
        return BasicTickFormatter;
    }(tick_formatter_1.TickFormatter));
    exports.BasicTickFormatter = BasicTickFormatter;
    BasicTickFormatter.__name__ = "BasicTickFormatter";
    BasicTickFormatter.init_BasicTickFormatter();
},
/* models/formatters/tick_formatter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var TickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(TickFormatter, _super);
        function TickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        return TickFormatter;
    }(model_1.Model));
    exports.TickFormatter = TickFormatter;
    TickFormatter.__name__ = "TickFormatter";
},
/* models/mappers/linear_color_mapper.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var continuous_color_mapper_1 = require(211) /* ./continuous_color_mapper */;
    var arrayable_1 = require(114) /* ../../core/util/arrayable */;
    var LinearColorMapper = /** @class */ (function (_super) {
        tslib_1.__extends(LinearColorMapper, _super);
        function LinearColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearColorMapper.prototype._v_compute = function (data, values, palette, colors) {
            var nan_color = colors.nan_color, low_color = colors.low_color, high_color = colors.high_color;
            var low = this.low != null ? this.low : arrayable_1.min(data);
            var high = this.high != null ? this.high : arrayable_1.max(data);
            var max_key = palette.length - 1;
            var norm_factor = 1 / (high - low);
            var normed_interval = 1 / palette.length;
            for (var i = 0, end = data.length; i < end; i++) {
                var d = data[i];
                if (isNaN(d)) {
                    values[i] = nan_color;
                    continue;
                }
                // This handles the edge case where d == high, since the code below maps
                // values exactly equal to high to palette.length, which is greater than
                // max_key
                if (d == high) {
                    values[i] = palette[max_key];
                    continue;
                }
                var normed_d = (d - low) * norm_factor;
                var key = Math.floor(normed_d / normed_interval);
                if (key < 0)
                    values[i] = low_color != null ? low_color : palette[0];
                else if (key > max_key)
                    values[i] = high_color != null ? high_color : palette[max_key];
                else
                    values[i] = palette[key];
            }
        };
        return LinearColorMapper;
    }(continuous_color_mapper_1.ContinuousColorMapper));
    exports.LinearColorMapper = LinearColorMapper;
    LinearColorMapper.__name__ = "LinearColorMapper";
},
/* models/mappers/continuous_color_mapper.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var color_mapper_1 = require(212) /* ./color_mapper */;
    var p = require(121) /* ../../core/properties */;
    var ContinuousColorMapper = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousColorMapper, _super);
        function ContinuousColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        ContinuousColorMapper.init_ContinuousColorMapper = function () {
            this.define({
                high: [p.Number],
                low: [p.Number],
                high_color: [p.Color],
                low_color: [p.Color],
            });
        };
        ContinuousColorMapper.prototype._colors = function (conv) {
            return Object.assign(Object.assign({}, _super.prototype._colors.call(this, conv)), { low_color: this.low_color != null ? conv(this.low_color) : undefined, high_color: this.high_color != null ? conv(this.high_color) : undefined });
        };
        return ContinuousColorMapper;
    }(color_mapper_1.ColorMapper));
    exports.ContinuousColorMapper = ContinuousColorMapper;
    ContinuousColorMapper.__name__ = "ContinuousColorMapper";
    ContinuousColorMapper.init_ContinuousColorMapper();
},
/* models/mappers/color_mapper.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var mapper_1 = require(213) /* ./mapper */;
    var p = require(121) /* ../../core/properties */;
    var types_1 = require(109) /* ../../core/util/types */;
    var color_1 = require(123) /* ../../core/util/color */;
    var compat_1 = require(197) /* ../../core/util/compat */;
    function _convert_color(color) {
        if (types_1.isNumber(color))
            return color;
        if (color[0] != "#")
            color = color_1.color2hex(color);
        if (color.length != 9)
            color = color + 'ff';
        return parseInt(color.slice(1), 16);
    }
    exports._convert_color = _convert_color;
    function _convert_palette(palette) {
        var new_palette = new Uint32Array(palette.length);
        for (var i = 0, end = palette.length; i < end; i++)
            new_palette[i] = _convert_color(palette[i]);
        return new_palette;
    }
    exports._convert_palette = _convert_palette;
    function _uint32_to_rgba(values) {
        if (compat_1.is_little_endian) {
            var view = new DataView(values.buffer);
            for (var i = 0, end = values.length; i < end; i++)
                view.setUint32(i * 4, values[i]);
        }
        return new Uint8Array(values.buffer);
    }
    exports._uint32_to_rgba = _uint32_to_rgba;
    var ColorMapper = /** @class */ (function (_super) {
        tslib_1.__extends(ColorMapper, _super);
        function ColorMapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColorMapper.init_ColorMapper = function () {
            this.define({
                palette: [p.Any],
                nan_color: [p.Color, "gray"],
            });
        };
        ColorMapper.prototype.v_compute = function (xs) {
            var values = new Array(xs.length);
            this._v_compute(xs, values, this.palette, this._colors(function (c) { return c; }));
            return values;
        };
        Object.defineProperty(ColorMapper.prototype, "rgba_mapper", {
            get: function () {
                var self = this;
                var palette = _convert_palette(this.palette);
                var colors = this._colors(_convert_color);
                return {
                    v_compute: function (xs) {
                        var values = new Uint32Array(xs.length);
                        self._v_compute(xs, values, palette, colors);
                        return _uint32_to_rgba(values);
                    },
                };
            },
            enumerable: true,
            configurable: true
        });
        ColorMapper.prototype._colors = function (conv) {
            return { nan_color: conv(this.nan_color) };
        };
        return ColorMapper;
    }(mapper_1.Mapper));
    exports.ColorMapper = ColorMapper;
    ColorMapper.__name__ = "ColorMapper";
    ColorMapper.init_ColorMapper();
},
/* models/mappers/mapper.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var transform_1 = require(214) /* ../transforms/transform */;
    var Mapper = /** @class */ (function (_super) {
        tslib_1.__extends(Mapper, _super);
        function Mapper(attrs) {
            return _super.call(this, attrs) || this;
        }
        Mapper.prototype.compute = function (_x) {
            // If it's just a single value, then a mapper doesn't really make sense.
            throw new Error("mapping single values is not supported");
        };
        return Mapper;
    }(transform_1.Transform));
    exports.Mapper = Mapper;
    Mapper.__name__ = "Mapper";
},
/* models/transforms/transform.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var Transform = /** @class */ (function (_super) {
        tslib_1.__extends(Transform, _super);
        function Transform(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Transform;
    }(model_1.Model));
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/scales/linear_scale.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var scale_1 = require(216) /* ./scale */;
    var LinearScale = /** @class */ (function (_super) {
        tslib_1.__extends(LinearScale, _super);
        function LinearScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearScale.prototype.compute = function (x) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            return factor * x + offset;
        };
        LinearScale.prototype.v_compute = function (xs) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            var result = new Float64Array(xs.length);
            for (var i = 0; i < xs.length; i++)
                result[i] = factor * xs[i] + offset;
            return result;
        };
        LinearScale.prototype.invert = function (xprime) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            return (xprime - offset) / factor;
        };
        LinearScale.prototype.v_invert = function (xprimes) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            var result = new Float64Array(xprimes.length);
            for (var i = 0; i < xprimes.length; i++)
                result[i] = (xprimes[i] - offset) / factor;
            return result;
        };
        /*protected*/ LinearScale.prototype._compute_state = function () {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var factor = (target_end - target_start) / (source_end - source_start);
            var offset = -(factor * source_start) + target_start;
            return [factor, offset];
        };
        return LinearScale;
    }(scale_1.Scale));
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/scale.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var transforms_1 = require(217) /* ../transforms */;
    var p = require(121) /* ../../core/properties */;
    var Scale = /** @class */ (function (_super) {
        tslib_1.__extends(Scale, _super);
        function Scale(attrs) {
            return _super.call(this, attrs) || this;
        }
        Scale.init_Scale = function () {
            this.internal({
                source_range: [p.Any],
                target_range: [p.Any],
            });
        };
        Scale.prototype.r_compute = function (x0, x1) {
            if (this.target_range.is_reversed)
                return [this.compute(x1), this.compute(x0)];
            else
                return [this.compute(x0), this.compute(x1)];
        };
        Scale.prototype.r_invert = function (sx0, sx1) {
            if (this.target_range.is_reversed)
                return [this.invert(sx1), this.invert(sx0)];
            else
                return [this.invert(sx0), this.invert(sx1)];
        };
        return Scale;
    }(transforms_1.Transform));
    exports.Scale = Scale;
    Scale.__name__ = "Scale";
    Scale.init_Scale();
},
/* models/transforms/index.js */ function _(require, module, exports) {
    var customjs_transform_1 = require(218) /* ./customjs_transform */;
    exports.CustomJSTransform = customjs_transform_1.CustomJSTransform;
    var dodge_1 = require(219) /* ./dodge */;
    exports.Dodge = dodge_1.Dodge;
    var interpolator_1 = require(220) /* ./interpolator */;
    exports.Interpolator = interpolator_1.Interpolator;
    var jitter_1 = require(221) /* ./jitter */;
    exports.Jitter = jitter_1.Jitter;
    var linear_interpolator_1 = require(222) /* ./linear_interpolator */;
    exports.LinearInterpolator = linear_interpolator_1.LinearInterpolator;
    var step_interpolator_1 = require(223) /* ./step_interpolator */;
    exports.StepInterpolator = step_interpolator_1.StepInterpolator;
    var transform_1 = require(214) /* ./transform */;
    exports.Transform = transform_1.Transform;
},
/* models/transforms/customjs_transform.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var transform_1 = require(214) /* ./transform */;
    var p = require(121) /* ../../core/properties */;
    var object_1 = require(125) /* ../../core/util/object */;
    var string_1 = require(127) /* ../../core/util/string */;
    var CustomJSTransform = /** @class */ (function (_super) {
        tslib_1.__extends(CustomJSTransform, _super);
        function CustomJSTransform(attrs) {
            return _super.call(this, attrs) || this;
        }
        CustomJSTransform.init_CustomJSTransform = function () {
            this.define({
                args: [p.Any, {}],
                func: [p.String, ""],
                v_func: [p.String, ""],
                use_strict: [p.Boolean, false],
            });
        };
        Object.defineProperty(CustomJSTransform.prototype, "names", {
            get: function () {
                return object_1.keys(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJSTransform.prototype, "values", {
            get: function () {
                return object_1.values(this.args);
            },
            enumerable: true,
            configurable: true
        });
        CustomJSTransform.prototype._make_transform = function (name, func) {
            var code = this.use_strict ? string_1.use_strict(func) : func;
            return new (Function.bind.apply(Function, tslib_1.__spreadArrays([void 0], this.names, [name, "require", "exports", code])))();
        };
        Object.defineProperty(CustomJSTransform.prototype, "scalar_transform", {
            get: function () {
                return this._make_transform("x", this.func);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJSTransform.prototype, "vector_transform", {
            get: function () {
                return this._make_transform("xs", this.v_func);
            },
            enumerable: true,
            configurable: true
        });
        CustomJSTransform.prototype.compute = function (x) {
            return this.scalar_transform.apply(this, tslib_1.__spreadArrays(this.values, [x, require, {}]));
        };
        CustomJSTransform.prototype.v_compute = function (xs) {
            return this.vector_transform.apply(this, tslib_1.__spreadArrays(this.values, [xs, require, {}]));
        };
        return CustomJSTransform;
    }(transform_1.Transform));
    exports.CustomJSTransform = CustomJSTransform;
    CustomJSTransform.__name__ = "CustomJSTransform";
    CustomJSTransform.init_CustomJSTransform();
},
/* models/transforms/dodge.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var transform_1 = require(214) /* ./transform */;
    var factor_range_1 = require(184) /* ../ranges/factor_range */;
    var p = require(121) /* ../../core/properties */;
    var types_1 = require(109) /* ../../core/util/types */;
    var Dodge = /** @class */ (function (_super) {
        tslib_1.__extends(Dodge, _super);
        function Dodge(attrs) {
            return _super.call(this, attrs) || this;
        }
        Dodge.init_Dodge = function () {
            this.define({
                value: [p.Number, 0],
                range: [p.Instance],
            });
        };
        // XXX: this is repeated in ./jitter.ts
        Dodge.prototype.v_compute = function (xs0) {
            var xs;
            if (this.range instanceof factor_range_1.FactorRange)
                xs = this.range.v_synthetic(xs0);
            else if (types_1.isArrayableOf(xs0, types_1.isNumber))
                xs = xs0;
            else
                throw new Error("unexpected");
            var result = new Float64Array(xs.length);
            for (var i = 0; i < xs.length; i++) {
                var x = xs[i];
                result[i] = this._compute(x);
            }
            return result;
        };
        Dodge.prototype.compute = function (x) {
            if (this.range instanceof factor_range_1.FactorRange)
                return this._compute(this.range.synthetic(x));
            else if (types_1.isNumber(x))
                return this._compute(x);
            else
                throw new Error("unexpected");
        };
        Dodge.prototype._compute = function (x) {
            return x + this.value;
        };
        return Dodge;
    }(transform_1.Transform));
    exports.Dodge = Dodge;
    Dodge.__name__ = "Dodge";
    Dodge.init_Dodge();
},
/* models/transforms/interpolator.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var transform_1 = require(214) /* ./transform */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    var types_1 = require(109) /* ../../core/util/types */;
    var Interpolator = /** @class */ (function (_super) {
        tslib_1.__extends(Interpolator, _super);
        function Interpolator(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this._sorted_dirty = true;
            return _this;
        }
        Interpolator.init_Interpolator = function () {
            this.define({
                x: [p.Any],
                y: [p.Any],
                data: [p.Any],
                clip: [p.Boolean, true],
            });
        };
        Interpolator.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () { return _this._sorted_dirty = true; });
        };
        Interpolator.prototype.v_compute = function (xs) {
            var result = new Float64Array(xs.length);
            for (var i = 0; i < xs.length; i++) {
                var x = xs[i];
                result[i] = this.compute(x);
            }
            return result;
        };
        Interpolator.prototype.sort = function (descending) {
            if (descending === void 0) {
                descending = false;
            }
            if (!this._sorted_dirty)
                return;
            var tsx;
            var tsy;
            if (types_1.isString(this.x) && types_1.isString(this.y) && this.data != null) {
                var column_names = this.data.columns();
                if (!array_1.includes(column_names, this.x))
                    throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");
                if (!array_1.includes(column_names, this.y))
                    throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");
                tsx = this.data.get_column(this.x);
                tsy = this.data.get_column(this.y);
            }
            else if (types_1.isArray(this.x) && types_1.isArray(this.y)) {
                tsx = this.x;
                tsy = this.y;
            }
            else {
                throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");
            }
            if (tsx.length !== tsy.length)
                throw new Error("The length for x and y do not match");
            if (tsx.length < 2)
                throw new Error("x and y must have at least two elements to support interpolation");
            // The following sorting code is referenced from:
            // http://stackoverflow.com/questions/11499268/sort-two-arrays-the-same-way
            var list = [];
            for (var j in tsx) {
                list.push({ x: tsx[j], y: tsy[j] });
            }
            if (descending)
                list.sort(function (a, b) { return a.x > b.x ? -1 : (a.x == b.x ? 0 : 1); });
            else
                list.sort(function (a, b) { return a.x < b.x ? -1 : (a.x == b.x ? 0 : 1); });
            this._x_sorted = [];
            this._y_sorted = [];
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var _a = list_1[_i], x = _a.x, y = _a.y;
                this._x_sorted.push(x);
                this._y_sorted.push(y);
            }
            this._sorted_dirty = false;
        };
        return Interpolator;
    }(transform_1.Transform));
    exports.Interpolator = Interpolator;
    Interpolator.__name__ = "Interpolator";
    Interpolator.init_Interpolator();
},
/* models/transforms/jitter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var transform_1 = require(214) /* ./transform */;
    var factor_range_1 = require(184) /* ../ranges/factor_range */;
    var types_1 = require(109) /* ../../core/util/types */;
    var p = require(121) /* ../../core/properties */;
    var bokeh_math = require(111) /* ../../core/util/math */;
    var Jitter = /** @class */ (function (_super) {
        tslib_1.__extends(Jitter, _super);
        function Jitter(attrs) {
            return _super.call(this, attrs) || this;
        }
        Jitter.init_Jitter = function () {
            this.define({
                mean: [p.Number, 0],
                width: [p.Number, 1],
                distribution: [p.Distribution, 'uniform'],
                range: [p.Instance],
            });
            this.internal({
                previous_values: [p.Array],
            });
        };
        Jitter.prototype.v_compute = function (xs0) {
            if (this.previous_values != null && this.previous_values.length == xs0.length)
                return this.previous_values;
            var xs;
            if (this.range instanceof factor_range_1.FactorRange)
                xs = this.range.v_synthetic(xs0);
            else if (types_1.isArrayableOf(xs0, types_1.isNumber))
                xs = xs0;
            else
                throw new Error("unexpected");
            var result = new Float64Array(xs.length);
            for (var i = 0; i < xs.length; i++) {
                var x = xs[i];
                result[i] = this._compute(x);
            }
            this.previous_values = result;
            return result;
        };
        Jitter.prototype.compute = function (x) {
            if (this.range instanceof factor_range_1.FactorRange)
                return this._compute(this.range.synthetic(x));
            else if (types_1.isNumber(x))
                return this._compute(x);
            else
                throw new Error("unexpected");
        };
        Jitter.prototype._compute = function (x) {
            switch (this.distribution) {
                case "uniform":
                    return x + this.mean + (bokeh_math.random() - 0.5) * this.width;
                case "normal":
                    return x + bokeh_math.rnorm(this.mean, this.width);
            }
        };
        return Jitter;
    }(transform_1.Transform));
    exports.Jitter = Jitter;
    Jitter.__name__ = "Jitter";
    Jitter.init_Jitter();
},
/* models/transforms/linear_interpolator.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var array_1 = require(110) /* ../../core/util/array */;
    var interpolator_1 = require(220) /* ./interpolator */;
    var LinearInterpolator = /** @class */ (function (_super) {
        tslib_1.__extends(LinearInterpolator, _super);
        function LinearInterpolator(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearInterpolator.prototype.compute = function (x) {
            this.sort(false);
            if (this.clip) {
                if (x < this._x_sorted[0] || x > this._x_sorted[this._x_sorted.length - 1])
                    return NaN;
            }
            else {
                if (x < this._x_sorted[0])
                    return this._y_sorted[0];
                if (x > this._x_sorted[this._x_sorted.length - 1])
                    return this._y_sorted[this._y_sorted.length - 1];
            }
            if (x == this._x_sorted[0])
                return this._y_sorted[0];
            var ind = array_1.find_last_index(this._x_sorted, function (num) { return num < x; });
            var x1 = this._x_sorted[ind];
            var x2 = this._x_sorted[ind + 1];
            var y1 = this._y_sorted[ind];
            var y2 = this._y_sorted[ind + 1];
            return y1 + (((x - x1) / (x2 - x1)) * (y2 - y1));
        };
        return LinearInterpolator;
    }(interpolator_1.Interpolator));
    exports.LinearInterpolator = LinearInterpolator;
    LinearInterpolator.__name__ = "LinearInterpolator";
},
/* models/transforms/step_interpolator.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var interpolator_1 = require(220) /* ./interpolator */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    var StepInterpolator = /** @class */ (function (_super) {
        tslib_1.__extends(StepInterpolator, _super);
        function StepInterpolator(attrs) {
            return _super.call(this, attrs) || this;
        }
        StepInterpolator.init_StepInterpolator = function () {
            this.define({
                mode: [p.StepMode, "after"],
            });
        };
        StepInterpolator.prototype.compute = function (x) {
            this.sort(false);
            if (this.clip) {
                if (x < this._x_sorted[0] || x > this._x_sorted[this._x_sorted.length - 1])
                    return NaN;
            }
            else {
                if (x < this._x_sorted[0])
                    return this._y_sorted[0];
                if (x > this._x_sorted[this._x_sorted.length - 1])
                    return this._y_sorted[this._y_sorted.length - 1];
            }
            var ind;
            switch (this.mode) {
                case "after": {
                    ind = array_1.find_last_index(this._x_sorted, function (num) { return x >= num; });
                    break;
                }
                case "before": {
                    ind = array_1.find_index(this._x_sorted, function (num) { return x <= num; });
                    break;
                }
                case "center": {
                    var diffs = this._x_sorted.map(function (tx) { return Math.abs(tx - x); });
                    var mdiff_1 = array_1.min(diffs);
                    ind = array_1.find_index(diffs, function (num) { return mdiff_1 === num; });
                    break;
                }
                default:
                    throw new Error("unknown mode: " + this.mode);
            }
            return ind != -1 ? this._y_sorted[ind] : NaN;
        };
        return StepInterpolator;
    }(interpolator_1.Interpolator));
    exports.StepInterpolator = StepInterpolator;
    StepInterpolator.__name__ = "StepInterpolator";
    StepInterpolator.init_StepInterpolator();
},
/* models/scales/log_scale.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var scale_1 = require(216) /* ./scale */;
    var LogScale = /** @class */ (function (_super) {
        tslib_1.__extends(LogScale, _super);
        function LogScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogScale.prototype.compute = function (x) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var value;
            if (inter_factor == 0)
                value = 0;
            else {
                var _x = (Math.log(x) - inter_offset) / inter_factor;
                if (isFinite(_x))
                    value = _x * factor + offset;
                else
                    value = NaN;
            }
            return value;
        };
        LogScale.prototype.v_compute = function (xs) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var result = new Float64Array(xs.length);
            if (inter_factor == 0) {
                for (var i = 0; i < xs.length; i++)
                    result[i] = 0;
            }
            else {
                for (var i = 0; i < xs.length; i++) {
                    var _x = (Math.log(xs[i]) - inter_offset) / inter_factor;
                    var value = void 0;
                    if (isFinite(_x))
                        value = _x * factor + offset;
                    else
                        value = NaN;
                    result[i] = value;
                }
            }
            return result;
        };
        LogScale.prototype.invert = function (xprime) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var value = (xprime - offset) / factor;
            return Math.exp(inter_factor * value + inter_offset);
        };
        LogScale.prototype.v_invert = function (xprimes) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var result = new Float64Array(xprimes.length);
            for (var i = 0; i < xprimes.length; i++) {
                var value = (xprimes[i] - offset) / factor;
                result[i] = Math.exp(inter_factor * value + inter_offset);
            }
            return result;
        };
        LogScale.prototype._get_safe_factor = function (orig_start, orig_end) {
            var _a;
            var start = orig_start < 0 ? 0 : orig_start;
            var end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    _a = [1, 10], start = _a[0], end = _a[1];
                else {
                    var log_val = Math.log(start) / Math.log(10);
                    start = Math.pow(10, Math.floor(log_val));
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = Math.pow(10, Math.ceil(log_val));
                    else
                        end = Math.pow(10, Math.ceil(log_val) + 1);
                }
            }
            return [start, end];
        };
        /*protected*/ LogScale.prototype._compute_state = function () {
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var screen_range = target_end - target_start;
            var _a = this._get_safe_factor(source_start, source_end), start = _a[0], end = _a[1];
            var inter_factor;
            var inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end) - Math.log(start);
                inter_offset = Math.log(start);
            }
            var factor = screen_range;
            var offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        };
        return LogScale;
    }(scale_1.Scale));
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* models/ranges/range1d.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var range_1 = require(185) /* ./range */;
    var p = require(121) /* ../../core/properties */;
    var Range1d = /** @class */ (function (_super) {
        tslib_1.__extends(Range1d, _super);
        function Range1d(attrs) {
            return _super.call(this, attrs) || this;
        }
        Range1d.init_Range1d = function () {
            this.define({
                start: [p.Number, 0],
                end: [p.Number, 1],
                reset_start: [p.Number],
                reset_end: [p.Number],
            });
        };
        Range1d.prototype._set_auto_bounds = function () {
            if (this.bounds == 'auto') {
                var min = Math.min(this.reset_start, this.reset_end);
                var max = Math.max(this.reset_start, this.reset_end);
                this.setv({ bounds: [min, max] }, { silent: true });
            }
        };
        Range1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.reset_start == null) {
                this.reset_start = this.start;
            }
            if (this.reset_end == null) {
                this.reset_end = this.end;
            }
            this._set_auto_bounds();
        };
        Object.defineProperty(Range1d.prototype, "min", {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Range1d.prototype, "max", {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Range1d.prototype.reset = function () {
            this._set_auto_bounds();
            if (this.start != this.reset_start || this.end != this.reset_end)
                this.setv({ start: this.reset_start, end: this.reset_end });
            else
                this.change.emit();
        };
        return Range1d;
    }(range_1.Range));
    exports.Range1d = Range1d;
    Range1d.__name__ = "Range1d";
    Range1d.init_Range1d();
},
/* core/util/text.js */ function _(require, module, exports) {
    var dom_1 = require(163) /* ../dom */;
    var cache = {};
    function measure_font(font) {
        if (cache[font] != null)
            return cache[font];
        var text = dom_1.span({ style: { font: font } }, "Hg");
        var block = dom_1.div({ style: { display: "inline-block", width: "1px", height: "0px" } });
        var elem = dom_1.div({}, text, block);
        document.body.appendChild(elem);
        try {
            block.style.verticalAlign = "baseline";
            var ascent = dom_1.offset(block).top - dom_1.offset(text).top;
            block.style.verticalAlign = "bottom";
            var height = dom_1.offset(block).top - dom_1.offset(text).top;
            var result = { height: height, ascent: ascent, descent: height - ascent };
            cache[font] = result;
            return result;
        }
        finally {
            document.body.removeChild(elem);
        }
    }
    exports.measure_font = measure_font;
    var _cache = {};
    function measure_text(text, font) {
        var text_cache = _cache[font];
        if (text_cache != null) {
            var size = text_cache[text];
            if (size != null)
                return size;
        }
        else
            _cache[font] = {};
        var el = dom_1.div({ style: { display: "inline-block", "white-space": "nowrap", font: font } }, text);
        document.body.appendChild(el);
        try {
            var _a = el.getBoundingClientRect(), width = _a.width, height = _a.height;
            _cache[font][text] = { width: width, height: height };
            return { width: width, height: height };
        }
        finally {
            document.body.removeChild(el);
        }
    }
    exports.measure_text = measure_text;
},
/* models/annotations/label.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var text_annotation_1 = require(228) /* ./text_annotation */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var LabelView = /** @class */ (function (_super) {
        tslib_1.__extends(LabelView, _super);
        function LabelView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LabelView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals.warm_cache();
        };
        LabelView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            var _a = ctx.measureText(this.model.text), width = _a.width, ascent = _a.ascent;
            return { width: width, height: ascent };
        };
        LabelView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.undisplay(this.el);
            if (!this.model.visible)
                return;
            // Here because AngleSpec does units transform and label doesn't support specs
            var angle;
            switch (this.model.angle_units) {
                case "rad": {
                    angle = -this.model.angle;
                    break;
                }
                case "deg": {
                    angle = (-this.model.angle * Math.PI) / 180.0;
                    break;
                }
                default:
                    throw new Error("unreachable code");
            }
            var panel = this.panel != null ? this.panel : this.plot_view.frame;
            var xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            var yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            var sx = this.model.x_units == "data" ? xscale.compute(this.model.x) : panel.xview.compute(this.model.x);
            var sy = this.model.y_units == "data" ? yscale.compute(this.model.y) : panel.yview.compute(this.model.y);
            sx += this.model.x_offset;
            sy -= this.model.y_offset;
            var draw = this.model.render_mode == 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.plot_view.canvas_view.ctx, this.model.text, sx, sy, angle);
        };
        return LabelView;
    }(text_annotation_1.TextAnnotationView));
    exports.LabelView = LabelView;
    LabelView.__name__ = "LabelView";
    var Label = /** @class */ (function (_super) {
        tslib_1.__extends(Label, _super);
        function Label(attrs) {
            return _super.call(this, attrs) || this;
        }
        Label.init_Label = function () {
            this.prototype.default_view = LabelView;
            this.mixins(['text', 'line:border_', 'fill:background_']);
            this.define({
                x: [p.Number],
                x_units: [p.SpatialUnits, 'data'],
                y: [p.Number],
                y_units: [p.SpatialUnits, 'data'],
                text: [p.String],
                angle: [p.Angle, 0],
                angle_units: [p.AngleUnits, 'rad'],
                x_offset: [p.Number, 0],
                y_offset: [p.Number, 0],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.override({
                background_fill_color: null,
                border_line_color: null,
            });
        };
        return Label;
    }(text_annotation_1.TextAnnotation));
    exports.Label = Label;
    Label.__name__ = "Label";
    Label.init_Label();
},
/* models/annotations/text_annotation.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var text_1 = require(226) /* ../../core/util/text */;
    var annotations_1 = require(202) /* ../../styles/annotations */;
    var TextAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(TextAnnotationView, _super);
        function TextAnnotationView() {
            var _this = _super.apply(this, arguments) || this;
            _this.rotate = true;
            return _this;
        }
        TextAnnotationView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.model.render_mode == 'css') {
                this.el.classList.add(annotations_1.bk_annotation);
                this.plot_view.canvas_overlays.appendChild(this.el);
            }
        };
        TextAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () { return _this.render(); });
            }
            else {
                this.connect(this.model.change, function () { return _this.plot_view.request_render(); });
            }
        };
        TextAnnotationView.prototype._calculate_text_dimensions = function (ctx, text) {
            var width = ctx.measureText(text).width;
            var height = text_1.measure_font(this.visuals.text.font_value()).height;
            return [width, height];
        };
        TextAnnotationView.prototype._calculate_bounding_box_dimensions = function (ctx, text) {
            var _a = this._calculate_text_dimensions(ctx, text), width = _a[0], height = _a[1];
            var x_offset;
            switch (ctx.textAlign) {
                case 'left':
                    x_offset = 0;
                    break;
                case 'center':
                    x_offset = -width / 2;
                    break;
                case 'right':
                    x_offset = -width;
                    break;
                default:
                    throw new Error("unreachable code");
            }
            // guestimated from https://www.w3.org/TR/2dcontext/#dom-context-2d-textbaseline
            var y_offset;
            switch (ctx.textBaseline) {
                case 'top':
                    y_offset = 0.0;
                    break;
                case 'middle':
                    y_offset = -0.5 * height;
                    break;
                case 'bottom':
                    y_offset = -1.0 * height;
                    break;
                case 'alphabetic':
                    y_offset = -0.8 * height;
                    break;
                case 'hanging':
                    y_offset = -0.17 * height;
                    break;
                case 'ideographic':
                    y_offset = -0.83 * height;
                    break;
                default:
                    throw new Error("unreachable code");
            }
            return [x_offset, y_offset, width, height];
        };
        TextAnnotationView.prototype._canvas_text = function (ctx, text, sx, sy, angle) {
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            if (angle)
                ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_value(ctx);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        };
        TextAnnotationView.prototype._css_text = function (ctx, text, sx, sy, angle) {
            dom_1.undisplay(this.el);
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector string-style ("8 4 8") line dashing for css mode
            var ld = this.visuals.border_line.line_dash.value();
            var line_dash = ld.length < 2 ? "solid" : "dashed";
            this.visuals.border_line.set_value(ctx);
            this.visuals.background_fill.set_value(ctx);
            this.el.style.position = 'absolute';
            this.el.style.left = sx + bbox_dims[0] + "px";
            this.el.style.top = sy + bbox_dims[1] + "px";
            this.el.style.color = "" + this.visuals.text.text_color.value();
            this.el.style.opacity = "" + this.visuals.text.text_alpha.value();
            this.el.style.font = "" + this.visuals.text.font_value();
            this.el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            if (angle) {
                this.el.style.transform = "rotate(" + angle + "rad)";
            }
            if (this.visuals.background_fill.doit) {
                this.el.style.backgroundColor = "" + this.visuals.background_fill.color_value();
            }
            if (this.visuals.border_line.doit) {
                this.el.style.borderStyle = "" + line_dash;
                this.el.style.borderWidth = this.visuals.border_line.line_width.value() + "px";
                this.el.style.borderColor = "" + this.visuals.border_line.color_value();
            }
            this.el.textContent = text;
            dom_1.display(this.el);
        };
        return TextAnnotationView;
    }(annotation_1.AnnotationView));
    exports.TextAnnotationView = TextAnnotationView;
    TextAnnotationView.__name__ = "TextAnnotationView";
    var TextAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(TextAnnotation, _super);
        function TextAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        TextAnnotation.init_TextAnnotation = function () {
            this.define({
                render_mode: [p.RenderMode, "canvas"],
            });
        };
        return TextAnnotation;
    }(annotation_1.Annotation));
    exports.TextAnnotation = TextAnnotation;
    TextAnnotation.__name__ = "TextAnnotation";
    TextAnnotation.init_TextAnnotation();
},
/* models/annotations/label_set.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var text_annotation_1 = require(228) /* ./text_annotation */;
    var column_data_source_1 = require(170) /* ../sources/column_data_source */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var annotations_1 = require(202) /* ../../styles/annotations */;
    var LabelSetView = /** @class */ (function (_super) {
        tslib_1.__extends(LabelSetView, _super);
        function LabelSetView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LabelSetView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.set_data(this.model.source);
            if (this.model.render_mode == 'css') {
                for (var i = 0, end = this._text.length; i < end; i++) {
                    var el = dom_1.div({ class: annotations_1.bk_annotation_child, style: { display: "none" } });
                    this.el.appendChild(el);
                }
            }
        };
        LabelSetView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.streaming, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.patching, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.change, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
            }
            else {
                this.connect(this.model.change, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.streaming, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.patching, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.change, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
            }
        };
        LabelSetView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
        };
        LabelSetView.prototype._map_data = function () {
            var xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            var yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            var panel = this.panel != null ? this.panel : this.plot_view.frame;
            var sx = this.model.x_units == "data" ? xscale.v_compute(this._x) : panel.xview.v_compute(this._x);
            var sy = this.model.y_units == "data" ? yscale.v_compute(this._y) : panel.yview.v_compute(this._y);
            return [sx, sy];
        };
        LabelSetView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.undisplay(this.el);
            if (!this.model.visible)
                return;
            var draw = this.model.render_mode == 'canvas' ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this);
            var ctx = this.plot_view.canvas_view.ctx;
            var _a = this._map_data(), sx = _a[0], sy = _a[1];
            for (var i = 0, end = this._text.length; i < end; i++) {
                draw(ctx, i, this._text[i], sx[i] + this._x_offset[i], sy[i] - this._y_offset[i], this._angle[i]);
            }
        };
        LabelSetView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            var _a = ctx.measureText(this._text[0]), width = _a.width, ascent = _a.ascent;
            return { width: width, height: ascent };
        };
        LabelSetView.prototype._v_canvas_text = function (ctx, i, text, sx, sy, angle) {
            this.visuals.text.set_vectorize(ctx, i);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_vectorize(ctx, i);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_vectorize(ctx, i);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        };
        LabelSetView.prototype._v_css_text = function (ctx, i, text, sx, sy, angle) {
            var el = this.el.children[i];
            el.textContent = text;
            this.visuals.text.set_vectorize(ctx, i);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector-style ("8 4 8") line dashing for css mode
            var ld = this.visuals.border_line.line_dash.value();
            var line_dash = ld.length < 2 ? "solid" : "dashed";
            this.visuals.border_line.set_vectorize(ctx, i);
            this.visuals.background_fill.set_vectorize(ctx, i);
            el.style.position = 'absolute';
            el.style.left = sx + bbox_dims[0] + "px";
            el.style.top = sy + bbox_dims[1] + "px";
            el.style.color = "" + this.visuals.text.text_color.value();
            el.style.opacity = "" + this.visuals.text.text_alpha.value();
            el.style.font = "" + this.visuals.text.font_value();
            el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            if (angle) {
                el.style.transform = "rotate(" + angle + "rad)";
            }
            if (this.visuals.background_fill.doit) {
                el.style.backgroundColor = "" + this.visuals.background_fill.color_value();
            }
            if (this.visuals.border_line.doit) {
                el.style.borderStyle = "" + line_dash;
                el.style.borderWidth = this.visuals.border_line.line_width.value() + "px";
                el.style.borderColor = "" + this.visuals.border_line.color_value();
            }
            dom_1.display(el);
        };
        return LabelSetView;
    }(text_annotation_1.TextAnnotationView));
    exports.LabelSetView = LabelSetView;
    LabelSetView.__name__ = "LabelSetView";
    var LabelSet = /** @class */ (function (_super) {
        tslib_1.__extends(LabelSet, _super);
        function LabelSet(attrs) {
            return _super.call(this, attrs) || this;
        }
        LabelSet.init_LabelSet = function () {
            this.prototype.default_view = LabelSetView;
            this.mixins(['text', 'line:border_', 'fill:background_']);
            this.define({
                x: [p.NumberSpec],
                y: [p.NumberSpec],
                x_units: [p.SpatialUnits, 'data'],
                y_units: [p.SpatialUnits, 'data'],
                text: [p.StringSpec, { field: "text" }],
                angle: [p.AngleSpec, 0],
                x_offset: [p.NumberSpec, { value: 0 }],
                y_offset: [p.NumberSpec, { value: 0 }],
                source: [p.Instance, function () { return new column_data_source_1.ColumnDataSource(); }],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.override({
                background_fill_color: null,
                border_line_color: null,
            });
        };
        return LabelSet;
    }(text_annotation_1.TextAnnotation));
    exports.LabelSet = LabelSet;
    LabelSet.__name__ = "LabelSet";
    LabelSet.init_LabelSet();
},
/* models/annotations/legend.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var p = require(121) /* ../../core/properties */;
    var signaling_1 = require(116) /* ../../core/signaling */;
    var text_1 = require(226) /* ../../core/util/text */;
    var bbox_1 = require(181) /* ../../core/util/bbox */;
    var array_1 = require(110) /* ../../core/util/array */;
    var object_1 = require(125) /* ../../core/util/object */;
    var types_1 = require(109) /* ../../core/util/types */;
    var LegendView = /** @class */ (function (_super) {
        tslib_1.__extends(LegendView, _super);
        function LegendView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LegendView.prototype.cursor = function (_sx, _sy) {
            return this.model.click_policy == "none" ? null : "pointer";
        };
        Object.defineProperty(LegendView.prototype, "legend_padding", {
            get: function () {
                return this.visuals.border_line.line_color.value() != null ? this.model.padding : 0;
            },
            enumerable: true,
            configurable: true
        });
        LegendView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.plot_view.request_render(); });
            this.connect(this.model.item_change, function () { return _this.plot_view.request_render(); });
        };
        LegendView.prototype.compute_legend_bbox = function () {
            var legend_names = this.model.get_legend_names();
            var _a = this.model, glyph_height = _a.glyph_height, glyph_width = _a.glyph_width;
            var _b = this.model, label_height = _b.label_height, label_width = _b.label_width;
            this.max_label_height = array_1.max([text_1.measure_font(this.visuals.label_text.font_value()).height, label_height, glyph_height]);
            // this is to measure text properties
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this.visuals.label_text.set_value(ctx);
            this.text_widths = {};
            for (var _i = 0, legend_names_1 = legend_names; _i < legend_names_1.length; _i++) {
                var name = legend_names_1[_i];
                this.text_widths[name] = array_1.max([ctx.measureText(name).width, label_width]);
            }
            this.visuals.title_text.set_value(ctx);
            this.title_height = this.model.title ? text_1.measure_font(this.visuals.title_text.font_value()).height + this.model.title_standoff : 0;
            this.title_width = this.model.title ? ctx.measureText(this.model.title).width : 0;
            ctx.restore();
            var max_label_width = Math.max(array_1.max(object_1.values(this.text_widths)), 0);
            var legend_margin = this.model.margin;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var legend_height, legend_width;
            if (this.model.orientation == "vertical") {
                legend_height = legend_names.length * this.max_label_height + Math.max(legend_names.length - 1, 0) * legend_spacing + 2 * legend_padding + this.title_height;
                legend_width = array_1.max([(max_label_width + glyph_width + label_standoff + 2 * legend_padding), this.title_width + 2 * legend_padding]);
            }
            else {
                var item_width = 2 * legend_padding + Math.max(legend_names.length - 1, 0) * legend_spacing;
                for (var name in this.text_widths) {
                    var width = this.text_widths[name];
                    item_width += array_1.max([width, label_width]) + glyph_width + label_standoff;
                }
                legend_width = array_1.max([this.title_width + 2 * legend_padding, item_width]);
                legend_height = this.max_label_height + this.title_height + 2 * legend_padding;
            }
            var panel = this.panel != null ? this.panel : this.plot_view.frame;
            var _c = panel.bbox.ranges, hr = _c[0], vr = _c[1];
            var location = this.model.location;
            var sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                    case 'top_left':
                        sx = hr.start + legend_margin;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.start + legend_margin;
                        break;
                    case 'bottom_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_left':
                        sx = hr.start + legend_margin;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'center_left':
                        sx = hr.start + legend_margin;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    default:
                        throw new Error("unreachable code");
                }
            }
            else if (types_1.isArray(location) && location.length == 2) {
                var vx = location[0], vy = location[1];
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            }
            else
                throw new Error("unreachable code");
            return new bbox_1.BBox({ left: sx, top: sy, width: legend_width, height: legend_height });
        };
        LegendView.prototype.interactive_bbox = function () {
            return this.compute_legend_bbox();
        };
        LegendView.prototype.interactive_hit = function (sx, sy) {
            var bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        };
        LegendView.prototype.on_hit = function (sx, sy) {
            var _a, _b;
            var yoffset;
            var glyph_width = this.model.glyph_width;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var xoffset = (yoffset = legend_padding);
            var legend_bbox = this.compute_legend_bbox();
            var vertical = this.model.orientation == "vertical";
            for (var _i = 0, _c = this.model.items; _i < _c.length; _i++) {
                var item = _c[_i];
                var labels = item.get_labels_list_from_label_prop();
                for (var _d = 0, labels_1 = labels; _d < labels_1.length; _d++) {
                    var label = labels_1[_d];
                    var x1 = legend_bbox.x + xoffset;
                    var y1 = legend_bbox.y + yoffset + this.title_height;
                    var w = void 0, h = void 0;
                    if (vertical)
                        _a = [legend_bbox.width - 2 * legend_padding, this.max_label_height], w = _a[0], h = _a[1];
                    else
                        _b = [this.text_widths[label] + glyph_width + label_standoff, this.max_label_height], w = _b[0], h = _b[1];
                    var bbox = new bbox_1.BBox({ left: x1, top: y1, width: w, height: h });
                    if (bbox.contains(sx, sy)) {
                        switch (this.model.click_policy) {
                            case "hide": {
                                for (var _e = 0, _f = item.renderers; _e < _f.length; _e++) {
                                    var r = _f[_e];
                                    r.visible = !r.visible;
                                }
                                break;
                            }
                            case "mute": {
                                for (var _g = 0, _h = item.renderers; _g < _h.length; _g++) {
                                    var r = _h[_g];
                                    r.muted = !r.muted;
                                }
                                break;
                            }
                        }
                        return true;
                    }
                    if (vertical)
                        yoffset += this.max_label_height + legend_spacing;
                    else
                        xoffset += this.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                }
            }
            return false;
        };
        LegendView.prototype.render = function () {
            if (!this.model.visible)
                return;
            if (this.model.items.length == 0)
                return;
            // set a backref on render so that items can later signal item_change upates
            // on the model to trigger a re-render
            for (var _i = 0, _a = this.model.items; _i < _a.length; _i++) {
                var item = _a[_i];
                item.legend = this.model;
            }
            var ctx = this.plot_view.canvas_view.ctx;
            var bbox = this.compute_legend_bbox();
            ctx.save();
            this._draw_legend_box(ctx, bbox);
            this._draw_legend_items(ctx, bbox);
            if (this.model.title)
                this._draw_title(ctx, bbox);
            ctx.restore();
        };
        LegendView.prototype._draw_legend_box = function (ctx, bbox) {
            ctx.beginPath();
            ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
            this.visuals.background_fill.set_value(ctx);
            ctx.fill();
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
        };
        LegendView.prototype._draw_legend_items = function (ctx, bbox) {
            var _this = this;
            var _a = this.model, glyph_width = _a.glyph_width, glyph_height = _a.glyph_height;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var xoffset = legend_padding;
            var yoffset = legend_padding;
            var vertical = this.model.orientation == "vertical";
            var _loop_1 = function (item) {
                var _a, _b;
                var labels = item.get_labels_list_from_label_prop();
                var field = item.get_field_from_label_prop();
                if (labels.length == 0)
                    return "continue";
                var active = (function () {
                    switch (_this.model.click_policy) {
                        case "none": return true;
                        case "hide": return array_1.every(item.renderers, function (r) { return r.visible; });
                        case "mute": return array_1.every(item.renderers, function (r) { return !r.muted; });
                    }
                })();
                for (var _i = 0, labels_2 = labels; _i < labels_2.length; _i++) {
                    var label = labels_2[_i];
                    var x1 = bbox.x + xoffset;
                    var y1 = bbox.y + yoffset + this_1.title_height;
                    var x2 = x1 + glyph_width;
                    var y2 = y1 + glyph_height;
                    if (vertical)
                        yoffset += this_1.max_label_height + legend_spacing;
                    else
                        xoffset += this_1.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                    this_1.visuals.label_text.set_value(ctx);
                    ctx.fillText(label, x2 + label_standoff, y1 + this_1.max_label_height / 2.0);
                    for (var _c = 0, _d = item.renderers; _c < _d.length; _c++) {
                        var r = _d[_c];
                        var view = this_1.plot_view.renderer_views[r.id];
                        view.draw_legend(ctx, x1, x2, y1, y2, field, label, item.index);
                    }
                    if (!active) {
                        var w = void 0, h = void 0;
                        if (vertical)
                            _a = [bbox.width - 2 * legend_padding, this_1.max_label_height], w = _a[0], h = _a[1];
                        else
                            _b = [this_1.text_widths[label] + glyph_width + label_standoff, this_1.max_label_height], w = _b[0], h = _b[1];
                        ctx.beginPath();
                        ctx.rect(x1, y1, w, h);
                        this_1.visuals.inactive_fill.set_value(ctx);
                        ctx.fill();
                    }
                }
            };
            var this_1 = this;
            for (var _i = 0, _b = this.model.items; _i < _b.length; _i++) {
                var item = _b[_i];
                _loop_1(item);
            }
        };
        LegendView.prototype._draw_title = function (ctx, bbox) {
            if (!this.visuals.title_text.doit)
                return;
            ctx.save();
            ctx.translate(bbox.x0, bbox.y0 + this.title_height);
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(this.model.title, this.legend_padding, this.legend_padding - this.model.title_standoff);
            ctx.restore();
        };
        LegendView.prototype._get_size = function () {
            var _a = this.compute_legend_bbox(), width = _a.width, height = _a.height;
            return {
                width: width + 2 * this.model.margin,
                height: height + 2 * this.model.margin,
            };
        };
        return LegendView;
    }(annotation_1.AnnotationView));
    exports.LegendView = LegendView;
    LegendView.__name__ = "LegendView";
    var Legend = /** @class */ (function (_super) {
        tslib_1.__extends(Legend, _super);
        function Legend(attrs) {
            return _super.call(this, attrs) || this;
        }
        Legend.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.item_change = new signaling_1.Signal0(this, "item_change");
        };
        Legend.init_Legend = function () {
            this.prototype.default_view = LegendView;
            this.mixins([
                'text:label_',
                'text:title_',
                'fill:inactive_',
                'line:border_',
                'fill:background_',
            ]);
            this.define({
                orientation: [p.Orientation, 'vertical'],
                location: [p.Any, 'top_right'],
                title: [p.String],
                title_standoff: [p.Number, 5],
                label_standoff: [p.Number, 5],
                glyph_height: [p.Number, 20],
                glyph_width: [p.Number, 20],
                label_height: [p.Number, 20],
                label_width: [p.Number, 20],
                margin: [p.Number, 10],
                padding: [p.Number, 10],
                spacing: [p.Number, 3],
                items: [p.Array, []],
                click_policy: [p.Any, "none"],
            });
            this.override({
                border_line_color: "#e5e5e5",
                border_line_alpha: 0.5,
                border_line_width: 1,
                background_fill_color: "#ffffff",
                background_fill_alpha: 0.95,
                inactive_fill_color: "white",
                inactive_fill_alpha: 0.7,
                label_text_font_size: "10pt",
                label_text_baseline: "middle",
                title_text_font_size: "10pt",
                title_text_font_style: "italic",
            });
        };
        Legend.prototype.get_legend_names = function () {
            var legend_names = [];
            for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
                var item = _a[_i];
                var labels = item.get_labels_list_from_label_prop();
                legend_names.push.apply(legend_names, labels);
            }
            return legend_names;
        };
        return Legend;
    }(annotation_1.Annotation));
    exports.Legend = Legend;
    Legend.__name__ = "Legend";
    Legend.init_Legend();
},
/* models/annotations/legend_item.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var columnar_data_source_1 = require(171) /* ../sources/columnar_data_source */;
    var vectorization_1 = require(232) /* ../../core/vectorization */;
    var p = require(121) /* ../../core/properties */;
    var logging_1 = require(167) /* ../../core/logging */;
    var array_1 = require(110) /* ../../core/util/array */;
    var LegendItem = /** @class */ (function (_super) {
        tslib_1.__extends(LegendItem, _super);
        function LegendItem(attrs) {
            return _super.call(this, attrs) || this;
        }
        LegendItem.init_LegendItem = function () {
            this.define({
                label: [p.StringSpec, null],
                renderers: [p.Array, []],
                index: [p.Number, null],
            });
        };
        /*protected*/ LegendItem.prototype._check_data_sources_on_renderers = function () {
            var field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                var source = this.renderers[0].data_source;
                if (source != null) {
                    for (var _i = 0, _a = this.renderers; _i < _a.length; _i++) {
                        var r = _a[_i];
                        if (r.data_source != source) {
                            return false;
                        }
                    }
                }
            }
            return true;
        };
        /*protected*/ LegendItem.prototype._check_field_label_on_data_source = function () {
            var field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                var source = this.renderers[0].data_source;
                if (source != null && !array_1.includes(source.columns(), field)) {
                    return false;
                }
            }
            return true;
        };
        LegendItem.prototype.initialize = function () {
            var _this = this;
            _super.prototype.initialize.call(this);
            this.legend = null;
            this.connect(this.change, function () {
                if (_this.legend != null)
                    _this.legend.item_change.emit();
            });
            // Validate data_sources match
            var data_source_validation = this._check_data_sources_on_renderers();
            if (!data_source_validation)
                logging_1.logger.error("Non matching data sources on legend item renderers");
            // Validate label in data_source
            var field_validation = this._check_field_label_on_data_source();
            if (!field_validation)
                logging_1.logger.error("Bad column name on label: " + this.label);
        };
        LegendItem.prototype.get_field_from_label_prop = function () {
            var label = this.label;
            return vectorization_1.isField(label) ? label.field : null;
        };
        LegendItem.prototype.get_labels_list_from_label_prop = function () {
            // Always return a list of the labels
            if (vectorization_1.isValue(this.label)) {
                var value = this.label.value;
                return value != null ? [value] : [];
            }
            var field = this.get_field_from_label_prop();
            if (field != null) {
                var source = void 0;
                if (this.renderers[0] && this.renderers[0].data_source != null)
                    source = this.renderers[0].data_source;
                else
                    return ["No source found"];
                if (source instanceof columnar_data_source_1.ColumnarDataSource) {
                    var data = source.get_column(field);
                    if (data != null)
                        return array_1.uniq(Array.from(data));
                    else
                        return ["Invalid field"];
                }
            }
            return [];
        };
        return LegendItem;
    }(model_1.Model));
    exports.LegendItem = LegendItem;
    LegendItem.__name__ = "LegendItem";
    LegendItem.init_LegendItem();
},
/* core/vectorization.js */ function _(require, module, exports) {
    var types_1 = require(109) /* ./util/types */;
    function isValue(obj) {
        return types_1.isPlainObject(obj) && "value" in obj;
    }
    exports.isValue = isValue;
    function isField(obj) {
        return types_1.isPlainObject(obj) && "field" in obj;
    }
    exports.isField = isField;
},
/* models/annotations/poly_annotation.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var signaling_1 = require(116) /* ../../core/signaling */;
    var p = require(121) /* ../../core/properties */;
    var PolyAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(PolyAnnotationView, _super);
        function PolyAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PolyAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            this.connect(this.model.change, function () { return _this.plot_view.request_render(); });
            this.connect(this.model.data_update, function () { return _this.plot_view.request_render(); });
        };
        PolyAnnotationView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var _a = this.model, xs = _a.xs, ys = _a.ys;
            if (xs.length != ys.length)
                return;
            if (xs.length < 3 || ys.length < 3)
                return;
            var frame = this.plot_view.frame;
            var ctx = this.plot_view.canvas_view.ctx;
            for (var i = 0, end = xs.length; i < end; i++) {
                var sx = void 0;
                if (this.model.xs_units == 'screen')
                    sx = this.model.screen ? xs[i] : frame.xview.compute(xs[i]);
                else
                    throw new Error("not implemented");
                var sy = void 0;
                if (this.model.ys_units == 'screen')
                    sy = this.model.screen ? ys[i] : frame.yview.compute(ys[i]);
                else
                    throw new Error("not implemented");
                if (i == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx, sy);
                }
                else {
                    ctx.lineTo(sx, sy);
                }
            }
            ctx.closePath();
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
        };
        return PolyAnnotationView;
    }(annotation_1.AnnotationView));
    exports.PolyAnnotationView = PolyAnnotationView;
    PolyAnnotationView.__name__ = "PolyAnnotationView";
    var PolyAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(PolyAnnotation, _super);
        function PolyAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        PolyAnnotation.init_PolyAnnotation = function () {
            this.prototype.default_view = PolyAnnotationView;
            this.mixins(['line', 'fill']);
            this.define({
                xs: [p.Array, []],
                xs_units: [p.SpatialUnits, 'data'],
                ys: [p.Array, []],
                ys_units: [p.SpatialUnits, 'data'],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.internal({
                screen: [p.Boolean, false],
            });
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        };
        PolyAnnotation.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.data_update = new signaling_1.Signal0(this, "data_update");
        };
        PolyAnnotation.prototype.update = function (_a) {
            var xs = _a.xs, ys = _a.ys;
            this.setv({ xs: xs, ys: ys, screen: true }, { silent: true });
            this.data_update.emit();
        };
        return PolyAnnotation;
    }(annotation_1.Annotation));
    exports.PolyAnnotation = PolyAnnotation;
    PolyAnnotation.__name__ = "PolyAnnotation";
    PolyAnnotation.init_PolyAnnotation();
},
/* models/annotations/slope.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var p = require(121) /* ../../core/properties */;
    var SlopeView = /** @class */ (function (_super) {
        tslib_1.__extends(SlopeView, _super);
        function SlopeView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SlopeView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
        };
        SlopeView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.plot_view.request_render(); });
        };
        SlopeView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._draw_slope();
        };
        SlopeView.prototype._draw_slope = function () {
            var gradient = this.model.gradient;
            var y_intercept = this.model.y_intercept;
            if (gradient == null || y_intercept == null) {
                return;
            }
            var frame = this.plot_view.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var sy_start = frame._top.value;
            var sy_end = sy_start + frame._height.value;
            var y_start = yscale.invert(sy_start);
            var y_end = yscale.invert(sy_end);
            var x_start = (y_start - y_intercept) / gradient;
            var x_end = (y_end - y_intercept) / gradient;
            var sx_start = xscale.compute(x_start);
            var sx_end = xscale.compute(x_end);
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            ctx.beginPath();
            this.visuals.line.set_value(ctx);
            ctx.moveTo(sx_start, sy_start);
            ctx.lineTo(sx_end, sy_end);
            ctx.stroke();
            ctx.restore();
        };
        return SlopeView;
    }(annotation_1.AnnotationView));
    exports.SlopeView = SlopeView;
    SlopeView.__name__ = "SlopeView";
    var Slope = /** @class */ (function (_super) {
        tslib_1.__extends(Slope, _super);
        function Slope(attrs) {
            return _super.call(this, attrs) || this;
        }
        Slope.init_Slope = function () {
            this.prototype.default_view = SlopeView;
            this.mixins(['line']);
            this.define({
                gradient: [p.Number, null],
                y_intercept: [p.Number, null],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.override({
                line_color: 'black',
            });
        };
        return Slope;
    }(annotation_1.Annotation));
    exports.Slope = Slope;
    Slope.__name__ = "Slope";
    Slope.init_Slope();
},
/* models/annotations/span.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var SpanView = /** @class */ (function (_super) {
        tslib_1.__extends(SpanView, _super);
        function SpanView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SpanView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.style.position = "absolute";
            dom_1.undisplay(this.el);
        };
        SpanView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.for_hover)
                this.connect(this.model.properties.computed_location.change, function () { return _this._draw_span(); });
            else {
                if (this.model.render_mode == 'canvas') {
                    this.connect(this.model.change, function () { return _this.plot_view.request_render(); });
                    this.connect(this.model.properties.location.change, function () { return _this.plot_view.request_render(); });
                }
                else {
                    this.connect(this.model.change, function () { return _this.render(); });
                    this.connect(this.model.properties.location.change, function () { return _this._draw_span(); });
                }
            }
        };
        SpanView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode == 'css')
                dom_1.undisplay(this.el);
            if (!this.model.visible)
                return;
            this._draw_span();
        };
        SpanView.prototype._draw_span = function () {
            var _this = this;
            var loc = this.model.for_hover ? this.model.computed_location : this.model.location;
            if (loc == null) {
                dom_1.undisplay(this.el);
                return;
            }
            var frame = this.plot_view.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var _calc_dim = function (scale, view) {
                if (_this.model.for_hover)
                    return _this.model.computed_location;
                else {
                    if (_this.model.location_units == 'data')
                        return scale.compute(loc);
                    else
                        return view.compute(loc);
                }
            };
            var height, sleft, stop, width;
            if (this.model.dimension == 'width') {
                stop = _calc_dim(yscale, frame.yview);
                sleft = frame._left.value;
                width = frame._width.value;
                height = this.model.properties.line_width.value();
            }
            else {
                stop = frame._top.value;
                sleft = _calc_dim(xscale, frame.xview);
                width = this.model.properties.line_width.value();
                height = frame._height.value;
            }
            if (this.model.render_mode == "css") {
                this.el.style.top = stop + "px";
                this.el.style.left = sleft + "px";
                this.el.style.width = width + "px";
                this.el.style.height = height + "px";
                this.el.style.backgroundColor = this.model.properties.line_color.value();
                this.el.style.opacity = this.model.properties.line_alpha.value();
                dom_1.display(this.el);
            }
            else if (this.model.render_mode == "canvas") {
                var ctx = this.plot_view.canvas_view.ctx;
                ctx.save();
                ctx.beginPath();
                this.visuals.line.set_value(ctx);
                ctx.moveTo(sleft, stop);
                if (this.model.dimension == "width") {
                    ctx.lineTo(sleft + width, stop);
                }
                else {
                    ctx.lineTo(sleft, stop + height);
                }
                ctx.stroke();
                ctx.restore();
            }
        };
        return SpanView;
    }(annotation_1.AnnotationView));
    exports.SpanView = SpanView;
    SpanView.__name__ = "SpanView";
    var Span = /** @class */ (function (_super) {
        tslib_1.__extends(Span, _super);
        function Span(attrs) {
            return _super.call(this, attrs) || this;
        }
        Span.init_Span = function () {
            this.prototype.default_view = SpanView;
            this.mixins(['line']);
            this.define({
                render_mode: [p.RenderMode, 'canvas'],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
                location: [p.Number, null],
                location_units: [p.SpatialUnits, 'data'],
                dimension: [p.Dimension, 'width'],
            });
            this.override({
                line_color: 'black',
            });
            this.internal({
                for_hover: [p.Boolean, false],
                computed_location: [p.Number, null],
            });
        };
        return Span;
    }(annotation_1.Annotation));
    exports.Span = Span;
    Span.__name__ = "Span";
    Span.init_Span();
},
/* models/annotations/title.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var text_annotation_1 = require(228) /* ./text_annotation */;
    var dom_1 = require(163) /* ../../core/dom */;
    var visuals_1 = require(165) /* ../../core/visuals */;
    var p = require(121) /* ../../core/properties */;
    var TitleView = /** @class */ (function (_super) {
        tslib_1.__extends(TitleView, _super);
        function TitleView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TitleView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals.text = new visuals_1.Text(this.model);
        };
        TitleView.prototype._get_location = function () {
            var panel = this.panel;
            var hmargin = this.model.offset;
            var vmargin = 5;
            var sx, sy;
            switch (panel.side) {
                case 'above':
                case 'below': {
                    switch (this.model.vertical_align) {
                        case 'top':
                            sy = panel._top.value + vmargin;
                            break;
                        case 'middle':
                            sy = panel._vcenter.value;
                            break;
                        case 'bottom':
                            sy = panel._bottom.value - vmargin;
                            break;
                        default: throw new Error("unreachable code");
                    }
                    switch (this.model.align) {
                        case 'left':
                            sx = panel._left.value + hmargin;
                            break;
                        case 'center':
                            sx = panel._hcenter.value;
                            break;
                        case 'right':
                            sx = panel._right.value - hmargin;
                            break;
                        default: throw new Error("unreachable code");
                    }
                    break;
                }
                case 'left': {
                    switch (this.model.vertical_align) {
                        case 'top':
                            sx = panel._left.value - vmargin;
                            break;
                        case 'middle':
                            sx = panel._hcenter.value;
                            break;
                        case 'bottom':
                            sx = panel._right.value + vmargin;
                            break;
                        default: throw new Error("unreachable code");
                    }
                    switch (this.model.align) {
                        case 'left':
                            sy = panel._bottom.value - hmargin;
                            break;
                        case 'center':
                            sy = panel._vcenter.value;
                            break;
                        case 'right':
                            sy = panel._top.value + hmargin;
                            break;
                        default: throw new Error("unreachable code");
                    }
                    break;
                }
                case 'right': {
                    switch (this.model.vertical_align) {
                        case 'top':
                            sx = panel._right.value - vmargin;
                            break;
                        case 'middle':
                            sx = panel._hcenter.value;
                            break;
                        case 'bottom':
                            sx = panel._left.value + vmargin;
                            break;
                        default: throw new Error("unreachable code");
                    }
                    switch (this.model.align) {
                        case 'left':
                            sy = panel._top.value + hmargin;
                            break;
                        case 'center':
                            sy = panel._vcenter.value;
                            break;
                        case 'right':
                            sy = panel._bottom.value - hmargin;
                            break;
                        default: throw new Error("unreachable code");
                    }
                    break;
                }
                default: throw new Error("unreachable code");
            }
            return [sx, sy];
        };
        TitleView.prototype.render = function () {
            if (!this.model.visible) {
                if (this.model.render_mode == 'css')
                    dom_1.undisplay(this.el);
                return;
            }
            var text = this.model.text;
            if (text == null || text.length == 0)
                return;
            this.model.text_baseline = this.model.vertical_align;
            this.model.text_align = this.model.align;
            var _a = this._get_location(), sx = _a[0], sy = _a[1];
            var angle = this.panel.get_label_angle_heuristic('parallel');
            var draw = this.model.render_mode == 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.plot_view.canvas_view.ctx, text, sx, sy, angle);
        };
        TitleView.prototype._get_size = function () {
            var text = this.model.text;
            if (text == null || text.length == 0)
                return { width: 0, height: 0 };
            else {
                this.visuals.text.set_value(this.ctx);
                var _a = this.ctx.measureText(text), width = _a.width, ascent = _a.ascent;
                return { width: width, height: ascent * this.visuals.text.text_line_height.value() + 10 };
            }
        };
        return TitleView;
    }(text_annotation_1.TextAnnotationView));
    exports.TitleView = TitleView;
    TitleView.__name__ = "TitleView";
    var Title = /** @class */ (function (_super) {
        tslib_1.__extends(Title, _super);
        function Title(attrs) {
            return _super.call(this, attrs) || this;
        }
        Title.init_Title = function () {
            this.prototype.default_view = TitleView;
            this.mixins(['line:border_', 'fill:background_']);
            this.define({
                text: [p.String],
                text_font: [p.Font, 'helvetica'],
                text_font_size: [p.FontSizeSpec, '10pt'],
                text_font_style: [p.FontStyle, 'bold'],
                text_color: [p.ColorSpec, '#444444'],
                text_alpha: [p.NumberSpec, 1.0],
                text_line_height: [p.Number, 1.0],
                vertical_align: [p.VerticalAlign, 'bottom'],
                align: [p.TextAlign, 'left'],
                offset: [p.Number, 0],
            });
            this.override({
                background_fill_color: null,
                border_line_color: null,
            });
            this.internal({
                text_align: [p.TextAlign, 'left'],
                text_baseline: [p.TextBaseline, 'bottom'],
            });
        };
        return Title;
    }(text_annotation_1.TextAnnotation));
    exports.Title = Title;
    Title.__name__ = "Title";
    Title.init_Title();
},
/* models/annotations/toolbar_panel.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var build_views_1 = require(194) /* ../../core/build_views */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var ToolbarPanelView = /** @class */ (function (_super) {
        tslib_1.__extends(ToolbarPanelView, _super);
        function ToolbarPanelView() {
            var _this = _super.apply(this, arguments) || this;
            _this.rotate = true;
            return _this;
        }
        ToolbarPanelView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.plot_view.canvas_events.appendChild(this.el);
            this._toolbar_views = {};
            build_views_1.build_views(this._toolbar_views, [this.model.toolbar], { parent: this });
            var toolbar_view = this._toolbar_views[this.model.toolbar.id];
            this.plot_view.visibility_callbacks.push(function (visible) { return toolbar_view.set_visibility(visible); });
        };
        ToolbarPanelView.prototype.remove = function () {
            build_views_1.remove_views(this._toolbar_views);
            _super.prototype.remove.call(this);
        };
        ToolbarPanelView.prototype.render = function () {
            _super.prototype.render.call(this);
            if (!this.model.visible) {
                dom_1.undisplay(this.el);
                return;
            }
            this.el.style.position = "absolute";
            this.el.style.overflow = "hidden";
            dom_1.position(this.el, this.panel.bbox);
            var toolbar_view = this._toolbar_views[this.model.toolbar.id];
            toolbar_view.render();
            dom_1.empty(this.el);
            this.el.appendChild(toolbar_view.el);
            dom_1.display(this.el);
        };
        ToolbarPanelView.prototype._get_size = function () {
            var _a = this.model.toolbar, tools = _a.tools, logo = _a.logo;
            return {
                width: tools.length * 30 + (logo != null ? 25 : 0),
                height: 30,
            };
        };
        return ToolbarPanelView;
    }(annotation_1.AnnotationView));
    exports.ToolbarPanelView = ToolbarPanelView;
    ToolbarPanelView.__name__ = "ToolbarPanelView";
    var ToolbarPanel = /** @class */ (function (_super) {
        tslib_1.__extends(ToolbarPanel, _super);
        function ToolbarPanel(attrs) {
            return _super.call(this, attrs) || this;
        }
        ToolbarPanel.init_ToolbarPanel = function () {
            this.prototype.default_view = ToolbarPanelView;
            this.define({
                toolbar: [p.Instance],
            });
        };
        return ToolbarPanel;
    }(annotation_1.Annotation));
    exports.ToolbarPanel = ToolbarPanel;
    ToolbarPanel.__name__ = "ToolbarPanel";
    ToolbarPanel.init_ToolbarPanel();
},
/* models/annotations/tooltip.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var dom_1 = require(163) /* ../../core/dom */;
    var p = require(121) /* ../../core/properties */;
    var tooltips_1 = require(239) /* ../../styles/tooltips */;
    var mixins_1 = require(240) /* ../../styles/mixins */;
    function compute_side(attachment, sx, sy, hcenter, vcenter) {
        switch (attachment) {
            case "horizontal":
                return sx < hcenter ? "right" : "left";
            case "vertical":
                return sy < vcenter ? "below" : "above";
            default:
                return attachment;
        }
    }
    exports.compute_side = compute_side;
    var TooltipView = /** @class */ (function (_super) {
        tslib_1.__extends(TooltipView, _super);
        function TooltipView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TooltipView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            // TODO (bev) really probably need multiple divs
            this.plot_view.canvas_overlays.appendChild(this.el);
            dom_1.undisplay(this.el);
        };
        TooltipView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.data.change, function () { return _this._draw_tips(); });
        };
        TooltipView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat(tooltips_1.bk_tooltip);
        };
        TooltipView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._draw_tips();
        };
        TooltipView.prototype._draw_tips = function () {
            var data = this.model.data;
            dom_1.empty(this.el);
            dom_1.undisplay(this.el);
            if (this.model.custom)
                this.el.classList.add(tooltips_1.bk_tooltip_custom);
            else
                this.el.classList.remove(tooltips_1.bk_tooltip_custom);
            if (data.length == 0)
                return;
            var frame = this.plot_view.frame;
            for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                var _a = data_1[_i], sx_1 = _a[0], sy_1 = _a[1], content = _a[2];
                if (this.model.inner_only && !frame.bbox.contains(sx_1, sy_1))
                    continue;
                var tip = dom_1.div({}, content);
                this.el.appendChild(tip);
            }
            var _b = data[data.length - 1], sx = _b[0], sy = _b[1]; // XXX: this previously depended on {sx, sy} leaking from the for-loop
            var side = compute_side(this.model.attachment, sx, sy, frame._hcenter.value, frame._vcenter.value);
            this.el.classList.remove(mixins_1.bk_right);
            this.el.classList.remove(mixins_1.bk_left);
            this.el.classList.remove(mixins_1.bk_above);
            this.el.classList.remove(mixins_1.bk_below);
            var arrow_size = 10; // XXX: keep in sync with less
            dom_1.display(this.el); // XXX: {offset,client}Width() gives 0 when display="none"
            // slightly confusing: side "left" (for example) is relative to point that
            // is being annotated but CS class ".bk-left" is relative to the tooltip itself
            var left, top;
            switch (side) {
                case "right":
                    this.el.classList.add(mixins_1.bk_left);
                    left = sx + (this.el.offsetWidth - this.el.clientWidth) + arrow_size;
                    top = sy - this.el.offsetHeight / 2;
                    break;
                case "left":
                    this.el.classList.add(mixins_1.bk_right);
                    left = sx - this.el.offsetWidth - arrow_size;
                    top = sy - this.el.offsetHeight / 2;
                    break;
                case "below":
                    this.el.classList.add(mixins_1.bk_above);
                    top = sy + (this.el.offsetHeight - this.el.clientHeight) + arrow_size;
                    left = Math.round(sx - this.el.offsetWidth / 2);
                    break;
                case "above":
                    this.el.classList.add(mixins_1.bk_below);
                    top = sy - this.el.offsetHeight - arrow_size;
                    left = Math.round(sx - this.el.offsetWidth / 2);
                    break;
                default:
                    throw new Error("unreachable code");
            }
            if (this.model.show_arrow)
                this.el.classList.add(tooltips_1.bk_tooltip_arrow);
            // TODO (bev) this is not currently bulletproof. If there are
            // two hits, not colocated and one is off the screen, that can
            // be problematic
            if (this.el.childNodes.length > 0) {
                this.el.style.top = top + "px";
                this.el.style.left = left + "px";
            }
            else
                dom_1.undisplay(this.el);
        };
        return TooltipView;
    }(annotation_1.AnnotationView));
    exports.TooltipView = TooltipView;
    TooltipView.__name__ = "TooltipView";
    var Tooltip = /** @class */ (function (_super) {
        tslib_1.__extends(Tooltip, _super);
        function Tooltip(attrs) {
            return _super.call(this, attrs) || this;
        }
        Tooltip.init_Tooltip = function () {
            this.prototype.default_view = TooltipView;
            this.define({
                attachment: [p.TooltipAttachment, 'horizontal'],
                inner_only: [p.Boolean, true],
                show_arrow: [p.Boolean, true],
            });
            this.override({
                level: 'overlay',
            });
            this.internal({
                data: [p.Any, []],
                custom: [p.Any],
            });
        };
        Tooltip.prototype.clear = function () {
            this.data = [];
        };
        Tooltip.prototype.add = function (sx, sy, content) {
            this.data = this.data.concat([[sx, sy, content]]);
        };
        return Tooltip;
    }(annotation_1.Annotation));
    exports.Tooltip = Tooltip;
    Tooltip.__name__ = "Tooltip";
    Tooltip.init_Tooltip();
},
/* styles/tooltips.js */ function _(require, module, exports) {
    require(164) /* ./root */;
    var _a = require(163) /* ../core/dom */;
    _a.styles.append(".bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: \" \";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: \" \";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: \" \";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: \" \";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n");
    exports.bk_tooltip = "bk-tooltip";
    exports.bk_tooltip_arrow = "bk-tooltip-arrow";
    exports.bk_tooltip_custom = "bk-tooltip-custom";
    exports.bk_tooltip_row_label = "bk-tooltip-row-label";
    exports.bk_tooltip_row_value = "bk-tooltip-row-value";
    exports.bk_tooltip_color_block = "bk-tooltip-color-block";
},
/* styles/mixins.js */ function _(require, module, exports) {
    var _a = require(163) /* ../core/dom */;
    _a.styles.append("");
    exports.bk_active = "bk-active";
    exports.bk_inline = "bk-inline";
    exports.bk_left = "bk-left";
    exports.bk_right = "bk-right";
    exports.bk_above = "bk-above";
    exports.bk_below = "bk-below";
    exports.bk_up = "bk-up";
    exports.bk_down = "bk-down";
    function bk_side(side) {
        switch (side) {
            case "above": return exports.bk_above;
            case "below": return exports.bk_below;
            case "left": return exports.bk_left;
            case "right": return exports.bk_right;
        }
    }
    exports.bk_side = bk_side;
},
/* models/annotations/whisker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var annotation_1 = require(131) /* ./annotation */;
    var column_data_source_1 = require(170) /* ../sources/column_data_source */;
    var arrow_head_1 = require(169) /* ./arrow_head */;
    var p = require(121) /* ../../core/properties */;
    var WhiskerView = /** @class */ (function (_super) {
        tslib_1.__extends(WhiskerView, _super);
        function WhiskerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WhiskerView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.set_data(this.model.source);
        };
        WhiskerView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.source.streaming, function () { return _this.set_data(_this.model.source); });
            this.connect(this.model.source.patching, function () { return _this.set_data(_this.model.source); });
            this.connect(this.model.source.change, function () { return _this.set_data(_this.model.source); });
        };
        WhiskerView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        };
        WhiskerView.prototype._map_data = function () {
            var frame = this.plot_view.frame;
            var dim = this.model.dimension;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var limit_scale = dim == "height" ? yscale : xscale;
            var base_scale = dim == "height" ? xscale : yscale;
            var limit_view = dim == "height" ? frame.yview : frame.xview;
            var base_view = dim == "height" ? frame.xview : frame.yview;
            var _lower_sx;
            if (this.model.properties.lower.units == "data")
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            var _upper_sx;
            if (this.model.properties.upper.units == "data")
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            var _base_sx;
            if (this.model.properties.base.units == "data")
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            var _a = dim == 'height' ? [1, 0] : [0, 1], i = _a[0], j = _a[1];
            var _lower = [_lower_sx, _base_sx];
            var _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        };
        WhiskerView.prototype.render = function () {
            if (!this.model.visible)
                return;
            this._map_data();
            var ctx = this.plot_view.canvas_view.ctx;
            if (this.visuals.line.doit) {
                for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(this._lower_sx[i], this._lower_sy[i]);
                    ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
                    ctx.stroke();
                }
            }
            var angle = this.model.dimension == "height" ? 0 : Math.PI / 2;
            if (this.model.lower_head != null) {
                for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._lower_sx[i], this._lower_sy[i]);
                    ctx.rotate(angle + Math.PI);
                    this.model.lower_head.render(ctx, i);
                    ctx.restore();
                }
            }
            if (this.model.upper_head != null) {
                for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._upper_sx[i], this._upper_sy[i]);
                    ctx.rotate(angle);
                    this.model.upper_head.render(ctx, i);
                    ctx.restore();
                }
            }
        };
        return WhiskerView;
    }(annotation_1.AnnotationView));
    exports.WhiskerView = WhiskerView;
    WhiskerView.__name__ = "WhiskerView";
    var Whisker = /** @class */ (function (_super) {
        tslib_1.__extends(Whisker, _super);
        function Whisker(attrs) {
            return _super.call(this, attrs) || this;
        }
        Whisker.init_Whisker = function () {
            this.prototype.default_view = WhiskerView;
            this.mixins(['line']);
            this.define({
                lower: [p.DistanceSpec],
                lower_head: [p.Instance, function () { return new arrow_head_1.TeeHead({ level: "underlay", size: 10 }); }],
                upper: [p.DistanceSpec],
                upper_head: [p.Instance, function () { return new arrow_head_1.TeeHead({ level: "underlay", size: 10 }); }],
                base: [p.DistanceSpec],
                dimension: [p.Dimension, 'height'],
                source: [p.Instance, function () { return new column_data_source_1.ColumnDataSource(); }],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
            });
            this.override({
                level: 'underlay',
            });
        };
        return Whisker;
    }(annotation_1.Annotation));
    exports.Whisker = Whisker;
    Whisker.__name__ = "Whisker";
    Whisker.init_Whisker();
},
/* models/axes/index.js */ function _(require, module, exports) {
    var axis_1 = require(243) /* ./axis */;
    exports.Axis = axis_1.Axis;
    var categorical_axis_1 = require(245) /* ./categorical_axis */;
    exports.CategoricalAxis = categorical_axis_1.CategoricalAxis;
    var continuous_axis_1 = require(248) /* ./continuous_axis */;
    exports.ContinuousAxis = continuous_axis_1.ContinuousAxis;
    var datetime_axis_1 = require(249) /* ./datetime_axis */;
    exports.DatetimeAxis = datetime_axis_1.DatetimeAxis;
    var linear_axis_1 = require(250) /* ./linear_axis */;
    exports.LinearAxis = linear_axis_1.LinearAxis;
    var log_axis_1 = require(263) /* ./log_axis */;
    exports.LogAxis = log_axis_1.LogAxis;
    var mercator_axis_1 = require(266) /* ./mercator_axis */;
    exports.MercatorAxis = mercator_axis_1.MercatorAxis;
},
/* models/axes/axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var guide_renderer_1 = require(244) /* ../renderers/guide_renderer */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    var types_1 = require(109) /* ../../core/util/types */;
    var factor_range_1 = require(184) /* ../ranges/factor_range */;
    var abs = Math.abs, min = Math.min, max = Math.max;
    var AxisView = /** @class */ (function (_super) {
        tslib_1.__extends(AxisView, _super);
        function AxisView() {
            var _this = _super.apply(this, arguments) || this;
            _this.rotate = true;
            return _this;
        }
        Object.defineProperty(AxisView.prototype, "panel", {
            get: function () {
                return this.layout;
            },
            enumerable: true,
            configurable: true
        });
        AxisView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var extents = {
                tick: this._tick_extent(),
                tick_label: this._tick_label_extents(),
                axis_label: this._axis_label_extent(),
            };
            var tick_coords = this.tick_coords;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            if (this._render != null)
                this._render(ctx, extents, tick_coords);
            ctx.restore();
        };
        AxisView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.plot_view.request_paint(); });
            var p = this.model.properties;
            this.on_change(p.visible, function () { return _this.plot_view.request_layout(); });
        };
        AxisView.prototype.get_size = function () {
            if (this.model.visible && this.model.fixed_location == null) {
                var size = this._get_size();
                return { width: 0 /* max */, height: Math.round(size) };
            }
            else
                return { width: 0, height: 0 };
        };
        AxisView.prototype._get_size = function () {
            return this._tick_extent() + this._tick_label_extent() + this._axis_label_extent();
        };
        Object.defineProperty(AxisView.prototype, "needs_clip", {
            get: function () {
                return this.model.fixed_location != null;
            },
            enumerable: true,
            configurable: true
        });
        // drawing sub functions -----------------------------------------------------
        AxisView.prototype._draw_rule = function (ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            var _a = this.rule_coords, xs = _a[0], ys = _a[1];
            var _b = this.plot_view.map_to_screen(xs, ys, this.model.x_range_name, this.model.y_range_name), sxs = _b[0], sys = _b[1];
            var _c = this.normals, nx = _c[0], ny = _c[1];
            var _d = this.offsets, xoff = _d[0], yoff = _d[1];
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            ctx.moveTo(Math.round(sxs[0] + nx * xoff), Math.round(sys[0] + ny * yoff));
            for (var i = 1; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nx * xoff);
                var sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        };
        AxisView.prototype._draw_major_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            var visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        };
        AxisView.prototype._draw_minor_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            var visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        };
        AxisView.prototype._draw_major_labels = function (ctx, extents, tick_coords) {
            var coords = tick_coords.major;
            var labels = this.compute_labels(coords[this.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = extents.tick + this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
        };
        AxisView.prototype._draw_axis_label = function (ctx, extents, _tick_coords) {
            if (this.model.axis_label == null || this.model.axis_label.length == 0 || this.model.fixed_location != null)
                return;
            var sx;
            var sy;
            switch (this.panel.side) {
                case "above":
                    sx = this.panel._hcenter.value;
                    sy = this.panel._bottom.value;
                    break;
                case "below":
                    sx = this.panel._hcenter.value;
                    sy = this.panel._top.value;
                    break;
                case "left":
                    sx = this.panel._right.value;
                    sy = this.panel._vcenter.value;
                    break;
                case "right":
                    sx = this.panel._left.value;
                    sy = this.panel._vcenter.value;
                    break;
                default:
                    throw new Error("unknown side: " + this.panel.side);
            }
            var coords = [[sx], [sy]];
            var standoff = extents.tick + array_1.sum(extents.tick_label) + this.model.axis_label_standoff;
            var visuals = this.visuals.axis_label_text;
            this._draw_oriented_labels(ctx, [this.model.axis_label], coords, 'parallel', this.panel.side, standoff, visuals, "screen");
        };
        AxisView.prototype._draw_ticks = function (ctx, coords, tin, tout, visuals) {
            if (!visuals.doit)
                return;
            var x = coords[0], y = coords[1];
            var _a = this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name), sxs = _a[0], sys = _a[1];
            var _b = this.normals, nx = _b[0], ny = _b[1];
            var _c = this.offsets, xoff = _c[0], yoff = _c[1];
            var _d = [nx * (xoff - tin), ny * (yoff - tin)], nxin = _d[0], nyin = _d[1];
            var _e = [nx * (xoff + tout), ny * (yoff + tout)], nxout = _e[0], nyout = _e[1];
            visuals.set_value(ctx);
            for (var i = 0; i < sxs.length; i++) {
                var sx0 = Math.round(sxs[i] + nxout);
                var sy0 = Math.round(sys[i] + nyout);
                var sx1 = Math.round(sxs[i] + nxin);
                var sy1 = Math.round(sys[i] + nyin);
                ctx.beginPath();
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
                ctx.stroke();
            }
        };
        AxisView.prototype._draw_oriented_labels = function (ctx, labels, coords, orient, _side, standoff, visuals, units) {
            var _a, _b, _c;
            if (units === void 0) {
                units = "data";
            }
            if (!visuals.doit || labels.length == 0)
                return;
            var sxs, sys;
            var xoff, yoff;
            if (units == "screen") {
                sxs = coords[0], sys = coords[1];
                _a = [0, 0], xoff = _a[0], yoff = _a[1];
            }
            else {
                var dxs = coords[0], dys = coords[1];
                _b = this.plot_view.map_to_screen(dxs, dys, this.model.x_range_name, this.model.y_range_name), sxs = _b[0], sys = _b[1];
                _c = this.offsets, xoff = _c[0], yoff = _c[1];
            }
            var _d = this.normals, nx = _d[0], ny = _d[1];
            var nxd = nx * (xoff + standoff);
            var nyd = ny * (yoff + standoff);
            visuals.set_value(ctx);
            this.panel.apply_label_text_heuristics(ctx, orient);
            var angle;
            if (types_1.isString(orient))
                angle = this.panel.get_label_angle_heuristic(orient);
            else
                angle = -orient;
            for (var i = 0; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nxd);
                var sy = Math.round(sys[i] + nyd);
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.fillText(labels[i], 0, 0);
                ctx.rotate(-angle);
                ctx.translate(-sx, -sy);
            }
        };
        // extents sub functions -----------------------------------------------------
        /*protected*/ AxisView.prototype._axis_label_extent = function () {
            if (this.model.axis_label == null || this.model.axis_label == "")
                return 0;
            var standoff = this.model.axis_label_standoff;
            var visuals = this.visuals.axis_label_text;
            return this._oriented_labels_extent([this.model.axis_label], "parallel", this.panel.side, standoff, visuals);
        };
        /*protected*/ AxisView.prototype._tick_extent = function () {
            return this.model.major_tick_out;
        };
        /*protected*/ AxisView.prototype._tick_label_extent = function () {
            return array_1.sum(this._tick_label_extents());
        };
        AxisView.prototype._tick_label_extents = function () {
            var coords = this.tick_coords.major;
            var labels = this.compute_labels(coords[this.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            return [this._oriented_labels_extent(labels, orient, this.panel.side, standoff, visuals)];
        };
        AxisView.prototype._oriented_labels_extent = function (labels, orient, side, standoff, visuals) {
            if (labels.length == 0)
                return 0;
            var ctx = this.plot_view.canvas_view.ctx;
            visuals.set_value(ctx);
            var hscale;
            var angle;
            if (types_1.isString(orient)) {
                hscale = 1;
                angle = this.panel.get_label_angle_heuristic(orient);
            }
            else {
                hscale = 2;
                angle = -orient;
            }
            angle = Math.abs(angle);
            var c = Math.cos(angle);
            var s = Math.sin(angle);
            var extent = 0;
            for (var i = 0; i < labels.length; i++) {
                var w = ctx.measureText(labels[i]).width * 1.1;
                var h = ctx.measureText(labels[i]).ascent * 0.9;
                var val = void 0;
                if (side == "above" || side == "below")
                    val = w * s + (h / hscale) * c;
                else
                    val = w * c + (h / hscale) * s;
                // update extent if current value is larger
                if (val > extent)
                    extent = val;
            }
            // only apply the standoff if we already have non-zero extent
            if (extent > 0)
                extent += standoff;
            return extent;
        };
        Object.defineProperty(AxisView.prototype, "normals", {
            // {{{ TODO: state
            get: function () {
                return this.panel.normals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "dimension", {
            get: function () {
                return this.panel.dimension;
            },
            enumerable: true,
            configurable: true
        });
        AxisView.prototype.compute_labels = function (ticks) {
            var labels = this.model.formatter.doFormat(ticks, this);
            for (var i = 0; i < ticks.length; i++) {
                if (ticks[i] in this.model.major_label_overrides)
                    labels[i] = this.model.major_label_overrides[ticks[i]];
            }
            return labels;
        };
        Object.defineProperty(AxisView.prototype, "offsets", {
            get: function () {
                // If we have a fixed_position then we should respect that exactly and
                // not apply any offsets (https://github.com/bokeh/bokeh/issues/8552)
                if (this.model.fixed_location != null)
                    return [0, 0];
                var frame = this.plot_view.frame;
                var _a = [0, 0], xoff = _a[0], yoff = _a[1];
                switch (this.panel.side) {
                    case "below":
                        yoff = abs(this.panel._top.value - frame._bottom.value);
                        break;
                    case "above":
                        yoff = abs(this.panel._bottom.value - frame._top.value);
                        break;
                    case "right":
                        xoff = abs(this.panel._left.value - frame._right.value);
                        break;
                    case "left":
                        xoff = abs(this.panel._right.value - frame._left.value);
                        break;
                }
                return [xoff, yoff];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "ranges", {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var frame = this.plot_view.frame;
                var ranges = [
                    frame.x_ranges[this.model.x_range_name],
                    frame.y_ranges[this.model.y_range_name],
                ];
                return [ranges[i], ranges[j]];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "computed_bounds", {
            get: function () {
                var range = this.ranges[0];
                var user_bounds = this.model.bounds; // XXX: ? 'auto'
                var range_bounds = [range.min, range.max];
                if (user_bounds == 'auto')
                    return [range.min, range.max];
                else if (types_1.isArray(user_bounds)) {
                    var start = void 0;
                    var end = void 0;
                    var user_start = user_bounds[0], user_end = user_bounds[1];
                    var range_start = range_bounds[0], range_end = range_bounds[1];
                    if (abs(user_start - user_end) > abs(range_start - range_end)) {
                        start = max(min(user_start, user_end), range_start);
                        end = min(max(user_start, user_end), range_end);
                    }
                    else {
                        start = min(user_start, user_end);
                        end = max(user_start, user_end);
                    }
                    return [start, end];
                }
                else
                    throw new Error("user bounds '" + user_bounds + "' not understood");
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "rule_coords", {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var xs = new Array(2);
                var ys = new Array(2);
                var coords = [xs, ys];
                coords[i][0] = Math.max(start, range.min);
                coords[i][1] = Math.min(end, range.max);
                if (coords[i][0] > coords[i][1])
                    coords[i][0] = coords[i][1] = NaN;
                coords[j][0] = this.loc;
                coords[j][1] = this.loc;
                return coords;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "tick_coords", {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var ticks = this.model.ticker.get_ticks(start, end, range, this.loc, {});
                var majors = ticks.major;
                var minors = ticks.minor;
                var xs = [];
                var ys = [];
                var coords = [xs, ys];
                var minor_xs = [];
                var minor_ys = [];
                var minor_coords = [minor_xs, minor_ys];
                var _b = [range.min, range.max], range_min = _b[0], range_max = _b[1];
                for (var ii = 0; ii < majors.length; ii++) {
                    if (majors[ii] < range_min || majors[ii] > range_max)
                        continue;
                    coords[i].push(majors[ii]);
                    coords[j].push(this.loc);
                }
                for (var ii = 0; ii < minors.length; ii++) {
                    if (minors[ii] < range_min || minors[ii] > range_max)
                        continue;
                    minor_coords[i].push(minors[ii]);
                    minor_coords[j].push(this.loc);
                }
                return {
                    major: coords,
                    minor: minor_coords,
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AxisView.prototype, "loc", {
            get: function () {
                var fixed_location = this.model.fixed_location;
                if (fixed_location != null) {
                    if (types_1.isNumber(fixed_location))
                        return fixed_location;
                    var _a = this.ranges, cross_range_1 = _a[1];
                    if (cross_range_1 instanceof factor_range_1.FactorRange)
                        return cross_range_1.synthetic(fixed_location);
                    throw new Error("unexpected");
                }
                var _b = this.ranges, cross_range = _b[1];
                switch (this.panel.side) {
                    case 'left':
                    case 'below':
                        return cross_range.start;
                    case 'right':
                    case 'above':
                        return cross_range.end;
                }
            },
            enumerable: true,
            configurable: true
        });
        // }}}
        AxisView.prototype.serializable_state = function () {
            return Object.assign(Object.assign({}, _super.prototype.serializable_state.call(this)), { bbox: this.layout.bbox.box });
        };
        return AxisView;
    }(guide_renderer_1.GuideRendererView));
    exports.AxisView = AxisView;
    AxisView.__name__ = "AxisView";
    var Axis = /** @class */ (function (_super) {
        tslib_1.__extends(Axis, _super);
        function Axis(attrs) {
            return _super.call(this, attrs) || this;
        }
        Axis.init_Axis = function () {
            this.prototype.default_view = AxisView;
            this.mixins([
                'line:axis_',
                'line:major_tick_',
                'line:minor_tick_',
                'text:major_label_',
                'text:axis_label_',
            ]);
            this.define({
                bounds: [p.Any, 'auto'],
                ticker: [p.Instance],
                formatter: [p.Instance],
                x_range_name: [p.String, 'default'],
                y_range_name: [p.String, 'default'],
                axis_label: [p.String, ''],
                axis_label_standoff: [p.Int, 5],
                major_label_standoff: [p.Int, 5],
                major_label_orientation: [p.Any, "horizontal"],
                major_label_overrides: [p.Any, {}],
                major_tick_in: [p.Number, 2],
                major_tick_out: [p.Number, 6],
                minor_tick_in: [p.Number, 0],
                minor_tick_out: [p.Number, 4],
                fixed_location: [p.Any, null],
            });
            this.override({
                axis_line_color: 'black',
                major_tick_line_color: 'black',
                minor_tick_line_color: 'black',
                major_label_text_font_size: "8pt",
                major_label_text_align: "center",
                major_label_text_baseline: "alphabetic",
                axis_label_text_font_size: "10pt",
                axis_label_text_font_style: "italic",
            });
        };
        return Axis;
    }(guide_renderer_1.GuideRenderer));
    exports.Axis = Axis;
    Axis.__name__ = "Axis";
    Axis.init_Axis();
},
/* models/renderers/guide_renderer.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var renderer_1 = require(160) /* ./renderer */;
    var GuideRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(GuideRendererView, _super);
        function GuideRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return GuideRendererView;
    }(renderer_1.RendererView));
    exports.GuideRendererView = GuideRendererView;
    GuideRendererView.__name__ = "GuideRendererView";
    var GuideRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(GuideRenderer, _super);
        function GuideRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GuideRenderer.init_GuideRenderer = function () {
            this.override({
                level: "overlay",
            });
        };
        return GuideRenderer;
    }(renderer_1.Renderer));
    exports.GuideRenderer = GuideRenderer;
    GuideRenderer.__name__ = "GuideRenderer";
    GuideRenderer.init_GuideRenderer();
},
/* models/axes/categorical_axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var axis_1 = require(243) /* ./axis */;
    var categorical_ticker_1 = require(246) /* ../tickers/categorical_ticker */;
    var categorical_tick_formatter_1 = require(247) /* ../formatters/categorical_tick_formatter */;
    var p = require(121) /* ../../core/properties */;
    var CategoricalAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalAxisView, _super);
        function CategoricalAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CategoricalAxisView.prototype._render = function (ctx, extents, tick_coords) {
            this._draw_group_separators(ctx, extents, tick_coords);
        };
        CategoricalAxisView.prototype._draw_group_separators = function (ctx, _extents, _tick_coords) {
            var _a;
            var range = this.ranges[0];
            var _b = this.computed_bounds, start = _b[0], end = _b[1];
            if (!range.tops || range.tops.length < 2 || !this.visuals.separator_line.doit)
                return;
            var dim = this.dimension;
            var alt = (dim + 1) % 2;
            var coords = [[], []];
            var ind = 0;
            for (var i = 0; i < range.tops.length - 1; i++) {
                var first = void 0, last = void 0;
                for (var j = ind; j < range.factors.length; j++) {
                    if (range.factors[j][0] == range.tops[i + 1]) {
                        _a = [range.factors[j - 1], range.factors[j]], first = _a[0], last = _a[1];
                        ind = j;
                        break;
                    }
                }
                var pt = (range.synthetic(first) + range.synthetic(last)) / 2;
                if (pt > start && pt < end) {
                    coords[dim].push(pt);
                    coords[alt].push(this.loc);
                }
            }
            var tex = this._tick_label_extent();
            this._draw_ticks(ctx, coords, -3, (tex - 6), this.visuals.separator_line);
        };
        CategoricalAxisView.prototype._draw_major_labels = function (ctx, extents, _tick_coords) {
            var info = this._get_factor_info();
            var standoff = extents.tick + this.model.major_label_standoff;
            for (var i = 0; i < info.length; i++) {
                var _a = info[i], labels = _a[0], coords = _a[1], orient = _a[2], visuals = _a[3];
                this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
                standoff += extents.tick_label[i];
            }
        };
        CategoricalAxisView.prototype._tick_label_extents = function () {
            var info = this._get_factor_info();
            var extents = [];
            for (var _i = 0, info_1 = info; _i < info_1.length; _i++) {
                var _a = info_1[_i], labels = _a[0], orient = _a[2], visuals = _a[3];
                var extent = this._oriented_labels_extent(labels, orient, this.panel.side, this.model.major_label_standoff, visuals);
                extents.push(extent);
            }
            return extents;
        };
        CategoricalAxisView.prototype._get_factor_info = function () {
            var range = this.ranges[0];
            var _a = this.computed_bounds, start = _a[0], end = _a[1];
            var loc = this.loc;
            var ticks = this.model.ticker.get_ticks(start, end, range, loc, {});
            var coords = this.tick_coords;
            var info = [];
            if (range.levels == 1) {
                var major = ticks.major;
                var labels = this.model.formatter.doFormat(major, this);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
            }
            else if (range.levels == 2) {
                var major = ticks.major.map(function (x) { return x[1]; });
                var labels = this.model.formatter.doFormat(major, this);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([ticks.tops, coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            else if (range.levels == 3) {
                var major = ticks.major.map(function (x) { return x[2]; });
                var labels = this.model.formatter.doFormat(major, this);
                var mid_labels = ticks.mids.map(function (x) { return x[1]; });
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([mid_labels, coords.mids, this.model.subgroup_label_orientation, this.visuals.subgroup_text]);
                info.push([ticks.tops, coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            return info;
        };
        Object.defineProperty(CategoricalAxisView.prototype, "tick_coords", {
            // {{{ TODO: state
            get: function () {
                var _this = this;
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var ticks = this.model.ticker.get_ticks(start, end, range, this.loc, {});
                var coords = {
                    major: [[], []],
                    mids: [[], []],
                    tops: [[], []],
                    minor: [[], []],
                };
                coords.major[i] = ticks.major;
                coords.major[j] = ticks.major.map(function (_x) { return _this.loc; });
                if (range.levels == 3) {
                    coords.mids[i] = ticks.mids;
                    coords.mids[j] = ticks.mids.map(function (_x) { return _this.loc; });
                }
                if (range.levels > 1) {
                    coords.tops[i] = ticks.tops;
                    coords.tops[j] = ticks.tops.map(function (_x) { return _this.loc; });
                }
                return coords;
            },
            enumerable: true,
            configurable: true
        });
        return CategoricalAxisView;
    }(axis_1.AxisView));
    exports.CategoricalAxisView = CategoricalAxisView;
    CategoricalAxisView.__name__ = "CategoricalAxisView";
    var CategoricalAxis = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalAxis, _super);
        function CategoricalAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalAxis.init_CategoricalAxis = function () {
            this.prototype.default_view = CategoricalAxisView;
            this.mixins([
                "line:separator_",
                "text:group_",
                "text:subgroup_",
            ]);
            this.define({
                group_label_orientation: [p.Any, "parallel"],
                subgroup_label_orientation: [p.Any, "parallel"],
            });
            this.override({
                ticker: function () { return new categorical_ticker_1.CategoricalTicker(); },
                formatter: function () { return new categorical_tick_formatter_1.CategoricalTickFormatter(); },
                separator_line_color: "lightgrey",
                separator_line_width: 2,
                group_text_font_style: "bold",
                group_text_font_size: "8pt",
                group_text_color: "grey",
                subgroup_text_font_style: "bold",
                subgroup_text_font_size: "8pt",
            });
        };
        return CategoricalAxis;
    }(axis_1.Axis));
    exports.CategoricalAxis = CategoricalAxis;
    CategoricalAxis.__name__ = "CategoricalAxis";
    CategoricalAxis.init_CategoricalAxis();
},
/* models/tickers/categorical_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var ticker_1 = require(207) /* ./ticker */;
    var CategoricalTicker = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalTicker, _super);
        function CategoricalTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalTicker.prototype.get_ticks = function (start, end, range, _cross_loc, _) {
            var majors = this._collect(range.factors, range, start, end);
            var tops = this._collect(range.tops || [], range, start, end);
            var mids = this._collect(range.mids || [], range, start, end);
            return {
                major: majors,
                minor: [],
                tops: tops,
                mids: mids,
            };
        };
        CategoricalTicker.prototype._collect = function (factors, range, start, end) {
            var result = [];
            for (var _i = 0, factors_1 = factors; _i < factors_1.length; _i++) {
                var factor = factors_1[_i];
                var coord = range.synthetic(factor);
                if (coord > start && coord < end)
                    result.push(factor);
            }
            return result;
        };
        return CategoricalTicker;
    }(ticker_1.Ticker));
    exports.CategoricalTicker = CategoricalTicker;
    CategoricalTicker.__name__ = "CategoricalTicker";
},
/* models/formatters/categorical_tick_formatter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var tick_formatter_1 = require(209) /* ./tick_formatter */;
    var array_1 = require(110) /* ../../core/util/array */;
    var CategoricalTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalTickFormatter, _super);
        function CategoricalTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalTickFormatter.prototype.doFormat = function (ticks, _opts) {
            return array_1.copy(ticks);
        };
        return CategoricalTickFormatter;
    }(tick_formatter_1.TickFormatter));
    exports.CategoricalTickFormatter = CategoricalTickFormatter;
    CategoricalTickFormatter.__name__ = "CategoricalTickFormatter";
},
/* models/axes/continuous_axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var axis_1 = require(243) /* ./axis */;
    var ContinuousAxis = /** @class */ (function (_super) {
        tslib_1.__extends(ContinuousAxis, _super);
        function ContinuousAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        return ContinuousAxis;
    }(axis_1.Axis));
    exports.ContinuousAxis = ContinuousAxis;
    ContinuousAxis.__name__ = "ContinuousAxis";
},
/* models/axes/datetime_axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var linear_axis_1 = require(250) /* ./linear_axis */;
    var datetime_tick_formatter_1 = require(251) /* ../formatters/datetime_tick_formatter */;
    var datetime_ticker_1 = require(256) /* ../tickers/datetime_ticker */;
    var DatetimeAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(DatetimeAxisView, _super);
        function DatetimeAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DatetimeAxisView;
    }(linear_axis_1.LinearAxisView));
    exports.DatetimeAxisView = DatetimeAxisView;
    DatetimeAxisView.__name__ = "DatetimeAxisView";
    var DatetimeAxis = /** @class */ (function (_super) {
        tslib_1.__extends(DatetimeAxis, _super);
        function DatetimeAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        DatetimeAxis.init_DatetimeAxis = function () {
            this.prototype.default_view = DatetimeAxisView;
            this.override({
                ticker: function () { return new datetime_ticker_1.DatetimeTicker(); },
                formatter: function () { return new datetime_tick_formatter_1.DatetimeTickFormatter(); },
            });
        };
        return DatetimeAxis;
    }(linear_axis_1.LinearAxis));
    exports.DatetimeAxis = DatetimeAxis;
    DatetimeAxis.__name__ = "DatetimeAxis";
    DatetimeAxis.init_DatetimeAxis();
},
/* models/axes/linear_axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var axis_1 = require(243) /* ./axis */;
    var continuous_axis_1 = require(248) /* ./continuous_axis */;
    var basic_tick_formatter_1 = require(208) /* ../formatters/basic_tick_formatter */;
    var basic_ticker_1 = require(204) /* ../tickers/basic_ticker */;
    var LinearAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(LinearAxisView, _super);
        function LinearAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LinearAxisView;
    }(axis_1.AxisView));
    exports.LinearAxisView = LinearAxisView;
    LinearAxisView.__name__ = "LinearAxisView";
    var LinearAxis = /** @class */ (function (_super) {
        tslib_1.__extends(LinearAxis, _super);
        function LinearAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        LinearAxis.init_LinearAxis = function () {
            this.prototype.default_view = LinearAxisView;
            this.override({
                ticker: function () { return new basic_ticker_1.BasicTicker(); },
                formatter: function () { return new basic_tick_formatter_1.BasicTickFormatter(); },
            });
        };
        return LinearAxis;
    }(continuous_axis_1.ContinuousAxis));
    exports.LinearAxis = LinearAxis;
    LinearAxis.__name__ = "LinearAxis";
    LinearAxis.init_LinearAxis();
},
/* models/formatters/datetime_tick_formatter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var tz = require(252) /* timezone */;
    var tick_formatter_1 = require(209) /* ./tick_formatter */;
    var logging_1 = require(167) /* ../../core/logging */;
    var p = require(121) /* ../../core/properties */;
    var templating_1 = require(253) /* ../../core/util/templating */;
    var array_1 = require(110) /* ../../core/util/array */;
    var types_1 = require(109) /* ../../core/util/types */;
    function _us(t) {
        // From double-precision unix (millisecond) timestamp get
        // microsecond since last second. Precision seems to run
        // out around the hundreds of nanoseconds scale, so rounding
        // to the nearest microsecond should round to a nice
        // microsecond / millisecond tick.
        return Math.round(((t / 1000) % 1) * 1000000);
    }
    function _array(t) {
        return tz(t, "%Y %m %d %H %M %S").split(/\s+/).map(function (e) { return parseInt(e, 10); });
    }
    function _strftime(t, format) {
        if (types_1.isFunction(format)) {
            return format(t);
        }
        else {
            // Python's datetime library augments the microsecond directive %f, which is not
            // supported by the javascript library timezone: http://bigeasy.github.io/timezone/.
            // Use a regular expression to replace %f directive with microseconds.
            // TODO: what should we do for negative microsecond strings?
            var microsecond_replacement_string = templating_1.sprintf("$1%06d", _us(t));
            format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
            if (format.indexOf("%") == -1) {
                // timezone seems to ignore any strings without any formatting directives,
                // and just return the time argument back instead of the string argument.
                // But we want the string argument, in case a user supplies a format string
                // which doesn't contain a formatting directive or is only using %f.
                return format;
            }
            return tz(t, format);
        }
    }
    // Labels of time units, from finest to coarsest.
    var format_order = [
        'microseconds', 'milliseconds', 'seconds', 'minsec', 'minutes', 'hourmin', 'hours', 'days', 'months', 'years',
    ];
    var DatetimeTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(DatetimeTickFormatter, _super);
        function DatetimeTickFormatter(attrs) {
            var _this = _super.call(this, attrs) || this;
            // Whether or not to strip the leading zeros on tick labels.
            _this.strip_leading_zeros = true;
            return _this;
        }
        DatetimeTickFormatter.init_DatetimeTickFormatter = function () {
            this.define({
                microseconds: [p.Array, ['%fus']],
                milliseconds: [p.Array, ['%3Nms', '%S.%3Ns']],
                seconds: [p.Array, ['%Ss']],
                minsec: [p.Array, [':%M:%S']],
                minutes: [p.Array, [':%M', '%Mm']],
                hourmin: [p.Array, ['%H:%M']],
                hours: [p.Array, ['%Hh', '%H:%M']],
                days: [p.Array, ['%m/%d', '%a%d']],
                months: [p.Array, ['%m/%Y', '%b %Y']],
                years: [p.Array, ['%Y']],
            });
        };
        DatetimeTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            // TODO (bev) trigger update on format change
            this._update_width_formats();
        };
        DatetimeTickFormatter.prototype._update_width_formats = function () {
            var now = +tz(new Date());
            var _widths = function (fmt_strings) {
                var sizes = fmt_strings.map(function (fmt_string) { return _strftime(now, fmt_string).length; });
                var sorted = array_1.sort_by(array_1.zip(sizes, fmt_strings), function (_a) {
                    var size = _a[0];
                    return size;
                });
                return array_1.unzip(sorted);
            };
            this._width_formats = {
                microseconds: _widths(this.microseconds),
                milliseconds: _widths(this.milliseconds),
                seconds: _widths(this.seconds),
                minsec: _widths(this.minsec),
                minutes: _widths(this.minutes),
                hourmin: _widths(this.hourmin),
                hours: _widths(this.hours),
                days: _widths(this.days),
                months: _widths(this.months),
                years: _widths(this.years),
            };
        };
        // FIXME There is some unfortunate flicker when panning/zooming near the
        // span boundaries.
        // FIXME Rounding is weird at the 20-us scale and below.
        DatetimeTickFormatter.prototype._get_resolution_str = function (resolution_secs, span_secs) {
            // Our resolution boundaries should not be round numbers, because we want
            // them to fall between the possible tick intervals (which *are* round
            // numbers, as we've worked hard to ensure).  Consequently, we adjust the
            // resolution upwards a small amount (less than any possible step in
            // scales) to make the effective boundaries slightly lower.
            var adjusted_secs = resolution_secs * 1.1;
            switch (false) {
                case !(adjusted_secs < 1e-3): return "microseconds";
                case !(adjusted_secs < 1.0): return "milliseconds";
                case !(adjusted_secs < 60): return span_secs >= 60 ? "minsec" : "seconds";
                case !(adjusted_secs < 3600): return span_secs >= 3600 ? "hourmin" : "minutes";
                case !(adjusted_secs < (24 * 3600)): return "hours";
                case !(adjusted_secs < (31 * 24 * 3600)): return "days";
                case !(adjusted_secs < (365 * 24 * 3600)): return "months";
                default: return "years";
            }
        };
        DatetimeTickFormatter.prototype.doFormat = function (ticks, _opts) {
            // In order to pick the right set of labels, we need to determine
            // the resolution of the ticks.  We can do this using a ticker if
            // it's provided, or by computing the resolution from the actual
            // ticks we've been given.
            if (ticks.length == 0)
                return [];
            var span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000.0;
            var r = span / (ticks.length - 1);
            var resol = this._get_resolution_str(r, span);
            var _a = this._width_formats[resol], format = _a[1][0];
            // Apply the format to the tick values
            var labels = [];
            var resol_ndx = format_order.indexOf(resol);
            // This dictionary maps the name of a time resolution (in @format_order)
            // to its index in a time.localtime() timetuple.  The default is to map
            // everything to index 0, which is year.  This is not ideal; it might cause
            // a problem with the tick at midnight, january 1st, 0 a.d. being incorrectly
            // promoted at certain tick resolutions.
            var time_tuple_ndx_for_resol = {};
            for (var _i = 0, format_order_1 = format_order; _i < format_order_1.length; _i++) {
                var fmt = format_order_1[_i];
                time_tuple_ndx_for_resol[fmt] = 0;
            }
            time_tuple_ndx_for_resol.seconds = 5;
            time_tuple_ndx_for_resol.minsec = 4;
            time_tuple_ndx_for_resol.minutes = 4;
            time_tuple_ndx_for_resol.hourmin = 3;
            time_tuple_ndx_for_resol.hours = 3;
            // As we format each tick, check to see if we are at a boundary of the
            // next higher unit of time.  If so, replace the current format with one
            // from that resolution.  This is not the best heuristic in the world,
            // but it works!  There is some trickiness here due to having to deal
            // with hybrid formats in a reasonable manner.
            for (var _b = 0, ticks_1 = ticks; _b < ticks_1.length; _b++) {
                var t = ticks_1[_b];
                var s = void 0, tm = void 0;
                try {
                    tm = _array(t);
                    s = _strftime(t, format);
                }
                catch (error) {
                    logging_1.logger.warn("unable to format tick for timestamp value " + t);
                    logging_1.logger.warn(" - " + error);
                    labels.push("ERR");
                    continue;
                }
                var hybrid_handled = false;
                var next_ndx = resol_ndx;
                // The way to check that we are at the boundary of the next unit of
                // time is by checking that we have 0 units of the resolution, i.e.
                // we are at zero minutes, so display hours, or we are at zero seconds,
                // so display minutes (and if that is zero as well, then display hours).
                while (tm[time_tuple_ndx_for_resol[format_order[next_ndx]]] == 0) {
                    var next_format = void 0;
                    next_ndx += 1;
                    if (next_ndx == format_order.length)
                        break;
                    if ((resol == "minsec" || resol == "hourmin") && !hybrid_handled) {
                        if ((resol == "minsec" && tm[4] == 0 && tm[5] != 0) || (resol == "hourmin" && tm[3] == 0 && tm[4] != 0)) {
                            next_format = this._width_formats[format_order[resol_ndx - 1]][1][0];
                            s = _strftime(t, next_format);
                            break;
                        }
                        else {
                            hybrid_handled = true;
                        }
                    }
                    next_format = this._width_formats[format_order[next_ndx]][1][0];
                    s = _strftime(t, next_format);
                }
                // TODO: should expose this in api. %H, %d, etc use leading zeros and
                // users might prefer to see them lined up correctly.
                if (this.strip_leading_zeros) {
                    var ss = s.replace(/^0+/g, "");
                    if (ss != s && isNaN(parseInt(ss))) {
                        // If the string can now be parsed as starting with an integer, then
                        // leave all zeros stripped, otherwise start with a zero. Hence:
                        // A label such as '000ms' should leave one zero.
                        // A label such as '001ms' or '0-1ms' should not leave a leading zero.
                        ss = "0" + ss;
                    }
                    labels.push(ss);
                }
                else
                    labels.push(s);
            }
            return labels;
        };
        return DatetimeTickFormatter;
    }(tick_formatter_1.TickFormatter));
    exports.DatetimeTickFormatter = DatetimeTickFormatter;
    DatetimeTickFormatter.__name__ = "DatetimeTickFormatter";
    DatetimeTickFormatter.init_DatetimeTickFormatter();
},
/* timezone/index.js */ function _(require, module, exports) {
    !function (definition) {
        if (typeof module == "object" && module.exports)
            module.exports = definition();
        else if (typeof define == "function")
            define(definition);
        else
            this.tz = definition();
    }(function () {
        /*
          function die () {
            console.log.apply(console, __slice.call(arguments, 0));
            return process.exit(1);
          }
        
          function say () { return console.log.apply(console, __slice.call(arguments, 0)) }
        */
        function actualize(entry, rule, year) {
            var actualized, date = rule.day[1];
            do {
                actualized = new Date(Date.UTC(year, rule.month, Math.abs(date++)));
            } while (rule.day[0] < 7 && actualized.getUTCDay() != rule.day[0]);
            actualized = {
                clock: rule.clock,
                sort: actualized.getTime(),
                rule: rule,
                save: rule.save * 6e4,
                offset: entry.offset
            };
            actualized[actualized.clock] = actualized.sort + rule.time * 6e4;
            if (actualized.posix) {
                actualized.wallclock = actualized[actualized.clock] + (entry.offset + rule.saved);
            }
            else {
                actualized.posix = actualized[actualized.clock] - (entry.offset + rule.saved);
            }
            return actualized;
        }
        function find(request, clock, time) {
            var i, I, entry, found, zone = request[request.zone], actualized = [], abbrev, rules, j, year = new Date(time).getUTCFullYear(), off = 1;
            for (i = 1, I = zone.length; i < I; i++)
                if (zone[i][clock] <= time)
                    break;
            entry = zone[i];
            if (entry.rules) {
                rules = request[entry.rules];
                for (j = year + 1; j >= year - off; --j)
                    for (i = 0, I = rules.length; i < I; i++)
                        if (rules[i].from <= j && j <= rules[i].to)
                            actualized.push(actualize(entry, rules[i], j));
                        else if (rules[i].to < j && off == 1)
                            off = j - rules[i].to;
                actualized.sort(function (a, b) { return a.sort - b.sort; });
                for (i = 0, I = actualized.length; i < I; i++) {
                    if (time >= actualized[i][clock] && actualized[i][actualized[i].clock] > entry[actualized[i].clock])
                        found = actualized[i];
                }
            }
            if (found) {
                if (abbrev = /^(.*)\/(.*)$/.exec(entry.format)) {
                    found.abbrev = abbrev[found.save ? 2 : 1];
                }
                else {
                    found.abbrev = entry.format.replace(/%s/, found.rule.letter);
                }
            }
            return found || entry;
        }
        function convertToWallclock(request, posix) {
            if (request.zone == "UTC")
                return posix;
            request.entry = find(request, "posix", posix);
            return posix + request.entry.offset + request.entry.save;
        }
        function convertToPOSIX(request, wallclock) {
            if (request.zone == "UTC")
                return wallclock;
            var entry, diff;
            request.entry = entry = find(request, "wallclock", wallclock);
            diff = wallclock - entry.wallclock;
            return 0 < diff && diff < entry.save ? null : wallclock - entry.offset - entry.save;
        }
        function adjust(request, posix, match) {
            var increment = +(match[1] + 1) // conversion necessary for week day addition
            , offset = match[2] * increment, index = UNITS.indexOf(match[3].toLowerCase()), date;
            if (index > 9) {
                posix += offset * TIME[index - 10];
            }
            else {
                date = new Date(convertToWallclock(request, posix));
                if (index < 7) {
                    while (offset) {
                        date.setUTCDate(date.getUTCDate() + increment);
                        if (date.getUTCDay() == index)
                            offset -= increment;
                    }
                }
                else if (index == 7) {
                    date.setUTCFullYear(date.getUTCFullYear() + offset);
                }
                else if (index == 8) {
                    date.setUTCMonth(date.getUTCMonth() + offset);
                }
                else {
                    date.setUTCDate(date.getUTCDate() + offset);
                }
                if ((posix = convertToPOSIX(request, date.getTime())) == null) {
                    posix = convertToPOSIX(request, date.getTime() + 864e5 * increment) - 864e5 * increment;
                }
            }
            return posix;
        }
        function convert(vargs) {
            if (!vargs.length)
                return "1.0.22";
            var request = Object.create(this), adjustments = [], i, I, $, argument, date;
            for (i = 0; i < vargs.length; i++) { // leave the for loop alone, it works.
                argument = vargs[i];
                // https://twitter.com/bigeasy/status/215112186572439552
                if (Array.isArray(argument)) {
                    if (!i && !isNaN(argument[1])) {
                        date = argument;
                    }
                    else {
                        argument.splice.apply(vargs, [i--, 1].concat(argument));
                    }
                }
                else if (isNaN(argument)) {
                    $ = typeof argument;
                    if ($ == "string") {
                        if (~argument.indexOf("%")) {
                            request.format = argument;
                        }
                        else if (!i && argument == "*") {
                            date = argument;
                        }
                        else if (!i && ($ = /^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(argument))) {
                            date = [];
                            date.push.apply(date, $.slice(1, 8));
                            if ($[9]) {
                                date.push($[10] + 1);
                                date.push.apply(date, $[11].split(/:/));
                            }
                            else if ($[8]) {
                                date.push(1);
                            }
                        }
                        else if (/^\w{2,3}_\w{2}$/.test(argument)) {
                            request.locale = argument;
                        }
                        else if ($ = UNIT_RE.exec(argument)) {
                            adjustments.push($);
                        }
                        else {
                            request.zone = argument;
                        }
                    }
                    else if ($ == "function") {
                        if ($ = argument.call(request))
                            return $;
                    }
                    else if (/^\w{2,3}_\w{2}$/.test(argument.name)) {
                        request[argument.name] = argument;
                    }
                    else if (argument.zones) {
                        for ($ in argument.zones)
                            request[$] = argument.zones[$];
                        for ($ in argument.rules)
                            request[$] = argument.rules[$];
                    }
                }
                else if (!i) {
                    date = argument;
                }
            }
            if (!request[request.locale])
                delete request.locale;
            if (!request[request.zone])
                delete request.zone;
            if (date != null) {
                if (date == "*") {
                    date = request.clock();
                }
                else if (Array.isArray(date)) {
                    $ = [];
                    I = !date[7];
                    for (i = 0; i < 11; i++)
                        $[i] = +(date[i] || 0); // conversion necessary for decrement
                    --$[1]; // Grr..
                    date = Date.UTC.apply(Date.UTC, $) + -$[7] * ($[8] * 36e5 + $[9] * 6e4 + $[10] * 1e3);
                }
                else {
                    date = Math.floor(date);
                }
                if (!isNaN(date)) {
                    if (I)
                        date = convertToPOSIX(request, date);
                    if (date == null)
                        return date;
                    for (i = 0, I = adjustments.length; i < I; i++) {
                        date = adjust(request, date, adjustments[i]);
                    }
                    if (!request.format)
                        return date;
                    $ = new Date(convertToWallclock(request, date));
                    return request.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g, function (value, flag, colons, padding, specifier) {
                        var f, fill = "0", pad;
                        if (f = request[specifier]) {
                            value = String(f.call(request, $, date, flag, colons.length));
                            if ((flag || f.style) == "_")
                                fill = " ";
                            pad = flag == "-" ? 0 : f.pad || 0;
                            while (value.length < pad)
                                value = fill + value;
                            pad = flag == "-" ? 0 : padding || f.pad;
                            while (value.length < pad)
                                value = fill + value;
                            if (specifier == "N" && pad < value.length)
                                value = value.slice(0, pad);
                            if (flag == "^")
                                value = value.toUpperCase();
                        }
                        return value;
                    });
                }
            }
            return function () { return request.convert(arguments); };
        }
        var context = { clock: function () { return +(new Date()); },
            zone: "UTC",
            entry: { abbrev: "UTC", offset: 0, save: 0 },
            UTC: 1,
            z: function (date, posix, flag, delimiters) {
                var offset = this.entry.offset + this.entry.save, seconds = Math.abs(offset / 1000), parts = [], part = 3600, i, z;
                for (i = 0; i < 3; i++) {
                    parts.push(("0" + Math.floor(seconds / part)).slice(-2));
                    seconds %= part;
                    part /= 60;
                }
                if (flag == "^" && !offset)
                    return "Z";
                if (flag == "^")
                    delimiters = 3;
                if (delimiters == 3) {
                    z = parts.join(":");
                    z = z.replace(/:00$/, "");
                    if (flag != "^")
                        z = z.replace(/:00$/, "");
                }
                else if (delimiters) {
                    z = parts.slice(0, delimiters + 1).join(":");
                    if (flag == "^")
                        z = z.replace(/:00$/, "");
                }
                else {
                    z = parts.slice(0, 2).join("");
                }
                z = (offset < 0 ? "-" : "+") + z;
                z = z.replace(/([-+])(0)/, { "_": " $1", "-": "$1" }[flag] || "$1$2");
                return z;
            },
            "%": function (date) { return "%"; },
            n: function (date) { return "\n"; },
            t: function (date) { return "\t"; },
            U: function (date) { return weekOfYear(date, 0); },
            W: function (date) { return weekOfYear(date, 1); },
            V: function (date) { return isoWeek(date)[0]; },
            G: function (date) { return isoWeek(date)[1]; },
            g: function (date) { return isoWeek(date)[1] % 100; },
            j: function (date) { return Math.floor((date.getTime() - Date.UTC(date.getUTCFullYear(), 0)) / 864e5) + 1; },
            s: function (date) { return Math.floor(date.getTime() / 1000); },
            C: function (date) { return Math.floor(date.getUTCFullYear() / 100); },
            N: function (date) { return date.getTime() % 1000 * 1000000; },
            m: function (date) { return date.getUTCMonth() + 1; },
            Y: function (date) { return date.getUTCFullYear(); },
            y: function (date) { return date.getUTCFullYear() % 100; },
            H: function (date) { return date.getUTCHours(); },
            M: function (date) { return date.getUTCMinutes(); },
            S: function (date) { return date.getUTCSeconds(); },
            e: function (date) { return date.getUTCDate(); },
            d: function (date) { return date.getUTCDate(); },
            u: function (date) { return date.getUTCDay() || 7; },
            w: function (date) { return date.getUTCDay(); },
            l: function (date) { return date.getUTCHours() % 12 || 12; },
            I: function (date) { return date.getUTCHours() % 12 || 12; },
            k: function (date) { return date.getUTCHours(); },
            Z: function (date) { return this.entry.abbrev; },
            a: function (date) { return this[this.locale].day.abbrev[date.getUTCDay()]; },
            A: function (date) { return this[this.locale].day.full[date.getUTCDay()]; },
            h: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()]; },
            b: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()]; },
            B: function (date) { return this[this.locale].month.full[date.getUTCMonth()]; },
            P: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)].toLowerCase(); },
            p: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)]; },
            R: function (date, posix) { return this.convert([posix, "%H:%M"]); },
            T: function (date, posix) { return this.convert([posix, "%H:%M:%S"]); },
            D: function (date, posix) { return this.convert([posix, "%m/%d/%y"]); },
            F: function (date, posix) { return this.convert([posix, "%Y-%m-%d"]); },
            x: function (date, posix) { return this.convert([posix, this[this.locale].date]); },
            r: function (date, posix) { return this.convert([posix, this[this.locale].time12 || '%I:%M:%S']); },
            X: function (date, posix) { return this.convert([posix, this[this.locale].time24]); },
            c: function (date, posix) { return this.convert([posix, this[this.locale].dateTime]); },
            convert: convert,
            locale: "en_US",
            en_US: {
                date: "%m/%d/%Y",
                time24: "%I:%M:%S %p",
                time12: "%I:%M:%S %p",
                dateTime: "%a %d %b %Y %I:%M:%S %p %Z",
                meridiem: ["AM", "PM"],
                month: {
                    abbrev: "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),
                    full: "January|February|March|April|May|June|July|August|September|October|November|December".split("|")
                },
                day: {
                    abbrev: "Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),
                    full: "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")
                }
            }
        };
        var UNITS = "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond", UNIT_RE = new RegExp("^\\s*([+-])(\\d+)\\s+(" + UNITS + ")s?\\s*$", "i"), TIME = [36e5, 6e4, 1e3, 1];
        UNITS = UNITS.toLowerCase().split("|");
        "delmHMSUWVgCIky".replace(/./g, function (e) { context[e].pad = 2; });
        context.N.pad = 9;
        context.j.pad = 3;
        context.k.style = "_";
        context.l.style = "_";
        context.e.style = "_";
        function weekOfYear(date, startOfWeek) {
            var diff, nyd, weekStart;
            nyd = new Date(Date.UTC(date.getUTCFullYear(), 0));
            diff = Math.floor((date.getTime() - nyd.getTime()) / 864e5);
            if (nyd.getUTCDay() == startOfWeek) {
                weekStart = 0;
            }
            else {
                weekStart = 7 - nyd.getUTCDay() + startOfWeek;
                if (weekStart == 8) {
                    weekStart = 1;
                }
            }
            return diff >= weekStart ? Math.floor((diff - weekStart) / 7) + 1 : 0;
        }
        function isoWeek(date) {
            var nyd, nyy, week;
            nyy = date.getUTCFullYear();
            nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
            week = weekOfYear(date, 1) + (nyd > 1 && nyd <= 4 ? 1 : 0);
            if (!week) {
                nyy = date.getUTCFullYear() - 1;
                nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
                week = nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29) ? 53 : 52;
                return [week, date.getUTCFullYear() - 1];
            }
            else if (week == 53 && !(nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29))) {
                return [1, date.getUTCFullYear() + 1];
            }
            else {
                return [week, date.getUTCFullYear()];
            }
        }
        return function () { return context.convert(arguments); };
    });
},
/* core/util/templating.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var sprintf_js_1 = require(254) /* sprintf-js */;
    var Numbro = require(255) /* numbro */;
    var tz = require(252) /* timezone */;
    var string_1 = require(127) /* ./string */;
    var types_1 = require(109) /* ./types */;
    function sprintf(format) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return sprintf_js_1.sprintf.apply(sprintf_js_1, tslib_1.__spreadArrays([format], args));
    }
    exports.sprintf = sprintf;
    exports.DEFAULT_FORMATTERS = {
        numeral: function (value, format, _special_vars) { return Numbro.format(value, format); },
        datetime: function (value, format, _special_vars) { return tz(value, format); },
        printf: function (value, format, _special_vars) { return sprintf(format, value); },
    };
    function basic_formatter(value, _format, _special_vars) {
        if (types_1.isNumber(value)) {
            var format = (function () {
                switch (false) {
                    case Math.floor(value) != value:
                        return "%d";
                    case !(Math.abs(value) > 0.1) || !(Math.abs(value) < 1000):
                        return "%0.3f";
                    default:
                        return "%0.3e";
                }
            })();
            return sprintf(format, value);
        }
        else
            return "" + value; // get strings for categorical types
    }
    exports.basic_formatter = basic_formatter;
    function get_formatter(name, raw_spec, format, formatters) {
        // no format, use default built in formatter
        if (format == null)
            return basic_formatter;
        // format spec in the formatters dict, use that
        if (formatters != null && (name in formatters || raw_spec in formatters)) {
            // some day (Bokeh 2.0) we can get rid of the check for name, and just check the raw spec
            // keep it now for compatibility but do not demonstrate it anywhere
            var key = raw_spec in formatters ? raw_spec : name;
            var formatter_1 = formatters[key];
            if (types_1.isString(formatter_1)) {
                if (formatter_1 in exports.DEFAULT_FORMATTERS)
                    return exports.DEFAULT_FORMATTERS[formatter_1];
                else
                    throw new Error("Unknown tooltip field formatter type '" + formatter_1 + "'");
            }
            return function (value, format, special_vars) {
                return formatter_1.format(value, format, special_vars);
            };
        }
        // otherwise use "numeral" as default
        return exports.DEFAULT_FORMATTERS.numeral;
    }
    exports.get_formatter = get_formatter;
    function get_value(name, data_source, i, special_vars) {
        if (name[0] == "$") {
            if (name.substring(1) in special_vars)
                return special_vars[name.substring(1)];
            else
                throw new Error("Unknown special variable '" + name + "'");
        }
        var column = data_source.get_column(name);
        // missing column
        if (column == null)
            return null;
        // typical (non-image) index
        if (types_1.isNumber(i))
            return column[i];
        // image index
        var data = column[i.index];
        if (types_1.isTypedArray(data) || types_1.isArray(data)) {
            // inspect array of arrays
            if (types_1.isArray(data[0])) {
                var row = data[i.dim2];
                return row[i.dim1];
            }
            else
                return data[i.flat_index]; // inspect flat array
        }
        else
            return data; // inspect per-image scalar data
    }
    exports.get_value = get_value;
    function replace_placeholders(str, data_source, i, formatters, special_vars) {
        if (special_vars === void 0) {
            special_vars = {};
        }
        // this extracts the $x, @x, @{x} without any trailing {format}
        var raw_spec = str.replace(/(?:^|[^@])([@|\$](?:\w+|{[^{}]+}))(?:{[^{}]+})?/g, function (_match, raw_spec, _format) { return "" + raw_spec; });
        // this handles the special case @$name, replacing it with an @var corresponding to special_vars.name
        str = str.replace(/@\$name/g, function (_match) { return "@{" + special_vars.name + "}"; });
        // this prepends special vars with "@", e.g "$x" becomes "@$x", so subsequent processing is simpler
        str = str.replace(/(^|[^\$])\$(\w+)/g, function (_match, prefix, name) { return prefix + "@$" + name; });
        str = str.replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g, function (_match, prefix, name, long_name, format) {
            name = long_name != null ? long_name : name;
            var value = get_value(name, data_source, i, special_vars);
            // missing value, return ???
            if (value == null)
                return "" + prefix + string_1.escape("???");
            // 'safe' format, return the value as-is
            if (format == 'safe')
                return "" + prefix + value;
            // format and escape everything else
            var formatter = get_formatter(name, raw_spec, format, formatters);
            return "" + prefix + string_1.escape(formatter(value, format, special_vars));
        });
        return str;
    }
    exports.replace_placeholders = replace_placeholders;
},
/* sprintf-js/src/sprintf.js */ function _(require, module, exports) {
    /* global window, exports, define */
    !function () {
        'use strict';
        var re = {
            not_string: /[^s]/,
            not_bool: /[^t]/,
            not_type: /[^T]/,
            not_primitive: /[^v]/,
            number: /[diefg]/,
            numeric_arg: /[bcdiefguxX]/,
            json: /[j]/,
            not_json: /[^j]/,
            text: /^[^\x25]+/,
            modulo: /^\x25{2}/,
            placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
            key: /^([a-z_][a-z_\d]*)/i,
            key_access: /^\.([a-z_][a-z_\d]*)/i,
            index_access: /^\[(\d+)\]/,
            sign: /^[+-]/
        };
        function sprintf(key) {
            // `arguments` is not an array, but should be fine for this call
            return sprintf_format(sprintf_parse(key), arguments);
        }
        function vsprintf(fmt, argv) {
            return sprintf.apply(null, [fmt].concat(argv || []));
        }
        function sprintf_format(parse_tree, argv) {
            var cursor = 1, tree_length = parse_tree.length, arg, output = '', i, k, ph, pad, pad_character, pad_length, is_positive, sign;
            for (i = 0; i < tree_length; i++) {
                if (typeof parse_tree[i] === 'string') {
                    output += parse_tree[i];
                }
                else if (typeof parse_tree[i] === 'object') {
                    ph = parse_tree[i]; // convenience purposes only
                    if (ph.keys) { // keyword argument
                        arg = argv[cursor];
                        for (k = 0; k < ph.keys.length; k++) {
                            if (arg == undefined) {
                                throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
                            }
                            arg = arg[ph.keys[k]];
                        }
                    }
                    else if (ph.param_no) { // positional argument (explicit)
                        arg = argv[ph.param_no];
                    }
                    else { // positional argument (implicit)
                        arg = argv[cursor++];
                    }
                    if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
                        arg = arg();
                    }
                    if (re.numeric_arg.test(ph.type) && (typeof arg !== 'number' && isNaN(arg))) {
                        throw new TypeError(sprintf('[sprintf] expecting number but found %T', arg));
                    }
                    if (re.number.test(ph.type)) {
                        is_positive = arg >= 0;
                    }
                    switch (ph.type) {
                        case 'b':
                            arg = parseInt(arg, 10).toString(2);
                            break;
                        case 'c':
                            arg = String.fromCharCode(parseInt(arg, 10));
                            break;
                        case 'd':
                        case 'i':
                            arg = parseInt(arg, 10);
                            break;
                        case 'j':
                            arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
                            break;
                        case 'e':
                            arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
                            break;
                        case 'f':
                            arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
                            break;
                        case 'g':
                            arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
                            break;
                        case 'o':
                            arg = (parseInt(arg, 10) >>> 0).toString(8);
                            break;
                        case 's':
                            arg = String(arg);
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 't':
                            arg = String(!!arg);
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'T':
                            arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'u':
                            arg = parseInt(arg, 10) >>> 0;
                            break;
                        case 'v':
                            arg = arg.valueOf();
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'x':
                            arg = (parseInt(arg, 10) >>> 0).toString(16);
                            break;
                        case 'X':
                            arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
                            break;
                    }
                    if (re.json.test(ph.type)) {
                        output += arg;
                    }
                    else {
                        if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
                            sign = is_positive ? '+' : '-';
                            arg = arg.toString().replace(re.sign, '');
                        }
                        else {
                            sign = '';
                        }
                        pad_character = ph.pad_char ? ph.pad_char === '0' ? '0' : ph.pad_char.charAt(1) : ' ';
                        pad_length = ph.width - (sign + arg).length;
                        pad = ph.width ? (pad_length > 0 ? pad_character.repeat(pad_length) : '') : '';
                        output += ph.align ? sign + arg + pad : (pad_character === '0' ? sign + pad + arg : pad + sign + arg);
                    }
                }
            }
            return output;
        }
        var sprintf_cache = Object.create(null);
        function sprintf_parse(fmt) {
            if (sprintf_cache[fmt]) {
                return sprintf_cache[fmt];
            }
            var _fmt = fmt, match, parse_tree = [], arg_names = 0;
            while (_fmt) {
                if ((match = re.text.exec(_fmt)) !== null) {
                    parse_tree.push(match[0]);
                }
                else if ((match = re.modulo.exec(_fmt)) !== null) {
                    parse_tree.push('%');
                }
                else if ((match = re.placeholder.exec(_fmt)) !== null) {
                    if (match[2]) {
                        arg_names |= 1;
                        var field_list = [], replacement_field = match[2], field_match = [];
                        if ((field_match = re.key.exec(replacement_field)) !== null) {
                            field_list.push(field_match[1]);
                            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== '') {
                                if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else {
                                    throw new SyntaxError('[sprintf] failed to parse named argument key');
                                }
                            }
                        }
                        else {
                            throw new SyntaxError('[sprintf] failed to parse named argument key');
                        }
                        match[2] = field_list;
                    }
                    else {
                        arg_names |= 2;
                    }
                    if (arg_names === 3) {
                        throw new Error('[sprintf] mixing positional and named placeholders is not (yet) supported');
                    }
                    parse_tree.push({
                        placeholder: match[0],
                        param_no: match[1],
                        keys: match[2],
                        sign: match[3],
                        pad_char: match[4],
                        align: match[5],
                        width: match[6],
                        precision: match[7],
                        type: match[8]
                    });
                }
                else {
                    throw new SyntaxError('[sprintf] unexpected placeholder');
                }
                _fmt = _fmt.substring(match[0].length);
            }
            return sprintf_cache[fmt] = parse_tree;
        }
        /**
         * export to either browser or node.js
         */
        /* eslint-disable quote-props */
        if (typeof exports !== 'undefined') {
            exports['sprintf'] = sprintf;
            exports['vsprintf'] = vsprintf;
        }
        if (typeof window !== 'undefined') {
            window['sprintf'] = sprintf;
            window['vsprintf'] = vsprintf;
            if (typeof define === 'function' && define['amd']) {
                define(function () {
                    return {
                        'sprintf': sprintf,
                        'vsprintf': vsprintf
                    };
                });
            }
        }
        /* eslint-enable quote-props */
    }(); // eslint-disable-line
},
/* numbro/numbro.js */ function _(require, module, exports) {
    /*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
    /************************************
        Constants
    ************************************/
    var numbro, VERSION = '1.6.2', 
    // internal storage for culture config files
    cultures = {}, 
    // Todo: Remove in 2.0.0
    languages = cultures, currentCulture = 'en-US', zeroFormat = null, defaultFormat = '0,0', defaultCurrencyFormat = '0$', 
    // check for nodeJS
    hasModule = (typeof module !== 'undefined' && module.exports), 
    // default culture
    enUS = {
        delimiters: {
            thousands: ',',
            decimal: '.'
        },
        abbreviations: {
            thousand: 'k',
            million: 'm',
            billion: 'b',
            trillion: 't'
        },
        ordinal: function (number) {
            var b = number % 10;
            return (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                    (b === 2) ? 'nd' :
                        (b === 3) ? 'rd' : 'th';
        },
        currency: {
            symbol: '$',
            position: 'prefix'
        },
        defaults: {
            currencyFormat: ',0000 a'
        },
        formats: {
            fourDigits: '0000 a',
            fullWithTwoDecimals: '$ ,0.00',
            fullWithTwoDecimalsNoCurrency: ',0.00'
        }
    };
    /************************************
        Constructors
    ************************************/
    // Numbro prototype object
    function Numbro(number) {
        this._value = number;
    }
    function zeroes(count) {
        var i, ret = '';
        for (i = 0; i < count; i++) {
            ret += '0';
        }
        return ret;
    }
    /**
     * Implementation of toFixed() for numbers with exponent > 21
     *
     *
     */
    function toFixedLarge(value, precision) {
        var mantissa, beforeDec, afterDec, exponent, str;
        str = value.toString();
        mantissa = str.split('e')[0];
        exponent = str.split('e')[1];
        beforeDec = mantissa.split('.')[0];
        afterDec = mantissa.split('.')[1] || '';
        str = beforeDec + afterDec + zeroes(exponent - afterDec.length);
        if (precision > 0) {
            str += '.' + zeroes(precision);
        }
        return str;
    }
    /**
     * Implementation of toFixed() that treats floats more like decimals
     *
     * Fixes binary rounding issues (eg. (0.615).toFixed(2) === '0.61') that present
     * problems for accounting- and finance-related software.
     */
    function toFixed(value, precision, roundingFunction, optionals) {
        var power = Math.pow(10, precision), optionalsRegExp, output;
        if (value.toFixed(0).search('e') > -1) {
            // Above 1e21, toFixed returns scientific notation, which
            // is useless and unexpected
            output = toFixedLarge(value, precision);
        }
        else {
            //roundingFunction = (roundingFunction !== undefined ? roundingFunction : Math.round);
            // Multiply up by precision, round accurately, then divide and use native toFixed():
            output = (roundingFunction(value * power) / power).toFixed(precision);
        }
        if (optionals) {
            optionalsRegExp = new RegExp('0{1,' + optionals + '}$');
            output = output.replace(optionalsRegExp, '');
        }
        return output;
    }
    /************************************
        Formatting
    ************************************/
    // determine what type of formatting we need to do
    function formatNumbro(value, format, roundingFunction) {
        var output;
        // TODO: do something with `language`
        // figure out what kind of format we are dealing with
        if (format.indexOf('$') > -1) { // currency!!!!!
            output = formatCurrency(value, format, roundingFunction);
        }
        else if (format.indexOf('%') > -1) { // percentage
            output = formatPercentage(value, format, roundingFunction);
        }
        else if (format.indexOf(':') > -1) { // time
            output = formatTime(value);
        }
        else { // plain ol' numbers or bytes
            output = formatNumber(value, format, roundingFunction);
        }
        // return string
        return output;
    }
    function formatCurrency(value, originalFormat, roundingFunction) {
        var format = originalFormat, symbolIndex = format.indexOf('$'), openParenIndex = format.indexOf('('), plusSignIndex = format.indexOf('+'), minusSignIndex = format.indexOf('-'), space = '', decimalSeparator = '', spliceIndex, output;
        if (format.indexOf('$') === -1) {
            // Use defaults instead of the format provided
            if (cultures[currentCulture].currency.position === 'infix') {
                decimalSeparator = cultures[currentCulture].currency.symbol;
                if (cultures[currentCulture].currency.spaceSeparated) {
                    decimalSeparator = ' ' + decimalSeparator + ' ';
                }
            }
            else if (cultures[currentCulture].currency.spaceSeparated) {
                space = ' ';
            }
        }
        else {
            // check for space before or after currency
            if (format.indexOf(' $') > -1) {
                space = ' ';
                format = format.replace(' $', '');
            }
            else if (format.indexOf('$ ') > -1) {
                space = ' ';
                format = format.replace('$ ', '');
            }
            else {
                format = format.replace('$', '');
            }
        }
        // Format The Number
        output = formatNumber(value, format, roundingFunction, decimalSeparator);
        if (originalFormat.indexOf('$') === -1) {
            // Use defaults instead of the format provided
            switch (cultures[currentCulture].currency.position) {
                case 'postfix':
                    if (output.indexOf(')') > -1) {
                        output = output.split('');
                        output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
                        output = output.join('');
                    }
                    else {
                        output = output + space + cultures[currentCulture].currency.symbol;
                    }
                    break;
                case 'infix':
                    break;
                case 'prefix':
                    if (output.indexOf('(') > -1 || output.indexOf('-') > -1) {
                        output = output.split('');
                        spliceIndex = Math.max(openParenIndex, minusSignIndex) + 1;
                        output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
                        output = output.join('');
                    }
                    else {
                        output = cultures[currentCulture].currency.symbol + space + output;
                    }
                    break;
                default:
                    throw Error('Currency position should be among ["prefix", "infix", "postfix"]');
            }
        }
        else {
            // position the symbol
            if (symbolIndex <= 1) {
                if (output.indexOf('(') > -1 || output.indexOf('+') > -1 || output.indexOf('-') > -1) {
                    output = output.split('');
                    spliceIndex = 1;
                    if (symbolIndex < openParenIndex || symbolIndex < plusSignIndex || symbolIndex < minusSignIndex) {
                        // the symbol appears before the "(", "+" or "-"
                        spliceIndex = 0;
                    }
                    output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
                    output = output.join('');
                }
                else {
                    output = cultures[currentCulture].currency.symbol + space + output;
                }
            }
            else {
                if (output.indexOf(')') > -1) {
                    output = output.split('');
                    output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
                    output = output.join('');
                }
                else {
                    output = output + space + cultures[currentCulture].currency.symbol;
                }
            }
        }
        return output;
    }
    function formatPercentage(value, format, roundingFunction) {
        var space = '', output;
        value = value * 100;
        // check for space before %
        if (format.indexOf(' %') > -1) {
            space = ' ';
            format = format.replace(' %', '');
        }
        else {
            format = format.replace('%', '');
        }
        output = formatNumber(value, format, roundingFunction);
        if (output.indexOf(')') > -1) {
            output = output.split('');
            output.splice(-1, 0, space + '%');
            output = output.join('');
        }
        else {
            output = output + space + '%';
        }
        return output;
    }
    function formatTime(value) {
        var hours = Math.floor(value / 60 / 60), minutes = Math.floor((value - (hours * 60 * 60)) / 60), seconds = Math.round(value - (hours * 60 * 60) - (minutes * 60));
        return hours + ':' +
            ((minutes < 10) ? '0' + minutes : minutes) + ':' +
            ((seconds < 10) ? '0' + seconds : seconds);
    }
    function formatNumber(value, format, roundingFunction, sep) {
        var negP = false, signed = false, optDec = false, abbr = '', i, abbrK = false, // force abbreviation to thousands
        abbrM = false, // force abbreviation to millions
        abbrB = false, // force abbreviation to billions
        abbrT = false, // force abbreviation to trillions
        abbrForce = false, // force abbreviation
        bytes = '', ord = '', abs = Math.abs(value), binarySuffixes = ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'], decimalSuffixes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'], min, max, power, totalLength, length, minimumPrecision, pow, w, intPrecision, precision, prefix, postfix, thousands, d = '', forcedNeg = false, neg = false, indexOpenP, size, indexMinus, paren = '', minlen;
        // check if number is zero and a custom zero format has been set
        if (value === 0 && zeroFormat !== null) {
            return zeroFormat;
        }
        if (!isFinite(value)) {
            return '' + value;
        }
        if (format.indexOf('{') === 0) {
            var end = format.indexOf('}');
            if (end === -1) {
                throw Error('Format should also contain a "}"');
            }
            prefix = format.slice(1, end);
            format = format.slice(end + 1);
        }
        else {
            prefix = '';
        }
        if (format.indexOf('}') === format.length - 1) {
            var start = format.indexOf('{');
            if (start === -1) {
                throw Error('Format should also contain a "{"');
            }
            postfix = format.slice(start + 1, -1);
            format = format.slice(0, start + 1);
        }
        else {
            postfix = '';
        }
        // check for min length
        var info;
        if (format.indexOf('.') === -1) {
            info = format.match(/([0-9]+).*/);
        }
        else {
            info = format.match(/([0-9]+)\..*/);
        }
        minlen = info === null ? -1 : info[1].length;
        // see if we should use parentheses for negative number or if we should prefix with a sign
        // if both are present we default to parentheses
        if (format.indexOf('-') !== -1) {
            forcedNeg = true;
        }
        if (format.indexOf('(') > -1) {
            negP = true;
            format = format.slice(1, -1);
        }
        else if (format.indexOf('+') > -1) {
            signed = true;
            format = format.replace(/\+/g, '');
        }
        // see if abbreviation is wanted
        if (format.indexOf('a') > -1) {
            intPrecision = format.split('.')[0].match(/[0-9]+/g) || ['0'];
            intPrecision = parseInt(intPrecision[0], 10);
            // check if abbreviation is specified
            abbrK = format.indexOf('aK') >= 0;
            abbrM = format.indexOf('aM') >= 0;
            abbrB = format.indexOf('aB') >= 0;
            abbrT = format.indexOf('aT') >= 0;
            abbrForce = abbrK || abbrM || abbrB || abbrT;
            // check for space before abbreviation
            if (format.indexOf(' a') > -1) {
                abbr = ' ';
                format = format.replace(' a', '');
            }
            else {
                format = format.replace('a', '');
            }
            totalLength = Math.floor(Math.log(abs) / Math.LN10) + 1;
            minimumPrecision = totalLength % 3;
            minimumPrecision = minimumPrecision === 0 ? 3 : minimumPrecision;
            if (intPrecision && abs !== 0) {
                length = Math.floor(Math.log(abs) / Math.LN10) + 1 - intPrecision;
                pow = 3 * ~~((Math.min(intPrecision, totalLength) - minimumPrecision) / 3);
                abs = abs / Math.pow(10, pow);
                if (format.indexOf('.') === -1 && intPrecision > 3) {
                    format += '[.]';
                    size = length === 0 ? 0 : 3 * ~~(length / 3) - length;
                    size = size < 0 ? size + 3 : size;
                    for (i = 0; i < size; i++) {
                        format += '0';
                    }
                }
            }
            if (Math.floor(Math.log(Math.abs(value)) / Math.LN10) + 1 !== intPrecision) {
                if (abs >= Math.pow(10, 12) && !abbrForce || abbrT) {
                    // trillion
                    abbr = abbr + cultures[currentCulture].abbreviations.trillion;
                    value = value / Math.pow(10, 12);
                }
                else if (abs < Math.pow(10, 12) && abs >= Math.pow(10, 9) && !abbrForce || abbrB) {
                    // billion
                    abbr = abbr + cultures[currentCulture].abbreviations.billion;
                    value = value / Math.pow(10, 9);
                }
                else if (abs < Math.pow(10, 9) && abs >= Math.pow(10, 6) && !abbrForce || abbrM) {
                    // million
                    abbr = abbr + cultures[currentCulture].abbreviations.million;
                    value = value / Math.pow(10, 6);
                }
                else if (abs < Math.pow(10, 6) && abs >= Math.pow(10, 3) && !abbrForce || abbrK) {
                    // thousand
                    abbr = abbr + cultures[currentCulture].abbreviations.thousand;
                    value = value / Math.pow(10, 3);
                }
            }
        }
        // see if we are formatting binary bytes
        if (format.indexOf('b') > -1) {
            // check for space before
            if (format.indexOf(' b') > -1) {
                bytes = ' ';
                format = format.replace(' b', '');
            }
            else {
                format = format.replace('b', '');
            }
            for (power = 0; power <= binarySuffixes.length; power++) {
                min = Math.pow(1024, power);
                max = Math.pow(1024, power + 1);
                if (value >= min && value < max) {
                    bytes = bytes + binarySuffixes[power];
                    if (min > 0) {
                        value = value / min;
                    }
                    break;
                }
            }
        }
        // see if we are formatting decimal bytes
        if (format.indexOf('d') > -1) {
            // check for space before
            if (format.indexOf(' d') > -1) {
                bytes = ' ';
                format = format.replace(' d', '');
            }
            else {
                format = format.replace('d', '');
            }
            for (power = 0; power <= decimalSuffixes.length; power++) {
                min = Math.pow(1000, power);
                max = Math.pow(1000, power + 1);
                if (value >= min && value < max) {
                    bytes = bytes + decimalSuffixes[power];
                    if (min > 0) {
                        value = value / min;
                    }
                    break;
                }
            }
        }
        // see if ordinal is wanted
        if (format.indexOf('o') > -1) {
            // check for space before
            if (format.indexOf(' o') > -1) {
                ord = ' ';
                format = format.replace(' o', '');
            }
            else {
                format = format.replace('o', '');
            }
            if (cultures[currentCulture].ordinal) {
                ord = ord + cultures[currentCulture].ordinal(value);
            }
        }
        if (format.indexOf('[.]') > -1) {
            optDec = true;
            format = format.replace('[.]', '.');
        }
        w = value.toString().split('.')[0];
        precision = format.split('.')[1];
        thousands = format.indexOf(',');
        if (precision) {
            if (precision.indexOf('*') !== -1) {
                d = toFixed(value, value.toString().split('.')[1].length, roundingFunction);
            }
            else {
                if (precision.indexOf('[') > -1) {
                    precision = precision.replace(']', '');
                    precision = precision.split('[');
                    d = toFixed(value, (precision[0].length + precision[1].length), roundingFunction, precision[1].length);
                }
                else {
                    d = toFixed(value, precision.length, roundingFunction);
                }
            }
            w = d.split('.')[0];
            if (d.split('.')[1].length) {
                var p = sep ? abbr + sep : cultures[currentCulture].delimiters.decimal;
                d = p + d.split('.')[1];
            }
            else {
                d = '';
            }
            if (optDec && Number(d.slice(1)) === 0) {
                d = '';
            }
        }
        else {
            w = toFixed(value, null, roundingFunction);
        }
        // format number
        if (w.indexOf('-') > -1) {
            w = w.slice(1);
            neg = true;
        }
        if (w.length < minlen) {
            w = new Array(minlen - w.length + 1).join('0') + w;
        }
        if (thousands > -1) {
            w = w.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' +
                cultures[currentCulture].delimiters.thousands);
        }
        if (format.indexOf('.') === 0) {
            w = '';
        }
        indexOpenP = format.indexOf('(');
        indexMinus = format.indexOf('-');
        if (indexOpenP < indexMinus) {
            paren = ((negP && neg) ? '(' : '') + (((forcedNeg && neg) || (!negP && neg)) ? '-' : '');
        }
        else {
            paren = (((forcedNeg && neg) || (!negP && neg)) ? '-' : '') + ((negP && neg) ? '(' : '');
        }
        return prefix +
            paren + ((!neg && signed && value !== 0) ? '+' : '') +
            w + d +
            ((ord) ? ord : '') +
            ((abbr && !sep) ? abbr : '') +
            ((bytes) ? bytes : '') +
            ((negP && neg) ? ')' : '') +
            postfix;
    }
    /************************************
        Top Level Functions
    ************************************/
    numbro = function (input) {
        if (numbro.isNumbro(input)) {
            input = input.value();
        }
        else if (input === 0 || typeof input === 'undefined') {
            input = 0;
        }
        else if (!Number(input)) {
            input = numbro.fn.unformat(input);
        }
        return new Numbro(Number(input));
    };
    // version number
    numbro.version = VERSION;
    // compare numbro object
    numbro.isNumbro = function (obj) {
        return obj instanceof Numbro;
    };
    /**
     * This function allow the user to set a new language with a fallback if
     * the language does not exist. If no fallback language is provided,
     * it fallbacks to english.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `setCulture` should be used instead.
     */
    numbro.setLanguage = function (newLanguage, fallbackLanguage) {
        console.warn('`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead');
        var key = newLanguage, prefix = newLanguage.split('-')[0], matchingLanguage = null;
        if (!languages[key]) {
            Object.keys(languages).forEach(function (language) {
                if (!matchingLanguage && language.split('-')[0] === prefix) {
                    matchingLanguage = language;
                }
            });
            key = matchingLanguage || fallbackLanguage || 'en-US';
        }
        chooseCulture(key);
    };
    /**
     * This function allow the user to set a new culture with a fallback if
     * the culture does not exist. If no fallback culture is provided,
     * it fallbacks to "en-US".
     */
    numbro.setCulture = function (newCulture, fallbackCulture) {
        var key = newCulture, suffix = newCulture.split('-')[1], matchingCulture = null;
        if (!cultures[key]) {
            if (suffix) {
                Object.keys(cultures).forEach(function (language) {
                    if (!matchingCulture && language.split('-')[1] === suffix) {
                        matchingCulture = language;
                    }
                });
            }
            key = matchingCulture || fallbackCulture || 'en-US';
        }
        chooseCulture(key);
    };
    /**
     * This function will load languages and then set the global language.  If
     * no arguments are passed in, it will simply return the current global
     * language key.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `culture` should be used instead.
     */
    numbro.language = function (key, values) {
        console.warn('`language` is deprecated since version 1.6.0. Use `culture` instead');
        if (!key) {
            return currentCulture;
        }
        if (key && !values) {
            if (!languages[key]) {
                throw new Error('Unknown language : ' + key);
            }
            chooseCulture(key);
        }
        if (values || !languages[key]) {
            setCulture(key, values);
        }
        return numbro;
    };
    /**
     * This function will load cultures and then set the global culture.  If
     * no arguments are passed in, it will simply return the current global
     * culture code.
     */
    numbro.culture = function (code, values) {
        if (!code) {
            return currentCulture;
        }
        if (code && !values) {
            if (!cultures[code]) {
                throw new Error('Unknown culture : ' + code);
            }
            chooseCulture(code);
        }
        if (values || !cultures[code]) {
            setCulture(code, values);
        }
        return numbro;
    };
    /**
     * This function provides access to the loaded language data.  If
     * no arguments are passed in, it will simply return the current
     * global language object.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `culture` should be used instead.
     */
    numbro.languageData = function (key) {
        console.warn('`languageData` is deprecated since version 1.6.0. Use `cultureData` instead');
        if (!key) {
            return languages[currentCulture];
        }
        if (!languages[key]) {
            throw new Error('Unknown language : ' + key);
        }
        return languages[key];
    };
    /**
     * This function provides access to the loaded culture data.  If
     * no arguments are passed in, it will simply return the current
     * global culture object.
     */
    numbro.cultureData = function (code) {
        if (!code) {
            return cultures[currentCulture];
        }
        if (!cultures[code]) {
            throw new Error('Unknown culture : ' + code);
        }
        return cultures[code];
    };
    numbro.culture('en-US', enUS);
    /**
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `cultures` should be used instead.
     */
    numbro.languages = function () {
        console.warn('`languages` is deprecated since version 1.6.0. Use `cultures` instead');
        return languages;
    };
    numbro.cultures = function () {
        return cultures;
    };
    numbro.zeroFormat = function (format) {
        zeroFormat = typeof (format) === 'string' ? format : null;
    };
    numbro.defaultFormat = function (format) {
        defaultFormat = typeof (format) === 'string' ? format : '0.0';
    };
    numbro.defaultCurrencyFormat = function (format) {
        defaultCurrencyFormat = typeof (format) === 'string' ? format : '0$';
    };
    numbro.validate = function (val, culture) {
        var _decimalSep, _thousandSep, _currSymbol, _valArray, _abbrObj, _thousandRegEx, cultureData, temp;
        //coerce val to string
        if (typeof val !== 'string') {
            val += '';
            if (console.warn) {
                console.warn('Numbro.js: Value is not string. It has been co-erced to: ', val);
            }
        }
        //trim whitespaces from either sides
        val = val.trim();
        //if val is just digits return true
        if (!!val.match(/^\d+$/)) {
            return true;
        }
        //if val is empty return false
        if (val === '') {
            return false;
        }
        //get the decimal and thousands separator from numbro.cultureData
        try {
            //check if the culture is understood by numbro. if not, default it to current culture
            cultureData = numbro.cultureData(culture);
        }
        catch (e) {
            cultureData = numbro.cultureData(numbro.culture());
        }
        //setup the delimiters and currency symbol based on culture
        _currSymbol = cultureData.currency.symbol;
        _abbrObj = cultureData.abbreviations;
        _decimalSep = cultureData.delimiters.decimal;
        if (cultureData.delimiters.thousands === '.') {
            _thousandSep = '\\.';
        }
        else {
            _thousandSep = cultureData.delimiters.thousands;
        }
        // validating currency symbol
        temp = val.match(/^[^\d]+/);
        if (temp !== null) {
            val = val.substr(1);
            if (temp[0] !== _currSymbol) {
                return false;
            }
        }
        //validating abbreviation symbol
        temp = val.match(/[^\d]+$/);
        if (temp !== null) {
            val = val.slice(0, -1);
            if (temp[0] !== _abbrObj.thousand && temp[0] !== _abbrObj.million &&
                temp[0] !== _abbrObj.billion && temp[0] !== _abbrObj.trillion) {
                return false;
            }
        }
        _thousandRegEx = new RegExp(_thousandSep + '{2}');
        if (!val.match(/[^\d.,]/g)) {
            _valArray = val.split(_decimalSep);
            if (_valArray.length > 2) {
                return false;
            }
            else {
                if (_valArray.length < 2) {
                    return (!!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx));
                }
                else {
                    if (_valArray[0].length === 1) {
                        return (!!_valArray[0].match(/^\d+$/) &&
                            !_valArray[0].match(_thousandRegEx) &&
                            !!_valArray[1].match(/^\d+$/));
                    }
                    else {
                        return (!!_valArray[0].match(/^\d+.*\d$/) &&
                            !_valArray[0].match(_thousandRegEx) &&
                            !!_valArray[1].match(/^\d+$/));
                    }
                }
            }
        }
        return false;
    };
    /************************************
        Helpers
    ************************************/
    function setCulture(code, values) {
        cultures[code] = values;
    }
    function chooseCulture(code) {
        currentCulture = code;
        var defaults = cultures[code].defaults;
        if (defaults && defaults.format) {
            numbro.defaultFormat(defaults.format);
        }
        if (defaults && defaults.currencyFormat) {
            numbro.defaultCurrencyFormat(defaults.currencyFormat);
        }
    }
    function format(input, formatString, language, roundingFunction) {
        if (language != null && language !== numbro.culture()) {
            numbro.setCulture(language);
        }
        return formatNumbro(Number(input), formatString != null ? formatString : defaultFormat, roundingFunction == null ? Math.round : roundingFunction);
    }
    module.exports = { "format": format };
},
/* models/tickers/datetime_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var array_1 = require(110) /* ../../core/util/array */;
    var adaptive_ticker_1 = require(205) /* ./adaptive_ticker */;
    var composite_ticker_1 = require(257) /* ./composite_ticker */;
    var days_ticker_1 = require(258) /* ./days_ticker */;
    var months_ticker_1 = require(261) /* ./months_ticker */;
    var years_ticker_1 = require(262) /* ./years_ticker */;
    var util_1 = require(260) /* ./util */;
    var DatetimeTicker = /** @class */ (function (_super) {
        tslib_1.__extends(DatetimeTicker, _super);
        function DatetimeTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        DatetimeTicker.init_DatetimeTicker = function () {
            this.override({
                num_minor_ticks: 0,
                tickers: function () {
                    return [
                        // Sub-second.
                        new adaptive_ticker_1.AdaptiveTicker({
                            mantissas: [1, 2, 5],
                            base: 10,
                            min_interval: 0,
                            max_interval: 500 * util_1.ONE_MILLI,
                            num_minor_ticks: 0,
                        }),
                        // Seconds, minutes.
                        new adaptive_ticker_1.AdaptiveTicker({
                            mantissas: [1, 2, 5, 10, 15, 20, 30],
                            base: 60,
                            min_interval: util_1.ONE_SECOND,
                            max_interval: 30 * util_1.ONE_MINUTE,
                            num_minor_ticks: 0,
                        }),
                        // Hours.
                        new adaptive_ticker_1.AdaptiveTicker({
                            mantissas: [1, 2, 4, 6, 8, 12],
                            base: 24.0,
                            min_interval: util_1.ONE_HOUR,
                            max_interval: 12 * util_1.ONE_HOUR,
                            num_minor_ticks: 0,
                        }),
                        // Days.
                        new days_ticker_1.DaysTicker({ days: array_1.range(1, 32) }),
                        new days_ticker_1.DaysTicker({ days: array_1.range(1, 31, 3) }),
                        new days_ticker_1.DaysTicker({ days: [1, 8, 15, 22] }),
                        new days_ticker_1.DaysTicker({ days: [1, 15] }),
                        // Months.
                        new months_ticker_1.MonthsTicker({ months: array_1.range(0, 12, 1) }),
                        new months_ticker_1.MonthsTicker({ months: array_1.range(0, 12, 2) }),
                        new months_ticker_1.MonthsTicker({ months: array_1.range(0, 12, 4) }),
                        new months_ticker_1.MonthsTicker({ months: array_1.range(0, 12, 6) }),
                        // Years
                        new years_ticker_1.YearsTicker({}),
                    ];
                },
            });
        };
        return DatetimeTicker;
    }(composite_ticker_1.CompositeTicker));
    exports.DatetimeTicker = DatetimeTicker;
    DatetimeTicker.__name__ = "DatetimeTicker";
    DatetimeTicker.init_DatetimeTicker();
},
/* models/tickers/composite_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var continuous_ticker_1 = require(206) /* ./continuous_ticker */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    var object_1 = require(125) /* ../../core/util/object */;
    var CompositeTicker = /** @class */ (function (_super) {
        tslib_1.__extends(CompositeTicker, _super);
        function CompositeTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        CompositeTicker.init_CompositeTicker = function () {
            this.define({
                tickers: [p.Array, []],
            });
        };
        Object.defineProperty(CompositeTicker.prototype, "min_intervals", {
            // The tickers should be in order of increasing interval size; specifically,
            // if S comes before T, then it should be the case that
            // S.get_max_interval() < T.get_min_interval().
            // FIXME Enforce this automatically.
            get: function () {
                return this.tickers.map(function (ticker) { return ticker.get_min_interval(); });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CompositeTicker.prototype, "max_intervals", {
            get: function () {
                return this.tickers.map(function (ticker) { return ticker.get_max_interval(); });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CompositeTicker.prototype, "min_interval", {
            get: function () {
                return this.min_intervals[0];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CompositeTicker.prototype, "max_interval", {
            get: function () {
                return this.max_intervals[0];
            },
            enumerable: true,
            configurable: true
        });
        CompositeTicker.prototype.get_best_ticker = function (data_low, data_high, desired_n_ticks) {
            var data_range = data_high - data_low;
            var ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            var ticker_ndxs = [
                array_1.sorted_index(this.min_intervals, ideal_interval) - 1,
                array_1.sorted_index(this.max_intervals, ideal_interval),
            ];
            var intervals = [
                this.min_intervals[ticker_ndxs[0]],
                this.max_intervals[ticker_ndxs[1]],
            ];
            var errors = intervals.map(function (interval) {
                return Math.abs(desired_n_ticks - (data_range / interval));
            });
            var best_ticker;
            if (object_1.isEmpty(errors.filter(function (e) { return !isNaN(e); }))) {
                // this can happen if the data isn't loaded yet, we just default to the first scale
                best_ticker = this.tickers[0];
            }
            else {
                var best_index = array_1.argmin(errors);
                var best_ticker_ndx = ticker_ndxs[best_index];
                best_ticker = this.tickers[best_ticker_ndx];
            }
            return best_ticker;
        };
        CompositeTicker.prototype.get_interval = function (data_low, data_high, desired_n_ticks) {
            var best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
            return best_ticker.get_interval(data_low, data_high, desired_n_ticks);
        };
        CompositeTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
            var best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
            return best_ticker.get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks);
        };
        return CompositeTicker;
    }(continuous_ticker_1.ContinuousTicker));
    exports.CompositeTicker = CompositeTicker;
    CompositeTicker.__name__ = "CompositeTicker";
    CompositeTicker.init_CompositeTicker();
},
/* models/tickers/days_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var single_interval_ticker_1 = require(259) /* ./single_interval_ticker */;
    var util_1 = require(260) /* ./util */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    // Given a start and end time in millis, returns the shortest array of
    // consecutive months (as Dates) that surrounds both times.
    function date_range_by_month(start_time, end_time) {
        var start_date = util_1.last_month_no_later_than(new Date(start_time));
        var end_date = util_1.last_month_no_later_than(new Date(end_time));
        // XXX This is not a reliable technique in general, but it should be
        // safe when the day of the month is 1.  (The problem case is this:
        // Mar 31 -> Apr 31, which becomes May 1.)
        end_date.setUTCMonth(end_date.getUTCMonth() + 1);
        var dates = [];
        var date = start_date;
        while (true) {
            dates.push(util_1.copy_date(date));
            date.setUTCMonth(date.getUTCMonth() + 1);
            if (date > end_date)
                break;
        }
        return dates;
    }
    var DaysTicker = /** @class */ (function (_super) {
        tslib_1.__extends(DaysTicker, _super);
        function DaysTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        DaysTicker.init_DaysTicker = function () {
            this.define({
                days: [p.Array, []],
            });
            this.override({
                num_minor_ticks: 0,
            });
        };
        DaysTicker.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            var days = this.days;
            if (days.length > 1)
                this.interval = (days[1] - days[0]) * util_1.ONE_DAY;
            else
                this.interval = 31 * util_1.ONE_DAY;
        };
        DaysTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, _cross_loc, _desired_n_ticks) {
            var month_dates = date_range_by_month(data_low, data_high);
            var days = this.days;
            var days_of_month = function (month_date, interval) {
                var current_month = month_date.getUTCMonth();
                var dates = [];
                for (var _i = 0, days_1 = days; _i < days_1.length; _i++) {
                    var day = days_1[_i];
                    var day_date = util_1.copy_date(month_date);
                    day_date.setUTCDate(day);
                    // We can't use all of the values in this.days, because they may not
                    // fall within the current month.  In fact, if, e.g., our month is 28 days
                    // and we're marking every third day, we don't want day 28 to show up
                    // because it'll be right next to the 1st of the next month.  So we
                    // make sure we have a bit of room before we include a day.
                    // TODO (bev) The above description does not exactly work because JS Date
                    // is broken and will happily consider "Feb 28 + 3*ONE_DAY" to have month "2"
                    var future_date = new Date(day_date.getTime() + (interval / 2));
                    if (future_date.getUTCMonth() == current_month)
                        dates.push(day_date);
                }
                return dates;
            };
            var interval = this.interval;
            var day_dates = array_1.concat(month_dates.map(function (date) { return days_of_month(date, interval); }));
            var all_ticks = day_dates.map(function (day_date) { return day_date.getTime(); });
            var ticks_in_range = all_ticks.filter(function (tick) { return data_low <= tick && tick <= data_high; });
            return {
                major: ticks_in_range,
                minor: [],
            };
        };
        return DaysTicker;
    }(single_interval_ticker_1.SingleIntervalTicker));
    exports.DaysTicker = DaysTicker;
    DaysTicker.__name__ = "DaysTicker";
    DaysTicker.init_DaysTicker();
},
/* models/tickers/single_interval_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var continuous_ticker_1 = require(206) /* ./continuous_ticker */;
    var p = require(121) /* ../../core/properties */;
    var SingleIntervalTicker = /** @class */ (function (_super) {
        tslib_1.__extends(SingleIntervalTicker, _super);
        function SingleIntervalTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        SingleIntervalTicker.init_SingleIntervalTicker = function () {
            this.define({
                interval: [p.Number],
            });
        };
        SingleIntervalTicker.prototype.get_interval = function (_data_low, _data_high, _n_desired_ticks) {
            return this.interval;
        };
        Object.defineProperty(SingleIntervalTicker.prototype, "min_interval", {
            get: function () {
                return this.interval;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SingleIntervalTicker.prototype, "max_interval", {
            get: function () {
                return this.interval;
            },
            enumerable: true,
            configurable: true
        });
        return SingleIntervalTicker;
    }(continuous_ticker_1.ContinuousTicker));
    exports.SingleIntervalTicker = SingleIntervalTicker;
    SingleIntervalTicker.__name__ = "SingleIntervalTicker";
    SingleIntervalTicker.init_SingleIntervalTicker();
},
/* models/tickers/util.js */ function _(require, module, exports) {
    // Some time constants, in milliseconds.
    exports.ONE_MILLI = 1.0;
    exports.ONE_SECOND = 1000.0;
    exports.ONE_MINUTE = 60.0 * exports.ONE_SECOND;
    exports.ONE_HOUR = 60 * exports.ONE_MINUTE;
    exports.ONE_DAY = 24 * exports.ONE_HOUR;
    exports.ONE_MONTH = 30 * exports.ONE_DAY; // An approximation, obviously.
    exports.ONE_YEAR = 365 * exports.ONE_DAY;
    // ---------------------------------------------------------------------------
    // Date/time utility functions
    // ---------------------------------------------------------------------------
    // Makes a copy of a date object.
    function copy_date(date) {
        return new Date(date.getTime());
    }
    exports.copy_date = copy_date;
    // Rounds a date down to the month.
    function last_month_no_later_than(date) {
        var new_date = copy_date(date);
        new_date.setUTCDate(1);
        new_date.setUTCHours(0);
        new_date.setUTCMinutes(0);
        new_date.setUTCSeconds(0);
        new_date.setUTCMilliseconds(0);
        return new_date;
    }
    exports.last_month_no_later_than = last_month_no_later_than;
    // Rounds a date down to the year.
    function last_year_no_later_than(date) {
        var new_date = last_month_no_later_than(date);
        new_date.setUTCMonth(0);
        return new_date;
    }
    exports.last_year_no_later_than = last_year_no_later_than;
},
/* models/tickers/months_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var single_interval_ticker_1 = require(259) /* ./single_interval_ticker */;
    var util_1 = require(260) /* ./util */;
    var p = require(121) /* ../../core/properties */;
    var array_1 = require(110) /* ../../core/util/array */;
    // Given a start and end time in millis, returns the shortest array of
    // consecutive years (as Dates) that surrounds both times.
    function date_range_by_year(start_time, end_time) {
        var start_date = util_1.last_year_no_later_than(new Date(start_time));
        var end_date = util_1.last_year_no_later_than(new Date(end_time));
        end_date.setUTCFullYear(end_date.getUTCFullYear() + 1);
        var dates = [];
        var date = start_date;
        while (true) {
            dates.push(util_1.copy_date(date));
            date.setUTCFullYear(date.getUTCFullYear() + 1);
            if (date > end_date)
                break;
        }
        return dates;
    }
    var MonthsTicker = /** @class */ (function (_super) {
        tslib_1.__extends(MonthsTicker, _super);
        function MonthsTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        MonthsTicker.init_MonthsTicker = function () {
            this.define({
                months: [p.Array, []],
            });
        };
        MonthsTicker.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            var months = this.months;
            if (months.length > 1)
                this.interval = (months[1] - months[0]) * util_1.ONE_MONTH;
            else
                this.interval = 12 * util_1.ONE_MONTH;
        };
        MonthsTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, _cross_loc, _desired_n_ticks) {
            var year_dates = date_range_by_year(data_low, data_high);
            var months = this.months;
            var months_of_year = function (year_date) {
                return months.map(function (month) {
                    var month_date = util_1.copy_date(year_date);
                    month_date.setUTCMonth(month);
                    return month_date;
                });
            };
            var month_dates = array_1.concat(year_dates.map(months_of_year));
            var all_ticks = month_dates.map(function (month_date) { return month_date.getTime(); });
            var ticks_in_range = all_ticks.filter(function (tick) { return data_low <= tick && tick <= data_high; });
            return {
                major: ticks_in_range,
                minor: [],
            };
        };
        return MonthsTicker;
    }(single_interval_ticker_1.SingleIntervalTicker));
    exports.MonthsTicker = MonthsTicker;
    MonthsTicker.__name__ = "MonthsTicker";
    MonthsTicker.init_MonthsTicker();
},
/* models/tickers/years_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var basic_ticker_1 = require(204) /* ./basic_ticker */;
    var single_interval_ticker_1 = require(259) /* ./single_interval_ticker */;
    var util_1 = require(260) /* ./util */;
    var YearsTicker = /** @class */ (function (_super) {
        tslib_1.__extends(YearsTicker, _super);
        function YearsTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        YearsTicker.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.interval = util_1.ONE_YEAR;
            this.basic_ticker = new basic_ticker_1.BasicTicker({ num_minor_ticks: 0 });
        };
        YearsTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
            var start_year = util_1.last_year_no_later_than(new Date(data_low)).getUTCFullYear();
            var end_year = util_1.last_year_no_later_than(new Date(data_high)).getUTCFullYear();
            var years = this.basic_ticker.get_ticks_no_defaults(start_year, end_year, cross_loc, desired_n_ticks).major;
            var all_ticks = years.map(function (year) { return Date.UTC(year, 0, 1); });
            var ticks_in_range = all_ticks.filter(function (tick) { return data_low <= tick && tick <= data_high; });
            return {
                major: ticks_in_range,
                minor: [],
            };
        };
        return YearsTicker;
    }(single_interval_ticker_1.SingleIntervalTicker));
    exports.YearsTicker = YearsTicker;
    YearsTicker.__name__ = "YearsTicker";
},
/* models/axes/log_axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var axis_1 = require(243) /* ./axis */;
    var continuous_axis_1 = require(248) /* ./continuous_axis */;
    var log_tick_formatter_1 = require(264) /* ../formatters/log_tick_formatter */;
    var log_ticker_1 = require(265) /* ../tickers/log_ticker */;
    var LogAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(LogAxisView, _super);
        function LogAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LogAxisView;
    }(axis_1.AxisView));
    exports.LogAxisView = LogAxisView;
    LogAxisView.__name__ = "LogAxisView";
    var LogAxis = /** @class */ (function (_super) {
        tslib_1.__extends(LogAxis, _super);
        function LogAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogAxis.init_LogAxis = function () {
            this.prototype.default_view = LogAxisView;
            this.override({
                ticker: function () { return new log_ticker_1.LogTicker(); },
                formatter: function () { return new log_tick_formatter_1.LogTickFormatter(); },
            });
        };
        return LogAxis;
    }(continuous_axis_1.ContinuousAxis));
    exports.LogAxis = LogAxis;
    LogAxis.__name__ = "LogAxis";
    LogAxis.init_LogAxis();
},
/* models/formatters/log_tick_formatter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var tick_formatter_1 = require(209) /* ./tick_formatter */;
    var basic_tick_formatter_1 = require(208) /* ./basic_tick_formatter */;
    var logging_1 = require(167) /* ../../core/logging */;
    var p = require(121) /* ../../core/properties */;
    var LogTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(LogTickFormatter, _super);
        function LogTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogTickFormatter.init_LogTickFormatter = function () {
            this.define({
                ticker: [p.Instance, null],
            });
        };
        LogTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.basic_formatter = new basic_tick_formatter_1.BasicTickFormatter();
            if (this.ticker == null)
                logging_1.logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)");
        };
        LogTickFormatter.prototype.doFormat = function (ticks, opts) {
            if (ticks.length == 0)
                return [];
            var base = this.ticker != null ? this.ticker.base : 10;
            var small_interval = false;
            var labels = new Array(ticks.length);
            for (var i = 0, end = ticks.length; i < end; i++) {
                labels[i] = base + "^" + Math.round(Math.log(ticks[i]) / Math.log(base));
                if (i > 0 && labels[i] == labels[i - 1]) {
                    small_interval = true;
                    break;
                }
            }
            if (small_interval)
                return this.basic_formatter.doFormat(ticks, opts);
            else
                return labels;
        };
        return LogTickFormatter;
    }(tick_formatter_1.TickFormatter));
    exports.LogTickFormatter = LogTickFormatter;
    LogTickFormatter.__name__ = "LogTickFormatter";
    LogTickFormatter.init_LogTickFormatter();
},
/* models/tickers/log_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var adaptive_ticker_1 = require(205) /* ./adaptive_ticker */;
    var array_1 = require(110) /* ../../core/util/array */;
    var LogTicker = /** @class */ (function (_super) {
        tslib_1.__extends(LogTicker, _super);
        function LogTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        LogTicker.init_LogTicker = function () {
            this.override({
                mantissas: [1, 5],
            });
        };
        LogTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, _cross_loc, desired_n_ticks) {
            var num_minor_ticks = this.num_minor_ticks;
            var minor_ticks = [];
            var base = this.base;
            var log_low = Math.log(data_low) / Math.log(base);
            var log_high = Math.log(data_high) / Math.log(base);
            var log_interval = log_high - log_low;
            var ticks;
            if (!isFinite(log_interval)) {
                ticks = [];
            }
            else if (log_interval < 2) { // treat as linear ticker
                var interval_1 = this.get_interval(data_low, data_high, desired_n_ticks);
                var start_factor = Math.floor(data_low / interval_1);
                var end_factor = Math.ceil(data_high / interval_1);
                ticks = array_1.range(start_factor, end_factor + 1)
                    .filter(function (factor) { return factor != 0; })
                    .map(function (factor) { return factor * interval_1; })
                    .filter(function (tick) { return data_low <= tick && tick <= data_high; });
                if (num_minor_ticks > 0 && ticks.length > 0) {
                    var minor_interval_1 = interval_1 / num_minor_ticks;
                    var minor_offsets = array_1.range(0, num_minor_ticks).map(function (i) { return i * minor_interval_1; });
                    for (var _i = 0, _a = minor_offsets.slice(1); _i < _a.length; _i++) {
                        var x = _a[_i];
                        minor_ticks.push(ticks[0] - x);
                    }
                    for (var _b = 0, ticks_1 = ticks; _b < ticks_1.length; _b++) {
                        var tick = ticks_1[_b];
                        for (var _c = 0, minor_offsets_1 = minor_offsets; _c < minor_offsets_1.length; _c++) {
                            var x = minor_offsets_1[_c];
                            minor_ticks.push(tick + x);
                        }
                    }
                }
            }
            else {
                var startlog = Math.ceil(log_low * 0.999999);
                var endlog = Math.floor(log_high * 1.000001);
                var interval = Math.ceil((endlog - startlog) / 9.0);
                ticks = array_1.range(startlog - 1, endlog + 1, interval)
                    .map(function (i) { return Math.pow(base, i); });
                if (num_minor_ticks > 0 && ticks.length > 0) {
                    var minor_interval_2 = Math.pow(base, interval) / num_minor_ticks;
                    var minor_offsets = array_1.range(1, num_minor_ticks + 1).map(function (i) { return i * minor_interval_2; });
                    for (var _d = 0, minor_offsets_2 = minor_offsets; _d < minor_offsets_2.length; _d++) {
                        var x = minor_offsets_2[_d];
                        minor_ticks.push(ticks[0] / x);
                    }
                    minor_ticks.push(ticks[0]);
                    for (var _e = 0, ticks_2 = ticks; _e < ticks_2.length; _e++) {
                        var tick = ticks_2[_e];
                        for (var _f = 0, minor_offsets_3 = minor_offsets; _f < minor_offsets_3.length; _f++) {
                            var x = minor_offsets_3[_f];
                            minor_ticks.push(tick * x);
                        }
                    }
                }
            }
            return {
                major: ticks.filter(function (tick) { return data_low <= tick && tick <= data_high; }),
                minor: minor_ticks.filter(function (tick) { return data_low <= tick && tick <= data_high; }),
            };
        };
        return LogTicker;
    }(adaptive_ticker_1.AdaptiveTicker));
    exports.LogTicker = LogTicker;
    LogTicker.__name__ = "LogTicker";
    LogTicker.init_LogTicker();
},
/* models/axes/mercator_axis.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var axis_1 = require(243) /* ./axis */;
    var linear_axis_1 = require(250) /* ./linear_axis */;
    var mercator_tick_formatter_1 = require(267) /* ../formatters/mercator_tick_formatter */;
    var mercator_ticker_1 = require(268) /* ../tickers/mercator_ticker */;
    var MercatorAxisView = /** @class */ (function (_super) {
        tslib_1.__extends(MercatorAxisView, _super);
        function MercatorAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return MercatorAxisView;
    }(axis_1.AxisView));
    exports.MercatorAxisView = MercatorAxisView;
    MercatorAxisView.__name__ = "MercatorAxisView";
    var MercatorAxis = /** @class */ (function (_super) {
        tslib_1.__extends(MercatorAxis, _super);
        function MercatorAxis(attrs) {
            return _super.call(this, attrs) || this;
        }
        MercatorAxis.init_MercatorAxis = function () {
            this.prototype.default_view = MercatorAxisView;
            this.override({
                ticker: function () { return new mercator_ticker_1.MercatorTicker({ dimension: "lat" }); },
                formatter: function () { return new mercator_tick_formatter_1.MercatorTickFormatter({ dimension: "lat" }); },
            });
        };
        return MercatorAxis;
    }(linear_axis_1.LinearAxis));
    exports.MercatorAxis = MercatorAxis;
    MercatorAxis.__name__ = "MercatorAxis";
    MercatorAxis.init_MercatorAxis();
},
/* models/formatters/mercator_tick_formatter.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var basic_tick_formatter_1 = require(208) /* ./basic_tick_formatter */;
    var p = require(121) /* ../../core/properties */;
    var projections_1 = require(132) /* ../../core/util/projections */;
    var MercatorTickFormatter = /** @class */ (function (_super) {
        tslib_1.__extends(MercatorTickFormatter, _super);
        function MercatorTickFormatter(attrs) {
            return _super.call(this, attrs) || this;
        }
        MercatorTickFormatter.init_MercatorTickFormatter = function () {
            this.define({
                dimension: [p.LatLon],
            });
        };
        MercatorTickFormatter.prototype.doFormat = function (ticks, opts) {
            if (this.dimension == null)
                throw new Error("MercatorTickFormatter.dimension not configured");
            if (ticks.length == 0)
                return [];
            var n = ticks.length;
            var proj_ticks = new Array(n);
            if (this.dimension == "lon") {
                for (var i = 0; i < n; i++) {
                    var lon = projections_1.wgs84_mercator.inverse([ticks[i], opts.loc])[0];
                    proj_ticks[i] = lon;
                }
            }
            else {
                for (var i = 0; i < n; i++) {
                    var _a = projections_1.wgs84_mercator.inverse([opts.loc, ticks[i]]), lat = _a[1];
                    proj_ticks[i] = lat;
                }
            }
            return _super.prototype.doFormat.call(this, proj_ticks, opts);
        };
        return MercatorTickFormatter;
    }(basic_tick_formatter_1.BasicTickFormatter));
    exports.MercatorTickFormatter = MercatorTickFormatter;
    MercatorTickFormatter.__name__ = "MercatorTickFormatter";
    MercatorTickFormatter.init_MercatorTickFormatter();
},
/* models/tickers/mercator_ticker.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var basic_ticker_1 = require(204) /* ./basic_ticker */;
    var p = require(121) /* ../../core/properties */;
    var projections_1 = require(132) /* ../../core/util/projections */;
    var MercatorTicker = /** @class */ (function (_super) {
        tslib_1.__extends(MercatorTicker, _super);
        function MercatorTicker(attrs) {
            return _super.call(this, attrs) || this;
        }
        MercatorTicker.init_MercatorTicker = function () {
            this.define({
                dimension: [p.LatLon],
            });
        };
        MercatorTicker.prototype.get_ticks_no_defaults = function (data_low, data_high, cross_loc, desired_n_ticks) {
            var _a, _b, _c, _d, _e;
            if (this.dimension == null) {
                throw new Error("MercatorTicker.dimension not configured");
            }
            _a = projections_1.clip_mercator(data_low, data_high, this.dimension), data_low = _a[0], data_high = _a[1];
            var proj_low, proj_high, proj_cross_loc;
            if (this.dimension === "lon") {
                _b = projections_1.wgs84_mercator.inverse([data_low, cross_loc]), proj_low = _b[0], proj_cross_loc = _b[1];
                _c = projections_1.wgs84_mercator.inverse([data_high, cross_loc]), proj_high = _c[0], proj_cross_loc = _c[1];
            }
            else {
                _d = projections_1.wgs84_mercator.inverse([cross_loc, data_low]), proj_cross_loc = _d[0], proj_low = _d[1];
                _e = projections_1.wgs84_mercator.inverse([cross_loc, data_high]), proj_cross_loc = _e[0], proj_high = _e[1];
            }
            var proj_ticks = _super.prototype.get_ticks_no_defaults.call(this, proj_low, proj_high, cross_loc, desired_n_ticks);
            var major = [];
            var minor = [];
            if (this.dimension === "lon") {
                for (var _i = 0, _f = proj_ticks.major; _i < _f.length; _i++) {
                    var tick = _f[_i];
                    if (projections_1.in_bounds(tick, 'lon')) {
                        var lon = projections_1.wgs84_mercator.forward([tick, proj_cross_loc])[0];
                        major.push(lon);
                    }
                }
                for (var _g = 0, _h = proj_ticks.minor; _g < _h.length; _g++) {
                    var tick = _h[_g];
                    if (projections_1.in_bounds(tick, 'lon')) {
                        var lon = projections_1.wgs84_mercator.forward([tick, proj_cross_loc])[0];
                        minor.push(lon);
                    }
                }
            }
            else {
                for (var _j = 0, _k = proj_ticks.major; _j < _k.length; _j++) {
                    var tick = _k[_j];
                    if (projections_1.in_bounds(tick, 'lat')) {
                        var _l = projections_1.wgs84_mercator.forward([proj_cross_loc, tick]), lat = _l[1];
                        major.push(lat);
                    }
                }
                for (var _m = 0, _o = proj_ticks.minor; _m < _o.length; _m++) {
                    var tick = _o[_m];
                    if (projections_1.in_bounds(tick, 'lat')) {
                        var _p = projections_1.wgs84_mercator.forward([proj_cross_loc, tick]), lat = _p[1];
                        minor.push(lat);
                    }
                }
            }
            return { major: major, minor: minor };
        };
        return MercatorTicker;
    }(basic_ticker_1.BasicTicker));
    exports.MercatorTicker = MercatorTicker;
    MercatorTicker.__name__ = "MercatorTicker";
    MercatorTicker.init_MercatorTicker();
},
/* models/callbacks/index.js */ function _(require, module, exports) {
    var customjs_1 = require(270) /* ./customjs */;
    exports.CustomJS = customjs_1.CustomJS;
    var open_url_1 = require(272) /* ./open_url */;
    exports.OpenURL = open_url_1.OpenURL;
},
/* models/callbacks/customjs.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var callback_1 = require(271) /* ./callback */;
    var p = require(121) /* ../../core/properties */;
    var object_1 = require(125) /* ../../core/util/object */;
    var string_1 = require(127) /* ../../core/util/string */;
    var CustomJS = /** @class */ (function (_super) {
        tslib_1.__extends(CustomJS, _super);
        function CustomJS(attrs) {
            return _super.call(this, attrs) || this;
        }
        CustomJS.init_CustomJS = function () {
            this.define({
                args: [p.Any, {}],
                code: [p.String, ''],
                use_strict: [p.Boolean, false],
            });
        };
        Object.defineProperty(CustomJS.prototype, "names", {
            get: function () {
                return object_1.keys(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJS.prototype, "values", {
            get: function () {
                return object_1.values(this.args);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJS.prototype, "func", {
            get: function () {
                var code = this.use_strict ? string_1.use_strict(this.code) : this.code;
                return new (Function.bind.apply(Function, tslib_1.__spreadArrays([void 0], this.names, ["cb_obj", "cb_data", "require", "exports", code])))();
            },
            enumerable: true,
            configurable: true
        });
        CustomJS.prototype.execute = function (cb_obj, cb_data) {
            if (cb_data === void 0) {
                cb_data = {};
            }
            return this.func.apply(cb_obj, this.values.concat(cb_obj, cb_data, require, {}));
        };
        return CustomJS;
    }(callback_1.Callback));
    exports.CustomJS = CustomJS;
    CustomJS.__name__ = "CustomJS";
    CustomJS.init_CustomJS();
},
/* models/callbacks/callback.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var model_1 = require(166) /* ../../model */;
    var Callback = /** @class */ (function (_super) {
        tslib_1.__extends(Callback, _super);
        function Callback(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Callback;
    }(model_1.Model));
    exports.Callback = Callback;
    Callback.__name__ = "Callback";
},
/* models/callbacks/open_url.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var callback_1 = require(271) /* ./callback */;
    var templating_1 = require(253) /* ../../core/util/templating */;
    var p = require(121) /* ../../core/properties */;
    var OpenURL = /** @class */ (function (_super) {
        tslib_1.__extends(OpenURL, _super);
        function OpenURL(attrs) {
            return _super.call(this, attrs) || this;
        }
        OpenURL.init_OpenURL = function () {
            this.define({
                url: [p.String, 'http://'],
                same_tab: [p.Boolean, false],
            });
        };
        OpenURL.prototype.execute = function (_cb_obj, _a) {
            var _this = this;
            var source = _a.source;
            var open_url = function (i) {
                var url = templating_1.replace_placeholders(_this.url, source, i);
                if (_this.same_tab)
                    window.location.href = url;
                else
                    window.open(url);
            };
            var selected = source.selected;
            for (var _i = 0, _b = selected.indices; _i < _b.length; _i++) {
                var i = _b[_i];
                open_url(i);
            }
            for (var _c = 0, _d = selected.line_indices; _c < _d.length; _c++) {
                var i = _d[_c];
                open_url(i);
            }
            // TODO: multiline_indices: {[key: string]: number[]}
        };
        return OpenURL;
    }(callback_1.Callback));
    exports.OpenURL = OpenURL;
    OpenURL.__name__ = "OpenURL";
    OpenURL.init_OpenURL();
},
/* models/canvas/index.js */ function _(require, module, exports) {
    var canvas_1 = require(274) /* ./canvas */;
    exports.Canvas = canvas_1.Canvas;
    var cartesian_frame_1 = require(278) /* ./cartesian_frame */;
    exports.CartesianFrame = cartesian_frame_1.CartesianFrame;
},
/* models/canvas/canvas.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var has_props_1 = require(115) /* ../../core/has_props */;
    var dom_view_1 = require(161) /* ../../core/dom_view */;
    var logging_1 = require(167) /* ../../core/logging */;
    var p = require(121) /* ../../core/properties */;
    var dom_1 = require(163) /* ../../core/dom */;
    var bbox_1 = require(181) /* ../../core/util/bbox */;
    var compat_1 = require(197) /* ../../core/util/compat */;
    var canvas_1 = require(275) /* ../../core/util/canvas */;
    var canvas_2 = require(276) /* ../../styles/canvas */;
    // fixes up a problem with some versions of IE11
    // ref: http://stackoverflow.com/questions/22062313/imagedata-set-in-internetexplorer
    if (compat_1.is_ie && typeof CanvasPixelArray !== "undefined") {
        CanvasPixelArray.prototype.set = function (arr) {
            for (var i = 0; i < this.length; i++) {
                this[i] = arr[i];
            }
        };
    }
    var canvas2svg = require(277) /* canvas2svg */;
    var CanvasView = /** @class */ (function (_super) {
        tslib_1.__extends(CanvasView, _super);
        function CanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(CanvasView.prototype, "ctx", {
            get: function () {
                return this._ctx;
            },
            enumerable: true,
            configurable: true
        });
        CanvasView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.map_el = this.model.map ? this.el.appendChild(dom_1.div({ class: canvas_2.bk_canvas_map })) : null;
            var style = {
                position: "absolute",
                top: "0",
                left: "0",
                width: "100%",
                height: "100%",
            };
            switch (this.model.output_backend) {
                case "canvas":
                case "webgl": {
                    this.canvas_el = this.el.appendChild(dom_1.canvas({ class: canvas_2.bk_canvas, style: style }));
                    var ctx = this.canvas_el.getContext('2d');
                    if (ctx == null)
                        throw new Error("unable to obtain 2D rendering context");
                    this._ctx = ctx;
                    break;
                }
                case "svg": {
                    var ctx = new canvas2svg();
                    this._ctx = ctx;
                    this.canvas_el = this.el.appendChild(ctx.getSvg());
                    break;
                }
            }
            this.overlays_el = this.el.appendChild(dom_1.div({ class: canvas_2.bk_canvas_overlays, style: style }));
            this.events_el = this.el.appendChild(dom_1.div({ class: canvas_2.bk_canvas_events, style: style }));
            canvas_1.fixup_ctx(this._ctx);
            logging_1.logger.debug("CanvasView initialized");
        };
        CanvasView.prototype.get_canvas_element = function () {
            return this.canvas_el;
        };
        CanvasView.prototype.prepare_canvas = function (width, height) {
            // Ensure canvas has the correct size, taking HIDPI into account
            this.bbox = new bbox_1.BBox({ left: 0, top: 0, width: width, height: height });
            this.el.style.width = width + "px";
            this.el.style.height = height + "px";
            var pixel_ratio = canvas_1.get_scale_ratio(this.ctx, this.model.use_hidpi, this.model.output_backend);
            this.model.pixel_ratio = pixel_ratio;
            this.canvas_el.style.width = width + "px";
            this.canvas_el.style.height = height + "px";
            // XXX: io.export and canvas2svg don't like this
            // this.canvas_el.width = width*pixel_ratio
            // this.canvas_el.height = height*pixel_ratio
            this.canvas_el.setAttribute("width", "" + width * pixel_ratio);
            this.canvas_el.setAttribute("height", "" + height * pixel_ratio);
            logging_1.logger.debug("Rendering CanvasView with width: " + width + ", height: " + height + ", pixel ratio: " + pixel_ratio);
        };
        return CanvasView;
    }(dom_view_1.DOMView));
    exports.CanvasView = CanvasView;
    CanvasView.__name__ = "CanvasView";
    var Canvas = /** @class */ (function (_super) {
        tslib_1.__extends(Canvas, _super);
        function Canvas(attrs) {
            return _super.call(this, attrs) || this;
        }
        Canvas.init_Canvas = function () {
            this.prototype.default_view = CanvasView;
            this.internal({
                map: [p.Boolean, false],
                use_hidpi: [p.Boolean, true],
                pixel_ratio: [p.Number, 1],
                output_backend: [p.OutputBackend, "canvas"],
            });
        };
        return Canvas;
    }(has_props_1.HasProps));
    exports.Canvas = Canvas;
    Canvas.__name__ = "Canvas";
    Canvas.init_Canvas();
},
/* core/util/canvas.js */ function _(require, module, exports) {
    function fixup_line_dash(ctx) {
        if (!ctx.setLineDash) {
            ctx.setLineDash = function (dash) {
                ctx.mozDash = dash;
                ctx.webkitLineDash = dash;
            };
        }
        if (!ctx.getLineDash) {
            ctx.getLineDash = function () {
                return ctx.mozDash;
            };
        }
    }
    function fixup_line_dash_offset(ctx) {
        ctx.setLineDashOffset = function (offset) {
            ctx.lineDashOffset = offset;
            ctx.mozDashOffset = offset;
            ctx.webkitLineDashOffset = offset;
        };
        ctx.getLineDashOffset = function () {
            return ctx.mozDashOffset;
        };
    }
    function fixup_image_smoothing(ctx) {
        ctx.setImageSmoothingEnabled = function (value) {
            ctx.imageSmoothingEnabled = value;
            ctx.mozImageSmoothingEnabled = value;
            ctx.oImageSmoothingEnabled = value;
            ctx.webkitImageSmoothingEnabled = value;
            ctx.msImageSmoothingEnabled = value;
        };
        ctx.getImageSmoothingEnabled = function () {
            var val = ctx.imageSmoothingEnabled;
            return val != null ? val : true;
        };
    }
    function fixup_measure_text(ctx) {
        if (ctx.measureText && ctx.html5MeasureText == null) {
            ctx.html5MeasureText = ctx.measureText;
            ctx.measureText = function (text) {
                var textMetrics = ctx.html5MeasureText(text);
                // fake it til you make it
                textMetrics.ascent = ctx.html5MeasureText("m").width * 1.6;
                return textMetrics;
            };
        }
    }
    function fixup_ellipse(ctx) {
        // implementing the ctx.ellipse function with bezier curves
        // we don't implement the startAngle, endAngle and anticlockwise arguments.
        function ellipse_bezier(x, y, radiusX, radiusY, rotation, _startAngle, _endAngle, anticlockwise) {
            if (anticlockwise === void 0) {
                anticlockwise = false;
            }
            var c = 0.551784; // see http://www.tinaja.com/glib/ellipse4.pdf
            ctx.translate(x, y);
            ctx.rotate(rotation);
            var rx = radiusX;
            var ry = radiusY;
            if (anticlockwise) {
                rx = -radiusX;
                ry = -radiusY;
            }
            ctx.moveTo(-rx, 0); // start point of first curve
            ctx.bezierCurveTo(-rx, ry * c, -rx * c, ry, 0, ry);
            ctx.bezierCurveTo(rx * c, ry, rx, ry * c, rx, 0);
            ctx.bezierCurveTo(rx, -ry * c, rx * c, -ry, 0, -ry);
            ctx.bezierCurveTo(-rx * c, -ry, -rx, -ry * c, -rx, 0);
            ctx.rotate(-rotation);
            ctx.translate(-x, -y);
        }
        if (!ctx.ellipse)
            ctx.ellipse = ellipse_bezier;
    }
    function fixup_ctx(ctx) {
        fixup_line_dash(ctx);
        fixup_line_dash_offset(ctx);
        fixup_image_smoothing(ctx);
        fixup_measure_text(ctx);
        fixup_ellipse(ctx);
    }
    exports.fixup_ctx = fixup_ctx;
    function get_scale_ratio(ctx, hidpi, backend) {
        if (backend == "svg")
            return 1;
        else if (hidpi) {
            var devicePixelRatio = window.devicePixelRatio || 1;
            var backingStoreRatio = ctx.webkitBackingStorePixelRatio ||
                ctx.mozBackingStorePixelRatio ||
                ctx.msBackingStorePixelRatio ||
                ctx.oBackingStorePixelRatio ||
                ctx.backingStorePixelRatio || 1;
            return devicePixelRatio / backingStoreRatio;
        }
        else
            return 1;
    }
    exports.get_scale_ratio = get_scale_ratio;
},
/* styles/canvas.js */ function _(require, module, exports) {
    require(164) /* ./root */;
    exports.bk_canvas = "bk-canvas";
    exports.bk_canvas_map = "bk-canvas-map";
    exports.bk_canvas_overlays = "bk-canvas-overlays";
    exports.bk_canvas_events = "bk-canvas-events";
},
/* canvas2svg/canvas2svg.js */ function _(require, module, exports) {
    /*!!
     *  Canvas 2 Svg v1.0.21
     *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
     *
     *  Licensed under the MIT license:
     *  http://www.opensource.org/licenses/mit-license.php
     *
     *  Author:
     *  Kerry Liu
     *
     *  Copyright (c) 2014 Gliffy Inc.
     */
    ;
    (function () {
        "use strict";
        var STYLES, ctx, CanvasGradient, CanvasPattern, namedEntities;
        //helper function to format a string
        function format(str, args) {
            var keys = Object.keys(args), i;
            for (i = 0; i < keys.length; i++) {
                str = str.replace(new RegExp("\\{" + keys[i] + "\\}", "gi"), args[keys[i]]);
            }
            return str;
        }
        //helper function that generates a random string
        function randomString(holder) {
            var chars, randomstring, i;
            if (!holder) {
                throw new Error("cannot create a random attribute name for an undefined object");
            }
            chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
            randomstring = "";
            do {
                randomstring = "";
                for (i = 0; i < 12; i++) {
                    randomstring += chars[Math.floor(Math.random() * chars.length)];
                }
            } while (holder[randomstring]);
            return randomstring;
        }
        //helper function to map named to numbered entities
        function createNamedToNumberedLookup(items, radix) {
            var i, entity, lookup = {}, base10, base16;
            items = items.split(',');
            radix = radix || 10;
            // Map from named to numbered entities.
            for (i = 0; i < items.length; i += 2) {
                entity = '&' + items[i + 1] + ';';
                base10 = parseInt(items[i], radix);
                lookup[entity] = '&#' + base10 + ';';
            }
            //FF and IE need to create a regex from hex values ie &nbsp; == \xa0
            lookup["\\xa0"] = '&#160;';
            return lookup;
        }
        //helper function to map canvas-textAlign to svg-textAnchor
        function getTextAnchor(textAlign) {
            //TODO: support rtl languages
            var mapping = { "left": "start", "right": "end", "center": "middle", "start": "start", "end": "end" };
            return mapping[textAlign] || mapping.start;
        }
        //helper function to map canvas-textBaseline to svg-dominantBaseline
        function getDominantBaseline(textBaseline) {
            //INFO: not supported in all browsers
            var mapping = { "alphabetic": "alphabetic", "hanging": "hanging", "top": "text-before-edge", "bottom": "text-after-edge", "middle": "central" };
            return mapping[textBaseline] || mapping.alphabetic;
        }
        // Unpack entities lookup where the numbers are in radix 32 to reduce the size
        // entity mapping courtesy of tinymce
        namedEntities = createNamedToNumberedLookup('50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' +
            '5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' +
            '5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' +
            '5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' +
            '68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' +
            '6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' +
            '6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' +
            '75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' +
            '7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' +
            '7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' +
            'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' +
            'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' +
            't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' +
            'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' +
            'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' +
            '81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' +
            '8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' +
            '8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' +
            '8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' +
            '8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' +
            'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' +
            'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' +
            'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' +
            '80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' +
            '811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro', 32);
        //Some basic mappings for attributes and default values.
        STYLES = {
            "strokeStyle": {
                svgAttr: "stroke",
                canvas: "#000000",
                svg: "none",
                apply: "stroke" //apply on stroke() or fill()
            },
            "fillStyle": {
                svgAttr: "fill",
                canvas: "#000000",
                svg: null,
                apply: "fill"
            },
            "lineCap": {
                svgAttr: "stroke-linecap",
                canvas: "butt",
                svg: "butt",
                apply: "stroke"
            },
            "lineJoin": {
                svgAttr: "stroke-linejoin",
                canvas: "miter",
                svg: "miter",
                apply: "stroke"
            },
            "miterLimit": {
                svgAttr: "stroke-miterlimit",
                canvas: 10,
                svg: 4,
                apply: "stroke"
            },
            "lineWidth": {
                svgAttr: "stroke-width",
                canvas: 1,
                svg: 1,
                apply: "stroke"
            },
            "globalAlpha": {
                svgAttr: "opacity",
                canvas: 1,
                svg: 1,
                apply: "fill stroke"
            },
            "font": {
                //font converts to multiple svg attributes, there is custom logic for this
                canvas: "10px sans-serif"
            },
            "shadowColor": {
                canvas: "#000000"
            },
            "shadowOffsetX": {
                canvas: 0
            },
            "shadowOffsetY": {
                canvas: 0
            },
            "shadowBlur": {
                canvas: 0
            },
            "textAlign": {
                canvas: "start"
            },
            "textBaseline": {
                canvas: "alphabetic"
            },
            "lineDash": {
                svgAttr: "stroke-dasharray",
                canvas: [],
                svg: null,
                apply: "stroke"
            }
        };
        /**
         *
         * @param gradientNode - reference to the gradient
         * @constructor
         */
        CanvasGradient = function (gradientNode, ctx) {
            this.__root = gradientNode;
            this.__ctx = ctx;
        };
        /**
         * Adds a color stop to the gradient root
         */
        CanvasGradient.prototype.addColorStop = function (offset, color) {
            var stop = this.__ctx.__createElement("stop"), regex, matches;
            stop.setAttribute("offset", offset);
            if (color.indexOf("rgba") !== -1) {
                //separate alpha value, since webkit can't handle it
                regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                matches = regex.exec(color);
                stop.setAttribute("stop-color", format("rgb({r},{g},{b})", { r: matches[1], g: matches[2], b: matches[3] }));
                stop.setAttribute("stop-opacity", matches[4]);
            }
            else {
                stop.setAttribute("stop-color", color);
            }
            this.__root.appendChild(stop);
        };
        CanvasPattern = function (pattern, ctx) {
            this.__root = pattern;
            this.__ctx = ctx;
        };
        /**
         * The mock canvas context
         * @param o - options include:
         * ctx - existing Context2D to wrap around
         * width - width of your canvas (defaults to 500)
         * height - height of your canvas (defaults to 500)
         * enableMirroring - enables canvas mirroring (get image data) (defaults to false)
         * document - the document object (defaults to the current document)
         */
        ctx = function (o) {
            var defaultOptions = { width: 500, height: 500, enableMirroring: false }, options;
            //keep support for this way of calling C2S: new C2S(width,height)
            if (arguments.length > 1) {
                options = defaultOptions;
                options.width = arguments[0];
                options.height = arguments[1];
            }
            else if (!o) {
                options = defaultOptions;
            }
            else {
                options = o;
            }
            if (!(this instanceof ctx)) {
                //did someone call this without new?
                return new ctx(options);
            }
            //setup options
            this.width = options.width || defaultOptions.width;
            this.height = options.height || defaultOptions.height;
            this.enableMirroring = options.enableMirroring !== undefined ? options.enableMirroring : defaultOptions.enableMirroring;
            this.canvas = this; ///point back to this instance!
            this.__document = options.document || document;
            // allow passing in an existing context to wrap around
            // if a context is passed in, we know a canvas already exist
            if (options.ctx) {
                this.__ctx = options.ctx;
            }
            else {
                this.__canvas = this.__document.createElement("canvas");
                this.__ctx = this.__canvas.getContext("2d");
            }
            this.__setDefaultStyles();
            this.__stack = [this.__getStyleState()];
            this.__groupStack = [];
            //the root svg element
            this.__root = this.__document.createElementNS("http://www.w3.org/2000/svg", "svg");
            this.__root.setAttribute("version", 1.1);
            this.__root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.__root.setAttribute("width", this.width);
            this.__root.setAttribute("height", this.height);
            //make sure we don't generate the same ids in defs
            this.__ids = {};
            //defs tag
            this.__defs = this.__document.createElementNS("http://www.w3.org/2000/svg", "defs");
            this.__root.appendChild(this.__defs);
            //also add a group child. the svg element can't use the transform attribute
            this.__currentElement = this.__document.createElementNS("http://www.w3.org/2000/svg", "g");
            this.__root.appendChild(this.__currentElement);
        };
        /**
         * Creates the specified svg element
         * @private
         */
        ctx.prototype.__createElement = function (elementName, properties, resetFill) {
            if (typeof properties === "undefined") {
                properties = {};
            }
            var element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName), keys = Object.keys(properties), i, key;
            if (resetFill) {
                //if fill or stroke is not specified, the svg element should not display. By default SVG's fill is black.
                element.setAttribute("fill", "none");
                element.setAttribute("stroke", "none");
            }
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                element.setAttribute(key, properties[key]);
            }
            return element;
        };
        /**
         * Applies default canvas styles to the context
         * @private
         */
        ctx.prototype.__setDefaultStyles = function () {
            //default 2d canvas context properties see:http://www.w3.org/TR/2dcontext/
            var keys = Object.keys(STYLES), i, key;
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                this[key] = STYLES[key].canvas;
            }
        };
        /**
         * Applies styles on restore
         * @param styleState
         * @private
         */
        ctx.prototype.__applyStyleState = function (styleState) {
            var keys = Object.keys(styleState), i, key;
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                this[key] = styleState[key];
            }
        };
        /**
         * Gets the current style state
         * @return {Object}
         * @private
         */
        ctx.prototype.__getStyleState = function () {
            var i, styleState = {}, keys = Object.keys(STYLES), key;
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                styleState[key] = this[key];
            }
            return styleState;
        };
        /**
         * Apples the current styles to the current SVG element. On "ctx.fill" or "ctx.stroke"
         * @param type
         * @private
         */
        ctx.prototype.__applyStyleToCurrentElement = function (type) {
            var currentElement = this.__currentElement;
            var currentStyleGroup = this.__currentElementsToStyle;
            if (currentStyleGroup) {
                currentElement.setAttribute(type, "");
                currentElement = currentStyleGroup.element;
                currentStyleGroup.children.forEach(function (node) {
                    node.setAttribute(type, "");
                });
            }
            var keys = Object.keys(STYLES), i, style, value, id, regex, matches;
            for (i = 0; i < keys.length; i++) {
                style = STYLES[keys[i]];
                value = this[keys[i]];
                if (style.apply) {
                    //is this a gradient or pattern?
                    if (value instanceof CanvasPattern) {
                        //pattern
                        if (value.__ctx) {
                            //copy over defs
                            while (value.__ctx.__defs.childNodes.length) {
                                id = value.__ctx.__defs.childNodes[0].getAttribute("id");
                                this.__ids[id] = id;
                                this.__defs.appendChild(value.__ctx.__defs.childNodes[0]);
                            }
                        }
                        currentElement.setAttribute(style.apply, format("url(#{id})", { id: value.__root.getAttribute("id") }));
                    }
                    else if (value instanceof CanvasGradient) {
                        //gradient
                        currentElement.setAttribute(style.apply, format("url(#{id})", { id: value.__root.getAttribute("id") }));
                    }
                    else if (style.apply.indexOf(type) !== -1 && style.svg !== value) {
                        if ((style.svgAttr === "stroke" || style.svgAttr === "fill") && value.indexOf("rgba") !== -1) {
                            //separate alpha value, since illustrator can't handle it
                            regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                            matches = regex.exec(value);
                            currentElement.setAttribute(style.svgAttr, format("rgb({r},{g},{b})", { r: matches[1], g: matches[2], b: matches[3] }));
                            //should take globalAlpha here
                            var opacity = matches[4];
                            var globalAlpha = this.globalAlpha;
                            if (globalAlpha != null) {
                                opacity *= globalAlpha;
                            }
                            currentElement.setAttribute(style.svgAttr + "-opacity", opacity);
                        }
                        else {
                            var attr = style.svgAttr;
                            if (keys[i] === 'globalAlpha') {
                                attr = type + '-' + style.svgAttr;
                                if (currentElement.getAttribute(attr)) {
                                    //fill-opacity or stroke-opacity has already been set by stroke or fill.
                                    continue;
                                }
                            }
                            //otherwise only update attribute if right type, and not svg default
                            currentElement.setAttribute(attr, value);
                        }
                    }
                }
            }
        };
        /**
         * Will return the closest group or svg node. May return the current element.
         * @private
         */
        ctx.prototype.__closestGroupOrSvg = function (node) {
            node = node || this.__currentElement;
            if (node.nodeName === "g" || node.nodeName === "svg") {
                return node;
            }
            else {
                return this.__closestGroupOrSvg(node.parentNode);
            }
        };
        /**
         * Returns the serialized value of the svg so far
         * @param fixNamedEntities - Standalone SVG doesn't support named entities, which document.createTextNode encodes.
         *                           If true, we attempt to find all named entities and encode it as a numeric entity.
         * @return serialized svg
         */
        ctx.prototype.getSerializedSvg = function (fixNamedEntities) {
            var serialized = new XMLSerializer().serializeToString(this.__root), keys, i, key, value, regexp, xmlns;
            //IE search for a duplicate xmnls because they didn't implement setAttributeNS correctly
            xmlns = /xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;
            if (xmlns.test(serialized)) {
                serialized = serialized.replace('xmlns="http://www.w3.org/2000/svg', 'xmlns:xlink="http://www.w3.org/1999/xlink');
            }
            if (fixNamedEntities) {
                keys = Object.keys(namedEntities);
                //loop over each named entity and replace with the proper equivalent.
                for (i = 0; i < keys.length; i++) {
                    key = keys[i];
                    value = namedEntities[key];
                    regexp = new RegExp(key, "gi");
                    if (regexp.test(serialized)) {
                        serialized = serialized.replace(regexp, value);
                    }
                }
            }
            return serialized;
        };
        /**
         * Returns the root svg
         * @return
         */
        ctx.prototype.getSvg = function () {
            return this.__root;
        };
        /**
         * Will generate a group tag.
         */
        ctx.prototype.save = function () {
            var group = this.__createElement("g");
            var parent = this.__closestGroupOrSvg();
            this.__groupStack.push(parent);
            parent.appendChild(group);
            this.__currentElement = group;
            this.__stack.push(this.__getStyleState());
        };
        /**
         * Sets current element to parent, or just root if already root
         */
        ctx.prototype.restore = function () {
            this.__currentElement = this.__groupStack.pop();
            this.__currentElementsToStyle = null;
            //Clearing canvas will make the poped group invalid, currentElement is set to the root group node.
            if (!this.__currentElement) {
                this.__currentElement = this.__root.childNodes[1];
            }
            var state = this.__stack.pop();
            this.__applyStyleState(state);
        };
        /**
         * Helper method to add transform
         * @private
         */
        ctx.prototype.__addTransform = function (t) {
            //if the current element has siblings, add another group
            var parent = this.__closestGroupOrSvg();
            if (parent.childNodes.length > 0) {
                if (this.__currentElement.nodeName === "path") {
                    if (!this.__currentElementsToStyle)
                        this.__currentElementsToStyle = { element: parent, children: [] };
                    this.__currentElementsToStyle.children.push(this.__currentElement);
                    this.__applyCurrentDefaultPath();
                }
                var group = this.__createElement("g");
                parent.appendChild(group);
                this.__currentElement = group;
            }
            var transform = this.__currentElement.getAttribute("transform");
            if (transform) {
                transform += " ";
            }
            else {
                transform = "";
            }
            transform += t;
            this.__currentElement.setAttribute("transform", transform);
        };
        /**
         *  scales the current element
         */
        ctx.prototype.scale = function (x, y) {
            if (y === undefined) {
                y = x;
            }
            this.__addTransform(format("scale({x},{y})", { x: x, y: y }));
        };
        /**
         * rotates the current element
         */
        ctx.prototype.rotate = function (angle) {
            var degrees = (angle * 180 / Math.PI);
            this.__addTransform(format("rotate({angle},{cx},{cy})", { angle: degrees, cx: 0, cy: 0 }));
        };
        /**
         * translates the current element
         */
        ctx.prototype.translate = function (x, y) {
            this.__addTransform(format("translate({x},{y})", { x: x, y: y }));
        };
        /**
         * applies a transform to the current element
         */
        ctx.prototype.transform = function (a, b, c, d, e, f) {
            this.__addTransform(format("matrix({a},{b},{c},{d},{e},{f})", { a: a, b: b, c: c, d: d, e: e, f: f }));
        };
        /**
         * Create a new Path Element
         */
        ctx.prototype.beginPath = function () {
            var path, parent;
            // Note that there is only one current default path, it is not part of the drawing state.
            // See also: https://html.spec.whatwg.org/multipage/scripting.html#current-default-path
            this.__currentDefaultPath = "";
            this.__currentPosition = {};
            path = this.__createElement("path", {}, true);
            parent = this.__closestGroupOrSvg();
            parent.appendChild(path);
            this.__currentElement = path;
        };
        /**
         * Helper function to apply currentDefaultPath to current path element
         * @private
         */
        ctx.prototype.__applyCurrentDefaultPath = function () {
            var currentElement = this.__currentElement;
            if (currentElement.nodeName === "path") {
                currentElement.setAttribute("d", this.__currentDefaultPath);
            }
            else {
                console.error("Attempted to apply path command to node", currentElement.nodeName);
            }
        };
        /**
         * Helper function to add path command
         * @private
         */
        ctx.prototype.__addPathCommand = function (command) {
            this.__currentDefaultPath += " ";
            this.__currentDefaultPath += command;
        };
        /**
         * Adds the move command to the current path element,
         * if the currentPathElement is not empty create a new path element
         */
        ctx.prototype.moveTo = function (x, y) {
            if (this.__currentElement.nodeName !== "path") {
                this.beginPath();
            }
            // creates a new subpath with the given point
            this.__currentPosition = { x: x, y: y };
            this.__addPathCommand(format("M {x} {y}", { x: x, y: y }));
        };
        /**
         * Closes the current path
         */
        ctx.prototype.closePath = function () {
            if (this.__currentDefaultPath) {
                this.__addPathCommand("Z");
            }
        };
        /**
         * Adds a line to command
         */
        ctx.prototype.lineTo = function (x, y) {
            this.__currentPosition = { x: x, y: y };
            if (this.__currentDefaultPath.indexOf('M') > -1) {
                this.__addPathCommand(format("L {x} {y}", { x: x, y: y }));
            }
            else {
                this.__addPathCommand(format("M {x} {y}", { x: x, y: y }));
            }
        };
        /**
         * Add a bezier command
         */
        ctx.prototype.bezierCurveTo = function (cp1x, cp1y, cp2x, cp2y, x, y) {
            this.__currentPosition = { x: x, y: y };
            this.__addPathCommand(format("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}", { cp1x: cp1x, cp1y: cp1y, cp2x: cp2x, cp2y: cp2y, x: x, y: y }));
        };
        /**
         * Adds a quadratic curve to command
         */
        ctx.prototype.quadraticCurveTo = function (cpx, cpy, x, y) {
            this.__currentPosition = { x: x, y: y };
            this.__addPathCommand(format("Q {cpx} {cpy} {x} {y}", { cpx: cpx, cpy: cpy, x: x, y: y }));
        };
        /**
         * Return a new normalized vector of given vector
         */
        var normalize = function (vector) {
            var len = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
            return [vector[0] / len, vector[1] / len];
        };
        /**
         * Adds the arcTo to the current path
         *
         * @see http://www.w3.org/TR/2015/WD-2dcontext-20150514/#dom-context-2d-arcto
         */
        ctx.prototype.arcTo = function (x1, y1, x2, y2, radius) {
            // Let the point (x0, y0) be the last point in the subpath.
            var x0 = this.__currentPosition && this.__currentPosition.x;
            var y0 = this.__currentPosition && this.__currentPosition.y;
            // First ensure there is a subpath for (x1, y1).
            if (typeof x0 == "undefined" || typeof y0 == "undefined") {
                return;
            }
            // Negative values for radius must cause the implementation to throw an IndexSizeError exception.
            if (radius < 0) {
                throw new Error("IndexSizeError: The radius provided (" + radius + ") is negative.");
            }
            // If the point (x0, y0) is equal to the point (x1, y1),
            // or if the point (x1, y1) is equal to the point (x2, y2),
            // or if the radius radius is zero,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            if (((x0 === x1) && (y0 === y1))
                || ((x1 === x2) && (y1 === y2))
                || (radius === 0)) {
                this.lineTo(x1, y1);
                return;
            }
            // Otherwise, if the points (x0, y0), (x1, y1), and (x2, y2) all lie on a single straight line,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            var unit_vec_p1_p0 = normalize([x0 - x1, y0 - y1]);
            var unit_vec_p1_p2 = normalize([x2 - x1, y2 - y1]);
            if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
                this.lineTo(x1, y1);
                return;
            }
            // Otherwise, let The Arc be the shortest arc given by circumference of the circle that has radius radius,
            // and that has one point tangent to the half-infinite line that crosses the point (x0, y0) and ends at the point (x1, y1),
            // and that has a different point tangent to the half-infinite line that ends at the point (x1, y1), and crosses the point (x2, y2).
            // The points at which this circle touches these two lines are called the start and end tangent points respectively.
            // note that both vectors are unit vectors, so the length is 1
            var cos = (unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1]);
            var theta = Math.acos(Math.abs(cos));
            // Calculate origin
            var unit_vec_p1_origin = normalize([
                unit_vec_p1_p0[0] + unit_vec_p1_p2[0],
                unit_vec_p1_p0[1] + unit_vec_p1_p2[1]
            ]);
            var len_p1_origin = radius / Math.sin(theta / 2);
            var x = x1 + len_p1_origin * unit_vec_p1_origin[0];
            var y = y1 + len_p1_origin * unit_vec_p1_origin[1];
            // Calculate start angle and end angle
            // rotate 90deg clockwise (note that y axis points to its down)
            var unit_vec_origin_start_tangent = [
                -unit_vec_p1_p0[1],
                unit_vec_p1_p0[0]
            ];
            // rotate 90deg counter clockwise (note that y axis points to its down)
            var unit_vec_origin_end_tangent = [
                unit_vec_p1_p2[1],
                -unit_vec_p1_p2[0]
            ];
            var getAngle = function (vector) {
                // get angle (clockwise) between vector and (1, 0)
                var x = vector[0];
                var y = vector[1];
                if (y >= 0) { // note that y axis points to its down
                    return Math.acos(x);
                }
                else {
                    return -Math.acos(x);
                }
            };
            var startAngle = getAngle(unit_vec_origin_start_tangent);
            var endAngle = getAngle(unit_vec_origin_end_tangent);
            // Connect the point (x0, y0) to the start tangent point by a straight line
            this.lineTo(x + unit_vec_origin_start_tangent[0] * radius, y + unit_vec_origin_start_tangent[1] * radius);
            // Connect the start tangent point to the end tangent point by arc
            // and adding the end tangent point to the subpath.
            this.arc(x, y, radius, startAngle, endAngle);
        };
        /**
         * Sets the stroke property on the current element
         */
        ctx.prototype.stroke = function () {
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "fill stroke markers");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("stroke");
        };
        /**
         * Sets fill properties on the current element
         */
        ctx.prototype.fill = function () {
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "stroke fill markers");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("fill");
        };
        /**
         *  Adds a rectangle to the path.
         */
        ctx.prototype.rect = function (x, y, width, height) {
            if (this.__currentElement.nodeName !== "path") {
                this.beginPath();
            }
            this.moveTo(x, y);
            this.lineTo(x + width, y);
            this.lineTo(x + width, y + height);
            this.lineTo(x, y + height);
            this.lineTo(x, y);
            this.closePath();
        };
        /**
         * adds a rectangle element
         */
        ctx.prototype.fillRect = function (x, y, width, height) {
            var rect, parent;
            rect = this.__createElement("rect", {
                x: x,
                y: y,
                width: width,
                height: height
            }, true);
            parent = this.__closestGroupOrSvg();
            parent.appendChild(rect);
            this.__currentElement = rect;
            this.__applyStyleToCurrentElement("fill");
        };
        /**
         * Draws a rectangle with no fill
         * @param x
         * @param y
         * @param width
         * @param height
         */
        ctx.prototype.strokeRect = function (x, y, width, height) {
            var rect, parent;
            rect = this.__createElement("rect", {
                x: x,
                y: y,
                width: width,
                height: height
            }, true);
            parent = this.__closestGroupOrSvg();
            parent.appendChild(rect);
            this.__currentElement = rect;
            this.__applyStyleToCurrentElement("stroke");
        };
        /**
         * Clear entire canvas:
         * 1. save current transforms
         * 2. remove all the childNodes of the root g element
         */
        ctx.prototype.__clearCanvas = function () {
            var current = this.__closestGroupOrSvg(), transform = current.getAttribute("transform");
            var rootGroup = this.__root.childNodes[1];
            var childNodes = rootGroup.childNodes;
            for (var i = childNodes.length - 1; i >= 0; i--) {
                if (childNodes[i]) {
                    rootGroup.removeChild(childNodes[i]);
                }
            }
            this.__currentElement = rootGroup;
            //reset __groupStack as all the child group nodes are all removed.
            this.__groupStack = [];
            if (transform) {
                this.__addTransform(transform);
            }
        };
        /**
         * "Clears" a canvas by just drawing a white rectangle in the current group.
         */
        ctx.prototype.clearRect = function (x, y, width, height) {
            //clear entire canvas
            if (x === 0 && y === 0 && width === this.width && height === this.height) {
                this.__clearCanvas();
                return;
            }
            var rect, parent = this.__closestGroupOrSvg();
            rect = this.__createElement("rect", {
                x: x,
                y: y,
                width: width,
                height: height,
                fill: "#FFFFFF"
            }, true);
            parent.appendChild(rect);
        };
        /**
         * Adds a linear gradient to a defs tag.
         * Returns a canvas gradient object that has a reference to it's parent def
         */
        ctx.prototype.createLinearGradient = function (x1, y1, x2, y2) {
            var grad = this.__createElement("linearGradient", {
                id: randomString(this.__ids),
                x1: x1 + "px",
                x2: x2 + "px",
                y1: y1 + "px",
                y2: y2 + "px",
                "gradientUnits": "userSpaceOnUse"
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        };
        /**
         * Adds a radial gradient to a defs tag.
         * Returns a canvas gradient object that has a reference to it's parent def
         */
        ctx.prototype.createRadialGradient = function (x0, y0, r0, x1, y1, r1) {
            var grad = this.__createElement("radialGradient", {
                id: randomString(this.__ids),
                cx: x1 + "px",
                cy: y1 + "px",
                r: r1 + "px",
                fx: x0 + "px",
                fy: y0 + "px",
                "gradientUnits": "userSpaceOnUse"
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        };
        /**
         * Parses the font string and returns svg mapping
         * @private
         */
        ctx.prototype.__parseFont = function () {
            var regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
            var fontPart = regex.exec(this.font);
            var data = {
                style: fontPart[1] || 'normal',
                size: fontPart[4] || '10px',
                family: fontPart[6] || 'sans-serif',
                weight: fontPart[3] || 'normal',
                decoration: fontPart[2] || 'normal',
                href: null
            };
            //canvas doesn't support underline natively, but we can pass this attribute
            if (this.__fontUnderline === "underline") {
                data.decoration = "underline";
            }
            //canvas also doesn't support linking, but we can pass this as well
            if (this.__fontHref) {
                data.href = this.__fontHref;
            }
            return data;
        };
        /**
         * Helper to link text fragments
         * @param font
         * @param element
         * @return {*}
         * @private
         */
        ctx.prototype.__wrapTextLink = function (font, element) {
            if (font.href) {
                var a = this.__createElement("a");
                a.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", font.href);
                a.appendChild(element);
                return a;
            }
            return element;
        };
        /**
         * Fills or strokes text
         * @param text
         * @param x
         * @param y
         * @param action - stroke or fill
         * @private
         */
        ctx.prototype.__applyText = function (text, x, y, action) {
            var font = this.__parseFont(), parent = this.__closestGroupOrSvg(), textElement = this.__createElement("text", {
                "font-family": font.family,
                "font-size": font.size,
                "font-style": font.style,
                "font-weight": font.weight,
                "text-decoration": font.decoration,
                "x": x,
                "y": y,
                "text-anchor": getTextAnchor(this.textAlign),
                "dominant-baseline": getDominantBaseline(this.textBaseline)
            }, true);
            textElement.appendChild(this.__document.createTextNode(text));
            this.__currentElement = textElement;
            this.__applyStyleToCurrentElement(action);
            parent.appendChild(this.__wrapTextLink(font, textElement));
        };
        /**
         * Creates a text element
         * @param text
         * @param x
         * @param y
         */
        ctx.prototype.fillText = function (text, x, y) {
            this.__applyText(text, x, y, "fill");
        };
        /**
         * Strokes text
         * @param text
         * @param x
         * @param y
         */
        ctx.prototype.strokeText = function (text, x, y) {
            this.__applyText(text, x, y, "stroke");
        };
        /**
         * No need to implement this for svg.
         * @param text
         * @return {TextMetrics}
         */
        ctx.prototype.measureText = function (text) {
            this.__ctx.font = this.font;
            return this.__ctx.measureText(text);
        };
        /**
         *  Arc command!
         */
        ctx.prototype.arc = function (x, y, radius, startAngle, endAngle, counterClockwise) {
            // in canvas no circle is drawn if no angle is provided.
            if (startAngle === endAngle) {
                return;
            }
            startAngle = startAngle % (2 * Math.PI);
            endAngle = endAngle % (2 * Math.PI);
            if (startAngle === endAngle) {
                //circle time! subtract some of the angle so svg is happy (svg elliptical arc can't draw a full circle)
                endAngle = ((endAngle + (2 * Math.PI)) - 0.001 * (counterClockwise ? -1 : 1)) % (2 * Math.PI);
            }
            var endX = x + radius * Math.cos(endAngle), endY = y + radius * Math.sin(endAngle), startX = x + radius * Math.cos(startAngle), startY = y + radius * Math.sin(startAngle), sweepFlag = counterClockwise ? 0 : 1, largeArcFlag = 0, diff = endAngle - startAngle;
            // https://github.com/gliffy/canvas2svg/issues/4
            if (diff < 0) {
                diff += 2 * Math.PI;
            }
            if (counterClockwise) {
                largeArcFlag = diff > Math.PI ? 0 : 1;
            }
            else {
                largeArcFlag = diff > Math.PI ? 1 : 0;
            }
            this.lineTo(startX, startY);
            this.__addPathCommand(format("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}", { rx: radius, ry: radius, xAxisRotation: 0, largeArcFlag: largeArcFlag, sweepFlag: sweepFlag, endX: endX, endY: endY }));
            this.__currentPosition = { x: endX, y: endY };
        };
        /**
         * Generates a ClipPath from the clip command.
         */
        ctx.prototype.clip = function () {
            var group = this.__closestGroupOrSvg(), clipPath = this.__createElement("clipPath"), id = randomString(this.__ids), newGroup = this.__createElement("g");
            this.__applyCurrentDefaultPath();
            group.removeChild(this.__currentElement);
            clipPath.setAttribute("id", id);
            clipPath.appendChild(this.__currentElement);
            this.__defs.appendChild(clipPath);
            //set the clip path to this group
            group.setAttribute("clip-path", format("url(#{id})", { id: id }));
            //clip paths can be scaled and transformed, we need to add another wrapper group to avoid later transformations
            // to this path
            group.appendChild(newGroup);
            this.__currentElement = newGroup;
        };
        /**
         * Draws a canvas, image or mock context to this canvas.
         * Note that all svg dom manipulation uses node.childNodes rather than node.children for IE support.
         * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-drawimage
         */
        ctx.prototype.drawImage = function () {
            //convert arguments to a real array
            var args = Array.prototype.slice.call(arguments), image = args[0], dx, dy, dw, dh, sx = 0, sy = 0, sw, sh, parent, svg, defs, group, currentElement, svgImage, canvas, context, id;
            if (args.length === 3) {
                dx = args[1];
                dy = args[2];
                sw = image.width;
                sh = image.height;
                dw = sw;
                dh = sh;
            }
            else if (args.length === 5) {
                dx = args[1];
                dy = args[2];
                dw = args[3];
                dh = args[4];
                sw = image.width;
                sh = image.height;
            }
            else if (args.length === 9) {
                sx = args[1];
                sy = args[2];
                sw = args[3];
                sh = args[4];
                dx = args[5];
                dy = args[6];
                dw = args[7];
                dh = args[8];
            }
            else {
                throw new Error("Inavlid number of arguments passed to drawImage: " + arguments.length);
            }
            parent = this.__closestGroupOrSvg();
            currentElement = this.__currentElement;
            var translateDirective = "translate(" + dx + ", " + dy + ")";
            if (image instanceof ctx) {
                //canvas2svg mock canvas context. In the future we may want to clone nodes instead.
                //also I'm currently ignoring dw, dh, sw, sh, sx, sy for a mock context.
                svg = image.getSvg().cloneNode(true);
                if (svg.childNodes && svg.childNodes.length > 1) {
                    defs = svg.childNodes[0];
                    while (defs.childNodes.length) {
                        id = defs.childNodes[0].getAttribute("id");
                        this.__ids[id] = id;
                        this.__defs.appendChild(defs.childNodes[0]);
                    }
                    group = svg.childNodes[1];
                    if (group) {
                        //save original transform
                        var originTransform = group.getAttribute("transform");
                        var transformDirective;
                        if (originTransform) {
                            transformDirective = originTransform + " " + translateDirective;
                        }
                        else {
                            transformDirective = translateDirective;
                        }
                        group.setAttribute("transform", transformDirective);
                        parent.appendChild(group);
                    }
                }
            }
            else if (image.nodeName === "IMG") {
                svgImage = this.__createElement("image");
                svgImage.setAttribute("width", dw);
                svgImage.setAttribute("height", dh);
                svgImage.setAttribute("preserveAspectRatio", "none");
                if (sx || sy || sw !== image.width || sh !== image.height) {
                    //crop the image using a temporary canvas
                    canvas = this.__document.createElement("canvas");
                    canvas.width = dw;
                    canvas.height = dh;
                    context = canvas.getContext("2d");
                    context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                    image = canvas;
                }
                svgImage.setAttribute("transform", translateDirective);
                svgImage.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.nodeName === "CANVAS" ? image.toDataURL() : image.getAttribute("src"));
                parent.appendChild(svgImage);
            }
            else if (image.nodeName === "CANVAS") {
                svgImage = this.__createElement("image");
                svgImage.setAttribute("width", dw);
                svgImage.setAttribute("height", dh);
                svgImage.setAttribute("preserveAspectRatio", "none");
                // draw canvas onto temporary canvas so that smoothing can be handled
                canvas = this.__document.createElement("canvas");
                canvas.width = dw;
                canvas.height = dh;
                context = canvas.getContext("2d");
                context.imageSmoothingEnabled = false;
                context.mozImageSmoothingEnabled = false;
                context.oImageSmoothingEnabled = false;
                context.webkitImageSmoothingEnabled = false;
                context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                image = canvas;
                svgImage.setAttribute("transform", translateDirective);
                svgImage.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.toDataURL());
                parent.appendChild(svgImage);
            }
        };
        /**
         * Generates a pattern tag
         */
        ctx.prototype.createPattern = function (image, repetition) {
            var pattern = this.__document.createElementNS("http://www.w3.org/2000/svg", "pattern"), id = randomString(this.__ids), img;
            pattern.setAttribute("id", id);
            pattern.setAttribute("width", image.width);
            pattern.setAttribute("height", image.height);
            if (image.nodeName === "CANVAS" || image.nodeName === "IMG") {
                img = this.__document.createElementNS("http://www.w3.org/2000/svg", "image");
                img.setAttribute("width", image.width);
                img.setAttribute("height", image.height);
                img.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.nodeName === "CANVAS" ? image.toDataURL() : image.getAttribute("src"));
                pattern.appendChild(img);
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof ctx) {
                pattern.appendChild(image.__root.childNodes[1]);
                this.__defs.appendChild(pattern);
            }
            return new CanvasPattern(pattern, this);
        };
        ctx.prototype.setLineDash = function (dashArray) {
            if (dashArray && dashArray.length > 0) {
                this.lineDash = dashArray.join(",");
            }
            else {
                this.lineDash = null;
            }
        };
        /**
         * Not yet implemented
         */
        ctx.prototype.drawFocusRing = function () { };
        ctx.prototype.createImageData = function () { };
        ctx.prototype.getImageData = function () { };
        ctx.prototype.putImageData = function () { };
        ctx.prototype.globalCompositeOperation = function () { };
        ctx.prototype.setTransform = function () { };
        //add options for alternative namespace
        if (typeof window === "object") {
            window.C2S = ctx;
        }
        // CommonJS/Browserify
        if (typeof module === "object" && typeof module.exports === "object") {
            module.exports = ctx;
        }
    }());
},
/* models/canvas/cartesian_frame.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var categorical_scale_1 = require(279) /* ../scales/categorical_scale */;
    var linear_scale_1 = require(215) /* ../scales/linear_scale */;
    var log_scale_1 = require(224) /* ../scales/log_scale */;
    var range1d_1 = require(225) /* ../ranges/range1d */;
    var data_range1d_1 = require(280) /* ../ranges/data_range1d */;
    var factor_range_1 = require(184) /* ../ranges/factor_range */;
    var layout_1 = require(282) /* ../../core/layout */;
    var CartesianFrame = /** @class */ (function (_super) {
        tslib_1.__extends(CartesianFrame, _super);
        function CartesianFrame(x_scale, y_scale, x_range, y_range, extra_x_ranges, extra_y_ranges) {
            if (extra_x_ranges === void 0) {
                extra_x_ranges = {};
            }
            if (extra_y_ranges === void 0) {
                extra_y_ranges = {};
            }
            var _this = _super.call(this) || this;
            _this.x_scale = x_scale;
            _this.y_scale = y_scale;
            _this.x_range = x_range;
            _this.y_range = y_range;
            _this.extra_x_ranges = extra_x_ranges;
            _this.extra_y_ranges = extra_y_ranges;
            _this._configure_scales();
            return _this;
        }
        CartesianFrame.prototype.map_to_screen = function (x, y, x_name, y_name) {
            if (x_name === void 0) {
                x_name = "default";
            }
            if (y_name === void 0) {
                y_name = "default";
            }
            var sx = this.xscales[x_name].v_compute(x);
            var sy = this.yscales[y_name].v_compute(y);
            return [sx, sy];
        };
        CartesianFrame.prototype._get_ranges = function (range, extra_ranges) {
            var ranges = {};
            ranges.default = range;
            if (extra_ranges != null) {
                for (var name in extra_ranges)
                    ranges[name] = extra_ranges[name];
            }
            return ranges;
        };
        /*protected*/ CartesianFrame.prototype._get_scales = function (scale, ranges, frame_range) {
            var scales = {};
            for (var name in ranges) {
                var range = ranges[name];
                if (range instanceof data_range1d_1.DataRange1d || range instanceof range1d_1.Range1d) {
                    if (!(scale instanceof log_scale_1.LogScale) && !(scale instanceof linear_scale_1.LinearScale))
                        throw new Error("Range " + range.type + " is incompatible is Scale " + scale.type);
                    // XXX: special case because CategoricalScale is a subclass of LinearScale, should be removed in future
                    if (scale instanceof categorical_scale_1.CategoricalScale)
                        throw new Error("Range " + range.type + " is incompatible is Scale " + scale.type);
                }
                if (range instanceof factor_range_1.FactorRange) {
                    if (!(scale instanceof categorical_scale_1.CategoricalScale))
                        throw new Error("Range " + range.type + " is incompatible is Scale " + scale.type);
                }
                if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                    range.scale_hint = "log";
                var s = scale.clone();
                s.setv({ source_range: range, target_range: frame_range });
                scales[name] = s;
            }
            return scales;
        };
        CartesianFrame.prototype._configure_frame_ranges = function () {
            // data to/from screen space transform (left-bottom <-> left-top origin)
            this._h_target = new range1d_1.Range1d({ start: this._left.value, end: this._right.value });
            this._v_target = new range1d_1.Range1d({ start: this._bottom.value, end: this._top.value });
        };
        CartesianFrame.prototype._configure_scales = function () {
            this._configure_frame_ranges();
            this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
            this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
            this._xscales = this._get_scales(this.x_scale, this._x_ranges, this._h_target);
            this._yscales = this._get_scales(this.y_scale, this._y_ranges, this._v_target);
        };
        CartesianFrame.prototype._update_scales = function () {
            this._configure_frame_ranges();
            for (var name in this._xscales) {
                var scale = this._xscales[name];
                scale.target_range = this._h_target;
            }
            for (var name in this._yscales) {
                var scale = this._yscales[name];
                scale.target_range = this._v_target;
            }
        };
        CartesianFrame.prototype._set_geometry = function (outer, inner) {
            _super.prototype._set_geometry.call(this, outer, inner);
            this._update_scales();
        };
        Object.defineProperty(CartesianFrame.prototype, "x_ranges", {
            get: function () {
                return this._x_ranges;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "y_ranges", {
            get: function () {
                return this._y_ranges;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "xscales", {
            get: function () {
                return this._xscales;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, "yscales", {
            get: function () {
                return this._yscales;
            },
            enumerable: true,
            configurable: true
        });
        return CartesianFrame;
    }(layout_1.LayoutItem));
    exports.CartesianFrame = CartesianFrame;
    CartesianFrame.__name__ = "CartesianFrame";
},
/* models/scales/categorical_scale.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var linear_scale_1 = require(215) /* ./linear_scale */;
    var CategoricalScale = /** @class */ (function (_super) {
        tslib_1.__extends(CategoricalScale, _super);
        function CategoricalScale(attrs) {
            return _super.call(this, attrs) || this;
        }
        CategoricalScale.prototype.compute = function (x) {
            return _super.prototype.compute.call(this, this.source_range.synthetic(x));
        };
        CategoricalScale.prototype.v_compute = function (xs) {
            return _super.prototype.v_compute.call(this, this.source_range.v_synthetic(xs));
        };
        return CategoricalScale;
    }(linear_scale_1.LinearScale));
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.__name__ = "CategoricalScale";
},
/* models/ranges/data_range1d.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var data_range_1 = require(281) /* ./data_range */;
    var glyph_renderer_1 = require(175) /* ../renderers/glyph_renderer */;
    var logging_1 = require(167) /* ../../core/logging */;
    var p = require(121) /* ../../core/properties */;
    var bbox = require(181) /* ../../core/util/bbox */;
    var array_1 = require(110) /* ../../core/util/array */;
    var DataRange1d = /** @class */ (function (_super) {
        tslib_1.__extends(DataRange1d, _super);
        function DataRange1d(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this._plot_bounds = {};
            _this.have_updated_interactively = false;
            return _this;
        }
        DataRange1d.init_DataRange1d = function () {
            this.define({
                start: [p.Number],
                end: [p.Number],
                range_padding: [p.Number, 0.1],
                range_padding_units: [p.PaddingUnits, "percent"],
                flipped: [p.Boolean, false],
                follow: [p.StartEnd],
                follow_interval: [p.Number],
                default_span: [p.Number, 2],
                only_visible: [p.Boolean, false],
            });
            this.internal({
                scale_hint: [p.String, 'auto'],
            });
        };
        DataRange1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
        };
        Object.defineProperty(DataRange1d.prototype, "min", {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DataRange1d.prototype, "max", {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        DataRange1d.prototype.computed_renderers = function () {
            // TODO (bev) check that renderers actually configured with this range
            var names = this.names;
            var renderers = this.renderers;
            if (renderers.length == 0) {
                for (var _i = 0, _a = this.plots; _i < _a.length; _i++) {
                    var plot = _a[_i];
                    var rs = plot.renderers.filter(function (r) { return r instanceof glyph_renderer_1.GlyphRenderer; });
                    renderers = renderers.concat(rs);
                }
            }
            if (names.length > 0)
                renderers = renderers.filter(function (r) { return array_1.includes(names, r.name); });
            logging_1.logger.debug("computed " + renderers.length + " renderers for DataRange1d " + this.id);
            for (var _b = 0, renderers_1 = renderers; _b < renderers_1.length; _b++) {
                var r = renderers_1[_b];
                logging_1.logger.trace(" - " + r.type + " " + r.id);
            }
            return renderers;
        };
        /*protected*/ DataRange1d.prototype._compute_plot_bounds = function (renderers, bounds) {
            var result = bbox.empty();
            for (var _i = 0, renderers_2 = renderers; _i < renderers_2.length; _i++) {
                var r = renderers_2[_i];
                if (bounds[r.id] != null && (r.visible || !this.only_visible))
                    result = bbox.union(result, bounds[r.id]);
            }
            return result;
        };
        DataRange1d.prototype.adjust_bounds_for_aspect = function (bounds, ratio) {
            var result = bbox.empty();
            var width = bounds.x1 - bounds.x0;
            if (width <= 0) {
                width = 1.0;
            }
            var height = bounds.y1 - bounds.y0;
            if (height <= 0) {
                height = 1.0;
            }
            var xcenter = 0.5 * (bounds.x1 + bounds.x0);
            var ycenter = 0.5 * (bounds.y1 + bounds.y0);
            if (width < ratio * height) {
                width = ratio * height;
            }
            else {
                height = width / ratio;
            }
            result.x1 = xcenter + 0.5 * width;
            result.x0 = xcenter - 0.5 * width;
            result.y1 = ycenter + 0.5 * height;
            result.y0 = ycenter - 0.5 * height;
            return result;
        };
        /*protected*/ DataRange1d.prototype._compute_min_max = function (plot_bounds, dimension) {
            var _a, _b;
            var overall = bbox.empty();
            for (var k in plot_bounds) {
                var v = plot_bounds[k];
                overall = bbox.union(overall, v);
            }
            var min, max;
            if (dimension == 0)
                _a = [overall.x0, overall.x1], min = _a[0], max = _a[1];
            else
                _b = [overall.y0, overall.y1], min = _b[0], max = _b[1];
            return [min, max];
        };
        /*protected*/ DataRange1d.prototype._compute_range = function (min, max) {
            var _a;
            var range_padding = this.range_padding; // XXX: ? 0
            var start, end;
            if (this.scale_hint == "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0)
                        min = 0.1;
                    else
                        min = max / 100;
                    logging_1.logger.warn("could not determine minimum data value for log axis, DataRange1d using value " + min);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0)
                        max = 10;
                    else
                        max = min * 100;
                    logging_1.logger.warn("could not determine maximum data value for log axis, DataRange1d using value " + max);
                }
                var center = void 0, span = void 0;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log(min) / Math.log(10);
                }
                else {
                    var log_min = void 0, log_max = void 0;
                    if (this.range_padding_units == "percent") {
                        log_min = Math.log(min) / Math.log(10);
                        log_max = Math.log(max) / Math.log(10);
                        span = (log_max - log_min) * (1 + range_padding);
                    }
                    else {
                        log_min = Math.log(min - range_padding) / Math.log(10);
                        log_max = Math.log(max + range_padding) / Math.log(10);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2.0;
                }
                start = Math.pow(10, center - span / 2.0);
                end = Math.pow(10, center + span / 2.0);
            }
            else {
                var span = void 0;
                if (max == min)
                    span = this.default_span;
                else {
                    if (this.range_padding_units == "percent")
                        span = (max - min) * (1 + range_padding);
                    else
                        span = (max - min) + 2 * range_padding;
                }
                var center = (max + min) / 2.0;
                start = center - span / 2.0;
                end = center + span / 2.0;
            }
            var follow_sign = +1;
            if (this.flipped) {
                _a = [end, start], start = _a[0], end = _a[1];
                follow_sign = -1;
            }
            var follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == 'start')
                    end = start + follow_sign * follow_interval;
                else if (this.follow == 'end')
                    start = end - follow_sign * follow_interval;
            }
            return [start, end];
        };
        DataRange1d.prototype.update = function (bounds, dimension, bounds_id, ratio) {
            if (this.have_updated_interactively)
                return;
            var renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            var total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null)
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            this._plot_bounds[bounds_id] = total_bounds;
            // compute the min/mix for our specified dimension
            var _a = this._compute_min_max(this._plot_bounds, dimension), min = _a[0], max = _a[1];
            // derive start, end from bounds and data range config
            var _b = this._compute_range(min, max), start = _b[0], end = _b[1];
            if (this._initial_start != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_start > 0)
                        start = this._initial_start;
                }
                else
                    start = this._initial_start;
            }
            if (this._initial_end != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_end > 0)
                        end = this._initial_end;
                }
                else
                    end = this._initial_end;
            }
            // only trigger updates when there are changes
            var _c = [this.start, this.end], _start = _c[0], _end = _c[1];
            if (start != _start || end != _end) {
                var new_range = {};
                if (start != _start)
                    new_range.start = start;
                if (end != _end)
                    new_range.end = end;
                this.setv(new_range);
            }
            if (this.bounds == 'auto')
                this.setv({ bounds: [start, end] }, { silent: true });
            this.change.emit();
        };
        DataRange1d.prototype.reset = function () {
            this.have_updated_interactively = false;
            // change events silenced as PlotView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span,
            }, { silent: true });
            this.change.emit();
        };
        return DataRange1d;
    }(data_range_1.DataRange));
    exports.DataRange1d = DataRange1d;
    DataRange1d.__name__ = "DataRange1d";
    DataRange1d.init_DataRange1d();
},
/* models/ranges/data_range.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var range_1 = require(185) /* ./range */;
    var p = require(121) /* ../../core/properties */;
    var DataRange = /** @class */ (function (_super) {
        tslib_1.__extends(DataRange, _super);
        function DataRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataRange.init_DataRange = function () {
            this.define({
                names: [p.Array, []],
                renderers: [p.Array, []],
            });
        };
        return DataRange;
    }(range_1.Range));
    exports.DataRange = DataRange;
    DataRange.__name__ = "DataRange";
    DataRange.init_DataRange();
},
/* core/layout/index.js */ function _(require, module, exports) {
    var types_1 = require(283) /* ./types */;
    exports.Sizeable = types_1.Sizeable;
    var layoutable_1 = require(284) /* ./layoutable */;
    exports.Layoutable = layoutable_1.Layoutable;
    exports.LayoutItem = layoutable_1.LayoutItem;
    var alignments_1 = require(285) /* ./alignments */;
    exports.HStack = alignments_1.HStack;
    exports.VStack = alignments_1.VStack;
    exports.AnchorLayout = alignments_1.AnchorLayout;
    var grid_1 = require(286) /* ./grid */;
    exports.Grid = grid_1.Grid;
    exports.Row = grid_1.Row;
    exports.Column = grid_1.Column;
    var html_1 = require(287) /* ./html */;
    exports.ContentBox = html_1.ContentBox;
    exports.VariadicBox = html_1.VariadicBox;
},
/* core/layout/types.js */ function _(require, module, exports) {
    var min = Math.min, max = Math.max;
    var Sizeable = /** @class */ (function () {
        function Sizeable(size) {
            if (size === void 0) {
                size = {};
            }
            this.width = size.width != null ? size.width : 0;
            this.height = size.height != null ? size.height : 0;
        }
        Sizeable.prototype.bounded_to = function (_a) {
            var width = _a.width, height = _a.height;
            return new Sizeable({
                width: this.width == Infinity && width != null ? width : this.width,
                height: this.height == Infinity && height != null ? height : this.height,
            });
        };
        Sizeable.prototype.expanded_to = function (_a) {
            var width = _a.width, height = _a.height;
            return new Sizeable({
                width: width != Infinity ? max(this.width, width) : this.width,
                height: height != Infinity ? max(this.height, height) : this.height,
            });
        };
        Sizeable.prototype.expand_to = function (_a) {
            var width = _a.width, height = _a.height;
            this.width = max(this.width, width);
            this.height = max(this.height, height);
        };
        Sizeable.prototype.narrowed_to = function (_a) {
            var width = _a.width, height = _a.height;
            return new Sizeable({
                width: min(this.width, width),
                height: min(this.height, height),
            });
        };
        Sizeable.prototype.narrow_to = function (_a) {
            var width = _a.width, height = _a.height;
            this.width = min(this.width, width);
            this.height = min(this.height, height);
        };
        Sizeable.prototype.grow_by = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            var width = this.width + left + right;
            var height = this.height + top + bottom;
            return new Sizeable({ width: width, height: height });
        };
        Sizeable.prototype.shrink_by = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            var width = max(this.width - left - right, 0);
            var height = max(this.height - top - bottom, 0);
            return new Sizeable({ width: width, height: height });
        };
        Sizeable.prototype.map = function (w_fn, h_fn) {
            return new Sizeable({
                width: w_fn(this.width),
                height: (h_fn != null ? h_fn : w_fn)(this.height),
            });
        };
        return Sizeable;
    }());
    exports.Sizeable = Sizeable;
    Sizeable.__name__ = "Sizeable";
},
/* core/layout/layoutable.js */ function _(require, module, exports) {
    var tslib_1 = require(113) /* tslib */;
    var types_1 = require(283) /* ./types */;
    var bbox_1 = require(181) /* ../util/bbox */;
    var min = Math.min, max = Math.max, round = Math.round;
    var Layoutable = /** @class */ (function () {
        function Layoutable() {
            this._bbox = new bbox_1.BBox();
            this._inner_bbox = new bbox_1.BBox();
            var layout = this;
            this._top = { get value() { return layout.bbox.top; } };
            this._left = { get value() { return layout.bbox.left; } };
            this._width = { get value() { return layout.bbox.width; } };
            this._height = { get value() { return layout.bbox.height; } };
            this._right = { get value() { return layout.bbox.right; } };
            this._bottom = { get value() { return layout.bbox.bottom; } };
            this._hcenter = { get value() { return layout.bbox.hcenter; } };
            this._vcenter = { get value() { return layout.bbox.vcenter; } };
        }
        Object.defineProperty(Layoutable.prototype, "bbox", {
            get: function () {
                return this._bbox;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "inner_bbox", {
            get: function () {
                return this._inner_bbox;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "sizing", {
            get: function () {
                return this._sizing;
            },
            enumerable: true,
            configurable: true
        });
        Layoutable.prototype.set_sizing = function (sizing) {
            var width_policy = sizing.width_policy || "fit";
            var width = sizing.width;
            var min_width = sizing.min_width != null ? sizing.min_width : 0;
            var max_width = sizing.max_width != null ? sizing.max_width : Infinity;
            var height_policy = sizing.height_policy || "fit";
            var height = sizing.height;
            var min_height = sizing.min_height != null ? sizing.min_height : 0;
            var max_height = sizing.max_height != null ? sizing.max_height : Infinity;
            var aspect = sizing.aspect;
            var margin = sizing.margin || { top: 0, right: 0, bottom: 0, left: 0 };
            var visible = sizing.visible !== false;
            var halign = sizing.halign || "start";
            var valign = sizing.valign || "start";
            this._sizing = {
                width_policy: width_policy, min_width: min_width, width: width, max_width: max_width,
                height_policy: height_policy, min_height: min_height, height: height, max_height: max_height,
                aspect: aspect,
                margin: margin,
                visible: visible,
                halign: halign,
                valign: valign,
                size: { width: width, height: height },
                min_size: { width: min_width, height: min_height },
                max_size: { width: max_width, height: max_height },
            };
            this._init();
        };
        Layoutable.prototype._init = function () { };
        Layoutable.prototype._set_geometry = function (outer, inner) {
            this._bbox = outer;
            this._inner_bbox = inner;
        };
        Layoutable.prototype.set_geometry = function (outer, inner) {
            this._set_geometry(outer, inner || outer);
        };
        Layoutable.prototype.is_width_expanding = function () {
            return this.sizing.width_policy == "max";
        };
        Layoutable.prototype.is_height_expanding = function () {
            return this.sizing.height_policy == "max";
        };
        Layoutable.prototype.apply_aspect = function (viewport, _a) {
            var width = _a.width, height = _a.height;
            var aspect = this.sizing.aspect;
            if (aspect != null) {
                var _b = this.sizing, width_policy = _b.width_policy, height_policy = _b.height_policy;
                var gt = function (width, height) {
                    var policies = { max: 4, fit: 3, min: 2, fixed: 1 };
                    return policies[width] > policies[height];
                };
                if (width_policy != "fixed" && height_policy != "fixed") {
                    if (width_policy == height_policy) {
                        var w_width = width;
                        var w_height = round(width / aspect);
                        var h_width = round(height * aspect);
                        var h_height = height;
                        var w_diff = Math.abs(viewport.width - w_width) + Math.abs(viewport.height - w_height);
                        var h_diff = Math.abs(viewport.width - h_width) + Math.abs(viewport.height - h_height);
                        if (w_diff <= h_diff) {
                            width = w_width;
                            height = w_height;
                        }
                        else {
                            width = h_width;
                            height = h_height;
                        }
                    }
                    else if (gt(width_policy, height_policy)) {
                        height = round(width / aspect);
                    }
                    else {
                        width = round(height * aspect);
                    }
                }
                else if (width_policy == "fixed") {
                    height = round(width / aspect);
                }
                else if (height_policy == "fixed") {
                    width = round(height * aspect);
                }
            }
            return { width: width, height: height };
        };
        Layoutable.prototype.measure = function (viewport_size) {
            var _this = this;
            if (!this.sizing.visible)
                return { width: 0, height: 0 };
            var exact_width = function (width) {
                return _this.sizing.width_policy == "fixed" && _this.sizing.width != null ? _this.sizing.width : width;
            };
            var exact_height = function (height) {
                return _this.sizing.height_policy == "fixed" && _this.sizing.height != null ? _this.sizing.height : height;
            };
            var viewport = new types_1.Sizeable(viewport_size)
                .shrink_by(this.sizing.margin)
                .map(exact_width, exact_height);
            var computed = this._measure(viewport);
            var clipped = this.clip_size(computed);
            var width = exact_width(clipped.width);
            var height = exact_height(clipped.height);
            var size = this.apply_aspect(viewport, { width: width, height: height });
            return Object.assign(Object.assign({}, computed), size);
        };
        Layoutable.prototype.compute = function (viewport) {
            if (viewport === void 0) {
                viewport = {};
            }
            var size_hint = this.measure({
                width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
                height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity,
            });
            var width = size_hint.width, height = size_hint.height;
            var outer = new bbox_1.BBox({ left: 0, top: 0, width: width, height: height });
            var inner = undefined;
            if (size_hint.inner != null) {
                var _a = size_hint.inner, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom;
                inner = new bbox_1.BBox({ left: left, top: top, right: width - right, bottom: height - bottom });
            }
            this.set_geometry(outer, inner);
        };
        Object.defineProperty(Layoutable.prototype, "xview", {
            get: function () {
                return this.bbox.xview;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Layoutable.prototype, "yview", {
            get: function () {
                re