/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVpcPeeringConnections
extends BaseCmd {
    public DescribeVpcPeeringConnections(String[] args) {
        super("ec2dpcx", "ec2-describe-vpc-peering-connections");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "[GENERAL OPTIONS] [-F FILTER] [VPCPEERINGCONNECTION [VPCPEERINGCONNECTION [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes your VPC Peering Connections.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair result = jec2.describeVpcPeeringConnections(this.getFilterMap(true), this.getNonOptions());
        out.outputVpcPeeringConnections(System.out, (List)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new DescribeVpcPeeringConnections(args).invoke();
    }
}

