/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.java;

import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.java.Resolver;
import com.sun.star.script.framework.provider.java.ScriptDescriptor;
import com.sun.star.script.framework.provider.java.ScriptProxy;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;

class ScriptImpl
implements XScript {
    private final ScriptMetaData metaData;
    private final XComponentContext m_xContext;
    private final XModel m_xModel;
    private final XScriptInvocationContext m_xInvocContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private final Resolver m_resolutionPolicy;

    ScriptImpl(XComponentContext xComponentContext, Resolver resolver, ScriptMetaData scriptMetaData, XModel xModel, XScriptInvocationContext xScriptInvocationContext) throws RuntimeException {
        this.metaData = scriptMetaData;
        this.m_xContext = xComponentContext;
        this.m_xModel = xModel;
        this.m_xInvocContext = xScriptInvocationContext;
        this.m_resolutionPolicy = resolver;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception exception) {
            LogUtils.DEBUG(LogUtils.getTrace(exception));
            throw new RuntimeException((Throwable)exception, "Error constructing ScriptProvider: " + exception);
        }
        LogUtils.DEBUG("ScriptImpl [java] script data = " + scriptMetaData);
    }

    public Object invoke(Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws ScriptFrameworkErrorException, com.sun.star.reflection.InvocationTargetException {
        XScriptContext xScriptContext;
        ScriptExceptionRaisedException scriptExceptionRaisedException;
        Object object;
        LogUtils.DEBUG("** ScriptProviderForJava::invoke: Starting...");
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        ScriptDescriptor scriptDescriptor = new ScriptDescriptor(this.metaData.getLanguageName());
        Object[] objectArray3 = null;
        ScriptProxy scriptProxy = null;
        LogUtils.DEBUG("Classloader starting...");
        try {
            object = ClassLoaderFactory.getURLClassLoader(this.metaData);
            Throwable throwable = null;
            try {
                LogUtils.DEBUG("Classloader finished...");
                scriptExceptionRaisedException = new ArrayList<Object>();
                LogUtils.DEBUG("Parameter Mapping...");
                xScriptContext = ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory);
                scriptDescriptor.addArgumentType(XScriptContext.class);
                scriptExceptionRaisedException.add(xScriptContext);
                for (int i = 0; i < objectArray.length; ++i) {
                    scriptDescriptor.addArgumentType(objectArray[i].getClass());
                    scriptExceptionRaisedException.add(objectArray[i]);
                }
                if (!scriptExceptionRaisedException.isEmpty()) {
                    objectArray3 = scriptExceptionRaisedException.toArray();
                }
                LogUtils.DEBUG("ScriptProxy starting... ");
                try {
                    String string = this.metaData.getLanguageName().substring(0, this.metaData.getLanguageName().lastIndexOf(46));
                    LogUtils.DEBUG("About to load Class " + string + " starting... ");
                    long l = new Date().getTime();
                    Class<?> clazz = ((ClassLoader)object).loadClass(string);
                    long l2 = new Date().getTime();
                    LogUtils.DEBUG("loadClass took: " + (l2 - l) + "milliseconds");
                    try {
                        LogUtils.DEBUG("class loaded ... ");
                        scriptProxy = this.m_resolutionPolicy.getProxy(scriptDescriptor, clazz);
                        LogUtils.DEBUG("script resolved ... ");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        ScriptFrameworkErrorException scriptFrameworkErrorException = new ScriptFrameworkErrorException(noSuchMethodException.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
                        scriptFrameworkErrorException.initCause((Throwable)noSuchMethodException);
                        throw scriptFrameworkErrorException;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ScriptFrameworkErrorException scriptFrameworkErrorException = new ScriptFrameworkErrorException(classNotFoundException.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
                    scriptFrameworkErrorException.initCause((Throwable)classNotFoundException);
                    throw scriptFrameworkErrorException;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((URLClassLoader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((URLClassLoader)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            ScriptFrameworkErrorException scriptFrameworkErrorException = new ScriptFrameworkErrorException(iOException.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
            scriptFrameworkErrorException.initCause((Throwable)iOException);
            throw scriptFrameworkErrorException;
        }
        LogUtils.DEBUG("Starting Invoke on Proxy ...");
        object = null;
        try {
            long l = new Date().getTime();
            object = scriptProxy.invoke(objectArray3);
            long l3 = new Date().getTime();
            LogUtils.DEBUG("invoke took: " + (l3 - l) + "milliseconds");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            scriptExceptionRaisedException = new ScriptFrameworkErrorException(illegalArgumentException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            scriptExceptionRaisedException.initCause((Throwable)illegalArgumentException);
            throw scriptExceptionRaisedException;
        }
        catch (IllegalAccessException illegalAccessException) {
            scriptExceptionRaisedException = new ScriptFrameworkErrorException(illegalAccessException.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            scriptExceptionRaisedException.initCause((Throwable)illegalAccessException);
            throw scriptExceptionRaisedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            scriptExceptionRaisedException = invocationTargetException.getTargetException();
            xScriptContext = new ScriptExceptionRaisedException(scriptExceptionRaisedException.toString());
            xScriptContext.lineNum = -1;
            xScriptContext.scriptName = this.metaData.getLanguageName();
            xScriptContext.language = "Java";
            xScriptContext.exceptionType = scriptExceptionRaisedException.getClass().getName();
            throw new com.sun.star.reflection.InvocationTargetException("Scripting Framework error executing script ", null, (Object)xScriptContext);
        }
        catch (Exception exception) {
            scriptExceptionRaisedException = new ScriptExceptionRaisedException(exception.toString());
            scriptExceptionRaisedException.lineNum = -1;
            scriptExceptionRaisedException.scriptName = this.metaData.getLanguageName();
            scriptExceptionRaisedException.language = "Java";
            scriptExceptionRaisedException.exceptionType = exception.getClass().getName();
            throw new com.sun.star.reflection.InvocationTargetException("Scripting Framework error executing script ", null, (Object)scriptExceptionRaisedException);
        }
        if (object == null) {
            LogUtils.DEBUG("Got Nothing Back");
            Any any = new Any(new Type(), null);
            object = any;
        } else {
            LogUtils.DEBUG("Got object " + object);
        }
        return object;
    }
}

