/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.TableSheet;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

@Deprecated
public class ListTableView
extends ListView {
    private boolean tableChanging = false;
    private ExplorerManager manager;
    private PropertyChangeListener wlpc;
    private TableSheet.ControlledTableView controlledTableView;
    private Listener listener;
    private Dimension prefSize;
    private JTable table;

    public ListTableView() {
        this((NodeTableModel)null);
    }

    public ListTableView(NodeTableModel nodeTableModel) {
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.setViewportView(null);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setBorder(null);
        this.controlledTableView = nodeTableModel == null ? new TableSheet.ControlledTableView(jScrollPane) : new TableSheet.ControlledTableView(jScrollPane, nodeTableModel);
        this.setViewportView(this.controlledTableView.compoundScrollPane());
        this.listener = new Listener();
        this.delayedFireTableDataChanged();
        this.setPreferredSize(new Dimension(400, 400));
        this.table = this.controlledTableView.getTable();
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.controlledTableView.setProperties(propertyArray);
    }

    public final void setTableAutoResizeMode(int n) {
        this.controlledTableView.setAutoResizeMode(n);
    }

    public final int getTableAutoResizeMode() {
        return this.controlledTableView.getAutoResizeMode();
    }

    public final void setTableColumnPreferredWidth(int n, int n2) {
        this.controlledTableView.setColumnPreferredWidth(n, n2);
    }

    public final int getTableColumnPreferredWidth(int n) {
        return this.controlledTableView.getColumnPreferredWidth(n);
    }

    public void setListPreferredWidth(int n) {
        this.controlledTableView.setControllingViewWidth(n);
        Dimension dimension = this.getPreferredSize();
        this.table.setPreferredScrollableViewportSize(new Dimension(dimension.width - n, dimension.height));
    }

    public final int getListPreferredWidth() {
        return this.controlledTableView.getControllingViewWidth();
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.prefSize = dimension;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find(this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.controlledTableView.setHeaderText(this.manager.getExploredContext().getDisplayName());
        }
        this.list.getModel().addListDataListener(this.listener);
        this.list.addFocusListener(this.listener);
        this.delayedFireTableDataChanged();
    }

    public void removeNotify() {
        super.removeNotify();
        this.list.getModel().removeListDataListener(this.listener);
        this.list.removeFocusListener(this.listener);
        this.controlledTableView.setNodes(new Node[0]);
    }

    private void delayedFireTableDataChanged() {
        if (this.tableChanging) {
            return;
        }
        this.tableChanging = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ListTableView.this.list.getCellBounds(0, 0) != null) {
                    ListTableView.this.controlledTableView.setRowHeight(ListTableView.this.list.getCellBounds((int)0, (int)0).height);
                }
                ListTableView.this.changeTableModel();
                ListTableView.this.tableChanging = false;
            }
        });
    }

    private void changeTableModel() {
        Node[] nodeArray = new Node[this.list.getModel().getSize()];
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            nodeArray[i] = Visualizer.findNode(this.list.getModel().getElementAt(i));
        }
        this.controlledTableView.setNodes(nodeArray);
    }

    private class Listener
    implements PropertyChangeListener,
    FocusListener,
    ListDataListener {
        Listener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListTableView.this.delayedFireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListTableView.this.delayedFireTableDataChanged();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListTableView.this.delayedFireTableDataChanged();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            int n = ListTableView.this.list.getSelectedIndex();
            ListTableView.this.table.getSelectionModel().setAnchorSelectionIndex(n);
            ListTableView.this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(0);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                ListTableView.this.controlledTableView.setHeaderText(ListTableView.this.manager.getExploredContext().getDisplayName());
            }
        }
    }
}

