/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Object object, String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws ReflectError, EvalError, InvocationTargetException {
        if (object instanceof This && !This.isExposedThisMethod(string)) {
            return ((This)object).invokeMethod(string, objectArray, interpreter, callStack, simpleNode, false);
        }
        try {
            BshClassManager bshClassManager = interpreter == null ? null : interpreter.getClassManager();
            Class<?> clazz = object.getClass();
            Method method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz, object, string, objectArray, false);
            return Reflect.invokeOnMethod(method, object, objectArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(simpleNode, callStack);
        }
    }

    public static Object invokeStaticMethod(BshClassManager bshClassManager, Class clazz, String string, Object[] objectArray) throws ReflectError, UtilEvalError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        Method method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz, null, string, objectArray, true);
        return Reflect.invokeOnMethod(method, null, objectArray);
    }

    static Object invokeOnMethod(Method method, Object object, Object[] objectArray) throws ReflectError, InvocationTargetException {
        int n;
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Invoking method (entry): " + method + " with args:");
            for (int i = 0; i < objectArray.length; ++i) {
                Interpreter.debug("args[" + i + "] = " + objectArray[i] + " type = " + objectArray[i].getClass());
            }
        }
        Object[] objectArray2 = new Object[objectArray.length];
        Class<?>[] classArray = method.getParameterTypes();
        try {
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n] = Types.getAssignableForm(objectArray[n], classArray[n]);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("illegal argument type in method invocation: " + utilEvalError);
        }
        objectArray2 = Primitive.unwrap(objectArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Invoking method (after massaging values): " + method + " with tmpArgs:");
            for (n = 0; n < objectArray2.length; ++n) {
                Interpreter.debug("tmpArgs[" + n + "] = " + objectArray2[n] + " type = " + objectArray2[n].getClass());
            }
        }
        try {
            Object object2 = method.invoke(object, objectArray2);
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            Class<?> clazz = method.getReturnType();
            return Primitive.wrap(object2, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " in '" + method.getDeclaringClass() + "' :" + illegalAccessException);
        }
    }

    public static Object getIndex(Object object, int n) throws ReflectError, UtilTargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + object + ", index=" + n);
        }
        try {
            Object object2 = Array.get(object, n);
            return Primitive.wrap(object2, object.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new UtilTargetError(arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object, int n, Object object2) throws ReflectError, UtilTargetError {
        try {
            object2 = Primitive.unwrap(object2);
            Array.set(object, n, object2);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new UtilTargetError(arrayStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UtilTargetError(new ArrayStoreException(illegalArgumentException.toString()));
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        return Reflect.getFieldValue(clazz, null, string, true);
    }

    public static Object getObjectField(Object object, String string) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(string);
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, string, false);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), string)) {
                return Reflect.getObjectProperty(object, string);
            }
            throw reflectError;
        }
    }

    static LHS getLHSStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        Field field = Reflect.resolveExpectedJavaField(clazz, string, true);
        return new LHS(field);
    }

    static LHS getLHSObjectField(Object object, String string) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            boolean bl = false;
            return new LHS(((This)object).namespace, string, bl);
        }
        try {
            Field field = Reflect.resolveExpectedJavaField(object.getClass(), string, false);
            return new LHS(object, field);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertySetter(object.getClass(), string)) {
                return new LHS(object, string);
            }
            throw reflectError;
        }
    }

    private static Object getFieldValue(Class clazz, Object object, String string, boolean bl) throws UtilEvalError, ReflectError {
        try {
            Field field = Reflect.resolveExpectedJavaField(clazz, string, bl);
            Object object2 = field.get(object);
            Class<?> clazz2 = field.getType();
            return Primitive.wrap(object2, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string);
        }
    }

    protected static Field resolveJavaField(Class clazz, String string, boolean bl) throws UtilEvalError {
        try {
            return Reflect.resolveExpectedJavaField(clazz, string, bl);
        }
        catch (ReflectError reflectError) {
            return null;
        }
    }

    protected static Field resolveExpectedJavaField(Class clazz, String string, boolean bl) throws UtilEvalError, ReflectError {
        Field field;
        try {
            field = Capabilities.haveAccessibility() ? Reflect.findAccessibleField(clazz, string) : clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string);
        }
        if (bl && !Modifier.isStatic(field.getModifiers())) {
            throw new UtilEvalError("Can't reach instance field: " + string + " from static context: " + clazz.getName());
        }
        return field;
    }

    private static Field findAccessibleField(Class clazz, String string) throws UtilEvalError, NoSuchFieldException {
        try {
            Field field = clazz.getField(string);
            ReflectManager.RMSetAccessible(field);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            while (clazz != null) {
                try {
                    Field field = clazz.getDeclaredField(string);
                    ReflectManager.RMSetAccessible(field);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    clazz = clazz.getSuperclass();
                }
            }
            throw new NoSuchFieldException(string);
        }
    }

    protected static Method resolveExpectedJavaMethod(BshClassManager bshClassManager, Class clazz, Object object, String string, Object[] objectArray, boolean bl) throws ReflectError, UtilEvalError {
        Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, object, string, objectArray, bl);
        if (method != null) {
            return method;
        }
        Class[] classArray = Types.getTypes(objectArray);
        throw new ReflectError((bl ? "Static method " : "Method ") + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
    }

    protected static Method resolveJavaMethod(BshClassManager bshClassManager, Class clazz, Object object, String string, Object[] objectArray, boolean bl) throws UtilEvalError {
        if (object == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to invoke method " + string + " on null value"));
        }
        Class[] classArray = Types.getTypes(objectArray);
        return Reflect.resolveJavaMethod(bshClassManager, clazz, string, classArray, bl);
    }

    protected static Method resolveJavaMethod(BshClassManager bshClassManager, Class clazz, String string, Class[] classArray, boolean bl) throws UtilEvalError {
        if (clazz == null) {
            throw new InterpreterError("null class");
        }
        Method method = null;
        if (bshClassManager == null) {
            Interpreter.debug("resolveJavaMethod UNOPTIMIZED lookup");
        } else {
            method = bshClassManager.getResolvedMethod(clazz, string, classArray, bl);
            if (method != null) {
                return method;
            }
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Searching for method: " + StringUtil.methodString(string, classArray) + " in '" + clazz.getName() + "'");
        }
        try {
            method = Reflect.findAccessibleMethod(clazz, string, classArray);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method == null && classArray.length > 0) {
            boolean bl2;
            Object[] objectArray;
            Vector<Object> vector = new Vector<Object>();
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                objectArray = clazz2.getDeclaredMethods();
                for (bl2 = false; bl2 < objectArray.length; bl2 += 1) {
                    vector.add(objectArray[bl2]);
                }
            }
            objectArray = new Method[vector.size()];
            vector.copyInto(objectArray);
            bl2 = !Capabilities.haveAccessibility();
            method = Reflect.findMostSpecificMethod(string, classArray, (Method[])objectArray, bl2);
            if (method != null && !Modifier.isPublic(method.getModifiers())) {
                try {
                    ReflectManager.RMSetAccessible(method);
                }
                catch (UtilEvalError utilEvalError) {
                    // empty catch block
                }
            }
        }
        if (method != null && bl && !Modifier.isStatic(method.getModifiers())) {
            throw new UtilEvalError("Cannot reach instance method: " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " from static context: " + clazz.getName());
        }
        if (method != null && bshClassManager != null) {
            bshClassManager.cacheResolvedMethod(clazz, classArray, method);
        }
        return method;
    }

    static Method findAccessibleMethod(Class clazz, String string, Class[] classArray) throws UtilEvalError {
        Method method = null;
        Method method2 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(clazz);
        Method method3 = null;
        while (vector.size() > 0) {
            Class<?>[] classArray2;
            Class clazz2 = (Class)vector.firstElement();
            vector.removeElementAt(0);
            if (Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility()) {
                try {
                    method = clazz2.getDeclaredMethod(string, classArray);
                    if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility() && ReflectManager.RMSetAccessible(method)) {
                        method3 = method;
                        break;
                    }
                    method2 = method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!clazz2.isInterface() && (classArray2 = clazz2.getSuperclass()) != null) {
                vector.addElement(classArray2);
            }
            classArray2 = clazz2.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                vector.addElement(classArray2[i]);
            }
        }
        if (method3 != null) {
            return method3;
        }
        if (method2 != null) {
            throw new UtilEvalError("Found non-public method: " + method2 + ".  Use setAccessibility(true) to enable access to " + " private and protected members of classes.");
        }
        return null;
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        if (clazz.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clazz);
        }
        Object var2_2 = null;
        Class[] classArray = Types.getTypes(objectArray);
        Constructor constructor = null;
        Constructor[] constructorArray = clazz.getDeclaredConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clazz);
        }
        if ((constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray)) == null) {
            if (classArray.length == 0) {
                throw new ReflectError("Can't find default constructor for: " + clazz);
            }
            throw new ReflectError("Can't find constructor: " + StringUtil.methodString(clazz.getName(), classArray) + " in class: " + clazz.getName());
        }
        if (!Modifier.isPublic(constructor.getModifiers()) && Capabilities.haveAccessibility()) {
            try {
                ReflectManager.RMSetAccessible(constructor);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
        objectArray = Primitive.unwrap(objectArray);
        try {
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("the class is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("We don't have permission to create an instance.Use setAccessibility(true) to enable access.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("the number of arguments was wrong");
        }
        if (var2_2 == null) {
            throw new ReflectError("couldn't construct the object");
        }
        return var2_2;
    }

    static Method findMostSpecificMethod(String string, Class[] classArray, Method[] methodArray, boolean bl) {
        int n;
        Vector<Class<?>[]> vector = new Vector<Class<?>[]>();
        Vector<Method> vector2 = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (bl && !Modifier.isPublic(methodArray[i].getModifiers()) || !methodArray[i].getName().equals(string)) continue;
            vector2.addElement(methodArray[i]);
            vector.addElement(methodArray[i].getParameterTypes());
        }
        Class[][] classArray2 = new Class[vector.size()][];
        vector.copyInto((Object[])classArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + string);
        }
        if ((n = Reflect.findMostSpecificSignature(classArray, classArray2)) == -1) {
            return null;
        }
        return (Method)vector2.elementAt(n);
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        int n = Reflect.findMostSpecificConstructorIndex(classArray, constructorArray);
        if (n == -1) {
            return null;
        }
        return constructorArray[n];
    }

    static int findMostSpecificConstructorIndex(Class[] classArray, Constructor[] constructorArray) {
        Class[][] classArray2 = new Class[constructorArray.length][];
        for (int i = 0; i < classArray2.length; ++i) {
            classArray2[i] = constructorArray[i].getParameterTypes();
        }
        return Reflect.findMostSpecificSignature(classArray, classArray2);
    }

    static int findMostSpecificSignature(Class[] classArray, Class[][] classArray2) {
        Class[] classArray3 = null;
        int n = -1;
        for (int i = 0; i < classArray2.length; ++i) {
            Class[] classArray4 = classArray2[i];
            if (!Types.isSignatureAssignable(classArray, classArray4) || classArray3 != null && !Types.isSignatureAssignable(classArray4, classArray3)) continue;
            classArray3 = classArray4;
            n = i;
        }
        if (classArray3 != null) {
            return n;
        }
        return -1;
    }

    private static String accessorName(String string, String string2) {
        return string + String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("get", string);
        try {
            clazz.getMethod(string2, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = Reflect.accessorName("is", string);
            try {
                Method method = clazz.getMethod(string2, new Class[0]);
                return method.getReturnType() == Boolean.TYPE;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return false;
            }
        }
    }

    public static boolean hasObjectPropertySetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("set", string);
        Class[] classArray = new Class[]{clazz};
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static Object getObjectProperty(Object object, String string) throws UtilEvalError, ReflectError {
        String string2;
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        Method method = null;
        Exception exception = null;
        Exception exception2 = null;
        try {
            string2 = Reflect.accessorName("get", string);
            method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string2, objectArray, false);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (method == null) {
            try {
                string2 = Reflect.accessorName("is", string);
                method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string2, objectArray, false);
                if (method.getReturnType() != Boolean.TYPE) {
                    method = null;
                }
            }
            catch (Exception exception4) {
                exception2 = exception4;
            }
        }
        if (method == null) {
            throw new ReflectError("Error in property getter: " + exception + (exception2 != null ? " : " + exception2 : ""));
        }
        try {
            return Reflect.invokeOnMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static void setObjectProperty(Object object, String string, Object object2) throws ReflectError, UtilEvalError {
        String string2 = Reflect.accessorName("set", string);
        Object[] objectArray = new Object[]{object2};
        Interpreter.debug("property access: ");
        try {
            Method method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string2, objectArray, false);
            Reflect.invokeOnMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName() + " ");
            for (int i = 0; i < Reflect.getArrayDimensions(clazz); ++i) {
                stringBuffer.append("[]");
            }
        }
        catch (ReflectError reflectError) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }

    public static Object invokeCompiledCommand(Class clazz, Object[] objectArray, Interpreter interpreter, CallStack callStack) throws UtilEvalError {
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = callStack;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, "invoke", objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Error in compiled command: " + invocationTargetException.getTargetException());
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Error invoking compiled command: " + reflectError);
        }
    }
}

