/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;

public class M2mProtocolDecoder
extends BaseProtocolDecoder {
    private boolean firstPacket = true;

    public M2mProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        StringBuilder imei;
        ByteBuf buf = (ByteBuf)msg;
        for (int i = 0; i < buf.readableBytes(); ++i) {
            byte b = buf.getByte(i);
            if (b == 11) continue;
            buf.setByte(i, b - 32);
        }
        if (this.firstPacket) {
            this.firstPacket = false;
            imei = new StringBuilder();
            for (int i = 0; i < 8; ++i) {
                byte b = buf.readByte();
                if (i != 0) {
                    imei.append(b / 10);
                }
                imei.append(b % 10);
            }
        } else {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setDay(buf.readUnsignedByte() & 0x3F).setMonth(buf.readUnsignedByte() & 0x3F).setYear(buf.readUnsignedByte()).setHour(buf.readUnsignedByte() & 0x3F).setMinute(buf.readUnsignedByte() & 0x7F).setSecond(buf.readUnsignedByte() & 0x7F);
            position.setTime(dateBuilder.getDate());
            int degrees = buf.readUnsignedByte();
            double latitude = buf.readUnsignedByte();
            latitude += (double)buf.readUnsignedByte() / 100.0;
            latitude += (double)buf.readUnsignedByte() / 10000.0;
            latitude /= 60.0;
            latitude += (double)degrees;
            short b = buf.readUnsignedByte();
            degrees = (b & 0x7F) * 100 + buf.readUnsignedByte();
            double longitude = buf.readUnsignedByte();
            longitude += (double)buf.readUnsignedByte() / 100.0;
            longitude += (double)buf.readUnsignedByte() / 10000.0;
            longitude /= 60.0;
            longitude += (double)degrees;
            if ((b & 0x80) != 0) {
                longitude = -longitude;
            }
            if ((b & 0x40) != 0) {
                latitude = -latitude;
            }
            position.setValid(true);
            position.setLatitude(latitude);
            position.setLongitude(longitude);
            position.setSpeed(buf.readUnsignedByte());
            short satellites = buf.readUnsignedByte();
            if (satellites == 0) {
                return null;
            }
            position.set("sat", Integer.valueOf(satellites));
            return position;
        }
        this.getDeviceSession(channel, remoteAddress, imei.toString());
        return null;
    }
}

