/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class GlobalSatProtocolDecoder
extends BaseProtocolDecoder {
    private String format0 = Context.getConfig().getString(this.getProtocolName() + ".format0", "TSPRXAB27GHKLMnaicz*U!");
    private String format1 = Context.getConfig().getString(this.getProtocolName() + ".format1", "SARY*U!");
    private static final Pattern PATTERN = new PatternBuilder().text("$").number("(d+),").number("d+,").number("(d+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([EW])").number("(ddd)(dd.d+),").expression("([NS])").number("(dd)(dd.d+),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*)?,").number("(d+)[,*]").number("(d+.?d*)").compile();

    public GlobalSatProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public void setFormat0(String format) {
        this.format0 = format;
    }

    public void setFormat1(String format) {
        this.format1 = format;
    }

    private Position decodeOriginal(Channel channel, SocketAddress remoteAddress, String sentence) {
        String format;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("ACK\r", remoteAddress));
        }
        if (sentence.startsWith("GSr")) {
            format = this.format0;
        } else if (sentence.startsWith("GSh")) {
            format = this.format1;
        } else {
            return null;
        }
        if (!(format.contains("B") && format.contains("S") && (format.contains("1") || format.contains("2") || format.contains("3")) && (format.contains("6") || format.contains("7") || format.contains("8")))) {
            return null;
        }
        if (format.contains("*")) {
            format = format.substring(0, format.indexOf(42));
            sentence = sentence.substring(0, sentence.indexOf(42));
        }
        String[] values = sentence.split(",");
        Position position = new Position(this.getProtocolName());
        int formatIndex = 0;
        block18: for (int valueIndex = 1; formatIndex < format.length() && valueIndex < values.length; ++valueIndex, ++formatIndex) {
            String value = values[valueIndex];
            switch (format.charAt(formatIndex)) {
                case 'S': {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                    if (deviceSession == null) {
                        return null;
                    }
                    position.setDeviceId(deviceSession.getDeviceId());
                    continue block18;
                }
                case 'A': {
                    if (value.isEmpty()) {
                        position.setValid(false);
                        continue block18;
                    }
                    position.setValid(Integer.parseInt(value) != 1);
                    continue block18;
                }
                case 'B': {
                    DateBuilder dateBuilder = new DateBuilder().setDay(Integer.parseInt(value.substring(0, 2))).setMonth(Integer.parseInt(value.substring(2, 4))).setYear(Integer.parseInt(value.substring(4)));
                    value = values[++valueIndex];
                    dateBuilder.setHour(Integer.parseInt(value.substring(0, 2))).setMinute(Integer.parseInt(value.substring(2, 4))).setSecond(Integer.parseInt(value.substring(4)));
                    position.setTime(dateBuilder.getDate());
                    continue block18;
                }
                case 'C': {
                    ++valueIndex;
                    continue block18;
                }
                case '1': {
                    double longitude = Double.parseDouble(value.substring(1));
                    if (value.charAt(0) == 'W') {
                        longitude = -longitude;
                    }
                    position.setLongitude(longitude);
                    continue block18;
                }
                case '2': {
                    double longitude = Double.parseDouble(value.substring(4)) / 60.0;
                    longitude += (double)Integer.parseInt(value.substring(1, 4));
                    if (value.charAt(0) == 'W') {
                        longitude = -longitude;
                    }
                    position.setLongitude(longitude);
                    continue block18;
                }
                case '3': {
                    position.setLongitude(Double.parseDouble(value) * 1.0E-6);
                    continue block18;
                }
                case '6': {
                    double latitude = Double.parseDouble(value.substring(1));
                    if (value.charAt(0) == 'S') {
                        latitude = -latitude;
                    }
                    position.setLatitude(latitude);
                    continue block18;
                }
                case '7': {
                    double latitude = Double.parseDouble(value.substring(3)) / 60.0;
                    latitude += (double)Integer.parseInt(value.substring(1, 3));
                    if (value.charAt(0) == 'S') {
                        latitude = -latitude;
                    }
                    position.setLatitude(latitude);
                    continue block18;
                }
                case '8': {
                    position.setLatitude(Double.parseDouble(value) * 1.0E-6);
                    continue block18;
                }
                case 'G': {
                    position.setAltitude(Double.parseDouble(value));
                    continue block18;
                }
                case 'H': {
                    position.setSpeed(Double.parseDouble(value));
                    continue block18;
                }
                case 'I': {
                    position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(value)));
                    continue block18;
                }
                case 'J': {
                    position.setSpeed(UnitsConverter.knotsFromMph(Double.parseDouble(value)));
                    continue block18;
                }
                case 'K': {
                    position.setCourse(Double.parseDouble(value));
                    continue block18;
                }
                case 'N': {
                    if (value.endsWith("mV")) {
                        position.set("battery", (double)Integer.parseInt(value.substring(0, value.length() - 2)) / 1000.0);
                        continue block18;
                    }
                    position.set("batteryLevel", Integer.parseInt(value));
                    continue block18;
                }
            }
        }
        return position;
    }

    private Position decodeAlternative(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(!parser.next().equals("1"));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.set("hdop", parser.nextDouble());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("GS")) {
            return this.decodeOriginal(channel, remoteAddress, sentence);
        }
        if (sentence.startsWith("$")) {
            return this.decodeAlternative(channel, remoteAddress, sentence);
        }
        return null;
    }
}

